import { ProjectGraph } from '../../../config/project-graph';
import { PluginConfiguration } from '../../../config/nx-json';
import { CreateDependenciesContext, CreateMetadataContext, CreateNodesContextV2 } from '../public-api';
import { LoadedNxPlugin } from '../internal-api';
import { Serializable } from 'child_process';
import { Socket } from 'net';
export interface PluginWorkerLoadMessage {
    type: 'load';
    payload: {
        plugin: PluginConfiguration;
        root: string;
    };
}
export interface PluginWorkerLoadResult {
    type: 'load-result';
    payload: {
        name: string;
        include?: string[];
        exclude?: string[];
        createNodesPattern: string;
        hasCreateDependencies: boolean;
        hasProcessProjectGraph: boolean;
        hasCreateMetadata: boolean;
        success: true;
    } | {
        success: false;
        error: Error;
    };
}
export interface PluginWorkerCreateNodesMessage {
    type: 'createNodes';
    payload: {
        configFiles: string[];
        context: CreateNodesContextV2;
        tx: string;
    };
}
export interface PluginWorkerCreateNodesResult {
    type: 'createNodesResult';
    payload: {
        success: true;
        result: Awaited<ReturnType<LoadedNxPlugin['createNodes'][1]>>;
        tx: string;
    } | {
        success: false;
        error: Error;
        tx: string;
    };
}
export interface PluginCreateDependenciesMessage {
    type: 'createDependencies';
    payload: {
        context: CreateDependenciesContext;
        tx: string;
    };
}
export interface PluginCreateMetadataMessage {
    type: 'createMetadata';
    payload: {
        graph: ProjectGraph;
        context: CreateMetadataContext;
        tx: string;
    };
}
export interface PluginCreateDependenciesResult {
    type: 'createDependenciesResult';
    payload: {
        dependencies: ReturnType<LoadedNxPlugin['createDependencies']>;
        success: true;
        tx: string;
    } | {
        success: false;
        error: Error;
        tx: string;
    };
}
export interface PluginCreateMetadataResult {
    type: 'createMetadataResult';
    payload: {
        metadata: ReturnType<LoadedNxPlugin['createMetadata']>;
        success: true;
        tx: string;
    } | {
        success: false;
        error: Error;
        tx: string;
    };
}
export interface PluginWorkerShutdownMessage {
    type: 'shutdown';
    payload: {};
}
export type PluginWorkerMessage = PluginWorkerLoadMessage | PluginWorkerShutdownMessage | PluginWorkerCreateNodesMessage | PluginCreateDependenciesMessage | PluginCreateMetadataMessage;
export type PluginWorkerResult = PluginWorkerLoadResult | PluginWorkerCreateNodesResult | PluginCreateDependenciesResult | PluginCreateMetadataResult;
export declare function isPluginWorkerMessage(message: Serializable): message is PluginWorkerMessage;
export declare function isPluginWorkerResult(message: Serializable): message is PluginWorkerResult;
type MaybePromise<T> = T | Promise<T>;
type MessageHandlerReturn<T extends PluginWorkerMessage | PluginWorkerResult> = T extends PluginWorkerResult ? MaybePromise<PluginWorkerMessage | void> : MaybePromise<PluginWorkerResult | void>;
export declare function consumeMessage<T extends PluginWorkerMessage | PluginWorkerResult>(socket: Socket, raw: T, handlers: {
    [K in T['type']]: (payload: Extract<T, {
        type: K;
    }>['payload']) => MessageHandlerReturn<T>;
}): Promise<void>;
export declare function sendMessageOverSocket(socket: Socket, message: PluginWorkerMessage | PluginWorkerResult): void;
export {};
