"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.commandsObject = exports.parserConfiguration = void 0;
const chalk = require("chalk");
const yargs = require("yargs");
const command_object_1 = require("./activate-powerpack/command-object");
const command_object_2 = require("./affected/command-object");
const command_object_3 = require("./connect/command-object");
const command_object_4 = require("./daemon/command-object");
const command_object_5 = require("./graph/command-object");
const command_object_6 = require("./exec/command-object");
const command_object_7 = require("./format/command-object");
const command_object_8 = require("./generate/command-object");
const command_object_9 = require("./import/command-object");
const command_object_10 = require("./init/command-object");
const command_object_11 = require("./list/command-object");
const command_object_12 = require("./migrate/command-object");
const command_object_13 = require("./new/command-object");
const command_object_14 = require("./repair/command-object");
const command_object_15 = require("./report/command-object");
const command_object_16 = require("./run/command-object");
const command_object_17 = require("./run-many/command-object");
const command_object_18 = require("./show/command-object");
const command_object_19 = require("./watch/command-object");
const command_object_20 = require("./reset/command-object");
const command_object_21 = require("./release/command-object");
const command_object_22 = require("./add/command-object");
const command_object_23 = require("./login/command-object");
const command_object_24 = require("./logout/command-object");
const command_objects_1 = require("./deprecated/command-objects");
const command_object_25 = require("./sync/command-object");
const output_1 = require("../utils/output");
// Ensure that the output takes up the available width of the terminal.
yargs.wrap(yargs.terminalWidth());
exports.parserConfiguration = {
    'strip-dashed': true,
};
/**
 * Exposing the Yargs commands object so the documentation generator can
 * parse it. The CLI will consume it and call the `.argv` to bootstrapped
 * the CLI. These command declarations needs to be in a different file
 * from the `.argv` call, so the object and it's relative scripts can
 * le executed correctly.
 */
exports.commandsObject = yargs
    .parserConfiguration(exports.parserConfiguration)
    .usage(chalk.bold('Smart Monorepos · Fast CI'))
    .demandCommand(1, '')
    .command(command_object_1.yargsActivatePowerpackCommand)
    .command(command_object_22.yargsAddCommand)
    .command(command_object_2.yargsAffectedBuildCommand)
    .command(command_object_2.yargsAffectedCommand)
    .command(command_object_2.yargsAffectedE2ECommand)
    .command(command_object_2.yargsAffectedLintCommand)
    .command(command_object_2.yargsAffectedTestCommand)
    .command(command_objects_1.yargsAffectedGraphCommand)
    .command(command_object_3.yargsConnectCommand)
    .command(command_object_4.yargsDaemonCommand)
    .command(command_object_5.yargsGraphCommand)
    .command(command_object_6.yargsExecCommand)
    .command(command_object_7.yargsFormatCheckCommand)
    .command(command_object_7.yargsFormatWriteCommand)
    .command(command_object_8.yargsGenerateCommand)
    .command(command_object_9.yargsImportCommand)
    .command(command_object_10.yargsInitCommand)
    .command(command_object_12.yargsInternalMigrateCommand)
    .command(command_object_11.yargsListCommand)
    .command(command_object_12.yargsMigrateCommand)
    .command(command_object_13.yargsNewCommand)
    .command(command_objects_1.yargsPrintAffectedCommand)
    .command(command_object_21.yargsReleaseCommand)
    .command(command_object_14.yargsRepairCommand)
    .command(command_object_15.yargsReportCommand)
    .command(command_object_20.yargsResetCommand)
    .command(command_object_16.yargsRunCommand)
    .command(command_object_17.yargsRunManyCommand)
    .command(command_object_18.yargsShowCommand)
    .command(command_object_25.yargsSyncCommand)
    .command(command_object_25.yargsSyncCheckCommand)
    .command(command_object_3.yargsViewLogsCommand)
    .command(command_object_19.yargsWatchCommand)
    .command(command_object_16.yargsNxInfixCommand)
    .command(command_object_23.yargsLoginCommand)
    .command(command_object_24.yargsLogoutCommand)
    .command(resolveConformanceCommandObject())
    .command(resolveConformanceCheckCommandObject())
    .scriptName('nx')
    .help()
    // NOTE: we handle --version in nx.ts, this just tells yargs that the option exists
    // so that it shows up in help. The default yargs implementation of --version is not
    // hit, as the implementation in nx.ts is hit first and calls process.exit(0).
    .version();
function createMissingConformanceCommand(command) {
    return {
        command,
        // Hide from --help output in the common case of not having the plugin installed
        describe: false,
        handler: () => {
            output_1.output.error({
                title: `${command} is not available`,
                bodyLines: [
                    `In order to use the \`nx ${command}\` command you must have an active Powerpack license and the \`@nx/powerpack-conformance\` plugin installed.`,
                    '',
                    'To learn more, visit https://nx.dev/nx-enterprise/powerpack/conformance',
                ],
            });
            process.exit(1);
        },
    };
}
function resolveConformanceCommandObject() {
    try {
        const { yargsConformanceCommand } = require('@nx/powerpack-conformance');
        return yargsConformanceCommand;
    }
    catch {
        return createMissingConformanceCommand('conformance');
    }
}
function resolveConformanceCheckCommandObject() {
    try {
        const { yargsConformanceCheckCommand, } = require('@nx/powerpack-conformance');
        return yargsConformanceCheckCommand;
    }
    catch {
        return createMissingConformanceCommand('conformance:check');
    }
}
