import { perfRules, correctnessRules, restrictionRules, suspiciousRules, styleRules, pedanticRules } from "./rules-by-category.mjs";
const pedanticConfig = {
  name: "oxlint/pedantic",
  rules: pedanticRules
};
const styleConfig = {
  name: "oxlint/style",
  rules: styleRules
};
const suspiciousConfig = {
  name: "oxlint/suspicious",
  rules: suspiciousRules
};
const restrictionConfig = {
  name: "oxlint/restriction",
  rules: restrictionRules
};
const correctnessConfig = {
  name: "oxlint/correctness",
  rules: correctnessRules
};
const perfConfig = {
  name: "oxlint/perf",
  rules: perfRules
};
const configByCategory = {
  "flat/pedantic": pedanticConfig,
  "flat/style": styleConfig,
  "flat/suspicious": suspiciousConfig,
  "flat/restriction": restrictionConfig,
  "flat/correctness": correctnessConfig,
  "flat/perf": perfConfig
};
export {
  configByCategory as default
};
