import { LEAF_NODE_TYPES_COUNT, NODE_TYPES_COUNT, NODE_TYPE_IDS_MAP } from "../../dist/generated/visit/types.js";
import { deserializeProgramOnly } from "../../dist/generated/deserialize/ts.js";
import { walkProgram } from "../../dist/generated/visit/walk.js";
const diagnostics = [];
let setupContextForFile, getInternal;
var Context = class {
	#internal;
	constructor(fullRuleName) {
		this.#internal = {
			id: fullRuleName,
			filePath: "",
			ruleIndex: -1,
			options: []
		};
	}
	get id() {
		return getInternal(this, "access `context.id`").id;
	}
	get filename() {
		return getInternal(this, "access `context.filename`").filePath;
	}
	get physicalFilename() {
		return getInternal(this, "access `context.physicalFilename`").filePath;
	}
	get options() {
		return getInternal(this, "access `context.options`").options;
	}
	report(diagnostic) {
		let { ruleIndex } = getInternal(this, "report errors"), { node } = diagnostic;
		diagnostics.push({
			message: diagnostic.message,
			start: node.start,
			end: node.end,
			ruleIndex
		});
	}
	static {
		setupContextForFile = (context, ruleIndex, filePath) => {
			let internal = context.#internal;
			internal.ruleIndex = ruleIndex, internal.filePath = filePath;
		}, getInternal = (context, actionDescription) => {
			let internal = context.#internal;
			if (internal.ruleIndex === -1) throw Error(`Cannot ${actionDescription} in \`createOnce\``);
			return internal;
		};
	}
};
function getErrorMessage(err) {
	try {
		if (err instanceof Error) {
			let { stack } = err;
			if (typeof stack == "string" && stack !== "") return stack;
		}
		let { message } = err;
		if (typeof message == "string" && message !== "") return message;
	} catch {}
	return "Unknown error";
}
const ObjectKeys$1 = Object.keys, registeredPluginPaths = /* @__PURE__ */ new Set(), registeredRules = [];
async function loadPlugin(path) {
	try {
		return await loadPluginImpl(path);
	} catch (err) {
		return JSON.stringify({ Failure: getErrorMessage(err) });
	}
}
async function loadPluginImpl(path) {
	if (registeredPluginPaths.has(path)) return JSON.stringify({ Failure: "This plugin has already been registered" });
	let { default: plugin } = await import(path);
	registeredPluginPaths.add(path);
	let pluginName = plugin.meta.name, offset = registeredRules.length, { rules } = plugin, ruleNames = ObjectKeys$1(rules), ruleNamesLen = ruleNames.length;
	for (let i = 0; i < ruleNamesLen; i++) {
		let ruleName = ruleNames[i], rule = rules[ruleName], context = new Context(`${pluginName}/${ruleName}`), ruleAndContext;
		if ("createOnce" in rule) {
			let { before: beforeHook, after: afterHook,...visitor } = rule.createOnce(context);
			ruleAndContext = {
				rule,
				context,
				visitor,
				beforeHook: beforeHook || null,
				afterHook: afterHook || null
			};
		} else ruleAndContext = {
			rule,
			context,
			visitor: null,
			beforeHook: null,
			afterHook: null
		};
		registeredRules.push(ruleAndContext);
	}
	return JSON.stringify({ Success: {
		name: pluginName,
		offset,
		ruleNames
	} });
}
const ObjectKeys = Object.keys, { isArray } = Array, compiledVisitor = [];
for (let i = NODE_TYPES_COUNT; i !== 0; i--) compiledVisitor.push(null);
const mergedLeafVisitorTypeIds = [], mergedEnterVisitorTypeIds = [], mergedExitVisitorTypeIds = [];
for (let i = LEAF_NODE_TYPES_COUNT; i !== 0; i--) mergedLeafVisitorTypeIds.push(0);
for (let i = NODE_TYPES_COUNT - LEAF_NODE_TYPES_COUNT; i !== 0; i--) mergedEnterVisitorTypeIds.push(0), mergedExitVisitorTypeIds.push(0);
mergedLeafVisitorTypeIds.length = 0, mergedEnterVisitorTypeIds.length = 0, mergedExitVisitorTypeIds.length = 0;
let hasActiveVisitors = !1;
const enterExitObjectCache = [];
let enterExitObjectCacheNextIndex = 0;
function getEnterExitObject() {
	if (enterExitObjectCacheNextIndex < enterExitObjectCache.length) return enterExitObjectCache[enterExitObjectCacheNextIndex++];
	let enterExit = {
		enter: null,
		exit: null
	};
	return enterExitObjectCache.push(enterExit), enterExitObjectCacheNextIndex++, enterExit;
}
const visitFnArrayCache = [];
let visitFnArrayCacheNextIndex = 0;
function createVisitFnArray(visit1, visit2) {
	if (visitFnArrayCacheNextIndex < visitFnArrayCache.length) {
		let arr$1 = visitFnArrayCache[visitFnArrayCacheNextIndex++];
		return arr$1.push(visit1, visit2), arr$1;
	}
	let arr = [visit1, visit2];
	return visitFnArrayCache.push(arr), visitFnArrayCacheNextIndex++, arr;
}
function initCompiledVisitor() {
	for (let i = 0; i < NODE_TYPES_COUNT; i++) compiledVisitor[i] = null;
	for (let i = 0; i < enterExitObjectCacheNextIndex; i++) {
		let enterExit = enterExitObjectCache[i];
		enterExit.enter = null, enterExit.exit = null;
	}
	enterExitObjectCacheNextIndex = 0;
}
function addVisitorToCompiled(visitor) {
	if (typeof visitor != "object" || !visitor) throw TypeError("Visitor returned from `create` method must be an object");
	let keys = ObjectKeys(visitor), keysLen = keys.length;
	if (keysLen !== 0) {
		hasActiveVisitors = !0;
		for (let i = 0; i < keysLen; i++) {
			let name = keys[i], visitFn = visitor[name];
			if (typeof visitFn != "function") throw TypeError(`'${name}' property of visitor object is not a function`);
			let isExit = name.endsWith(":exit");
			isExit && (name = name.slice(0, -5));
			let typeId = NODE_TYPE_IDS_MAP.get(name);
			if (typeId === void 0) throw Error(`Unknown node type '${name}' in visitor object`);
			let existing = compiledVisitor[typeId];
			if (typeId < LEAF_NODE_TYPES_COUNT) existing === null ? compiledVisitor[typeId] = visitFn : isArray(existing) ? isExit ? existing.push(visitFn) : existing.splice(existing.length - 1, 0, visitFn) : (compiledVisitor[typeId] = isExit ? createVisitFnArray(existing, visitFn) : createVisitFnArray(visitFn, existing), mergedLeafVisitorTypeIds.push(typeId));
			else if (existing === null) {
				let enterExit = compiledVisitor[typeId] = getEnterExitObject();
				isExit ? enterExit.exit = visitFn : enterExit.enter = visitFn;
			} else if (isExit) {
				let { exit } = existing;
				exit === null ? existing.exit = visitFn : isArray(exit) ? exit.push(visitFn) : (existing.exit = createVisitFnArray(exit, visitFn), mergedExitVisitorTypeIds.push(typeId));
			} else {
				let { enter } = existing;
				enter === null ? existing.enter = visitFn : isArray(enter) ? enter.push(visitFn) : (existing.enter = createVisitFnArray(enter, visitFn), mergedEnterVisitorTypeIds.push(typeId));
			}
		}
	}
}
function finalizeCompiledVisitor() {
	if (hasActiveVisitors === !1) return !1;
	for (let i = mergedLeafVisitorTypeIds.length - 1; i >= 0; i--) {
		let typeId = mergedLeafVisitorTypeIds[i];
		compiledVisitor[typeId] = mergeVisitFns(compiledVisitor[typeId]);
	}
	for (let i = mergedEnterVisitorTypeIds.length - 1; i >= 0; i--) {
		let typeId = mergedEnterVisitorTypeIds[i], enterExit = compiledVisitor[typeId];
		enterExit.enter = mergeVisitFns(enterExit.enter);
	}
	for (let i = mergedExitVisitorTypeIds.length - 1; i >= 0; i--) {
		let typeId = mergedExitVisitorTypeIds[i], enterExit = compiledVisitor[typeId];
		enterExit.exit = mergeVisitFns(enterExit.exit);
	}
	return mergedLeafVisitorTypeIds.length = 0, mergedEnterVisitorTypeIds.length = 0, mergedExitVisitorTypeIds.length = 0, visitFnArrayCacheNextIndex = 0, hasActiveVisitors = !1, !0;
}
function mergeVisitFns(visitFns) {
	let numVisitFns = visitFns.length, merger;
	if (mergers.length <= numVisitFns) {
		for (; mergers.length < numVisitFns;) mergers.push(null);
		merger = createMerger(numVisitFns), mergers.push(merger);
	} else merger = mergers[numVisitFns], merger === null && (merger = mergers[numVisitFns] = createMerger(numVisitFns));
	let mergedFn = merger(...visitFns);
	return visitFns.length = 0, mergedFn;
}
function createMerger(fnCount) {
	let args = [], body = "return node=>{";
	for (let i = 1; i <= fnCount; i++) args.push(`visit${i}`), body += `visit${i}(node);`;
	return body += "}", args.push(body), Function(...args);
}
const mergers = [
	null,
	null,
	(visit1, visit2) => (node) => {
		visit1(node), visit2(node);
	},
	(visit1, visit2, visit3) => (node) => {
		visit1(node), visit2(node), visit3(node);
	},
	(visit1, visit2, visit3, visit4) => (node) => {
		visit1(node), visit2(node), visit3(node), visit4(node);
	},
	(visit1, visit2, visit3, visit4, visit5) => (node) => {
		visit1(node), visit2(node), visit3(node), visit4(node), visit5(node);
	}
], buffers = [], textDecoder = new TextDecoder("utf-8", { ignoreBOM: !0 }), afterHooks = [];
function lintFile(filePath, bufferId, buffer, ruleIds) {
	if (buffer === null) buffer = buffers[bufferId];
	else {
		let { buffer: arrayBuffer, byteOffset } = buffer;
		buffer.uint32 = new Uint32Array(arrayBuffer, byteOffset), buffer.float64 = new Float64Array(arrayBuffer, byteOffset);
		for (let i = bufferId - buffers.length; i >= 0; i--) buffers.push(null);
		buffers[bufferId] = buffer;
	}
	if (typeof filePath != "string" || filePath.length === 0) throw Error("expected filePath to be a non-zero length string");
	if (!Array.isArray(ruleIds) || ruleIds.length === 0) throw Error("Expected `ruleIds` to be a non-zero len array");
	initCompiledVisitor();
	for (let i = 0; i < ruleIds.length; i++) {
		let ruleId = ruleIds[i], ruleAndContext = registeredRules[ruleId], { rule, context } = ruleAndContext;
		setupContextForFile(context, i, filePath);
		let { visitor } = ruleAndContext;
		if (visitor === null) visitor = rule.create(context);
		else {
			let { beforeHook, afterHook } = ruleAndContext;
			if (beforeHook !== null && beforeHook() === !1) continue;
			afterHook !== null && afterHooks.push(afterHook);
		}
		addVisitorToCompiled(visitor);
	}
	if (finalizeCompiledVisitor()) {
		let { uint32 } = buffer, programPos = uint32[536870902], sourceByteLen = uint32[programPos + 16 >> 2], sourceText = textDecoder.decode(buffer.subarray(0, sourceByteLen)), program = deserializeProgramOnly(buffer, sourceText, sourceByteLen, !1);
		walkProgram(program, compiledVisitor);
	}
	if (afterHooks.length !== 0) {
		for (let afterHook of afterHooks) afterHook();
		afterHooks.length = 0;
	}
	let ret = JSON.stringify(diagnostics);
	return diagnostics.length = 0, ret;
}
export { lintFile, loadPlugin };
