/* eslint-disable no-undef */
var _WebAssembly$1 = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
function validateImports(imports) {
    if (imports && typeof imports !== 'object') {
        throw new TypeError('imports must be an object or undefined');
    }
    return true;
}
function load(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    // Promise<string | URL | Response | BufferSource | WebAssembly.Module>
    try {
        var then = typeof wasmInput === 'object' && wasmInput !== null && 'then' in wasmInput ? wasmInput.then : undefined;
        if (typeof then === 'function') {
            return then.call(wasmInput, function (input) { return load(input, imports); });
        }
    }
    catch (_) { }
    // BufferSource
    if (wasmInput instanceof ArrayBuffer || ArrayBuffer.isView(wasmInput)) {
        return _WebAssembly$1.instantiate(wasmInput, imports);
    }
    // WebAssembly.Module
    if (wasmInput instanceof _WebAssembly$1.Module) {
        return _WebAssembly$1.instantiate(wasmInput, imports).then(function (instance) {
            return { instance: instance, module: wasmInput };
        });
    }
    // Response
    if (typeof Response !== 'undefined' && wasmInput instanceof Response) {
        return wasmInput.arrayBuffer().then(function (buffer) {
            return _WebAssembly$1.instantiate(buffer, imports);
        });
    }
    // string | URL
    var inputIsString = typeof wasmInput === 'string';
    if (inputIsString || (typeof URL !== 'undefined' && wasmInput instanceof URL)) {
        if (inputIsString && typeof wx !== 'undefined' && typeof __wxConfig !== 'undefined') {
            return _WebAssembly$1.instantiate(wasmInput, imports);
        }
        if (typeof fetch !== 'function') {
            throw new TypeError('wasm source can not be a string or URL in this environment');
        }
        if (typeof _WebAssembly$1.instantiateStreaming === 'function') {
            try {
                return _WebAssembly$1.instantiateStreaming(fetch(wasmInput), imports).catch(function () {
                    return load(fetch(wasmInput), imports);
                });
            }
            catch (_) {
                return load(fetch(wasmInput), imports);
            }
        }
        else {
            return load(fetch(wasmInput), imports);
        }
    }
    throw new TypeError('Invalid wasm source');
}
function loadSync(wasmInput, imports) {
    if (!wasmInput)
        throw new TypeError('Invalid wasm source');
    validateImports(imports);
    imports = imports !== null && imports !== void 0 ? imports : {};
    var module;
    if ((wasmInput instanceof ArrayBuffer) || ArrayBuffer.isView(wasmInput)) {
        module = new _WebAssembly$1.Module(wasmInput);
    }
    else if (wasmInput instanceof WebAssembly.Module) {
        module = wasmInput;
    }
    else {
        throw new TypeError('Invalid wasm source');
    }
    var instance = new _WebAssembly$1.Instance(module, imports);
    var source = { instance: instance, module: module };
    return source;
}

function createNapiModule(options) {
    var napiModule = (function () {
        var ENVIRONMENT_IS_NODE = null !== null   ;
        var ENVIRONMENT_IS_PTHREAD = Boolean(options.childThread);
        var reuseWorker = Boolean(options.reuseWorker);
        var wasmInstance;
        var wasmModule;
        var wasmMemory;
        var wasmTable;
        var _malloc;
        var _free;
        function abort(msg) {
            if (typeof _WebAssembly$1.RuntimeError === 'function') {
                throw new _WebAssembly$1.RuntimeError(msg);
            }
            throw Error(msg);
        }
        var napiModule = {
            imports: {
                env: {},
                napi: {},
                emnapi: {}
            },
            exports: {},
            emnapi: {},
            loaded: false,
            filename: '',
            childThread: Boolean(options.childThread),
            spawnThread: undefined,
            startThread: undefined,
            initWorker: undefined,
            executeAsyncWork: undefined,
            init: function (options) {
                if (napiModule.loaded)
                    return napiModule.exports;
                if (!options)
                    throw new TypeError('Invalid napi init options');
                var instance = options.instance;
                if (!(instance === null || instance === void 0 ? void 0 : instance.exports))
                    throw new TypeError('Invalid wasm instance');
                wasmInstance = instance;
                var exports = instance.exports;
                var module = options.module;
                var memory = options.memory || exports.memory;
                var table = options.table || exports.__indirect_function_table;
                if (!(module instanceof _WebAssembly$1.Module))
                    throw new TypeError('Invalid wasm module');
                if (!(memory instanceof _WebAssembly$1.Memory))
                    throw new TypeError('Invalid wasm memory');
                if (!(table instanceof _WebAssembly$1.Table))
                    throw new TypeError('Invalid wasm table');
                wasmModule = module;
                wasmMemory = memory;
                wasmTable = table;
                if (typeof exports.malloc !== 'function')
                    throw new TypeError('malloc is not exported');
                if (typeof exports.free !== 'function')
                    throw new TypeError('free is not exported');
                _malloc = exports.malloc;
                _free = exports.free;
                if (!napiModule.childThread) {
                    // main thread only
                    var moduleApiVersion = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;
                    var node_api_module_get_api_version_v1 = instance.exports.node_api_module_get_api_version_v1;
                    if (typeof node_api_module_get_api_version_v1 === 'function') {
                        moduleApiVersion = node_api_module_get_api_version_v1();
                    }
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    var envObject = napiModule.envObject || (napiModule.envObject = emnapiCtx.createEnv(napiModule.filename, moduleApiVersion, function (cb) { return (wasmTable.get(cb)); }, function (cb) { return (wasmTable.get(cb)); }, abort, emnapiNodeBinding));
                    var scope_1 = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callIntoModule(function (_envObject) {
                            var exports = napiModule.exports;
                            var exportsHandle = scope_1.add(exports);
                            var napi_register_wasm_v1 = instance.exports.napi_register_wasm_v1;
                            var napiValue = napi_register_wasm_v1(_envObject.id, exportsHandle.id);
                            napiModule.exports = (!napiValue) ? exports : emnapiCtx.handleStore.get(napiValue).value;
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope_1);
                    }
                    napiModule.loaded = true;
                    delete napiModule.envObject;
                    return napiModule.exports;
                }
            }
        };
        var emnapiCtx;
        var emnapiNodeBinding;
        var onCreateWorker;
        var err;
        if (!ENVIRONMENT_IS_PTHREAD) {
            var context = options.context;
            if (typeof context !== 'object' || context === null) {
                throw new TypeError("Invalid `options.context`. Use `import { getDefaultContext } from '@emnapi/runtime'`");
            }
            emnapiCtx = context;
        }
        else {
            emnapiCtx = options === null || options === void 0 ? void 0 : options.context;
            var postMsg = typeof options.postMessage === 'function'
                ? options.postMessage
                : typeof postMessage === 'function'
                    ? postMessage
                    : undefined;
            if (typeof postMsg !== 'function') {
                throw new TypeError('No postMessage found');
            }
            napiModule.postMessage = postMsg;
        }
        if (typeof options.filename === 'string') {
            napiModule.filename = options.filename;
        }
        if (typeof options.onCreateWorker === 'function') {
            onCreateWorker = options.onCreateWorker;
        }
        if (typeof options.print === 'function') {
            options.print;
        }
        else {
            console.log.bind(console);
        }
        if (typeof options.printErr === 'function') {
            err = options.printErr;
        }
        else {
            err = console.warn.bind(console);
        }
        if ('nodeBinding' in options) {
            var nodeBinding = options.nodeBinding;
            if (typeof nodeBinding !== 'object' || nodeBinding === null) {
                throw new TypeError('Invalid `options.nodeBinding`. Use @emnapi/node-binding package');
            }
            emnapiNodeBinding = nodeBinding;
        }
        var emnapiAsyncWorkPoolSize = 0;
        if ('asyncWorkPoolSize' in options) {
            if (typeof options.asyncWorkPoolSize !== 'number') {
                throw new TypeError('options.asyncWorkPoolSize must be a integer');
            }
            emnapiAsyncWorkPoolSize = options.asyncWorkPoolSize >> 0;
            if (emnapiAsyncWorkPoolSize > 1024) {
                emnapiAsyncWorkPoolSize = 1024;
            }
            else if (emnapiAsyncWorkPoolSize < -1024) {
                emnapiAsyncWorkPoolSize = -1024;
            }
        }
        var singleThreadAsyncWork = ENVIRONMENT_IS_PTHREAD ? false : (emnapiAsyncWorkPoolSize <= 0);
        function _emnapi_async_work_pool_size() {
            return Math.abs(emnapiAsyncWorkPoolSize);
        }
        napiModule.imports.env._emnapi_async_work_pool_size = _emnapi_async_work_pool_size;
        // ------------------------------ pthread -------------------------------
        function emnapiAddSendListener(worker) {
            if (!worker)
                return false;
            if (worker._emnapiSendListener)
                return true;
            var handler = function (e) {
                var data = e.data;
                var __emnapi__ = data.__emnapi__;
                if (__emnapi__ && __emnapi__.type === 'async-send') {
                    if (ENVIRONMENT_IS_PTHREAD) {
                        var postMessage_1 = napiModule.postMessage;
                        postMessage_1({ __emnapi__: __emnapi__ });
                    }
                    else {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var callback = __emnapi__.payload.callback;
                        (wasmTable.get(callback))(__emnapi__.payload.data);
                    }
                }
            };
            var dispose = function () {
                {
                    worker.removeEventListener('message', handler, false);
                }
                delete worker._emnapiSendListener;
            };
            worker._emnapiSendListener = { handler: handler, dispose: dispose };
            {
                worker.addEventListener('message', handler, false);
            }
            return true;
        }
        napiModule.emnapi.addSendListener = emnapiAddSendListener;
        function terminateWorker(worker) {
            var tid = worker.__emnapi_tid;
            worker.terminate();
            worker.onmessage = function (e) {
                if (e.data.__emnapi__) {
                    err('received "' + e.data.__emnapi__.type + '" command from terminated worker: ' + tid);
                }
            };
        }
        function spawnThread(startArg, errorOrTid) {
            var isNewABI = errorOrTid !== undefined;
            if (!isNewABI) {
                errorOrTid = _malloc(8);
                if (!errorOrTid) {
                    return -48; /* ENOMEM */
                }
            }
            var struct = new Int32Array(wasmMemory.buffer, errorOrTid, 2);
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, 0);
            if (ENVIRONMENT_IS_PTHREAD) {
                var postMessage_2 = napiModule.postMessage;
                postMessage_2({
                    __emnapi__: {
                        type: 'spawn-thread',
                        payload: {
                            startArg: startArg,
                            errorOrTid: errorOrTid
                        }
                    }
                });
                Atomics.wait(struct, 1, 0);
                var isError = Atomics.load(struct, 0);
                var result = Atomics.load(struct, 1);
                if (isNewABI) {
                    return isError;
                }
                _free(errorOrTid);
                return isError ? -result : result;
            }
            var worker;
            try {
                worker = PThread.getNewWorker();
                if (!worker) {
                    throw new Error('failed to get new worker');
                }
            }
            catch (e) {
                var EAGAIN = 6;
                Atomics.store(struct, 0, 1);
                Atomics.store(struct, 1, EAGAIN);
                Atomics.notify(struct, 1);
                err(e.message);
                if (isNewABI) {
                    return 1;
                }
                _free(errorOrTid);
                return -EAGAIN;
            }
            var tid = PThread.nextWorkerID + 43;
            Atomics.store(struct, 0, 0);
            Atomics.store(struct, 1, tid);
            Atomics.notify(struct, 1);
            var WASI_THREADS_MAX_TID = 0x1FFFFFFF;
            PThread.nextWorkerID = (PThread.nextWorkerID + 1) % (WASI_THREADS_MAX_TID - 42);
            PThread.pthreads[tid] = worker;
            worker.__emnapi_tid = tid;
            PThread.runningWorkers.push(worker);
            worker.postMessage({
                __emnapi__: {
                    type: 'start',
                    payload: {
                        tid: tid,
                        arg: startArg
                    }
                }
            });
            if (isNewABI) {
                return 0;
            }
            _free(errorOrTid);
            return tid;
        }
        function startThread(tid, startArg) {
            if (napiModule.childThread) {
                if (typeof wasmInstance.exports.wasi_thread_start !== 'function') {
                    throw new TypeError('wasi_thread_start is not exported');
                }
                var postMessage_3 = napiModule.postMessage;
                wasmInstance.exports.wasi_thread_start(tid, startArg);
                postMessage_3({
                    __emnapi__: {
                        type: 'cleanup-thread',
                        payload: {
                            tid: tid
                        }
                    }
                });
            }
            else {
                throw new Error('startThread is only available in child threads');
            }
        }
        napiModule.spawnThread = spawnThread;
        napiModule.startThread = startThread;
        var PThread = {
            unusedWorkers: [],
            runningWorkers: [],
            pthreads: Object.create(null),
            nextWorkerID: 0,
            init: function () { },
            returnWorkerToPool: function (worker) {
                var tid = worker.__emnapi_tid;
                delete PThread.pthreads[tid];
                PThread.unusedWorkers.push(worker);
                PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(worker), 1);
                delete worker.__emnapi_tid;
            },
            loadWasmModuleToWorker: function (worker) {
                if (worker.whenLoaded)
                    return worker.whenLoaded;
                worker.whenLoaded = new Promise(function (resolve, reject) {
                    worker.onmessage = function (e) {
                        if (e.data.__emnapi__) {
                            var type = e.data.__emnapi__.type;
                            var payload = e.data.__emnapi__.payload;
                            if (type === 'loaded') {
                                worker.loaded = true;
                                resolve(worker);
                                // if (payload.err) {
                                //   err('failed to load in child thread: ' + (payload.err.message || payload.err))
                                // }
                            }
                            else if (type === 'spawn-thread') {
                                spawnThread(payload.startArg, payload.errorOrTid);
                            }
                            else if (type === 'cleanup-thread') {
                                if (reuseWorker) {
                                    PThread.returnWorkerToPool(worker);
                                }
                                else {
                                    delete PThread.pthreads[payload.tid];
                                    PThread.runningWorkers.splice(PThread.runningWorkers.indexOf(worker), 1);
                                    terminateWorker(worker);
                                    delete worker.__emnapi_tid;
                                }
                            }
                        }
                    };
                    worker.onerror = function (e) {
                        var message = 'worker sent an error!';
                        // if (worker.pthread_ptr) {
                        //   message = 'Pthread ' + ptrToString(worker.pthread_ptr) + ' sent an error!'
                        // }
                        err(message + ' ' + e.message);
                        reject(e);
                        throw e;
                    };
                    // napiModule.emnapi.addSendListener(worker)
                    emnapiAddSendListener(worker);
                    // if (typeof emnapiTSFN !== 'undefined') {
                    //   emnapiTSFN.addListener(worker)
                    // }
                    try {
                        worker.postMessage({
                            __emnapi__: {
                                type: 'load',
                                payload: {
                                    wasmModule: wasmModule,
                                    wasmMemory: wasmMemory
                                }
                            }
                        });
                    }
                    catch (err) {
                        if (typeof SharedArrayBuffer === 'undefined' || !(wasmMemory.buffer instanceof SharedArrayBuffer)) {
                            throw new Error('Multithread features require shared wasm memory. ' +
                                'Try to compile with `-matomics -mbulk-memory` and use `--import-memory --shared-memory` during linking');
                        }
                        throw err;
                    }
                });
                return worker.whenLoaded;
            },
            allocateUnusedWorker: function () {
                if (typeof onCreateWorker !== 'function') {
                    throw new TypeError('`options.onCreateWorker` is not provided');
                }
                var worker = onCreateWorker({ type: 'thread' });
                PThread.unusedWorkers.push(worker);
                return worker;
            },
            getNewWorker: function () {
                if (reuseWorker) {
                    if (PThread.unusedWorkers.length === 0) {
                        var worker_1 = PThread.allocateUnusedWorker();
                        PThread.loadWasmModuleToWorker(worker_1);
                    }
                    return PThread.unusedWorkers.pop();
                }
                var worker = PThread.allocateUnusedWorker();
                PThread.loadWasmModuleToWorker(worker);
                return worker;
            }
        };
        /**
         * @__sig ipiip
         */
        function napi_set_last_error(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.setLastError(error_code, engine_error_code, engine_reserved);
        }
        /**
         * @__sig ip
         */
        function napi_clear_last_error(env) {
            var envObject = emnapiCtx.envStore.get(env);
            return envObject.clearLastError();
        }
        /**
         * @__sig vppp
         */
        function _emnapi_get_node_version(major, minor, patch) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = [0, 0, 0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(major, versions[0], true);
            HEAP_DATA_VIEW.setUint32(minor, versions[1], true);
            HEAP_DATA_VIEW.setUint32(patch, versions[2], true);
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePush
         */
        function _emnapi_runtime_keepalive_push() {
        }
        /**
         * @__sig v
         * @__deps $runtimeKeepalivePop
         */
        function _emnapi_runtime_keepalive_pop() {
        }
        /**
         * @__sig vpp
         */
        function _emnapi_set_immediate(callback, data) {
            emnapiCtx.feature.setImmediate(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vpp
         */
        function _emnapi_next_tick(callback, data) {
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            Promise.resolve().then(function () {
                (wasmTable.get(callback))(data);
            });
        }
        /**
         * @__sig vipppi
         */
        function _emnapi_callback_into_module(forceUncaught, env, callback, data, close_scope_if_throw) {
            var envObject = emnapiCtx.envStore.get(env);
            var scope = emnapiCtx.openScope(envObject);
            try {
                envObject.callbackIntoModule(Boolean(forceUncaught), function () {
                    (wasmTable.get(callback))(env, data);
                });
            }
            catch (err) {
                emnapiCtx.closeScope(envObject, scope);
                if (close_scope_if_throw) {
                    emnapiCtx.closeScope(envObject);
                }
                throw err;
            }
            emnapiCtx.closeScope(envObject, scope);
        }
        /**
         * @__sig vipppp
         */
        function _emnapi_call_finalizer(forceUncaught, env, callback, data, hint) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.callFinalizerInternal(forceUncaught, callback, data, hint);
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_increase_waiting_request_counter() {
            emnapiCtx.increaseWaitingRequestCounter();
        }
        /**
         * @__sig v
         */
        function _emnapi_ctx_decrease_waiting_request_counter() {
            emnapiCtx.decreaseWaitingRequestCounter();
        }
        function $emnapiSetValueI64(result, numberValue) {
            var tempDouble;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var tempI64 = [
                numberValue >>> 0,
                (tempDouble = numberValue, +Math.abs(tempDouble) >= 1 ? tempDouble > 0 ? (Math.min(+Math.floor(tempDouble / 4294967296), 4294967295) | 0) >>> 0 : ~~+Math.ceil((tempDouble - +(~~tempDouble >>> 0)) / 4294967296) >>> 0 : 0)
            ];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, tempI64[0], true);
            HEAP_DATA_VIEW.setInt32(result + 4, tempI64[1], true);
        }
        var utilMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiSetValueI64: $emnapiSetValueI64,
            _emnapi_call_finalizer: _emnapi_call_finalizer,
            _emnapi_callback_into_module: _emnapi_callback_into_module,
            _emnapi_ctx_decrease_waiting_request_counter: _emnapi_ctx_decrease_waiting_request_counter,
            _emnapi_ctx_increase_waiting_request_counter: _emnapi_ctx_increase_waiting_request_counter,
            _emnapi_get_node_version: _emnapi_get_node_version,
            _emnapi_next_tick: _emnapi_next_tick,
            _emnapi_runtime_keepalive_pop: _emnapi_runtime_keepalive_pop,
            _emnapi_runtime_keepalive_push: _emnapi_runtime_keepalive_push,
            _emnapi_set_immediate: _emnapi_set_immediate,
            napi_clear_last_error: napi_clear_last_error,
            napi_set_last_error: napi_set_last_error
        });
        function emnapiGetWorkerByPthreadPtr(pthreadPtr) {
            var view = new DataView(wasmMemory.buffer);
            /**
             * wasi-sdk-20.0+threads
             *
             * struct pthread {
             *   struct pthread *self;        // 0
             *   struct pthread *prev, *next; // 4, 8
             *   uintptr_t sysinfo;           // 12
             *   uintptr_t canary;            // 16
             *   int tid;                     // 20
             *   // ...
             * }
             */
            var tidOffset = 20;
            var tid = view.getInt32(pthreadPtr + tidOffset, true);
            var worker = PThread.pthreads[tid];
            return worker;
        }
        /** @__sig vp */
        function _emnapi_worker_unref(pthreadPtr) {
            if (ENVIRONMENT_IS_PTHREAD)
                return;
            var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
            if (worker && typeof worker.unref === 'function') {
                worker.unref();
            }
        }
        /** @__sig vipp */
        function _emnapi_async_send_js(type, callback, data) {
            if (ENVIRONMENT_IS_PTHREAD) {
                var postMessage_1 = napiModule.postMessage;
                postMessage_1({
                    __emnapi__: {
                        type: 'async-send',
                        payload: {
                            callback: callback,
                            data: data
                        }
                    }
                });
            }
            else {
                switch (type) {
                    case 0:
                        _emnapi_set_immediate(callback, data);
                        break;
                    case 1:
                        _emnapi_next_tick(callback, data);
                        break;
                }
            }
        }
        // function ptrToString (ptr: number): string {
        //   return '0x' + ('00000000' + ptr.toString(16)).slice(-8)
        // }
        var uvThreadpoolReadyResolve;
        var uvThreadpoolReady = new Promise(function (resolve) {
            uvThreadpoolReadyResolve = function () {
                uvThreadpoolReady.ready = true;
                resolve();
            };
        });
        uvThreadpoolReady.ready = false;
        /** @__sig i */
        function _emnapi_is_main_browser_thread() {
            return (typeof window !== 'undefined' && typeof document !== 'undefined' && !ENVIRONMENT_IS_NODE) ? 1 : 0;
        }
        /** @__sig vppi */
        function _emnapi_after_uvthreadpool_ready(callback, q, type) {
            if (uvThreadpoolReady.ready) {
                (wasmTable.get(callback))(q, type);
            }
            else {
                uvThreadpoolReady.then(function () {
                    (wasmTable.get(callback))(q, type);
                });
            }
        }
        /** @__sig vpi */
        function _emnapi_tell_js_uvthreadpool(threads, size) {
            var p = [];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var _loop_1 = function (i) {
                var pthreadPtr = HEAP_DATA_VIEW.getInt32(threads + i * 4, true);
                var worker = emnapiGetWorkerByPthreadPtr(pthreadPtr);
                p.push(new Promise(function (resolve) {
                    var handler = function (e) {
                        var data = e.data;
                        var __emnapi__ = data.__emnapi__;
                        if (__emnapi__ && __emnapi__.type === 'async-thread-ready') {
                            resolve();
                            if (worker && typeof worker.unref === 'function') {
                                worker.unref();
                            }
                            {
                                worker.removeEventListener('message', handler);
                            }
                        }
                    };
                    {
                        worker.addEventListener('message', handler);
                    }
                }));
            };
            for (var i = 0; i < size; i++) {
                _loop_1(i);
            }
            Promise.all(p).then(uvThreadpoolReadyResolve);
        }
        /** @__sig v */
        function _emnapi_emit_async_thread_ready() {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-thread-ready',
                    payload: {}
                }
            });
        }
        var asyncMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_after_uvthreadpool_ready: _emnapi_after_uvthreadpool_ready,
            _emnapi_async_send_js: _emnapi_async_send_js,
            _emnapi_emit_async_thread_ready: _emnapi_emit_async_thread_ready,
            _emnapi_is_main_browser_thread: _emnapi_is_main_browser_thread,
            _emnapi_tell_js_uvthreadpool: _emnapi_tell_js_uvthreadpool,
            _emnapi_worker_unref: _emnapi_worker_unref
        });
        /* eslint-disable @typescript-eslint/indent */
        /** @__sig ipjp */
        function napi_adjust_external_memory(env, change_in_bytes, adjusted_value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!adjusted_value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var change_in_bytes_number = Number(change_in_bytes);
            if (change_in_bytes_number < 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var old_size = wasmMemory.buffer.byteLength;
            var new_size = old_size + change_in_bytes_number;
            new_size = new_size + ((65536 - new_size % 65536) % 65536);
            if (wasmMemory.grow((new_size - old_size + 65535) >> 16) === -1) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (emnapiCtx.feature.supportBigInt) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setBigInt64(adjusted_value, BigInt(wasmMemory.buffer.byteLength), true);
            }
            else {
                $emnapiSetValueI64(adjusted_value, wasmMemory.buffer.byteLength);
            }
            return envObject.clearLastError();
        }
        var memoryMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_adjust_external_memory: napi_adjust_external_memory
        });
        /**
         * @__postset
         * ```
         * emnapiAWST.init();
         * ```
         */
        var emnapiAWST = {
            idGen: {},
            values: [undefined],
            queued: new Set(),
            pending: [],
            init: function () {
                var idGen = {
                    nextId: 1,
                    list: [],
                    generate: function () {
                        var id;
                        if (idGen.list.length) {
                            id = idGen.list.shift();
                        }
                        else {
                            id = idGen.nextId;
                            idGen.nextId++;
                        }
                        return id;
                    },
                    reuse: function (id) {
                        idGen.list.push(id);
                    }
                };
                emnapiAWST.idGen = idGen;
                emnapiAWST.values = [undefined];
                emnapiAWST.queued = new Set();
                emnapiAWST.pending = [];
            },
            create: function (env, resource, resourceName, execute, complete, data) {
                var asyncId = 0;
                var triggerAsyncId = 0;
                if (emnapiNodeBinding) {
                    var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resourceName, -1);
                    asyncId = asyncContext.asyncId;
                    triggerAsyncId = asyncContext.triggerAsyncId;
                }
                var id = emnapiAWST.idGen.generate();
                emnapiAWST.values[id] = {
                    env: env,
                    id: id,
                    resource: resource,
                    asyncId: asyncId,
                    triggerAsyncId: triggerAsyncId,
                    status: 0,
                    execute: execute,
                    complete: complete,
                    data: data
                };
                return id;
            },
            callComplete: function (work, status) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var complete = work.complete;
                var env = work.env;
                var data = work.data;
                var callback = function () {
                    if (!complete)
                        return;
                    var envObject = emnapiCtx.envStore.get(env);
                    var scope = emnapiCtx.openScope(envObject);
                    try {
                        envObject.callbackIntoModule(true, function () {
                            (wasmTable.get(complete))(env, status, data);
                        });
                    }
                    finally {
                        emnapiCtx.closeScope(envObject, scope);
                    }
                };
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.makeCallback(work.resource, callback, [], {
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                else {
                    callback();
                }
            },
            queue: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (work.status === 0) {
                    work.status = 1;
                    if (emnapiAWST.queued.size >= (Math.abs(emnapiAsyncWorkPoolSize) || 4)) {
                        emnapiAWST.pending.push(id);
                        return;
                    }
                    emnapiAWST.queued.add(id);
                    var env_1 = work.env;
                    var data_1 = work.data;
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var execute = work.execute;
                    work.status = 2;
                    emnapiCtx.feature.setImmediate(function () {
                        (wasmTable.get(execute))(env_1, data_1);
                        emnapiAWST.queued.delete(id);
                        work.status = 3;
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work, 0 /* napi_status.napi_ok */);
                        });
                        if (emnapiAWST.pending.length > 0) {
                            var nextWorkId = emnapiAWST.pending.shift();
                            emnapiAWST.values[nextWorkId].status = 0;
                            emnapiAWST.queue(nextWorkId);
                        }
                    });
                }
            },
            cancel: function (id) {
                var index = emnapiAWST.pending.indexOf(id);
                if (index !== -1) {
                    var work_1 = emnapiAWST.values[id];
                    if (work_1 && (work_1.status === 1)) {
                        work_1.status = 4;
                        emnapiAWST.pending.splice(index, 1);
                        emnapiCtx.feature.setImmediate(function () {
                            emnapiAWST.callComplete(work_1, 11 /* napi_status.napi_cancelled */);
                        });
                        return 0 /* napi_status.napi_ok */;
                    }
                    else {
                        return 9 /* napi_status.napi_generic_failure */;
                    }
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            remove: function (id) {
                var work = emnapiAWST.values[id];
                if (!work)
                    return;
                if (emnapiNodeBinding) {
                    emnapiNodeBinding.node.emitAsyncDestroy({
                        asyncId: work.asyncId,
                        triggerAsyncId: work.triggerAsyncId
                    });
                }
                emnapiAWST.values[id] = undefined;
                emnapiAWST.idGen.reuse(id);
            }
        };
        /** @__sig vppdp */
        function _emnapi_node_emit_async_init(async_resource, async_resource_name, trigger_async_id, result) {
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var resource_name = emnapiCtx.handleStore.get(async_resource_name).value;
            var asyncContext = emnapiNodeBinding.node.emitAsyncInit(resource, resource_name, trigger_async_id);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var asyncId = asyncContext.asyncId;
            var triggerAsyncId = asyncContext.triggerAsyncId;
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, asyncId, true);
                HEAP_DATA_VIEW.setFloat64(result + 8, triggerAsyncId, true);
            }
        }
        /** @__sig vdd */
        function _emnapi_node_emit_async_destroy(async_id, trigger_async_id) {
            if (!emnapiNodeBinding)
                return;
            emnapiNodeBinding.node.emitAsyncDestroy({
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
        }
        /* vpddp export function _emnapi_node_open_callback_scope (async_resource: napi_value, async_id: double, trigger_async_id: double, result: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !result) return
          const resource = emnapiCtx.handleStore.get(async_resource)!.value
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          const nativeCallbackScopePointer = emnapiNodeBinding.node.openCallbackScope(resource, {
            asyncId: async_id,
            triggerAsyncId: trigger_async_id
          })
    
          from64('result')
          $_TODO_makeSetValue('result', 0, 'nativeCallbackScopePointer', 'i64')
        }
    
        vp
        export function _emnapi_node_close_callback_scope (scope: Pointer<int64_t>): void {
          if (!emnapiNodeBinding || !scope) return
          from64('scope')
          const nativeCallbackScopePointer = $_TODO_makeGetValue('scope', 0, 'i64')
          emnapiNodeBinding.node.closeCallbackScope(BigInt(nativeCallbackScopePointer))
        } */
        /** @__sig ipppppddp */
        function _emnapi_node_make_callback(env, async_resource, cb, argv, size, async_id, trigger_async_id, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!emnapiNodeBinding)
                return;
            var resource = emnapiCtx.handleStore.get(async_resource).value;
            var callback = emnapiCtx.handleStore.get(cb).value;
            size = size >>> 0;
            var arr = Array(size);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            for (; i < size; i++) {
                var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                arr[i] = emnapiCtx.handleStore.get(argVal).value;
            }
            var ret = emnapiNodeBinding.node.makeCallback(resource, callback, arr, {
                asyncId: async_id,
                triggerAsyncId: trigger_async_id
            });
            if (result) {
                var envObject = emnapiCtx.envStore.get(env);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(ret);
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
        }
        /** @__sig ippp */
        function _emnapi_async_init_js(async_resource, async_resource_name, result) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var resource;
            if (async_resource) {
                resource = Object(emnapiCtx.handleStore.get(async_resource).value);
            }
            var name = emnapiCtx.handleStore.get(async_resource_name).value;
            var ret = emnapiNodeBinding.napi.asyncInit(resource, name);
            if (ret.status !== 0)
                return ret.status;
            var numberValue = ret.value;
            if (!((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63))))) {
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ip */
        function _emnapi_async_destroy_js(async_context) {
            if (!emnapiNodeBinding) {
                return 9 /* napi_status.napi_generic_failure */;
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var low = HEAP_DATA_VIEW.getInt32(async_context, true);
            var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
            var pointer = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
            var ret = emnapiNodeBinding.napi.asyncDestroy(pointer);
            if (ret.status !== 0)
                return ret.status;
            return 0 /* napi_status.napi_ok */;
        }
        // https://github.com/nodejs/node-addon-api/pull/1283
        /** @__sig ipppp */
        function napi_open_callback_scope(env, ignored, async_context_handle, result) {
            throw new Error('napi_open_callback_scope has not been implemented yet');
        }
        /** @__sig ipp */
        function napi_close_callback_scope(env, scope) {
            throw new Error('napi_close_callback_scope has not been implemented yet');
        }
        /** @__sig ippppppp */
        function napi_make_callback(env, async_context, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiNodeBinding) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = Object(emnapiCtx.handleStore.get(recv).value);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var low = HEAP_DATA_VIEW.getInt32(async_context, true);
                var high = HEAP_DATA_VIEW.getInt32(async_context + 4, true);
                var ctx = BigInt(low >>> 0) | (BigInt(high) << BigInt(32));
                argc = argc >>> 0;
                var arr = Array(argc);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    arr[i] = emnapiCtx.handleStore.get(argVal).value;
                }
                var ret = emnapiNodeBinding.napi.makeCallback(ctx, v8recv, v8func, arr);
                if (ret.error) {
                    throw ret.error;
                }
                if (ret.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(ret.status);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = envObject.ensureHandleId(ret.value);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig vp */
        function _emnapi_env_check_gc_access(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
        }
        var nodeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_async_destroy_js: _emnapi_async_destroy_js,
            _emnapi_async_init_js: _emnapi_async_init_js,
            _emnapi_env_check_gc_access: _emnapi_env_check_gc_access,
            _emnapi_node_emit_async_destroy: _emnapi_node_emit_async_destroy,
            _emnapi_node_emit_async_init: _emnapi_node_emit_async_init,
            _emnapi_node_make_callback: _emnapi_node_make_callback,
            napi_close_callback_scope: napi_close_callback_scope,
            napi_make_callback: napi_make_callback,
            napi_open_callback_scope: napi_open_callback_scope
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiTSFN.init();
         * ```
         */
        var emnapiTSFN = {
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* size_t */ queue_size: 24,
                /* void* */ queue: 1 * 4 + 24,
                /* size_t */ thread_count: 2 * 4 + 24,
                /* bool */ is_closing: 3 * 4 + 24,
                /* atomic_uchar */ dispatch_state: 3 * 4 + 28,
                /* void* */ context: 3 * 4 + 32,
                /* size_t */ max_queue_size: 4 * 4 + 32,
                /* napi_ref */ ref: 5 * 4 + 32,
                /* napi_env */ env: 6 * 4 + 32,
                /* void* */ finalize_data: 7 * 4 + 32,
                /* napi_finalize */ finalize_cb: 8 * 4 + 32,
                /* napi_threadsafe_function_call_js */ call_js_cb: 9 * 4 + 32,
                /* bool */ handles_closing: 10 * 4 + 32,
                /* bool */ async_ref: 10 * 4 + 36,
                /* int32_t */ mutex: 10 * 4 + 40,
                /* int32_t */ cond: 10 * 4 + 44,
                end: 10 * 4 + 48
            },
            init: function () {
                if (typeof PThread !== 'undefined') {
                    PThread.unusedWorkers.forEach(emnapiTSFN.addListener);
                    PThread.runningWorkers.forEach(emnapiTSFN.addListener);
                    var __original_getNewWorker_1 = PThread.getNewWorker;
                    PThread.getNewWorker = function () {
                        var r = __original_getNewWorker_1.apply(this, arguments);
                        emnapiTSFN.addListener(r);
                        return r;
                    };
                }
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiTSFNListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'tsfn-send') {
                            emnapiTSFN.dispatch(payload.tsfn);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiTSFNListener;
                };
                worker._emnapiTSFNListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initQueue: function (func) {
                var size = 2 * 4;
                var queue = _malloc(size);
                if (!queue)
                    return false;
                new Uint8Array(wasmMemory.buffer, queue, size).fill(0);
                emnapiTSFN.storeSizeTypeValue(func + emnapiTSFN.offset.queue, queue, false);
                return true;
            },
            destroyQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                if (queue) {
                    _free(queue);
                }
            },
            pushQueue: function (func, data) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                var tail = emnapiTSFN.loadSizeTypeValue(queue + 4, false);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var size = 2 * 4;
                var node = _malloc(size);
                if (!node)
                    throw new Error('OOM');
                emnapiTSFN.storeSizeTypeValue(node, data, false);
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                if (head === 0 && tail === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                else {
                    emnapiTSFN.storeSizeTypeValue(tail + 4, node, false);
                    emnapiTSFN.storeSizeTypeValue(queue + 4, node, false);
                }
                emnapiTSFN.addQueueSize(func);
            },
            shiftQueue: function (func) {
                var queue = emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue, false);
                var head = emnapiTSFN.loadSizeTypeValue(queue, false);
                if (head === 0)
                    return 0;
                var node = head;
                var next = emnapiTSFN.loadSizeTypeValue(head + 4, false);
                emnapiTSFN.storeSizeTypeValue(queue, next, false);
                if (next === 0) {
                    emnapiTSFN.storeSizeTypeValue(queue + 4, 0, false);
                }
                emnapiTSFN.storeSizeTypeValue(node + 4, 0, false);
                var value = emnapiTSFN.loadSizeTypeValue(node, false);
                _free(node);
                emnapiTSFN.subQueueSize(func);
                return value;
            },
            push: function (func, data, mode) {
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                var waitCondition = function () {
                    var queueSize = emnapiTSFN.getQueueSize(func);
                    var maxSize = emnapiTSFN.getMaxQueueSize(func);
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    return queueSize >= maxSize && maxSize > 0 && !isClosing;
                };
                var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && !ENVIRONMENT_IS_NODE;
                return mutex.execute(function () {
                    while (waitCondition()) {
                        if (mode === 0 /* napi_threadsafe_function_call_mode.napi_tsfn_nonblocking */) {
                            return 15 /* napi_status.napi_queue_full */;
                        }
                        /**
                         * Browser JS main thread can not use `Atomics.wait`
                         *
                         * Related:
                         * https://github.com/nodejs/node/pull/32689
                         * https://github.com/nodejs/node/pull/33453
                         */
                        if (isBrowserMain) {
                            return 21 /* napi_status.napi_would_deadlock */;
                        }
                        cond.wait();
                    }
                    if (emnapiTSFN.getIsClosing(func)) {
                        if (emnapiTSFN.getThreadCount(func) === 0) {
                            return 1 /* napi_status.napi_invalid_arg */;
                        }
                        else {
                            emnapiTSFN.subThreadCount(func);
                            return 16 /* napi_status.napi_closing */;
                        }
                    }
                    else {
                        emnapiTSFN.pushQueue(func, data);
                        emnapiTSFN.send(func);
                        return 0 /* napi_status.napi_ok */;
                    }
                });
            },
            getMutex: function (func) {
                var index = func + emnapiTSFN.offset.mutex;
                var mutex = {
                    lock: function () {
                        var isBrowserMain = typeof window !== 'undefined' && typeof document !== 'undefined' && !ENVIRONMENT_IS_NODE;
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        if (isBrowserMain) {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                            }
                        }
                        else {
                            while (true) {
                                var oldValue = Atomics.compareExchange(i32a, 0, 0, 1);
                                if (oldValue === 0) {
                                    return;
                                }
                                Atomics.wait(i32a, 0, 1);
                            }
                        }
                    },
                    /* lockAsync () {
                      return new Promise<void>(resolve => {
                        const again = (): void => { fn() }
                        const fn = (): void => {
                          const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                          const oldValue = Atomics.compareExchange(i32a, 0, 0, 1)
                          if (oldValue === 0) {
                            resolve()
                            return
                          }
                          (Atomics as any).waitAsync(i32a, 0, 1).value.then(again)
                        }
                        fn()
                      })
                    }, */
                    unlock: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var oldValue = Atomics.compareExchange(i32a, 0, 1, 0);
                        if (oldValue !== 1) {
                            throw new Error('Tried to unlock while not holding the mutex');
                        }
                        Atomics.notify(i32a, 0, 1);
                    },
                    execute: function (fn) {
                        mutex.lock();
                        try {
                            return fn();
                        }
                        finally {
                            mutex.unlock();
                        }
                    } /* ,
                    executeAsync<T> (fn: () => Promise<T>): Promise<T> {
                      return mutex.lockAsync().then(() => {
                        const r = fn()
                        mutex.unlock()
                        return r
                      }, (err) => {
                        mutex.unlock()
                        throw err
                      })
                    } */
                };
                return mutex;
            },
            getCond: function (func) {
                var index = func + emnapiTSFN.offset.cond;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = {
                    wait: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        var value = Atomics.load(i32a, 0);
                        mutex.unlock();
                        Atomics.wait(i32a, 0, value);
                        mutex.lock();
                    },
                    /* waitAsync () {
                      const i32a = new Int32Array(wasmMemory.buffer, index, 1)
                      const value = Atomics.load(i32a, 0)
                      mutex.unlock()
                      const lock = (): Promise<void> => mutex.lockAsync()
                      try {
                        return (Atomics as any).waitAsync(i32a, 0, value).value.then(lock, lock)
                      } catch (err) {
                        return lock()
                      }
                    }, */
                    signal: function () {
                        var i32a = new Int32Array(wasmMemory.buffer, index, 1);
                        Atomics.add(i32a, 0, 1);
                        Atomics.notify(i32a, 0, 1);
                    }
                };
                return cond;
            },
            getQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.queue_size, true);
            },
            addQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subQueueSize: function (func) {
                var offset = emnapiTSFN.offset.queue_size;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getThreadCount: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.thread_count, true);
            },
            addThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.add(arr, index, 1);
            },
            subThreadCount: function (func) {
                var offset = emnapiTSFN.offset.thread_count;
                var arr, index;
                arr = new Uint32Array(wasmMemory.buffer);
                index = (func + offset) >> 2;
                Atomics.sub(arr, index, 1);
            },
            getIsClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2);
            },
            setIsClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.is_closing) >> 2, value);
            },
            getHandlesClosing: function (func) {
                return Atomics.load(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2);
            },
            setHandlesClosing: function (func, value) {
                Atomics.store(new Int32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.handles_closing) >> 2, value);
            },
            getDispatchState: function (func) {
                return Atomics.load(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2);
            },
            getContext: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.context, false);
            },
            getMaxQueueSize: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.max_queue_size, true);
            },
            getEnv: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.env, false);
            },
            getCallJSCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.call_js_cb, false);
            },
            getRef: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.ref, false);
            },
            getResource: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.resource, false);
            },
            getFinalizeCb: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_cb, false);
            },
            getFinalizeData: function (func) {
                return emnapiTSFN.loadSizeTypeValue(func + emnapiTSFN.offset.finalize_data, false);
            },
            loadSizeTypeValue: function (offset, unsigned) {
                var ret;
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    ret = Atomics.load(arr, offset >> 2);
                    return ret;
                }
            },
            storeSizeTypeValue: function (offset, value, unsigned) {
                var arr;
                if (unsigned) {
                    arr = new Uint32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value);
                    return undefined;
                }
                else {
                    arr = new Int32Array(wasmMemory.buffer);
                    Atomics.store(arr, offset >> 2, value >>> 0);
                    return undefined;
                }
            },
            destroy: function (func) {
                emnapiTSFN.destroyQueue(func);
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                var ref = emnapiTSFN.getRef(func);
                if (ref) {
                    emnapiCtx.refStore.get(ref).dispose();
                }
                emnapiCtx.removeCleanupHook(envObject, emnapiTSFN.cleanup, func);
                envObject.unref();
                var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
                var arr = new Int32Array(wasmMemory.buffer);
                if (Atomics.load(arr, asyncRefOffset)) {
                    Atomics.store(arr, asyncRefOffset, 0);
                    emnapiCtx.decreaseWaitingRequestCounter();
                }
                var resource = emnapiTSFN.getResource(func);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(func);
            },
            emptyQueueAndDelete: function (func) {
                var callJsCb = emnapiTSFN.getCallJSCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var data;
                while (emnapiTSFN.getQueueSize(func) > 0) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = emnapiTSFN.shiftQueue(func);
                    if (callJsCb) {
                        (wasmTable.get(callJsCb))(0, 0, context, data);
                    }
                }
                emnapiTSFN.destroy(func);
            },
            finalize: function (func) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                var finalize = emnapiTSFN.getFinalizeCb(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = emnapiTSFN.getFinalizeData(func);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var context = emnapiTSFN.getContext(func);
                var f = function () {
                    envObject.callFinalizerInternal(0, finalize, data, context);
                };
                try {
                    if (finalize) {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            var asyncId = view.getFloat64(func + emnapiTSFN.offset.async_id, true);
                            var triggerAsyncId = view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: asyncId,
                                triggerAsyncId: triggerAsyncId
                            });
                        }
                        else {
                            f();
                        }
                    }
                    emnapiTSFN.emptyQueueAndDelete(func);
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            cleanup: function (func) {
                emnapiTSFN.closeHandlesAndMaybeDelete(func, 1);
            },
            closeHandlesAndMaybeDelete: function (func, set_closing) {
                var env = emnapiTSFN.getEnv(func);
                var envObject = emnapiCtx.envStore.get(env);
                emnapiCtx.openScope(envObject);
                try {
                    if (set_closing) {
                        emnapiTSFN.getMutex(func).execute(function () {
                            emnapiTSFN.setIsClosing(func, 1);
                            if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                emnapiTSFN.getCond(func).signal();
                            }
                        });
                    }
                    if (emnapiTSFN.getHandlesClosing(func)) {
                        return;
                    }
                    emnapiTSFN.setHandlesClosing(func, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.finalize(func);
                    });
                }
                finally {
                    emnapiCtx.closeScope(envObject);
                }
            },
            dispatchOne: function (func) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var data = 0;
                var popped_value = false;
                var has_more = false;
                var mutex = emnapiTSFN.getMutex(func);
                var cond = emnapiTSFN.getCond(func);
                mutex.execute(function () {
                    if (emnapiTSFN.getIsClosing(func)) {
                        emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                    }
                    else {
                        var size = emnapiTSFN.getQueueSize(func);
                        if (size > 0) {
                            data = emnapiTSFN.shiftQueue(func);
                            popped_value = true;
                            var maxQueueSize = emnapiTSFN.getMaxQueueSize(func);
                            if (size === maxQueueSize && maxQueueSize > 0) {
                                cond.signal();
                            }
                            size--;
                        }
                        if (size === 0) {
                            if (emnapiTSFN.getThreadCount(func) === 0) {
                                emnapiTSFN.setIsClosing(func, 1);
                                if (emnapiTSFN.getMaxQueueSize(func) > 0) {
                                    cond.signal();
                                }
                                emnapiTSFN.closeHandlesAndMaybeDelete(func, 0);
                            }
                        }
                        else {
                            has_more = true;
                        }
                    }
                });
                if (popped_value) {
                    var env = emnapiTSFN.getEnv(func);
                    var envObject_1 = emnapiCtx.envStore.get(env);
                    emnapiCtx.openScope(envObject_1);
                    var f = function () {
                        envObject_1.callbackIntoModule(false, function () {
                            var callJsCb = emnapiTSFN.getCallJSCb(func);
                            var ref = emnapiTSFN.getRef(func);
                            var js_callback = ref ? emnapiCtx.refStore.get(ref).get() : 0;
                            if (callJsCb) {
                                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                                var context = emnapiTSFN.getContext(func);
                                (wasmTable.get(callJsCb))(env, js_callback, context, data);
                            }
                            else {
                                var jsCallback = js_callback ? emnapiCtx.handleStore.get(js_callback).value : null;
                                if (typeof jsCallback === 'function') {
                                    jsCallback();
                                }
                            }
                        });
                    };
                    try {
                        if (emnapiNodeBinding) {
                            var resource = emnapiTSFN.getResource(func);
                            var resource_value = emnapiCtx.refStore.get(resource).get();
                            var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                            var view = new DataView(wasmMemory.buffer);
                            emnapiNodeBinding.node.makeCallback(resourceObject, f, [], {
                                asyncId: view.getFloat64(func + emnapiTSFN.offset.async_id, true),
                                triggerAsyncId: view.getFloat64(func + emnapiTSFN.offset.trigger_async_id, true)
                            });
                        }
                        else {
                            f();
                        }
                    }
                    finally {
                        emnapiCtx.closeScope(envObject_1);
                    }
                }
                return has_more;
            },
            dispatch: function (func) {
                var has_more = true;
                var iterations_left = 1000;
                var ui32a = new Uint32Array(wasmMemory.buffer);
                var index = (func + emnapiTSFN.offset.dispatch_state) >> 2;
                while (has_more && --iterations_left !== 0) {
                    Atomics.store(ui32a, index, 1);
                    has_more = emnapiTSFN.dispatchOne(func);
                    if (Atomics.exchange(ui32a, index, 0) !== 1) {
                        has_more = true;
                    }
                }
                if (has_more) {
                    emnapiTSFN.send(func);
                }
            },
            send: function (func) {
                var current_state = Atomics.or(new Uint32Array(wasmMemory.buffer), (func + emnapiTSFN.offset.dispatch_state) >> 2, 1 << 1);
                if ((current_state & 1) === 1) {
                    return;
                }
                if ((typeof ENVIRONMENT_IS_PTHREAD !== 'undefined') && ENVIRONMENT_IS_PTHREAD) {
                    postMessage({
                        __emnapi__: {
                            type: 'tsfn-send',
                            payload: {
                                tsfn: func
                            }
                        }
                    });
                }
                else {
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiTSFN.dispatch(func);
                    });
                }
            }
        };
        /** @__sig ippppppppppp */
        function napi_create_threadsafe_function(env, func, async_resource, async_resource_name, max_queue_size, initial_thread_count, thread_finalize_data, thread_finalize_cb, context, call_js_cb, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!async_resource_name)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            max_queue_size = max_queue_size >>> 0;
            initial_thread_count = initial_thread_count >>> 0;
            if (initial_thread_count === 0) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var ref = 0;
            if (!func) {
                if (!call_js_cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            else {
                var funcValue = emnapiCtx.handleStore.get(func).value;
                if (typeof funcValue !== 'function') {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                ref = emnapiCtx.createReference(envObject, func, 1, 1 /* Ownership.kUserland */).id;
            }
            var asyncResourceObject;
            if (async_resource) {
                asyncResourceObject = emnapiCtx.handleStore.get(async_resource).value;
                if (asyncResourceObject == null) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                asyncResourceObject = Object(asyncResourceObject);
            }
            else {
                asyncResourceObject = {};
            }
            var resource = envObject.ensureHandleId(asyncResourceObject);
            var asyncResourceName = emnapiCtx.handleStore.get(async_resource_name).value;
            if (typeof asyncResourceName === 'symbol') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            asyncResourceName = String(asyncResourceName);
            var resource_name = envObject.ensureHandleId(asyncResourceName);
            // tsfn create
            var sizeofTSFN = emnapiTSFN.offset.end;
            var tsfn = _malloc(sizeofTSFN);
            if (!tsfn)
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            new Uint8Array(wasmMemory.buffer).subarray(tsfn, tsfn + sizeofTSFN).fill(0);
            var resourceRef = emnapiCtx.createReference(envObject, resource, 1, 1 /* Ownership.kUserland */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var resource_ = resourceRef.id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(tsfn, resource_, true);
            if (!emnapiTSFN.initQueue(tsfn)) {
                _free(tsfn);
                resourceRef.dispose();
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            _emnapi_node_emit_async_init(resource, resource_name, -1, tsfn + emnapiTSFN.offset.async_id);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.thread_count, initial_thread_count, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.context, context, true);
            HEAP_DATA_VIEW.setUint32(tsfn + emnapiTSFN.offset.max_queue_size, max_queue_size, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.ref, ref, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.env, env, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_data, thread_finalize_data, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.finalize_cb, thread_finalize_cb, true);
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.call_js_cb, call_js_cb, true);
            emnapiCtx.addCleanupHook(envObject, emnapiTSFN.cleanup, tsfn);
            envObject.ref();
            emnapiCtx.increaseWaitingRequestCounter();
            HEAP_DATA_VIEW.setInt32(tsfn + emnapiTSFN.offset.async_ref, 1, true);
            HEAP_DATA_VIEW.setInt32(result, tsfn, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_threadsafe_function_context(func, result) {
            if (!func || !result) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var context = emnapiTSFN.getContext(func);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, context, true);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippi */
        function napi_call_threadsafe_function(func, data, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            return emnapiTSFN.push(func, data, mode);
        }
        /** @__sig ip */
        function napi_acquire_threadsafe_function(func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getIsClosing(func)) {
                    return 16 /* napi_status.napi_closing */;
                }
                emnapiTSFN.addThreadCount(func);
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipi */
        function napi_release_threadsafe_function(func, mode) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var mutex = emnapiTSFN.getMutex(func);
            var cond = emnapiTSFN.getCond(func);
            return mutex.execute(function () {
                if (emnapiTSFN.getThreadCount(func) === 0) {
                    return 1 /* napi_status.napi_invalid_arg */;
                }
                emnapiTSFN.subThreadCount(func);
                if (emnapiTSFN.getThreadCount(func) === 0 || mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) {
                    var isClosing = emnapiTSFN.getIsClosing(func);
                    if (!isClosing) {
                        var isClosingValue = (mode === 1 /* napi_threadsafe_function_release_mode.napi_tsfn_abort */) ? 1 : 0;
                        emnapiTSFN.setIsClosing(func, isClosingValue);
                        if (isClosingValue && emnapiTSFN.getMaxQueueSize(func) > 0) {
                            cond.signal();
                        }
                        emnapiTSFN.send(func);
                    }
                }
                return 0 /* napi_status.napi_ok */;
            });
        }
        /** @__sig ipp */
        function napi_unref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 0);
                emnapiCtx.decreaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ipp */
        function napi_ref_threadsafe_function(env, func) {
            if (!func) {
                abort();
                return 1 /* napi_status.napi_invalid_arg */;
            }
            var asyncRefOffset = (func + emnapiTSFN.offset.async_ref) >> 2;
            var arr = new Int32Array(wasmMemory.buffer);
            if (!Atomics.load(arr, asyncRefOffset)) {
                Atomics.store(arr, asyncRefOffset, 1);
                emnapiCtx.increaseWaitingRequestCounter();
            }
            return 0 /* napi_status.napi_ok */;
        }
        var emnapiAWMT = {
            unusedWorkers: [],
            runningWorkers: [],
            workQueue: [],
            workerReady: null,
            offset: {
                /* napi_ref */ resource: 0,
                /* double */ async_id: 8,
                /* double */ trigger_async_id: 16,
                /* napi_env */ env: 24,
                /* void* */ data: 1 * 4 + 24,
                /* napi_async_execute_callback */ execute: 2 * 4 + 24,
                /* napi_async_complete_callback */ complete: 3 * 4 + 24,
                end: 4 * 4 + 24
            },
            init: function () {
                emnapiAWMT.unusedWorkers = [];
                emnapiAWMT.runningWorkers = [];
                emnapiAWMT.workQueue = [];
                emnapiAWMT.workerReady = null;
            },
            addListener: function (worker) {
                if (!worker)
                    return false;
                if (worker._emnapiAWMTListener)
                    return true;
                var handler = function (e) {
                    var data = e.data;
                    var __emnapi__ = data.__emnapi__;
                    if (__emnapi__) {
                        var type = __emnapi__.type;
                        var payload = __emnapi__.payload;
                        if (type === 'async-work-complete') {
                            emnapiCtx.decreaseWaitingRequestCounter();
                            emnapiAWMT.runningWorkers.splice(emnapiAWMT.runningWorkers.indexOf(worker), 1);
                            emnapiAWMT.unusedWorkers.push(worker);
                            emnapiAWMT.checkIdleWorker();
                            emnapiAWMT.callComplete(payload.work, 0 /* napi_status.napi_ok */);
                        }
                        else if (type === 'async-work-queue') {
                            emnapiAWMT.scheduleWork(payload.work);
                        }
                        else if (type === 'async-work-cancel') {
                            emnapiAWMT.cancelWork(payload.work);
                        }
                    }
                };
                var dispose = function () {
                    {
                        worker.removeEventListener('message', handler, false);
                    }
                    delete worker._emnapiAWMTListener;
                };
                worker._emnapiAWMTListener = { handler: handler, dispose: dispose };
                {
                    worker.addEventListener('message', handler, false);
                }
                return true;
            },
            initWorkers: function (n) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                    return emnapiAWMT.workerReady || (emnapiAWMT.workerReady = Promise.resolve());
                }
                if (emnapiAWMT.workerReady)
                    return emnapiAWMT.workerReady;
                if (typeof onCreateWorker !== 'function') {
                    throw new TypeError('`options.onCreateWorker` is not a function');
                }
                var promises = [];
                var args = [];
                if (!('emnapi_async_worker_create' in wasmInstance.exports)) {
                    throw new TypeError('`emnapi_async_worker_create` is not exported, please try to add `--export=emnapi_async_worker_create` to linker flags');
                }
                for (var i = 0; i < n; ++i) {
                    args.push(wasmInstance.exports.emnapi_async_worker_create());
                }
                try {
                    var _loop_1 = function (i) {
                        var worker = onCreateWorker({ type: 'async-work' });
                        var p = PThread.loadWasmModuleToWorker(worker);
                        emnapiAWMT.addListener(worker);
                        promises.push(p.then(function () {
                            if (typeof worker.unref === 'function') {
                                worker.unref();
                            }
                        }));
                        emnapiAWMT.unusedWorkers.push(worker);
                        var arg = args[i];
                        worker.threadBlockBase = arg;
                        worker.postMessage({
                            __emnapi__: {
                                type: 'async-worker-init',
                                payload: { arg: arg }
                            }
                        });
                    };
                    for (var i = 0; i < n; ++i) {
                        _loop_1(i);
                    }
                }
                catch (err) {
                    for (var i = 0; i < n; ++i) {
                        // eslint-disable-next-line @typescript-eslint/no-unused-vars
                        var arg = args[i];
                        _free(arg);
                    }
                    throw err;
                }
                emnapiAWMT.workerReady = Promise.all(promises);
                return emnapiAWMT.workerReady;
            },
            checkIdleWorker: function () {
                if (emnapiAWMT.unusedWorkers.length > 0 && emnapiAWMT.workQueue.length > 0) {
                    var worker = emnapiAWMT.unusedWorkers.shift();
                    var work = emnapiAWMT.workQueue.shift();
                    emnapiAWMT.runningWorkers.push(worker);
                    worker.postMessage({
                        __emnapi__: {
                            type: 'async-work-execute',
                            payload: { work: work }
                        }
                    });
                }
            },
            getResource: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.resource, false);
            },
            getExecute: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.execute, false);
            },
            getComplete: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.complete, false);
            },
            getEnv: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.env, false);
            },
            getData: function (work) {
                return emnapiTSFN.loadSizeTypeValue(work + emnapiAWMT.offset.data, false);
            },
            scheduleWork: function (work) {
                var _a;
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_1 = napiModule.postMessage;
                    postMessage_1({
                        __emnapi__: {
                            type: 'async-work-queue',
                            payload: { work: work }
                        }
                    });
                    return;
                }
                emnapiCtx.increaseWaitingRequestCounter();
                emnapiAWMT.workQueue.push(work);
                if ((_a = emnapiAWMT.workerReady) === null || _a === void 0 ? void 0 : _a.ready) {
                    emnapiAWMT.checkIdleWorker();
                }
                else {
                    var fail = function (err) {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        throw err;
                    };
                    try {
                        emnapiAWMT.initWorkers(_emnapi_async_work_pool_size()).then(function () {
                            emnapiAWMT.workerReady.ready = true;
                            emnapiAWMT.checkIdleWorker();
                        }, fail);
                    }
                    catch (err) {
                        fail(err);
                    }
                }
            },
            cancelWork: function (work) {
                if (ENVIRONMENT_IS_PTHREAD) {
                    var postMessage_2 = napiModule.postMessage;
                    postMessage_2({
                        __emnapi__: {
                            type: 'async-work-cancel',
                            payload: { work: work }
                        }
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                var index = emnapiAWMT.workQueue.indexOf(work);
                if (index !== -1) {
                    emnapiAWMT.workQueue.splice(index, 1);
                    emnapiCtx.feature.setImmediate(function () {
                        emnapiCtx.decreaseWaitingRequestCounter();
                        emnapiAWMT.checkIdleWorker();
                        emnapiAWMT.callComplete(work, 11 /* napi_status.napi_cancelled */);
                    });
                    return 0 /* napi_status.napi_ok */;
                }
                return 9 /* napi_status.napi_generic_failure */;
            },
            callComplete: function (work, status) {
                var complete = emnapiAWMT.getComplete(work);
                var env = emnapiAWMT.getEnv(work);
                var data = emnapiAWMT.getData(work);
                var envObject = emnapiCtx.envStore.get(env);
                var scope = emnapiCtx.openScope(envObject);
                var callback = function () {
                    if (!complete)
                        return;
                    envObject.callbackIntoModule(true, function () {
                        (wasmTable.get(complete))(env, status, data);
                    });
                };
                try {
                    if (emnapiNodeBinding) {
                        var resource = emnapiAWMT.getResource(work);
                        var resource_value = emnapiCtx.refStore.get(resource).get();
                        var resourceObject = emnapiCtx.handleStore.get(resource_value).value;
                        var view = new DataView(wasmMemory.buffer);
                        var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                        var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                        emnapiNodeBinding.node.makeCallback(resourceObject, callback, [], {
                            asyncId: asyncId,
                            triggerAsyncId: triggerAsyncId
                        });
                    }
                    else {
                        callback();
                    }
                }
                finally {
                    emnapiCtx.closeScope(envObject, scope);
                }
            }
        };
        /** @__sig ippppppp */
        var napi_create_async_work = singleThreadAsyncWork
            ? function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceName = String(emnapiCtx.handleStore.get(resource_name).value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var id = emnapiAWST.create(env, resourceObject, resourceName, execute, complete, data);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, id, true);
                return envObject.clearLastError();
            }
            : function (env, resource, resource_name, execute, complete, data, result) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!execute)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resourceObject;
                if (resource) {
                    resourceObject = Object(emnapiCtx.handleStore.get(resource).value);
                }
                else {
                    resourceObject = {};
                }
                if (!resource_name)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var sizeofAW = emnapiAWMT.offset.end;
                var aw = _malloc(sizeofAW);
                if (!aw)
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                new Uint8Array(wasmMemory.buffer).subarray(aw, aw + sizeofAW).fill(0);
                var s = envObject.ensureHandleId(resourceObject);
                var resourceRef = emnapiCtx.createReference(envObject, s, 1, 1 /* Ownership.kUserland */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var resource_ = resourceRef.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(aw, resource_, true);
                _emnapi_node_emit_async_init(s, resource_name, -1, aw + emnapiAWMT.offset.async_id);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.env, env, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.execute, execute, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.complete, complete, true);
                HEAP_DATA_VIEW.setInt32(aw + emnapiAWMT.offset.data, data, true);
                HEAP_DATA_VIEW.setInt32(result, aw, true);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_delete_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.remove(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var resource = emnapiAWMT.getResource(work);
                emnapiCtx.refStore.get(resource).dispose();
                if (emnapiNodeBinding) {
                    var view = new DataView(wasmMemory.buffer);
                    var asyncId = view.getFloat64(work + emnapiAWMT.offset.async_id, true);
                    var triggerAsyncId = view.getFloat64(work + emnapiAWMT.offset.trigger_async_id, true);
                    _emnapi_node_emit_async_destroy(asyncId, triggerAsyncId);
                }
                _free(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_queue_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWST.queue(work);
                return envObject.clearLastError();
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                emnapiAWMT.scheduleWork(work);
                return envObject.clearLastError();
            };
        /** @__sig ipp */
        var napi_cancel_async_work = singleThreadAsyncWork
            ? function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWST.cancel(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            }
            : function (env, work) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                var envObject = emnapiCtx.envStore.get(env);
                if (!work)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = emnapiAWMT.cancelWork(work);
                if (status === 0 /* napi_status.napi_ok */)
                    return envObject.clearLastError();
                return envObject.setLastError(status);
            };
        function initWorker(startArg) {
            if (napiModule.childThread) {
                if (typeof wasmInstance.exports.emnapi_async_worker_init !== 'function') {
                    throw new TypeError('`emnapi_async_worker_init` is not exported, please try to add `--export=emnapi_async_worker_init` to linker flags');
                }
                wasmInstance.exports.emnapi_async_worker_init(startArg);
            }
            else {
                throw new Error('startThread is only available in child threads');
            }
        }
        function executeAsyncWork(work) {
            if (!ENVIRONMENT_IS_PTHREAD)
                return;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var execute = emnapiAWMT.getExecute(work);
            var env = emnapiAWMT.getEnv(work);
            var data = emnapiAWMT.getData(work);
            (wasmTable.get(execute))(env, data);
            var postMessage = napiModule.postMessage;
            postMessage({
                __emnapi__: {
                    type: 'async-work-complete',
                    payload: { work: work }
                }
            });
        }
        napiModule.initWorker = initWorker;
        napiModule.executeAsyncWork = executeAsyncWork;
        var asyncWorkMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_cancel_async_work: napi_cancel_async_work,
            napi_create_async_work: napi_create_async_work,
            napi_delete_async_work: napi_delete_async_work,
            napi_queue_async_work: napi_queue_async_work
        });
        /**
         * @__deps malloc
         * @__deps free
         * @__postset
         * ```
         * emnapiExternalMemory.init();
         * ```
         */
        var emnapiExternalMemory = {
            registry: typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined,
            table: new WeakMap(),
            wasmMemoryViewTable: new WeakMap(),
            init: function () {
                emnapiExternalMemory.registry = typeof FinalizationRegistry === 'function' ? new FinalizationRegistry(function (_pointer) { _free(_pointer); }) : undefined;
                emnapiExternalMemory.table = new WeakMap();
                emnapiExternalMemory.wasmMemoryViewTable = new WeakMap();
            },
            isDetachedArrayBuffer: function (arrayBuffer) {
                if (arrayBuffer.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(arrayBuffer);
                    }
                    catch (_) {
                        return true;
                    }
                }
                return false;
            },
            getArrayBufferPointer: function (arrayBuffer, shouldCopy) {
                var _a;
                var info = {
                    address: 0,
                    ownership: 0 /* Ownership.kRuntime */,
                    runtimeAllocated: 0
                };
                if (arrayBuffer === wasmMemory.buffer) {
                    return info;
                }
                var isDetached = emnapiExternalMemory.isDetachedArrayBuffer(arrayBuffer);
                if (emnapiExternalMemory.table.has(arrayBuffer)) {
                    var cachedInfo = emnapiExternalMemory.table.get(arrayBuffer);
                    if (isDetached) {
                        cachedInfo.address = 0;
                        return cachedInfo;
                    }
                    if (shouldCopy && cachedInfo.ownership === 0 /* Ownership.kRuntime */ && cachedInfo.runtimeAllocated === 1) {
                        new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), cachedInfo.address);
                    }
                    return cachedInfo;
                }
                if (isDetached || (arrayBuffer.byteLength === 0)) {
                    return info;
                }
                if (!shouldCopy) {
                    return info;
                }
                var pointer = _malloc(arrayBuffer.byteLength);
                if (!pointer)
                    throw new Error('Out of memory');
                new Uint8Array(wasmMemory.buffer).set(new Uint8Array(arrayBuffer), pointer);
                info.address = pointer;
                info.ownership = emnapiExternalMemory.registry ? 0 /* Ownership.kRuntime */ : 1 /* Ownership.kUserland */;
                info.runtimeAllocated = 1;
                emnapiExternalMemory.table.set(arrayBuffer, info);
                (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(arrayBuffer, pointer);
                return info;
            },
            getOrUpdateMemoryView: function (view) {
                if (view.buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(view, {
                            Ctor: view.constructor,
                            address: view.byteOffset,
                            length: view instanceof DataView ? view.byteLength : view.length,
                            ownership: 1 /* Ownership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                    return view;
                }
                var maybeOldWasmMemory = emnapiExternalMemory.isDetachedArrayBuffer(view.buffer) ||
                    ((typeof SharedArrayBuffer === 'function') && (view.buffer instanceof SharedArrayBuffer));
                if (maybeOldWasmMemory && emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                    var info = emnapiExternalMemory.wasmMemoryViewTable.get(view);
                    var Ctor = info.Ctor;
                    var newView = void 0;
                    var Buffer = emnapiCtx.feature.Buffer;
                    if (typeof Buffer === 'function' && Ctor === Buffer) {
                        newView = Buffer.from(wasmMemory.buffer, info.address, info.length);
                    }
                    else {
                        newView = new Ctor(wasmMemory.buffer, info.address, info.length);
                    }
                    emnapiExternalMemory.wasmMemoryViewTable.set(newView, info);
                    return newView;
                }
                return view;
            },
            getViewPointer: function (view, shouldCopy) {
                view = emnapiExternalMemory.getOrUpdateMemoryView(view);
                if (view.buffer === wasmMemory.buffer) {
                    if (emnapiExternalMemory.wasmMemoryViewTable.has(view)) {
                        var _a = emnapiExternalMemory.wasmMemoryViewTable.get(view), address_1 = _a.address, ownership_1 = _a.ownership, runtimeAllocated_1 = _a.runtimeAllocated;
                        return { address: address_1, ownership: ownership_1, runtimeAllocated: runtimeAllocated_1, view: view };
                    }
                    return { address: view.byteOffset, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0, view: view };
                }
                var _b = emnapiExternalMemory.getArrayBufferPointer(view.buffer, shouldCopy), address = _b.address, ownership = _b.ownership, runtimeAllocated = _b.runtimeAllocated;
                return { address: address === 0 ? 0 : (address + view.byteOffset), ownership: ownership, runtimeAllocated: runtimeAllocated, view: view };
            }
        };
        /* eslint-disable @typescript-eslint/indent */
        /**
         * @__postset
         * ```
         * emnapiString.init();
         * ```
         */
        var emnapiString = {
            utf8Decoder: undefined,
            utf16Decoder: undefined,
            init: function () {
                var fallbackDecoder = {
                    decode: function (bytes) {
                        var inputIndex = 0;
                        var pendingSize = Math.min(0x1000, bytes.length + 1);
                        var pending = new Uint16Array(pendingSize);
                        var chunks = [];
                        var pendingIndex = 0;
                        for (;;) {
                            var more = inputIndex < bytes.length;
                            if (!more || (pendingIndex >= pendingSize - 1)) {
                                var subarray = pending.subarray(0, pendingIndex);
                                var arraylike = subarray;
                                chunks.push(String.fromCharCode.apply(null, arraylike));
                                if (!more) {
                                    return chunks.join('');
                                }
                                bytes = bytes.subarray(inputIndex);
                                inputIndex = 0;
                                pendingIndex = 0;
                            }
                            var byte1 = bytes[inputIndex++];
                            if ((byte1 & 0x80) === 0) {
                                pending[pendingIndex++] = byte1;
                            }
                            else if ((byte1 & 0xe0) === 0xc0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 6) | byte2;
                            }
                            else if ((byte1 & 0xf0) === 0xe0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                pending[pendingIndex++] = ((byte1 & 0x1f) << 12) | (byte2 << 6) | byte3;
                            }
                            else if ((byte1 & 0xf8) === 0xf0) {
                                var byte2 = bytes[inputIndex++] & 0x3f;
                                var byte3 = bytes[inputIndex++] & 0x3f;
                                var byte4 = bytes[inputIndex++] & 0x3f;
                                var codepoint = ((byte1 & 0x07) << 0x12) | (byte2 << 0x0c) | (byte3 << 0x06) | byte4;
                                if (codepoint > 0xffff) {
                                    codepoint -= 0x10000;
                                    pending[pendingIndex++] = (codepoint >>> 10) & 0x3ff | 0xd800;
                                    codepoint = 0xdc00 | codepoint & 0x3ff;
                                }
                                pending[pendingIndex++] = codepoint;
                            }
                            else ;
                        }
                    }
                };
                var utf8Decoder;
                utf8Decoder = typeof TextDecoder === 'function' ? new TextDecoder() : fallbackDecoder;
                emnapiString.utf8Decoder = utf8Decoder;
                var fallbackDecoder2 = {
                    decode: function (input) {
                        var bytes = new Uint16Array(input.buffer, input.byteOffset, input.byteLength / 2);
                        if (bytes.length <= 0x1000) {
                            return String.fromCharCode.apply(null, bytes);
                        }
                        var chunks = [];
                        var i = 0;
                        var len = 0;
                        for (; i < bytes.length; i += len) {
                            len = Math.min(0x1000, bytes.length - i);
                            chunks.push(String.fromCharCode.apply(null, bytes.subarray(i, i + len)));
                        }
                        return chunks.join('');
                    }
                };
                var utf16Decoder;
                utf16Decoder = typeof TextDecoder === 'function' ? new TextDecoder('utf-16le') : fallbackDecoder2;
                emnapiString.utf16Decoder = utf16Decoder;
            },
            lengthBytesUTF8: function (str) {
                var c;
                var len = 0;
                for (var i = 0; i < str.length; ++i) {
                    c = str.charCodeAt(i);
                    if (c <= 0x7F) {
                        len++;
                    }
                    else if (c <= 0x7FF) {
                        len += 2;
                    }
                    else if (c >= 0xD800 && c <= 0xDFFF) {
                        len += 4;
                        ++i;
                    }
                    else {
                        len += 3;
                    }
                }
                return len;
            },
            UTF8ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var end = ptr;
                if (length === -1) {
                    for (; HEAPU8[end];)
                        ++end;
                }
                else {
                    end = ptr + (length >>> 0);
                }
                length = end - ptr;
                if (length <= 16) {
                    var idx = ptr;
                    var str = '';
                    while (idx < end) {
                        var u0 = HEAPU8[idx++];
                        if (!(u0 & 0x80)) {
                            str += String.fromCharCode(u0);
                            continue;
                        }
                        var u1 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xE0) === 0xC0) {
                            str += String.fromCharCode(((u0 & 31) << 6) | u1);
                            continue;
                        }
                        var u2 = HEAPU8[idx++] & 63;
                        if ((u0 & 0xF0) === 0xE0) {
                            u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
                        }
                        else {
                            u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | (HEAPU8[idx++] & 63);
                        }
                        if (u0 < 0x10000) {
                            str += String.fromCharCode(u0);
                        }
                        else {
                            var ch = u0 - 0x10000;
                            str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
                        }
                    }
                    return str;
                }
                return emnapiString.utf8Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer.constructor) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF8: function (str, outPtr, maxBytesToWrite) {
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                var outIdx = outPtr;
                outIdx >>>= 0;
                if (!(maxBytesToWrite > 0)) {
                    return 0;
                }
                var startIdx = outIdx;
                var endIdx = outIdx + maxBytesToWrite - 1;
                for (var i = 0; i < str.length; ++i) {
                    var u = str.charCodeAt(i);
                    if (u >= 0xD800 && u <= 0xDFFF) {
                        var u1 = str.charCodeAt(++i);
                        u = 0x10000 + ((u & 0x3FF) << 10) | (u1 & 0x3FF);
                    }
                    if (u <= 0x7F) {
                        if (outIdx >= endIdx)
                            break;
                        HEAPU8[outIdx++] = u;
                    }
                    else if (u <= 0x7FF) {
                        if (outIdx + 1 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xC0 | (u >> 6);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else if (u <= 0xFFFF) {
                        if (outIdx + 2 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xE0 | (u >> 12);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                    else {
                        if (outIdx + 3 >= endIdx)
                            break;
                        HEAPU8[outIdx++] = 0xF0 | (u >> 18);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 12) & 63);
                        HEAPU8[outIdx++] = 0x80 | ((u >> 6) & 63);
                        HEAPU8[outIdx++] = 0x80 | (u & 63);
                    }
                }
                HEAPU8[outIdx] = 0;
                return outIdx - startIdx;
            },
            UTF16ToString: function (ptr, length) {
                if (!ptr || !length)
                    return '';
                ptr >>>= 0;
                var end = ptr;
                if (length === -1) {
                    var idx = end >> 1;
                    var HEAPU16 = new Uint16Array(wasmMemory.buffer);
                    while (HEAPU16[idx])
                        ++idx;
                    end = idx << 1;
                }
                else {
                    end = ptr + (length >>> 0) * 2;
                }
                length = end - ptr;
                if (length <= 32) {
                    return String.fromCharCode.apply(null, new Uint16Array(wasmMemory.buffer, ptr, length / 2));
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var HEAPU8 = new Uint8Array(wasmMemory.buffer);
                return emnapiString.utf16Decoder.decode(((typeof SharedArrayBuffer === "function" && HEAPU8.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(HEAPU8.buffer.constructor) === "[object SharedArrayBuffer]")) ? HEAPU8.slice(ptr, end) : HEAPU8.subarray(ptr, end));
            },
            stringToUTF16: function (str, outPtr, maxBytesToWrite) {
                if (maxBytesToWrite === undefined) {
                    maxBytesToWrite = 0x7FFFFFFF;
                }
                if (maxBytesToWrite < 2)
                    return 0;
                maxBytesToWrite -= 2;
                var startPtr = outPtr;
                var numCharsToWrite = (maxBytesToWrite < str.length * 2) ? (maxBytesToWrite / 2) : str.length;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < numCharsToWrite; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var codeUnit = str.charCodeAt(i);
                    HEAP_DATA_VIEW.setInt16(outPtr, codeUnit, true);
                    outPtr += 2;
                }
                HEAP_DATA_VIEW.setInt16(outPtr, 0, true);
                return outPtr - startPtr;
            },
            newString: function (env, str, length, result, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var strValue = stringMaker(str, autoLength, sizelength);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(strValue).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            },
            newExternalString: function (env, str, length, finalize_callback, finalize_hint, result, copied, createApi, stringMaker) {
                if (!env)
                    return 1 /* napi_status.napi_invalid_arg */;
                // @ts-expect-error
                var envObject = emnapiCtx.envStore.get(env);
                envObject.checkGCAccess();
                var autoLength = length === -1;
                var sizelength = length >>> 0;
                if (length !== 0) {
                    if (!str)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!(autoLength || (sizelength <= 2147483647)))
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var status = createApi(env, str, length, result);
                if (status === 0 /* napi_status.napi_ok */) {
                    if (copied) {
                        var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                        HEAP_DATA_VIEW.setInt8(copied, 1, true);
                    }
                    if (finalize_callback) {
                        envObject.callFinalizer(finalize_callback, str, finalize_hint);
                    }
                }
                return status;
            }
        };
        /**
         * @__sig ippp
         */
        function napi_get_array_length(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isArray()) {
                    return envObject.setLastError(8 /* napi_status.napi_array_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = handle.value.length >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_get_arraybuffer_info(env, arraybuffer, data, byte_length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(arraybuffer);
            if (!handle.isArrayBuffer()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(handle.value, true).address;
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, handle.value.byteLength, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_prototype(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = handle.isObject() || handle.isFunction() ? handle.value : Object(handle.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = envObject.ensureHandleId(Object.getPrototypeOf(v));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, p, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppppp
         */
        function napi_get_typedarray_info(env, typedarray, type, length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!typedarray)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(typedarray);
            if (!handle.isTypedArray()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (type) {
                var t = void 0;
                if (v instanceof Int8Array) {
                    t = 0 /* napi_typedarray_type.napi_int8_array */;
                }
                else if (v instanceof Uint8Array) {
                    t = 1 /* napi_typedarray_type.napi_uint8_array */;
                }
                else if (v instanceof Uint8ClampedArray) {
                    t = 2 /* napi_typedarray_type.napi_uint8_clamped_array */;
                }
                else if (v instanceof Int16Array) {
                    t = 3 /* napi_typedarray_type.napi_int16_array */;
                }
                else if (v instanceof Uint16Array) {
                    t = 4 /* napi_typedarray_type.napi_uint16_array */;
                }
                else if (v instanceof Int32Array) {
                    t = 5 /* napi_typedarray_type.napi_int32_array */;
                }
                else if (v instanceof Uint32Array) {
                    t = 6 /* napi_typedarray_type.napi_uint32_array */;
                }
                else if (v instanceof Float32Array) {
                    t = 7 /* napi_typedarray_type.napi_float32_array */;
                }
                else if (v instanceof Float64Array) {
                    t = 8 /* napi_typedarray_type.napi_float64_array */;
                }
                else if (v instanceof BigInt64Array) {
                    t = 9 /* napi_typedarray_type.napi_bigint64_array */;
                }
                else if (v instanceof BigUint64Array) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    t = 10 /* napi_typedarray_type.napi_biguint64_array */;
                }
                else {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                HEAP_DATA_VIEW.setInt32(type, t, true);
            }
            if (length) {
                HEAP_DATA_VIEW.setUint32(length, v.length, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_buffer_info(env, buffer, data, length) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!buffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(buffer);
            if (!handle.isBuffer())
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            return napi_get_typedarray_info(env, buffer, 0, length, data, 0, 0);
        }
        /**
         * @__sig ipppppp
         */
        function napi_get_dataview_info(env, dataview, byte_length, data, arraybuffer, byte_offset) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!dataview)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(dataview);
            if (!handle.isDataView()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var v = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (byte_length) {
                HEAP_DATA_VIEW.setUint32(byte_length, v.byteLength, true);
            }
            var buffer;
            if (data || arraybuffer) {
                buffer = v.buffer;
                if (data) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var p = emnapiExternalMemory.getViewPointer(v, true).address;
                    HEAP_DATA_VIEW.setInt32(data, p, true);
                }
                if (arraybuffer) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var ab = envObject.ensureHandleId(buffer);
                    HEAP_DATA_VIEW.setInt32(arraybuffer, ab, true);
                }
            }
            if (byte_offset) {
                HEAP_DATA_VIEW.setUint32(byte_offset, v.byteOffset, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_date_value(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (!handle.isDate()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                v = handle.value.valueOf();
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setFloat64(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_bool(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'boolean') {
                return envObject.setLastError(7 /* napi_status.napi_boolean_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setFloat64(result, r, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_int64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= (BigInt(-1) * (BigInt(1) << BigInt(63)))) && (numberValue < (BigInt(1) << BigInt(63)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                if (numberValue >= (BigInt(1) << BigInt(63))) {
                    numberValue = numberValue - (BigInt(1) << BigInt(64));
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setInt32(result, low, true);
            HEAP_DATA_VIEW.setInt32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_get_value_bigint_uint64(env, value, result, lossless) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!lossless)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            var numberValue = handle.value;
            if (typeof numberValue !== 'bigint') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if ((numberValue >= BigInt(0)) && (numberValue < (BigInt(1) << BigInt(64)))) {
                HEAP_DATA_VIEW.setInt8(lossless, 1, true);
            }
            else {
                HEAP_DATA_VIEW.setInt8(lossless, 0, true);
                numberValue = numberValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var low = Number(numberValue & BigInt(0xffffffff));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var high = Number(numberValue >> BigInt(32));
            HEAP_DATA_VIEW.setUint32(result, low, true);
            HEAP_DATA_VIEW.setUint32(result + 4, high, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_bigint_words(env, value, sign_bit, word_count, words) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!word_count)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isBigInt()) {
                return envObject.setLastError(17 /* napi_status.napi_bigint_expected */);
            }
            var isMinus = handle.value < BigInt(0);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            var word_count_int = HEAP_DATA_VIEW.getUint32(word_count, true);
            var wordCount = 0;
            var bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            while (bigintValue !== BigInt(0)) {
                wordCount++;
                bigintValue = bigintValue >> BigInt(64);
            }
            bigintValue = isMinus ? (handle.value * BigInt(-1)) : handle.value;
            if (!sign_bit && !words) {
                word_count_int = wordCount;
                HEAP_DATA_VIEW.setUint32(word_count, word_count_int, true);
            }
            else {
                if (!sign_bit)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!words)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var wordsArr = [];
                while (bigintValue !== BigInt(0)) {
                    var uint64 = bigintValue & ((BigInt(1) << BigInt(64)) - BigInt(1));
                    wordsArr.push(uint64);
                    bigintValue = bigintValue >> BigInt(64);
                }
                var len = Math.min(word_count_int, wordsArr.length);
                for (var i = 0; i < len; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var low = Number(wordsArr[i] & BigInt(0xffffffff));
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var high = Number(wordsArr[i] >> BigInt(32));
                    HEAP_DATA_VIEW.setUint32(words + i * 8, low, true);
                    HEAP_DATA_VIEW.setUint32(words + i * 8 + 4, high, true);
                }
                HEAP_DATA_VIEW.setInt32(sign_bit, isMinus ? 1 : 0, true);
                HEAP_DATA_VIEW.setUint32(word_count, len, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_external(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (!handle.isExternal()) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p = handle.data(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, p, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Int32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_int64(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            var numberValue = handle.value;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (numberValue === Number.POSITIVE_INFINITY || numberValue === Number.NEGATIVE_INFINITY || isNaN(numberValue)) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 0, true);
            }
            else if (numberValue < /* INT64_RANGE_NEGATIVE */ -9223372036854776000) {
                HEAP_DATA_VIEW.setInt32(result, 0, true);
                HEAP_DATA_VIEW.setInt32(result + 4, 0x80000000, true);
            }
            else if (numberValue >= /* INT64_RANGE_POSITIVE */ 9223372036854776000) {
                HEAP_DATA_VIEW.setUint32(result, 0xffffffff, true);
                HEAP_DATA_VIEW.setUint32(result + 4, 0x7fffffff, true);
            }
            else {
                $emnapiSetValueI64(result, Math.trunc(numberValue));
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_latin1(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                var copied = 0;
                var v = void 0;
                for (var i = 0; i < buf_size - 1; ++i) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    v = handle.value.charCodeAt(i) & 0xff;
                    HEAP_DATA_VIEW.setUint8(buf + i, v, true);
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    copied++;
                }
                HEAP_DATA_VIEW.setUint8(buf + copied, 0, true);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf8(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var strLength = emnapiString.lengthBytesUTF8(handle.value);
                HEAP_DATA_VIEW.setUint32(result, strLength, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF8(handle.value, buf, buf_size);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippppp
         */
        function napi_get_value_string_utf16(env, value, buf, buf_size, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            buf_size = buf_size >>> 0;
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!buf) {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                HEAP_DATA_VIEW.setUint32(result, handle.value.length, true);
            }
            else if (buf_size !== 0) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var copied = emnapiString.stringToUTF16(handle.value, buf, buf_size * 2);
                if (result) {
                    HEAP_DATA_VIEW.setUint32(result, copied / 2, true);
                }
            }
            else if (result) {
                HEAP_DATA_VIEW.setUint32(result, 0, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_get_value_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (typeof handle.value !== 'number') {
                return envObject.setLastError(6 /* napi_status.napi_number_expected */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = new Uint32Array([handle.value])[0];
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, v, true);
            return envObject.clearLastError();
        }
        var convert2cMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_array_length: napi_get_array_length,
            napi_get_arraybuffer_info: napi_get_arraybuffer_info,
            napi_get_buffer_info: napi_get_buffer_info,
            napi_get_dataview_info: napi_get_dataview_info,
            napi_get_date_value: napi_get_date_value,
            napi_get_prototype: napi_get_prototype,
            napi_get_typedarray_info: napi_get_typedarray_info,
            napi_get_value_bigint_int64: napi_get_value_bigint_int64,
            napi_get_value_bigint_uint64: napi_get_value_bigint_uint64,
            napi_get_value_bigint_words: napi_get_value_bigint_words,
            napi_get_value_bool: napi_get_value_bool,
            napi_get_value_double: napi_get_value_double,
            napi_get_value_external: napi_get_value_external,
            napi_get_value_int32: napi_get_value_int32,
            napi_get_value_int64: napi_get_value_int64,
            napi_get_value_string_latin1: napi_get_value_string_latin1,
            napi_get_value_string_utf16: napi_get_value_string_utf16,
            napi_get_value_string_utf8: napi_get_value_string_utf8,
            napi_get_value_uint32: napi_get_value_uint32
        });
        /**
         * @__sig ipip
         */
        function napi_create_int32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipip
         */
        function napi_create_uint32(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value >>> 0).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = Number(low);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipdp
         */
        function napi_create_double(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_latin1(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str, autoLength, sizeLength) {
                var latin1String = '';
                var len = 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (autoLength) {
                    while (true) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        str++;
                    }
                }
                else {
                    while (len < sizeLength) {
                        var ch = HEAP_DATA_VIEW.getUint8(str, true);
                        if (!ch)
                            break;
                        latin1String += String.fromCharCode(ch);
                        len++;
                        str++;
                    }
                }
                return latin1String;
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf16(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF16ToString(str, length);
            });
        }
        /**
         * @__sig ipppp
         */
        function napi_create_string_utf8(env, str, length, result) {
            return emnapiString.newString(env, str, length, result, function (str) {
                return emnapiString.UTF8ToString(str, length);
            });
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_latin1(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_latin1, undefined);
        }
        /**
         * @__sig ippppppp
         */
        function node_api_create_external_string_utf16(env, str, length, finalize_callback, finalize_hint, result, copied) {
            return emnapiString.newExternalString(env, str, length, finalize_callback, finalize_hint, result, copied, napi_create_string_utf16, undefined);
        }
        /**
         * @__sig ipppp
         */
        function node_api_create_property_key_utf16(env, str, length, result) {
            return napi_create_string_utf16(env, str, length, result);
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_int64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipjp
         */
        function napi_create_bigint_uint64(env, low, high, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportBigInt) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            var value;
            if (!high)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            value = low & ((BigInt(1) << BigInt(64)) - BigInt(1));
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v1 = emnapiCtx.addToCurrentScope(value).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(high, v1, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ipippp
         */
        function napi_create_bigint_words(env, sign_bit, word_count, words, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v, i;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportBigInt) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                word_count = word_count >>> 0;
                if (word_count > 2147483647) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (word_count > (1024 * 1024 / (4 * 8) / 2)) {
                    throw new RangeError('Maximum BigInt size exceeded');
                }
                var value = BigInt(0);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (i = 0; i < word_count; i++) {
                    var low = HEAP_DATA_VIEW.getUint32(words + i * 8, true);
                    var high = HEAP_DATA_VIEW.getUint32(words + i * 8 + 4, true);
                    var wordi = BigInt(low) | (BigInt(high) << BigInt(32));
                    value += wordi << BigInt(64 * i);
                }
                value *= ((BigInt(sign_bit) % BigInt(2) === BigInt(0)) ? BigInt(1) : BigInt(-1));
                v = emnapiCtx.addToCurrentScope(value).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var convert2napiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_bigint_int64: napi_create_bigint_int64,
            napi_create_bigint_uint64: napi_create_bigint_uint64,
            napi_create_bigint_words: napi_create_bigint_words,
            napi_create_double: napi_create_double,
            napi_create_int32: napi_create_int32,
            napi_create_int64: napi_create_int64,
            napi_create_string_latin1: napi_create_string_latin1,
            napi_create_string_utf16: napi_create_string_utf16,
            napi_create_string_utf8: napi_create_string_utf8,
            napi_create_uint32: napi_create_uint32,
            node_api_create_external_string_latin1: node_api_create_external_string_latin1,
            node_api_create_external_string_utf16: node_api_create_external_string_utf16,
            node_api_create_property_key_utf16: node_api_create_property_key_utf16
        });
        function emnapiCreateFunction(envObject, utf8name, length, cb, data) {
            var functionName = (!utf8name || !length) ? '' : (emnapiString.UTF8ToString(utf8name, length));
            var f;
            var makeFunction = function () {
                return function () {
                    var cbinfo = emnapiCtx.cbinfoStack.push(this, data, arguments, f);
                    var scope = emnapiCtx.openScope(envObject);
                    try {
                        return envObject.callIntoModule(function (envObject) {
                            var napiValue = (wasmTable.get(cb))(envObject.id, cbinfo);
                            return (!napiValue) ? undefined : emnapiCtx.handleStore.get(napiValue).value;
                        });
                    }
                    finally {
                        emnapiCtx.cbinfoStack.pop();
                        emnapiCtx.closeScope(envObject, scope);
                    }
                };
            };
            if (functionName === '') {
                f = makeFunction();
                return { status: 0 /* napi_status.napi_ok */, f: f };
            }
            if (!(/^[_$a-zA-Z][_$a-zA-Z0-9]*$/.test(functionName))) {
                return { status: 1 /* napi_status.napi_invalid_arg */, f: undefined };
            }
            if (emnapiCtx.feature.supportNewFunction) {
                var _ = makeFunction();
                try {
                    f = (new Function('_', 'return function ' + functionName + '(){' +
                        '"use strict";' +
                        'return _.apply(this,arguments);' +
                        '};'))(_);
                }
                catch (_err) {
                    f = makeFunction();
                    if (emnapiCtx.feature.canSetFunctionName)
                        Object.defineProperty(f, 'name', { value: functionName });
                }
            }
            else {
                f = makeFunction();
                if (emnapiCtx.feature.canSetFunctionName)
                    Object.defineProperty(f, 'name', { value: functionName });
            }
            return { status: 0 /* napi_status.napi_ok */, f: f };
        }
        function emnapiDefineProperty(envObject, obj, propertyName, method, getter, setter, value, attributes, data) {
            if (getter || setter) {
                var localGetter = void 0;
                var localSetter = void 0;
                if (getter) {
                    localGetter = emnapiCreateFunction(envObject, 0, 0, getter, data).f;
                }
                if (setter) {
                    localSetter = emnapiCreateFunction(envObject, 0, 0, setter, data).f;
                }
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    get: localGetter,
                    set: localSetter
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else if (method) {
                var localMethod = emnapiCreateFunction(envObject, 0, 0, method, data).f;
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: localMethod
                };
                Object.defineProperty(obj, propertyName, desc);
            }
            else {
                var desc = {
                    configurable: (attributes & 4 /* napi_property_attributes.napi_configurable */) !== 0,
                    enumerable: (attributes & 2 /* napi_property_attributes.napi_enumerable */) !== 0,
                    writable: (attributes & 1 /* napi_property_attributes.napi_writable */) !== 0,
                    value: emnapiCtx.handleStore.get(value).value
                };
                Object.defineProperty(obj, propertyName, desc);
            }
        }
        function emnapiGetHandle(js_object) {
            var handle = emnapiCtx.handleStore.get(js_object);
            if (!(handle.isObject() || handle.isFunction())) {
                return { status: 1 /* napi_status.napi_invalid_arg */ };
            }
            if (typeof emnapiExternalMemory !== 'undefined' && ArrayBuffer.isView(handle.value)) {
                if (emnapiExternalMemory.wasmMemoryViewTable.has(handle.value)) {
                    handle = emnapiCtx.addToCurrentScope(emnapiExternalMemory.wasmMemoryViewTable.get(handle.value));
                }
            }
            return { status: 0 /* napi_status.napi_ok */, handle: handle };
        }
        function emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var referenceId;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!emnapiCtx.feature.supportFinalizer) {
                    if (finalize_cb) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "finalize_cb" must be 0(NULL)');
                    }
                    if (result) {
                        throw emnapiCtx.createNotSupportWeakRefError('napi_wrap', 'Parameter "result" must be 0(NULL)');
                    }
                }
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handleResult = emnapiGetHandle(js_object);
                if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                    return envObject.setLastError(handleResult.status);
                }
                var handle = handleResult.handle;
                if (envObject.getObjectBinding(handle.value).wrapped !== 0) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var reference = void 0;
                if (result) {
                    if (!finalize_cb)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                    reference = emnapiCtx.createReference(envObject, handle.id, 0, 1 /* Ownership.kUserland */, finalize_cb, native_object, finalize_hint);
                    referenceId = reference.id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, referenceId, true);
                }
                else {
                    reference = emnapiCtx.createReference(envObject, handle.id, 0, 0 /* Ownership.kRuntime */, finalize_cb, native_object, !finalize_cb ? finalize_cb : finalize_hint);
                }
                envObject.getObjectBinding(handle.value).wrapped = reference.id;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function emnapiUnwrap(env, js_object, result, action) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var data;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!js_object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (action === 0 /* UnwrapAction.KeepWrap */) {
                    if (!result)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(js_object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                var referenceId = binding.wrapped;
                var ref = emnapiCtx.refStore.get(referenceId);
                if (!ref)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (result) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    data = ref.data();
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, data, true);
                }
                if (action === 1 /* UnwrapAction.RemoveWrap */) {
                    binding.wrapped = 0;
                    if (ref.ownership() === 1 /* Ownership.kUserland */) {
                        // When the wrap is been removed, the finalizer should be reset.
                        ref.resetFinalizer();
                    }
                    else {
                        ref.dispose();
                    }
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppppp
         */
        function napi_define_class(env, utf8name, length, constructor, callback_data, property_count, properties, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, valueHandleId, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if ((length < -1) || (length > 2147483647) || (!utf8name)) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var fresult = emnapiCreateFunction(envObject, utf8name, length, constructor, callback_data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var F = fresult.f;
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_1 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_1) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_1).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    if ((attributes & 1024 /* napi_property_attributes.napi_static */) !== 0) {
                        emnapiDefineProperty(envObject, F, propertyName, method, getter, setter, value, attributes, data);
                        continue;
                    }
                    emnapiDefineProperty(envObject, F.prototype, propertyName, method, getter, setter, value, attributes, data);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var valueHandle = emnapiCtx.addToCurrentScope(F);
                valueHandleId = valueHandle.id;
                HEAP_DATA_VIEW.setInt32(result, valueHandleId, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_wrap(env, js_object, native_object, finalize_cb, finalize_hint, result) {
            return emnapiWrap(env, js_object, native_object, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippp
         */
        function napi_unwrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 0 /* UnwrapAction.KeepWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_remove_wrap(env, js_object, result) {
            return emnapiUnwrap(env, js_object, result, 1 /* UnwrapAction.RemoveWrap */);
        }
        /**
         * @__sig ippp
         */
        function napi_type_tag_object(env, object, type_tag) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var tag = new Uint8Array(16);
                tag.set(new Uint8Array(wasmMemory.buffer, type_tag, 16));
                binding.tag = new Uint32Array(tag.buffer);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function napi_check_object_type_tag(env, object, type_tag, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars, one-var
            var ret = true;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var value = emnapiCtx.handleStore.get(object);
                if (!(value.isObject() || value.isFunction())) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 2 /* napi_status.napi_object_expected */);
                }
                if (!type_tag) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                if (!result) {
                    return envObject.setLastError(envObject.tryCatch.hasCaught() ? 10 /* napi_status.napi_pending_exception */ : 1 /* napi_status.napi_invalid_arg */);
                }
                var binding = envObject.getObjectBinding(value.value);
                if (binding.tag !== null) {
                    var tag = binding.tag;
                    var typeTag = new Uint32Array(wasmMemory.buffer, type_tag, 4);
                    ret = (tag[0] === typeTag[0] &&
                        tag[1] === typeTag[1] &&
                        tag[2] === typeTag[2] &&
                        tag[3] === typeTag[3]);
                }
                else {
                    ret = false;
                }
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, ret ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_add_finalizer(env, js_object, finalize_data, finalize_cb, finalize_hint, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!emnapiCtx.feature.supportFinalizer) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            if (!js_object)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!finalize_cb)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handleResult = emnapiGetHandle(js_object);
            if (handleResult.status !== 0 /* napi_status.napi_ok */) {
                return envObject.setLastError(handleResult.status);
            }
            var handle = handleResult.handle;
            var ownership = !result ? 0 /* Ownership.kRuntime */ : 1 /* Ownership.kUserland */;
            var reference = emnapiCtx.createReference(envObject, handle.id, 0, ownership, finalize_cb, finalize_data, finalize_hint);
            if (result) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var referenceId = reference.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, referenceId, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipppp
         */
        function node_api_post_finalizer(env, finalize_cb, finalize_data, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.enqueueFinalizer(emnapiCtx.createTrackedFinalizer(envObject, finalize_cb, finalize_data, finalize_hint));
            return envObject.clearLastError();
        }
        var wrapMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_add_finalizer: napi_add_finalizer,
            napi_check_object_type_tag: napi_check_object_type_tag,
            napi_define_class: napi_define_class,
            napi_remove_wrap: napi_remove_wrap,
            napi_type_tag_object: napi_type_tag_object,
            napi_unwrap: napi_unwrap,
            napi_wrap: napi_wrap,
            node_api_post_finalizer: node_api_post_finalizer
        });
        /**
         * @__sig ipippppp
         */
        function emnapi_create_memory_view(env, typedarray_type, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if (byte_length > 2147483647) {
                    throw new RangeError('Cannot create a memory view larger than 2147483647 bytes');
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('emnapi_create_memory_view', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var viewDescriptor = void 0;
                switch (typedarray_type) {
                    case 0 /* emnapi_memory_view_type.emnapi_int8_array */:
                        viewDescriptor = { Ctor: Int8Array, address: external_data, length: byte_length, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 1 /* emnapi_memory_view_type.emnapi_uint8_array */:
                        viewDescriptor = { Ctor: Uint8Array, address: external_data, length: byte_length, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 2 /* emnapi_memory_view_type.emnapi_uint8_clamped_array */:
                        viewDescriptor = { Ctor: Uint8ClampedArray, address: external_data, length: byte_length, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 3 /* emnapi_memory_view_type.emnapi_int16_array */:
                        viewDescriptor = { Ctor: Int16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 4 /* emnapi_memory_view_type.emnapi_uint16_array */:
                        viewDescriptor = { Ctor: Uint16Array, address: external_data, length: byte_length >> 1, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 5 /* emnapi_memory_view_type.emnapi_int32_array */:
                        viewDescriptor = { Ctor: Int32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 6 /* emnapi_memory_view_type.emnapi_uint32_array */:
                        viewDescriptor = { Ctor: Uint32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 7 /* emnapi_memory_view_type.emnapi_float32_array */:
                        viewDescriptor = { Ctor: Float32Array, address: external_data, length: byte_length >> 2, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 8 /* emnapi_memory_view_type.emnapi_float64_array */:
                        viewDescriptor = { Ctor: Float64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 9 /* emnapi_memory_view_type.emnapi_bigint64_array */:
                        viewDescriptor = { Ctor: BigInt64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case 10 /* emnapi_memory_view_type.emnapi_biguint64_array */:
                        viewDescriptor = { Ctor: BigUint64Array, address: external_data, length: byte_length >> 3, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -1 /* emnapi_memory_view_type.emnapi_data_view */:
                        viewDescriptor = { Ctor: DataView, address: external_data, length: byte_length, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    case -2 /* emnapi_memory_view_type.emnapi_buffer */: {
                        if (!emnapiCtx.feature.Buffer) {
                            throw emnapiCtx.createNotSupportBufferError('emnapi_create_memory_view', '');
                        }
                        viewDescriptor = { Ctor: emnapiCtx.feature.Buffer, address: external_data, length: byte_length, ownership: 1 /* Ownership.kUserland */, runtimeAllocated: 0 };
                        break;
                    }
                    default: return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var Ctor = viewDescriptor.Ctor;
                var typedArray = typedarray_type === -2 /* emnapi_memory_view_type.emnapi_buffer */
                    ? emnapiCtx.feature.Buffer.from(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length)
                    : new Ctor(wasmMemory.buffer, viewDescriptor.address, viewDescriptor.length);
                var handle = emnapiCtx.addToCurrentScope(typedArray);
                emnapiExternalMemory.wasmMemoryViewTable.set(typedArray, viewDescriptor);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_weakref() {
            return emnapiCtx.feature.supportFinalizer ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_support_bigint() {
            return emnapiCtx.feature.supportBigInt ? 1 : 0;
        }
        /**
         * @__sig i
         */
        function emnapi_is_node_binding_available() {
            return emnapiNodeBinding ? 1 : 0;
        }
        function $emnapiSyncMemory(js_to_wasm, arrayBufferOrView, offset, len) {
            offset = offset !== null && offset !== void 0 ? offset : 0;
            offset = offset >>> 0;
            var view;
            if (arrayBufferOrView instanceof ArrayBuffer) {
                var pointer = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false).address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = arrayBufferOrView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return arrayBufferOrView;
                view = new Uint8Array(arrayBufferOrView, offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return arrayBufferOrView;
            }
            if (ArrayBuffer.isView(arrayBufferOrView)) {
                var viewPointerInfo = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
                var latestView = viewPointerInfo.view;
                var pointer = viewPointerInfo.address;
                if (!pointer)
                    throw new Error('Unknown ArrayBuffer address');
                if (typeof len !== 'number' || len === -1) {
                    len = latestView.byteLength - offset;
                }
                len = len >>> 0;
                if (len === 0)
                    return latestView;
                view = new Uint8Array(latestView.buffer, latestView.byteOffset + offset, len);
                var wasmMemoryU8 = new Uint8Array(wasmMemory.buffer);
                if (!js_to_wasm) {
                    view.set(wasmMemoryU8.subarray(pointer, pointer + len));
                }
                else {
                    wasmMemoryU8.set(view, pointer);
                }
                return latestView;
            }
            throw new TypeError('emnapiSyncMemory expect ArrayBuffer or ArrayBufferView as first parameter');
        }
        /**
         * @__sig ipippp
         */
        function emnapi_sync_memory(env, js_to_wasm, arraybuffer_or_view, offset, len) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var handleId = HEAP_DATA_VIEW.getInt32(arraybuffer_or_view, true);
                var handle = envObject.ctx.handleStore.get(handleId);
                if (!handle.isArrayBuffer() && !handle.isTypedArray() && !handle.isDataView()) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var ret = $emnapiSyncMemory(Boolean(js_to_wasm), handle.value, offset, len);
                if (handle.value !== ret) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(arraybuffer_or_view, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        function $emnapiGetMemoryAddress(arrayBufferOrView) {
            var isArrayBuffer = arrayBufferOrView instanceof ArrayBuffer;
            var isDataView = arrayBufferOrView instanceof DataView;
            var isTypedArray = ArrayBuffer.isView(arrayBufferOrView) && !isDataView;
            if (!isArrayBuffer && !isTypedArray && !isDataView) {
                throw new TypeError('emnapiGetMemoryAddress expect ArrayBuffer or ArrayBufferView as first parameter');
            }
            var info;
            if (isArrayBuffer) {
                info = emnapiExternalMemory.getArrayBufferPointer(arrayBufferOrView, false);
            }
            else {
                info = emnapiExternalMemory.getViewPointer(arrayBufferOrView, false);
            }
            return {
                address: info.address,
                ownership: info.ownership,
                runtimeAllocated: info.runtimeAllocated
            };
        }
        /**
         * @__sig ipppp
         */
        function emnapi_get_memory_address(env, arraybuffer_or_view, address, ownership, runtime_allocated) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var p, runtimeAllocated, ownershipOut;
            var info;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer_or_view)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!address && !ownership && !runtime_allocated) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var handle = envObject.ctx.handleStore.get(arraybuffer_or_view);
                info = $emnapiGetMemoryAddress(handle.value);
                p = info.address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (address) {
                    HEAP_DATA_VIEW.setInt32(address, p, true);
                }
                if (ownership) {
                    ownershipOut = info.ownership;
                    HEAP_DATA_VIEW.setInt32(ownership, ownershipOut, true);
                }
                if (runtime_allocated) {
                    runtimeAllocated = info.runtimeAllocated;
                    HEAP_DATA_VIEW.setInt8(runtime_allocated, runtimeAllocated, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function emnapi_get_runtime_version(env, version) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!version)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var runtimeVersion;
            try {
                runtimeVersion = emnapiCtx.getRuntimeVersions().version;
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var versions = runtimeVersion.split('.')
                .map(function (n) { return Number(n); });
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(version, versions[0], true);
            HEAP_DATA_VIEW.setUint32(version + 4, versions[1], true);
            HEAP_DATA_VIEW.setUint32(version + 8, versions[2], true);
            return envObject.clearLastError();
        }
        var emnapiMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            $emnapiGetMemoryAddress: $emnapiGetMemoryAddress,
            $emnapiSyncMemory: $emnapiSyncMemory,
            emnapi_create_memory_view: emnapi_create_memory_view,
            emnapi_get_memory_address: emnapi_get_memory_address,
            emnapi_get_runtime_version: emnapi_get_runtime_version,
            emnapi_is_node_binding_available: emnapi_is_node_binding_available,
            emnapi_is_support_bigint: emnapi_is_support_bigint,
            emnapi_is_support_weakref: emnapi_is_support_weakref,
            emnapi_sync_memory: emnapi_sync_memory
        });
        /**
         * @__sig ipp
         */
        function napi_create_array(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope([]).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_array_with_length(env, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            length = length >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(new Array(length)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        function emnapiCreateArrayBuffer(byte_length, data) {
            byte_length = byte_length >>> 0;
            var arrayBuffer = new ArrayBuffer(byte_length);
            if (data) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var p = emnapiExternalMemory.getArrayBufferPointer(arrayBuffer, true).address;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(data, p, true);
            }
            return arrayBuffer;
        }
        /**
         * @__sig ipppp
         */
        function napi_create_arraybuffer(env, byte_length, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var arrayBuffer = emnapiCreateArrayBuffer(byte_length, data);
                value = emnapiCtx.addToCurrentScope(arrayBuffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipdp
         */
        function napi_create_date(env, time, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(new Date(time)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_external(env, data, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var externalHandle = emnapiCtx.getCurrentScope().addExternal(envObject, data);
                if (finalize_cb) {
                    emnapiCtx.createReference(envObject, externalHandle.id, 0, 0 /* Ownership.kRuntime */, finalize_cb, data, finalize_hint);
                }
                value = externalHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_arraybuffer(env, external_data, byte_length, finalize_cb, finalize_hint, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                if (!external_data) {
                    byte_length = 0;
                }
                if ((external_data + byte_length) > wasmMemory.buffer.byteLength) {
                    throw new RangeError('Memory out of range');
                }
                if (!emnapiCtx.feature.supportFinalizer && finalize_cb) {
                    throw emnapiCtx.createNotSupportWeakRefError('napi_create_external_arraybuffer', 'Parameter "finalize_cb" must be 0(NULL)');
                }
                var arrayBuffer = new ArrayBuffer(byte_length);
                if (byte_length === 0) {
                    try {
                        var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                        var messageChannel = new MessageChannel_1();
                        messageChannel.port1.postMessage(arrayBuffer, [arrayBuffer]);
                    }
                    catch (_) { }
                }
                else {
                    var u8arr = new Uint8Array(arrayBuffer);
                    u8arr.set(new Uint8Array(wasmMemory.buffer).subarray(external_data, external_data + byte_length));
                    emnapiExternalMemory.table.set(arrayBuffer, {
                        address: external_data,
                        ownership: 1 /* Ownership.kUserland */,
                        runtimeAllocated: 0
                    });
                }
                var handle = emnapiCtx.addToCurrentScope(arrayBuffer);
                if (finalize_cb) {
                    var status_1 = napi_add_finalizer(env, handle.id, external_data, finalize_cb, finalize_hint, /* NULL */ 0);
                    if (status_1 === 10 /* napi_status.napi_pending_exception */) {
                        var err = envObject.tryCatch.extractException();
                        envObject.clearLastError();
                        throw err;
                    }
                    else if (status_1 !== 0 /* napi_status.napi_ok */) {
                        return envObject.setLastError(status_1);
                    }
                }
                value = handle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipp
         */
        function napi_create_object(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope({}).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /**
         * @__sig ippp
         */
        function napi_create_symbol(env, description, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!description) {
                // eslint-disable-next-line symbol-description, @typescript-eslint/no-unused-vars
                var value = emnapiCtx.addToCurrentScope(Symbol()).id;
                HEAP_DATA_VIEW.setInt32(result, value, true);
            }
            else {
                var handle = emnapiCtx.handleStore.get(description);
                var desc = handle.value;
                if (typeof desc !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = emnapiCtx.addToCurrentScope(Symbol(desc)).id;
                HEAP_DATA_VIEW.setInt32(result, v, true);
            }
            return envObject.clearLastError();
        }
        /**
         * @__sig ipipppp
         */
        function napi_create_typedarray(env, type, length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                var buffer = handle.value;
                if (!(buffer instanceof ArrayBuffer)) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var createTypedArray = function (envObject, Type, size_of_element, buffer, byte_offset, length) {
                    var _a;
                    byte_offset = byte_offset >>> 0;
                    length = length >>> 0;
                    if (size_of_element > 1) {
                        if ((byte_offset) % (size_of_element) !== 0) {
                            var err = new RangeError("start offset of ".concat((_a = Type.name) !== null && _a !== void 0 ? _a : '', " should be a multiple of ").concat(size_of_element));
                            err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_ALIGNMENT';
                            envObject.tryCatch.setError(err);
                            return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                        }
                    }
                    if (((length * size_of_element) + byte_offset) > buffer.byteLength) {
                        var err = new RangeError('Invalid typed array length');
                        err.code = 'ERR_NAPI_INVALID_TYPEDARRAY_LENGTH';
                        envObject.tryCatch.setError(err);
                        return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                    }
                    var out = new Type(buffer, byte_offset, length);
                    if (buffer === wasmMemory.buffer) {
                        if (!emnapiExternalMemory.wasmMemoryViewTable.has(out)) {
                            emnapiExternalMemory.wasmMemoryViewTable.set(out, {
                                Ctor: Type,
                                address: byte_offset,
                                length: length,
                                ownership: 1 /* Ownership.kUserland */,
                                runtimeAllocated: 0
                            });
                        }
                    }
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    value = emnapiCtx.addToCurrentScope(out).id;
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    return envObject.getReturnStatus();
                };
                switch (type) {
                    case 0 /* napi_typedarray_type.napi_int8_array */:
                        return createTypedArray(envObject, Int8Array, 1, buffer, byte_offset, length);
                    case 1 /* napi_typedarray_type.napi_uint8_array */:
                        return createTypedArray(envObject, Uint8Array, 1, buffer, byte_offset, length);
                    case 2 /* napi_typedarray_type.napi_uint8_clamped_array */:
                        return createTypedArray(envObject, Uint8ClampedArray, 1, buffer, byte_offset, length);
                    case 3 /* napi_typedarray_type.napi_int16_array */:
                        return createTypedArray(envObject, Int16Array, 2, buffer, byte_offset, length);
                    case 4 /* napi_typedarray_type.napi_uint16_array */:
                        return createTypedArray(envObject, Uint16Array, 2, buffer, byte_offset, length);
                    case 5 /* napi_typedarray_type.napi_int32_array */:
                        return createTypedArray(envObject, Int32Array, 4, buffer, byte_offset, length);
                    case 6 /* napi_typedarray_type.napi_uint32_array */:
                        return createTypedArray(envObject, Uint32Array, 4, buffer, byte_offset, length);
                    case 7 /* napi_typedarray_type.napi_float32_array */:
                        return createTypedArray(envObject, Float32Array, 4, buffer, byte_offset, length);
                    case 8 /* napi_typedarray_type.napi_float64_array */:
                        return createTypedArray(envObject, Float64Array, 8, buffer, byte_offset, length);
                    case 9 /* napi_typedarray_type.napi_bigint64_array */:
                        return createTypedArray(envObject, BigInt64Array, 8, buffer, byte_offset, length);
                    case 10 /* napi_typedarray_type.napi_biguint64_array */:
                        return createTypedArray(envObject, BigUint64Array, 8, buffer, byte_offset, length);
                    default:
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__deps malloc
         * @__sig ippp
         */
        function napi_create_buffer(env, size, data, result) {
            var _a;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value, pointer;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer', '');
                }
                var buffer = void 0;
                size = size >>> 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (!data || (size === 0)) {
                    buffer = Buffer.alloc(size);
                    value = emnapiCtx.addToCurrentScope(buffer).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                }
                else {
                    pointer = _malloc(size);
                    if (!pointer)
                        throw new Error('Out of memory');
                    new Uint8Array(wasmMemory.buffer).subarray(pointer, pointer + size).fill(0);
                    var buffer_1 = Buffer.from(wasmMemory.buffer, pointer, size);
                    var viewDescriptor = {
                        Ctor: Buffer,
                        address: pointer,
                        length: size,
                        ownership: emnapiExternalMemory.registry ? 0 /* Ownership.kRuntime */ : 1 /* Ownership.kUserland */,
                        runtimeAllocated: 1
                    };
                    emnapiExternalMemory.wasmMemoryViewTable.set(buffer_1, viewDescriptor);
                    (_a = emnapiExternalMemory.registry) === null || _a === void 0 ? void 0 : _a.register(viewDescriptor, pointer);
                    value = emnapiCtx.addToCurrentScope(buffer_1).id;
                    HEAP_DATA_VIEW.setInt32(result, value, true);
                    HEAP_DATA_VIEW.setInt32(data, pointer, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ippppp
         */
        function napi_create_buffer_copy(env, length, data, result_data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Buffer = emnapiCtx.feature.Buffer;
                if (!Buffer) {
                    throw emnapiCtx.createNotSupportBufferError('napi_create_buffer_copy', '');
                }
                var arrayBuffer = emnapiCreateArrayBuffer(length, result_data);
                var buffer = Buffer.from(arrayBuffer);
                buffer.set(new Uint8Array(wasmMemory.buffer).subarray(data, data + length));
                value = emnapiCtx.addToCurrentScope(buffer).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppppp
         */
        function napi_create_external_buffer(env, length, data, finalize_cb, finalize_hint, result) {
            return emnapi_create_memory_view(env, -2 /* emnapi_memory_view_type.emnapi_buffer */, data, length, finalize_cb, finalize_hint, result);
        }
        /**
         * @__sig ippppp
         */
        function napi_create_dataview(env, byte_length, arraybuffer, byte_offset, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                byte_length = byte_length >>> 0;
                byte_offset = byte_offset >>> 0;
                var handle = emnapiCtx.handleStore.get(arraybuffer);
                var buffer = handle.value;
                if (!(buffer instanceof ArrayBuffer)) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if ((byte_length + byte_offset) > buffer.byteLength) {
                    var err = new RangeError('byte_offset + byte_length should be less than or equal to the size in bytes of the array passed in');
                    err.code = 'ERR_NAPI_INVALID_DATAVIEW_ARGS';
                    throw err;
                }
                var dataview = new DataView(buffer, byte_offset, byte_length);
                if (buffer === wasmMemory.buffer) {
                    if (!emnapiExternalMemory.wasmMemoryViewTable.has(dataview)) {
                        emnapiExternalMemory.wasmMemoryViewTable.set(dataview, {
                            Ctor: DataView,
                            address: byte_offset,
                            length: byte_length,
                            ownership: 1 /* Ownership.kUserland */,
                            runtimeAllocated: 0
                        });
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(dataview).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /**
         * @__sig ipppp
         */
        function node_api_symbol_for(env, utf8description, length, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var autoLength = length === -1;
            var sizelength = length >>> 0;
            if (length !== 0) {
                if (!utf8description)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            if (!(autoLength || (sizelength <= 2147483647))) {
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var descriptionString = emnapiString.UTF8ToString(utf8description, length);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(Symbol.for(descriptionString)).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var createMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_array: napi_create_array,
            napi_create_array_with_length: napi_create_array_with_length,
            napi_create_arraybuffer: napi_create_arraybuffer,
            napi_create_buffer: napi_create_buffer,
            napi_create_buffer_copy: napi_create_buffer_copy,
            napi_create_dataview: napi_create_dataview,
            napi_create_date: napi_create_date,
            napi_create_external: napi_create_external,
            napi_create_external_arraybuffer: napi_create_external_arraybuffer,
            napi_create_external_buffer: napi_create_external_buffer,
            napi_create_object: napi_create_object,
            napi_create_symbol: napi_create_symbol,
            napi_create_typedarray: napi_create_typedarray,
            node_api_symbol_for: node_api_symbol_for
        });
        /** @__sig ipip */
        function napi_get_boolean(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v = value === 0 ? 3 /* GlobalHandle.FALSE */ : 4 /* GlobalHandle.TRUE */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, v, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_global(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 5 /* GlobalHandle.GLOBAL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_null(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 2 /* GlobalHandle.NULL */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_undefined(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = 1 /* GlobalHandle.UNDEFINED */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var globalMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_boolean: napi_get_boolean,
            napi_get_global: napi_get_global,
            napi_get_null: napi_get_null,
            napi_get_undefined: napi_get_undefined
        });
        /** @__sig ipppp */
        function napi_set_instance_data(env, data, finalize_cb, finalize_hint) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            envObject.setInstanceData(data, finalize_cb, finalize_hint);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_instance_data(env, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!data)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = envObject.getInstanceData();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(data, value, true);
            return envObject.clearLastError();
        }
        var envMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_instance_data: napi_get_instance_data,
            napi_set_instance_data: napi_set_instance_data
        });
        /** @__sig vpppp */
        function _emnapi_get_last_error_info(env, error_code, engine_error_code, engine_reserved) {
            var envObject = emnapiCtx.envStore.get(env);
            var lastError = envObject.lastError;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var errorCode = lastError.errorCode;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineErrorCode = lastError.engineErrorCode >>> 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var engineReserved = lastError.engineReserved;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(error_code, errorCode, true);
            HEAP_DATA_VIEW.setUint32(engine_error_code, engineErrorCode, true);
            HEAP_DATA_VIEW.setInt32(engine_reserved, engineReserved, true);
        }
        /** @__sig ipp */
        function napi_throw(env, error) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!error)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                envObject.tryCatch.setError(emnapiCtx.handleStore.get(error).value);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new Error(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_type_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new TypeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_throw_range_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new RangeError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function node_api_throw_syntax_error(env, code, msg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!msg)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = new SyntaxError(emnapiString.UTF8ToString(msg, -1));
                if (code)
                    error.code = emnapiString.UTF8ToString(code, -1);
                envObject.tryCatch.setError(error);
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_is_exception_pending(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = envObject.tryCatch.hasCaught();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new Error(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_type_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new TypeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_create_range_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new RangeError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function node_api_create_syntax_error(env, code, msg, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!msg)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var msgValue = emnapiCtx.handleStore.get(msg).value;
            if (typeof msgValue !== 'string') {
                return envObject.setLastError(3 /* napi_status.napi_string_expected */);
            }
            var error = new SyntaxError(msgValue);
            if (code) {
                var codeValue = emnapiCtx.handleStore.get(code).value;
                if (typeof codeValue !== 'string') {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                error.code = codeValue;
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = emnapiCtx.addToCurrentScope(error).id;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_get_and_clear_last_exception(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (!envObject.tryCatch.hasCaught()) {
                HEAP_DATA_VIEW.setInt32(result, 1, true); // ID_UNDEFINED
                return envObject.clearLastError();
            }
            else {
                var err = envObject.tryCatch.exception();
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = envObject.ensureHandleId(err);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                envObject.tryCatch.reset();
            }
            return envObject.clearLastError();
        }
        /** @__sig vpppp */
        function napi_fatal_error(location, location_len, message, message_len) {
            var locationStr = emnapiString.UTF8ToString(location, location_len);
            var messageStr = emnapiString.UTF8ToString(message, message_len);
            if (emnapiNodeBinding) {
                emnapiNodeBinding.napi.fatalError(locationStr, messageStr);
            }
            else {
                abort('FATAL ERROR: ' + locationStr + ' ' + messageStr);
            }
        }
        /** @__sig ipp */
        function napi_fatal_exception(env, err) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!err)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var error = envObject.ctx.handleStore.get(err);
                try {
                    envObject.triggerFatalException(error.value);
                }
                catch (_) {
                    return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var errorMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_last_error_info: _emnapi_get_last_error_info,
            napi_create_error: napi_create_error,
            napi_create_range_error: napi_create_range_error,
            napi_create_type_error: napi_create_type_error,
            napi_fatal_error: napi_fatal_error,
            napi_fatal_exception: napi_fatal_exception,
            napi_get_and_clear_last_exception: napi_get_and_clear_last_exception,
            napi_is_exception_pending: napi_is_exception_pending,
            napi_throw: napi_throw,
            napi_throw_error: napi_throw_error,
            napi_throw_range_error: napi_throw_range_error,
            napi_throw_type_error: napi_throw_type_error,
            node_api_create_syntax_error: node_api_create_syntax_error,
            node_api_throw_syntax_error: node_api_throw_syntax_error
        });
        /** @__sig ipppppp */
        function napi_create_function(env, utf8name, length, cb, data, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!cb)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var fresult = emnapiCreateFunction(envObject, utf8name, length, cb, data);
                if (fresult.status !== 0 /* napi_status.napi_ok */)
                    return envObject.setLastError(fresult.status);
                var f = fresult.f;
                var valueHandle = emnapiCtx.addToCurrentScope(f);
                value = valueHandle.id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppppp */
        function napi_get_cb_info(env, cbinfo, argc, argv, this_arg, data) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.cbinfoStack.get(cbinfo);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            if (argv) {
                if (!argc)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var argcValue = HEAP_DATA_VIEW.getUint32(argc, true);
                var len = cbinfoValue.args.length;
                var arrlen = argcValue < len ? argcValue : len;
                var i = 0;
                for (; i < arrlen; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    var argVal = envObject.ensureHandleId(cbinfoValue.args[i]);
                    HEAP_DATA_VIEW.setInt32(argv + i * 4, argVal, true);
                }
                if (i < argcValue) {
                    for (; i < argcValue; i++) {
                        HEAP_DATA_VIEW.setInt32(argv + i * 4, 1, true);
                    }
                }
            }
            if (argc) {
                HEAP_DATA_VIEW.setUint32(argc, cbinfoValue.args.length, true);
            }
            if (this_arg) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var v = envObject.ensureHandleId(cbinfoValue.thiz);
                HEAP_DATA_VIEW.setInt32(this_arg, v, true);
            }
            if (data) {
                HEAP_DATA_VIEW.setInt32(data, cbinfoValue.data, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ipppppp */
        function napi_call_function(env, recv, func, argc, argv, result) {
            var i = 0;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!recv)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var v8recv = emnapiCtx.handleStore.get(recv).value;
                if (!func)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8func = emnapiCtx.handleStore.get(func).value;
                if (typeof v8func !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var args = [];
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (; i < argc; i++) {
                    var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                    args.push(emnapiCtx.handleStore.get(argVal).value);
                }
                var ret = v8func.apply(v8recv, args);
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.clearLastError();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippppp */
        function napi_new_instance(env, constructor, argc, argv, result) {
            var i;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                argc = argc >>> 0;
                if (argc > 0) {
                    if (!argv)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var Ctor = emnapiCtx.handleStore.get(constructor).value;
                if (typeof Ctor !== 'function')
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var ret = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (emnapiCtx.feature.supportReflect) {
                    var argList = Array(argc);
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        argList[i] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    ret = Reflect.construct(Ctor, argList, Ctor);
                }
                else {
                    var args = Array(argc + 1);
                    args[0] = undefined;
                    for (i = 0; i < argc; i++) {
                        var argVal = HEAP_DATA_VIEW.getInt32(argv + i * 4, true);
                        args[i + 1] = emnapiCtx.handleStore.get(argVal).value;
                    }
                    var BoundCtor = Ctor.bind.apply(Ctor, args);
                    ret = new BoundCtor();
                }
                if (result) {
                    v = envObject.ensureHandleId(ret);
                    HEAP_DATA_VIEW.setInt32(result, v, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_new_target(env, cbinfo, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!cbinfo)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var cbinfoValue = emnapiCtx.cbinfoStack.get(cbinfo);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value = cbinfoValue.getNewTarget(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, value, true);
            return envObject.clearLastError();
        }
        var functionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_call_function: napi_call_function,
            napi_create_function: napi_create_function,
            napi_get_cb_info: napi_get_cb_info,
            napi_get_new_target: napi_get_new_target,
            napi_new_instance: napi_new_instance
        });
        /** @__sig ipp */
        function napi_open_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_open_escapable_handle_scope(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var scope = emnapiCtx.openScope(envObject);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, scope.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_close_escapable_handle_scope(env, scope) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if ((envObject.openHandleScopes === 0)) {
                return 13 /* napi_status.napi_handle_scope_mismatch */;
            }
            emnapiCtx.closeScope(envObject);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_escape_handle(env, scope, escapee, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!scope)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!escapee)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var scopeObject = emnapiCtx.scopeStore.get(scope);
            if (!scopeObject.escapeCalled()) {
                var newHandle = scopeObject.escape(escapee);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                var value = newHandle ? newHandle.id : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.clearLastError();
            }
            return envObject.setLastError(12 /* napi_status.napi_escape_called_twice */);
        }
        /** @__sig ippip */
        function napi_create_reference(env, value, initial_refcount, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var handle = emnapiCtx.handleStore.get(value);
            if (envObject.moduleApiVersion !== 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */) {
                if (!(handle.isObject() || handle.isFunction() || handle.isSymbol())) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var ref = emnapiCtx.createReference(envObject, handle.id, initial_refcount >>> 0, 1 /* Ownership.kUserland */);
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, ref.id, true);
            return envObject.clearLastError();
        }
        /** @__sig ipp */
        function napi_delete_reference(env, ref) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.refStore.get(ref).dispose();
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_ref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = emnapiCtx.refStore.get(ref).ref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_reference_unref(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            var refcount = reference.refCount();
            if (refcount === 0) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var count = reference.unref();
            if (result) {
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setUint32(result, count, true);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_get_reference_value(env, ref, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!ref)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var reference = emnapiCtx.refStore.get(ref);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var handleId = reference.get();
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, handleId, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_add_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.addCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig ippp */
        function napi_remove_env_cleanup_hook(env, fun, arg) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!fun)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            emnapiCtx.removeCleanupHook(envObject, fun, arg);
            return 0 /* napi_status.napi_ok */;
        }
        /** @__sig vp */
        function _emnapi_env_ref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.ref();
        }
        /** @__sig vp */
        function _emnapi_env_unref(env) {
            var envObject = emnapiCtx.envStore.get(env);
            envObject.unref();
        }
        var lifeMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_env_ref: _emnapi_env_ref,
            _emnapi_env_unref: _emnapi_env_unref,
            napi_add_env_cleanup_hook: napi_add_env_cleanup_hook,
            napi_close_escapable_handle_scope: napi_close_escapable_handle_scope,
            napi_close_handle_scope: napi_close_handle_scope,
            napi_create_reference: napi_create_reference,
            napi_delete_reference: napi_delete_reference,
            napi_escape_handle: napi_escape_handle,
            napi_get_reference_value: napi_get_reference_value,
            napi_open_escapable_handle_scope: napi_open_escapable_handle_scope,
            napi_open_handle_scope: napi_open_handle_scope,
            napi_reference_ref: napi_reference_ref,
            napi_reference_unref: napi_reference_unref,
            napi_remove_env_cleanup_hook: napi_remove_env_cleanup_hook
        });
        /** @__sig ippi */
        function _emnapi_get_filename(env, buf, len) {
            var envObject = emnapiCtx.envStore.get(env);
            var filename = envObject.filename;
            if (!buf) {
                return emnapiString.lengthBytesUTF8(filename);
            }
            return emnapiString.stringToUTF8(filename, buf, len);
        }
        var miscellaneousMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            _emnapi_get_filename: _emnapi_get_filename
        });
        /** @__sig ippp */
        function napi_create_promise(env, deferred, promise) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var deferredObjectId, value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!promise)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                var p = new Promise(function (resolve, reject) {
                    var deferredObject = emnapiCtx.createDeferred({ resolve: resolve, reject: reject });
                    deferredObjectId = deferredObject.id;
                    HEAP_DATA_VIEW.setInt32(deferred, deferredObjectId, true);
                });
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(p).id;
                HEAP_DATA_VIEW.setInt32(promise, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_resolve_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.resolve(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_reject_deferred(env, deferred, resolution) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!deferred)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!resolution)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var deferredObject = emnapiCtx.deferredStore.get(deferred);
                deferredObject.reject(emnapiCtx.handleStore.get(resolution).value);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_promise(env, value, is_promise) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!is_promise)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isPromise() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(is_promise, r, true);
            return envObject.clearLastError();
        }
        var promiseMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_create_promise: napi_create_promise,
            napi_is_promise: napi_is_promise,
            napi_reject_deferred: napi_reject_deferred,
            napi_resolve_deferred: napi_resolve_deferred
        });
        /** @__sig ippiiip */
        function napi_get_all_property_names(env, object, key_mode, key_filter, key_conversion, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var obj = void 0;
                try {
                    obj = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (key_mode !== 0 /* napi_key_collection_mode.napi_key_include_prototypes */ && key_mode !== 1 /* napi_key_collection_mode.napi_key_own_only */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (key_conversion !== 0 /* napi_key_conversion.napi_key_keep_numbers */ && key_conversion !== 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var props = [];
                var names = void 0;
                var symbols = void 0;
                var i = void 0;
                var own = true;
                var integerIndiceRegex = /^(0|[1-9][0-9]*)$/;
                do {
                    names = Object.getOwnPropertyNames(obj);
                    symbols = Object.getOwnPropertySymbols(obj);
                    for (i = 0; i < names.length; i++) {
                        props.push({
                            name: integerIndiceRegex.test(names[i]) ? Number(names[i]) : names[i],
                            desc: Object.getOwnPropertyDescriptor(obj, names[i]),
                            own: own
                        });
                    }
                    for (i = 0; i < symbols.length; i++) {
                        props.push({
                            name: symbols[i],
                            desc: Object.getOwnPropertyDescriptor(obj, symbols[i]),
                            own: own
                        });
                    }
                    if (key_mode === 1 /* napi_key_collection_mode.napi_key_own_only */) {
                        break;
                    }
                    obj = Object.getPrototypeOf(obj);
                    own = false;
                } while (obj);
                var ret = [];
                var addName = function (ret, name, key_filter, conversion_mode) {
                    if (ret.indexOf(name) !== -1)
                        return;
                    if (conversion_mode === 0 /* napi_key_conversion.napi_key_keep_numbers */) {
                        ret.push(name);
                    }
                    else if (conversion_mode === 1 /* napi_key_conversion.napi_key_numbers_to_strings */) {
                        var realName = typeof name === 'number' ? String(name) : name;
                        if (typeof realName === 'string') {
                            if (!(key_filter & 8 /* napi_key_filter.napi_key_skip_strings */)) {
                                ret.push(realName);
                            }
                        }
                        else {
                            ret.push(realName);
                        }
                    }
                };
                for (i = 0; i < props.length; i++) {
                    var prop = props[i];
                    var name_1 = prop.name;
                    var desc = prop.desc;
                    if (key_filter === 0 /* napi_key_filter.napi_key_all_properties */) {
                        addName(ret, name_1, key_filter, key_conversion);
                    }
                    else {
                        if (key_filter & 8 /* napi_key_filter.napi_key_skip_strings */ && typeof name_1 === 'string') {
                            continue;
                        }
                        if (key_filter & 16 /* napi_key_filter.napi_key_skip_symbols */ && typeof name_1 === 'symbol') {
                            continue;
                        }
                        var shouldAdd = true;
                        switch (key_filter & 7) {
                            case 1 /* napi_key_filter.napi_key_writable */: {
                                shouldAdd = Boolean(desc.writable);
                                break;
                            }
                            case 2 /* napi_key_filter.napi_key_enumerable */: {
                                shouldAdd = Boolean(desc.enumerable);
                                break;
                            }
                            case (1 /* napi_key_filter.napi_key_writable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.writable && desc.enumerable);
                                break;
                            }
                            case 4 /* napi_key_filter.napi_key_configurable */: {
                                shouldAdd = Boolean(desc.configurable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.writable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable);
                                break;
                            }
                            case (4 /* napi_key_filter.napi_key_configurable */ | 2 /* napi_key_filter.napi_key_enumerable */ | 1 /* napi_key_filter.napi_key_writable */): {
                                shouldAdd = Boolean(desc.configurable && desc.enumerable && desc.writable);
                                break;
                            }
                        }
                        if (shouldAdd) {
                            addName(ret, name_1, key_filter, key_conversion);
                        }
                    }
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = emnapiCtx.addToCurrentScope(ret).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_get_property_names(env, object, result) {
            return napi_get_all_property_names(env, object, 0 /* napi_key_collection_mode.napi_key_include_prototypes */, 2 /* napi_key_filter.napi_key_enumerable */ | 16 /* napi_key_filter.napi_key_skip_symbols */, 1 /* napi_key_conversion.napi_key_numbers_to_strings */, result);
        }
        /** @__sig ipppp */
        function napi_set_property(env, object, key, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[emnapiCtx.handleStore.get(key).value] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = (emnapiCtx.handleStore.get(key).value in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiCtx.handleStore.get(key).value]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_delete_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyKey = emnapiCtx.handleStore.get(key).value;
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, propertyKey);
                }
                else {
                    try {
                        r = delete h.value[propertyKey];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_own_property(env, object, key, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!key)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var prop = emnapiCtx.handleStore.get(key).value;
                if (typeof prop !== 'string' && typeof prop !== 'symbol') {
                    return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                }
                r = Object.prototype.hasOwnProperty.call(v, emnapiCtx.handleStore.get(key).value);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_set_named_property(env, object, cname, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (!cname) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                emnapiCtx.handleStore.get(object).value[emnapiString.UTF8ToString(cname, -1)] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_has_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = emnapiString.UTF8ToString(utf8name, -1) in v;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_get_named_property(env, object, utf8name, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!utf8name) {
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[emnapiString.UTF8ToString(utf8name, -1)]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_set_element(env, object, index, value) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                h.value[index >>> 0] = emnapiCtx.handleStore.get(value).value;
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_has_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                r = ((index >>> 0) in v) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_get_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (h.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                var v = void 0;
                try {
                    v = h.isObject() || h.isFunction() ? h.value : Object(h.value);
                }
                catch (_) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(v[index >>> 0]);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippip */
        function napi_delete_element(env, object, index, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                if (emnapiCtx.feature.supportReflect) {
                    r = Reflect.deleteProperty(h.value, index >>> 0);
                }
                else {
                    try {
                        r = delete h.value[index >>> 0];
                    }
                    catch (_) {
                        r = false;
                    }
                }
                if (result) {
                    var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                    HEAP_DATA_VIEW.setInt8(result, r ? 1 : 0, true);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_define_properties(env, object, property_count, properties) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var propPtr, attributes;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                property_count = property_count >>> 0;
                if (property_count > 0) {
                    if (!properties)
                        return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                }
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                var propertyName = void 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                for (var i = 0; i < property_count; i++) {
                    // eslint-disable-next-line @typescript-eslint/no-unused-vars
                    propPtr = properties + (i * (4 * 8));
                    var utf8Name = HEAP_DATA_VIEW.getInt32(propPtr, true);
                    var name_2 = HEAP_DATA_VIEW.getInt32(propPtr + 4, true);
                    var method = HEAP_DATA_VIEW.getInt32(propPtr + 8, true);
                    var getter = HEAP_DATA_VIEW.getInt32(propPtr + 12, true);
                    var setter = HEAP_DATA_VIEW.getInt32(propPtr + 16, true);
                    var value = HEAP_DATA_VIEW.getInt32(propPtr + 20, true);
                    attributes = HEAP_DATA_VIEW.getInt32(propPtr + 24, true);
                    var data = HEAP_DATA_VIEW.getInt32(propPtr + 28, true);
                    if (utf8Name) {
                        propertyName = emnapiString.UTF8ToString(utf8Name, -1);
                    }
                    else {
                        if (!name_2) {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                        propertyName = emnapiCtx.handleStore.get(name_2).value;
                        if (typeof propertyName !== 'string' && typeof propertyName !== 'symbol') {
                            return envObject.setLastError(4 /* napi_status.napi_name_expected */);
                        }
                    }
                    emnapiDefineProperty(envObject, maybeObject, propertyName, method, getter, setter, value, attributes, data);
                }
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_freeze(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.freeze(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_object_seal(env, object) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(object);
                var maybeObject = h.value;
                if (!(h.isObject() || h.isFunction())) {
                    return envObject.setLastError(2 /* napi_status.napi_object_expected */);
                }
                Object.seal(maybeObject);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var propertyMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_define_properties: napi_define_properties,
            napi_delete_element: napi_delete_element,
            napi_delete_property: napi_delete_property,
            napi_get_all_property_names: napi_get_all_property_names,
            napi_get_element: napi_get_element,
            napi_get_named_property: napi_get_named_property,
            napi_get_property: napi_get_property,
            napi_get_property_names: napi_get_property_names,
            napi_has_element: napi_has_element,
            napi_has_named_property: napi_has_named_property,
            napi_has_own_property: napi_has_own_property,
            napi_has_property: napi_has_property,
            napi_object_freeze: napi_object_freeze,
            napi_object_seal: napi_object_seal,
            napi_set_element: napi_set_element,
            napi_set_named_property: napi_set_named_property,
            napi_set_property: napi_set_property
        });
        /** @__sig ippp */
        function napi_run_script(env, script, result) {
            var status;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var value;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!script)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var v8Script = emnapiCtx.handleStore.get(script);
                if (!v8Script.isString()) {
                    return envObject.setLastError(3 /* napi_status.napi_string_expected */);
                }
                var g = emnapiCtx.handleStore.get(5 /* GlobalHandle.GLOBAL */).value;
                var ret = g.eval(v8Script.value);
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                value = envObject.ensureHandleId(ret);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, value, true);
                status = envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
            return status;
        }
        var scriptMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_run_script: napi_run_script
        });
        /** @__sig ippp */
        function napi_typeof(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var v = emnapiCtx.handleStore.get(value);
            var r;
            if (v.isNumber()) {
                r = 3 /* napi_valuetype.napi_number */;
            }
            else if (v.isBigInt()) {
                r = 9 /* napi_valuetype.napi_bigint */;
            }
            else if (v.isString()) {
                r = 4 /* napi_valuetype.napi_string */;
            }
            else if (v.isFunction()) {
                // This test has to come before IsObject because IsFunction
                // implies IsObject
                r = 7 /* napi_valuetype.napi_function */;
            }
            else if (v.isExternal()) {
                // This test has to come before IsObject because IsExternal
                // implies IsObject
                r = 8 /* napi_valuetype.napi_external */;
            }
            else if (v.isObject()) {
                r = 6 /* napi_valuetype.napi_object */;
            }
            else if (v.isBoolean()) {
                r = 2 /* napi_valuetype.napi_boolean */;
            }
            else if (v.isUndefined()) {
                r = 0 /* napi_valuetype.napi_undefined */;
            }
            else if (v.isSymbol()) {
                r = 5 /* napi_valuetype.napi_symbol */;
            }
            else if (v.isNull()) {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                r = 1 /* napi_valuetype.napi_null */;
            }
            else {
                // Should not get here unless V8 has added some new kind of value.
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            }
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt32(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_coerce_to_bool(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                v = handle.value ? 4 /* GlobalHandle.TRUE */ : 3 /* GlobalHandle.FALSE */;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_number(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isBigInt()) {
                    throw new TypeError('Cannot convert a BigInt value to a number');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(Number(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_object(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.value == null) {
                    throw new TypeError('Cannot convert undefined or null to object');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = envObject.ensureHandleId(Object(handle.value));
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_coerce_to_string(env, value, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var v;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!value)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var handle = emnapiCtx.handleStore.get(value);
                if (handle.isSymbol()) {
                    throw new TypeError('Cannot convert a Symbol value to a string');
                }
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                v = emnapiCtx.addToCurrentScope(String(handle.value)).id;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt32(result, v, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipppp */
        function napi_instanceof(env, object, constructor, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!object)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!constructor)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                var ctor = emnapiCtx.handleStore.get(constructor);
                if (!ctor.isFunction()) {
                    return envObject.setLastError(5 /* napi_status.napi_function_expected */);
                }
                var val = emnapiCtx.handleStore.get(object).value;
                var ret = val instanceof ctor.value;
                r = ret ? 1 : 0;
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ippp */
        function napi_is_array(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_arraybuffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isArrayBuffer() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_date(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDate() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_error(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var val = emnapiCtx.handleStore.get(value).value;
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = (val instanceof Error) ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_typedarray(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isTypedArray() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_buffer(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isBuffer() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_dataview(env, value, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!value)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var h = emnapiCtx.handleStore.get(value);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r = h.isDataView() ? 1 : 0;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setInt8(result, r, true);
            return envObject.clearLastError();
        }
        /** @__sig ipppp */
        function napi_strict_equals(env, lhs, rhs, result) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var r;
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!lhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!rhs)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var lv = emnapiCtx.handleStore.get(lhs).value;
                var rv = emnapiCtx.handleStore.get(rhs).value;
                r = (lv === rv) ? 1 : 0;
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                HEAP_DATA_VIEW.setInt8(result, r, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        /** @__sig ipp */
        function napi_detach_arraybuffer(env, arraybuffer) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!arraybuffer)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            var value = emnapiCtx.handleStore.get(arraybuffer).value;
            if (!(value instanceof ArrayBuffer)) {
                if (typeof SharedArrayBuffer === 'function' && (value instanceof SharedArrayBuffer)) {
                    return envObject.setLastError(20 /* napi_status.napi_detachable_arraybuffer_expected */);
                }
                return envObject.setLastError(19 /* napi_status.napi_arraybuffer_expected */);
            }
            try {
                var MessageChannel_1 = emnapiCtx.feature.MessageChannel;
                var messageChannel = new MessageChannel_1();
                messageChannel.port1.postMessage(value, [value]);
            }
            catch (_) {
                return envObject.setLastError(9 /* napi_status.napi_generic_failure */);
            }
            return envObject.clearLastError();
        }
        /** @__sig ippp */
        function napi_is_detached_arraybuffer(env, arraybuffer, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            // @ts-expect-error
            var envObject = emnapiCtx.envStore.get(env);
            envObject.checkGCAccess();
            if (!envObject.tryCatch.isEmpty())
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            if (!envObject.canCallIntoJs())
                return envObject.setLastError(envObject.moduleApiVersion === 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */ ? 23 /* napi_status.napi_cannot_run_js */ : 10 /* napi_status.napi_pending_exception */);
            envObject.clearLastError();
            try {
                if (!arraybuffer)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                if (!result)
                    return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
                var h = emnapiCtx.handleStore.get(arraybuffer);
                var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
                if (h.isArrayBuffer() && h.value.byteLength === 0) {
                    try {
                        // eslint-disable-next-line no-new
                        new Uint8Array(h.value);
                    }
                    catch (_) {
                        HEAP_DATA_VIEW.setInt8(result, 1, true);
                        return envObject.getReturnStatus();
                    }
                }
                HEAP_DATA_VIEW.setInt8(result, 0, true);
                return envObject.getReturnStatus();
            }
            catch (err) {
                envObject.tryCatch.setError(err);
                return envObject.setLastError(10 /* napi_status.napi_pending_exception */);
            }
        }
        var valueOperationMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_coerce_to_bool: napi_coerce_to_bool,
            napi_coerce_to_number: napi_coerce_to_number,
            napi_coerce_to_object: napi_coerce_to_object,
            napi_coerce_to_string: napi_coerce_to_string,
            napi_detach_arraybuffer: napi_detach_arraybuffer,
            napi_instanceof: napi_instanceof,
            napi_is_array: napi_is_array,
            napi_is_arraybuffer: napi_is_arraybuffer,
            napi_is_buffer: napi_is_buffer,
            napi_is_dataview: napi_is_dataview,
            napi_is_date: napi_is_date,
            napi_is_detached_arraybuffer: napi_is_detached_arraybuffer,
            napi_is_error: napi_is_error,
            napi_is_typedarray: napi_is_typedarray,
            napi_strict_equals: napi_strict_equals,
            napi_typeof: napi_typeof
        });
        /** @__sig ipp */
        function napi_get_version(env, result) {
            if (!env)
                return 1 /* napi_status.napi_invalid_arg */;
            var envObject = emnapiCtx.envStore.get(env);
            if (!result)
                return envObject.setLastError(1 /* napi_status.napi_invalid_arg */);
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            var NODE_API_SUPPORTED_VERSION_MAX = 9 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
            var HEAP_DATA_VIEW = new DataView(wasmMemory.buffer);
            HEAP_DATA_VIEW.setUint32(result, NODE_API_SUPPORTED_VERSION_MAX, true);
            return envObject.clearLastError();
        }
        var versionMod = /*#__PURE__*/ Object.freeze({
            __proto__: null,
            napi_get_version: napi_get_version
        });
        emnapiAWST.init();
        emnapiExternalMemory.init();
        emnapiString.init();
        emnapiTSFN.init();
        napiModule.emnapi.syncMemory = $emnapiSyncMemory;
        napiModule.emnapi.getMemoryAddress = $emnapiGetMemoryAddress;
        function addImports(mod) {
            var keys = Object.keys(mod);
            for (var i = 0; i < keys.length; ++i) {
                var k = keys[i];
                if (k.indexOf('$') === 0)
                    continue;
                if (k.indexOf('emnapi_') === 0) {
                    napiModule.imports.emnapi[k] = mod[k];
                }
                else if (k.indexOf('_emnapi_') === 0 || k === 'napi_set_last_error' || k === 'napi_clear_last_error') {
                    napiModule.imports.env[k] = mod[k];
                }
                else {
                    napiModule.imports.napi[k] = mod[k];
                }
            }
        }
        addImports(asyncMod);
        addImports(memoryMod);
        addImports(asyncWorkMod);
        addImports(utilMod);
        addImports(convert2cMod);
        addImports(convert2napiMod);
        addImports(createMod);
        addImports(globalMod);
        addImports(wrapMod);
        addImports(envMod);
        addImports(emnapiMod);
        addImports(errorMod);
        addImports(functionMod);
        addImports(lifeMod);
        addImports(miscellaneousMod);
        addImports(nodeMod);
        addImports(promiseMod);
        addImports(propertyMod);
        addImports(scriptMod);
        addImports(valueOperationMod);
        addImports(versionMod);
        napiModule.imports.napi.napi_create_threadsafe_function = napi_create_threadsafe_function;
        napiModule.imports.napi.napi_get_threadsafe_function_context = napi_get_threadsafe_function_context;
        napiModule.imports.napi.napi_call_threadsafe_function = napi_call_threadsafe_function;
        napiModule.imports.napi.napi_acquire_threadsafe_function = napi_acquire_threadsafe_function;
        napiModule.imports.napi.napi_release_threadsafe_function = napi_release_threadsafe_function;
        napiModule.imports.napi.napi_unref_threadsafe_function = napi_unref_threadsafe_function;
        napiModule.imports.napi.napi_ref_threadsafe_function = napi_ref_threadsafe_function;
        return napiModule;
    })();
    return napiModule;
}

function loadNapiModuleImpl(loadFn, userNapiModule, wasmInput, options) {
    // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
    options = options !== null && options !== void 0 ? options : {};
    var getMemory = options.getMemory;
    var getTable = options.getTable;
    var beforeInit = options.beforeInit;
    if (getMemory != null && typeof getMemory !== 'function') {
        throw new TypeError('options.getMemory is not a function');
    }
    if (getTable != null && typeof getTable !== 'function') {
        throw new TypeError('options.getTable is not a function');
    }
    if (beforeInit != null && typeof beforeInit !== 'function') {
        throw new TypeError('options.beforeInit is not a function');
    }
    var napiModule;
    {
        napiModule = createNapiModule(options);
    }
    var wasi = options.wasi;
    var importObject = {
        env: napiModule.imports.env,
        napi: napiModule.imports.napi,
        emnapi: napiModule.imports.emnapi,
        wasi: {
            // eslint-disable-next-line camelcase
            'thread-spawn': function __imported_wasi_thread_spawn(startArg, errorOrTid) {
                return napiModule.spawnThread(startArg, errorOrTid);
            }
        }
    };
    if (wasi) {
        Object.assign(importObject, typeof wasi.getImportObject === 'function'
            ? wasi.getImportObject()
            : { wasi_snapshot_preview1: wasi.wasiImport });
    }
    var overwriteImports = options.overwriteImports;
    if (typeof overwriteImports === 'function') {
        var newImportObject = overwriteImports(importObject);
        if (typeof newImportObject === 'object' && newImportObject !== null) {
            importObject = newImportObject;
        }
    }
    return loadFn(wasmInput, importObject, function (err, source) {
        if (err) {
            throw err;
        }
        var originalInstance = source.instance;
        var instance = originalInstance;
        var originalExports = originalInstance.exports;
        var exportMemory = 'memory' in originalExports;
        var importMemory = 'memory' in importObject.env;
        var memory = getMemory
            ? getMemory(originalExports)
            : exportMemory
                ? originalExports.memory
                : importMemory
                    ? importObject.env.memory
                    : undefined;
        if (!memory) {
            throw new Error('memory is neither exported nor imported');
        }
        var table = getTable ? getTable(originalExports) : originalExports.__indirect_function_table;
        if (wasi && !exportMemory) {
            var exports_1 = Object.create(null);
            Object.assign(exports_1, originalExports, { memory: memory });
            instance = { exports: exports_1 };
        }
        var module = source.module;
        if (wasi) {
            if (napiModule.childThread) {
                // https://github.com/nodejs/help/issues/4102
                var createHandler = function (target) {
                    var handlers = [
                        'apply',
                        'construct',
                        'defineProperty',
                        'deleteProperty',
                        'get',
                        'getOwnPropertyDescriptor',
                        'getPrototypeOf',
                        'has',
                        'isExtensible',
                        'ownKeys',
                        'preventExtensions',
                        'set',
                        'setPrototypeOf'
                    ];
                    var handler = {};
                    var _loop_1 = function (i) {
                        var name_1 = handlers[i];
                        handler[name_1] = function () {
                            var args = Array.prototype.slice.call(arguments, 1);
                            args.unshift(target);
                            return Reflect[name_1].apply(Reflect, args);
                        };
                    };
                    for (var i = 0; i < handlers.length; i++) {
                        _loop_1(i);
                    }
                    return handler;
                };
                var handler = createHandler(originalExports);
                var noop_1 = function () { };
                handler.get = function (_target, p, receiver) {
                    if (p === 'memory') {
                        return memory;
                    }
                    if (p === '_initialize') {
                        return noop_1;
                    }
                    return Reflect.get(originalExports, p, receiver);
                };
                var exportsProxy_1 = new Proxy(Object.create(null), handler);
                instance = new Proxy(instance, {
                    get: function (target, p, receiver) {
                        if (p === 'exports') {
                            return exportsProxy_1;
                        }
                        return Reflect.get(target, p, receiver);
                    }
                });
            }
            wasi.initialize(instance);
        }
        if (beforeInit) {
            beforeInit({
                instance: originalInstance,
                module: module
            });
        }
        napiModule.init({
            instance: instance,
            module: module,
            memory: memory,
            table: table
        });
        var ret = { instance: originalInstance, module: module };
        {
            ret.napiModule = napiModule;
        }
        return ret;
    });
}
function loadCallback(wasmInput, importObject, callback) {
    return load(wasmInput, importObject).then(function (source) {
        return callback(null, source);
    }, function (err) {
        return callback(err);
    });
}
function loadSyncCallback(wasmInput, importObject, callback) {
    var source;
    try {
        source = loadSync(wasmInput, importObject);
    }
    catch (err) {
        return callback(err);
    }
    return callback(null, source);
}
/** @public */
function instantiateNapiModule(
/** Only support `BufferSource` or `WebAssembly.Module` on Node.js */
wasmInput, options) {
    return loadNapiModuleImpl(loadCallback, undefined, wasmInput, options);
}
/** @public */
function instantiateNapiModuleSync(wasmInput, options) {
    return loadNapiModuleImpl(loadSyncCallback, undefined, wasmInput, options);
}

/** @public */
var MessageHandler = /*#__PURE__*/ (function () {
    function MessageHandler(options) {
        var onLoad = options.onLoad;
        if (typeof onLoad !== 'function') {
            throw new TypeError('options.onLoad is not a function');
        }
        this.onLoad = onLoad;
        this.instance = undefined;
        // this.module = undefined
        this.napiModule = undefined;
        this.messagesBeforeLoad = [];
    }
    MessageHandler.prototype.handle = function (e) {
        var _this = this;
        var _a;
        if ((_a = e === null || e === void 0 ? void 0 : e.data) === null || _a === void 0 ? void 0 : _a.__emnapi__) {
            var type = e.data.__emnapi__.type;
            var payload_1 = e.data.__emnapi__.payload;
            var onLoad = this.onLoad;
            if (type === 'load') {
                if (this.instance !== undefined)
                    return;
                var source = onLoad(payload_1);
                var then = source && 'then' in source ? source.then : undefined;
                if (typeof then === 'function') {
                    // eslint-disable-next-line @typescript-eslint/no-floating-promises
                    then.call(source, function (source) { onLoaded.call(_this, source); }, function (err) { throw err; });
                }
                else {
                    onLoaded.call(this, source);
                }
            }
            else if (type === 'start') {
                handleAfterLoad.call(this, e, function () {
                    _this.napiModule.startThread(payload_1.tid, payload_1.arg);
                });
            }
            else if (type === 'async-worker-init') {
                handleAfterLoad.call(this, e, function () {
                    _this.napiModule.initWorker(payload_1.arg);
                });
            }
            else if (type === 'async-work-execute') {
                handleAfterLoad.call(this, e, function () {
                    _this.napiModule.executeAsyncWork(payload_1.work);
                });
            }
        }
    };
    return MessageHandler;
}());
function handleAfterLoad(e, f) {
    if (this.instance !== undefined) {
        f.call(this, e);
    }
    else {
        this.messagesBeforeLoad.push(e.data);
    }
}
function onLoaded(source) {
    if (source == null) {
        throw new TypeError('onLoad should return an object');
    }
    var instance = source.instance;
    var napiModule = source.napiModule;
    if (!instance)
        throw new TypeError('onLoad should return an object which includes "instance"');
    if (!napiModule)
        throw new TypeError('onLoad should return an object which includes "napiModule"');
    if (!napiModule.childThread)
        throw new Error('napiModule should be created with `childThread: true`');
    this.instance = instance;
    this.napiModule = napiModule;
    var postMessage = napiModule.postMessage;
    postMessage({
        __emnapi__: {
            type: 'loaded',
            payload: {}
        }
    });
    var messages = this.messagesBeforeLoad;
    this.messagesBeforeLoad = [];
    for (var i = 0; i < messages.length; i++) {
        var data = messages[i];
        this.handle({ data: data });
    }
}

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var EMPTY_ARGS = [];
var CallbackInfo = /*#__PURE__*/ (function () {
    function CallbackInfo(id, parent, child, thiz, data, args, fn) {
        this.id = id;
        this.parent = parent;
        this.child = child;
        this.thiz = thiz;
        this.data = data;
        this.args = args;
        this.fn = fn;
    }
    CallbackInfo.prototype.getNewTarget = function (envObject) {
        var thiz = this.thiz;
        // eslint-disable-next-line @typescript-eslint/prefer-optional-chain
        if (thiz == null || thiz.constructor == null)
            return 0;
        return thiz instanceof this.fn ? envObject.ensureHandleId(thiz.constructor) : 0;
    };
    CallbackInfo.prototype.dispose = function () {
        if (this.thiz !== undefined)
            this.thiz = undefined;
        this.args = EMPTY_ARGS;
        this.fn = null;
    };
    return CallbackInfo;
}());
var ROOT_CBINFO = new CallbackInfo(0, null, null, null, 0, null, null);
var CallbackInfoStack = /*#__PURE__*/ (function () {
    function CallbackInfoStack() {
        this.current = ROOT_CBINFO;
    }
    CallbackInfoStack.prototype.get = function (id) {
        if (id === 1)
            return ROOT_CBINFO.child;
        var info = ROOT_CBINFO;
        for (var i = 0; i < id; ++i) {
            info = info.child;
            if (info === null)
                return null;
        }
        return info === ROOT_CBINFO ? null : info;
    };
    CallbackInfoStack.prototype.pop = function () {
        var current = this.current;
        if (current === ROOT_CBINFO)
            return;
        this.current = current.parent;
        current.dispose();
    };
    CallbackInfoStack.prototype.push = function (thiz, data, args, fn) {
        var info = this.current.child;
        if (info) {
            info.thiz = thiz;
            info.data = data;
            info.args = args;
            info.fn = fn;
        }
        else {
            info = new CallbackInfo(this.current.id + 1, this.current, null, thiz, data, args, fn);
            this.current.child = info;
        }
        this.current = info;
        return info.id;
    };
    CallbackInfoStack.prototype.dispose = function () {
        this.current = null;
    };
    return CallbackInfoStack;
}());

var supportNewFunction = /*#__PURE__*/ (function () {
    var f;
    try {
        f = new Function();
    }
    catch (_) {
        return false;
    }
    return typeof f === 'function';
})();
var _global = /*#__PURE__*/ (function () {
    if (typeof globalThis !== 'undefined')
        return globalThis;
    var g = (function () { return this; })();
    if (!g && supportNewFunction) {
        try {
            g = new Function('return this')();
        }
        catch (_) { }
    }
    if (!g) {
        {
            if (typeof global !== 'undefined')
                return global;
        }
        if (typeof window !== 'undefined')
            return window;
        if (typeof self !== 'undefined')
            return self;
    }
    return g;
})();
var TryCatch = /*#__PURE__*/ (function () {
    function TryCatch() {
        this._exception = undefined;
        this._caught = false;
    }
    TryCatch.prototype.isEmpty = function () {
        return !this._caught;
    };
    TryCatch.prototype.hasCaught = function () {
        return this._caught;
    };
    TryCatch.prototype.exception = function () {
        return this._exception;
    };
    TryCatch.prototype.setError = function (err) {
        this._caught = true;
        this._exception = err;
    };
    TryCatch.prototype.reset = function () {
        this._caught = false;
        this._exception = undefined;
    };
    TryCatch.prototype.extractException = function () {
        var e = this._exception;
        this.reset();
        return e;
    };
    return TryCatch;
}());
var canSetFunctionName = /*#__PURE__*/ (function () {
    var _a;
    try {
        return Boolean((_a = Object.getOwnPropertyDescriptor(Function.prototype, 'name')) === null || _a === void 0 ? void 0 : _a.configurable);
    }
    catch (_) {
        return false;
    }
})();
var supportReflect = typeof Reflect === 'object';
var supportFinalizer = (typeof FinalizationRegistry !== 'undefined') && (typeof WeakRef !== 'undefined');
var supportWeakSymbol = /*#__PURE__*/ (function () {
    try {
        // eslint-disable-next-line symbol-description
        var sym = Symbol();
        // eslint-disable-next-line no-new
        new WeakRef(sym);
        new WeakMap().set(sym, undefined);
    }
    catch (_) {
        return false;
    }
    return true;
})();
var supportBigInt = typeof BigInt !== 'undefined';
function isReferenceType(v) {
    return (typeof v === 'object' && v !== null) || typeof v === 'function';
}
var _require = /*#__PURE__*/ (function () {
    var nativeRequire;
    {
        nativeRequire = (function () {
            return (typeof require !== 'undefined' ? require : undefined);
        })();
    }
    return nativeRequire;
})();
var _MessageChannel = typeof MessageChannel === 'function'
    ? MessageChannel
    : /*#__PURE__*/ (function () {
        try {
            return _require('worker_threads').MessageChannel;
        }
        catch (_) { }
        return undefined;
    })();
var _setImmediate = typeof setImmediate === 'function'
    ? setImmediate
    : function (callback) {
        if (typeof callback !== 'function') {
            throw new TypeError('The "callback" argument must be of type function');
        }
        if (_MessageChannel) {
            var channel_1 = new _MessageChannel();
            channel_1.port1.onmessage = function () {
                channel_1.port1.onmessage = null;
                channel_1 = undefined;
                callback();
            };
            channel_1.port2.postMessage(null);
        }
        else {
            setTimeout(callback, 0);
        }
    };
var _Buffer = typeof Buffer === 'function'
    ? Buffer
    : /*#__PURE__*/ (function () {
        try {
            return _require('buffer').Buffer;
        }
        catch (_) { }
        return undefined;
    })();
var version = "1.1.1";
var NODE_API_SUPPORTED_VERSION_MAX = 9 /* Version.NODE_API_SUPPORTED_VERSION_MAX */;
var NAPI_VERSION_EXPERIMENTAL = 2147483647 /* Version.NAPI_VERSION_EXPERIMENTAL */;
var NODE_API_DEFAULT_MODULE_API_VERSION = 8 /* Version.NODE_API_DEFAULT_MODULE_API_VERSION */;

var Handle = /*#__PURE__*/ (function () {
    function Handle(id, value) {
        this.id = id;
        this.value = value;
    }
    Handle.prototype.data = function (envObject) {
        return envObject.getObjectBinding(this.value).data;
    };
    Handle.prototype.isNumber = function () {
        return typeof this.value === 'number';
    };
    Handle.prototype.isBigInt = function () {
        return typeof this.value === 'bigint';
    };
    Handle.prototype.isString = function () {
        return typeof this.value === 'string';
    };
    Handle.prototype.isFunction = function () {
        return typeof this.value === 'function';
    };
    Handle.prototype.isExternal = function () {
        return (isReferenceType(this.value) && Object.getPrototypeOf(this.value) === null);
    };
    Handle.prototype.isObject = function () {
        return typeof this.value === 'object' && this.value !== null;
    };
    Handle.prototype.isArray = function () {
        return Array.isArray(this.value);
    };
    Handle.prototype.isArrayBuffer = function () {
        return (this.value instanceof ArrayBuffer);
    };
    Handle.prototype.isTypedArray = function () {
        return (ArrayBuffer.isView(this.value)) && !(this.value instanceof DataView);
    };
    Handle.prototype.isBuffer = function () {
        return typeof _Buffer === 'function' && _Buffer.isBuffer(this.value);
    };
    Handle.prototype.isDataView = function () {
        return (this.value instanceof DataView);
    };
    Handle.prototype.isDate = function () {
        return (this.value instanceof Date);
    };
    Handle.prototype.isPromise = function () {
        return (this.value instanceof Promise);
    };
    Handle.prototype.isBoolean = function () {
        return typeof this.value === 'boolean';
    };
    Handle.prototype.isUndefined = function () {
        return this.value === undefined;
    };
    Handle.prototype.isSymbol = function () {
        return typeof this.value === 'symbol';
    };
    Handle.prototype.isNull = function () {
        return this.value === null;
    };
    Handle.prototype.dispose = function () {
        this.value = undefined;
    };
    return Handle;
}());
var ConstHandle = /*#__PURE__*/ (function (_super) {
    __extends(ConstHandle, _super);
    function ConstHandle(id, value) {
        return _super.call(this, id, value) || this;
    }
    ConstHandle.prototype.dispose = function () { };
    return ConstHandle;
}(Handle));
function External() {
    Object.setPrototypeOf(this, null);
}
External.prototype = null;
var HandleStore = /*#__PURE__*/ (function () {
    function HandleStore() {
        this._values = [
            undefined,
            HandleStore.UNDEFINED,
            HandleStore.NULL,
            HandleStore.FALSE,
            HandleStore.TRUE,
            HandleStore.GLOBAL
        ];
        this._next = HandleStore.MIN_ID;
    }
    HandleStore.prototype.push = function (value) {
        var h;
        var next = this._next;
        var values = this._values;
        if (next < values.length) {
            h = values[next];
            h.value = value;
        }
        else {
            h = new Handle(next, value);
            values[next] = h;
        }
        this._next++;
        return h;
    };
    HandleStore.prototype.erase = function (start, end) {
        this._next = start;
        var values = this._values;
        for (var i = start; i < end; ++i) {
            values[i].dispose();
        }
    };
    HandleStore.prototype.get = function (id) {
        return this._values[id];
    };
    HandleStore.prototype.swap = function (a, b) {
        var values = this._values;
        var h = values[a];
        values[a] = values[b];
        values[a].id = Number(a);
        values[b] = h;
        h.id = Number(b);
    };
    HandleStore.prototype.dispose = function () {
        this._values.length = HandleStore.MIN_ID;
        this._next = HandleStore.MIN_ID;
    };
    HandleStore.UNDEFINED = new ConstHandle(1 /* GlobalHandle.UNDEFINED */, undefined);
    HandleStore.NULL = new ConstHandle(2 /* GlobalHandle.NULL */, null);
    HandleStore.FALSE = new ConstHandle(3 /* GlobalHandle.FALSE */, false);
    HandleStore.TRUE = new ConstHandle(4 /* GlobalHandle.TRUE */, true);
    HandleStore.GLOBAL = new ConstHandle(5 /* GlobalHandle.GLOBAL */, _global);
    HandleStore.MIN_ID = 6;
    return HandleStore;
}());

var HandleScope = /*#__PURE__*/ (function () {
    function HandleScope(handleStore, id, parentScope, start, end) {
        if (end === void 0) { end = start; }
        this.handleStore = handleStore;
        this.id = id;
        this.parent = parentScope;
        this.child = null;
        if (parentScope !== null)
            parentScope.child = this;
        this.start = start;
        this.end = end;
        this._escapeCalled = false;
    }
    HandleScope.prototype.add = function (value) {
        var h = this.handleStore.push(value);
        this.end++;
        return h;
    };
    HandleScope.prototype.addExternal = function (envObject, data) {
        var value = new External();
        var h = envObject.ctx.handleStore.push(value);
        var binding = envObject.initObjectBinding(value);
        binding.data = data;
        this.end++;
        return h;
    };
    HandleScope.prototype.dispose = function () {
        if (this.start === this.end)
            return;
        this.handleStore.erase(this.start, this.end);
    };
    HandleScope.prototype.escape = function (handle) {
        if (this._escapeCalled)
            return null;
        this._escapeCalled = true;
        if (handle < this.start || handle >= this.end) {
            return null;
        }
        this.handleStore.swap(handle, this.start);
        var h = this.handleStore.get(this.start);
        this.start++;
        this.parent.end++;
        return h;
    };
    HandleScope.prototype.escapeCalled = function () {
        return this._escapeCalled;
    };
    return HandleScope;
}());

var ScopeStore = /*#__PURE__*/ (function () {
    function ScopeStore() {
        this._rootScope = new HandleScope(null, 0, null, 1, HandleStore.MIN_ID);
        this.currentScope = this._rootScope;
    }
    ScopeStore.prototype.get = function (id) {
        id = Number(id);
        var scope = this.currentScope;
        while (scope !== this._rootScope) {
            if (scope.id === id) {
                return scope;
            }
            scope = scope.parent;
        }
        return undefined;
    };
    ScopeStore.prototype.openScope = function (envObject) {
        var currentScope = this.currentScope;
        var scope = currentScope.child;
        if (scope !== null) {
            scope.start = scope.end = currentScope.end;
            scope._escapeCalled = false;
        }
        else {
            scope = new HandleScope(envObject.ctx.handleStore, currentScope.id + 1, currentScope, currentScope.end);
        }
        this.currentScope = scope;
        envObject.openHandleScopes++;
        return scope;
    };
    ScopeStore.prototype.closeScope = function (envObject) {
        if (envObject.openHandleScopes === 0)
            return;
        var scope = this.currentScope;
        this.currentScope = scope.parent;
        scope.dispose();
        envObject.openHandleScopes--;
    };
    ScopeStore.prototype.dispose = function () {
        var scope = this.currentScope;
        while (scope !== null) {
            scope.handleStore = null;
            scope.id = 0;
            scope.parent = null;
            scope.start = HandleStore.MIN_ID;
            scope.end = HandleStore.MIN_ID;
            scope._escapeCalled = false;
            var child = scope.child;
            scope.child = null;
            scope = child;
        }
        this.currentScope = null;
    };
    return ScopeStore;
}());

var RefTracker = /*#__PURE__*/ (function () {
    function RefTracker() {
        this._next = null;
        this._prev = null;
    }
    /** @virtual */
    RefTracker.prototype.finalize = function () { };
    RefTracker.prototype.link = function (list) {
        this._prev = list;
        this._next = list._next;
        if (this._next !== null) {
            this._next._prev = this;
        }
        list._next = this;
    };
    RefTracker.prototype.unlink = function () {
        if (this._prev !== null) {
            this._prev._next = this._next;
        }
        if (this._next !== null) {
            this._next._prev = this._prev;
        }
        this._prev = null;
        this._next = null;
    };
    RefTracker.finalizeAll = function (list) {
        while (list._next !== null) {
            list._next.finalize();
        }
    };
    return RefTracker;
}());

var Finalizer = /*#__PURE__*/ (function () {
    function Finalizer(envObject, _finalizeCallback, _finalizeData, _finalizeHint) {
        if (_finalizeCallback === void 0) { _finalizeCallback = 0; }
        if (_finalizeData === void 0) { _finalizeData = 0; }
        if (_finalizeHint === void 0) { _finalizeHint = 0; }
        this.envObject = envObject;
        this._finalizeCallback = _finalizeCallback;
        this._finalizeData = _finalizeData;
        this._finalizeHint = _finalizeHint;
    }
    Finalizer.prototype.callback = function () { return this._finalizeCallback; };
    Finalizer.prototype.data = function () { return this._finalizeData; };
    Finalizer.prototype.hint = function () { return this._finalizeHint; };
    Finalizer.prototype.resetFinalizer = function () {
        this._finalizeCallback = 0;
        this._finalizeData = 0;
        this._finalizeHint = 0;
    };
    Finalizer.prototype.dispose = function () {
        this.envObject = undefined;
    };
    return Finalizer;
}());

var TrackedFinalizer = /*#__PURE__*/ (function (_super) {
    __extends(TrackedFinalizer, _super);
    function TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this, envObject, finalize_callback, finalize_data, finalize_hint) || this;
        _this._next = null;
        _this._prev = null;
        _this.link(!finalize_callback ? envObject.reflist : envObject.finalizing_reflist);
        return _this;
    }
    TrackedFinalizer.finalizeAll = function (list) {
        RefTracker.finalizeAll(list);
    };
    TrackedFinalizer.prototype.link = function (list) {
        RefTracker.prototype.link.call(this, list);
    };
    TrackedFinalizer.prototype.unlink = function () {
        RefTracker.prototype.unlink.call(this);
    };
    TrackedFinalizer.create = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        return new TrackedFinalizer(envObject, finalize_callback, finalize_data, finalize_hint);
    };
    TrackedFinalizer.prototype.dispose = function () {
        this.unlink();
        this.envObject.dequeueFinalizer(this);
        _super.prototype.dispose.call(this);
    };
    TrackedFinalizer.prototype.finalize = function () {
        this.finalizeCore(true);
    };
    TrackedFinalizer.prototype.finalizeCore = function (deleteMe) {
        var finalize_callback = this._finalizeCallback;
        var finalize_data = this._finalizeData;
        var finalize_hint = this._finalizeHint;
        this.resetFinalizer();
        this.unlink();
        var error;
        var caught = false;
        if (finalize_callback) {
            var fini = Number(finalize_callback);
            try {
                this.envObject.callFinalizer(fini, finalize_data, finalize_hint);
            }
            catch (err) {
                caught = true;
                error = err;
            }
        }
        if (deleteMe) {
            this.dispose();
        }
        if (caught) {
            throw error;
        }
    };
    return TrackedFinalizer;
}(Finalizer));

var RefBase = /*#__PURE__*/ (function (_super) {
    __extends(RefBase, _super);
    function RefBase(envObject, initial_refcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        var _this = _super.call(this, envObject, finalize_callback, finalize_data, finalize_hint) || this;
        _this._refcount = initial_refcount;
        _this._ownership = ownership;
        return _this;
    }
    RefBase.prototype.data = function () {
        return this._finalizeData;
    };
    RefBase.prototype.ref = function () {
        return ++this._refcount;
    };
    RefBase.prototype.unref = function () {
        if (this._refcount === 0) {
            return 0;
        }
        return --this._refcount;
    };
    RefBase.prototype.refCount = function () {
        return this._refcount;
    };
    RefBase.prototype.ownership = function () {
        return this._ownership;
    };
    RefBase.prototype.finalize = function () {
        this.finalizeCore(this._ownership === 0 /* Ownership.kRuntime */);
    };
    return RefBase;
}(TrackedFinalizer));

function throwNodeApiVersionError(moduleName, moduleApiVersion) {
    var errorMessage = "".concat(moduleName, " requires Node-API version ").concat(moduleApiVersion, ", but this version of Node.js only supports version ").concat(NODE_API_SUPPORTED_VERSION_MAX, " add-ons.");
    throw new Error(errorMessage);
}
function handleThrow(envObject, value) {
    if (envObject.terminatedOrTerminating()) {
        return;
    }
    throw value;
}
var Env = /*#__PURE__*/ (function () {
    function Env(ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) {
        this.ctx = ctx;
        this.moduleApiVersion = moduleApiVersion;
        this.makeDynCall_vppp = makeDynCall_vppp;
        this.makeDynCall_vp = makeDynCall_vp;
        this.abort = abort;
        this.openHandleScopes = 0;
        this.instanceData = null;
        this.tryCatch = new TryCatch();
        this.refs = 1;
        this.reflist = new RefTracker();
        this.finalizing_reflist = new RefTracker();
        this.pendingFinalizers = [];
        this.lastError = {
            errorCode: 0 /* napi_status.napi_ok */,
            engineErrorCode: 0,
            engineReserved: 0
        };
        this.inGcFinalizer = false;
        this._bindingMap = new WeakMap();
        this.id = 0;
    }
    /** @virtual */
    Env.prototype.canCallIntoJs = function () {
        return true;
    };
    Env.prototype.terminatedOrTerminating = function () {
        return !this.canCallIntoJs();
    };
    Env.prototype.ref = function () {
        this.refs++;
    };
    Env.prototype.unref = function () {
        this.refs--;
        if (this.refs === 0) {
            this.dispose();
        }
    };
    Env.prototype.ensureHandle = function (value) {
        return this.ctx.ensureHandle(value);
    };
    Env.prototype.ensureHandleId = function (value) {
        return this.ensureHandle(value).id;
    };
    Env.prototype.clearLastError = function () {
        var lastError = this.lastError;
        if (lastError.errorCode !== 0 /* napi_status.napi_ok */)
            lastError.errorCode = 0 /* napi_status.napi_ok */;
        if (lastError.engineErrorCode !== 0)
            lastError.engineErrorCode = 0;
        if (lastError.engineReserved !== 0)
            lastError.engineReserved = 0;
        return 0 /* napi_status.napi_ok */;
    };
    Env.prototype.setLastError = function (error_code, engine_error_code, engine_reserved) {
        if (engine_error_code === void 0) { engine_error_code = 0; }
        if (engine_reserved === void 0) { engine_reserved = 0; }
        var lastError = this.lastError;
        if (lastError.errorCode !== error_code)
            lastError.errorCode = error_code;
        if (lastError.engineErrorCode !== engine_error_code)
            lastError.engineErrorCode = engine_error_code;
        if (lastError.engineReserved !== engine_reserved)
            lastError.engineReserved = engine_reserved;
        return error_code;
    };
    Env.prototype.getReturnStatus = function () {
        return !this.tryCatch.hasCaught() ? 0 /* napi_status.napi_ok */ : this.setLastError(10 /* napi_status.napi_pending_exception */);
    };
    Env.prototype.callIntoModule = function (fn, handleException) {
        if (handleException === void 0) { handleException = handleThrow; }
        var openHandleScopesBefore = this.openHandleScopes;
        this.clearLastError();
        var r = fn(this);
        if (openHandleScopesBefore !== this.openHandleScopes) {
            this.abort('open_handle_scopes != open_handle_scopes_before');
        }
        if (this.tryCatch.hasCaught()) {
            var err = this.tryCatch.extractException();
            handleException(this, err);
        }
        return r;
    };
    /** @virtual */
    Env.prototype.callFinalizer = function (cb, data, hint) {
        var f = this.makeDynCall_vppp(cb);
        var env = this.id;
        var scope = this.ctx.openScope(this);
        try {
            this.callIntoModule(function () { f(env, data, hint); });
        }
        finally {
            this.ctx.closeScope(this, scope);
        }
    };
    Env.prototype.invokeFinalizerFromGC = function (finalizer) {
        if (this.moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
            this.enqueueFinalizer(finalizer);
        }
        else {
            var saved = this.inGcFinalizer;
            this.inGcFinalizer = true;
            try {
                finalizer.finalize();
            }
            finally {
                this.inGcFinalizer = saved;
            }
        }
    };
    Env.prototype.checkGCAccess = function () {
        if (this.moduleApiVersion === NAPI_VERSION_EXPERIMENTAL && this.inGcFinalizer) {
            this.abort('Finalizer is calling a function that may affect GC state.\n' +
                'The finalizers are run directly from GC and must not affect GC ' +
                'state.\n' +
                'Use `node_api_post_finalizer` from inside of the finalizer to work ' +
                'around this issue.\n' +
                'It schedules the call as a new task in the event loop.');
        }
    };
    /** @virtual */
    Env.prototype.enqueueFinalizer = function (finalizer) {
        if (this.pendingFinalizers.indexOf(finalizer) === -1) {
            this.pendingFinalizers.push(finalizer);
        }
    };
    /** @virtual */
    Env.prototype.dequeueFinalizer = function (finalizer) {
        var index = this.pendingFinalizers.indexOf(finalizer);
        if (index !== -1) {
            this.pendingFinalizers.splice(index, 1);
        }
    };
    /** @virtual */
    Env.prototype.deleteMe = function () {
        RefBase.finalizeAll(this.finalizing_reflist);
        RefBase.finalizeAll(this.reflist);
        this.tryCatch.extractException();
        this.ctx.envStore.remove(this.id);
    };
    Env.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.deleteMe();
        this.id = 0;
    };
    Env.prototype.initObjectBinding = function (value) {
        var binding = {
            wrapped: 0,
            tag: null,
            data: 0
        };
        this._bindingMap.set(value, binding);
        return binding;
    };
    Env.prototype.getObjectBinding = function (value) {
        if (this._bindingMap.has(value)) {
            return this._bindingMap.get(value);
        }
        return this.initObjectBinding(value);
    };
    Env.prototype.setInstanceData = function (data, finalize_cb, finalize_hint) {
        if (this.instanceData) {
            this.instanceData.dispose();
        }
        this.instanceData = new RefBase(this, 0, 0 /* Ownership.kRuntime */, finalize_cb, data, finalize_hint);
    };
    Env.prototype.getInstanceData = function () {
        return this.instanceData ? this.instanceData.data() : 0;
    };
    return Env;
}());
var NodeEnv = /*#__PURE__*/ (function (_super) {
    __extends(NodeEnv, _super);
    function NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        var _this = _super.call(this, ctx, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort) || this;
        _this.filename = filename;
        _this.nodeBinding = nodeBinding;
        _this.destructing = false;
        _this.finalizationScheduled = false;
        return _this;
    }
    NodeEnv.prototype.deleteMe = function () {
        this.destructing = true;
        this.drainFinalizerQueue();
        _super.prototype.deleteMe.call(this);
    };
    NodeEnv.prototype.canCallIntoJs = function () {
        return _super.prototype.canCallIntoJs.call(this) && this.ctx.canCallIntoJs();
    };
    NodeEnv.prototype.triggerFatalException = function (err) {
        if (this.nodeBinding) {
            this.nodeBinding.napi.fatalException(err);
        }
        else {
            {
                throw err;
            }
        }
    };
    NodeEnv.prototype.callbackIntoModule = function (enforceUncaughtExceptionPolicy, fn) {
        return this.callIntoModule(fn, function (envObject, err) {
            if (envObject.terminatedOrTerminating()) {
                return;
            }
            var hasForceFlag = false;
            if (envObject.moduleApiVersion < NAPI_VERSION_EXPERIMENTAL && !hasForceFlag && !enforceUncaughtExceptionPolicy) {
                var warn = function (warning, type, code) {
                        if (warning instanceof Error) {
                            console.warn(warning.toString());
                        }
                        else {
                            var prefix = code ? "[".concat(code, "] ") : '';
                            // eslint-disable-next-line @typescript-eslint/prefer-nullish-coalescing
                            console.warn("".concat(prefix).concat(type || 'Warning', ": ").concat(warning));
                        }
                    };
                warn('Uncaught N-API callback exception detected, please run node with option --force-node-api-uncaught-exceptions-policy=true to handle those exceptions properly.', 'DeprecationWarning', 'DEP0168');
                return;
            }
            envObject.triggerFatalException(err);
        });
    };
    NodeEnv.prototype.callFinalizer = function (cb, data, hint) {
        this.callFinalizerInternal(1, cb, data, hint);
    };
    NodeEnv.prototype.callFinalizerInternal = function (forceUncaught, cb, data, hint) {
        var f = this.makeDynCall_vppp(cb);
        var env = this.id;
        var scope = this.ctx.openScope(this);
        try {
            this.callbackIntoModule(Boolean(forceUncaught), function () { f(env, data, hint); });
        }
        finally {
            this.ctx.closeScope(this, scope);
        }
    };
    NodeEnv.prototype.enqueueFinalizer = function (finalizer) {
        var _this = this;
        _super.prototype.enqueueFinalizer.call(this, finalizer);
        if (!this.finalizationScheduled && !this.destructing) {
            this.finalizationScheduled = true;
            this.ref();
            _setImmediate(function () {
                _this.finalizationScheduled = false;
                _this.unref();
                _this.drainFinalizerQueue();
            });
        }
    };
    NodeEnv.prototype.drainFinalizerQueue = function () {
        while (this.pendingFinalizers.length > 0) {
            var refTracker = this.pendingFinalizers.shift();
            refTracker.finalize();
        }
    };
    return NodeEnv;
}(Env));
function newEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
    moduleApiVersion = typeof moduleApiVersion !== 'number' ? NODE_API_DEFAULT_MODULE_API_VERSION : moduleApiVersion;
    // Validate module_api_version.
    if (moduleApiVersion < NODE_API_DEFAULT_MODULE_API_VERSION) {
        moduleApiVersion = NODE_API_DEFAULT_MODULE_API_VERSION;
    }
    else if (moduleApiVersion > NODE_API_SUPPORTED_VERSION_MAX && moduleApiVersion !== NAPI_VERSION_EXPERIMENTAL) {
        throwNodeApiVersionError(filename, moduleApiVersion);
    }
    var env = new NodeEnv(ctx, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    ctx.envStore.add(env);
    ctx.addCleanupHook(env, function () { env.unref(); }, 0);
    return env;
}

var EmnapiError = /*#__PURE__*/ (function (_super) {
    __extends(EmnapiError, _super);
    function EmnapiError(message) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, message) || this;
        var ErrorConstructor = _newTarget;
        var proto = ErrorConstructor.prototype;
        if (!(_this instanceof EmnapiError)) {
            var setPrototypeOf = Object.setPrototypeOf;
            if (typeof setPrototypeOf === 'function') {
                setPrototypeOf.call(Object, _this, proto);
            }
            else {
                // eslint-disable-next-line no-proto
                _this.__proto__ = proto;
            }
            if (typeof Error.captureStackTrace === 'function') {
                Error.captureStackTrace(_this, ErrorConstructor);
            }
        }
        return _this;
    }
    return EmnapiError;
}(Error));
Object.defineProperty(EmnapiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'EmnapiError'
});
var NotSupportWeakRefError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportWeakRefError, _super);
    function NotSupportWeakRefError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"FinalizationRegistry\" and \"WeakRef\".").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportWeakRefError;
}(EmnapiError));
Object.defineProperty(NotSupportWeakRefError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportWeakRefError'
});
var NotSupportBufferError = /*#__PURE__*/ (function (_super) {
    __extends(NotSupportBufferError, _super);
    function NotSupportBufferError(api, message) {
        return _super.call(this, "".concat(api, ": The current runtime does not support \"Buffer\". Consider using buffer polyfill to make sure `globalThis.Buffer` is defined.").concat(message ? " ".concat(message) : '')) || this;
    }
    return NotSupportBufferError;
}(EmnapiError));
Object.defineProperty(NotSupportBufferError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'NotSupportBufferError'
});

var StrongRef = /*#__PURE__*/ (function () {
    function StrongRef(value) {
        this._value = value;
    }
    StrongRef.prototype.deref = function () {
        return this._value;
    };
    StrongRef.prototype.dispose = function () {
        this._value = undefined;
    };
    return StrongRef;
}());
var Persistent = /*#__PURE__*/ (function () {
    function Persistent(value) {
        this._ref = new StrongRef(value);
    }
    Persistent.prototype.setWeak = function (param, callback) {
        if (!supportFinalizer || this._ref === undefined || this._ref instanceof WeakRef)
            return;
        var value = this._ref.deref();
        try {
            Persistent._registry.register(value, this, this);
            var weakRef = new WeakRef(value);
            this._ref.dispose();
            this._ref = weakRef;
            this._param = param;
            this._callback = callback;
        }
        catch (err) {
            if (typeof value === 'symbol') ;
            else {
                throw err;
            }
        }
    };
    Persistent.prototype.clearWeak = function () {
        if (!supportFinalizer || this._ref === undefined)
            return;
        if (this._ref instanceof WeakRef) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
            this._param = undefined;
            this._callback = undefined;
            var value = this._ref.deref();
            if (value === undefined) {
                this._ref = value;
            }
            else {
                this._ref = new StrongRef(value);
            }
        }
    };
    Persistent.prototype.reset = function () {
        if (supportFinalizer) {
            try {
                Persistent._registry.unregister(this);
            }
            catch (_) { }
        }
        this._param = undefined;
        this._callback = undefined;
        if (this._ref instanceof StrongRef) {
            this._ref.dispose();
        }
        this._ref = undefined;
    };
    Persistent.prototype.isEmpty = function () {
        return this._ref === undefined;
    };
    Persistent.prototype.deref = function () {
        if (this._ref === undefined)
            return undefined;
        return this._ref.deref();
    };
    Persistent._registry = supportFinalizer
        ? new FinalizationRegistry(function (value) {
            value._ref = undefined;
            var callback = value._callback;
            var param = value._param;
            value._callback = undefined;
            value._param = undefined;
            if (typeof callback === 'function') {
                callback(param);
            }
        })
        : undefined;
    return Persistent;
}());

function weakCallback(ref) {
    ref.persistent.reset();
    ref.envObject.invokeFinalizerFromGC(ref);
}
function canBeHeldWeakly(value) {
    return value.isObject() || value.isFunction() || value.isSymbol();
}
var Reference = /*#__PURE__*/ (function (_super) {
    __extends(Reference, _super);
    function Reference(envObject, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        if (finalize_callback === void 0) { finalize_callback = 0; }
        if (finalize_data === void 0) { finalize_data = 0; }
        if (finalize_hint === void 0) { finalize_hint = 0; }
        var _this = _super.call(this, envObject, initialRefcount >>> 0, ownership, finalize_callback, finalize_data, finalize_hint) || this;
        _this.id = 0;
        return _this;
    }
    Reference.create = function (envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        if (finalize_callback === void 0) { finalize_callback = 0; }
        if (finalize_data === void 0) { finalize_data = 0; }
        if (finalize_hint === void 0) { finalize_hint = 0; }
        var handle = envObject.ctx.handleStore.get(handle_id);
        var ref = new Reference(envObject, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
        envObject.ctx.refStore.add(ref);
        ref.canBeWeak = canBeHeldWeakly(handle);
        ref.persistent = new Persistent(handle.value);
        if (initialRefcount === 0) {
            ref._setWeak();
        }
        return ref;
    };
    Reference.prototype.ref = function () {
        if (this.persistent.isEmpty()) {
            return 0;
        }
        var count = _super.prototype.ref.call(this);
        if (count === 1 && this.canBeWeak) {
            this.persistent.clearWeak();
        }
        return count;
    };
    Reference.prototype.unref = function () {
        if (this.persistent.isEmpty()) {
            return 0;
        }
        var oldRefcount = this.refCount();
        var refcount = _super.prototype.unref.call(this);
        if (oldRefcount === 1 && refcount === 0) {
            this._setWeak();
        }
        return refcount;
    };
    Reference.prototype.get = function () {
        if (this.persistent.isEmpty()) {
            return 0;
        }
        var obj = this.persistent.deref();
        var handle = this.envObject.ensureHandle(obj);
        return handle.id;
    };
    Reference.prototype._setWeak = function () {
        if (this.canBeWeak) {
            this.persistent.setWeak(this, weakCallback);
        }
        else {
            this.persistent.reset();
        }
    };
    Reference.prototype.finalize = function () {
        this.persistent.reset();
        _super.prototype.finalize.call(this);
    };
    Reference.prototype.dispose = function () {
        if (this.id === 0)
            return;
        this.persistent.reset();
        this.envObject.ctx.refStore.remove(this.id);
        _super.prototype.dispose.call(this);
        this.id = 0;
    };
    return Reference;
}(RefBase));

var Deferred = /*#__PURE__*/ (function () {
    function Deferred(ctx, value) {
        this.id = 0;
        this.ctx = ctx;
        this.value = value;
    }
    Deferred.create = function (ctx, value) {
        var deferred = new Deferred(ctx, value);
        ctx.deferredStore.add(deferred);
        return deferred;
    };
    Deferred.prototype.resolve = function (value) {
        this.value.resolve(value);
        this.dispose();
    };
    Deferred.prototype.reject = function (reason) {
        this.value.reject(reason);
        this.dispose();
    };
    Deferred.prototype.dispose = function () {
        this.ctx.deferredStore.remove(this.id);
        this.id = 0;
        this.value = null;
        this.ctx = null;
    };
    return Deferred;
}());

var Store = /*#__PURE__*/ (function () {
    function Store() {
        this._values = [undefined];
        this._values.length = 4;
        this._size = 1;
        this._freeList = [];
    }
    Store.prototype.add = function (value) {
        var id;
        if (this._freeList.length) {
            id = this._freeList.shift();
        }
        else {
            id = this._size;
            this._size++;
            var capacity = this._values.length;
            if (id >= capacity) {
                this._values.length = capacity + (capacity >> 1) + 16;
            }
        }
        value.id = id;
        this._values[id] = value;
    };
    Store.prototype.get = function (id) {
        return this._values[id];
    };
    Store.prototype.has = function (id) {
        return this._values[id] !== undefined;
    };
    Store.prototype.remove = function (id) {
        var value = this._values[id];
        if (value) {
            value.id = 0;
            this._values[id] = undefined;
            this._freeList.push(Number(id));
        }
    };
    Store.prototype.dispose = function () {
        for (var i = 1; i < this._size; ++i) {
            var value = this._values[i];
            value === null || value === void 0 ? void 0 : value.dispose();
        }
        this._values = [undefined];
        this._size = 1;
        this._freeList = [];
    };
    return Store;
}());

var CleanupHookCallback = /*#__PURE__*/ (function () {
    function CleanupHookCallback(envObject, fn, arg, order) {
        this.envObject = envObject;
        this.fn = fn;
        this.arg = arg;
        this.order = order;
    }
    return CleanupHookCallback;
}());
var CleanupQueue = /*#__PURE__*/ (function () {
    function CleanupQueue() {
        this._cleanupHooks = [];
        this._cleanupHookCounter = 0;
    }
    CleanupQueue.prototype.empty = function () {
        return this._cleanupHooks.length === 0;
    };
    CleanupQueue.prototype.add = function (envObject, fn, arg) {
        if (this._cleanupHooks.filter(function (hook) { return (hook.envObject === envObject && hook.fn === fn && hook.arg === arg); }).length > 0) {
            throw new Error('Can not add same fn and arg twice');
        }
        this._cleanupHooks.push(new CleanupHookCallback(envObject, fn, arg, this._cleanupHookCounter++));
    };
    CleanupQueue.prototype.remove = function (envObject, fn, arg) {
        for (var i = 0; i < this._cleanupHooks.length; ++i) {
            var hook = this._cleanupHooks[i];
            if (hook.envObject === envObject && hook.fn === fn && hook.arg === arg) {
                this._cleanupHooks.splice(i, 1);
                return;
            }
        }
    };
    CleanupQueue.prototype.drain = function () {
        var hooks = this._cleanupHooks.slice();
        hooks.sort(function (a, b) { return (b.order - a.order); });
        for (var i = 0; i < hooks.length; ++i) {
            var cb = hooks[i];
            if (typeof cb.fn === 'number') {
                cb.envObject.makeDynCall_vp(cb.fn)(cb.arg);
            }
            else {
                cb.fn(cb.arg);
            }
            this._cleanupHooks.splice(this._cleanupHooks.indexOf(cb), 1);
        }
    };
    CleanupQueue.prototype.dispose = function () {
        this._cleanupHooks.length = 0;
        this._cleanupHookCounter = 0;
    };
    return CleanupQueue;
}());
var Context = /*#__PURE__*/ (function () {
    function Context() {
        this._isStopping = false;
        this._canCallIntoJs = true;
        this.envStore = new Store();
        this.scopeStore = new ScopeStore();
        this.refStore = new Store();
        this.deferredStore = new Store();
        this.handleStore = new HandleStore();
        this.cbinfoStack = new CallbackInfoStack();
        this.feature = {
            supportReflect: supportReflect,
            supportFinalizer: supportFinalizer,
            supportWeakSymbol: supportWeakSymbol,
            supportBigInt: supportBigInt,
            supportNewFunction: supportNewFunction,
            canSetFunctionName: canSetFunctionName,
            setImmediate: _setImmediate,
            Buffer: _Buffer,
            MessageChannel: _MessageChannel
        };
        this.cleanupQueue = new CleanupQueue();
    }
    // eslint-disable-next-line @typescript-eslint/explicit-function-return-type
    Context.prototype.getRuntimeVersions = function () {
        return {
            version: version,
            NODE_API_SUPPORTED_VERSION_MAX: NODE_API_SUPPORTED_VERSION_MAX,
            NAPI_VERSION_EXPERIMENTAL: NAPI_VERSION_EXPERIMENTAL,
            NODE_API_DEFAULT_MODULE_API_VERSION: NODE_API_DEFAULT_MODULE_API_VERSION
        };
    };
    Context.prototype.createNotSupportWeakRefError = function (api, message) {
        return new NotSupportWeakRefError(api, message);
    };
    Context.prototype.createNotSupportBufferError = function (api, message) {
        return new NotSupportBufferError(api, message);
    };
    Context.prototype.createReference = function (envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint) {
        if (finalize_callback === void 0) { finalize_callback = 0; }
        if (finalize_data === void 0) { finalize_data = 0; }
        if (finalize_hint === void 0) { finalize_hint = 0; }
        return Reference.create(envObject, handle_id, initialRefcount, ownership, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.createDeferred = function (value) {
        return Deferred.create(this, value);
    };
    Context.prototype.createEnv = function (filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding) {
        return newEnv(this, filename, moduleApiVersion, makeDynCall_vppp, makeDynCall_vp, abort, nodeBinding);
    };
    Context.prototype.createTrackedFinalizer = function (envObject, finalize_callback, finalize_data, finalize_hint) {
        return TrackedFinalizer.create(envObject, finalize_callback, finalize_data, finalize_hint);
    };
    Context.prototype.getCurrentScope = function () {
        return this.scopeStore.currentScope;
    };
    Context.prototype.addToCurrentScope = function (value) {
        return this.scopeStore.currentScope.add(value);
    };
    Context.prototype.openScope = function (envObject) {
        return this.scopeStore.openScope(envObject);
    };
    Context.prototype.closeScope = function (envObject, _scope) {
        this.scopeStore.closeScope(envObject);
    };
    Context.prototype.ensureHandle = function (value) {
        switch (value) {
            case undefined: return HandleStore.UNDEFINED;
            case null: return HandleStore.NULL;
            case true: return HandleStore.TRUE;
            case false: return HandleStore.FALSE;
            case _global: return HandleStore.GLOBAL;
        }
        return this.addToCurrentScope(value);
    };
    Context.prototype.addCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.add(envObject, fn, arg);
    };
    Context.prototype.removeCleanupHook = function (envObject, fn, arg) {
        this.cleanupQueue.remove(envObject, fn, arg);
    };
    Context.prototype.runCleanup = function () {
        while (!this.cleanupQueue.empty()) {
            this.cleanupQueue.drain();
        }
    };
    Context.prototype.increaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.increase();
    };
    Context.prototype.decreaseWaitingRequestCounter = function () {
        var _a;
        (_a = this.refCounter) === null || _a === void 0 ? void 0 : _a.decrease();
    };
    Context.prototype.setCanCallIntoJs = function (value) {
        this._canCallIntoJs = value;
    };
    Context.prototype.setStopping = function (value) {
        this._isStopping = value;
    };
    Context.prototype.canCallIntoJs = function () {
        return this._canCallIntoJs && !this._isStopping;
    };
    Context.prototype.destroy = function () {
        this.setStopping(true);
        this.setCanCallIntoJs(false);
        this.runCleanup();
    };
    return Context;
}());
var defaultContext;
function createContext() {
    return new Context();
}
function getDefaultContext() {
    if (!defaultContext) {
        defaultContext = createContext();
    }
    return defaultContext;
}

const _WebAssembly = typeof WebAssembly !== 'undefined'
    ? WebAssembly
    : typeof WXWebAssembly !== 'undefined'
        ? WXWebAssembly
        : undefined;
if (!_WebAssembly) {
    throw new Error('WebAssembly is not supported in this environment');
}

/* eslint-disable spaced-comment */

function validateObject(value, name) {
    if (value === null || typeof value !== 'object') {
        throw new TypeError(`${name} must be an object. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateArray(value, name) {
    if (!Array.isArray(value)) {
        throw new TypeError(`${name} must be an array. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateBoolean(value, name) {
    if (typeof value !== 'boolean') {
        throw new TypeError(`${name} must be a boolean. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateString(value, name) {
    if (typeof value !== 'string') {
        throw new TypeError(`${name} must be a string. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateFunction(value, name) {
    if (typeof value !== 'function') {
        throw new TypeError(`${name} must be a function. Received ${value === null ? 'null' : typeof value}`);
    }
}
function validateUndefined(value, name) {
    if (value !== undefined) {
        throw new TypeError(`${name} must be undefined. Received ${value === null ? 'null' : typeof value}`);
    }
}
function isPromiseLike(obj) {
    return !!(obj && (typeof obj === 'object' || typeof obj === 'function') && typeof obj.then === 'function');
}
function unsharedSlice(view, start, end) {
    return ((typeof SharedArrayBuffer === 'function' && view.buffer instanceof SharedArrayBuffer) || (Object.prototype.toString.call(view.buffer.constructor) === '[object SharedArrayBuffer]'))
        ? view.slice(start, end)
        : view.subarray(start, end);
}

const CHAR_DOT = 46; /* . */
const CHAR_FORWARD_SLASH = 47; /* / */
function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
}
function normalizeString(path, allowAboveRoot, separator, isPathSeparator) {
    let res = '';
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path.length; ++i) {
        if (i < path.length) {
            code = path.charCodeAt(i);
        }
        else if (isPathSeparator(code)) {
            break;
        }
        else {
            code = CHAR_FORWARD_SLASH;
        }
        if (isPathSeparator(code)) {
            if (lastSlash === i - 1 || dots === 1) ;
            else if (dots === 2) {
                if (res.length < 2 || lastSegmentLength !== 2 ||
                    res.charCodeAt(res.length - 1) !== CHAR_DOT ||
                    res.charCodeAt(res.length - 2) !== CHAR_DOT) {
                    if (res.length > 2) {
                        const lastSlashIndex = res.indexOf(separator);
                        if (lastSlashIndex === -1) {
                            res = '';
                            lastSegmentLength = 0;
                        }
                        else {
                            res = res.slice(0, lastSlashIndex);
                            lastSegmentLength =
                                res.length - 1 - res.indexOf(separator);
                        }
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                    else if (res.length !== 0) {
                        res = '';
                        lastSegmentLength = 0;
                        lastSlash = i;
                        dots = 0;
                        continue;
                    }
                }
                if (allowAboveRoot) {
                    res += res.length > 0 ? `${separator}..` : '..';
                    lastSegmentLength = 2;
                }
            }
            else {
                if (res.length > 0) {
                    res += `${separator}${path.slice(lastSlash + 1, i)}`;
                }
                else {
                    res = path.slice(lastSlash + 1, i);
                }
                lastSegmentLength = i - lastSlash - 1;
            }
            lastSlash = i;
            dots = 0;
        }
        else if (code === CHAR_DOT && dots !== -1) {
            ++dots;
        }
        else {
            dots = -1;
        }
    }
    return res;
}
function resolve(...args) {
    let resolvedPath = '';
    let resolvedAbsolute = false;
    for (let i = args.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        const path = i >= 0 ? args[i] : '/';
        validateString(path, 'path');
        // Skip empty entries
        if (path.length === 0) {
            continue;
        }
        resolvedPath = `${path}/${resolvedPath}`;
        resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)
    // Normalize the path
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, '/', isPosixPathSeparator);
    if (resolvedAbsolute) {
        return `/${resolvedPath}`;
    }
    return resolvedPath.length > 0 ? resolvedPath : '.';
}

const FD_DATASYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(0));
const FD_READ = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(1));
const FD_SEEK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(2));
const FD_FDSTAT_SET_FLAGS = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(3));
const FD_SYNC = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(4));
const FD_TELL = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(5));
const FD_WRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(6));
const FD_ADVISE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(7));
const FD_ALLOCATE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(8));
const PATH_CREATE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(9));
const PATH_CREATE_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(10));
const PATH_LINK_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(11));
const PATH_LINK_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(12));
const PATH_OPEN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(13));
const FD_READDIR = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(14));
const PATH_READLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(15));
const PATH_RENAME_SOURCE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(16));
const PATH_RENAME_TARGET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(17));
const PATH_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(18));
const PATH_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(19));
const PATH_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(20));
const FD_FILESTAT_GET = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(21));
const FD_FILESTAT_SET_SIZE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(22));
const FD_FILESTAT_SET_TIMES = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(23));
const PATH_SYMLINK = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(24));
const PATH_REMOVE_DIRECTORY = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(25));
const PATH_UNLINK_FILE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(26));
const POLL_FD_READWRITE = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(27));
const SOCK_SHUTDOWN = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(28));
const SOCK_ACCEPT = ( /*#__PURE__*/BigInt(1) << /*#__PURE__*/ BigInt(29));
const WasiRights = {
    FD_DATASYNC,
    FD_READ,
    FD_SEEK,
    FD_FDSTAT_SET_FLAGS,
    FD_SYNC,
    FD_TELL,
    FD_WRITE,
    FD_ADVISE,
    FD_ALLOCATE,
    PATH_CREATE_DIRECTORY,
    PATH_CREATE_FILE,
    PATH_LINK_SOURCE,
    PATH_LINK_TARGET,
    PATH_OPEN,
    FD_READDIR,
    PATH_READLINK,
    PATH_RENAME_SOURCE,
    PATH_RENAME_TARGET,
    PATH_FILESTAT_GET,
    PATH_FILESTAT_SET_SIZE,
    PATH_FILESTAT_SET_TIMES,
    FD_FILESTAT_GET,
    FD_FILESTAT_SET_SIZE,
    FD_FILESTAT_SET_TIMES,
    PATH_SYMLINK,
    PATH_REMOVE_DIRECTORY,
    PATH_UNLINK_FILE,
    POLL_FD_READWRITE,
    SOCK_SHUTDOWN,
    SOCK_ACCEPT
};

function strerror(errno) {
    switch (errno) {
        case 0 /* WasiErrno.ESUCCESS */: return 'Success';
        case 1 /* WasiErrno.E2BIG */: return 'Argument list too long';
        case 2 /* WasiErrno.EACCES */: return 'Permission denied';
        case 3 /* WasiErrno.EADDRINUSE */: return 'Address in use';
        case 4 /* WasiErrno.EADDRNOTAVAIL */: return 'Address not available';
        case 5 /* WasiErrno.EAFNOSUPPORT */: return 'Address family not supported by protocol';
        case 6 /* WasiErrno.EAGAIN */: return 'Resource temporarily unavailable';
        case 7 /* WasiErrno.EALREADY */: return 'Operation already in progress';
        case 8 /* WasiErrno.EBADF */: return 'Bad file descriptor';
        case 9 /* WasiErrno.EBADMSG */: return 'Bad message';
        case 10 /* WasiErrno.EBUSY */: return 'Resource busy';
        case 11 /* WasiErrno.ECANCELED */: return 'Operation canceled';
        case 12 /* WasiErrno.ECHILD */: return 'No child null';
        case 13 /* WasiErrno.ECONNABORTED */: return 'Connection aborted';
        case 14 /* WasiErrno.ECONNREFUSED */: return 'Connection refused';
        case 15 /* WasiErrno.ECONNRESET */: return 'Connection reset by peer';
        case 16 /* WasiErrno.EDEADLK */: return 'Resource deadlock would occur';
        case 17 /* WasiErrno.EDESTADDRREQ */: return 'Destination address required';
        case 18 /* WasiErrno.EDOM */: return 'Domain error';
        case 19 /* WasiErrno.EDQUOT */: return 'Quota exceeded';
        case 20 /* WasiErrno.EEXIST */: return 'File exists';
        case 21 /* WasiErrno.EFAULT */: return 'Bad address';
        case 22 /* WasiErrno.EFBIG */: return 'File too large';
        case 23 /* WasiErrno.EHOSTUNREACH */: return 'Host is unreachable';
        case 24 /* WasiErrno.EIDRM */: return 'Identifier removed';
        case 25 /* WasiErrno.EILSEQ */: return 'Illegal byte sequence';
        case 26 /* WasiErrno.EINPROGRESS */: return 'Operation in progress';
        case 27 /* WasiErrno.EINTR */: return 'Interrupted system call';
        case 28 /* WasiErrno.EINVAL */: return 'Invalid argument';
        case 29 /* WasiErrno.EIO */: return 'I/O error';
        case 30 /* WasiErrno.EISCONN */: return 'Socket is connected';
        case 31 /* WasiErrno.EISDIR */: return 'Is a directory';
        case 32 /* WasiErrno.ELOOP */: return 'Symbolic link loop';
        case 33 /* WasiErrno.EMFILE */: return 'No file descriptors available';
        case 34 /* WasiErrno.EMLINK */: return 'Too many links';
        case 35 /* WasiErrno.EMSGSIZE */: return 'Message too large';
        case 36 /* WasiErrno.EMULTIHOP */: return 'Multihop attempted';
        case 37 /* WasiErrno.ENAMETOOLONG */: return 'Filename too long';
        case 38 /* WasiErrno.ENETDOWN */: return 'Network is down';
        case 39 /* WasiErrno.ENETRESET */: return 'Connection reset by network';
        case 40 /* WasiErrno.ENETUNREACH */: return 'Network unreachable';
        case 41 /* WasiErrno.ENFILE */: return 'Too many files open in system';
        case 42 /* WasiErrno.ENOBUFS */: return 'No buffer space available';
        case 43 /* WasiErrno.ENODEV */: return 'No such device';
        case 44 /* WasiErrno.ENOENT */: return 'No such file or directory';
        case 45 /* WasiErrno.ENOEXEC */: return 'Exec format error';
        case 46 /* WasiErrno.ENOLCK */: return 'No locks available';
        case 47 /* WasiErrno.ENOLINK */: return 'Link has been severed';
        case 48 /* WasiErrno.ENOMEM */: return 'Out of memory';
        case 49 /* WasiErrno.ENOMSG */: return 'No message of the desired type';
        case 50 /* WasiErrno.ENOPROTOOPT */: return 'Protocol not available';
        case 51 /* WasiErrno.ENOSPC */: return 'No space left on device';
        case 52 /* WasiErrno.ENOSYS */: return 'Function not implemented';
        case 53 /* WasiErrno.ENOTCONN */: return 'Socket not connected';
        case 54 /* WasiErrno.ENOTDIR */: return 'Not a directory';
        case 55 /* WasiErrno.ENOTEMPTY */: return 'Directory not empty';
        case 56 /* WasiErrno.ENOTRECOVERABLE */: return 'State not recoverable';
        case 57 /* WasiErrno.ENOTSOCK */: return 'Not a socket';
        case 58 /* WasiErrno.ENOTSUP */: return 'Not supported';
        case 59 /* WasiErrno.ENOTTY */: return 'Not a tty';
        case 60 /* WasiErrno.ENXIO */: return 'No such device or address';
        case 61 /* WasiErrno.EOVERFLOW */: return 'Value too large for data type';
        case 62 /* WasiErrno.EOWNERDEAD */: return 'Previous owner died';
        case 63 /* WasiErrno.EPERM */: return 'Operation not permitted';
        case 64 /* WasiErrno.EPIPE */: return 'Broken pipe';
        case 65 /* WasiErrno.EPROTO */: return 'Protocol error';
        case 66 /* WasiErrno.EPROTONOSUPPORT */: return 'Protocol not supported';
        case 67 /* WasiErrno.EPROTOTYPE */: return 'Protocol wrong type for socket';
        case 68 /* WasiErrno.ERANGE */: return 'Result not representable';
        case 69 /* WasiErrno.EROFS */: return 'Read-only file system';
        case 70 /* WasiErrno.ESPIPE */: return 'Invalid seek';
        case 71 /* WasiErrno.ESRCH */: return 'No such null';
        case 72 /* WasiErrno.ESTALE */: return 'Stale file handle';
        case 73 /* WasiErrno.ETIMEDOUT */: return 'Operation timed out';
        case 74 /* WasiErrno.ETXTBSY */: return 'Text file busy';
        case 75 /* WasiErrno.EXDEV */: return 'Cross-device link';
        case 76 /* WasiErrno.ENOTCAPABLE */: return 'Capabilities insufficient';
        default: return 'Unknown error';
    }
}
class WasiError extends Error {
    constructor(message, errno) {
        super(message);
        this.errno = errno;
    }
    getErrorMessage() {
        return strerror(this.errno);
    }
}
Object.defineProperty(WasiError.prototype, 'name', {
    configurable: true,
    writable: true,
    value: 'WasiError'
});

const RIGHTS_ALL = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN |
    WasiRights.SOCK_ACCEPT;
const BLOCK_DEVICE_BASE = RIGHTS_ALL;
const BLOCK_DEVICE_INHERITING = RIGHTS_ALL;
const CHARACTER_DEVICE_BASE = RIGHTS_ALL;
const CHARACTER_DEVICE_INHERITING = RIGHTS_ALL;
const REGULAR_FILE_BASE = WasiRights.FD_DATASYNC |
    WasiRights.FD_READ |
    WasiRights.FD_SEEK |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_TELL |
    WasiRights.FD_WRITE |
    WasiRights.FD_ADVISE |
    WasiRights.FD_ALLOCATE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_SIZE |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.POLL_FD_READWRITE;
const REGULAR_FILE_INHERITING = /*#__PURE__*/ BigInt(0);
const DIRECTORY_BASE = WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_SYNC |
    WasiRights.FD_ADVISE |
    WasiRights.PATH_CREATE_DIRECTORY |
    WasiRights.PATH_CREATE_FILE |
    WasiRights.PATH_LINK_SOURCE |
    WasiRights.PATH_LINK_TARGET |
    WasiRights.PATH_OPEN |
    WasiRights.FD_READDIR |
    WasiRights.PATH_READLINK |
    WasiRights.PATH_RENAME_SOURCE |
    WasiRights.PATH_RENAME_TARGET |
    WasiRights.PATH_FILESTAT_GET |
    WasiRights.PATH_FILESTAT_SET_SIZE |
    WasiRights.PATH_FILESTAT_SET_TIMES |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.FD_FILESTAT_SET_TIMES |
    WasiRights.PATH_SYMLINK |
    WasiRights.PATH_UNLINK_FILE |
    WasiRights.PATH_REMOVE_DIRECTORY |
    WasiRights.POLL_FD_READWRITE;
const DIRECTORY_INHERITING = DIRECTORY_BASE | REGULAR_FILE_BASE;
const SOCKET_BASE = (WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE |
    WasiRights.SOCK_SHUTDOWN);
const SOCKET_INHERITING = RIGHTS_ALL;
const TTY_BASE = WasiRights.FD_READ |
    WasiRights.FD_FDSTAT_SET_FLAGS |
    WasiRights.FD_WRITE |
    WasiRights.FD_FILESTAT_GET |
    WasiRights.POLL_FD_READWRITE;
const TTY_INHERITING = /*#__PURE__*/ BigInt(0);
function getRights(stdio, fd, flags, type) {
    const ret = {
        base: BigInt(0),
        inheriting: BigInt(0)
    };
    if (type === 0 /* WasiFileType.UNKNOWN */) {
        throw new WasiError('Unknown file type', 28 /* WasiErrno.EINVAL */);
    }
    switch (type) {
        case 4 /* WasiFileType.REGULAR_FILE */:
            ret.base = REGULAR_FILE_BASE;
            ret.inheriting = REGULAR_FILE_INHERITING;
            break;
        case 3 /* WasiFileType.DIRECTORY */:
            ret.base = DIRECTORY_BASE;
            ret.inheriting = DIRECTORY_INHERITING;
            break;
        case 6 /* WasiFileType.SOCKET_STREAM */:
        case 5 /* WasiFileType.SOCKET_DGRAM */:
            ret.base = SOCKET_BASE;
            ret.inheriting = SOCKET_INHERITING;
            break;
        case 2 /* WasiFileType.CHARACTER_DEVICE */:
            if (stdio.indexOf(fd) !== -1) {
                ret.base = TTY_BASE;
                ret.inheriting = TTY_INHERITING;
            }
            else {
                ret.base = CHARACTER_DEVICE_BASE;
                ret.inheriting = CHARACTER_DEVICE_INHERITING;
            }
            break;
        case 1 /* WasiFileType.BLOCK_DEVICE */:
            ret.base = BLOCK_DEVICE_BASE;
            ret.inheriting = BLOCK_DEVICE_INHERITING;
            break;
        default:
            ret.base = BigInt(0);
            ret.inheriting = BigInt(0);
    }
    /* Disable read/write bits depending on access mode. */
    const read_or_write_only = flags & (0 | 1 | 2);
    if (read_or_write_only === 0) {
        ret.base &= ~WasiRights.FD_WRITE;
    }
    else if (read_or_write_only === 1) {
        ret.base &= ~WasiRights.FD_READ;
    }
    return ret;
}

function concatBuffer(buffers, size) {
    let total = 0;
    {
        for (let i = 0; i < buffers.length; i++) {
            const buffer = buffers[i];
            total += buffer.length;
        }
    }
    let pos = 0;
    const ret = new Uint8Array(total);
    for (let i = 0; i < buffers.length; i++) {
        const buffer = buffers[i];
        ret.set(buffer, pos);
        pos += buffer.length;
    }
    return ret;
}
class FileDescriptor {
    constructor(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        this.id = id;
        this.fd = fd;
        this.path = path;
        this.realPath = realPath;
        this.type = type;
        this.rightsBase = rightsBase;
        this.rightsInheriting = rightsInheriting;
        this.preopen = preopen;
        this.pos = BigInt(0);
        this.size = BigInt(0);
    }
    seek(offset, whence) {
        if (whence === 0 /* WasiWhence.SET */) {
            this.pos = BigInt(offset);
        }
        else if (whence === 1 /* WasiWhence.CUR */) {
            this.pos += BigInt(offset);
        }
        else if (whence === 2 /* WasiWhence.END */) {
            this.pos = BigInt(this.size) - BigInt(offset);
        }
        else {
            throw new WasiError('Unknown whence', 29 /* WasiErrno.EIO */);
        }
        return this.pos;
    }
}
class StandardOutput extends FileDescriptor {
    constructor(log, id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen) {
        super(id, fd, path, realPath, type, rightsBase, rightsInheriting, preopen);
        this._log = log;
        this._buf = null;
    }
    write(buffer) {
        const originalBuffer = buffer;
        if (this._buf) {
            buffer = concatBuffer([this._buf, buffer]);
            this._buf = null;
        }
        if (buffer.indexOf(10) === -1) {
            this._buf = buffer;
            return originalBuffer.byteLength;
        }
        let written = 0;
        let lastBegin = 0;
        let index;
        while ((index = buffer.indexOf(10, written)) !== -1) {
            const str = new TextDecoder().decode(buffer.subarray(lastBegin, index));
            this._log(str);
            written += index - lastBegin + 1;
            lastBegin = index + 1;
        }
        if (written < buffer.length) {
            this._buf = buffer.slice(written);
        }
        return originalBuffer.byteLength;
    }
}
function toFileType(stat) {
    if (stat.isBlockDevice())
        return 1 /* WasiFileType.BLOCK_DEVICE */;
    if (stat.isCharacterDevice())
        return 2 /* WasiFileType.CHARACTER_DEVICE */;
    if (stat.isDirectory())
        return 3 /* WasiFileType.DIRECTORY */;
    if (stat.isSocket())
        return 6 /* WasiFileType.SOCKET_STREAM */;
    if (stat.isFile())
        return 4 /* WasiFileType.REGULAR_FILE */;
    if (stat.isSymbolicLink())
        return 7 /* WasiFileType.SYMBOLIC_LINK */;
    return 0 /* WasiFileType.UNKNOWN */;
}
function toFileStat(view, buf, stat) {
    view.setBigUint64(buf, stat.dev, true);
    view.setBigUint64(buf + 8, stat.ino, true);
    view.setBigUint64(buf + 16, BigInt(toFileType(stat)), true);
    view.setBigUint64(buf + 24, stat.nlink, true);
    view.setBigUint64(buf + 32, stat.size, true);
    view.setBigUint64(buf + 40, stat.atimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 48, stat.mtimeMs * BigInt(1000000), true);
    view.setBigUint64(buf + 56, stat.ctimeMs * BigInt(1000000), true);
}
class FileDescriptorTable {
    constructor(options) {
        this.used = 0;
        this.size = options.size;
        this.fds = Array(options.size);
        this.stdio = [options.in, options.out, options.err];
        this.print = options.print;
        this.printErr = options.printErr;
        this.insertStdio(options.in, 0, '<stdin>');
        this.insertStdio(options.out, 1, '<stdout>');
        this.insertStdio(options.err, 2, '<stderr>');
    }
    insertStdio(fd, expected, name) {
        const type = 2 /* WasiFileType.CHARACTER_DEVICE */;
        const { base, inheriting } = getRights(this.stdio, fd, 2 /* FileControlFlag.O_RDWR */, type);
        const wrap = this.insert(fd, name, name, type, base, inheriting, 0);
        if (wrap.id !== expected) {
            throw new WasiError(`id: ${wrap.id} !== expected: ${expected}`, 8 /* WasiErrno.EBADF */);
        }
        return wrap;
    }
    insert(fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen) {
        var _a, _b;
        let index = -1;
        if (this.used >= this.size) {
            const newSize = this.size * 2;
            this.fds.length = newSize;
            index = this.size;
            this.size = newSize;
        }
        else {
            for (let i = 0; i < this.size; ++i) {
                if (this.fds[i] == null) {
                    index = i;
                    break;
                }
            }
        }
        let entry;
        if (mappedPath === '<stdout>') {
            entry = new StandardOutput((_a = this.print) !== null && _a !== void 0 ? _a : console.log, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else if (mappedPath === '<stderr>') {
            entry = new StandardOutput((_b = this.printErr) !== null && _b !== void 0 ? _b : console.error, index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        else {
            entry = new FileDescriptor(index, fd, mappedPath, realPath, type, rightsBase, rightsInheriting, preopen);
        }
        this.fds[index] = entry;
        this.used++;
        return entry;
    }
    get(id, base, inheriting) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        /* Validate that the fd has the necessary rights. */
        if ((~entry.rightsBase & base) !== BigInt(0) || (~entry.rightsInheriting & inheriting) !== BigInt(0)) {
            throw new WasiError('Capabilities insufficient', 76 /* WasiErrno.ENOTCAPABLE */);
        }
        return entry;
    }
    remove(id) {
        if (id >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const entry = this.fds[id];
        if (!entry || entry.id !== id) {
            throw new WasiError('Bad file descriptor', 8 /* WasiErrno.EBADF */);
        }
        this.fds[id] = undefined;
        this.used--;
    }
}
class SyncTable extends FileDescriptorTable {
    constructor(options) {
        super(options);
        this.fs = options.fs;
    }
    getFileTypeByFd(fd) {
        const stats = this.fs.fstatSync(fd, { bigint: true });
        return toFileType(stats);
    }
    insertPreopen(fd, mappedPath, realPath) {
        const type = this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        this.fs.closeSync(dstEntry.fd);
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}
class AsyncTable extends FileDescriptorTable {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(options) {
        super(options);
    }
    async getFileTypeByFd(fd) {
        const stats = await fd.stat({ bigint: true });
        return toFileType(stats);
    }
    async insertPreopen(fd, mappedPath, realPath) {
        const type = await this.getFileTypeByFd(fd);
        if (type !== 3 /* WasiFileType.DIRECTORY */) {
            throw new WasiError(`Preopen not dir: ["${mappedPath}", "${realPath}"]`, 54 /* WasiErrno.ENOTDIR */);
        }
        const result = getRights(this.stdio, fd.fd, 0, type);
        return this.insert(fd, mappedPath, realPath, type, result.base, result.inheriting, 1);
    }
    async renumber(dst, src) {
        if (dst === src)
            return;
        if (dst >= this.size || src >= this.size) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        const dstEntry = this.fds[dst];
        const srcEntry = this.fds[src];
        if (!dstEntry || !srcEntry || dstEntry.id !== dst || srcEntry.id !== src) {
            throw new WasiError('Invalid fd', 8 /* WasiErrno.EBADF */);
        }
        await dstEntry.fd.close();
        this.fds[dst] = this.fds[src];
        this.fds[dst].id = dst;
        this.fds[src] = undefined;
        this.used--;
    }
}

/** @public */
const WebAssemblyMemory = /*#__PURE__*/ (function () { return _WebAssembly.Memory; })();
/** @public */
class Memory extends WebAssemblyMemory {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(descriptor) {
        super(descriptor);
    }
    get HEAP8() { return new Int8Array(super.buffer); }
    get HEAPU8() { return new Uint8Array(super.buffer); }
    get HEAP16() { return new Int16Array(super.buffer); }
    get HEAPU16() { return new Uint16Array(super.buffer); }
    get HEAP32() { return new Int32Array(super.buffer); }
    get HEAPU32() { return new Uint32Array(super.buffer); }
    get HEAP64() { return new BigInt64Array(super.buffer); }
    get HEAPU64() { return new BigUint64Array(super.buffer); }
    get HEAPF32() { return new Float32Array(super.buffer); }
    get HEAPF64() { return new Float64Array(super.buffer); }
    get view() { return new DataView(super.buffer); }
}
/** @public */
function extendMemory(memory) {
    if (Object.getPrototypeOf(memory) === _WebAssembly.Memory.prototype) {
        Object.setPrototypeOf(memory, Memory.prototype);
    }
    return memory;
}

function checkWebAssemblyFunction() {
    const WebAssemblyFunction = _WebAssembly.Function;
    if (typeof WebAssemblyFunction !== 'function') {
        throw new Error('WebAssembly.Function is not supported in this environment.' +
            ' If you are using V8 based browser like Chrome, try to specify' +
            ' --js-flags="--wasm-staging --experimental-wasm-stack-switching"');
    }
    return WebAssemblyFunction;
}
/** @public */
function wrapAsyncImport(f, parameterType, returnType) {
    const WebAssemblyFunction = checkWebAssemblyFunction();
    if (typeof f !== 'function') {
        throw new TypeError('Function required');
    }
    const parameters = parameterType.slice(0);
    parameters.unshift('externref');
    return new WebAssemblyFunction({ parameters, results: returnType }, f, { suspending: 'first' });
}

function copyMemory(targets, src) {
    if (targets.length === 0 || src.length === 0)
        return 0;
    let copied = 0;
    let left = src.length - copied;
    for (let i = 0; i < targets.length; ++i) {
        const target = targets[i];
        if (left < target.length) {
            target.set(src.subarray(copied, copied + left), 0);
            copied += left;
            left = 0;
            return copied;
        }
        target.set(src.subarray(copied, copied + target.length), 0);
        copied += target.length;
        left -= target.length;
    }
    return copied;
}
const _memory = new WeakMap();
const _wasi = new WeakMap();
const _fs = new WeakMap();
function getMemory(wasi) {
    return _memory.get(wasi);
}
function getFs(wasi) {
    const fs = _fs.get(wasi);
    if (!fs)
        throw new Error('filesystem is unavailable');
    return fs;
}
function handleError(err) {
    if (err instanceof WasiError) {
        return err.errno;
    }
    switch (err.code) {
        case 'ENOENT': return 44 /* WasiErrno.ENOENT */;
        case 'EBADF': return 8 /* WasiErrno.EBADF */;
        case 'EINVAL': return 28 /* WasiErrno.EINVAL */;
        case 'EPERM': return 63 /* WasiErrno.EPERM */;
        case 'EPROTO': return 65 /* WasiErrno.EPROTO */;
        case 'EEXIST': return 20 /* WasiErrno.EEXIST */;
        case 'ENOTDIR': return 54 /* WasiErrno.ENOTDIR */;
        case 'EMFILE': return 33 /* WasiErrno.EMFILE */;
        case 'EACCES': return 2 /* WasiErrno.EACCES */;
        case 'EISDIR': return 31 /* WasiErrno.EISDIR */;
        case 'ENOTEMPTY': return 55 /* WasiErrno.ENOTEMPTY */;
        case 'ENOSYS': return 52 /* WasiErrno.ENOSYS */;
    }
    throw err;
}
function defineName(name, f) {
    Object.defineProperty(f, 'name', { value: name });
    return f;
}
function syscallWrap(self, name, f) {
    return defineName(name, function () {
        let r;
        try {
            r = f.apply(self, arguments);
        }
        catch (err) {
            return handleError(err);
        }
        if (isPromiseLike(r)) {
            return r.then(_ => _, handleError);
        }
        return r;
    });
}
function resolvePathSync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = fs.readlinkSync(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
async function resolvePathAsync(fs, fileDescriptor, path, flags) {
    let resolvedPath = resolve(fileDescriptor.realPath, path);
    if ((flags & 1) === 1) {
        try {
            resolvedPath = await fs.promises.readlink(resolvedPath);
        }
        catch (err) {
            if (err.code !== 'EINVAL' && err.code !== 'ENOENT') {
                throw err;
            }
        }
    }
    return resolvedPath;
}
// eslint-disable-next-line spaced-comment
const encoder = /*#__PURE__*/ new TextEncoder();
// eslint-disable-next-line spaced-comment
const decoder = /*#__PURE__*/ new TextDecoder();
const INT64_MAX = (BigInt(1) << BigInt(63)) - BigInt(1);
function readStdin() {
    const value = window.prompt();
    if (value === null)
        return new Uint8Array();
    const buffer = new TextEncoder().encode(value + '\n');
    return buffer;
}
function validateFstFlagsOrReturn(flags) {
    return (Boolean((flags) & ~(1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */ |
        4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */)) ||
        ((flags) & (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */)) ===
            (1 /* WasiFstFlag.SET_ATIM */ | 2 /* WasiFstFlag.SET_ATIM_NOW */) ||
        ((flags) & (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */)) ===
            (4 /* WasiFstFlag.SET_MTIM */ | 8 /* WasiFstFlag.SET_MTIM_NOW */));
}
class WASI$1 {
    constructor(args, env, fds, asyncFs, fs, asyncify) {
        this.args_get = syscallWrap(this, 'args_get', function (argv, argv_buf) {
            argv = Number(argv);
            argv_buf = Number(argv_buf);
            if (argv === 0 || argv_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            for (let i = 0; i < args.length; ++i) {
                const arg = args[i];
                view.setInt32(argv, argv_buf, true);
                argv += 4;
                const data = encoder.encode(arg + '\0');
                HEAPU8.set(data, argv_buf);
                argv_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.args_sizes_get = syscallWrap(this, 'args_sizes_get', function (argc, argv_buf_size) {
            argc = Number(argc);
            argv_buf_size = Number(argv_buf_size);
            if (argc === 0 || argv_buf_size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            const args = wasi.args;
            view.setUint32(argc, args.length, true);
            view.setUint32(argv_buf_size, encoder.encode(args.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_get = syscallWrap(this, 'environ_get', function (environ, environ_buf) {
            environ = Number(environ);
            environ_buf = Number(environ_buf);
            if (environ === 0 || environ_buf === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const env = wasi.env;
            for (let i = 0; i < env.length; ++i) {
                const pair = env[i];
                view.setInt32(environ, environ_buf, true);
                environ += 4;
                const data = encoder.encode(pair + '\0');
                HEAPU8.set(data, environ_buf);
                environ_buf += data.length;
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.environ_sizes_get = syscallWrap(this, 'environ_sizes_get', function (len, buflen) {
            len = Number(len);
            buflen = Number(buflen);
            if (len === 0 || buflen === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            const wasi = _wasi.get(this);
            view.setUint32(len, wasi.env.length, true);
            view.setUint32(buflen, encoder.encode(wasi.env.join('\0') + '\0').length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.clock_res_get = syscallWrap(this, 'clock_res_get', function (id, resolution) {
            resolution = Number(resolution);
            if (resolution === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(resolution, BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */:
                    view.setBigUint64(resolution, BigInt(1000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.clock_time_get = syscallWrap(this, 'clock_time_get', function (id, _percision, time) {
            time = Number(time);
            if (time === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            switch (id) {
                case 0 /* WasiClockid.REALTIME */:
                    view.setBigUint64(time, BigInt(Date.now()) * BigInt(1000000), true);
                    return 0 /* WasiErrno.ESUCCESS */;
                case 1 /* WasiClockid.MONOTONIC */:
                case 2 /* WasiClockid.PROCESS_CPUTIME_ID */:
                case 3 /* WasiClockid.THREAD_CPUTIME_ID */: {
                    const t = performance.now();
                    const s = Math.trunc(t);
                    const ms = Math.floor((t - s) * 1000);
                    const result = BigInt(s) * BigInt(1000000000) + BigInt(ms) * BigInt(1000000);
                    view.setBigUint64(time, result, true);
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                default: return 28 /* WasiErrno.EINVAL */;
            }
        });
        this.fd_advise = syscallWrap(this, 'fd_advise', function (_fd, _offset, _len, _advice) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_get = syscallWrap(this, 'fd_fdstat_get', function (fd, fdstat) {
            fdstat = Number(fdstat);
            if (fdstat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const { view } = getMemory(this);
            view.setUint16(fdstat, fileDescriptor.type, true);
            view.setUint16(fdstat + 2, 0, true);
            view.setBigUint64(fdstat + 8, fileDescriptor.rightsBase, true);
            view.setBigUint64(fdstat + 16, fileDescriptor.rightsInheriting, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_fdstat_set_flags = syscallWrap(this, 'fd_fdstat_set_flags', function (_fd, _flags) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.fd_fdstat_set_rights = syscallWrap(this, 'fd_fdstat_set_rights', function (fd, rightsBase, rightsInheriting) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if ((rightsBase | fileDescriptor.rightsBase) > fileDescriptor.rightsBase) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            if ((rightsInheriting | fileDescriptor.rightsInheriting) >
                fileDescriptor.rightsInheriting) {
                return 76 /* WasiErrno.ENOTCAPABLE */;
            }
            fileDescriptor.rightsBase = rightsBase;
            fileDescriptor.rightsInheriting = rightsInheriting;
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_get = syscallWrap(this, 'fd_prestat_get', function (fd, prestat) {
            prestat = Number(prestat);
            if (prestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let fileDescriptor;
            try {
                fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            }
            catch (err) {
                if (err instanceof WasiError)
                    return err.errno;
                throw err;
            }
            if (fileDescriptor.preopen !== 1)
                return 28 /* WasiErrno.EINVAL */;
            const { view } = getMemory(this);
            // preopen type is dir(0)
            view.setUint32(prestat, 0, true);
            view.setUint32(prestat + 4, encoder.encode(fileDescriptor.path).length, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_prestat_dir_name = syscallWrap(this, 'fd_prestat_dir_name', function (fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            if (fileDescriptor.preopen !== 1)
                return 8 /* WasiErrno.EBADF */;
            const buffer = encoder.encode(fileDescriptor.path);
            const size = buffer.length;
            if (size > path_len)
                return 42 /* WasiErrno.ENOBUFS */;
            const { HEAPU8 } = getMemory(this);
            HEAPU8.set(buffer, path);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_seek = syscallWrap(this, 'fd_seek', function (fd, offset, whence, newOffset) {
            newOffset = Number(newOffset);
            if (newOffset === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            if (fd === 0 || fd === 1 || fd === 2)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SEEK, BigInt(0));
            const r = fileDescriptor.seek(offset, whence);
            const { view } = getMemory(this);
            view.setBigUint64(newOffset, r, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.fd_tell = syscallWrap(this, 'fd_tell', function (fd, offset) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_TELL, BigInt(0));
            const pos = BigInt(fileDescriptor.pos);
            const { view } = getMemory(this);
            view.setBigUint64(Number(offset), pos, true);
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.poll_oneoff = syscallWrap(this, 'poll_oneoff', function (in_ptr, out_ptr, nsubscriptions, nevents) {
            in_ptr = Number(in_ptr);
            out_ptr = Number(out_ptr);
            nevents = Number(nevents);
            nsubscriptions = Number(nsubscriptions);
            nsubscriptions = nsubscriptions >>> 0;
            if (in_ptr === 0 || out_ptr === 0 || nsubscriptions === 0 || nevents === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { view } = getMemory(this);
            view.setUint32(nevents, 0, true);
            let i = 0;
            let timer_userdata = BigInt(0);
            let cur_timeout = BigInt(0);
            let has_timeout = 0;
            let min_timeout = BigInt(0);
            let sub;
            const subscriptions = Array(nsubscriptions);
            for (i = 0; i < nsubscriptions; i++) {
                sub = in_ptr + i * 48;
                const userdata = view.getBigUint64(sub, true);
                const type = view.getUint8(sub + 8);
                const clockIdOrFd = view.getUint32(sub + 16, true);
                const timeout = view.getBigUint64(sub + 24, true);
                const precision = view.getBigUint64(sub + 32, true);
                const flags = view.getUint16(sub + 40, true);
                subscriptions[i] = {
                    userdata,
                    type,
                    u: {
                        clock: {
                            clock_id: clockIdOrFd,
                            timeout,
                            precision,
                            flags
                        },
                        fd_readwrite: {
                            fd: clockIdOrFd
                        }
                    }
                };
            }
            const fdevents = [];
            for (i = 0; i < nsubscriptions; i++) {
                sub = subscriptions[i];
                switch (sub.type) {
                    case 0 /* WasiEventType.CLOCK */: {
                        if (sub.u.clock.flags === 1 /* WasiSubclockflags.ABSTIME */) {
                            /* Convert absolute time to relative delay. */
                            const now = BigInt(Date.now()) * BigInt(1000000);
                            cur_timeout = sub.u.clock.timeout - now;
                        }
                        else {
                            cur_timeout = sub.u.clock.timeout;
                        }
                        if (has_timeout === 0 || cur_timeout < min_timeout) {
                            min_timeout = cur_timeout;
                            timer_userdata = sub.userdata;
                            has_timeout = 1;
                        }
                        break;
                    }
                    case 1 /* WasiEventType.FD_READ */:
                    case 2 /* WasiEventType.FD_WRITE */:
                        fdevents.push(sub);
                        break;
                    default: return 28 /* WasiErrno.EINVAL */;
                }
            }
            if (fdevents.length > 0) {
                for (i = 0; i < fdevents.length; i++) {
                    const fdevent = fdevents[i];
                    const event = out_ptr + 32 * i;
                    view.setBigUint64(event, fdevent.userdata, true);
                    view.setUint32(event + 8, 52 /* WasiErrno.ENOSYS */, true);
                    view.setUint32(event + 12, fdevent.type, true);
                    view.setBigUint64(event + 16, BigInt(0), true);
                    view.setUint16(event + 24, 0, true);
                    view.setUint32(nevents, 1, true);
                }
                view.setUint32(nevents, fdevents.length, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            if (has_timeout) {
                Number(min_timeout / BigInt(1000000));
                // } else {
                //   const buf = new SharedArrayBuffer(4)
                //   const arr = new Int32Array(buf)
                //   postMsg({
                //     __tybys_wasm_util_wasi__: {
                //       type: 'set-timeout',
                //       payload: {
                //         buffer: buf,
                //         delay
                //       }
                //     }
                //   })
                //   Atomics.wait(arr, 0, 0)
                // }
                const event = out_ptr;
                view.setBigUint64(event, timer_userdata, true);
                view.setUint32(event + 8, 0 /* WasiErrno.ESUCCESS */, true);
                view.setUint32(event + 12, 0 /* WasiEventType.CLOCK */, true);
                view.setUint32(nevents, 1, true);
            }
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_exit = syscallWrap(this, 'proc_exit', function (rval) {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.proc_raise = syscallWrap(this, 'proc_raise', function (_sig) {
            return 52 /* WasiErrno.ENOSYS */;
        });
        this.sched_yield = syscallWrap(this, 'sched_yield', function () {
            return 0 /* WasiErrno.ESUCCESS */;
        });
        this.random_get = typeof crypto !== 'undefined' && typeof crypto.getRandomValues === 'function'
            ? syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { HEAPU8, view } = getMemory(this);
                if ((typeof SharedArrayBuffer === 'function' && HEAPU8.buffer instanceof SharedArrayBuffer) ||
                    (Object.prototype.toString.call(HEAPU8.buffer) === '[object SharedArrayBuffer]')) {
                    for (let i = buf; i < buf + buf_len; ++i) {
                        view.setUint8(i, Math.floor(Math.random() * 256));
                    }
                    return 0 /* WasiErrno.ESUCCESS */;
                }
                let pos;
                const stride = 65536;
                for (pos = 0; pos + stride < buf_len; pos += stride) {
                    crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + pos + stride));
                }
                crypto.getRandomValues(HEAPU8.subarray(buf + pos, buf + buf_len));
                return 0 /* WasiErrno.ESUCCESS */;
            })
            : syscallWrap(this, 'random_get', function (buf, buf_len) {
                buf = Number(buf);
                if (buf === 0) {
                    return 28 /* WasiErrno.EINVAL */;
                }
                buf_len = Number(buf_len);
                const { view } = getMemory(this);
                for (let i = buf; i < buf + buf_len; ++i) {
                    view.setUint8(i, Math.floor(Math.random() * 256));
                }
                return 0 /* WasiErrno.ESUCCESS */;
            });
        this.sock_recv = syscallWrap(this, 'sock_recv', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_send = syscallWrap(this, 'sock_send', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_shutdown = syscallWrap(this, 'sock_shutdown', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        this.sock_accept = syscallWrap(this, 'sock_accept', function () {
            return 58 /* WasiErrno.ENOTSUP */;
        });
        _wasi.set(this, {
            fds,
            args,
            env
        });
        if (fs)
            _fs.set(this, fs);
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        const _this = this;
        function defineImport(name, syncVersion, asyncVersion, parameterType, returnType) {
            if (asyncFs) {
                if (asyncify) {
                    _this[name] = asyncify.wrapImportFunction(syscallWrap(_this, name, asyncVersion));
                }
                else {
                    _this[name] = wrapAsyncImport(syscallWrap(_this, name, asyncVersion), parameterType, returnType);
                }
            }
            else {
                _this[name] = syscallWrap(_this, name, syncVersion);
            }
        }
        defineImport('fd_allocate', function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fs = getFs(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            if (stat.size < offset + len) {
                fs.ftruncateSync(fileDescriptor.fd, Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_allocate(fd, offset, len) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_ALLOCATE, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            if (stat.size < offset + len) {
                await h.truncate(Number(offset + len));
            }
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'f64'], ['i32']);
        defineImport('fd_close', function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            const fs = getFs(this);
            fs.closeSync(fileDescriptor.fd);
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_close(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, BigInt(0), BigInt(0));
            await fileDescriptor.fd.close();
            wasi.fds.remove(fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_datasync', function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            const fs = getFs(this);
            fs.fdatasyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_datasync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_DATASYNC, BigInt(0));
            await fileDescriptor.fd.datasync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_filestat_get', function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const fs = getFs(this);
            const stat = fs.fstatSync(fileDescriptor.fd, { bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_get(fd, buf) {
            buf = Number(buf);
            if (buf === 0)
                return 28 /* WasiErrno.EINVAL */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_GET, BigInt(0));
            const h = fileDescriptor.fd;
            const stat = await h.stat({ bigint: true });
            const { view } = getMemory(this);
            toFileStat(view, buf, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_filestat_set_size', function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const fs = getFs(this);
            fs.ftruncateSync(fileDescriptor.fd, Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_size(fd, size) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_SIZE, BigInt(0));
            const h = fileDescriptor.fd;
            await h.truncate(Number(size));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64'], ['i32']);
        function fdFilestatGetTimes(fd, atim, mtim, flags) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_FILESTAT_SET_TIMES, BigInt(0));
            if ((flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            return { fileDescriptor, atim, mtim };
        }
        defineImport('fd_filestat_set_times', function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const fs = getFs(this);
            fs.futimesSync(fileDescriptor.fd, Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_filestat_set_times(fd, atim, mtim, flags) {
            if (validateFstFlagsOrReturn(flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { fileDescriptor, atim: atimRes, mtim: mtimRes } = fdFilestatGetTimes.call(this, fd, atim, mtim, flags);
            const h = fileDescriptor.fd;
            await h.utimes(Number(atimRes), Number(mtimRes));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('fd_pread', function fd_pread(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = (() => {
                try {
                    return new Uint8Array(new SharedArrayBuffer(totalSize));
                }
                catch (_) {
                    return new Uint8Array(totalSize);
                }
            })();
            buffer._isBuffer = true;
            const fs = getFs(this);
            const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function (fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let nread = 0;
            const buffer = new Uint8Array(totalSize);
            buffer._isBuffer = true;
            const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(offset));
            nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_pwrite', function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const fs = getFs(this);
            const nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_pwrite(fd, iovs, iovslen, offset, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0 || offset > INT64_MAX) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE | WasiRights.FD_SEEK, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            const { bytesWritten } = await fileDescriptor.fd.write(buffer, 0, buffer.length, Number(offset));
            view.setUint32(size, bytesWritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_read', function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = (() => {
                    try {
                        return new Uint8Array(new SharedArrayBuffer(totalSize));
                    }
                    catch (_) {
                        return new Uint8Array(totalSize);
                    }
                })();
                buffer._isBuffer = true;
                const fs = getFs(this);
                const bytesRead = fs.readSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_read(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READ, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            let totalSize = 0;
            const ioVecs = Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                totalSize += bufLen;
                return HEAPU8.subarray(buf, buf + bufLen);
            });
            let buffer;
            let nread = 0;
            if (fd === 0) {
                if (typeof window === 'undefined' || typeof window.prompt !== 'function') {
                    return 58 /* WasiErrno.ENOTSUP */;
                }
                buffer = readStdin();
                nread = buffer ? copyMemory(ioVecs, buffer) : 0;
            }
            else {
                buffer = new Uint8Array(totalSize);
                buffer._isBuffer = true;
                const { bytesRead } = await fileDescriptor.fd.read(buffer, 0, buffer.length, Number(fileDescriptor.pos));
                nread = buffer ? copyMemory(ioVecs, buffer.subarray(0, bytesRead)) : 0;
                fileDescriptor.pos += BigInt(nread);
            }
            view.setUint32(size, nread, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('fd_readdir', function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = fs.readdirSync(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = fs.statSync(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_readdir(fd, buf, buf_len, cookie, bufused) {
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (buf === 0 || bufused === 0)
                return 0 /* WasiErrno.ESUCCESS */;
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_READDIR, BigInt(0));
            const fs = getFs(this);
            const entries = await fs.promises.readdir(fileDescriptor.realPath, { withFileTypes: true });
            const { HEAPU8, view } = getMemory(this);
            let bufferUsed = 0;
            for (let i = Number(cookie); i < entries.length; i++) {
                const nameData = encoder.encode(entries[i].name);
                const entryInfo = await fs.promises.stat(resolve(fileDescriptor.realPath, entries[i].name), { bigint: true });
                const entryData = new Uint8Array(24 + nameData.byteLength);
                const entryView = new DataView(entryData.buffer);
                entryView.setBigUint64(0, BigInt(i + 1), true);
                entryView.setBigUint64(8, BigInt(entryInfo.ino ? entryInfo.ino : 0), true);
                entryView.setUint32(16, nameData.byteLength, true);
                let type;
                if (entries[i].isFile()) {
                    type = 4 /* WasiFileType.REGULAR_FILE */;
                }
                else if (entries[i].isDirectory()) {
                    type = 3 /* WasiFileType.DIRECTORY */;
                }
                else if (entries[i].isSymbolicLink()) {
                    type = 7 /* WasiFileType.SYMBOLIC_LINK */;
                }
                else if (entries[i].isCharacterDevice()) {
                    type = 2 /* WasiFileType.CHARACTER_DEVICE */;
                }
                else if (entries[i].isBlockDevice()) {
                    type = 1 /* WasiFileType.BLOCK_DEVICE */;
                }
                else if (entries[i].isSocket()) {
                    type = 6 /* WasiFileType.SOCKET_STREAM */;
                }
                else {
                    type = 0 /* WasiFileType.UNKNOWN */;
                }
                entryView.setUint8(20, type);
                entryData.set(nameData, 24);
                const data = entryData.slice(0, Math.min(entryData.length, buf_len - bufferUsed));
                HEAPU8.set(data, buf + bufferUsed);
                bufferUsed += data.byteLength;
            }
            view.setUint32(bufused, bufferUsed, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i64', 'i32'], ['i32']);
        defineImport('fd_renumber', function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_renumber(from, to) {
            const wasi = _wasi.get(this);
            await wasi.fds.renumber(to, from);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32'], ['i32']);
        defineImport('fd_sync', function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            const fs = getFs(this);
            fs.fsyncSync(fileDescriptor.fd);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_sync(fd) {
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_SYNC, BigInt(0));
            await fileDescriptor.fd.sync();
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32'], ['i32']);
        defineImport('fd_write', function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                const fs = getFs(this);
                nwritten = fs.writeSync(fileDescriptor.fd, buffer, 0, buffer.length, Number(fileDescriptor.pos));
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function fd_write(fd, iovs, iovslen, size) {
            iovs = Number(iovs);
            size = Number(size);
            if ((iovs === 0 && iovslen) || size === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.FD_WRITE, BigInt(0));
            if (!iovslen) {
                view.setUint32(size, 0, true);
                return 0 /* WasiErrno.ESUCCESS */;
            }
            const buffer = concatBuffer(Array.from({ length: Number(iovslen) }, (_, i) => {
                const offset = iovs + (i * 8);
                const buf = view.getInt32(offset, true);
                const bufLen = view.getUint32(offset + 4, true);
                return HEAPU8.subarray(buf, buf + bufLen);
            }));
            let nwritten;
            if (fd === 1 || fd === 2) {
                nwritten = fileDescriptor.write(buffer);
            }
            else {
                nwritten = await (await (fileDescriptor.fd.write(buffer, 0, buffer.length, Number(fileDescriptor.pos)))).bytesWritten;
                fileDescriptor.pos += BigInt(nwritten);
            }
            view.setUint32(size, nwritten, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_create_directory', function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.mkdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_create_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_CREATE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.mkdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_get', function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = fs.statSync(pathString, { bigint: true });
            }
            else {
                stat = fs.lstatSync(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_get(fd, flags, path, path_len, filestat) {
            path = Number(path);
            path_len = Number(path_len);
            filestat = Number(filestat);
            if (path === 0 || filestat === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_GET, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            pathString = resolve(fileDescriptor.realPath, pathString);
            let stat;
            if ((flags & 1) === 1) {
                stat = await fs.promises.stat(pathString, { bigint: true });
            }
            else {
                stat = await fs.promises.lstat(pathString, { bigint: true });
            }
            toFileStat(view, filestat, stat);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_filestat_set_times', function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = resolvePathSync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            fs.utimesSync(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_filestat_set_times(fd, flags, path, path_len, atim, mtim, fst_flags) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0)
                return 28 /* WasiErrno.EINVAL */;
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_FILESTAT_SET_TIMES, BigInt(0));
            if (validateFstFlagsOrReturn(fst_flags)) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const fs = getFs(this);
            const resolvedPath = await resolvePathAsync(fs, fileDescriptor, decoder.decode(unsharedSlice(HEAPU8, path, path + path_len)), flags);
            if ((fst_flags & 2 /* WasiFstFlag.SET_ATIM_NOW */) === 2 /* WasiFstFlag.SET_ATIM_NOW */) {
                atim = BigInt(Date.now() * 1000000);
            }
            if ((fst_flags & 8 /* WasiFstFlag.SET_MTIM_NOW */) === 8 /* WasiFstFlag.SET_MTIM_NOW */) {
                mtim = BigInt(Date.now() * 1000000);
            }
            await fs.promises.utimes(resolvedPath, Number(atim), Number(mtim));
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32'], ['i32']);
        defineImport('path_link', function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = resolvePathSync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            fs.linkSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_link(old_fd, old_flags, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE | WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_LINK_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_LINK_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const fs = getFs(this);
            const resolvedOldPath = await resolvePathAsync(fs, oldWrap, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)), old_flags);
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            await fs.promises.link(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        function pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags) {
            const read = (fs_rights_base & (WasiRights.FD_READ |
                WasiRights.FD_READDIR)) !== BigInt(0);
            const write = (fs_rights_base & (WasiRights.FD_DATASYNC |
                WasiRights.FD_WRITE |
                WasiRights.FD_ALLOCATE |
                WasiRights.FD_FILESTAT_SET_SIZE)) !== BigInt(0);
            let flags = write ? read ? 2 /* FileControlFlag.O_RDWR */ : 1 /* FileControlFlag.O_WRONLY */ : 0 /* FileControlFlag.O_RDONLY */;
            let needed_base = WasiRights.PATH_OPEN;
            let needed_inheriting = fs_rights_base | fs_rights_inheriting;
            if ((o_flags & 1 /* WasiFileControlFlag.O_CREAT */) !== 0) {
                flags |= 64 /* FileControlFlag.O_CREAT */;
                needed_base |= WasiRights.PATH_CREATE_FILE;
            }
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0) {
                flags |= 65536 /* FileControlFlag.O_DIRECTORY */;
            }
            if ((o_flags & 4 /* WasiFileControlFlag.O_EXCL */) !== 0) {
                flags |= 128 /* FileControlFlag.O_EXCL */;
            }
            if ((o_flags & 8 /* WasiFileControlFlag.O_TRUNC */) !== 0) {
                flags |= 512 /* FileControlFlag.O_TRUNC */;
                needed_base |= WasiRights.PATH_FILESTAT_SET_SIZE;
            }
            if ((fs_flags & 1 /* WasiFdFlag.APPEND */) !== 0) {
                flags |= 1024 /* FileControlFlag.O_APPEND */;
            }
            if ((fs_flags & 2 /* WasiFdFlag.DSYNC */) !== 0) {
                // flags |= FileControlFlag.O_DSYNC;
                needed_inheriting |= WasiRights.FD_DATASYNC;
            }
            if ((fs_flags & 4 /* WasiFdFlag.NONBLOCK */) !== 0) {
                flags |= 2048 /* FileControlFlag.O_NONBLOCK */;
            }
            if ((fs_flags & 8 /* WasiFdFlag.RSYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if ((fs_flags & 16 /* WasiFdFlag.SYNC */) !== 0) {
                flags |= 1052672 /* FileControlFlag.O_SYNC */;
                needed_inheriting |= WasiRights.FD_SYNC;
            }
            if (write && (flags & (1024 /* FileControlFlag.O_APPEND */ | 512 /* FileControlFlag.O_TRUNC */)) === 0) {
                needed_inheriting |= WasiRights.FD_SEEK;
            }
            return { flags, needed_base, needed_inheriting };
        }
        defineImport('path_open', function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = resolvePathSync(fs, fileDescriptor, pathString, dirflags);
            const r = fs.openSync(resolved_path, flagsRes, 0o666);
            const filetype = wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = fs.fstatSync(r, { bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_open(dirfd, dirflags, path, path_len, o_flags, fs_rights_base, fs_rights_inheriting, fs_flags, fd) {
            path = Number(path);
            fd = Number(fd);
            if (path === 0 || fd === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            path_len = Number(path_len);
            fs_rights_base = BigInt(fs_rights_base);
            fs_rights_inheriting = BigInt(fs_rights_inheriting);
            const { flags: flagsRes, needed_base: neededBase, needed_inheriting: neededInheriting } = pathOpen(o_flags, fs_rights_base, fs_rights_inheriting, fs_flags);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(dirfd, neededBase, neededInheriting);
            const memory = getMemory(this);
            const HEAPU8 = memory.HEAPU8;
            const pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            const fs = getFs(this);
            const resolved_path = await resolvePathAsync(fs, fileDescriptor, pathString, dirflags);
            const r = await fs.promises.open(resolved_path, flagsRes, 0o666);
            const filetype = await wasi.fds.getFileTypeByFd(r);
            if ((o_flags & 2 /* WasiFileControlFlag.O_DIRECTORY */) !== 0 && filetype !== 3 /* WasiFileType.DIRECTORY */) {
                return 54 /* WasiErrno.ENOTDIR */;
            }
            const { base: max_base, inheriting: max_inheriting } = getRights(wasi.fds.stdio, r.fd, flagsRes, filetype);
            const wrap = wasi.fds.insert(r, resolved_path, resolved_path, filetype, fs_rights_base & max_base, fs_rights_inheriting & max_inheriting, 0);
            const stat = await r.stat({ bigint: true });
            if (stat.isFile()) {
                wrap.size = stat.size;
                if ((flagsRes & 1024 /* FileControlFlag.O_APPEND */) !== 0) {
                    wrap.pos = stat.size;
                }
            }
            const view = memory.view;
            view.setInt32(fd, wrap.id, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i64', 'i64', 'i32', 'i32'], ['i32']);
        defineImport('path_readlink', function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = fs.readlinkSync(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_readlink(fd, path, path_len, buf, buf_len, bufused) {
            path = Number(path);
            path_len = Number(path_len);
            buf = Number(buf);
            buf_len = Number(buf_len);
            bufused = Number(bufused);
            if (path === 0 || buf === 0 || bufused === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8, view } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_READLINK, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            const link = await fs.promises.readlink(pathString);
            const linkData = encoder.encode(link);
            const len = Math.min(linkData.length, buf_len);
            if (len >= buf_len)
                return 42 /* WasiErrno.ENOBUFS */;
            HEAPU8.set(linkData.subarray(0, len), buf);
            HEAPU8[buf + len] = 0;
            view.setUint32(bufused, len, true);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_remove_directory', function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.rmdirSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_remove_directory(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_REMOVE_DIRECTORY, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.rmdir(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        defineImport('path_rename', function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            fs.renameSync(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_rename(old_fd, old_path, old_path_len, new_fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const wasi = _wasi.get(this);
            let oldWrap;
            let newWrap;
            if (old_fd === new_fd) {
                oldWrap = newWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE | WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            else {
                oldWrap = wasi.fds.get(old_fd, WasiRights.PATH_RENAME_SOURCE, BigInt(0));
                newWrap = wasi.fds.get(new_fd, WasiRights.PATH_RENAME_TARGET, BigInt(0));
            }
            const { HEAPU8 } = getMemory(this);
            const resolvedOldPath = resolve(oldWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len)));
            const resolvedNewPath = resolve(newWrap.realPath, decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len)));
            const fs = getFs(this);
            await fs.promises.rename(resolvedOldPath, resolvedNewPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_symlink', function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            fs.symlinkSync(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_symlink(old_path, old_path_len, fd, new_path, new_path_len) {
            old_path = Number(old_path);
            old_path_len = Number(old_path_len);
            new_path = Number(new_path);
            new_path_len = Number(new_path_len);
            if (old_path === 0 || new_path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_SYMLINK, BigInt(0));
            const oldPath = decoder.decode(unsharedSlice(HEAPU8, old_path, old_path + old_path_len));
            let newPath = decoder.decode(unsharedSlice(HEAPU8, new_path, new_path + new_path_len));
            newPath = resolve(fileDescriptor.realPath, newPath);
            const fs = getFs(this);
            await fs.promises.symlink(oldPath, newPath);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32', 'i32', 'i32'], ['i32']);
        defineImport('path_unlink_file', function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            fs.unlinkSync(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, async function path_unlink_file(fd, path, path_len) {
            path = Number(path);
            path_len = Number(path_len);
            if (path === 0) {
                return 28 /* WasiErrno.EINVAL */;
            }
            const { HEAPU8 } = getMemory(this);
            const wasi = _wasi.get(this);
            const fileDescriptor = wasi.fds.get(fd, WasiRights.PATH_UNLINK_FILE, BigInt(0));
            let pathString = decoder.decode(unsharedSlice(HEAPU8, path, path + path_len));
            pathString = resolve(fileDescriptor.realPath, pathString);
            const fs = getFs(this);
            await fs.promises.unlink(pathString);
            return 0 /* WasiErrno.ESUCCESS */;
        }, ['i32', 'i32', 'i32'], ['i32']);
        this._setMemory = function setMemory(m) {
            if (!(m instanceof _WebAssembly.Memory)) {
                throw new TypeError('"instance.exports.memory" property must be a WebAssembly.Memory');
            }
            _memory.set(_this, extendMemory(m));
        };
    }
    static createSync(args, env, preopens, stdio, fs, print, printErr) {
        const fds = new SyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            fs,
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, false, fs);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const realPath = fs.realpathSync(preopens[i].realPath, 'utf8');
                const fd = fs.openSync(realPath, 'r', 0o666);
                fds.insertPreopen(fd, preopens[i].mappedPath, realPath);
            }
        }
        return _this;
    }
    static async createAsync(args, env, preopens, stdio, fs, print, printErr, asyncify) {
        const fds = new AsyncTable({
            size: 3,
            in: stdio[0],
            out: stdio[1],
            err: stdio[2],
            print,
            printErr
        });
        const _this = new WASI$1(args, env, fds, true, fs, asyncify);
        if (preopens.length > 0) {
            for (let i = 0; i < preopens.length; ++i) {
                const entry = preopens[i];
                const realPath = await fs.promises.realpath(entry.realPath);
                const fd = await fs.promises.open(realPath, 'r', 0o666);
                await fds.insertPreopen(fd, entry.mappedPath, realPath);
            }
        }
        return _this;
    }
}

// eslint-disable-next-line spaced-comment
const kEmptyObject = /*#__PURE__*/ Object.freeze(/*#__PURE__*/ Object.create(null));
const kExitCode = Symbol('kExitCode');
const kSetMemory = Symbol('kSetMemory');
const kStarted = Symbol('kStarted');
const kInstance = Symbol('kInstance');
const kBindingName = Symbol('kBindingName');
function setupInstance(self, instance) {
    validateObject(instance, 'instance');
    validateObject(instance.exports, 'instance.exports');
    self[kInstance] = instance;
    self[kSetMemory](instance.exports.memory);
}
function validateOptions(options) {
    var _a;
    validateObject(options, 'options');
    let _WASI;
    if (options.version !== undefined) {
        validateString(options.version, 'options.version');
        switch (options.version) {
            case 'unstable':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_unstable';
                break;
            case 'preview1':
                _WASI = WASI$1;
                this[kBindingName] = 'wasi_snapshot_preview1';
                break;
            default:
                throw new TypeError(`unsupported WASI version "${options.version}"`);
        }
    }
    else {
        _WASI = WASI$1;
        this[kBindingName] = 'wasi_snapshot_preview1';
    }
    if (options.args !== undefined) {
        validateArray(options.args, 'options.args');
    }
    const args = ((_a = options.args) !== null && _a !== void 0 ? _a : []).map(String);
    const env = [];
    if (options.env !== undefined) {
        validateObject(options.env, 'options.env');
        Object.entries(options.env).forEach(({ 0: key, 1: value }) => {
            if (value !== undefined) {
                env.push(`${key}=${value}`);
            }
        });
    }
    const preopens = [];
    if (options.preopens !== undefined) {
        validateObject(options.preopens, 'options.preopens');
        Object.entries(options.preopens).forEach(({ 0: key, 1: value }) => preopens.push({ mappedPath: String(key), realPath: String(value) }));
    }
    if (preopens.length > 0) {
        if (options.fs === undefined) {
            throw new Error('filesystem is disabled, can not preopen directory');
        }
        try {
            validateObject(options.fs, 'options.fs');
        }
        catch (_) {
            throw new TypeError('Node.js fs like implementation is not provided');
        }
    }
    // if (options.filesystem !== undefined) {
    //   validateObject(options.filesystem, 'options.filesystem')
    //   validateString(options.filesystem.type, 'options.filesystem.type')
    //   if (options.filesystem.type !== 'memfs' && options.filesystem.type !== 'file-system-access-api') {
    //     throw new Error(`Filesystem type ${(options.filesystem as any).type as string} is not supported, only "memfs" and "file-system-access-api" is supported currently`)
    //   }
    //   try {
    //     validateObject(options.filesystem.fs, 'options.filesystem.fs')
    //   } catch (_) {
    //     throw new Error('Node.js fs like implementation is not provided')
    //   }
    // }
    if (options.print !== undefined)
        validateFunction(options.print, 'options.print');
    if (options.printErr !== undefined)
        validateFunction(options.printErr, 'options.printErr');
    if (options.returnOnExit !== undefined) {
        validateBoolean(options.returnOnExit, 'options.returnOnExit');
    }
    // const { stdin = 0, stdout = 1, stderr = 2 } = options
    // validateInt32(stdin, 'options.stdin', 0)
    // validateInt32(stdout, 'options.stdout', 0)
    // validateInt32(stderr, 'options.stderr', 0)
    // const stdio = [stdin, stdout, stderr] as const
    const stdio = [0, 1, 2];
    return {
        args,
        env,
        preopens,
        stdio,
        _WASI
    };
}
function initWASI(setMemory, wrap) {
    this[kSetMemory] = setMemory;
    this.wasiImport = wrap;
    this[kStarted] = false;
    this[kExitCode] = 0;
    this[kInstance] = undefined;
}
/** @public */
class WASI {
    constructor(options = kEmptyObject) {
        const { args, env, preopens, stdio, _WASI } = validateOptions.call(this, options);
        const wrap = _WASI.createSync(args, env, preopens, stdio, options.fs, options.print, options.printErr);
        const setMemory = wrap._setMemory;
        delete wrap._setMemory;
        initWASI.call(this, setMemory, wrap);
        if (options.returnOnExit) {
            wrap.proc_exit = wasiReturnOnProcExit.bind(this);
        }
    }
    // Must not export _initialize, must export _start
    start(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateFunction(_start, 'instance.exports._start');
        validateUndefined(_initialize, 'instance.exports._initialize');
        let ret;
        try {
            ret = _start();
        }
        catch (err) {
            if (err !== kExitCode) {
                throw err;
            }
        }
        if (ret instanceof Promise) {
            return ret.then(() => this[kExitCode], (err) => {
                if (err !== kExitCode) {
                    throw err;
                }
                return this[kExitCode];
            });
        }
        return this[kExitCode];
    }
    // Must not export _start, may optionally export _initialize
    initialize(instance) {
        if (this[kStarted]) {
            throw new Error('WASI instance has already started');
        }
        this[kStarted] = true;
        setupInstance(this, instance);
        const { _start, _initialize } = this[kInstance].exports;
        validateUndefined(_start, 'instance.exports._start');
        if (_initialize !== undefined) {
            validateFunction(_initialize, 'instance.exports._initialize');
            return _initialize();
        }
    }
    getImportObject() {
        return { [this[kBindingName]]: this.wasiImport };
    }
}
function wasiReturnOnProcExit(rval) {
    this[kExitCode] = rval;
    // eslint-disable-next-line @typescript-eslint/no-throw-literal
    throw kExitCode;
}

// @ts-check

/**
 * @param {unknown} value
 */
const getType = (value) => {
  if (value === undefined) return 0
  if (value === null) return 1
  const t = typeof value;
  if (t === 'boolean') return 2
  if (t === 'number') return 3
  if (t === 'string') return 4
  if (t === 'object') return 6
  if (t === 'bigint') return 9
  return -1
};

/**
 * @param {import('memfs').IFs} memfs
 * @param {any} value
 * @param {ReturnType<typeof getType>} type
 * @returns {Uint8Array}
 */
const encodeValue = (memfs, value, type) => {
  switch (type) {
    case 0:
    case 1:
      return new Uint8Array(0)
    case 2: {
      const view = new Int32Array(1);
      view[0] = value ? 1 : 0;
      return new Uint8Array(view.buffer)
    }
    case 3: {
      const view = new Float64Array(1);
      view[0] = value;
      return new Uint8Array(view.buffer)
    }
    case 4: {
      const view = new TextEncoder().encode(value);
      return view
    }
    case 6: {
      const [entry] = Object.entries(memfs).filter(([_, v]) => v === value.constructor)[0] ?? [];
      if (entry) {
        Object.defineProperty(value, '__constructor__', {
          configurable: true,
          writable: true,
          enumerable: true,
          value: entry
        });
      }

      const json = JSON.stringify(value, (_, value) => {
        if (typeof value === 'bigint') {
          return `BigInt(${String(value)})`
        }
        return value
      });
      const view = new TextEncoder().encode(json);
      return view
    }
    case 9: {
      const view = new BigInt64Array(1);
      view[0] = value;
      return new Uint8Array(view.buffer)
    }
    case -1:
    default:
      throw new Error('unsupported data')
  }
};

/**
 * @param {import('memfs').IFs} fs
 * @returns {(e: { data: { __fs__: { sab: Int32Array, type: keyof import('memfs').IFs, payload: any[] } } }) => void}
 */
var createOnMessage = (fs) => function onMessage(e) {
  if (e.data.__fs__) {
    /**
     * 0..4                    status(int32_t):        21(waiting) 0(success) 1(error)
     * 5..8                    type(napi_valuetype):   0(undefined) 1(null) 2(boolean) 3(number) 4(string) 6(jsonstring) 9(bigint) -1(unsupported)
     * 9..16                   payload_size(uint32_t)  <= 1024
     * 16..16 + payload_size   payload_content
     */
    const { sab, type, payload } = e.data.__fs__;
    const fn = fs[type];
    const args = payload ? payload.map((value) => {
      if (value instanceof Uint8Array) {
        // buffer polyfill bug
        // @ts-expect-error
        value._isBuffer = true;
      }
      return value
    }) : payload;
    try {
      const ret = fn.apply(fs, args);
      const t = getType(ret);
      const v = encodeValue(fs, ret, t);
      Atomics.store(sab, 0, 0);
      Atomics.store(sab, 1, t);
      Atomics.store(sab, 2, v.length);
      new Uint8Array(sab.buffer).set(v, 16);

    } catch (/** @type {any} */ err) {
      Atomics.store(sab, 0, 1);
      Atomics.store(sab, 1, 6);
      const payloadContent = new TextEncoder().encode(JSON.stringify({
        ...err,
        message: err.message,
        stack: err.stack
      }));
      Atomics.store(sab, 2, payloadContent.length);
      new Uint8Array(sab.buffer).set(payloadContent, 16);
    } finally {
      Atomics.notify(sab, 0);
    }
  }
};

/**
 * @param {import('memfs').IFs} memfs
 */
var createFsProxy = (memfs) => new Proxy({}, {
  get (_target, p, _receiver) {
    /**
     * @param {any[]} args
     */
    return function (...args) {
      const sab = new SharedArrayBuffer(16 + 1024);
      const i32arr = new Int32Array(sab);
      Atomics.store(i32arr, 0, 21);

      // @ts-expect-error
      postMessage({
        __fs__: {
          sab: i32arr,
          type: p,
          payload: args
        }
      });

      Atomics.wait(i32arr, 0, 21);

      const status = Atomics.load(i32arr, 0);
      const type = Atomics.load(i32arr, 1);
      const size = Atomics.load(i32arr, 2);
      const content = new Uint8Array(sab, 16, size);
      if (status === 1) {
        const errobj = JSON.parse(new TextDecoder().decode(content.slice()));
        const err = new Error(errobj.message);
        Object.defineProperty(err, 'stack', {
          configurable: true,
          enumerable: false,
          writable: true,
          value: errobj.stack
        });
        for (const [k, v] of Object.entries(errobj)) {
          if (k === 'message' || k === 'stack') continue
          // @ts-expect-error
          err[k] = v;
        }
        throw err
      }
      if (type === 0) return undefined
      if (type === 1) return null
      if (type === 2) return Boolean(content[0])
      if (type === 3) return new Float64Array(sab, 16, 1)[0]
      if (type === 4) return new TextDecoder().decode(content.slice())
      if (type === 6) {
        const obj = JSON.parse(new TextDecoder().decode(content.slice()), (_key, value) => {
          if (typeof value === 'string') {
            const matched = value.match(/^BigInt\((-?\d+)\)$/);
            if (matched && matched[1]) {
              return BigInt(matched[1])
            }
          }
          return value
        });
        if (obj.__constructor__) {
          const ctor = obj.__constructor__;
          delete obj.__constructor__;
          // @ts-expect-error
          Object.setPrototypeOf(obj, memfs[ctor].prototype);
        }
        return obj
      }
      if (type === 9) return new BigInt64Array(sab, 16, 1)[0]
      throw new Error('unsupported data')
    }
  }
});

export { MessageHandler, WASI, createFsProxy, createOnMessage, getDefaultContext, instantiateNapiModule, instantiateNapiModuleSync };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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