/**
 * Exported as `'resolve-import/get-all-conditions'`
 * @module
 */
import { Exports, Imports } from './index.js';
/**
 * Given an `exports` or `imports` value from a package, return the list of
 * conditions that it is sensitive to.
 *
 * `default` is not included in the returned list, since that's always
 * effectively relevant.
 *
 * Note that a condition being returned by this method does not mean
 * that the export/import object actually has a *target* for that condition,
 * since it may map to `null`, be nested under another condition, etc. But it
 * does potentially have some kind of conditional behavior for all the
 * conditions returned.
 *
 * Ordering of returned conditions is arbitrary, and does not imply precedence
 * or object shape.
 */
export declare const getAllConditions: (importsExports: Imports | Exports) => string[];
//# sourceMappingURL=get-all-conditions.d.ts.map