"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.starGlob = void 0;
const glob_1 = require("glob");
const path_1 = require("path");
const starGlob = async (star, // actually [string,string]
dir) => {
    const pattern = (0, glob_1.escape)(star[0]) +
        (star[0].endsWith('/') ? '' : '*/') +
        '**' +
        (star[1].startsWith('/') ? '' : '/*') +
        (0, glob_1.escape)(star[1]);
    const matches = await (0, glob_1.glob)(pattern, {
        posix: true,
        absolute: false,
        nodir: true,
        cwd: dir,
        dotRelative: true,
    });
    return matches.map(match => {
        const rep = match.substring(star[0].length, match.length - star[1].length);
        return [rep, (0, path_1.resolve)(dir, match)];
    });
};
exports.starGlob = starGlob;
//# sourceMappingURL=star-glob.js.map