import { ResolveImportOpts } from './index.js';
/**
 * Resolve an import URL or string as if it were coming from the
 * module at parentURL.
 *
 * Returns a string for node builtin modules, and a file:// URL
 * object for anything resolved on disk.
 *
 * If the resolution is impossible, then an error will be raised, which
 * closely matches the errors raised by Node when failing for the same
 * reason.
 */
export declare const resolveImport: (url: string | URL, parentURL?: string | URL | undefined, options?: ResolveImportOpts) => Promise<URL | string>;
//# sourceMappingURL=resolve-import.d.ts.map