"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveExport = void 0;
const errors_js_1 = require("./errors.js");
const find_star_match_js_1 = require("./find-star-match.js");
const resolve_conditional_value_js_1 = require("./resolve-conditional-value.js");
/**
 * Resolve an export that might be a string, subpath exports, exports value
 * object, or array of strings and exports value objects
 */
const resolveExport = (sub, exp, pj, from, options) => {
    const s = !sub ? '.'
        : sub === '.' || sub.startsWith('./') ? sub
            : `./${sub}`;
    if (typeof exp === 'string' || Array.isArray(exp)) {
        const res = s === '.' && (0, resolve_conditional_value_js_1.resolveConditionalValue)(exp, options);
        if (!res)
            throw (0, errors_js_1.subpathNotExported)(s, pj, from);
        return res;
    }
    // now it must be a set of named exports or an export value object
    // first try to resolve as a value object, if that's allowed
    if (s === '.') {
        const res = (0, resolve_conditional_value_js_1.resolveConditionalValue)(exp, options);
        if (res)
            return res;
    }
    // otherwise the only way to match is with subpaths
    const es = exp;
    // if we have an exact match, use that
    const e = es[s];
    if (e !== undefined) {
        const res = (0, resolve_conditional_value_js_1.resolveConditionalValue)(e, options);
        if (!res)
            throw (0, errors_js_1.subpathNotExported)(s, pj, from);
        return res;
    }
    const sm = (0, find_star_match_js_1.findStarMatch)(s, es);
    if (sm) {
        const [key, mid] = sm;
        const res = (0, resolve_conditional_value_js_1.resolveConditionalValue)(es[key], options);
        if (!res)
            throw (0, errors_js_1.subpathNotExported)(s, pj, from);
        return res.replace(/\*/g, mid);
    }
    // did not find a match
    throw (0, errors_js_1.subpathNotExported)(s, pj, from);
};
exports.resolveExport = resolveExport;
//# sourceMappingURL=resolve-export.js.map