"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNamedExportsList = void 0;
/**
 * Get the condition-resolved targets of all exports
 *
 * Stars are not expanded.
 */
const getNamedExportsList = (exports) => {
    if (!exports)
        return [];
    if (!isExportSubpaths(exports))
        return ['.'];
    return Object.keys(exports).filter(e => e === '.' || e.startsWith('./'));
};
exports.getNamedExportsList = getNamedExportsList;
const isExportSubpaths = (e) => {
    if (!e || typeof e !== 'object' || Array.isArray(e))
        return false;
    for (const p in e) {
        if (p !== '.' && !p.startsWith('./'))
            return false;
    }
    return true;
};
//# sourceMappingURL=get-named-exports-list.js.map