/**
 * Exported as `'resolve-import/get-conditional-values-list'`
 * @module
 */
import { Exports, Imports } from './index.js';
export type ConditionalValuesList = [
    submodulePath: string,
    conditions: Set<string>,
    resolvedValue: string | null
][];
/**
 * Given an `exports` or `imports` value from a package, return the list of all
 * possible conditional values that it might potentially resolve to, for any
 * possible set of import conditions, along with the `Set<string>` of
 * conditions, any superset of which will result in the condition.
 *
 * The list includes null results, since while these are not a valid resolution
 * per se, they do *prevent* valid resolutions that match the same conditions.
 */
export declare const getConditionalValuesList: (importsExports: Imports | Exports) => ConditionalValuesList;
//# sourceMappingURL=get-conditional-values-list.d.ts.map