/**
 * Errors raised by resolve failures.
 * @module
 */
export declare const invalidImportSpecifier: (url: string, caller?: (...a: any[]) => any) => Error;
export declare const invalidPackage: (pj: string | URL, caller?: (...a: any[]) => any) => Error;
export declare const relativeImportWithoutParentURL: (url: string, parentURL: any, caller?: (...a: any[]) => any) => Error & {
    url: string;
    parentURL: any;
};
export declare const subpathNotExported: (sub: string, pj: string, from: string, caller?: (...a: any[]) => any) => Error & {
    code: string;
};
export declare const packageNotFound: (path: string | null, from: string, caller?: (...a: any[]) => any) => Error & {
    code: string;
};
export declare const moduleNotFound: (path: string, from: string, caller?: (...a: any[]) => any) => Error & {
    code: string;
};
export declare const packageImportNotDefined: (path: string, pj: string, from: string, caller?: (...a: any[]) => any) => Error & {
    code: string;
};
//# sourceMappingURL=errors.d.ts.map