// this file is autogenerated using `./scripts/package-swift-manager.swift`
import XCTest
import RxSwift

protocol RxTestCase {
#if os(macOS)
    init()
    static var allTests: [(String, (Self) -> () -> ())] { get }
#endif
    func setUp()
    func tearDown()
}


final class ObservableWithLatestFromTest_ : ObservableWithLatestFromTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableWithLatestFromTest_) -> () -> ())] { return [
    ("testWithLatestFrom_Simple1", ObservableWithLatestFromTest.testWithLatestFrom_Simple1),
    ("testWithLatestFrom_TwoObservablesWithImmediateValues", ObservableWithLatestFromTest.testWithLatestFrom_TwoObservablesWithImmediateValues),
    ("testWithLatestFrom_Simple2", ObservableWithLatestFromTest.testWithLatestFrom_Simple2),
    ("testWithLatestFrom_Simple3", ObservableWithLatestFromTest.testWithLatestFrom_Simple3),
    ("testWithLatestFrom_Error1", ObservableWithLatestFromTest.testWithLatestFrom_Error1),
    ("testWithLatestFrom_Error2", ObservableWithLatestFromTest.testWithLatestFrom_Error2),
    ("testWithLatestFrom_Error3", ObservableWithLatestFromTest.testWithLatestFrom_Error3),
    ("testWithLatestFrom_MakeSureDefaultOverloadTakesSecondSequenceValues", ObservableWithLatestFromTest.testWithLatestFrom_MakeSureDefaultOverloadTakesSecondSequenceValues),
    ] }
}

final class ObservableOptionalTest_ : ObservableOptionalTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableOptionalTest_) -> () -> ())] { return [
    ("testFromOptionalSome_immediate", ObservableOptionalTest.testFromOptionalSome_immediate),
    ("testFromOptionalNone_immediate", ObservableOptionalTest.testFromOptionalNone_immediate),
    ("testFromOptionalSome_basic_testScheduler", ObservableOptionalTest.testFromOptionalSome_basic_testScheduler),
    ("testFromOptionalNone_basic_testScheduler", ObservableOptionalTest.testFromOptionalNone_basic_testScheduler),
    ] }
}

final class AnomaliesTest_ : AnomaliesTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (AnomaliesTest_) -> () -> ())] { return [
    ("test936", AnomaliesTest.test936),
    ("testSeparationBetweenOnAndSubscriptionLocks", AnomaliesTest.testSeparationBetweenOnAndSubscriptionLocks),
    ] }
}

final class ObservableTakeLastTest_ : ObservableTakeLastTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTakeLastTest_) -> () -> ())] { return [
    ("testTakeLast_Complete_Less", ObservableTakeLastTest.testTakeLast_Complete_Less),
    ("testTakeLast_Complete_Same", ObservableTakeLastTest.testTakeLast_Complete_Same),
    ("testTakeLast_Complete_More", ObservableTakeLastTest.testTakeLast_Complete_More),
    ("testTakeLast_Error_Less", ObservableTakeLastTest.testTakeLast_Error_Less),
    ("testTakeLast_Error_Same", ObservableTakeLastTest.testTakeLast_Error_Same),
    ("testTakeLast_Error_More", ObservableTakeLastTest.testTakeLast_Error_More),
    ("testTakeLast_0_DefaultScheduler", ObservableTakeLastTest.testTakeLast_0_DefaultScheduler),
    ("testTakeLast_TakeLast1", ObservableTakeLastTest.testTakeLast_TakeLast1),
    ("testTakeLast_DecrementCountsFirst", ObservableTakeLastTest.testTakeLast_DecrementCountsFirst),
    ] }
}

final class PrimitiveSequenceTest_ : PrimitiveSequenceTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (PrimitiveSequenceTest_) -> () -> ())] { return [
    ("testZip2_selector_producesSingleElement", PrimitiveSequenceTest.testZip2_selector_producesSingleElement),
    ("testZip2_producesSingleElement", PrimitiveSequenceTest.testZip2_producesSingleElement),
    ("testZip3_selector_producesSingleElement", PrimitiveSequenceTest.testZip3_selector_producesSingleElement),
    ("testZip3_producesSingleElement", PrimitiveSequenceTest.testZip3_producesSingleElement),
    ("testZip4_selector_producesSingleElement", PrimitiveSequenceTest.testZip4_selector_producesSingleElement),
    ("testZip4_producesSingleElement", PrimitiveSequenceTest.testZip4_producesSingleElement),
    ("testZip5_selector_producesSingleElement", PrimitiveSequenceTest.testZip5_selector_producesSingleElement),
    ("testZip5_producesSingleElement", PrimitiveSequenceTest.testZip5_producesSingleElement),
    ("testZip6_selector_producesSingleElement", PrimitiveSequenceTest.testZip6_selector_producesSingleElement),
    ("testZip6_producesSingleElement", PrimitiveSequenceTest.testZip6_producesSingleElement),
    ("testZip7_selector_producesSingleElement", PrimitiveSequenceTest.testZip7_selector_producesSingleElement),
    ("testZip7_producesSingleElement", PrimitiveSequenceTest.testZip7_producesSingleElement),
    ("testZip8_selector_producesSingleElement", PrimitiveSequenceTest.testZip8_selector_producesSingleElement),
    ("testZip8_producesSingleElement", PrimitiveSequenceTest.testZip8_producesSingleElement),
    ("testSingle_Subscription_success", PrimitiveSequenceTest.testSingle_Subscription_success),
    ("testSingle_Subscription_error", PrimitiveSequenceTest.testSingle_Subscription_error),
    ("testSingle_create_success", PrimitiveSequenceTest.testSingle_create_success),
    ("testSingle_create_error", PrimitiveSequenceTest.testSingle_create_error),
    ("testSingle_create_disposing", PrimitiveSequenceTest.testSingle_create_disposing),
    ("testMaybe_Subscription_success", PrimitiveSequenceTest.testMaybe_Subscription_success),
    ("testMaybe_Subscription_completed", PrimitiveSequenceTest.testMaybe_Subscription_completed),
    ("testMaybe_Subscription_error", PrimitiveSequenceTest.testMaybe_Subscription_error),
    ("testMaybe_create_success", PrimitiveSequenceTest.testMaybe_create_success),
    ("testMaybe_create_completed", PrimitiveSequenceTest.testMaybe_create_completed),
    ("testMaybe_create_error", PrimitiveSequenceTest.testMaybe_create_error),
    ("testMaybe_create_disposing", PrimitiveSequenceTest.testMaybe_create_disposing),
    ("testCompletable_Subscription_completed", PrimitiveSequenceTest.testCompletable_Subscription_completed),
    ("testCompletable_Subscription_error", PrimitiveSequenceTest.testCompletable_Subscription_error),
    ("testCompletable_create_completed", PrimitiveSequenceTest.testCompletable_create_completed),
    ("testCompletable_create_error", PrimitiveSequenceTest.testCompletable_create_error),
    ("testCompletable_create_disposing", PrimitiveSequenceTest.testCompletable_create_disposing),
    ("testSingle_deferred_producesSingleElement", PrimitiveSequenceTest.testSingle_deferred_producesSingleElement),
    ("testSingle_just_producesSingleElement", PrimitiveSequenceTest.testSingle_just_producesSingleElement),
    ("testSingle_just2_producesSingleElement", PrimitiveSequenceTest.testSingle_just2_producesSingleElement),
    ("testSingle_error_fails", PrimitiveSequenceTest.testSingle_error_fails),
    ("testSingle_never_producesSingleElement", PrimitiveSequenceTest.testSingle_never_producesSingleElement),
    ("testSingle_delaySubscription_producesSingleElement", PrimitiveSequenceTest.testSingle_delaySubscription_producesSingleElement),
    ("testSingle_delay_producesSingleElement", PrimitiveSequenceTest.testSingle_delay_producesSingleElement),
    ("testSingle_do_producesSingleElement", PrimitiveSequenceTest.testSingle_do_producesSingleElement),
    ("testSingle_filter_resultIsMaybe", PrimitiveSequenceTest.testSingle_filter_resultIsMaybe),
    ("testSingle_map_producesSingleElement", PrimitiveSequenceTest.testSingle_map_producesSingleElement),
    ("testSingle_flatMap_producesSingleElement", PrimitiveSequenceTest.testSingle_flatMap_producesSingleElement),
    ("testSingle_observeOn_producesSingleElement", PrimitiveSequenceTest.testSingle_observeOn_producesSingleElement),
    ("testSingle_subscribeOn_producesSingleElement", PrimitiveSequenceTest.testSingle_subscribeOn_producesSingleElement),
    ("testSingle_catchError_producesSingleElement", PrimitiveSequenceTest.testSingle_catchError_producesSingleElement),
    ("testSingle_retry_producesSingleElement", PrimitiveSequenceTest.testSingle_retry_producesSingleElement),
    ("testSingle_retryWhen1_producesSingleElement", PrimitiveSequenceTest.testSingle_retryWhen1_producesSingleElement),
    ("testSingle_retryWhen2_producesSingleElement", PrimitiveSequenceTest.testSingle_retryWhen2_producesSingleElement),
    ("testSingle_timer_producesSingleElement", PrimitiveSequenceTest.testSingle_timer_producesSingleElement),
    ("testSingle_using_producesSingleElement", PrimitiveSequenceTest.testSingle_using_producesSingleElement),
    ("testAsSingle_Empty", PrimitiveSequenceTest.testAsSingle_Empty),
    ("testAsSingle_One", PrimitiveSequenceTest.testAsSingle_One),
    ("testAsSingle_Many", PrimitiveSequenceTest.testAsSingle_Many),
    ("testAsSingle_Error", PrimitiveSequenceTest.testAsSingle_Error),
    ("testAsSingle_Error2", PrimitiveSequenceTest.testAsSingle_Error2),
    ("testAsSingle_subscribeOnSuccess", PrimitiveSequenceTest.testAsSingle_subscribeOnSuccess),
    ("testAsSingle_subscribeOnError", PrimitiveSequenceTest.testAsSingle_subscribeOnError),
    ("testAsMaybe_Empty", PrimitiveSequenceTest.testAsMaybe_Empty),
    ("testAsMaybe_One", PrimitiveSequenceTest.testAsMaybe_One),
    ("testAsMaybe_Many", PrimitiveSequenceTest.testAsMaybe_Many),
    ("testAsMaybe_Error", PrimitiveSequenceTest.testAsMaybe_Error),
    ("testAsMaybe_Error2", PrimitiveSequenceTest.testAsMaybe_Error2),
    ("testAsMaybe_subscribeOnSuccess", PrimitiveSequenceTest.testAsMaybe_subscribeOnSuccess),
    ("testAsMaybe_subscribeOnError", PrimitiveSequenceTest.testAsMaybe_subscribeOnError),
    ("testAsMaybe_subscribeOnCompleted", PrimitiveSequenceTest.testAsMaybe_subscribeOnCompleted),
    ("testAsCompletable_Empty", PrimitiveSequenceTest.testAsCompletable_Empty),
    ("testAsCompletable_Error", PrimitiveSequenceTest.testAsCompletable_Error),
    ("testAsCompletable_subscribeOnCompleted", PrimitiveSequenceTest.testAsCompletable_subscribeOnCompleted),
    ("testAsCompletable_subscribeOnError", PrimitiveSequenceTest.testAsCompletable_subscribeOnError),
    ("testCompletable_merge", PrimitiveSequenceTest.testCompletable_merge),
    ("testDebug_producesSingleElement", PrimitiveSequenceTest.testDebug_producesSingleElement),
    ] }
}

final class VirtualSchedulerTest_ : VirtualSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (VirtualSchedulerTest_) -> () -> ())] { return [
    ("testVirtualScheduler_initialClock", VirtualSchedulerTest.testVirtualScheduler_initialClock),
    ("testVirtualScheduler_start", VirtualSchedulerTest.testVirtualScheduler_start),
    ("testVirtualScheduler_disposeStart", VirtualSchedulerTest.testVirtualScheduler_disposeStart),
    ("testVirtualScheduler_advanceToAfter", VirtualSchedulerTest.testVirtualScheduler_advanceToAfter),
    ("testVirtualScheduler_advanceToBefore", VirtualSchedulerTest.testVirtualScheduler_advanceToBefore),
    ("testVirtualScheduler_disposeAdvanceTo", VirtualSchedulerTest.testVirtualScheduler_disposeAdvanceTo),
    ("testVirtualScheduler_stop", VirtualSchedulerTest.testVirtualScheduler_stop),
    ("testVirtualScheduler_sleep", VirtualSchedulerTest.testVirtualScheduler_sleep),
    ("testVirtualScheduler_stress", VirtualSchedulerTest.testVirtualScheduler_stress),
    ] }
}

final class ObservableBlockingTest_ : ObservableBlockingTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableBlockingTest_) -> () -> ())] { return [
    ("testToArray_empty", ObservableBlockingTest.testToArray_empty),
    ("testToArray_return", ObservableBlockingTest.testToArray_return),
    ("testToArray_fail", ObservableBlockingTest.testToArray_fail),
    ("testToArray_someData", ObservableBlockingTest.testToArray_someData),
    ("testToArray_withRealScheduler", ObservableBlockingTest.testToArray_withRealScheduler),
    ("testToArray_independent", ObservableBlockingTest.testToArray_independent),
    ("testToArray_timeout", ObservableBlockingTest.testToArray_timeout),
    ("testFirst_empty", ObservableBlockingTest.testFirst_empty),
    ("testFirst_return", ObservableBlockingTest.testFirst_return),
    ("testFirst_fail", ObservableBlockingTest.testFirst_fail),
    ("testFirst_someData", ObservableBlockingTest.testFirst_someData),
    ("testFirst_withRealScheduler", ObservableBlockingTest.testFirst_withRealScheduler),
    ("testFirst_independent", ObservableBlockingTest.testFirst_independent),
    ("testFirst_timeout", ObservableBlockingTest.testFirst_timeout),
    ("testLast_empty", ObservableBlockingTest.testLast_empty),
    ("testLast_return", ObservableBlockingTest.testLast_return),
    ("testLast_fail", ObservableBlockingTest.testLast_fail),
    ("testLast_someData", ObservableBlockingTest.testLast_someData),
    ("testLast_withRealScheduler", ObservableBlockingTest.testLast_withRealScheduler),
    ("testLast_independent", ObservableBlockingTest.testLast_independent),
    ("testLast_timeout", ObservableBlockingTest.testLast_timeout),
    ("testSingle_empty", ObservableBlockingTest.testSingle_empty),
    ("testSingle_return", ObservableBlockingTest.testSingle_return),
    ("testSingle_two", ObservableBlockingTest.testSingle_two),
    ("testSingle_someData", ObservableBlockingTest.testSingle_someData),
    ("testSingle_fail", ObservableBlockingTest.testSingle_fail),
    ("testSingle_withRealScheduler", ObservableBlockingTest.testSingle_withRealScheduler),
    ("testSingle_predicate_empty", ObservableBlockingTest.testSingle_predicate_empty),
    ("testSingle_predicate_return", ObservableBlockingTest.testSingle_predicate_return),
    ("testSingle_predicate_someData_one_match", ObservableBlockingTest.testSingle_predicate_someData_one_match),
    ("testSingle_predicate_someData_two_match", ObservableBlockingTest.testSingle_predicate_someData_two_match),
    ("testSingle_predicate_none", ObservableBlockingTest.testSingle_predicate_none),
    ("testSingle_predicate_throws", ObservableBlockingTest.testSingle_predicate_throws),
    ("testSingle_predicate_fail", ObservableBlockingTest.testSingle_predicate_fail),
    ("testSingle_predicate_withRealScheduler", ObservableBlockingTest.testSingle_predicate_withRealScheduler),
    ("testSingle_independent", ObservableBlockingTest.testSingle_independent),
    ("testSingle_timeout", ObservableBlockingTest.testSingle_timeout),
    ("testSinglePredicate_timeout", ObservableBlockingTest.testSinglePredicate_timeout),
    ] }
}

final class ObservableRetryWhenTest_ : ObservableRetryWhenTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableRetryWhenTest_) -> () -> ())] { return [
    ("testRetryWhen_Never", ObservableRetryWhenTest.testRetryWhen_Never),
    ("testRetryWhen_ObservableNever", ObservableRetryWhenTest.testRetryWhen_ObservableNever),
    ("testRetryWhen_ObservableNeverComplete", ObservableRetryWhenTest.testRetryWhen_ObservableNeverComplete),
    ("testRetryWhen_ObservableEmpty", ObservableRetryWhenTest.testRetryWhen_ObservableEmpty),
    ("testRetryWhen_ObservableNextError", ObservableRetryWhenTest.testRetryWhen_ObservableNextError),
    ("testRetryWhen_ObservableComplete", ObservableRetryWhenTest.testRetryWhen_ObservableComplete),
    ("testRetryWhen_ObservableNextComplete", ObservableRetryWhenTest.testRetryWhen_ObservableNextComplete),
    ("testRetryWhen_ObservableInfinite", ObservableRetryWhenTest.testRetryWhen_ObservableInfinite),
    ("testRetryWhen_Incremental_BackOff", ObservableRetryWhenTest.testRetryWhen_Incremental_BackOff),
    ("testRetryWhen_IgnoresDifferentErrorTypes", ObservableRetryWhenTest.testRetryWhen_IgnoresDifferentErrorTypes),
    ("testRetryWhen_tailRecursiveOptimizationsTest", ObservableRetryWhenTest.testRetryWhen_tailRecursiveOptimizationsTest),
    ] }
}

final class ObservableDelaySubscriptionTest_ : ObservableDelaySubscriptionTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDelaySubscriptionTest_) -> () -> ())] { return [
    ("testDelaySubscription_TimeSpan_Simple", ObservableDelaySubscriptionTest.testDelaySubscription_TimeSpan_Simple),
    ("testDelaySubscription_TimeSpan_Error", ObservableDelaySubscriptionTest.testDelaySubscription_TimeSpan_Error),
    ("testDelaySubscription_TimeSpan_Dispose", ObservableDelaySubscriptionTest.testDelaySubscription_TimeSpan_Dispose),
    ] }
}

final class ObservableDistinctUntilChangedTest_ : ObservableDistinctUntilChangedTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDistinctUntilChangedTest_) -> () -> ())] { return [
    ("testDistinctUntilChanged_allChanges", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_allChanges),
    ("testDistinctUntilChanged_someChanges", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_someChanges),
    ("testDistinctUntilChanged_allEqual", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_allEqual),
    ("testDistinctUntilChanged_allDifferent", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_allDifferent),
    ("testDistinctUntilChanged_keySelector_Div2", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_keySelector_Div2),
    ("testDistinctUntilChanged_keySelectorThrows", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_keySelectorThrows),
    ("testDistinctUntilChanged_comparerThrows", ObservableDistinctUntilChangedTest.testDistinctUntilChanged_comparerThrows),
    ] }
}

final class ObservableObserveOnTest_ : ObservableObserveOnTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableObserveOnTest_) -> () -> ())] { return [
    ("testObserveOnDispatchQueue_DoesPerformWorkOnQueue", ObservableObserveOnTest.testObserveOnDispatchQueue_DoesPerformWorkOnQueue),
    ("testObserveOnDispatchQueue_DeadlockErrorImmediatelly", ObservableObserveOnTest.testObserveOnDispatchQueue_DeadlockErrorImmediatelly),
    ("testObserveOnDispatchQueue_DeadlockEmpty", ObservableObserveOnTest.testObserveOnDispatchQueue_DeadlockEmpty),
    ("testObserveOnDispatchQueue_Never", ObservableObserveOnTest.testObserveOnDispatchQueue_Never),
    ("testObserveOnDispatchQueue_Simple", ObservableObserveOnTest.testObserveOnDispatchQueue_Simple),
    ("testObserveOnDispatchQueue_Empty", ObservableObserveOnTest.testObserveOnDispatchQueue_Empty),
    ("testObserveOnDispatchQueue_Error", ObservableObserveOnTest.testObserveOnDispatchQueue_Error),
    ("testObserveOnDispatchQueue_Dispose", ObservableObserveOnTest.testObserveOnDispatchQueue_Dispose),
    ] }
}

final class ObservableSkipWhileTest_ : ObservableSkipWhileTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSkipWhileTest_) -> () -> ())] { return [
    ("testSkipWhile_Complete_Before", ObservableSkipWhileTest.testSkipWhile_Complete_Before),
    ("testSkipWhile_Complete_After", ObservableSkipWhileTest.testSkipWhile_Complete_After),
    ("testSkipWhile_Error_Before", ObservableSkipWhileTest.testSkipWhile_Error_Before),
    ("testSkipWhile_Error_After", ObservableSkipWhileTest.testSkipWhile_Error_After),
    ("testSkipWhile_Dispose_Before", ObservableSkipWhileTest.testSkipWhile_Dispose_Before),
    ("testSkipWhile_Dispose_After", ObservableSkipWhileTest.testSkipWhile_Dispose_After),
    ("testSkipWhile_Zero", ObservableSkipWhileTest.testSkipWhile_Zero),
    ("testSkipWhile_Throw", ObservableSkipWhileTest.testSkipWhile_Throw),
    ("testSkipWhile_Index", ObservableSkipWhileTest.testSkipWhile_Index),
    ("testSkipWhile_Index_Throw", ObservableSkipWhileTest.testSkipWhile_Index_Throw),
    ("testSkipWhile_Index_SelectorThrows", ObservableSkipWhileTest.testSkipWhile_Index_SelectorThrows),
    ] }
}

final class ObservableSwitchTest_ : ObservableSwitchTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSwitchTest_) -> () -> ())] { return [
    ("testSwitch_Data", ObservableSwitchTest.testSwitch_Data),
    ("testSwitch_InnerThrows", ObservableSwitchTest.testSwitch_InnerThrows),
    ("testSwitch_OuterThrows", ObservableSwitchTest.testSwitch_OuterThrows),
    ("testFlatMapLatest_Data", ObservableSwitchTest.testFlatMapLatest_Data),
    ("testFlatMapLatest_InnerThrows", ObservableSwitchTest.testFlatMapLatest_InnerThrows),
    ("testFlatMapLatest_OuterThrows", ObservableSwitchTest.testFlatMapLatest_OuterThrows),
    ("testFlatMapLatest_SelectorThrows", ObservableSwitchTest.testFlatMapLatest_SelectorThrows),
    ] }
}

final class ObservableSkipTest_ : ObservableSkipTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSkipTest_) -> () -> ())] { return [
    ("testSkip_Complete_After", ObservableSkipTest.testSkip_Complete_After),
    ("testSkip_Complete_Some", ObservableSkipTest.testSkip_Complete_Some),
    ("testSkip_Complete_Before", ObservableSkipTest.testSkip_Complete_Before),
    ("testSkip_Complete_Zero", ObservableSkipTest.testSkip_Complete_Zero),
    ("testSkip_Error_After", ObservableSkipTest.testSkip_Error_After),
    ("testSkip_Error_Same", ObservableSkipTest.testSkip_Error_Same),
    ("testSkip_Error_Before", ObservableSkipTest.testSkip_Error_Before),
    ("testSkip_Dispose_Before", ObservableSkipTest.testSkip_Dispose_Before),
    ("testSkip_Dispose_After", ObservableSkipTest.testSkip_Dispose_After),
    ("testSkip_Zero", ObservableSkipTest.testSkip_Zero),
    ("testSkip_Some", ObservableSkipTest.testSkip_Some),
    ("testSkip_Late", ObservableSkipTest.testSkip_Late),
    ("testSkip_Error", ObservableSkipTest.testSkip_Error),
    ("testSkip_Never", ObservableSkipTest.testSkip_Never),
    ] }
}

final class ObservableTest_ : ObservableTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTest_) -> () -> ())] { return [
    ("testAnonymousObservable_detachesOnDispose", ObservableTest.testAnonymousObservable_detachesOnDispose),
    ("testAnonymousObservable_detachesOnComplete", ObservableTest.testAnonymousObservable_detachesOnComplete),
    ("testAnonymousObservable_detachesOnError", ObservableTest.testAnonymousObservable_detachesOnError),
    ("testAsObservable_asObservable", ObservableTest.testAsObservable_asObservable),
    ("testAsObservable_hides", ObservableTest.testAsObservable_hides),
    ("testAsObservable_never", ObservableTest.testAsObservable_never),
    ] }
}

final class ObservableRangeTest_ : ObservableRangeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableRangeTest_) -> () -> ())] { return [
    ("testRange_Boundaries", ObservableRangeTest.testRange_Boundaries),
    ("testRange_Dispose", ObservableRangeTest.testRange_Dispose),
    ] }
}

final class ObservableScanTest_ : ObservableScanTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableScanTest_) -> () -> ())] { return [
    ("testScan_Seed_Never", ObservableScanTest.testScan_Seed_Never),
    ("testScan_Seed_Empty", ObservableScanTest.testScan_Seed_Empty),
    ("testScan_Seed_Return", ObservableScanTest.testScan_Seed_Return),
    ("testScan_Seed_Throw", ObservableScanTest.testScan_Seed_Throw),
    ("testScan_Seed_SomeData", ObservableScanTest.testScan_Seed_SomeData),
    ("testScan_Seed_AccumulatorThrows", ObservableScanTest.testScan_Seed_AccumulatorThrows),
    ] }
}

final class ReplaySubjectTest_ : ReplaySubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ReplaySubjectTest_) -> () -> ())] { return [
    ("test_hasObserversNoObservers", ReplaySubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", ReplaySubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", ReplaySubjectTest.test_hasObserversManyObserver),
    ] }
}

final class DisposableTest_ : DisposableTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (DisposableTest_) -> () -> ())] { return [
    ("testActionDisposable", DisposableTest.testActionDisposable),
    ("testHotObservable_Disposing", DisposableTest.testHotObservable_Disposing),
    ("testCompositeDisposable_TestNormal", DisposableTest.testCompositeDisposable_TestNormal),
    ("testCompositeDisposable_TestInitWithNumberOfDisposables", DisposableTest.testCompositeDisposable_TestInitWithNumberOfDisposables),
    ("testCompositeDisposable_TestRemoving", DisposableTest.testCompositeDisposable_TestRemoving),
    ("testDisposables_TestCreateWithNumberOfDisposables", DisposableTest.testDisposables_TestCreateWithNumberOfDisposables),
    ("testRefCountDisposable_RefCounting", DisposableTest.testRefCountDisposable_RefCounting),
    ("testRefCountDisposable_PrimaryDisposesFirst", DisposableTest.testRefCountDisposable_PrimaryDisposesFirst),
    ("testSingleAssignmentDisposable_firstDisposedThenSet", DisposableTest.testSingleAssignmentDisposable_firstDisposedThenSet),
    ("testSingleAssignmentDisposable_firstSetThenDisposed", DisposableTest.testSingleAssignmentDisposable_firstSetThenDisposed),
    ("testSingleAssignmentDisposable_stress", DisposableTest.testSingleAssignmentDisposable_stress),
    ] }
}

final class RecursiveLockTests_ : RecursiveLockTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (RecursiveLockTests_) -> () -> ())] { return [
    ("testSynchronizes", RecursiveLockTests.testSynchronizes),
    ("testIsReentrant", RecursiveLockTests.testIsReentrant),
    ] }
}

final class QueueTest_ : QueueTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (QueueTest_) -> () -> ())] { return [
    ("testComplexity", QueueTest.testComplexity),
    ] }
}

final class ObservableSequenceTest_ : ObservableSequenceTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSequenceTest_) -> () -> ())] { return [
    ("testFromArray_complete_immediate", ObservableSequenceTest.testFromArray_complete_immediate),
    ("testFromArray_complete", ObservableSequenceTest.testFromArray_complete),
    ("testFromArray_dispose", ObservableSequenceTest.testFromArray_dispose),
    ("testSequenceOf_complete_immediate", ObservableSequenceTest.testSequenceOf_complete_immediate),
    ("testSequenceOf_complete", ObservableSequenceTest.testSequenceOf_complete),
    ("testSequenceOf_dispose", ObservableSequenceTest.testSequenceOf_dispose),
    ("testFromAnySequence_basic_immediate", ObservableSequenceTest.testFromAnySequence_basic_immediate),
    ("testToObservableAnySequence_basic_testScheduler", ObservableSequenceTest.testToObservableAnySequence_basic_testScheduler),
    ] }
}

final class DriverTest_ : DriverTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (DriverTest_) -> () -> ())] { return [
    ("testDriverSharing_WhenErroring", DriverTest.testDriverSharing_WhenErroring),
    ("testDriverSharing_WhenCompleted", DriverTest.testDriverSharing_WhenCompleted),
    ("testVariableAsDriver", DriverTest.testVariableAsDriver),
    ("testAsDriver_onErrorJustReturn", DriverTest.testAsDriver_onErrorJustReturn),
    ("testAsDriver_onErrorDriveWith", DriverTest.testAsDriver_onErrorDriveWith),
    ("testAsDriver_onErrorRecover", DriverTest.testAsDriver_onErrorRecover),
    ("testAsDriver_deferred", DriverTest.testAsDriver_deferred),
    ("testAsDriver_map", DriverTest.testAsDriver_map),
    ("testAsDriver_filter", DriverTest.testAsDriver_filter),
    ("testAsDriver_switchLatest", DriverTest.testAsDriver_switchLatest),
    ("testAsDriver_flatMapLatest", DriverTest.testAsDriver_flatMapLatest),
    ("testAsDriver_flatMapFirst", DriverTest.testAsDriver_flatMapFirst),
    ("testAsDriver_doOn", DriverTest.testAsDriver_doOn),
    ("testAsDriver_doOnNext", DriverTest.testAsDriver_doOnNext),
    ("testAsDriver_doOnCompleted", DriverTest.testAsDriver_doOnCompleted),
    ("testAsDriver_distinctUntilChanged1", DriverTest.testAsDriver_distinctUntilChanged1),
    ("testAsDriver_distinctUntilChanged2", DriverTest.testAsDriver_distinctUntilChanged2),
    ("testAsDriver_distinctUntilChanged3", DriverTest.testAsDriver_distinctUntilChanged3),
    ("testAsDriver_distinctUntilChanged4", DriverTest.testAsDriver_distinctUntilChanged4),
    ("testAsDriver_flatMap", DriverTest.testAsDriver_flatMap),
    ("testAsDriver_mergeSync", DriverTest.testAsDriver_mergeSync),
    ("testAsDriver_merge", DriverTest.testAsDriver_merge),
    ("testAsDriver_merge2", DriverTest.testAsDriver_merge2),
    ("testAsDriver_debug", DriverTest.testAsDriver_debug),
    ("testAsDriver_debounce", DriverTest.testAsDriver_debounce),
    ("testAsDriver_throttle", DriverTest.testAsDriver_throttle),
    ("testAsDriver_throttle2", DriverTest.testAsDriver_throttle2),
    ("testAsDriver_scan", DriverTest.testAsDriver_scan),
    ("testAsDriver_concat_sequenceType", DriverTest.testAsDriver_concat_sequenceType),
    ("testAsDriver_concat", DriverTest.testAsDriver_concat),
    ("testAsDriver_combineLatest_array", DriverTest.testAsDriver_combineLatest_array),
    ("testAsDriver_combineLatest", DriverTest.testAsDriver_combineLatest),
    ("testAsDriver_zip_array", DriverTest.testAsDriver_zip_array),
    ("testAsDriver_zip", DriverTest.testAsDriver_zip),
    ("testAsDriver_withLatestFrom", DriverTest.testAsDriver_withLatestFrom),
    ("testAsDriver_withLatestFromDefaultOverload", DriverTest.testAsDriver_withLatestFromDefaultOverload),
    ("testAsDriver_skip", DriverTest.testAsDriver_skip),
    ("testAsDriver_startWith", DriverTest.testAsDriver_startWith),
    ("testAsDriver_interval", DriverTest.testAsDriver_interval),
    ("testAsDriver_timer", DriverTest.testAsDriver_timer),
    ("testDriveObserver", DriverTest.testDriveObserver),
    ("testDriveOptionalObserver", DriverTest.testDriveOptionalObserver),
    ("testDriveNoAmbiguity", DriverTest.testDriveNoAmbiguity),
    ("testdriveVariable", DriverTest.testdriveVariable),
    ("testDriveOptionalVariable", DriverTest.testDriveOptionalVariable),
    ("testDriveVariableNoAmbiguity", DriverTest.testDriveVariableNoAmbiguity),
    ("testDriverFromOptional", DriverTest.testDriverFromOptional),
    ("testDriverFromOptionalWhenNil", DriverTest.testDriverFromOptionalWhenNil),
    ("testDriverFromSequence", DriverTest.testDriverFromSequence),
    ("testDriverFromArray", DriverTest.testDriverFromArray),
    ("testDrivingOrderOfSynchronousSubscriptions1", DriverTest.testDrivingOrderOfSynchronousSubscriptions1),
    ("testDrivingOrderOfSynchronousSubscriptions2", DriverTest.testDrivingOrderOfSynchronousSubscriptions2),
    ] }
}

final class ObservableMapTest_ : ObservableMapTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableMapTest_) -> () -> ())] { return [
    ("testMap_Never", ObservableMapTest.testMap_Never),
    ("testMap_Empty", ObservableMapTest.testMap_Empty),
    ("testMap_Range", ObservableMapTest.testMap_Range),
    ("testMap_Error", ObservableMapTest.testMap_Error),
    ("testMap_Dispose", ObservableMapTest.testMap_Dispose),
    ("testMap_SelectorThrows", ObservableMapTest.testMap_SelectorThrows),
    ("testMap1_Never", ObservableMapTest.testMap1_Never),
    ("testMap1_Empty", ObservableMapTest.testMap1_Empty),
    ("testMap1_Range", ObservableMapTest.testMap1_Range),
    ("testMap1_Error", ObservableMapTest.testMap1_Error),
    ("testMap1_Dispose", ObservableMapTest.testMap1_Dispose),
    ("testMap1_SelectorThrows", ObservableMapTest.testMap1_SelectorThrows),
    ("testMap_DisposeOnCompleted", ObservableMapTest.testMap_DisposeOnCompleted),
    ("testMap1_DisposeOnCompleted", ObservableMapTest.testMap1_DisposeOnCompleted),
    ("testMapCompose_Never", ObservableMapTest.testMapCompose_Never),
    ("testMapCompose_Empty", ObservableMapTest.testMapCompose_Empty),
    ("testMapCompose_Range", ObservableMapTest.testMapCompose_Range),
    ("testMapCompose_Error", ObservableMapTest.testMapCompose_Error),
    ("testMapCompose_Dispose", ObservableMapTest.testMapCompose_Dispose),
    ("testMapCompose_Selector1Throws", ObservableMapTest.testMapCompose_Selector1Throws),
    ("testMapCompose_Selector2Throws", ObservableMapTest.testMapCompose_Selector2Throws),
    ] }
}

final class CurrentThreadSchedulerTest_ : CurrentThreadSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (CurrentThreadSchedulerTest_) -> () -> ())] { return [
    ("testCurrentThreadScheduler_scheduleRequired", CurrentThreadSchedulerTest.testCurrentThreadScheduler_scheduleRequired),
    ("testCurrentThreadScheduler_basicScenario", CurrentThreadSchedulerTest.testCurrentThreadScheduler_basicScenario),
    ("testCurrentThreadScheduler_disposing1", CurrentThreadSchedulerTest.testCurrentThreadScheduler_disposing1),
    ("testCurrentThreadScheduler_disposing2", CurrentThreadSchedulerTest.testCurrentThreadScheduler_disposing2),
    ] }
}

final class ObservableSubscribeOnTest_ : ObservableSubscribeOnTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSubscribeOnTest_) -> () -> ())] { return [
    ("testSubscribeOn_SchedulerSleep", ObservableSubscribeOnTest.testSubscribeOn_SchedulerSleep),
    ("testSubscribeOn_SchedulerCompleted", ObservableSubscribeOnTest.testSubscribeOn_SchedulerCompleted),
    ("testSubscribeOn_SchedulerError", ObservableSubscribeOnTest.testSubscribeOn_SchedulerError),
    ("testSubscribeOn_SchedulerDispose", ObservableSubscribeOnTest.testSubscribeOn_SchedulerDispose),
    ] }
}

final class ObservableWindowTest_ : ObservableWindowTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableWindowTest_) -> () -> ())] { return [
    ("testWindowWithTimeOrCount_Basic", ObservableWindowTest.testWindowWithTimeOrCount_Basic),
    ("testWindowWithTimeOrCount_Error", ObservableWindowTest.testWindowWithTimeOrCount_Error),
    ("testWindowWithTimeOrCount_Disposed", ObservableWindowTest.testWindowWithTimeOrCount_Disposed),
    ] }
}

final class ObservableZipTest_ : ObservableZipTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableZipTest_) -> () -> ())] { return [
    ("testZip_ImmediateSchedule2", ObservableZipTest.testZip_ImmediateSchedule2),
    ("testZip_Never2", ObservableZipTest.testZip_Never2),
    ("testZip_Empty2", ObservableZipTest.testZip_Empty2),
    ("testZip_SymmetricReturn2", ObservableZipTest.testZip_SymmetricReturn2),
    ("testZip_AllCompleted2", ObservableZipTest.testZip_AllCompleted2),
    ("testZip_ImmediateSchedule3", ObservableZipTest.testZip_ImmediateSchedule3),
    ("testZip_Never3", ObservableZipTest.testZip_Never3),
    ("testZip_Empty3", ObservableZipTest.testZip_Empty3),
    ("testZip_SymmetricReturn3", ObservableZipTest.testZip_SymmetricReturn3),
    ("testZip_AllCompleted3", ObservableZipTest.testZip_AllCompleted3),
    ("testZip_ImmediateSchedule4", ObservableZipTest.testZip_ImmediateSchedule4),
    ("testZip_Never4", ObservableZipTest.testZip_Never4),
    ("testZip_Empty4", ObservableZipTest.testZip_Empty4),
    ("testZip_SymmetricReturn4", ObservableZipTest.testZip_SymmetricReturn4),
    ("testZip_AllCompleted4", ObservableZipTest.testZip_AllCompleted4),
    ("testZip_ImmediateSchedule5", ObservableZipTest.testZip_ImmediateSchedule5),
    ("testZip_Never5", ObservableZipTest.testZip_Never5),
    ("testZip_Empty5", ObservableZipTest.testZip_Empty5),
    ("testZip_SymmetricReturn5", ObservableZipTest.testZip_SymmetricReturn5),
    ("testZip_AllCompleted5", ObservableZipTest.testZip_AllCompleted5),
    ("testZip_ImmediateSchedule6", ObservableZipTest.testZip_ImmediateSchedule6),
    ("testZip_Never6", ObservableZipTest.testZip_Never6),
    ("testZip_Empty6", ObservableZipTest.testZip_Empty6),
    ("testZip_SymmetricReturn6", ObservableZipTest.testZip_SymmetricReturn6),
    ("testZip_AllCompleted6", ObservableZipTest.testZip_AllCompleted6),
    ("testZip_ImmediateSchedule7", ObservableZipTest.testZip_ImmediateSchedule7),
    ("testZip_Never7", ObservableZipTest.testZip_Never7),
    ("testZip_Empty7", ObservableZipTest.testZip_Empty7),
    ("testZip_SymmetricReturn7", ObservableZipTest.testZip_SymmetricReturn7),
    ("testZip_AllCompleted7", ObservableZipTest.testZip_AllCompleted7),
    ("testZip_ImmediateSchedule8", ObservableZipTest.testZip_ImmediateSchedule8),
    ("testZip_Never8", ObservableZipTest.testZip_Never8),
    ("testZip_Empty8", ObservableZipTest.testZip_Empty8),
    ("testZip_SymmetricReturn8", ObservableZipTest.testZip_SymmetricReturn8),
    ("testZip_AllCompleted8", ObservableZipTest.testZip_AllCompleted8),
    ("testZip_NeverEmpty", ObservableZipTest.testZip_NeverEmpty),
    ("testZip_EmptyNever", ObservableZipTest.testZip_EmptyNever),
    ("testZip_EmptyNonEmpty", ObservableZipTest.testZip_EmptyNonEmpty),
    ("testZip_NonEmptyEmpty", ObservableZipTest.testZip_NonEmptyEmpty),
    ("testZip_NeverNonEmpty", ObservableZipTest.testZip_NeverNonEmpty),
    ("testZip_NonEmptyNever", ObservableZipTest.testZip_NonEmptyNever),
    ("testZip_NonEmptyNonEmpty", ObservableZipTest.testZip_NonEmptyNonEmpty),
    ("testZip_EmptyError", ObservableZipTest.testZip_EmptyError),
    ("testZip_ErrorEmpty", ObservableZipTest.testZip_ErrorEmpty),
    ("testZip_NeverError", ObservableZipTest.testZip_NeverError),
    ("testZip_ErrorNever", ObservableZipTest.testZip_ErrorNever),
    ("testZip_ErrorError", ObservableZipTest.testZip_ErrorError),
    ("testZip_SomeError", ObservableZipTest.testZip_SomeError),
    ("testZip_ErrorSome", ObservableZipTest.testZip_ErrorSome),
    ("testZip_LeftCompletesFirst", ObservableZipTest.testZip_LeftCompletesFirst),
    ("testZip_RightCompletesFirst", ObservableZipTest.testZip_RightCompletesFirst),
    ("testZip_LeftTriggersSelectorError", ObservableZipTest.testZip_LeftTriggersSelectorError),
    ("testZip_RightTriggersSelectorError", ObservableZipTest.testZip_RightTriggersSelectorError),
    ("testZip_NAry_emptyArray", ObservableZipTest.testZip_NAry_emptyArray),
    ("testZip_NAry_symmetric", ObservableZipTest.testZip_NAry_symmetric),
    ("testZip_NAry_asymmetric", ObservableZipTest.testZip_NAry_asymmetric),
    ("testZip_NAry_error", ObservableZipTest.testZip_NAry_error),
    ("testZip_NAry_atLeastOneErrors4", ObservableZipTest.testZip_NAry_atLeastOneErrors4),
    ] }
}

final class ObservableSkipUntilTest_ : ObservableSkipUntilTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSkipUntilTest_) -> () -> ())] { return [
    ("testSkipUntil_SomeData_Next", ObservableSkipUntilTest.testSkipUntil_SomeData_Next),
    ("testSkipUntil_SomeData_Error", ObservableSkipUntilTest.testSkipUntil_SomeData_Error),
    ("testSkipUntil_Error_SomeData", ObservableSkipUntilTest.testSkipUntil_Error_SomeData),
    ("testSkipUntil_SomeData_Empty", ObservableSkipUntilTest.testSkipUntil_SomeData_Empty),
    ("testSkipUntil_Never_Next", ObservableSkipUntilTest.testSkipUntil_Never_Next),
    ("testSkipUntil_Never_Error1", ObservableSkipUntilTest.testSkipUntil_Never_Error1),
    ("testSkipUntil_SomeData_Error2", ObservableSkipUntilTest.testSkipUntil_SomeData_Error2),
    ("testSkipUntil_SomeData_Never", ObservableSkipUntilTest.testSkipUntil_SomeData_Never),
    ("testSkipUntil_Never_Empty", ObservableSkipUntilTest.testSkipUntil_Never_Empty),
    ("testSkipUntil_Never_Never", ObservableSkipUntilTest.testSkipUntil_Never_Never),
    ("testSkipUntil_HasCompletedCausesDisposal", ObservableSkipUntilTest.testSkipUntil_HasCompletedCausesDisposal),
    ] }
}

final class ObservableDefaultIfEmptyTest_ : ObservableDefaultIfEmptyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDefaultIfEmptyTest_) -> () -> ())] { return [
    ("testDefaultIfEmpty_Source_Empty", ObservableDefaultIfEmptyTest.testDefaultIfEmpty_Source_Empty),
    ("testDefaultIfEmpty_Source_Errors", ObservableDefaultIfEmptyTest.testDefaultIfEmpty_Source_Errors),
    ("testDefaultIfEmpty_Source_Emits", ObservableDefaultIfEmptyTest.testDefaultIfEmpty_Source_Emits),
    ("testDefaultIfEmpty_Never", ObservableDefaultIfEmptyTest.testDefaultIfEmpty_Never),
    ] }
}

final class ObservableFilterTest_ : ObservableFilterTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableFilterTest_) -> () -> ())] { return [
    ("test_filterComplete", ObservableFilterTest.test_filterComplete),
    ("test_filterTrue", ObservableFilterTest.test_filterTrue),
    ("test_filterFalse", ObservableFilterTest.test_filterFalse),
    ("test_filterDisposed", ObservableFilterTest.test_filterDisposed),
    ("testIgnoreElements_DoesNotSendValues", ObservableFilterTest.testIgnoreElements_DoesNotSendValues),
    ] }
}

final class ObservableAmbTest_ : ObservableAmbTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableAmbTest_) -> () -> ())] { return [
    ("testAmb_Never2", ObservableAmbTest.testAmb_Never2),
    ("testAmb_Never3", ObservableAmbTest.testAmb_Never3),
    ("testAmb_Never_Empty", ObservableAmbTest.testAmb_Never_Empty),
    ("testAmb_RegularShouldDisposeLoser", ObservableAmbTest.testAmb_RegularShouldDisposeLoser),
    ("testAmb_WinnerThrows", ObservableAmbTest.testAmb_WinnerThrows),
    ("testAmb_LoserThrows", ObservableAmbTest.testAmb_LoserThrows),
    ("testAmb_ThrowsBeforeElectionLeft", ObservableAmbTest.testAmb_ThrowsBeforeElectionLeft),
    ("testAmb_ThrowsBeforeElectionRight", ObservableAmbTest.testAmb_ThrowsBeforeElectionRight),
    ] }
}

final class ObservableConcatTest_ : ObservableConcatTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableConcatTest_) -> () -> ())] { return [
    ("testConcat_DefaultScheduler", ObservableConcatTest.testConcat_DefaultScheduler),
    ("testConcat_IEofIO", ObservableConcatTest.testConcat_IEofIO),
    ("testConcat_EmptyEmpty", ObservableConcatTest.testConcat_EmptyEmpty),
    ("testConcat_EmptyNever", ObservableConcatTest.testConcat_EmptyNever),
    ("testConcat_NeverNever", ObservableConcatTest.testConcat_NeverNever),
    ("testConcat_EmptyThrow", ObservableConcatTest.testConcat_EmptyThrow),
    ("testConcat_ThrowEmpty", ObservableConcatTest.testConcat_ThrowEmpty),
    ("testConcat_ThrowThrow", ObservableConcatTest.testConcat_ThrowThrow),
    ("testConcat_ReturnEmpty", ObservableConcatTest.testConcat_ReturnEmpty),
    ("testConcat_EmptyReturn", ObservableConcatTest.testConcat_EmptyReturn),
    ("testConcat_ReturnNever", ObservableConcatTest.testConcat_ReturnNever),
    ("testConcat_NeverReturn", ObservableConcatTest.testConcat_NeverReturn),
    ("testConcat_ReturnReturn", ObservableConcatTest.testConcat_ReturnReturn),
    ("testConcat_ThrowReturn", ObservableConcatTest.testConcat_ThrowReturn),
    ("testConcat_ReturnThrow", ObservableConcatTest.testConcat_ReturnThrow),
    ("testConcat_SomeDataSomeData", ObservableConcatTest.testConcat_SomeDataSomeData),
    ("testConcat_EnumerableTiming", ObservableConcatTest.testConcat_EnumerableTiming),
    ("testConcat_variadicElementsOverload", ObservableConcatTest.testConcat_variadicElementsOverload),
    ] }
}

final class EventTests_ : EventTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (EventTests_) -> () -> ())] { return [
    ("testMapTransformNext", EventTests.testMapTransformNext),
    ("testMapTransformNextThrow", EventTests.testMapTransformNextThrow),
    ("testMapTransformError", EventTests.testMapTransformError),
    ("testMapTransformCompleted", EventTests.testMapTransformCompleted),
    ] }
}

final class ObservableMulticastTest_ : ObservableMulticastTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableMulticastTest_) -> () -> ())] { return [
    ("testMulticastWhileConnected_connectControlsSourceSubscription", ObservableMulticastTest.testMulticastWhileConnected_connectControlsSourceSubscription),
    ("testMulticastWhileConnected_connectFirstThenSubscribe", ObservableMulticastTest.testMulticastWhileConnected_connectFirstThenSubscribe),
    ("testMulticastWhileConnected_completed", ObservableMulticastTest.testMulticastWhileConnected_completed),
    ("testMulticastWhileConnected_error", ObservableMulticastTest.testMulticastWhileConnected_error),
    ("testMulticastForever_connectControlsSourceSubscription", ObservableMulticastTest.testMulticastForever_connectControlsSourceSubscription),
    ("testMulticastForever_connectFirstThenSubscribe", ObservableMulticastTest.testMulticastForever_connectFirstThenSubscribe),
    ("testMulticastForever_completed", ObservableMulticastTest.testMulticastForever_completed),
    ("testMulticastForever_error", ObservableMulticastTest.testMulticastForever_error),
    ("testMulticast_Cold_Completed", ObservableMulticastTest.testMulticast_Cold_Completed),
    ("testMulticast_Cold_Error", ObservableMulticastTest.testMulticast_Cold_Error),
    ("testMulticast_Cold_Dispose", ObservableMulticastTest.testMulticast_Cold_Dispose),
    ("testMulticast_Cold_Zip", ObservableMulticastTest.testMulticast_Cold_Zip),
    ("testMulticast_SubjectSelectorThrows", ObservableMulticastTest.testMulticast_SubjectSelectorThrows),
    ("testMulticast_SelectorThrows", ObservableMulticastTest.testMulticast_SelectorThrows),
    ("testRefCount_DeadlockSimple", ObservableMulticastTest.testRefCount_DeadlockSimple),
    ("testRefCount_DeadlockErrorAfterN", ObservableMulticastTest.testRefCount_DeadlockErrorAfterN),
    ("testRefCount_DeadlockErrorImmediatelly", ObservableMulticastTest.testRefCount_DeadlockErrorImmediatelly),
    ("testRefCount_DeadlockEmpty", ObservableMulticastTest.testRefCount_DeadlockEmpty),
    ("testRefCount_ConnectsOnFirst", ObservableMulticastTest.testRefCount_ConnectsOnFirst),
    ("testRefCount_DoesntConnectsOnFirstInCaseSynchronousCompleted", ObservableMulticastTest.testRefCount_DoesntConnectsOnFirstInCaseSynchronousCompleted),
    ("testRefCount_DoesntConnectsOnFirstInCaseSynchronousError", ObservableMulticastTest.testRefCount_DoesntConnectsOnFirstInCaseSynchronousError),
    ("testRefCount_NotConnected", ObservableMulticastTest.testRefCount_NotConnected),
    ("testRefCount_Error", ObservableMulticastTest.testRefCount_Error),
    ("testRefCount_Publish", ObservableMulticastTest.testRefCount_Publish),
    ("testRefCount_synchronousResubscribingOnErrorWorks", ObservableMulticastTest.testRefCount_synchronousResubscribingOnErrorWorks),
    ("testRefCount_synchronousResubscribingOnCompletedWorks", ObservableMulticastTest.testRefCount_synchronousResubscribingOnCompletedWorks),
    ("testReplayCount_Basic", ObservableMulticastTest.testReplayCount_Basic),
    ("testReplayCount_Error", ObservableMulticastTest.testReplayCount_Error),
    ("testReplayCount_Complete", ObservableMulticastTest.testReplayCount_Complete),
    ("testReplayCount_Dispose", ObservableMulticastTest.testReplayCount_Dispose),
    ("testReplayOneCount_Basic", ObservableMulticastTest.testReplayOneCount_Basic),
    ("testReplayOneCount_Error", ObservableMulticastTest.testReplayOneCount_Error),
    ("testReplayOneCount_Complete", ObservableMulticastTest.testReplayOneCount_Complete),
    ("testReplayOneCount_Dispose", ObservableMulticastTest.testReplayOneCount_Dispose),
    ("testReplayAll_Basic", ObservableMulticastTest.testReplayAll_Basic),
    ("testReplayAll_Error", ObservableMulticastTest.testReplayAll_Error),
    ("testReplayAll_Complete", ObservableMulticastTest.testReplayAll_Complete),
    ("testReplayAll_Dispose", ObservableMulticastTest.testReplayAll_Dispose),
    ] }
}

final class ObservableSampleTest_ : ObservableSampleTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSampleTest_) -> () -> ())] { return [
    ("testSample_Sampler_SamplerThrows", ObservableSampleTest.testSample_Sampler_SamplerThrows),
    ("testSample_Sampler_Simple1", ObservableSampleTest.testSample_Sampler_Simple1),
    ("testSample_Sampler_Simple2", ObservableSampleTest.testSample_Sampler_Simple2),
    ("testSample_Sampler_Simple3", ObservableSampleTest.testSample_Sampler_Simple3),
    ("testSample_Sampler_SourceThrows", ObservableSampleTest.testSample_Sampler_SourceThrows),
    ] }
}

final class PublishSubjectTest_ : PublishSubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (PublishSubjectTest_) -> () -> ())] { return [
    ("test_hasObserversNoObservers", PublishSubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", PublishSubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", PublishSubjectTest.test_hasObserversManyObserver),
    ] }
}

final class ObservableJustTest_ : ObservableJustTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableJustTest_) -> () -> ())] { return [
    ("testJust_Immediate", ObservableJustTest.testJust_Immediate),
    ("testJust_Basic", ObservableJustTest.testJust_Basic),
    ("testJust_Disposed", ObservableJustTest.testJust_Disposed),
    ("testJust_DisposeAfterNext", ObservableJustTest.testJust_DisposeAfterNext),
    ("testJust_DefaultScheduler", ObservableJustTest.testJust_DefaultScheduler),
    ("testJust_CompilesInMap", ObservableJustTest.testJust_CompilesInMap),
    ] }
}

final class ObservableUsingTest_ : ObservableUsingTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableUsingTest_) -> () -> ())] { return [
    ("testUsing_Complete", ObservableUsingTest.testUsing_Complete),
    ("testUsing_Error", ObservableUsingTest.testUsing_Error),
    ("testUsing_Dispose", ObservableUsingTest.testUsing_Dispose),
    ("testUsing_ThrowResourceSelector", ObservableUsingTest.testUsing_ThrowResourceSelector),
    ("testUsing_ThrowResourceUsage", ObservableUsingTest.testUsing_ThrowResourceUsage),
    ] }
}

final class ObservableTakeWhileTest_ : ObservableTakeWhileTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTakeWhileTest_) -> () -> ())] { return [
    ("testTakeWhile_Complete_Before", ObservableTakeWhileTest.testTakeWhile_Complete_Before),
    ("testTakeWhile_Complete_After", ObservableTakeWhileTest.testTakeWhile_Complete_After),
    ("testTakeWhile_Error_Before", ObservableTakeWhileTest.testTakeWhile_Error_Before),
    ("testTakeWhile_Error_After", ObservableTakeWhileTest.testTakeWhile_Error_After),
    ("testTakeWhile_Dispose_Before", ObservableTakeWhileTest.testTakeWhile_Dispose_Before),
    ("testTakeWhile_Dispose_After", ObservableTakeWhileTest.testTakeWhile_Dispose_After),
    ("testTakeWhile_Zero", ObservableTakeWhileTest.testTakeWhile_Zero),
    ("testTakeWhile_Throw", ObservableTakeWhileTest.testTakeWhile_Throw),
    ("testTakeWhile_Index1", ObservableTakeWhileTest.testTakeWhile_Index1),
    ("testTakeWhile_Index2", ObservableTakeWhileTest.testTakeWhile_Index2),
    ("testTakeWhile_Index_Error", ObservableTakeWhileTest.testTakeWhile_Index_Error),
    ("testTakeWhile_Index_SelectorThrows", ObservableTakeWhileTest.testTakeWhile_Index_SelectorThrows),
    ] }
}

final class AsyncSubjectTests_ : AsyncSubjectTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (AsyncSubjectTests_) -> () -> ())] { return [
    ("test_hasObserversManyObserver", AsyncSubjectTests.test_hasObserversManyObserver),
    ("test_infinite", AsyncSubjectTests.test_infinite),
    ("test_finite", AsyncSubjectTests.test_finite),
    ("test_error", AsyncSubjectTests.test_error),
    ("test_empty", AsyncSubjectTests.test_empty),
    ] }
}

final class ObservableDelayTest_ : ObservableDelayTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDelayTest_) -> () -> ())] { return [
    ("testDelay_TimeSpan_Simple1", ObservableDelayTest.testDelay_TimeSpan_Simple1),
    ("testDelay_TimeSpan_Simple2", ObservableDelayTest.testDelay_TimeSpan_Simple2),
    ("testDelay_TimeSpan_Simple3", ObservableDelayTest.testDelay_TimeSpan_Simple3),
    ("testDelay_TimeSpan_Error", ObservableDelayTest.testDelay_TimeSpan_Error),
    ("testDelay_TimeSpan_Completed", ObservableDelayTest.testDelay_TimeSpan_Completed),
    ("testDelay_TimeSpan_Error1", ObservableDelayTest.testDelay_TimeSpan_Error1),
    ("testDelay_TimeSpan_Error2", ObservableDelayTest.testDelay_TimeSpan_Error2),
    ("testDelay_TimeSpan_Real_Simple", ObservableDelayTest.testDelay_TimeSpan_Real_Simple),
    ("testDelay_TimeSpan_Real_Error1", ObservableDelayTest.testDelay_TimeSpan_Real_Error1),
    ("testDelay_TimeSpan_Real_Error2", ObservableDelayTest.testDelay_TimeSpan_Real_Error2),
    ("testDelay_TimeSpan_Real_Error3", ObservableDelayTest.testDelay_TimeSpan_Real_Error3),
    ("testDelay_TimeSpan_Positive", ObservableDelayTest.testDelay_TimeSpan_Positive),
    ("testDelay_TimeSpan_DefaultScheduler", ObservableDelayTest.testDelay_TimeSpan_DefaultScheduler),
    ] }
}

final class ObservableRepeatTest_ : ObservableRepeatTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableRepeatTest_) -> () -> ())] { return [
    ("testRepeat_Element", ObservableRepeatTest.testRepeat_Element),
    ] }
}

final class ObservableSingleTest_ : ObservableSingleTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSingleTest_) -> () -> ())] { return [
    ("testSingle_Empty", ObservableSingleTest.testSingle_Empty),
    ("testSingle_One", ObservableSingleTest.testSingle_One),
    ("testSingle_Many", ObservableSingleTest.testSingle_Many),
    ("testSingle_Error", ObservableSingleTest.testSingle_Error),
    ("testSinglePredicate_Empty", ObservableSingleTest.testSinglePredicate_Empty),
    ("testSinglePredicate_One", ObservableSingleTest.testSinglePredicate_One),
    ("testSinglePredicate_Many", ObservableSingleTest.testSinglePredicate_Many),
    ("testSinglePredicate_Error", ObservableSingleTest.testSinglePredicate_Error),
    ("testSinglePredicate_Throws", ObservableSingleTest.testSinglePredicate_Throws),
    ] }
}

final class ObservableTakeTest_ : ObservableTakeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTakeTest_) -> () -> ())] { return [
    ("testTake_Complete_After", ObservableTakeTest.testTake_Complete_After),
    ("testTake_Complete_Same", ObservableTakeTest.testTake_Complete_Same),
    ("testTake_Complete_Before", ObservableTakeTest.testTake_Complete_Before),
    ("testTake_Error_After", ObservableTakeTest.testTake_Error_After),
    ("testTake_Error_Same", ObservableTakeTest.testTake_Error_Same),
    ("testTake_Error_Before", ObservableTakeTest.testTake_Error_Before),
    ("testTake_Dispose_Before", ObservableTakeTest.testTake_Dispose_Before),
    ("testTake_Dispose_After", ObservableTakeTest.testTake_Dispose_After),
    ("testTake_0_DefaultScheduler", ObservableTakeTest.testTake_0_DefaultScheduler),
    ("testTake_Take1", ObservableTakeTest.testTake_Take1),
    ("testTake_DecrementCountsFirst", ObservableTakeTest.testTake_DecrementCountsFirst),
    ("testTake_TakeZero", ObservableTakeTest.testTake_TakeZero),
    ("testTake_Some", ObservableTakeTest.testTake_Some),
    ("testTake_TakeLate", ObservableTakeTest.testTake_TakeLate),
    ("testTake_TakeError", ObservableTakeTest.testTake_TakeError),
    ("testTake_TakeNever", ObservableTakeTest.testTake_TakeNever),
    ("testTake_TakeTwice1", ObservableTakeTest.testTake_TakeTwice1),
    ("testTake_TakeDefault", ObservableTakeTest.testTake_TakeDefault),
    ] }
}

final class ObservableGenerateTest_ : ObservableGenerateTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableGenerateTest_) -> () -> ())] { return [
    ("testGenerate_Finite", ObservableGenerateTest.testGenerate_Finite),
    ("testGenerate_ThrowCondition", ObservableGenerateTest.testGenerate_ThrowCondition),
    ("testGenerate_ThrowIterate", ObservableGenerateTest.testGenerate_ThrowIterate),
    ("testGenerate_Dispose", ObservableGenerateTest.testGenerate_Dispose),
    ("testGenerate_take", ObservableGenerateTest.testGenerate_take),
    ] }
}

final class SubjectConcurrencyTest_ : SubjectConcurrencyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (SubjectConcurrencyTest_) -> () -> ())] { return [
    ("testSubjectIsReentrantForNextAndComplete", SubjectConcurrencyTest.testSubjectIsReentrantForNextAndComplete),
    ("testSubjectIsReentrantForNextAndError", SubjectConcurrencyTest.testSubjectIsReentrantForNextAndError),
    ] }
}

final class ObservableDematerializeTest_ : ObservableDematerializeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDematerializeTest_) -> () -> ())] { return [
    ("testDematerialize_Range1", ObservableDematerializeTest.testDematerialize_Range1),
    ("testDematerialize_Range2", ObservableDematerializeTest.testDematerialize_Range2),
    ("testDematerialize_Error", ObservableDematerializeTest.testDematerialize_Error),
    ("testDematerialize_Error2", ObservableDematerializeTest.testDematerialize_Error2),
    ("testMaterialize_Dematerialize_Never", ObservableDematerializeTest.testMaterialize_Dematerialize_Never),
    ("testMaterialize_Dematerialize_Empty", ObservableDematerializeTest.testMaterialize_Dematerialize_Empty),
    ("testMaterialize_Dematerialize_Return", ObservableDematerializeTest.testMaterialize_Dematerialize_Return),
    ("testMaterialize_Dematerialize_Throw", ObservableDematerializeTest.testMaterialize_Dematerialize_Throw),
    ] }
}

final class VariableTest_ : VariableTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (VariableTest_) -> () -> ())] { return [
    ("testVariable_initialValues", VariableTest.testVariable_initialValues),
    ("testVariable_sendsCompletedOnDealloc", VariableTest.testVariable_sendsCompletedOnDealloc),
    ("testVariable_READMEExample", VariableTest.testVariable_READMEExample),
    ] }
}

final class ObservableTimerTest_ : ObservableTimerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTimerTest_) -> () -> ())] { return [
    ("testTimer_Basic", ObservableTimerTest.testTimer_Basic),
    ("testInterval_TimeSpan_Basic", ObservableTimerTest.testInterval_TimeSpan_Basic),
    ("testInterval_TimeSpan_Zero", ObservableTimerTest.testInterval_TimeSpan_Zero),
    ("testInterval_TimeSpan_Zero_DefaultScheduler", ObservableTimerTest.testInterval_TimeSpan_Zero_DefaultScheduler),
    ("testInterval_TimeSpan_Disposed", ObservableTimerTest.testInterval_TimeSpan_Disposed),
    ("test_IntervalWithRealScheduler", ObservableTimerTest.test_IntervalWithRealScheduler),
    ] }
}

final class ObservableShareReplayScopeTests_ : ObservableShareReplayScopeTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableShareReplayScopeTests_) -> () -> ())] { return [
    ("testReplay_forever_receivesCorrectElements", ObservableShareReplayScopeTests.testReplay_forever_receivesCorrectElements),
    ("testReplay_whileConnected_receivesCorrectElements", ObservableShareReplayScopeTests.testReplay_whileConnected_receivesCorrectElements),
    ("testReplay_forever_error", ObservableShareReplayScopeTests.testReplay_forever_error),
    ("testReplay_whileConnected_error", ObservableShareReplayScopeTests.testReplay_whileConnected_error),
    ("testReplay_forever_completed", ObservableShareReplayScopeTests.testReplay_forever_completed),
    ("testReplay_whileConnected_completed", ObservableShareReplayScopeTests.testReplay_whileConnected_completed),
    ] }
}

final class ReactiveTests_ : ReactiveTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ReactiveTests_) -> () -> ())] { return [
    ("testEnablesMutations", ReactiveTests.testEnablesMutations),
    ] }
}

final class ObservableMaterializeTest_ : ObservableMaterializeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableMaterializeTest_) -> () -> ())] { return [
    ("testMaterializeNever", ObservableMaterializeTest.testMaterializeNever),
    ("testMaterializeEmpty", ObservableMaterializeTest.testMaterializeEmpty),
    ("testMaterializeEmits", ObservableMaterializeTest.testMaterializeEmits),
    ("testMaterializeThrow", ObservableMaterializeTest.testMaterializeThrow),
    ] }
}

final class NSNotificationCenterTests_ : NSNotificationCenterTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (NSNotificationCenterTests_) -> () -> ())] { return [
    ("testNotificationCenterWithoutObject", NSNotificationCenterTests.testNotificationCenterWithoutObject),
    ("testNotificationCenterWithObject", NSNotificationCenterTests.testNotificationCenterWithObject),
    ] }
}

final class HistoricalSchedulerTest_ : HistoricalSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (HistoricalSchedulerTest_) -> () -> ())] { return [
    ("testHistoricalScheduler_initialClock", HistoricalSchedulerTest.testHistoricalScheduler_initialClock),
    ("testHistoricalScheduler_start", HistoricalSchedulerTest.testHistoricalScheduler_start),
    ("testHistoricalScheduler_disposeStart", HistoricalSchedulerTest.testHistoricalScheduler_disposeStart),
    ("testHistoricalScheduler_advanceToAfter", HistoricalSchedulerTest.testHistoricalScheduler_advanceToAfter),
    ("testHistoricalScheduler_advanceToBefore", HistoricalSchedulerTest.testHistoricalScheduler_advanceToBefore),
    ("testHistoricalScheduler_disposeAdvanceTo", HistoricalSchedulerTest.testHistoricalScheduler_disposeAdvanceTo),
    ("testHistoricalScheduler_stop", HistoricalSchedulerTest.testHistoricalScheduler_stop),
    ("testHistoricalScheduler_sleep", HistoricalSchedulerTest.testHistoricalScheduler_sleep),
    ] }
}

final class MainSchedulerTest_ : MainSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (MainSchedulerTest_) -> () -> ())] { return [
    ("testMainScheduler_basicScenario", MainSchedulerTest.testMainScheduler_basicScenario),
    ("testMainScheduler_disposing1", MainSchedulerTest.testMainScheduler_disposing1),
    ("testMainScheduler_disposing2", MainSchedulerTest.testMainScheduler_disposing2),
    ] }
}

final class ObservableCombineLatestTest_ : ObservableCombineLatestTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableCombineLatestTest_) -> () -> ())] { return [
    ("testCombineLatest_Never2", ObservableCombineLatestTest.testCombineLatest_Never2),
    ("testCombineLatest_Empty2", ObservableCombineLatestTest.testCombineLatest_Empty2),
    ("testCombineLatest_SelectorThrows2", ObservableCombineLatestTest.testCombineLatest_SelectorThrows2),
    ("testCombineLatest_WillNeverBeAbleToCombine2", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine2),
    ("testCombineLatest_Typical2", ObservableCombineLatestTest.testCombineLatest_Typical2),
    ("testCombineLatest_Never3", ObservableCombineLatestTest.testCombineLatest_Never3),
    ("testCombineLatest_Empty3", ObservableCombineLatestTest.testCombineLatest_Empty3),
    ("testCombineLatest_SelectorThrows3", ObservableCombineLatestTest.testCombineLatest_SelectorThrows3),
    ("testCombineLatest_WillNeverBeAbleToCombine3", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine3),
    ("testCombineLatest_Typical3", ObservableCombineLatestTest.testCombineLatest_Typical3),
    ("testCombineLatest_Never4", ObservableCombineLatestTest.testCombineLatest_Never4),
    ("testCombineLatest_Empty4", ObservableCombineLatestTest.testCombineLatest_Empty4),
    ("testCombineLatest_SelectorThrows4", ObservableCombineLatestTest.testCombineLatest_SelectorThrows4),
    ("testCombineLatest_WillNeverBeAbleToCombine4", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine4),
    ("testCombineLatest_Typical4", ObservableCombineLatestTest.testCombineLatest_Typical4),
    ("testCombineLatest_Never5", ObservableCombineLatestTest.testCombineLatest_Never5),
    ("testCombineLatest_Empty5", ObservableCombineLatestTest.testCombineLatest_Empty5),
    ("testCombineLatest_SelectorThrows5", ObservableCombineLatestTest.testCombineLatest_SelectorThrows5),
    ("testCombineLatest_WillNeverBeAbleToCombine5", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine5),
    ("testCombineLatest_Typical5", ObservableCombineLatestTest.testCombineLatest_Typical5),
    ("testCombineLatest_Never6", ObservableCombineLatestTest.testCombineLatest_Never6),
    ("testCombineLatest_Empty6", ObservableCombineLatestTest.testCombineLatest_Empty6),
    ("testCombineLatest_SelectorThrows6", ObservableCombineLatestTest.testCombineLatest_SelectorThrows6),
    ("testCombineLatest_WillNeverBeAbleToCombine6", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine6),
    ("testCombineLatest_Typical6", ObservableCombineLatestTest.testCombineLatest_Typical6),
    ("testCombineLatest_Never7", ObservableCombineLatestTest.testCombineLatest_Never7),
    ("testCombineLatest_Empty7", ObservableCombineLatestTest.testCombineLatest_Empty7),
    ("testCombineLatest_SelectorThrows7", ObservableCombineLatestTest.testCombineLatest_SelectorThrows7),
    ("testCombineLatest_WillNeverBeAbleToCombine7", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine7),
    ("testCombineLatest_Typical7", ObservableCombineLatestTest.testCombineLatest_Typical7),
    ("testCombineLatest_Never8", ObservableCombineLatestTest.testCombineLatest_Never8),
    ("testCombineLatest_Empty8", ObservableCombineLatestTest.testCombineLatest_Empty8),
    ("testCombineLatest_SelectorThrows8", ObservableCombineLatestTest.testCombineLatest_SelectorThrows8),
    ("testCombineLatest_WillNeverBeAbleToCombine8", ObservableCombineLatestTest.testCombineLatest_WillNeverBeAbleToCombine8),
    ("testCombineLatest_Typical8", ObservableCombineLatestTest.testCombineLatest_Typical8),
    ("testCombineLatest_NeverEmpty", ObservableCombineLatestTest.testCombineLatest_NeverEmpty),
    ("testCombineLatest_EmptyNever", ObservableCombineLatestTest.testCombineLatest_EmptyNever),
    ("testCombineLatest_EmptyReturn", ObservableCombineLatestTest.testCombineLatest_EmptyReturn),
    ("testCombineLatest_ReturnEmpty", ObservableCombineLatestTest.testCombineLatest_ReturnEmpty),
    ("testCombineLatest_NeverReturn", ObservableCombineLatestTest.testCombineLatest_NeverReturn),
    ("testCombineLatest_ReturnNever", ObservableCombineLatestTest.testCombineLatest_ReturnNever),
    ("testCombineLatest_ReturnReturn1", ObservableCombineLatestTest.testCombineLatest_ReturnReturn1),
    ("testCombineLatest_ReturnReturn2", ObservableCombineLatestTest.testCombineLatest_ReturnReturn2),
    ("testCombineLatest_EmptyError", ObservableCombineLatestTest.testCombineLatest_EmptyError),
    ("testCombineLatest_ErrorEmpty", ObservableCombineLatestTest.testCombineLatest_ErrorEmpty),
    ("testCombineLatest_ReturnThrow", ObservableCombineLatestTest.testCombineLatest_ReturnThrow),
    ("testCombineLatest_ThrowReturn", ObservableCombineLatestTest.testCombineLatest_ThrowReturn),
    ("testCombineLatest_ThrowThrow1", ObservableCombineLatestTest.testCombineLatest_ThrowThrow1),
    ("testCombineLatest_ThrowThrow2", ObservableCombineLatestTest.testCombineLatest_ThrowThrow2),
    ("testCombineLatest_ErrorThrow", ObservableCombineLatestTest.testCombineLatest_ErrorThrow),
    ("testCombineLatest_ThrowError", ObservableCombineLatestTest.testCombineLatest_ThrowError),
    ("testCombineLatest_SomeThrow", ObservableCombineLatestTest.testCombineLatest_SomeThrow),
    ("testCombineLatest_ThrowSome", ObservableCombineLatestTest.testCombineLatest_ThrowSome),
    ("testCombineLatest_ThrowAfterCompleteLeft", ObservableCombineLatestTest.testCombineLatest_ThrowAfterCompleteLeft),
    ("testCombineLatest_ThrowAfterCompleteRight", ObservableCombineLatestTest.testCombineLatest_ThrowAfterCompleteRight),
    ("testCombineLatest_TestInterleavedWithTail", ObservableCombineLatestTest.testCombineLatest_TestInterleavedWithTail),
    ("testCombineLatest_Consecutive", ObservableCombineLatestTest.testCombineLatest_Consecutive),
    ("testCombineLatest_ConsecutiveEndWithErrorLeft", ObservableCombineLatestTest.testCombineLatest_ConsecutiveEndWithErrorLeft),
    ("testCombineLatest_ConsecutiveEndWithErrorRight", ObservableCombineLatestTest.testCombineLatest_ConsecutiveEndWithErrorRight),
    ("testCombineLatest_DeadlockErrorAfterN", ObservableCombineLatestTest.testCombineLatest_DeadlockErrorAfterN),
    ("testCombineLatest_DeadlockErrorImmediatelly", ObservableCombineLatestTest.testCombineLatest_DeadlockErrorImmediatelly),
    ("testReplay_DeadlockEmpty", ObservableCombineLatestTest.testReplay_DeadlockEmpty),
    ("testCombineLatest_emptyArrayN", ObservableCombineLatestTest.testCombineLatest_emptyArrayN),
    ("testCombineLatest_NeverN", ObservableCombineLatestTest.testCombineLatest_NeverN),
    ("testCombineLatest_NeverEmptyN", ObservableCombineLatestTest.testCombineLatest_NeverEmptyN),
    ("testCombineLatest_EmptyNeverN", ObservableCombineLatestTest.testCombineLatest_EmptyNeverN),
    ("testCombineLatest_EmptyReturnN", ObservableCombineLatestTest.testCombineLatest_EmptyReturnN),
    ("testCombineLatest_ReturnReturnN", ObservableCombineLatestTest.testCombineLatest_ReturnReturnN),
    ("testCombineLatest_EmptyErrorN", ObservableCombineLatestTest.testCombineLatest_EmptyErrorN),
    ("testCombineLatest_ReturnErrorN", ObservableCombineLatestTest.testCombineLatest_ReturnErrorN),
    ("testCombineLatest_ErrorErrorN", ObservableCombineLatestTest.testCombineLatest_ErrorErrorN),
    ("testCombineLatest_NeverErrorN", ObservableCombineLatestTest.testCombineLatest_NeverErrorN),
    ("testCombineLatest_SomeErrorN", ObservableCombineLatestTest.testCombineLatest_SomeErrorN),
    ("testCombineLatest_ErrorAfterCompletedN", ObservableCombineLatestTest.testCombineLatest_ErrorAfterCompletedN),
    ("testCombineLatest_InterleavedWithTailN", ObservableCombineLatestTest.testCombineLatest_InterleavedWithTailN),
    ("testCombineLatest_ConsecutiveN", ObservableCombineLatestTest.testCombineLatest_ConsecutiveN),
    ("testCombineLatest_ConsecutiveNWithErrorLeft", ObservableCombineLatestTest.testCombineLatest_ConsecutiveNWithErrorLeft),
    ("testCombineLatest_ConsecutiveNWithErrorRight", ObservableCombineLatestTest.testCombineLatest_ConsecutiveNWithErrorRight),
    ("testCombineLatest_SelectorThrowsN", ObservableCombineLatestTest.testCombineLatest_SelectorThrowsN),
    ("testCombineLatest_willNeverBeAbleToCombineN", ObservableCombineLatestTest.testCombineLatest_willNeverBeAbleToCombineN),
    ("testCombineLatest_typicalN", ObservableCombineLatestTest.testCombineLatest_typicalN),
    ("testCombineLatest_NAry_symmetric", ObservableCombineLatestTest.testCombineLatest_NAry_symmetric),
    ("testCombineLatest_NAry_asymmetric", ObservableCombineLatestTest.testCombineLatest_NAry_asymmetric),
    ] }
}

final class ObservableSubscriptionTests_ : ObservableSubscriptionTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSubscriptionTests_) -> () -> ())] { return [
    ("testSubscribeOnNext", ObservableSubscriptionTests.testSubscribeOnNext),
    ("testSubscribeOnError", ObservableSubscriptionTests.testSubscribeOnError),
    ("testSubscribeOnCompleted", ObservableSubscriptionTests.testSubscribeOnCompleted),
    ("testDisposed", ObservableSubscriptionTests.testDisposed),
    ] }
}

final class ObservableToArrayTest_ : ObservableToArrayTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableToArrayTest_) -> () -> ())] { return [
    ("test_ToArrayWithSingleItem_Return", ObservableToArrayTest.test_ToArrayWithSingleItem_Return),
    ("test_ToArrayWithMultipleItems_Return", ObservableToArrayTest.test_ToArrayWithMultipleItems_Return),
    ("test_ToArrayWithNoItems_Empty", ObservableToArrayTest.test_ToArrayWithNoItems_Empty),
    ("test_ToArrayWithSingleItem_Never", ObservableToArrayTest.test_ToArrayWithSingleItem_Never),
    ("test_ToArrayWithImmediateError_Throw", ObservableToArrayTest.test_ToArrayWithImmediateError_Throw),
    ("test_ToArrayWithMultipleItems_Throw", ObservableToArrayTest.test_ToArrayWithMultipleItems_Throw),
    ] }
}

final class ObservableCatchTest_ : ObservableCatchTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableCatchTest_) -> () -> ())] { return [
    ("testCatch_ErrorSpecific_Caught", ObservableCatchTest.testCatch_ErrorSpecific_Caught),
    ("testCatch_HandlerThrows", ObservableCatchTest.testCatch_HandlerThrows),
    ("testCatchSequenceOf_IEofIO", ObservableCatchTest.testCatchSequenceOf_IEofIO),
    ("testCatchAnySequence_NoErrors", ObservableCatchTest.testCatchAnySequence_NoErrors),
    ("testCatchAnySequence_Never", ObservableCatchTest.testCatchAnySequence_Never),
    ("testCatchAnySequence_Empty", ObservableCatchTest.testCatchAnySequence_Empty),
    ("testCatchSequenceOf_Error", ObservableCatchTest.testCatchSequenceOf_Error),
    ("testCatchSequenceOf_ErrorNever", ObservableCatchTest.testCatchSequenceOf_ErrorNever),
    ("testCatchSequenceOf_ErrorError", ObservableCatchTest.testCatchSequenceOf_ErrorError),
    ("testCatchSequenceOf_Multiple", ObservableCatchTest.testCatchSequenceOf_Multiple),
    ("testRetry_Basic", ObservableCatchTest.testRetry_Basic),
    ("testRetry_Infinite", ObservableCatchTest.testRetry_Infinite),
    ("testRetry_Observable_Error", ObservableCatchTest.testRetry_Observable_Error),
    ("testRetryCount_Basic", ObservableCatchTest.testRetryCount_Basic),
    ("testRetryCount_Dispose", ObservableCatchTest.testRetryCount_Dispose),
    ("testRetryCount_Infinite", ObservableCatchTest.testRetryCount_Infinite),
    ("testRetryCount_Completed", ObservableCatchTest.testRetryCount_Completed),
    ("testRetry_tailRecursiveOptimizationsTest", ObservableCatchTest.testRetry_tailRecursiveOptimizationsTest),
    ] }
}

final class ObserverTests_ : ObserverTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObserverTests_) -> () -> ())] { return [
    ("testConvenienceOn_Next", ObserverTests.testConvenienceOn_Next),
    ("testConvenienceOn_Error", ObserverTests.testConvenienceOn_Error),
    ("testConvenienceOn_Complete", ObserverTests.testConvenienceOn_Complete),
    ("testMapElement", ObserverTests.testMapElement),
    ("testMapElementCompleted", ObserverTests.testMapElementCompleted),
    ("testMapElementError", ObserverTests.testMapElementError),
    ("testMapElementThrow", ObserverTests.testMapElementThrow),
    ] }
}

final class ConcurrentDispatchQueueSchedulerTests_ : ConcurrentDispatchQueueSchedulerTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ConcurrentDispatchQueueSchedulerTests_) -> () -> ())] { return [
    ("test_scheduleRelative", ConcurrentDispatchQueueSchedulerTests.test_scheduleRelative),
    ("test_scheduleRelativeCancel", ConcurrentDispatchQueueSchedulerTests.test_scheduleRelativeCancel),
    ("test_schedulePeriodic", ConcurrentDispatchQueueSchedulerTests.test_schedulePeriodic),
    ("test_schedulePeriodicCancel", ConcurrentDispatchQueueSchedulerTests.test_schedulePeriodicCancel),
    ] }
}

final class ObservableObserveOnTestConcurrentSchedulerTest_ : ObservableObserveOnTestConcurrentSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableObserveOnTestConcurrentSchedulerTest_) -> () -> ())] { return [
    ("testObserveOn_EnsureTestsAreExecutedWithRealConcurrentScheduler", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_EnsureTestsAreExecutedWithRealConcurrentScheduler),
    ("testObserveOn_Never", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_Never),
    ("testObserveOn_Simple", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_Simple),
    ("testObserveOn_Empty", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_Empty),
    ("testObserveOn_ConcurrentSchedulerIsSerialized", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_ConcurrentSchedulerIsSerialized),
    ("testObserveOn_Error", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_Error),
    ("testObserveOn_Dispose", ObservableObserveOnTestConcurrentSchedulerTest.testObserveOn_Dispose),
    ] }
}

final class ObservableTimeoutTest_ : ObservableTimeoutTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTimeoutTest_) -> () -> ())] { return [
    ("testTimeout_Empty", ObservableTimeoutTest.testTimeout_Empty),
    ("testTimeout_Error", ObservableTimeoutTest.testTimeout_Error),
    ("testTimeout_Never", ObservableTimeoutTest.testTimeout_Never),
    ("testTimeout_Duetime_Simple", ObservableTimeoutTest.testTimeout_Duetime_Simple),
    ("testTimeout_Duetime_Timeout_Exact", ObservableTimeoutTest.testTimeout_Duetime_Timeout_Exact),
    ("testTimeout_Duetime_Timeout", ObservableTimeoutTest.testTimeout_Duetime_Timeout),
    ("testTimeout_Duetime_Disposed", ObservableTimeoutTest.testTimeout_Duetime_Disposed),
    ("testTimeout_TimeoutOccurs_1", ObservableTimeoutTest.testTimeout_TimeoutOccurs_1),
    ("testTimeout_TimeoutOccurs_2", ObservableTimeoutTest.testTimeout_TimeoutOccurs_2),
    ("testTimeout_TimeoutOccurs_Never", ObservableTimeoutTest.testTimeout_TimeoutOccurs_Never),
    ("testTimeout_TimeoutOccurs_Completed", ObservableTimeoutTest.testTimeout_TimeoutOccurs_Completed),
    ("testTimeout_TimeoutOccurs_Error", ObservableTimeoutTest.testTimeout_TimeoutOccurs_Error),
    ("testTimeout_TimeoutOccurs_NextIsError", ObservableTimeoutTest.testTimeout_TimeoutOccurs_NextIsError),
    ("testTimeout_TimeoutNotOccurs_Completed", ObservableTimeoutTest.testTimeout_TimeoutNotOccurs_Completed),
    ("testTimeout_TimeoutNotOccurs_Error", ObservableTimeoutTest.testTimeout_TimeoutNotOccurs_Error),
    ("testTimeout_TimeoutNotOccurs", ObservableTimeoutTest.testTimeout_TimeoutNotOccurs),
    ] }
}

final class ObservableBufferTest_ : ObservableBufferTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableBufferTest_) -> () -> ())] { return [
    ("testBufferWithTimeOrCount_Basic", ObservableBufferTest.testBufferWithTimeOrCount_Basic),
    ("testBufferWithTimeOrCount_Error", ObservableBufferTest.testBufferWithTimeOrCount_Error),
    ("testBufferWithTimeOrCount_Disposed", ObservableBufferTest.testBufferWithTimeOrCount_Disposed),
    ("testBufferWithTimeOrCount_Default", ObservableBufferTest.testBufferWithTimeOrCount_Default),
    ] }
}

final class BehaviorSubjectTest_ : BehaviorSubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (BehaviorSubjectTest_) -> () -> ())] { return [
    ("test_Infinite", BehaviorSubjectTest.test_Infinite),
    ("test_Finite", BehaviorSubjectTest.test_Finite),
    ("test_Error", BehaviorSubjectTest.test_Error),
    ("test_Canceled", BehaviorSubjectTest.test_Canceled),
    ("test_hasObserversNoObservers", BehaviorSubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", BehaviorSubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", BehaviorSubjectTest.test_hasObserversManyObserver),
    ] }
}

final class ObservableDebugTest_ : ObservableDebugTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDebugTest_) -> () -> ())] { return [
    ("testDebug_Completed", ObservableDebugTest.testDebug_Completed),
    ("testDebug_Error", ObservableDebugTest.testDebug_Error),
    ] }
}

final class ObservableDoOnTest_ : ObservableDoOnTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDoOnTest_) -> () -> ())] { return [
    ("testDoOn_shouldSeeAllValues", ObservableDoOnTest.testDoOn_shouldSeeAllValues),
    ("testDoOn_plainAction", ObservableDoOnTest.testDoOn_plainAction),
    ("testDoOn_nextCompleted", ObservableDoOnTest.testDoOn_nextCompleted),
    ("testDoOn_completedNever", ObservableDoOnTest.testDoOn_completedNever),
    ("testDoOn_nextError", ObservableDoOnTest.testDoOn_nextError),
    ("testDoOn_nextErrorNot", ObservableDoOnTest.testDoOn_nextErrorNot),
    ("testDoOnNext_normal", ObservableDoOnTest.testDoOnNext_normal),
    ("testDoOnNext_throws", ObservableDoOnTest.testDoOnNext_throws),
    ("testDoOnError_normal", ObservableDoOnTest.testDoOnError_normal),
    ("testDoOnError_throws", ObservableDoOnTest.testDoOnError_throws),
    ("testDoOnCompleted_normal", ObservableDoOnTest.testDoOnCompleted_normal),
    ("testDoOnCompleted_throws", ObservableDoOnTest.testDoOnCompleted_throws),
    ("testDoOnOrder_Completed_Async", ObservableDoOnTest.testDoOnOrder_Completed_Async),
    ("testDoOnOrder_Completed_Sync", ObservableDoOnTest.testDoOnOrder_Completed_Sync),
    ("testDoOnOrder_Error", ObservableDoOnTest.testDoOnOrder_Error),
    ("testDoOnOrder_Dispose", ObservableDoOnTest.testDoOnOrder_Dispose),
    ] }
}

final class ObservableElementAtTest_ : ObservableElementAtTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableElementAtTest_) -> () -> ())] { return [
    ("testElementAt_Complete_After", ObservableElementAtTest.testElementAt_Complete_After),
    ("testElementAt_Complete_Before", ObservableElementAtTest.testElementAt_Complete_Before),
    ("testElementAt_Error_After", ObservableElementAtTest.testElementAt_Error_After),
    ("testElementAt_Error_Before", ObservableElementAtTest.testElementAt_Error_Before),
    ("testElementAt_Dispose_Before", ObservableElementAtTest.testElementAt_Dispose_Before),
    ("testElementAt_Dispose_After", ObservableElementAtTest.testElementAt_Dispose_After),
    ("testElementAt_First", ObservableElementAtTest.testElementAt_First),
    ] }
}

final class ObservableGroupByTest_ : ObservableGroupByTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableGroupByTest_) -> () -> ())] { return [
    ("testGroupBy_TwoGroup", ObservableGroupByTest.testGroupBy_TwoGroup),
    ("testGroupBy_OuterComplete", ObservableGroupByTest.testGroupBy_OuterComplete),
    ("testGroupBy_OuterError", ObservableGroupByTest.testGroupBy_OuterError),
    ("testGroupBy_OuterDispose", ObservableGroupByTest.testGroupBy_OuterDispose),
    ("testGroupBy_OuterKeySelectorThrows", ObservableGroupByTest.testGroupBy_OuterKeySelectorThrows),
    ("testGroupBy_InnerComplete", ObservableGroupByTest.testGroupBy_InnerComplete),
    ("testGroupBy_InnerCompleteAll", ObservableGroupByTest.testGroupBy_InnerCompleteAll),
    ("testGroupBy_InnerError", ObservableGroupByTest.testGroupBy_InnerError),
    ("testGroupBy_InnerDispose", ObservableGroupByTest.testGroupBy_InnerDispose),
    ("testGroupBy_InnerKeyThrow", ObservableGroupByTest.testGroupBy_InnerKeyThrow),
    ("testGroupBy_OuterIndependence", ObservableGroupByTest.testGroupBy_OuterIndependence),
    ("testGroupBy_InnerIndependence", ObservableGroupByTest.testGroupBy_InnerIndependence),
    ("testGroupBy_InnerMultipleIndependence", ObservableGroupByTest.testGroupBy_InnerMultipleIndependence),
    ("testGroupBy_InnerEscapeComplete", ObservableGroupByTest.testGroupBy_InnerEscapeComplete),
    ("testGroupBy_InnerEscapeError", ObservableGroupByTest.testGroupBy_InnerEscapeError),
    ("testGroupBy_InnerEscapeDispose", ObservableGroupByTest.testGroupBy_InnerEscapeDispose),
    ] }
}

final class ObservableSwitchIfEmptyTest_ : ObservableSwitchIfEmptyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSwitchIfEmptyTest_) -> () -> ())] { return [
    ("testSwitchIfEmpty_SourceNotEmpty_SwitchCompletes", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_SourceNotEmpty_SwitchCompletes),
    ("testSwitchIfEmpty_SourceNotEmptyError_SwitchCompletes", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_SourceNotEmptyError_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmptyError_SwitchCompletes", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_SourceEmptyError_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmpty_SwitchCompletes", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_SourceEmpty_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmpty_SwitchError", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_SourceEmpty_SwitchError),
    ("testSwitchIfEmpty_Never", ObservableSwitchIfEmptyTest.testSwitchIfEmpty_Never),
    ] }
}

final class ObservableThrottleTest_ : ObservableThrottleTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableThrottleTest_) -> () -> ())] { return [
    ("test_ThrottleTimeSpan_NotLatest_Completed", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_Completed),
    ("test_ThrottleTimeSpan_NotLatest_Never", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_Never),
    ("test_ThrottleTimeSpan_NotLatest_Empty", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_Empty),
    ("test_ThrottleTimeSpan_NotLatest_Error", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_Error),
    ("test_ThrottleTimeSpan_NotLatest_NoEnd", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_NoEnd),
    ("test_ThrottleTimeSpan_NotLatest_WithRealScheduler", ObservableThrottleTest.test_ThrottleTimeSpan_NotLatest_WithRealScheduler),
    ("test_ThrottleTimeSpan_Completed", ObservableThrottleTest.test_ThrottleTimeSpan_Completed),
    ("test_ThrottleTimeSpan_CompletedAfterDueTime", ObservableThrottleTest.test_ThrottleTimeSpan_CompletedAfterDueTime),
    ("test_ThrottleTimeSpan_Never", ObservableThrottleTest.test_ThrottleTimeSpan_Never),
    ("test_ThrottleTimeSpan_Empty", ObservableThrottleTest.test_ThrottleTimeSpan_Empty),
    ("test_ThrottleTimeSpan_Error", ObservableThrottleTest.test_ThrottleTimeSpan_Error),
    ("test_ThrottleTimeSpan_NoEnd", ObservableThrottleTest.test_ThrottleTimeSpan_NoEnd),
    ("test_ThrottleTimeSpan_WithRealScheduler", ObservableThrottleTest.test_ThrottleTimeSpan_WithRealScheduler),
    ] }
}

final class ObservableTakeUntilTest_ : ObservableTakeUntilTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTakeUntilTest_) -> () -> ())] { return [
    ("testTakeUntil_Preempt_SomeData_Next", ObservableTakeUntilTest.testTakeUntil_Preempt_SomeData_Next),
    ("testTakeUntil_Preempt_SomeData_Error", ObservableTakeUntilTest.testTakeUntil_Preempt_SomeData_Error),
    ("testTakeUntil_NoPreempt_SomeData_Empty", ObservableTakeUntilTest.testTakeUntil_NoPreempt_SomeData_Empty),
    ("testTakeUntil_NoPreempt_SomeData_Never", ObservableTakeUntilTest.testTakeUntil_NoPreempt_SomeData_Never),
    ("testTakeUntil_Preempt_Never_Next", ObservableTakeUntilTest.testTakeUntil_Preempt_Never_Next),
    ("testTakeUntil_Preempt_Never_Error", ObservableTakeUntilTest.testTakeUntil_Preempt_Never_Error),
    ("testTakeUntil_NoPreempt_Never_Empty", ObservableTakeUntilTest.testTakeUntil_NoPreempt_Never_Empty),
    ("testTakeUntil_NoPreempt_Never_Never", ObservableTakeUntilTest.testTakeUntil_NoPreempt_Never_Never),
    ("testTakeUntil_Preempt_BeforeFirstProduced", ObservableTakeUntilTest.testTakeUntil_Preempt_BeforeFirstProduced),
    ("testTakeUntil_Preempt_BeforeFirstProduced_RemainSilentAndProperDisposed", ObservableTakeUntilTest.testTakeUntil_Preempt_BeforeFirstProduced_RemainSilentAndProperDisposed),
    ("testTakeUntil_NoPreempt_AfterLastProduced_ProperDisposedSigna", ObservableTakeUntilTest.testTakeUntil_NoPreempt_AfterLastProduced_ProperDisposedSigna),
    ("testTakeUntil_Error_Some", ObservableTakeUntilTest.testTakeUntil_Error_Some),
    ] }
}

final class ObservableMergeTest_ : ObservableMergeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableMergeTest_) -> () -> ())] { return [
    ("testMerge_DeadlockSimple", ObservableMergeTest.testMerge_DeadlockSimple),
    ("testMerge_DeadlockErrorAfterN", ObservableMergeTest.testMerge_DeadlockErrorAfterN),
    ("testMerge_DeadlockErrorImmediatelly", ObservableMergeTest.testMerge_DeadlockErrorImmediatelly),
    ("testMerge_DeadlockEmpty", ObservableMergeTest.testMerge_DeadlockEmpty),
    ("testMerge_DeadlockFirstEmpty", ObservableMergeTest.testMerge_DeadlockFirstEmpty),
    ("testMergeConcurrent_DeadlockSimple", ObservableMergeTest.testMergeConcurrent_DeadlockSimple),
    ("testMergeConcurrent_DeadlockErrorAfterN", ObservableMergeTest.testMergeConcurrent_DeadlockErrorAfterN),
    ("testMergeConcurrent_DeadlockErrorImmediatelly", ObservableMergeTest.testMergeConcurrent_DeadlockErrorImmediatelly),
    ("testMergeConcurrent_DeadlockEmpty", ObservableMergeTest.testMergeConcurrent_DeadlockEmpty),
    ("testMergeConcurrent_DeadlockFirstEmpty", ObservableMergeTest.testMergeConcurrent_DeadlockFirstEmpty),
    ("testMerge_ObservableOfObservable_Data", ObservableMergeTest.testMerge_ObservableOfObservable_Data),
    ("testMerge_ObservableOfObservable_Data_NotOverlapped", ObservableMergeTest.testMerge_ObservableOfObservable_Data_NotOverlapped),
    ("testMerge_ObservableOfObservable_InnerThrows", ObservableMergeTest.testMerge_ObservableOfObservable_InnerThrows),
    ("testMerge_ObservableOfObservable_OuterThrows", ObservableMergeTest.testMerge_ObservableOfObservable_OuterThrows),
    ("testMerge_MergeConcat_Basic", ObservableMergeTest.testMerge_MergeConcat_Basic),
    ("testMerge_MergeConcat_BasicLong", ObservableMergeTest.testMerge_MergeConcat_BasicLong),
    ("testMerge_MergeConcat_BasicWide", ObservableMergeTest.testMerge_MergeConcat_BasicWide),
    ("testMerge_MergeConcat_BasicLate", ObservableMergeTest.testMerge_MergeConcat_BasicLate),
    ("testMerge_MergeConcat_Disposed", ObservableMergeTest.testMerge_MergeConcat_Disposed),
    ("testMerge_MergeConcat_OuterError", ObservableMergeTest.testMerge_MergeConcat_OuterError),
    ("testMerge_MergeConcat_InnerError", ObservableMergeTest.testMerge_MergeConcat_InnerError),
    ("testMergeSync_Empty", ObservableMergeTest.testMergeSync_Empty),
    ("testMergeSync_EmptyData_DoesntCompleteImmediatelly", ObservableMergeTest.testMergeSync_EmptyData_DoesntCompleteImmediatelly),
    ("testMergeSync_EmptyEmpty_Completes", ObservableMergeTest.testMergeSync_EmptyEmpty_Completes),
    ("testMergeSync_Data", ObservableMergeTest.testMergeSync_Data),
    ("testMergeSync_ObservableOfObservable_InnerThrows", ObservableMergeTest.testMergeSync_ObservableOfObservable_InnerThrows),
    ("testFlatMapFirst_Complete", ObservableMergeTest.testFlatMapFirst_Complete),
    ("testFlatMapFirst_Complete_InnerNotComplete", ObservableMergeTest.testFlatMapFirst_Complete_InnerNotComplete),
    ("testFlatMapFirst_Complete_OuterNotComplete", ObservableMergeTest.testFlatMapFirst_Complete_OuterNotComplete),
    ("testFlatMapFirst_Complete_ErrorOuter", ObservableMergeTest.testFlatMapFirst_Complete_ErrorOuter),
    ("testFlatMapFirst_Error_Inner", ObservableMergeTest.testFlatMapFirst_Error_Inner),
    ("testFlatMapFirst_Dispose", ObservableMergeTest.testFlatMapFirst_Dispose),
    ("testFlatMapFirst_SelectorThrows", ObservableMergeTest.testFlatMapFirst_SelectorThrows),
    ("testFlatMapFirst_UseFunction", ObservableMergeTest.testFlatMapFirst_UseFunction),
    ("testFlatMap_Complete", ObservableMergeTest.testFlatMap_Complete),
    ("testFlatMap_Complete_InnerNotComplete", ObservableMergeTest.testFlatMap_Complete_InnerNotComplete),
    ("testFlatMap_Complete_OuterNotComplete", ObservableMergeTest.testFlatMap_Complete_OuterNotComplete),
    ("testFlatMap_Complete_ErrorOuter", ObservableMergeTest.testFlatMap_Complete_ErrorOuter),
    ("testFlatMap_Error_Inner", ObservableMergeTest.testFlatMap_Error_Inner),
    ("testFlatMap_Dispose", ObservableMergeTest.testFlatMap_Dispose),
    ("testFlatMap_SelectorThrows", ObservableMergeTest.testFlatMap_SelectorThrows),
    ("testFlatMap_UseFunction", ObservableMergeTest.testFlatMap_UseFunction),
    ("testFlatMapIndex_Index", ObservableMergeTest.testFlatMapIndex_Index),
    ("testFlatMapWithIndex_Complete", ObservableMergeTest.testFlatMapWithIndex_Complete),
    ("testFlatMapWithIndex_Complete_InnerNotComplete", ObservableMergeTest.testFlatMapWithIndex_Complete_InnerNotComplete),
    ("testFlatMapWithIndex_Complete_OuterNotComplete", ObservableMergeTest.testFlatMapWithIndex_Complete_OuterNotComplete),
    ("testFlatMapWithIndex_Complete_ErrorOuter", ObservableMergeTest.testFlatMapWithIndex_Complete_ErrorOuter),
    ("testFlatMapWithIndex_Error_Inner", ObservableMergeTest.testFlatMapWithIndex_Error_Inner),
    ("testFlatMapWithIndex_Dispose", ObservableMergeTest.testFlatMapWithIndex_Dispose),
    ("testFlatMapWithIndex_SelectorThrows", ObservableMergeTest.testFlatMapWithIndex_SelectorThrows),
    ("testFlatMapWithIndex_UseFunction", ObservableMergeTest.testFlatMapWithIndex_UseFunction),
    ("testConcatMap_InnerCompleteFasterThanOuterElementsAreProduced", ObservableMergeTest.testConcatMap_InnerCompleteFasterThanOuterElementsAreProduced),
    ("testConcatMap_Disposed", ObservableMergeTest.testConcatMap_Disposed),
    ("testConcatMap_OuterComplete_InnerNotComplete", ObservableMergeTest.testConcatMap_OuterComplete_InnerNotComplete),
    ("testConcatMap_InnerComplete_OuterNotComplete", ObservableMergeTest.testConcatMap_InnerComplete_OuterNotComplete),
    ("testConcatMap_InnerComplete_OuterCompleteBeforeInner", ObservableMergeTest.testConcatMap_InnerComplete_OuterCompleteBeforeInner),
    ("testConcatMap_InnerComplete_OuterCompleteAfterInner", ObservableMergeTest.testConcatMap_InnerComplete_OuterCompleteAfterInner),
    ("testConcatMap_Error_Outer", ObservableMergeTest.testConcatMap_Error_Outer),
    ("testConcatMap_Error_Inner", ObservableMergeTest.testConcatMap_Error_Inner),
    ("testConcatMap_Throw", ObservableMergeTest.testConcatMap_Throw),
    ("testConcatMap_UseFunction", ObservableMergeTest.testConcatMap_UseFunction),
    ] }
}

final class ObservableReduceTest_ : ObservableReduceTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableReduceTest_) -> () -> ())] { return [
    ("test_ReduceWithSeed_Empty", ObservableReduceTest.test_ReduceWithSeed_Empty),
    ("test_ReduceWithSeed_Return", ObservableReduceTest.test_ReduceWithSeed_Return),
    ("test_ReduceWithSeed_Throw", ObservableReduceTest.test_ReduceWithSeed_Throw),
    ("test_ReduceWithSeed_Never", ObservableReduceTest.test_ReduceWithSeed_Never),
    ("test_ReduceWithSeed_Range", ObservableReduceTest.test_ReduceWithSeed_Range),
    ("test_ReduceWithSeed_AccumulatorThrows", ObservableReduceTest.test_ReduceWithSeed_AccumulatorThrows),
    ("test_ReduceWithSeedAndResult_Empty", ObservableReduceTest.test_ReduceWithSeedAndResult_Empty),
    ("test_ReduceWithSeedAndResult_Return", ObservableReduceTest.test_ReduceWithSeedAndResult_Return),
    ("test_ReduceWithSeedAndResult_Throw", ObservableReduceTest.test_ReduceWithSeedAndResult_Throw),
    ("test_ReduceWithSeedAndResult_Never", ObservableReduceTest.test_ReduceWithSeedAndResult_Never),
    ("test_ReduceWithSeedAndResult_Range", ObservableReduceTest.test_ReduceWithSeedAndResult_Range),
    ("test_ReduceWithSeedAndResult_AccumulatorThrows", ObservableReduceTest.test_ReduceWithSeedAndResult_AccumulatorThrows),
    ("test_ReduceWithSeedAndResult_SelectorThrows", ObservableReduceTest.test_ReduceWithSeedAndResult_SelectorThrows),
    ] }
}
#if os(macOS) || os(iOS) || os(tvOS) || os(watchOS)

func testCase<T: RxTestCase>(_ tests: [(String, (T) -> () -> ())]) -> () -> () {
    return {
        for testCase in tests {
            print("Test \(testCase)")
            for test in T.allTests {
                let testInstance = T()
                testInstance.setUp()
                print("   testing \(test.0)")
                test.1(testInstance)()
                testInstance.tearDown()
            }
        }
    }
}

func XCTMain(_ tests: [() -> ()]) {
    for testCase in tests {
        testCase()
    }
}

#endif

    XCTMain([
        testCase(ObservableWithLatestFromTest_.allTests),
        testCase(ObservableOptionalTest_.allTests),
        testCase(AnomaliesTest_.allTests),
        testCase(ObservableTakeLastTest_.allTests),
        testCase(PrimitiveSequenceTest_.allTests),
        testCase(VirtualSchedulerTest_.allTests),
        testCase(ObservableBlockingTest_.allTests),
        testCase(ObservableRetryWhenTest_.allTests),
        testCase(ObservableDelaySubscriptionTest_.allTests),
        testCase(ObservableDistinctUntilChangedTest_.allTests),
        testCase(ObservableObserveOnTest_.allTests),
        testCase(ObservableSkipWhileTest_.allTests),
        testCase(ObservableSwitchTest_.allTests),
        testCase(ObservableSkipTest_.allTests),
        testCase(ObservableTest_.allTests),
        testCase(ObservableRangeTest_.allTests),
        testCase(ObservableScanTest_.allTests),
        testCase(ReplaySubjectTest_.allTests),
        testCase(DisposableTest_.allTests),
        testCase(RecursiveLockTests_.allTests),
        testCase(QueueTest_.allTests),
        testCase(ObservableSequenceTest_.allTests),
        testCase(DriverTest_.allTests),
        testCase(ObservableMapTest_.allTests),
        testCase(CurrentThreadSchedulerTest_.allTests),
        testCase(ObservableSubscribeOnTest_.allTests),
        testCase(ObservableWindowTest_.allTests),
        testCase(ObservableZipTest_.allTests),
        testCase(ObservableSkipUntilTest_.allTests),
        testCase(ObservableDefaultIfEmptyTest_.allTests),
        testCase(ObservableFilterTest_.allTests),
        testCase(ObservableAmbTest_.allTests),
        testCase(ObservableConcatTest_.allTests),
        testCase(EventTests_.allTests),
        testCase(ObservableMulticastTest_.allTests),
        testCase(ObservableSampleTest_.allTests),
        testCase(PublishSubjectTest_.allTests),
        testCase(ObservableJustTest_.allTests),
        testCase(ObservableUsingTest_.allTests),
        testCase(ObservableTakeWhileTest_.allTests),
        testCase(AsyncSubjectTests_.allTests),
        testCase(ObservableDelayTest_.allTests),
        testCase(ObservableRepeatTest_.allTests),
        testCase(ObservableSingleTest_.allTests),
        testCase(ObservableTakeTest_.allTests),
        testCase(ObservableGenerateTest_.allTests),
        testCase(SubjectConcurrencyTest_.allTests),
        testCase(ObservableDematerializeTest_.allTests),
        testCase(VariableTest_.allTests),
        testCase(ObservableTimerTest_.allTests),
        testCase(ObservableShareReplayScopeTests_.allTests),
        testCase(ReactiveTests_.allTests),
        testCase(ObservableMaterializeTest_.allTests),
        testCase(NSNotificationCenterTests_.allTests),
        testCase(HistoricalSchedulerTest_.allTests),
        testCase(MainSchedulerTest_.allTests),
        testCase(ObservableCombineLatestTest_.allTests),
        testCase(ObservableSubscriptionTests_.allTests),
        testCase(ObservableToArrayTest_.allTests),
        testCase(ObservableCatchTest_.allTests),
        testCase(ObserverTests_.allTests),
        testCase(ConcurrentDispatchQueueSchedulerTests_.allTests),
        testCase(ObservableObserveOnTestConcurrentSchedulerTest_.allTests),
        testCase(ObservableTimeoutTest_.allTests),
        testCase(ObservableBufferTest_.allTests),
        testCase(BehaviorSubjectTest_.allTests),
        testCase(ObservableDebugTest_.allTests),
        testCase(ObservableDoOnTest_.allTests),
        testCase(ObservableElementAtTest_.allTests),
        testCase(ObservableGroupByTest_.allTests),
        testCase(ObservableSwitchIfEmptyTest_.allTests),
        testCase(ObservableThrottleTest_.allTests),
        testCase(ObservableTakeUntilTest_.allTests),
        testCase(ObservableMergeTest_.allTests),
        testCase(ObservableReduceTest_.allTests),
    ])
//}
