// this file is autogenerated using `./scripts/package-swift-manager.swift`
import XCTest
import RxSwift

protocol RxTestCase {
#if os(macOS)
    init()
    static var allTests: [(String, (Self) -> () -> ())] { get }
#endif
    func setUp()
    func tearDown()
}


final class EventTests_ : EventTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (EventTests_) -> () -> ())] { return [
    ("testMapTransformNext", EventTests.testMapTransformNext),
    ("testMapTransformNextThrow", EventTests.testMapTransformNextThrow),
    ("testMapTransformError", EventTests.testMapTransformError),
    ("testMapTransformCompleted", EventTests.testMapTransformCompleted),
    ] }
}

final class PublishSubjectTest_ : PublishSubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (PublishSubjectTest_) -> () -> ())] { return [
    ("test_hasObserversNoObservers", PublishSubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", PublishSubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", PublishSubjectTest.test_hasObserversManyObserver),
    ] }
}

final class AnomaliesTest_ : AnomaliesTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (AnomaliesTest_) -> () -> ())] { return [
    ("test936", AnomaliesTest.test936),
    ("testSeparationBetweenOnAndSubscriptionLocks", AnomaliesTest.testSeparationBetweenOnAndSubscriptionLocks),
    ] }
}

final class PrimitiveSequenceTest_ : PrimitiveSequenceTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (PrimitiveSequenceTest_) -> () -> ())] { return [
    ("testZip2_selector_producesSingleElement", PrimitiveSequenceTest.testZip2_selector_producesSingleElement),
    ("testZip2_producesSingleElement", PrimitiveSequenceTest.testZip2_producesSingleElement),
    ("testZip3_selector_producesSingleElement", PrimitiveSequenceTest.testZip3_selector_producesSingleElement),
    ("testZip3_producesSingleElement", PrimitiveSequenceTest.testZip3_producesSingleElement),
    ("testZip4_selector_producesSingleElement", PrimitiveSequenceTest.testZip4_selector_producesSingleElement),
    ("testZip4_producesSingleElement", PrimitiveSequenceTest.testZip4_producesSingleElement),
    ("testZip5_selector_producesSingleElement", PrimitiveSequenceTest.testZip5_selector_producesSingleElement),
    ("testZip5_producesSingleElement", PrimitiveSequenceTest.testZip5_producesSingleElement),
    ("testZip6_selector_producesSingleElement", PrimitiveSequenceTest.testZip6_selector_producesSingleElement),
    ("testZip6_producesSingleElement", PrimitiveSequenceTest.testZip6_producesSingleElement),
    ("testZip7_selector_producesSingleElement", PrimitiveSequenceTest.testZip7_selector_producesSingleElement),
    ("testZip7_producesSingleElement", PrimitiveSequenceTest.testZip7_producesSingleElement),
    ("testZip8_selector_producesSingleElement", PrimitiveSequenceTest.testZip8_selector_producesSingleElement),
    ("testZip8_producesSingleElement", PrimitiveSequenceTest.testZip8_producesSingleElement),
    ("testSingle_Subscription_success", PrimitiveSequenceTest.testSingle_Subscription_success),
    ("testSingle_Subscription_error", PrimitiveSequenceTest.testSingle_Subscription_error),
    ("testSingle_create_success", PrimitiveSequenceTest.testSingle_create_success),
    ("testSingle_create_error", PrimitiveSequenceTest.testSingle_create_error),
    ("testSingle_create_disposing", PrimitiveSequenceTest.testSingle_create_disposing),
    ("testMaybe_Subscription_success", PrimitiveSequenceTest.testMaybe_Subscription_success),
    ("testMaybe_Subscription_completed", PrimitiveSequenceTest.testMaybe_Subscription_completed),
    ("testMaybe_Subscription_error", PrimitiveSequenceTest.testMaybe_Subscription_error),
    ("testMaybe_create_success", PrimitiveSequenceTest.testMaybe_create_success),
    ("testMaybe_create_completed", PrimitiveSequenceTest.testMaybe_create_completed),
    ("testMaybe_create_error", PrimitiveSequenceTest.testMaybe_create_error),
    ("testMaybe_create_disposing", PrimitiveSequenceTest.testMaybe_create_disposing),
    ("testCompletable_Subscription_completed", PrimitiveSequenceTest.testCompletable_Subscription_completed),
    ("testCompletable_Subscription_error", PrimitiveSequenceTest.testCompletable_Subscription_error),
    ("testCompletable_create_completed", PrimitiveSequenceTest.testCompletable_create_completed),
    ("testCompletable_create_error", PrimitiveSequenceTest.testCompletable_create_error),
    ("testCompletable_create_disposing", PrimitiveSequenceTest.testCompletable_create_disposing),
    ("testSingle_deferred_producesSingleElement", PrimitiveSequenceTest.testSingle_deferred_producesSingleElement),
    ("testSingle_just_producesSingleElement", PrimitiveSequenceTest.testSingle_just_producesSingleElement),
    ("testSingle_just2_producesSingleElement", PrimitiveSequenceTest.testSingle_just2_producesSingleElement),
    ("testSingle_error_fails", PrimitiveSequenceTest.testSingle_error_fails),
    ("testSingle_never_producesSingleElement", PrimitiveSequenceTest.testSingle_never_producesSingleElement),
    ("testSingle_delaySubscription_producesSingleElement", PrimitiveSequenceTest.testSingle_delaySubscription_producesSingleElement),
    ("testSingle_delay_producesSingleElement", PrimitiveSequenceTest.testSingle_delay_producesSingleElement),
    ("testSingle_do_producesSingleElement", PrimitiveSequenceTest.testSingle_do_producesSingleElement),
    ("testSingle_filter_resultIsMaybe", PrimitiveSequenceTest.testSingle_filter_resultIsMaybe),
    ("testSingle_map_producesSingleElement", PrimitiveSequenceTest.testSingle_map_producesSingleElement),
    ("testSingle_flatMap_producesSingleElement", PrimitiveSequenceTest.testSingle_flatMap_producesSingleElement),
    ("testSingle_observeOn_producesSingleElement", PrimitiveSequenceTest.testSingle_observeOn_producesSingleElement),
    ("testSingle_subscribeOn_producesSingleElement", PrimitiveSequenceTest.testSingle_subscribeOn_producesSingleElement),
    ("testSingle_catchError_producesSingleElement", PrimitiveSequenceTest.testSingle_catchError_producesSingleElement),
    ("testSingle_retry_producesSingleElement", PrimitiveSequenceTest.testSingle_retry_producesSingleElement),
    ("testSingle_retryWhen1_producesSingleElement", PrimitiveSequenceTest.testSingle_retryWhen1_producesSingleElement),
    ("testSingle_retryWhen2_producesSingleElement", PrimitiveSequenceTest.testSingle_retryWhen2_producesSingleElement),
    ("testSingle_timer_producesSingleElement", PrimitiveSequenceTest.testSingle_timer_producesSingleElement),
    ("testAsSingle_Empty", PrimitiveSequenceTest.testAsSingle_Empty),
    ("testAsSingle_One", PrimitiveSequenceTest.testAsSingle_One),
    ("testAsSingle_Many", PrimitiveSequenceTest.testAsSingle_Many),
    ("testAsSingle_Error", PrimitiveSequenceTest.testAsSingle_Error),
    ("testAsSingle_Error2", PrimitiveSequenceTest.testAsSingle_Error2),
    ("testAsMaybe_Empty", PrimitiveSequenceTest.testAsMaybe_Empty),
    ("testAsMaybe_One", PrimitiveSequenceTest.testAsMaybe_One),
    ("testAsMaybe_Many", PrimitiveSequenceTest.testAsMaybe_Many),
    ("testAsMaybe_Error", PrimitiveSequenceTest.testAsMaybe_Error),
    ("testAsMaybe_Error2", PrimitiveSequenceTest.testAsMaybe_Error2),
    ("testAsCompletable_Empty", PrimitiveSequenceTest.testAsCompletable_Empty),
    ("testAsCompletable_Error", PrimitiveSequenceTest.testAsCompletable_Error),
    ] }
}

final class VirtualSchedulerTest_ : VirtualSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (VirtualSchedulerTest_) -> () -> ())] { return [
    ("testVirtualScheduler_initialClock", VirtualSchedulerTest.testVirtualScheduler_initialClock),
    ("testVirtualScheduler_start", VirtualSchedulerTest.testVirtualScheduler_start),
    ("testVirtualScheduler_disposeStart", VirtualSchedulerTest.testVirtualScheduler_disposeStart),
    ("testVirtualScheduler_advanceToAfter", VirtualSchedulerTest.testVirtualScheduler_advanceToAfter),
    ("testVirtualScheduler_advanceToBefore", VirtualSchedulerTest.testVirtualScheduler_advanceToBefore),
    ("testVirtualScheduler_disposeAdvanceTo", VirtualSchedulerTest.testVirtualScheduler_disposeAdvanceTo),
    ("testVirtualScheduler_stop", VirtualSchedulerTest.testVirtualScheduler_stop),
    ("testVirtualScheduler_sleep", VirtualSchedulerTest.testVirtualScheduler_sleep),
    ("testVirtualScheduler_stress", VirtualSchedulerTest.testVirtualScheduler_stress),
    ] }
}

final class ObservableBlockingTest_ : ObservableBlockingTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableBlockingTest_) -> () -> ())] { return [
    ("testToArray_empty", ObservableBlockingTest.testToArray_empty),
    ("testToArray_return", ObservableBlockingTest.testToArray_return),
    ("testToArray_fail", ObservableBlockingTest.testToArray_fail),
    ("testToArray_someData", ObservableBlockingTest.testToArray_someData),
    ("testToArray_withRealScheduler", ObservableBlockingTest.testToArray_withRealScheduler),
    ("testToArray_independent", ObservableBlockingTest.testToArray_independent),
    ("testToArray_timeout", ObservableBlockingTest.testToArray_timeout),
    ("testFirst_empty", ObservableBlockingTest.testFirst_empty),
    ("testFirst_return", ObservableBlockingTest.testFirst_return),
    ("testFirst_fail", ObservableBlockingTest.testFirst_fail),
    ("testFirst_someData", ObservableBlockingTest.testFirst_someData),
    ("testFirst_withRealScheduler", ObservableBlockingTest.testFirst_withRealScheduler),
    ("testFirst_independent", ObservableBlockingTest.testFirst_independent),
    ("testFirst_timeout", ObservableBlockingTest.testFirst_timeout),
    ("testLast_empty", ObservableBlockingTest.testLast_empty),
    ("testLast_return", ObservableBlockingTest.testLast_return),
    ("testLast_fail", ObservableBlockingTest.testLast_fail),
    ("testLast_someData", ObservableBlockingTest.testLast_someData),
    ("testLast_withRealScheduler", ObservableBlockingTest.testLast_withRealScheduler),
    ("testLast_independent", ObservableBlockingTest.testLast_independent),
    ("testLast_timeout", ObservableBlockingTest.testLast_timeout),
    ("testSingle_empty", ObservableBlockingTest.testSingle_empty),
    ("testSingle_return", ObservableBlockingTest.testSingle_return),
    ("testSingle_two", ObservableBlockingTest.testSingle_two),
    ("testSingle_someData", ObservableBlockingTest.testSingle_someData),
    ("testSingle_fail", ObservableBlockingTest.testSingle_fail),
    ("testSingle_withRealScheduler", ObservableBlockingTest.testSingle_withRealScheduler),
    ("testSingle_predicate_empty", ObservableBlockingTest.testSingle_predicate_empty),
    ("testSingle_predicate_return", ObservableBlockingTest.testSingle_predicate_return),
    ("testSingle_predicate_someData_one_match", ObservableBlockingTest.testSingle_predicate_someData_one_match),
    ("testSingle_predicate_someData_two_match", ObservableBlockingTest.testSingle_predicate_someData_two_match),
    ("testSingle_predicate_none", ObservableBlockingTest.testSingle_predicate_none),
    ("testSingle_predicate_throws", ObservableBlockingTest.testSingle_predicate_throws),
    ("testSingle_predicate_fail", ObservableBlockingTest.testSingle_predicate_fail),
    ("testSingle_predicate_withRealScheduler", ObservableBlockingTest.testSingle_predicate_withRealScheduler),
    ("testSingle_independent", ObservableBlockingTest.testSingle_independent),
    ("testSingle_timeout", ObservableBlockingTest.testSingle_timeout),
    ("testSinglePredicate_timeout", ObservableBlockingTest.testSinglePredicate_timeout),
    ] }
}

final class ObservableTimeTest_ : ObservableTimeTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableTimeTest_) -> () -> ())] { return [
    ("test_ThrottleTimeSpan_NotLatest_Completed", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_Completed),
    ("test_ThrottleTimeSpan_NotLatest_Never", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_Never),
    ("test_ThrottleTimeSpan_NotLatest_Empty", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_Empty),
    ("test_ThrottleTimeSpan_NotLatest_Error", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_Error),
    ("test_ThrottleTimeSpan_NotLatest_NoEnd", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_NoEnd),
    ("test_ThrottleTimeSpan_NotLatest_WithRealScheduler", ObservableTimeTest.test_ThrottleTimeSpan_NotLatest_WithRealScheduler),
    ("test_ThrottleTimeSpan_Completed", ObservableTimeTest.test_ThrottleTimeSpan_Completed),
    ("test_ThrottleTimeSpan_CompletedAfterDueTime", ObservableTimeTest.test_ThrottleTimeSpan_CompletedAfterDueTime),
    ("test_ThrottleTimeSpan_Never", ObservableTimeTest.test_ThrottleTimeSpan_Never),
    ("test_ThrottleTimeSpan_Empty", ObservableTimeTest.test_ThrottleTimeSpan_Empty),
    ("test_ThrottleTimeSpan_Error", ObservableTimeTest.test_ThrottleTimeSpan_Error),
    ("test_ThrottleTimeSpan_NoEnd", ObservableTimeTest.test_ThrottleTimeSpan_NoEnd),
    ("test_ThrottleTimeSpan_WithRealScheduler", ObservableTimeTest.test_ThrottleTimeSpan_WithRealScheduler),
    ("testSample_Sampler_SamplerThrows", ObservableTimeTest.testSample_Sampler_SamplerThrows),
    ("testSample_Sampler_Simple1", ObservableTimeTest.testSample_Sampler_Simple1),
    ("testSample_Sampler_Simple2", ObservableTimeTest.testSample_Sampler_Simple2),
    ("testSample_Sampler_Simple3", ObservableTimeTest.testSample_Sampler_Simple3),
    ("testSample_Sampler_SourceThrows", ObservableTimeTest.testSample_Sampler_SourceThrows),
    ("testTimer_Basic", ObservableTimeTest.testTimer_Basic),
    ("testInterval_TimeSpan_Basic", ObservableTimeTest.testInterval_TimeSpan_Basic),
    ("testInterval_TimeSpan_Zero", ObservableTimeTest.testInterval_TimeSpan_Zero),
    ("testInterval_TimeSpan_Zero_DefaultScheduler", ObservableTimeTest.testInterval_TimeSpan_Zero_DefaultScheduler),
    ("testInterval_TimeSpan_Disposed", ObservableTimeTest.testInterval_TimeSpan_Disposed),
    ("test_IntervalWithRealScheduler", ObservableTimeTest.test_IntervalWithRealScheduler),
    ("testTake_TakeZero", ObservableTimeTest.testTake_TakeZero),
    ("testTake_Some", ObservableTimeTest.testTake_Some),
    ("testTake_TakeLate", ObservableTimeTest.testTake_TakeLate),
    ("testTake_TakeError", ObservableTimeTest.testTake_TakeError),
    ("testTake_TakeNever", ObservableTimeTest.testTake_TakeNever),
    ("testTake_TakeTwice1", ObservableTimeTest.testTake_TakeTwice1),
    ("testTake_TakeDefault", ObservableTimeTest.testTake_TakeDefault),
    ("testDelaySubscription_TimeSpan_Simple", ObservableTimeTest.testDelaySubscription_TimeSpan_Simple),
    ("testDelaySubscription_TimeSpan_Error", ObservableTimeTest.testDelaySubscription_TimeSpan_Error),
    ("testDelaySubscription_TimeSpan_Dispose", ObservableTimeTest.testDelaySubscription_TimeSpan_Dispose),
    ("testSkip_Zero", ObservableTimeTest.testSkip_Zero),
    ("testSkip_Some", ObservableTimeTest.testSkip_Some),
    ("testSkip_Late", ObservableTimeTest.testSkip_Late),
    ("testSkip_Error", ObservableTimeTest.testSkip_Error),
    ("testSkip_Never", ObservableTimeTest.testSkip_Never),
    ("testBufferWithTimeOrCount_Basic", ObservableTimeTest.testBufferWithTimeOrCount_Basic),
    ("testBufferWithTimeOrCount_Error", ObservableTimeTest.testBufferWithTimeOrCount_Error),
    ("testBufferWithTimeOrCount_Disposed", ObservableTimeTest.testBufferWithTimeOrCount_Disposed),
    ("testBufferWithTimeOrCount_Default", ObservableTimeTest.testBufferWithTimeOrCount_Default),
    ("testWindowWithTimeOrCount_Basic", ObservableTimeTest.testWindowWithTimeOrCount_Basic),
    ("testWindowWithTimeOrCount_Error", ObservableTimeTest.testWindowWithTimeOrCount_Error),
    ("testWindowWithTimeOrCount_Disposed", ObservableTimeTest.testWindowWithTimeOrCount_Disposed),
    ("testTimeout_Empty", ObservableTimeTest.testTimeout_Empty),
    ("testTimeout_Error", ObservableTimeTest.testTimeout_Error),
    ("testTimeout_Never", ObservableTimeTest.testTimeout_Never),
    ("testTimeout_Duetime_Simple", ObservableTimeTest.testTimeout_Duetime_Simple),
    ("testTimeout_Duetime_Timeout_Exact", ObservableTimeTest.testTimeout_Duetime_Timeout_Exact),
    ("testTimeout_Duetime_Timeout", ObservableTimeTest.testTimeout_Duetime_Timeout),
    ("testTimeout_Duetime_Disposed", ObservableTimeTest.testTimeout_Duetime_Disposed),
    ("testTimeout_TimeoutOccurs_1", ObservableTimeTest.testTimeout_TimeoutOccurs_1),
    ("testTimeout_TimeoutOccurs_2", ObservableTimeTest.testTimeout_TimeoutOccurs_2),
    ("testTimeout_TimeoutOccurs_Never", ObservableTimeTest.testTimeout_TimeoutOccurs_Never),
    ("testTimeout_TimeoutOccurs_Completed", ObservableTimeTest.testTimeout_TimeoutOccurs_Completed),
    ("testTimeout_TimeoutOccurs_Error", ObservableTimeTest.testTimeout_TimeoutOccurs_Error),
    ("testTimeout_TimeoutOccurs_NextIsError", ObservableTimeTest.testTimeout_TimeoutOccurs_NextIsError),
    ("testTimeout_TimeoutNotOccurs_Completed", ObservableTimeTest.testTimeout_TimeoutNotOccurs_Completed),
    ("testTimeout_TimeoutNotOccurs_Error", ObservableTimeTest.testTimeout_TimeoutNotOccurs_Error),
    ("testTimeout_TimeoutNotOccurs", ObservableTimeTest.testTimeout_TimeoutNotOccurs),
    ("testDelay_TimeSpan_Simple1", ObservableTimeTest.testDelay_TimeSpan_Simple1),
    ("testDelay_TimeSpan_Simple2", ObservableTimeTest.testDelay_TimeSpan_Simple2),
    ("testDelay_TimeSpan_Simple3", ObservableTimeTest.testDelay_TimeSpan_Simple3),
    ("testDelay_TimeSpan_Error", ObservableTimeTest.testDelay_TimeSpan_Error),
    ("testDelay_TimeSpan_Completed", ObservableTimeTest.testDelay_TimeSpan_Completed),
    ("testDelay_TimeSpan_Error1", ObservableTimeTest.testDelay_TimeSpan_Error1),
    ("testDelay_TimeSpan_Error2", ObservableTimeTest.testDelay_TimeSpan_Error2),
    ("testDelay_TimeSpan_Real_Simple", ObservableTimeTest.testDelay_TimeSpan_Real_Simple),
    ("testDelay_TimeSpan_Real_Error1", ObservableTimeTest.testDelay_TimeSpan_Real_Error1),
    ("testDelay_TimeSpan_Real_Error2", ObservableTimeTest.testDelay_TimeSpan_Real_Error2),
    ("testDelay_TimeSpan_Real_Error3", ObservableTimeTest.testDelay_TimeSpan_Real_Error3),
    ("testDelay_TimeSpan_Positive", ObservableTimeTest.testDelay_TimeSpan_Positive),
    ("testDelay_TimeSpan_DefaultScheduler", ObservableTimeTest.testDelay_TimeSpan_DefaultScheduler),
    ] }
}

final class AsyncSubjectTests_ : AsyncSubjectTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (AsyncSubjectTests_) -> () -> ())] { return [
    ("test_hasObserversManyObserver", AsyncSubjectTests.test_hasObserversManyObserver),
    ("test_infinite", AsyncSubjectTests.test_infinite),
    ("test_finite", AsyncSubjectTests.test_finite),
    ("test_error", AsyncSubjectTests.test_error),
    ("test_empty", AsyncSubjectTests.test_empty),
    ] }
}

final class ObservableBindingTest_ : ObservableBindingTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableBindingTest_) -> () -> ())] { return [
    ("testMulticast_Cold_Completed", ObservableBindingTest.testMulticast_Cold_Completed),
    ("testMulticast_Cold_Error", ObservableBindingTest.testMulticast_Cold_Error),
    ("testMulticast_Cold_Dispose", ObservableBindingTest.testMulticast_Cold_Dispose),
    ("testMulticast_Cold_Zip", ObservableBindingTest.testMulticast_Cold_Zip),
    ("testMulticast_SubjectSelectorThrows", ObservableBindingTest.testMulticast_SubjectSelectorThrows),
    ("testMulticast_SelectorThrows", ObservableBindingTest.testMulticast_SelectorThrows),
    ("testRefCount_DeadlockSimple", ObservableBindingTest.testRefCount_DeadlockSimple),
    ("testRefCount_DeadlockErrorAfterN", ObservableBindingTest.testRefCount_DeadlockErrorAfterN),
    ("testRefCount_DeadlockErrorImmediatelly", ObservableBindingTest.testRefCount_DeadlockErrorImmediatelly),
    ("testRefCount_DeadlockEmpty", ObservableBindingTest.testRefCount_DeadlockEmpty),
    ("testRefCount_ConnectsOnFirst", ObservableBindingTest.testRefCount_ConnectsOnFirst),
    ("testRefCount_NotConnected", ObservableBindingTest.testRefCount_NotConnected),
    ("testRefCount_Error", ObservableBindingTest.testRefCount_Error),
    ("testRefCount_Publish", ObservableBindingTest.testRefCount_Publish),
    ("testReplayCount_Basic", ObservableBindingTest.testReplayCount_Basic),
    ("testReplayCount_Error", ObservableBindingTest.testReplayCount_Error),
    ("testReplayCount_Complete", ObservableBindingTest.testReplayCount_Complete),
    ("testReplayCount_Dispose", ObservableBindingTest.testReplayCount_Dispose),
    ("testReplayOneCount_Basic", ObservableBindingTest.testReplayOneCount_Basic),
    ("testReplayOneCount_Error", ObservableBindingTest.testReplayOneCount_Error),
    ("testReplayOneCount_Complete", ObservableBindingTest.testReplayOneCount_Complete),
    ("testReplayOneCount_Dispose", ObservableBindingTest.testReplayOneCount_Dispose),
    ("testReplayAll_Basic", ObservableBindingTest.testReplayAll_Basic),
    ("testReplayAll_Error", ObservableBindingTest.testReplayAll_Error),
    ("testReplayAll_Complete", ObservableBindingTest.testReplayAll_Complete),
    ("testReplayAll_Dispose", ObservableBindingTest.testReplayAll_Dispose),
    ("testShareReplay_DeadlockImmediatelly", ObservableBindingTest.testShareReplay_DeadlockImmediatelly),
    ("testShareReplay_DeadlockEmpty", ObservableBindingTest.testShareReplay_DeadlockEmpty),
    ("testShareReplay_DeadlockError", ObservableBindingTest.testShareReplay_DeadlockError),
    ("testShareReplay1_DeadlockErrorAfterN", ObservableBindingTest.testShareReplay1_DeadlockErrorAfterN),
    ("testShareReplay1_Basic", ObservableBindingTest.testShareReplay1_Basic),
    ("testShareReplay1_Error", ObservableBindingTest.testShareReplay1_Error),
    ("testShareReplay1_Completed", ObservableBindingTest.testShareReplay1_Completed),
    ("testShareReplay1_Canceled", ObservableBindingTest.testShareReplay1_Canceled),
    ("testShareReplayLatestWhileConnected_DeadlockImmediatelly", ObservableBindingTest.testShareReplayLatestWhileConnected_DeadlockImmediatelly),
    ("testShareReplayLatestWhileConnected_DeadlockEmpty", ObservableBindingTest.testShareReplayLatestWhileConnected_DeadlockEmpty),
    ("testShareReplayLatestWhileConnected_DeadlockError", ObservableBindingTest.testShareReplayLatestWhileConnected_DeadlockError),
    ("testShareReplayLatestWhileConnected_DeadlockErrorAfterN", ObservableBindingTest.testShareReplayLatestWhileConnected_DeadlockErrorAfterN),
    ("testShareReplayLatestWhileConnected_Basic", ObservableBindingTest.testShareReplayLatestWhileConnected_Basic),
    ("testShareReplayLatestWhileConnected_Error", ObservableBindingTest.testShareReplayLatestWhileConnected_Error),
    ("testShareReplayLatestWhileConnected_Completed", ObservableBindingTest.testShareReplayLatestWhileConnected_Completed),
    ("testShareReplayLatestWhileConnected_FirstDisconnectsThenEmits_Complete", ObservableBindingTest.testShareReplayLatestWhileConnected_FirstDisconnectsThenEmits_Complete),
    ("testShareReplayLatestWhileConnected_FirstDisconnectsThenEmits_Error", ObservableBindingTest.testShareReplayLatestWhileConnected_FirstDisconnectsThenEmits_Error),
    ] }
}

final class ObservableSingleTest_ : ObservableSingleTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSingleTest_) -> () -> ())] { return [
    ("testAsObservable_asObservable", ObservableSingleTest.testAsObservable_asObservable),
    ("testAsObservable_hides", ObservableSingleTest.testAsObservable_hides),
    ("testAsObservable_never", ObservableSingleTest.testAsObservable_never),
    ("testDistinctUntilChanged_allChanges", ObservableSingleTest.testDistinctUntilChanged_allChanges),
    ("testDistinctUntilChanged_someChanges", ObservableSingleTest.testDistinctUntilChanged_someChanges),
    ("testDistinctUntilChanged_allEqual", ObservableSingleTest.testDistinctUntilChanged_allEqual),
    ("testDistinctUntilChanged_allDifferent", ObservableSingleTest.testDistinctUntilChanged_allDifferent),
    ("testDistinctUntilChanged_keySelector_Div2", ObservableSingleTest.testDistinctUntilChanged_keySelector_Div2),
    ("testDistinctUntilChanged_keySelectorThrows", ObservableSingleTest.testDistinctUntilChanged_keySelectorThrows),
    ("testDistinctUntilChanged_comparerThrows", ObservableSingleTest.testDistinctUntilChanged_comparerThrows),
    ("testDoOn_shouldSeeAllValues", ObservableSingleTest.testDoOn_shouldSeeAllValues),
    ("testDoOn_plainAction", ObservableSingleTest.testDoOn_plainAction),
    ("testDoOn_nextCompleted", ObservableSingleTest.testDoOn_nextCompleted),
    ("testDoOn_completedNever", ObservableSingleTest.testDoOn_completedNever),
    ("testDoOn_nextError", ObservableSingleTest.testDoOn_nextError),
    ("testDoOn_nextErrorNot", ObservableSingleTest.testDoOn_nextErrorNot),
    ("testDoOnNext_normal", ObservableSingleTest.testDoOnNext_normal),
    ("testDoOnNext_throws", ObservableSingleTest.testDoOnNext_throws),
    ("testDoOnError_normal", ObservableSingleTest.testDoOnError_normal),
    ("testDoOnError_throws", ObservableSingleTest.testDoOnError_throws),
    ("testDoOnCompleted_normal", ObservableSingleTest.testDoOnCompleted_normal),
    ("testDoOnCompleted_throws", ObservableSingleTest.testDoOnCompleted_throws),
    ("testDoOnOrder_Completed_Async", ObservableSingleTest.testDoOnOrder_Completed_Async),
    ("testDoOnOrder_Completed_Sync", ObservableSingleTest.testDoOnOrder_Completed_Sync),
    ("testDoOnOrder_Error", ObservableSingleTest.testDoOnOrder_Error),
    ("testDoOnOrder_Dispose", ObservableSingleTest.testDoOnOrder_Dispose),
    ("testRetry_Basic", ObservableSingleTest.testRetry_Basic),
    ("testRetry_Infinite", ObservableSingleTest.testRetry_Infinite),
    ("testRetry_Observable_Error", ObservableSingleTest.testRetry_Observable_Error),
    ("testRetryCount_Basic", ObservableSingleTest.testRetryCount_Basic),
    ("testRetryCount_Dispose", ObservableSingleTest.testRetryCount_Dispose),
    ("testRetryCount_Infinite", ObservableSingleTest.testRetryCount_Infinite),
    ("testRetryCount_Completed", ObservableSingleTest.testRetryCount_Completed),
    ("testRetry_tailRecursiveOptimizationsTest", ObservableSingleTest.testRetry_tailRecursiveOptimizationsTest),
    ("testRetryWhen_Never", ObservableSingleTest.testRetryWhen_Never),
    ("testRetryWhen_ObservableNever", ObservableSingleTest.testRetryWhen_ObservableNever),
    ("testRetryWhen_ObservableNeverComplete", ObservableSingleTest.testRetryWhen_ObservableNeverComplete),
    ("testRetryWhen_ObservableEmpty", ObservableSingleTest.testRetryWhen_ObservableEmpty),
    ("testRetryWhen_ObservableNextError", ObservableSingleTest.testRetryWhen_ObservableNextError),
    ("testRetryWhen_ObservableComplete", ObservableSingleTest.testRetryWhen_ObservableComplete),
    ("testRetryWhen_ObservableNextComplete", ObservableSingleTest.testRetryWhen_ObservableNextComplete),
    ("testRetryWhen_ObservableInfinite", ObservableSingleTest.testRetryWhen_ObservableInfinite),
    ("testRetryWhen_Incremental_BackOff", ObservableSingleTest.testRetryWhen_Incremental_BackOff),
    ("testRetryWhen_IgnoresDifferentErrorTypes", ObservableSingleTest.testRetryWhen_IgnoresDifferentErrorTypes),
    ("testRetryWhen_tailRecursiveOptimizationsTest", ObservableSingleTest.testRetryWhen_tailRecursiveOptimizationsTest),
    ("testIgnoreElements_DoesNotSendValues", ObservableSingleTest.testIgnoreElements_DoesNotSendValues),
    ("testScan_Seed_Never", ObservableSingleTest.testScan_Seed_Never),
    ("testScan_Seed_Empty", ObservableSingleTest.testScan_Seed_Empty),
    ("testScan_Seed_Return", ObservableSingleTest.testScan_Seed_Return),
    ("testScan_Seed_Throw", ObservableSingleTest.testScan_Seed_Throw),
    ("testScan_Seed_SomeData", ObservableSingleTest.testScan_Seed_SomeData),
    ("testScan_Seed_AccumulatorThrows", ObservableSingleTest.testScan_Seed_AccumulatorThrows),
    ("testDefaultIfEmpty_Source_Empty", ObservableSingleTest.testDefaultIfEmpty_Source_Empty),
    ("testDefaultIfEmpty_Source_Errors", ObservableSingleTest.testDefaultIfEmpty_Source_Errors),
    ("testDefaultIfEmpty_Source_Emits", ObservableSingleTest.testDefaultIfEmpty_Source_Emits),
    ("testDefaultIfEmpty_Never", ObservableSingleTest.testDefaultIfEmpty_Never),
    ("testGroupBy_TwoGroup", ObservableSingleTest.testGroupBy_TwoGroup),
    ("testGroupBy_OuterComplete", ObservableSingleTest.testGroupBy_OuterComplete),
    ("testGroupBy_OuterError", ObservableSingleTest.testGroupBy_OuterError),
    ("testGroupBy_OuterDispose", ObservableSingleTest.testGroupBy_OuterDispose),
    ("testGroupBy_OuterKeySelectorThrows", ObservableSingleTest.testGroupBy_OuterKeySelectorThrows),
    ("testGroupBy_InnerComplete", ObservableSingleTest.testGroupBy_InnerComplete),
    ("testGroupBy_InnerCompleteAll", ObservableSingleTest.testGroupBy_InnerCompleteAll),
    ("testGroupBy_InnerError", ObservableSingleTest.testGroupBy_InnerError),
    ("testGroupBy_InnerDispose", ObservableSingleTest.testGroupBy_InnerDispose),
    ("testGroupBy_InnerKeyThrow", ObservableSingleTest.testGroupBy_InnerKeyThrow),
    ("testGroupBy_OuterIndependence", ObservableSingleTest.testGroupBy_OuterIndependence),
    ("testGroupBy_InnerIndependence", ObservableSingleTest.testGroupBy_InnerIndependence),
    ("testGroupBy_InnerMultipleIndependence", ObservableSingleTest.testGroupBy_InnerMultipleIndependence),
    ("testGroupBy_InnerEscapeComplete", ObservableSingleTest.testGroupBy_InnerEscapeComplete),
    ("testGroupBy_InnerEscapeError", ObservableSingleTest.testGroupBy_InnerEscapeError),
    ("testGroupBy_InnerEscapeDispose", ObservableSingleTest.testGroupBy_InnerEscapeDispose),
    ] }
}

final class ObservableAggregateTest_ : ObservableAggregateTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableAggregateTest_) -> () -> ())] { return [
    ("test_AggregateWithSeed_Empty", ObservableAggregateTest.test_AggregateWithSeed_Empty),
    ("test_AggregateWithSeed_Return", ObservableAggregateTest.test_AggregateWithSeed_Return),
    ("test_AggregateWithSeed_Throw", ObservableAggregateTest.test_AggregateWithSeed_Throw),
    ("test_AggregateWithSeed_Never", ObservableAggregateTest.test_AggregateWithSeed_Never),
    ("test_AggregateWithSeed_Range", ObservableAggregateTest.test_AggregateWithSeed_Range),
    ("test_AggregateWithSeed_AccumulatorThrows", ObservableAggregateTest.test_AggregateWithSeed_AccumulatorThrows),
    ("test_AggregateWithSeedAndResult_Empty", ObservableAggregateTest.test_AggregateWithSeedAndResult_Empty),
    ("test_AggregateWithSeedAndResult_Return", ObservableAggregateTest.test_AggregateWithSeedAndResult_Return),
    ("test_AggregateWithSeedAndResult_Throw", ObservableAggregateTest.test_AggregateWithSeedAndResult_Throw),
    ("test_AggregateWithSeedAndResult_Never", ObservableAggregateTest.test_AggregateWithSeedAndResult_Never),
    ("test_AggregateWithSeedAndResult_Range", ObservableAggregateTest.test_AggregateWithSeedAndResult_Range),
    ("test_AggregateWithSeedAndResult_AccumulatorThrows", ObservableAggregateTest.test_AggregateWithSeedAndResult_AccumulatorThrows),
    ("test_AggregateWithSeedAndResult_SelectorThrows", ObservableAggregateTest.test_AggregateWithSeedAndResult_SelectorThrows),
    ("test_ToArrayWithSingleItem_Return", ObservableAggregateTest.test_ToArrayWithSingleItem_Return),
    ("test_ToArrayWithMultipleItems_Return", ObservableAggregateTest.test_ToArrayWithMultipleItems_Return),
    ("test_ToArrayWithNoItems_Empty", ObservableAggregateTest.test_ToArrayWithNoItems_Empty),
    ("test_ToArrayWithSingleItem_Never", ObservableAggregateTest.test_ToArrayWithSingleItem_Never),
    ("test_ToArrayWithImmediateError_Throw", ObservableAggregateTest.test_ToArrayWithImmediateError_Throw),
    ("test_ToArrayWithMultipleItems_Throw", ObservableAggregateTest.test_ToArrayWithMultipleItems_Throw),
    ] }
}

final class ObservableStandardSequenceOperatorsTest_ : ObservableStandardSequenceOperatorsTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableStandardSequenceOperatorsTest_) -> () -> ())] { return [
    ("test_filterComplete", ObservableStandardSequenceOperatorsTest.test_filterComplete),
    ("test_filterTrue", ObservableStandardSequenceOperatorsTest.test_filterTrue),
    ("test_filterFalse", ObservableStandardSequenceOperatorsTest.test_filterFalse),
    ("test_filterDisposed", ObservableStandardSequenceOperatorsTest.test_filterDisposed),
    ("testTakeWhile_Complete_Before", ObservableStandardSequenceOperatorsTest.testTakeWhile_Complete_Before),
    ("testTakeWhile_Complete_After", ObservableStandardSequenceOperatorsTest.testTakeWhile_Complete_After),
    ("testTakeWhile_Error_Before", ObservableStandardSequenceOperatorsTest.testTakeWhile_Error_Before),
    ("testTakeWhile_Error_After", ObservableStandardSequenceOperatorsTest.testTakeWhile_Error_After),
    ("testTakeWhile_Dispose_Before", ObservableStandardSequenceOperatorsTest.testTakeWhile_Dispose_Before),
    ("testTakeWhile_Dispose_After", ObservableStandardSequenceOperatorsTest.testTakeWhile_Dispose_After),
    ("testTakeWhile_Zero", ObservableStandardSequenceOperatorsTest.testTakeWhile_Zero),
    ("testTakeWhile_Throw", ObservableStandardSequenceOperatorsTest.testTakeWhile_Throw),
    ("testTakeWhile_Index1", ObservableStandardSequenceOperatorsTest.testTakeWhile_Index1),
    ("testTakeWhile_Index2", ObservableStandardSequenceOperatorsTest.testTakeWhile_Index2),
    ("testTakeWhile_Index_Error", ObservableStandardSequenceOperatorsTest.testTakeWhile_Index_Error),
    ("testTakeWhile_Index_SelectorThrows", ObservableStandardSequenceOperatorsTest.testTakeWhile_Index_SelectorThrows),
    ("testMap_Never", ObservableStandardSequenceOperatorsTest.testMap_Never),
    ("testMap_Empty", ObservableStandardSequenceOperatorsTest.testMap_Empty),
    ("testMap_Range", ObservableStandardSequenceOperatorsTest.testMap_Range),
    ("testMap_Error", ObservableStandardSequenceOperatorsTest.testMap_Error),
    ("testMap_Dispose", ObservableStandardSequenceOperatorsTest.testMap_Dispose),
    ("testMap_SelectorThrows", ObservableStandardSequenceOperatorsTest.testMap_SelectorThrows),
    ("testMap1_Never", ObservableStandardSequenceOperatorsTest.testMap1_Never),
    ("testMap1_Empty", ObservableStandardSequenceOperatorsTest.testMap1_Empty),
    ("testMap1_Range", ObservableStandardSequenceOperatorsTest.testMap1_Range),
    ("testMap1_Error", ObservableStandardSequenceOperatorsTest.testMap1_Error),
    ("testMap1_Dispose", ObservableStandardSequenceOperatorsTest.testMap1_Dispose),
    ("testMap1_SelectorThrows", ObservableStandardSequenceOperatorsTest.testMap1_SelectorThrows),
    ("testMap_DisposeOnCompleted", ObservableStandardSequenceOperatorsTest.testMap_DisposeOnCompleted),
    ("testMap1_DisposeOnCompleted", ObservableStandardSequenceOperatorsTest.testMap1_DisposeOnCompleted),
    ("testMapCompose_Never", ObservableStandardSequenceOperatorsTest.testMapCompose_Never),
    ("testMapCompose_Empty", ObservableStandardSequenceOperatorsTest.testMapCompose_Empty),
    ("testMapCompose_Range", ObservableStandardSequenceOperatorsTest.testMapCompose_Range),
    ("testMapCompose_Error", ObservableStandardSequenceOperatorsTest.testMapCompose_Error),
    ("testMapCompose_Dispose", ObservableStandardSequenceOperatorsTest.testMapCompose_Dispose),
    ("testMapCompose_Selector1Throws", ObservableStandardSequenceOperatorsTest.testMapCompose_Selector1Throws),
    ("testMapCompose_Selector2Throws", ObservableStandardSequenceOperatorsTest.testMapCompose_Selector2Throws),
    ("testFlatMapFirst_Complete", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Complete),
    ("testFlatMapFirst_Complete_InnerNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Complete_InnerNotComplete),
    ("testFlatMapFirst_Complete_OuterNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Complete_OuterNotComplete),
    ("testFlatMapFirst_Complete_ErrorOuter", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Complete_ErrorOuter),
    ("testFlatMapFirst_Error_Inner", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Error_Inner),
    ("testFlatMapFirst_Dispose", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_Dispose),
    ("testFlatMapFirst_SelectorThrows", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_SelectorThrows),
    ("testFlatMapFirst_UseFunction", ObservableStandardSequenceOperatorsTest.testFlatMapFirst_UseFunction),
    ("testFlatMap_Complete", ObservableStandardSequenceOperatorsTest.testFlatMap_Complete),
    ("testFlatMap_Complete_InnerNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMap_Complete_InnerNotComplete),
    ("testFlatMap_Complete_OuterNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMap_Complete_OuterNotComplete),
    ("testFlatMap_Complete_ErrorOuter", ObservableStandardSequenceOperatorsTest.testFlatMap_Complete_ErrorOuter),
    ("testFlatMap_Error_Inner", ObservableStandardSequenceOperatorsTest.testFlatMap_Error_Inner),
    ("testFlatMap_Dispose", ObservableStandardSequenceOperatorsTest.testFlatMap_Dispose),
    ("testFlatMap_SelectorThrows", ObservableStandardSequenceOperatorsTest.testFlatMap_SelectorThrows),
    ("testFlatMap_UseFunction", ObservableStandardSequenceOperatorsTest.testFlatMap_UseFunction),
    ("testFlatMapIndex_Index", ObservableStandardSequenceOperatorsTest.testFlatMapIndex_Index),
    ("testFlatMapWithIndex_Complete", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Complete),
    ("testFlatMapWithIndex_Complete_InnerNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Complete_InnerNotComplete),
    ("testFlatMapWithIndex_Complete_OuterNotComplete", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Complete_OuterNotComplete),
    ("testFlatMapWithIndex_Complete_ErrorOuter", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Complete_ErrorOuter),
    ("testFlatMapWithIndex_Error_Inner", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Error_Inner),
    ("testFlatMapWithIndex_Dispose", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_Dispose),
    ("testFlatMapWithIndex_SelectorThrows", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_SelectorThrows),
    ("testFlatMapWithIndex_UseFunction", ObservableStandardSequenceOperatorsTest.testFlatMapWithIndex_UseFunction),
    ("testTake_Complete_After", ObservableStandardSequenceOperatorsTest.testTake_Complete_After),
    ("testTake_Complete_Same", ObservableStandardSequenceOperatorsTest.testTake_Complete_Same),
    ("testTake_Complete_Before", ObservableStandardSequenceOperatorsTest.testTake_Complete_Before),
    ("testTake_Error_After", ObservableStandardSequenceOperatorsTest.testTake_Error_After),
    ("testTake_Error_Same", ObservableStandardSequenceOperatorsTest.testTake_Error_Same),
    ("testTake_Error_Before", ObservableStandardSequenceOperatorsTest.testTake_Error_Before),
    ("testTake_Dispose_Before", ObservableStandardSequenceOperatorsTest.testTake_Dispose_Before),
    ("testTake_Dispose_After", ObservableStandardSequenceOperatorsTest.testTake_Dispose_After),
    ("testTake_0_DefaultScheduler", ObservableStandardSequenceOperatorsTest.testTake_0_DefaultScheduler),
    ("testTake_Take1", ObservableStandardSequenceOperatorsTest.testTake_Take1),
    ("testTake_DecrementCountsFirst", ObservableStandardSequenceOperatorsTest.testTake_DecrementCountsFirst),
    ("testTakeLast_Complete_Less", ObservableStandardSequenceOperatorsTest.testTakeLast_Complete_Less),
    ("testTakeLast_Complete_Same", ObservableStandardSequenceOperatorsTest.testTakeLast_Complete_Same),
    ("testTakeLast_Complete_More", ObservableStandardSequenceOperatorsTest.testTakeLast_Complete_More),
    ("testTakeLast_Error_Less", ObservableStandardSequenceOperatorsTest.testTakeLast_Error_Less),
    ("testTakeLast_Error_Same", ObservableStandardSequenceOperatorsTest.testTakeLast_Error_Same),
    ("testTakeLast_Error_More", ObservableStandardSequenceOperatorsTest.testTakeLast_Error_More),
    ("testTakeLast_0_DefaultScheduler", ObservableStandardSequenceOperatorsTest.testTakeLast_0_DefaultScheduler),
    ("testTakeLast_TakeLast1", ObservableStandardSequenceOperatorsTest.testTakeLast_TakeLast1),
    ("testTakeLast_DecrementCountsFirst", ObservableStandardSequenceOperatorsTest.testTakeLast_DecrementCountsFirst),
    ("testSkip_Complete_After", ObservableStandardSequenceOperatorsTest.testSkip_Complete_After),
    ("testSkip_Complete_Some", ObservableStandardSequenceOperatorsTest.testSkip_Complete_Some),
    ("testSkip_Complete_Before", ObservableStandardSequenceOperatorsTest.testSkip_Complete_Before),
    ("testSkip_Complete_Zero", ObservableStandardSequenceOperatorsTest.testSkip_Complete_Zero),
    ("testSkip_Error_After", ObservableStandardSequenceOperatorsTest.testSkip_Error_After),
    ("testSkip_Error_Same", ObservableStandardSequenceOperatorsTest.testSkip_Error_Same),
    ("testSkip_Error_Before", ObservableStandardSequenceOperatorsTest.testSkip_Error_Before),
    ("testSkip_Dispose_Before", ObservableStandardSequenceOperatorsTest.testSkip_Dispose_Before),
    ("testSkip_Dispose_After", ObservableStandardSequenceOperatorsTest.testSkip_Dispose_After),
    ("testSkipWhile_Complete_Before", ObservableStandardSequenceOperatorsTest.testSkipWhile_Complete_Before),
    ("testSkipWhile_Complete_After", ObservableStandardSequenceOperatorsTest.testSkipWhile_Complete_After),
    ("testSkipWhile_Error_Before", ObservableStandardSequenceOperatorsTest.testSkipWhile_Error_Before),
    ("testSkipWhile_Error_After", ObservableStandardSequenceOperatorsTest.testSkipWhile_Error_After),
    ("testSkipWhile_Dispose_Before", ObservableStandardSequenceOperatorsTest.testSkipWhile_Dispose_Before),
    ("testSkipWhile_Dispose_After", ObservableStandardSequenceOperatorsTest.testSkipWhile_Dispose_After),
    ("testSkipWhile_Zero", ObservableStandardSequenceOperatorsTest.testSkipWhile_Zero),
    ("testSkipWhile_Throw", ObservableStandardSequenceOperatorsTest.testSkipWhile_Throw),
    ("testSkipWhile_Index", ObservableStandardSequenceOperatorsTest.testSkipWhile_Index),
    ("testSkipWhile_Index_Throw", ObservableStandardSequenceOperatorsTest.testSkipWhile_Index_Throw),
    ("testSkipWhile_Index_SelectorThrows", ObservableStandardSequenceOperatorsTest.testSkipWhile_Index_SelectorThrows),
    ("testElementAt_Complete_After", ObservableStandardSequenceOperatorsTest.testElementAt_Complete_After),
    ("testElementAt_Complete_Before", ObservableStandardSequenceOperatorsTest.testElementAt_Complete_Before),
    ("testElementAt_Error_After", ObservableStandardSequenceOperatorsTest.testElementAt_Error_After),
    ("testElementAt_Error_Before", ObservableStandardSequenceOperatorsTest.testElementAt_Error_Before),
    ("testElementAt_Dispose_Before", ObservableStandardSequenceOperatorsTest.testElementAt_Dispose_Before),
    ("testElementAt_Dispose_After", ObservableStandardSequenceOperatorsTest.testElementAt_Dispose_After),
    ("testElementAt_First", ObservableStandardSequenceOperatorsTest.testElementAt_First),
    ("testSingle_Empty", ObservableStandardSequenceOperatorsTest.testSingle_Empty),
    ("testSingle_One", ObservableStandardSequenceOperatorsTest.testSingle_One),
    ("testSingle_Many", ObservableStandardSequenceOperatorsTest.testSingle_Many),
    ("testSingle_Error", ObservableStandardSequenceOperatorsTest.testSingle_Error),
    ("testSinglePredicate_Empty", ObservableStandardSequenceOperatorsTest.testSinglePredicate_Empty),
    ("testSinglePredicate_One", ObservableStandardSequenceOperatorsTest.testSinglePredicate_One),
    ("testSinglePredicate_Many", ObservableStandardSequenceOperatorsTest.testSinglePredicate_Many),
    ("testSinglePredicate_Error", ObservableStandardSequenceOperatorsTest.testSinglePredicate_Error),
    ("testSinglePredicate_Throws", ObservableStandardSequenceOperatorsTest.testSinglePredicate_Throws),
    ] }
}

final class SubjectConcurrencyTest_ : SubjectConcurrencyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (SubjectConcurrencyTest_) -> () -> ())] { return [
    ("testSubjectIsReentrantForNextAndComplete", SubjectConcurrencyTest.testSubjectIsReentrantForNextAndComplete),
    ("testSubjectIsReentrantForNextAndError", SubjectConcurrencyTest.testSubjectIsReentrantForNextAndError),
    ] }
}

final class VariableTest_ : VariableTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (VariableTest_) -> () -> ())] { return [
    ("testVariable_initialValues", VariableTest.testVariable_initialValues),
    ("testVariable_sendsCompletedOnDealloc", VariableTest.testVariable_sendsCompletedOnDealloc),
    ("testVariable_READMEExample", VariableTest.testVariable_READMEExample),
    ] }
}

final class ObservableConcurrencyTest_ : ObservableConcurrencyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableConcurrencyTest_) -> () -> ())] { return [
    ("testObserveOnDispatchQueue_DoesPerformWorkOnQueue", ObservableConcurrencyTest.testObserveOnDispatchQueue_DoesPerformWorkOnQueue),
    ("testObserveOnDispatchQueue_DeadlockErrorImmediatelly", ObservableConcurrencyTest.testObserveOnDispatchQueue_DeadlockErrorImmediatelly),
    ("testObserveOnDispatchQueue_DeadlockEmpty", ObservableConcurrencyTest.testObserveOnDispatchQueue_DeadlockEmpty),
    ("testObserveOnDispatchQueue_Never", ObservableConcurrencyTest.testObserveOnDispatchQueue_Never),
    ("testObserveOnDispatchQueue_Simple", ObservableConcurrencyTest.testObserveOnDispatchQueue_Simple),
    ("testObserveOnDispatchQueue_Empty", ObservableConcurrencyTest.testObserveOnDispatchQueue_Empty),
    ("testObserveOnDispatchQueue_Error", ObservableConcurrencyTest.testObserveOnDispatchQueue_Error),
    ("testObserveOnDispatchQueue_Dispose", ObservableConcurrencyTest.testObserveOnDispatchQueue_Dispose),
    ("testSubscribeOn_SchedulerSleep", ObservableConcurrencyTest.testSubscribeOn_SchedulerSleep),
    ("testSubscribeOn_SchedulerCompleted", ObservableConcurrencyTest.testSubscribeOn_SchedulerCompleted),
    ("testSubscribeOn_SchedulerError", ObservableConcurrencyTest.testSubscribeOn_SchedulerError),
    ("testSubscribeOn_SchedulerDispose", ObservableConcurrencyTest.testSubscribeOn_SchedulerDispose),
    ] }
}

final class ReactiveTests_ : ReactiveTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ReactiveTests_) -> () -> ())] { return [
    ("testEnablesMutations", ReactiveTests.testEnablesMutations),
    ] }
}

final class ReplaySubjectTest_ : ReplaySubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ReplaySubjectTest_) -> () -> ())] { return [
    ("test_hasObserversNoObservers", ReplaySubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", ReplaySubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", ReplaySubjectTest.test_hasObserversManyObserver),
    ] }
}

final class ObservableSubscriptionTests_ : ObservableSubscriptionTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableSubscriptionTests_) -> () -> ())] { return [
    ("testSubscribeOnNext", ObservableSubscriptionTests.testSubscribeOnNext),
    ("testSubscribeOnError", ObservableSubscriptionTests.testSubscribeOnError),
    ("testSubscribeOnCompleted", ObservableSubscriptionTests.testSubscribeOnCompleted),
    ("testDisposed", ObservableSubscriptionTests.testDisposed),
    ] }
}

final class NSNotificationCenterTests_ : NSNotificationCenterTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (NSNotificationCenterTests_) -> () -> ())] { return [
    ("testNotificationCenterWithoutObject", NSNotificationCenterTests.testNotificationCenterWithoutObject),
    ("testNotificationCenterWithObject", NSNotificationCenterTests.testNotificationCenterWithObject),
    ] }
}

final class DisposableTest_ : DisposableTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (DisposableTest_) -> () -> ())] { return [
    ("testActionDisposable", DisposableTest.testActionDisposable),
    ("testHotObservable_Disposing", DisposableTest.testHotObservable_Disposing),
    ("testCompositeDisposable_TestNormal", DisposableTest.testCompositeDisposable_TestNormal),
    ("testCompositeDisposable_TestInitWithNumberOfDisposables", DisposableTest.testCompositeDisposable_TestInitWithNumberOfDisposables),
    ("testCompositeDisposable_TestRemoving", DisposableTest.testCompositeDisposable_TestRemoving),
    ("testDisposables_TestCreateWithNumberOfDisposables", DisposableTest.testDisposables_TestCreateWithNumberOfDisposables),
    ("testRefCountDisposable_RefCounting", DisposableTest.testRefCountDisposable_RefCounting),
    ("testRefCountDisposable_PrimaryDisposesFirst", DisposableTest.testRefCountDisposable_PrimaryDisposesFirst),
    ("testSingleAssignmentDisposable_firstDisposedThenSet", DisposableTest.testSingleAssignmentDisposable_firstDisposedThenSet),
    ("testSingleAssignmentDisposable_firstSetThenDisposed", DisposableTest.testSingleAssignmentDisposable_firstSetThenDisposed),
    ("testSingleAssignmentDisposable_stress", DisposableTest.testSingleAssignmentDisposable_stress),
    ] }
}

final class HistoricalSchedulerTest_ : HistoricalSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (HistoricalSchedulerTest_) -> () -> ())] { return [
    ("testHistoricalScheduler_initialClock", HistoricalSchedulerTest.testHistoricalScheduler_initialClock),
    ("testHistoricalScheduler_start", HistoricalSchedulerTest.testHistoricalScheduler_start),
    ("testHistoricalScheduler_disposeStart", HistoricalSchedulerTest.testHistoricalScheduler_disposeStart),
    ("testHistoricalScheduler_advanceToAfter", HistoricalSchedulerTest.testHistoricalScheduler_advanceToAfter),
    ("testHistoricalScheduler_advanceToBefore", HistoricalSchedulerTest.testHistoricalScheduler_advanceToBefore),
    ("testHistoricalScheduler_disposeAdvanceTo", HistoricalSchedulerTest.testHistoricalScheduler_disposeAdvanceTo),
    ("testHistoricalScheduler_stop", HistoricalSchedulerTest.testHistoricalScheduler_stop),
    ("testHistoricalScheduler_sleep", HistoricalSchedulerTest.testHistoricalScheduler_sleep),
    ] }
}

final class MainSchedulerTest_ : MainSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (MainSchedulerTest_) -> () -> ())] { return [
    ("testMainScheduler_basicScenario", MainSchedulerTest.testMainScheduler_basicScenario),
    ("testMainScheduler_disposing1", MainSchedulerTest.testMainScheduler_disposing1),
    ("testMainScheduler_disposing2", MainSchedulerTest.testMainScheduler_disposing2),
    ] }
}

final class ObserverTests_ : ObserverTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObserverTests_) -> () -> ())] { return [
    ("testConvenienceOn_Next", ObserverTests.testConvenienceOn_Next),
    ("testConvenienceOn_Error", ObserverTests.testConvenienceOn_Error),
    ("testConvenienceOn_Complete", ObserverTests.testConvenienceOn_Complete),
    ("testMapElement", ObserverTests.testMapElement),
    ("testMapElementCompleted", ObserverTests.testMapElementCompleted),
    ("testMapElementError", ObserverTests.testMapElementError),
    ("testMapElementThrow", ObserverTests.testMapElementThrow),
    ] }
}

final class RecursiveLockTests_ : RecursiveLockTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (RecursiveLockTests_) -> () -> ())] { return [
    ("testSynchronizes", RecursiveLockTests.testSynchronizes),
    ("testIsReentrant", RecursiveLockTests.testIsReentrant),
    ] }
}

final class QueueTest_ : QueueTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (QueueTest_) -> () -> ())] { return [
    ("testComplexity", QueueTest.testComplexity),
    ] }
}

final class ConcurrentDispatchQueueSchedulerTests_ : ConcurrentDispatchQueueSchedulerTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ConcurrentDispatchQueueSchedulerTests_) -> () -> ())] { return [
    ("test_scheduleRelative", ConcurrentDispatchQueueSchedulerTests.test_scheduleRelative),
    ("test_scheduleRelativeCancel", ConcurrentDispatchQueueSchedulerTests.test_scheduleRelativeCancel),
    ("test_schedulePeriodic", ConcurrentDispatchQueueSchedulerTests.test_schedulePeriodic),
    ("test_schedulePeriodicCancel", ConcurrentDispatchQueueSchedulerTests.test_schedulePeriodicCancel),
    ] }
}

final class ObservableMultipleTest_ : ObservableMultipleTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableMultipleTest_) -> () -> ())] { return [
    ("testCombineLatest_NeverEmpty", ObservableMultipleTest.testCombineLatest_NeverEmpty),
    ("testCombineLatest_EmptyNever", ObservableMultipleTest.testCombineLatest_EmptyNever),
    ("testCombineLatest_EmptyReturn", ObservableMultipleTest.testCombineLatest_EmptyReturn),
    ("testCombineLatest_ReturnEmpty", ObservableMultipleTest.testCombineLatest_ReturnEmpty),
    ("testCombineLatest_NeverReturn", ObservableMultipleTest.testCombineLatest_NeverReturn),
    ("testCombineLatest_ReturnNever", ObservableMultipleTest.testCombineLatest_ReturnNever),
    ("testCombineLatest_ReturnReturn1", ObservableMultipleTest.testCombineLatest_ReturnReturn1),
    ("testCombineLatest_ReturnReturn2", ObservableMultipleTest.testCombineLatest_ReturnReturn2),
    ("testCombineLatest_EmptyError", ObservableMultipleTest.testCombineLatest_EmptyError),
    ("testCombineLatest_ErrorEmpty", ObservableMultipleTest.testCombineLatest_ErrorEmpty),
    ("testCombineLatest_ReturnThrow", ObservableMultipleTest.testCombineLatest_ReturnThrow),
    ("testCombineLatest_ThrowReturn", ObservableMultipleTest.testCombineLatest_ThrowReturn),
    ("testCombineLatest_ThrowThrow1", ObservableMultipleTest.testCombineLatest_ThrowThrow1),
    ("testCombineLatest_ThrowThrow2", ObservableMultipleTest.testCombineLatest_ThrowThrow2),
    ("testCombineLatest_ErrorThrow", ObservableMultipleTest.testCombineLatest_ErrorThrow),
    ("testCombineLatest_ThrowError", ObservableMultipleTest.testCombineLatest_ThrowError),
    ("testCombineLatest_SomeThrow", ObservableMultipleTest.testCombineLatest_SomeThrow),
    ("testCombineLatest_ThrowSome", ObservableMultipleTest.testCombineLatest_ThrowSome),
    ("testCombineLatest_ThrowAfterCompleteLeft", ObservableMultipleTest.testCombineLatest_ThrowAfterCompleteLeft),
    ("testCombineLatest_ThrowAfterCompleteRight", ObservableMultipleTest.testCombineLatest_ThrowAfterCompleteRight),
    ("testCombineLatest_TestInterleavedWithTail", ObservableMultipleTest.testCombineLatest_TestInterleavedWithTail),
    ("testCombineLatest_Consecutive", ObservableMultipleTest.testCombineLatest_Consecutive),
    ("testCombineLatest_ConsecutiveEndWithErrorLeft", ObservableMultipleTest.testCombineLatest_ConsecutiveEndWithErrorLeft),
    ("testCombineLatest_ConsecutiveEndWithErrorRight", ObservableMultipleTest.testCombineLatest_ConsecutiveEndWithErrorRight),
    ("testCombineLatest_Never2", ObservableMultipleTest.testCombineLatest_Never2),
    ("testCombineLatest_Empty2", ObservableMultipleTest.testCombineLatest_Empty2),
    ("testCombineLatest_SelectorThrows2", ObservableMultipleTest.testCombineLatest_SelectorThrows2),
    ("testCombineLatest_WillNeverBeAbleToCombine2", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine2),
    ("testCombineLatest_Typical2", ObservableMultipleTest.testCombineLatest_Typical2),
    ("testCombineLatest_Never3", ObservableMultipleTest.testCombineLatest_Never3),
    ("testCombineLatest_Empty3", ObservableMultipleTest.testCombineLatest_Empty3),
    ("testCombineLatest_SelectorThrows3", ObservableMultipleTest.testCombineLatest_SelectorThrows3),
    ("testCombineLatest_WillNeverBeAbleToCombine3", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine3),
    ("testCombineLatest_Typical3", ObservableMultipleTest.testCombineLatest_Typical3),
    ("testCombineLatest_Never4", ObservableMultipleTest.testCombineLatest_Never4),
    ("testCombineLatest_Empty4", ObservableMultipleTest.testCombineLatest_Empty4),
    ("testCombineLatest_SelectorThrows4", ObservableMultipleTest.testCombineLatest_SelectorThrows4),
    ("testCombineLatest_WillNeverBeAbleToCombine4", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine4),
    ("testCombineLatest_Typical4", ObservableMultipleTest.testCombineLatest_Typical4),
    ("testCombineLatest_Never5", ObservableMultipleTest.testCombineLatest_Never5),
    ("testCombineLatest_Empty5", ObservableMultipleTest.testCombineLatest_Empty5),
    ("testCombineLatest_SelectorThrows5", ObservableMultipleTest.testCombineLatest_SelectorThrows5),
    ("testCombineLatest_WillNeverBeAbleToCombine5", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine5),
    ("testCombineLatest_Typical5", ObservableMultipleTest.testCombineLatest_Typical5),
    ("testCombineLatest_Never6", ObservableMultipleTest.testCombineLatest_Never6),
    ("testCombineLatest_Empty6", ObservableMultipleTest.testCombineLatest_Empty6),
    ("testCombineLatest_SelectorThrows6", ObservableMultipleTest.testCombineLatest_SelectorThrows6),
    ("testCombineLatest_WillNeverBeAbleToCombine6", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine6),
    ("testCombineLatest_Typical6", ObservableMultipleTest.testCombineLatest_Typical6),
    ("testCombineLatest_Never7", ObservableMultipleTest.testCombineLatest_Never7),
    ("testCombineLatest_Empty7", ObservableMultipleTest.testCombineLatest_Empty7),
    ("testCombineLatest_SelectorThrows7", ObservableMultipleTest.testCombineLatest_SelectorThrows7),
    ("testCombineLatest_WillNeverBeAbleToCombine7", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine7),
    ("testCombineLatest_Typical7", ObservableMultipleTest.testCombineLatest_Typical7),
    ("testCombineLatest_Never8", ObservableMultipleTest.testCombineLatest_Never8),
    ("testCombineLatest_Empty8", ObservableMultipleTest.testCombineLatest_Empty8),
    ("testCombineLatest_SelectorThrows8", ObservableMultipleTest.testCombineLatest_SelectorThrows8),
    ("testCombineLatest_WillNeverBeAbleToCombine8", ObservableMultipleTest.testCombineLatest_WillNeverBeAbleToCombine8),
    ("testCombineLatest_Typical8", ObservableMultipleTest.testCombineLatest_Typical8),
    ("testZip_NeverEmpty", ObservableMultipleTest.testZip_NeverEmpty),
    ("testZip_EmptyNever", ObservableMultipleTest.testZip_EmptyNever),
    ("testZip_EmptyNonEmpty", ObservableMultipleTest.testZip_EmptyNonEmpty),
    ("testZip_NonEmptyEmpty", ObservableMultipleTest.testZip_NonEmptyEmpty),
    ("testZip_NeverNonEmpty", ObservableMultipleTest.testZip_NeverNonEmpty),
    ("testZip_NonEmptyNever", ObservableMultipleTest.testZip_NonEmptyNever),
    ("testZip_NonEmptyNonEmpty", ObservableMultipleTest.testZip_NonEmptyNonEmpty),
    ("testZip_EmptyError", ObservableMultipleTest.testZip_EmptyError),
    ("testZip_ErrorEmpty", ObservableMultipleTest.testZip_ErrorEmpty),
    ("testZip_NeverError", ObservableMultipleTest.testZip_NeverError),
    ("testZip_ErrorNever", ObservableMultipleTest.testZip_ErrorNever),
    ("testZip_ErrorError", ObservableMultipleTest.testZip_ErrorError),
    ("testZip_SomeError", ObservableMultipleTest.testZip_SomeError),
    ("testZip_ErrorSome", ObservableMultipleTest.testZip_ErrorSome),
    ("testZip_LeftCompletesFirst", ObservableMultipleTest.testZip_LeftCompletesFirst),
    ("testZip_RightCompletesFirst", ObservableMultipleTest.testZip_RightCompletesFirst),
    ("testZip_LeftTriggersSelectorError", ObservableMultipleTest.testZip_LeftTriggersSelectorError),
    ("testZip_RightTriggersSelectorError", ObservableMultipleTest.testZip_RightTriggersSelectorError),
    ("testZip_ImmediateSchedule2", ObservableMultipleTest.testZip_ImmediateSchedule2),
    ("testZip_Never2", ObservableMultipleTest.testZip_Never2),
    ("testZip_Empty2", ObservableMultipleTest.testZip_Empty2),
    ("testZip_SymmetricReturn2", ObservableMultipleTest.testZip_SymmetricReturn2),
    ("testZip_AllCompleted2", ObservableMultipleTest.testZip_AllCompleted2),
    ("testZip_ImmediateSchedule3", ObservableMultipleTest.testZip_ImmediateSchedule3),
    ("testZip_Never3", ObservableMultipleTest.testZip_Never3),
    ("testZip_Empty3", ObservableMultipleTest.testZip_Empty3),
    ("testZip_SymmetricReturn3", ObservableMultipleTest.testZip_SymmetricReturn3),
    ("testZip_AllCompleted3", ObservableMultipleTest.testZip_AllCompleted3),
    ("testZip_ImmediateSchedule4", ObservableMultipleTest.testZip_ImmediateSchedule4),
    ("testZip_Never4", ObservableMultipleTest.testZip_Never4),
    ("testZip_Empty4", ObservableMultipleTest.testZip_Empty4),
    ("testZip_SymmetricReturn4", ObservableMultipleTest.testZip_SymmetricReturn4),
    ("testZip_AllCompleted4", ObservableMultipleTest.testZip_AllCompleted4),
    ("testZip_ImmediateSchedule5", ObservableMultipleTest.testZip_ImmediateSchedule5),
    ("testZip_Never5", ObservableMultipleTest.testZip_Never5),
    ("testZip_Empty5", ObservableMultipleTest.testZip_Empty5),
    ("testZip_SymmetricReturn5", ObservableMultipleTest.testZip_SymmetricReturn5),
    ("testZip_AllCompleted5", ObservableMultipleTest.testZip_AllCompleted5),
    ("testZip_ImmediateSchedule6", ObservableMultipleTest.testZip_ImmediateSchedule6),
    ("testZip_Never6", ObservableMultipleTest.testZip_Never6),
    ("testZip_Empty6", ObservableMultipleTest.testZip_Empty6),
    ("testZip_SymmetricReturn6", ObservableMultipleTest.testZip_SymmetricReturn6),
    ("testZip_AllCompleted6", ObservableMultipleTest.testZip_AllCompleted6),
    ("testZip_ImmediateSchedule7", ObservableMultipleTest.testZip_ImmediateSchedule7),
    ("testZip_Never7", ObservableMultipleTest.testZip_Never7),
    ("testZip_Empty7", ObservableMultipleTest.testZip_Empty7),
    ("testZip_SymmetricReturn7", ObservableMultipleTest.testZip_SymmetricReturn7),
    ("testZip_AllCompleted7", ObservableMultipleTest.testZip_AllCompleted7),
    ("testZip_ImmediateSchedule8", ObservableMultipleTest.testZip_ImmediateSchedule8),
    ("testZip_Never8", ObservableMultipleTest.testZip_Never8),
    ("testZip_Empty8", ObservableMultipleTest.testZip_Empty8),
    ("testZip_SymmetricReturn8", ObservableMultipleTest.testZip_SymmetricReturn8),
    ("testZip_AllCompleted8", ObservableMultipleTest.testZip_AllCompleted8),
    ("testCatch_ErrorSpecific_Caught", ObservableMultipleTest.testCatch_ErrorSpecific_Caught),
    ("testCatch_HandlerThrows", ObservableMultipleTest.testCatch_HandlerThrows),
    ("testCatchSequenceOf_IEofIO", ObservableMultipleTest.testCatchSequenceOf_IEofIO),
    ("testCatchAnySequence_NoErrors", ObservableMultipleTest.testCatchAnySequence_NoErrors),
    ("testCatchAnySequence_Never", ObservableMultipleTest.testCatchAnySequence_Never),
    ("testCatchAnySequence_Empty", ObservableMultipleTest.testCatchAnySequence_Empty),
    ("testCatchSequenceOf_Error", ObservableMultipleTest.testCatchSequenceOf_Error),
    ("testCatchSequenceOf_ErrorNever", ObservableMultipleTest.testCatchSequenceOf_ErrorNever),
    ("testCatchSequenceOf_ErrorError", ObservableMultipleTest.testCatchSequenceOf_ErrorError),
    ("testCatchSequenceOf_Multiple", ObservableMultipleTest.testCatchSequenceOf_Multiple),
    ("testSwitch_Data", ObservableMultipleTest.testSwitch_Data),
    ("testSwitch_InnerThrows", ObservableMultipleTest.testSwitch_InnerThrows),
    ("testSwitch_OuterThrows", ObservableMultipleTest.testSwitch_OuterThrows),
    ("testSwitchIfEmpty_SourceNotEmpty_SwitchCompletes", ObservableMultipleTest.testSwitchIfEmpty_SourceNotEmpty_SwitchCompletes),
    ("testSwitchIfEmpty_SourceNotEmptyError_SwitchCompletes", ObservableMultipleTest.testSwitchIfEmpty_SourceNotEmptyError_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmptyError_SwitchCompletes", ObservableMultipleTest.testSwitchIfEmpty_SourceEmptyError_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmpty_SwitchCompletes", ObservableMultipleTest.testSwitchIfEmpty_SourceEmpty_SwitchCompletes),
    ("testSwitchIfEmpty_SourceEmpty_SwitchError", ObservableMultipleTest.testSwitchIfEmpty_SourceEmpty_SwitchError),
    ("testSwitchIfEmpty_Never", ObservableMultipleTest.testSwitchIfEmpty_Never),
    ("testFlatMapLatest_Data", ObservableMultipleTest.testFlatMapLatest_Data),
    ("testFlatMapLatest_InnerThrows", ObservableMultipleTest.testFlatMapLatest_InnerThrows),
    ("testFlatMapLatest_OuterThrows", ObservableMultipleTest.testFlatMapLatest_OuterThrows),
    ("testFlatMapLatest_SelectorThrows", ObservableMultipleTest.testFlatMapLatest_SelectorThrows),
    ("testConcat_DefaultScheduler", ObservableMultipleTest.testConcat_DefaultScheduler),
    ("testConcat_IEofIO", ObservableMultipleTest.testConcat_IEofIO),
    ("testConcat_EmptyEmpty", ObservableMultipleTest.testConcat_EmptyEmpty),
    ("testConcat_EmptyNever", ObservableMultipleTest.testConcat_EmptyNever),
    ("testConcat_NeverNever", ObservableMultipleTest.testConcat_NeverNever),
    ("testConcat_EmptyThrow", ObservableMultipleTest.testConcat_EmptyThrow),
    ("testConcat_ThrowEmpty", ObservableMultipleTest.testConcat_ThrowEmpty),
    ("testConcat_ThrowThrow", ObservableMultipleTest.testConcat_ThrowThrow),
    ("testConcat_ReturnEmpty", ObservableMultipleTest.testConcat_ReturnEmpty),
    ("testConcat_EmptyReturn", ObservableMultipleTest.testConcat_EmptyReturn),
    ("testConcat_ReturnNever", ObservableMultipleTest.testConcat_ReturnNever),
    ("testConcat_NeverReturn", ObservableMultipleTest.testConcat_NeverReturn),
    ("testConcat_ReturnReturn", ObservableMultipleTest.testConcat_ReturnReturn),
    ("testConcat_ThrowReturn", ObservableMultipleTest.testConcat_ThrowReturn),
    ("testConcat_ReturnThrow", ObservableMultipleTest.testConcat_ReturnThrow),
    ("testConcat_SomeDataSomeData", ObservableMultipleTest.testConcat_SomeDataSomeData),
    ("testConcat_EnumerableTiming", ObservableMultipleTest.testConcat_EnumerableTiming),
    ("testConcat_variadicElementsOverload", ObservableMultipleTest.testConcat_variadicElementsOverload),
    ("testMerge_DeadlockSimple", ObservableMultipleTest.testMerge_DeadlockSimple),
    ("testMerge_DeadlockErrorAfterN", ObservableMultipleTest.testMerge_DeadlockErrorAfterN),
    ("testMerge_DeadlockErrorImmediatelly", ObservableMultipleTest.testMerge_DeadlockErrorImmediatelly),
    ("testMerge_DeadlockEmpty", ObservableMultipleTest.testMerge_DeadlockEmpty),
    ("testMerge_DeadlockFirstEmpty", ObservableMultipleTest.testMerge_DeadlockFirstEmpty),
    ("testMergeConcurrent_DeadlockSimple", ObservableMultipleTest.testMergeConcurrent_DeadlockSimple),
    ("testMergeConcurrent_DeadlockErrorAfterN", ObservableMultipleTest.testMergeConcurrent_DeadlockErrorAfterN),
    ("testMergeConcurrent_DeadlockErrorImmediatelly", ObservableMultipleTest.testMergeConcurrent_DeadlockErrorImmediatelly),
    ("testMergeConcurrent_DeadlockEmpty", ObservableMultipleTest.testMergeConcurrent_DeadlockEmpty),
    ("testMergeConcurrent_DeadlockFirstEmpty", ObservableMultipleTest.testMergeConcurrent_DeadlockFirstEmpty),
    ("testMerge_ObservableOfObservable_Data", ObservableMultipleTest.testMerge_ObservableOfObservable_Data),
    ("testMerge_ObservableOfObservable_Data_NotOverlapped", ObservableMultipleTest.testMerge_ObservableOfObservable_Data_NotOverlapped),
    ("testMerge_ObservableOfObservable_InnerThrows", ObservableMultipleTest.testMerge_ObservableOfObservable_InnerThrows),
    ("testMerge_ObservableOfObservable_OuterThrows", ObservableMultipleTest.testMerge_ObservableOfObservable_OuterThrows),
    ("testMerge_MergeConcat_Basic", ObservableMultipleTest.testMerge_MergeConcat_Basic),
    ("testMerge_MergeConcat_BasicLong", ObservableMultipleTest.testMerge_MergeConcat_BasicLong),
    ("testMerge_MergeConcat_BasicWide", ObservableMultipleTest.testMerge_MergeConcat_BasicWide),
    ("testMerge_MergeConcat_BasicLate", ObservableMultipleTest.testMerge_MergeConcat_BasicLate),
    ("testMerge_MergeConcat_Disposed", ObservableMultipleTest.testMerge_MergeConcat_Disposed),
    ("testMerge_MergeConcat_OuterError", ObservableMultipleTest.testMerge_MergeConcat_OuterError),
    ("testMerge_MergeConcat_InnerError", ObservableMultipleTest.testMerge_MergeConcat_InnerError),
    ("testMergeSync_Empty", ObservableMultipleTest.testMergeSync_Empty),
    ("testMergeSync_Data", ObservableMultipleTest.testMergeSync_Data),
    ("testMergeSync_ObservableOfObservable_InnerThrows", ObservableMultipleTest.testMergeSync_ObservableOfObservable_InnerThrows),
    ("testCombineLatest_DeadlockErrorAfterN", ObservableMultipleTest.testCombineLatest_DeadlockErrorAfterN),
    ("testCombineLatest_DeadlockErrorImmediatelly", ObservableMultipleTest.testCombineLatest_DeadlockErrorImmediatelly),
    ("testReplay_DeadlockEmpty", ObservableMultipleTest.testReplay_DeadlockEmpty),
    ("testTakeUntil_Preempt_SomeData_Next", ObservableMultipleTest.testTakeUntil_Preempt_SomeData_Next),
    ("testTakeUntil_Preempt_SomeData_Error", ObservableMultipleTest.testTakeUntil_Preempt_SomeData_Error),
    ("testTakeUntil_NoPreempt_SomeData_Empty", ObservableMultipleTest.testTakeUntil_NoPreempt_SomeData_Empty),
    ("testTakeUntil_NoPreempt_SomeData_Never", ObservableMultipleTest.testTakeUntil_NoPreempt_SomeData_Never),
    ("testTakeUntil_Preempt_Never_Next", ObservableMultipleTest.testTakeUntil_Preempt_Never_Next),
    ("testTakeUntil_Preempt_Never_Error", ObservableMultipleTest.testTakeUntil_Preempt_Never_Error),
    ("testTakeUntil_NoPreempt_Never_Empty", ObservableMultipleTest.testTakeUntil_NoPreempt_Never_Empty),
    ("testTakeUntil_NoPreempt_Never_Never", ObservableMultipleTest.testTakeUntil_NoPreempt_Never_Never),
    ("testTakeUntil_Preempt_BeforeFirstProduced", ObservableMultipleTest.testTakeUntil_Preempt_BeforeFirstProduced),
    ("testTakeUntil_Preempt_BeforeFirstProduced_RemainSilentAndProperDisposed", ObservableMultipleTest.testTakeUntil_Preempt_BeforeFirstProduced_RemainSilentAndProperDisposed),
    ("testTakeUntil_NoPreempt_AfterLastProduced_ProperDisposedSigna", ObservableMultipleTest.testTakeUntil_NoPreempt_AfterLastProduced_ProperDisposedSigna),
    ("testTakeUntil_Error_Some", ObservableMultipleTest.testTakeUntil_Error_Some),
    ("testAmb_Never2", ObservableMultipleTest.testAmb_Never2),
    ("testAmb_Never3", ObservableMultipleTest.testAmb_Never3),
    ("testAmb_Never_Empty", ObservableMultipleTest.testAmb_Never_Empty),
    ("testAmb_RegularShouldDisposeLoser", ObservableMultipleTest.testAmb_RegularShouldDisposeLoser),
    ("testAmb_WinnerThrows", ObservableMultipleTest.testAmb_WinnerThrows),
    ("testAmb_LoserThrows", ObservableMultipleTest.testAmb_LoserThrows),
    ("testAmb_ThrowsBeforeElectionLeft", ObservableMultipleTest.testAmb_ThrowsBeforeElectionLeft),
    ("testAmb_ThrowsBeforeElectionRight", ObservableMultipleTest.testAmb_ThrowsBeforeElectionRight),
    ("testCombineLatest_NeverN", ObservableMultipleTest.testCombineLatest_NeverN),
    ("testCombineLatest_NeverEmptyN", ObservableMultipleTest.testCombineLatest_NeverEmptyN),
    ("testCombineLatest_EmptyNeverN", ObservableMultipleTest.testCombineLatest_EmptyNeverN),
    ("testCombineLatest_EmptyReturnN", ObservableMultipleTest.testCombineLatest_EmptyReturnN),
    ("testCombineLatest_ReturnReturnN", ObservableMultipleTest.testCombineLatest_ReturnReturnN),
    ("testCombineLatest_EmptyErrorN", ObservableMultipleTest.testCombineLatest_EmptyErrorN),
    ("testCombineLatest_ReturnErrorN", ObservableMultipleTest.testCombineLatest_ReturnErrorN),
    ("testCombineLatest_ErrorErrorN", ObservableMultipleTest.testCombineLatest_ErrorErrorN),
    ("testCombineLatest_NeverErrorN", ObservableMultipleTest.testCombineLatest_NeverErrorN),
    ("testCombineLatest_SomeErrorN", ObservableMultipleTest.testCombineLatest_SomeErrorN),
    ("testCombineLatest_ErrorAfterCompletedN", ObservableMultipleTest.testCombineLatest_ErrorAfterCompletedN),
    ("testCombineLatest_InterleavedWithTailN", ObservableMultipleTest.testCombineLatest_InterleavedWithTailN),
    ("testCombineLatest_ConsecutiveN", ObservableMultipleTest.testCombineLatest_ConsecutiveN),
    ("testCombineLatest_ConsecutiveNWithErrorLeft", ObservableMultipleTest.testCombineLatest_ConsecutiveNWithErrorLeft),
    ("testCombineLatest_ConsecutiveNWithErrorRight", ObservableMultipleTest.testCombineLatest_ConsecutiveNWithErrorRight),
    ("testCombineLatest_SelectorThrowsN", ObservableMultipleTest.testCombineLatest_SelectorThrowsN),
    ("testCombineLatest_willNeverBeAbleToCombineN", ObservableMultipleTest.testCombineLatest_willNeverBeAbleToCombineN),
    ("testCombineLatest_typicalN", ObservableMultipleTest.testCombineLatest_typicalN),
    ("testCombineLatest_NAry_symmetric", ObservableMultipleTest.testCombineLatest_NAry_symmetric),
    ("testCombineLatest_NAry_asymmetric", ObservableMultipleTest.testCombineLatest_NAry_asymmetric),
    ("testZip_NAry_symmetric", ObservableMultipleTest.testZip_NAry_symmetric),
    ("testZip_NAry_asymmetric", ObservableMultipleTest.testZip_NAry_asymmetric),
    ("testZip_NAry_error", ObservableMultipleTest.testZip_NAry_error),
    ("testZip_NAry_atLeastOneErrors4", ObservableMultipleTest.testZip_NAry_atLeastOneErrors4),
    ("testSkipUntil_SomeData_Next", ObservableMultipleTest.testSkipUntil_SomeData_Next),
    ("testSkipUntil_SomeData_Error", ObservableMultipleTest.testSkipUntil_SomeData_Error),
    ("testSkipUntil_Error_SomeData", ObservableMultipleTest.testSkipUntil_Error_SomeData),
    ("testSkipUntil_SomeData_Empty", ObservableMultipleTest.testSkipUntil_SomeData_Empty),
    ("testSkipUntil_Never_Next", ObservableMultipleTest.testSkipUntil_Never_Next),
    ("testSkipUntil_Never_Error1", ObservableMultipleTest.testSkipUntil_Never_Error1),
    ("testSkipUntil_SomeData_Error2", ObservableMultipleTest.testSkipUntil_SomeData_Error2),
    ("testSkipUntil_SomeData_Never", ObservableMultipleTest.testSkipUntil_SomeData_Never),
    ("testSkipUntil_Never_Empty", ObservableMultipleTest.testSkipUntil_Never_Empty),
    ("testSkipUntil_Never_Never", ObservableMultipleTest.testSkipUntil_Never_Never),
    ("testSkipUntil_HasCompletedCausesDisposal", ObservableMultipleTest.testSkipUntil_HasCompletedCausesDisposal),
    ("testWithLatestFrom_Simple1", ObservableMultipleTest.testWithLatestFrom_Simple1),
    ("testWithLatestFrom_TwoObservablesWithImmediateValues", ObservableMultipleTest.testWithLatestFrom_TwoObservablesWithImmediateValues),
    ("testWithLatestFrom_Simple2", ObservableMultipleTest.testWithLatestFrom_Simple2),
    ("testWithLatestFrom_Simple3", ObservableMultipleTest.testWithLatestFrom_Simple3),
    ("testWithLatestFrom_Error1", ObservableMultipleTest.testWithLatestFrom_Error1),
    ("testWithLatestFrom_Error2", ObservableMultipleTest.testWithLatestFrom_Error2),
    ("testWithLatestFrom_Error3", ObservableMultipleTest.testWithLatestFrom_Error3),
    ("testWithLatestFrom_MakeSureDefaultOverloadTakesSecondSequenceValues", ObservableMultipleTest.testWithLatestFrom_MakeSureDefaultOverloadTakesSecondSequenceValues),
    ] }
}

final class ObservableCreationTests_ : ObservableCreationTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableCreationTests_) -> () -> ())] { return [
    ("testJust_Immediate", ObservableCreationTests.testJust_Immediate),
    ("testJust_Basic", ObservableCreationTests.testJust_Basic),
    ("testJust_Disposed", ObservableCreationTests.testJust_Disposed),
    ("testJust_DisposeAfterNext", ObservableCreationTests.testJust_DisposeAfterNext),
    ("testJust_DefaultScheduler", ObservableCreationTests.testJust_DefaultScheduler),
    ("testJust_CompilesInMap", ObservableCreationTests.testJust_CompilesInMap),
    ("testFromArray_complete_immediate", ObservableCreationTests.testFromArray_complete_immediate),
    ("testFromArray_complete", ObservableCreationTests.testFromArray_complete),
    ("testFromArray_dispose", ObservableCreationTests.testFromArray_dispose),
    ("testSequenceOf_complete_immediate", ObservableCreationTests.testSequenceOf_complete_immediate),
    ("testSequenceOf_complete", ObservableCreationTests.testSequenceOf_complete),
    ("testSequenceOf_dispose", ObservableCreationTests.testSequenceOf_dispose),
    ("testFromAnySequence_basic_immediate", ObservableCreationTests.testFromAnySequence_basic_immediate),
    ("testToObservableAnySequence_basic_testScheduler", ObservableCreationTests.testToObservableAnySequence_basic_testScheduler),
    ("testToObservableOptionalSome_immediate", ObservableCreationTests.testToObservableOptionalSome_immediate),
    ("testToObservableOptionalNone_immediate", ObservableCreationTests.testToObservableOptionalNone_immediate),
    ("testToObservableOptionalSome_basic_testScheduler", ObservableCreationTests.testToObservableOptionalSome_basic_testScheduler),
    ("testToObservableOptionalNone_basic_testScheduler", ObservableCreationTests.testToObservableOptionalNone_basic_testScheduler),
    ("testGenerate_Finite", ObservableCreationTests.testGenerate_Finite),
    ("testGenerate_ThrowCondition", ObservableCreationTests.testGenerate_ThrowCondition),
    ("testGenerate_ThrowIterate", ObservableCreationTests.testGenerate_ThrowIterate),
    ("testGenerate_Dispose", ObservableCreationTests.testGenerate_Dispose),
    ("testGenerate_take", ObservableCreationTests.testGenerate_take),
    ("testRange_Boundaries", ObservableCreationTests.testRange_Boundaries),
    ("testRange_Dispose", ObservableCreationTests.testRange_Dispose),
    ("testRepeat_Element", ObservableCreationTests.testRepeat_Element),
    ("testUsing_Complete", ObservableCreationTests.testUsing_Complete),
    ("testUsing_Error", ObservableCreationTests.testUsing_Error),
    ("testUsing_Dispose", ObservableCreationTests.testUsing_Dispose),
    ("testUsing_ThrowResourceSelector", ObservableCreationTests.testUsing_ThrowResourceSelector),
    ("testUsing_ThrowResourceUsage", ObservableCreationTests.testUsing_ThrowResourceUsage),
    ] }
}

final class BehaviorSubjectTest_ : BehaviorSubjectTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (BehaviorSubjectTest_) -> () -> ())] { return [
    ("test_Infinite", BehaviorSubjectTest.test_Infinite),
    ("test_Finite", BehaviorSubjectTest.test_Finite),
    ("test_Error", BehaviorSubjectTest.test_Error),
    ("test_Canceled", BehaviorSubjectTest.test_Canceled),
    ("test_hasObserversNoObservers", BehaviorSubjectTest.test_hasObserversNoObservers),
    ("test_hasObserversOneObserver", BehaviorSubjectTest.test_hasObserversOneObserver),
    ("test_hasObserversManyObserver", BehaviorSubjectTest.test_hasObserversManyObserver),
    ] }
}

final class ObservableDebugTest_ : ObservableDebugTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableDebugTest_) -> () -> ())] { return [
    ("testDebug_Completed", ObservableDebugTest.testDebug_Completed),
    ("testDebug_Error", ObservableDebugTest.testDebug_Error),
    ] }
}

final class ObservableConcurrentSchedulerConcurrencyTest_ : ObservableConcurrentSchedulerConcurrencyTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (ObservableConcurrentSchedulerConcurrencyTest_) -> () -> ())] { return [
    ("testObserveOn_EnsureTestsAreExecutedWithRealConcurrentScheduler", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_EnsureTestsAreExecutedWithRealConcurrentScheduler),
    ("testObserveOn_Never", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_Never),
    ("testObserveOn_Simple", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_Simple),
    ("testObserveOn_Empty", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_Empty),
    ("testObserveOn_ConcurrentSchedulerIsSerialized", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_ConcurrentSchedulerIsSerialized),
    ("testObserveOn_Error", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_Error),
    ("testObserveOn_Dispose", ObservableConcurrentSchedulerConcurrencyTest.testObserveOn_Dispose),
    ] }
}

final class AnonymousObservableTests_ : AnonymousObservableTests, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (AnonymousObservableTests_) -> () -> ())] { return [
    ("testAnonymousObservable_detachesOnDispose", AnonymousObservableTests.testAnonymousObservable_detachesOnDispose),
    ("testAnonymousObservable_detachesOnComplete", AnonymousObservableTests.testAnonymousObservable_detachesOnComplete),
    ("testAnonymousObservable_detachesOnError", AnonymousObservableTests.testAnonymousObservable_detachesOnError),
    ] }
}

final class DriverTest_ : DriverTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (DriverTest_) -> () -> ())] { return [
    ("testDriverSharing_WhenErroring", DriverTest.testDriverSharing_WhenErroring),
    ("testDriverSharing_WhenCompleted", DriverTest.testDriverSharing_WhenCompleted),
    ("testVariableAsDriver", DriverTest.testVariableAsDriver),
    ("testAsDriver_onErrorJustReturn", DriverTest.testAsDriver_onErrorJustReturn),
    ("testAsDriver_onErrorDriveWith", DriverTest.testAsDriver_onErrorDriveWith),
    ("testAsDriver_onErrorRecover", DriverTest.testAsDriver_onErrorRecover),
    ("testAsDriver_deferred", DriverTest.testAsDriver_deferred),
    ("testAsDriver_map", DriverTest.testAsDriver_map),
    ("testAsDriver_filter", DriverTest.testAsDriver_filter),
    ("testAsDriver_switchLatest", DriverTest.testAsDriver_switchLatest),
    ("testAsDriver_flatMapLatest", DriverTest.testAsDriver_flatMapLatest),
    ("testAsDriver_flatMapFirst", DriverTest.testAsDriver_flatMapFirst),
    ("testAsDriver_doOn", DriverTest.testAsDriver_doOn),
    ("testAsDriver_doOnNext", DriverTest.testAsDriver_doOnNext),
    ("testAsDriver_doOnCompleted", DriverTest.testAsDriver_doOnCompleted),
    ("testAsDriver_distinctUntilChanged1", DriverTest.testAsDriver_distinctUntilChanged1),
    ("testAsDriver_distinctUntilChanged2", DriverTest.testAsDriver_distinctUntilChanged2),
    ("testAsDriver_distinctUntilChanged3", DriverTest.testAsDriver_distinctUntilChanged3),
    ("testAsDriver_distinctUntilChanged4", DriverTest.testAsDriver_distinctUntilChanged4),
    ("testAsDriver_flatMap", DriverTest.testAsDriver_flatMap),
    ("testAsDriver_mergeSync", DriverTest.testAsDriver_mergeSync),
    ("testAsDriver_merge", DriverTest.testAsDriver_merge),
    ("testAsDriver_merge2", DriverTest.testAsDriver_merge2),
    ("testAsDriver_debounce", DriverTest.testAsDriver_debounce),
    ("testAsDriver_throttle", DriverTest.testAsDriver_throttle),
    ("testAsDriver_scan", DriverTest.testAsDriver_scan),
    ("testAsDriver_concat_sequenceType", DriverTest.testAsDriver_concat_sequenceType),
    ("testAsDriver_concat", DriverTest.testAsDriver_concat),
    ("testAsDriver_combineLatest_array", DriverTest.testAsDriver_combineLatest_array),
    ("testAsDriver_combineLatest", DriverTest.testAsDriver_combineLatest),
    ("testAsDriver_zip_array", DriverTest.testAsDriver_zip_array),
    ("testAsDriver_zip", DriverTest.testAsDriver_zip),
    ("testAsDriver_withLatestFrom", DriverTest.testAsDriver_withLatestFrom),
    ("testAsDriver_withLatestFromDefaultOverload", DriverTest.testAsDriver_withLatestFromDefaultOverload),
    ("testAsDriver_skip", DriverTest.testAsDriver_skip),
    ("testAsDriver_startWith", DriverTest.testAsDriver_startWith),
    ("testAsDriver_interval", DriverTest.testAsDriver_interval),
    ("testAsDriver_timer", DriverTest.testAsDriver_timer),
    ("testDriveObserver", DriverTest.testDriveObserver),
    ("testDriveOptionalObserver", DriverTest.testDriveOptionalObserver),
    ("testDriveNoAmbiguity", DriverTest.testDriveNoAmbiguity),
    ("testdriveVariable", DriverTest.testdriveVariable),
    ("testDriveOptionalVariable", DriverTest.testDriveOptionalVariable),
    ("testDriveVariableNoAmbiguity", DriverTest.testDriveVariableNoAmbiguity),
    ] }
}

final class CurrentThreadSchedulerTest_ : CurrentThreadSchedulerTest, RxTestCase {
    #if os(macOS)
    required override init() {
        super.init()
    }
    #endif

    static var allTests: [(String, (CurrentThreadSchedulerTest_) -> () -> ())] { return [
    ("testCurrentThreadScheduler_scheduleRequired", CurrentThreadSchedulerTest.testCurrentThreadScheduler_scheduleRequired),
    ("testCurrentThreadScheduler_basicScenario", CurrentThreadSchedulerTest.testCurrentThreadScheduler_basicScenario),
    ("testCurrentThreadScheduler_disposing1", CurrentThreadSchedulerTest.testCurrentThreadScheduler_disposing1),
    ("testCurrentThreadScheduler_disposing2", CurrentThreadSchedulerTest.testCurrentThreadScheduler_disposing2),
    ] }
}
#if os(macOS) || os(iOS) || os(tvOS) || os(watchOS)

func testCase<T: RxTestCase>(_ tests: [(String, (T) -> () -> ())]) -> () -> () {
    return {
        for testCase in tests {
            print("Test \(testCase)")
            for test in T.allTests {
                let testInstance = T()
                testInstance.setUp()
                print("   testing \(test.0)")
                test.1(testInstance)()
                testInstance.tearDown()
            }
        }
    }
}

func XCTMain(_ tests: [() -> ()]) {
    for testCase in tests {
        testCase()
    }
}

#endif

    XCTMain([
        testCase(EventTests_.allTests),
        testCase(PublishSubjectTest_.allTests),
        testCase(AnomaliesTest_.allTests),
        testCase(PrimitiveSequenceTest_.allTests),
        testCase(VirtualSchedulerTest_.allTests),
        testCase(ObservableBlockingTest_.allTests),
        testCase(ObservableTimeTest_.allTests),
        testCase(AsyncSubjectTests_.allTests),
        testCase(ObservableBindingTest_.allTests),
        testCase(ObservableSingleTest_.allTests),
        testCase(ObservableAggregateTest_.allTests),
        testCase(ObservableStandardSequenceOperatorsTest_.allTests),
        testCase(SubjectConcurrencyTest_.allTests),
        testCase(VariableTest_.allTests),
        testCase(ObservableConcurrencyTest_.allTests),
        testCase(ReactiveTests_.allTests),
        testCase(ReplaySubjectTest_.allTests),
        testCase(ObservableSubscriptionTests_.allTests),
        testCase(NSNotificationCenterTests_.allTests),
        testCase(DisposableTest_.allTests),
        testCase(HistoricalSchedulerTest_.allTests),
        testCase(MainSchedulerTest_.allTests),
        testCase(ObserverTests_.allTests),
        testCase(RecursiveLockTests_.allTests),
        testCase(QueueTest_.allTests),
        testCase(ConcurrentDispatchQueueSchedulerTests_.allTests),
        testCase(ObservableMultipleTest_.allTests),
        testCase(ObservableCreationTests_.allTests),
        testCase(BehaviorSubjectTest_.allTests),
        testCase(ObservableDebugTest_.allTests),
        testCase(ObservableConcurrentSchedulerConcurrencyTest_.allTests),
        testCase(AnonymousObservableTests_.allTests),
        testCase(DriverTest_.allTests),
        testCase(CurrentThreadSchedulerTest_.allTests),
    ])
//}
