// This file is autogenerated. Take a look at `Preprocessor` target in RxSwift project 
//
//  PrimitiveSequenceTest+zip+arity.swift
//  Tests
//
//  Created by Krunoslav Zaher on 3/12/17.
//  Copyright © 2017 Krunoslav Zaher. All rights reserved.
//

import XCTest
import RxSwift
import RxTest



// 2

extension PrimitiveSequenceTest {
    func testZip2_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1)) { $0 + $1 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 2)
    }

    func testZip2_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1)).map { $0 + $1 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 2)
    }
}



// 3

extension PrimitiveSequenceTest {
    func testZip3_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 3)
    }

    func testZip3_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 3)
    }
}



// 4

extension PrimitiveSequenceTest {
    func testZip4_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 + $3 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 4)
    }

    func testZip4_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 + $3 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 4)
    }
}



// 5

extension PrimitiveSequenceTest {
    func testZip5_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 + $3 + $4 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 5)
    }

    func testZip5_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 + $3 + $4 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 5)
    }
}



// 6

extension PrimitiveSequenceTest {
    func testZip6_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 + $3 + $4 + $5 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 6)
    }

    func testZip6_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 + $3 + $4 + $5 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 6)
    }
}



// 7

extension PrimitiveSequenceTest {
    func testZip7_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 + $3 + $4 + $5 + $6 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 7)
    }

    func testZip7_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 + $3 + $4 + $5 + $6 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 7)
    }
}



// 8

extension PrimitiveSequenceTest {
    func testZip8_selector_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)) { $0 + $1 + $2 + $3 + $4 + $5 + $6 + $7 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 8)
    }

    func testZip8_producesSingleElement() {
        let singleResult: Single<Int> = Single.zip(Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1), Single.just(1)).map { $0 + $1 + $2 + $3 + $4 + $5 + $6 + $7 }

        let result = try! singleResult
            .toBlocking().first()!
        XCTAssertEqual(result, 8)
    }
}


