//
//  UISwitch+Rx.swift
//  RxCocoa
//
//  Created by Carlos García on 8/7/15.
//  Copyright © 2015 Krunoslav Zaher. All rights reserved.
//

#if os(iOS)

import UIKit
#if !RX_NO_MODULE
import RxSwift
#endif


extension Reactive where Base: UISwitch {

    /// Reactive wrapper for `isOn` property.
    public var isOn: ControlProperty<Bool> {
        return value
    }
    
    /**
    Reactive wrapper for `isOn` property.
    
    **⚠️ Versions prior to iOS 10.2 were leaking `UIButton`s, so on those versions
     underlying observable sequence won't complete when nothing holds a strong reference
     to UISwitch.⚠️**
    */
    public var value: ControlProperty<Bool> {
        return UIControl.rx.value(
            self.base,
            getter: { uiSwitch in
                uiSwitch.isOn
            }, setter: { uiSwitch, value in
                uiSwitch.isOn = value
            }
        )
    }
    
}

#endif

