// This file is autogenerated. Take a look at `Preprocessor` target in RxSwift project 
//
//  Observable+MultipleTest+Zip.swift
//  Tests
//
//  Created by Krunoslav Zaher on 5/23/15.
//  Copyright © 2015 Krunoslav Zaher. All rights reserved.
//

import XCTest
import RxSwift
import RxTest

// combine latest
extension ObservableMultipleTest {


    // 2

    func testZip_ImmediateSchedule2() {
        let factories: [(Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1 in
                    Observable.zip(e0, e1).map { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
                { e0, e1 in
                    Observable.zip(e0, e1) { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)

            var result: Int! = nil

            let _ = factory(v0, v1)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 3)
        }
    }

    func testZip_Never2() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1 in
                    Observable.zip(e0, e1).map { (_: Int, _: Int) -> Int in 42 }
                },
                { e0, e1 in
                    Observable.zip(e0, e1) { (_: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
        }
    }

    func testZip_Empty2() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1 in
                    Observable.zip(e0, e1).map { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
                { e0, e1 in
                    Observable.zip(e0, e1) { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1)
            }

            XCTAssertEqual(res.events, [
                completed(220)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        }
    }

    func testZip_SymmetricReturn2() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1 in
                    Observable.zip(e0, e1).map { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
                { e0, e1 in
                    Observable.zip(e0, e1) { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1)
            }

            XCTAssertEqual(res.events, [
                next(220, 3),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted2() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1 in
                    Observable.zip(e0, e1).map { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
                { e0, e1 in
                    Observable.zip(e0, e1) { (a0: Int, a1: Int) -> Int in a0 + a1 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1) 
            }

            XCTAssertEqual(res.events, [
                next(210, 10),
                completed(220)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        }
    }



    

    // 3

    func testZip_ImmediateSchedule3() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2).map { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2) { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)

            var result: Int! = nil

            let _ = factory(v0, v1, v2)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 6)
        }
    }

    func testZip_Never3() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2).map { (_: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2) { (_: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
        }
    }

    func testZip_Empty3() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2).map { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2) { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2)
            }

            XCTAssertEqual(res.events, [
                completed(230)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        }
    }

    func testZip_SymmetricReturn3() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2).map { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2) { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2)
            }

            XCTAssertEqual(res.events, [
                next(230, 6),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted3() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2).map { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
                { e0, e1, e2 in
                    Observable.zip(e0, e1, e2) { (a0: Int, a1: Int, a2: Int) -> Int in a0 + a1 + a2 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2) 
            }

            XCTAssertEqual(res.events, [
                next(210, 15),
                completed(230)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        }
    }



    

    // 4

    func testZip_ImmediateSchedule4() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3).map { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3) { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)
            let v3: Observable<Int> = Observable.just(4)

            var result: Int! = nil

            let _ = factory(v0, v1, v2, v3)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 10)
        }
    }

    func testZip_Never4() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3).map { (_: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3) { (_: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e3 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
            XCTAssertEqual(e3.subscriptions, subscriptions)
        }
    }

    func testZip_Empty4() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3).map { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3) { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                completed(240)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3)
            }

            XCTAssertEqual(res.events, [
                completed(240)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        }
    }

    func testZip_SymmetricReturn4() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3).map { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3) { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(240, 4),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3)
            }

            XCTAssertEqual(res.events, [
                next(240, 10),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted4() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3).map { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
                { e0, e1, e2, e3 in
                    Observable.zip(e0, e1, e2, e3) { (a0: Int, a1: Int, a2: Int, a3: Int) -> Int in a0 + a1 + a2 + a3 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8),
                completed(250)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3) 
            }

            XCTAssertEqual(res.events, [
                next(210, 20),
                completed(240)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        }
    }



    

    // 5

    func testZip_ImmediateSchedule5() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)
            let v3: Observable<Int> = Observable.just(4)
            let v4: Observable<Int> = Observable.just(5)

            var result: Int! = nil

            let _ = factory(v0, v1, v2, v3, v4)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 15)
        }
    }

    func testZip_Never5() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4).map { (_: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4) { (_: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e3 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e4 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
            XCTAssertEqual(e3.subscriptions, subscriptions)
            XCTAssertEqual(e4.subscriptions, subscriptions)
        }
    }

    func testZip_Empty5() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                completed(240)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                completed(250)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4)
            }

            XCTAssertEqual(res.events, [
                completed(250)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        }
    }

    func testZip_SymmetricReturn5() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(240, 4),
                completed(400)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(250, 5),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4)
            }

            XCTAssertEqual(res.events, [
                next(250, 15),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted5() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
                { e0, e1, e2, e3, e4 in
                    Observable.zip(e0, e1, e2, e3, e4) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int) -> Int in a0 + a1 + a2 + a3 + a4 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8),
                completed(250)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9),
                completed(260)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4) 
            }

            XCTAssertEqual(res.events, [
                next(210, 25),
                completed(250)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        }
    }



    

    // 6

    func testZip_ImmediateSchedule6() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)
            let v3: Observable<Int> = Observable.just(4)
            let v4: Observable<Int> = Observable.just(5)
            let v5: Observable<Int> = Observable.just(6)

            var result: Int! = nil

            let _ = factory(v0, v1, v2, v3, v4, v5)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 21)
        }
    }

    func testZip_Never6() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5).map { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5) { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e3 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e4 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e5 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
            XCTAssertEqual(e3.subscriptions, subscriptions)
            XCTAssertEqual(e4.subscriptions, subscriptions)
            XCTAssertEqual(e5.subscriptions, subscriptions)
        }
    }

    func testZip_Empty6() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                completed(240)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                completed(250)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                completed(260)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5)
            }

            XCTAssertEqual(res.events, [
                completed(260)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        }
    }

    func testZip_SymmetricReturn6() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(240, 4),
                completed(400)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(250, 5),
                completed(400)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(260, 6),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5)
            }

            XCTAssertEqual(res.events, [
                next(260, 21),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted6() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
                { e0, e1, e2, e3, e4, e5 in
                    Observable.zip(e0, e1, e2, e3, e4, e5) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8),
                completed(250)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9),
                completed(260)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10),
                completed(270)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5) 
            }

            XCTAssertEqual(res.events, [
                next(210, 30),
                completed(260)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        }
    }



    

    // 7

    func testZip_ImmediateSchedule7() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)
            let v3: Observable<Int> = Observable.just(4)
            let v4: Observable<Int> = Observable.just(5)
            let v5: Observable<Int> = Observable.just(6)
            let v6: Observable<Int> = Observable.just(7)

            var result: Int! = nil

            let _ = factory(v0, v1, v2, v3, v4, v5, v6)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 28)
        }
    }

    func testZip_Never7() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6).map { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6) { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e3 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e4 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e5 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e6 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
            XCTAssertEqual(e3.subscriptions, subscriptions)
            XCTAssertEqual(e4.subscriptions, subscriptions)
            XCTAssertEqual(e5.subscriptions, subscriptions)
            XCTAssertEqual(e6.subscriptions, subscriptions)
        }
    }

    func testZip_Empty7() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                completed(240)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                completed(250)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                completed(260)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                completed(270)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6)
            }

            XCTAssertEqual(res.events, [
                completed(270)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
        }
    }

    func testZip_SymmetricReturn7() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(240, 4),
                completed(400)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(250, 5),
                completed(400)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(260, 6),
                completed(400)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(270, 7),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6)
            }

            XCTAssertEqual(res.events, [
                next(270, 28),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted7() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
                { e0, e1, e2, e3, e4, e5, e6 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8),
                completed(250)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9),
                completed(260)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10),
                completed(270)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10), 
                next(270, 11),
                completed(280)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6) 
            }

            XCTAssertEqual(res.events, [
                next(210, 35),
                completed(270)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
        }
    }



    

    // 8

    func testZip_ImmediateSchedule8() {
        let factories: [(Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>, Observable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
            ]

        for factory in factories {
            
            let v0: Observable<Int> = Observable.just(1)
            let v1: Observable<Int> = Observable.just(2)
            let v2: Observable<Int> = Observable.just(3)
            let v3: Observable<Int> = Observable.just(4)
            let v4: Observable<Int> = Observable.just(5)
            let v5: Observable<Int> = Observable.just(6)
            let v6: Observable<Int> = Observable.just(7)
            let v7: Observable<Int> = Observable.just(8)

            var result: Int! = nil

            let _ = factory(v0, v1, v2, v3, v4, v5, v6, v7)
                .subscribe(onNext: { (x: Int) -> Void in result = x })

            XCTAssertEqual(result, 36)
        }
    }

    func testZip_Never8() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7).map { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7) { (_: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int, _: Int) -> Int in 42 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e1 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e2 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e3 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e4 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e5 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e6 = scheduler.createHotObservable([
                next(150, 1)
            ])
            
            let e7 = scheduler.createHotObservable([
                next(150, 1)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6, e7)
            }

            XCTAssertEqual(res.events, [])

            let subscriptions = [Subscription(200, 1000)]


            XCTAssertEqual(e0.subscriptions, subscriptions)
            XCTAssertEqual(e1.subscriptions, subscriptions)
            XCTAssertEqual(e2.subscriptions, subscriptions)
            XCTAssertEqual(e3.subscriptions, subscriptions)
            XCTAssertEqual(e4.subscriptions, subscriptions)
            XCTAssertEqual(e5.subscriptions, subscriptions)
            XCTAssertEqual(e6.subscriptions, subscriptions)
            XCTAssertEqual(e7.subscriptions, subscriptions)
        }
    }

    func testZip_Empty8() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
            ]
        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                completed(210)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                completed(220)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                completed(230)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                completed(240)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                completed(250)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                completed(260)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                completed(270)
            ])
            
            let e7: TestableObservable<Int> = scheduler.createHotObservable([
                completed(280)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6, e7)
            }

            XCTAssertEqual(res.events, [
                completed(280)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
            XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
        }
    }

    func testZip_SymmetricReturn8() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(210, 1),
                completed(400)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(220, 2),
                completed(400)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(230, 3),
                completed(400)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(240, 4),
                completed(400)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(250, 5),
                completed(400)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(260, 6),
                completed(400)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(270, 7),
                completed(400)
            ])
            
            let e7: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
                next(280, 8),
                completed(400)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6, e7)
            }

            XCTAssertEqual(res.events, [
                next(280, 36),
                completed(400)
            ])


            XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
            XCTAssertEqual(e7.subscriptions, [Subscription(200, 400)])
        }
    }

    func testZip_AllCompleted8() {
        let factories: [(TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>, TestableObservable<Int>) -> Observable<Int>] =
            [
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7).map { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
                { e0, e1, e2, e3, e4, e5, e6, e7 in
                    Observable.zip(e0, e1, e2, e3, e4, e5, e6, e7) { (a0: Int, a1: Int, a2: Int, a3: Int, a4: Int, a5: Int, a6: Int, a7: Int) -> Int in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 }
                },
            ]

        for factory in factories {
            let scheduler = TestScheduler(initialClock: 0)

            
            let e0: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5),
                completed(220)
            ])
            
            let e1: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6),
                completed(230)
            ])
            
            let e2: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7),
                completed(240)
            ])
            
            let e3: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8),
                completed(250)
            ])
            
            let e4: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9),
                completed(260)
            ])
            
            let e5: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10),
                completed(270)
            ])
            
            let e6: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10), 
                next(270, 11),
                completed(280)
            ])
            
            let e7: TestableObservable<Int> = scheduler.createHotObservable([
                next(150, 1),
     
                next(210, 5), 
                next(220, 6), 
                next(230, 7), 
                next(240, 8), 
                next(250, 9), 
                next(260, 10), 
                next(270, 11), 
                next(280, 12),
                completed(290)
            ])
            

            let res = scheduler.start { () -> Observable<Int> in
                factory(e0, e1, e2, e3, e4, e5, e6, e7) 
            }

            XCTAssertEqual(res.events, [
                next(210, 40),
                completed(280)
            ])

    
            XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
            XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
            XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
            XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
            XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
            XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
            XCTAssertEqual(e6.subscriptions, [Subscription(200, 280)])
            XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
        }
    }



    




}
