// This file is autogenerated. Take a look at `Preprocessor` target in RxSwift project 
//
//  SharedSequence+Operators+arity.swift
//  RxCocoa
//
//  Created by Krunoslav Zaher on 10/14/15.
//  Copyright © 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation
#if !RX_NO_MODULE
import RxSwift
#endif



// 2

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, resultSelector: @escaping (O1.E, O2.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, resultSelector: @escaping (O1.E, O2.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 3

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, resultSelector: @escaping (O1.E, O2.E, O3.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, resultSelector: @escaping (O1.E, O2.E, O3.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 4

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 5

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 6

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 7

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType, O7: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, _ source7: O7, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E, O7.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy,
            O1.SharingStrategy == O7.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(), source7.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType, O7: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, _ source7: O7, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E, O7.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy,
            O1.SharingStrategy == O7.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(), source7.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}



// 8

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever all of the observable sequences have produced an element at a corresponding index.

    - parameter resultSelector: Function to invoke for each series of elements at corresponding indexes in the sources.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func zip<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType, O7: SharedSequenceConvertibleType, O8: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, _ source7: O7, _ source8: O8, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E, O7.E, O8.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy,
            O1.SharingStrategy == O7.SharingStrategy,
            O1.SharingStrategy == O8.SharingStrategy {
        let source = Observable.zip(
            source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(), source7.asSharedSequence().asObservable(), source8.asSharedSequence().asObservable(),
            resultSelector: resultSelector
        )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}

extension SharedSequence {
    /**
    Merges the specified observable sequences into one observable sequence by using the selector function whenever any of the observable sequences produces an element.

    - parameter resultSelector: Function to invoke whenever any of the sources produces an element.
    - returns: An observable sequence containing the result of combining elements of the sources using the specified result selector function.
    */
    public static func combineLatest<O1: SharedSequenceConvertibleType, O2: SharedSequenceConvertibleType, O3: SharedSequenceConvertibleType, O4: SharedSequenceConvertibleType, O5: SharedSequenceConvertibleType, O6: SharedSequenceConvertibleType, O7: SharedSequenceConvertibleType, O8: SharedSequenceConvertibleType>
        (_ source1: O1, _ source2: O2, _ source3: O3, _ source4: O4, _ source5: O5, _ source6: O6, _ source7: O7, _ source8: O8, resultSelector: @escaping (O1.E, O2.E, O3.E, O4.E, O5.E, O6.E, O7.E, O8.E) throws -> E)
        -> SharedSequence<O1.SharingStrategy, E> where O1.SharingStrategy == O2.SharingStrategy,
            O1.SharingStrategy == O3.SharingStrategy,
            O1.SharingStrategy == O4.SharingStrategy,
            O1.SharingStrategy == O5.SharingStrategy,
            O1.SharingStrategy == O6.SharingStrategy,
            O1.SharingStrategy == O7.SharingStrategy,
            O1.SharingStrategy == O8.SharingStrategy {
        let source = Observable.combineLatest(
                source1.asSharedSequence().asObservable(), source2.asSharedSequence().asObservable(), source3.asSharedSequence().asObservable(), source4.asSharedSequence().asObservable(), source5.asSharedSequence().asObservable(), source6.asSharedSequence().asObservable(), source7.asSharedSequence().asObservable(), source8.asSharedSequence().asObservable(),
                resultSelector: resultSelector
            )

        return SharedSequence<O1.SharingStrategy, E>(source)
    }
}


