//
//  Observable+Concurrency.swift
//  Rx
//
//  Created by Krunoslav Zaher on 3/15/15.
//  Copyright (c) 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation

// observeOn

extension ObservableType {
    
    /**
    Wraps the source sequence in order to run its observer callbacks on the specified scheduler.
    
    This only invokes observer callbacks on a `scheduler`. In case the subscription and/or unsubscription
    actions have side-effects that require to be run on a scheduler, use `subscribeOn`.
    
    - parameter scheduler: Scheduler to notify observers on.
    - returns: The source sequence whose observations happen on the specified scheduler.
    */
    public func observeOn(scheduler: ImmediateScheduler)
        -> Observable<E> {
        if let scheduler = scheduler as? SerialDispatchQueueScheduler {
            return ObserveOnSerialDispatchQueue(source: self.asObservable(), scheduler: scheduler)
        }
        else {
            return ObserveOn(source: self.asObservable(), scheduler: scheduler)
        }
    }
}

// subscribeOn

extension ObservableType {
    
    /**
    Wraps the source sequence in order to run its subscription and unsubscription logic on the specified 
    scheduler. 
    
    This operation is not commonly used.
    
    This only performs the side-effects of subscription and unsubscription on the specified scheduler. 
    
    In order to invoke observer callbacks on a `scheduler`, use `observeOn`.
    
    - parameter scheduler: Scheduler to perform subscription and unsubscription actions on.
    - returns: The source sequence whose subscriptions and unsubscriptions happen on the specified scheduler.
    */
    public func subscribeOn(scheduler: ImmediateScheduler)
        -> Observable<E> {
        return SubscribeOn(source: self.asObservable(), scheduler: scheduler)
    }
}