// This file is autogenerated.
// Take a look at `Preprocessor` target in RxSwift project 
//
//  CombineLatest.tt.swift
//  RxSwift
//
//  Created by Krunoslav Zaher on 4/22/15.
//  Copyright (c) 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation



// 2

public func combineLatestOrDie<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest2(
        source1: source1, source2: source2,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> R)
        -> Observable<R> {
    return CombineLatest2(
        source1: source1, source2: source2,
        resultSelector: { success(resultSelector($0, $1)) }
    )
}

class CombineLatestSink2_<E1, E2, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest2<E1, E2, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 2, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2)
    }
}

class CombineLatest2<E1, E2, R> : Producer<R> {
    typealias ResultSelector = (E1, E2) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink2_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 3

public func combineLatestOrDie<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> R)
        -> Observable<R> {
    return CombineLatest3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: { success(resultSelector($0, $1, $2)) }
    )
}

class CombineLatestSink3_<E1, E2, E3, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest3<E1, E2, E3, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 3, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3)
    }
}

class CombineLatest3<E1, E2, E3, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink3_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 4

public func combineLatestOrDie<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> R)
        -> Observable<R> {
    return CombineLatest4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: { success(resultSelector($0, $1, $2, $3)) }
    )
}

class CombineLatestSink4_<E1, E2, E3, E4, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest4<E1, E2, E3, E4, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 4, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4)
    }
}

class CombineLatest4<E1, E2, E3, E4, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink4_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 5

public func combineLatestOrDie<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> R)
        -> Observable<R> {
    return CombineLatest5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4)) }
    )
}

class CombineLatestSink5_<E1, E2, E3, E4, E5, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest5<E1, E2, E3, E4, E5, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 5, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5)
    }
}

class CombineLatest5<E1, E2, E3, E4, E5, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink5_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 6

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> R)
        -> Observable<R> {
    return CombineLatest6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5)) }
    )
}

class CombineLatestSink6_<E1, E2, E3, E4, E5, E6, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest6<E1, E2, E3, E4, E5, E6, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil
     var latestElement6: E6! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 6, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)
         let observer6 = CombineLatestObserver(lock: lock, parent: self, index: 5, setLatestValue: { (e: E6) -> Void in self.latestElement6 = e }, this: subscription6)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)
         subscription6.disposable = parent.source6.subscribeSafe(observer6)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5, latestElement6)
    }
}

class CombineLatest6<E1, E2, E3, E4, E5, E6, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink6_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 7

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> R)
        -> Observable<R> {
    return CombineLatest7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6)) }
    )
}

class CombineLatestSink7_<E1, E2, E3, E4, E5, E6, E7, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest7<E1, E2, E3, E4, E5, E6, E7, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil
     var latestElement6: E6! = nil
     var latestElement7: E7! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 7, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)
         let observer6 = CombineLatestObserver(lock: lock, parent: self, index: 5, setLatestValue: { (e: E6) -> Void in self.latestElement6 = e }, this: subscription6)
         let observer7 = CombineLatestObserver(lock: lock, parent: self, index: 6, setLatestValue: { (e: E7) -> Void in self.latestElement7 = e }, this: subscription7)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)
         subscription6.disposable = parent.source6.subscribeSafe(observer6)
         subscription7.disposable = parent.source7.subscribeSafe(observer7)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5, latestElement6, latestElement7)
    }
}

class CombineLatest7<E1, E2, E3, E4, E5, E6, E7, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink7_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 8

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> R)
        -> Observable<R> {
    return CombineLatest8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7)) }
    )
}

class CombineLatestSink8_<E1, E2, E3, E4, E5, E6, E7, E8, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest8<E1, E2, E3, E4, E5, E6, E7, E8, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil
     var latestElement6: E6! = nil
     var latestElement7: E7! = nil
     var latestElement8: E8! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 8, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)
         let observer6 = CombineLatestObserver(lock: lock, parent: self, index: 5, setLatestValue: { (e: E6) -> Void in self.latestElement6 = e }, this: subscription6)
         let observer7 = CombineLatestObserver(lock: lock, parent: self, index: 6, setLatestValue: { (e: E7) -> Void in self.latestElement7 = e }, this: subscription7)
         let observer8 = CombineLatestObserver(lock: lock, parent: self, index: 7, setLatestValue: { (e: E8) -> Void in self.latestElement8 = e }, this: subscription8)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)
         subscription6.disposable = parent.source6.subscribeSafe(observer6)
         subscription7.disposable = parent.source7.subscribeSafe(observer7)
         subscription8.disposable = parent.source8.subscribeSafe(observer8)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5, latestElement6, latestElement7, latestElement8)
    }
}

class CombineLatest8<E1, E2, E3, E4, E5, E6, E7, E8, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink8_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 9

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> R)
        -> Observable<R> {
    return CombineLatest9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8)) }
    )
}

class CombineLatestSink9_<E1, E2, E3, E4, E5, E6, E7, E8, E9, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil
     var latestElement6: E6! = nil
     var latestElement7: E7! = nil
     var latestElement8: E8! = nil
     var latestElement9: E9! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 9, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)
         let observer6 = CombineLatestObserver(lock: lock, parent: self, index: 5, setLatestValue: { (e: E6) -> Void in self.latestElement6 = e }, this: subscription6)
         let observer7 = CombineLatestObserver(lock: lock, parent: self, index: 6, setLatestValue: { (e: E7) -> Void in self.latestElement7 = e }, this: subscription7)
         let observer8 = CombineLatestObserver(lock: lock, parent: self, index: 7, setLatestValue: { (e: E8) -> Void in self.latestElement8 = e }, this: subscription8)
         let observer9 = CombineLatestObserver(lock: lock, parent: self, index: 8, setLatestValue: { (e: E9) -> Void in self.latestElement9 = e }, this: subscription9)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)
         subscription6.disposable = parent.source6.subscribeSafe(observer6)
         subscription7.disposable = parent.source7.subscribeSafe(observer7)
         subscription8.disposable = parent.source8.subscribeSafe(observer8)
         subscription9.disposable = parent.source9.subscribeSafe(observer9)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8,
                subscription9
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5, latestElement6, latestElement7, latestElement8, latestElement9)
    }
}

class CombineLatest9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink9_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 10

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>)
        -> Observable<R> {
    return CombineLatest10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> R)
        -> Observable<R> {
    return CombineLatest10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8, $9)) }
    )
}

class CombineLatestSink10_<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, O: ObserverType> : CombineLatestSink<O> {
    typealias R = O.Element
    typealias Parent = CombineLatest10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>

    let parent: Parent

     var latestElement1: E1! = nil
     var latestElement2: E2! = nil
     var latestElement3: E3! = nil
     var latestElement4: E4! = nil
     var latestElement5: E5! = nil
     var latestElement6: E6! = nil
     var latestElement7: E7! = nil
     var latestElement8: E8! = nil
     var latestElement9: E9! = nil
     var latestElement10: E10! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 10, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()
        let subscription10 = SingleAssignmentDisposable()

         let observer1 = CombineLatestObserver(lock: lock, parent: self, index: 0, setLatestValue: { (e: E1) -> Void in self.latestElement1 = e }, this: subscription1)
         let observer2 = CombineLatestObserver(lock: lock, parent: self, index: 1, setLatestValue: { (e: E2) -> Void in self.latestElement2 = e }, this: subscription2)
         let observer3 = CombineLatestObserver(lock: lock, parent: self, index: 2, setLatestValue: { (e: E3) -> Void in self.latestElement3 = e }, this: subscription3)
         let observer4 = CombineLatestObserver(lock: lock, parent: self, index: 3, setLatestValue: { (e: E4) -> Void in self.latestElement4 = e }, this: subscription4)
         let observer5 = CombineLatestObserver(lock: lock, parent: self, index: 4, setLatestValue: { (e: E5) -> Void in self.latestElement5 = e }, this: subscription5)
         let observer6 = CombineLatestObserver(lock: lock, parent: self, index: 5, setLatestValue: { (e: E6) -> Void in self.latestElement6 = e }, this: subscription6)
         let observer7 = CombineLatestObserver(lock: lock, parent: self, index: 6, setLatestValue: { (e: E7) -> Void in self.latestElement7 = e }, this: subscription7)
         let observer8 = CombineLatestObserver(lock: lock, parent: self, index: 7, setLatestValue: { (e: E8) -> Void in self.latestElement8 = e }, this: subscription8)
         let observer9 = CombineLatestObserver(lock: lock, parent: self, index: 8, setLatestValue: { (e: E9) -> Void in self.latestElement9 = e }, this: subscription9)
         let observer10 = CombineLatestObserver(lock: lock, parent: self, index: 9, setLatestValue: { (e: E10) -> Void in self.latestElement10 = e }, this: subscription10)

         subscription1.disposable = parent.source1.subscribeSafe(observer1)
         subscription2.disposable = parent.source2.subscribeSafe(observer2)
         subscription3.disposable = parent.source3.subscribeSafe(observer3)
         subscription4.disposable = parent.source4.subscribeSafe(observer4)
         subscription5.disposable = parent.source5.subscribeSafe(observer5)
         subscription6.disposable = parent.source6.subscribeSafe(observer6)
         subscription7.disposable = parent.source7.subscribeSafe(observer7)
         subscription8.disposable = parent.source8.subscribeSafe(observer8)
         subscription9.disposable = parent.source9.subscribeSafe(observer9)
         subscription10.disposable = parent.source10.subscribeSafe(observer10)

        return CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8,
                subscription9,
                subscription10
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(latestElement1, latestElement2, latestElement3, latestElement4, latestElement5, latestElement6, latestElement7, latestElement8, latestElement9, latestElement10)
    }
}

class CombineLatest10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>
    let source10: Observable<E10>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9
        self.source10 = source10

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = CombineLatestSink10_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}

