// This file is autogenerated.
// Take a look at `Preprocessor` target in RxSwift project 
//
//  Zip+arity.tt
//  RxSwift
//
//  Created by Krunoslav Zaher on 5/23/15.
//  Copyright (c) 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation



// 2

public func zipOrDie<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> RxResult<R>)
    -> Observable<R> {
    return Zip2(
        source1: source1, source2: source2,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> R)
    -> Observable<R> {
    return Zip2(
        source1: source1, source2: source2,
        resultSelector: { success(resultSelector($0, $1)) }
    )
}

class ZipSink2_<E1, E2, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip2<E1, E2, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 2, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue())
    }
}

class Zip2<E1, E2, R> : Producer<R> {
    typealias ResultSelector = (E1, E2) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink2_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 3

public func zipOrDie<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> RxResult<R>)
    -> Observable<R> {
    return Zip3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> R)
    -> Observable<R> {
    return Zip3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: { success(resultSelector($0, $1, $2)) }
    )
}

class ZipSink3_<E1, E2, E3, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip3<E1, E2, E3, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 3, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue())
    }
}

class Zip3<E1, E2, E3, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink3_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 4

public func zipOrDie<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> RxResult<R>)
    -> Observable<R> {
    return Zip4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> R)
    -> Observable<R> {
    return Zip4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: { success(resultSelector($0, $1, $2, $3)) }
    )
}

class ZipSink4_<E1, E2, E3, E4, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip4<E1, E2, E3, E4, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 4, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue())
    }
}

class Zip4<E1, E2, E3, E4, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink4_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 5

public func zipOrDie<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> RxResult<R>)
    -> Observable<R> {
    return Zip5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> R)
    -> Observable<R> {
    return Zip5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4)) }
    )
}

class ZipSink5_<E1, E2, E3, E4, E5, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip5<E1, E2, E3, E4, E5, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 5, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue())
    }
}

class Zip5<E1, E2, E3, E4, E5, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink5_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 6

public func zipOrDie<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> RxResult<R>)
    -> Observable<R> {
    return Zip6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> R)
    -> Observable<R> {
    return Zip6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5)) }
    )
}

class ZipSink6_<E1, E2, E3, E4, E5, E6, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip6<E1, E2, E3, E4, E5, E6, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)
    var values6: Queue<E6> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 6, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0
        case 5: return values6.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)
        let observer6 = ZipObserver(lock: lock, parent: self, index: 5, setNextValue: { self.values6.enqueue($0) }, this: subscription6)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)
        subscription6.disposable = parent.source6.subscribeSafe(observer6)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue(), values6.dequeue())
    }
}

class Zip6<E1, E2, E3, E4, E5, E6, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink6_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 7

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>)
    -> Observable<R> {
    return Zip7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> R)
    -> Observable<R> {
    return Zip7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6)) }
    )
}

class ZipSink7_<E1, E2, E3, E4, E5, E6, E7, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip7<E1, E2, E3, E4, E5, E6, E7, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)
    var values6: Queue<E6> = Queue(capacity: 2)
    var values7: Queue<E7> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 7, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0
        case 5: return values6.count > 0
        case 6: return values7.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)
        let observer6 = ZipObserver(lock: lock, parent: self, index: 5, setNextValue: { self.values6.enqueue($0) }, this: subscription6)
        let observer7 = ZipObserver(lock: lock, parent: self, index: 6, setNextValue: { self.values7.enqueue($0) }, this: subscription7)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)
        subscription6.disposable = parent.source6.subscribeSafe(observer6)
        subscription7.disposable = parent.source7.subscribeSafe(observer7)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue(), values6.dequeue(), values7.dequeue())
    }
}

class Zip7<E1, E2, E3, E4, E5, E6, E7, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink7_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 8

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>)
    -> Observable<R> {
    return Zip8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> R)
    -> Observable<R> {
    return Zip8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7)) }
    )
}

class ZipSink8_<E1, E2, E3, E4, E5, E6, E7, E8, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip8<E1, E2, E3, E4, E5, E6, E7, E8, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)
    var values6: Queue<E6> = Queue(capacity: 2)
    var values7: Queue<E7> = Queue(capacity: 2)
    var values8: Queue<E8> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 8, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0
        case 5: return values6.count > 0
        case 6: return values7.count > 0
        case 7: return values8.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)
        let observer6 = ZipObserver(lock: lock, parent: self, index: 5, setNextValue: { self.values6.enqueue($0) }, this: subscription6)
        let observer7 = ZipObserver(lock: lock, parent: self, index: 6, setNextValue: { self.values7.enqueue($0) }, this: subscription7)
        let observer8 = ZipObserver(lock: lock, parent: self, index: 7, setNextValue: { self.values8.enqueue($0) }, this: subscription8)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)
        subscription6.disposable = parent.source6.subscribeSafe(observer6)
        subscription7.disposable = parent.source7.subscribeSafe(observer7)
        subscription8.disposable = parent.source8.subscribeSafe(observer8)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue(), values6.dequeue(), values7.dequeue(), values8.dequeue())
    }
}

class Zip8<E1, E2, E3, E4, E5, E6, E7, E8, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink8_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 9

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>)
    -> Observable<R> {
    return Zip9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> R)
    -> Observable<R> {
    return Zip9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8)) }
    )
}

class ZipSink9_<E1, E2, E3, E4, E5, E6, E7, E8, E9, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)
    var values6: Queue<E6> = Queue(capacity: 2)
    var values7: Queue<E7> = Queue(capacity: 2)
    var values8: Queue<E8> = Queue(capacity: 2)
    var values9: Queue<E9> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 9, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0
        case 5: return values6.count > 0
        case 6: return values7.count > 0
        case 7: return values8.count > 0
        case 8: return values9.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)
        let observer6 = ZipObserver(lock: lock, parent: self, index: 5, setNextValue: { self.values6.enqueue($0) }, this: subscription6)
        let observer7 = ZipObserver(lock: lock, parent: self, index: 6, setNextValue: { self.values7.enqueue($0) }, this: subscription7)
        let observer8 = ZipObserver(lock: lock, parent: self, index: 7, setNextValue: { self.values8.enqueue($0) }, this: subscription8)
        let observer9 = ZipObserver(lock: lock, parent: self, index: 8, setNextValue: { self.values9.enqueue($0) }, this: subscription9)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)
        subscription6.disposable = parent.source6.subscribeSafe(observer6)
        subscription7.disposable = parent.source7.subscribeSafe(observer7)
        subscription8.disposable = parent.source8.subscribeSafe(observer8)
        subscription9.disposable = parent.source9.subscribeSafe(observer9)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8,
           subscription9
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue(), values6.dequeue(), values7.dequeue(), values8.dequeue(), values9.dequeue())
    }
}

class Zip9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink9_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 10

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>)
    -> Observable<R> {
    return Zip10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> R)
    -> Observable<R> {
    return Zip10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8, $9)) }
    )
}

class ZipSink10_<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>

    let parent: Parent

    var values1: Queue<E1> = Queue(capacity: 2)
    var values2: Queue<E2> = Queue(capacity: 2)
    var values3: Queue<E3> = Queue(capacity: 2)
    var values4: Queue<E4> = Queue(capacity: 2)
    var values5: Queue<E5> = Queue(capacity: 2)
    var values6: Queue<E6> = Queue(capacity: 2)
    var values7: Queue<E7> = Queue(capacity: 2)
    var values8: Queue<E8> = Queue(capacity: 2)
    var values9: Queue<E9> = Queue(capacity: 2)
    var values10: Queue<E10> = Queue(capacity: 2)

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 10, observer: observer, cancel: cancel)
    }

    override func hasElements(index: Int) -> Bool {
        switch (index) {
        case 0: return values1.count > 0
        case 1: return values2.count > 0
        case 2: return values3.count > 0
        case 3: return values4.count > 0
        case 4: return values5.count > 0
        case 5: return values6.count > 0
        case 6: return values7.count > 0
        case 7: return values8.count > 0
        case 8: return values9.count > 0
        case 9: return values10.count > 0

        default:
            rxFatalError("Unhandled case (Function)")
        }

        return false
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()
        let subscription10 = SingleAssignmentDisposable()

        let observer1 = ZipObserver(lock: lock, parent: self, index: 0, setNextValue: { self.values1.enqueue($0) }, this: subscription1)
        let observer2 = ZipObserver(lock: lock, parent: self, index: 1, setNextValue: { self.values2.enqueue($0) }, this: subscription2)
        let observer3 = ZipObserver(lock: lock, parent: self, index: 2, setNextValue: { self.values3.enqueue($0) }, this: subscription3)
        let observer4 = ZipObserver(lock: lock, parent: self, index: 3, setNextValue: { self.values4.enqueue($0) }, this: subscription4)
        let observer5 = ZipObserver(lock: lock, parent: self, index: 4, setNextValue: { self.values5.enqueue($0) }, this: subscription5)
        let observer6 = ZipObserver(lock: lock, parent: self, index: 5, setNextValue: { self.values6.enqueue($0) }, this: subscription6)
        let observer7 = ZipObserver(lock: lock, parent: self, index: 6, setNextValue: { self.values7.enqueue($0) }, this: subscription7)
        let observer8 = ZipObserver(lock: lock, parent: self, index: 7, setNextValue: { self.values8.enqueue($0) }, this: subscription8)
        let observer9 = ZipObserver(lock: lock, parent: self, index: 8, setNextValue: { self.values9.enqueue($0) }, this: subscription9)
        let observer10 = ZipObserver(lock: lock, parent: self, index: 9, setNextValue: { self.values10.enqueue($0) }, this: subscription10)

        subscription1.disposable = parent.source1.subscribeSafe(observer1)
        subscription2.disposable = parent.source2.subscribeSafe(observer2)
        subscription3.disposable = parent.source3.subscribeSafe(observer3)
        subscription4.disposable = parent.source4.subscribeSafe(observer4)
        subscription5.disposable = parent.source5.subscribeSafe(observer5)
        subscription6.disposable = parent.source6.subscribeSafe(observer6)
        subscription7.disposable = parent.source7.subscribeSafe(observer7)
        subscription8.disposable = parent.source8.subscribeSafe(observer8)
        subscription9.disposable = parent.source9.subscribeSafe(observer9)
        subscription10.disposable = parent.source10.subscribeSafe(observer10)

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8,
           subscription9,
           subscription10
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(values1.dequeue(), values2.dequeue(), values3.dequeue(), values4.dequeue(), values5.dequeue(), values6.dequeue(), values7.dequeue(), values8.dequeue(), values9.dequeue(), values10.dequeue())
    }
}

class Zip10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>
    let source10: Observable<E10>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9
        self.source10 = source10

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink10_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}

