// This file is autogenerated.
// Take a look at `Preprocessor` target in RxSwift project 
//
//  Observable+MultipleTest+Zip.tt
//  RxTests
//
//  Created by Krunoslav Zaher on 5/23/15.
//
//

import Foundation
import XCTest
import RxSwift

// combine latest
extension ObservableMultipleTest {


    // 2

    func testZip_ImmediateSchedule2() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)

        var result: Int! = nil

        let d = zip(v0, v1) { (a0, a1) in a0 + a1 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 3)
    }

    func testZip_Never2() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1) { (_, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
    }

    func testZip_Empty2() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1) { (_, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(220)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
    }

    func testZip_SymmetricReturn2() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1) { (_0, _1) -> Int in
                return (_0 + _1) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(220, 3),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted2() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1) { (_0, _1) -> Int in
                return (_0 + _1) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 10),
            completed(220)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
    }



    

    // 3

    func testZip_ImmediateSchedule3() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)

        var result: Int! = nil

        let d = zip(v0, v1, v2) { (a0, a1, a2) in a0 + a1 + a2 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 6)
    }

    func testZip_Never3() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2) { (_, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
    }

    func testZip_Empty3() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2) { (_, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(230)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
    }

    func testZip_SymmetricReturn3() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2) { (_0, _1, _2) -> Int in
                return (_0 + _1 + _2) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(230, 6),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted3() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2) { (_0, _1, _2) -> Int in
                return (_0 + _1 + _2) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 15),
            completed(230)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
    }



    

    // 4

    func testZip_ImmediateSchedule4() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3) { (a0, a1, a2, a3) in a0 + a1 + a2 + a3 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 10)
    }

    func testZip_Never4() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3) { (_, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
    }

    func testZip_Empty4() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3) { (_, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(240)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
    }

    func testZip_SymmetricReturn4() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3) { (_0, _1, _2, _3) -> Int in
                return (_0 + _1 + _2 + _3) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(240, 10),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted4() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3) { (_0, _1, _2, _3) -> Int in
                return (_0 + _1 + _2 + _3) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 20),
            completed(240)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
    }



    

    // 5

    func testZip_ImmediateSchedule5() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4) { (a0, a1, a2, a3, a4) in a0 + a1 + a2 + a3 + a4 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 15)
    }

    func testZip_Never5() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4) { (_, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
    }

    func testZip_Empty5() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4) { (_, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(250)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
    }

    func testZip_SymmetricReturn5() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4) { (_0, _1, _2, _3, _4) -> Int in
                return (_0 + _1 + _2 + _3 + _4) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(250, 15),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted5() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4) { (_0, _1, _2, _3, _4) -> Int in
                return (_0 + _1 + _2 + _3 + _4) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 25),
            completed(250)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
    }



    

    // 6

    func testZip_ImmediateSchedule6() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)
        let v5: Observable<Int> = returnElement(6)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4, v5) { (a0, a1, a2, a3, a4, a5) in a0 + a1 + a2 + a3 + a4 + a5 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 21)
    }

    func testZip_Never6() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e5 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5) { (_, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
        XCTAssertEqual(e5.subscriptions, subscriptions)
    }

    func testZip_Empty6() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            completed(260)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5) { (_, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(260)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
    }

    func testZip_SymmetricReturn6() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(260, 6),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5) { (_0, _1, _2, _3, _4, _5) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(260, 21),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted6() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10),
            completed(270)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5) { (_0, _1, _2, _3, _4, _5) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 30),
            completed(260)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
    }



    

    // 7

    func testZip_ImmediateSchedule7() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)
        let v5: Observable<Int> = returnElement(6)
        let v6: Observable<Int> = returnElement(7)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4, v5, v6) { (a0, a1, a2, a3, a4, a5, a6) in a0 + a1 + a2 + a3 + a4 + a5 + a6 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 28)
    }

    func testZip_Never7() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e5 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e6 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6) { (_, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
        XCTAssertEqual(e5.subscriptions, subscriptions)
        XCTAssertEqual(e6.subscriptions, subscriptions)
    }

    func testZip_Empty7() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            completed(260)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            completed(270)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6) { (_, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(270)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
    }

    func testZip_SymmetricReturn7() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(260, 6),
            completed(400)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(270, 7),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6) { (_0, _1, _2, _3, _4, _5, _6) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(270, 28),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted7() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10),
            completed(270)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11),
            completed(280)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6) { (_0, _1, _2, _3, _4, _5, _6) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 35),
            completed(270)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
    }



    

    // 8

    func testZip_ImmediateSchedule8() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)
        let v5: Observable<Int> = returnElement(6)
        let v6: Observable<Int> = returnElement(7)
        let v7: Observable<Int> = returnElement(8)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4, v5, v6, v7) { (a0, a1, a2, a3, a4, a5, a6, a7) in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 36)
    }

    func testZip_Never8() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e5 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e6 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e7 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7) { (_, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
        XCTAssertEqual(e5.subscriptions, subscriptions)
        XCTAssertEqual(e6.subscriptions, subscriptions)
        XCTAssertEqual(e7.subscriptions, subscriptions)
    }

    func testZip_Empty8() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            completed(260)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            completed(270)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            completed(280)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7) { (_, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(280)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
    }

    func testZip_SymmetricReturn8() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(260, 6),
            completed(400)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(270, 7),
            completed(400)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(280, 8),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7) { (_0, _1, _2, _3, _4, _5, _6, _7) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(280, 36),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted8() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10),
            completed(270)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11),
            completed(280)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12),
            completed(290)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7) { (_0, _1, _2, _3, _4, _5, _6, _7) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 40),
            completed(280)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 280)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
    }



    

    // 9

    func testZip_ImmediateSchedule9() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)
        let v5: Observable<Int> = returnElement(6)
        let v6: Observable<Int> = returnElement(7)
        let v7: Observable<Int> = returnElement(8)
        let v8: Observable<Int> = returnElement(9)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4, v5, v6, v7, v8) { (a0, a1, a2, a3, a4, a5, a6, a7, a8) in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 + a8 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 45)
    }

    func testZip_Never9() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e5 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e6 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e7 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e8 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8) { (_, _, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
        XCTAssertEqual(e5.subscriptions, subscriptions)
        XCTAssertEqual(e6.subscriptions, subscriptions)
        XCTAssertEqual(e7.subscriptions, subscriptions)
        XCTAssertEqual(e8.subscriptions, subscriptions)
    }

    func testZip_Empty9() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            completed(260)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            completed(270)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            completed(280)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            completed(290)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8) { (_, _, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(290)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 290)])
    }

    func testZip_SymmetricReturn9() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(260, 6),
            completed(400)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(270, 7),
            completed(400)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(280, 8),
            completed(400)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(290, 9),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8) { (_0, _1, _2, _3, _4, _5, _6, _7, _8) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7 + _8) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(290, 45),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted9() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10),
            completed(270)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11),
            completed(280)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12),
            completed(290)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12), 
            next(290, 13),
            completed(300)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8) { (_0, _1, _2, _3, _4, _5, _6, _7, _8) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7 + _8) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 45),
            completed(290)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 280)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 290)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 290)])
    }



    

    // 10

    func testZip_ImmediateSchedule10() {
        
        let v0: Observable<Int> = returnElement(1)
        let v1: Observable<Int> = returnElement(2)
        let v2: Observable<Int> = returnElement(3)
        let v3: Observable<Int> = returnElement(4)
        let v4: Observable<Int> = returnElement(5)
        let v5: Observable<Int> = returnElement(6)
        let v6: Observable<Int> = returnElement(7)
        let v7: Observable<Int> = returnElement(8)
        let v8: Observable<Int> = returnElement(9)
        let v9: Observable<Int> = returnElement(10)

        var result: Int! = nil

        let d = zip(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9) { (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) in a0 + a1 + a2 + a3 + a4 + a5 + a6 + a7 + a8 + a9 } >- subscribeNext { result = $0 }

        XCTAssertEqual(result, 55)
    }

    func testZip_Never10() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e1 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e2 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e3 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e4 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e5 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e6 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e7 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e8 = scheduler.createHotObservable([
            next(150, 1)
        ])
        
        let e9 = scheduler.createHotObservable([
            next(150, 1)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9) { (_, _, _, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [])

        let subscriptions = [Subscription(200, 1000)]


        XCTAssertEqual(e0.subscriptions, subscriptions)
        XCTAssertEqual(e1.subscriptions, subscriptions)
        XCTAssertEqual(e2.subscriptions, subscriptions)
        XCTAssertEqual(e3.subscriptions, subscriptions)
        XCTAssertEqual(e4.subscriptions, subscriptions)
        XCTAssertEqual(e5.subscriptions, subscriptions)
        XCTAssertEqual(e6.subscriptions, subscriptions)
        XCTAssertEqual(e7.subscriptions, subscriptions)
        XCTAssertEqual(e8.subscriptions, subscriptions)
        XCTAssertEqual(e9.subscriptions, subscriptions)
    }

    func testZip_Empty10() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            completed(210)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            completed(220)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            completed(230)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            completed(240)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            completed(250)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            completed(260)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            completed(270)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            completed(280)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            completed(290)
        ])
        
        let e9: HotObservable<Int> = scheduler.createHotObservable([
            completed(300)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9) { (_, _, _, _, _, _, _, _, _, _) -> Int in
                return (42)
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            completed(300)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 210)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 280)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 290)])
        XCTAssertEqual(e9.subscriptions, [Subscription(200, 300)])
    }

    func testZip_SymmetricReturn10() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(210, 1),
            completed(400)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(400)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(230, 3),
            completed(400)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(240, 4),
            completed(400)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(250, 5),
            completed(400)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(260, 6),
            completed(400)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(270, 7),
            completed(400)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(280, 8),
            completed(400)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(290, 9),
            completed(400)
        ])
        
        let e9: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
            next(300, 10),
            completed(400)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9) { (_0, _1, _2, _3, _4, _5, _6, _7, _8, _9) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7 + _8 + _9) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(300, 55),
            completed(400)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 400)])
        XCTAssertEqual(e9.subscriptions, [Subscription(200, 400)])
    }

    func testZip_AllCompleted10() {
        let scheduler = TestScheduler(initialClock: 0)

        
        let e0: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5),
            completed(220)
        ])
        
        let e1: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6),
            completed(230)
        ])
        
        let e2: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7),
            completed(240)
        ])
        
        let e3: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8),
            completed(250)
        ])
        
        let e4: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9),
            completed(260)
        ])
        
        let e5: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10),
            completed(270)
        ])
        
        let e6: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11),
            completed(280)
        ])
        
        let e7: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12),
            completed(290)
        ])
        
        let e8: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12), 
            next(290, 13),
            completed(300)
        ])
        
        let e9: HotObservable<Int> = scheduler.createHotObservable([
            next(150, 1),
 
            next(210, 5), 
            next(220, 6), 
            next(230, 7), 
            next(240, 8), 
            next(250, 9), 
            next(260, 10), 
            next(270, 11), 
            next(280, 12), 
            next(290, 13), 
            next(300, 14),
            completed(310)
        ])
        

        let res = scheduler.start { () -> Observable<Int> in
            let result: Observable<Int> = zip(e0, e1, e2, e3, e4, e5, e6, e7, e8, e9) { (_0, _1, _2, _3, _4, _5, _6, _7, _8, _9) -> Int in
                return (_0 + _1 + _2 + _3 + _4 + _5 + _6 + _7 + _8 + _9) 
            }

            return result
        }

        XCTAssertEqual(res.messages, [
            next(210, 50),
            completed(300)
        ])


        XCTAssertEqual(e0.subscriptions, [Subscription(200, 220)])
        XCTAssertEqual(e1.subscriptions, [Subscription(200, 230)])
        XCTAssertEqual(e2.subscriptions, [Subscription(200, 240)])
        XCTAssertEqual(e3.subscriptions, [Subscription(200, 250)])
        XCTAssertEqual(e4.subscriptions, [Subscription(200, 260)])
        XCTAssertEqual(e5.subscriptions, [Subscription(200, 270)])
        XCTAssertEqual(e6.subscriptions, [Subscription(200, 280)])
        XCTAssertEqual(e7.subscriptions, [Subscription(200, 290)])
        XCTAssertEqual(e8.subscriptions, [Subscription(200, 300)])
        XCTAssertEqual(e9.subscriptions, [Subscription(200, 300)])
    }



    


    func testZip_NeverEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let n = scheduler.createHotObservable([
            next(150, 1)
        ])

        let e = scheduler.createHotObservable([
            next(150, 1),
            completed(210)
        ])

        let res = scheduler.start {
            zip(n, e) { $0 + $1 }
        }

        XCTAssertEqual(res.messages, [])

        XCTAssertEqual(n.subscriptions, [
            Subscription(200, 1000)
        ])

        XCTAssertEqual(e.subscriptions, [
            Subscription(200, 210)
        ])
    }

    func testZip_EmptyNever() {
        let scheduler = TestScheduler(initialClock: 0)

        let n = scheduler.createHotObservable([
            next(150, 1)
        ])

        let e = scheduler.createHotObservable([
            next(150, 1),
            completed(210)
        ])

        let res = scheduler.start {
            zip(e, n) { $0 + $1 }
        }

        XCTAssertEqual(res.messages, [])

        XCTAssertEqual(n.subscriptions, [
            Subscription(200, 1000)
        ])

        XCTAssertEqual(e.subscriptions, [
            Subscription(200, 210)
        ])
    }

    func testZip_EmptyNonEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let e = scheduler.createHotObservable([
            next(150, 1),
            completed(210)
        ])

        let o = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(220)
        ])

        let res = scheduler.start {
            zip(e, o) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [completed(215)]
        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(e.subscriptions, [
            Subscription(200, 210)
        ])

        XCTAssertEqual(o.subscriptions, [
            Subscription(200, 215)
        ])
    }

    func testZip_NonEmptyEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let e = scheduler.createHotObservable([
            next(150, 1),
            completed(210)
        ])

        let o = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(220)
        ])

        let res = scheduler.start {
            zip(o, e) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [completed(215)]
        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(e.subscriptions, [
            Subscription(200, 210)
        ])

        XCTAssertEqual(o.subscriptions, [
            Subscription(200, 215)
        ])
    }

    func testZip_NeverNonEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let n = scheduler.createHotObservable([
            next(150, 1),
        ])

        let o = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(220)
        ])

        let res = scheduler.start {
            zip(n, o) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = []
        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(n.subscriptions, [
            Subscription(200, 1000)
        ])
    }

    func testZip_NonEmptyNever() {
        let scheduler = TestScheduler(initialClock: 0)

        let n = scheduler.createHotObservable([
            next(150, 1),
        ])

        let o = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(220)
        ])

        let res = scheduler.start {
            zip(o, n) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = []
        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(n.subscriptions, [
            Subscription(200, 1000)
        ])
    }

    func testZip_NonEmptyNonEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(230)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            next(220, 3),
            completed(240)
        ])

        let res = scheduler.start {
            zip(o1, o2) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            next(220, 2 + 3),
            completed(240)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 230)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 240)
        ])
    }

    func testZip_EmptyError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            completed(230)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError)
        ])

        let res = scheduler.start {
            zip(o1, o2) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_ErrorEmpty() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            completed(230)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError)
        ])

        let res = scheduler.start {
            zip(o2, o1) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_NeverError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError)
        ])

        let res = scheduler.start {
            zip(o1, o2) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_ErrorNever() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError)
        ])

        let res = scheduler.start {
            zip(o2, o1) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_ErrorError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            error(230, testError1)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError2)
        ])

        let res = scheduler.start {
            zip(o2, o1) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError2)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_SomeError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(230)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError1)
        ])

        let res = scheduler.start {
            zip(o1, o2) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError1)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_ErrorSome() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(215, 2),
            completed(230)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            error(220, testError1)
        ])

        let res = scheduler.start {
            zip(o2, o1) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError1)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_LeftCompletesFirst() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(210, 2),
            completed(220)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            next(215, 4),
            completed(225)
        ])

        let res = scheduler.start {
            zip(o1, o2) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            next(215, 2 + 4),
            completed(225)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 225)
        ])
    }

    func testZip_RightCompletesFirst() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(210, 2),
            completed(220)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            next(215, 4),
            completed(225)
        ])

        let res = scheduler.start {
            zip(o2, o1) { $0 + $1 }
        }
   
        let messages: [Recorded<Int>] = [
            next(215, 2 + 4),
            completed(225)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 225)
        ])
    }

    func testZip_LeftTriggersSelectorError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(220)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            next(210, 4),
        ])

        let res = scheduler.start {
            zipOrDie(o1, o2) { (_, _) -> RxResult<Int> in failure(testError) }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }

    func testZip_RightTriggersSelectorError() {
        let scheduler = TestScheduler(initialClock: 0)

        let o1 = scheduler.createHotObservable([
            next(150, 1),
            next(220, 2),
            completed(220)
        ])

        let o2 = scheduler.createHotObservable([
            next(150, 1),
            next(210, 4),
        ])

        let res = scheduler.start {
            zipOrDie(o2, o1) { (_, _) -> RxResult<Int> in failure(testError) }
        }
   
        let messages: [Recorded<Int>] = [
            error(220, testError)
        ]

        XCTAssertEqual(res.messages, messages)

        XCTAssertEqual(o1.subscriptions, [
            Subscription(200, 220)
        ])

        XCTAssertEqual(o2.subscriptions, [
            Subscription(200, 220)
        ])
    }







}
