// This file is autogenerated.
// Take a look at `Preprocessor` target in RxSwift project 
//
//  Zip+arity.tt
//  RxSwift
//
//  Created by Krunoslav Zaher on 5/23/15.
//  Copyright (c) 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation



// 2

public func zipOrDie<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> RxResult<R>)
    -> Observable<R> {
    return Zip2(
        source1: source1, source2: source2,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> R)
    -> Observable<R> {
    return Zip2(
        source1: source1, source2: source2,
        resultSelector: { success(resultSelector($0, $1)) }
    )
}

class ZipSink2_<E1, E2, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip2<E1, E2, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 2, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))

        self.observers = [
            observer1,
            observer2,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue())
    }
}

class Zip2<E1, E2, R> : Producer<R> {
    typealias ResultSelector = (E1, E2) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink2_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 3

public func zipOrDie<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> RxResult<R>)
    -> Observable<R> {
    return Zip3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> R)
    -> Observable<R> {
    return Zip3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: { success(resultSelector($0, $1, $2)) }
    )
}

class ZipSink3_<E1, E2, E3, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip3<E1, E2, E3, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 3, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))

        self.observers = [
            observer1,
            observer2,
            observer3,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue())
    }
}

class Zip3<E1, E2, E3, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink3_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 4

public func zipOrDie<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> RxResult<R>)
    -> Observable<R> {
    return Zip4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> R)
    -> Observable<R> {
    return Zip4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: { success(resultSelector($0, $1, $2, $3)) }
    )
}

class ZipSink4_<E1, E2, E3, E4, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip4<E1, E2, E3, E4, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 4, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue())
    }
}

class Zip4<E1, E2, E3, E4, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink4_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 5

public func zipOrDie<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> RxResult<R>)
    -> Observable<R> {
    return Zip5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> R)
    -> Observable<R> {
    return Zip5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4)) }
    )
}

class ZipSink5_<E1, E2, E3, E4, E5, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip5<E1, E2, E3, E4, E5, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 5, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue())
    }
}

class Zip5<E1, E2, E3, E4, E5, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink5_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 6

public func zipOrDie<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> RxResult<R>)
    -> Observable<R> {
    return Zip6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> R)
    -> Observable<R> {
    return Zip6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5)) }
    )
}

class ZipSink6_<E1, E2, E3, E4, E5, E6, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip6<E1, E2, E3, E4, E5, E6, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil
    var observer6: ZipObserver<E6>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 6, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)
        observer6 = ZipObserver(lock: lock, parent: self, index: 5, this: subscription6)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))
        subscription6.setDisposable(parent.source6.subscribe(observer6))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
            observer6,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue(), observer6.values.dequeue())
    }
}

class Zip6<E1, E2, E3, E4, E5, E6, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink6_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 7

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>)
    -> Observable<R> {
    return Zip7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> R)
    -> Observable<R> {
    return Zip7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6)) }
    )
}

class ZipSink7_<E1, E2, E3, E4, E5, E6, E7, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip7<E1, E2, E3, E4, E5, E6, E7, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil
    var observer6: ZipObserver<E6>! = nil
    var observer7: ZipObserver<E7>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 7, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)
        observer6 = ZipObserver(lock: lock, parent: self, index: 5, this: subscription6)
        observer7 = ZipObserver(lock: lock, parent: self, index: 6, this: subscription7)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))
        subscription6.setDisposable(parent.source6.subscribe(observer6))
        subscription7.setDisposable(parent.source7.subscribe(observer7))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
            observer6,
            observer7,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue(), observer6.values.dequeue(), observer7.values.dequeue())
    }
}

class Zip7<E1, E2, E3, E4, E5, E6, E7, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink7_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 8

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>)
    -> Observable<R> {
    return Zip8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> R)
    -> Observable<R> {
    return Zip8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7)) }
    )
}

class ZipSink8_<E1, E2, E3, E4, E5, E6, E7, E8, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip8<E1, E2, E3, E4, E5, E6, E7, E8, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil
    var observer6: ZipObserver<E6>! = nil
    var observer7: ZipObserver<E7>! = nil
    var observer8: ZipObserver<E8>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 8, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)
        observer6 = ZipObserver(lock: lock, parent: self, index: 5, this: subscription6)
        observer7 = ZipObserver(lock: lock, parent: self, index: 6, this: subscription7)
        observer8 = ZipObserver(lock: lock, parent: self, index: 7, this: subscription8)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))
        subscription6.setDisposable(parent.source6.subscribe(observer6))
        subscription7.setDisposable(parent.source7.subscribe(observer7))
        subscription8.setDisposable(parent.source8.subscribe(observer8))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
            observer6,
            observer7,
            observer8,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue(), observer6.values.dequeue(), observer7.values.dequeue(), observer8.values.dequeue())
    }
}

class Zip8<E1, E2, E3, E4, E5, E6, E7, E8, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink8_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 9

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>)
    -> Observable<R> {
    return Zip9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> R)
    -> Observable<R> {
    return Zip9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8)) }
    )
}

class ZipSink9_<E1, E2, E3, E4, E5, E6, E7, E8, E9, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil
    var observer6: ZipObserver<E6>! = nil
    var observer7: ZipObserver<E7>! = nil
    var observer8: ZipObserver<E8>! = nil
    var observer9: ZipObserver<E9>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 9, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)
        observer6 = ZipObserver(lock: lock, parent: self, index: 5, this: subscription6)
        observer7 = ZipObserver(lock: lock, parent: self, index: 6, this: subscription7)
        observer8 = ZipObserver(lock: lock, parent: self, index: 7, this: subscription8)
        observer9 = ZipObserver(lock: lock, parent: self, index: 8, this: subscription9)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))
        subscription6.setDisposable(parent.source6.subscribe(observer6))
        subscription7.setDisposable(parent.source7.subscribe(observer7))
        subscription8.setDisposable(parent.source8.subscribe(observer8))
        subscription9.setDisposable(parent.source9.subscribe(observer9))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
            observer6,
            observer7,
            observer8,
            observer9,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8,
           subscription9
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue(), observer6.values.dequeue(), observer7.values.dequeue(), observer8.values.dequeue(), observer9.values.dequeue())
    }
}

class Zip9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink9_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 10

public func zipOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>)
    -> Observable<R> {
    return Zip10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: resultSelector
    )
}

public func zip<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> R)
    -> Observable<R> {
    return Zip10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8, $9)) }
    )
}

class ZipSink10_<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, O: ObserverType> : ZipSink<O> {
    typealias R = O.Element
    typealias Parent = Zip10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>

    let parent: Parent

        var observer1: ZipObserver<E1>! = nil
    var observer2: ZipObserver<E2>! = nil
    var observer3: ZipObserver<E3>! = nil
    var observer4: ZipObserver<E4>! = nil
    var observer5: ZipObserver<E5>! = nil
    var observer6: ZipObserver<E6>! = nil
    var observer7: ZipObserver<E7>! = nil
    var observer8: ZipObserver<E8>! = nil
    var observer9: ZipObserver<E9>! = nil
    var observer10: ZipObserver<E10>! = nil

    init(parent: Parent, observer: O, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 10, observer: observer, cancel: cancel)
    }

    func run() -> Disposable {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()
        let subscription10 = SingleAssignmentDisposable()

        observer1 = ZipObserver(lock: lock, parent: self, index: 0, this: subscription1)
        observer2 = ZipObserver(lock: lock, parent: self, index: 1, this: subscription2)
        observer3 = ZipObserver(lock: lock, parent: self, index: 2, this: subscription3)
        observer4 = ZipObserver(lock: lock, parent: self, index: 3, this: subscription4)
        observer5 = ZipObserver(lock: lock, parent: self, index: 4, this: subscription5)
        observer6 = ZipObserver(lock: lock, parent: self, index: 5, this: subscription6)
        observer7 = ZipObserver(lock: lock, parent: self, index: 6, this: subscription7)
        observer8 = ZipObserver(lock: lock, parent: self, index: 7, this: subscription8)
        observer9 = ZipObserver(lock: lock, parent: self, index: 8, this: subscription9)
        observer10 = ZipObserver(lock: lock, parent: self, index: 9, this: subscription10)

        subscription1.setDisposable(parent.source1.subscribe(observer1))
        subscription2.setDisposable(parent.source2.subscribe(observer2))
        subscription3.setDisposable(parent.source3.subscribe(observer3))
        subscription4.setDisposable(parent.source4.subscribe(observer4))
        subscription5.setDisposable(parent.source5.subscribe(observer5))
        subscription6.setDisposable(parent.source6.subscribe(observer6))
        subscription7.setDisposable(parent.source7.subscribe(observer7))
        subscription8.setDisposable(parent.source8.subscribe(observer8))
        subscription9.setDisposable(parent.source9.subscribe(observer9))
        subscription10.setDisposable(parent.source10.subscribe(observer10))

        self.observers = [
            observer1,
            observer2,
            observer3,
            observer4,
            observer5,
            observer6,
            observer7,
            observer8,
            observer9,
            observer10,
        ]

        return CompositeDisposable(disposables: [
           subscription1,
           subscription2,
           subscription3,
           subscription4,
           subscription5,
           subscription6,
           subscription7,
           subscription8,
           subscription9,
           subscription10
        ])
    }

    override func getResult() -> RxResult<R> {
        return self.parent.resultSelector(observer1.values.dequeue(), observer2.values.dequeue(), observer3.values.dequeue(), observer4.values.dequeue(), observer5.values.dequeue(), observer6.values.dequeue(), observer7.values.dequeue(), observer8.values.dequeue(), observer9.values.dequeue(), observer10.values.dequeue())
    }
}

class Zip10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> RxResult<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>
    let source10: Observable<E10>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9
        self.source10 = source10

        self.resultSelector = resultSelector
    }

    override func run<O: ObserverType where O.Element == R>(observer: O, cancel: Disposable, setSink: (Disposable) -> Void) -> Disposable {
        let sink = ZipSink10_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}

