// This file is autogenerated.
// Take a look at `Preprocessor` target in RxSwift project 
//
//  CombineLatest.tt.swift
//  RxSwift
//
//  Created by Krunoslav Zaher on 4/22/15.
//  Copyright (c) 2015 Krunoslav Zaher. All rights reserved.
//

import Foundation



// 2

public func combineLatestOrDie<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> Result<R>)
        -> Observable<R> {
    return CombineLatest2(
        source1: source1, source2: source2,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, R>
    (source1: Observable<E1>, source2: Observable<E2>, resultSelector: (E1, E2) -> R)
        -> Observable<R> {
    return CombineLatest2(
        source1: source1, source2: source2,
        resultSelector: { success(resultSelector($0, $1)) }
    )
}

class CombineLatestSink2_<E1, E2, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest2<E1, E2, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 2, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value)
    }
}

class CombineLatest2<E1, E2, R> : Producer<R> {
    typealias ResultSelector = (E1, E2) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink2_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 3

public func combineLatestOrDie<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> Result<R>)
        -> Observable<R> {
    return CombineLatest3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: (E1, E2, E3) -> R)
        -> Observable<R> {
    return CombineLatest3(
        source1: source1, source2: source2, source3: source3,
        resultSelector: { success(resultSelector($0, $1, $2)) }
    )
}

class CombineLatestSink3_<E1, E2, E3, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest3<E1, E2, E3, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 3, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value)
    }
}

class CombineLatest3<E1, E2, E3, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink3_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 4

public func combineLatestOrDie<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> Result<R>)
        -> Observable<R> {
    return CombineLatest4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: (E1, E2, E3, E4) -> R)
        -> Observable<R> {
    return CombineLatest4(
        source1: source1, source2: source2, source3: source3, source4: source4,
        resultSelector: { success(resultSelector($0, $1, $2, $3)) }
    )
}

class CombineLatestSink4_<E1, E2, E3, E4, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest4<E1, E2, E3, E4, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 4, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value)
    }
}

class CombineLatest4<E1, E2, E3, E4, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink4_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 5

public func combineLatestOrDie<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> Result<R>)
        -> Observable<R> {
    return CombineLatest5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: (E1, E2, E3, E4, E5) -> R)
        -> Observable<R> {
    return CombineLatest5(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4)) }
    )
}

class CombineLatestSink5_<E1, E2, E3, E4, E5, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest5<E1, E2, E3, E4, E5, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 5, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value)
    }
}

class CombineLatest5<E1, E2, E3, E4, E5, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink5_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 6

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> Result<R>)
        -> Observable<R> {
    return CombineLatest6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: (E1, E2, E3, E4, E5, E6) -> R)
        -> Observable<R> {
    return CombineLatest6(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5)) }
    )
}

class CombineLatestSink6_<E1, E2, E3, E4, E5, E6, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest6<E1, E2, E3, E4, E5, E6, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil
    var observer6: CombineLatestObserver<E6>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 6, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)
        observer6 = CombineLatestObserver(parent: self, index: 5, this: subscription6)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))
        subscription6.setDisposable(*parent.source6.subscribeSafe(ObserverOf(observer6)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value, observer6.value)
    }
}

class CombineLatest6<E1, E2, E3, E4, E5, E6, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink6_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 7

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> Result<R>)
        -> Observable<R> {
    return CombineLatest7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: (E1, E2, E3, E4, E5, E6, E7) -> R)
        -> Observable<R> {
    return CombineLatest7(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6)) }
    )
}

class CombineLatestSink7_<E1, E2, E3, E4, E5, E6, E7, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest7<E1, E2, E3, E4, E5, E6, E7, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil
    var observer6: CombineLatestObserver<E6>! = nil
    var observer7: CombineLatestObserver<E7>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 7, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)
        observer6 = CombineLatestObserver(parent: self, index: 5, this: subscription6)
        observer7 = CombineLatestObserver(parent: self, index: 6, this: subscription7)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))
        subscription6.setDisposable(*parent.source6.subscribeSafe(ObserverOf(observer6)))
        subscription7.setDisposable(*parent.source7.subscribeSafe(ObserverOf(observer7)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value, observer6.value, observer7.value)
    }
}

class CombineLatest7<E1, E2, E3, E4, E5, E6, E7, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink7_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 8

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> Result<R>)
        -> Observable<R> {
    return CombineLatest8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8) -> R)
        -> Observable<R> {
    return CombineLatest8(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7)) }
    )
}

class CombineLatestSink8_<E1, E2, E3, E4, E5, E6, E7, E8, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest8<E1, E2, E3, E4, E5, E6, E7, E8, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil
    var observer6: CombineLatestObserver<E6>! = nil
    var observer7: CombineLatestObserver<E7>! = nil
    var observer8: CombineLatestObserver<E8>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 8, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)
        observer6 = CombineLatestObserver(parent: self, index: 5, this: subscription6)
        observer7 = CombineLatestObserver(parent: self, index: 6, this: subscription7)
        observer8 = CombineLatestObserver(parent: self, index: 7, this: subscription8)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))
        subscription6.setDisposable(*parent.source6.subscribeSafe(ObserverOf(observer6)))
        subscription7.setDisposable(*parent.source7.subscribeSafe(ObserverOf(observer7)))
        subscription8.setDisposable(*parent.source8.subscribeSafe(ObserverOf(observer8)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value, observer6.value, observer7.value, observer8.value)
    }
}

class CombineLatest8<E1, E2, E3, E4, E5, E6, E7, E8, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink8_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 9

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> Result<R>)
        -> Observable<R> {
    return CombineLatest9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> R)
        -> Observable<R> {
    return CombineLatest9(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8)) }
    )
}

class CombineLatestSink9_<E1, E2, E3, E4, E5, E6, E7, E8, E9, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil
    var observer6: CombineLatestObserver<E6>! = nil
    var observer7: CombineLatestObserver<E7>! = nil
    var observer8: CombineLatestObserver<E8>! = nil
    var observer9: CombineLatestObserver<E9>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 9, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)
        observer6 = CombineLatestObserver(parent: self, index: 5, this: subscription6)
        observer7 = CombineLatestObserver(parent: self, index: 6, this: subscription7)
        observer8 = CombineLatestObserver(parent: self, index: 7, this: subscription8)
        observer9 = CombineLatestObserver(parent: self, index: 8, this: subscription9)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))
        subscription6.setDisposable(*parent.source6.subscribeSafe(ObserverOf(observer6)))
        subscription7.setDisposable(*parent.source7.subscribeSafe(ObserverOf(observer7)))
        subscription8.setDisposable(*parent.source8.subscribeSafe(ObserverOf(observer8)))
        subscription9.setDisposable(*parent.source9.subscribeSafe(ObserverOf(observer9)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8,
                subscription9
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value, observer6.value, observer7.value, observer8.value, observer9.value)
    }
}

class CombineLatest9<E1, E2, E3, E4, E5, E6, E7, E8, E9, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink9_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}



// 10

public func combineLatestOrDie<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> Result<R>)
        -> Observable<R> {
    return CombineLatest10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: resultSelector
    )
}

public func combineLatest<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>
    (source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> R)
        -> Observable<R> {
    return CombineLatest10(
        source1: source1, source2: source2, source3: source3, source4: source4, source5: source5, source6: source6, source7: source7, source8: source8, source9: source9, source10: source10,
        resultSelector: { success(resultSelector($0, $1, $2, $3, $4, $5, $6, $7, $8, $9)) }
    )
}

class CombineLatestSink10_<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R> : CombineLatestSink<R> {
    typealias Parent = CombineLatest10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R>

    let parent: Parent

    var observer1: CombineLatestObserver<E1>! = nil
    var observer2: CombineLatestObserver<E2>! = nil
    var observer3: CombineLatestObserver<E3>! = nil
    var observer4: CombineLatestObserver<E4>! = nil
    var observer5: CombineLatestObserver<E5>! = nil
    var observer6: CombineLatestObserver<E6>! = nil
    var observer7: CombineLatestObserver<E7>! = nil
    var observer8: CombineLatestObserver<E8>! = nil
    var observer9: CombineLatestObserver<E9>! = nil
    var observer10: CombineLatestObserver<E10>! = nil

    init(parent: Parent, observer: ObserverOf<R>, cancel: Disposable) {
        self.parent = parent
        super.init(arity: 10, observer: observer, cancel: cancel)
    }

    func run() -> Result<Disposable> {
        let subscription1 = SingleAssignmentDisposable()
        let subscription2 = SingleAssignmentDisposable()
        let subscription3 = SingleAssignmentDisposable()
        let subscription4 = SingleAssignmentDisposable()
        let subscription5 = SingleAssignmentDisposable()
        let subscription6 = SingleAssignmentDisposable()
        let subscription7 = SingleAssignmentDisposable()
        let subscription8 = SingleAssignmentDisposable()
        let subscription9 = SingleAssignmentDisposable()
        let subscription10 = SingleAssignmentDisposable()

        observer1 = CombineLatestObserver(parent: self, index: 0, this: subscription1)
        observer2 = CombineLatestObserver(parent: self, index: 1, this: subscription2)
        observer3 = CombineLatestObserver(parent: self, index: 2, this: subscription3)
        observer4 = CombineLatestObserver(parent: self, index: 3, this: subscription4)
        observer5 = CombineLatestObserver(parent: self, index: 4, this: subscription5)
        observer6 = CombineLatestObserver(parent: self, index: 5, this: subscription6)
        observer7 = CombineLatestObserver(parent: self, index: 6, this: subscription7)
        observer8 = CombineLatestObserver(parent: self, index: 7, this: subscription8)
        observer9 = CombineLatestObserver(parent: self, index: 8, this: subscription9)
        observer10 = CombineLatestObserver(parent: self, index: 9, this: subscription10)

        subscription1.setDisposable(*parent.source1.subscribeSafe(ObserverOf(observer1)))
        subscription2.setDisposable(*parent.source2.subscribeSafe(ObserverOf(observer2)))
        subscription3.setDisposable(*parent.source3.subscribeSafe(ObserverOf(observer3)))
        subscription4.setDisposable(*parent.source4.subscribeSafe(ObserverOf(observer4)))
        subscription5.setDisposable(*parent.source5.subscribeSafe(ObserverOf(observer5)))
        subscription6.setDisposable(*parent.source6.subscribeSafe(ObserverOf(observer6)))
        subscription7.setDisposable(*parent.source7.subscribeSafe(ObserverOf(observer7)))
        subscription8.setDisposable(*parent.source8.subscribeSafe(ObserverOf(observer8)))
        subscription9.setDisposable(*parent.source9.subscribeSafe(ObserverOf(observer9)))
        subscription10.setDisposable(*parent.source10.subscribeSafe(ObserverOf(observer10)))

        return success(CompositeDisposable(disposables: [
                subscription1,
                subscription2,
                subscription3,
                subscription4,
                subscription5,
                subscription6,
                subscription7,
                subscription8,
                subscription9,
                subscription10
        ]))
    }

    override func getResult() -> Result<R> {
        return self.parent.resultSelector(observer1.value, observer2.value, observer3.value, observer4.value, observer5.value, observer6.value, observer7.value, observer8.value, observer9.value, observer10.value)
    }
}

class CombineLatest10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, R> : Producer<R> {
    typealias ResultSelector = (E1, E2, E3, E4, E5, E6, E7, E8, E9, E10) -> Result<R>

    let source1: Observable<E1>
    let source2: Observable<E2>
    let source3: Observable<E3>
    let source4: Observable<E4>
    let source5: Observable<E5>
    let source6: Observable<E6>
    let source7: Observable<E7>
    let source8: Observable<E8>
    let source9: Observable<E9>
    let source10: Observable<E10>

    let resultSelector: ResultSelector

    init(source1: Observable<E1>, source2: Observable<E2>, source3: Observable<E3>, source4: Observable<E4>, source5: Observable<E5>, source6: Observable<E6>, source7: Observable<E7>, source8: Observable<E8>, source9: Observable<E9>, source10: Observable<E10>, resultSelector: ResultSelector) {
        self.source1 = source1
        self.source2 = source2
        self.source3 = source3
        self.source4 = source4
        self.source5 = source5
        self.source6 = source6
        self.source7 = source7
        self.source8 = source8
        self.source9 = source9
        self.source10 = source10

        self.resultSelector = resultSelector
    }

    override func run(observer: ObserverOf<R>, cancel: Disposable, setSink: (Disposable) -> Void) -> Result<Disposable> {
        let sink = CombineLatestSink10_(parent: self, observer: observer, cancel: cancel)
        setSink(sink)
        return sink.run()
    }
}

