# QuecPython Meter-Box解决方案

中文 | [English](README.MD)

欢迎来到 QuecPython Meter-Box解决方案仓库！

## 仓库目录

```plaintext
meter-box/
├──fw                          #QuecPython固件
├──media                       #项目相关图片
├── src/
│   ├── _main.py               # 程序入口，创建应用、等待网络、启动应用
│   ├── config.json            # 配置文件（产品密钥、服务器地址等）
│   ├── Qth/                   # 移远云平台相关API
│   ├── extensions/            # 扩展模块
│   │   ├── __init__.py        # 导出qth_client和meter_service实例
│   │   ├── qth_client.py      # QTH客户端模块（MQTT通信、数据上报等）
│   │   └── meter_service.py   # 仪表服务模块（模拟数据生成、定时更新）
│   └── libs/                  # 基础库
│       ├── __init__.py        # 导出常用工具类
│       ├── collections.py     # 单例模式实现
│       ├── common.py          # 配置存储类（基于JSON文件）
│       ├── logging.py         # 日志工具类
│       └── threading.py       # 线程结果处理工具
├── LICENSE
├── README.md
├── README_ZH.md
```

## 方案介绍

QuecPython针对智能测量领域，结合移远云平台推出了meter-box一站式解决方案，实现手机终端远程获取测量数据，控制设备等功能。

本方案已目前应用较为广泛的智能电表为例子，实现远程抄表功能。

​	![](./media/app.png)





## 快速开始

### 先决条件

在开始之前，请确保您具备以下先决条件：

- **硬件**：

  - meter-box产品或产品对应的开发板（BG95M3系列和EG912U系列）

    ​	<img src="./media/product.png" style="zoom:50%;" />

  - USB 数据线（USB-A 转 USB-C）
  - 电脑（Windows 7、Windows 10 或 Windows 11）

- **软件**：

  - QuecPython 模块的 [USB 驱动](https://developer.quectel.com/resource-download?cid=5)（根据搭载的模组型号进行选择）
  - [QPYcom](https://developer.quectel.com/wp-content/uploads/2024/09/QPYcom_V3.9.0.zip) 调试工具
  - [QuecPython 固件](https://developer.quectel.com/resource-download?cid=15)及相关软件资源（根据搭载的模组型号进行选择）
  - Python 文本编辑器（例如，[VSCode](https://code.visualstudio.com/)、[Pycharm](https://www.jetbrains.com/pycharm/download/)）

### 安装

1. **克隆仓库**：

   ```bash
   git clone https://github.com/QuecPython/meter-box.git
   cd meter-box
   ```

2. **烧录固件**：

   按照[说明](https://developer.quectel.com/doc/quecpython/Application_guide/zh/dev-tools/QPYcom/qpycom-dw.html#%E4%B8%8B%E8%BD%BD%E5%9B%BA%E4%BB%B6)将固件烧录到开发板上。

### 运行应用程序

1. **连接硬件**：

   - 使用 USB 数据线将meter-box连接到计算机的 USB 端口。

     ​	<img src="./media/connect.png" style="zoom: 67%;" />

2. **将代码下载到设备**：

   - 启动 QPYcom 调试工具。
   - 将数据线连接到计算机。
   - 按下产品上的开关按钮启动设备。
   - 按照[说明](https://developer.quectel.com/doc/quecpython/Getting_started/zh/4G/first_python.html)将 `src` 文件夹中的所有文件导入到模块的文件系统中，保留目录结构。

3. **运行应用程序**：

   - 选择 `File` 选项卡。

   - 选择 `_main.py` 脚本。

   - 右键单击并选择 `Run` 或使用`运行`快捷按钮执行脚本。

     ​	<img src="./media/start.png" style="zoom: 80%;" />

## 使用

点击[这里](https://developer.quectel.com/doc/quecpython/Application_guide/zh/solutions/meter-box)查看Meter-Box解决方案的详细实现。

## 贡献

我们欢迎对本项目的改进做出贡献！请按照以下步骤进行贡献：

1. Fork 此仓库。
2. 创建一个新分支（`git checkout -b feature/your-feature`）。
3. 提交您的更改（`git commit -m 'Add your feature'`）。
4. 推送到分支（`git push origin feature/your-feature`）。
5. 打开一个 Pull Request。

## 许可证

本项目使用 Apache 许可证。详细信息请参阅 [LICENSE](LICENSE) 文件。

## 支持

如果您有任何问题或需要支持，请参阅 [QuecPython 文档](https://developer.quectel.com/doc) 或在本仓库中打开一个 issue。
