# QuecPython Meter-Box Solution

[中文](README_ZH.md) | English

Welcome to the QuecPython Meter-Box Solution repository!

## Repository Structure

```plaintext
meter-box/
├──fw                          #QuecPython firmware
├──media                       #Project related images
├── src/
│   ├── _main.py               #Program entry point, create application, wait for network, start application
│   ├── config.json            #Configuration file (product key, server address, etc.)
│   ├── Qth/                   #Quectel Cloud platform related APIs
│   ├── extensions/            #Extension modules
│   │   ├── __init__.py        #Export qth_client and meter_service instances
│   │   ├── qth_client.py      #QTH client module (MQTT communication, data reporting, etc.)
│   │   └── meter_service.py   #Meter service module (simulated data generation)
│   └── libs/                  #Basic libraries
│       ├── __init__.py        #Export common utility classes
│       ├── collections.py     #Singleton pattern implementation
│       ├── common.py          #Configuration storage class (based on JSON file)
│       ├── logging.py         #Logging utility class
│       └── threading.py       #Thread result processing utility
├── LICENSE
├── README.md
├── README_ZH.md
```

## Solution Introduction

QuecPython has launched a one-stop meter-box solution for the intelligent measurement field, combined with Quectel Cloud platform, enabling mobile terminals to remotely acquire measurement data and control devices.

This solution takes the currently widely used smart electricity meter as an example to implement remote meter reading functionality.

​	![](./media/app.png)

## Quick Start

### Prerequisites

Before you begin, ensure you have met the following prerequisites:

* **Hardware**:


    * meter-box product or corresponding development board (BG95M3 series and EG912U series)<img src="./media/product.png" style="zoom: 50%;" />

  * USB data cable (USB-A to USB-C)


  * Computer (Windows 7, Windows 10, or Windows 11)


- **Software**:


    * [USB driver](https://developer.quectel.com/resource-download?cid=5) for QuecPython module (select according to the module model)



    * [QPYcom](https://developer.quectel.com/wp-content/uploads/2024/09/QPYcom_V3.9.0.zip) debugging tool



    * [QuecPython firmware](https://developer.quectel.com/resource-download?cid=15) and related software resources (select according to the module model)



    * Python text editor (e.g., [VSCode](https://code.visualstudio.com/), [Pycharm](https://www.jetbrains.com/pycharm/download/))


### Installation

**Clone the repository**:

```bash
git clone https://github.com/QuecPython/meter-box.git
cd meter-box
```

**Flash firmware**:

Flash the firmware to the development board according to the [instructions](https://developer.quectel.com/doc/quecpython/Application_guide/en/dev-tools/QPYcom/qpycom-dw.html#Download-Firmware).

### Running the Application

**Connect hardware**:

* Use a USB data cable to connect the meter-box to your computer's USB port.

​	<img src="./media/connect.png" style="zoom:80%;" />

**Download code to device**:

* Launch the QPYcom debugging tool.

* Connect the data cable to your computer.

* Press the switch button on the product to start the device.

* Import all files from the `src` folder into the module's file system while preserving the directory structure, following the [instructions](https://developer.quectel.com/doc/quecpython/Getting_started/en/4G/first_python.html).

**Run the application**:

* Select the `File` tab.

* Select the `_main.py` script.

* Right-click and select `Run` or use the run shortcut button to execute the script.

​	<img src="./media/start.png" style="zoom: 80%;" />

## Usage

Click [here](https://developer.quectel.com/doc/quecpython/Application_guide/en/solutions/meter-box) to view the detailed implementation of the Meter-Box solution.

## Contribution

We welcome contributions to improve this project! Please follow these steps to contribute:

1. Fork this repository.

2. Create a new branch (`git checkout -b feature/your-feature`).

3. Commit your changes (`git commit -m 'Add your feature'`).

4. Push to the branch (`git push origin feature/your-feature`).

5. Open a Pull Request.

## License

This project is licensed under the Apache License. For detailed information, please refer to the [LICENSE](LICENSE) file.

## Support

If you have any questions or need support, please refer to the [QuecPython Documentation](https://developer.quectel.com/doc) or open an issue in this repository.
