//
//  UnitIdentifierTests.swift
//  Bluetooth
//

import Foundation
import Testing
@testable import Bluetooth

// swiftlint:disable type_body_length
#if !SWIFTPM_ENABLE_PLUGINS && !os(WASI)
@Suite
struct UnitIdentifierTests {

    @Test func units() {

        // unitless
        #expect(UnitIdentifier.unitless.rawValue == 0x2700)
        #expect(UnitIdentifier.unitless.type == #"org.bluetooth.unit.unitless"#)
        #expect(UnitIdentifier.unitless.name == #"unitless"#)
        #expect(UnitIdentifier.unitless.description == #"0x2700 (unitless)"#)
    
        // length (metre)
        #expect(UnitIdentifier.metre.rawValue == 0x2701)
        #expect(UnitIdentifier.metre.type == #"org.bluetooth.unit.length.metre"#)
        #expect(UnitIdentifier.metre.name == #"length (metre)"#)
        #expect(UnitIdentifier.metre.description == #"0x2701 (length (metre))"#)
    
        // mass (kilogram)
        #expect(UnitIdentifier.kilogram.rawValue == 0x2702)
        #expect(UnitIdentifier.kilogram.type == #"org.bluetooth.unit.mass.kilogram"#)
        #expect(UnitIdentifier.kilogram.name == #"mass (kilogram)"#)
        #expect(UnitIdentifier.kilogram.description == #"0x2702 (mass (kilogram))"#)
    
        // time (second)
        #expect(UnitIdentifier.second.rawValue == 0x2703)
        #expect(UnitIdentifier.second.type == #"org.bluetooth.unit.time.second"#)
        #expect(UnitIdentifier.second.name == #"time (second)"#)
        #expect(UnitIdentifier.second.description == #"0x2703 (time (second))"#)
    
        // electric current (ampere)
        #expect(UnitIdentifier.ampere.rawValue == 0x2704)
        #expect(UnitIdentifier.ampere.type == #"org.bluetooth.unit.electric_current.ampere"#)
        #expect(UnitIdentifier.ampere.name == #"electric current (ampere)"#)
        #expect(UnitIdentifier.ampere.description == #"0x2704 (electric current (ampere))"#)
    
        // thermodynamic temperature (kelvin)
        #expect(UnitIdentifier.kelvin.rawValue == 0x2705)
        #expect(UnitIdentifier.kelvin.type == #"org.bluetooth.unit.thermodynamic_temperature.kelvin"#)
        #expect(UnitIdentifier.kelvin.name == #"thermodynamic temperature (kelvin)"#)
        #expect(UnitIdentifier.kelvin.description == #"0x2705 (thermodynamic temperature (kelvin))"#)
    
        // amount of substance (mole)
        #expect(UnitIdentifier.mole.rawValue == 0x2706)
        #expect(UnitIdentifier.mole.type == #"org.bluetooth.unit.amount_of_substance.mole"#)
        #expect(UnitIdentifier.mole.name == #"amount of substance (mole)"#)
        #expect(UnitIdentifier.mole.description == #"0x2706 (amount of substance (mole))"#)
    
        // luminous intensity (candela)
        #expect(UnitIdentifier.candela.rawValue == 0x2707)
        #expect(UnitIdentifier.candela.type == #"org.bluetooth.unit.luminous_intensity.candela"#)
        #expect(UnitIdentifier.candela.name == #"luminous intensity (candela)"#)
        #expect(UnitIdentifier.candela.description == #"0x2707 (luminous intensity (candela))"#)
    
        // area (square metres)
        #expect(UnitIdentifier.area.rawValue == 0x2710)
        #expect(UnitIdentifier.area.type == #"org.bluetooth.unit.area.square_metres"#)
        #expect(UnitIdentifier.area.name == #"area (square metres)"#)
        #expect(UnitIdentifier.area.description == #"0x2710 (area (square metres))"#)
    
        // volume (cubic metres)
        #expect(UnitIdentifier.volume.rawValue == 0x2711)
        #expect(UnitIdentifier.volume.type == #"org.bluetooth.unit.volume.cubic_metres"#)
        #expect(UnitIdentifier.volume.name == #"volume (cubic metres)"#)
        #expect(UnitIdentifier.volume.description == #"0x2711 (volume (cubic metres))"#)
    
        // velocity (metres per second)
        #expect(UnitIdentifier.velocity.rawValue == 0x2712)
        #expect(UnitIdentifier.velocity.type == #"org.bluetooth.unit.velocity.metres_per_second"#)
        #expect(UnitIdentifier.velocity.name == #"velocity (metres per second)"#)
        #expect(UnitIdentifier.velocity.description == #"0x2712 (velocity (metres per second))"#)
    
        // acceleration (metres per second squared)
        #expect(UnitIdentifier.acceleration.rawValue == 0x2713)
        #expect(UnitIdentifier.acceleration.type == #"org.bluetooth.unit.acceleration.metres_per_second_squared"#)
        #expect(UnitIdentifier.acceleration.name == #"acceleration (metres per second squared)"#)
        #expect(UnitIdentifier.acceleration.description == #"0x2713 (acceleration (metres per second squared))"#)
    
        // wavenumber (reciprocal metre)
        #expect(UnitIdentifier.wavenumber.rawValue == 0x2714)
        #expect(UnitIdentifier.wavenumber.type == #"org.bluetooth.unit.wavenumber.reciprocal_metre"#)
        #expect(UnitIdentifier.wavenumber.name == #"wavenumber (reciprocal metre)"#)
        #expect(UnitIdentifier.wavenumber.description == #"0x2714 (wavenumber (reciprocal metre))"#)
    
        // density (kilogram per cubic metre)
        #expect(UnitIdentifier.density.rawValue == 0x2715)
        #expect(UnitIdentifier.density.type == #"org.bluetooth.unit.density.kilogram_per_cubic_metre"#)
        #expect(UnitIdentifier.density.name == #"density (kilogram per cubic metre)"#)
        #expect(UnitIdentifier.density.description == #"0x2715 (density (kilogram per cubic metre))"#)
    
        // surface density (kilogram per square metre)
        #expect(UnitIdentifier.surfaceDensity.rawValue == 0x2716)
        #expect(UnitIdentifier.surfaceDensity.type == #"org.bluetooth.unit.surface_density.kilogram_per_square_metre"#)
        #expect(UnitIdentifier.surfaceDensity.name == #"surface density (kilogram per square metre)"#)
        #expect(UnitIdentifier.surfaceDensity.description == #"0x2716 (surface density (kilogram per square metre))"#)
    
        // specific volume (cubic metre per kilogram)
        #expect(UnitIdentifier.specificVolume.rawValue == 0x2717)
        #expect(UnitIdentifier.specificVolume.type == #"org.bluetooth.unit.specific_volume.cubic_metre_per_kilogram"#)
        #expect(UnitIdentifier.specificVolume.name == #"specific volume (cubic metre per kilogram)"#)
        #expect(UnitIdentifier.specificVolume.description == #"0x2717 (specific volume (cubic metre per kilogram))"#)
    
        // current density (ampere per square metre)
        #expect(UnitIdentifier.currentDensity.rawValue == 0x2718)
        #expect(UnitIdentifier.currentDensity.type == #"org.bluetooth.unit.current_density.ampere_per_square_metre"#)
        #expect(UnitIdentifier.currentDensity.name == #"current density (ampere per square metre)"#)
        #expect(UnitIdentifier.currentDensity.description == #"0x2718 (current density (ampere per square metre))"#)
    
        // magnetic field strength (ampere per metre)
        #expect(UnitIdentifier.magneticFieldStrengh.rawValue == 0x2719)
        #expect(UnitIdentifier.magneticFieldStrengh.type == #"org.bluetooth.unit.magnetic_field_strength.ampere_per_metre"#)
        #expect(UnitIdentifier.magneticFieldStrengh.name == #"magnetic field strength (ampere per metre)"#)
        #expect(UnitIdentifier.magneticFieldStrengh.description == #"0x2719 (magnetic field strength (ampere per metre))"#)
    
        // amount concentration (mole per cubic metre)
        #expect(UnitIdentifier.amountConcentration.rawValue == 0x271A)
        #expect(UnitIdentifier.amountConcentration.type == #"org.bluetooth.unit.amount_concentration.mole_per_cubic_metre"#)
        #expect(UnitIdentifier.amountConcentration.name == #"amount concentration (mole per cubic metre)"#)
        #expect(UnitIdentifier.amountConcentration.description == #"0x271A (amount concentration (mole per cubic metre))"#)
    
        // mass concentration (kilogram per cubic metre)
        #expect(UnitIdentifier.massConcentration.rawValue == 0x271B)
        #expect(UnitIdentifier.massConcentration.type == #"org.bluetooth.unit.mass_concentration.kilogram_per_cubic_metre"#)
        #expect(UnitIdentifier.massConcentration.name == #"mass concentration (kilogram per cubic metre)"#)
        #expect(UnitIdentifier.massConcentration.description == #"0x271B (mass concentration (kilogram per cubic metre))"#)
    
        // luminance (candela per square metre)
        #expect(UnitIdentifier.luminance.rawValue == 0x271C)
        #expect(UnitIdentifier.luminance.type == #"org.bluetooth.unit.luminance.candela_per_square_metre"#)
        #expect(UnitIdentifier.luminance.name == #"luminance (candela per square metre)"#)
        #expect(UnitIdentifier.luminance.description == #"0x271C (luminance (candela per square metre))"#)
    
        // refractive index
        #expect(UnitIdentifier.refractiveIndex.rawValue == 0x271D)
        #expect(UnitIdentifier.refractiveIndex.type == #"org.bluetooth.unit.refractive_index"#)
        #expect(UnitIdentifier.refractiveIndex.name == #"refractive index"#)
        #expect(UnitIdentifier.refractiveIndex.description == #"0x271D (refractive index)"#)
    
        // relative permeability
        #expect(UnitIdentifier.relativePermeability.rawValue == 0x271E)
        #expect(UnitIdentifier.relativePermeability.type == #"org.bluetooth.unit.relative_permeability"#)
        #expect(UnitIdentifier.relativePermeability.name == #"relative permeability"#)
        #expect(UnitIdentifier.relativePermeability.description == #"0x271E (relative permeability)"#)
    
        // plane angle (radian)
        #expect(UnitIdentifier.planeAngle.rawValue == 0x2720)
        #expect(UnitIdentifier.planeAngle.type == #"org.bluetooth.unit.plane_angle.radian"#)
        #expect(UnitIdentifier.planeAngle.name == #"plane angle (radian)"#)
        #expect(UnitIdentifier.planeAngle.description == #"0x2720 (plane angle (radian))"#)
    
        // solid angle (steradian)
        #expect(UnitIdentifier.solidAngle.rawValue == 0x2721)
        #expect(UnitIdentifier.solidAngle.type == #"org.bluetooth.unit.solid_angle.steradian"#)
        #expect(UnitIdentifier.solidAngle.name == #"solid angle (steradian)"#)
        #expect(UnitIdentifier.solidAngle.description == #"0x2721 (solid angle (steradian))"#)
    
        // frequency (hertz)
        #expect(UnitIdentifier.frequency.rawValue == 0x2722)
        #expect(UnitIdentifier.frequency.type == #"org.bluetooth.unit.frequency.hertz"#)
        #expect(UnitIdentifier.frequency.name == #"frequency (hertz)"#)
        #expect(UnitIdentifier.frequency.description == #"0x2722 (frequency (hertz))"#)
    
        // force (newton)
        #expect(UnitIdentifier.force.rawValue == 0x2723)
        #expect(UnitIdentifier.force.type == #"org.bluetooth.unit.force.newton"#)
        #expect(UnitIdentifier.force.name == #"force (newton)"#)
        #expect(UnitIdentifier.force.description == #"0x2723 (force (newton))"#)
    
        // pressure (pascal)
        #expect(UnitIdentifier.pascalPressure.rawValue == 0x2724)
        #expect(UnitIdentifier.pascalPressure.type == #"org.bluetooth.unit.pressure.pascal"#)
        #expect(UnitIdentifier.pascalPressure.name == #"pressure (pascal)"#)
        #expect(UnitIdentifier.pascalPressure.description == #"0x2724 (pressure (pascal))"#)
    
        // energy (joule)
        #expect(UnitIdentifier.energy.rawValue == 0x2725)
        #expect(UnitIdentifier.energy.type == #"org.bluetooth.unit.energy.joule"#)
        #expect(UnitIdentifier.energy.name == #"energy (joule)"#)
        #expect(UnitIdentifier.energy.description == #"0x2725 (energy (joule))"#)
    
        // power (watt)
        #expect(UnitIdentifier.power.rawValue == 0x2726)
        #expect(UnitIdentifier.power.type == #"org.bluetooth.unit.power.watt"#)
        #expect(UnitIdentifier.power.name == #"power (watt)"#)
        #expect(UnitIdentifier.power.description == #"0x2726 (power (watt))"#)
    
        // electric charge (coulomb)
        #expect(UnitIdentifier.coulomb.rawValue == 0x2727)
        #expect(UnitIdentifier.coulomb.type == #"org.bluetooth.unit.electric_charge.coulomb"#)
        #expect(UnitIdentifier.coulomb.name == #"electric charge (coulomb)"#)
        #expect(UnitIdentifier.coulomb.description == #"0x2727 (electric charge (coulomb))"#)
    
        // electric potential difference (volt)
        #expect(UnitIdentifier.electricPotential.rawValue == 0x2728)
        #expect(UnitIdentifier.electricPotential.type == #"org.bluetooth.unit.electric_potential_difference.volt"#)
        #expect(UnitIdentifier.electricPotential.name == #"electric potential difference (volt)"#)
        #expect(UnitIdentifier.electricPotential.description == #"0x2728 (electric potential difference (volt))"#)
    
        // capacitance (farad)
        #expect(UnitIdentifier.capitance.rawValue == 0x2729)
        #expect(UnitIdentifier.capitance.type == #"org.bluetooth.unit.capacitance.farad"#)
        #expect(UnitIdentifier.capitance.name == #"capacitance (farad)"#)
        #expect(UnitIdentifier.capitance.description == #"0x2729 (capacitance (farad))"#)
    
        // electric resistance (ohm)
        #expect(UnitIdentifier.electricResistance.rawValue == 0x272A)
        #expect(UnitIdentifier.electricResistance.type == #"org.bluetooth.unit.electric_resistance.ohm"#)
        #expect(UnitIdentifier.electricResistance.name == #"electric resistance (ohm)"#)
        #expect(UnitIdentifier.electricResistance.description == #"0x272A (electric resistance (ohm))"#)
    
        // electric conductance (siemens)
        #expect(UnitIdentifier.electricConductance.rawValue == 0x272B)
        #expect(UnitIdentifier.electricConductance.type == #"org.bluetooth.unit.electric_conductance.siemens"#)
        #expect(UnitIdentifier.electricConductance.name == #"electric conductance (siemens)"#)
        #expect(UnitIdentifier.electricConductance.description == #"0x272B (electric conductance (siemens))"#)
    
        // magnetic flux (weber)
        #expect(UnitIdentifier.magneticFlux.rawValue == 0x272C)
        #expect(UnitIdentifier.magneticFlux.type == #"org.bluetooth.unit.magnetic_flux.weber"#)
        #expect(UnitIdentifier.magneticFlux.name == #"magnetic flux (weber)"#)
        #expect(UnitIdentifier.magneticFlux.description == #"0x272C (magnetic flux (weber))"#)
    
        // magnetic flux density (tesla)
        #expect(UnitIdentifier.magneticFluxDensity.rawValue == 0x272D)
        #expect(UnitIdentifier.magneticFluxDensity.type == #"org.bluetooth.unit.magnetic_flux_density.tesla"#)
        #expect(UnitIdentifier.magneticFluxDensity.name == #"magnetic flux density (tesla)"#)
        #expect(UnitIdentifier.magneticFluxDensity.description == #"0x272D (magnetic flux density (tesla))"#)
    
        // inductance (henry)
        #expect(UnitIdentifier.inductance.rawValue == 0x272E)
        #expect(UnitIdentifier.inductance.type == #"org.bluetooth.unit.inductance.henry"#)
        #expect(UnitIdentifier.inductance.name == #"inductance (henry)"#)
        #expect(UnitIdentifier.inductance.description == #"0x272E (inductance (henry))"#)
    
        // Celsius temperature (degree Celsius)
        #expect(UnitIdentifier.celsius.rawValue == 0x272F)
        #expect(UnitIdentifier.celsius.type == #"org.bluetooth.unit.thermodynamic_temperature.degree_celsius"#)
        #expect(UnitIdentifier.celsius.name == #"Celsius temperature (degree Celsius)"#)
        #expect(UnitIdentifier.celsius.description == #"0x272F (Celsius temperature (degree Celsius))"#)
    
        // luminous flux (lumen)
        #expect(UnitIdentifier.luminousFlux.rawValue == 0x2730)
        #expect(UnitIdentifier.luminousFlux.type == #"org.bluetooth.unit.luminous_flux.lumen"#)
        #expect(UnitIdentifier.luminousFlux.name == #"luminous flux (lumen)"#)
        #expect(UnitIdentifier.luminousFlux.description == #"0x2730 (luminous flux (lumen))"#)
    
        // illuminance (lux)
        #expect(UnitIdentifier.illuminance.rawValue == 0x2731)
        #expect(UnitIdentifier.illuminance.type == #"org.bluetooth.unit.illuminance.lux"#)
        #expect(UnitIdentifier.illuminance.name == #"illuminance (lux)"#)
        #expect(UnitIdentifier.illuminance.description == #"0x2731 (illuminance (lux))"#)
    
        // activity referred to a radionuclide (becquerel)
        #expect(UnitIdentifier.becquerel.rawValue == 0x2732)
        #expect(UnitIdentifier.becquerel.type == #"org.bluetooth.unit.activity_referred_to_a_radionuclide.becquerel"#)
        #expect(UnitIdentifier.becquerel.name == #"activity referred to a radionuclide (becquerel)"#)
        #expect(UnitIdentifier.becquerel.description == #"0x2732 (activity referred to a radionuclide (becquerel))"#)
    
        // absorbed dose (gray)
        #expect(UnitIdentifier.absorbedDose.rawValue == 0x2733)
        #expect(UnitIdentifier.absorbedDose.type == #"org.bluetooth.unit.absorbed_dose.gray"#)
        #expect(UnitIdentifier.absorbedDose.name == #"absorbed dose (gray)"#)
        #expect(UnitIdentifier.absorbedDose.description == #"0x2733 (absorbed dose (gray))"#)
    
        // dose equivalent (sievert)
        #expect(UnitIdentifier.sievert.rawValue == 0x2734)
        #expect(UnitIdentifier.sievert.type == #"org.bluetooth.unit.dose_equivalent.sievert"#)
        #expect(UnitIdentifier.sievert.name == #"dose equivalent (sievert)"#)
        #expect(UnitIdentifier.sievert.description == #"0x2734 (dose equivalent (sievert))"#)
    
        // catalytic activity (katal)
        #expect(UnitIdentifier.katal.rawValue == 0x2735)
        #expect(UnitIdentifier.katal.type == #"org.bluetooth.unit.catalytic_activity.katal"#)
        #expect(UnitIdentifier.katal.name == #"catalytic activity (katal)"#)
        #expect(UnitIdentifier.katal.description == #"0x2735 (catalytic activity (katal))"#)
    
        // dynamic viscosity (pascal second)
        #expect(UnitIdentifier.pascalSecond.rawValue == 0x2740)
        #expect(UnitIdentifier.pascalSecond.type == #"org.bluetooth.unit.dynamic_viscosity.pascal_second"#)
        #expect(UnitIdentifier.pascalSecond.name == #"dynamic viscosity (pascal second)"#)
        #expect(UnitIdentifier.pascalSecond.description == #"0x2740 (dynamic viscosity (pascal second))"#)
    
        // moment of force (newton metre)
        #expect(UnitIdentifier.newtonMetre.rawValue == 0x2741)
        #expect(UnitIdentifier.newtonMetre.type == #"org.bluetooth.unit.moment_of_force.newton_metre"#)
        #expect(UnitIdentifier.newtonMetre.name == #"moment of force (newton metre)"#)
        #expect(UnitIdentifier.newtonMetre.description == #"0x2741 (moment of force (newton metre))"#)
    
        // surface tension (newton per metre)
        #expect(UnitIdentifier.surfaceTension.rawValue == 0x2742)
        #expect(UnitIdentifier.surfaceTension.type == #"org.bluetooth.unit.surface_tension.newton_per_metre"#)
        #expect(UnitIdentifier.surfaceTension.name == #"surface tension (newton per metre)"#)
        #expect(UnitIdentifier.surfaceTension.description == #"0x2742 (surface tension (newton per metre))"#)
    
        // angular velocity (radian per second)
        #expect(UnitIdentifier.angularVelocity.rawValue == 0x2743)
        #expect(UnitIdentifier.angularVelocity.type == #"org.bluetooth.unit.angular_velocity.radian_per_second"#)
        #expect(UnitIdentifier.angularVelocity.name == #"angular velocity (radian per second)"#)
        #expect(UnitIdentifier.angularVelocity.description == #"0x2743 (angular velocity (radian per second))"#)
    
        // angular acceleration (radian per second squared)
        #expect(UnitIdentifier.angularAcceleration.rawValue == 0x2744)
        #expect(UnitIdentifier.angularAcceleration.type == #"org.bluetooth.unit.angular_acceleration.radian_per_second_squared"#)
        #expect(UnitIdentifier.angularAcceleration.name == #"angular acceleration (radian per second squared)"#)
        #expect(UnitIdentifier.angularAcceleration.description == #"0x2744 (angular acceleration (radian per second squared))"#)
    
        // heat flux density (watt per square metre)
        #expect(UnitIdentifier.heatFluxDensity.rawValue == 0x2745)
        #expect(UnitIdentifier.heatFluxDensity.type == #"org.bluetooth.unit.heat_flux_density.watt_per_square_metre"#)
        #expect(UnitIdentifier.heatFluxDensity.name == #"heat flux density (watt per square metre)"#)
        #expect(UnitIdentifier.heatFluxDensity.description == #"0x2745 (heat flux density (watt per square metre))"#)
    
        // heat capacity (joule per kelvin)
        #expect(UnitIdentifier.heatCapacity.rawValue == 0x2746)
        #expect(UnitIdentifier.heatCapacity.type == #"org.bluetooth.unit.heat_capacity.joule_per_kelvin"#)
        #expect(UnitIdentifier.heatCapacity.name == #"heat capacity (joule per kelvin)"#)
        #expect(UnitIdentifier.heatCapacity.description == #"0x2746 (heat capacity (joule per kelvin))"#)
    
        // specific heat capacity (joule per kilogram kelvin)
        #expect(UnitIdentifier.specificHeatCapacity.rawValue == 0x2747)
        #expect(UnitIdentifier.specificHeatCapacity.type == #"org.bluetooth.unit.specific_heat_capacity.joule_per_kilogram_kelvin"#)
        #expect(UnitIdentifier.specificHeatCapacity.name == #"specific heat capacity (joule per kilogram kelvin)"#)
        #expect(UnitIdentifier.specificHeatCapacity.description == #"0x2747 (specific heat capacity (joule per kilogram kelvin))"#)
    
        // specific energy (joule per kilogram)
        #expect(UnitIdentifier.specificEnergy.rawValue == 0x2748)
        #expect(UnitIdentifier.specificEnergy.type == #"org.bluetooth.unit.specific_energy.joule_per_kilogram"#)
        #expect(UnitIdentifier.specificEnergy.name == #"specific energy (joule per kilogram)"#)
        #expect(UnitIdentifier.specificEnergy.description == #"0x2748 (specific energy (joule per kilogram))"#)
    
        // thermal conductivity (watt per metre kelvin)
        #expect(UnitIdentifier.thermalConductivity.rawValue == 0x2749)
        #expect(UnitIdentifier.thermalConductivity.type == #"org.bluetooth.unit.thermal_conductivity.watt_per_metre_kelvin"#)
        #expect(UnitIdentifier.thermalConductivity.name == #"thermal conductivity (watt per metre kelvin)"#)
        #expect(UnitIdentifier.thermalConductivity.description == #"0x2749 (thermal conductivity (watt per metre kelvin))"#)
    
        // energy density (joule per cubic metre)
        #expect(UnitIdentifier.energyDensity.rawValue == 0x274A)
        #expect(UnitIdentifier.energyDensity.type == #"org.bluetooth.unit.energy_density.joule_per_cubic_metre"#)
        #expect(UnitIdentifier.energyDensity.name == #"energy density (joule per cubic metre)"#)
        #expect(UnitIdentifier.energyDensity.description == #"0x274A (energy density (joule per cubic metre))"#)
    
        // electric field strength (volt per metre)
        #expect(UnitIdentifier.electricFieldStrength.rawValue == 0x274B)
        #expect(UnitIdentifier.electricFieldStrength.type == #"org.bluetooth.unit.electric_field_strength.volt_per_metre"#)
        #expect(UnitIdentifier.electricFieldStrength.name == #"electric field strength (volt per metre)"#)
        #expect(UnitIdentifier.electricFieldStrength.description == #"0x274B (electric field strength (volt per metre))"#)
    
        // electric charge density (coulomb per cubic metre)
        #expect(UnitIdentifier.electricChargeDensity.rawValue == 0x274C)
        #expect(UnitIdentifier.electricChargeDensity.type == #"org.bluetooth.unit.electric_charge_density.coulomb_per_cubic_metre"#)
        #expect(UnitIdentifier.electricChargeDensity.name == #"electric charge density (coulomb per cubic metre)"#)
        #expect(UnitIdentifier.electricChargeDensity.description == #"0x274C (electric charge density (coulomb per cubic metre))"#)
    
        // surface charge density (coulomb per square metre)
        #expect(UnitIdentifier.surfaceChargeDensity.rawValue == 0x274D)
        #expect(UnitIdentifier.surfaceChargeDensity.type == #"org.bluetooth.unit.surface_charge_density.coulomb_per_square_metre"#)
        #expect(UnitIdentifier.surfaceChargeDensity.name == #"surface charge density (coulomb per square metre)"#)
        #expect(UnitIdentifier.surfaceChargeDensity.description == #"0x274D (surface charge density (coulomb per square metre))"#)
    
        // electric flux density (coulomb per square metre)
        #expect(UnitIdentifier.electricFluxDensity.rawValue == 0x274E)
        #expect(UnitIdentifier.electricFluxDensity.type == #"org.bluetooth.unit.electric_flux_density.coulomb_per_square_metre"#)
        #expect(UnitIdentifier.electricFluxDensity.name == #"electric flux density (coulomb per square metre)"#)
        #expect(UnitIdentifier.electricFluxDensity.description == #"0x274E (electric flux density (coulomb per square metre))"#)
    
        // permittivity (farad per metre)
        #expect(UnitIdentifier.permittivity.rawValue == 0x274F)
        #expect(UnitIdentifier.permittivity.type == #"org.bluetooth.unit.permittivity.farad_per_metre"#)
        #expect(UnitIdentifier.permittivity.name == #"permittivity (farad per metre)"#)
        #expect(UnitIdentifier.permittivity.description == #"0x274F (permittivity (farad per metre))"#)
    
        // permeability (henry per metre)
        #expect(UnitIdentifier.permeability.rawValue == 0x2750)
        #expect(UnitIdentifier.permeability.type == #"org.bluetooth.unit.permeability.henry_per_metre"#)
        #expect(UnitIdentifier.permeability.name == #"permeability (henry per metre)"#)
        #expect(UnitIdentifier.permeability.description == #"0x2750 (permeability (henry per metre))"#)
    
        // molar energy (joule per mole)
        #expect(UnitIdentifier.molarEnergy.rawValue == 0x2751)
        #expect(UnitIdentifier.molarEnergy.type == #"org.bluetooth.unit.molar_energy.joule_per_mole"#)
        #expect(UnitIdentifier.molarEnergy.name == #"molar energy (joule per mole)"#)
        #expect(UnitIdentifier.molarEnergy.description == #"0x2751 (molar energy (joule per mole))"#)
    
        // molar entropy (joule per mole kelvin)
        #expect(UnitIdentifier.molarEntropy.rawValue == 0x2752)
        #expect(UnitIdentifier.molarEntropy.type == #"org.bluetooth.unit.molar_entropy.joule_per_mole_kelvin"#)
        #expect(UnitIdentifier.molarEntropy.name == #"molar entropy (joule per mole kelvin)"#)
        #expect(UnitIdentifier.molarEntropy.description == #"0x2752 (molar entropy (joule per mole kelvin))"#)
    
        // exposure (coulomb per kilogram)
        #expect(UnitIdentifier.exposure.rawValue == 0x2753)
        #expect(UnitIdentifier.exposure.type == #"org.bluetooth.unit.exposure.coulomb_per_kilogram"#)
        #expect(UnitIdentifier.exposure.name == #"exposure (coulomb per kilogram)"#)
        #expect(UnitIdentifier.exposure.description == #"0x2753 (exposure (coulomb per kilogram))"#)
    
        // absorbed dose rate (gray per second)
        #expect(UnitIdentifier.absorbedDoseRate.rawValue == 0x2754)
        #expect(UnitIdentifier.absorbedDoseRate.type == #"org.bluetooth.unit.absorbed_dose_rate.gray_per_second"#)
        #expect(UnitIdentifier.absorbedDoseRate.name == #"absorbed dose rate (gray per second)"#)
        #expect(UnitIdentifier.absorbedDoseRate.description == #"0x2754 (absorbed dose rate (gray per second))"#)
    
        // radiant intensity (watt per steradian)
        #expect(UnitIdentifier.radradiantIntensityiance.rawValue == 0x2755)
        #expect(UnitIdentifier.radradiantIntensityiance.type == #"org.bluetooth.unit.radiant_intensity.watt_per_steradian"#)
        #expect(UnitIdentifier.radradiantIntensityiance.name == #"radiant intensity (watt per steradian)"#)
        #expect(UnitIdentifier.radradiantIntensityiance.description == #"0x2755 (radiant intensity (watt per steradian))"#)
    
        // radiance (watt per square metre steradian)
        #expect(UnitIdentifier.radiance.rawValue == 0x2756)
        #expect(UnitIdentifier.radiance.type == #"org.bluetooth.unit.radiance.watt_per_square_metre_steradian"#)
        #expect(UnitIdentifier.radiance.name == #"radiance (watt per square metre steradian)"#)
        #expect(UnitIdentifier.radiance.description == #"0x2756 (radiance (watt per square metre steradian))"#)
    
        // catalytic activity concentration (katal per cubic metre)
        #expect(UnitIdentifier.catalyticActivity.rawValue == 0x2757)
        #expect(UnitIdentifier.catalyticActivity.type == #"org.bluetooth.unit.catalytic_activity_concentration.katal_per_cubic_metre"#)
        #expect(UnitIdentifier.catalyticActivity.name == #"catalytic activity concentration (katal per cubic metre)"#)
        #expect(UnitIdentifier.catalyticActivity.description == #"0x2757 (catalytic activity concentration (katal per cubic metre))"#)
    
        // time (minute)
        #expect(UnitIdentifier.minute.rawValue == 0x2760)
        #expect(UnitIdentifier.minute.type == #"org.bluetooth.unit.time.minute"#)
        #expect(UnitIdentifier.minute.name == #"time (minute)"#)
        #expect(UnitIdentifier.minute.description == #"0x2760 (time (minute))"#)
    
        // time (hour)
        #expect(UnitIdentifier.hour.rawValue == 0x2761)
        #expect(UnitIdentifier.hour.type == #"org.bluetooth.unit.time.hour"#)
        #expect(UnitIdentifier.hour.name == #"time (hour)"#)
        #expect(UnitIdentifier.hour.description == #"0x2761 (time (hour))"#)
    
        // time (day)
        #expect(UnitIdentifier.day.rawValue == 0x2762)
        #expect(UnitIdentifier.day.type == #"org.bluetooth.unit.time.day"#)
        #expect(UnitIdentifier.day.name == #"time (day)"#)
        #expect(UnitIdentifier.day.description == #"0x2762 (time (day))"#)
    
        // plane angle (degree)
        #expect(UnitIdentifier.degree.rawValue == 0x2763)
        #expect(UnitIdentifier.degree.type == #"org.bluetooth.unit.plane_angle.degree"#)
        #expect(UnitIdentifier.degree.name == #"plane angle (degree)"#)
        #expect(UnitIdentifier.degree.description == #"0x2763 (plane angle (degree))"#)
    
        // plane angle (minute)
        #expect(UnitIdentifier.planeAngleMinute.rawValue == 0x2764)
        #expect(UnitIdentifier.planeAngleMinute.type == #"org.bluetooth.unit.plane_angle.minute"#)
        #expect(UnitIdentifier.planeAngleMinute.name == #"plane angle (minute)"#)
        #expect(UnitIdentifier.planeAngleMinute.description == #"0x2764 (plane angle (minute))"#)
    
        // plane angle (second)
        #expect(UnitIdentifier.planeAngleSecond.rawValue == 0x2765)
        #expect(UnitIdentifier.planeAngleSecond.type == #"org.bluetooth.unit.plane_angle.second"#)
        #expect(UnitIdentifier.planeAngleSecond.name == #"plane angle (second)"#)
        #expect(UnitIdentifier.planeAngleSecond.description == #"0x2765 (plane angle (second))"#)
    
        // area (hectare)
        #expect(UnitIdentifier.hectare.rawValue == 0x2766)
        #expect(UnitIdentifier.hectare.type == #"org.bluetooth.unit.area.hectare"#)
        #expect(UnitIdentifier.hectare.name == #"area (hectare)"#)
        #expect(UnitIdentifier.hectare.description == #"0x2766 (area (hectare))"#)
    
        // volume (litre)
        #expect(UnitIdentifier.litre.rawValue == 0x2767)
        #expect(UnitIdentifier.litre.type == #"org.bluetooth.unit.volume.litre"#)
        #expect(UnitIdentifier.litre.name == #"volume (litre)"#)
        #expect(UnitIdentifier.litre.description == #"0x2767 (volume (litre))"#)
    
        // mass (tonne)
        #expect(UnitIdentifier.tonne.rawValue == 0x2768)
        #expect(UnitIdentifier.tonne.type == #"org.bluetooth.unit.mass.tonne"#)
        #expect(UnitIdentifier.tonne.name == #"mass (tonne)"#)
        #expect(UnitIdentifier.tonne.description == #"0x2768 (mass (tonne))"#)
    
        // pressure (bar)
        #expect(UnitIdentifier.bar.rawValue == 0x2780)
        #expect(UnitIdentifier.bar.type == #"org.bluetooth.unit.pressure.bar"#)
        #expect(UnitIdentifier.bar.name == #"pressure (bar)"#)
        #expect(UnitIdentifier.bar.description == #"0x2780 (pressure (bar))"#)
    
        // pressure (millimetre of mercury)
        #expect(UnitIdentifier.millimetreOfMercury.rawValue == 0x2781)
        #expect(UnitIdentifier.millimetreOfMercury.type == #"org.bluetooth.unit.pressure.millimetre_of_mercury"#)
        #expect(UnitIdentifier.millimetreOfMercury.name == #"pressure (millimetre of mercury)"#)
        #expect(UnitIdentifier.millimetreOfMercury.description == #"0x2781 (pressure (millimetre of mercury))"#)
    
        // length (ångström)
        #expect(UnitIdentifier.ngstrm.rawValue == 0x2782)
        #expect(UnitIdentifier.ngstrm.type == #"org.bluetooth.unit.length.ångström"#)
        #expect(UnitIdentifier.ngstrm.name == #"length (ångström)"#)
        #expect(UnitIdentifier.ngstrm.description == #"0x2782 (length (ångström))"#)
    
        // length (nautical mile)
        #expect(UnitIdentifier.nauticalMile.rawValue == 0x2783)
        #expect(UnitIdentifier.nauticalMile.type == #"org.bluetooth.unit.length.nautical_mile"#)
        #expect(UnitIdentifier.nauticalMile.name == #"length (nautical mile)"#)
        #expect(UnitIdentifier.nauticalMile.description == #"0x2783 (length (nautical mile))"#)
    
        // area (barn)
        #expect(UnitIdentifier.barn.rawValue == 0x2784)
        #expect(UnitIdentifier.barn.type == #"org.bluetooth.unit.area.barn"#)
        #expect(UnitIdentifier.barn.name == #"area (barn)"#)
        #expect(UnitIdentifier.barn.description == #"0x2784 (area (barn))"#)
    
        // velocity (knot)
        #expect(UnitIdentifier.velocityKnot.rawValue == 0x2785)
        #expect(UnitIdentifier.velocityKnot.type == #"org.bluetooth.unit.velocity.knot"#)
        #expect(UnitIdentifier.velocityKnot.name == #"velocity (knot)"#)
        #expect(UnitIdentifier.velocityKnot.description == #"0x2785 (velocity (knot))"#)
    
        // logarithmic radio quantity (neper)
        #expect(UnitIdentifier.neper.rawValue == 0x2786)
        #expect(UnitIdentifier.neper.type == #"org.bluetooth.unit.logarithmic_radio_quantity.neper"#)
        #expect(UnitIdentifier.neper.name == #"logarithmic radio quantity (neper)"#)
        #expect(UnitIdentifier.neper.description == #"0x2786 (logarithmic radio quantity (neper))"#)
    
        // logarithmic radio quantity (bel)
        #expect(UnitIdentifier.bel.rawValue == 0x2787)
        #expect(UnitIdentifier.bel.type == #"org.bluetooth.unit.logarithmic_radio_quantity.bel"#)
        #expect(UnitIdentifier.bel.name == #"logarithmic radio quantity (bel)"#)
        #expect(UnitIdentifier.bel.description == #"0x2787 (logarithmic radio quantity (bel))"#)
    
        // length (yard)
        #expect(UnitIdentifier.yard.rawValue == 0x27A0)
        #expect(UnitIdentifier.yard.type == #"org.bluetooth.unit.length.yard"#)
        #expect(UnitIdentifier.yard.name == #"length (yard)"#)
        #expect(UnitIdentifier.yard.description == #"0x27A0 (length (yard))"#)
    
        // length (parsec)
        #expect(UnitIdentifier.parsec.rawValue == 0x27A1)
        #expect(UnitIdentifier.parsec.type == #"org.bluetooth.unit.length.parsec"#)
        #expect(UnitIdentifier.parsec.name == #"length (parsec)"#)
        #expect(UnitIdentifier.parsec.description == #"0x27A1 (length (parsec))"#)
    
        // length (inch)
        #expect(UnitIdentifier.inch.rawValue == 0x27A2)
        #expect(UnitIdentifier.inch.type == #"org.bluetooth.unit.length.inch"#)
        #expect(UnitIdentifier.inch.name == #"length (inch)"#)
        #expect(UnitIdentifier.inch.description == #"0x27A2 (length (inch))"#)
    
        // length (foot)
        #expect(UnitIdentifier.foot.rawValue == 0x27A3)
        #expect(UnitIdentifier.foot.type == #"org.bluetooth.unit.length.foot"#)
        #expect(UnitIdentifier.foot.name == #"length (foot)"#)
        #expect(UnitIdentifier.foot.description == #"0x27A3 (length (foot))"#)
    
        // length (mile)
        #expect(UnitIdentifier.mile.rawValue == 0x27A4)
        #expect(UnitIdentifier.mile.type == #"org.bluetooth.unit.length.mile"#)
        #expect(UnitIdentifier.mile.name == #"length (mile)"#)
        #expect(UnitIdentifier.mile.description == #"0x27A4 (length (mile))"#)
    
        // pressure (pound-force per square inch)
        #expect(UnitIdentifier.pressurePoundForce.rawValue == 0x27A5)
        #expect(UnitIdentifier.pressurePoundForce.type == #"org.bluetooth.unit.pressure.pound_force_per_square_inch"#)
        #expect(UnitIdentifier.pressurePoundForce.name == #"pressure (pound-force per square inch)"#)
        #expect(UnitIdentifier.pressurePoundForce.description == #"0x27A5 (pressure (pound-force per square inch))"#)
    
        // velocity (kilometre per hour)
        #expect(UnitIdentifier.kilometrePerHour.rawValue == 0x27A6)
        #expect(UnitIdentifier.kilometrePerHour.type == #"org.bluetooth.unit.velocity.kilometre_per_hour"#)
        #expect(UnitIdentifier.kilometrePerHour.name == #"velocity (kilometre per hour)"#)
        #expect(UnitIdentifier.kilometrePerHour.description == #"0x27A6 (velocity (kilometre per hour))"#)
    
        // velocity (mile per hour)
        #expect(UnitIdentifier.milePerHour.rawValue == 0x27A7)
        #expect(UnitIdentifier.milePerHour.type == #"org.bluetooth.unit.velocity.mile_per_hour"#)
        #expect(UnitIdentifier.milePerHour.name == #"velocity (mile per hour)"#)
        #expect(UnitIdentifier.milePerHour.description == #"0x27A7 (velocity (mile per hour))"#)
    
        // angular velocity (revolution per minute)
        #expect(UnitIdentifier.revolutionPerMinute.rawValue == 0x27A8)
        #expect(UnitIdentifier.revolutionPerMinute.type == #"org.bluetooth.unit.angular_velocity.revolution_per_minute"#)
        #expect(UnitIdentifier.revolutionPerMinute.name == #"angular velocity (revolution per minute)"#)
        #expect(UnitIdentifier.revolutionPerMinute.description == #"0x27A8 (angular velocity (revolution per minute))"#)
    
        // energy (gram calorie)
        #expect(UnitIdentifier.gramCalorie.rawValue == 0x27A9)
        #expect(UnitIdentifier.gramCalorie.type == #"org.bluetooth.unit.energy.gram_calorie"#)
        #expect(UnitIdentifier.gramCalorie.name == #"energy (gram calorie)"#)
        #expect(UnitIdentifier.gramCalorie.description == #"0x27A9 (energy (gram calorie))"#)
    
        // energy (kilogram calorie)
        #expect(UnitIdentifier.kilogramCalorie.rawValue == 0x27AA)
        #expect(UnitIdentifier.kilogramCalorie.type == #"org.bluetooth.unit.energy.kilogram_calorie"#)
        #expect(UnitIdentifier.kilogramCalorie.name == #"energy (kilogram calorie)"#)
        #expect(UnitIdentifier.kilogramCalorie.description == #"0x27AA (energy (kilogram calorie))"#)
    
        // energy (kilowatt hour)
        #expect(UnitIdentifier.kilowattHour.rawValue == 0x27AB)
        #expect(UnitIdentifier.kilowattHour.type == #"org.bluetooth.unit.energy.kilowatt_hour"#)
        #expect(UnitIdentifier.kilowattHour.name == #"energy (kilowatt hour)"#)
        #expect(UnitIdentifier.kilowattHour.description == #"0x27AB (energy (kilowatt hour))"#)
    
        // thermodynamic temperature (degree Fahrenheit)
        #expect(UnitIdentifier.degreeFahrenheit.rawValue == 0x27AC)
        #expect(UnitIdentifier.degreeFahrenheit.type == #"org.bluetooth.unit.thermodynamic_temperature.degree_fahrenheit"#)
        #expect(UnitIdentifier.degreeFahrenheit.name == #"thermodynamic temperature (degree Fahrenheit)"#)
        #expect(UnitIdentifier.degreeFahrenheit.description == #"0x27AC (thermodynamic temperature (degree Fahrenheit))"#)
    
        // percentage
        #expect(UnitIdentifier.percentage.rawValue == 0x27AD)
        #expect(UnitIdentifier.percentage.type == #"org.bluetooth.unit.percentage"#)
        #expect(UnitIdentifier.percentage.name == #"percentage"#)
        #expect(UnitIdentifier.percentage.description == #"0x27AD (percentage)"#)
    
        // per mille
        #expect(UnitIdentifier.perMille.rawValue == 0x27AE)
        #expect(UnitIdentifier.perMille.type == #"org.bluetooth.unit.per_mille"#)
        #expect(UnitIdentifier.perMille.name == #"per mille"#)
        #expect(UnitIdentifier.perMille.description == #"0x27AE (per mille)"#)
    
        // period (beats per minute)
        #expect(UnitIdentifier.beatsPerMinute.rawValue == 0x27AF)
        #expect(UnitIdentifier.beatsPerMinute.type == #"org.bluetooth.unit.period.beats_per_minute"#)
        #expect(UnitIdentifier.beatsPerMinute.name == #"period (beats per minute)"#)
        #expect(UnitIdentifier.beatsPerMinute.description == #"0x27AF (period (beats per minute))"#)
    
        // electric charge (ampere hours)
        #expect(UnitIdentifier.ampereHours.rawValue == 0x27B0)
        #expect(UnitIdentifier.ampereHours.type == #"org.bluetooth.unit.electric_charge.ampere_hours"#)
        #expect(UnitIdentifier.ampereHours.name == #"electric charge (ampere hours)"#)
        #expect(UnitIdentifier.ampereHours.description == #"0x27B0 (electric charge (ampere hours))"#)
    
        // mass density (milligram per decilitre)
        #expect(UnitIdentifier.milligramPerDecilitre.rawValue == 0x27B1)
        #expect(UnitIdentifier.milligramPerDecilitre.type == #"org.bluetooth.unit.mass_density.milligram_per_decilitre"#)
        #expect(UnitIdentifier.milligramPerDecilitre.name == #"mass density (milligram per decilitre)"#)
        #expect(UnitIdentifier.milligramPerDecilitre.description == #"0x27B1 (mass density (milligram per decilitre))"#)
    
        // mass density (millimole per litre)
        #expect(UnitIdentifier.millimolePerLitre.rawValue == 0x27B2)
        #expect(UnitIdentifier.millimolePerLitre.type == #"org.bluetooth.unit.mass_density.millimole_per_litre"#)
        #expect(UnitIdentifier.millimolePerLitre.name == #"mass density (millimole per litre)"#)
        #expect(UnitIdentifier.millimolePerLitre.description == #"0x27B2 (mass density (millimole per litre))"#)
    
        // time (year)
        #expect(UnitIdentifier.year.rawValue == 0x27B3)
        #expect(UnitIdentifier.year.type == #"org.bluetooth.unit.time.year"#)
        #expect(UnitIdentifier.year.name == #"time (year)"#)
        #expect(UnitIdentifier.year.description == #"0x27B3 (time (year))"#)
    
        // time (month)
        #expect(UnitIdentifier.month.rawValue == 0x27B4)
        #expect(UnitIdentifier.month.type == #"org.bluetooth.unit.time.month"#)
        #expect(UnitIdentifier.month.name == #"time (month)"#)
        #expect(UnitIdentifier.month.description == #"0x27B4 (time (month))"#)
    
        // concentration (count per cubic metre)
        #expect(UnitIdentifier.concentration.rawValue == 0x27B5)
        #expect(UnitIdentifier.concentration.type == #"org.bluetooth.unit.concentration.count_per_cubic_metre"#)
        #expect(UnitIdentifier.concentration.name == #"concentration (count per cubic metre)"#)
        #expect(UnitIdentifier.concentration.description == #"0x27B5 (concentration (count per cubic metre))"#)
    
        // irradiance (watt per square metre)
        #expect(UnitIdentifier.irrandiance.rawValue == 0x27B6)
        #expect(UnitIdentifier.irrandiance.type == #"org.bluetooth.unit.irradiance.watt_per_square_metre"#)
        #expect(UnitIdentifier.irrandiance.name == #"irradiance (watt per square metre)"#)
        #expect(UnitIdentifier.irrandiance.description == #"0x27B6 (irradiance (watt per square metre))"#)
    
        // milliliter (per kilogram per minute)
        #expect(UnitIdentifier.millilitre.rawValue == 0x27B7)
        #expect(UnitIdentifier.millilitre.type == #"org.bluetooth.unit.transfer_rate.milliliter_per_kilogram_per_minute"#)
        #expect(UnitIdentifier.millilitre.name == #"milliliter (per kilogram per minute)"#)
        #expect(UnitIdentifier.millilitre.description == #"0x27B7 (milliliter (per kilogram per minute))"#)
    
        // mass (pound)
        #expect(UnitIdentifier.pound.rawValue == 0x27B8)
        #expect(UnitIdentifier.pound.type == #"org.bluetooth.unit.mass.pound"#)
        #expect(UnitIdentifier.pound.name == #"mass (pound)"#)
        #expect(UnitIdentifier.pound.description == #"0x27B8 (mass (pound))"#)
    
        // metabolic equivalent
        #expect(UnitIdentifier.metabolicEquivalent.rawValue == 0x27B9)
        #expect(UnitIdentifier.metabolicEquivalent.type == #"org.bluetooth.unit.metabolic_equivalent"#)
        #expect(UnitIdentifier.metabolicEquivalent.name == #"metabolic equivalent"#)
        #expect(UnitIdentifier.metabolicEquivalent.description == #"0x27B9 (metabolic equivalent)"#)
    
        // step (per minute)
        #expect(UnitIdentifier.step.rawValue == 0x27BA)
        #expect(UnitIdentifier.step.type == #"org.bluetooth.unit.step_per_minute"#)
        #expect(UnitIdentifier.step.name == #"step (per minute)"#)
        #expect(UnitIdentifier.step.description == #"0x27BA (step (per minute))"#)
    
        // stroke (per minute)
        #expect(UnitIdentifier.stroke.rawValue == 0x27BC)
        #expect(UnitIdentifier.stroke.type == #"org.bluetooth.unit.stroke_per_minute"#)
        #expect(UnitIdentifier.stroke.name == #"stroke (per minute)"#)
        #expect(UnitIdentifier.stroke.description == #"0x27BC (stroke (per minute))"#)
    
        // pace (kilometre per minute)
        #expect(UnitIdentifier.pace.rawValue == 0x27BD)
        #expect(UnitIdentifier.pace.type == #"org.bluetooth.unit.velocity.kilometer_per_minute"#)
        #expect(UnitIdentifier.pace.name == #"pace (kilometre per minute)"#)
        #expect(UnitIdentifier.pace.description == #"0x27BD (pace (kilometre per minute))"#)
    
        // luminous efficacy (lumen per watt)
        #expect(UnitIdentifier.luminousEfficacy.rawValue == 0x27BE)
        #expect(UnitIdentifier.luminousEfficacy.type == #"org.bluetooth.unit.luminous_efficacy.lumen_per_watt"#)
        #expect(UnitIdentifier.luminousEfficacy.name == #"luminous efficacy (lumen per watt)"#)
        #expect(UnitIdentifier.luminousEfficacy.description == #"0x27BE (luminous efficacy (lumen per watt))"#)
    
        // luminous energy (lumen hour)
        #expect(UnitIdentifier.luminousEnergy.rawValue == 0x27BF)
        #expect(UnitIdentifier.luminousEnergy.type == #"org.bluetooth.unit.luminous_energy.lumen_hour"#)
        #expect(UnitIdentifier.luminousEnergy.name == #"luminous energy (lumen hour)"#)
        #expect(UnitIdentifier.luminousEnergy.description == #"0x27BF (luminous energy (lumen hour))"#)
    
        // luminous exposure (lux hour)
        #expect(UnitIdentifier.luminousExposure.rawValue == 0x27C0)
        #expect(UnitIdentifier.luminousExposure.type == #"org.bluetooth.unit.luminous_exposure.lux_hour"#)
        #expect(UnitIdentifier.luminousExposure.name == #"luminous exposure (lux hour)"#)
        #expect(UnitIdentifier.luminousExposure.description == #"0x27C0 (luminous exposure (lux hour))"#)
    
        // mass flow (gram per second)
        #expect(UnitIdentifier.massFlow.rawValue == 0x27C1)
        #expect(UnitIdentifier.massFlow.type == #"org.bluetooth.unit.mass_flow.gram_per_second"#)
        #expect(UnitIdentifier.massFlow.name == #"mass flow (gram per second)"#)
        #expect(UnitIdentifier.massFlow.description == #"0x27C1 (mass flow (gram per second))"#)
    
        // volume flow (litre per second)
        #expect(UnitIdentifier.volumeFlow.rawValue == 0x27C2)
        #expect(UnitIdentifier.volumeFlow.type == #"org.bluetooth.unit.volume_flow.litre_per_second"#)
        #expect(UnitIdentifier.volumeFlow.name == #"volume flow (litre per second)"#)
        #expect(UnitIdentifier.volumeFlow.description == #"0x27C2 (volume flow (litre per second))"#)
    
        // sound pressure (decibel)
        #expect(UnitIdentifier.soundPressure.rawValue == 0x27C3)
        #expect(UnitIdentifier.soundPressure.type == #"org.bluetooth.unit.sound_pressure.decibel_spl"#)
        #expect(UnitIdentifier.soundPressure.name == #"sound pressure (decibel)"#)
        #expect(UnitIdentifier.soundPressure.description == #"0x27C3 (sound pressure (decibel))"#)
    
        // parts per million
        #expect(UnitIdentifier.partsPerMillion.rawValue == 0x27C4)
        #expect(UnitIdentifier.partsPerMillion.type == #"org.bluetooth.unit.ppm"#)
        #expect(UnitIdentifier.partsPerMillion.name == #"parts per million"#)
        #expect(UnitIdentifier.partsPerMillion.description == #"0x27C4 (parts per million)"#)
    
        // parts per billion
        #expect(UnitIdentifier.partsPerBillion.rawValue == 0x27C5)
        #expect(UnitIdentifier.partsPerBillion.type == #"org.bluetooth.unit.ppb"#)
        #expect(UnitIdentifier.partsPerBillion.name == #"parts per billion"#)
        #expect(UnitIdentifier.partsPerBillion.description == #"0x27C5 (parts per billion)"#)
    
        // mass density rate ((milligram per decilitre) per minute)
        #expect(UnitIdentifier.massDensityRate.rawValue == 0x27C6)
        #expect(UnitIdentifier.massDensityRate.type == #"org.bluetooth.unit.mass_density_rate.milligram_per_decilitre_per_minute"#)
        #expect(UnitIdentifier.massDensityRate.name == #"mass density rate ((milligram per decilitre) per minute)"#)
        #expect(UnitIdentifier.massDensityRate.description == #"0x27C6 (mass density rate ((milligram per decilitre) per minute))"#)
    
        // Electrical Apparent Energy (kilovolt ampere hour)
        #expect(UnitIdentifier.kilovoltAmpereHour.rawValue == 0x27C7)
        #expect(UnitIdentifier.kilovoltAmpereHour.type == #"org.bluetooth.unit.energy.kilovolt_ampere_hour"#)
        #expect(UnitIdentifier.kilovoltAmpereHour.name == #"Electrical Apparent Energy (kilovolt ampere hour)"#)
        #expect(UnitIdentifier.kilovoltAmpereHour.description == #"0x27C7 (Electrical Apparent Energy (kilovolt ampere hour))"#)
    
        // Electrical Apparent Power (volt ampere)
        #expect(UnitIdentifier.voltAmpere.rawValue == 0x27C8)
        #expect(UnitIdentifier.voltAmpere.type == #"org.bluetooth.unit.power.volt_ampere"#)
        #expect(UnitIdentifier.voltAmpere.name == #"Electrical Apparent Power (volt ampere)"#)
        #expect(UnitIdentifier.voltAmpere.description == #"0x27C8 (Electrical Apparent Power (volt ampere))"#)
    
    }

}
#endif
// swiftlint:enable type_body_length
