//
//  DefinedUUIDTests.swift
//  Bluetooth
//
//  Generated by Alsey Coleman Miller on 5/29/20.
//

#if !os(WASI)
import Testing
import Foundation
@testable import Bluetooth

// swiftlint:disable type_body_length
@Suite struct DefinedUUIDTests {
    
    @Test func definedUUID() {

        /// SDP
        #expect(BluetoothUUID.sdp.rawValue == "0001")
        #expect(BluetoothUUID.sdp == .bit16(0x0001))
        #expect(BluetoothUUID.sdp == .bit16(1))
        #expect(BluetoothUUID.sdp.name == "SDP")
        #expect(BluetoothUUID.sdp != .bit32(1))
        #expect(BluetoothUUID.sdp != .bit32(0x0001))

        /// RFCOMM
        #expect(BluetoothUUID.rfcomm.rawValue == "0003")
        #expect(BluetoothUUID.rfcomm == .bit16(0x0003))
        #expect(BluetoothUUID.rfcomm == .bit16(3))
        #expect(BluetoothUUID.rfcomm.name == "RFCOMM")
        #expect(BluetoothUUID.rfcomm != .bit32(3))
        #expect(BluetoothUUID.rfcomm != .bit32(0x0003))

        /// TCS-BIN
        #expect(BluetoothUUID.tcsBin.rawValue == "0005")
        #expect(BluetoothUUID.tcsBin == .bit16(0x0005))
        #expect(BluetoothUUID.tcsBin == .bit16(5))
        #expect(BluetoothUUID.tcsBin.name == "TCS-BIN")
        #expect(BluetoothUUID.tcsBin != .bit32(5))
        #expect(BluetoothUUID.tcsBin != .bit32(0x0005))

        /// ATT
        #expect(BluetoothUUID.att.rawValue == "0007")
        #expect(BluetoothUUID.att == .bit16(0x0007))
        #expect(BluetoothUUID.att == .bit16(7))
        #expect(BluetoothUUID.att.name == "ATT")
        #expect(BluetoothUUID.att != .bit32(7))
        #expect(BluetoothUUID.att != .bit32(0x0007))

        /// OBEX
        #expect(BluetoothUUID.obex.rawValue == "0008")
        #expect(BluetoothUUID.obex == .bit16(0x0008))
        #expect(BluetoothUUID.obex == .bit16(8))
        #expect(BluetoothUUID.obex.name == "OBEX")
        #expect(BluetoothUUID.obex != .bit32(8))
        #expect(BluetoothUUID.obex != .bit32(0x0008))

        /// BNEP
        #expect(BluetoothUUID.bnep.rawValue == "000F")
        #expect(BluetoothUUID.bnep == .bit16(0x000F))
        #expect(BluetoothUUID.bnep == .bit16(15))
        #expect(BluetoothUUID.bnep.name == "BNEP")
        #expect(BluetoothUUID.bnep != .bit32(15))
        #expect(BluetoothUUID.bnep != .bit32(0x000F))

        /// UPNP
        #expect(BluetoothUUID.upnp.rawValue == "0010")
        #expect(BluetoothUUID.upnp == .bit16(0x0010))
        #expect(BluetoothUUID.upnp == .bit16(16))
        #expect(BluetoothUUID.upnp.name == "UPNP")
        #expect(BluetoothUUID.upnp != .bit32(16))
        #expect(BluetoothUUID.upnp != .bit32(0x0010))

        /// HIDP
        #expect(BluetoothUUID.hidp.rawValue == "0011")
        #expect(BluetoothUUID.hidp == .bit16(0x0011))
        #expect(BluetoothUUID.hidp == .bit16(17))
        #expect(BluetoothUUID.hidp.name == "HIDP")
        #expect(BluetoothUUID.hidp != .bit32(17))
        #expect(BluetoothUUID.hidp != .bit32(0x0011))

        /// Hardcopy Control Channel
        #expect(BluetoothUUID.hardcopyControlChannel.rawValue == "0012")
        #expect(BluetoothUUID.hardcopyControlChannel == .bit16(0x0012))
        #expect(BluetoothUUID.hardcopyControlChannel == .bit16(18))
        #expect(BluetoothUUID.hardcopyControlChannel.name == "Hardcopy Control Channel")
        #expect(BluetoothUUID.hardcopyControlChannel != .bit32(18))
        #expect(BluetoothUUID.hardcopyControlChannel != .bit32(0x0012))

        /// Hardcopy Data Channel
        #expect(BluetoothUUID.hardcopyDataChannel.rawValue == "0014")
        #expect(BluetoothUUID.hardcopyDataChannel == .bit16(0x0014))
        #expect(BluetoothUUID.hardcopyDataChannel == .bit16(20))
        #expect(BluetoothUUID.hardcopyDataChannel.name == "Hardcopy Data Channel")
        #expect(BluetoothUUID.hardcopyDataChannel != .bit32(20))
        #expect(BluetoothUUID.hardcopyDataChannel != .bit32(0x0014))

        /// Hardcopy Notification
        #expect(BluetoothUUID.hardcopyNotification.rawValue == "0016")
        #expect(BluetoothUUID.hardcopyNotification == .bit16(0x0016))
        #expect(BluetoothUUID.hardcopyNotification == .bit16(22))
        #expect(BluetoothUUID.hardcopyNotification.name == "Hardcopy Notification")
        #expect(BluetoothUUID.hardcopyNotification != .bit32(22))
        #expect(BluetoothUUID.hardcopyNotification != .bit32(0x0016))

        /// AVCTP
        #expect(BluetoothUUID.avctp.rawValue == "0017")
        #expect(BluetoothUUID.avctp == .bit16(0x0017))
        #expect(BluetoothUUID.avctp == .bit16(23))
        #expect(BluetoothUUID.avctp.name == "AVCTP")
        #expect(BluetoothUUID.avctp != .bit32(23))
        #expect(BluetoothUUID.avctp != .bit32(0x0017))

        /// AVDTP
        #expect(BluetoothUUID.avdtp.rawValue == "0019")
        #expect(BluetoothUUID.avdtp == .bit16(0x0019))
        #expect(BluetoothUUID.avdtp == .bit16(25))
        #expect(BluetoothUUID.avdtp.name == "AVDTP")
        #expect(BluetoothUUID.avdtp != .bit32(25))
        #expect(BluetoothUUID.avdtp != .bit32(0x0019))

        /// CMTP
        #expect(BluetoothUUID.cmtp.rawValue == "001B")
        #expect(BluetoothUUID.cmtp == .bit16(0x001B))
        #expect(BluetoothUUID.cmtp == .bit16(27))
        #expect(BluetoothUUID.cmtp.name == "CMTP")
        #expect(BluetoothUUID.cmtp != .bit32(27))
        #expect(BluetoothUUID.cmtp != .bit32(0x001B))

        /// MCAP Control Channel
        #expect(BluetoothUUID.mcapControlChannel.rawValue == "001E")
        #expect(BluetoothUUID.mcapControlChannel == .bit16(0x001E))
        #expect(BluetoothUUID.mcapControlChannel == .bit16(30))
        #expect(BluetoothUUID.mcapControlChannel.name == "MCAP Control Channel")
        #expect(BluetoothUUID.mcapControlChannel != .bit32(30))
        #expect(BluetoothUUID.mcapControlChannel != .bit32(0x001E))

        /// MCAP Data Channel
        #expect(BluetoothUUID.mcapDataChannel.rawValue == "001F")
        #expect(BluetoothUUID.mcapDataChannel == .bit16(0x001F))
        #expect(BluetoothUUID.mcapDataChannel == .bit16(31))
        #expect(BluetoothUUID.mcapDataChannel.name == "MCAP Data Channel")
        #expect(BluetoothUUID.mcapDataChannel != .bit32(31))
        #expect(BluetoothUUID.mcapDataChannel != .bit32(0x001F))

        /// L2CAP
        #expect(BluetoothUUID.l2Cap.rawValue == "0100")
        #expect(BluetoothUUID.l2Cap == .bit16(0x0100))
        #expect(BluetoothUUID.l2Cap == .bit16(256))
        #expect(BluetoothUUID.l2Cap.name == "L2CAP")
        #expect(BluetoothUUID.l2Cap != .bit32(256))
        #expect(BluetoothUUID.l2Cap != .bit32(0x0100))

        /// Service Discovery Server Service Class
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass.rawValue == "1000")
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass == .bit16(0x1000))
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass == .bit16(4096))
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass.name == "Service Discovery Server Service Class")
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass != .bit32(4096))
        #expect(BluetoothUUID.serviceDiscoveryServerServiceClass != .bit32(0x1000))

        /// Browse Group Descriptor Service Class
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass.rawValue == "1001")
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass == .bit16(0x1001))
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass == .bit16(4097))
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass.name == "Browse Group Descriptor Service Class")
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass != .bit32(4097))
        #expect(BluetoothUUID.browseGroupDescriptorServiceClass != .bit32(0x1001))

        /// Public Browse Root
        #expect(BluetoothUUID.publicBrowseRoot.rawValue == "1002")
        #expect(BluetoothUUID.publicBrowseRoot == .bit16(0x1002))
        #expect(BluetoothUUID.publicBrowseRoot == .bit16(4098))
        #expect(BluetoothUUID.publicBrowseRoot.name == "Public Browse Root")
        #expect(BluetoothUUID.publicBrowseRoot != .bit32(4098))
        #expect(BluetoothUUID.publicBrowseRoot != .bit32(0x1002))

        /// Serial Port
        #expect(BluetoothUUID.serialPort.rawValue == "1101")
        #expect(BluetoothUUID.serialPort == .bit16(0x1101))
        #expect(BluetoothUUID.serialPort == .bit16(4353))
        #expect(BluetoothUUID.serialPort.name == "Serial Port")
        #expect(BluetoothUUID.serialPort != .bit32(4353))
        #expect(BluetoothUUID.serialPort != .bit32(0x1101))

        /// LAN Access Using PPP
        #expect(BluetoothUUID.lanAccessUsingPpp.rawValue == "1102")
        #expect(BluetoothUUID.lanAccessUsingPpp == .bit16(0x1102))
        #expect(BluetoothUUID.lanAccessUsingPpp == .bit16(4354))
        #expect(BluetoothUUID.lanAccessUsingPpp.name == "LAN Access Using PPP")
        #expect(BluetoothUUID.lanAccessUsingPpp != .bit32(4354))
        #expect(BluetoothUUID.lanAccessUsingPpp != .bit32(0x1102))

        /// Dialup Networking
        #expect(BluetoothUUID.dialupNetworking.rawValue == "1103")
        #expect(BluetoothUUID.dialupNetworking == .bit16(0x1103))
        #expect(BluetoothUUID.dialupNetworking == .bit16(4355))
        #expect(BluetoothUUID.dialupNetworking.name == "Dialup Networking")
        #expect(BluetoothUUID.dialupNetworking != .bit32(4355))
        #expect(BluetoothUUID.dialupNetworking != .bit32(0x1103))

        /// IrMC Sync
        #expect(BluetoothUUID.irmcSync.rawValue == "1104")
        #expect(BluetoothUUID.irmcSync == .bit16(0x1104))
        #expect(BluetoothUUID.irmcSync == .bit16(4356))
        #expect(BluetoothUUID.irmcSync.name == "IrMC Sync")
        #expect(BluetoothUUID.irmcSync != .bit32(4356))
        #expect(BluetoothUUID.irmcSync != .bit32(0x1104))

        /// OBEX Object Push
        #expect(BluetoothUUID.obexObjectPush.rawValue == "1105")
        #expect(BluetoothUUID.obexObjectPush == .bit16(0x1105))
        #expect(BluetoothUUID.obexObjectPush == .bit16(4357))
        #expect(BluetoothUUID.obexObjectPush.name == "OBEX Object Push")
        #expect(BluetoothUUID.obexObjectPush != .bit32(4357))
        #expect(BluetoothUUID.obexObjectPush != .bit32(0x1105))

        /// OBEX File Transfer
        #expect(BluetoothUUID.obexFileTransfer.rawValue == "1106")
        #expect(BluetoothUUID.obexFileTransfer == .bit16(0x1106))
        #expect(BluetoothUUID.obexFileTransfer == .bit16(4358))
        #expect(BluetoothUUID.obexFileTransfer.name == "OBEX File Transfer")
        #expect(BluetoothUUID.obexFileTransfer != .bit32(4358))
        #expect(BluetoothUUID.obexFileTransfer != .bit32(0x1106))

        /// IrMC Sync Command
        #expect(BluetoothUUID.irmcSyncCommand.rawValue == "1107")
        #expect(BluetoothUUID.irmcSyncCommand == .bit16(0x1107))
        #expect(BluetoothUUID.irmcSyncCommand == .bit16(4359))
        #expect(BluetoothUUID.irmcSyncCommand.name == "IrMC Sync Command")
        #expect(BluetoothUUID.irmcSyncCommand != .bit32(4359))
        #expect(BluetoothUUID.irmcSyncCommand != .bit32(0x1107))

        /// Headset
        #expect(BluetoothUUID.headset.rawValue == "1108")
        #expect(BluetoothUUID.headset == .bit16(0x1108))
        #expect(BluetoothUUID.headset == .bit16(4360))
        #expect(BluetoothUUID.headset.name == "Headset")
        #expect(BluetoothUUID.headset != .bit32(4360))
        #expect(BluetoothUUID.headset != .bit32(0x1108))

        /// Cordless Telephony
        #expect(BluetoothUUID.cordlessTelephony.rawValue == "1109")
        #expect(BluetoothUUID.cordlessTelephony == .bit16(0x1109))
        #expect(BluetoothUUID.cordlessTelephony == .bit16(4361))
        #expect(BluetoothUUID.cordlessTelephony.name == "Cordless Telephony")
        #expect(BluetoothUUID.cordlessTelephony != .bit32(4361))
        #expect(BluetoothUUID.cordlessTelephony != .bit32(0x1109))

        /// Audio Source
        #expect(BluetoothUUID.audioSource.rawValue == "110A")
        #expect(BluetoothUUID.audioSource == .bit16(0x110A))
        #expect(BluetoothUUID.audioSource == .bit16(4362))
        #expect(BluetoothUUID.audioSource.name == "Audio Source")
        #expect(BluetoothUUID.audioSource != .bit32(4362))
        #expect(BluetoothUUID.audioSource != .bit32(0x110A))

        /// Audio Sink
        #expect(BluetoothUUID.audioSink.rawValue == "110B")
        #expect(BluetoothUUID.audioSink == .bit16(0x110B))
        #expect(BluetoothUUID.audioSink == .bit16(4363))
        #expect(BluetoothUUID.audioSink.name == "Audio Sink")
        #expect(BluetoothUUID.audioSink != .bit32(4363))
        #expect(BluetoothUUID.audioSink != .bit32(0x110B))

        /// A/V Remote Control Target
        #expect(BluetoothUUID.avRemoteControlTarget.rawValue == "110C")
        #expect(BluetoothUUID.avRemoteControlTarget == .bit16(0x110C))
        #expect(BluetoothUUID.avRemoteControlTarget == .bit16(4364))
        #expect(BluetoothUUID.avRemoteControlTarget.name == "A/V Remote Control Target")
        #expect(BluetoothUUID.avRemoteControlTarget != .bit32(4364))
        #expect(BluetoothUUID.avRemoteControlTarget != .bit32(0x110C))

        /// Advanced Audio Distribution
        #expect(BluetoothUUID.advancedAudioDistribution.rawValue == "110D")
        #expect(BluetoothUUID.advancedAudioDistribution == .bit16(0x110D))
        #expect(BluetoothUUID.advancedAudioDistribution == .bit16(4365))
        #expect(BluetoothUUID.advancedAudioDistribution.name == "Advanced Audio Distribution")
        #expect(BluetoothUUID.advancedAudioDistribution != .bit32(4365))
        #expect(BluetoothUUID.advancedAudioDistribution != .bit32(0x110D))

        /// A/V Remote Control
        #expect(BluetoothUUID.avRemoteControl.rawValue == "110E")
        #expect(BluetoothUUID.avRemoteControl == .bit16(0x110E))
        #expect(BluetoothUUID.avRemoteControl == .bit16(4366))
        #expect(BluetoothUUID.avRemoteControl.name == "A/V Remote Control")
        #expect(BluetoothUUID.avRemoteControl != .bit32(4366))
        #expect(BluetoothUUID.avRemoteControl != .bit32(0x110E))

        /// A/V Remote Control Controller
        #expect(BluetoothUUID.avRemoteControlController.rawValue == "110F")
        #expect(BluetoothUUID.avRemoteControlController == .bit16(0x110F))
        #expect(BluetoothUUID.avRemoteControlController == .bit16(4367))
        #expect(BluetoothUUID.avRemoteControlController.name == "A/V Remote Control Controller")
        #expect(BluetoothUUID.avRemoteControlController != .bit32(4367))
        #expect(BluetoothUUID.avRemoteControlController != .bit32(0x110F))

        /// Intercom
        #expect(BluetoothUUID.intercom.rawValue == "1110")
        #expect(BluetoothUUID.intercom == .bit16(0x1110))
        #expect(BluetoothUUID.intercom == .bit16(4368))
        #expect(BluetoothUUID.intercom.name == "Intercom")
        #expect(BluetoothUUID.intercom != .bit32(4368))
        #expect(BluetoothUUID.intercom != .bit32(0x1110))

        /// Fax
        #expect(BluetoothUUID.fax.rawValue == "1111")
        #expect(BluetoothUUID.fax == .bit16(0x1111))
        #expect(BluetoothUUID.fax == .bit16(4369))
        #expect(BluetoothUUID.fax.name == "Fax")
        #expect(BluetoothUUID.fax != .bit32(4369))
        #expect(BluetoothUUID.fax != .bit32(0x1111))

        /// Headset AG
        #expect(BluetoothUUID.headset2.rawValue == "1112")
        #expect(BluetoothUUID.headset2 == .bit16(0x1112))
        #expect(BluetoothUUID.headset2 == .bit16(4370))
        #expect(BluetoothUUID.headset2.name == "Headset AG")
        #expect(BluetoothUUID.headset2 != .bit32(4370))
        #expect(BluetoothUUID.headset2 != .bit32(0x1112))

        /// WAP
        #expect(BluetoothUUID.wap.rawValue == "1113")
        #expect(BluetoothUUID.wap == .bit16(0x1113))
        #expect(BluetoothUUID.wap == .bit16(4371))
        #expect(BluetoothUUID.wap.name == "WAP")
        #expect(BluetoothUUID.wap != .bit32(4371))
        #expect(BluetoothUUID.wap != .bit32(0x1113))

        /// WAP Client
        #expect(BluetoothUUID.wapClient.rawValue == "1114")
        #expect(BluetoothUUID.wapClient == .bit16(0x1114))
        #expect(BluetoothUUID.wapClient == .bit16(4372))
        #expect(BluetoothUUID.wapClient.name == "WAP Client")
        #expect(BluetoothUUID.wapClient != .bit32(4372))
        #expect(BluetoothUUID.wapClient != .bit32(0x1114))

        /// PANU
        #expect(BluetoothUUID.panu.rawValue == "1115")
        #expect(BluetoothUUID.panu == .bit16(0x1115))
        #expect(BluetoothUUID.panu == .bit16(4373))
        #expect(BluetoothUUID.panu.name == "PANU")
        #expect(BluetoothUUID.panu != .bit32(4373))
        #expect(BluetoothUUID.panu != .bit32(0x1115))

        /// NAP
        #expect(BluetoothUUID.nap.rawValue == "1116")
        #expect(BluetoothUUID.nap == .bit16(0x1116))
        #expect(BluetoothUUID.nap == .bit16(4374))
        #expect(BluetoothUUID.nap.name == "NAP")
        #expect(BluetoothUUID.nap != .bit32(4374))
        #expect(BluetoothUUID.nap != .bit32(0x1116))

        /// GN
        #expect(BluetoothUUID.gn.rawValue == "1117")
        #expect(BluetoothUUID.gn == .bit16(0x1117))
        #expect(BluetoothUUID.gn == .bit16(4375))
        #expect(BluetoothUUID.gn.name == "GN")
        #expect(BluetoothUUID.gn != .bit32(4375))
        #expect(BluetoothUUID.gn != .bit32(0x1117))

        /// Direct Printing
        #expect(BluetoothUUID.directPrinting.rawValue == "1118")
        #expect(BluetoothUUID.directPrinting == .bit16(0x1118))
        #expect(BluetoothUUID.directPrinting == .bit16(4376))
        #expect(BluetoothUUID.directPrinting.name == "Direct Printing")
        #expect(BluetoothUUID.directPrinting != .bit32(4376))
        #expect(BluetoothUUID.directPrinting != .bit32(0x1118))

        /// Reference Printing
        #expect(BluetoothUUID.referencePrinting.rawValue == "1119")
        #expect(BluetoothUUID.referencePrinting == .bit16(0x1119))
        #expect(BluetoothUUID.referencePrinting == .bit16(4377))
        #expect(BluetoothUUID.referencePrinting.name == "Reference Printing")
        #expect(BluetoothUUID.referencePrinting != .bit32(4377))
        #expect(BluetoothUUID.referencePrinting != .bit32(0x1119))

        /// Basic Imaging Profile
        #expect(BluetoothUUID.basicImagingProfile.rawValue == "111A")
        #expect(BluetoothUUID.basicImagingProfile == .bit16(0x111A))
        #expect(BluetoothUUID.basicImagingProfile == .bit16(4378))
        #expect(BluetoothUUID.basicImagingProfile.name == "Basic Imaging Profile")
        #expect(BluetoothUUID.basicImagingProfile != .bit32(4378))
        #expect(BluetoothUUID.basicImagingProfile != .bit32(0x111A))

        /// Imaging Responder
        #expect(BluetoothUUID.imagingResponder.rawValue == "111B")
        #expect(BluetoothUUID.imagingResponder == .bit16(0x111B))
        #expect(BluetoothUUID.imagingResponder == .bit16(4379))
        #expect(BluetoothUUID.imagingResponder.name == "Imaging Responder")
        #expect(BluetoothUUID.imagingResponder != .bit32(4379))
        #expect(BluetoothUUID.imagingResponder != .bit32(0x111B))

        /// Imaging Automatic Archive
        #expect(BluetoothUUID.imagingAutomaticArchive.rawValue == "111C")
        #expect(BluetoothUUID.imagingAutomaticArchive == .bit16(0x111C))
        #expect(BluetoothUUID.imagingAutomaticArchive == .bit16(4380))
        #expect(BluetoothUUID.imagingAutomaticArchive.name == "Imaging Automatic Archive")
        #expect(BluetoothUUID.imagingAutomaticArchive != .bit32(4380))
        #expect(BluetoothUUID.imagingAutomaticArchive != .bit32(0x111C))

        /// Imaging Referenced Objects
        #expect(BluetoothUUID.imagingReferencedObjects.rawValue == "111D")
        #expect(BluetoothUUID.imagingReferencedObjects == .bit16(0x111D))
        #expect(BluetoothUUID.imagingReferencedObjects == .bit16(4381))
        #expect(BluetoothUUID.imagingReferencedObjects.name == "Imaging Referenced Objects")
        #expect(BluetoothUUID.imagingReferencedObjects != .bit32(4381))
        #expect(BluetoothUUID.imagingReferencedObjects != .bit32(0x111D))

        /// Handsfree
        #expect(BluetoothUUID.handsfree.rawValue == "111E")
        #expect(BluetoothUUID.handsfree == .bit16(0x111E))
        #expect(BluetoothUUID.handsfree == .bit16(4382))
        #expect(BluetoothUUID.handsfree.name == "Handsfree")
        #expect(BluetoothUUID.handsfree != .bit32(4382))
        #expect(BluetoothUUID.handsfree != .bit32(0x111E))

        /// Handsfree Audio Gateway
        #expect(BluetoothUUID.handsfreeAudioGateway.rawValue == "111F")
        #expect(BluetoothUUID.handsfreeAudioGateway == .bit16(0x111F))
        #expect(BluetoothUUID.handsfreeAudioGateway == .bit16(4383))
        #expect(BluetoothUUID.handsfreeAudioGateway.name == "Handsfree Audio Gateway")
        #expect(BluetoothUUID.handsfreeAudioGateway != .bit32(4383))
        #expect(BluetoothUUID.handsfreeAudioGateway != .bit32(0x111F))

        /// Direct Printing Refrence Objects Service
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService.rawValue == "1120")
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService == .bit16(0x1120))
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService == .bit16(4384))
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService.name == "Direct Printing Refrence Objects Service")
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService != .bit32(4384))
        #expect(BluetoothUUID.directPrintingRefrenceObjectsService != .bit32(0x1120))

        /// Reflected UI
        #expect(BluetoothUUID.reflectedUi.rawValue == "1121")
        #expect(BluetoothUUID.reflectedUi == .bit16(0x1121))
        #expect(BluetoothUUID.reflectedUi == .bit16(4385))
        #expect(BluetoothUUID.reflectedUi.name == "Reflected UI")
        #expect(BluetoothUUID.reflectedUi != .bit32(4385))
        #expect(BluetoothUUID.reflectedUi != .bit32(0x1121))

        /// Basic Printing
        #expect(BluetoothUUID.basicPrinting.rawValue == "1122")
        #expect(BluetoothUUID.basicPrinting == .bit16(0x1122))
        #expect(BluetoothUUID.basicPrinting == .bit16(4386))
        #expect(BluetoothUUID.basicPrinting.name == "Basic Printing")
        #expect(BluetoothUUID.basicPrinting != .bit32(4386))
        #expect(BluetoothUUID.basicPrinting != .bit32(0x1122))

        /// Printing Status
        #expect(BluetoothUUID.printingStatus.rawValue == "1123")
        #expect(BluetoothUUID.printingStatus == .bit16(0x1123))
        #expect(BluetoothUUID.printingStatus == .bit16(4387))
        #expect(BluetoothUUID.printingStatus.name == "Printing Status")
        #expect(BluetoothUUID.printingStatus != .bit32(4387))
        #expect(BluetoothUUID.printingStatus != .bit32(0x1123))

        /// Human Interface Device Service
        #expect(BluetoothUUID.humanInterfaceDeviceService.rawValue == "1124")
        #expect(BluetoothUUID.humanInterfaceDeviceService == .bit16(0x1124))
        #expect(BluetoothUUID.humanInterfaceDeviceService == .bit16(4388))
        #expect(BluetoothUUID.humanInterfaceDeviceService.name == "Human Interface Device Service")
        #expect(BluetoothUUID.humanInterfaceDeviceService != .bit32(4388))
        #expect(BluetoothUUID.humanInterfaceDeviceService != .bit32(0x1124))

        /// Hardcopy Cable Replacement
        #expect(BluetoothUUID.hardcopyCableReplacement.rawValue == "1125")
        #expect(BluetoothUUID.hardcopyCableReplacement == .bit16(0x1125))
        #expect(BluetoothUUID.hardcopyCableReplacement == .bit16(4389))
        #expect(BluetoothUUID.hardcopyCableReplacement.name == "Hardcopy Cable Replacement")
        #expect(BluetoothUUID.hardcopyCableReplacement != .bit32(4389))
        #expect(BluetoothUUID.hardcopyCableReplacement != .bit32(0x1125))

        /// HCR Print
        #expect(BluetoothUUID.hcrPrint.rawValue == "1126")
        #expect(BluetoothUUID.hcrPrint == .bit16(0x1126))
        #expect(BluetoothUUID.hcrPrint == .bit16(4390))
        #expect(BluetoothUUID.hcrPrint.name == "HCR Print")
        #expect(BluetoothUUID.hcrPrint != .bit32(4390))
        #expect(BluetoothUUID.hcrPrint != .bit32(0x1126))

        /// HCR Scan
        #expect(BluetoothUUID.hcrScan.rawValue == "1127")
        #expect(BluetoothUUID.hcrScan == .bit16(0x1127))
        #expect(BluetoothUUID.hcrScan == .bit16(4391))
        #expect(BluetoothUUID.hcrScan.name == "HCR Scan")
        #expect(BluetoothUUID.hcrScan != .bit32(4391))
        #expect(BluetoothUUID.hcrScan != .bit32(0x1127))

        /// Common ISDN Access
        #expect(BluetoothUUID.commonIsdnAccess.rawValue == "1128")
        #expect(BluetoothUUID.commonIsdnAccess == .bit16(0x1128))
        #expect(BluetoothUUID.commonIsdnAccess == .bit16(4392))
        #expect(BluetoothUUID.commonIsdnAccess.name == "Common ISDN Access")
        #expect(BluetoothUUID.commonIsdnAccess != .bit32(4392))
        #expect(BluetoothUUID.commonIsdnAccess != .bit32(0x1128))

        /// SIM Access
        #expect(BluetoothUUID.simAccess.rawValue == "112D")
        #expect(BluetoothUUID.simAccess == .bit16(0x112D))
        #expect(BluetoothUUID.simAccess == .bit16(4397))
        #expect(BluetoothUUID.simAccess.name == "SIM Access")
        #expect(BluetoothUUID.simAccess != .bit32(4397))
        #expect(BluetoothUUID.simAccess != .bit32(0x112D))

        /// Phonebook Access Client
        #expect(BluetoothUUID.phonebookAccessClient.rawValue == "112E")
        #expect(BluetoothUUID.phonebookAccessClient == .bit16(0x112E))
        #expect(BluetoothUUID.phonebookAccessClient == .bit16(4398))
        #expect(BluetoothUUID.phonebookAccessClient.name == "Phonebook Access Client")
        #expect(BluetoothUUID.phonebookAccessClient != .bit32(4398))
        #expect(BluetoothUUID.phonebookAccessClient != .bit32(0x112E))

        /// Phonebook Access Server
        #expect(BluetoothUUID.phonebookAccessServer.rawValue == "112F")
        #expect(BluetoothUUID.phonebookAccessServer == .bit16(0x112F))
        #expect(BluetoothUUID.phonebookAccessServer == .bit16(4399))
        #expect(BluetoothUUID.phonebookAccessServer.name == "Phonebook Access Server")
        #expect(BluetoothUUID.phonebookAccessServer != .bit32(4399))
        #expect(BluetoothUUID.phonebookAccessServer != .bit32(0x112F))

        /// Phonebook Access
        #expect(BluetoothUUID.phonebookAccess.rawValue == "1130")
        #expect(BluetoothUUID.phonebookAccess == .bit16(0x1130))
        #expect(BluetoothUUID.phonebookAccess == .bit16(4400))
        #expect(BluetoothUUID.phonebookAccess.name == "Phonebook Access")
        #expect(BluetoothUUID.phonebookAccess != .bit32(4400))
        #expect(BluetoothUUID.phonebookAccess != .bit32(0x1130))

        /// Headset HS
        #expect(BluetoothUUID.headsetHs.rawValue == "1131")
        #expect(BluetoothUUID.headsetHs == .bit16(0x1131))
        #expect(BluetoothUUID.headsetHs == .bit16(4401))
        #expect(BluetoothUUID.headsetHs.name == "Headset HS")
        #expect(BluetoothUUID.headsetHs != .bit32(4401))
        #expect(BluetoothUUID.headsetHs != .bit32(0x1131))

        /// Message Access Server
        #expect(BluetoothUUID.messageAccessServer.rawValue == "1132")
        #expect(BluetoothUUID.messageAccessServer == .bit16(0x1132))
        #expect(BluetoothUUID.messageAccessServer == .bit16(4402))
        #expect(BluetoothUUID.messageAccessServer.name == "Message Access Server")
        #expect(BluetoothUUID.messageAccessServer != .bit32(4402))
        #expect(BluetoothUUID.messageAccessServer != .bit32(0x1132))

        /// Message Notification Server
        #expect(BluetoothUUID.messageNotificationServer.rawValue == "1133")
        #expect(BluetoothUUID.messageNotificationServer == .bit16(0x1133))
        #expect(BluetoothUUID.messageNotificationServer == .bit16(4403))
        #expect(BluetoothUUID.messageNotificationServer.name == "Message Notification Server")
        #expect(BluetoothUUID.messageNotificationServer != .bit32(4403))
        #expect(BluetoothUUID.messageNotificationServer != .bit32(0x1133))

        /// Message Access Profile
        #expect(BluetoothUUID.messageAccessProfile.rawValue == "1134")
        #expect(BluetoothUUID.messageAccessProfile == .bit16(0x1134))
        #expect(BluetoothUUID.messageAccessProfile == .bit16(4404))
        #expect(BluetoothUUID.messageAccessProfile.name == "Message Access Profile")
        #expect(BluetoothUUID.messageAccessProfile != .bit32(4404))
        #expect(BluetoothUUID.messageAccessProfile != .bit32(0x1134))

        /// GNSS
        #expect(BluetoothUUID.gnss.rawValue == "1135")
        #expect(BluetoothUUID.gnss == .bit16(0x1135))
        #expect(BluetoothUUID.gnss == .bit16(4405))
        #expect(BluetoothUUID.gnss.name == "GNSS")
        #expect(BluetoothUUID.gnss != .bit32(4405))
        #expect(BluetoothUUID.gnss != .bit32(0x1135))

        /// GNSS Server
        #expect(BluetoothUUID.gnssServer.rawValue == "1136")
        #expect(BluetoothUUID.gnssServer == .bit16(0x1136))
        #expect(BluetoothUUID.gnssServer == .bit16(4406))
        #expect(BluetoothUUID.gnssServer.name == "GNSS Server")
        #expect(BluetoothUUID.gnssServer != .bit32(4406))
        #expect(BluetoothUUID.gnssServer != .bit32(0x1136))

        /// 3D Display
        #expect(BluetoothUUID.uuid3Ddisplay.rawValue == "1137")
        #expect(BluetoothUUID.uuid3Ddisplay == .bit16(0x1137))
        #expect(BluetoothUUID.uuid3Ddisplay == .bit16(4407))
        #expect(BluetoothUUID.uuid3Ddisplay.name == "3D Display")
        #expect(BluetoothUUID.uuid3Ddisplay != .bit32(4407))
        #expect(BluetoothUUID.uuid3Ddisplay != .bit32(0x1137))

        /// 3D Glasses
        #expect(BluetoothUUID.uuid3Dglasses.rawValue == "1138")
        #expect(BluetoothUUID.uuid3Dglasses == .bit16(0x1138))
        #expect(BluetoothUUID.uuid3Dglasses == .bit16(4408))
        #expect(BluetoothUUID.uuid3Dglasses.name == "3D Glasses")
        #expect(BluetoothUUID.uuid3Dglasses != .bit32(4408))
        #expect(BluetoothUUID.uuid3Dglasses != .bit32(0x1138))

        /// 3D Synchronization
        #expect(BluetoothUUID.uuid3Dsynchronization.rawValue == "1139")
        #expect(BluetoothUUID.uuid3Dsynchronization == .bit16(0x1139))
        #expect(BluetoothUUID.uuid3Dsynchronization == .bit16(4409))
        #expect(BluetoothUUID.uuid3Dsynchronization.name == "3D Synchronization")
        #expect(BluetoothUUID.uuid3Dsynchronization != .bit32(4409))
        #expect(BluetoothUUID.uuid3Dsynchronization != .bit32(0x1139))

        /// MPS Profile
        #expect(BluetoothUUID.mpsProfile.rawValue == "113A")
        #expect(BluetoothUUID.mpsProfile == .bit16(0x113A))
        #expect(BluetoothUUID.mpsProfile == .bit16(4410))
        #expect(BluetoothUUID.mpsProfile.name == "MPS Profile")
        #expect(BluetoothUUID.mpsProfile != .bit32(4410))
        #expect(BluetoothUUID.mpsProfile != .bit32(0x113A))

        /// MPS Service
        #expect(BluetoothUUID.mpsService.rawValue == "113B")
        #expect(BluetoothUUID.mpsService == .bit16(0x113B))
        #expect(BluetoothUUID.mpsService == .bit16(4411))
        #expect(BluetoothUUID.mpsService.name == "MPS Service")
        #expect(BluetoothUUID.mpsService != .bit32(4411))
        #expect(BluetoothUUID.mpsService != .bit32(0x113B))

        /// PnP Information
        #expect(BluetoothUUID.pnpInformation.rawValue == "1200")
        #expect(BluetoothUUID.pnpInformation == .bit16(0x1200))
        #expect(BluetoothUUID.pnpInformation == .bit16(4608))
        #expect(BluetoothUUID.pnpInformation.name == "PnP Information")
        #expect(BluetoothUUID.pnpInformation != .bit32(4608))
        #expect(BluetoothUUID.pnpInformation != .bit32(0x1200))

        /// Generic Networking
        #expect(BluetoothUUID.genericNetworking.rawValue == "1201")
        #expect(BluetoothUUID.genericNetworking == .bit16(0x1201))
        #expect(BluetoothUUID.genericNetworking == .bit16(4609))
        #expect(BluetoothUUID.genericNetworking.name == "Generic Networking")
        #expect(BluetoothUUID.genericNetworking != .bit32(4609))
        #expect(BluetoothUUID.genericNetworking != .bit32(0x1201))

        /// Generic File Transfer
        #expect(BluetoothUUID.genericFileTransfer.rawValue == "1202")
        #expect(BluetoothUUID.genericFileTransfer == .bit16(0x1202))
        #expect(BluetoothUUID.genericFileTransfer == .bit16(4610))
        #expect(BluetoothUUID.genericFileTransfer.name == "Generic File Transfer")
        #expect(BluetoothUUID.genericFileTransfer != .bit32(4610))
        #expect(BluetoothUUID.genericFileTransfer != .bit32(0x1202))

        /// Generic Audio
        #expect(BluetoothUUID.genericAudio.rawValue == "1203")
        #expect(BluetoothUUID.genericAudio == .bit16(0x1203))
        #expect(BluetoothUUID.genericAudio == .bit16(4611))
        #expect(BluetoothUUID.genericAudio.name == "Generic Audio")
        #expect(BluetoothUUID.genericAudio != .bit32(4611))
        #expect(BluetoothUUID.genericAudio != .bit32(0x1203))

        /// Generic Telephony
        #expect(BluetoothUUID.genericTelephony.rawValue == "1204")
        #expect(BluetoothUUID.genericTelephony == .bit16(0x1204))
        #expect(BluetoothUUID.genericTelephony == .bit16(4612))
        #expect(BluetoothUUID.genericTelephony.name == "Generic Telephony")
        #expect(BluetoothUUID.genericTelephony != .bit32(4612))
        #expect(BluetoothUUID.genericTelephony != .bit32(0x1204))

        /// UPNP Service
        #expect(BluetoothUUID.upnpService.rawValue == "1205")
        #expect(BluetoothUUID.upnpService == .bit16(0x1205))
        #expect(BluetoothUUID.upnpService == .bit16(4613))
        #expect(BluetoothUUID.upnpService.name == "UPNP Service")
        #expect(BluetoothUUID.upnpService != .bit32(4613))
        #expect(BluetoothUUID.upnpService != .bit32(0x1205))

        /// UPNP IP Service
        #expect(BluetoothUUID.upnpIpService.rawValue == "1206")
        #expect(BluetoothUUID.upnpIpService == .bit16(0x1206))
        #expect(BluetoothUUID.upnpIpService == .bit16(4614))
        #expect(BluetoothUUID.upnpIpService.name == "UPNP IP Service")
        #expect(BluetoothUUID.upnpIpService != .bit32(4614))
        #expect(BluetoothUUID.upnpIpService != .bit32(0x1206))

        /// UPNP IP PAN
        #expect(BluetoothUUID.upnpIpPan.rawValue == "1300")
        #expect(BluetoothUUID.upnpIpPan == .bit16(0x1300))
        #expect(BluetoothUUID.upnpIpPan == .bit16(4864))
        #expect(BluetoothUUID.upnpIpPan.name == "UPNP IP PAN")
        #expect(BluetoothUUID.upnpIpPan != .bit32(4864))
        #expect(BluetoothUUID.upnpIpPan != .bit32(0x1300))

        /// UPNP IP LAP
        #expect(BluetoothUUID.upnpIpLap.rawValue == "1301")
        #expect(BluetoothUUID.upnpIpLap == .bit16(0x1301))
        #expect(BluetoothUUID.upnpIpLap == .bit16(4865))
        #expect(BluetoothUUID.upnpIpLap.name == "UPNP IP LAP")
        #expect(BluetoothUUID.upnpIpLap != .bit32(4865))
        #expect(BluetoothUUID.upnpIpLap != .bit32(0x1301))

        /// UPNP IP L2CAP
        #expect(BluetoothUUID.upnpIpL2Cap.rawValue == "1302")
        #expect(BluetoothUUID.upnpIpL2Cap == .bit16(0x1302))
        #expect(BluetoothUUID.upnpIpL2Cap == .bit16(4866))
        #expect(BluetoothUUID.upnpIpL2Cap.name == "UPNP IP L2CAP")
        #expect(BluetoothUUID.upnpIpL2Cap != .bit32(4866))
        #expect(BluetoothUUID.upnpIpL2Cap != .bit32(0x1302))

        /// Video Source
        #expect(BluetoothUUID.videoSource.rawValue == "1303")
        #expect(BluetoothUUID.videoSource == .bit16(0x1303))
        #expect(BluetoothUUID.videoSource == .bit16(4867))
        #expect(BluetoothUUID.videoSource.name == "Video Source")
        #expect(BluetoothUUID.videoSource != .bit32(4867))
        #expect(BluetoothUUID.videoSource != .bit32(0x1303))

        /// Video Sink
        #expect(BluetoothUUID.videoSink.rawValue == "1304")
        #expect(BluetoothUUID.videoSink == .bit16(0x1304))
        #expect(BluetoothUUID.videoSink == .bit16(4868))
        #expect(BluetoothUUID.videoSink.name == "Video Sink")
        #expect(BluetoothUUID.videoSink != .bit32(4868))
        #expect(BluetoothUUID.videoSink != .bit32(0x1304))

        /// Video Distribution
        #expect(BluetoothUUID.videoDistribution.rawValue == "1305")
        #expect(BluetoothUUID.videoDistribution == .bit16(0x1305))
        #expect(BluetoothUUID.videoDistribution == .bit16(4869))
        #expect(BluetoothUUID.videoDistribution.name == "Video Distribution")
        #expect(BluetoothUUID.videoDistribution != .bit32(4869))
        #expect(BluetoothUUID.videoDistribution != .bit32(0x1305))

        /// HDP
        #expect(BluetoothUUID.hdp.rawValue == "1400")
        #expect(BluetoothUUID.hdp == .bit16(0x1400))
        #expect(BluetoothUUID.hdp == .bit16(5120))
        #expect(BluetoothUUID.hdp.name == "HDP")
        #expect(BluetoothUUID.hdp != .bit32(5120))
        #expect(BluetoothUUID.hdp != .bit32(0x1400))

        /// HDP Source
        #expect(BluetoothUUID.hdpSource.rawValue == "1401")
        #expect(BluetoothUUID.hdpSource == .bit16(0x1401))
        #expect(BluetoothUUID.hdpSource == .bit16(5121))
        #expect(BluetoothUUID.hdpSource.name == "HDP Source")
        #expect(BluetoothUUID.hdpSource != .bit32(5121))
        #expect(BluetoothUUID.hdpSource != .bit32(0x1401))

        /// HDP Sink
        #expect(BluetoothUUID.hdpSink.rawValue == "1402")
        #expect(BluetoothUUID.hdpSink == .bit16(0x1402))
        #expect(BluetoothUUID.hdpSink == .bit16(5122))
        #expect(BluetoothUUID.hdpSink.name == "HDP Sink")
        #expect(BluetoothUUID.hdpSink != .bit32(5122))
        #expect(BluetoothUUID.hdpSink != .bit32(0x1402))

        /// Generic Access Profile
        #expect(BluetoothUUID.genericAccessProfile.rawValue == "1800")
        #expect(BluetoothUUID.genericAccessProfile == .bit16(0x1800))
        #expect(BluetoothUUID.genericAccessProfile == .bit16(6144))
        #expect(BluetoothUUID.genericAccessProfile.name == "Generic Access Profile")
        #expect(BluetoothUUID.genericAccessProfile != .bit32(6144))
        #expect(BluetoothUUID.genericAccessProfile != .bit32(0x1800))

        /// Generic Attribute Profile
        #expect(BluetoothUUID.genericAttributeProfile.rawValue == "1801")
        #expect(BluetoothUUID.genericAttributeProfile == .bit16(0x1801))
        #expect(BluetoothUUID.genericAttributeProfile == .bit16(6145))
        #expect(BluetoothUUID.genericAttributeProfile.name == "Generic Attribute Profile")
        #expect(BluetoothUUID.genericAttributeProfile != .bit32(6145))
        #expect(BluetoothUUID.genericAttributeProfile != .bit32(0x1801))

        /// Immediate Alert
        #expect(BluetoothUUID.immediateAlert.rawValue == "1802")
        #expect(BluetoothUUID.immediateAlert == .bit16(0x1802))
        #expect(BluetoothUUID.immediateAlert == .bit16(6146))
        #expect(BluetoothUUID.immediateAlert.name == "Immediate Alert")
        #expect(BluetoothUUID.immediateAlert != .bit32(6146))
        #expect(BluetoothUUID.immediateAlert != .bit32(0x1802))

        /// Link Loss
        #expect(BluetoothUUID.linkLoss.rawValue == "1803")
        #expect(BluetoothUUID.linkLoss == .bit16(0x1803))
        #expect(BluetoothUUID.linkLoss == .bit16(6147))
        #expect(BluetoothUUID.linkLoss.name == "Link Loss")
        #expect(BluetoothUUID.linkLoss != .bit32(6147))
        #expect(BluetoothUUID.linkLoss != .bit32(0x1803))

        /// Tx Power
        #expect(BluetoothUUID.txPower.rawValue == "1804")
        #expect(BluetoothUUID.txPower == .bit16(0x1804))
        #expect(BluetoothUUID.txPower == .bit16(6148))
        #expect(BluetoothUUID.txPower.name == "Tx Power")
        #expect(BluetoothUUID.txPower != .bit32(6148))
        #expect(BluetoothUUID.txPower != .bit32(0x1804))

        /// Current Time Service
        #expect(BluetoothUUID.currentTimeService.rawValue == "1805")
        #expect(BluetoothUUID.currentTimeService == .bit16(0x1805))
        #expect(BluetoothUUID.currentTimeService == .bit16(6149))
        #expect(BluetoothUUID.currentTimeService.name == "Current Time Service")
        #expect(BluetoothUUID.currentTimeService != .bit32(6149))
        #expect(BluetoothUUID.currentTimeService != .bit32(0x1805))

        /// Reference Time Update Service
        #expect(BluetoothUUID.referenceTimeUpdateService.rawValue == "1806")
        #expect(BluetoothUUID.referenceTimeUpdateService == .bit16(0x1806))
        #expect(BluetoothUUID.referenceTimeUpdateService == .bit16(6150))
        #expect(BluetoothUUID.referenceTimeUpdateService.name == "Reference Time Update Service")
        #expect(BluetoothUUID.referenceTimeUpdateService != .bit32(6150))
        #expect(BluetoothUUID.referenceTimeUpdateService != .bit32(0x1806))

        /// Next DST Change Service
        #expect(BluetoothUUID.nextDstChangeService.rawValue == "1807")
        #expect(BluetoothUUID.nextDstChangeService == .bit16(0x1807))
        #expect(BluetoothUUID.nextDstChangeService == .bit16(6151))
        #expect(BluetoothUUID.nextDstChangeService.name == "Next DST Change Service")
        #expect(BluetoothUUID.nextDstChangeService != .bit32(6151))
        #expect(BluetoothUUID.nextDstChangeService != .bit32(0x1807))

        /// Glucose
        #expect(BluetoothUUID.glucose.rawValue == "1808")
        #expect(BluetoothUUID.glucose == .bit16(0x1808))
        #expect(BluetoothUUID.glucose == .bit16(6152))
        #expect(BluetoothUUID.glucose.name == "Glucose")
        #expect(BluetoothUUID.glucose != .bit32(6152))
        #expect(BluetoothUUID.glucose != .bit32(0x1808))

        /// Health Thermometer
        #expect(BluetoothUUID.healthThermometer.rawValue == "1809")
        #expect(BluetoothUUID.healthThermometer == .bit16(0x1809))
        #expect(BluetoothUUID.healthThermometer == .bit16(6153))
        #expect(BluetoothUUID.healthThermometer.name == "Health Thermometer")
        #expect(BluetoothUUID.healthThermometer != .bit32(6153))
        #expect(BluetoothUUID.healthThermometer != .bit32(0x1809))

        /// Device Information
        #expect(BluetoothUUID.deviceInformation.rawValue == "180A")
        #expect(BluetoothUUID.deviceInformation == .bit16(0x180A))
        #expect(BluetoothUUID.deviceInformation == .bit16(6154))
        #expect(BluetoothUUID.deviceInformation.name == "Device Information")
        #expect(BluetoothUUID.deviceInformation != .bit32(6154))
        #expect(BluetoothUUID.deviceInformation != .bit32(0x180A))

        /// Heart Rate
        #expect(BluetoothUUID.heartRate.rawValue == "180D")
        #expect(BluetoothUUID.heartRate == .bit16(0x180D))
        #expect(BluetoothUUID.heartRate == .bit16(6157))
        #expect(BluetoothUUID.heartRate.name == "Heart Rate")
        #expect(BluetoothUUID.heartRate != .bit32(6157))
        #expect(BluetoothUUID.heartRate != .bit32(0x180D))

        /// Phone Alert Status Service
        #expect(BluetoothUUID.phoneAlertStatusService.rawValue == "180E")
        #expect(BluetoothUUID.phoneAlertStatusService == .bit16(0x180E))
        #expect(BluetoothUUID.phoneAlertStatusService == .bit16(6158))
        #expect(BluetoothUUID.phoneAlertStatusService.name == "Phone Alert Status Service")
        #expect(BluetoothUUID.phoneAlertStatusService != .bit32(6158))
        #expect(BluetoothUUID.phoneAlertStatusService != .bit32(0x180E))

        /// Battery Service
        #expect(BluetoothUUID.batteryService.rawValue == "180F")
        #expect(BluetoothUUID.batteryService == .bit16(0x180F))
        #expect(BluetoothUUID.batteryService == .bit16(6159))
        #expect(BluetoothUUID.batteryService.name == "Battery Service")
        #expect(BluetoothUUID.batteryService != .bit32(6159))
        #expect(BluetoothUUID.batteryService != .bit32(0x180F))

        /// Blood Pressure
        #expect(BluetoothUUID.bloodPressure.rawValue == "1810")
        #expect(BluetoothUUID.bloodPressure == .bit16(0x1810))
        #expect(BluetoothUUID.bloodPressure == .bit16(6160))
        #expect(BluetoothUUID.bloodPressure.name == "Blood Pressure")
        #expect(BluetoothUUID.bloodPressure != .bit32(6160))
        #expect(BluetoothUUID.bloodPressure != .bit32(0x1810))

        /// Alert Notification Service
        #expect(BluetoothUUID.alertNotificationService.rawValue == "1811")
        #expect(BluetoothUUID.alertNotificationService == .bit16(0x1811))
        #expect(BluetoothUUID.alertNotificationService == .bit16(6161))
        #expect(BluetoothUUID.alertNotificationService.name == "Alert Notification Service")
        #expect(BluetoothUUID.alertNotificationService != .bit32(6161))
        #expect(BluetoothUUID.alertNotificationService != .bit32(0x1811))

        /// Human Interface Device
        #expect(BluetoothUUID.humanInterfaceDevice.rawValue == "1812")
        #expect(BluetoothUUID.humanInterfaceDevice == .bit16(0x1812))
        #expect(BluetoothUUID.humanInterfaceDevice == .bit16(6162))
        #expect(BluetoothUUID.humanInterfaceDevice.name == "Human Interface Device")
        #expect(BluetoothUUID.humanInterfaceDevice != .bit32(6162))
        #expect(BluetoothUUID.humanInterfaceDevice != .bit32(0x1812))

        /// Scan Parameters
        #expect(BluetoothUUID.scanParameters.rawValue == "1813")
        #expect(BluetoothUUID.scanParameters == .bit16(0x1813))
        #expect(BluetoothUUID.scanParameters == .bit16(6163))
        #expect(BluetoothUUID.scanParameters.name == "Scan Parameters")
        #expect(BluetoothUUID.scanParameters != .bit32(6163))
        #expect(BluetoothUUID.scanParameters != .bit32(0x1813))

        /// Running Speed and Cadence
        #expect(BluetoothUUID.runningSpeedAndCadence.rawValue == "1814")
        #expect(BluetoothUUID.runningSpeedAndCadence == .bit16(0x1814))
        #expect(BluetoothUUID.runningSpeedAndCadence == .bit16(6164))
        #expect(BluetoothUUID.runningSpeedAndCadence.name == "Running Speed and Cadence")
        #expect(BluetoothUUID.runningSpeedAndCadence != .bit32(6164))
        #expect(BluetoothUUID.runningSpeedAndCadence != .bit32(0x1814))

        /// Automation IO
        #expect(BluetoothUUID.automationIo.rawValue == "1815")
        #expect(BluetoothUUID.automationIo == .bit16(0x1815))
        #expect(BluetoothUUID.automationIo == .bit16(6165))
        #expect(BluetoothUUID.automationIo.name == "Automation IO")
        #expect(BluetoothUUID.automationIo != .bit32(6165))
        #expect(BluetoothUUID.automationIo != .bit32(0x1815))

        /// Cycling Speed and Cadence
        #expect(BluetoothUUID.cyclingSpeedAndCadence.rawValue == "1816")
        #expect(BluetoothUUID.cyclingSpeedAndCadence == .bit16(0x1816))
        #expect(BluetoothUUID.cyclingSpeedAndCadence == .bit16(6166))
        #expect(BluetoothUUID.cyclingSpeedAndCadence.name == "Cycling Speed and Cadence")
        #expect(BluetoothUUID.cyclingSpeedAndCadence != .bit32(6166))
        #expect(BluetoothUUID.cyclingSpeedAndCadence != .bit32(0x1816))

        /// Cycling Power
        #expect(BluetoothUUID.cyclingPower.rawValue == "1818")
        #expect(BluetoothUUID.cyclingPower == .bit16(0x1818))
        #expect(BluetoothUUID.cyclingPower == .bit16(6168))
        #expect(BluetoothUUID.cyclingPower.name == "Cycling Power")
        #expect(BluetoothUUID.cyclingPower != .bit32(6168))
        #expect(BluetoothUUID.cyclingPower != .bit32(0x1818))

        /// Location and Navigation
        #expect(BluetoothUUID.locationAndNavigation.rawValue == "1819")
        #expect(BluetoothUUID.locationAndNavigation == .bit16(0x1819))
        #expect(BluetoothUUID.locationAndNavigation == .bit16(6169))
        #expect(BluetoothUUID.locationAndNavigation.name == "Location and Navigation")
        #expect(BluetoothUUID.locationAndNavigation != .bit32(6169))
        #expect(BluetoothUUID.locationAndNavigation != .bit32(0x1819))

        /// Environmental Sensing
        #expect(BluetoothUUID.environmentalSensing.rawValue == "181A")
        #expect(BluetoothUUID.environmentalSensing == .bit16(0x181A))
        #expect(BluetoothUUID.environmentalSensing == .bit16(6170))
        #expect(BluetoothUUID.environmentalSensing.name == "Environmental Sensing")
        #expect(BluetoothUUID.environmentalSensing != .bit32(6170))
        #expect(BluetoothUUID.environmentalSensing != .bit32(0x181A))

        /// Body Composition
        #expect(BluetoothUUID.bodyComposition.rawValue == "181B")
        #expect(BluetoothUUID.bodyComposition == .bit16(0x181B))
        #expect(BluetoothUUID.bodyComposition == .bit16(6171))
        #expect(BluetoothUUID.bodyComposition.name == "Body Composition")
        #expect(BluetoothUUID.bodyComposition != .bit32(6171))
        #expect(BluetoothUUID.bodyComposition != .bit32(0x181B))

        /// User Data
        #expect(BluetoothUUID.userData.rawValue == "181C")
        #expect(BluetoothUUID.userData == .bit16(0x181C))
        #expect(BluetoothUUID.userData == .bit16(6172))
        #expect(BluetoothUUID.userData.name == "User Data")
        #expect(BluetoothUUID.userData != .bit32(6172))
        #expect(BluetoothUUID.userData != .bit32(0x181C))

        /// Weight Scale
        #expect(BluetoothUUID.weightScale.rawValue == "181D")
        #expect(BluetoothUUID.weightScale == .bit16(0x181D))
        #expect(BluetoothUUID.weightScale == .bit16(6173))
        #expect(BluetoothUUID.weightScale.name == "Weight Scale")
        #expect(BluetoothUUID.weightScale != .bit32(6173))
        #expect(BluetoothUUID.weightScale != .bit32(0x181D))

        /// Bond Management
        #expect(BluetoothUUID.bondManagement.rawValue == "181E")
        #expect(BluetoothUUID.bondManagement == .bit16(0x181E))
        #expect(BluetoothUUID.bondManagement == .bit16(6174))
        #expect(BluetoothUUID.bondManagement.name == "Bond Management")
        #expect(BluetoothUUID.bondManagement != .bit32(6174))
        #expect(BluetoothUUID.bondManagement != .bit32(0x181E))

        /// Continuous Glucose Monitoring
        #expect(BluetoothUUID.continuousGlucoseMonitoring.rawValue == "181F")
        #expect(BluetoothUUID.continuousGlucoseMonitoring == .bit16(0x181F))
        #expect(BluetoothUUID.continuousGlucoseMonitoring == .bit16(6175))
        #expect(BluetoothUUID.continuousGlucoseMonitoring.name == "Continuous Glucose Monitoring")
        #expect(BluetoothUUID.continuousGlucoseMonitoring != .bit32(6175))
        #expect(BluetoothUUID.continuousGlucoseMonitoring != .bit32(0x181F))

        /// Internet Protocol Support
        #expect(BluetoothUUID.internetProtocolSupport.rawValue == "1820")
        #expect(BluetoothUUID.internetProtocolSupport == .bit16(0x1820))
        #expect(BluetoothUUID.internetProtocolSupport == .bit16(6176))
        #expect(BluetoothUUID.internetProtocolSupport.name == "Internet Protocol Support")
        #expect(BluetoothUUID.internetProtocolSupport != .bit32(6176))
        #expect(BluetoothUUID.internetProtocolSupport != .bit32(0x1820))

        /// Indoor Positioning
        #expect(BluetoothUUID.indoorPositioning.rawValue == "1821")
        #expect(BluetoothUUID.indoorPositioning == .bit16(0x1821))
        #expect(BluetoothUUID.indoorPositioning == .bit16(6177))
        #expect(BluetoothUUID.indoorPositioning.name == "Indoor Positioning")
        #expect(BluetoothUUID.indoorPositioning != .bit32(6177))
        #expect(BluetoothUUID.indoorPositioning != .bit32(0x1821))

        /// Pulse Oximeter
        #expect(BluetoothUUID.pulseOximeter.rawValue == "1822")
        #expect(BluetoothUUID.pulseOximeter == .bit16(0x1822))
        #expect(BluetoothUUID.pulseOximeter == .bit16(6178))
        #expect(BluetoothUUID.pulseOximeter.name == "Pulse Oximeter")
        #expect(BluetoothUUID.pulseOximeter != .bit32(6178))
        #expect(BluetoothUUID.pulseOximeter != .bit32(0x1822))

        /// HTTP Proxy
        #expect(BluetoothUUID.httpProxy.rawValue == "1823")
        #expect(BluetoothUUID.httpProxy == .bit16(0x1823))
        #expect(BluetoothUUID.httpProxy == .bit16(6179))
        #expect(BluetoothUUID.httpProxy.name == "HTTP Proxy")
        #expect(BluetoothUUID.httpProxy != .bit32(6179))
        #expect(BluetoothUUID.httpProxy != .bit32(0x1823))

        /// Transport Discovery
        #expect(BluetoothUUID.transportDiscovery.rawValue == "1824")
        #expect(BluetoothUUID.transportDiscovery == .bit16(0x1824))
        #expect(BluetoothUUID.transportDiscovery == .bit16(6180))
        #expect(BluetoothUUID.transportDiscovery.name == "Transport Discovery")
        #expect(BluetoothUUID.transportDiscovery != .bit32(6180))
        #expect(BluetoothUUID.transportDiscovery != .bit32(0x1824))

        /// Object Transfer
        #expect(BluetoothUUID.objectTransfer.rawValue == "1825")
        #expect(BluetoothUUID.objectTransfer == .bit16(0x1825))
        #expect(BluetoothUUID.objectTransfer == .bit16(6181))
        #expect(BluetoothUUID.objectTransfer.name == "Object Transfer")
        #expect(BluetoothUUID.objectTransfer != .bit32(6181))
        #expect(BluetoothUUID.objectTransfer != .bit32(0x1825))

        /// Primary Service
        #expect(BluetoothUUID.primaryService.rawValue == "2800")
        #expect(BluetoothUUID.primaryService == .bit16(0x2800))
        #expect(BluetoothUUID.primaryService == .bit16(10240))
        #expect(BluetoothUUID.primaryService.name == "Primary Service")
        #expect(BluetoothUUID.primaryService != .bit32(10240))
        #expect(BluetoothUUID.primaryService != .bit32(0x2800))

        /// Secondary Service
        #expect(BluetoothUUID.secondaryService.rawValue == "2801")
        #expect(BluetoothUUID.secondaryService == .bit16(0x2801))
        #expect(BluetoothUUID.secondaryService == .bit16(10241))
        #expect(BluetoothUUID.secondaryService.name == "Secondary Service")
        #expect(BluetoothUUID.secondaryService != .bit32(10241))
        #expect(BluetoothUUID.secondaryService != .bit32(0x2801))

        /// Include
        #expect(BluetoothUUID.include.rawValue == "2802")
        #expect(BluetoothUUID.include == .bit16(0x2802))
        #expect(BluetoothUUID.include == .bit16(10242))
        #expect(BluetoothUUID.include.name == "Include")
        #expect(BluetoothUUID.include != .bit32(10242))
        #expect(BluetoothUUID.include != .bit32(0x2802))

        /// Characteristic
        #expect(BluetoothUUID.characteristic.rawValue == "2803")
        #expect(BluetoothUUID.characteristic == .bit16(0x2803))
        #expect(BluetoothUUID.characteristic == .bit16(10243))
        #expect(BluetoothUUID.characteristic.name == "Characteristic")
        #expect(BluetoothUUID.characteristic != .bit32(10243))
        #expect(BluetoothUUID.characteristic != .bit32(0x2803))

        /// Characteristic Extended Properties
        #expect(BluetoothUUID.characteristicExtendedProperties.rawValue == "2900")
        #expect(BluetoothUUID.characteristicExtendedProperties == .bit16(0x2900))
        #expect(BluetoothUUID.characteristicExtendedProperties == .bit16(10496))
        #expect(BluetoothUUID.characteristicExtendedProperties.name == "Characteristic Extended Properties")
        #expect(BluetoothUUID.characteristicExtendedProperties != .bit32(10496))
        #expect(BluetoothUUID.characteristicExtendedProperties != .bit32(0x2900))

        /// Characteristic User Description
        #expect(BluetoothUUID.characteristicUserDescription.rawValue == "2901")
        #expect(BluetoothUUID.characteristicUserDescription == .bit16(0x2901))
        #expect(BluetoothUUID.characteristicUserDescription == .bit16(10497))
        #expect(BluetoothUUID.characteristicUserDescription.name == "Characteristic User Description")
        #expect(BluetoothUUID.characteristicUserDescription != .bit32(10497))
        #expect(BluetoothUUID.characteristicUserDescription != .bit32(0x2901))

        /// Client Characteristic Configuration
        #expect(BluetoothUUID.clientCharacteristicConfiguration.rawValue == "2902")
        #expect(BluetoothUUID.clientCharacteristicConfiguration == .bit16(0x2902))
        #expect(BluetoothUUID.clientCharacteristicConfiguration == .bit16(10498))
        #expect(BluetoothUUID.clientCharacteristicConfiguration.name == "Client Characteristic Configuration")
        #expect(BluetoothUUID.clientCharacteristicConfiguration != .bit32(10498))
        #expect(BluetoothUUID.clientCharacteristicConfiguration != .bit32(0x2902))

        /// Server Characteristic Configuration
        #expect(BluetoothUUID.serverCharacteristicConfiguration.rawValue == "2903")
        #expect(BluetoothUUID.serverCharacteristicConfiguration == .bit16(0x2903))
        #expect(BluetoothUUID.serverCharacteristicConfiguration == .bit16(10499))
        #expect(BluetoothUUID.serverCharacteristicConfiguration.name == "Server Characteristic Configuration")
        #expect(BluetoothUUID.serverCharacteristicConfiguration != .bit32(10499))
        #expect(BluetoothUUID.serverCharacteristicConfiguration != .bit32(0x2903))

        /// Characteristic Format
        #expect(BluetoothUUID.characteristicFormat.rawValue == "2904")
        #expect(BluetoothUUID.characteristicFormat == .bit16(0x2904))
        #expect(BluetoothUUID.characteristicFormat == .bit16(10500))
        #expect(BluetoothUUID.characteristicFormat.name == "Characteristic Format")
        #expect(BluetoothUUID.characteristicFormat != .bit32(10500))
        #expect(BluetoothUUID.characteristicFormat != .bit32(0x2904))

        /// Characteristic Aggregate Format
        #expect(BluetoothUUID.characteristicAggregateFormat.rawValue == "2905")
        #expect(BluetoothUUID.characteristicAggregateFormat == .bit16(0x2905))
        #expect(BluetoothUUID.characteristicAggregateFormat == .bit16(10501))
        #expect(BluetoothUUID.characteristicAggregateFormat.name == "Characteristic Aggregate Format")
        #expect(BluetoothUUID.characteristicAggregateFormat != .bit32(10501))
        #expect(BluetoothUUID.characteristicAggregateFormat != .bit32(0x2905))

        /// Valid Range
        #expect(BluetoothUUID.validRange.rawValue == "2906")
        #expect(BluetoothUUID.validRange == .bit16(0x2906))
        #expect(BluetoothUUID.validRange == .bit16(10502))
        #expect(BluetoothUUID.validRange.name == "Valid Range")
        #expect(BluetoothUUID.validRange != .bit32(10502))
        #expect(BluetoothUUID.validRange != .bit32(0x2906))

        /// External Report Reference
        #expect(BluetoothUUID.externalReportReference.rawValue == "2907")
        #expect(BluetoothUUID.externalReportReference == .bit16(0x2907))
        #expect(BluetoothUUID.externalReportReference == .bit16(10503))
        #expect(BluetoothUUID.externalReportReference.name == "External Report Reference")
        #expect(BluetoothUUID.externalReportReference != .bit32(10503))
        #expect(BluetoothUUID.externalReportReference != .bit32(0x2907))

        /// Report Reference
        #expect(BluetoothUUID.reportReference.rawValue == "2908")
        #expect(BluetoothUUID.reportReference == .bit16(0x2908))
        #expect(BluetoothUUID.reportReference == .bit16(10504))
        #expect(BluetoothUUID.reportReference.name == "Report Reference")
        #expect(BluetoothUUID.reportReference != .bit32(10504))
        #expect(BluetoothUUID.reportReference != .bit32(0x2908))

        /// Number of Digitals
        #expect(BluetoothUUID.numberOfDigitals.rawValue == "2909")
        #expect(BluetoothUUID.numberOfDigitals == .bit16(0x2909))
        #expect(BluetoothUUID.numberOfDigitals == .bit16(10505))
        #expect(BluetoothUUID.numberOfDigitals.name == "Number of Digitals")
        #expect(BluetoothUUID.numberOfDigitals != .bit32(10505))
        #expect(BluetoothUUID.numberOfDigitals != .bit32(0x2909))

        /// Value Trigger Setting
        #expect(BluetoothUUID.valueTriggerSetting.rawValue == "290A")
        #expect(BluetoothUUID.valueTriggerSetting == .bit16(0x290A))
        #expect(BluetoothUUID.valueTriggerSetting == .bit16(10506))
        #expect(BluetoothUUID.valueTriggerSetting.name == "Value Trigger Setting")
        #expect(BluetoothUUID.valueTriggerSetting != .bit32(10506))
        #expect(BluetoothUUID.valueTriggerSetting != .bit32(0x290A))

        /// Environmental Sensing Configuration
        #expect(BluetoothUUID.environmentalSensingConfiguration.rawValue == "290B")
        #expect(BluetoothUUID.environmentalSensingConfiguration == .bit16(0x290B))
        #expect(BluetoothUUID.environmentalSensingConfiguration == .bit16(10507))
        #expect(BluetoothUUID.environmentalSensingConfiguration.name == "Environmental Sensing Configuration")
        #expect(BluetoothUUID.environmentalSensingConfiguration != .bit32(10507))
        #expect(BluetoothUUID.environmentalSensingConfiguration != .bit32(0x290B))

        /// Environmental Sensing Measurement
        #expect(BluetoothUUID.environmentalSensingMeasurement.rawValue == "290C")
        #expect(BluetoothUUID.environmentalSensingMeasurement == .bit16(0x290C))
        #expect(BluetoothUUID.environmentalSensingMeasurement == .bit16(10508))
        #expect(BluetoothUUID.environmentalSensingMeasurement.name == "Environmental Sensing Measurement")
        #expect(BluetoothUUID.environmentalSensingMeasurement != .bit32(10508))
        #expect(BluetoothUUID.environmentalSensingMeasurement != .bit32(0x290C))

        /// Environmental Sensing Trigger Setting
        #expect(BluetoothUUID.environmentalSensingTriggerSetting.rawValue == "290D")
        #expect(BluetoothUUID.environmentalSensingTriggerSetting == .bit16(0x290D))
        #expect(BluetoothUUID.environmentalSensingTriggerSetting == .bit16(10509))
        #expect(BluetoothUUID.environmentalSensingTriggerSetting.name == "Environmental Sensing Trigger Setting")
        #expect(BluetoothUUID.environmentalSensingTriggerSetting != .bit32(10509))
        #expect(BluetoothUUID.environmentalSensingTriggerSetting != .bit32(0x290D))

        /// Time Trigger Setting
        #expect(BluetoothUUID.timeTriggerSetting.rawValue == "290E")
        #expect(BluetoothUUID.timeTriggerSetting == .bit16(0x290E))
        #expect(BluetoothUUID.timeTriggerSetting == .bit16(10510))
        #expect(BluetoothUUID.timeTriggerSetting.name == "Time Trigger Setting")
        #expect(BluetoothUUID.timeTriggerSetting != .bit32(10510))
        #expect(BluetoothUUID.timeTriggerSetting != .bit32(0x290E))

        /// Device Name
        #expect(BluetoothUUID.deviceName.rawValue == "2A00")
        #expect(BluetoothUUID.deviceName == .bit16(0x2A00))
        #expect(BluetoothUUID.deviceName == .bit16(10752))
        #expect(BluetoothUUID.deviceName.name == "Device Name")
        #expect(BluetoothUUID.deviceName != .bit32(10752))
        #expect(BluetoothUUID.deviceName != .bit32(0x2A00))

        /// Appearance
        #expect(BluetoothUUID.appearance.rawValue == "2A01")
        #expect(BluetoothUUID.appearance == .bit16(0x2A01))
        #expect(BluetoothUUID.appearance == .bit16(10753))
        #expect(BluetoothUUID.appearance.name == "Appearance")
        #expect(BluetoothUUID.appearance != .bit32(10753))
        #expect(BluetoothUUID.appearance != .bit32(0x2A01))

        /// Peripheral Privacy Flag
        #expect(BluetoothUUID.peripheralPrivacyFlag.rawValue == "2A02")
        #expect(BluetoothUUID.peripheralPrivacyFlag == .bit16(0x2A02))
        #expect(BluetoothUUID.peripheralPrivacyFlag == .bit16(10754))
        #expect(BluetoothUUID.peripheralPrivacyFlag.name == "Peripheral Privacy Flag")
        #expect(BluetoothUUID.peripheralPrivacyFlag != .bit32(10754))
        #expect(BluetoothUUID.peripheralPrivacyFlag != .bit32(0x2A02))

        /// Reconnection Address
        #expect(BluetoothUUID.reconnectionAddress.rawValue == "2A03")
        #expect(BluetoothUUID.reconnectionAddress == .bit16(0x2A03))
        #expect(BluetoothUUID.reconnectionAddress == .bit16(10755))
        #expect(BluetoothUUID.reconnectionAddress.name == "Reconnection Address")
        #expect(BluetoothUUID.reconnectionAddress != .bit32(10755))
        #expect(BluetoothUUID.reconnectionAddress != .bit32(0x2A03))

        /// Peripheral Preferred Connection Parameters
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters.rawValue == "2A04")
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters == .bit16(0x2A04))
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters == .bit16(10756))
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters.name == "Peripheral Preferred Connection Parameters")
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters != .bit32(10756))
        #expect(BluetoothUUID.peripheralPreferredConnectionParameters != .bit32(0x2A04))

        /// Service Changed
        #expect(BluetoothUUID.serviceChanged.rawValue == "2A05")
        #expect(BluetoothUUID.serviceChanged == .bit16(0x2A05))
        #expect(BluetoothUUID.serviceChanged == .bit16(10757))
        #expect(BluetoothUUID.serviceChanged.name == "Service Changed")
        #expect(BluetoothUUID.serviceChanged != .bit32(10757))
        #expect(BluetoothUUID.serviceChanged != .bit32(0x2A05))

        /// Alert Level
        #expect(BluetoothUUID.alertLevel.rawValue == "2A06")
        #expect(BluetoothUUID.alertLevel == .bit16(0x2A06))
        #expect(BluetoothUUID.alertLevel == .bit16(10758))
        #expect(BluetoothUUID.alertLevel.name == "Alert Level")
        #expect(BluetoothUUID.alertLevel != .bit32(10758))
        #expect(BluetoothUUID.alertLevel != .bit32(0x2A06))

        /// Tx Power Level
        #expect(BluetoothUUID.txPowerLevel.rawValue == "2A07")
        #expect(BluetoothUUID.txPowerLevel == .bit16(0x2A07))
        #expect(BluetoothUUID.txPowerLevel == .bit16(10759))
        #expect(BluetoothUUID.txPowerLevel.name == "Tx Power Level")
        #expect(BluetoothUUID.txPowerLevel != .bit32(10759))
        #expect(BluetoothUUID.txPowerLevel != .bit32(0x2A07))

        /// Date Time
        #expect(BluetoothUUID.dateTime.rawValue == "2A08")
        #expect(BluetoothUUID.dateTime == .bit16(0x2A08))
        #expect(BluetoothUUID.dateTime == .bit16(10760))
        #expect(BluetoothUUID.dateTime.name == "Date Time")
        #expect(BluetoothUUID.dateTime != .bit32(10760))
        #expect(BluetoothUUID.dateTime != .bit32(0x2A08))

        /// Day of Week
        #expect(BluetoothUUID.dayOfWeek.rawValue == "2A09")
        #expect(BluetoothUUID.dayOfWeek == .bit16(0x2A09))
        #expect(BluetoothUUID.dayOfWeek == .bit16(10761))
        #expect(BluetoothUUID.dayOfWeek.name == "Day of Week")
        #expect(BluetoothUUID.dayOfWeek != .bit32(10761))
        #expect(BluetoothUUID.dayOfWeek != .bit32(0x2A09))

        /// Day Date Time
        #expect(BluetoothUUID.dayDateTime.rawValue == "2A0A")
        #expect(BluetoothUUID.dayDateTime == .bit16(0x2A0A))
        #expect(BluetoothUUID.dayDateTime == .bit16(10762))
        #expect(BluetoothUUID.dayDateTime.name == "Day Date Time")
        #expect(BluetoothUUID.dayDateTime != .bit32(10762))
        #expect(BluetoothUUID.dayDateTime != .bit32(0x2A0A))

        /// Exact Time 100
        #expect(BluetoothUUID.exactTime100.rawValue == "2A0B")
        #expect(BluetoothUUID.exactTime100 == .bit16(0x2A0B))
        #expect(BluetoothUUID.exactTime100 == .bit16(10763))
        #expect(BluetoothUUID.exactTime100.name == "Exact Time 100")
        #expect(BluetoothUUID.exactTime100 != .bit32(10763))
        #expect(BluetoothUUID.exactTime100 != .bit32(0x2A0B))

        /// Exact Time 256
        #expect(BluetoothUUID.exactTime256.rawValue == "2A0C")
        #expect(BluetoothUUID.exactTime256 == .bit16(0x2A0C))
        #expect(BluetoothUUID.exactTime256 == .bit16(10764))
        #expect(BluetoothUUID.exactTime256.name == "Exact Time 256")
        #expect(BluetoothUUID.exactTime256 != .bit32(10764))
        #expect(BluetoothUUID.exactTime256 != .bit32(0x2A0C))

        /// DST Offset
        #expect(BluetoothUUID.dstOffset.rawValue == "2A0D")
        #expect(BluetoothUUID.dstOffset == .bit16(0x2A0D))
        #expect(BluetoothUUID.dstOffset == .bit16(10765))
        #expect(BluetoothUUID.dstOffset.name == "DST Offset")
        #expect(BluetoothUUID.dstOffset != .bit32(10765))
        #expect(BluetoothUUID.dstOffset != .bit32(0x2A0D))

        /// Time Zone
        #expect(BluetoothUUID.timeZone.rawValue == "2A0E")
        #expect(BluetoothUUID.timeZone == .bit16(0x2A0E))
        #expect(BluetoothUUID.timeZone == .bit16(10766))
        #expect(BluetoothUUID.timeZone.name == "Time Zone")
        #expect(BluetoothUUID.timeZone != .bit32(10766))
        #expect(BluetoothUUID.timeZone != .bit32(0x2A0E))

        /// Local Time Information
        #expect(BluetoothUUID.localTimeInformation.rawValue == "2A0F")
        #expect(BluetoothUUID.localTimeInformation == .bit16(0x2A0F))
        #expect(BluetoothUUID.localTimeInformation == .bit16(10767))
        #expect(BluetoothUUID.localTimeInformation.name == "Local Time Information")
        #expect(BluetoothUUID.localTimeInformation != .bit32(10767))
        #expect(BluetoothUUID.localTimeInformation != .bit32(0x2A0F))

        /// Secondary Time Zone
        #expect(BluetoothUUID.secondaryTimeZone.rawValue == "2A10")
        #expect(BluetoothUUID.secondaryTimeZone == .bit16(0x2A10))
        #expect(BluetoothUUID.secondaryTimeZone == .bit16(10768))
        #expect(BluetoothUUID.secondaryTimeZone.name == "Secondary Time Zone")
        #expect(BluetoothUUID.secondaryTimeZone != .bit32(10768))
        #expect(BluetoothUUID.secondaryTimeZone != .bit32(0x2A10))

        /// Time with DST
        #expect(BluetoothUUID.timeWithDst.rawValue == "2A11")
        #expect(BluetoothUUID.timeWithDst == .bit16(0x2A11))
        #expect(BluetoothUUID.timeWithDst == .bit16(10769))
        #expect(BluetoothUUID.timeWithDst.name == "Time with DST")
        #expect(BluetoothUUID.timeWithDst != .bit32(10769))
        #expect(BluetoothUUID.timeWithDst != .bit32(0x2A11))

        /// Time Accuracy
        #expect(BluetoothUUID.timeAccuracy.rawValue == "2A12")
        #expect(BluetoothUUID.timeAccuracy == .bit16(0x2A12))
        #expect(BluetoothUUID.timeAccuracy == .bit16(10770))
        #expect(BluetoothUUID.timeAccuracy.name == "Time Accuracy")
        #expect(BluetoothUUID.timeAccuracy != .bit32(10770))
        #expect(BluetoothUUID.timeAccuracy != .bit32(0x2A12))

        /// Time Source
        #expect(BluetoothUUID.timeSource.rawValue == "2A13")
        #expect(BluetoothUUID.timeSource == .bit16(0x2A13))
        #expect(BluetoothUUID.timeSource == .bit16(10771))
        #expect(BluetoothUUID.timeSource.name == "Time Source")
        #expect(BluetoothUUID.timeSource != .bit32(10771))
        #expect(BluetoothUUID.timeSource != .bit32(0x2A13))

        /// Reference Time Information
        #expect(BluetoothUUID.referenceTimeInformation.rawValue == "2A14")
        #expect(BluetoothUUID.referenceTimeInformation == .bit16(0x2A14))
        #expect(BluetoothUUID.referenceTimeInformation == .bit16(10772))
        #expect(BluetoothUUID.referenceTimeInformation.name == "Reference Time Information")
        #expect(BluetoothUUID.referenceTimeInformation != .bit32(10772))
        #expect(BluetoothUUID.referenceTimeInformation != .bit32(0x2A14))

        /// Time Broadcast
        #expect(BluetoothUUID.timeBroadcast.rawValue == "2A15")
        #expect(BluetoothUUID.timeBroadcast == .bit16(0x2A15))
        #expect(BluetoothUUID.timeBroadcast == .bit16(10773))
        #expect(BluetoothUUID.timeBroadcast.name == "Time Broadcast")
        #expect(BluetoothUUID.timeBroadcast != .bit32(10773))
        #expect(BluetoothUUID.timeBroadcast != .bit32(0x2A15))

        /// Time Update Control Point
        #expect(BluetoothUUID.timeUpdateControlPoint.rawValue == "2A16")
        #expect(BluetoothUUID.timeUpdateControlPoint == .bit16(0x2A16))
        #expect(BluetoothUUID.timeUpdateControlPoint == .bit16(10774))
        #expect(BluetoothUUID.timeUpdateControlPoint.name == "Time Update Control Point")
        #expect(BluetoothUUID.timeUpdateControlPoint != .bit32(10774))
        #expect(BluetoothUUID.timeUpdateControlPoint != .bit32(0x2A16))

        /// Time Update State
        #expect(BluetoothUUID.timeUpdateState.rawValue == "2A17")
        #expect(BluetoothUUID.timeUpdateState == .bit16(0x2A17))
        #expect(BluetoothUUID.timeUpdateState == .bit16(10775))
        #expect(BluetoothUUID.timeUpdateState.name == "Time Update State")
        #expect(BluetoothUUID.timeUpdateState != .bit32(10775))
        #expect(BluetoothUUID.timeUpdateState != .bit32(0x2A17))

        /// Glucose Measurement
        #expect(BluetoothUUID.glucoseMeasurement.rawValue == "2A18")
        #expect(BluetoothUUID.glucoseMeasurement == .bit16(0x2A18))
        #expect(BluetoothUUID.glucoseMeasurement == .bit16(10776))
        #expect(BluetoothUUID.glucoseMeasurement.name == "Glucose Measurement")
        #expect(BluetoothUUID.glucoseMeasurement != .bit32(10776))
        #expect(BluetoothUUID.glucoseMeasurement != .bit32(0x2A18))

        /// Battery Level
        #expect(BluetoothUUID.batteryLevel.rawValue == "2A19")
        #expect(BluetoothUUID.batteryLevel == .bit16(0x2A19))
        #expect(BluetoothUUID.batteryLevel == .bit16(10777))
        #expect(BluetoothUUID.batteryLevel.name == "Battery Level")
        #expect(BluetoothUUID.batteryLevel != .bit32(10777))
        #expect(BluetoothUUID.batteryLevel != .bit32(0x2A19))

        /// Battery Power State
        #expect(BluetoothUUID.batteryPowerState.rawValue == "2A1A")
        #expect(BluetoothUUID.batteryPowerState == .bit16(0x2A1A))
        #expect(BluetoothUUID.batteryPowerState == .bit16(10778))
        #expect(BluetoothUUID.batteryPowerState.name == "Battery Power State")
        #expect(BluetoothUUID.batteryPowerState != .bit32(10778))
        #expect(BluetoothUUID.batteryPowerState != .bit32(0x2A1A))

        /// Battery Level State
        #expect(BluetoothUUID.batteryLevelState.rawValue == "2A1B")
        #expect(BluetoothUUID.batteryLevelState == .bit16(0x2A1B))
        #expect(BluetoothUUID.batteryLevelState == .bit16(10779))
        #expect(BluetoothUUID.batteryLevelState.name == "Battery Level State")
        #expect(BluetoothUUID.batteryLevelState != .bit32(10779))
        #expect(BluetoothUUID.batteryLevelState != .bit32(0x2A1B))

        /// Temperature Measurement
        #expect(BluetoothUUID.temperatureMeasurement.rawValue == "2A1C")
        #expect(BluetoothUUID.temperatureMeasurement == .bit16(0x2A1C))
        #expect(BluetoothUUID.temperatureMeasurement == .bit16(10780))
        #expect(BluetoothUUID.temperatureMeasurement.name == "Temperature Measurement")
        #expect(BluetoothUUID.temperatureMeasurement != .bit32(10780))
        #expect(BluetoothUUID.temperatureMeasurement != .bit32(0x2A1C))

        /// Temperature Type
        #expect(BluetoothUUID.temperatureType.rawValue == "2A1D")
        #expect(BluetoothUUID.temperatureType == .bit16(0x2A1D))
        #expect(BluetoothUUID.temperatureType == .bit16(10781))
        #expect(BluetoothUUID.temperatureType.name == "Temperature Type")
        #expect(BluetoothUUID.temperatureType != .bit32(10781))
        #expect(BluetoothUUID.temperatureType != .bit32(0x2A1D))

        /// Intermediate Temperature
        #expect(BluetoothUUID.intermediateTemperature.rawValue == "2A1E")
        #expect(BluetoothUUID.intermediateTemperature == .bit16(0x2A1E))
        #expect(BluetoothUUID.intermediateTemperature == .bit16(10782))
        #expect(BluetoothUUID.intermediateTemperature.name == "Intermediate Temperature")
        #expect(BluetoothUUID.intermediateTemperature != .bit32(10782))
        #expect(BluetoothUUID.intermediateTemperature != .bit32(0x2A1E))

        /// Measurement Interval
        #expect(BluetoothUUID.measurementInterval.rawValue == "2A21")
        #expect(BluetoothUUID.measurementInterval == .bit16(0x2A21))
        #expect(BluetoothUUID.measurementInterval == .bit16(10785))
        #expect(BluetoothUUID.measurementInterval.name == "Measurement Interval")
        #expect(BluetoothUUID.measurementInterval != .bit32(10785))
        #expect(BluetoothUUID.measurementInterval != .bit32(0x2A21))

        /// Boot Keyboard Input Report
        #expect(BluetoothUUID.bootKeyboardInputReport.rawValue == "2A22")
        #expect(BluetoothUUID.bootKeyboardInputReport == .bit16(0x2A22))
        #expect(BluetoothUUID.bootKeyboardInputReport == .bit16(10786))
        #expect(BluetoothUUID.bootKeyboardInputReport.name == "Boot Keyboard Input Report")
        #expect(BluetoothUUID.bootKeyboardInputReport != .bit32(10786))
        #expect(BluetoothUUID.bootKeyboardInputReport != .bit32(0x2A22))

        /// System ID
        #expect(BluetoothUUID.systemId.rawValue == "2A23")
        #expect(BluetoothUUID.systemId == .bit16(0x2A23))
        #expect(BluetoothUUID.systemId == .bit16(10787))
        #expect(BluetoothUUID.systemId.name == "System ID")
        #expect(BluetoothUUID.systemId != .bit32(10787))
        #expect(BluetoothUUID.systemId != .bit32(0x2A23))

        /// Model Number String
        #expect(BluetoothUUID.modelNumberString.rawValue == "2A24")
        #expect(BluetoothUUID.modelNumberString == .bit16(0x2A24))
        #expect(BluetoothUUID.modelNumberString == .bit16(10788))
        #expect(BluetoothUUID.modelNumberString.name == "Model Number String")
        #expect(BluetoothUUID.modelNumberString != .bit32(10788))
        #expect(BluetoothUUID.modelNumberString != .bit32(0x2A24))

        /// Serial Number String
        #expect(BluetoothUUID.serialNumberString.rawValue == "2A25")
        #expect(BluetoothUUID.serialNumberString == .bit16(0x2A25))
        #expect(BluetoothUUID.serialNumberString == .bit16(10789))
        #expect(BluetoothUUID.serialNumberString.name == "Serial Number String")
        #expect(BluetoothUUID.serialNumberString != .bit32(10789))
        #expect(BluetoothUUID.serialNumberString != .bit32(0x2A25))

        /// Firmware Revision String
        #expect(BluetoothUUID.firmwareRevisionString.rawValue == "2A26")
        #expect(BluetoothUUID.firmwareRevisionString == .bit16(0x2A26))
        #expect(BluetoothUUID.firmwareRevisionString == .bit16(10790))
        #expect(BluetoothUUID.firmwareRevisionString.name == "Firmware Revision String")
        #expect(BluetoothUUID.firmwareRevisionString != .bit32(10790))
        #expect(BluetoothUUID.firmwareRevisionString != .bit32(0x2A26))

        /// Hardware Revision String
        #expect(BluetoothUUID.hardwareRevisionString.rawValue == "2A27")
        #expect(BluetoothUUID.hardwareRevisionString == .bit16(0x2A27))
        #expect(BluetoothUUID.hardwareRevisionString == .bit16(10791))
        #expect(BluetoothUUID.hardwareRevisionString.name == "Hardware Revision String")
        #expect(BluetoothUUID.hardwareRevisionString != .bit32(10791))
        #expect(BluetoothUUID.hardwareRevisionString != .bit32(0x2A27))

        /// Software Revision String
        #expect(BluetoothUUID.softwareRevisionString.rawValue == "2A28")
        #expect(BluetoothUUID.softwareRevisionString == .bit16(0x2A28))
        #expect(BluetoothUUID.softwareRevisionString == .bit16(10792))
        #expect(BluetoothUUID.softwareRevisionString.name == "Software Revision String")
        #expect(BluetoothUUID.softwareRevisionString != .bit32(10792))
        #expect(BluetoothUUID.softwareRevisionString != .bit32(0x2A28))

        /// Manufacturer Name String
        #expect(BluetoothUUID.manufacturerNameString.rawValue == "2A29")
        #expect(BluetoothUUID.manufacturerNameString == .bit16(0x2A29))
        #expect(BluetoothUUID.manufacturerNameString == .bit16(10793))
        #expect(BluetoothUUID.manufacturerNameString.name == "Manufacturer Name String")
        #expect(BluetoothUUID.manufacturerNameString != .bit32(10793))
        #expect(BluetoothUUID.manufacturerNameString != .bit32(0x2A29))

        /// IEEE 11073-20601 Regulatory Cert. Data List
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList.rawValue == "2A2A")
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList == .bit16(0x2A2A))
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList == .bit16(10794))
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList.name == "IEEE 11073-20601 Regulatory Cert. Data List")
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList != .bit32(10794))
        #expect(BluetoothUUID.ieee1107320601RegulatoryCertDataList != .bit32(0x2A2A))

        /// Current Time
        #expect(BluetoothUUID.currentTime.rawValue == "2A2B")
        #expect(BluetoothUUID.currentTime == .bit16(0x2A2B))
        #expect(BluetoothUUID.currentTime == .bit16(10795))
        #expect(BluetoothUUID.currentTime.name == "Current Time")
        #expect(BluetoothUUID.currentTime != .bit32(10795))
        #expect(BluetoothUUID.currentTime != .bit32(0x2A2B))

        /// Magnetic Declination
        #expect(BluetoothUUID.magneticDeclination.rawValue == "2A2C")
        #expect(BluetoothUUID.magneticDeclination == .bit16(0x2A2C))
        #expect(BluetoothUUID.magneticDeclination == .bit16(10796))
        #expect(BluetoothUUID.magneticDeclination.name == "Magnetic Declination")
        #expect(BluetoothUUID.magneticDeclination != .bit32(10796))
        #expect(BluetoothUUID.magneticDeclination != .bit32(0x2A2C))

        /// Scan Refresh
        #expect(BluetoothUUID.scanRefresh.rawValue == "2A31")
        #expect(BluetoothUUID.scanRefresh == .bit16(0x2A31))
        #expect(BluetoothUUID.scanRefresh == .bit16(10801))
        #expect(BluetoothUUID.scanRefresh.name == "Scan Refresh")
        #expect(BluetoothUUID.scanRefresh != .bit32(10801))
        #expect(BluetoothUUID.scanRefresh != .bit32(0x2A31))

        /// Boot Keyboard Output Report
        #expect(BluetoothUUID.bootKeyboardOutputReport.rawValue == "2A32")
        #expect(BluetoothUUID.bootKeyboardOutputReport == .bit16(0x2A32))
        #expect(BluetoothUUID.bootKeyboardOutputReport == .bit16(10802))
        #expect(BluetoothUUID.bootKeyboardOutputReport.name == "Boot Keyboard Output Report")
        #expect(BluetoothUUID.bootKeyboardOutputReport != .bit32(10802))
        #expect(BluetoothUUID.bootKeyboardOutputReport != .bit32(0x2A32))

        /// Boot Mouse Input Report
        #expect(BluetoothUUID.bootMouseInputReport.rawValue == "2A33")
        #expect(BluetoothUUID.bootMouseInputReport == .bit16(0x2A33))
        #expect(BluetoothUUID.bootMouseInputReport == .bit16(10803))
        #expect(BluetoothUUID.bootMouseInputReport.name == "Boot Mouse Input Report")
        #expect(BluetoothUUID.bootMouseInputReport != .bit32(10803))
        #expect(BluetoothUUID.bootMouseInputReport != .bit32(0x2A33))

        /// Glucose Measurement Context
        #expect(BluetoothUUID.glucoseMeasurementContext.rawValue == "2A34")
        #expect(BluetoothUUID.glucoseMeasurementContext == .bit16(0x2A34))
        #expect(BluetoothUUID.glucoseMeasurementContext == .bit16(10804))
        #expect(BluetoothUUID.glucoseMeasurementContext.name == "Glucose Measurement Context")
        #expect(BluetoothUUID.glucoseMeasurementContext != .bit32(10804))
        #expect(BluetoothUUID.glucoseMeasurementContext != .bit32(0x2A34))

        /// Blood Pressure Measurement
        #expect(BluetoothUUID.bloodPressureMeasurement.rawValue == "2A35")
        #expect(BluetoothUUID.bloodPressureMeasurement == .bit16(0x2A35))
        #expect(BluetoothUUID.bloodPressureMeasurement == .bit16(10805))
        #expect(BluetoothUUID.bloodPressureMeasurement.name == "Blood Pressure Measurement")
        #expect(BluetoothUUID.bloodPressureMeasurement != .bit32(10805))
        #expect(BluetoothUUID.bloodPressureMeasurement != .bit32(0x2A35))

        /// Intermediate Cuff Pressure
        #expect(BluetoothUUID.intermediateCuffPressure.rawValue == "2A36")
        #expect(BluetoothUUID.intermediateCuffPressure == .bit16(0x2A36))
        #expect(BluetoothUUID.intermediateCuffPressure == .bit16(10806))
        #expect(BluetoothUUID.intermediateCuffPressure.name == "Intermediate Cuff Pressure")
        #expect(BluetoothUUID.intermediateCuffPressure != .bit32(10806))
        #expect(BluetoothUUID.intermediateCuffPressure != .bit32(0x2A36))

        /// Heart Rate Measurement
        #expect(BluetoothUUID.heartRateMeasurement.rawValue == "2A37")
        #expect(BluetoothUUID.heartRateMeasurement == .bit16(0x2A37))
        #expect(BluetoothUUID.heartRateMeasurement == .bit16(10807))
        #expect(BluetoothUUID.heartRateMeasurement.name == "Heart Rate Measurement")
        #expect(BluetoothUUID.heartRateMeasurement != .bit32(10807))
        #expect(BluetoothUUID.heartRateMeasurement != .bit32(0x2A37))

        /// Body Sensor Location
        #expect(BluetoothUUID.bodySensorLocation.rawValue == "2A38")
        #expect(BluetoothUUID.bodySensorLocation == .bit16(0x2A38))
        #expect(BluetoothUUID.bodySensorLocation == .bit16(10808))
        #expect(BluetoothUUID.bodySensorLocation.name == "Body Sensor Location")
        #expect(BluetoothUUID.bodySensorLocation != .bit32(10808))
        #expect(BluetoothUUID.bodySensorLocation != .bit32(0x2A38))

        /// Heart Rate Control Point
        #expect(BluetoothUUID.heartRateControlPoint.rawValue == "2A39")
        #expect(BluetoothUUID.heartRateControlPoint == .bit16(0x2A39))
        #expect(BluetoothUUID.heartRateControlPoint == .bit16(10809))
        #expect(BluetoothUUID.heartRateControlPoint.name == "Heart Rate Control Point")
        #expect(BluetoothUUID.heartRateControlPoint != .bit32(10809))
        #expect(BluetoothUUID.heartRateControlPoint != .bit32(0x2A39))

        /// Alert Status
        #expect(BluetoothUUID.alertStatus.rawValue == "2A3F")
        #expect(BluetoothUUID.alertStatus == .bit16(0x2A3F))
        #expect(BluetoothUUID.alertStatus == .bit16(10815))
        #expect(BluetoothUUID.alertStatus.name == "Alert Status")
        #expect(BluetoothUUID.alertStatus != .bit32(10815))
        #expect(BluetoothUUID.alertStatus != .bit32(0x2A3F))

        /// Ringer Control Point
        #expect(BluetoothUUID.ringerControlPoint.rawValue == "2A40")
        #expect(BluetoothUUID.ringerControlPoint == .bit16(0x2A40))
        #expect(BluetoothUUID.ringerControlPoint == .bit16(10816))
        #expect(BluetoothUUID.ringerControlPoint.name == "Ringer Control Point")
        #expect(BluetoothUUID.ringerControlPoint != .bit32(10816))
        #expect(BluetoothUUID.ringerControlPoint != .bit32(0x2A40))

        /// Ringer Setting
        #expect(BluetoothUUID.ringerSetting.rawValue == "2A41")
        #expect(BluetoothUUID.ringerSetting == .bit16(0x2A41))
        #expect(BluetoothUUID.ringerSetting == .bit16(10817))
        #expect(BluetoothUUID.ringerSetting.name == "Ringer Setting")
        #expect(BluetoothUUID.ringerSetting != .bit32(10817))
        #expect(BluetoothUUID.ringerSetting != .bit32(0x2A41))

        /// Alert Category ID Bit Mask
        #expect(BluetoothUUID.alertCategoryIdBitMask.rawValue == "2A42")
        #expect(BluetoothUUID.alertCategoryIdBitMask == .bit16(0x2A42))
        #expect(BluetoothUUID.alertCategoryIdBitMask == .bit16(10818))
        #expect(BluetoothUUID.alertCategoryIdBitMask.name == "Alert Category ID Bit Mask")
        #expect(BluetoothUUID.alertCategoryIdBitMask != .bit32(10818))
        #expect(BluetoothUUID.alertCategoryIdBitMask != .bit32(0x2A42))

        /// Alert Category ID
        #expect(BluetoothUUID.alertCategoryId.rawValue == "2A43")
        #expect(BluetoothUUID.alertCategoryId == .bit16(0x2A43))
        #expect(BluetoothUUID.alertCategoryId == .bit16(10819))
        #expect(BluetoothUUID.alertCategoryId.name == "Alert Category ID")
        #expect(BluetoothUUID.alertCategoryId != .bit32(10819))
        #expect(BluetoothUUID.alertCategoryId != .bit32(0x2A43))

        /// Alert Notification Control Point
        #expect(BluetoothUUID.alertNotificationControlPoint.rawValue == "2A44")
        #expect(BluetoothUUID.alertNotificationControlPoint == .bit16(0x2A44))
        #expect(BluetoothUUID.alertNotificationControlPoint == .bit16(10820))
        #expect(BluetoothUUID.alertNotificationControlPoint.name == "Alert Notification Control Point")
        #expect(BluetoothUUID.alertNotificationControlPoint != .bit32(10820))
        #expect(BluetoothUUID.alertNotificationControlPoint != .bit32(0x2A44))

        /// Unread Alert Status
        #expect(BluetoothUUID.unreadAlertStatus.rawValue == "2A45")
        #expect(BluetoothUUID.unreadAlertStatus == .bit16(0x2A45))
        #expect(BluetoothUUID.unreadAlertStatus == .bit16(10821))
        #expect(BluetoothUUID.unreadAlertStatus.name == "Unread Alert Status")
        #expect(BluetoothUUID.unreadAlertStatus != .bit32(10821))
        #expect(BluetoothUUID.unreadAlertStatus != .bit32(0x2A45))

        /// New Alert
        #expect(BluetoothUUID.newAlert.rawValue == "2A46")
        #expect(BluetoothUUID.newAlert == .bit16(0x2A46))
        #expect(BluetoothUUID.newAlert == .bit16(10822))
        #expect(BluetoothUUID.newAlert.name == "New Alert")
        #expect(BluetoothUUID.newAlert != .bit32(10822))
        #expect(BluetoothUUID.newAlert != .bit32(0x2A46))

        /// Supported New Alert Category
        #expect(BluetoothUUID.supportedNewAlertCategory.rawValue == "2A47")
        #expect(BluetoothUUID.supportedNewAlertCategory == .bit16(0x2A47))
        #expect(BluetoothUUID.supportedNewAlertCategory == .bit16(10823))
        #expect(BluetoothUUID.supportedNewAlertCategory.name == "Supported New Alert Category")
        #expect(BluetoothUUID.supportedNewAlertCategory != .bit32(10823))
        #expect(BluetoothUUID.supportedNewAlertCategory != .bit32(0x2A47))

        /// Supported Unread Alert Category
        #expect(BluetoothUUID.supportedUnreadAlertCategory.rawValue == "2A48")
        #expect(BluetoothUUID.supportedUnreadAlertCategory == .bit16(0x2A48))
        #expect(BluetoothUUID.supportedUnreadAlertCategory == .bit16(10824))
        #expect(BluetoothUUID.supportedUnreadAlertCategory.name == "Supported Unread Alert Category")
        #expect(BluetoothUUID.supportedUnreadAlertCategory != .bit32(10824))
        #expect(BluetoothUUID.supportedUnreadAlertCategory != .bit32(0x2A48))

        /// Blood Pressure Feature
        #expect(BluetoothUUID.bloodPressureFeature.rawValue == "2A49")
        #expect(BluetoothUUID.bloodPressureFeature == .bit16(0x2A49))
        #expect(BluetoothUUID.bloodPressureFeature == .bit16(10825))
        #expect(BluetoothUUID.bloodPressureFeature.name == "Blood Pressure Feature")
        #expect(BluetoothUUID.bloodPressureFeature != .bit32(10825))
        #expect(BluetoothUUID.bloodPressureFeature != .bit32(0x2A49))

        /// HID Information
        #expect(BluetoothUUID.hidInformation.rawValue == "2A4A")
        #expect(BluetoothUUID.hidInformation == .bit16(0x2A4A))
        #expect(BluetoothUUID.hidInformation == .bit16(10826))
        #expect(BluetoothUUID.hidInformation.name == "HID Information")
        #expect(BluetoothUUID.hidInformation != .bit32(10826))
        #expect(BluetoothUUID.hidInformation != .bit32(0x2A4A))

        /// Report Map
        #expect(BluetoothUUID.reportMap.rawValue == "2A4B")
        #expect(BluetoothUUID.reportMap == .bit16(0x2A4B))
        #expect(BluetoothUUID.reportMap == .bit16(10827))
        #expect(BluetoothUUID.reportMap.name == "Report Map")
        #expect(BluetoothUUID.reportMap != .bit32(10827))
        #expect(BluetoothUUID.reportMap != .bit32(0x2A4B))

        /// HID Control Point
        #expect(BluetoothUUID.hidControlPoint.rawValue == "2A4C")
        #expect(BluetoothUUID.hidControlPoint == .bit16(0x2A4C))
        #expect(BluetoothUUID.hidControlPoint == .bit16(10828))
        #expect(BluetoothUUID.hidControlPoint.name == "HID Control Point")
        #expect(BluetoothUUID.hidControlPoint != .bit32(10828))
        #expect(BluetoothUUID.hidControlPoint != .bit32(0x2A4C))

        /// Report
        #expect(BluetoothUUID.report.rawValue == "2A4D")
        #expect(BluetoothUUID.report == .bit16(0x2A4D))
        #expect(BluetoothUUID.report == .bit16(10829))
        #expect(BluetoothUUID.report.name == "Report")
        #expect(BluetoothUUID.report != .bit32(10829))
        #expect(BluetoothUUID.report != .bit32(0x2A4D))

        /// Protocol Mode
        #expect(BluetoothUUID.protocolMode.rawValue == "2A4E")
        #expect(BluetoothUUID.protocolMode == .bit16(0x2A4E))
        #expect(BluetoothUUID.protocolMode == .bit16(10830))
        #expect(BluetoothUUID.protocolMode.name == "Protocol Mode")
        #expect(BluetoothUUID.protocolMode != .bit32(10830))
        #expect(BluetoothUUID.protocolMode != .bit32(0x2A4E))

        /// Scan Interval Window
        #expect(BluetoothUUID.scanIntervalWindow.rawValue == "2A4F")
        #expect(BluetoothUUID.scanIntervalWindow == .bit16(0x2A4F))
        #expect(BluetoothUUID.scanIntervalWindow == .bit16(10831))
        #expect(BluetoothUUID.scanIntervalWindow.name == "Scan Interval Window")
        #expect(BluetoothUUID.scanIntervalWindow != .bit32(10831))
        #expect(BluetoothUUID.scanIntervalWindow != .bit32(0x2A4F))

        /// PnP ID
        #expect(BluetoothUUID.pnpId.rawValue == "2A50")
        #expect(BluetoothUUID.pnpId == .bit16(0x2A50))
        #expect(BluetoothUUID.pnpId == .bit16(10832))
        #expect(BluetoothUUID.pnpId.name == "PnP ID")
        #expect(BluetoothUUID.pnpId != .bit32(10832))
        #expect(BluetoothUUID.pnpId != .bit32(0x2A50))

        /// Glucose Feature
        #expect(BluetoothUUID.glucoseFeature.rawValue == "2A51")
        #expect(BluetoothUUID.glucoseFeature == .bit16(0x2A51))
        #expect(BluetoothUUID.glucoseFeature == .bit16(10833))
        #expect(BluetoothUUID.glucoseFeature.name == "Glucose Feature")
        #expect(BluetoothUUID.glucoseFeature != .bit32(10833))
        #expect(BluetoothUUID.glucoseFeature != .bit32(0x2A51))

        /// Record Access Control Point
        #expect(BluetoothUUID.recordAccessControlPoint.rawValue == "2A52")
        #expect(BluetoothUUID.recordAccessControlPoint == .bit16(0x2A52))
        #expect(BluetoothUUID.recordAccessControlPoint == .bit16(10834))
        #expect(BluetoothUUID.recordAccessControlPoint.name == "Record Access Control Point")
        #expect(BluetoothUUID.recordAccessControlPoint != .bit32(10834))
        #expect(BluetoothUUID.recordAccessControlPoint != .bit32(0x2A52))

        /// RSC Measurement
        #expect(BluetoothUUID.rscMeasurement.rawValue == "2A53")
        #expect(BluetoothUUID.rscMeasurement == .bit16(0x2A53))
        #expect(BluetoothUUID.rscMeasurement == .bit16(10835))
        #expect(BluetoothUUID.rscMeasurement.name == "RSC Measurement")
        #expect(BluetoothUUID.rscMeasurement != .bit32(10835))
        #expect(BluetoothUUID.rscMeasurement != .bit32(0x2A53))

        /// RSC Feature
        #expect(BluetoothUUID.rscFeature.rawValue == "2A54")
        #expect(BluetoothUUID.rscFeature == .bit16(0x2A54))
        #expect(BluetoothUUID.rscFeature == .bit16(10836))
        #expect(BluetoothUUID.rscFeature.name == "RSC Feature")
        #expect(BluetoothUUID.rscFeature != .bit32(10836))
        #expect(BluetoothUUID.rscFeature != .bit32(0x2A54))

        /// SC Control Point
        #expect(BluetoothUUID.scControlPoint.rawValue == "2A55")
        #expect(BluetoothUUID.scControlPoint == .bit16(0x2A55))
        #expect(BluetoothUUID.scControlPoint == .bit16(10837))
        #expect(BluetoothUUID.scControlPoint.name == "SC Control Point")
        #expect(BluetoothUUID.scControlPoint != .bit32(10837))
        #expect(BluetoothUUID.scControlPoint != .bit32(0x2A55))

        /// Digital
        #expect(BluetoothUUID.digital.rawValue == "2A56")
        #expect(BluetoothUUID.digital == .bit16(0x2A56))
        #expect(BluetoothUUID.digital == .bit16(10838))
        #expect(BluetoothUUID.digital.name == "Digital")
        #expect(BluetoothUUID.digital != .bit32(10838))
        #expect(BluetoothUUID.digital != .bit32(0x2A56))

        /// Analog
        #expect(BluetoothUUID.analog.rawValue == "2A58")
        #expect(BluetoothUUID.analog == .bit16(0x2A58))
        #expect(BluetoothUUID.analog == .bit16(10840))
        #expect(BluetoothUUID.analog.name == "Analog")
        #expect(BluetoothUUID.analog != .bit32(10840))
        #expect(BluetoothUUID.analog != .bit32(0x2A58))

        /// Analog Output
        #expect(BluetoothUUID.analogOutput.rawValue == "2A59")
        #expect(BluetoothUUID.analogOutput == .bit16(0x2A59))
        #expect(BluetoothUUID.analogOutput == .bit16(10841))
        #expect(BluetoothUUID.analogOutput.name == "Analog Output")
        #expect(BluetoothUUID.analogOutput != .bit32(10841))
        #expect(BluetoothUUID.analogOutput != .bit32(0x2A59))

        /// Aggregate
        #expect(BluetoothUUID.aggregate.rawValue == "2A5A")
        #expect(BluetoothUUID.aggregate == .bit16(0x2A5A))
        #expect(BluetoothUUID.aggregate == .bit16(10842))
        #expect(BluetoothUUID.aggregate.name == "Aggregate")
        #expect(BluetoothUUID.aggregate != .bit32(10842))
        #expect(BluetoothUUID.aggregate != .bit32(0x2A5A))

        /// CSC Measurement
        #expect(BluetoothUUID.cscMeasurement.rawValue == "2A5B")
        #expect(BluetoothUUID.cscMeasurement == .bit16(0x2A5B))
        #expect(BluetoothUUID.cscMeasurement == .bit16(10843))
        #expect(BluetoothUUID.cscMeasurement.name == "CSC Measurement")
        #expect(BluetoothUUID.cscMeasurement != .bit32(10843))
        #expect(BluetoothUUID.cscMeasurement != .bit32(0x2A5B))

        /// CSC Feature
        #expect(BluetoothUUID.cscFeature.rawValue == "2A5C")
        #expect(BluetoothUUID.cscFeature == .bit16(0x2A5C))
        #expect(BluetoothUUID.cscFeature == .bit16(10844))
        #expect(BluetoothUUID.cscFeature.name == "CSC Feature")
        #expect(BluetoothUUID.cscFeature != .bit32(10844))
        #expect(BluetoothUUID.cscFeature != .bit32(0x2A5C))

        /// Sensor Location
        #expect(BluetoothUUID.sensorLocation.rawValue == "2A5D")
        #expect(BluetoothUUID.sensorLocation == .bit16(0x2A5D))
        #expect(BluetoothUUID.sensorLocation == .bit16(10845))
        #expect(BluetoothUUID.sensorLocation.name == "Sensor Location")
        #expect(BluetoothUUID.sensorLocation != .bit32(10845))
        #expect(BluetoothUUID.sensorLocation != .bit32(0x2A5D))

        /// Cycling Power Measurement
        #expect(BluetoothUUID.cyclingPowerMeasurement.rawValue == "2A63")
        #expect(BluetoothUUID.cyclingPowerMeasurement == .bit16(0x2A63))
        #expect(BluetoothUUID.cyclingPowerMeasurement == .bit16(10851))
        #expect(BluetoothUUID.cyclingPowerMeasurement.name == "Cycling Power Measurement")
        #expect(BluetoothUUID.cyclingPowerMeasurement != .bit32(10851))
        #expect(BluetoothUUID.cyclingPowerMeasurement != .bit32(0x2A63))

        /// Cycling Power Vector
        #expect(BluetoothUUID.cyclingPowerVector.rawValue == "2A64")
        #expect(BluetoothUUID.cyclingPowerVector == .bit16(0x2A64))
        #expect(BluetoothUUID.cyclingPowerVector == .bit16(10852))
        #expect(BluetoothUUID.cyclingPowerVector.name == "Cycling Power Vector")
        #expect(BluetoothUUID.cyclingPowerVector != .bit32(10852))
        #expect(BluetoothUUID.cyclingPowerVector != .bit32(0x2A64))

        /// Cycling Power Feature
        #expect(BluetoothUUID.cyclingPowerFeature.rawValue == "2A65")
        #expect(BluetoothUUID.cyclingPowerFeature == .bit16(0x2A65))
        #expect(BluetoothUUID.cyclingPowerFeature == .bit16(10853))
        #expect(BluetoothUUID.cyclingPowerFeature.name == "Cycling Power Feature")
        #expect(BluetoothUUID.cyclingPowerFeature != .bit32(10853))
        #expect(BluetoothUUID.cyclingPowerFeature != .bit32(0x2A65))

        /// Cycling Power Control Point
        #expect(BluetoothUUID.cyclingPowerControlPoint.rawValue == "2A66")
        #expect(BluetoothUUID.cyclingPowerControlPoint == .bit16(0x2A66))
        #expect(BluetoothUUID.cyclingPowerControlPoint == .bit16(10854))
        #expect(BluetoothUUID.cyclingPowerControlPoint.name == "Cycling Power Control Point")
        #expect(BluetoothUUID.cyclingPowerControlPoint != .bit32(10854))
        #expect(BluetoothUUID.cyclingPowerControlPoint != .bit32(0x2A66))

        /// Location and Speed
        #expect(BluetoothUUID.locationAndSpeed.rawValue == "2A67")
        #expect(BluetoothUUID.locationAndSpeed == .bit16(0x2A67))
        #expect(BluetoothUUID.locationAndSpeed == .bit16(10855))
        #expect(BluetoothUUID.locationAndSpeed.name == "Location and Speed")
        #expect(BluetoothUUID.locationAndSpeed != .bit32(10855))
        #expect(BluetoothUUID.locationAndSpeed != .bit32(0x2A67))

        /// Navigation
        #expect(BluetoothUUID.navigation.rawValue == "2A68")
        #expect(BluetoothUUID.navigation == .bit16(0x2A68))
        #expect(BluetoothUUID.navigation == .bit16(10856))
        #expect(BluetoothUUID.navigation.name == "Navigation")
        #expect(BluetoothUUID.navigation != .bit32(10856))
        #expect(BluetoothUUID.navigation != .bit32(0x2A68))

        /// Position Quality
        #expect(BluetoothUUID.positionQuality.rawValue == "2A69")
        #expect(BluetoothUUID.positionQuality == .bit16(0x2A69))
        #expect(BluetoothUUID.positionQuality == .bit16(10857))
        #expect(BluetoothUUID.positionQuality.name == "Position Quality")
        #expect(BluetoothUUID.positionQuality != .bit32(10857))
        #expect(BluetoothUUID.positionQuality != .bit32(0x2A69))

        /// LN Feature
        #expect(BluetoothUUID.lnFeature.rawValue == "2A6A")
        #expect(BluetoothUUID.lnFeature == .bit16(0x2A6A))
        #expect(BluetoothUUID.lnFeature == .bit16(10858))
        #expect(BluetoothUUID.lnFeature.name == "LN Feature")
        #expect(BluetoothUUID.lnFeature != .bit32(10858))
        #expect(BluetoothUUID.lnFeature != .bit32(0x2A6A))

        /// LN Control Point
        #expect(BluetoothUUID.lnControlPoint.rawValue == "2A6B")
        #expect(BluetoothUUID.lnControlPoint == .bit16(0x2A6B))
        #expect(BluetoothUUID.lnControlPoint == .bit16(10859))
        #expect(BluetoothUUID.lnControlPoint.name == "LN Control Point")
        #expect(BluetoothUUID.lnControlPoint != .bit32(10859))
        #expect(BluetoothUUID.lnControlPoint != .bit32(0x2A6B))

        /// Elevation
        #expect(BluetoothUUID.elevation.rawValue == "2A6C")
        #expect(BluetoothUUID.elevation == .bit16(0x2A6C))
        #expect(BluetoothUUID.elevation == .bit16(10860))
        #expect(BluetoothUUID.elevation.name == "Elevation")
        #expect(BluetoothUUID.elevation != .bit32(10860))
        #expect(BluetoothUUID.elevation != .bit32(0x2A6C))

        /// Pressure
        #expect(BluetoothUUID.pressure.rawValue == "2A6D")
        #expect(BluetoothUUID.pressure == .bit16(0x2A6D))
        #expect(BluetoothUUID.pressure == .bit16(10861))
        #expect(BluetoothUUID.pressure.name == "Pressure")
        #expect(BluetoothUUID.pressure != .bit32(10861))
        #expect(BluetoothUUID.pressure != .bit32(0x2A6D))

        /// Temperature
        #expect(BluetoothUUID.temperature.rawValue == "2A6E")
        #expect(BluetoothUUID.temperature == .bit16(0x2A6E))
        #expect(BluetoothUUID.temperature == .bit16(10862))
        #expect(BluetoothUUID.temperature.name == "Temperature")
        #expect(BluetoothUUID.temperature != .bit32(10862))
        #expect(BluetoothUUID.temperature != .bit32(0x2A6E))

        /// Humidity
        #expect(BluetoothUUID.humidity.rawValue == "2A6F")
        #expect(BluetoothUUID.humidity == .bit16(0x2A6F))
        #expect(BluetoothUUID.humidity == .bit16(10863))
        #expect(BluetoothUUID.humidity.name == "Humidity")
        #expect(BluetoothUUID.humidity != .bit32(10863))
        #expect(BluetoothUUID.humidity != .bit32(0x2A6F))

        /// True Wind Speed
        #expect(BluetoothUUID.trueWindSpeed.rawValue == "2A70")
        #expect(BluetoothUUID.trueWindSpeed == .bit16(0x2A70))
        #expect(BluetoothUUID.trueWindSpeed == .bit16(10864))
        #expect(BluetoothUUID.trueWindSpeed.name == "True Wind Speed")
        #expect(BluetoothUUID.trueWindSpeed != .bit32(10864))
        #expect(BluetoothUUID.trueWindSpeed != .bit32(0x2A70))

        /// True Wind Direction
        #expect(BluetoothUUID.trueWindDirection.rawValue == "2A71")
        #expect(BluetoothUUID.trueWindDirection == .bit16(0x2A71))
        #expect(BluetoothUUID.trueWindDirection == .bit16(10865))
        #expect(BluetoothUUID.trueWindDirection.name == "True Wind Direction")
        #expect(BluetoothUUID.trueWindDirection != .bit32(10865))
        #expect(BluetoothUUID.trueWindDirection != .bit32(0x2A71))

        /// Apparent Wind Speed
        #expect(BluetoothUUID.apparentWindSpeed.rawValue == "2A72")
        #expect(BluetoothUUID.apparentWindSpeed == .bit16(0x2A72))
        #expect(BluetoothUUID.apparentWindSpeed == .bit16(10866))
        #expect(BluetoothUUID.apparentWindSpeed.name == "Apparent Wind Speed")
        #expect(BluetoothUUID.apparentWindSpeed != .bit32(10866))
        #expect(BluetoothUUID.apparentWindSpeed != .bit32(0x2A72))

        /// Apparent Wind Direction
        #expect(BluetoothUUID.apparentWindDirection.rawValue == "2A73")
        #expect(BluetoothUUID.apparentWindDirection == .bit16(0x2A73))
        #expect(BluetoothUUID.apparentWindDirection == .bit16(10867))
        #expect(BluetoothUUID.apparentWindDirection.name == "Apparent Wind Direction")
        #expect(BluetoothUUID.apparentWindDirection != .bit32(10867))
        #expect(BluetoothUUID.apparentWindDirection != .bit32(0x2A73))

        /// Gust Factor
        #expect(BluetoothUUID.gustFactor.rawValue == "2A74")
        #expect(BluetoothUUID.gustFactor == .bit16(0x2A74))
        #expect(BluetoothUUID.gustFactor == .bit16(10868))
        #expect(BluetoothUUID.gustFactor.name == "Gust Factor")
        #expect(BluetoothUUID.gustFactor != .bit32(10868))
        #expect(BluetoothUUID.gustFactor != .bit32(0x2A74))

        /// Pollen Concentration
        #expect(BluetoothUUID.pollenConcentration.rawValue == "2A75")
        #expect(BluetoothUUID.pollenConcentration == .bit16(0x2A75))
        #expect(BluetoothUUID.pollenConcentration == .bit16(10869))
        #expect(BluetoothUUID.pollenConcentration.name == "Pollen Concentration")
        #expect(BluetoothUUID.pollenConcentration != .bit32(10869))
        #expect(BluetoothUUID.pollenConcentration != .bit32(0x2A75))

        /// UV Index
        #expect(BluetoothUUID.uvIndex.rawValue == "2A76")
        #expect(BluetoothUUID.uvIndex == .bit16(0x2A76))
        #expect(BluetoothUUID.uvIndex == .bit16(10870))
        #expect(BluetoothUUID.uvIndex.name == "UV Index")
        #expect(BluetoothUUID.uvIndex != .bit32(10870))
        #expect(BluetoothUUID.uvIndex != .bit32(0x2A76))

        /// Irradiance
        #expect(BluetoothUUID.irradiance.rawValue == "2A77")
        #expect(BluetoothUUID.irradiance == .bit16(0x2A77))
        #expect(BluetoothUUID.irradiance == .bit16(10871))
        #expect(BluetoothUUID.irradiance.name == "Irradiance")
        #expect(BluetoothUUID.irradiance != .bit32(10871))
        #expect(BluetoothUUID.irradiance != .bit32(0x2A77))

        /// Rainfall
        #expect(BluetoothUUID.rainfall.rawValue == "2A78")
        #expect(BluetoothUUID.rainfall == .bit16(0x2A78))
        #expect(BluetoothUUID.rainfall == .bit16(10872))
        #expect(BluetoothUUID.rainfall.name == "Rainfall")
        #expect(BluetoothUUID.rainfall != .bit32(10872))
        #expect(BluetoothUUID.rainfall != .bit32(0x2A78))

        /// Wind Chill
        #expect(BluetoothUUID.windChill.rawValue == "2A79")
        #expect(BluetoothUUID.windChill == .bit16(0x2A79))
        #expect(BluetoothUUID.windChill == .bit16(10873))
        #expect(BluetoothUUID.windChill.name == "Wind Chill")
        #expect(BluetoothUUID.windChill != .bit32(10873))
        #expect(BluetoothUUID.windChill != .bit32(0x2A79))

        /// Heat Index
        #expect(BluetoothUUID.heatIndex.rawValue == "2A7A")
        #expect(BluetoothUUID.heatIndex == .bit16(0x2A7A))
        #expect(BluetoothUUID.heatIndex == .bit16(10874))
        #expect(BluetoothUUID.heatIndex.name == "Heat Index")
        #expect(BluetoothUUID.heatIndex != .bit32(10874))
        #expect(BluetoothUUID.heatIndex != .bit32(0x2A7A))

        /// Dew Point
        #expect(BluetoothUUID.dewPoint.rawValue == "2A7B")
        #expect(BluetoothUUID.dewPoint == .bit16(0x2A7B))
        #expect(BluetoothUUID.dewPoint == .bit16(10875))
        #expect(BluetoothUUID.dewPoint.name == "Dew Point")
        #expect(BluetoothUUID.dewPoint != .bit32(10875))
        #expect(BluetoothUUID.dewPoint != .bit32(0x2A7B))

        /// Trend
        #expect(BluetoothUUID.trend.rawValue == "2A7C")
        #expect(BluetoothUUID.trend == .bit16(0x2A7C))
        #expect(BluetoothUUID.trend == .bit16(10876))
        #expect(BluetoothUUID.trend.name == "Trend")
        #expect(BluetoothUUID.trend != .bit32(10876))
        #expect(BluetoothUUID.trend != .bit32(0x2A7C))

        /// Descriptor Value Changed
        #expect(BluetoothUUID.descriptorValueChanged.rawValue == "2A7D")
        #expect(BluetoothUUID.descriptorValueChanged == .bit16(0x2A7D))
        #expect(BluetoothUUID.descriptorValueChanged == .bit16(10877))
        #expect(BluetoothUUID.descriptorValueChanged.name == "Descriptor Value Changed")
        #expect(BluetoothUUID.descriptorValueChanged != .bit32(10877))
        #expect(BluetoothUUID.descriptorValueChanged != .bit32(0x2A7D))

        /// Aerobic Heart Rate Lower Limit
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit.rawValue == "2A7E")
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit == .bit16(0x2A7E))
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit == .bit16(10878))
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit.name == "Aerobic Heart Rate Lower Limit")
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit != .bit32(10878))
        #expect(BluetoothUUID.aerobicHeartRateLowerLimit != .bit32(0x2A7E))

        /// Aerobic Threshold
        #expect(BluetoothUUID.aerobicThreshold.rawValue == "2A7F")
        #expect(BluetoothUUID.aerobicThreshold == .bit16(0x2A7F))
        #expect(BluetoothUUID.aerobicThreshold == .bit16(10879))
        #expect(BluetoothUUID.aerobicThreshold.name == "Aerobic Threshold")
        #expect(BluetoothUUID.aerobicThreshold != .bit32(10879))
        #expect(BluetoothUUID.aerobicThreshold != .bit32(0x2A7F))

        /// Age
        #expect(BluetoothUUID.age.rawValue == "2A80")
        #expect(BluetoothUUID.age == .bit16(0x2A80))
        #expect(BluetoothUUID.age == .bit16(10880))
        #expect(BluetoothUUID.age.name == "Age")
        #expect(BluetoothUUID.age != .bit32(10880))
        #expect(BluetoothUUID.age != .bit32(0x2A80))

        /// Anaerobic Heart Rate Lower Limit
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit.rawValue == "2A81")
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit == .bit16(0x2A81))
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit == .bit16(10881))
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit.name == "Anaerobic Heart Rate Lower Limit")
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit != .bit32(10881))
        #expect(BluetoothUUID.anaerobicHeartRateLowerLimit != .bit32(0x2A81))

        /// Anaerobic Heart Rate Upper Limit
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit.rawValue == "2A82")
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit == .bit16(0x2A82))
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit == .bit16(10882))
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit.name == "Anaerobic Heart Rate Upper Limit")
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit != .bit32(10882))
        #expect(BluetoothUUID.anaerobicHeartRateUpperLimit != .bit32(0x2A82))

        /// Anaerobic Threshold
        #expect(BluetoothUUID.anaerobicThreshold.rawValue == "2A83")
        #expect(BluetoothUUID.anaerobicThreshold == .bit16(0x2A83))
        #expect(BluetoothUUID.anaerobicThreshold == .bit16(10883))
        #expect(BluetoothUUID.anaerobicThreshold.name == "Anaerobic Threshold")
        #expect(BluetoothUUID.anaerobicThreshold != .bit32(10883))
        #expect(BluetoothUUID.anaerobicThreshold != .bit32(0x2A83))

        /// Aerobic Heart Rate Upper Limit
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit.rawValue == "2A84")
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit == .bit16(0x2A84))
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit == .bit16(10884))
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit.name == "Aerobic Heart Rate Upper Limit")
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit != .bit32(10884))
        #expect(BluetoothUUID.aerobicHeartRateUpperLimit != .bit32(0x2A84))

        /// Date of Birth
        #expect(BluetoothUUID.dateOfBirth.rawValue == "2A85")
        #expect(BluetoothUUID.dateOfBirth == .bit16(0x2A85))
        #expect(BluetoothUUID.dateOfBirth == .bit16(10885))
        #expect(BluetoothUUID.dateOfBirth.name == "Date of Birth")
        #expect(BluetoothUUID.dateOfBirth != .bit32(10885))
        #expect(BluetoothUUID.dateOfBirth != .bit32(0x2A85))

        /// Date of Threshold Assessment
        #expect(BluetoothUUID.dateOfThresholdAssessment.rawValue == "2A86")
        #expect(BluetoothUUID.dateOfThresholdAssessment == .bit16(0x2A86))
        #expect(BluetoothUUID.dateOfThresholdAssessment == .bit16(10886))
        #expect(BluetoothUUID.dateOfThresholdAssessment.name == "Date of Threshold Assessment")
        #expect(BluetoothUUID.dateOfThresholdAssessment != .bit32(10886))
        #expect(BluetoothUUID.dateOfThresholdAssessment != .bit32(0x2A86))

        /// Email Address
        #expect(BluetoothUUID.emailAddress.rawValue == "2A87")
        #expect(BluetoothUUID.emailAddress == .bit16(0x2A87))
        #expect(BluetoothUUID.emailAddress == .bit16(10887))
        #expect(BluetoothUUID.emailAddress.name == "Email Address")
        #expect(BluetoothUUID.emailAddress != .bit32(10887))
        #expect(BluetoothUUID.emailAddress != .bit32(0x2A87))

        /// Fat Burn Heart Rate Lower Limit
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit.rawValue == "2A88")
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit == .bit16(0x2A88))
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit == .bit16(10888))
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit.name == "Fat Burn Heart Rate Lower Limit")
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit != .bit32(10888))
        #expect(BluetoothUUID.fatBurnHeartRateLowerLimit != .bit32(0x2A88))

        /// Fat Burn Heart Rate Upper Limit
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit.rawValue == "2A89")
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit == .bit16(0x2A89))
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit == .bit16(10889))
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit.name == "Fat Burn Heart Rate Upper Limit")
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit != .bit32(10889))
        #expect(BluetoothUUID.fatBurnHeartRateUpperLimit != .bit32(0x2A89))

        /// First Name
        #expect(BluetoothUUID.firstName.rawValue == "2A8A")
        #expect(BluetoothUUID.firstName == .bit16(0x2A8A))
        #expect(BluetoothUUID.firstName == .bit16(10890))
        #expect(BluetoothUUID.firstName.name == "First Name")
        #expect(BluetoothUUID.firstName != .bit32(10890))
        #expect(BluetoothUUID.firstName != .bit32(0x2A8A))

        /// Five Zone Heart Rate Limits
        #expect(BluetoothUUID.fiveZoneHeartRateLimits.rawValue == "2A8B")
        #expect(BluetoothUUID.fiveZoneHeartRateLimits == .bit16(0x2A8B))
        #expect(BluetoothUUID.fiveZoneHeartRateLimits == .bit16(10891))
        #expect(BluetoothUUID.fiveZoneHeartRateLimits.name == "Five Zone Heart Rate Limits")
        #expect(BluetoothUUID.fiveZoneHeartRateLimits != .bit32(10891))
        #expect(BluetoothUUID.fiveZoneHeartRateLimits != .bit32(0x2A8B))

        /// Gender
        #expect(BluetoothUUID.gender.rawValue == "2A8C")
        #expect(BluetoothUUID.gender == .bit16(0x2A8C))
        #expect(BluetoothUUID.gender == .bit16(10892))
        #expect(BluetoothUUID.gender.name == "Gender")
        #expect(BluetoothUUID.gender != .bit32(10892))
        #expect(BluetoothUUID.gender != .bit32(0x2A8C))

        /// Heart Rate Max
        #expect(BluetoothUUID.heartRateMax.rawValue == "2A8D")
        #expect(BluetoothUUID.heartRateMax == .bit16(0x2A8D))
        #expect(BluetoothUUID.heartRateMax == .bit16(10893))
        #expect(BluetoothUUID.heartRateMax.name == "Heart Rate Max")
        #expect(BluetoothUUID.heartRateMax != .bit32(10893))
        #expect(BluetoothUUID.heartRateMax != .bit32(0x2A8D))

        /// Height
        #expect(BluetoothUUID.height.rawValue == "2A8E")
        #expect(BluetoothUUID.height == .bit16(0x2A8E))
        #expect(BluetoothUUID.height == .bit16(10894))
        #expect(BluetoothUUID.height.name == "Height")
        #expect(BluetoothUUID.height != .bit32(10894))
        #expect(BluetoothUUID.height != .bit32(0x2A8E))

        /// Hip Circumference
        #expect(BluetoothUUID.hipCircumference.rawValue == "2A8F")
        #expect(BluetoothUUID.hipCircumference == .bit16(0x2A8F))
        #expect(BluetoothUUID.hipCircumference == .bit16(10895))
        #expect(BluetoothUUID.hipCircumference.name == "Hip Circumference")
        #expect(BluetoothUUID.hipCircumference != .bit32(10895))
        #expect(BluetoothUUID.hipCircumference != .bit32(0x2A8F))

        /// Last Name
        #expect(BluetoothUUID.lastName.rawValue == "2A90")
        #expect(BluetoothUUID.lastName == .bit16(0x2A90))
        #expect(BluetoothUUID.lastName == .bit16(10896))
        #expect(BluetoothUUID.lastName.name == "Last Name")
        #expect(BluetoothUUID.lastName != .bit32(10896))
        #expect(BluetoothUUID.lastName != .bit32(0x2A90))

        /// Maximum Recommended Heart Rate
        #expect(BluetoothUUID.maximumRecommendedHeartRate.rawValue == "2A91")
        #expect(BluetoothUUID.maximumRecommendedHeartRate == .bit16(0x2A91))
        #expect(BluetoothUUID.maximumRecommendedHeartRate == .bit16(10897))
        #expect(BluetoothUUID.maximumRecommendedHeartRate.name == "Maximum Recommended Heart Rate")
        #expect(BluetoothUUID.maximumRecommendedHeartRate != .bit32(10897))
        #expect(BluetoothUUID.maximumRecommendedHeartRate != .bit32(0x2A91))

        /// Resting Heart Rate
        #expect(BluetoothUUID.restingHeartRate.rawValue == "2A92")
        #expect(BluetoothUUID.restingHeartRate == .bit16(0x2A92))
        #expect(BluetoothUUID.restingHeartRate == .bit16(10898))
        #expect(BluetoothUUID.restingHeartRate.name == "Resting Heart Rate")
        #expect(BluetoothUUID.restingHeartRate != .bit32(10898))
        #expect(BluetoothUUID.restingHeartRate != .bit32(0x2A92))

        /// Sport Type for Aerobic/Anaerobic Thresholds
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.rawValue == "2A93")
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds == .bit16(0x2A93))
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds == .bit16(10899))
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.name == "Sport Type for Aerobic/Anaerobic Thresholds")
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds != .bit32(10899))
        #expect(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds != .bit32(0x2A93))

        /// Three Zone Heart Rate Limits
        #expect(BluetoothUUID.threeZoneHeartRateLimits.rawValue == "2A94")
        #expect(BluetoothUUID.threeZoneHeartRateLimits == .bit16(0x2A94))
        #expect(BluetoothUUID.threeZoneHeartRateLimits == .bit16(10900))
        #expect(BluetoothUUID.threeZoneHeartRateLimits.name == "Three Zone Heart Rate Limits")
        #expect(BluetoothUUID.threeZoneHeartRateLimits != .bit32(10900))
        #expect(BluetoothUUID.threeZoneHeartRateLimits != .bit32(0x2A94))

        /// Two Zone Heart Rate Limit
        #expect(BluetoothUUID.twoZoneHeartRateLimit.rawValue == "2A95")
        #expect(BluetoothUUID.twoZoneHeartRateLimit == .bit16(0x2A95))
        #expect(BluetoothUUID.twoZoneHeartRateLimit == .bit16(10901))
        #expect(BluetoothUUID.twoZoneHeartRateLimit.name == "Two Zone Heart Rate Limit")
        #expect(BluetoothUUID.twoZoneHeartRateLimit != .bit32(10901))
        #expect(BluetoothUUID.twoZoneHeartRateLimit != .bit32(0x2A95))

        /// VO2 Max
        #expect(BluetoothUUID.vo2Max.rawValue == "2A96")
        #expect(BluetoothUUID.vo2Max == .bit16(0x2A96))
        #expect(BluetoothUUID.vo2Max == .bit16(10902))
        #expect(BluetoothUUID.vo2Max.name == "VO2 Max")
        #expect(BluetoothUUID.vo2Max != .bit32(10902))
        #expect(BluetoothUUID.vo2Max != .bit32(0x2A96))

        /// Waist Circumference
        #expect(BluetoothUUID.waistCircumference.rawValue == "2A97")
        #expect(BluetoothUUID.waistCircumference == .bit16(0x2A97))
        #expect(BluetoothUUID.waistCircumference == .bit16(10903))
        #expect(BluetoothUUID.waistCircumference.name == "Waist Circumference")
        #expect(BluetoothUUID.waistCircumference != .bit32(10903))
        #expect(BluetoothUUID.waistCircumference != .bit32(0x2A97))

        /// Weight
        #expect(BluetoothUUID.weight.rawValue == "2A98")
        #expect(BluetoothUUID.weight == .bit16(0x2A98))
        #expect(BluetoothUUID.weight == .bit16(10904))
        #expect(BluetoothUUID.weight.name == "Weight")
        #expect(BluetoothUUID.weight != .bit32(10904))
        #expect(BluetoothUUID.weight != .bit32(0x2A98))

        /// Database Change Increment
        #expect(BluetoothUUID.databaseChangerement.rawValue == "2A99")
        #expect(BluetoothUUID.databaseChangerement == .bit16(0x2A99))
        #expect(BluetoothUUID.databaseChangerement == .bit16(10905))
        #expect(BluetoothUUID.databaseChangerement.name == "Database Change Increment")
        #expect(BluetoothUUID.databaseChangerement != .bit32(10905))
        #expect(BluetoothUUID.databaseChangerement != .bit32(0x2A99))

        /// User Index
        #expect(BluetoothUUID.userIndex.rawValue == "2A9A")
        #expect(BluetoothUUID.userIndex == .bit16(0x2A9A))
        #expect(BluetoothUUID.userIndex == .bit16(10906))
        #expect(BluetoothUUID.userIndex.name == "User Index")
        #expect(BluetoothUUID.userIndex != .bit32(10906))
        #expect(BluetoothUUID.userIndex != .bit32(0x2A9A))

        /// Body Composition Feature
        #expect(BluetoothUUID.bodyCompositionFeature.rawValue == "2A9B")
        #expect(BluetoothUUID.bodyCompositionFeature == .bit16(0x2A9B))
        #expect(BluetoothUUID.bodyCompositionFeature == .bit16(10907))
        #expect(BluetoothUUID.bodyCompositionFeature.name == "Body Composition Feature")
        #expect(BluetoothUUID.bodyCompositionFeature != .bit32(10907))
        #expect(BluetoothUUID.bodyCompositionFeature != .bit32(0x2A9B))

        /// Body Composition Measurement
        #expect(BluetoothUUID.bodyCompositionMeasurement.rawValue == "2A9C")
        #expect(BluetoothUUID.bodyCompositionMeasurement == .bit16(0x2A9C))
        #expect(BluetoothUUID.bodyCompositionMeasurement == .bit16(10908))
        #expect(BluetoothUUID.bodyCompositionMeasurement.name == "Body Composition Measurement")
        #expect(BluetoothUUID.bodyCompositionMeasurement != .bit32(10908))
        #expect(BluetoothUUID.bodyCompositionMeasurement != .bit32(0x2A9C))

        /// Weight Measurement
        #expect(BluetoothUUID.weightMeasurement.rawValue == "2A9D")
        #expect(BluetoothUUID.weightMeasurement == .bit16(0x2A9D))
        #expect(BluetoothUUID.weightMeasurement == .bit16(10909))
        #expect(BluetoothUUID.weightMeasurement.name == "Weight Measurement")
        #expect(BluetoothUUID.weightMeasurement != .bit32(10909))
        #expect(BluetoothUUID.weightMeasurement != .bit32(0x2A9D))

        /// Weight Scale Feature
        #expect(BluetoothUUID.weightScaleFeature.rawValue == "2A9E")
        #expect(BluetoothUUID.weightScaleFeature == .bit16(0x2A9E))
        #expect(BluetoothUUID.weightScaleFeature == .bit16(10910))
        #expect(BluetoothUUID.weightScaleFeature.name == "Weight Scale Feature")
        #expect(BluetoothUUID.weightScaleFeature != .bit32(10910))
        #expect(BluetoothUUID.weightScaleFeature != .bit32(0x2A9E))

        /// User Control Point
        #expect(BluetoothUUID.userControlPoint.rawValue == "2A9F")
        #expect(BluetoothUUID.userControlPoint == .bit16(0x2A9F))
        #expect(BluetoothUUID.userControlPoint == .bit16(10911))
        #expect(BluetoothUUID.userControlPoint.name == "User Control Point")
        #expect(BluetoothUUID.userControlPoint != .bit32(10911))
        #expect(BluetoothUUID.userControlPoint != .bit32(0x2A9F))

        /// Magnetic Flux Density - 2D
        #expect(BluetoothUUID.magneticFluxDensity2D.rawValue == "2AA0")
        #expect(BluetoothUUID.magneticFluxDensity2D == .bit16(0x2AA0))
        #expect(BluetoothUUID.magneticFluxDensity2D == .bit16(10912))
        #expect(BluetoothUUID.magneticFluxDensity2D.name == "Magnetic Flux Density - 2D")
        #expect(BluetoothUUID.magneticFluxDensity2D != .bit32(10912))
        #expect(BluetoothUUID.magneticFluxDensity2D != .bit32(0x2AA0))

        /// Magnetic Flux Density - 3D
        #expect(BluetoothUUID.magneticFluxDensity3D.rawValue == "2AA1")
        #expect(BluetoothUUID.magneticFluxDensity3D == .bit16(0x2AA1))
        #expect(BluetoothUUID.magneticFluxDensity3D == .bit16(10913))
        #expect(BluetoothUUID.magneticFluxDensity3D.name == "Magnetic Flux Density - 3D")
        #expect(BluetoothUUID.magneticFluxDensity3D != .bit32(10913))
        #expect(BluetoothUUID.magneticFluxDensity3D != .bit32(0x2AA1))

        /// Language
        #expect(BluetoothUUID.language.rawValue == "2AA2")
        #expect(BluetoothUUID.language == .bit16(0x2AA2))
        #expect(BluetoothUUID.language == .bit16(10914))
        #expect(BluetoothUUID.language.name == "Language")
        #expect(BluetoothUUID.language != .bit32(10914))
        #expect(BluetoothUUID.language != .bit32(0x2AA2))

        /// Barometric Pressure Trend
        #expect(BluetoothUUID.barometricPressureTrend.rawValue == "2AA3")
        #expect(BluetoothUUID.barometricPressureTrend == .bit16(0x2AA3))
        #expect(BluetoothUUID.barometricPressureTrend == .bit16(10915))
        #expect(BluetoothUUID.barometricPressureTrend.name == "Barometric Pressure Trend")
        #expect(BluetoothUUID.barometricPressureTrend != .bit32(10915))
        #expect(BluetoothUUID.barometricPressureTrend != .bit32(0x2AA3))

        /// Bond Management Control Point
        #expect(BluetoothUUID.bondManagementControlPoint.rawValue == "2AA4")
        #expect(BluetoothUUID.bondManagementControlPoint == .bit16(0x2AA4))
        #expect(BluetoothUUID.bondManagementControlPoint == .bit16(10916))
        #expect(BluetoothUUID.bondManagementControlPoint.name == "Bond Management Control Point")
        #expect(BluetoothUUID.bondManagementControlPoint != .bit32(10916))
        #expect(BluetoothUUID.bondManagementControlPoint != .bit32(0x2AA4))

        /// Bond Management Feature
        #expect(BluetoothUUID.bondManagementFeature.rawValue == "2AA5")
        #expect(BluetoothUUID.bondManagementFeature == .bit16(0x2AA5))
        #expect(BluetoothUUID.bondManagementFeature == .bit16(10917))
        #expect(BluetoothUUID.bondManagementFeature.name == "Bond Management Feature")
        #expect(BluetoothUUID.bondManagementFeature != .bit32(10917))
        #expect(BluetoothUUID.bondManagementFeature != .bit32(0x2AA5))

        /// Central Address Resolution
        #expect(BluetoothUUID.centralAddressResolution.rawValue == "2AA6")
        #expect(BluetoothUUID.centralAddressResolution == .bit16(0x2AA6))
        #expect(BluetoothUUID.centralAddressResolution == .bit16(10918))
        #expect(BluetoothUUID.centralAddressResolution.name == "Central Address Resolution")
        #expect(BluetoothUUID.centralAddressResolution != .bit32(10918))
        #expect(BluetoothUUID.centralAddressResolution != .bit32(0x2AA6))

        /// CGM Measurement
        #expect(BluetoothUUID.cgmMeasurement.rawValue == "2AA7")
        #expect(BluetoothUUID.cgmMeasurement == .bit16(0x2AA7))
        #expect(BluetoothUUID.cgmMeasurement == .bit16(10919))
        #expect(BluetoothUUID.cgmMeasurement.name == "CGM Measurement")
        #expect(BluetoothUUID.cgmMeasurement != .bit32(10919))
        #expect(BluetoothUUID.cgmMeasurement != .bit32(0x2AA7))

        /// CGM Feature
        #expect(BluetoothUUID.cgmFeature.rawValue == "2AA8")
        #expect(BluetoothUUID.cgmFeature == .bit16(0x2AA8))
        #expect(BluetoothUUID.cgmFeature == .bit16(10920))
        #expect(BluetoothUUID.cgmFeature.name == "CGM Feature")
        #expect(BluetoothUUID.cgmFeature != .bit32(10920))
        #expect(BluetoothUUID.cgmFeature != .bit32(0x2AA8))

        /// CGM Status
        #expect(BluetoothUUID.cgmStatus.rawValue == "2AA9")
        #expect(BluetoothUUID.cgmStatus == .bit16(0x2AA9))
        #expect(BluetoothUUID.cgmStatus == .bit16(10921))
        #expect(BluetoothUUID.cgmStatus.name == "CGM Status")
        #expect(BluetoothUUID.cgmStatus != .bit32(10921))
        #expect(BluetoothUUID.cgmStatus != .bit32(0x2AA9))

        /// CGM Session Start Time
        #expect(BluetoothUUID.cgmSessionStartTime.rawValue == "2AAA")
        #expect(BluetoothUUID.cgmSessionStartTime == .bit16(0x2AAA))
        #expect(BluetoothUUID.cgmSessionStartTime == .bit16(10922))
        #expect(BluetoothUUID.cgmSessionStartTime.name == "CGM Session Start Time")
        #expect(BluetoothUUID.cgmSessionStartTime != .bit32(10922))
        #expect(BluetoothUUID.cgmSessionStartTime != .bit32(0x2AAA))

        /// CGM Session Run Time
        #expect(BluetoothUUID.cgmSessionRunTime.rawValue == "2AAB")
        #expect(BluetoothUUID.cgmSessionRunTime == .bit16(0x2AAB))
        #expect(BluetoothUUID.cgmSessionRunTime == .bit16(10923))
        #expect(BluetoothUUID.cgmSessionRunTime.name == "CGM Session Run Time")
        #expect(BluetoothUUID.cgmSessionRunTime != .bit32(10923))
        #expect(BluetoothUUID.cgmSessionRunTime != .bit32(0x2AAB))

        /// CGM Specific Ops Control Point
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint.rawValue == "2AAC")
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint == .bit16(0x2AAC))
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint == .bit16(10924))
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint.name == "CGM Specific Ops Control Point")
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint != .bit32(10924))
        #expect(BluetoothUUID.cgmSpecificOpsControlPoint != .bit32(0x2AAC))

        /// Indoor Positioning Configuration
        #expect(BluetoothUUID.indoorPositioningConfiguration.rawValue == "2AAD")
        #expect(BluetoothUUID.indoorPositioningConfiguration == .bit16(0x2AAD))
        #expect(BluetoothUUID.indoorPositioningConfiguration == .bit16(10925))
        #expect(BluetoothUUID.indoorPositioningConfiguration.name == "Indoor Positioning Configuration")
        #expect(BluetoothUUID.indoorPositioningConfiguration != .bit32(10925))
        #expect(BluetoothUUID.indoorPositioningConfiguration != .bit32(0x2AAD))

        /// Latitude
        #expect(BluetoothUUID.latitude.rawValue == "2AAE")
        #expect(BluetoothUUID.latitude == .bit16(0x2AAE))
        #expect(BluetoothUUID.latitude == .bit16(10926))
        #expect(BluetoothUUID.latitude.name == "Latitude")
        #expect(BluetoothUUID.latitude != .bit32(10926))
        #expect(BluetoothUUID.latitude != .bit32(0x2AAE))

        /// Longitude
        #expect(BluetoothUUID.longitude.rawValue == "2AAF")
        #expect(BluetoothUUID.longitude == .bit16(0x2AAF))
        #expect(BluetoothUUID.longitude == .bit16(10927))
        #expect(BluetoothUUID.longitude.name == "Longitude")
        #expect(BluetoothUUID.longitude != .bit32(10927))
        #expect(BluetoothUUID.longitude != .bit32(0x2AAF))

        /// Local North Coordinate
        #expect(BluetoothUUID.localNorthCoordinate.rawValue == "2AB0")
        #expect(BluetoothUUID.localNorthCoordinate == .bit16(0x2AB0))
        #expect(BluetoothUUID.localNorthCoordinate == .bit16(10928))
        #expect(BluetoothUUID.localNorthCoordinate.name == "Local North Coordinate")
        #expect(BluetoothUUID.localNorthCoordinate != .bit32(10928))
        #expect(BluetoothUUID.localNorthCoordinate != .bit32(0x2AB0))

        /// Local East Coordinate
        #expect(BluetoothUUID.localEastCoordinate.rawValue == "2AB1")
        #expect(BluetoothUUID.localEastCoordinate == .bit16(0x2AB1))
        #expect(BluetoothUUID.localEastCoordinate == .bit16(10929))
        #expect(BluetoothUUID.localEastCoordinate.name == "Local East Coordinate")
        #expect(BluetoothUUID.localEastCoordinate != .bit32(10929))
        #expect(BluetoothUUID.localEastCoordinate != .bit32(0x2AB1))

        /// Floor Number
        #expect(BluetoothUUID.floorNumber.rawValue == "2AB2")
        #expect(BluetoothUUID.floorNumber == .bit16(0x2AB2))
        #expect(BluetoothUUID.floorNumber == .bit16(10930))
        #expect(BluetoothUUID.floorNumber.name == "Floor Number")
        #expect(BluetoothUUID.floorNumber != .bit32(10930))
        #expect(BluetoothUUID.floorNumber != .bit32(0x2AB2))

        /// Altitude
        #expect(BluetoothUUID.altitude.rawValue == "2AB3")
        #expect(BluetoothUUID.altitude == .bit16(0x2AB3))
        #expect(BluetoothUUID.altitude == .bit16(10931))
        #expect(BluetoothUUID.altitude.name == "Altitude")
        #expect(BluetoothUUID.altitude != .bit32(10931))
        #expect(BluetoothUUID.altitude != .bit32(0x2AB3))

        /// Uncertainty
        #expect(BluetoothUUID.uncertainty.rawValue == "2AB4")
        #expect(BluetoothUUID.uncertainty == .bit16(0x2AB4))
        #expect(BluetoothUUID.uncertainty == .bit16(10932))
        #expect(BluetoothUUID.uncertainty.name == "Uncertainty")
        #expect(BluetoothUUID.uncertainty != .bit32(10932))
        #expect(BluetoothUUID.uncertainty != .bit32(0x2AB4))

        /// Location Name
        #expect(BluetoothUUID.locationName.rawValue == "2AB5")
        #expect(BluetoothUUID.locationName == .bit16(0x2AB5))
        #expect(BluetoothUUID.locationName == .bit16(10933))
        #expect(BluetoothUUID.locationName.name == "Location Name")
        #expect(BluetoothUUID.locationName != .bit32(10933))
        #expect(BluetoothUUID.locationName != .bit32(0x2AB5))

        /// URI
        #expect(BluetoothUUID.uri.rawValue == "2AB6")
        #expect(BluetoothUUID.uri == .bit16(0x2AB6))
        #expect(BluetoothUUID.uri == .bit16(10934))
        #expect(BluetoothUUID.uri.name == "URI")
        #expect(BluetoothUUID.uri != .bit32(10934))
        #expect(BluetoothUUID.uri != .bit32(0x2AB6))

        /// HTTP Headers
        #expect(BluetoothUUID.httpHeaders.rawValue == "2AB7")
        #expect(BluetoothUUID.httpHeaders == .bit16(0x2AB7))
        #expect(BluetoothUUID.httpHeaders == .bit16(10935))
        #expect(BluetoothUUID.httpHeaders.name == "HTTP Headers")
        #expect(BluetoothUUID.httpHeaders != .bit32(10935))
        #expect(BluetoothUUID.httpHeaders != .bit32(0x2AB7))

        /// HTTP Status Code
        #expect(BluetoothUUID.httpStatusCode.rawValue == "2AB8")
        #expect(BluetoothUUID.httpStatusCode == .bit16(0x2AB8))
        #expect(BluetoothUUID.httpStatusCode == .bit16(10936))
        #expect(BluetoothUUID.httpStatusCode.name == "HTTP Status Code")
        #expect(BluetoothUUID.httpStatusCode != .bit32(10936))
        #expect(BluetoothUUID.httpStatusCode != .bit32(0x2AB8))

        /// HTTP Entity Body
        #expect(BluetoothUUID.httpEntityBody.rawValue == "2AB9")
        #expect(BluetoothUUID.httpEntityBody == .bit16(0x2AB9))
        #expect(BluetoothUUID.httpEntityBody == .bit16(10937))
        #expect(BluetoothUUID.httpEntityBody.name == "HTTP Entity Body")
        #expect(BluetoothUUID.httpEntityBody != .bit32(10937))
        #expect(BluetoothUUID.httpEntityBody != .bit32(0x2AB9))

        /// HTTP Control Point
        #expect(BluetoothUUID.httpControlPoint.rawValue == "2ABA")
        #expect(BluetoothUUID.httpControlPoint == .bit16(0x2ABA))
        #expect(BluetoothUUID.httpControlPoint == .bit16(10938))
        #expect(BluetoothUUID.httpControlPoint.name == "HTTP Control Point")
        #expect(BluetoothUUID.httpControlPoint != .bit32(10938))
        #expect(BluetoothUUID.httpControlPoint != .bit32(0x2ABA))

        /// HTTPS Security
        #expect(BluetoothUUID.httpsSecurity.rawValue == "2ABB")
        #expect(BluetoothUUID.httpsSecurity == .bit16(0x2ABB))
        #expect(BluetoothUUID.httpsSecurity == .bit16(10939))
        #expect(BluetoothUUID.httpsSecurity.name == "HTTPS Security")
        #expect(BluetoothUUID.httpsSecurity != .bit32(10939))
        #expect(BluetoothUUID.httpsSecurity != .bit32(0x2ABB))

        /// TDS Control Point
        #expect(BluetoothUUID.tdsControlPoint.rawValue == "2ABC")
        #expect(BluetoothUUID.tdsControlPoint == .bit16(0x2ABC))
        #expect(BluetoothUUID.tdsControlPoint == .bit16(10940))
        #expect(BluetoothUUID.tdsControlPoint.name == "TDS Control Point")
        #expect(BluetoothUUID.tdsControlPoint != .bit32(10940))
        #expect(BluetoothUUID.tdsControlPoint != .bit32(0x2ABC))

        /// OTS Feature
        #expect(BluetoothUUID.otsFeature.rawValue == "2ABD")
        #expect(BluetoothUUID.otsFeature == .bit16(0x2ABD))
        #expect(BluetoothUUID.otsFeature == .bit16(10941))
        #expect(BluetoothUUID.otsFeature.name == "OTS Feature")
        #expect(BluetoothUUID.otsFeature != .bit32(10941))
        #expect(BluetoothUUID.otsFeature != .bit32(0x2ABD))

        /// Object Name
        #expect(BluetoothUUID.objectName.rawValue == "2ABE")
        #expect(BluetoothUUID.objectName == .bit16(0x2ABE))
        #expect(BluetoothUUID.objectName == .bit16(10942))
        #expect(BluetoothUUID.objectName.name == "Object Name")
        #expect(BluetoothUUID.objectName != .bit32(10942))
        #expect(BluetoothUUID.objectName != .bit32(0x2ABE))

        /// Object Type
        #expect(BluetoothUUID.objectType.rawValue == "2ABF")
        #expect(BluetoothUUID.objectType == .bit16(0x2ABF))
        #expect(BluetoothUUID.objectType == .bit16(10943))
        #expect(BluetoothUUID.objectType.name == "Object Type")
        #expect(BluetoothUUID.objectType != .bit32(10943))
        #expect(BluetoothUUID.objectType != .bit32(0x2ABF))

        /// Object Size
        #expect(BluetoothUUID.objectSize.rawValue == "2AC0")
        #expect(BluetoothUUID.objectSize == .bit16(0x2AC0))
        #expect(BluetoothUUID.objectSize == .bit16(10944))
        #expect(BluetoothUUID.objectSize.name == "Object Size")
        #expect(BluetoothUUID.objectSize != .bit32(10944))
        #expect(BluetoothUUID.objectSize != .bit32(0x2AC0))

        /// Object First-Created
        #expect(BluetoothUUID.objectFirstCreated.rawValue == "2AC1")
        #expect(BluetoothUUID.objectFirstCreated == .bit16(0x2AC1))
        #expect(BluetoothUUID.objectFirstCreated == .bit16(10945))
        #expect(BluetoothUUID.objectFirstCreated.name == "Object First-Created")
        #expect(BluetoothUUID.objectFirstCreated != .bit32(10945))
        #expect(BluetoothUUID.objectFirstCreated != .bit32(0x2AC1))

        /// Object Last-Modified
        #expect(BluetoothUUID.objectLastModified.rawValue == "2AC2")
        #expect(BluetoothUUID.objectLastModified == .bit16(0x2AC2))
        #expect(BluetoothUUID.objectLastModified == .bit16(10946))
        #expect(BluetoothUUID.objectLastModified.name == "Object Last-Modified")
        #expect(BluetoothUUID.objectLastModified != .bit32(10946))
        #expect(BluetoothUUID.objectLastModified != .bit32(0x2AC2))

        /// Object ID
        #expect(BluetoothUUID.objectId.rawValue == "2AC3")
        #expect(BluetoothUUID.objectId == .bit16(0x2AC3))
        #expect(BluetoothUUID.objectId == .bit16(10947))
        #expect(BluetoothUUID.objectId.name == "Object ID")
        #expect(BluetoothUUID.objectId != .bit32(10947))
        #expect(BluetoothUUID.objectId != .bit32(0x2AC3))

        /// Object Properties
        #expect(BluetoothUUID.objectProperties.rawValue == "2AC4")
        #expect(BluetoothUUID.objectProperties == .bit16(0x2AC4))
        #expect(BluetoothUUID.objectProperties == .bit16(10948))
        #expect(BluetoothUUID.objectProperties.name == "Object Properties")
        #expect(BluetoothUUID.objectProperties != .bit32(10948))
        #expect(BluetoothUUID.objectProperties != .bit32(0x2AC4))

        /// Object Action Control Point
        #expect(BluetoothUUID.objectActionControlPoint.rawValue == "2AC5")
        #expect(BluetoothUUID.objectActionControlPoint == .bit16(0x2AC5))
        #expect(BluetoothUUID.objectActionControlPoint == .bit16(10949))
        #expect(BluetoothUUID.objectActionControlPoint.name == "Object Action Control Point")
        #expect(BluetoothUUID.objectActionControlPoint != .bit32(10949))
        #expect(BluetoothUUID.objectActionControlPoint != .bit32(0x2AC5))

        /// Object List Control Point
        #expect(BluetoothUUID.objectListControlPoint.rawValue == "2AC6")
        #expect(BluetoothUUID.objectListControlPoint == .bit16(0x2AC6))
        #expect(BluetoothUUID.objectListControlPoint == .bit16(10950))
        #expect(BluetoothUUID.objectListControlPoint.name == "Object List Control Point")
        #expect(BluetoothUUID.objectListControlPoint != .bit32(10950))
        #expect(BluetoothUUID.objectListControlPoint != .bit32(0x2AC6))

        /// Object List Filter
        #expect(BluetoothUUID.objectListFilter.rawValue == "2AC7")
        #expect(BluetoothUUID.objectListFilter == .bit16(0x2AC7))
        #expect(BluetoothUUID.objectListFilter == .bit16(10951))
        #expect(BluetoothUUID.objectListFilter.name == "Object List Filter")
        #expect(BluetoothUUID.objectListFilter != .bit32(10951))
        #expect(BluetoothUUID.objectListFilter != .bit32(0x2AC7))

        /// Object Changed
        #expect(BluetoothUUID.objectChanged.rawValue == "2AC8")
        #expect(BluetoothUUID.objectChanged == .bit16(0x2AC8))
        #expect(BluetoothUUID.objectChanged == .bit16(10952))
        #expect(BluetoothUUID.objectChanged.name == "Object Changed")
        #expect(BluetoothUUID.objectChanged != .bit32(10952))
        #expect(BluetoothUUID.objectChanged != .bit32(0x2AC8))

        /// Cross Trainer Data
        #expect(BluetoothUUID.crossTrainerData.rawValue == "2ACE")
        #expect(BluetoothUUID.crossTrainerData == .bit16(0x2ACE))
        #expect(BluetoothUUID.crossTrainerData == .bit16(10958))
        #expect(BluetoothUUID.crossTrainerData.name == "Cross Trainer Data")
        #expect(BluetoothUUID.crossTrainerData != .bit32(10958))
        #expect(BluetoothUUID.crossTrainerData != .bit32(0x2ACE))

        /// Date UTC
        #expect(BluetoothUUID.dateUtc.rawValue == "2AED")
        #expect(BluetoothUUID.dateUtc == .bit16(0x2AED))
        #expect(BluetoothUUID.dateUtc == .bit16(10989))
        #expect(BluetoothUUID.dateUtc.name == "Date UTC")
        #expect(BluetoothUUID.dateUtc != .bit32(10989))
        #expect(BluetoothUUID.dateUtc != .bit32(0x2AED))

        /// Abbott Diabetes Care
        #expect(BluetoothUUID.abbottDiabetesCare.rawValue == "FDE3")
        #expect(BluetoothUUID.abbottDiabetesCare == .bit16(0xFDE3))
        #expect(BluetoothUUID.abbottDiabetesCare == .bit16(64995))
        #expect(BluetoothUUID.abbottDiabetesCare.name == "Abbott Diabetes Care")
        #expect(BluetoothUUID.abbottDiabetesCare != .bit32(64995))
        #expect(BluetoothUUID.abbottDiabetesCare != .bit32(0xFDE3))

        /// JUUL Labs, Inc.
        #expect(BluetoothUUID.juulLabs.rawValue == "FDE4")
        #expect(BluetoothUUID.juulLabs == .bit16(0xFDE4))
        #expect(BluetoothUUID.juulLabs == .bit16(64996))
        #expect(BluetoothUUID.juulLabs.name == "JUUL Labs, Inc.")
        #expect(BluetoothUUID.juulLabs != .bit32(64996))
        #expect(BluetoothUUID.juulLabs != .bit32(0xFDE4))

        /// SMK Corporation
        #expect(BluetoothUUID.smk.rawValue == "FDE5")
        #expect(BluetoothUUID.smk == .bit16(0xFDE5))
        #expect(BluetoothUUID.smk == .bit16(64997))
        #expect(BluetoothUUID.smk.name == "SMK Corporation")
        #expect(BluetoothUUID.smk != .bit32(64997))
        #expect(BluetoothUUID.smk != .bit32(0xFDE5))

        /// Intelletto Technologies Inc
        #expect(BluetoothUUID.intellettoTechnologies.rawValue == "FDE6")
        #expect(BluetoothUUID.intellettoTechnologies == .bit16(0xFDE6))
        #expect(BluetoothUUID.intellettoTechnologies == .bit16(64998))
        #expect(BluetoothUUID.intellettoTechnologies.name == "Intelletto Technologies Inc")
        #expect(BluetoothUUID.intellettoTechnologies != .bit32(64998))
        #expect(BluetoothUUID.intellettoTechnologies != .bit32(0xFDE6))

        /// SECOM Co., LTD
        #expect(BluetoothUUID.secom.rawValue == "FDE7")
        #expect(BluetoothUUID.secom == .bit16(0xFDE7))
        #expect(BluetoothUUID.secom == .bit16(64999))
        #expect(BluetoothUUID.secom.name == "SECOM Co., LTD")
        #expect(BluetoothUUID.secom != .bit32(64999))
        #expect(BluetoothUUID.secom != .bit32(0xFDE7))

        /// Robert Bosch GmbH
        #expect(BluetoothUUID.robertBosch.rawValue == "FDE8")
        #expect(BluetoothUUID.robertBosch == .bit16(0xFDE8))
        #expect(BluetoothUUID.robertBosch == .bit16(65000))
        #expect(BluetoothUUID.robertBosch.name == "Robert Bosch GmbH")
        #expect(BluetoothUUID.robertBosch != .bit32(65000))
        #expect(BluetoothUUID.robertBosch != .bit32(0xFDE8))

        /// Spacesaver Corporation
        #expect(BluetoothUUID.spacesaver.rawValue == "FDE9")
        #expect(BluetoothUUID.spacesaver == .bit16(0xFDE9))
        #expect(BluetoothUUID.spacesaver == .bit16(65001))
        #expect(BluetoothUUID.spacesaver.name == "Spacesaver Corporation")
        #expect(BluetoothUUID.spacesaver != .bit32(65001))
        #expect(BluetoothUUID.spacesaver != .bit32(0xFDE9))

        /// SeeScan, Inc
        #expect(BluetoothUUID.seescan.rawValue == "FDEA")
        #expect(BluetoothUUID.seescan == .bit16(0xFDEA))
        #expect(BluetoothUUID.seescan == .bit16(65002))
        #expect(BluetoothUUID.seescan.name == "SeeScan, Inc")
        #expect(BluetoothUUID.seescan != .bit32(65002))
        #expect(BluetoothUUID.seescan != .bit32(0xFDEA))

        /// Syntronix Corporation
        #expect(BluetoothUUID.syntronix.rawValue == "FDEB")
        #expect(BluetoothUUID.syntronix == .bit16(0xFDEB))
        #expect(BluetoothUUID.syntronix == .bit16(65003))
        #expect(BluetoothUUID.syntronix.name == "Syntronix Corporation")
        #expect(BluetoothUUID.syntronix != .bit32(65003))
        #expect(BluetoothUUID.syntronix != .bit32(0xFDEB))

        /// Mannkind Corporation
        #expect(BluetoothUUID.mannkind.rawValue == "FDEC")
        #expect(BluetoothUUID.mannkind == .bit16(0xFDEC))
        #expect(BluetoothUUID.mannkind == .bit16(65004))
        #expect(BluetoothUUID.mannkind.name == "Mannkind Corporation")
        #expect(BluetoothUUID.mannkind != .bit32(65004))
        #expect(BluetoothUUID.mannkind != .bit32(0xFDEC))

        /// Pole Star
        #expect(BluetoothUUID.poleStar.rawValue == "FDED")
        #expect(BluetoothUUID.poleStar == .bit16(0xFDED))
        #expect(BluetoothUUID.poleStar == .bit16(65005))
        #expect(BluetoothUUID.poleStar.name == "Pole Star")
        #expect(BluetoothUUID.poleStar != .bit32(65005))
        #expect(BluetoothUUID.poleStar != .bit32(0xFDED))

        /// Huawei Technologies Co., Ltd.
        #expect(BluetoothUUID.huaweiTechnologies.rawValue == "FDEE")
        #expect(BluetoothUUID.huaweiTechnologies == .bit16(0xFDEE))
        #expect(BluetoothUUID.huaweiTechnologies == .bit16(65006))
        #expect(BluetoothUUID.huaweiTechnologies.name == "Huawei Technologies Co., Ltd.")
        #expect(BluetoothUUID.huaweiTechnologies != .bit32(65006))
        #expect(BluetoothUUID.huaweiTechnologies != .bit32(0xFDEE))

        /// ART AND PROGRAM, INC.
        #expect(BluetoothUUID.artAndProgram.rawValue == "FDEF")
        #expect(BluetoothUUID.artAndProgram == .bit16(0xFDEF))
        #expect(BluetoothUUID.artAndProgram == .bit16(65007))
        #expect(BluetoothUUID.artAndProgram.name == "ART AND PROGRAM, INC.")
        #expect(BluetoothUUID.artAndProgram != .bit32(65007))
        #expect(BluetoothUUID.artAndProgram != .bit32(0xFDEF))

        /// Google Inc.
        #expect(BluetoothUUID.google.rawValue == "FDF0")
        #expect(BluetoothUUID.google == .bit16(0xFDF0))
        #expect(BluetoothUUID.google == .bit16(65008))
        #expect(BluetoothUUID.google.name == "Google Inc.")
        #expect(BluetoothUUID.google != .bit32(65008))
        #expect(BluetoothUUID.google != .bit32(0xFDF0))

        /// LAMPLIGHT Co.,Ltd
        #expect(BluetoothUUID.lamplight.rawValue == "FDF1")
        #expect(BluetoothUUID.lamplight == .bit16(0xFDF1))
        #expect(BluetoothUUID.lamplight == .bit16(65009))
        #expect(BluetoothUUID.lamplight.name == "LAMPLIGHT Co.,Ltd")
        #expect(BluetoothUUID.lamplight != .bit32(65009))
        #expect(BluetoothUUID.lamplight != .bit32(0xFDF1))

        /// AMICCOM Electronics Corporation
        #expect(BluetoothUUID.amiccomElectronics.rawValue == "FDF2")
        #expect(BluetoothUUID.amiccomElectronics == .bit16(0xFDF2))
        #expect(BluetoothUUID.amiccomElectronics == .bit16(65010))
        #expect(BluetoothUUID.amiccomElectronics.name == "AMICCOM Electronics Corporation")
        #expect(BluetoothUUID.amiccomElectronics != .bit32(65010))
        #expect(BluetoothUUID.amiccomElectronics != .bit32(0xFDF2))

        /// Amersports
        #expect(BluetoothUUID.amersports.rawValue == "FDF3")
        #expect(BluetoothUUID.amersports == .bit16(0xFDF3))
        #expect(BluetoothUUID.amersports == .bit16(65011))
        #expect(BluetoothUUID.amersports.name == "Amersports")
        #expect(BluetoothUUID.amersports != .bit32(65011))
        #expect(BluetoothUUID.amersports != .bit32(0xFDF3))

        /// O. E. M. Controls, Inc.
        #expect(BluetoothUUID.oEMControls.rawValue == "FDF4")
        #expect(BluetoothUUID.oEMControls == .bit16(0xFDF4))
        #expect(BluetoothUUID.oEMControls == .bit16(65012))
        #expect(BluetoothUUID.oEMControls.name == "O. E. M. Controls, Inc.")
        #expect(BluetoothUUID.oEMControls != .bit32(65012))
        #expect(BluetoothUUID.oEMControls != .bit32(0xFDF4))

        /// Milwaukee Electric Tools
        #expect(BluetoothUUID.milwaukeeElectricTools.rawValue == "FDF5")
        #expect(BluetoothUUID.milwaukeeElectricTools == .bit16(0xFDF5))
        #expect(BluetoothUUID.milwaukeeElectricTools == .bit16(65013))
        #expect(BluetoothUUID.milwaukeeElectricTools.name == "Milwaukee Electric Tools")
        #expect(BluetoothUUID.milwaukeeElectricTools != .bit32(65013))
        #expect(BluetoothUUID.milwaukeeElectricTools != .bit32(0xFDF5))

        /// AIAIAI ApS
        #expect(BluetoothUUID.aiaiai.rawValue == "FDF6")
        #expect(BluetoothUUID.aiaiai == .bit16(0xFDF6))
        #expect(BluetoothUUID.aiaiai == .bit16(65014))
        #expect(BluetoothUUID.aiaiai.name == "AIAIAI ApS")
        #expect(BluetoothUUID.aiaiai != .bit32(65014))
        #expect(BluetoothUUID.aiaiai != .bit32(0xFDF6))

        /// HP Inc.
        #expect(BluetoothUUID.hp.rawValue == "FDF7")
        #expect(BluetoothUUID.hp == .bit16(0xFDF7))
        #expect(BluetoothUUID.hp == .bit16(65015))
        #expect(BluetoothUUID.hp.name == "HP Inc.")
        #expect(BluetoothUUID.hp != .bit32(65015))
        #expect(BluetoothUUID.hp != .bit32(0xFDF7))

        /// Onvocal
        #expect(BluetoothUUID.onvocal.rawValue == "FDF8")
        #expect(BluetoothUUID.onvocal == .bit16(0xFDF8))
        #expect(BluetoothUUID.onvocal == .bit16(65016))
        #expect(BluetoothUUID.onvocal.name == "Onvocal")
        #expect(BluetoothUUID.onvocal != .bit32(65016))
        #expect(BluetoothUUID.onvocal != .bit32(0xFDF8))

        /// INIA
        #expect(BluetoothUUID.inia.rawValue == "FDF9")
        #expect(BluetoothUUID.inia == .bit16(0xFDF9))
        #expect(BluetoothUUID.inia == .bit16(65017))
        #expect(BluetoothUUID.inia.name == "INIA")
        #expect(BluetoothUUID.inia != .bit32(65017))
        #expect(BluetoothUUID.inia != .bit32(0xFDF9))

        /// Tandem Diabetes Care
        #expect(BluetoothUUID.tandemDiabetesCare.rawValue == "FDFA")
        #expect(BluetoothUUID.tandemDiabetesCare == .bit16(0xFDFA))
        #expect(BluetoothUUID.tandemDiabetesCare == .bit16(65018))
        #expect(BluetoothUUID.tandemDiabetesCare.name == "Tandem Diabetes Care")
        #expect(BluetoothUUID.tandemDiabetesCare != .bit32(65018))
        #expect(BluetoothUUID.tandemDiabetesCare != .bit32(0xFDFA))

        /// Tandem Diabetes Care
        #expect(BluetoothUUID.tandemDiabetesCare2.rawValue == "FDFB")
        #expect(BluetoothUUID.tandemDiabetesCare2 == .bit16(0xFDFB))
        #expect(BluetoothUUID.tandemDiabetesCare2 == .bit16(65019))
        #expect(BluetoothUUID.tandemDiabetesCare2.name == "Tandem Diabetes Care")
        #expect(BluetoothUUID.tandemDiabetesCare2 != .bit32(65019))
        #expect(BluetoothUUID.tandemDiabetesCare2 != .bit32(0xFDFB))

        /// Optrel AG
        #expect(BluetoothUUID.optrel.rawValue == "FDFC")
        #expect(BluetoothUUID.optrel == .bit16(0xFDFC))
        #expect(BluetoothUUID.optrel == .bit16(65020))
        #expect(BluetoothUUID.optrel.name == "Optrel AG")
        #expect(BluetoothUUID.optrel != .bit32(65020))
        #expect(BluetoothUUID.optrel != .bit32(0xFDFC))

        /// RecursiveSoft Inc.
        #expect(BluetoothUUID.recursivesoft.rawValue == "FDFD")
        #expect(BluetoothUUID.recursivesoft == .bit16(0xFDFD))
        #expect(BluetoothUUID.recursivesoft == .bit16(65021))
        #expect(BluetoothUUID.recursivesoft.name == "RecursiveSoft Inc.")
        #expect(BluetoothUUID.recursivesoft != .bit32(65021))
        #expect(BluetoothUUID.recursivesoft != .bit32(0xFDFD))

        /// ADHERIUM(NZ) LIMITED
        #expect(BluetoothUUID.adheriumNzLimited.rawValue == "FDFE")
        #expect(BluetoothUUID.adheriumNzLimited == .bit16(0xFDFE))
        #expect(BluetoothUUID.adheriumNzLimited == .bit16(65022))
        #expect(BluetoothUUID.adheriumNzLimited.name == "ADHERIUM(NZ) LIMITED")
        #expect(BluetoothUUID.adheriumNzLimited != .bit32(65022))
        #expect(BluetoothUUID.adheriumNzLimited != .bit32(0xFDFE))

        /// OSRAM GmbH
        #expect(BluetoothUUID.osram.rawValue == "FDFF")
        #expect(BluetoothUUID.osram == .bit16(0xFDFF))
        #expect(BluetoothUUID.osram == .bit16(65023))
        #expect(BluetoothUUID.osram.name == "OSRAM GmbH")
        #expect(BluetoothUUID.osram != .bit32(65023))
        #expect(BluetoothUUID.osram != .bit32(0xFDFF))

        /// Amazon.com Services, Inc.
        #expect(BluetoothUUID.amazon.rawValue == "FE00")
        #expect(BluetoothUUID.amazon == .bit16(0xFE00))
        #expect(BluetoothUUID.amazon == .bit16(65024))
        #expect(BluetoothUUID.amazon.name == "Amazon.com Services, Inc.")
        #expect(BluetoothUUID.amazon != .bit32(65024))
        #expect(BluetoothUUID.amazon != .bit32(0xFE00))

        /// Duracell U.S. Operations Inc.
        #expect(BluetoothUUID.duracellUSOperations.rawValue == "FE01")
        #expect(BluetoothUUID.duracellUSOperations == .bit16(0xFE01))
        #expect(BluetoothUUID.duracellUSOperations == .bit16(65025))
        #expect(BluetoothUUID.duracellUSOperations.name == "Duracell U.S. Operations Inc.")
        #expect(BluetoothUUID.duracellUSOperations != .bit32(65025))
        #expect(BluetoothUUID.duracellUSOperations != .bit32(0xFE01))

        /// Robert Bosch GmbH
        #expect(BluetoothUUID.robertBosch2.rawValue == "FE02")
        #expect(BluetoothUUID.robertBosch2 == .bit16(0xFE02))
        #expect(BluetoothUUID.robertBosch2 == .bit16(65026))
        #expect(BluetoothUUID.robertBosch2.name == "Robert Bosch GmbH")
        #expect(BluetoothUUID.robertBosch2 != .bit32(65026))
        #expect(BluetoothUUID.robertBosch2 != .bit32(0xFE02))

        /// Amazon.com Services, Inc.
        #expect(BluetoothUUID.amazon2.rawValue == "FE03")
        #expect(BluetoothUUID.amazon2 == .bit16(0xFE03))
        #expect(BluetoothUUID.amazon2 == .bit16(65027))
        #expect(BluetoothUUID.amazon2.name == "Amazon.com Services, Inc.")
        #expect(BluetoothUUID.amazon2 != .bit32(65027))
        #expect(BluetoothUUID.amazon2 != .bit32(0xFE03))

        /// OpenPath Security Inc
        #expect(BluetoothUUID.openpathSecurity.rawValue == "FE04")
        #expect(BluetoothUUID.openpathSecurity == .bit16(0xFE04))
        #expect(BluetoothUUID.openpathSecurity == .bit16(65028))
        #expect(BluetoothUUID.openpathSecurity.name == "OpenPath Security Inc")
        #expect(BluetoothUUID.openpathSecurity != .bit32(65028))
        #expect(BluetoothUUID.openpathSecurity != .bit32(0xFE04))

        /// CORE Transport Technologies NZ Limited
        #expect(BluetoothUUID.coreTransportTechnologiesNz.rawValue == "FE05")
        #expect(BluetoothUUID.coreTransportTechnologiesNz == .bit16(0xFE05))
        #expect(BluetoothUUID.coreTransportTechnologiesNz == .bit16(65029))
        #expect(BluetoothUUID.coreTransportTechnologiesNz.name == "CORE Transport Technologies NZ Limited")
        #expect(BluetoothUUID.coreTransportTechnologiesNz != .bit32(65029))
        #expect(BluetoothUUID.coreTransportTechnologiesNz != .bit32(0xFE05))

        /// Qualcomm Technologies, Inc.
        #expect(BluetoothUUID.qualcommTechnologies.rawValue == "FE06")
        #expect(BluetoothUUID.qualcommTechnologies == .bit16(0xFE06))
        #expect(BluetoothUUID.qualcommTechnologies == .bit16(65030))
        #expect(BluetoothUUID.qualcommTechnologies.name == "Qualcomm Technologies, Inc.")
        #expect(BluetoothUUID.qualcommTechnologies != .bit32(65030))
        #expect(BluetoothUUID.qualcommTechnologies != .bit32(0xFE06))

        /// Microsoft
        #expect(BluetoothUUID.microsoft.rawValue == "FE08")
        #expect(BluetoothUUID.microsoft == .bit16(0xFE08))
        #expect(BluetoothUUID.microsoft == .bit16(65032))
        #expect(BluetoothUUID.microsoft.name == "Microsoft")
        #expect(BluetoothUUID.microsoft != .bit32(65032))
        #expect(BluetoothUUID.microsoft != .bit32(0xFE08))

        /// Pillsy, Inc.
        #expect(BluetoothUUID.pillsy.rawValue == "FE09")
        #expect(BluetoothUUID.pillsy == .bit16(0xFE09))
        #expect(BluetoothUUID.pillsy == .bit16(65033))
        #expect(BluetoothUUID.pillsy.name == "Pillsy, Inc.")
        #expect(BluetoothUUID.pillsy != .bit32(65033))
        #expect(BluetoothUUID.pillsy != .bit32(0xFE09))

        /// ruwido austria gmbh
        #expect(BluetoothUUID.ruwidoAustria.rawValue == "FE0A")
        #expect(BluetoothUUID.ruwidoAustria == .bit16(0xFE0A))
        #expect(BluetoothUUID.ruwidoAustria == .bit16(65034))
        #expect(BluetoothUUID.ruwidoAustria.name == "ruwido austria gmbh")
        #expect(BluetoothUUID.ruwidoAustria != .bit32(65034))
        #expect(BluetoothUUID.ruwidoAustria != .bit32(0xFE0A))

        /// ruwido austria gmbh
        #expect(BluetoothUUID.ruwidoAustria2.rawValue == "FE0B")
        #expect(BluetoothUUID.ruwidoAustria2 == .bit16(0xFE0B))
        #expect(BluetoothUUID.ruwidoAustria2 == .bit16(65035))
        #expect(BluetoothUUID.ruwidoAustria2.name == "ruwido austria gmbh")
        #expect(BluetoothUUID.ruwidoAustria2 != .bit32(65035))
        #expect(BluetoothUUID.ruwidoAustria2 != .bit32(0xFE0B))

        /// Procter & Gamble
        #expect(BluetoothUUID.procterGamble.rawValue == "FE0C")
        #expect(BluetoothUUID.procterGamble == .bit16(0xFE0C))
        #expect(BluetoothUUID.procterGamble == .bit16(65036))
        #expect(BluetoothUUID.procterGamble.name == "Procter & Gamble")
        #expect(BluetoothUUID.procterGamble != .bit32(65036))
        #expect(BluetoothUUID.procterGamble != .bit32(0xFE0C))

        /// Procter & Gamble
        #expect(BluetoothUUID.procterGamble2.rawValue == "FE0D")
        #expect(BluetoothUUID.procterGamble2 == .bit16(0xFE0D))
        #expect(BluetoothUUID.procterGamble2 == .bit16(65037))
        #expect(BluetoothUUID.procterGamble2.name == "Procter & Gamble")
        #expect(BluetoothUUID.procterGamble2 != .bit32(65037))
        #expect(BluetoothUUID.procterGamble2 != .bit32(0xFE0D))

        /// Setec Pty Ltd
        #expect(BluetoothUUID.setecPty.rawValue == "FE0E")
        #expect(BluetoothUUID.setecPty == .bit16(0xFE0E))
        #expect(BluetoothUUID.setecPty == .bit16(65038))
        #expect(BluetoothUUID.setecPty.name == "Setec Pty Ltd")
        #expect(BluetoothUUID.setecPty != .bit32(65038))
        #expect(BluetoothUUID.setecPty != .bit32(0xFE0E))

        /// Philips Lighting B.V.
        #expect(BluetoothUUID.philipsLighting.rawValue == "FE0F")
        #expect(BluetoothUUID.philipsLighting == .bit16(0xFE0F))
        #expect(BluetoothUUID.philipsLighting == .bit16(65039))
        #expect(BluetoothUUID.philipsLighting.name == "Philips Lighting B.V.")
        #expect(BluetoothUUID.philipsLighting != .bit32(65039))
        #expect(BluetoothUUID.philipsLighting != .bit32(0xFE0F))

        /// Lapis Semiconductor Co., Ltd.
        #expect(BluetoothUUID.lapisSemiconductor.rawValue == "FE10")
        #expect(BluetoothUUID.lapisSemiconductor == .bit16(0xFE10))
        #expect(BluetoothUUID.lapisSemiconductor == .bit16(65040))
        #expect(BluetoothUUID.lapisSemiconductor.name == "Lapis Semiconductor Co., Ltd.")
        #expect(BluetoothUUID.lapisSemiconductor != .bit32(65040))
        #expect(BluetoothUUID.lapisSemiconductor != .bit32(0xFE10))

        /// GMC-I Messtechnik GmbH
        #expect(BluetoothUUID.gmcIMesstechnik.rawValue == "FE11")
        #expect(BluetoothUUID.gmcIMesstechnik == .bit16(0xFE11))
        #expect(BluetoothUUID.gmcIMesstechnik == .bit16(65041))
        #expect(BluetoothUUID.gmcIMesstechnik.name == "GMC-I Messtechnik GmbH")
        #expect(BluetoothUUID.gmcIMesstechnik != .bit32(65041))
        #expect(BluetoothUUID.gmcIMesstechnik != .bit32(0xFE11))

        /// M-Way Solutions GmbH
        #expect(BluetoothUUID.mWaySolutions.rawValue == "FE12")
        #expect(BluetoothUUID.mWaySolutions == .bit16(0xFE12))
        #expect(BluetoothUUID.mWaySolutions == .bit16(65042))
        #expect(BluetoothUUID.mWaySolutions.name == "M-Way Solutions GmbH")
        #expect(BluetoothUUID.mWaySolutions != .bit32(65042))
        #expect(BluetoothUUID.mWaySolutions != .bit32(0xFE12))

        /// Apple Inc.
        #expect(BluetoothUUID.apple.rawValue == "FE13")
        #expect(BluetoothUUID.apple == .bit16(0xFE13))
        #expect(BluetoothUUID.apple == .bit16(65043))
        #expect(BluetoothUUID.apple.name == "Apple Inc.")
        #expect(BluetoothUUID.apple != .bit32(65043))
        #expect(BluetoothUUID.apple != .bit32(0xFE13))

        /// Flextronics International USA Inc.
        #expect(BluetoothUUID.flextronicsInternationalUsa.rawValue == "FE14")
        #expect(BluetoothUUID.flextronicsInternationalUsa == .bit16(0xFE14))
        #expect(BluetoothUUID.flextronicsInternationalUsa == .bit16(65044))
        #expect(BluetoothUUID.flextronicsInternationalUsa.name == "Flextronics International USA Inc.")
        #expect(BluetoothUUID.flextronicsInternationalUsa != .bit32(65044))
        #expect(BluetoothUUID.flextronicsInternationalUsa != .bit32(0xFE14))

        /// Amazon.com Services, Inc.
        #expect(BluetoothUUID.amazon3.rawValue == "FE15")
        #expect(BluetoothUUID.amazon3 == .bit16(0xFE15))
        #expect(BluetoothUUID.amazon3 == .bit16(65045))
        #expect(BluetoothUUID.amazon3.name == "Amazon.com Services, Inc.")
        #expect(BluetoothUUID.amazon3 != .bit32(65045))
        #expect(BluetoothUUID.amazon3 != .bit32(0xFE15))

        /// Footmarks, Inc.
        #expect(BluetoothUUID.footmarks.rawValue == "FE16")
        #expect(BluetoothUUID.footmarks == .bit16(0xFE16))
        #expect(BluetoothUUID.footmarks == .bit16(65046))
        #expect(BluetoothUUID.footmarks.name == "Footmarks, Inc.")
        #expect(BluetoothUUID.footmarks != .bit32(65046))
        #expect(BluetoothUUID.footmarks != .bit32(0xFE16))

        /// Telit Wireless Solutions GmbH
        #expect(BluetoothUUID.telitWirelessSolutions.rawValue == "FE17")
        #expect(BluetoothUUID.telitWirelessSolutions == .bit16(0xFE17))
        #expect(BluetoothUUID.telitWirelessSolutions == .bit16(65047))
        #expect(BluetoothUUID.telitWirelessSolutions.name == "Telit Wireless Solutions GmbH")
        #expect(BluetoothUUID.telitWirelessSolutions != .bit32(65047))
        #expect(BluetoothUUID.telitWirelessSolutions != .bit32(0xFE17))

        /// Runtime, Inc.
        #expect(BluetoothUUID.runtime.rawValue == "FE18")
        #expect(BluetoothUUID.runtime == .bit16(0xFE18))
        #expect(BluetoothUUID.runtime == .bit16(65048))
        #expect(BluetoothUUID.runtime.name == "Runtime, Inc.")
        #expect(BluetoothUUID.runtime != .bit32(65048))
        #expect(BluetoothUUID.runtime != .bit32(0xFE18))

        /// Google Inc.
        #expect(BluetoothUUID.google2.rawValue == "FE19")
        #expect(BluetoothUUID.google2 == .bit16(0xFE19))
        #expect(BluetoothUUID.google2 == .bit16(65049))
        #expect(BluetoothUUID.google2.name == "Google Inc.")
        #expect(BluetoothUUID.google2 != .bit32(65049))
        #expect(BluetoothUUID.google2 != .bit32(0xFE19))

        /// Tyto Life LLC
        #expect(BluetoothUUID.tytoLife.rawValue == "FE1A")
        #expect(BluetoothUUID.tytoLife == .bit16(0xFE1A))
        #expect(BluetoothUUID.tytoLife == .bit16(65050))
        #expect(BluetoothUUID.tytoLife.name == "Tyto Life LLC")
        #expect(BluetoothUUID.tytoLife != .bit32(65050))
        #expect(BluetoothUUID.tytoLife != .bit32(0xFE1A))

        /// Tyto Life LLC
        #expect(BluetoothUUID.tytoLife2.rawValue == "FE1B")
        #expect(BluetoothUUID.tytoLife2 == .bit16(0xFE1B))
        #expect(BluetoothUUID.tytoLife2 == .bit16(65051))
        #expect(BluetoothUUID.tytoLife2.name == "Tyto Life LLC")
        #expect(BluetoothUUID.tytoLife2 != .bit32(65051))
        #expect(BluetoothUUID.tytoLife2 != .bit32(0xFE1B))

        /// NetMedia, Inc.
        #expect(BluetoothUUID.netmedia.rawValue == "FE1C")
        #expect(BluetoothUUID.netmedia == .bit16(0xFE1C))
        #expect(BluetoothUUID.netmedia == .bit16(65052))
        #expect(BluetoothUUID.netmedia.name == "NetMedia, Inc.")
        #expect(BluetoothUUID.netmedia != .bit32(65052))
        #expect(BluetoothUUID.netmedia != .bit32(0xFE1C))

        /// Illuminati Instrument Corporation
        #expect(BluetoothUUID.illuminatiInstrument.rawValue == "FE1D")
        #expect(BluetoothUUID.illuminatiInstrument == .bit16(0xFE1D))
        #expect(BluetoothUUID.illuminatiInstrument == .bit16(65053))
        #expect(BluetoothUUID.illuminatiInstrument.name == "Illuminati Instrument Corporation")
        #expect(BluetoothUUID.illuminatiInstrument != .bit32(65053))
        #expect(BluetoothUUID.illuminatiInstrument != .bit32(0xFE1D))

        /// Smart Innovations Co., Ltd
        #expect(BluetoothUUID.smartInnovations.rawValue == "FE1E")
        #expect(BluetoothUUID.smartInnovations == .bit16(0xFE1E))
        #expect(BluetoothUUID.smartInnovations == .bit16(65054))
        #expect(BluetoothUUID.smartInnovations.name == "Smart Innovations Co., Ltd")
        #expect(BluetoothUUID.smartInnovations != .bit32(65054))
        #expect(BluetoothUUID.smartInnovations != .bit32(0xFE1E))

        /// Garmin International, Inc.
        #expect(BluetoothUUID.garminInternational.rawValue == "FE1F")
        #expect(BluetoothUUID.garminInternational == .bit16(0xFE1F))
        #expect(BluetoothUUID.garminInternational == .bit16(65055))
        #expect(BluetoothUUID.garminInternational.name == "Garmin International, Inc.")
        #expect(BluetoothUUID.garminInternational != .bit32(65055))
        #expect(BluetoothUUID.garminInternational != .bit32(0xFE1F))

        /// Emerson
        #expect(BluetoothUUID.emerson.rawValue == "FE20")
        #expect(BluetoothUUID.emerson == .bit16(0xFE20))
        #expect(BluetoothUUID.emerson == .bit16(65056))
        #expect(BluetoothUUID.emerson.name == "Emerson")
        #expect(BluetoothUUID.emerson != .bit32(65056))
        #expect(BluetoothUUID.emerson != .bit32(0xFE20))

        /// Bose Corporation
        #expect(BluetoothUUID.bose.rawValue == "FE21")
        #expect(BluetoothUUID.bose == .bit16(0xFE21))
        #expect(BluetoothUUID.bose == .bit16(65057))
        #expect(BluetoothUUID.bose.name == "Bose Corporation")
        #expect(BluetoothUUID.bose != .bit32(65057))
        #expect(BluetoothUUID.bose != .bit32(0xFE21))

        /// Zoll Medical Corporation
        #expect(BluetoothUUID.zollMedical.rawValue == "FE22")
        #expect(BluetoothUUID.zollMedical == .bit16(0xFE22))
        #expect(BluetoothUUID.zollMedical == .bit16(65058))
        #expect(BluetoothUUID.zollMedical.name == "Zoll Medical Corporation")
        #expect(BluetoothUUID.zollMedical != .bit32(65058))
        #expect(BluetoothUUID.zollMedical != .bit32(0xFE22))

        /// Zoll Medical Corporation
        #expect(BluetoothUUID.zollMedical2.rawValue == "FE23")
        #expect(BluetoothUUID.zollMedical2 == .bit16(0xFE23))
        #expect(BluetoothUUID.zollMedical2 == .bit16(65059))
        #expect(BluetoothUUID.zollMedical2.name == "Zoll Medical Corporation")
        #expect(BluetoothUUID.zollMedical2 != .bit32(65059))
        #expect(BluetoothUUID.zollMedical2 != .bit32(0xFE23))

        /// August Home Inc
        #expect(BluetoothUUID.augustHome.rawValue == "FE24")
        #expect(BluetoothUUID.augustHome == .bit16(0xFE24))
        #expect(BluetoothUUID.augustHome == .bit16(65060))
        #expect(BluetoothUUID.augustHome.name == "August Home Inc")
        #expect(BluetoothUUID.augustHome != .bit32(65060))
        #expect(BluetoothUUID.augustHome != .bit32(0xFE24))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple2.rawValue == "FE25")
        #expect(BluetoothUUID.apple2 == .bit16(0xFE25))
        #expect(BluetoothUUID.apple2 == .bit16(65061))
        #expect(BluetoothUUID.apple2.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple2 != .bit32(65061))
        #expect(BluetoothUUID.apple2 != .bit32(0xFE25))

        /// Google Inc.
        #expect(BluetoothUUID.google3.rawValue == "FE26")
        #expect(BluetoothUUID.google3 == .bit16(0xFE26))
        #expect(BluetoothUUID.google3 == .bit16(65062))
        #expect(BluetoothUUID.google3.name == "Google Inc.")
        #expect(BluetoothUUID.google3 != .bit32(65062))
        #expect(BluetoothUUID.google3 != .bit32(0xFE26))

        /// Google Inc.
        #expect(BluetoothUUID.google4.rawValue == "FE27")
        #expect(BluetoothUUID.google4 == .bit16(0xFE27))
        #expect(BluetoothUUID.google4 == .bit16(65063))
        #expect(BluetoothUUID.google4.name == "Google Inc.")
        #expect(BluetoothUUID.google4 != .bit32(65063))
        #expect(BluetoothUUID.google4 != .bit32(0xFE27))

        /// Ayla Networks
        #expect(BluetoothUUID.aylaNetworks.rawValue == "FE28")
        #expect(BluetoothUUID.aylaNetworks == .bit16(0xFE28))
        #expect(BluetoothUUID.aylaNetworks == .bit16(65064))
        #expect(BluetoothUUID.aylaNetworks.name == "Ayla Networks")
        #expect(BluetoothUUID.aylaNetworks != .bit32(65064))
        #expect(BluetoothUUID.aylaNetworks != .bit32(0xFE28))

        /// Gibson Innovations
        #expect(BluetoothUUID.gibsonInnovations.rawValue == "FE29")
        #expect(BluetoothUUID.gibsonInnovations == .bit16(0xFE29))
        #expect(BluetoothUUID.gibsonInnovations == .bit16(65065))
        #expect(BluetoothUUID.gibsonInnovations.name == "Gibson Innovations")
        #expect(BluetoothUUID.gibsonInnovations != .bit32(65065))
        #expect(BluetoothUUID.gibsonInnovations != .bit32(0xFE29))

        /// DaisyWorks, Inc.
        #expect(BluetoothUUID.daisyworks.rawValue == "FE2A")
        #expect(BluetoothUUID.daisyworks == .bit16(0xFE2A))
        #expect(BluetoothUUID.daisyworks == .bit16(65066))
        #expect(BluetoothUUID.daisyworks.name == "DaisyWorks, Inc.")
        #expect(BluetoothUUID.daisyworks != .bit32(65066))
        #expect(BluetoothUUID.daisyworks != .bit32(0xFE2A))

        /// ITT Industries
        #expect(BluetoothUUID.ittIndustries.rawValue == "FE2B")
        #expect(BluetoothUUID.ittIndustries == .bit16(0xFE2B))
        #expect(BluetoothUUID.ittIndustries == .bit16(65067))
        #expect(BluetoothUUID.ittIndustries.name == "ITT Industries")
        #expect(BluetoothUUID.ittIndustries != .bit32(65067))
        #expect(BluetoothUUID.ittIndustries != .bit32(0xFE2B))

        /// Google Inc.
        #expect(BluetoothUUID.google5.rawValue == "FE2C")
        #expect(BluetoothUUID.google5 == .bit16(0xFE2C))
        #expect(BluetoothUUID.google5 == .bit16(65068))
        #expect(BluetoothUUID.google5.name == "Google Inc.")
        #expect(BluetoothUUID.google5 != .bit32(65068))
        #expect(BluetoothUUID.google5 != .bit32(0xFE2C))

        /// SMART INNOVATION Co.,Ltd
        #expect(BluetoothUUID.smartInnovation.rawValue == "FE2D")
        #expect(BluetoothUUID.smartInnovation == .bit16(0xFE2D))
        #expect(BluetoothUUID.smartInnovation == .bit16(65069))
        #expect(BluetoothUUID.smartInnovation.name == "SMART INNOVATION Co.,Ltd")
        #expect(BluetoothUUID.smartInnovation != .bit32(65069))
        #expect(BluetoothUUID.smartInnovation != .bit32(0xFE2D))

        /// ERi,Inc.
        #expect(BluetoothUUID.eri.rawValue == "FE2E")
        #expect(BluetoothUUID.eri == .bit16(0xFE2E))
        #expect(BluetoothUUID.eri == .bit16(65070))
        #expect(BluetoothUUID.eri.name == "ERi,Inc.")
        #expect(BluetoothUUID.eri != .bit32(65070))
        #expect(BluetoothUUID.eri != .bit32(0xFE2E))

        /// CRESCO Wireless, Inc
        #expect(BluetoothUUID.crescoWireless.rawValue == "FE2F")
        #expect(BluetoothUUID.crescoWireless == .bit16(0xFE2F))
        #expect(BluetoothUUID.crescoWireless == .bit16(65071))
        #expect(BluetoothUUID.crescoWireless.name == "CRESCO Wireless, Inc")
        #expect(BluetoothUUID.crescoWireless != .bit32(65071))
        #expect(BluetoothUUID.crescoWireless != .bit32(0xFE2F))

        /// Volkswagen AG
        #expect(BluetoothUUID.volkswagen.rawValue == "FE30")
        #expect(BluetoothUUID.volkswagen == .bit16(0xFE30))
        #expect(BluetoothUUID.volkswagen == .bit16(65072))
        #expect(BluetoothUUID.volkswagen.name == "Volkswagen AG")
        #expect(BluetoothUUID.volkswagen != .bit32(65072))
        #expect(BluetoothUUID.volkswagen != .bit32(0xFE30))

        /// Volkswagen AG
        #expect(BluetoothUUID.volkswagen2.rawValue == "FE31")
        #expect(BluetoothUUID.volkswagen2 == .bit16(0xFE31))
        #expect(BluetoothUUID.volkswagen2 == .bit16(65073))
        #expect(BluetoothUUID.volkswagen2.name == "Volkswagen AG")
        #expect(BluetoothUUID.volkswagen2 != .bit32(65073))
        #expect(BluetoothUUID.volkswagen2 != .bit32(0xFE31))

        /// Pro-Mark, Inc.
        #expect(BluetoothUUID.proMark.rawValue == "FE32")
        #expect(BluetoothUUID.proMark == .bit16(0xFE32))
        #expect(BluetoothUUID.proMark == .bit16(65074))
        #expect(BluetoothUUID.proMark.name == "Pro-Mark, Inc.")
        #expect(BluetoothUUID.proMark != .bit32(65074))
        #expect(BluetoothUUID.proMark != .bit32(0xFE32))

        /// CHIPOLO d.o.o.
        #expect(BluetoothUUID.chipolo.rawValue == "FE33")
        #expect(BluetoothUUID.chipolo == .bit16(0xFE33))
        #expect(BluetoothUUID.chipolo == .bit16(65075))
        #expect(BluetoothUUID.chipolo.name == "CHIPOLO d.o.o.")
        #expect(BluetoothUUID.chipolo != .bit32(65075))
        #expect(BluetoothUUID.chipolo != .bit32(0xFE33))

        /// SmallLoop LLC
        #expect(BluetoothUUID.smallloop.rawValue == "FE34")
        #expect(BluetoothUUID.smallloop == .bit16(0xFE34))
        #expect(BluetoothUUID.smallloop == .bit16(65076))
        #expect(BluetoothUUID.smallloop.name == "SmallLoop LLC")
        #expect(BluetoothUUID.smallloop != .bit32(65076))
        #expect(BluetoothUUID.smallloop != .bit32(0xFE34))

        /// HUAWEI Technologies Co., Ltd
        #expect(BluetoothUUID.huaweiTechnologies2.rawValue == "FE35")
        #expect(BluetoothUUID.huaweiTechnologies2 == .bit16(0xFE35))
        #expect(BluetoothUUID.huaweiTechnologies2 == .bit16(65077))
        #expect(BluetoothUUID.huaweiTechnologies2.name == "HUAWEI Technologies Co., Ltd")
        #expect(BluetoothUUID.huaweiTechnologies2 != .bit32(65077))
        #expect(BluetoothUUID.huaweiTechnologies2 != .bit32(0xFE35))

        /// HUAWEI Technologies Co., Ltd
        #expect(BluetoothUUID.huaweiTechnologies3.rawValue == "FE36")
        #expect(BluetoothUUID.huaweiTechnologies3 == .bit16(0xFE36))
        #expect(BluetoothUUID.huaweiTechnologies3 == .bit16(65078))
        #expect(BluetoothUUID.huaweiTechnologies3.name == "HUAWEI Technologies Co., Ltd")
        #expect(BluetoothUUID.huaweiTechnologies3 != .bit32(65078))
        #expect(BluetoothUUID.huaweiTechnologies3 != .bit32(0xFE36))

        /// Spaceek LTD
        #expect(BluetoothUUID.spaceek.rawValue == "FE37")
        #expect(BluetoothUUID.spaceek == .bit16(0xFE37))
        #expect(BluetoothUUID.spaceek == .bit16(65079))
        #expect(BluetoothUUID.spaceek.name == "Spaceek LTD")
        #expect(BluetoothUUID.spaceek != .bit32(65079))
        #expect(BluetoothUUID.spaceek != .bit32(0xFE37))

        /// Spaceek LTD
        #expect(BluetoothUUID.spaceek2.rawValue == "FE38")
        #expect(BluetoothUUID.spaceek2 == .bit16(0xFE38))
        #expect(BluetoothUUID.spaceek2 == .bit16(65080))
        #expect(BluetoothUUID.spaceek2.name == "Spaceek LTD")
        #expect(BluetoothUUID.spaceek2 != .bit32(65080))
        #expect(BluetoothUUID.spaceek2 != .bit32(0xFE38))

        /// TTS Tooltechnic Systems AG & Co.
        #expect(BluetoothUUID.ttsTooltechnicSystems.rawValue == "FE39")
        #expect(BluetoothUUID.ttsTooltechnicSystems == .bit16(0xFE39))
        #expect(BluetoothUUID.ttsTooltechnicSystems == .bit16(65081))
        #expect(BluetoothUUID.ttsTooltechnicSystems.name == "TTS Tooltechnic Systems AG & Co.")
        #expect(BluetoothUUID.ttsTooltechnicSystems != .bit32(65081))
        #expect(BluetoothUUID.ttsTooltechnicSystems != .bit32(0xFE39))

        /// TTS Tooltechnic Systems AG & Co.
        #expect(BluetoothUUID.ttsTooltechnicSystems2.rawValue == "FE3A")
        #expect(BluetoothUUID.ttsTooltechnicSystems2 == .bit16(0xFE3A))
        #expect(BluetoothUUID.ttsTooltechnicSystems2 == .bit16(65082))
        #expect(BluetoothUUID.ttsTooltechnicSystems2.name == "TTS Tooltechnic Systems AG & Co.")
        #expect(BluetoothUUID.ttsTooltechnicSystems2 != .bit32(65082))
        #expect(BluetoothUUID.ttsTooltechnicSystems2 != .bit32(0xFE3A))

        /// Dolby Laboratories
        #expect(BluetoothUUID.dolbyLaboratories.rawValue == "FE3B")
        #expect(BluetoothUUID.dolbyLaboratories == .bit16(0xFE3B))
        #expect(BluetoothUUID.dolbyLaboratories == .bit16(65083))
        #expect(BluetoothUUID.dolbyLaboratories.name == "Dolby Laboratories")
        #expect(BluetoothUUID.dolbyLaboratories != .bit32(65083))
        #expect(BluetoothUUID.dolbyLaboratories != .bit32(0xFE3B))

        /// Alibaba
        #expect(BluetoothUUID.alibaba.rawValue == "FE3C")
        #expect(BluetoothUUID.alibaba == .bit16(0xFE3C))
        #expect(BluetoothUUID.alibaba == .bit16(65084))
        #expect(BluetoothUUID.alibaba.name == "Alibaba")
        #expect(BluetoothUUID.alibaba != .bit32(65084))
        #expect(BluetoothUUID.alibaba != .bit32(0xFE3C))

        /// BD Medical
        #expect(BluetoothUUID.bdMedical.rawValue == "FE3D")
        #expect(BluetoothUUID.bdMedical == .bit16(0xFE3D))
        #expect(BluetoothUUID.bdMedical == .bit16(65085))
        #expect(BluetoothUUID.bdMedical.name == "BD Medical")
        #expect(BluetoothUUID.bdMedical != .bit32(65085))
        #expect(BluetoothUUID.bdMedical != .bit32(0xFE3D))

        /// BD Medical
        #expect(BluetoothUUID.bdMedical2.rawValue == "FE3E")
        #expect(BluetoothUUID.bdMedical2 == .bit16(0xFE3E))
        #expect(BluetoothUUID.bdMedical2 == .bit16(65086))
        #expect(BluetoothUUID.bdMedical2.name == "BD Medical")
        #expect(BluetoothUUID.bdMedical2 != .bit32(65086))
        #expect(BluetoothUUID.bdMedical2 != .bit32(0xFE3E))

        /// Friday Labs Limited
        #expect(BluetoothUUID.fridayLabs.rawValue == "FE3F")
        #expect(BluetoothUUID.fridayLabs == .bit16(0xFE3F))
        #expect(BluetoothUUID.fridayLabs == .bit16(65087))
        #expect(BluetoothUUID.fridayLabs.name == "Friday Labs Limited")
        #expect(BluetoothUUID.fridayLabs != .bit32(65087))
        #expect(BluetoothUUID.fridayLabs != .bit32(0xFE3F))

        /// Inugo Systems Limited
        #expect(BluetoothUUID.inugoSystems.rawValue == "FE40")
        #expect(BluetoothUUID.inugoSystems == .bit16(0xFE40))
        #expect(BluetoothUUID.inugoSystems == .bit16(65088))
        #expect(BluetoothUUID.inugoSystems.name == "Inugo Systems Limited")
        #expect(BluetoothUUID.inugoSystems != .bit32(65088))
        #expect(BluetoothUUID.inugoSystems != .bit32(0xFE40))

        /// Inugo Systems Limited
        #expect(BluetoothUUID.inugoSystems2.rawValue == "FE41")
        #expect(BluetoothUUID.inugoSystems2 == .bit16(0xFE41))
        #expect(BluetoothUUID.inugoSystems2 == .bit16(65089))
        #expect(BluetoothUUID.inugoSystems2.name == "Inugo Systems Limited")
        #expect(BluetoothUUID.inugoSystems2 != .bit32(65089))
        #expect(BluetoothUUID.inugoSystems2 != .bit32(0xFE41))

        /// Nets A/S
        #expect(BluetoothUUID.nets.rawValue == "FE42")
        #expect(BluetoothUUID.nets == .bit16(0xFE42))
        #expect(BluetoothUUID.nets == .bit16(65090))
        #expect(BluetoothUUID.nets.name == "Nets A/S")
        #expect(BluetoothUUID.nets != .bit32(65090))
        #expect(BluetoothUUID.nets != .bit32(0xFE42))

        /// Andreas Stihl AG & Co. KG
        #expect(BluetoothUUID.andreasStihl.rawValue == "FE43")
        #expect(BluetoothUUID.andreasStihl == .bit16(0xFE43))
        #expect(BluetoothUUID.andreasStihl == .bit16(65091))
        #expect(BluetoothUUID.andreasStihl.name == "Andreas Stihl AG & Co. KG")
        #expect(BluetoothUUID.andreasStihl != .bit32(65091))
        #expect(BluetoothUUID.andreasStihl != .bit32(0xFE43))

        /// SK Telecom
        #expect(BluetoothUUID.skTelecom.rawValue == "FE44")
        #expect(BluetoothUUID.skTelecom == .bit16(0xFE44))
        #expect(BluetoothUUID.skTelecom == .bit16(65092))
        #expect(BluetoothUUID.skTelecom.name == "SK Telecom")
        #expect(BluetoothUUID.skTelecom != .bit32(65092))
        #expect(BluetoothUUID.skTelecom != .bit32(0xFE44))

        /// Snapchat Inc
        #expect(BluetoothUUID.snapchat.rawValue == "FE45")
        #expect(BluetoothUUID.snapchat == .bit16(0xFE45))
        #expect(BluetoothUUID.snapchat == .bit16(65093))
        #expect(BluetoothUUID.snapchat.name == "Snapchat Inc")
        #expect(BluetoothUUID.snapchat != .bit32(65093))
        #expect(BluetoothUUID.snapchat != .bit32(0xFE45))

        /// B&O Play A/S
        #expect(BluetoothUUID.bOPlay.rawValue == "FE46")
        #expect(BluetoothUUID.bOPlay == .bit16(0xFE46))
        #expect(BluetoothUUID.bOPlay == .bit16(65094))
        #expect(BluetoothUUID.bOPlay.name == "B&O Play A/S")
        #expect(BluetoothUUID.bOPlay != .bit32(65094))
        #expect(BluetoothUUID.bOPlay != .bit32(0xFE46))

        /// General Motors
        #expect(BluetoothUUID.generalMotors.rawValue == "FE47")
        #expect(BluetoothUUID.generalMotors == .bit16(0xFE47))
        #expect(BluetoothUUID.generalMotors == .bit16(65095))
        #expect(BluetoothUUID.generalMotors.name == "General Motors")
        #expect(BluetoothUUID.generalMotors != .bit32(65095))
        #expect(BluetoothUUID.generalMotors != .bit32(0xFE47))

        /// General Motors
        #expect(BluetoothUUID.generalMotors2.rawValue == "FE48")
        #expect(BluetoothUUID.generalMotors2 == .bit16(0xFE48))
        #expect(BluetoothUUID.generalMotors2 == .bit16(65096))
        #expect(BluetoothUUID.generalMotors2.name == "General Motors")
        #expect(BluetoothUUID.generalMotors2 != .bit32(65096))
        #expect(BluetoothUUID.generalMotors2 != .bit32(0xFE48))

        /// SenionLab AB
        #expect(BluetoothUUID.senionlab.rawValue == "FE49")
        #expect(BluetoothUUID.senionlab == .bit16(0xFE49))
        #expect(BluetoothUUID.senionlab == .bit16(65097))
        #expect(BluetoothUUID.senionlab.name == "SenionLab AB")
        #expect(BluetoothUUID.senionlab != .bit32(65097))
        #expect(BluetoothUUID.senionlab != .bit32(0xFE49))

        /// OMRON HEALTHCARE Co., Ltd.
        #expect(BluetoothUUID.omronHealthcare.rawValue == "FE4A")
        #expect(BluetoothUUID.omronHealthcare == .bit16(0xFE4A))
        #expect(BluetoothUUID.omronHealthcare == .bit16(65098))
        #expect(BluetoothUUID.omronHealthcare.name == "OMRON HEALTHCARE Co., Ltd.")
        #expect(BluetoothUUID.omronHealthcare != .bit32(65098))
        #expect(BluetoothUUID.omronHealthcare != .bit32(0xFE4A))

        /// Philips Lighting B.V.
        #expect(BluetoothUUID.philipsLighting2.rawValue == "FE4B")
        #expect(BluetoothUUID.philipsLighting2 == .bit16(0xFE4B))
        #expect(BluetoothUUID.philipsLighting2 == .bit16(65099))
        #expect(BluetoothUUID.philipsLighting2.name == "Philips Lighting B.V.")
        #expect(BluetoothUUID.philipsLighting2 != .bit32(65099))
        #expect(BluetoothUUID.philipsLighting2 != .bit32(0xFE4B))

        /// Volkswagen AG
        #expect(BluetoothUUID.volkswagen3.rawValue == "FE4C")
        #expect(BluetoothUUID.volkswagen3 == .bit16(0xFE4C))
        #expect(BluetoothUUID.volkswagen3 == .bit16(65100))
        #expect(BluetoothUUID.volkswagen3.name == "Volkswagen AG")
        #expect(BluetoothUUID.volkswagen3 != .bit32(65100))
        #expect(BluetoothUUID.volkswagen3 != .bit32(0xFE4C))

        /// Casambi Technologies Oy
        #expect(BluetoothUUID.casambiTechnologies.rawValue == "FE4D")
        #expect(BluetoothUUID.casambiTechnologies == .bit16(0xFE4D))
        #expect(BluetoothUUID.casambiTechnologies == .bit16(65101))
        #expect(BluetoothUUID.casambiTechnologies.name == "Casambi Technologies Oy")
        #expect(BluetoothUUID.casambiTechnologies != .bit32(65101))
        #expect(BluetoothUUID.casambiTechnologies != .bit32(0xFE4D))

        /// NTT docomo
        #expect(BluetoothUUID.nttDocomo.rawValue == "FE4E")
        #expect(BluetoothUUID.nttDocomo == .bit16(0xFE4E))
        #expect(BluetoothUUID.nttDocomo == .bit16(65102))
        #expect(BluetoothUUID.nttDocomo.name == "NTT docomo")
        #expect(BluetoothUUID.nttDocomo != .bit32(65102))
        #expect(BluetoothUUID.nttDocomo != .bit32(0xFE4E))

        /// Molekule, Inc.
        #expect(BluetoothUUID.molekule.rawValue == "FE4F")
        #expect(BluetoothUUID.molekule == .bit16(0xFE4F))
        #expect(BluetoothUUID.molekule == .bit16(65103))
        #expect(BluetoothUUID.molekule.name == "Molekule, Inc.")
        #expect(BluetoothUUID.molekule != .bit32(65103))
        #expect(BluetoothUUID.molekule != .bit32(0xFE4F))

        /// Google Inc.
        #expect(BluetoothUUID.google6.rawValue == "FE50")
        #expect(BluetoothUUID.google6 == .bit16(0xFE50))
        #expect(BluetoothUUID.google6 == .bit16(65104))
        #expect(BluetoothUUID.google6.name == "Google Inc.")
        #expect(BluetoothUUID.google6 != .bit32(65104))
        #expect(BluetoothUUID.google6 != .bit32(0xFE50))

        /// SRAM
        #expect(BluetoothUUID.sram.rawValue == "FE51")
        #expect(BluetoothUUID.sram == .bit16(0xFE51))
        #expect(BluetoothUUID.sram == .bit16(65105))
        #expect(BluetoothUUID.sram.name == "SRAM")
        #expect(BluetoothUUID.sram != .bit32(65105))
        #expect(BluetoothUUID.sram != .bit32(0xFE51))

        /// SetPoint Medical
        #expect(BluetoothUUID.setpointMedical.rawValue == "FE52")
        #expect(BluetoothUUID.setpointMedical == .bit16(0xFE52))
        #expect(BluetoothUUID.setpointMedical == .bit16(65106))
        #expect(BluetoothUUID.setpointMedical.name == "SetPoint Medical")
        #expect(BluetoothUUID.setpointMedical != .bit32(65106))
        #expect(BluetoothUUID.setpointMedical != .bit32(0xFE52))

        /// 3M
        #expect(BluetoothUUID.uuid3M.rawValue == "FE53")
        #expect(BluetoothUUID.uuid3M == .bit16(0xFE53))
        #expect(BluetoothUUID.uuid3M == .bit16(65107))
        #expect(BluetoothUUID.uuid3M.name == "3M")
        #expect(BluetoothUUID.uuid3M != .bit32(65107))
        #expect(BluetoothUUID.uuid3M != .bit32(0xFE53))

        /// Motiv, Inc.
        #expect(BluetoothUUID.motiv.rawValue == "FE54")
        #expect(BluetoothUUID.motiv == .bit16(0xFE54))
        #expect(BluetoothUUID.motiv == .bit16(65108))
        #expect(BluetoothUUID.motiv.name == "Motiv, Inc.")
        #expect(BluetoothUUID.motiv != .bit32(65108))
        #expect(BluetoothUUID.motiv != .bit32(0xFE54))

        /// Google Inc.
        #expect(BluetoothUUID.google7.rawValue == "FE55")
        #expect(BluetoothUUID.google7 == .bit16(0xFE55))
        #expect(BluetoothUUID.google7 == .bit16(65109))
        #expect(BluetoothUUID.google7.name == "Google Inc.")
        #expect(BluetoothUUID.google7 != .bit32(65109))
        #expect(BluetoothUUID.google7 != .bit32(0xFE55))

        /// Google Inc.
        #expect(BluetoothUUID.google8.rawValue == "FE56")
        #expect(BluetoothUUID.google8 == .bit16(0xFE56))
        #expect(BluetoothUUID.google8 == .bit16(65110))
        #expect(BluetoothUUID.google8.name == "Google Inc.")
        #expect(BluetoothUUID.google8 != .bit32(65110))
        #expect(BluetoothUUID.google8 != .bit32(0xFE56))

        /// Dotted Labs
        #expect(BluetoothUUID.dottedLabs.rawValue == "FE57")
        #expect(BluetoothUUID.dottedLabs == .bit16(0xFE57))
        #expect(BluetoothUUID.dottedLabs == .bit16(65111))
        #expect(BluetoothUUID.dottedLabs.name == "Dotted Labs")
        #expect(BluetoothUUID.dottedLabs != .bit32(65111))
        #expect(BluetoothUUID.dottedLabs != .bit32(0xFE57))

        /// Nordic Semiconductor ASA
        #expect(BluetoothUUID.nordicSemiconductor.rawValue == "FE58")
        #expect(BluetoothUUID.nordicSemiconductor == .bit16(0xFE58))
        #expect(BluetoothUUID.nordicSemiconductor == .bit16(65112))
        #expect(BluetoothUUID.nordicSemiconductor.name == "Nordic Semiconductor ASA")
        #expect(BluetoothUUID.nordicSemiconductor != .bit32(65112))
        #expect(BluetoothUUID.nordicSemiconductor != .bit32(0xFE58))

        /// Nordic Semiconductor ASA
        #expect(BluetoothUUID.nordicSemiconductor2.rawValue == "FE59")
        #expect(BluetoothUUID.nordicSemiconductor2 == .bit16(0xFE59))
        #expect(BluetoothUUID.nordicSemiconductor2 == .bit16(65113))
        #expect(BluetoothUUID.nordicSemiconductor2.name == "Nordic Semiconductor ASA")
        #expect(BluetoothUUID.nordicSemiconductor2 != .bit32(65113))
        #expect(BluetoothUUID.nordicSemiconductor2 != .bit32(0xFE59))

        /// Chronologics Corporation
        #expect(BluetoothUUID.chronologics.rawValue == "FE5A")
        #expect(BluetoothUUID.chronologics == .bit16(0xFE5A))
        #expect(BluetoothUUID.chronologics == .bit16(65114))
        #expect(BluetoothUUID.chronologics.name == "Chronologics Corporation")
        #expect(BluetoothUUID.chronologics != .bit32(65114))
        #expect(BluetoothUUID.chronologics != .bit32(0xFE5A))

        /// GT-tronics HK Ltd
        #expect(BluetoothUUID.gtTronicsHk.rawValue == "FE5B")
        #expect(BluetoothUUID.gtTronicsHk == .bit16(0xFE5B))
        #expect(BluetoothUUID.gtTronicsHk == .bit16(65115))
        #expect(BluetoothUUID.gtTronicsHk.name == "GT-tronics HK Ltd")
        #expect(BluetoothUUID.gtTronicsHk != .bit32(65115))
        #expect(BluetoothUUID.gtTronicsHk != .bit32(0xFE5B))

        /// million hunters GmbH
        #expect(BluetoothUUID.millionHunters.rawValue == "FE5C")
        #expect(BluetoothUUID.millionHunters == .bit16(0xFE5C))
        #expect(BluetoothUUID.millionHunters == .bit16(65116))
        #expect(BluetoothUUID.millionHunters.name == "million hunters GmbH")
        #expect(BluetoothUUID.millionHunters != .bit32(65116))
        #expect(BluetoothUUID.millionHunters != .bit32(0xFE5C))

        /// Grundfos A/S
        #expect(BluetoothUUID.grundfos.rawValue == "FE5D")
        #expect(BluetoothUUID.grundfos == .bit16(0xFE5D))
        #expect(BluetoothUUID.grundfos == .bit16(65117))
        #expect(BluetoothUUID.grundfos.name == "Grundfos A/S")
        #expect(BluetoothUUID.grundfos != .bit32(65117))
        #expect(BluetoothUUID.grundfos != .bit32(0xFE5D))

        /// Plastc Corporation
        #expect(BluetoothUUID.plastc.rawValue == "FE5E")
        #expect(BluetoothUUID.plastc == .bit16(0xFE5E))
        #expect(BluetoothUUID.plastc == .bit16(65118))
        #expect(BluetoothUUID.plastc.name == "Plastc Corporation")
        #expect(BluetoothUUID.plastc != .bit32(65118))
        #expect(BluetoothUUID.plastc != .bit32(0xFE5E))

        /// Eyefi, Inc.
        #expect(BluetoothUUID.eyefi.rawValue == "FE5F")
        #expect(BluetoothUUID.eyefi == .bit16(0xFE5F))
        #expect(BluetoothUUID.eyefi == .bit16(65119))
        #expect(BluetoothUUID.eyefi.name == "Eyefi, Inc.")
        #expect(BluetoothUUID.eyefi != .bit32(65119))
        #expect(BluetoothUUID.eyefi != .bit32(0xFE5F))

        /// Lierda Science & Technology Group Co., Ltd.
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup.rawValue == "FE60")
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup == .bit16(0xFE60))
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup == .bit16(65120))
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup.name == "Lierda Science & Technology Group Co., Ltd.")
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup != .bit32(65120))
        #expect(BluetoothUUID.lierdaScienceTechnologyGroup != .bit32(0xFE60))

        /// Logitech International SA
        #expect(BluetoothUUID.logitechInternational.rawValue == "FE61")
        #expect(BluetoothUUID.logitechInternational == .bit16(0xFE61))
        #expect(BluetoothUUID.logitechInternational == .bit16(65121))
        #expect(BluetoothUUID.logitechInternational.name == "Logitech International SA")
        #expect(BluetoothUUID.logitechInternational != .bit32(65121))
        #expect(BluetoothUUID.logitechInternational != .bit32(0xFE61))

        /// Indagem Tech LLC
        #expect(BluetoothUUID.indagemTech.rawValue == "FE62")
        #expect(BluetoothUUID.indagemTech == .bit16(0xFE62))
        #expect(BluetoothUUID.indagemTech == .bit16(65122))
        #expect(BluetoothUUID.indagemTech.name == "Indagem Tech LLC")
        #expect(BluetoothUUID.indagemTech != .bit32(65122))
        #expect(BluetoothUUID.indagemTech != .bit32(0xFE62))

        /// Connected Yard, Inc.
        #expect(BluetoothUUID.connectedYard.rawValue == "FE63")
        #expect(BluetoothUUID.connectedYard == .bit16(0xFE63))
        #expect(BluetoothUUID.connectedYard == .bit16(65123))
        #expect(BluetoothUUID.connectedYard.name == "Connected Yard, Inc.")
        #expect(BluetoothUUID.connectedYard != .bit32(65123))
        #expect(BluetoothUUID.connectedYard != .bit32(0xFE63))

        /// Siemens AG
        #expect(BluetoothUUID.siemens.rawValue == "FE64")
        #expect(BluetoothUUID.siemens == .bit16(0xFE64))
        #expect(BluetoothUUID.siemens == .bit16(65124))
        #expect(BluetoothUUID.siemens.name == "Siemens AG")
        #expect(BluetoothUUID.siemens != .bit32(65124))
        #expect(BluetoothUUID.siemens != .bit32(0xFE64))

        /// CHIPOLO d.o.o.
        #expect(BluetoothUUID.chipolo2.rawValue == "FE65")
        #expect(BluetoothUUID.chipolo2 == .bit16(0xFE65))
        #expect(BluetoothUUID.chipolo2 == .bit16(65125))
        #expect(BluetoothUUID.chipolo2.name == "CHIPOLO d.o.o.")
        #expect(BluetoothUUID.chipolo2 != .bit32(65125))
        #expect(BluetoothUUID.chipolo2 != .bit32(0xFE65))

        /// Intel Corporation
        #expect(BluetoothUUID.intel.rawValue == "FE66")
        #expect(BluetoothUUID.intel == .bit16(0xFE66))
        #expect(BluetoothUUID.intel == .bit16(65126))
        #expect(BluetoothUUID.intel.name == "Intel Corporation")
        #expect(BluetoothUUID.intel != .bit32(65126))
        #expect(BluetoothUUID.intel != .bit32(0xFE66))

        /// Lab Sensor Solutions
        #expect(BluetoothUUID.labSensorSolutions.rawValue == "FE67")
        #expect(BluetoothUUID.labSensorSolutions == .bit16(0xFE67))
        #expect(BluetoothUUID.labSensorSolutions == .bit16(65127))
        #expect(BluetoothUUID.labSensorSolutions.name == "Lab Sensor Solutions")
        #expect(BluetoothUUID.labSensorSolutions != .bit32(65127))
        #expect(BluetoothUUID.labSensorSolutions != .bit32(0xFE67))

        /// Qualcomm Life Inc
        #expect(BluetoothUUID.qualcommLife.rawValue == "FE68")
        #expect(BluetoothUUID.qualcommLife == .bit16(0xFE68))
        #expect(BluetoothUUID.qualcommLife == .bit16(65128))
        #expect(BluetoothUUID.qualcommLife.name == "Qualcomm Life Inc")
        #expect(BluetoothUUID.qualcommLife != .bit32(65128))
        #expect(BluetoothUUID.qualcommLife != .bit32(0xFE68))

        /// Qualcomm Life Inc
        #expect(BluetoothUUID.qualcommLife2.rawValue == "FE69")
        #expect(BluetoothUUID.qualcommLife2 == .bit16(0xFE69))
        #expect(BluetoothUUID.qualcommLife2 == .bit16(65129))
        #expect(BluetoothUUID.qualcommLife2.name == "Qualcomm Life Inc")
        #expect(BluetoothUUID.qualcommLife2 != .bit32(65129))
        #expect(BluetoothUUID.qualcommLife2 != .bit32(0xFE69))

        /// Kontakt Micro-Location Sp. z o.o.
        #expect(BluetoothUUID.kontaktMicroLocation.rawValue == "FE6A")
        #expect(BluetoothUUID.kontaktMicroLocation == .bit16(0xFE6A))
        #expect(BluetoothUUID.kontaktMicroLocation == .bit16(65130))
        #expect(BluetoothUUID.kontaktMicroLocation.name == "Kontakt Micro-Location Sp. z o.o.")
        #expect(BluetoothUUID.kontaktMicroLocation != .bit32(65130))
        #expect(BluetoothUUID.kontaktMicroLocation != .bit32(0xFE6A))

        /// TASER International, Inc.
        #expect(BluetoothUUID.taserInternational.rawValue == "FE6B")
        #expect(BluetoothUUID.taserInternational == .bit16(0xFE6B))
        #expect(BluetoothUUID.taserInternational == .bit16(65131))
        #expect(BluetoothUUID.taserInternational.name == "TASER International, Inc.")
        #expect(BluetoothUUID.taserInternational != .bit32(65131))
        #expect(BluetoothUUID.taserInternational != .bit32(0xFE6B))

        /// TASER International, Inc.
        #expect(BluetoothUUID.taserInternational2.rawValue == "FE6C")
        #expect(BluetoothUUID.taserInternational2 == .bit16(0xFE6C))
        #expect(BluetoothUUID.taserInternational2 == .bit16(65132))
        #expect(BluetoothUUID.taserInternational2.name == "TASER International, Inc.")
        #expect(BluetoothUUID.taserInternational2 != .bit32(65132))
        #expect(BluetoothUUID.taserInternational2 != .bit32(0xFE6C))

        /// The University of Tokyo
        #expect(BluetoothUUID.universityOfTokyo.rawValue == "FE6D")
        #expect(BluetoothUUID.universityOfTokyo == .bit16(0xFE6D))
        #expect(BluetoothUUID.universityOfTokyo == .bit16(65133))
        #expect(BluetoothUUID.universityOfTokyo.name == "The University of Tokyo")
        #expect(BluetoothUUID.universityOfTokyo != .bit32(65133))
        #expect(BluetoothUUID.universityOfTokyo != .bit32(0xFE6D))

        /// The University of Tokyo
        #expect(BluetoothUUID.universityOfTokyo2.rawValue == "FE6E")
        #expect(BluetoothUUID.universityOfTokyo2 == .bit16(0xFE6E))
        #expect(BluetoothUUID.universityOfTokyo2 == .bit16(65134))
        #expect(BluetoothUUID.universityOfTokyo2.name == "The University of Tokyo")
        #expect(BluetoothUUID.universityOfTokyo2 != .bit32(65134))
        #expect(BluetoothUUID.universityOfTokyo2 != .bit32(0xFE6E))

        /// LINE Corporation
        #expect(BluetoothUUID.line.rawValue == "FE6F")
        #expect(BluetoothUUID.line == .bit16(0xFE6F))
        #expect(BluetoothUUID.line == .bit16(65135))
        #expect(BluetoothUUID.line.name == "LINE Corporation")
        #expect(BluetoothUUID.line != .bit32(65135))
        #expect(BluetoothUUID.line != .bit32(0xFE6F))

        /// Beijing Jingdong Century Trading Co., Ltd.
        #expect(BluetoothUUID.beijingJingdongCenturyTrading.rawValue == "FE70")
        #expect(BluetoothUUID.beijingJingdongCenturyTrading == .bit16(0xFE70))
        #expect(BluetoothUUID.beijingJingdongCenturyTrading == .bit16(65136))
        #expect(BluetoothUUID.beijingJingdongCenturyTrading.name == "Beijing Jingdong Century Trading Co., Ltd.")
        #expect(BluetoothUUID.beijingJingdongCenturyTrading != .bit32(65136))
        #expect(BluetoothUUID.beijingJingdongCenturyTrading != .bit32(0xFE70))

        /// Plume Design Inc
        #expect(BluetoothUUID.plumeDesign.rawValue == "FE71")
        #expect(BluetoothUUID.plumeDesign == .bit16(0xFE71))
        #expect(BluetoothUUID.plumeDesign == .bit16(65137))
        #expect(BluetoothUUID.plumeDesign.name == "Plume Design Inc")
        #expect(BluetoothUUID.plumeDesign != .bit32(65137))
        #expect(BluetoothUUID.plumeDesign != .bit32(0xFE71))

        /// St. Jude Medical, Inc.
        #expect(BluetoothUUID.stJudeMedical.rawValue == "FE72")
        #expect(BluetoothUUID.stJudeMedical == .bit16(0xFE72))
        #expect(BluetoothUUID.stJudeMedical == .bit16(65138))
        #expect(BluetoothUUID.stJudeMedical.name == "St. Jude Medical, Inc.")
        #expect(BluetoothUUID.stJudeMedical != .bit32(65138))
        #expect(BluetoothUUID.stJudeMedical != .bit32(0xFE72))

        /// St. Jude Medical, Inc.
        #expect(BluetoothUUID.stJudeMedical2.rawValue == "FE73")
        #expect(BluetoothUUID.stJudeMedical2 == .bit16(0xFE73))
        #expect(BluetoothUUID.stJudeMedical2 == .bit16(65139))
        #expect(BluetoothUUID.stJudeMedical2.name == "St. Jude Medical, Inc.")
        #expect(BluetoothUUID.stJudeMedical2 != .bit32(65139))
        #expect(BluetoothUUID.stJudeMedical2 != .bit32(0xFE73))

        /// unwire
        #expect(BluetoothUUID.unwire.rawValue == "FE74")
        #expect(BluetoothUUID.unwire == .bit16(0xFE74))
        #expect(BluetoothUUID.unwire == .bit16(65140))
        #expect(BluetoothUUID.unwire.name == "unwire")
        #expect(BluetoothUUID.unwire != .bit32(65140))
        #expect(BluetoothUUID.unwire != .bit32(0xFE74))

        /// TangoMe
        #expect(BluetoothUUID.tangome.rawValue == "FE75")
        #expect(BluetoothUUID.tangome == .bit16(0xFE75))
        #expect(BluetoothUUID.tangome == .bit16(65141))
        #expect(BluetoothUUID.tangome.name == "TangoMe")
        #expect(BluetoothUUID.tangome != .bit32(65141))
        #expect(BluetoothUUID.tangome != .bit32(0xFE75))

        /// TangoMe
        #expect(BluetoothUUID.tangome2.rawValue == "FE76")
        #expect(BluetoothUUID.tangome2 == .bit16(0xFE76))
        #expect(BluetoothUUID.tangome2 == .bit16(65142))
        #expect(BluetoothUUID.tangome2.name == "TangoMe")
        #expect(BluetoothUUID.tangome2 != .bit32(65142))
        #expect(BluetoothUUID.tangome2 != .bit32(0xFE76))

        /// Hewlett-Packard Company
        #expect(BluetoothUUID.hewlettPackardCompany.rawValue == "FE77")
        #expect(BluetoothUUID.hewlettPackardCompany == .bit16(0xFE77))
        #expect(BluetoothUUID.hewlettPackardCompany == .bit16(65143))
        #expect(BluetoothUUID.hewlettPackardCompany.name == "Hewlett-Packard Company")
        #expect(BluetoothUUID.hewlettPackardCompany != .bit32(65143))
        #expect(BluetoothUUID.hewlettPackardCompany != .bit32(0xFE77))

        /// Hewlett-Packard Company
        #expect(BluetoothUUID.hewlettPackardCompany2.rawValue == "FE78")
        #expect(BluetoothUUID.hewlettPackardCompany2 == .bit16(0xFE78))
        #expect(BluetoothUUID.hewlettPackardCompany2 == .bit16(65144))
        #expect(BluetoothUUID.hewlettPackardCompany2.name == "Hewlett-Packard Company")
        #expect(BluetoothUUID.hewlettPackardCompany2 != .bit32(65144))
        #expect(BluetoothUUID.hewlettPackardCompany2 != .bit32(0xFE78))

        /// Zebra Technologies
        #expect(BluetoothUUID.zebraTechnologies.rawValue == "FE79")
        #expect(BluetoothUUID.zebraTechnologies == .bit16(0xFE79))
        #expect(BluetoothUUID.zebraTechnologies == .bit16(65145))
        #expect(BluetoothUUID.zebraTechnologies.name == "Zebra Technologies")
        #expect(BluetoothUUID.zebraTechnologies != .bit32(65145))
        #expect(BluetoothUUID.zebraTechnologies != .bit32(0xFE79))

        /// Bragi GmbH
        #expect(BluetoothUUID.bragi.rawValue == "FE7A")
        #expect(BluetoothUUID.bragi == .bit16(0xFE7A))
        #expect(BluetoothUUID.bragi == .bit16(65146))
        #expect(BluetoothUUID.bragi.name == "Bragi GmbH")
        #expect(BluetoothUUID.bragi != .bit32(65146))
        #expect(BluetoothUUID.bragi != .bit32(0xFE7A))

        /// Orion Labs, Inc.
        #expect(BluetoothUUID.orionLabs.rawValue == "FE7B")
        #expect(BluetoothUUID.orionLabs == .bit16(0xFE7B))
        #expect(BluetoothUUID.orionLabs == .bit16(65147))
        #expect(BluetoothUUID.orionLabs.name == "Orion Labs, Inc.")
        #expect(BluetoothUUID.orionLabs != .bit32(65147))
        #expect(BluetoothUUID.orionLabs != .bit32(0xFE7B))

        /// Stollmann E+V GmbH
        #expect(BluetoothUUID.stollmannEV.rawValue == "FE7C")
        #expect(BluetoothUUID.stollmannEV == .bit16(0xFE7C))
        #expect(BluetoothUUID.stollmannEV == .bit16(65148))
        #expect(BluetoothUUID.stollmannEV.name == "Stollmann E+V GmbH")
        #expect(BluetoothUUID.stollmannEV != .bit32(65148))
        #expect(BluetoothUUID.stollmannEV != .bit32(0xFE7C))

        /// Aterica Health Inc.
        #expect(BluetoothUUID.atericaHealth.rawValue == "FE7D")
        #expect(BluetoothUUID.atericaHealth == .bit16(0xFE7D))
        #expect(BluetoothUUID.atericaHealth == .bit16(65149))
        #expect(BluetoothUUID.atericaHealth.name == "Aterica Health Inc.")
        #expect(BluetoothUUID.atericaHealth != .bit32(65149))
        #expect(BluetoothUUID.atericaHealth != .bit32(0xFE7D))

        /// Awear Solutions Ltd
        #expect(BluetoothUUID.awearSolutions.rawValue == "FE7E")
        #expect(BluetoothUUID.awearSolutions == .bit16(0xFE7E))
        #expect(BluetoothUUID.awearSolutions == .bit16(65150))
        #expect(BluetoothUUID.awearSolutions.name == "Awear Solutions Ltd")
        #expect(BluetoothUUID.awearSolutions != .bit32(65150))
        #expect(BluetoothUUID.awearSolutions != .bit32(0xFE7E))

        /// Doppler Lab
        #expect(BluetoothUUID.dopplerLab.rawValue == "FE7F")
        #expect(BluetoothUUID.dopplerLab == .bit16(0xFE7F))
        #expect(BluetoothUUID.dopplerLab == .bit16(65151))
        #expect(BluetoothUUID.dopplerLab.name == "Doppler Lab")
        #expect(BluetoothUUID.dopplerLab != .bit32(65151))
        #expect(BluetoothUUID.dopplerLab != .bit32(0xFE7F))

        /// Doppler Lab
        #expect(BluetoothUUID.dopplerLab2.rawValue == "FE80")
        #expect(BluetoothUUID.dopplerLab2 == .bit16(0xFE80))
        #expect(BluetoothUUID.dopplerLab2 == .bit16(65152))
        #expect(BluetoothUUID.dopplerLab2.name == "Doppler Lab")
        #expect(BluetoothUUID.dopplerLab2 != .bit32(65152))
        #expect(BluetoothUUID.dopplerLab2 != .bit32(0xFE80))

        /// Medtronic Inc.
        #expect(BluetoothUUID.medtronic.rawValue == "FE81")
        #expect(BluetoothUUID.medtronic == .bit16(0xFE81))
        #expect(BluetoothUUID.medtronic == .bit16(65153))
        #expect(BluetoothUUID.medtronic.name == "Medtronic Inc.")
        #expect(BluetoothUUID.medtronic != .bit32(65153))
        #expect(BluetoothUUID.medtronic != .bit32(0xFE81))

        /// Medtronic Inc.
        #expect(BluetoothUUID.medtronic2.rawValue == "FE82")
        #expect(BluetoothUUID.medtronic2 == .bit16(0xFE82))
        #expect(BluetoothUUID.medtronic2 == .bit16(65154))
        #expect(BluetoothUUID.medtronic2.name == "Medtronic Inc.")
        #expect(BluetoothUUID.medtronic2 != .bit32(65154))
        #expect(BluetoothUUID.medtronic2 != .bit32(0xFE82))

        /// Blue Bite
        #expect(BluetoothUUID.blueBite.rawValue == "FE83")
        #expect(BluetoothUUID.blueBite == .bit16(0xFE83))
        #expect(BluetoothUUID.blueBite == .bit16(65155))
        #expect(BluetoothUUID.blueBite.name == "Blue Bite")
        #expect(BluetoothUUID.blueBite != .bit32(65155))
        #expect(BluetoothUUID.blueBite != .bit32(0xFE83))

        /// RF Digital Corp
        #expect(BluetoothUUID.rfDigital.rawValue == "FE84")
        #expect(BluetoothUUID.rfDigital == .bit16(0xFE84))
        #expect(BluetoothUUID.rfDigital == .bit16(65156))
        #expect(BluetoothUUID.rfDigital.name == "RF Digital Corp")
        #expect(BluetoothUUID.rfDigital != .bit32(65156))
        #expect(BluetoothUUID.rfDigital != .bit32(0xFE84))

        /// RF Digital Corp
        #expect(BluetoothUUID.rfDigital2.rawValue == "FE85")
        #expect(BluetoothUUID.rfDigital2 == .bit16(0xFE85))
        #expect(BluetoothUUID.rfDigital2 == .bit16(65157))
        #expect(BluetoothUUID.rfDigital2.name == "RF Digital Corp")
        #expect(BluetoothUUID.rfDigital2 != .bit32(65157))
        #expect(BluetoothUUID.rfDigital2 != .bit32(0xFE85))

        /// HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司.rawValue == "FE86")
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司 == .bit16(0xFE86))
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司 == .bit16(65158))
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司.name == "HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )")
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司 != .bit32(65158))
        #expect(BluetoothUUID.huaweiTechnologies华为技术有限公司 != .bit32(0xFE86))

        /// Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.rawValue == "FE87")
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司 == .bit16(0xFE87))
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司 == .bit16(65159))
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.name == "Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )")
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司 != .bit32(65159))
        #expect(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司 != .bit32(0xFE87))

        /// SALTO SYSTEMS S.L.
        #expect(BluetoothUUID.saltoSystems.rawValue == "FE88")
        #expect(BluetoothUUID.saltoSystems == .bit16(0xFE88))
        #expect(BluetoothUUID.saltoSystems == .bit16(65160))
        #expect(BluetoothUUID.saltoSystems.name == "SALTO SYSTEMS S.L.")
        #expect(BluetoothUUID.saltoSystems != .bit32(65160))
        #expect(BluetoothUUID.saltoSystems != .bit32(0xFE88))

        /// B&O Play A/S
        #expect(BluetoothUUID.bOPlay2.rawValue == "FE89")
        #expect(BluetoothUUID.bOPlay2 == .bit16(0xFE89))
        #expect(BluetoothUUID.bOPlay2 == .bit16(65161))
        #expect(BluetoothUUID.bOPlay2.name == "B&O Play A/S")
        #expect(BluetoothUUID.bOPlay2 != .bit32(65161))
        #expect(BluetoothUUID.bOPlay2 != .bit32(0xFE89))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple3.rawValue == "FE8A")
        #expect(BluetoothUUID.apple3 == .bit16(0xFE8A))
        #expect(BluetoothUUID.apple3 == .bit16(65162))
        #expect(BluetoothUUID.apple3.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple3 != .bit32(65162))
        #expect(BluetoothUUID.apple3 != .bit32(0xFE8A))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple4.rawValue == "FE8B")
        #expect(BluetoothUUID.apple4 == .bit16(0xFE8B))
        #expect(BluetoothUUID.apple4 == .bit16(65163))
        #expect(BluetoothUUID.apple4.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple4 != .bit32(65163))
        #expect(BluetoothUUID.apple4 != .bit32(0xFE8B))

        /// TRON Forum
        #expect(BluetoothUUID.tronForum.rawValue == "FE8C")
        #expect(BluetoothUUID.tronForum == .bit16(0xFE8C))
        #expect(BluetoothUUID.tronForum == .bit16(65164))
        #expect(BluetoothUUID.tronForum.name == "TRON Forum")
        #expect(BluetoothUUID.tronForum != .bit32(65164))
        #expect(BluetoothUUID.tronForum != .bit32(0xFE8C))

        /// Interaxon Inc.
        #expect(BluetoothUUID.interaxon.rawValue == "FE8D")
        #expect(BluetoothUUID.interaxon == .bit16(0xFE8D))
        #expect(BluetoothUUID.interaxon == .bit16(65165))
        #expect(BluetoothUUID.interaxon.name == "Interaxon Inc.")
        #expect(BluetoothUUID.interaxon != .bit32(65165))
        #expect(BluetoothUUID.interaxon != .bit32(0xFE8D))

        /// ARM Ltd
        #expect(BluetoothUUID.arm.rawValue == "FE8E")
        #expect(BluetoothUUID.arm == .bit16(0xFE8E))
        #expect(BluetoothUUID.arm == .bit16(65166))
        #expect(BluetoothUUID.arm.name == "ARM Ltd")
        #expect(BluetoothUUID.arm != .bit32(65166))
        #expect(BluetoothUUID.arm != .bit32(0xFE8E))

        /// CSR
        #expect(BluetoothUUID.csr.rawValue == "FE8F")
        #expect(BluetoothUUID.csr == .bit16(0xFE8F))
        #expect(BluetoothUUID.csr == .bit16(65167))
        #expect(BluetoothUUID.csr.name == "CSR")
        #expect(BluetoothUUID.csr != .bit32(65167))
        #expect(BluetoothUUID.csr != .bit32(0xFE8F))

        /// JUMA
        #expect(BluetoothUUID.juma.rawValue == "FE90")
        #expect(BluetoothUUID.juma == .bit16(0xFE90))
        #expect(BluetoothUUID.juma == .bit16(65168))
        #expect(BluetoothUUID.juma.name == "JUMA")
        #expect(BluetoothUUID.juma != .bit32(65168))
        #expect(BluetoothUUID.juma != .bit32(0xFE90))

        /// Shanghai Imilab Technology Co.,Ltd
        #expect(BluetoothUUID.shanghaiImilabTechnology.rawValue == "FE91")
        #expect(BluetoothUUID.shanghaiImilabTechnology == .bit16(0xFE91))
        #expect(BluetoothUUID.shanghaiImilabTechnology == .bit16(65169))
        #expect(BluetoothUUID.shanghaiImilabTechnology.name == "Shanghai Imilab Technology Co.,Ltd")
        #expect(BluetoothUUID.shanghaiImilabTechnology != .bit32(65169))
        #expect(BluetoothUUID.shanghaiImilabTechnology != .bit32(0xFE91))

        /// Jarden Safety & Security
        #expect(BluetoothUUID.jardenSafetySecurity.rawValue == "FE92")
        #expect(BluetoothUUID.jardenSafetySecurity == .bit16(0xFE92))
        #expect(BluetoothUUID.jardenSafetySecurity == .bit16(65170))
        #expect(BluetoothUUID.jardenSafetySecurity.name == "Jarden Safety & Security")
        #expect(BluetoothUUID.jardenSafetySecurity != .bit32(65170))
        #expect(BluetoothUUID.jardenSafetySecurity != .bit32(0xFE92))

        /// OttoQ Inc.
        #expect(BluetoothUUID.ottoq.rawValue == "FE93")
        #expect(BluetoothUUID.ottoq == .bit16(0xFE93))
        #expect(BluetoothUUID.ottoq == .bit16(65171))
        #expect(BluetoothUUID.ottoq.name == "OttoQ Inc.")
        #expect(BluetoothUUID.ottoq != .bit32(65171))
        #expect(BluetoothUUID.ottoq != .bit32(0xFE93))

        /// OttoQ Inc.
        #expect(BluetoothUUID.ottoq2.rawValue == "FE94")
        #expect(BluetoothUUID.ottoq2 == .bit16(0xFE94))
        #expect(BluetoothUUID.ottoq2 == .bit16(65172))
        #expect(BluetoothUUID.ottoq2.name == "OttoQ Inc.")
        #expect(BluetoothUUID.ottoq2 != .bit32(65172))
        #expect(BluetoothUUID.ottoq2 != .bit32(0xFE94))

        /// Xiaomi Inc.
        #expect(BluetoothUUID.xiaomi.rawValue == "FE95")
        #expect(BluetoothUUID.xiaomi == .bit16(0xFE95))
        #expect(BluetoothUUID.xiaomi == .bit16(65173))
        #expect(BluetoothUUID.xiaomi.name == "Xiaomi Inc.")
        #expect(BluetoothUUID.xiaomi != .bit32(65173))
        #expect(BluetoothUUID.xiaomi != .bit32(0xFE95))

        /// Tesla Motor Inc.
        #expect(BluetoothUUID.teslaMotor.rawValue == "FE96")
        #expect(BluetoothUUID.teslaMotor == .bit16(0xFE96))
        #expect(BluetoothUUID.teslaMotor == .bit16(65174))
        #expect(BluetoothUUID.teslaMotor.name == "Tesla Motor Inc.")
        #expect(BluetoothUUID.teslaMotor != .bit32(65174))
        #expect(BluetoothUUID.teslaMotor != .bit32(0xFE96))

        /// Tesla Motor Inc.
        #expect(BluetoothUUID.teslaMotor2.rawValue == "FE97")
        #expect(BluetoothUUID.teslaMotor2 == .bit16(0xFE97))
        #expect(BluetoothUUID.teslaMotor2 == .bit16(65175))
        #expect(BluetoothUUID.teslaMotor2.name == "Tesla Motor Inc.")
        #expect(BluetoothUUID.teslaMotor2 != .bit32(65175))
        #expect(BluetoothUUID.teslaMotor2 != .bit32(0xFE97))

        /// Currant, Inc.
        #expect(BluetoothUUID.currant.rawValue == "FE98")
        #expect(BluetoothUUID.currant == .bit16(0xFE98))
        #expect(BluetoothUUID.currant == .bit16(65176))
        #expect(BluetoothUUID.currant.name == "Currant, Inc.")
        #expect(BluetoothUUID.currant != .bit32(65176))
        #expect(BluetoothUUID.currant != .bit32(0xFE98))

        /// Currant, Inc.
        #expect(BluetoothUUID.currant2.rawValue == "FE99")
        #expect(BluetoothUUID.currant2 == .bit16(0xFE99))
        #expect(BluetoothUUID.currant2 == .bit16(65177))
        #expect(BluetoothUUID.currant2.name == "Currant, Inc.")
        #expect(BluetoothUUID.currant2 != .bit32(65177))
        #expect(BluetoothUUID.currant2 != .bit32(0xFE99))

        /// Estimote
        #expect(BluetoothUUID.estimote.rawValue == "FE9A")
        #expect(BluetoothUUID.estimote == .bit16(0xFE9A))
        #expect(BluetoothUUID.estimote == .bit16(65178))
        #expect(BluetoothUUID.estimote.name == "Estimote")
        #expect(BluetoothUUID.estimote != .bit32(65178))
        #expect(BluetoothUUID.estimote != .bit32(0xFE9A))

        /// Samsara Networks, Inc
        #expect(BluetoothUUID.samsaraNetworks.rawValue == "FE9B")
        #expect(BluetoothUUID.samsaraNetworks == .bit16(0xFE9B))
        #expect(BluetoothUUID.samsaraNetworks == .bit16(65179))
        #expect(BluetoothUUID.samsaraNetworks.name == "Samsara Networks, Inc")
        #expect(BluetoothUUID.samsaraNetworks != .bit32(65179))
        #expect(BluetoothUUID.samsaraNetworks != .bit32(0xFE9B))

        /// GSI Laboratories, Inc.
        #expect(BluetoothUUID.gsiLaboratories.rawValue == "FE9C")
        #expect(BluetoothUUID.gsiLaboratories == .bit16(0xFE9C))
        #expect(BluetoothUUID.gsiLaboratories == .bit16(65180))
        #expect(BluetoothUUID.gsiLaboratories.name == "GSI Laboratories, Inc.")
        #expect(BluetoothUUID.gsiLaboratories != .bit32(65180))
        #expect(BluetoothUUID.gsiLaboratories != .bit32(0xFE9C))

        /// Mobiquity Networks Inc
        #expect(BluetoothUUID.mobiquityNetworks.rawValue == "FE9D")
        #expect(BluetoothUUID.mobiquityNetworks == .bit16(0xFE9D))
        #expect(BluetoothUUID.mobiquityNetworks == .bit16(65181))
        #expect(BluetoothUUID.mobiquityNetworks.name == "Mobiquity Networks Inc")
        #expect(BluetoothUUID.mobiquityNetworks != .bit32(65181))
        #expect(BluetoothUUID.mobiquityNetworks != .bit32(0xFE9D))

        /// Dialog Semiconductor B.V.
        #expect(BluetoothUUID.dialogSemiconductor.rawValue == "FE9E")
        #expect(BluetoothUUID.dialogSemiconductor == .bit16(0xFE9E))
        #expect(BluetoothUUID.dialogSemiconductor == .bit16(65182))
        #expect(BluetoothUUID.dialogSemiconductor.name == "Dialog Semiconductor B.V.")
        #expect(BluetoothUUID.dialogSemiconductor != .bit32(65182))
        #expect(BluetoothUUID.dialogSemiconductor != .bit32(0xFE9E))

        /// Google Inc.
        #expect(BluetoothUUID.google9.rawValue == "FE9F")
        #expect(BluetoothUUID.google9 == .bit16(0xFE9F))
        #expect(BluetoothUUID.google9 == .bit16(65183))
        #expect(BluetoothUUID.google9.name == "Google Inc.")
        #expect(BluetoothUUID.google9 != .bit32(65183))
        #expect(BluetoothUUID.google9 != .bit32(0xFE9F))

        /// Google Inc.
        #expect(BluetoothUUID.google10.rawValue == "FEA0")
        #expect(BluetoothUUID.google10 == .bit16(0xFEA0))
        #expect(BluetoothUUID.google10 == .bit16(65184))
        #expect(BluetoothUUID.google10.name == "Google Inc.")
        #expect(BluetoothUUID.google10 != .bit32(65184))
        #expect(BluetoothUUID.google10 != .bit32(0xFEA0))

        /// Intrepid Control Systems, Inc.
        #expect(BluetoothUUID.intrepidControlSystems.rawValue == "FEA1")
        #expect(BluetoothUUID.intrepidControlSystems == .bit16(0xFEA1))
        #expect(BluetoothUUID.intrepidControlSystems == .bit16(65185))
        #expect(BluetoothUUID.intrepidControlSystems.name == "Intrepid Control Systems, Inc.")
        #expect(BluetoothUUID.intrepidControlSystems != .bit32(65185))
        #expect(BluetoothUUID.intrepidControlSystems != .bit32(0xFEA1))

        /// Intrepid Control Systems, Inc.
        #expect(BluetoothUUID.intrepidControlSystems2.rawValue == "FEA2")
        #expect(BluetoothUUID.intrepidControlSystems2 == .bit16(0xFEA2))
        #expect(BluetoothUUID.intrepidControlSystems2 == .bit16(65186))
        #expect(BluetoothUUID.intrepidControlSystems2.name == "Intrepid Control Systems, Inc.")
        #expect(BluetoothUUID.intrepidControlSystems2 != .bit32(65186))
        #expect(BluetoothUUID.intrepidControlSystems2 != .bit32(0xFEA2))

        /// ITT Industries
        #expect(BluetoothUUID.ittIndustries2.rawValue == "FEA3")
        #expect(BluetoothUUID.ittIndustries2 == .bit16(0xFEA3))
        #expect(BluetoothUUID.ittIndustries2 == .bit16(65187))
        #expect(BluetoothUUID.ittIndustries2.name == "ITT Industries")
        #expect(BluetoothUUID.ittIndustries2 != .bit32(65187))
        #expect(BluetoothUUID.ittIndustries2 != .bit32(0xFEA3))

        /// Paxton Access Ltd
        #expect(BluetoothUUID.paxtonAccess.rawValue == "FEA4")
        #expect(BluetoothUUID.paxtonAccess == .bit16(0xFEA4))
        #expect(BluetoothUUID.paxtonAccess == .bit16(65188))
        #expect(BluetoothUUID.paxtonAccess.name == "Paxton Access Ltd")
        #expect(BluetoothUUID.paxtonAccess != .bit32(65188))
        #expect(BluetoothUUID.paxtonAccess != .bit32(0xFEA4))

        /// GoPro, Inc.
        #expect(BluetoothUUID.gopro.rawValue == "FEA5")
        #expect(BluetoothUUID.gopro == .bit16(0xFEA5))
        #expect(BluetoothUUID.gopro == .bit16(65189))
        #expect(BluetoothUUID.gopro.name == "GoPro, Inc.")
        #expect(BluetoothUUID.gopro != .bit32(65189))
        #expect(BluetoothUUID.gopro != .bit32(0xFEA5))

        /// GoPro, Inc.
        #expect(BluetoothUUID.gopro2.rawValue == "FEA6")
        #expect(BluetoothUUID.gopro2 == .bit16(0xFEA6))
        #expect(BluetoothUUID.gopro2 == .bit16(65190))
        #expect(BluetoothUUID.gopro2.name == "GoPro, Inc.")
        #expect(BluetoothUUID.gopro2 != .bit32(65190))
        #expect(BluetoothUUID.gopro2 != .bit32(0xFEA6))

        /// UTC Fire and Security
        #expect(BluetoothUUID.utcFireAndSecurity.rawValue == "FEA7")
        #expect(BluetoothUUID.utcFireAndSecurity == .bit16(0xFEA7))
        #expect(BluetoothUUID.utcFireAndSecurity == .bit16(65191))
        #expect(BluetoothUUID.utcFireAndSecurity.name == "UTC Fire and Security")
        #expect(BluetoothUUID.utcFireAndSecurity != .bit32(65191))
        #expect(BluetoothUUID.utcFireAndSecurity != .bit32(0xFEA7))

        /// Savant Systems LLC
        #expect(BluetoothUUID.savantSystems.rawValue == "FEA8")
        #expect(BluetoothUUID.savantSystems == .bit16(0xFEA8))
        #expect(BluetoothUUID.savantSystems == .bit16(65192))
        #expect(BluetoothUUID.savantSystems.name == "Savant Systems LLC")
        #expect(BluetoothUUID.savantSystems != .bit32(65192))
        #expect(BluetoothUUID.savantSystems != .bit32(0xFEA8))

        /// Savant Systems LLC
        #expect(BluetoothUUID.savantSystems2.rawValue == "FEA9")
        #expect(BluetoothUUID.savantSystems2 == .bit16(0xFEA9))
        #expect(BluetoothUUID.savantSystems2 == .bit16(65193))
        #expect(BluetoothUUID.savantSystems2.name == "Savant Systems LLC")
        #expect(BluetoothUUID.savantSystems2 != .bit32(65193))
        #expect(BluetoothUUID.savantSystems2 != .bit32(0xFEA9))

        /// Google Inc.
        #expect(BluetoothUUID.google11.rawValue == "FEAA")
        #expect(BluetoothUUID.google11 == .bit16(0xFEAA))
        #expect(BluetoothUUID.google11 == .bit16(65194))
        #expect(BluetoothUUID.google11.name == "Google Inc.")
        #expect(BluetoothUUID.google11 != .bit32(65194))
        #expect(BluetoothUUID.google11 != .bit32(0xFEAA))

        /// Nokia Corporation
        #expect(BluetoothUUID.nokia.rawValue == "FEAB")
        #expect(BluetoothUUID.nokia == .bit16(0xFEAB))
        #expect(BluetoothUUID.nokia == .bit16(65195))
        #expect(BluetoothUUID.nokia.name == "Nokia Corporation")
        #expect(BluetoothUUID.nokia != .bit32(65195))
        #expect(BluetoothUUID.nokia != .bit32(0xFEAB))

        /// Nokia Corporation
        #expect(BluetoothUUID.nokia2.rawValue == "FEAC")
        #expect(BluetoothUUID.nokia2 == .bit16(0xFEAC))
        #expect(BluetoothUUID.nokia2 == .bit16(65196))
        #expect(BluetoothUUID.nokia2.name == "Nokia Corporation")
        #expect(BluetoothUUID.nokia2 != .bit32(65196))
        #expect(BluetoothUUID.nokia2 != .bit32(0xFEAC))

        /// Nokia Corporation
        #expect(BluetoothUUID.nokia3.rawValue == "FEAD")
        #expect(BluetoothUUID.nokia3 == .bit16(0xFEAD))
        #expect(BluetoothUUID.nokia3 == .bit16(65197))
        #expect(BluetoothUUID.nokia3.name == "Nokia Corporation")
        #expect(BluetoothUUID.nokia3 != .bit32(65197))
        #expect(BluetoothUUID.nokia3 != .bit32(0xFEAD))

        /// Nokia Corporation
        #expect(BluetoothUUID.nokia4.rawValue == "FEAE")
        #expect(BluetoothUUID.nokia4 == .bit16(0xFEAE))
        #expect(BluetoothUUID.nokia4 == .bit16(65198))
        #expect(BluetoothUUID.nokia4.name == "Nokia Corporation")
        #expect(BluetoothUUID.nokia4 != .bit32(65198))
        #expect(BluetoothUUID.nokia4 != .bit32(0xFEAE))

        /// Nest Labs Inc.
        #expect(BluetoothUUID.nestLabs.rawValue == "FEAF")
        #expect(BluetoothUUID.nestLabs == .bit16(0xFEAF))
        #expect(BluetoothUUID.nestLabs == .bit16(65199))
        #expect(BluetoothUUID.nestLabs.name == "Nest Labs Inc.")
        #expect(BluetoothUUID.nestLabs != .bit32(65199))
        #expect(BluetoothUUID.nestLabs != .bit32(0xFEAF))

        /// Nest Labs Inc.
        #expect(BluetoothUUID.nestLabs2.rawValue == "FEB0")
        #expect(BluetoothUUID.nestLabs2 == .bit16(0xFEB0))
        #expect(BluetoothUUID.nestLabs2 == .bit16(65200))
        #expect(BluetoothUUID.nestLabs2.name == "Nest Labs Inc.")
        #expect(BluetoothUUID.nestLabs2 != .bit32(65200))
        #expect(BluetoothUUID.nestLabs2 != .bit32(0xFEB0))

        /// Electronics Tomorrow Limited
        #expect(BluetoothUUID.electronicsTomorrow.rawValue == "FEB1")
        #expect(BluetoothUUID.electronicsTomorrow == .bit16(0xFEB1))
        #expect(BluetoothUUID.electronicsTomorrow == .bit16(65201))
        #expect(BluetoothUUID.electronicsTomorrow.name == "Electronics Tomorrow Limited")
        #expect(BluetoothUUID.electronicsTomorrow != .bit32(65201))
        #expect(BluetoothUUID.electronicsTomorrow != .bit32(0xFEB1))

        /// Microsoft Corporation
        #expect(BluetoothUUID.microsoft2.rawValue == "FEB2")
        #expect(BluetoothUUID.microsoft2 == .bit16(0xFEB2))
        #expect(BluetoothUUID.microsoft2 == .bit16(65202))
        #expect(BluetoothUUID.microsoft2.name == "Microsoft Corporation")
        #expect(BluetoothUUID.microsoft2 != .bit32(65202))
        #expect(BluetoothUUID.microsoft2 != .bit32(0xFEB2))

        /// Taobao
        #expect(BluetoothUUID.taobao.rawValue == "FEB3")
        #expect(BluetoothUUID.taobao == .bit16(0xFEB3))
        #expect(BluetoothUUID.taobao == .bit16(65203))
        #expect(BluetoothUUID.taobao.name == "Taobao")
        #expect(BluetoothUUID.taobao != .bit32(65203))
        #expect(BluetoothUUID.taobao != .bit32(0xFEB3))

        /// WiSilica Inc.
        #expect(BluetoothUUID.wisilica.rawValue == "FEB4")
        #expect(BluetoothUUID.wisilica == .bit16(0xFEB4))
        #expect(BluetoothUUID.wisilica == .bit16(65204))
        #expect(BluetoothUUID.wisilica.name == "WiSilica Inc.")
        #expect(BluetoothUUID.wisilica != .bit32(65204))
        #expect(BluetoothUUID.wisilica != .bit32(0xFEB4))

        /// WiSilica Inc.
        #expect(BluetoothUUID.wisilica2.rawValue == "FEB5")
        #expect(BluetoothUUID.wisilica2 == .bit16(0xFEB5))
        #expect(BluetoothUUID.wisilica2 == .bit16(65205))
        #expect(BluetoothUUID.wisilica2.name == "WiSilica Inc.")
        #expect(BluetoothUUID.wisilica2 != .bit32(65205))
        #expect(BluetoothUUID.wisilica2 != .bit32(0xFEB5))

        /// Vencer Co, Ltd
        #expect(BluetoothUUID.vencerCo.rawValue == "FEB6")
        #expect(BluetoothUUID.vencerCo == .bit16(0xFEB6))
        #expect(BluetoothUUID.vencerCo == .bit16(65206))
        #expect(BluetoothUUID.vencerCo.name == "Vencer Co, Ltd")
        #expect(BluetoothUUID.vencerCo != .bit32(65206))
        #expect(BluetoothUUID.vencerCo != .bit32(0xFEB6))

        /// Facebook, Inc.
        #expect(BluetoothUUID.facebook.rawValue == "FEB7")
        #expect(BluetoothUUID.facebook == .bit16(0xFEB7))
        #expect(BluetoothUUID.facebook == .bit16(65207))
        #expect(BluetoothUUID.facebook.name == "Facebook, Inc.")
        #expect(BluetoothUUID.facebook != .bit32(65207))
        #expect(BluetoothUUID.facebook != .bit32(0xFEB7))

        /// Facebook, Inc.
        #expect(BluetoothUUID.facebook2.rawValue == "FEB8")
        #expect(BluetoothUUID.facebook2 == .bit16(0xFEB8))
        #expect(BluetoothUUID.facebook2 == .bit16(65208))
        #expect(BluetoothUUID.facebook2.name == "Facebook, Inc.")
        #expect(BluetoothUUID.facebook2 != .bit32(65208))
        #expect(BluetoothUUID.facebook2 != .bit32(0xFEB8))

        /// LG Electronics
        #expect(BluetoothUUID.lgElectronics.rawValue == "FEB9")
        #expect(BluetoothUUID.lgElectronics == .bit16(0xFEB9))
        #expect(BluetoothUUID.lgElectronics == .bit16(65209))
        #expect(BluetoothUUID.lgElectronics.name == "LG Electronics")
        #expect(BluetoothUUID.lgElectronics != .bit32(65209))
        #expect(BluetoothUUID.lgElectronics != .bit32(0xFEB9))

        /// Tencent Holdings Limited
        #expect(BluetoothUUID.tencentHoldings.rawValue == "FEBA")
        #expect(BluetoothUUID.tencentHoldings == .bit16(0xFEBA))
        #expect(BluetoothUUID.tencentHoldings == .bit16(65210))
        #expect(BluetoothUUID.tencentHoldings.name == "Tencent Holdings Limited")
        #expect(BluetoothUUID.tencentHoldings != .bit32(65210))
        #expect(BluetoothUUID.tencentHoldings != .bit32(0xFEBA))

        /// adafruit industries
        #expect(BluetoothUUID.adafruitIndustries.rawValue == "FEBB")
        #expect(BluetoothUUID.adafruitIndustries == .bit16(0xFEBB))
        #expect(BluetoothUUID.adafruitIndustries == .bit16(65211))
        #expect(BluetoothUUID.adafruitIndustries.name == "adafruit industries")
        #expect(BluetoothUUID.adafruitIndustries != .bit32(65211))
        #expect(BluetoothUUID.adafruitIndustries != .bit32(0xFEBB))

        /// Dexcom, Inc.
        #expect(BluetoothUUID.dexcom.rawValue == "FEBC")
        #expect(BluetoothUUID.dexcom == .bit16(0xFEBC))
        #expect(BluetoothUUID.dexcom == .bit16(65212))
        #expect(BluetoothUUID.dexcom.name == "Dexcom, Inc.")
        #expect(BluetoothUUID.dexcom != .bit32(65212))
        #expect(BluetoothUUID.dexcom != .bit32(0xFEBC))

        /// Clover Network, Inc.
        #expect(BluetoothUUID.cloverNetwork.rawValue == "FEBD")
        #expect(BluetoothUUID.cloverNetwork == .bit16(0xFEBD))
        #expect(BluetoothUUID.cloverNetwork == .bit16(65213))
        #expect(BluetoothUUID.cloverNetwork.name == "Clover Network, Inc.")
        #expect(BluetoothUUID.cloverNetwork != .bit32(65213))
        #expect(BluetoothUUID.cloverNetwork != .bit32(0xFEBD))

        /// Bose Corporation
        #expect(BluetoothUUID.bose2.rawValue == "FEBE")
        #expect(BluetoothUUID.bose2 == .bit16(0xFEBE))
        #expect(BluetoothUUID.bose2 == .bit16(65214))
        #expect(BluetoothUUID.bose2.name == "Bose Corporation")
        #expect(BluetoothUUID.bose2 != .bit32(65214))
        #expect(BluetoothUUID.bose2 != .bit32(0xFEBE))

        /// Nod, Inc.
        #expect(BluetoothUUID.nod.rawValue == "FEBF")
        #expect(BluetoothUUID.nod == .bit16(0xFEBF))
        #expect(BluetoothUUID.nod == .bit16(65215))
        #expect(BluetoothUUID.nod.name == "Nod, Inc.")
        #expect(BluetoothUUID.nod != .bit32(65215))
        #expect(BluetoothUUID.nod != .bit32(0xFEBF))

        /// KDDI Corporation
        #expect(BluetoothUUID.kddi.rawValue == "FEC0")
        #expect(BluetoothUUID.kddi == .bit16(0xFEC0))
        #expect(BluetoothUUID.kddi == .bit16(65216))
        #expect(BluetoothUUID.kddi.name == "KDDI Corporation")
        #expect(BluetoothUUID.kddi != .bit32(65216))
        #expect(BluetoothUUID.kddi != .bit32(0xFEC0))

        /// KDDI Corporation
        #expect(BluetoothUUID.kddi2.rawValue == "FEC1")
        #expect(BluetoothUUID.kddi2 == .bit16(0xFEC1))
        #expect(BluetoothUUID.kddi2 == .bit16(65217))
        #expect(BluetoothUUID.kddi2.name == "KDDI Corporation")
        #expect(BluetoothUUID.kddi2 != .bit32(65217))
        #expect(BluetoothUUID.kddi2 != .bit32(0xFEC1))

        /// Blue Spark Technologies, Inc.
        #expect(BluetoothUUID.blueSparkTechnologies.rawValue == "FEC2")
        #expect(BluetoothUUID.blueSparkTechnologies == .bit16(0xFEC2))
        #expect(BluetoothUUID.blueSparkTechnologies == .bit16(65218))
        #expect(BluetoothUUID.blueSparkTechnologies.name == "Blue Spark Technologies, Inc.")
        #expect(BluetoothUUID.blueSparkTechnologies != .bit32(65218))
        #expect(BluetoothUUID.blueSparkTechnologies != .bit32(0xFEC2))

        /// 360fly, Inc.
        #expect(BluetoothUUID.uuid360Fly.rawValue == "FEC3")
        #expect(BluetoothUUID.uuid360Fly == .bit16(0xFEC3))
        #expect(BluetoothUUID.uuid360Fly == .bit16(65219))
        #expect(BluetoothUUID.uuid360Fly.name == "360fly, Inc.")
        #expect(BluetoothUUID.uuid360Fly != .bit32(65219))
        #expect(BluetoothUUID.uuid360Fly != .bit32(0xFEC3))

        /// PLUS Location Systems
        #expect(BluetoothUUID.plusLocationSystems.rawValue == "FEC4")
        #expect(BluetoothUUID.plusLocationSystems == .bit16(0xFEC4))
        #expect(BluetoothUUID.plusLocationSystems == .bit16(65220))
        #expect(BluetoothUUID.plusLocationSystems.name == "PLUS Location Systems")
        #expect(BluetoothUUID.plusLocationSystems != .bit32(65220))
        #expect(BluetoothUUID.plusLocationSystems != .bit32(0xFEC4))

        /// Realtek Semiconductor Corp.
        #expect(BluetoothUUID.realtekSemiconductor.rawValue == "FEC5")
        #expect(BluetoothUUID.realtekSemiconductor == .bit16(0xFEC5))
        #expect(BluetoothUUID.realtekSemiconductor == .bit16(65221))
        #expect(BluetoothUUID.realtekSemiconductor.name == "Realtek Semiconductor Corp.")
        #expect(BluetoothUUID.realtekSemiconductor != .bit32(65221))
        #expect(BluetoothUUID.realtekSemiconductor != .bit32(0xFEC5))

        /// Kocomojo, LLC
        #expect(BluetoothUUID.kocomojo.rawValue == "FEC6")
        #expect(BluetoothUUID.kocomojo == .bit16(0xFEC6))
        #expect(BluetoothUUID.kocomojo == .bit16(65222))
        #expect(BluetoothUUID.kocomojo.name == "Kocomojo, LLC")
        #expect(BluetoothUUID.kocomojo != .bit32(65222))
        #expect(BluetoothUUID.kocomojo != .bit32(0xFEC6))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple5.rawValue == "FEC7")
        #expect(BluetoothUUID.apple5 == .bit16(0xFEC7))
        #expect(BluetoothUUID.apple5 == .bit16(65223))
        #expect(BluetoothUUID.apple5.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple5 != .bit32(65223))
        #expect(BluetoothUUID.apple5 != .bit32(0xFEC7))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple6.rawValue == "FEC8")
        #expect(BluetoothUUID.apple6 == .bit16(0xFEC8))
        #expect(BluetoothUUID.apple6 == .bit16(65224))
        #expect(BluetoothUUID.apple6.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple6 != .bit32(65224))
        #expect(BluetoothUUID.apple6 != .bit32(0xFEC8))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple7.rawValue == "FEC9")
        #expect(BluetoothUUID.apple7 == .bit16(0xFEC9))
        #expect(BluetoothUUID.apple7 == .bit16(65225))
        #expect(BluetoothUUID.apple7.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple7 != .bit32(65225))
        #expect(BluetoothUUID.apple7 != .bit32(0xFEC9))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple8.rawValue == "FECA")
        #expect(BluetoothUUID.apple8 == .bit16(0xFECA))
        #expect(BluetoothUUID.apple8 == .bit16(65226))
        #expect(BluetoothUUID.apple8.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple8 != .bit32(65226))
        #expect(BluetoothUUID.apple8 != .bit32(0xFECA))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple9.rawValue == "FECB")
        #expect(BluetoothUUID.apple9 == .bit16(0xFECB))
        #expect(BluetoothUUID.apple9 == .bit16(65227))
        #expect(BluetoothUUID.apple9.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple9 != .bit32(65227))
        #expect(BluetoothUUID.apple9 != .bit32(0xFECB))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple10.rawValue == "FECC")
        #expect(BluetoothUUID.apple10 == .bit16(0xFECC))
        #expect(BluetoothUUID.apple10 == .bit16(65228))
        #expect(BluetoothUUID.apple10.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple10 != .bit32(65228))
        #expect(BluetoothUUID.apple10 != .bit32(0xFECC))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple11.rawValue == "FECD")
        #expect(BluetoothUUID.apple11 == .bit16(0xFECD))
        #expect(BluetoothUUID.apple11 == .bit16(65229))
        #expect(BluetoothUUID.apple11.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple11 != .bit32(65229))
        #expect(BluetoothUUID.apple11 != .bit32(0xFECD))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple12.rawValue == "FECE")
        #expect(BluetoothUUID.apple12 == .bit16(0xFECE))
        #expect(BluetoothUUID.apple12 == .bit16(65230))
        #expect(BluetoothUUID.apple12.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple12 != .bit32(65230))
        #expect(BluetoothUUID.apple12 != .bit32(0xFECE))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple13.rawValue == "FECF")
        #expect(BluetoothUUID.apple13 == .bit16(0xFECF))
        #expect(BluetoothUUID.apple13 == .bit16(65231))
        #expect(BluetoothUUID.apple13.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple13 != .bit32(65231))
        #expect(BluetoothUUID.apple13 != .bit32(0xFECF))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple14.rawValue == "FED0")
        #expect(BluetoothUUID.apple14 == .bit16(0xFED0))
        #expect(BluetoothUUID.apple14 == .bit16(65232))
        #expect(BluetoothUUID.apple14.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple14 != .bit32(65232))
        #expect(BluetoothUUID.apple14 != .bit32(0xFED0))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple15.rawValue == "FED1")
        #expect(BluetoothUUID.apple15 == .bit16(0xFED1))
        #expect(BluetoothUUID.apple15 == .bit16(65233))
        #expect(BluetoothUUID.apple15.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple15 != .bit32(65233))
        #expect(BluetoothUUID.apple15 != .bit32(0xFED1))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple16.rawValue == "FED2")
        #expect(BluetoothUUID.apple16 == .bit16(0xFED2))
        #expect(BluetoothUUID.apple16 == .bit16(65234))
        #expect(BluetoothUUID.apple16.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple16 != .bit32(65234))
        #expect(BluetoothUUID.apple16 != .bit32(0xFED2))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple17.rawValue == "FED3")
        #expect(BluetoothUUID.apple17 == .bit16(0xFED3))
        #expect(BluetoothUUID.apple17 == .bit16(65235))
        #expect(BluetoothUUID.apple17.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple17 != .bit32(65235))
        #expect(BluetoothUUID.apple17 != .bit32(0xFED3))

        /// Apple, Inc.
        #expect(BluetoothUUID.apple18.rawValue == "FED4")
        #expect(BluetoothUUID.apple18 == .bit16(0xFED4))
        #expect(BluetoothUUID.apple18 == .bit16(65236))
        #expect(BluetoothUUID.apple18.name == "Apple, Inc.")
        #expect(BluetoothUUID.apple18 != .bit32(65236))
        #expect(BluetoothUUID.apple18 != .bit32(0xFED4))

        /// Plantronics Inc.
        #expect(BluetoothUUID.plantronics.rawValue == "FED5")
        #expect(BluetoothUUID.plantronics == .bit16(0xFED5))
        #expect(BluetoothUUID.plantronics == .bit16(65237))
        #expect(BluetoothUUID.plantronics.name == "Plantronics Inc.")
        #expect(BluetoothUUID.plantronics != .bit32(65237))
        #expect(BluetoothUUID.plantronics != .bit32(0xFED5))

        /// Broadcom Corporation
        #expect(BluetoothUUID.broadcom.rawValue == "FED6")
        #expect(BluetoothUUID.broadcom == .bit16(0xFED6))
        #expect(BluetoothUUID.broadcom == .bit16(65238))
        #expect(BluetoothUUID.broadcom.name == "Broadcom Corporation")
        #expect(BluetoothUUID.broadcom != .bit32(65238))
        #expect(BluetoothUUID.broadcom != .bit32(0xFED6))

        /// Broadcom Corporation
        #expect(BluetoothUUID.broadcom2.rawValue == "FED7")
        #expect(BluetoothUUID.broadcom2 == .bit16(0xFED7))
        #expect(BluetoothUUID.broadcom2 == .bit16(65239))
        #expect(BluetoothUUID.broadcom2.name == "Broadcom Corporation")
        #expect(BluetoothUUID.broadcom2 != .bit32(65239))
        #expect(BluetoothUUID.broadcom2 != .bit32(0xFED7))

        /// Google Inc.
        #expect(BluetoothUUID.google12.rawValue == "FED8")
        #expect(BluetoothUUID.google12 == .bit16(0xFED8))
        #expect(BluetoothUUID.google12 == .bit16(65240))
        #expect(BluetoothUUID.google12.name == "Google Inc.")
        #expect(BluetoothUUID.google12 != .bit32(65240))
        #expect(BluetoothUUID.google12 != .bit32(0xFED8))

        /// Pebble Technology Corporation
        #expect(BluetoothUUID.pebbleTechnology.rawValue == "FED9")
        #expect(BluetoothUUID.pebbleTechnology == .bit16(0xFED9))
        #expect(BluetoothUUID.pebbleTechnology == .bit16(65241))
        #expect(BluetoothUUID.pebbleTechnology.name == "Pebble Technology Corporation")
        #expect(BluetoothUUID.pebbleTechnology != .bit32(65241))
        #expect(BluetoothUUID.pebbleTechnology != .bit32(0xFED9))

        /// ISSC Technologies Corporation
        #expect(BluetoothUUID.isscTechnologies.rawValue == "FEDA")
        #expect(BluetoothUUID.isscTechnologies == .bit16(0xFEDA))
        #expect(BluetoothUUID.isscTechnologies == .bit16(65242))
        #expect(BluetoothUUID.isscTechnologies.name == "ISSC Technologies Corporation")
        #expect(BluetoothUUID.isscTechnologies != .bit32(65242))
        #expect(BluetoothUUID.isscTechnologies != .bit32(0xFEDA))

        /// Perka, Inc.
        #expect(BluetoothUUID.perka.rawValue == "FEDB")
        #expect(BluetoothUUID.perka == .bit16(0xFEDB))
        #expect(BluetoothUUID.perka == .bit16(65243))
        #expect(BluetoothUUID.perka.name == "Perka, Inc.")
        #expect(BluetoothUUID.perka != .bit32(65243))
        #expect(BluetoothUUID.perka != .bit32(0xFEDB))

        /// Jawbone
        #expect(BluetoothUUID.jawbone.rawValue == "FEDC")
        #expect(BluetoothUUID.jawbone == .bit16(0xFEDC))
        #expect(BluetoothUUID.jawbone == .bit16(65244))
        #expect(BluetoothUUID.jawbone.name == "Jawbone")
        #expect(BluetoothUUID.jawbone != .bit32(65244))
        #expect(BluetoothUUID.jawbone != .bit32(0xFEDC))

        /// Jawbone
        #expect(BluetoothUUID.jawbone2.rawValue == "FEDD")
        #expect(BluetoothUUID.jawbone2 == .bit16(0xFEDD))
        #expect(BluetoothUUID.jawbone2 == .bit16(65245))
        #expect(BluetoothUUID.jawbone2.name == "Jawbone")
        #expect(BluetoothUUID.jawbone2 != .bit32(65245))
        #expect(BluetoothUUID.jawbone2 != .bit32(0xFEDD))

        /// Coin, Inc.
        #expect(BluetoothUUID.coin.rawValue == "FEDE")
        #expect(BluetoothUUID.coin == .bit16(0xFEDE))
        #expect(BluetoothUUID.coin == .bit16(65246))
        #expect(BluetoothUUID.coin.name == "Coin, Inc.")
        #expect(BluetoothUUID.coin != .bit32(65246))
        #expect(BluetoothUUID.coin != .bit32(0xFEDE))

        /// Design SHIFT
        #expect(BluetoothUUID.designShift.rawValue == "FEDF")
        #expect(BluetoothUUID.designShift == .bit16(0xFEDF))
        #expect(BluetoothUUID.designShift == .bit16(65247))
        #expect(BluetoothUUID.designShift.name == "Design SHIFT")
        #expect(BluetoothUUID.designShift != .bit32(65247))
        #expect(BluetoothUUID.designShift != .bit32(0xFEDF))

        /// Anhui Huami Information Technology Co.
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology.rawValue == "FEE0")
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology == .bit16(0xFEE0))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology == .bit16(65248))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology.name == "Anhui Huami Information Technology Co.")
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology != .bit32(65248))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology != .bit32(0xFEE0))

        /// Anhui Huami Information Technology Co.
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2.rawValue == "FEE1")
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2 == .bit16(0xFEE1))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2 == .bit16(65249))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2.name == "Anhui Huami Information Technology Co.")
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2 != .bit32(65249))
        #expect(BluetoothUUID.anhuiHuamiInformationTechnology2 != .bit32(0xFEE1))

        /// Anki, Inc.
        #expect(BluetoothUUID.anki.rawValue == "FEE2")
        #expect(BluetoothUUID.anki == .bit16(0xFEE2))
        #expect(BluetoothUUID.anki == .bit16(65250))
        #expect(BluetoothUUID.anki.name == "Anki, Inc.")
        #expect(BluetoothUUID.anki != .bit32(65250))
        #expect(BluetoothUUID.anki != .bit32(0xFEE2))

        /// Anki, Inc.
        #expect(BluetoothUUID.anki2.rawValue == "FEE3")
        #expect(BluetoothUUID.anki2 == .bit16(0xFEE3))
        #expect(BluetoothUUID.anki2 == .bit16(65251))
        #expect(BluetoothUUID.anki2.name == "Anki, Inc.")
        #expect(BluetoothUUID.anki2 != .bit32(65251))
        #expect(BluetoothUUID.anki2 != .bit32(0xFEE3))

        /// Nordic Semiconductor ASA
        #expect(BluetoothUUID.nordicSemiconductor3.rawValue == "FEE4")
        #expect(BluetoothUUID.nordicSemiconductor3 == .bit16(0xFEE4))
        #expect(BluetoothUUID.nordicSemiconductor3 == .bit16(65252))
        #expect(BluetoothUUID.nordicSemiconductor3.name == "Nordic Semiconductor ASA")
        #expect(BluetoothUUID.nordicSemiconductor3 != .bit32(65252))
        #expect(BluetoothUUID.nordicSemiconductor3 != .bit32(0xFEE4))

        /// Nordic Semiconductor ASA
        #expect(BluetoothUUID.nordicSemiconductor4.rawValue == "FEE5")
        #expect(BluetoothUUID.nordicSemiconductor4 == .bit16(0xFEE5))
        #expect(BluetoothUUID.nordicSemiconductor4 == .bit16(65253))
        #expect(BluetoothUUID.nordicSemiconductor4.name == "Nordic Semiconductor ASA")
        #expect(BluetoothUUID.nordicSemiconductor4 != .bit32(65253))
        #expect(BluetoothUUID.nordicSemiconductor4 != .bit32(0xFEE5))

        /// Silvair, Inc.
        #expect(BluetoothUUID.silvair.rawValue == "FEE6")
        #expect(BluetoothUUID.silvair == .bit16(0xFEE6))
        #expect(BluetoothUUID.silvair == .bit16(65254))
        #expect(BluetoothUUID.silvair.name == "Silvair, Inc.")
        #expect(BluetoothUUID.silvair != .bit32(65254))
        #expect(BluetoothUUID.silvair != .bit32(0xFEE6))

        /// Tencent Holdings Limited
        #expect(BluetoothUUID.tencentHoldings2.rawValue == "FEE7")
        #expect(BluetoothUUID.tencentHoldings2 == .bit16(0xFEE7))
        #expect(BluetoothUUID.tencentHoldings2 == .bit16(65255))
        #expect(BluetoothUUID.tencentHoldings2.name == "Tencent Holdings Limited")
        #expect(BluetoothUUID.tencentHoldings2 != .bit32(65255))
        #expect(BluetoothUUID.tencentHoldings2 != .bit32(0xFEE7))

        /// Quintic Corp.
        #expect(BluetoothUUID.quintic.rawValue == "FEE8")
        #expect(BluetoothUUID.quintic == .bit16(0xFEE8))
        #expect(BluetoothUUID.quintic == .bit16(65256))
        #expect(BluetoothUUID.quintic.name == "Quintic Corp.")
        #expect(BluetoothUUID.quintic != .bit32(65256))
        #expect(BluetoothUUID.quintic != .bit32(0xFEE8))

        /// Quintic Corp.
        #expect(BluetoothUUID.quintic2.rawValue == "FEE9")
        #expect(BluetoothUUID.quintic2 == .bit16(0xFEE9))
        #expect(BluetoothUUID.quintic2 == .bit16(65257))
        #expect(BluetoothUUID.quintic2.name == "Quintic Corp.")
        #expect(BluetoothUUID.quintic2 != .bit32(65257))
        #expect(BluetoothUUID.quintic2 != .bit32(0xFEE9))

        /// Swirl Networks, Inc.
        #expect(BluetoothUUID.swirlNetworks.rawValue == "FEEA")
        #expect(BluetoothUUID.swirlNetworks == .bit16(0xFEEA))
        #expect(BluetoothUUID.swirlNetworks == .bit16(65258))
        #expect(BluetoothUUID.swirlNetworks.name == "Swirl Networks, Inc.")
        #expect(BluetoothUUID.swirlNetworks != .bit32(65258))
        #expect(BluetoothUUID.swirlNetworks != .bit32(0xFEEA))

        /// Swirl Networks, Inc.
        #expect(BluetoothUUID.swirlNetworks2.rawValue == "FEEB")
        #expect(BluetoothUUID.swirlNetworks2 == .bit16(0xFEEB))
        #expect(BluetoothUUID.swirlNetworks2 == .bit16(65259))
        #expect(BluetoothUUID.swirlNetworks2.name == "Swirl Networks, Inc.")
        #expect(BluetoothUUID.swirlNetworks2 != .bit32(65259))
        #expect(BluetoothUUID.swirlNetworks2 != .bit32(0xFEEB))

        /// Tile, Inc.
        #expect(BluetoothUUID.tile.rawValue == "FEEC")
        #expect(BluetoothUUID.tile == .bit16(0xFEEC))
        #expect(BluetoothUUID.tile == .bit16(65260))
        #expect(BluetoothUUID.tile.name == "Tile, Inc.")
        #expect(BluetoothUUID.tile != .bit32(65260))
        #expect(BluetoothUUID.tile != .bit32(0xFEEC))

        /// Tile, Inc.
        #expect(BluetoothUUID.tile2.rawValue == "FEED")
        #expect(BluetoothUUID.tile2 == .bit16(0xFEED))
        #expect(BluetoothUUID.tile2 == .bit16(65261))
        #expect(BluetoothUUID.tile2.name == "Tile, Inc.")
        #expect(BluetoothUUID.tile2 != .bit32(65261))
        #expect(BluetoothUUID.tile2 != .bit32(0xFEED))

        /// Polar Electro Oy
        #expect(BluetoothUUID.polarElectro.rawValue == "FEEE")
        #expect(BluetoothUUID.polarElectro == .bit16(0xFEEE))
        #expect(BluetoothUUID.polarElectro == .bit16(65262))
        #expect(BluetoothUUID.polarElectro.name == "Polar Electro Oy")
        #expect(BluetoothUUID.polarElectro != .bit32(65262))
        #expect(BluetoothUUID.polarElectro != .bit32(0xFEEE))

        /// Polar Electro Oy
        #expect(BluetoothUUID.polarElectro2.rawValue == "FEEF")
        #expect(BluetoothUUID.polarElectro2 == .bit16(0xFEEF))
        #expect(BluetoothUUID.polarElectro2 == .bit16(65263))
        #expect(BluetoothUUID.polarElectro2.name == "Polar Electro Oy")
        #expect(BluetoothUUID.polarElectro2 != .bit32(65263))
        #expect(BluetoothUUID.polarElectro2 != .bit32(0xFEEF))

        /// Intel
        #expect(BluetoothUUID.intel2.rawValue == "FEF0")
        #expect(BluetoothUUID.intel2 == .bit16(0xFEF0))
        #expect(BluetoothUUID.intel2 == .bit16(65264))
        #expect(BluetoothUUID.intel2.name == "Intel")
        #expect(BluetoothUUID.intel2 != .bit32(65264))
        #expect(BluetoothUUID.intel2 != .bit32(0xFEF0))

        /// CSR
        #expect(BluetoothUUID.csr2.rawValue == "FEF1")
        #expect(BluetoothUUID.csr2 == .bit16(0xFEF1))
        #expect(BluetoothUUID.csr2 == .bit16(65265))
        #expect(BluetoothUUID.csr2.name == "CSR")
        #expect(BluetoothUUID.csr2 != .bit32(65265))
        #expect(BluetoothUUID.csr2 != .bit32(0xFEF1))

        /// CSR
        #expect(BluetoothUUID.csr3.rawValue == "FEF2")
        #expect(BluetoothUUID.csr3 == .bit16(0xFEF2))
        #expect(BluetoothUUID.csr3 == .bit16(65266))
        #expect(BluetoothUUID.csr3.name == "CSR")
        #expect(BluetoothUUID.csr3 != .bit32(65266))
        #expect(BluetoothUUID.csr3 != .bit32(0xFEF2))

        /// Google Inc.
        #expect(BluetoothUUID.google13.rawValue == "FEF3")
        #expect(BluetoothUUID.google13 == .bit16(0xFEF3))
        #expect(BluetoothUUID.google13 == .bit16(65267))
        #expect(BluetoothUUID.google13.name == "Google Inc.")
        #expect(BluetoothUUID.google13 != .bit32(65267))
        #expect(BluetoothUUID.google13 != .bit32(0xFEF3))

        /// Google Inc.
        #expect(BluetoothUUID.google14.rawValue == "FEF4")
        #expect(BluetoothUUID.google14 == .bit16(0xFEF4))
        #expect(BluetoothUUID.google14 == .bit16(65268))
        #expect(BluetoothUUID.google14.name == "Google Inc.")
        #expect(BluetoothUUID.google14 != .bit32(65268))
        #expect(BluetoothUUID.google14 != .bit32(0xFEF4))

        /// Dialog Semiconductor GmbH
        #expect(BluetoothUUID.dialogSemiconductor2.rawValue == "FEF5")
        #expect(BluetoothUUID.dialogSemiconductor2 == .bit16(0xFEF5))
        #expect(BluetoothUUID.dialogSemiconductor2 == .bit16(65269))
        #expect(BluetoothUUID.dialogSemiconductor2.name == "Dialog Semiconductor GmbH")
        #expect(BluetoothUUID.dialogSemiconductor2 != .bit32(65269))
        #expect(BluetoothUUID.dialogSemiconductor2 != .bit32(0xFEF5))

        /// Wicentric, Inc.
        #expect(BluetoothUUID.wicentric.rawValue == "FEF6")
        #expect(BluetoothUUID.wicentric == .bit16(0xFEF6))
        #expect(BluetoothUUID.wicentric == .bit16(65270))
        #expect(BluetoothUUID.wicentric.name == "Wicentric, Inc.")
        #expect(BluetoothUUID.wicentric != .bit32(65270))
        #expect(BluetoothUUID.wicentric != .bit32(0xFEF6))

        /// Aplix Corporation
        #expect(BluetoothUUID.aplix.rawValue == "FEF7")
        #expect(BluetoothUUID.aplix == .bit16(0xFEF7))
        #expect(BluetoothUUID.aplix == .bit16(65271))
        #expect(BluetoothUUID.aplix.name == "Aplix Corporation")
        #expect(BluetoothUUID.aplix != .bit32(65271))
        #expect(BluetoothUUID.aplix != .bit32(0xFEF7))

        /// Aplix Corporation
        #expect(BluetoothUUID.aplix2.rawValue == "FEF8")
        #expect(BluetoothUUID.aplix2 == .bit16(0xFEF8))
        #expect(BluetoothUUID.aplix2 == .bit16(65272))
        #expect(BluetoothUUID.aplix2.name == "Aplix Corporation")
        #expect(BluetoothUUID.aplix2 != .bit32(65272))
        #expect(BluetoothUUID.aplix2 != .bit32(0xFEF8))

        /// PayPal, Inc.
        #expect(BluetoothUUID.paypal.rawValue == "FEF9")
        #expect(BluetoothUUID.paypal == .bit16(0xFEF9))
        #expect(BluetoothUUID.paypal == .bit16(65273))
        #expect(BluetoothUUID.paypal.name == "PayPal, Inc.")
        #expect(BluetoothUUID.paypal != .bit32(65273))
        #expect(BluetoothUUID.paypal != .bit32(0xFEF9))

        /// PayPal, Inc.
        #expect(BluetoothUUID.paypal2.rawValue == "FEFA")
        #expect(BluetoothUUID.paypal2 == .bit16(0xFEFA))
        #expect(BluetoothUUID.paypal2 == .bit16(65274))
        #expect(BluetoothUUID.paypal2.name == "PayPal, Inc.")
        #expect(BluetoothUUID.paypal2 != .bit32(65274))
        #expect(BluetoothUUID.paypal2 != .bit32(0xFEFA))

        /// Telit Wireless Solutions
        #expect(BluetoothUUID.telitWirelessSolutions2.rawValue == "FEFB")
        #expect(BluetoothUUID.telitWirelessSolutions2 == .bit16(0xFEFB))
        #expect(BluetoothUUID.telitWirelessSolutions2 == .bit16(65275))
        #expect(BluetoothUUID.telitWirelessSolutions2.name == "Telit Wireless Solutions")
        #expect(BluetoothUUID.telitWirelessSolutions2 != .bit32(65275))
        #expect(BluetoothUUID.telitWirelessSolutions2 != .bit32(0xFEFB))

        /// Gimbal, Inc.
        #expect(BluetoothUUID.gimbal.rawValue == "FEFC")
        #expect(BluetoothUUID.gimbal == .bit16(0xFEFC))
        #expect(BluetoothUUID.gimbal == .bit16(65276))
        #expect(BluetoothUUID.gimbal.name == "Gimbal, Inc.")
        #expect(BluetoothUUID.gimbal != .bit32(65276))
        #expect(BluetoothUUID.gimbal != .bit32(0xFEFC))

        /// Gimbal, Inc.
        #expect(BluetoothUUID.gimbal2.rawValue == "FEFD")
        #expect(BluetoothUUID.gimbal2 == .bit16(0xFEFD))
        #expect(BluetoothUUID.gimbal2 == .bit16(65277))
        #expect(BluetoothUUID.gimbal2.name == "Gimbal, Inc.")
        #expect(BluetoothUUID.gimbal2 != .bit32(65277))
        #expect(BluetoothUUID.gimbal2 != .bit32(0xFEFD))

        /// GN ReSound A/S
        #expect(BluetoothUUID.gnResound.rawValue == "FEFE")
        #expect(BluetoothUUID.gnResound == .bit16(0xFEFE))
        #expect(BluetoothUUID.gnResound == .bit16(65278))
        #expect(BluetoothUUID.gnResound.name == "GN ReSound A/S")
        #expect(BluetoothUUID.gnResound != .bit32(65278))
        #expect(BluetoothUUID.gnResound != .bit32(0xFEFE))

        /// GN Netcom
        #expect(BluetoothUUID.gnNetcom.rawValue == "FEFF")
        #expect(BluetoothUUID.gnNetcom == .bit16(0xFEFF))
        #expect(BluetoothUUID.gnNetcom == .bit16(65279))
        #expect(BluetoothUUID.gnNetcom.name == "GN Netcom")
        #expect(BluetoothUUID.gnNetcom != .bit32(65279))
        #expect(BluetoothUUID.gnNetcom != .bit32(0xFEFF))

        /// Fast IDentity Online Alliance (FIDO)
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido.rawValue == "FFFD")
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido == .bit16(0xFFFD))
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido == .bit16(65533))
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido.name == "Fast IDentity Online Alliance (FIDO)")
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido != .bit32(65533))
        #expect(BluetoothUUID.fastIdentityOnlineAllianceFido != .bit32(0xFFFD))

        /// Alliance for Wireless Power (A4WP)
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp.rawValue == "FFFE")
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp == .bit16(0xFFFE))
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp == .bit16(65534))
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp.name == "Alliance for Wireless Power (A4WP)")
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp != .bit32(65534))
        #expect(BluetoothUUID.allianceForWirelessPowerA4Wp != .bit32(0xFFFE))

    }

}
#endif
// swiftlint:enable type_body_length
