//
//  DefinedUUIDTests.swift
//  Bluetooth
//
//  Generated by Alsey Coleman Miller on 5/29/20.
//

import XCTest
import Foundation
@testable import Bluetooth

// swiftlint:disable type_body_length
final class DefinedUUIDTests: XCTestCase {

    static let allTests = [
        ("testDefinedUUID", testDefinedUUID)
    ]

    func testDefinedUUID() {

        /// SDP
        XCTAssertEqual(BluetoothUUID.sdp.rawValue, "0001")
        XCTAssertEqual(BluetoothUUID.sdp, .bit16(0x0001))
        XCTAssertEqual(BluetoothUUID.sdp, .bit16(1))
        XCTAssertEqual(BluetoothUUID.sdp.name, "SDP")
        XCTAssertNotEqual(BluetoothUUID.sdp, .bit32(1))
        XCTAssertNotEqual(BluetoothUUID.sdp, .bit32(0x0001))

        /// RFCOMM
        XCTAssertEqual(BluetoothUUID.rfcomm.rawValue, "0003")
        XCTAssertEqual(BluetoothUUID.rfcomm, .bit16(0x0003))
        XCTAssertEqual(BluetoothUUID.rfcomm, .bit16(3))
        XCTAssertEqual(BluetoothUUID.rfcomm.name, "RFCOMM")
        XCTAssertNotEqual(BluetoothUUID.rfcomm, .bit32(3))
        XCTAssertNotEqual(BluetoothUUID.rfcomm, .bit32(0x0003))

        /// TCS-BIN
        XCTAssertEqual(BluetoothUUID.tcsBin.rawValue, "0005")
        XCTAssertEqual(BluetoothUUID.tcsBin, .bit16(0x0005))
        XCTAssertEqual(BluetoothUUID.tcsBin, .bit16(5))
        XCTAssertEqual(BluetoothUUID.tcsBin.name, "TCS-BIN")
        XCTAssertNotEqual(BluetoothUUID.tcsBin, .bit32(5))
        XCTAssertNotEqual(BluetoothUUID.tcsBin, .bit32(0x0005))

        /// ATT
        XCTAssertEqual(BluetoothUUID.att.rawValue, "0007")
        XCTAssertEqual(BluetoothUUID.att, .bit16(0x0007))
        XCTAssertEqual(BluetoothUUID.att, .bit16(7))
        XCTAssertEqual(BluetoothUUID.att.name, "ATT")
        XCTAssertNotEqual(BluetoothUUID.att, .bit32(7))
        XCTAssertNotEqual(BluetoothUUID.att, .bit32(0x0007))

        /// OBEX
        XCTAssertEqual(BluetoothUUID.obex.rawValue, "0008")
        XCTAssertEqual(BluetoothUUID.obex, .bit16(0x0008))
        XCTAssertEqual(BluetoothUUID.obex, .bit16(8))
        XCTAssertEqual(BluetoothUUID.obex.name, "OBEX")
        XCTAssertNotEqual(BluetoothUUID.obex, .bit32(8))
        XCTAssertNotEqual(BluetoothUUID.obex, .bit32(0x0008))

        /// BNEP
        XCTAssertEqual(BluetoothUUID.bnep.rawValue, "000F")
        XCTAssertEqual(BluetoothUUID.bnep, .bit16(0x000F))
        XCTAssertEqual(BluetoothUUID.bnep, .bit16(15))
        XCTAssertEqual(BluetoothUUID.bnep.name, "BNEP")
        XCTAssertNotEqual(BluetoothUUID.bnep, .bit32(15))
        XCTAssertNotEqual(BluetoothUUID.bnep, .bit32(0x000F))

        /// UPNP
        XCTAssertEqual(BluetoothUUID.upnp.rawValue, "0010")
        XCTAssertEqual(BluetoothUUID.upnp, .bit16(0x0010))
        XCTAssertEqual(BluetoothUUID.upnp, .bit16(16))
        XCTAssertEqual(BluetoothUUID.upnp.name, "UPNP")
        XCTAssertNotEqual(BluetoothUUID.upnp, .bit32(16))
        XCTAssertNotEqual(BluetoothUUID.upnp, .bit32(0x0010))

        /// HIDP
        XCTAssertEqual(BluetoothUUID.hidp.rawValue, "0011")
        XCTAssertEqual(BluetoothUUID.hidp, .bit16(0x0011))
        XCTAssertEqual(BluetoothUUID.hidp, .bit16(17))
        XCTAssertEqual(BluetoothUUID.hidp.name, "HIDP")
        XCTAssertNotEqual(BluetoothUUID.hidp, .bit32(17))
        XCTAssertNotEqual(BluetoothUUID.hidp, .bit32(0x0011))

        /// Hardcopy Control Channel
        XCTAssertEqual(BluetoothUUID.hardcopyControlChannel.rawValue, "0012")
        XCTAssertEqual(BluetoothUUID.hardcopyControlChannel, .bit16(0x0012))
        XCTAssertEqual(BluetoothUUID.hardcopyControlChannel, .bit16(18))
        XCTAssertEqual(BluetoothUUID.hardcopyControlChannel.name, "Hardcopy Control Channel")
        XCTAssertNotEqual(BluetoothUUID.hardcopyControlChannel, .bit32(18))
        XCTAssertNotEqual(BluetoothUUID.hardcopyControlChannel, .bit32(0x0012))

        /// Hardcopy Data Channel
        XCTAssertEqual(BluetoothUUID.hardcopyDataChannel.rawValue, "0014")
        XCTAssertEqual(BluetoothUUID.hardcopyDataChannel, .bit16(0x0014))
        XCTAssertEqual(BluetoothUUID.hardcopyDataChannel, .bit16(20))
        XCTAssertEqual(BluetoothUUID.hardcopyDataChannel.name, "Hardcopy Data Channel")
        XCTAssertNotEqual(BluetoothUUID.hardcopyDataChannel, .bit32(20))
        XCTAssertNotEqual(BluetoothUUID.hardcopyDataChannel, .bit32(0x0014))

        /// Hardcopy Notification
        XCTAssertEqual(BluetoothUUID.hardcopyNotification.rawValue, "0016")
        XCTAssertEqual(BluetoothUUID.hardcopyNotification, .bit16(0x0016))
        XCTAssertEqual(BluetoothUUID.hardcopyNotification, .bit16(22))
        XCTAssertEqual(BluetoothUUID.hardcopyNotification.name, "Hardcopy Notification")
        XCTAssertNotEqual(BluetoothUUID.hardcopyNotification, .bit32(22))
        XCTAssertNotEqual(BluetoothUUID.hardcopyNotification, .bit32(0x0016))

        /// AVCTP
        XCTAssertEqual(BluetoothUUID.avctp.rawValue, "0017")
        XCTAssertEqual(BluetoothUUID.avctp, .bit16(0x0017))
        XCTAssertEqual(BluetoothUUID.avctp, .bit16(23))
        XCTAssertEqual(BluetoothUUID.avctp.name, "AVCTP")
        XCTAssertNotEqual(BluetoothUUID.avctp, .bit32(23))
        XCTAssertNotEqual(BluetoothUUID.avctp, .bit32(0x0017))

        /// AVDTP
        XCTAssertEqual(BluetoothUUID.avdtp.rawValue, "0019")
        XCTAssertEqual(BluetoothUUID.avdtp, .bit16(0x0019))
        XCTAssertEqual(BluetoothUUID.avdtp, .bit16(25))
        XCTAssertEqual(BluetoothUUID.avdtp.name, "AVDTP")
        XCTAssertNotEqual(BluetoothUUID.avdtp, .bit32(25))
        XCTAssertNotEqual(BluetoothUUID.avdtp, .bit32(0x0019))

        /// CMTP
        XCTAssertEqual(BluetoothUUID.cmtp.rawValue, "001B")
        XCTAssertEqual(BluetoothUUID.cmtp, .bit16(0x001B))
        XCTAssertEqual(BluetoothUUID.cmtp, .bit16(27))
        XCTAssertEqual(BluetoothUUID.cmtp.name, "CMTP")
        XCTAssertNotEqual(BluetoothUUID.cmtp, .bit32(27))
        XCTAssertNotEqual(BluetoothUUID.cmtp, .bit32(0x001B))

        /// MCAP Control Channel
        XCTAssertEqual(BluetoothUUID.mcapControlChannel.rawValue, "001E")
        XCTAssertEqual(BluetoothUUID.mcapControlChannel, .bit16(0x001E))
        XCTAssertEqual(BluetoothUUID.mcapControlChannel, .bit16(30))
        XCTAssertEqual(BluetoothUUID.mcapControlChannel.name, "MCAP Control Channel")
        XCTAssertNotEqual(BluetoothUUID.mcapControlChannel, .bit32(30))
        XCTAssertNotEqual(BluetoothUUID.mcapControlChannel, .bit32(0x001E))

        /// MCAP Data Channel
        XCTAssertEqual(BluetoothUUID.mcapDataChannel.rawValue, "001F")
        XCTAssertEqual(BluetoothUUID.mcapDataChannel, .bit16(0x001F))
        XCTAssertEqual(BluetoothUUID.mcapDataChannel, .bit16(31))
        XCTAssertEqual(BluetoothUUID.mcapDataChannel.name, "MCAP Data Channel")
        XCTAssertNotEqual(BluetoothUUID.mcapDataChannel, .bit32(31))
        XCTAssertNotEqual(BluetoothUUID.mcapDataChannel, .bit32(0x001F))

        /// L2CAP
        XCTAssertEqual(BluetoothUUID.l2Cap.rawValue, "0100")
        XCTAssertEqual(BluetoothUUID.l2Cap, .bit16(0x0100))
        XCTAssertEqual(BluetoothUUID.l2Cap, .bit16(256))
        XCTAssertEqual(BluetoothUUID.l2Cap.name, "L2CAP")
        XCTAssertNotEqual(BluetoothUUID.l2Cap, .bit32(256))
        XCTAssertNotEqual(BluetoothUUID.l2Cap, .bit32(0x0100))

        /// Service Discovery Server Service Class
        XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass.rawValue, "1000")
        XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit16(0x1000))
        XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit16(4096))
        XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass.name, "Service Discovery Server Service Class")
        XCTAssertNotEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit32(4096))
        XCTAssertNotEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit32(0x1000))

        /// Browse Group Descriptor Service Class
        XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass.rawValue, "1001")
        XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit16(0x1001))
        XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit16(4097))
        XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass.name, "Browse Group Descriptor Service Class")
        XCTAssertNotEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit32(4097))
        XCTAssertNotEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit32(0x1001))

        /// Public Browse Root
        XCTAssertEqual(BluetoothUUID.publicBrowseRoot.rawValue, "1002")
        XCTAssertEqual(BluetoothUUID.publicBrowseRoot, .bit16(0x1002))
        XCTAssertEqual(BluetoothUUID.publicBrowseRoot, .bit16(4098))
        XCTAssertEqual(BluetoothUUID.publicBrowseRoot.name, "Public Browse Root")
        XCTAssertNotEqual(BluetoothUUID.publicBrowseRoot, .bit32(4098))
        XCTAssertNotEqual(BluetoothUUID.publicBrowseRoot, .bit32(0x1002))

        /// Serial Port
        XCTAssertEqual(BluetoothUUID.serialPort.rawValue, "1101")
        XCTAssertEqual(BluetoothUUID.serialPort, .bit16(0x1101))
        XCTAssertEqual(BluetoothUUID.serialPort, .bit16(4353))
        XCTAssertEqual(BluetoothUUID.serialPort.name, "Serial Port")
        XCTAssertNotEqual(BluetoothUUID.serialPort, .bit32(4353))
        XCTAssertNotEqual(BluetoothUUID.serialPort, .bit32(0x1101))

        /// LAN Access Using PPP
        XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp.rawValue, "1102")
        XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp, .bit16(0x1102))
        XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp, .bit16(4354))
        XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp.name, "LAN Access Using PPP")
        XCTAssertNotEqual(BluetoothUUID.lanAccessUsingPpp, .bit32(4354))
        XCTAssertNotEqual(BluetoothUUID.lanAccessUsingPpp, .bit32(0x1102))

        /// Dialup Networking
        XCTAssertEqual(BluetoothUUID.dialupNetworking.rawValue, "1103")
        XCTAssertEqual(BluetoothUUID.dialupNetworking, .bit16(0x1103))
        XCTAssertEqual(BluetoothUUID.dialupNetworking, .bit16(4355))
        XCTAssertEqual(BluetoothUUID.dialupNetworking.name, "Dialup Networking")
        XCTAssertNotEqual(BluetoothUUID.dialupNetworking, .bit32(4355))
        XCTAssertNotEqual(BluetoothUUID.dialupNetworking, .bit32(0x1103))

        /// IrMC Sync
        XCTAssertEqual(BluetoothUUID.irmcSync.rawValue, "1104")
        XCTAssertEqual(BluetoothUUID.irmcSync, .bit16(0x1104))
        XCTAssertEqual(BluetoothUUID.irmcSync, .bit16(4356))
        XCTAssertEqual(BluetoothUUID.irmcSync.name, "IrMC Sync")
        XCTAssertNotEqual(BluetoothUUID.irmcSync, .bit32(4356))
        XCTAssertNotEqual(BluetoothUUID.irmcSync, .bit32(0x1104))

        /// OBEX Object Push
        XCTAssertEqual(BluetoothUUID.obexObjectPush.rawValue, "1105")
        XCTAssertEqual(BluetoothUUID.obexObjectPush, .bit16(0x1105))
        XCTAssertEqual(BluetoothUUID.obexObjectPush, .bit16(4357))
        XCTAssertEqual(BluetoothUUID.obexObjectPush.name, "OBEX Object Push")
        XCTAssertNotEqual(BluetoothUUID.obexObjectPush, .bit32(4357))
        XCTAssertNotEqual(BluetoothUUID.obexObjectPush, .bit32(0x1105))

        /// OBEX File Transfer
        XCTAssertEqual(BluetoothUUID.obexFileTransfer.rawValue, "1106")
        XCTAssertEqual(BluetoothUUID.obexFileTransfer, .bit16(0x1106))
        XCTAssertEqual(BluetoothUUID.obexFileTransfer, .bit16(4358))
        XCTAssertEqual(BluetoothUUID.obexFileTransfer.name, "OBEX File Transfer")
        XCTAssertNotEqual(BluetoothUUID.obexFileTransfer, .bit32(4358))
        XCTAssertNotEqual(BluetoothUUID.obexFileTransfer, .bit32(0x1106))

        /// IrMC Sync Command
        XCTAssertEqual(BluetoothUUID.irmcSyncCommand.rawValue, "1107")
        XCTAssertEqual(BluetoothUUID.irmcSyncCommand, .bit16(0x1107))
        XCTAssertEqual(BluetoothUUID.irmcSyncCommand, .bit16(4359))
        XCTAssertEqual(BluetoothUUID.irmcSyncCommand.name, "IrMC Sync Command")
        XCTAssertNotEqual(BluetoothUUID.irmcSyncCommand, .bit32(4359))
        XCTAssertNotEqual(BluetoothUUID.irmcSyncCommand, .bit32(0x1107))

        /// Headset
        XCTAssertEqual(BluetoothUUID.headset.rawValue, "1108")
        XCTAssertEqual(BluetoothUUID.headset, .bit16(0x1108))
        XCTAssertEqual(BluetoothUUID.headset, .bit16(4360))
        XCTAssertEqual(BluetoothUUID.headset.name, "Headset")
        XCTAssertNotEqual(BluetoothUUID.headset, .bit32(4360))
        XCTAssertNotEqual(BluetoothUUID.headset, .bit32(0x1108))

        /// Cordless Telephony
        XCTAssertEqual(BluetoothUUID.cordlessTelephony.rawValue, "1109")
        XCTAssertEqual(BluetoothUUID.cordlessTelephony, .bit16(0x1109))
        XCTAssertEqual(BluetoothUUID.cordlessTelephony, .bit16(4361))
        XCTAssertEqual(BluetoothUUID.cordlessTelephony.name, "Cordless Telephony")
        XCTAssertNotEqual(BluetoothUUID.cordlessTelephony, .bit32(4361))
        XCTAssertNotEqual(BluetoothUUID.cordlessTelephony, .bit32(0x1109))

        /// Audio Source
        XCTAssertEqual(BluetoothUUID.audioSource.rawValue, "110A")
        XCTAssertEqual(BluetoothUUID.audioSource, .bit16(0x110A))
        XCTAssertEqual(BluetoothUUID.audioSource, .bit16(4362))
        XCTAssertEqual(BluetoothUUID.audioSource.name, "Audio Source")
        XCTAssertNotEqual(BluetoothUUID.audioSource, .bit32(4362))
        XCTAssertNotEqual(BluetoothUUID.audioSource, .bit32(0x110A))

        /// Audio Sink
        XCTAssertEqual(BluetoothUUID.audioSink.rawValue, "110B")
        XCTAssertEqual(BluetoothUUID.audioSink, .bit16(0x110B))
        XCTAssertEqual(BluetoothUUID.audioSink, .bit16(4363))
        XCTAssertEqual(BluetoothUUID.audioSink.name, "Audio Sink")
        XCTAssertNotEqual(BluetoothUUID.audioSink, .bit32(4363))
        XCTAssertNotEqual(BluetoothUUID.audioSink, .bit32(0x110B))

        /// A/V Remote Control Target
        XCTAssertEqual(BluetoothUUID.avRemoteControlTarget.rawValue, "110C")
        XCTAssertEqual(BluetoothUUID.avRemoteControlTarget, .bit16(0x110C))
        XCTAssertEqual(BluetoothUUID.avRemoteControlTarget, .bit16(4364))
        XCTAssertEqual(BluetoothUUID.avRemoteControlTarget.name, "A/V Remote Control Target")
        XCTAssertNotEqual(BluetoothUUID.avRemoteControlTarget, .bit32(4364))
        XCTAssertNotEqual(BluetoothUUID.avRemoteControlTarget, .bit32(0x110C))

        /// Advanced Audio Distribution
        XCTAssertEqual(BluetoothUUID.advancedAudioDistribution.rawValue, "110D")
        XCTAssertEqual(BluetoothUUID.advancedAudioDistribution, .bit16(0x110D))
        XCTAssertEqual(BluetoothUUID.advancedAudioDistribution, .bit16(4365))
        XCTAssertEqual(BluetoothUUID.advancedAudioDistribution.name, "Advanced Audio Distribution")
        XCTAssertNotEqual(BluetoothUUID.advancedAudioDistribution, .bit32(4365))
        XCTAssertNotEqual(BluetoothUUID.advancedAudioDistribution, .bit32(0x110D))

        /// A/V Remote Control
        XCTAssertEqual(BluetoothUUID.avRemoteControl.rawValue, "110E")
        XCTAssertEqual(BluetoothUUID.avRemoteControl, .bit16(0x110E))
        XCTAssertEqual(BluetoothUUID.avRemoteControl, .bit16(4366))
        XCTAssertEqual(BluetoothUUID.avRemoteControl.name, "A/V Remote Control")
        XCTAssertNotEqual(BluetoothUUID.avRemoteControl, .bit32(4366))
        XCTAssertNotEqual(BluetoothUUID.avRemoteControl, .bit32(0x110E))

        /// A/V Remote Control Controller
        XCTAssertEqual(BluetoothUUID.avRemoteControlController.rawValue, "110F")
        XCTAssertEqual(BluetoothUUID.avRemoteControlController, .bit16(0x110F))
        XCTAssertEqual(BluetoothUUID.avRemoteControlController, .bit16(4367))
        XCTAssertEqual(BluetoothUUID.avRemoteControlController.name, "A/V Remote Control Controller")
        XCTAssertNotEqual(BluetoothUUID.avRemoteControlController, .bit32(4367))
        XCTAssertNotEqual(BluetoothUUID.avRemoteControlController, .bit32(0x110F))

        /// Intercom
        XCTAssertEqual(BluetoothUUID.intercom.rawValue, "1110")
        XCTAssertEqual(BluetoothUUID.intercom, .bit16(0x1110))
        XCTAssertEqual(BluetoothUUID.intercom, .bit16(4368))
        XCTAssertEqual(BluetoothUUID.intercom.name, "Intercom")
        XCTAssertNotEqual(BluetoothUUID.intercom, .bit32(4368))
        XCTAssertNotEqual(BluetoothUUID.intercom, .bit32(0x1110))

        /// Fax
        XCTAssertEqual(BluetoothUUID.fax.rawValue, "1111")
        XCTAssertEqual(BluetoothUUID.fax, .bit16(0x1111))
        XCTAssertEqual(BluetoothUUID.fax, .bit16(4369))
        XCTAssertEqual(BluetoothUUID.fax.name, "Fax")
        XCTAssertNotEqual(BluetoothUUID.fax, .bit32(4369))
        XCTAssertNotEqual(BluetoothUUID.fax, .bit32(0x1111))

        /// Headset AG
        XCTAssertEqual(BluetoothUUID.headset2.rawValue, "1112")
        XCTAssertEqual(BluetoothUUID.headset2, .bit16(0x1112))
        XCTAssertEqual(BluetoothUUID.headset2, .bit16(4370))
        XCTAssertEqual(BluetoothUUID.headset2.name, "Headset AG")
        XCTAssertNotEqual(BluetoothUUID.headset2, .bit32(4370))
        XCTAssertNotEqual(BluetoothUUID.headset2, .bit32(0x1112))

        /// WAP
        XCTAssertEqual(BluetoothUUID.wap.rawValue, "1113")
        XCTAssertEqual(BluetoothUUID.wap, .bit16(0x1113))
        XCTAssertEqual(BluetoothUUID.wap, .bit16(4371))
        XCTAssertEqual(BluetoothUUID.wap.name, "WAP")
        XCTAssertNotEqual(BluetoothUUID.wap, .bit32(4371))
        XCTAssertNotEqual(BluetoothUUID.wap, .bit32(0x1113))

        /// WAP Client
        XCTAssertEqual(BluetoothUUID.wapClient.rawValue, "1114")
        XCTAssertEqual(BluetoothUUID.wapClient, .bit16(0x1114))
        XCTAssertEqual(BluetoothUUID.wapClient, .bit16(4372))
        XCTAssertEqual(BluetoothUUID.wapClient.name, "WAP Client")
        XCTAssertNotEqual(BluetoothUUID.wapClient, .bit32(4372))
        XCTAssertNotEqual(BluetoothUUID.wapClient, .bit32(0x1114))

        /// PANU
        XCTAssertEqual(BluetoothUUID.panu.rawValue, "1115")
        XCTAssertEqual(BluetoothUUID.panu, .bit16(0x1115))
        XCTAssertEqual(BluetoothUUID.panu, .bit16(4373))
        XCTAssertEqual(BluetoothUUID.panu.name, "PANU")
        XCTAssertNotEqual(BluetoothUUID.panu, .bit32(4373))
        XCTAssertNotEqual(BluetoothUUID.panu, .bit32(0x1115))

        /// NAP
        XCTAssertEqual(BluetoothUUID.nap.rawValue, "1116")
        XCTAssertEqual(BluetoothUUID.nap, .bit16(0x1116))
        XCTAssertEqual(BluetoothUUID.nap, .bit16(4374))
        XCTAssertEqual(BluetoothUUID.nap.name, "NAP")
        XCTAssertNotEqual(BluetoothUUID.nap, .bit32(4374))
        XCTAssertNotEqual(BluetoothUUID.nap, .bit32(0x1116))

        /// GN
        XCTAssertEqual(BluetoothUUID.gn.rawValue, "1117")
        XCTAssertEqual(BluetoothUUID.gn, .bit16(0x1117))
        XCTAssertEqual(BluetoothUUID.gn, .bit16(4375))
        XCTAssertEqual(BluetoothUUID.gn.name, "GN")
        XCTAssertNotEqual(BluetoothUUID.gn, .bit32(4375))
        XCTAssertNotEqual(BluetoothUUID.gn, .bit32(0x1117))

        /// Direct Printing
        XCTAssertEqual(BluetoothUUID.directPrinting.rawValue, "1118")
        XCTAssertEqual(BluetoothUUID.directPrinting, .bit16(0x1118))
        XCTAssertEqual(BluetoothUUID.directPrinting, .bit16(4376))
        XCTAssertEqual(BluetoothUUID.directPrinting.name, "Direct Printing")
        XCTAssertNotEqual(BluetoothUUID.directPrinting, .bit32(4376))
        XCTAssertNotEqual(BluetoothUUID.directPrinting, .bit32(0x1118))

        /// Reference Printing
        XCTAssertEqual(BluetoothUUID.referencePrinting.rawValue, "1119")
        XCTAssertEqual(BluetoothUUID.referencePrinting, .bit16(0x1119))
        XCTAssertEqual(BluetoothUUID.referencePrinting, .bit16(4377))
        XCTAssertEqual(BluetoothUUID.referencePrinting.name, "Reference Printing")
        XCTAssertNotEqual(BluetoothUUID.referencePrinting, .bit32(4377))
        XCTAssertNotEqual(BluetoothUUID.referencePrinting, .bit32(0x1119))

        /// Basic Imaging Profile
        XCTAssertEqual(BluetoothUUID.basicImagingProfile.rawValue, "111A")
        XCTAssertEqual(BluetoothUUID.basicImagingProfile, .bit16(0x111A))
        XCTAssertEqual(BluetoothUUID.basicImagingProfile, .bit16(4378))
        XCTAssertEqual(BluetoothUUID.basicImagingProfile.name, "Basic Imaging Profile")
        XCTAssertNotEqual(BluetoothUUID.basicImagingProfile, .bit32(4378))
        XCTAssertNotEqual(BluetoothUUID.basicImagingProfile, .bit32(0x111A))

        /// Imaging Responder
        XCTAssertEqual(BluetoothUUID.imagingResponder.rawValue, "111B")
        XCTAssertEqual(BluetoothUUID.imagingResponder, .bit16(0x111B))
        XCTAssertEqual(BluetoothUUID.imagingResponder, .bit16(4379))
        XCTAssertEqual(BluetoothUUID.imagingResponder.name, "Imaging Responder")
        XCTAssertNotEqual(BluetoothUUID.imagingResponder, .bit32(4379))
        XCTAssertNotEqual(BluetoothUUID.imagingResponder, .bit32(0x111B))

        /// Imaging Automatic Archive
        XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive.rawValue, "111C")
        XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive, .bit16(0x111C))
        XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive, .bit16(4380))
        XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive.name, "Imaging Automatic Archive")
        XCTAssertNotEqual(BluetoothUUID.imagingAutomaticArchive, .bit32(4380))
        XCTAssertNotEqual(BluetoothUUID.imagingAutomaticArchive, .bit32(0x111C))

        /// Imaging Referenced Objects
        XCTAssertEqual(BluetoothUUID.imagingReferencedObjects.rawValue, "111D")
        XCTAssertEqual(BluetoothUUID.imagingReferencedObjects, .bit16(0x111D))
        XCTAssertEqual(BluetoothUUID.imagingReferencedObjects, .bit16(4381))
        XCTAssertEqual(BluetoothUUID.imagingReferencedObjects.name, "Imaging Referenced Objects")
        XCTAssertNotEqual(BluetoothUUID.imagingReferencedObjects, .bit32(4381))
        XCTAssertNotEqual(BluetoothUUID.imagingReferencedObjects, .bit32(0x111D))

        /// Handsfree
        XCTAssertEqual(BluetoothUUID.handsfree.rawValue, "111E")
        XCTAssertEqual(BluetoothUUID.handsfree, .bit16(0x111E))
        XCTAssertEqual(BluetoothUUID.handsfree, .bit16(4382))
        XCTAssertEqual(BluetoothUUID.handsfree.name, "Handsfree")
        XCTAssertNotEqual(BluetoothUUID.handsfree, .bit32(4382))
        XCTAssertNotEqual(BluetoothUUID.handsfree, .bit32(0x111E))

        /// Handsfree Audio Gateway
        XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway.rawValue, "111F")
        XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway, .bit16(0x111F))
        XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway, .bit16(4383))
        XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway.name, "Handsfree Audio Gateway")
        XCTAssertNotEqual(BluetoothUUID.handsfreeAudioGateway, .bit32(4383))
        XCTAssertNotEqual(BluetoothUUID.handsfreeAudioGateway, .bit32(0x111F))

        /// Direct Printing Refrence Objects Service
        XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService.rawValue, "1120")
        XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit16(0x1120))
        XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit16(4384))
        XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService.name, "Direct Printing Refrence Objects Service")
        XCTAssertNotEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit32(4384))
        XCTAssertNotEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit32(0x1120))

        /// Reflected UI
        XCTAssertEqual(BluetoothUUID.reflectedUi.rawValue, "1121")
        XCTAssertEqual(BluetoothUUID.reflectedUi, .bit16(0x1121))
        XCTAssertEqual(BluetoothUUID.reflectedUi, .bit16(4385))
        XCTAssertEqual(BluetoothUUID.reflectedUi.name, "Reflected UI")
        XCTAssertNotEqual(BluetoothUUID.reflectedUi, .bit32(4385))
        XCTAssertNotEqual(BluetoothUUID.reflectedUi, .bit32(0x1121))

        /// Basic Printing
        XCTAssertEqual(BluetoothUUID.basicPrinting.rawValue, "1122")
        XCTAssertEqual(BluetoothUUID.basicPrinting, .bit16(0x1122))
        XCTAssertEqual(BluetoothUUID.basicPrinting, .bit16(4386))
        XCTAssertEqual(BluetoothUUID.basicPrinting.name, "Basic Printing")
        XCTAssertNotEqual(BluetoothUUID.basicPrinting, .bit32(4386))
        XCTAssertNotEqual(BluetoothUUID.basicPrinting, .bit32(0x1122))

        /// Printing Status
        XCTAssertEqual(BluetoothUUID.printingStatus.rawValue, "1123")
        XCTAssertEqual(BluetoothUUID.printingStatus, .bit16(0x1123))
        XCTAssertEqual(BluetoothUUID.printingStatus, .bit16(4387))
        XCTAssertEqual(BluetoothUUID.printingStatus.name, "Printing Status")
        XCTAssertNotEqual(BluetoothUUID.printingStatus, .bit32(4387))
        XCTAssertNotEqual(BluetoothUUID.printingStatus, .bit32(0x1123))

        /// Human Interface Device Service
        XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService.rawValue, "1124")
        XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService, .bit16(0x1124))
        XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService, .bit16(4388))
        XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService.name, "Human Interface Device Service")
        XCTAssertNotEqual(BluetoothUUID.humanInterfaceDeviceService, .bit32(4388))
        XCTAssertNotEqual(BluetoothUUID.humanInterfaceDeviceService, .bit32(0x1124))

        /// Hardcopy Cable Replacement
        XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement.rawValue, "1125")
        XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement, .bit16(0x1125))
        XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement, .bit16(4389))
        XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement.name, "Hardcopy Cable Replacement")
        XCTAssertNotEqual(BluetoothUUID.hardcopyCableReplacement, .bit32(4389))
        XCTAssertNotEqual(BluetoothUUID.hardcopyCableReplacement, .bit32(0x1125))

        /// HCR Print
        XCTAssertEqual(BluetoothUUID.hcrPrint.rawValue, "1126")
        XCTAssertEqual(BluetoothUUID.hcrPrint, .bit16(0x1126))
        XCTAssertEqual(BluetoothUUID.hcrPrint, .bit16(4390))
        XCTAssertEqual(BluetoothUUID.hcrPrint.name, "HCR Print")
        XCTAssertNotEqual(BluetoothUUID.hcrPrint, .bit32(4390))
        XCTAssertNotEqual(BluetoothUUID.hcrPrint, .bit32(0x1126))

        /// HCR Scan
        XCTAssertEqual(BluetoothUUID.hcrScan.rawValue, "1127")
        XCTAssertEqual(BluetoothUUID.hcrScan, .bit16(0x1127))
        XCTAssertEqual(BluetoothUUID.hcrScan, .bit16(4391))
        XCTAssertEqual(BluetoothUUID.hcrScan.name, "HCR Scan")
        XCTAssertNotEqual(BluetoothUUID.hcrScan, .bit32(4391))
        XCTAssertNotEqual(BluetoothUUID.hcrScan, .bit32(0x1127))

        /// Common ISDN Access
        XCTAssertEqual(BluetoothUUID.commonIsdnAccess.rawValue, "1128")
        XCTAssertEqual(BluetoothUUID.commonIsdnAccess, .bit16(0x1128))
        XCTAssertEqual(BluetoothUUID.commonIsdnAccess, .bit16(4392))
        XCTAssertEqual(BluetoothUUID.commonIsdnAccess.name, "Common ISDN Access")
        XCTAssertNotEqual(BluetoothUUID.commonIsdnAccess, .bit32(4392))
        XCTAssertNotEqual(BluetoothUUID.commonIsdnAccess, .bit32(0x1128))

        /// SIM Access
        XCTAssertEqual(BluetoothUUID.simAccess.rawValue, "112D")
        XCTAssertEqual(BluetoothUUID.simAccess, .bit16(0x112D))
        XCTAssertEqual(BluetoothUUID.simAccess, .bit16(4397))
        XCTAssertEqual(BluetoothUUID.simAccess.name, "SIM Access")
        XCTAssertNotEqual(BluetoothUUID.simAccess, .bit32(4397))
        XCTAssertNotEqual(BluetoothUUID.simAccess, .bit32(0x112D))

        /// Phonebook Access Client
        XCTAssertEqual(BluetoothUUID.phonebookAccessClient.rawValue, "112E")
        XCTAssertEqual(BluetoothUUID.phonebookAccessClient, .bit16(0x112E))
        XCTAssertEqual(BluetoothUUID.phonebookAccessClient, .bit16(4398))
        XCTAssertEqual(BluetoothUUID.phonebookAccessClient.name, "Phonebook Access Client")
        XCTAssertNotEqual(BluetoothUUID.phonebookAccessClient, .bit32(4398))
        XCTAssertNotEqual(BluetoothUUID.phonebookAccessClient, .bit32(0x112E))

        /// Phonebook Access Server
        XCTAssertEqual(BluetoothUUID.phonebookAccessServer.rawValue, "112F")
        XCTAssertEqual(BluetoothUUID.phonebookAccessServer, .bit16(0x112F))
        XCTAssertEqual(BluetoothUUID.phonebookAccessServer, .bit16(4399))
        XCTAssertEqual(BluetoothUUID.phonebookAccessServer.name, "Phonebook Access Server")
        XCTAssertNotEqual(BluetoothUUID.phonebookAccessServer, .bit32(4399))
        XCTAssertNotEqual(BluetoothUUID.phonebookAccessServer, .bit32(0x112F))

        /// Phonebook Access
        XCTAssertEqual(BluetoothUUID.phonebookAccess.rawValue, "1130")
        XCTAssertEqual(BluetoothUUID.phonebookAccess, .bit16(0x1130))
        XCTAssertEqual(BluetoothUUID.phonebookAccess, .bit16(4400))
        XCTAssertEqual(BluetoothUUID.phonebookAccess.name, "Phonebook Access")
        XCTAssertNotEqual(BluetoothUUID.phonebookAccess, .bit32(4400))
        XCTAssertNotEqual(BluetoothUUID.phonebookAccess, .bit32(0x1130))

        /// Headset HS
        XCTAssertEqual(BluetoothUUID.headsetHs.rawValue, "1131")
        XCTAssertEqual(BluetoothUUID.headsetHs, .bit16(0x1131))
        XCTAssertEqual(BluetoothUUID.headsetHs, .bit16(4401))
        XCTAssertEqual(BluetoothUUID.headsetHs.name, "Headset HS")
        XCTAssertNotEqual(BluetoothUUID.headsetHs, .bit32(4401))
        XCTAssertNotEqual(BluetoothUUID.headsetHs, .bit32(0x1131))

        /// Message Access Server
        XCTAssertEqual(BluetoothUUID.messageAccessServer.rawValue, "1132")
        XCTAssertEqual(BluetoothUUID.messageAccessServer, .bit16(0x1132))
        XCTAssertEqual(BluetoothUUID.messageAccessServer, .bit16(4402))
        XCTAssertEqual(BluetoothUUID.messageAccessServer.name, "Message Access Server")
        XCTAssertNotEqual(BluetoothUUID.messageAccessServer, .bit32(4402))
        XCTAssertNotEqual(BluetoothUUID.messageAccessServer, .bit32(0x1132))

        /// Message Notification Server
        XCTAssertEqual(BluetoothUUID.messageNotificationServer.rawValue, "1133")
        XCTAssertEqual(BluetoothUUID.messageNotificationServer, .bit16(0x1133))
        XCTAssertEqual(BluetoothUUID.messageNotificationServer, .bit16(4403))
        XCTAssertEqual(BluetoothUUID.messageNotificationServer.name, "Message Notification Server")
        XCTAssertNotEqual(BluetoothUUID.messageNotificationServer, .bit32(4403))
        XCTAssertNotEqual(BluetoothUUID.messageNotificationServer, .bit32(0x1133))

        /// Message Access Profile
        XCTAssertEqual(BluetoothUUID.messageAccessProfile.rawValue, "1134")
        XCTAssertEqual(BluetoothUUID.messageAccessProfile, .bit16(0x1134))
        XCTAssertEqual(BluetoothUUID.messageAccessProfile, .bit16(4404))
        XCTAssertEqual(BluetoothUUID.messageAccessProfile.name, "Message Access Profile")
        XCTAssertNotEqual(BluetoothUUID.messageAccessProfile, .bit32(4404))
        XCTAssertNotEqual(BluetoothUUID.messageAccessProfile, .bit32(0x1134))

        /// GNSS
        XCTAssertEqual(BluetoothUUID.gnss.rawValue, "1135")
        XCTAssertEqual(BluetoothUUID.gnss, .bit16(0x1135))
        XCTAssertEqual(BluetoothUUID.gnss, .bit16(4405))
        XCTAssertEqual(BluetoothUUID.gnss.name, "GNSS")
        XCTAssertNotEqual(BluetoothUUID.gnss, .bit32(4405))
        XCTAssertNotEqual(BluetoothUUID.gnss, .bit32(0x1135))

        /// GNSS Server
        XCTAssertEqual(BluetoothUUID.gnssServer.rawValue, "1136")
        XCTAssertEqual(BluetoothUUID.gnssServer, .bit16(0x1136))
        XCTAssertEqual(BluetoothUUID.gnssServer, .bit16(4406))
        XCTAssertEqual(BluetoothUUID.gnssServer.name, "GNSS Server")
        XCTAssertNotEqual(BluetoothUUID.gnssServer, .bit32(4406))
        XCTAssertNotEqual(BluetoothUUID.gnssServer, .bit32(0x1136))

        /// 3D Display
        XCTAssertEqual(BluetoothUUID.uuid3Ddisplay.rawValue, "1137")
        XCTAssertEqual(BluetoothUUID.uuid3Ddisplay, .bit16(0x1137))
        XCTAssertEqual(BluetoothUUID.uuid3Ddisplay, .bit16(4407))
        XCTAssertEqual(BluetoothUUID.uuid3Ddisplay.name, "3D Display")
        XCTAssertNotEqual(BluetoothUUID.uuid3Ddisplay, .bit32(4407))
        XCTAssertNotEqual(BluetoothUUID.uuid3Ddisplay, .bit32(0x1137))

        /// 3D Glasses
        XCTAssertEqual(BluetoothUUID.uuid3Dglasses.rawValue, "1138")
        XCTAssertEqual(BluetoothUUID.uuid3Dglasses, .bit16(0x1138))
        XCTAssertEqual(BluetoothUUID.uuid3Dglasses, .bit16(4408))
        XCTAssertEqual(BluetoothUUID.uuid3Dglasses.name, "3D Glasses")
        XCTAssertNotEqual(BluetoothUUID.uuid3Dglasses, .bit32(4408))
        XCTAssertNotEqual(BluetoothUUID.uuid3Dglasses, .bit32(0x1138))

        /// 3D Synchronization
        XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization.rawValue, "1139")
        XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization, .bit16(0x1139))
        XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization, .bit16(4409))
        XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization.name, "3D Synchronization")
        XCTAssertNotEqual(BluetoothUUID.uuid3Dsynchronization, .bit32(4409))
        XCTAssertNotEqual(BluetoothUUID.uuid3Dsynchronization, .bit32(0x1139))

        /// MPS Profile
        XCTAssertEqual(BluetoothUUID.mpsProfile.rawValue, "113A")
        XCTAssertEqual(BluetoothUUID.mpsProfile, .bit16(0x113A))
        XCTAssertEqual(BluetoothUUID.mpsProfile, .bit16(4410))
        XCTAssertEqual(BluetoothUUID.mpsProfile.name, "MPS Profile")
        XCTAssertNotEqual(BluetoothUUID.mpsProfile, .bit32(4410))
        XCTAssertNotEqual(BluetoothUUID.mpsProfile, .bit32(0x113A))

        /// MPS Service
        XCTAssertEqual(BluetoothUUID.mpsService.rawValue, "113B")
        XCTAssertEqual(BluetoothUUID.mpsService, .bit16(0x113B))
        XCTAssertEqual(BluetoothUUID.mpsService, .bit16(4411))
        XCTAssertEqual(BluetoothUUID.mpsService.name, "MPS Service")
        XCTAssertNotEqual(BluetoothUUID.mpsService, .bit32(4411))
        XCTAssertNotEqual(BluetoothUUID.mpsService, .bit32(0x113B))

        /// PnP Information
        XCTAssertEqual(BluetoothUUID.pnpInformation.rawValue, "1200")
        XCTAssertEqual(BluetoothUUID.pnpInformation, .bit16(0x1200))
        XCTAssertEqual(BluetoothUUID.pnpInformation, .bit16(4608))
        XCTAssertEqual(BluetoothUUID.pnpInformation.name, "PnP Information")
        XCTAssertNotEqual(BluetoothUUID.pnpInformation, .bit32(4608))
        XCTAssertNotEqual(BluetoothUUID.pnpInformation, .bit32(0x1200))

        /// Generic Networking
        XCTAssertEqual(BluetoothUUID.genericNetworking.rawValue, "1201")
        XCTAssertEqual(BluetoothUUID.genericNetworking, .bit16(0x1201))
        XCTAssertEqual(BluetoothUUID.genericNetworking, .bit16(4609))
        XCTAssertEqual(BluetoothUUID.genericNetworking.name, "Generic Networking")
        XCTAssertNotEqual(BluetoothUUID.genericNetworking, .bit32(4609))
        XCTAssertNotEqual(BluetoothUUID.genericNetworking, .bit32(0x1201))

        /// Generic File Transfer
        XCTAssertEqual(BluetoothUUID.genericFileTransfer.rawValue, "1202")
        XCTAssertEqual(BluetoothUUID.genericFileTransfer, .bit16(0x1202))
        XCTAssertEqual(BluetoothUUID.genericFileTransfer, .bit16(4610))
        XCTAssertEqual(BluetoothUUID.genericFileTransfer.name, "Generic File Transfer")
        XCTAssertNotEqual(BluetoothUUID.genericFileTransfer, .bit32(4610))
        XCTAssertNotEqual(BluetoothUUID.genericFileTransfer, .bit32(0x1202))

        /// Generic Audio
        XCTAssertEqual(BluetoothUUID.genericAudio.rawValue, "1203")
        XCTAssertEqual(BluetoothUUID.genericAudio, .bit16(0x1203))
        XCTAssertEqual(BluetoothUUID.genericAudio, .bit16(4611))
        XCTAssertEqual(BluetoothUUID.genericAudio.name, "Generic Audio")
        XCTAssertNotEqual(BluetoothUUID.genericAudio, .bit32(4611))
        XCTAssertNotEqual(BluetoothUUID.genericAudio, .bit32(0x1203))

        /// Generic Telephony
        XCTAssertEqual(BluetoothUUID.genericTelephony.rawValue, "1204")
        XCTAssertEqual(BluetoothUUID.genericTelephony, .bit16(0x1204))
        XCTAssertEqual(BluetoothUUID.genericTelephony, .bit16(4612))
        XCTAssertEqual(BluetoothUUID.genericTelephony.name, "Generic Telephony")
        XCTAssertNotEqual(BluetoothUUID.genericTelephony, .bit32(4612))
        XCTAssertNotEqual(BluetoothUUID.genericTelephony, .bit32(0x1204))

        /// UPNP Service
        XCTAssertEqual(BluetoothUUID.upnpService.rawValue, "1205")
        XCTAssertEqual(BluetoothUUID.upnpService, .bit16(0x1205))
        XCTAssertEqual(BluetoothUUID.upnpService, .bit16(4613))
        XCTAssertEqual(BluetoothUUID.upnpService.name, "UPNP Service")
        XCTAssertNotEqual(BluetoothUUID.upnpService, .bit32(4613))
        XCTAssertNotEqual(BluetoothUUID.upnpService, .bit32(0x1205))

        /// UPNP IP Service
        XCTAssertEqual(BluetoothUUID.upnpIpService.rawValue, "1206")
        XCTAssertEqual(BluetoothUUID.upnpIpService, .bit16(0x1206))
        XCTAssertEqual(BluetoothUUID.upnpIpService, .bit16(4614))
        XCTAssertEqual(BluetoothUUID.upnpIpService.name, "UPNP IP Service")
        XCTAssertNotEqual(BluetoothUUID.upnpIpService, .bit32(4614))
        XCTAssertNotEqual(BluetoothUUID.upnpIpService, .bit32(0x1206))

        /// UPNP IP PAN
        XCTAssertEqual(BluetoothUUID.upnpIpPan.rawValue, "1300")
        XCTAssertEqual(BluetoothUUID.upnpIpPan, .bit16(0x1300))
        XCTAssertEqual(BluetoothUUID.upnpIpPan, .bit16(4864))
        XCTAssertEqual(BluetoothUUID.upnpIpPan.name, "UPNP IP PAN")
        XCTAssertNotEqual(BluetoothUUID.upnpIpPan, .bit32(4864))
        XCTAssertNotEqual(BluetoothUUID.upnpIpPan, .bit32(0x1300))

        /// UPNP IP LAP
        XCTAssertEqual(BluetoothUUID.upnpIpLap.rawValue, "1301")
        XCTAssertEqual(BluetoothUUID.upnpIpLap, .bit16(0x1301))
        XCTAssertEqual(BluetoothUUID.upnpIpLap, .bit16(4865))
        XCTAssertEqual(BluetoothUUID.upnpIpLap.name, "UPNP IP LAP")
        XCTAssertNotEqual(BluetoothUUID.upnpIpLap, .bit32(4865))
        XCTAssertNotEqual(BluetoothUUID.upnpIpLap, .bit32(0x1301))

        /// UPNP IP L2CAP
        XCTAssertEqual(BluetoothUUID.upnpIpL2Cap.rawValue, "1302")
        XCTAssertEqual(BluetoothUUID.upnpIpL2Cap, .bit16(0x1302))
        XCTAssertEqual(BluetoothUUID.upnpIpL2Cap, .bit16(4866))
        XCTAssertEqual(BluetoothUUID.upnpIpL2Cap.name, "UPNP IP L2CAP")
        XCTAssertNotEqual(BluetoothUUID.upnpIpL2Cap, .bit32(4866))
        XCTAssertNotEqual(BluetoothUUID.upnpIpL2Cap, .bit32(0x1302))

        /// Video Source
        XCTAssertEqual(BluetoothUUID.videoSource.rawValue, "1303")
        XCTAssertEqual(BluetoothUUID.videoSource, .bit16(0x1303))
        XCTAssertEqual(BluetoothUUID.videoSource, .bit16(4867))
        XCTAssertEqual(BluetoothUUID.videoSource.name, "Video Source")
        XCTAssertNotEqual(BluetoothUUID.videoSource, .bit32(4867))
        XCTAssertNotEqual(BluetoothUUID.videoSource, .bit32(0x1303))

        /// Video Sink
        XCTAssertEqual(BluetoothUUID.videoSink.rawValue, "1304")
        XCTAssertEqual(BluetoothUUID.videoSink, .bit16(0x1304))
        XCTAssertEqual(BluetoothUUID.videoSink, .bit16(4868))
        XCTAssertEqual(BluetoothUUID.videoSink.name, "Video Sink")
        XCTAssertNotEqual(BluetoothUUID.videoSink, .bit32(4868))
        XCTAssertNotEqual(BluetoothUUID.videoSink, .bit32(0x1304))

        /// Video Distribution
        XCTAssertEqual(BluetoothUUID.videoDistribution.rawValue, "1305")
        XCTAssertEqual(BluetoothUUID.videoDistribution, .bit16(0x1305))
        XCTAssertEqual(BluetoothUUID.videoDistribution, .bit16(4869))
        XCTAssertEqual(BluetoothUUID.videoDistribution.name, "Video Distribution")
        XCTAssertNotEqual(BluetoothUUID.videoDistribution, .bit32(4869))
        XCTAssertNotEqual(BluetoothUUID.videoDistribution, .bit32(0x1305))

        /// HDP
        XCTAssertEqual(BluetoothUUID.hdp.rawValue, "1400")
        XCTAssertEqual(BluetoothUUID.hdp, .bit16(0x1400))
        XCTAssertEqual(BluetoothUUID.hdp, .bit16(5120))
        XCTAssertEqual(BluetoothUUID.hdp.name, "HDP")
        XCTAssertNotEqual(BluetoothUUID.hdp, .bit32(5120))
        XCTAssertNotEqual(BluetoothUUID.hdp, .bit32(0x1400))

        /// HDP Source
        XCTAssertEqual(BluetoothUUID.hdpSource.rawValue, "1401")
        XCTAssertEqual(BluetoothUUID.hdpSource, .bit16(0x1401))
        XCTAssertEqual(BluetoothUUID.hdpSource, .bit16(5121))
        XCTAssertEqual(BluetoothUUID.hdpSource.name, "HDP Source")
        XCTAssertNotEqual(BluetoothUUID.hdpSource, .bit32(5121))
        XCTAssertNotEqual(BluetoothUUID.hdpSource, .bit32(0x1401))

        /// HDP Sink
        XCTAssertEqual(BluetoothUUID.hdpSink.rawValue, "1402")
        XCTAssertEqual(BluetoothUUID.hdpSink, .bit16(0x1402))
        XCTAssertEqual(BluetoothUUID.hdpSink, .bit16(5122))
        XCTAssertEqual(BluetoothUUID.hdpSink.name, "HDP Sink")
        XCTAssertNotEqual(BluetoothUUID.hdpSink, .bit32(5122))
        XCTAssertNotEqual(BluetoothUUID.hdpSink, .bit32(0x1402))

        /// Generic Access Profile
        XCTAssertEqual(BluetoothUUID.genericAccessProfile.rawValue, "1800")
        XCTAssertEqual(BluetoothUUID.genericAccessProfile, .bit16(0x1800))
        XCTAssertEqual(BluetoothUUID.genericAccessProfile, .bit16(6144))
        XCTAssertEqual(BluetoothUUID.genericAccessProfile.name, "Generic Access Profile")
        XCTAssertNotEqual(BluetoothUUID.genericAccessProfile, .bit32(6144))
        XCTAssertNotEqual(BluetoothUUID.genericAccessProfile, .bit32(0x1800))

        /// Generic Attribute Profile
        XCTAssertEqual(BluetoothUUID.genericAttributeProfile.rawValue, "1801")
        XCTAssertEqual(BluetoothUUID.genericAttributeProfile, .bit16(0x1801))
        XCTAssertEqual(BluetoothUUID.genericAttributeProfile, .bit16(6145))
        XCTAssertEqual(BluetoothUUID.genericAttributeProfile.name, "Generic Attribute Profile")
        XCTAssertNotEqual(BluetoothUUID.genericAttributeProfile, .bit32(6145))
        XCTAssertNotEqual(BluetoothUUID.genericAttributeProfile, .bit32(0x1801))

        /// Immediate Alert
        XCTAssertEqual(BluetoothUUID.immediateAlert.rawValue, "1802")
        XCTAssertEqual(BluetoothUUID.immediateAlert, .bit16(0x1802))
        XCTAssertEqual(BluetoothUUID.immediateAlert, .bit16(6146))
        XCTAssertEqual(BluetoothUUID.immediateAlert.name, "Immediate Alert")
        XCTAssertNotEqual(BluetoothUUID.immediateAlert, .bit32(6146))
        XCTAssertNotEqual(BluetoothUUID.immediateAlert, .bit32(0x1802))

        /// Link Loss
        XCTAssertEqual(BluetoothUUID.linkLoss.rawValue, "1803")
        XCTAssertEqual(BluetoothUUID.linkLoss, .bit16(0x1803))
        XCTAssertEqual(BluetoothUUID.linkLoss, .bit16(6147))
        XCTAssertEqual(BluetoothUUID.linkLoss.name, "Link Loss")
        XCTAssertNotEqual(BluetoothUUID.linkLoss, .bit32(6147))
        XCTAssertNotEqual(BluetoothUUID.linkLoss, .bit32(0x1803))

        /// Tx Power
        XCTAssertEqual(BluetoothUUID.txPower.rawValue, "1804")
        XCTAssertEqual(BluetoothUUID.txPower, .bit16(0x1804))
        XCTAssertEqual(BluetoothUUID.txPower, .bit16(6148))
        XCTAssertEqual(BluetoothUUID.txPower.name, "Tx Power")
        XCTAssertNotEqual(BluetoothUUID.txPower, .bit32(6148))
        XCTAssertNotEqual(BluetoothUUID.txPower, .bit32(0x1804))

        /// Current Time Service
        XCTAssertEqual(BluetoothUUID.currentTimeService.rawValue, "1805")
        XCTAssertEqual(BluetoothUUID.currentTimeService, .bit16(0x1805))
        XCTAssertEqual(BluetoothUUID.currentTimeService, .bit16(6149))
        XCTAssertEqual(BluetoothUUID.currentTimeService.name, "Current Time Service")
        XCTAssertNotEqual(BluetoothUUID.currentTimeService, .bit32(6149))
        XCTAssertNotEqual(BluetoothUUID.currentTimeService, .bit32(0x1805))

        /// Reference Time Update Service
        XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService.rawValue, "1806")
        XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService, .bit16(0x1806))
        XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService, .bit16(6150))
        XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService.name, "Reference Time Update Service")
        XCTAssertNotEqual(BluetoothUUID.referenceTimeUpdateService, .bit32(6150))
        XCTAssertNotEqual(BluetoothUUID.referenceTimeUpdateService, .bit32(0x1806))

        /// Next DST Change Service
        XCTAssertEqual(BluetoothUUID.nextDstChangeService.rawValue, "1807")
        XCTAssertEqual(BluetoothUUID.nextDstChangeService, .bit16(0x1807))
        XCTAssertEqual(BluetoothUUID.nextDstChangeService, .bit16(6151))
        XCTAssertEqual(BluetoothUUID.nextDstChangeService.name, "Next DST Change Service")
        XCTAssertNotEqual(BluetoothUUID.nextDstChangeService, .bit32(6151))
        XCTAssertNotEqual(BluetoothUUID.nextDstChangeService, .bit32(0x1807))

        /// Glucose
        XCTAssertEqual(BluetoothUUID.glucose.rawValue, "1808")
        XCTAssertEqual(BluetoothUUID.glucose, .bit16(0x1808))
        XCTAssertEqual(BluetoothUUID.glucose, .bit16(6152))
        XCTAssertEqual(BluetoothUUID.glucose.name, "Glucose")
        XCTAssertNotEqual(BluetoothUUID.glucose, .bit32(6152))
        XCTAssertNotEqual(BluetoothUUID.glucose, .bit32(0x1808))

        /// Health Thermometer
        XCTAssertEqual(BluetoothUUID.healthThermometer.rawValue, "1809")
        XCTAssertEqual(BluetoothUUID.healthThermometer, .bit16(0x1809))
        XCTAssertEqual(BluetoothUUID.healthThermometer, .bit16(6153))
        XCTAssertEqual(BluetoothUUID.healthThermometer.name, "Health Thermometer")
        XCTAssertNotEqual(BluetoothUUID.healthThermometer, .bit32(6153))
        XCTAssertNotEqual(BluetoothUUID.healthThermometer, .bit32(0x1809))

        /// Device Information
        XCTAssertEqual(BluetoothUUID.deviceInformation.rawValue, "180A")
        XCTAssertEqual(BluetoothUUID.deviceInformation, .bit16(0x180A))
        XCTAssertEqual(BluetoothUUID.deviceInformation, .bit16(6154))
        XCTAssertEqual(BluetoothUUID.deviceInformation.name, "Device Information")
        XCTAssertNotEqual(BluetoothUUID.deviceInformation, .bit32(6154))
        XCTAssertNotEqual(BluetoothUUID.deviceInformation, .bit32(0x180A))

        /// Heart Rate
        XCTAssertEqual(BluetoothUUID.heartRate.rawValue, "180D")
        XCTAssertEqual(BluetoothUUID.heartRate, .bit16(0x180D))
        XCTAssertEqual(BluetoothUUID.heartRate, .bit16(6157))
        XCTAssertEqual(BluetoothUUID.heartRate.name, "Heart Rate")
        XCTAssertNotEqual(BluetoothUUID.heartRate, .bit32(6157))
        XCTAssertNotEqual(BluetoothUUID.heartRate, .bit32(0x180D))

        /// Phone Alert Status Service
        XCTAssertEqual(BluetoothUUID.phoneAlertStatusService.rawValue, "180E")
        XCTAssertEqual(BluetoothUUID.phoneAlertStatusService, .bit16(0x180E))
        XCTAssertEqual(BluetoothUUID.phoneAlertStatusService, .bit16(6158))
        XCTAssertEqual(BluetoothUUID.phoneAlertStatusService.name, "Phone Alert Status Service")
        XCTAssertNotEqual(BluetoothUUID.phoneAlertStatusService, .bit32(6158))
        XCTAssertNotEqual(BluetoothUUID.phoneAlertStatusService, .bit32(0x180E))

        /// Battery Service
        XCTAssertEqual(BluetoothUUID.batteryService.rawValue, "180F")
        XCTAssertEqual(BluetoothUUID.batteryService, .bit16(0x180F))
        XCTAssertEqual(BluetoothUUID.batteryService, .bit16(6159))
        XCTAssertEqual(BluetoothUUID.batteryService.name, "Battery Service")
        XCTAssertNotEqual(BluetoothUUID.batteryService, .bit32(6159))
        XCTAssertNotEqual(BluetoothUUID.batteryService, .bit32(0x180F))

        /// Blood Pressure
        XCTAssertEqual(BluetoothUUID.bloodPressure.rawValue, "1810")
        XCTAssertEqual(BluetoothUUID.bloodPressure, .bit16(0x1810))
        XCTAssertEqual(BluetoothUUID.bloodPressure, .bit16(6160))
        XCTAssertEqual(BluetoothUUID.bloodPressure.name, "Blood Pressure")
        XCTAssertNotEqual(BluetoothUUID.bloodPressure, .bit32(6160))
        XCTAssertNotEqual(BluetoothUUID.bloodPressure, .bit32(0x1810))

        /// Alert Notification Service
        XCTAssertEqual(BluetoothUUID.alertNotificationService.rawValue, "1811")
        XCTAssertEqual(BluetoothUUID.alertNotificationService, .bit16(0x1811))
        XCTAssertEqual(BluetoothUUID.alertNotificationService, .bit16(6161))
        XCTAssertEqual(BluetoothUUID.alertNotificationService.name, "Alert Notification Service")
        XCTAssertNotEqual(BluetoothUUID.alertNotificationService, .bit32(6161))
        XCTAssertNotEqual(BluetoothUUID.alertNotificationService, .bit32(0x1811))

        /// Human Interface Device
        XCTAssertEqual(BluetoothUUID.humanInterfaceDevice.rawValue, "1812")
        XCTAssertEqual(BluetoothUUID.humanInterfaceDevice, .bit16(0x1812))
        XCTAssertEqual(BluetoothUUID.humanInterfaceDevice, .bit16(6162))
        XCTAssertEqual(BluetoothUUID.humanInterfaceDevice.name, "Human Interface Device")
        XCTAssertNotEqual(BluetoothUUID.humanInterfaceDevice, .bit32(6162))
        XCTAssertNotEqual(BluetoothUUID.humanInterfaceDevice, .bit32(0x1812))

        /// Scan Parameters
        XCTAssertEqual(BluetoothUUID.scanParameters.rawValue, "1813")
        XCTAssertEqual(BluetoothUUID.scanParameters, .bit16(0x1813))
        XCTAssertEqual(BluetoothUUID.scanParameters, .bit16(6163))
        XCTAssertEqual(BluetoothUUID.scanParameters.name, "Scan Parameters")
        XCTAssertNotEqual(BluetoothUUID.scanParameters, .bit32(6163))
        XCTAssertNotEqual(BluetoothUUID.scanParameters, .bit32(0x1813))

        /// Running Speed and Cadence
        XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence.rawValue, "1814")
        XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence, .bit16(0x1814))
        XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence, .bit16(6164))
        XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence.name, "Running Speed and Cadence")
        XCTAssertNotEqual(BluetoothUUID.runningSpeedAndCadence, .bit32(6164))
        XCTAssertNotEqual(BluetoothUUID.runningSpeedAndCadence, .bit32(0x1814))

        /// Automation IO
        XCTAssertEqual(BluetoothUUID.automationIo.rawValue, "1815")
        XCTAssertEqual(BluetoothUUID.automationIo, .bit16(0x1815))
        XCTAssertEqual(BluetoothUUID.automationIo, .bit16(6165))
        XCTAssertEqual(BluetoothUUID.automationIo.name, "Automation IO")
        XCTAssertNotEqual(BluetoothUUID.automationIo, .bit32(6165))
        XCTAssertNotEqual(BluetoothUUID.automationIo, .bit32(0x1815))

        /// Cycling Speed and Cadence
        XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence.rawValue, "1816")
        XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit16(0x1816))
        XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit16(6166))
        XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence.name, "Cycling Speed and Cadence")
        XCTAssertNotEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit32(6166))
        XCTAssertNotEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit32(0x1816))

        /// Cycling Power
        XCTAssertEqual(BluetoothUUID.cyclingPower.rawValue, "1818")
        XCTAssertEqual(BluetoothUUID.cyclingPower, .bit16(0x1818))
        XCTAssertEqual(BluetoothUUID.cyclingPower, .bit16(6168))
        XCTAssertEqual(BluetoothUUID.cyclingPower.name, "Cycling Power")
        XCTAssertNotEqual(BluetoothUUID.cyclingPower, .bit32(6168))
        XCTAssertNotEqual(BluetoothUUID.cyclingPower, .bit32(0x1818))

        /// Location and Navigation
        XCTAssertEqual(BluetoothUUID.locationAndNavigation.rawValue, "1819")
        XCTAssertEqual(BluetoothUUID.locationAndNavigation, .bit16(0x1819))
        XCTAssertEqual(BluetoothUUID.locationAndNavigation, .bit16(6169))
        XCTAssertEqual(BluetoothUUID.locationAndNavigation.name, "Location and Navigation")
        XCTAssertNotEqual(BluetoothUUID.locationAndNavigation, .bit32(6169))
        XCTAssertNotEqual(BluetoothUUID.locationAndNavigation, .bit32(0x1819))

        /// Environmental Sensing
        XCTAssertEqual(BluetoothUUID.environmentalSensing.rawValue, "181A")
        XCTAssertEqual(BluetoothUUID.environmentalSensing, .bit16(0x181A))
        XCTAssertEqual(BluetoothUUID.environmentalSensing, .bit16(6170))
        XCTAssertEqual(BluetoothUUID.environmentalSensing.name, "Environmental Sensing")
        XCTAssertNotEqual(BluetoothUUID.environmentalSensing, .bit32(6170))
        XCTAssertNotEqual(BluetoothUUID.environmentalSensing, .bit32(0x181A))

        /// Body Composition
        XCTAssertEqual(BluetoothUUID.bodyComposition.rawValue, "181B")
        XCTAssertEqual(BluetoothUUID.bodyComposition, .bit16(0x181B))
        XCTAssertEqual(BluetoothUUID.bodyComposition, .bit16(6171))
        XCTAssertEqual(BluetoothUUID.bodyComposition.name, "Body Composition")
        XCTAssertNotEqual(BluetoothUUID.bodyComposition, .bit32(6171))
        XCTAssertNotEqual(BluetoothUUID.bodyComposition, .bit32(0x181B))

        /// User Data
        XCTAssertEqual(BluetoothUUID.userData.rawValue, "181C")
        XCTAssertEqual(BluetoothUUID.userData, .bit16(0x181C))
        XCTAssertEqual(BluetoothUUID.userData, .bit16(6172))
        XCTAssertEqual(BluetoothUUID.userData.name, "User Data")
        XCTAssertNotEqual(BluetoothUUID.userData, .bit32(6172))
        XCTAssertNotEqual(BluetoothUUID.userData, .bit32(0x181C))

        /// Weight Scale
        XCTAssertEqual(BluetoothUUID.weightScale.rawValue, "181D")
        XCTAssertEqual(BluetoothUUID.weightScale, .bit16(0x181D))
        XCTAssertEqual(BluetoothUUID.weightScale, .bit16(6173))
        XCTAssertEqual(BluetoothUUID.weightScale.name, "Weight Scale")
        XCTAssertNotEqual(BluetoothUUID.weightScale, .bit32(6173))
        XCTAssertNotEqual(BluetoothUUID.weightScale, .bit32(0x181D))

        /// Bond Management
        XCTAssertEqual(BluetoothUUID.bondManagement.rawValue, "181E")
        XCTAssertEqual(BluetoothUUID.bondManagement, .bit16(0x181E))
        XCTAssertEqual(BluetoothUUID.bondManagement, .bit16(6174))
        XCTAssertEqual(BluetoothUUID.bondManagement.name, "Bond Management")
        XCTAssertNotEqual(BluetoothUUID.bondManagement, .bit32(6174))
        XCTAssertNotEqual(BluetoothUUID.bondManagement, .bit32(0x181E))

        /// Continuous Glucose Monitoring
        XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring.rawValue, "181F")
        XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit16(0x181F))
        XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit16(6175))
        XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring.name, "Continuous Glucose Monitoring")
        XCTAssertNotEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit32(6175))
        XCTAssertNotEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit32(0x181F))

        /// Internet Protocol Support
        XCTAssertEqual(BluetoothUUID.internetProtocolSupport.rawValue, "1820")
        XCTAssertEqual(BluetoothUUID.internetProtocolSupport, .bit16(0x1820))
        XCTAssertEqual(BluetoothUUID.internetProtocolSupport, .bit16(6176))
        XCTAssertEqual(BluetoothUUID.internetProtocolSupport.name, "Internet Protocol Support")
        XCTAssertNotEqual(BluetoothUUID.internetProtocolSupport, .bit32(6176))
        XCTAssertNotEqual(BluetoothUUID.internetProtocolSupport, .bit32(0x1820))

        /// Indoor Positioning
        XCTAssertEqual(BluetoothUUID.indoorPositioning.rawValue, "1821")
        XCTAssertEqual(BluetoothUUID.indoorPositioning, .bit16(0x1821))
        XCTAssertEqual(BluetoothUUID.indoorPositioning, .bit16(6177))
        XCTAssertEqual(BluetoothUUID.indoorPositioning.name, "Indoor Positioning")
        XCTAssertNotEqual(BluetoothUUID.indoorPositioning, .bit32(6177))
        XCTAssertNotEqual(BluetoothUUID.indoorPositioning, .bit32(0x1821))

        /// Pulse Oximeter
        XCTAssertEqual(BluetoothUUID.pulseOximeter.rawValue, "1822")
        XCTAssertEqual(BluetoothUUID.pulseOximeter, .bit16(0x1822))
        XCTAssertEqual(BluetoothUUID.pulseOximeter, .bit16(6178))
        XCTAssertEqual(BluetoothUUID.pulseOximeter.name, "Pulse Oximeter")
        XCTAssertNotEqual(BluetoothUUID.pulseOximeter, .bit32(6178))
        XCTAssertNotEqual(BluetoothUUID.pulseOximeter, .bit32(0x1822))

        /// HTTP Proxy
        XCTAssertEqual(BluetoothUUID.httpProxy.rawValue, "1823")
        XCTAssertEqual(BluetoothUUID.httpProxy, .bit16(0x1823))
        XCTAssertEqual(BluetoothUUID.httpProxy, .bit16(6179))
        XCTAssertEqual(BluetoothUUID.httpProxy.name, "HTTP Proxy")
        XCTAssertNotEqual(BluetoothUUID.httpProxy, .bit32(6179))
        XCTAssertNotEqual(BluetoothUUID.httpProxy, .bit32(0x1823))

        /// Transport Discovery
        XCTAssertEqual(BluetoothUUID.transportDiscovery.rawValue, "1824")
        XCTAssertEqual(BluetoothUUID.transportDiscovery, .bit16(0x1824))
        XCTAssertEqual(BluetoothUUID.transportDiscovery, .bit16(6180))
        XCTAssertEqual(BluetoothUUID.transportDiscovery.name, "Transport Discovery")
        XCTAssertNotEqual(BluetoothUUID.transportDiscovery, .bit32(6180))
        XCTAssertNotEqual(BluetoothUUID.transportDiscovery, .bit32(0x1824))

        /// Object Transfer
        XCTAssertEqual(BluetoothUUID.objectTransfer.rawValue, "1825")
        XCTAssertEqual(BluetoothUUID.objectTransfer, .bit16(0x1825))
        XCTAssertEqual(BluetoothUUID.objectTransfer, .bit16(6181))
        XCTAssertEqual(BluetoothUUID.objectTransfer.name, "Object Transfer")
        XCTAssertNotEqual(BluetoothUUID.objectTransfer, .bit32(6181))
        XCTAssertNotEqual(BluetoothUUID.objectTransfer, .bit32(0x1825))

        /// Primary Service
        XCTAssertEqual(BluetoothUUID.primaryService.rawValue, "2800")
        XCTAssertEqual(BluetoothUUID.primaryService, .bit16(0x2800))
        XCTAssertEqual(BluetoothUUID.primaryService, .bit16(10240))
        XCTAssertEqual(BluetoothUUID.primaryService.name, "Primary Service")
        XCTAssertNotEqual(BluetoothUUID.primaryService, .bit32(10240))
        XCTAssertNotEqual(BluetoothUUID.primaryService, .bit32(0x2800))

        /// Secondary Service
        XCTAssertEqual(BluetoothUUID.secondaryService.rawValue, "2801")
        XCTAssertEqual(BluetoothUUID.secondaryService, .bit16(0x2801))
        XCTAssertEqual(BluetoothUUID.secondaryService, .bit16(10241))
        XCTAssertEqual(BluetoothUUID.secondaryService.name, "Secondary Service")
        XCTAssertNotEqual(BluetoothUUID.secondaryService, .bit32(10241))
        XCTAssertNotEqual(BluetoothUUID.secondaryService, .bit32(0x2801))

        /// Include
        XCTAssertEqual(BluetoothUUID.include.rawValue, "2802")
        XCTAssertEqual(BluetoothUUID.include, .bit16(0x2802))
        XCTAssertEqual(BluetoothUUID.include, .bit16(10242))
        XCTAssertEqual(BluetoothUUID.include.name, "Include")
        XCTAssertNotEqual(BluetoothUUID.include, .bit32(10242))
        XCTAssertNotEqual(BluetoothUUID.include, .bit32(0x2802))

        /// Characteristic
        XCTAssertEqual(BluetoothUUID.characteristic.rawValue, "2803")
        XCTAssertEqual(BluetoothUUID.characteristic, .bit16(0x2803))
        XCTAssertEqual(BluetoothUUID.characteristic, .bit16(10243))
        XCTAssertEqual(BluetoothUUID.characteristic.name, "Characteristic")
        XCTAssertNotEqual(BluetoothUUID.characteristic, .bit32(10243))
        XCTAssertNotEqual(BluetoothUUID.characteristic, .bit32(0x2803))

        /// Characteristic Extended Properties
        XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties.rawValue, "2900")
        XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties, .bit16(0x2900))
        XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties, .bit16(10496))
        XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties.name, "Characteristic Extended Properties")
        XCTAssertNotEqual(BluetoothUUID.characteristicExtendedProperties, .bit32(10496))
        XCTAssertNotEqual(BluetoothUUID.characteristicExtendedProperties, .bit32(0x2900))

        /// Characteristic User Description
        XCTAssertEqual(BluetoothUUID.characteristicUserDescription.rawValue, "2901")
        XCTAssertEqual(BluetoothUUID.characteristicUserDescription, .bit16(0x2901))
        XCTAssertEqual(BluetoothUUID.characteristicUserDescription, .bit16(10497))
        XCTAssertEqual(BluetoothUUID.characteristicUserDescription.name, "Characteristic User Description")
        XCTAssertNotEqual(BluetoothUUID.characteristicUserDescription, .bit32(10497))
        XCTAssertNotEqual(BluetoothUUID.characteristicUserDescription, .bit32(0x2901))

        /// Client Characteristic Configuration
        XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration.rawValue, "2902")
        XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit16(0x2902))
        XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit16(10498))
        XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration.name, "Client Characteristic Configuration")
        XCTAssertNotEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit32(10498))
        XCTAssertNotEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit32(0x2902))

        /// Server Characteristic Configuration
        XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration.rawValue, "2903")
        XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit16(0x2903))
        XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit16(10499))
        XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration.name, "Server Characteristic Configuration")
        XCTAssertNotEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit32(10499))
        XCTAssertNotEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit32(0x2903))

        /// Characteristic Format
        XCTAssertEqual(BluetoothUUID.characteristicFormat.rawValue, "2904")
        XCTAssertEqual(BluetoothUUID.characteristicFormat, .bit16(0x2904))
        XCTAssertEqual(BluetoothUUID.characteristicFormat, .bit16(10500))
        XCTAssertEqual(BluetoothUUID.characteristicFormat.name, "Characteristic Format")
        XCTAssertNotEqual(BluetoothUUID.characteristicFormat, .bit32(10500))
        XCTAssertNotEqual(BluetoothUUID.characteristicFormat, .bit32(0x2904))

        /// Characteristic Aggregate Format
        XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat.rawValue, "2905")
        XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat, .bit16(0x2905))
        XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat, .bit16(10501))
        XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat.name, "Characteristic Aggregate Format")
        XCTAssertNotEqual(BluetoothUUID.characteristicAggregateFormat, .bit32(10501))
        XCTAssertNotEqual(BluetoothUUID.characteristicAggregateFormat, .bit32(0x2905))

        /// Valid Range
        XCTAssertEqual(BluetoothUUID.validRange.rawValue, "2906")
        XCTAssertEqual(BluetoothUUID.validRange, .bit16(0x2906))
        XCTAssertEqual(BluetoothUUID.validRange, .bit16(10502))
        XCTAssertEqual(BluetoothUUID.validRange.name, "Valid Range")
        XCTAssertNotEqual(BluetoothUUID.validRange, .bit32(10502))
        XCTAssertNotEqual(BluetoothUUID.validRange, .bit32(0x2906))

        /// External Report Reference
        XCTAssertEqual(BluetoothUUID.externalReportReference.rawValue, "2907")
        XCTAssertEqual(BluetoothUUID.externalReportReference, .bit16(0x2907))
        XCTAssertEqual(BluetoothUUID.externalReportReference, .bit16(10503))
        XCTAssertEqual(BluetoothUUID.externalReportReference.name, "External Report Reference")
        XCTAssertNotEqual(BluetoothUUID.externalReportReference, .bit32(10503))
        XCTAssertNotEqual(BluetoothUUID.externalReportReference, .bit32(0x2907))

        /// Report Reference
        XCTAssertEqual(BluetoothUUID.reportReference.rawValue, "2908")
        XCTAssertEqual(BluetoothUUID.reportReference, .bit16(0x2908))
        XCTAssertEqual(BluetoothUUID.reportReference, .bit16(10504))
        XCTAssertEqual(BluetoothUUID.reportReference.name, "Report Reference")
        XCTAssertNotEqual(BluetoothUUID.reportReference, .bit32(10504))
        XCTAssertNotEqual(BluetoothUUID.reportReference, .bit32(0x2908))

        /// Number of Digitals
        XCTAssertEqual(BluetoothUUID.numberOfDigitals.rawValue, "2909")
        XCTAssertEqual(BluetoothUUID.numberOfDigitals, .bit16(0x2909))
        XCTAssertEqual(BluetoothUUID.numberOfDigitals, .bit16(10505))
        XCTAssertEqual(BluetoothUUID.numberOfDigitals.name, "Number of Digitals")
        XCTAssertNotEqual(BluetoothUUID.numberOfDigitals, .bit32(10505))
        XCTAssertNotEqual(BluetoothUUID.numberOfDigitals, .bit32(0x2909))

        /// Value Trigger Setting
        XCTAssertEqual(BluetoothUUID.valueTriggerSetting.rawValue, "290A")
        XCTAssertEqual(BluetoothUUID.valueTriggerSetting, .bit16(0x290A))
        XCTAssertEqual(BluetoothUUID.valueTriggerSetting, .bit16(10506))
        XCTAssertEqual(BluetoothUUID.valueTriggerSetting.name, "Value Trigger Setting")
        XCTAssertNotEqual(BluetoothUUID.valueTriggerSetting, .bit32(10506))
        XCTAssertNotEqual(BluetoothUUID.valueTriggerSetting, .bit32(0x290A))

        /// Environmental Sensing Configuration
        XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration.rawValue, "290B")
        XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration, .bit16(0x290B))
        XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration, .bit16(10507))
        XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration.name, "Environmental Sensing Configuration")
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingConfiguration, .bit32(10507))
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingConfiguration, .bit32(0x290B))

        /// Environmental Sensing Measurement
        XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement.rawValue, "290C")
        XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement, .bit16(0x290C))
        XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement, .bit16(10508))
        XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement.name, "Environmental Sensing Measurement")
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingMeasurement, .bit32(10508))
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingMeasurement, .bit32(0x290C))

        /// Environmental Sensing Trigger Setting
        XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting.rawValue, "290D")
        XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit16(0x290D))
        XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit16(10509))
        XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting.name, "Environmental Sensing Trigger Setting")
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit32(10509))
        XCTAssertNotEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit32(0x290D))

        /// Time Trigger Setting
        XCTAssertEqual(BluetoothUUID.timeTriggerSetting.rawValue, "290E")
        XCTAssertEqual(BluetoothUUID.timeTriggerSetting, .bit16(0x290E))
        XCTAssertEqual(BluetoothUUID.timeTriggerSetting, .bit16(10510))
        XCTAssertEqual(BluetoothUUID.timeTriggerSetting.name, "Time Trigger Setting")
        XCTAssertNotEqual(BluetoothUUID.timeTriggerSetting, .bit32(10510))
        XCTAssertNotEqual(BluetoothUUID.timeTriggerSetting, .bit32(0x290E))

        /// Device Name
        XCTAssertEqual(BluetoothUUID.deviceName.rawValue, "2A00")
        XCTAssertEqual(BluetoothUUID.deviceName, .bit16(0x2A00))
        XCTAssertEqual(BluetoothUUID.deviceName, .bit16(10752))
        XCTAssertEqual(BluetoothUUID.deviceName.name, "Device Name")
        XCTAssertNotEqual(BluetoothUUID.deviceName, .bit32(10752))
        XCTAssertNotEqual(BluetoothUUID.deviceName, .bit32(0x2A00))

        /// Appearance
        XCTAssertEqual(BluetoothUUID.appearance.rawValue, "2A01")
        XCTAssertEqual(BluetoothUUID.appearance, .bit16(0x2A01))
        XCTAssertEqual(BluetoothUUID.appearance, .bit16(10753))
        XCTAssertEqual(BluetoothUUID.appearance.name, "Appearance")
        XCTAssertNotEqual(BluetoothUUID.appearance, .bit32(10753))
        XCTAssertNotEqual(BluetoothUUID.appearance, .bit32(0x2A01))

        /// Peripheral Privacy Flag
        XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag.rawValue, "2A02")
        XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag, .bit16(0x2A02))
        XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag, .bit16(10754))
        XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag.name, "Peripheral Privacy Flag")
        XCTAssertNotEqual(BluetoothUUID.peripheralPrivacyFlag, .bit32(10754))
        XCTAssertNotEqual(BluetoothUUID.peripheralPrivacyFlag, .bit32(0x2A02))

        /// Reconnection Address
        XCTAssertEqual(BluetoothUUID.reconnectionAddress.rawValue, "2A03")
        XCTAssertEqual(BluetoothUUID.reconnectionAddress, .bit16(0x2A03))
        XCTAssertEqual(BluetoothUUID.reconnectionAddress, .bit16(10755))
        XCTAssertEqual(BluetoothUUID.reconnectionAddress.name, "Reconnection Address")
        XCTAssertNotEqual(BluetoothUUID.reconnectionAddress, .bit32(10755))
        XCTAssertNotEqual(BluetoothUUID.reconnectionAddress, .bit32(0x2A03))

        /// Peripheral Preferred Connection Parameters
        XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters.rawValue, "2A04")
        XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit16(0x2A04))
        XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit16(10756))
        XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters.name, "Peripheral Preferred Connection Parameters")
        XCTAssertNotEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit32(10756))
        XCTAssertNotEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit32(0x2A04))

        /// Service Changed
        XCTAssertEqual(BluetoothUUID.serviceChanged.rawValue, "2A05")
        XCTAssertEqual(BluetoothUUID.serviceChanged, .bit16(0x2A05))
        XCTAssertEqual(BluetoothUUID.serviceChanged, .bit16(10757))
        XCTAssertEqual(BluetoothUUID.serviceChanged.name, "Service Changed")
        XCTAssertNotEqual(BluetoothUUID.serviceChanged, .bit32(10757))
        XCTAssertNotEqual(BluetoothUUID.serviceChanged, .bit32(0x2A05))

        /// Alert Level
        XCTAssertEqual(BluetoothUUID.alertLevel.rawValue, "2A06")
        XCTAssertEqual(BluetoothUUID.alertLevel, .bit16(0x2A06))
        XCTAssertEqual(BluetoothUUID.alertLevel, .bit16(10758))
        XCTAssertEqual(BluetoothUUID.alertLevel.name, "Alert Level")
        XCTAssertNotEqual(BluetoothUUID.alertLevel, .bit32(10758))
        XCTAssertNotEqual(BluetoothUUID.alertLevel, .bit32(0x2A06))

        /// Tx Power Level
        XCTAssertEqual(BluetoothUUID.txPowerLevel.rawValue, "2A07")
        XCTAssertEqual(BluetoothUUID.txPowerLevel, .bit16(0x2A07))
        XCTAssertEqual(BluetoothUUID.txPowerLevel, .bit16(10759))
        XCTAssertEqual(BluetoothUUID.txPowerLevel.name, "Tx Power Level")
        XCTAssertNotEqual(BluetoothUUID.txPowerLevel, .bit32(10759))
        XCTAssertNotEqual(BluetoothUUID.txPowerLevel, .bit32(0x2A07))

        /// Date Time
        XCTAssertEqual(BluetoothUUID.dateTime.rawValue, "2A08")
        XCTAssertEqual(BluetoothUUID.dateTime, .bit16(0x2A08))
        XCTAssertEqual(BluetoothUUID.dateTime, .bit16(10760))
        XCTAssertEqual(BluetoothUUID.dateTime.name, "Date Time")
        XCTAssertNotEqual(BluetoothUUID.dateTime, .bit32(10760))
        XCTAssertNotEqual(BluetoothUUID.dateTime, .bit32(0x2A08))

        /// Day of Week
        XCTAssertEqual(BluetoothUUID.dayOfWeek.rawValue, "2A09")
        XCTAssertEqual(BluetoothUUID.dayOfWeek, .bit16(0x2A09))
        XCTAssertEqual(BluetoothUUID.dayOfWeek, .bit16(10761))
        XCTAssertEqual(BluetoothUUID.dayOfWeek.name, "Day of Week")
        XCTAssertNotEqual(BluetoothUUID.dayOfWeek, .bit32(10761))
        XCTAssertNotEqual(BluetoothUUID.dayOfWeek, .bit32(0x2A09))

        /// Day Date Time
        XCTAssertEqual(BluetoothUUID.dayDateTime.rawValue, "2A0A")
        XCTAssertEqual(BluetoothUUID.dayDateTime, .bit16(0x2A0A))
        XCTAssertEqual(BluetoothUUID.dayDateTime, .bit16(10762))
        XCTAssertEqual(BluetoothUUID.dayDateTime.name, "Day Date Time")
        XCTAssertNotEqual(BluetoothUUID.dayDateTime, .bit32(10762))
        XCTAssertNotEqual(BluetoothUUID.dayDateTime, .bit32(0x2A0A))

        /// Exact Time 100
        XCTAssertEqual(BluetoothUUID.exactTime100.rawValue, "2A0B")
        XCTAssertEqual(BluetoothUUID.exactTime100, .bit16(0x2A0B))
        XCTAssertEqual(BluetoothUUID.exactTime100, .bit16(10763))
        XCTAssertEqual(BluetoothUUID.exactTime100.name, "Exact Time 100")
        XCTAssertNotEqual(BluetoothUUID.exactTime100, .bit32(10763))
        XCTAssertNotEqual(BluetoothUUID.exactTime100, .bit32(0x2A0B))

        /// Exact Time 256
        XCTAssertEqual(BluetoothUUID.exactTime256.rawValue, "2A0C")
        XCTAssertEqual(BluetoothUUID.exactTime256, .bit16(0x2A0C))
        XCTAssertEqual(BluetoothUUID.exactTime256, .bit16(10764))
        XCTAssertEqual(BluetoothUUID.exactTime256.name, "Exact Time 256")
        XCTAssertNotEqual(BluetoothUUID.exactTime256, .bit32(10764))
        XCTAssertNotEqual(BluetoothUUID.exactTime256, .bit32(0x2A0C))

        /// DST Offset
        XCTAssertEqual(BluetoothUUID.dstOffset.rawValue, "2A0D")
        XCTAssertEqual(BluetoothUUID.dstOffset, .bit16(0x2A0D))
        XCTAssertEqual(BluetoothUUID.dstOffset, .bit16(10765))
        XCTAssertEqual(BluetoothUUID.dstOffset.name, "DST Offset")
        XCTAssertNotEqual(BluetoothUUID.dstOffset, .bit32(10765))
        XCTAssertNotEqual(BluetoothUUID.dstOffset, .bit32(0x2A0D))

        /// Time Zone
        XCTAssertEqual(BluetoothUUID.timeZone.rawValue, "2A0E")
        XCTAssertEqual(BluetoothUUID.timeZone, .bit16(0x2A0E))
        XCTAssertEqual(BluetoothUUID.timeZone, .bit16(10766))
        XCTAssertEqual(BluetoothUUID.timeZone.name, "Time Zone")
        XCTAssertNotEqual(BluetoothUUID.timeZone, .bit32(10766))
        XCTAssertNotEqual(BluetoothUUID.timeZone, .bit32(0x2A0E))

        /// Local Time Information
        XCTAssertEqual(BluetoothUUID.localTimeInformation.rawValue, "2A0F")
        XCTAssertEqual(BluetoothUUID.localTimeInformation, .bit16(0x2A0F))
        XCTAssertEqual(BluetoothUUID.localTimeInformation, .bit16(10767))
        XCTAssertEqual(BluetoothUUID.localTimeInformation.name, "Local Time Information")
        XCTAssertNotEqual(BluetoothUUID.localTimeInformation, .bit32(10767))
        XCTAssertNotEqual(BluetoothUUID.localTimeInformation, .bit32(0x2A0F))

        /// Secondary Time Zone
        XCTAssertEqual(BluetoothUUID.secondaryTimeZone.rawValue, "2A10")
        XCTAssertEqual(BluetoothUUID.secondaryTimeZone, .bit16(0x2A10))
        XCTAssertEqual(BluetoothUUID.secondaryTimeZone, .bit16(10768))
        XCTAssertEqual(BluetoothUUID.secondaryTimeZone.name, "Secondary Time Zone")
        XCTAssertNotEqual(BluetoothUUID.secondaryTimeZone, .bit32(10768))
        XCTAssertNotEqual(BluetoothUUID.secondaryTimeZone, .bit32(0x2A10))

        /// Time with DST
        XCTAssertEqual(BluetoothUUID.timeWithDst.rawValue, "2A11")
        XCTAssertEqual(BluetoothUUID.timeWithDst, .bit16(0x2A11))
        XCTAssertEqual(BluetoothUUID.timeWithDst, .bit16(10769))
        XCTAssertEqual(BluetoothUUID.timeWithDst.name, "Time with DST")
        XCTAssertNotEqual(BluetoothUUID.timeWithDst, .bit32(10769))
        XCTAssertNotEqual(BluetoothUUID.timeWithDst, .bit32(0x2A11))

        /// Time Accuracy
        XCTAssertEqual(BluetoothUUID.timeAccuracy.rawValue, "2A12")
        XCTAssertEqual(BluetoothUUID.timeAccuracy, .bit16(0x2A12))
        XCTAssertEqual(BluetoothUUID.timeAccuracy, .bit16(10770))
        XCTAssertEqual(BluetoothUUID.timeAccuracy.name, "Time Accuracy")
        XCTAssertNotEqual(BluetoothUUID.timeAccuracy, .bit32(10770))
        XCTAssertNotEqual(BluetoothUUID.timeAccuracy, .bit32(0x2A12))

        /// Time Source
        XCTAssertEqual(BluetoothUUID.timeSource.rawValue, "2A13")
        XCTAssertEqual(BluetoothUUID.timeSource, .bit16(0x2A13))
        XCTAssertEqual(BluetoothUUID.timeSource, .bit16(10771))
        XCTAssertEqual(BluetoothUUID.timeSource.name, "Time Source")
        XCTAssertNotEqual(BluetoothUUID.timeSource, .bit32(10771))
        XCTAssertNotEqual(BluetoothUUID.timeSource, .bit32(0x2A13))

        /// Reference Time Information
        XCTAssertEqual(BluetoothUUID.referenceTimeInformation.rawValue, "2A14")
        XCTAssertEqual(BluetoothUUID.referenceTimeInformation, .bit16(0x2A14))
        XCTAssertEqual(BluetoothUUID.referenceTimeInformation, .bit16(10772))
        XCTAssertEqual(BluetoothUUID.referenceTimeInformation.name, "Reference Time Information")
        XCTAssertNotEqual(BluetoothUUID.referenceTimeInformation, .bit32(10772))
        XCTAssertNotEqual(BluetoothUUID.referenceTimeInformation, .bit32(0x2A14))

        /// Time Broadcast
        XCTAssertEqual(BluetoothUUID.timeBroadcast.rawValue, "2A15")
        XCTAssertEqual(BluetoothUUID.timeBroadcast, .bit16(0x2A15))
        XCTAssertEqual(BluetoothUUID.timeBroadcast, .bit16(10773))
        XCTAssertEqual(BluetoothUUID.timeBroadcast.name, "Time Broadcast")
        XCTAssertNotEqual(BluetoothUUID.timeBroadcast, .bit32(10773))
        XCTAssertNotEqual(BluetoothUUID.timeBroadcast, .bit32(0x2A15))

        /// Time Update Control Point
        XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint.rawValue, "2A16")
        XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint, .bit16(0x2A16))
        XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint, .bit16(10774))
        XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint.name, "Time Update Control Point")
        XCTAssertNotEqual(BluetoothUUID.timeUpdateControlPoint, .bit32(10774))
        XCTAssertNotEqual(BluetoothUUID.timeUpdateControlPoint, .bit32(0x2A16))

        /// Time Update State
        XCTAssertEqual(BluetoothUUID.timeUpdateState.rawValue, "2A17")
        XCTAssertEqual(BluetoothUUID.timeUpdateState, .bit16(0x2A17))
        XCTAssertEqual(BluetoothUUID.timeUpdateState, .bit16(10775))
        XCTAssertEqual(BluetoothUUID.timeUpdateState.name, "Time Update State")
        XCTAssertNotEqual(BluetoothUUID.timeUpdateState, .bit32(10775))
        XCTAssertNotEqual(BluetoothUUID.timeUpdateState, .bit32(0x2A17))

        /// Glucose Measurement
        XCTAssertEqual(BluetoothUUID.glucoseMeasurement.rawValue, "2A18")
        XCTAssertEqual(BluetoothUUID.glucoseMeasurement, .bit16(0x2A18))
        XCTAssertEqual(BluetoothUUID.glucoseMeasurement, .bit16(10776))
        XCTAssertEqual(BluetoothUUID.glucoseMeasurement.name, "Glucose Measurement")
        XCTAssertNotEqual(BluetoothUUID.glucoseMeasurement, .bit32(10776))
        XCTAssertNotEqual(BluetoothUUID.glucoseMeasurement, .bit32(0x2A18))

        /// Battery Level
        XCTAssertEqual(BluetoothUUID.batteryLevel.rawValue, "2A19")
        XCTAssertEqual(BluetoothUUID.batteryLevel, .bit16(0x2A19))
        XCTAssertEqual(BluetoothUUID.batteryLevel, .bit16(10777))
        XCTAssertEqual(BluetoothUUID.batteryLevel.name, "Battery Level")
        XCTAssertNotEqual(BluetoothUUID.batteryLevel, .bit32(10777))
        XCTAssertNotEqual(BluetoothUUID.batteryLevel, .bit32(0x2A19))

        /// Battery Power State
        XCTAssertEqual(BluetoothUUID.batteryPowerState.rawValue, "2A1A")
        XCTAssertEqual(BluetoothUUID.batteryPowerState, .bit16(0x2A1A))
        XCTAssertEqual(BluetoothUUID.batteryPowerState, .bit16(10778))
        XCTAssertEqual(BluetoothUUID.batteryPowerState.name, "Battery Power State")
        XCTAssertNotEqual(BluetoothUUID.batteryPowerState, .bit32(10778))
        XCTAssertNotEqual(BluetoothUUID.batteryPowerState, .bit32(0x2A1A))

        /// Battery Level State
        XCTAssertEqual(BluetoothUUID.batteryLevelState.rawValue, "2A1B")
        XCTAssertEqual(BluetoothUUID.batteryLevelState, .bit16(0x2A1B))
        XCTAssertEqual(BluetoothUUID.batteryLevelState, .bit16(10779))
        XCTAssertEqual(BluetoothUUID.batteryLevelState.name, "Battery Level State")
        XCTAssertNotEqual(BluetoothUUID.batteryLevelState, .bit32(10779))
        XCTAssertNotEqual(BluetoothUUID.batteryLevelState, .bit32(0x2A1B))

        /// Temperature Measurement
        XCTAssertEqual(BluetoothUUID.temperatureMeasurement.rawValue, "2A1C")
        XCTAssertEqual(BluetoothUUID.temperatureMeasurement, .bit16(0x2A1C))
        XCTAssertEqual(BluetoothUUID.temperatureMeasurement, .bit16(10780))
        XCTAssertEqual(BluetoothUUID.temperatureMeasurement.name, "Temperature Measurement")
        XCTAssertNotEqual(BluetoothUUID.temperatureMeasurement, .bit32(10780))
        XCTAssertNotEqual(BluetoothUUID.temperatureMeasurement, .bit32(0x2A1C))

        /// Temperature Type
        XCTAssertEqual(BluetoothUUID.temperatureType.rawValue, "2A1D")
        XCTAssertEqual(BluetoothUUID.temperatureType, .bit16(0x2A1D))
        XCTAssertEqual(BluetoothUUID.temperatureType, .bit16(10781))
        XCTAssertEqual(BluetoothUUID.temperatureType.name, "Temperature Type")
        XCTAssertNotEqual(BluetoothUUID.temperatureType, .bit32(10781))
        XCTAssertNotEqual(BluetoothUUID.temperatureType, .bit32(0x2A1D))

        /// Intermediate Temperature
        XCTAssertEqual(BluetoothUUID.intermediateTemperature.rawValue, "2A1E")
        XCTAssertEqual(BluetoothUUID.intermediateTemperature, .bit16(0x2A1E))
        XCTAssertEqual(BluetoothUUID.intermediateTemperature, .bit16(10782))
        XCTAssertEqual(BluetoothUUID.intermediateTemperature.name, "Intermediate Temperature")
        XCTAssertNotEqual(BluetoothUUID.intermediateTemperature, .bit32(10782))
        XCTAssertNotEqual(BluetoothUUID.intermediateTemperature, .bit32(0x2A1E))

        /// Measurement Interval
        XCTAssertEqual(BluetoothUUID.measurementInterval.rawValue, "2A21")
        XCTAssertEqual(BluetoothUUID.measurementInterval, .bit16(0x2A21))
        XCTAssertEqual(BluetoothUUID.measurementInterval, .bit16(10785))
        XCTAssertEqual(BluetoothUUID.measurementInterval.name, "Measurement Interval")
        XCTAssertNotEqual(BluetoothUUID.measurementInterval, .bit32(10785))
        XCTAssertNotEqual(BluetoothUUID.measurementInterval, .bit32(0x2A21))

        /// Boot Keyboard Input Report
        XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport.rawValue, "2A22")
        XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport, .bit16(0x2A22))
        XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport, .bit16(10786))
        XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport.name, "Boot Keyboard Input Report")
        XCTAssertNotEqual(BluetoothUUID.bootKeyboardInputReport, .bit32(10786))
        XCTAssertNotEqual(BluetoothUUID.bootKeyboardInputReport, .bit32(0x2A22))

        /// System ID
        XCTAssertEqual(BluetoothUUID.systemId.rawValue, "2A23")
        XCTAssertEqual(BluetoothUUID.systemId, .bit16(0x2A23))
        XCTAssertEqual(BluetoothUUID.systemId, .bit16(10787))
        XCTAssertEqual(BluetoothUUID.systemId.name, "System ID")
        XCTAssertNotEqual(BluetoothUUID.systemId, .bit32(10787))
        XCTAssertNotEqual(BluetoothUUID.systemId, .bit32(0x2A23))

        /// Model Number String
        XCTAssertEqual(BluetoothUUID.modelNumberString.rawValue, "2A24")
        XCTAssertEqual(BluetoothUUID.modelNumberString, .bit16(0x2A24))
        XCTAssertEqual(BluetoothUUID.modelNumberString, .bit16(10788))
        XCTAssertEqual(BluetoothUUID.modelNumberString.name, "Model Number String")
        XCTAssertNotEqual(BluetoothUUID.modelNumberString, .bit32(10788))
        XCTAssertNotEqual(BluetoothUUID.modelNumberString, .bit32(0x2A24))

        /// Serial Number String
        XCTAssertEqual(BluetoothUUID.serialNumberString.rawValue, "2A25")
        XCTAssertEqual(BluetoothUUID.serialNumberString, .bit16(0x2A25))
        XCTAssertEqual(BluetoothUUID.serialNumberString, .bit16(10789))
        XCTAssertEqual(BluetoothUUID.serialNumberString.name, "Serial Number String")
        XCTAssertNotEqual(BluetoothUUID.serialNumberString, .bit32(10789))
        XCTAssertNotEqual(BluetoothUUID.serialNumberString, .bit32(0x2A25))

        /// Firmware Revision String
        XCTAssertEqual(BluetoothUUID.firmwareRevisionString.rawValue, "2A26")
        XCTAssertEqual(BluetoothUUID.firmwareRevisionString, .bit16(0x2A26))
        XCTAssertEqual(BluetoothUUID.firmwareRevisionString, .bit16(10790))
        XCTAssertEqual(BluetoothUUID.firmwareRevisionString.name, "Firmware Revision String")
        XCTAssertNotEqual(BluetoothUUID.firmwareRevisionString, .bit32(10790))
        XCTAssertNotEqual(BluetoothUUID.firmwareRevisionString, .bit32(0x2A26))

        /// Hardware Revision String
        XCTAssertEqual(BluetoothUUID.hardwareRevisionString.rawValue, "2A27")
        XCTAssertEqual(BluetoothUUID.hardwareRevisionString, .bit16(0x2A27))
        XCTAssertEqual(BluetoothUUID.hardwareRevisionString, .bit16(10791))
        XCTAssertEqual(BluetoothUUID.hardwareRevisionString.name, "Hardware Revision String")
        XCTAssertNotEqual(BluetoothUUID.hardwareRevisionString, .bit32(10791))
        XCTAssertNotEqual(BluetoothUUID.hardwareRevisionString, .bit32(0x2A27))

        /// Software Revision String
        XCTAssertEqual(BluetoothUUID.softwareRevisionString.rawValue, "2A28")
        XCTAssertEqual(BluetoothUUID.softwareRevisionString, .bit16(0x2A28))
        XCTAssertEqual(BluetoothUUID.softwareRevisionString, .bit16(10792))
        XCTAssertEqual(BluetoothUUID.softwareRevisionString.name, "Software Revision String")
        XCTAssertNotEqual(BluetoothUUID.softwareRevisionString, .bit32(10792))
        XCTAssertNotEqual(BluetoothUUID.softwareRevisionString, .bit32(0x2A28))

        /// Manufacturer Name String
        XCTAssertEqual(BluetoothUUID.manufacturerNameString.rawValue, "2A29")
        XCTAssertEqual(BluetoothUUID.manufacturerNameString, .bit16(0x2A29))
        XCTAssertEqual(BluetoothUUID.manufacturerNameString, .bit16(10793))
        XCTAssertEqual(BluetoothUUID.manufacturerNameString.name, "Manufacturer Name String")
        XCTAssertNotEqual(BluetoothUUID.manufacturerNameString, .bit32(10793))
        XCTAssertNotEqual(BluetoothUUID.manufacturerNameString, .bit32(0x2A29))

        /// IEEE 11073-20601 Regulatory Cert. Data List
        XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList.rawValue, "2A2A")
        XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit16(0x2A2A))
        XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit16(10794))
        XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList.name, "IEEE 11073-20601 Regulatory Cert. Data List")
        XCTAssertNotEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit32(10794))
        XCTAssertNotEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit32(0x2A2A))

        /// Current Time
        XCTAssertEqual(BluetoothUUID.currentTime.rawValue, "2A2B")
        XCTAssertEqual(BluetoothUUID.currentTime, .bit16(0x2A2B))
        XCTAssertEqual(BluetoothUUID.currentTime, .bit16(10795))
        XCTAssertEqual(BluetoothUUID.currentTime.name, "Current Time")
        XCTAssertNotEqual(BluetoothUUID.currentTime, .bit32(10795))
        XCTAssertNotEqual(BluetoothUUID.currentTime, .bit32(0x2A2B))

        /// Magnetic Declination
        XCTAssertEqual(BluetoothUUID.magneticDeclination.rawValue, "2A2C")
        XCTAssertEqual(BluetoothUUID.magneticDeclination, .bit16(0x2A2C))
        XCTAssertEqual(BluetoothUUID.magneticDeclination, .bit16(10796))
        XCTAssertEqual(BluetoothUUID.magneticDeclination.name, "Magnetic Declination")
        XCTAssertNotEqual(BluetoothUUID.magneticDeclination, .bit32(10796))
        XCTAssertNotEqual(BluetoothUUID.magneticDeclination, .bit32(0x2A2C))

        /// Scan Refresh
        XCTAssertEqual(BluetoothUUID.scanRefresh.rawValue, "2A31")
        XCTAssertEqual(BluetoothUUID.scanRefresh, .bit16(0x2A31))
        XCTAssertEqual(BluetoothUUID.scanRefresh, .bit16(10801))
        XCTAssertEqual(BluetoothUUID.scanRefresh.name, "Scan Refresh")
        XCTAssertNotEqual(BluetoothUUID.scanRefresh, .bit32(10801))
        XCTAssertNotEqual(BluetoothUUID.scanRefresh, .bit32(0x2A31))

        /// Boot Keyboard Output Report
        XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport.rawValue, "2A32")
        XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport, .bit16(0x2A32))
        XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport, .bit16(10802))
        XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport.name, "Boot Keyboard Output Report")
        XCTAssertNotEqual(BluetoothUUID.bootKeyboardOutputReport, .bit32(10802))
        XCTAssertNotEqual(BluetoothUUID.bootKeyboardOutputReport, .bit32(0x2A32))

        /// Boot Mouse Input Report
        XCTAssertEqual(BluetoothUUID.bootMouseInputReport.rawValue, "2A33")
        XCTAssertEqual(BluetoothUUID.bootMouseInputReport, .bit16(0x2A33))
        XCTAssertEqual(BluetoothUUID.bootMouseInputReport, .bit16(10803))
        XCTAssertEqual(BluetoothUUID.bootMouseInputReport.name, "Boot Mouse Input Report")
        XCTAssertNotEqual(BluetoothUUID.bootMouseInputReport, .bit32(10803))
        XCTAssertNotEqual(BluetoothUUID.bootMouseInputReport, .bit32(0x2A33))

        /// Glucose Measurement Context
        XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext.rawValue, "2A34")
        XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext, .bit16(0x2A34))
        XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext, .bit16(10804))
        XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext.name, "Glucose Measurement Context")
        XCTAssertNotEqual(BluetoothUUID.glucoseMeasurementContext, .bit32(10804))
        XCTAssertNotEqual(BluetoothUUID.glucoseMeasurementContext, .bit32(0x2A34))

        /// Blood Pressure Measurement
        XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement.rawValue, "2A35")
        XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement, .bit16(0x2A35))
        XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement, .bit16(10805))
        XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement.name, "Blood Pressure Measurement")
        XCTAssertNotEqual(BluetoothUUID.bloodPressureMeasurement, .bit32(10805))
        XCTAssertNotEqual(BluetoothUUID.bloodPressureMeasurement, .bit32(0x2A35))

        /// Intermediate Cuff Pressure
        XCTAssertEqual(BluetoothUUID.intermediateCuffPressure.rawValue, "2A36")
        XCTAssertEqual(BluetoothUUID.intermediateCuffPressure, .bit16(0x2A36))
        XCTAssertEqual(BluetoothUUID.intermediateCuffPressure, .bit16(10806))
        XCTAssertEqual(BluetoothUUID.intermediateCuffPressure.name, "Intermediate Cuff Pressure")
        XCTAssertNotEqual(BluetoothUUID.intermediateCuffPressure, .bit32(10806))
        XCTAssertNotEqual(BluetoothUUID.intermediateCuffPressure, .bit32(0x2A36))

        /// Heart Rate Measurement
        XCTAssertEqual(BluetoothUUID.heartRateMeasurement.rawValue, "2A37")
        XCTAssertEqual(BluetoothUUID.heartRateMeasurement, .bit16(0x2A37))
        XCTAssertEqual(BluetoothUUID.heartRateMeasurement, .bit16(10807))
        XCTAssertEqual(BluetoothUUID.heartRateMeasurement.name, "Heart Rate Measurement")
        XCTAssertNotEqual(BluetoothUUID.heartRateMeasurement, .bit32(10807))
        XCTAssertNotEqual(BluetoothUUID.heartRateMeasurement, .bit32(0x2A37))

        /// Body Sensor Location
        XCTAssertEqual(BluetoothUUID.bodySensorLocation.rawValue, "2A38")
        XCTAssertEqual(BluetoothUUID.bodySensorLocation, .bit16(0x2A38))
        XCTAssertEqual(BluetoothUUID.bodySensorLocation, .bit16(10808))
        XCTAssertEqual(BluetoothUUID.bodySensorLocation.name, "Body Sensor Location")
        XCTAssertNotEqual(BluetoothUUID.bodySensorLocation, .bit32(10808))
        XCTAssertNotEqual(BluetoothUUID.bodySensorLocation, .bit32(0x2A38))

        /// Heart Rate Control Point
        XCTAssertEqual(BluetoothUUID.heartRateControlPoint.rawValue, "2A39")
        XCTAssertEqual(BluetoothUUID.heartRateControlPoint, .bit16(0x2A39))
        XCTAssertEqual(BluetoothUUID.heartRateControlPoint, .bit16(10809))
        XCTAssertEqual(BluetoothUUID.heartRateControlPoint.name, "Heart Rate Control Point")
        XCTAssertNotEqual(BluetoothUUID.heartRateControlPoint, .bit32(10809))
        XCTAssertNotEqual(BluetoothUUID.heartRateControlPoint, .bit32(0x2A39))

        /// Alert Status
        XCTAssertEqual(BluetoothUUID.alertStatus.rawValue, "2A3F")
        XCTAssertEqual(BluetoothUUID.alertStatus, .bit16(0x2A3F))
        XCTAssertEqual(BluetoothUUID.alertStatus, .bit16(10815))
        XCTAssertEqual(BluetoothUUID.alertStatus.name, "Alert Status")
        XCTAssertNotEqual(BluetoothUUID.alertStatus, .bit32(10815))
        XCTAssertNotEqual(BluetoothUUID.alertStatus, .bit32(0x2A3F))

        /// Ringer Control Point
        XCTAssertEqual(BluetoothUUID.ringerControlPoint.rawValue, "2A40")
        XCTAssertEqual(BluetoothUUID.ringerControlPoint, .bit16(0x2A40))
        XCTAssertEqual(BluetoothUUID.ringerControlPoint, .bit16(10816))
        XCTAssertEqual(BluetoothUUID.ringerControlPoint.name, "Ringer Control Point")
        XCTAssertNotEqual(BluetoothUUID.ringerControlPoint, .bit32(10816))
        XCTAssertNotEqual(BluetoothUUID.ringerControlPoint, .bit32(0x2A40))

        /// Ringer Setting
        XCTAssertEqual(BluetoothUUID.ringerSetting.rawValue, "2A41")
        XCTAssertEqual(BluetoothUUID.ringerSetting, .bit16(0x2A41))
        XCTAssertEqual(BluetoothUUID.ringerSetting, .bit16(10817))
        XCTAssertEqual(BluetoothUUID.ringerSetting.name, "Ringer Setting")
        XCTAssertNotEqual(BluetoothUUID.ringerSetting, .bit32(10817))
        XCTAssertNotEqual(BluetoothUUID.ringerSetting, .bit32(0x2A41))

        /// Alert Category ID Bit Mask
        XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask.rawValue, "2A42")
        XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask, .bit16(0x2A42))
        XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask, .bit16(10818))
        XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask.name, "Alert Category ID Bit Mask")
        XCTAssertNotEqual(BluetoothUUID.alertCategoryIdBitMask, .bit32(10818))
        XCTAssertNotEqual(BluetoothUUID.alertCategoryIdBitMask, .bit32(0x2A42))

        /// Alert Category ID
        XCTAssertEqual(BluetoothUUID.alertCategoryId.rawValue, "2A43")
        XCTAssertEqual(BluetoothUUID.alertCategoryId, .bit16(0x2A43))
        XCTAssertEqual(BluetoothUUID.alertCategoryId, .bit16(10819))
        XCTAssertEqual(BluetoothUUID.alertCategoryId.name, "Alert Category ID")
        XCTAssertNotEqual(BluetoothUUID.alertCategoryId, .bit32(10819))
        XCTAssertNotEqual(BluetoothUUID.alertCategoryId, .bit32(0x2A43))

        /// Alert Notification Control Point
        XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint.rawValue, "2A44")
        XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint, .bit16(0x2A44))
        XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint, .bit16(10820))
        XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint.name, "Alert Notification Control Point")
        XCTAssertNotEqual(BluetoothUUID.alertNotificationControlPoint, .bit32(10820))
        XCTAssertNotEqual(BluetoothUUID.alertNotificationControlPoint, .bit32(0x2A44))

        /// Unread Alert Status
        XCTAssertEqual(BluetoothUUID.unreadAlertStatus.rawValue, "2A45")
        XCTAssertEqual(BluetoothUUID.unreadAlertStatus, .bit16(0x2A45))
        XCTAssertEqual(BluetoothUUID.unreadAlertStatus, .bit16(10821))
        XCTAssertEqual(BluetoothUUID.unreadAlertStatus.name, "Unread Alert Status")
        XCTAssertNotEqual(BluetoothUUID.unreadAlertStatus, .bit32(10821))
        XCTAssertNotEqual(BluetoothUUID.unreadAlertStatus, .bit32(0x2A45))

        /// New Alert
        XCTAssertEqual(BluetoothUUID.newAlert.rawValue, "2A46")
        XCTAssertEqual(BluetoothUUID.newAlert, .bit16(0x2A46))
        XCTAssertEqual(BluetoothUUID.newAlert, .bit16(10822))
        XCTAssertEqual(BluetoothUUID.newAlert.name, "New Alert")
        XCTAssertNotEqual(BluetoothUUID.newAlert, .bit32(10822))
        XCTAssertNotEqual(BluetoothUUID.newAlert, .bit32(0x2A46))

        /// Supported New Alert Category
        XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory.rawValue, "2A47")
        XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory, .bit16(0x2A47))
        XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory, .bit16(10823))
        XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory.name, "Supported New Alert Category")
        XCTAssertNotEqual(BluetoothUUID.supportedNewAlertCategory, .bit32(10823))
        XCTAssertNotEqual(BluetoothUUID.supportedNewAlertCategory, .bit32(0x2A47))

        /// Supported Unread Alert Category
        XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory.rawValue, "2A48")
        XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit16(0x2A48))
        XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit16(10824))
        XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory.name, "Supported Unread Alert Category")
        XCTAssertNotEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit32(10824))
        XCTAssertNotEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit32(0x2A48))

        /// Blood Pressure Feature
        XCTAssertEqual(BluetoothUUID.bloodPressureFeature.rawValue, "2A49")
        XCTAssertEqual(BluetoothUUID.bloodPressureFeature, .bit16(0x2A49))
        XCTAssertEqual(BluetoothUUID.bloodPressureFeature, .bit16(10825))
        XCTAssertEqual(BluetoothUUID.bloodPressureFeature.name, "Blood Pressure Feature")
        XCTAssertNotEqual(BluetoothUUID.bloodPressureFeature, .bit32(10825))
        XCTAssertNotEqual(BluetoothUUID.bloodPressureFeature, .bit32(0x2A49))

        /// HID Information
        XCTAssertEqual(BluetoothUUID.hidInformation.rawValue, "2A4A")
        XCTAssertEqual(BluetoothUUID.hidInformation, .bit16(0x2A4A))
        XCTAssertEqual(BluetoothUUID.hidInformation, .bit16(10826))
        XCTAssertEqual(BluetoothUUID.hidInformation.name, "HID Information")
        XCTAssertNotEqual(BluetoothUUID.hidInformation, .bit32(10826))
        XCTAssertNotEqual(BluetoothUUID.hidInformation, .bit32(0x2A4A))

        /// Report Map
        XCTAssertEqual(BluetoothUUID.reportMap.rawValue, "2A4B")
        XCTAssertEqual(BluetoothUUID.reportMap, .bit16(0x2A4B))
        XCTAssertEqual(BluetoothUUID.reportMap, .bit16(10827))
        XCTAssertEqual(BluetoothUUID.reportMap.name, "Report Map")
        XCTAssertNotEqual(BluetoothUUID.reportMap, .bit32(10827))
        XCTAssertNotEqual(BluetoothUUID.reportMap, .bit32(0x2A4B))

        /// HID Control Point
        XCTAssertEqual(BluetoothUUID.hidControlPoint.rawValue, "2A4C")
        XCTAssertEqual(BluetoothUUID.hidControlPoint, .bit16(0x2A4C))
        XCTAssertEqual(BluetoothUUID.hidControlPoint, .bit16(10828))
        XCTAssertEqual(BluetoothUUID.hidControlPoint.name, "HID Control Point")
        XCTAssertNotEqual(BluetoothUUID.hidControlPoint, .bit32(10828))
        XCTAssertNotEqual(BluetoothUUID.hidControlPoint, .bit32(0x2A4C))

        /// Report
        XCTAssertEqual(BluetoothUUID.report.rawValue, "2A4D")
        XCTAssertEqual(BluetoothUUID.report, .bit16(0x2A4D))
        XCTAssertEqual(BluetoothUUID.report, .bit16(10829))
        XCTAssertEqual(BluetoothUUID.report.name, "Report")
        XCTAssertNotEqual(BluetoothUUID.report, .bit32(10829))
        XCTAssertNotEqual(BluetoothUUID.report, .bit32(0x2A4D))

        /// Protocol Mode
        XCTAssertEqual(BluetoothUUID.protocolMode.rawValue, "2A4E")
        XCTAssertEqual(BluetoothUUID.protocolMode, .bit16(0x2A4E))
        XCTAssertEqual(BluetoothUUID.protocolMode, .bit16(10830))
        XCTAssertEqual(BluetoothUUID.protocolMode.name, "Protocol Mode")
        XCTAssertNotEqual(BluetoothUUID.protocolMode, .bit32(10830))
        XCTAssertNotEqual(BluetoothUUID.protocolMode, .bit32(0x2A4E))

        /// Scan Interval Window
        XCTAssertEqual(BluetoothUUID.scanIntervalWindow.rawValue, "2A4F")
        XCTAssertEqual(BluetoothUUID.scanIntervalWindow, .bit16(0x2A4F))
        XCTAssertEqual(BluetoothUUID.scanIntervalWindow, .bit16(10831))
        XCTAssertEqual(BluetoothUUID.scanIntervalWindow.name, "Scan Interval Window")
        XCTAssertNotEqual(BluetoothUUID.scanIntervalWindow, .bit32(10831))
        XCTAssertNotEqual(BluetoothUUID.scanIntervalWindow, .bit32(0x2A4F))

        /// PnP ID
        XCTAssertEqual(BluetoothUUID.pnpId.rawValue, "2A50")
        XCTAssertEqual(BluetoothUUID.pnpId, .bit16(0x2A50))
        XCTAssertEqual(BluetoothUUID.pnpId, .bit16(10832))
        XCTAssertEqual(BluetoothUUID.pnpId.name, "PnP ID")
        XCTAssertNotEqual(BluetoothUUID.pnpId, .bit32(10832))
        XCTAssertNotEqual(BluetoothUUID.pnpId, .bit32(0x2A50))

        /// Glucose Feature
        XCTAssertEqual(BluetoothUUID.glucoseFeature.rawValue, "2A51")
        XCTAssertEqual(BluetoothUUID.glucoseFeature, .bit16(0x2A51))
        XCTAssertEqual(BluetoothUUID.glucoseFeature, .bit16(10833))
        XCTAssertEqual(BluetoothUUID.glucoseFeature.name, "Glucose Feature")
        XCTAssertNotEqual(BluetoothUUID.glucoseFeature, .bit32(10833))
        XCTAssertNotEqual(BluetoothUUID.glucoseFeature, .bit32(0x2A51))

        /// Record Access Control Point
        XCTAssertEqual(BluetoothUUID.recordAccessControlPoint.rawValue, "2A52")
        XCTAssertEqual(BluetoothUUID.recordAccessControlPoint, .bit16(0x2A52))
        XCTAssertEqual(BluetoothUUID.recordAccessControlPoint, .bit16(10834))
        XCTAssertEqual(BluetoothUUID.recordAccessControlPoint.name, "Record Access Control Point")
        XCTAssertNotEqual(BluetoothUUID.recordAccessControlPoint, .bit32(10834))
        XCTAssertNotEqual(BluetoothUUID.recordAccessControlPoint, .bit32(0x2A52))

        /// RSC Measurement
        XCTAssertEqual(BluetoothUUID.rscMeasurement.rawValue, "2A53")
        XCTAssertEqual(BluetoothUUID.rscMeasurement, .bit16(0x2A53))
        XCTAssertEqual(BluetoothUUID.rscMeasurement, .bit16(10835))
        XCTAssertEqual(BluetoothUUID.rscMeasurement.name, "RSC Measurement")
        XCTAssertNotEqual(BluetoothUUID.rscMeasurement, .bit32(10835))
        XCTAssertNotEqual(BluetoothUUID.rscMeasurement, .bit32(0x2A53))

        /// RSC Feature
        XCTAssertEqual(BluetoothUUID.rscFeature.rawValue, "2A54")
        XCTAssertEqual(BluetoothUUID.rscFeature, .bit16(0x2A54))
        XCTAssertEqual(BluetoothUUID.rscFeature, .bit16(10836))
        XCTAssertEqual(BluetoothUUID.rscFeature.name, "RSC Feature")
        XCTAssertNotEqual(BluetoothUUID.rscFeature, .bit32(10836))
        XCTAssertNotEqual(BluetoothUUID.rscFeature, .bit32(0x2A54))

        /// SC Control Point
        XCTAssertEqual(BluetoothUUID.scControlPoint.rawValue, "2A55")
        XCTAssertEqual(BluetoothUUID.scControlPoint, .bit16(0x2A55))
        XCTAssertEqual(BluetoothUUID.scControlPoint, .bit16(10837))
        XCTAssertEqual(BluetoothUUID.scControlPoint.name, "SC Control Point")
        XCTAssertNotEqual(BluetoothUUID.scControlPoint, .bit32(10837))
        XCTAssertNotEqual(BluetoothUUID.scControlPoint, .bit32(0x2A55))

        /// Digital
        XCTAssertEqual(BluetoothUUID.digital.rawValue, "2A56")
        XCTAssertEqual(BluetoothUUID.digital, .bit16(0x2A56))
        XCTAssertEqual(BluetoothUUID.digital, .bit16(10838))
        XCTAssertEqual(BluetoothUUID.digital.name, "Digital")
        XCTAssertNotEqual(BluetoothUUID.digital, .bit32(10838))
        XCTAssertNotEqual(BluetoothUUID.digital, .bit32(0x2A56))

        /// Analog
        XCTAssertEqual(BluetoothUUID.analog.rawValue, "2A58")
        XCTAssertEqual(BluetoothUUID.analog, .bit16(0x2A58))
        XCTAssertEqual(BluetoothUUID.analog, .bit16(10840))
        XCTAssertEqual(BluetoothUUID.analog.name, "Analog")
        XCTAssertNotEqual(BluetoothUUID.analog, .bit32(10840))
        XCTAssertNotEqual(BluetoothUUID.analog, .bit32(0x2A58))

        /// Analog Output
        XCTAssertEqual(BluetoothUUID.analogOutput.rawValue, "2A59")
        XCTAssertEqual(BluetoothUUID.analogOutput, .bit16(0x2A59))
        XCTAssertEqual(BluetoothUUID.analogOutput, .bit16(10841))
        XCTAssertEqual(BluetoothUUID.analogOutput.name, "Analog Output")
        XCTAssertNotEqual(BluetoothUUID.analogOutput, .bit32(10841))
        XCTAssertNotEqual(BluetoothUUID.analogOutput, .bit32(0x2A59))

        /// Aggregate
        XCTAssertEqual(BluetoothUUID.aggregate.rawValue, "2A5A")
        XCTAssertEqual(BluetoothUUID.aggregate, .bit16(0x2A5A))
        XCTAssertEqual(BluetoothUUID.aggregate, .bit16(10842))
        XCTAssertEqual(BluetoothUUID.aggregate.name, "Aggregate")
        XCTAssertNotEqual(BluetoothUUID.aggregate, .bit32(10842))
        XCTAssertNotEqual(BluetoothUUID.aggregate, .bit32(0x2A5A))

        /// CSC Measurement
        XCTAssertEqual(BluetoothUUID.cscMeasurement.rawValue, "2A5B")
        XCTAssertEqual(BluetoothUUID.cscMeasurement, .bit16(0x2A5B))
        XCTAssertEqual(BluetoothUUID.cscMeasurement, .bit16(10843))
        XCTAssertEqual(BluetoothUUID.cscMeasurement.name, "CSC Measurement")
        XCTAssertNotEqual(BluetoothUUID.cscMeasurement, .bit32(10843))
        XCTAssertNotEqual(BluetoothUUID.cscMeasurement, .bit32(0x2A5B))

        /// CSC Feature
        XCTAssertEqual(BluetoothUUID.cscFeature.rawValue, "2A5C")
        XCTAssertEqual(BluetoothUUID.cscFeature, .bit16(0x2A5C))
        XCTAssertEqual(BluetoothUUID.cscFeature, .bit16(10844))
        XCTAssertEqual(BluetoothUUID.cscFeature.name, "CSC Feature")
        XCTAssertNotEqual(BluetoothUUID.cscFeature, .bit32(10844))
        XCTAssertNotEqual(BluetoothUUID.cscFeature, .bit32(0x2A5C))

        /// Sensor Location
        XCTAssertEqual(BluetoothUUID.sensorLocation.rawValue, "2A5D")
        XCTAssertEqual(BluetoothUUID.sensorLocation, .bit16(0x2A5D))
        XCTAssertEqual(BluetoothUUID.sensorLocation, .bit16(10845))
        XCTAssertEqual(BluetoothUUID.sensorLocation.name, "Sensor Location")
        XCTAssertNotEqual(BluetoothUUID.sensorLocation, .bit32(10845))
        XCTAssertNotEqual(BluetoothUUID.sensorLocation, .bit32(0x2A5D))

        /// Cycling Power Measurement
        XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement.rawValue, "2A63")
        XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement, .bit16(0x2A63))
        XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement, .bit16(10851))
        XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement.name, "Cycling Power Measurement")
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerMeasurement, .bit32(10851))
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerMeasurement, .bit32(0x2A63))

        /// Cycling Power Vector
        XCTAssertEqual(BluetoothUUID.cyclingPowerVector.rawValue, "2A64")
        XCTAssertEqual(BluetoothUUID.cyclingPowerVector, .bit16(0x2A64))
        XCTAssertEqual(BluetoothUUID.cyclingPowerVector, .bit16(10852))
        XCTAssertEqual(BluetoothUUID.cyclingPowerVector.name, "Cycling Power Vector")
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerVector, .bit32(10852))
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerVector, .bit32(0x2A64))

        /// Cycling Power Feature
        XCTAssertEqual(BluetoothUUID.cyclingPowerFeature.rawValue, "2A65")
        XCTAssertEqual(BluetoothUUID.cyclingPowerFeature, .bit16(0x2A65))
        XCTAssertEqual(BluetoothUUID.cyclingPowerFeature, .bit16(10853))
        XCTAssertEqual(BluetoothUUID.cyclingPowerFeature.name, "Cycling Power Feature")
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerFeature, .bit32(10853))
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerFeature, .bit32(0x2A65))

        /// Cycling Power Control Point
        XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint.rawValue, "2A66")
        XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint, .bit16(0x2A66))
        XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint, .bit16(10854))
        XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint.name, "Cycling Power Control Point")
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerControlPoint, .bit32(10854))
        XCTAssertNotEqual(BluetoothUUID.cyclingPowerControlPoint, .bit32(0x2A66))

        /// Location and Speed
        XCTAssertEqual(BluetoothUUID.locationAndSpeed.rawValue, "2A67")
        XCTAssertEqual(BluetoothUUID.locationAndSpeed, .bit16(0x2A67))
        XCTAssertEqual(BluetoothUUID.locationAndSpeed, .bit16(10855))
        XCTAssertEqual(BluetoothUUID.locationAndSpeed.name, "Location and Speed")
        XCTAssertNotEqual(BluetoothUUID.locationAndSpeed, .bit32(10855))
        XCTAssertNotEqual(BluetoothUUID.locationAndSpeed, .bit32(0x2A67))

        /// Navigation
        XCTAssertEqual(BluetoothUUID.navigation.rawValue, "2A68")
        XCTAssertEqual(BluetoothUUID.navigation, .bit16(0x2A68))
        XCTAssertEqual(BluetoothUUID.navigation, .bit16(10856))
        XCTAssertEqual(BluetoothUUID.navigation.name, "Navigation")
        XCTAssertNotEqual(BluetoothUUID.navigation, .bit32(10856))
        XCTAssertNotEqual(BluetoothUUID.navigation, .bit32(0x2A68))

        /// Position Quality
        XCTAssertEqual(BluetoothUUID.positionQuality.rawValue, "2A69")
        XCTAssertEqual(BluetoothUUID.positionQuality, .bit16(0x2A69))
        XCTAssertEqual(BluetoothUUID.positionQuality, .bit16(10857))
        XCTAssertEqual(BluetoothUUID.positionQuality.name, "Position Quality")
        XCTAssertNotEqual(BluetoothUUID.positionQuality, .bit32(10857))
        XCTAssertNotEqual(BluetoothUUID.positionQuality, .bit32(0x2A69))

        /// LN Feature
        XCTAssertEqual(BluetoothUUID.lnFeature.rawValue, "2A6A")
        XCTAssertEqual(BluetoothUUID.lnFeature, .bit16(0x2A6A))
        XCTAssertEqual(BluetoothUUID.lnFeature, .bit16(10858))
        XCTAssertEqual(BluetoothUUID.lnFeature.name, "LN Feature")
        XCTAssertNotEqual(BluetoothUUID.lnFeature, .bit32(10858))
        XCTAssertNotEqual(BluetoothUUID.lnFeature, .bit32(0x2A6A))

        /// LN Control Point
        XCTAssertEqual(BluetoothUUID.lnControlPoint.rawValue, "2A6B")
        XCTAssertEqual(BluetoothUUID.lnControlPoint, .bit16(0x2A6B))
        XCTAssertEqual(BluetoothUUID.lnControlPoint, .bit16(10859))
        XCTAssertEqual(BluetoothUUID.lnControlPoint.name, "LN Control Point")
        XCTAssertNotEqual(BluetoothUUID.lnControlPoint, .bit32(10859))
        XCTAssertNotEqual(BluetoothUUID.lnControlPoint, .bit32(0x2A6B))

        /// Elevation
        XCTAssertEqual(BluetoothUUID.elevation.rawValue, "2A6C")
        XCTAssertEqual(BluetoothUUID.elevation, .bit16(0x2A6C))
        XCTAssertEqual(BluetoothUUID.elevation, .bit16(10860))
        XCTAssertEqual(BluetoothUUID.elevation.name, "Elevation")
        XCTAssertNotEqual(BluetoothUUID.elevation, .bit32(10860))
        XCTAssertNotEqual(BluetoothUUID.elevation, .bit32(0x2A6C))

        /// Pressure
        XCTAssertEqual(BluetoothUUID.pressure.rawValue, "2A6D")
        XCTAssertEqual(BluetoothUUID.pressure, .bit16(0x2A6D))
        XCTAssertEqual(BluetoothUUID.pressure, .bit16(10861))
        XCTAssertEqual(BluetoothUUID.pressure.name, "Pressure")
        XCTAssertNotEqual(BluetoothUUID.pressure, .bit32(10861))
        XCTAssertNotEqual(BluetoothUUID.pressure, .bit32(0x2A6D))

        /// Temperature
        XCTAssertEqual(BluetoothUUID.temperature.rawValue, "2A6E")
        XCTAssertEqual(BluetoothUUID.temperature, .bit16(0x2A6E))
        XCTAssertEqual(BluetoothUUID.temperature, .bit16(10862))
        XCTAssertEqual(BluetoothUUID.temperature.name, "Temperature")
        XCTAssertNotEqual(BluetoothUUID.temperature, .bit32(10862))
        XCTAssertNotEqual(BluetoothUUID.temperature, .bit32(0x2A6E))

        /// Humidity
        XCTAssertEqual(BluetoothUUID.humidity.rawValue, "2A6F")
        XCTAssertEqual(BluetoothUUID.humidity, .bit16(0x2A6F))
        XCTAssertEqual(BluetoothUUID.humidity, .bit16(10863))
        XCTAssertEqual(BluetoothUUID.humidity.name, "Humidity")
        XCTAssertNotEqual(BluetoothUUID.humidity, .bit32(10863))
        XCTAssertNotEqual(BluetoothUUID.humidity, .bit32(0x2A6F))

        /// True Wind Speed
        XCTAssertEqual(BluetoothUUID.trueWindSpeed.rawValue, "2A70")
        XCTAssertEqual(BluetoothUUID.trueWindSpeed, .bit16(0x2A70))
        XCTAssertEqual(BluetoothUUID.trueWindSpeed, .bit16(10864))
        XCTAssertEqual(BluetoothUUID.trueWindSpeed.name, "True Wind Speed")
        XCTAssertNotEqual(BluetoothUUID.trueWindSpeed, .bit32(10864))
        XCTAssertNotEqual(BluetoothUUID.trueWindSpeed, .bit32(0x2A70))

        /// True Wind Direction
        XCTAssertEqual(BluetoothUUID.trueWindDirection.rawValue, "2A71")
        XCTAssertEqual(BluetoothUUID.trueWindDirection, .bit16(0x2A71))
        XCTAssertEqual(BluetoothUUID.trueWindDirection, .bit16(10865))
        XCTAssertEqual(BluetoothUUID.trueWindDirection.name, "True Wind Direction")
        XCTAssertNotEqual(BluetoothUUID.trueWindDirection, .bit32(10865))
        XCTAssertNotEqual(BluetoothUUID.trueWindDirection, .bit32(0x2A71))

        /// Apparent Wind Speed
        XCTAssertEqual(BluetoothUUID.apparentWindSpeed.rawValue, "2A72")
        XCTAssertEqual(BluetoothUUID.apparentWindSpeed, .bit16(0x2A72))
        XCTAssertEqual(BluetoothUUID.apparentWindSpeed, .bit16(10866))
        XCTAssertEqual(BluetoothUUID.apparentWindSpeed.name, "Apparent Wind Speed")
        XCTAssertNotEqual(BluetoothUUID.apparentWindSpeed, .bit32(10866))
        XCTAssertNotEqual(BluetoothUUID.apparentWindSpeed, .bit32(0x2A72))

        /// Apparent Wind Direction
        XCTAssertEqual(BluetoothUUID.apparentWindDirection.rawValue, "2A73")
        XCTAssertEqual(BluetoothUUID.apparentWindDirection, .bit16(0x2A73))
        XCTAssertEqual(BluetoothUUID.apparentWindDirection, .bit16(10867))
        XCTAssertEqual(BluetoothUUID.apparentWindDirection.name, "Apparent Wind Direction")
        XCTAssertNotEqual(BluetoothUUID.apparentWindDirection, .bit32(10867))
        XCTAssertNotEqual(BluetoothUUID.apparentWindDirection, .bit32(0x2A73))

        /// Gust Factor
        XCTAssertEqual(BluetoothUUID.gustFactor.rawValue, "2A74")
        XCTAssertEqual(BluetoothUUID.gustFactor, .bit16(0x2A74))
        XCTAssertEqual(BluetoothUUID.gustFactor, .bit16(10868))
        XCTAssertEqual(BluetoothUUID.gustFactor.name, "Gust Factor")
        XCTAssertNotEqual(BluetoothUUID.gustFactor, .bit32(10868))
        XCTAssertNotEqual(BluetoothUUID.gustFactor, .bit32(0x2A74))

        /// Pollen Concentration
        XCTAssertEqual(BluetoothUUID.pollenConcentration.rawValue, "2A75")
        XCTAssertEqual(BluetoothUUID.pollenConcentration, .bit16(0x2A75))
        XCTAssertEqual(BluetoothUUID.pollenConcentration, .bit16(10869))
        XCTAssertEqual(BluetoothUUID.pollenConcentration.name, "Pollen Concentration")
        XCTAssertNotEqual(BluetoothUUID.pollenConcentration, .bit32(10869))
        XCTAssertNotEqual(BluetoothUUID.pollenConcentration, .bit32(0x2A75))

        /// UV Index
        XCTAssertEqual(BluetoothUUID.uvIndex.rawValue, "2A76")
        XCTAssertEqual(BluetoothUUID.uvIndex, .bit16(0x2A76))
        XCTAssertEqual(BluetoothUUID.uvIndex, .bit16(10870))
        XCTAssertEqual(BluetoothUUID.uvIndex.name, "UV Index")
        XCTAssertNotEqual(BluetoothUUID.uvIndex, .bit32(10870))
        XCTAssertNotEqual(BluetoothUUID.uvIndex, .bit32(0x2A76))

        /// Irradiance
        XCTAssertEqual(BluetoothUUID.irradiance.rawValue, "2A77")
        XCTAssertEqual(BluetoothUUID.irradiance, .bit16(0x2A77))
        XCTAssertEqual(BluetoothUUID.irradiance, .bit16(10871))
        XCTAssertEqual(BluetoothUUID.irradiance.name, "Irradiance")
        XCTAssertNotEqual(BluetoothUUID.irradiance, .bit32(10871))
        XCTAssertNotEqual(BluetoothUUID.irradiance, .bit32(0x2A77))

        /// Rainfall
        XCTAssertEqual(BluetoothUUID.rainfall.rawValue, "2A78")
        XCTAssertEqual(BluetoothUUID.rainfall, .bit16(0x2A78))
        XCTAssertEqual(BluetoothUUID.rainfall, .bit16(10872))
        XCTAssertEqual(BluetoothUUID.rainfall.name, "Rainfall")
        XCTAssertNotEqual(BluetoothUUID.rainfall, .bit32(10872))
        XCTAssertNotEqual(BluetoothUUID.rainfall, .bit32(0x2A78))

        /// Wind Chill
        XCTAssertEqual(BluetoothUUID.windChill.rawValue, "2A79")
        XCTAssertEqual(BluetoothUUID.windChill, .bit16(0x2A79))
        XCTAssertEqual(BluetoothUUID.windChill, .bit16(10873))
        XCTAssertEqual(BluetoothUUID.windChill.name, "Wind Chill")
        XCTAssertNotEqual(BluetoothUUID.windChill, .bit32(10873))
        XCTAssertNotEqual(BluetoothUUID.windChill, .bit32(0x2A79))

        /// Heat Index
        XCTAssertEqual(BluetoothUUID.heatIndex.rawValue, "2A7A")
        XCTAssertEqual(BluetoothUUID.heatIndex, .bit16(0x2A7A))
        XCTAssertEqual(BluetoothUUID.heatIndex, .bit16(10874))
        XCTAssertEqual(BluetoothUUID.heatIndex.name, "Heat Index")
        XCTAssertNotEqual(BluetoothUUID.heatIndex, .bit32(10874))
        XCTAssertNotEqual(BluetoothUUID.heatIndex, .bit32(0x2A7A))

        /// Dew Point
        XCTAssertEqual(BluetoothUUID.dewPoint.rawValue, "2A7B")
        XCTAssertEqual(BluetoothUUID.dewPoint, .bit16(0x2A7B))
        XCTAssertEqual(BluetoothUUID.dewPoint, .bit16(10875))
        XCTAssertEqual(BluetoothUUID.dewPoint.name, "Dew Point")
        XCTAssertNotEqual(BluetoothUUID.dewPoint, .bit32(10875))
        XCTAssertNotEqual(BluetoothUUID.dewPoint, .bit32(0x2A7B))

        /// Trend
        XCTAssertEqual(BluetoothUUID.trend.rawValue, "2A7C")
        XCTAssertEqual(BluetoothUUID.trend, .bit16(0x2A7C))
        XCTAssertEqual(BluetoothUUID.trend, .bit16(10876))
        XCTAssertEqual(BluetoothUUID.trend.name, "Trend")
        XCTAssertNotEqual(BluetoothUUID.trend, .bit32(10876))
        XCTAssertNotEqual(BluetoothUUID.trend, .bit32(0x2A7C))

        /// Descriptor Value Changed
        XCTAssertEqual(BluetoothUUID.descriptorValueChanged.rawValue, "2A7D")
        XCTAssertEqual(BluetoothUUID.descriptorValueChanged, .bit16(0x2A7D))
        XCTAssertEqual(BluetoothUUID.descriptorValueChanged, .bit16(10877))
        XCTAssertEqual(BluetoothUUID.descriptorValueChanged.name, "Descriptor Value Changed")
        XCTAssertNotEqual(BluetoothUUID.descriptorValueChanged, .bit32(10877))
        XCTAssertNotEqual(BluetoothUUID.descriptorValueChanged, .bit32(0x2A7D))

        /// Aerobic Heart Rate Lower Limit
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit.rawValue, "2A7E")
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit16(0x2A7E))
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit16(10878))
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit.name, "Aerobic Heart Rate Lower Limit")
        XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit32(10878))
        XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit32(0x2A7E))

        /// Aerobic Threshold
        XCTAssertEqual(BluetoothUUID.aerobicThreshold.rawValue, "2A7F")
        XCTAssertEqual(BluetoothUUID.aerobicThreshold, .bit16(0x2A7F))
        XCTAssertEqual(BluetoothUUID.aerobicThreshold, .bit16(10879))
        XCTAssertEqual(BluetoothUUID.aerobicThreshold.name, "Aerobic Threshold")
        XCTAssertNotEqual(BluetoothUUID.aerobicThreshold, .bit32(10879))
        XCTAssertNotEqual(BluetoothUUID.aerobicThreshold, .bit32(0x2A7F))

        /// Age
        XCTAssertEqual(BluetoothUUID.age.rawValue, "2A80")
        XCTAssertEqual(BluetoothUUID.age, .bit16(0x2A80))
        XCTAssertEqual(BluetoothUUID.age, .bit16(10880))
        XCTAssertEqual(BluetoothUUID.age.name, "Age")
        XCTAssertNotEqual(BluetoothUUID.age, .bit32(10880))
        XCTAssertNotEqual(BluetoothUUID.age, .bit32(0x2A80))

        /// Anaerobic Heart Rate Lower Limit
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit.rawValue, "2A81")
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit16(0x2A81))
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit16(10881))
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit.name, "Anaerobic Heart Rate Lower Limit")
        XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit32(10881))
        XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit32(0x2A81))

        /// Anaerobic Heart Rate Upper Limit
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit.rawValue, "2A82")
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit16(0x2A82))
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit16(10882))
        XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit.name, "Anaerobic Heart Rate Upper Limit")
        XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit32(10882))
        XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit32(0x2A82))

        /// Anaerobic Threshold
        XCTAssertEqual(BluetoothUUID.anaerobicThreshold.rawValue, "2A83")
        XCTAssertEqual(BluetoothUUID.anaerobicThreshold, .bit16(0x2A83))
        XCTAssertEqual(BluetoothUUID.anaerobicThreshold, .bit16(10883))
        XCTAssertEqual(BluetoothUUID.anaerobicThreshold.name, "Anaerobic Threshold")
        XCTAssertNotEqual(BluetoothUUID.anaerobicThreshold, .bit32(10883))
        XCTAssertNotEqual(BluetoothUUID.anaerobicThreshold, .bit32(0x2A83))

        /// Aerobic Heart Rate Upper Limit
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit.rawValue, "2A84")
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit16(0x2A84))
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit16(10884))
        XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit.name, "Aerobic Heart Rate Upper Limit")
        XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit32(10884))
        XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit32(0x2A84))

        /// Date of Birth
        XCTAssertEqual(BluetoothUUID.dateOfBirth.rawValue, "2A85")
        XCTAssertEqual(BluetoothUUID.dateOfBirth, .bit16(0x2A85))
        XCTAssertEqual(BluetoothUUID.dateOfBirth, .bit16(10885))
        XCTAssertEqual(BluetoothUUID.dateOfBirth.name, "Date of Birth")
        XCTAssertNotEqual(BluetoothUUID.dateOfBirth, .bit32(10885))
        XCTAssertNotEqual(BluetoothUUID.dateOfBirth, .bit32(0x2A85))

        /// Date of Threshold Assessment
        XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment.rawValue, "2A86")
        XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment, .bit16(0x2A86))
        XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment, .bit16(10886))
        XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment.name, "Date of Threshold Assessment")
        XCTAssertNotEqual(BluetoothUUID.dateOfThresholdAssessment, .bit32(10886))
        XCTAssertNotEqual(BluetoothUUID.dateOfThresholdAssessment, .bit32(0x2A86))

        /// Email Address
        XCTAssertEqual(BluetoothUUID.emailAddress.rawValue, "2A87")
        XCTAssertEqual(BluetoothUUID.emailAddress, .bit16(0x2A87))
        XCTAssertEqual(BluetoothUUID.emailAddress, .bit16(10887))
        XCTAssertEqual(BluetoothUUID.emailAddress.name, "Email Address")
        XCTAssertNotEqual(BluetoothUUID.emailAddress, .bit32(10887))
        XCTAssertNotEqual(BluetoothUUID.emailAddress, .bit32(0x2A87))

        /// Fat Burn Heart Rate Lower Limit
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit.rawValue, "2A88")
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit16(0x2A88))
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit16(10888))
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit.name, "Fat Burn Heart Rate Lower Limit")
        XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit32(10888))
        XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit32(0x2A88))

        /// Fat Burn Heart Rate Upper Limit
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit.rawValue, "2A89")
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit16(0x2A89))
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit16(10889))
        XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit.name, "Fat Burn Heart Rate Upper Limit")
        XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit32(10889))
        XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit32(0x2A89))

        /// First Name
        XCTAssertEqual(BluetoothUUID.firstName.rawValue, "2A8A")
        XCTAssertEqual(BluetoothUUID.firstName, .bit16(0x2A8A))
        XCTAssertEqual(BluetoothUUID.firstName, .bit16(10890))
        XCTAssertEqual(BluetoothUUID.firstName.name, "First Name")
        XCTAssertNotEqual(BluetoothUUID.firstName, .bit32(10890))
        XCTAssertNotEqual(BluetoothUUID.firstName, .bit32(0x2A8A))

        /// Five Zone Heart Rate Limits
        XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits.rawValue, "2A8B")
        XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit16(0x2A8B))
        XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit16(10891))
        XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits.name, "Five Zone Heart Rate Limits")
        XCTAssertNotEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit32(10891))
        XCTAssertNotEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit32(0x2A8B))

        /// Gender
        XCTAssertEqual(BluetoothUUID.gender.rawValue, "2A8C")
        XCTAssertEqual(BluetoothUUID.gender, .bit16(0x2A8C))
        XCTAssertEqual(BluetoothUUID.gender, .bit16(10892))
        XCTAssertEqual(BluetoothUUID.gender.name, "Gender")
        XCTAssertNotEqual(BluetoothUUID.gender, .bit32(10892))
        XCTAssertNotEqual(BluetoothUUID.gender, .bit32(0x2A8C))

        /// Heart Rate Max
        XCTAssertEqual(BluetoothUUID.heartRateMax.rawValue, "2A8D")
        XCTAssertEqual(BluetoothUUID.heartRateMax, .bit16(0x2A8D))
        XCTAssertEqual(BluetoothUUID.heartRateMax, .bit16(10893))
        XCTAssertEqual(BluetoothUUID.heartRateMax.name, "Heart Rate Max")
        XCTAssertNotEqual(BluetoothUUID.heartRateMax, .bit32(10893))
        XCTAssertNotEqual(BluetoothUUID.heartRateMax, .bit32(0x2A8D))

        /// Height
        XCTAssertEqual(BluetoothUUID.height.rawValue, "2A8E")
        XCTAssertEqual(BluetoothUUID.height, .bit16(0x2A8E))
        XCTAssertEqual(BluetoothUUID.height, .bit16(10894))
        XCTAssertEqual(BluetoothUUID.height.name, "Height")
        XCTAssertNotEqual(BluetoothUUID.height, .bit32(10894))
        XCTAssertNotEqual(BluetoothUUID.height, .bit32(0x2A8E))

        /// Hip Circumference
        XCTAssertEqual(BluetoothUUID.hipCircumference.rawValue, "2A8F")
        XCTAssertEqual(BluetoothUUID.hipCircumference, .bit16(0x2A8F))
        XCTAssertEqual(BluetoothUUID.hipCircumference, .bit16(10895))
        XCTAssertEqual(BluetoothUUID.hipCircumference.name, "Hip Circumference")
        XCTAssertNotEqual(BluetoothUUID.hipCircumference, .bit32(10895))
        XCTAssertNotEqual(BluetoothUUID.hipCircumference, .bit32(0x2A8F))

        /// Last Name
        XCTAssertEqual(BluetoothUUID.lastName.rawValue, "2A90")
        XCTAssertEqual(BluetoothUUID.lastName, .bit16(0x2A90))
        XCTAssertEqual(BluetoothUUID.lastName, .bit16(10896))
        XCTAssertEqual(BluetoothUUID.lastName.name, "Last Name")
        XCTAssertNotEqual(BluetoothUUID.lastName, .bit32(10896))
        XCTAssertNotEqual(BluetoothUUID.lastName, .bit32(0x2A90))

        /// Maximum Recommended Heart Rate
        XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate.rawValue, "2A91")
        XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit16(0x2A91))
        XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit16(10897))
        XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate.name, "Maximum Recommended Heart Rate")
        XCTAssertNotEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit32(10897))
        XCTAssertNotEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit32(0x2A91))

        /// Resting Heart Rate
        XCTAssertEqual(BluetoothUUID.restingHeartRate.rawValue, "2A92")
        XCTAssertEqual(BluetoothUUID.restingHeartRate, .bit16(0x2A92))
        XCTAssertEqual(BluetoothUUID.restingHeartRate, .bit16(10898))
        XCTAssertEqual(BluetoothUUID.restingHeartRate.name, "Resting Heart Rate")
        XCTAssertNotEqual(BluetoothUUID.restingHeartRate, .bit32(10898))
        XCTAssertNotEqual(BluetoothUUID.restingHeartRate, .bit32(0x2A92))

        /// Sport Type for Aerobic/Anaerobic Thresholds
        XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.rawValue, "2A93")
        XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit16(0x2A93))
        XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit16(10899))
        XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.name, "Sport Type for Aerobic/Anaerobic Thresholds")
        XCTAssertNotEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit32(10899))
        XCTAssertNotEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit32(0x2A93))

        /// Three Zone Heart Rate Limits
        XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits.rawValue, "2A94")
        XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit16(0x2A94))
        XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit16(10900))
        XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits.name, "Three Zone Heart Rate Limits")
        XCTAssertNotEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit32(10900))
        XCTAssertNotEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit32(0x2A94))

        /// Two Zone Heart Rate Limit
        XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit.rawValue, "2A95")
        XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit16(0x2A95))
        XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit16(10901))
        XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit.name, "Two Zone Heart Rate Limit")
        XCTAssertNotEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit32(10901))
        XCTAssertNotEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit32(0x2A95))

        /// VO2 Max
        XCTAssertEqual(BluetoothUUID.vo2Max.rawValue, "2A96")
        XCTAssertEqual(BluetoothUUID.vo2Max, .bit16(0x2A96))
        XCTAssertEqual(BluetoothUUID.vo2Max, .bit16(10902))
        XCTAssertEqual(BluetoothUUID.vo2Max.name, "VO2 Max")
        XCTAssertNotEqual(BluetoothUUID.vo2Max, .bit32(10902))
        XCTAssertNotEqual(BluetoothUUID.vo2Max, .bit32(0x2A96))

        /// Waist Circumference
        XCTAssertEqual(BluetoothUUID.waistCircumference.rawValue, "2A97")
        XCTAssertEqual(BluetoothUUID.waistCircumference, .bit16(0x2A97))
        XCTAssertEqual(BluetoothUUID.waistCircumference, .bit16(10903))
        XCTAssertEqual(BluetoothUUID.waistCircumference.name, "Waist Circumference")
        XCTAssertNotEqual(BluetoothUUID.waistCircumference, .bit32(10903))
        XCTAssertNotEqual(BluetoothUUID.waistCircumference, .bit32(0x2A97))

        /// Weight
        XCTAssertEqual(BluetoothUUID.weight.rawValue, "2A98")
        XCTAssertEqual(BluetoothUUID.weight, .bit16(0x2A98))
        XCTAssertEqual(BluetoothUUID.weight, .bit16(10904))
        XCTAssertEqual(BluetoothUUID.weight.name, "Weight")
        XCTAssertNotEqual(BluetoothUUID.weight, .bit32(10904))
        XCTAssertNotEqual(BluetoothUUID.weight, .bit32(0x2A98))

        /// Database Change Increment
        XCTAssertEqual(BluetoothUUID.databaseChangerement.rawValue, "2A99")
        XCTAssertEqual(BluetoothUUID.databaseChangerement, .bit16(0x2A99))
        XCTAssertEqual(BluetoothUUID.databaseChangerement, .bit16(10905))
        XCTAssertEqual(BluetoothUUID.databaseChangerement.name, "Database Change Increment")
        XCTAssertNotEqual(BluetoothUUID.databaseChangerement, .bit32(10905))
        XCTAssertNotEqual(BluetoothUUID.databaseChangerement, .bit32(0x2A99))

        /// User Index
        XCTAssertEqual(BluetoothUUID.userIndex.rawValue, "2A9A")
        XCTAssertEqual(BluetoothUUID.userIndex, .bit16(0x2A9A))
        XCTAssertEqual(BluetoothUUID.userIndex, .bit16(10906))
        XCTAssertEqual(BluetoothUUID.userIndex.name, "User Index")
        XCTAssertNotEqual(BluetoothUUID.userIndex, .bit32(10906))
        XCTAssertNotEqual(BluetoothUUID.userIndex, .bit32(0x2A9A))

        /// Body Composition Feature
        XCTAssertEqual(BluetoothUUID.bodyCompositionFeature.rawValue, "2A9B")
        XCTAssertEqual(BluetoothUUID.bodyCompositionFeature, .bit16(0x2A9B))
        XCTAssertEqual(BluetoothUUID.bodyCompositionFeature, .bit16(10907))
        XCTAssertEqual(BluetoothUUID.bodyCompositionFeature.name, "Body Composition Feature")
        XCTAssertNotEqual(BluetoothUUID.bodyCompositionFeature, .bit32(10907))
        XCTAssertNotEqual(BluetoothUUID.bodyCompositionFeature, .bit32(0x2A9B))

        /// Body Composition Measurement
        XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement.rawValue, "2A9C")
        XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement, .bit16(0x2A9C))
        XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement, .bit16(10908))
        XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement.name, "Body Composition Measurement")
        XCTAssertNotEqual(BluetoothUUID.bodyCompositionMeasurement, .bit32(10908))
        XCTAssertNotEqual(BluetoothUUID.bodyCompositionMeasurement, .bit32(0x2A9C))

        /// Weight Measurement
        XCTAssertEqual(BluetoothUUID.weightMeasurement.rawValue, "2A9D")
        XCTAssertEqual(BluetoothUUID.weightMeasurement, .bit16(0x2A9D))
        XCTAssertEqual(BluetoothUUID.weightMeasurement, .bit16(10909))
        XCTAssertEqual(BluetoothUUID.weightMeasurement.name, "Weight Measurement")
        XCTAssertNotEqual(BluetoothUUID.weightMeasurement, .bit32(10909))
        XCTAssertNotEqual(BluetoothUUID.weightMeasurement, .bit32(0x2A9D))

        /// Weight Scale Feature
        XCTAssertEqual(BluetoothUUID.weightScaleFeature.rawValue, "2A9E")
        XCTAssertEqual(BluetoothUUID.weightScaleFeature, .bit16(0x2A9E))
        XCTAssertEqual(BluetoothUUID.weightScaleFeature, .bit16(10910))
        XCTAssertEqual(BluetoothUUID.weightScaleFeature.name, "Weight Scale Feature")
        XCTAssertNotEqual(BluetoothUUID.weightScaleFeature, .bit32(10910))
        XCTAssertNotEqual(BluetoothUUID.weightScaleFeature, .bit32(0x2A9E))

        /// User Control Point
        XCTAssertEqual(BluetoothUUID.userControlPoint.rawValue, "2A9F")
        XCTAssertEqual(BluetoothUUID.userControlPoint, .bit16(0x2A9F))
        XCTAssertEqual(BluetoothUUID.userControlPoint, .bit16(10911))
        XCTAssertEqual(BluetoothUUID.userControlPoint.name, "User Control Point")
        XCTAssertNotEqual(BluetoothUUID.userControlPoint, .bit32(10911))
        XCTAssertNotEqual(BluetoothUUID.userControlPoint, .bit32(0x2A9F))

        /// Magnetic Flux Density - 2D
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D.rawValue, "2AA0")
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D, .bit16(0x2AA0))
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D, .bit16(10912))
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D.name, "Magnetic Flux Density - 2D")
        XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity2D, .bit32(10912))
        XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity2D, .bit32(0x2AA0))

        /// Magnetic Flux Density - 3D
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D.rawValue, "2AA1")
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D, .bit16(0x2AA1))
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D, .bit16(10913))
        XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D.name, "Magnetic Flux Density - 3D")
        XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity3D, .bit32(10913))
        XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity3D, .bit32(0x2AA1))

        /// Language
        XCTAssertEqual(BluetoothUUID.language.rawValue, "2AA2")
        XCTAssertEqual(BluetoothUUID.language, .bit16(0x2AA2))
        XCTAssertEqual(BluetoothUUID.language, .bit16(10914))
        XCTAssertEqual(BluetoothUUID.language.name, "Language")
        XCTAssertNotEqual(BluetoothUUID.language, .bit32(10914))
        XCTAssertNotEqual(BluetoothUUID.language, .bit32(0x2AA2))

        /// Barometric Pressure Trend
        XCTAssertEqual(BluetoothUUID.barometricPressureTrend.rawValue, "2AA3")
        XCTAssertEqual(BluetoothUUID.barometricPressureTrend, .bit16(0x2AA3))
        XCTAssertEqual(BluetoothUUID.barometricPressureTrend, .bit16(10915))
        XCTAssertEqual(BluetoothUUID.barometricPressureTrend.name, "Barometric Pressure Trend")
        XCTAssertNotEqual(BluetoothUUID.barometricPressureTrend, .bit32(10915))
        XCTAssertNotEqual(BluetoothUUID.barometricPressureTrend, .bit32(0x2AA3))

        /// Bond Management Control Point
        XCTAssertEqual(BluetoothUUID.bondManagementControlPoint.rawValue, "2AA4")
        XCTAssertEqual(BluetoothUUID.bondManagementControlPoint, .bit16(0x2AA4))
        XCTAssertEqual(BluetoothUUID.bondManagementControlPoint, .bit16(10916))
        XCTAssertEqual(BluetoothUUID.bondManagementControlPoint.name, "Bond Management Control Point")
        XCTAssertNotEqual(BluetoothUUID.bondManagementControlPoint, .bit32(10916))
        XCTAssertNotEqual(BluetoothUUID.bondManagementControlPoint, .bit32(0x2AA4))

        /// Bond Management Feature
        XCTAssertEqual(BluetoothUUID.bondManagementFeature.rawValue, "2AA5")
        XCTAssertEqual(BluetoothUUID.bondManagementFeature, .bit16(0x2AA5))
        XCTAssertEqual(BluetoothUUID.bondManagementFeature, .bit16(10917))
        XCTAssertEqual(BluetoothUUID.bondManagementFeature.name, "Bond Management Feature")
        XCTAssertNotEqual(BluetoothUUID.bondManagementFeature, .bit32(10917))
        XCTAssertNotEqual(BluetoothUUID.bondManagementFeature, .bit32(0x2AA5))

        /// Central Address Resolution
        XCTAssertEqual(BluetoothUUID.centralAddressResolution.rawValue, "2AA6")
        XCTAssertEqual(BluetoothUUID.centralAddressResolution, .bit16(0x2AA6))
        XCTAssertEqual(BluetoothUUID.centralAddressResolution, .bit16(10918))
        XCTAssertEqual(BluetoothUUID.centralAddressResolution.name, "Central Address Resolution")
        XCTAssertNotEqual(BluetoothUUID.centralAddressResolution, .bit32(10918))
        XCTAssertNotEqual(BluetoothUUID.centralAddressResolution, .bit32(0x2AA6))

        /// CGM Measurement
        XCTAssertEqual(BluetoothUUID.cgmMeasurement.rawValue, "2AA7")
        XCTAssertEqual(BluetoothUUID.cgmMeasurement, .bit16(0x2AA7))
        XCTAssertEqual(BluetoothUUID.cgmMeasurement, .bit16(10919))
        XCTAssertEqual(BluetoothUUID.cgmMeasurement.name, "CGM Measurement")
        XCTAssertNotEqual(BluetoothUUID.cgmMeasurement, .bit32(10919))
        XCTAssertNotEqual(BluetoothUUID.cgmMeasurement, .bit32(0x2AA7))

        /// CGM Feature
        XCTAssertEqual(BluetoothUUID.cgmFeature.rawValue, "2AA8")
        XCTAssertEqual(BluetoothUUID.cgmFeature, .bit16(0x2AA8))
        XCTAssertEqual(BluetoothUUID.cgmFeature, .bit16(10920))
        XCTAssertEqual(BluetoothUUID.cgmFeature.name, "CGM Feature")
        XCTAssertNotEqual(BluetoothUUID.cgmFeature, .bit32(10920))
        XCTAssertNotEqual(BluetoothUUID.cgmFeature, .bit32(0x2AA8))

        /// CGM Status
        XCTAssertEqual(BluetoothUUID.cgmStatus.rawValue, "2AA9")
        XCTAssertEqual(BluetoothUUID.cgmStatus, .bit16(0x2AA9))
        XCTAssertEqual(BluetoothUUID.cgmStatus, .bit16(10921))
        XCTAssertEqual(BluetoothUUID.cgmStatus.name, "CGM Status")
        XCTAssertNotEqual(BluetoothUUID.cgmStatus, .bit32(10921))
        XCTAssertNotEqual(BluetoothUUID.cgmStatus, .bit32(0x2AA9))

        /// CGM Session Start Time
        XCTAssertEqual(BluetoothUUID.cgmSessionStartTime.rawValue, "2AAA")
        XCTAssertEqual(BluetoothUUID.cgmSessionStartTime, .bit16(0x2AAA))
        XCTAssertEqual(BluetoothUUID.cgmSessionStartTime, .bit16(10922))
        XCTAssertEqual(BluetoothUUID.cgmSessionStartTime.name, "CGM Session Start Time")
        XCTAssertNotEqual(BluetoothUUID.cgmSessionStartTime, .bit32(10922))
        XCTAssertNotEqual(BluetoothUUID.cgmSessionStartTime, .bit32(0x2AAA))

        /// CGM Session Run Time
        XCTAssertEqual(BluetoothUUID.cgmSessionRunTime.rawValue, "2AAB")
        XCTAssertEqual(BluetoothUUID.cgmSessionRunTime, .bit16(0x2AAB))
        XCTAssertEqual(BluetoothUUID.cgmSessionRunTime, .bit16(10923))
        XCTAssertEqual(BluetoothUUID.cgmSessionRunTime.name, "CGM Session Run Time")
        XCTAssertNotEqual(BluetoothUUID.cgmSessionRunTime, .bit32(10923))
        XCTAssertNotEqual(BluetoothUUID.cgmSessionRunTime, .bit32(0x2AAB))

        /// CGM Specific Ops Control Point
        XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint.rawValue, "2AAC")
        XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit16(0x2AAC))
        XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit16(10924))
        XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint.name, "CGM Specific Ops Control Point")
        XCTAssertNotEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit32(10924))
        XCTAssertNotEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit32(0x2AAC))

        /// Indoor Positioning Configuration
        XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration.rawValue, "2AAD")
        XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration, .bit16(0x2AAD))
        XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration, .bit16(10925))
        XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration.name, "Indoor Positioning Configuration")
        XCTAssertNotEqual(BluetoothUUID.indoorPositioningConfiguration, .bit32(10925))
        XCTAssertNotEqual(BluetoothUUID.indoorPositioningConfiguration, .bit32(0x2AAD))

        /// Latitude
        XCTAssertEqual(BluetoothUUID.latitude.rawValue, "2AAE")
        XCTAssertEqual(BluetoothUUID.latitude, .bit16(0x2AAE))
        XCTAssertEqual(BluetoothUUID.latitude, .bit16(10926))
        XCTAssertEqual(BluetoothUUID.latitude.name, "Latitude")
        XCTAssertNotEqual(BluetoothUUID.latitude, .bit32(10926))
        XCTAssertNotEqual(BluetoothUUID.latitude, .bit32(0x2AAE))

        /// Longitude
        XCTAssertEqual(BluetoothUUID.longitude.rawValue, "2AAF")
        XCTAssertEqual(BluetoothUUID.longitude, .bit16(0x2AAF))
        XCTAssertEqual(BluetoothUUID.longitude, .bit16(10927))
        XCTAssertEqual(BluetoothUUID.longitude.name, "Longitude")
        XCTAssertNotEqual(BluetoothUUID.longitude, .bit32(10927))
        XCTAssertNotEqual(BluetoothUUID.longitude, .bit32(0x2AAF))

        /// Local North Coordinate
        XCTAssertEqual(BluetoothUUID.localNorthCoordinate.rawValue, "2AB0")
        XCTAssertEqual(BluetoothUUID.localNorthCoordinate, .bit16(0x2AB0))
        XCTAssertEqual(BluetoothUUID.localNorthCoordinate, .bit16(10928))
        XCTAssertEqual(BluetoothUUID.localNorthCoordinate.name, "Local North Coordinate")
        XCTAssertNotEqual(BluetoothUUID.localNorthCoordinate, .bit32(10928))
        XCTAssertNotEqual(BluetoothUUID.localNorthCoordinate, .bit32(0x2AB0))

        /// Local East Coordinate
        XCTAssertEqual(BluetoothUUID.localEastCoordinate.rawValue, "2AB1")
        XCTAssertEqual(BluetoothUUID.localEastCoordinate, .bit16(0x2AB1))
        XCTAssertEqual(BluetoothUUID.localEastCoordinate, .bit16(10929))
        XCTAssertEqual(BluetoothUUID.localEastCoordinate.name, "Local East Coordinate")
        XCTAssertNotEqual(BluetoothUUID.localEastCoordinate, .bit32(10929))
        XCTAssertNotEqual(BluetoothUUID.localEastCoordinate, .bit32(0x2AB1))

        /// Floor Number
        XCTAssertEqual(BluetoothUUID.floorNumber.rawValue, "2AB2")
        XCTAssertEqual(BluetoothUUID.floorNumber, .bit16(0x2AB2))
        XCTAssertEqual(BluetoothUUID.floorNumber, .bit16(10930))
        XCTAssertEqual(BluetoothUUID.floorNumber.name, "Floor Number")
        XCTAssertNotEqual(BluetoothUUID.floorNumber, .bit32(10930))
        XCTAssertNotEqual(BluetoothUUID.floorNumber, .bit32(0x2AB2))

        /// Altitude
        XCTAssertEqual(BluetoothUUID.altitude.rawValue, "2AB3")
        XCTAssertEqual(BluetoothUUID.altitude, .bit16(0x2AB3))
        XCTAssertEqual(BluetoothUUID.altitude, .bit16(10931))
        XCTAssertEqual(BluetoothUUID.altitude.name, "Altitude")
        XCTAssertNotEqual(BluetoothUUID.altitude, .bit32(10931))
        XCTAssertNotEqual(BluetoothUUID.altitude, .bit32(0x2AB3))

        /// Uncertainty
        XCTAssertEqual(BluetoothUUID.uncertainty.rawValue, "2AB4")
        XCTAssertEqual(BluetoothUUID.uncertainty, .bit16(0x2AB4))
        XCTAssertEqual(BluetoothUUID.uncertainty, .bit16(10932))
        XCTAssertEqual(BluetoothUUID.uncertainty.name, "Uncertainty")
        XCTAssertNotEqual(BluetoothUUID.uncertainty, .bit32(10932))
        XCTAssertNotEqual(BluetoothUUID.uncertainty, .bit32(0x2AB4))

        /// Location Name
        XCTAssertEqual(BluetoothUUID.locationName.rawValue, "2AB5")
        XCTAssertEqual(BluetoothUUID.locationName, .bit16(0x2AB5))
        XCTAssertEqual(BluetoothUUID.locationName, .bit16(10933))
        XCTAssertEqual(BluetoothUUID.locationName.name, "Location Name")
        XCTAssertNotEqual(BluetoothUUID.locationName, .bit32(10933))
        XCTAssertNotEqual(BluetoothUUID.locationName, .bit32(0x2AB5))

        /// URI
        XCTAssertEqual(BluetoothUUID.uri.rawValue, "2AB6")
        XCTAssertEqual(BluetoothUUID.uri, .bit16(0x2AB6))
        XCTAssertEqual(BluetoothUUID.uri, .bit16(10934))
        XCTAssertEqual(BluetoothUUID.uri.name, "URI")
        XCTAssertNotEqual(BluetoothUUID.uri, .bit32(10934))
        XCTAssertNotEqual(BluetoothUUID.uri, .bit32(0x2AB6))

        /// HTTP Headers
        XCTAssertEqual(BluetoothUUID.httpHeaders.rawValue, "2AB7")
        XCTAssertEqual(BluetoothUUID.httpHeaders, .bit16(0x2AB7))
        XCTAssertEqual(BluetoothUUID.httpHeaders, .bit16(10935))
        XCTAssertEqual(BluetoothUUID.httpHeaders.name, "HTTP Headers")
        XCTAssertNotEqual(BluetoothUUID.httpHeaders, .bit32(10935))
        XCTAssertNotEqual(BluetoothUUID.httpHeaders, .bit32(0x2AB7))

        /// HTTP Status Code
        XCTAssertEqual(BluetoothUUID.httpStatusCode.rawValue, "2AB8")
        XCTAssertEqual(BluetoothUUID.httpStatusCode, .bit16(0x2AB8))
        XCTAssertEqual(BluetoothUUID.httpStatusCode, .bit16(10936))
        XCTAssertEqual(BluetoothUUID.httpStatusCode.name, "HTTP Status Code")
        XCTAssertNotEqual(BluetoothUUID.httpStatusCode, .bit32(10936))
        XCTAssertNotEqual(BluetoothUUID.httpStatusCode, .bit32(0x2AB8))

        /// HTTP Entity Body
        XCTAssertEqual(BluetoothUUID.httpEntityBody.rawValue, "2AB9")
        XCTAssertEqual(BluetoothUUID.httpEntityBody, .bit16(0x2AB9))
        XCTAssertEqual(BluetoothUUID.httpEntityBody, .bit16(10937))
        XCTAssertEqual(BluetoothUUID.httpEntityBody.name, "HTTP Entity Body")
        XCTAssertNotEqual(BluetoothUUID.httpEntityBody, .bit32(10937))
        XCTAssertNotEqual(BluetoothUUID.httpEntityBody, .bit32(0x2AB9))

        /// HTTP Control Point
        XCTAssertEqual(BluetoothUUID.httpControlPoint.rawValue, "2ABA")
        XCTAssertEqual(BluetoothUUID.httpControlPoint, .bit16(0x2ABA))
        XCTAssertEqual(BluetoothUUID.httpControlPoint, .bit16(10938))
        XCTAssertEqual(BluetoothUUID.httpControlPoint.name, "HTTP Control Point")
        XCTAssertNotEqual(BluetoothUUID.httpControlPoint, .bit32(10938))
        XCTAssertNotEqual(BluetoothUUID.httpControlPoint, .bit32(0x2ABA))

        /// HTTPS Security
        XCTAssertEqual(BluetoothUUID.httpsSecurity.rawValue, "2ABB")
        XCTAssertEqual(BluetoothUUID.httpsSecurity, .bit16(0x2ABB))
        XCTAssertEqual(BluetoothUUID.httpsSecurity, .bit16(10939))
        XCTAssertEqual(BluetoothUUID.httpsSecurity.name, "HTTPS Security")
        XCTAssertNotEqual(BluetoothUUID.httpsSecurity, .bit32(10939))
        XCTAssertNotEqual(BluetoothUUID.httpsSecurity, .bit32(0x2ABB))

        /// TDS Control Point
        XCTAssertEqual(BluetoothUUID.tdsControlPoint.rawValue, "2ABC")
        XCTAssertEqual(BluetoothUUID.tdsControlPoint, .bit16(0x2ABC))
        XCTAssertEqual(BluetoothUUID.tdsControlPoint, .bit16(10940))
        XCTAssertEqual(BluetoothUUID.tdsControlPoint.name, "TDS Control Point")
        XCTAssertNotEqual(BluetoothUUID.tdsControlPoint, .bit32(10940))
        XCTAssertNotEqual(BluetoothUUID.tdsControlPoint, .bit32(0x2ABC))

        /// OTS Feature
        XCTAssertEqual(BluetoothUUID.otsFeature.rawValue, "2ABD")
        XCTAssertEqual(BluetoothUUID.otsFeature, .bit16(0x2ABD))
        XCTAssertEqual(BluetoothUUID.otsFeature, .bit16(10941))
        XCTAssertEqual(BluetoothUUID.otsFeature.name, "OTS Feature")
        XCTAssertNotEqual(BluetoothUUID.otsFeature, .bit32(10941))
        XCTAssertNotEqual(BluetoothUUID.otsFeature, .bit32(0x2ABD))

        /// Object Name
        XCTAssertEqual(BluetoothUUID.objectName.rawValue, "2ABE")
        XCTAssertEqual(BluetoothUUID.objectName, .bit16(0x2ABE))
        XCTAssertEqual(BluetoothUUID.objectName, .bit16(10942))
        XCTAssertEqual(BluetoothUUID.objectName.name, "Object Name")
        XCTAssertNotEqual(BluetoothUUID.objectName, .bit32(10942))
        XCTAssertNotEqual(BluetoothUUID.objectName, .bit32(0x2ABE))

        /// Object Type
        XCTAssertEqual(BluetoothUUID.objectType.rawValue, "2ABF")
        XCTAssertEqual(BluetoothUUID.objectType, .bit16(0x2ABF))
        XCTAssertEqual(BluetoothUUID.objectType, .bit16(10943))
        XCTAssertEqual(BluetoothUUID.objectType.name, "Object Type")
        XCTAssertNotEqual(BluetoothUUID.objectType, .bit32(10943))
        XCTAssertNotEqual(BluetoothUUID.objectType, .bit32(0x2ABF))

        /// Object Size
        XCTAssertEqual(BluetoothUUID.objectSize.rawValue, "2AC0")
        XCTAssertEqual(BluetoothUUID.objectSize, .bit16(0x2AC0))
        XCTAssertEqual(BluetoothUUID.objectSize, .bit16(10944))
        XCTAssertEqual(BluetoothUUID.objectSize.name, "Object Size")
        XCTAssertNotEqual(BluetoothUUID.objectSize, .bit32(10944))
        XCTAssertNotEqual(BluetoothUUID.objectSize, .bit32(0x2AC0))

        /// Object First-Created
        XCTAssertEqual(BluetoothUUID.objectFirstCreated.rawValue, "2AC1")
        XCTAssertEqual(BluetoothUUID.objectFirstCreated, .bit16(0x2AC1))
        XCTAssertEqual(BluetoothUUID.objectFirstCreated, .bit16(10945))
        XCTAssertEqual(BluetoothUUID.objectFirstCreated.name, "Object First-Created")
        XCTAssertNotEqual(BluetoothUUID.objectFirstCreated, .bit32(10945))
        XCTAssertNotEqual(BluetoothUUID.objectFirstCreated, .bit32(0x2AC1))

        /// Object Last-Modified
        XCTAssertEqual(BluetoothUUID.objectLastModified.rawValue, "2AC2")
        XCTAssertEqual(BluetoothUUID.objectLastModified, .bit16(0x2AC2))
        XCTAssertEqual(BluetoothUUID.objectLastModified, .bit16(10946))
        XCTAssertEqual(BluetoothUUID.objectLastModified.name, "Object Last-Modified")
        XCTAssertNotEqual(BluetoothUUID.objectLastModified, .bit32(10946))
        XCTAssertNotEqual(BluetoothUUID.objectLastModified, .bit32(0x2AC2))

        /// Object ID
        XCTAssertEqual(BluetoothUUID.objectId.rawValue, "2AC3")
        XCTAssertEqual(BluetoothUUID.objectId, .bit16(0x2AC3))
        XCTAssertEqual(BluetoothUUID.objectId, .bit16(10947))
        XCTAssertEqual(BluetoothUUID.objectId.name, "Object ID")
        XCTAssertNotEqual(BluetoothUUID.objectId, .bit32(10947))
        XCTAssertNotEqual(BluetoothUUID.objectId, .bit32(0x2AC3))

        /// Object Properties
        XCTAssertEqual(BluetoothUUID.objectProperties.rawValue, "2AC4")
        XCTAssertEqual(BluetoothUUID.objectProperties, .bit16(0x2AC4))
        XCTAssertEqual(BluetoothUUID.objectProperties, .bit16(10948))
        XCTAssertEqual(BluetoothUUID.objectProperties.name, "Object Properties")
        XCTAssertNotEqual(BluetoothUUID.objectProperties, .bit32(10948))
        XCTAssertNotEqual(BluetoothUUID.objectProperties, .bit32(0x2AC4))

        /// Object Action Control Point
        XCTAssertEqual(BluetoothUUID.objectActionControlPoint.rawValue, "2AC5")
        XCTAssertEqual(BluetoothUUID.objectActionControlPoint, .bit16(0x2AC5))
        XCTAssertEqual(BluetoothUUID.objectActionControlPoint, .bit16(10949))
        XCTAssertEqual(BluetoothUUID.objectActionControlPoint.name, "Object Action Control Point")
        XCTAssertNotEqual(BluetoothUUID.objectActionControlPoint, .bit32(10949))
        XCTAssertNotEqual(BluetoothUUID.objectActionControlPoint, .bit32(0x2AC5))

        /// Object List Control Point
        XCTAssertEqual(BluetoothUUID.objectListControlPoint.rawValue, "2AC6")
        XCTAssertEqual(BluetoothUUID.objectListControlPoint, .bit16(0x2AC6))
        XCTAssertEqual(BluetoothUUID.objectListControlPoint, .bit16(10950))
        XCTAssertEqual(BluetoothUUID.objectListControlPoint.name, "Object List Control Point")
        XCTAssertNotEqual(BluetoothUUID.objectListControlPoint, .bit32(10950))
        XCTAssertNotEqual(BluetoothUUID.objectListControlPoint, .bit32(0x2AC6))

        /// Object List Filter
        XCTAssertEqual(BluetoothUUID.objectListFilter.rawValue, "2AC7")
        XCTAssertEqual(BluetoothUUID.objectListFilter, .bit16(0x2AC7))
        XCTAssertEqual(BluetoothUUID.objectListFilter, .bit16(10951))
        XCTAssertEqual(BluetoothUUID.objectListFilter.name, "Object List Filter")
        XCTAssertNotEqual(BluetoothUUID.objectListFilter, .bit32(10951))
        XCTAssertNotEqual(BluetoothUUID.objectListFilter, .bit32(0x2AC7))

        /// Object Changed
        XCTAssertEqual(BluetoothUUID.objectChanged.rawValue, "2AC8")
        XCTAssertEqual(BluetoothUUID.objectChanged, .bit16(0x2AC8))
        XCTAssertEqual(BluetoothUUID.objectChanged, .bit16(10952))
        XCTAssertEqual(BluetoothUUID.objectChanged.name, "Object Changed")
        XCTAssertNotEqual(BluetoothUUID.objectChanged, .bit32(10952))
        XCTAssertNotEqual(BluetoothUUID.objectChanged, .bit32(0x2AC8))

        /// Cross Trainer Data
        XCTAssertEqual(BluetoothUUID.crossTrainerData.rawValue, "2ACE")
        XCTAssertEqual(BluetoothUUID.crossTrainerData, .bit16(0x2ACE))
        XCTAssertEqual(BluetoothUUID.crossTrainerData, .bit16(10958))
        XCTAssertEqual(BluetoothUUID.crossTrainerData.name, "Cross Trainer Data")
        XCTAssertNotEqual(BluetoothUUID.crossTrainerData, .bit32(10958))
        XCTAssertNotEqual(BluetoothUUID.crossTrainerData, .bit32(0x2ACE))

        /// Date UTC
        XCTAssertEqual(BluetoothUUID.dateUtc.rawValue, "2AED")
        XCTAssertEqual(BluetoothUUID.dateUtc, .bit16(0x2AED))
        XCTAssertEqual(BluetoothUUID.dateUtc, .bit16(10989))
        XCTAssertEqual(BluetoothUUID.dateUtc.name, "Date UTC")
        XCTAssertNotEqual(BluetoothUUID.dateUtc, .bit32(10989))
        XCTAssertNotEqual(BluetoothUUID.dateUtc, .bit32(0x2AED))

        /// Abbott Diabetes Care
        XCTAssertEqual(BluetoothUUID.abbottDiabetesCare.rawValue, "FDE3")
        XCTAssertEqual(BluetoothUUID.abbottDiabetesCare, .bit16(0xFDE3))
        XCTAssertEqual(BluetoothUUID.abbottDiabetesCare, .bit16(64995))
        XCTAssertEqual(BluetoothUUID.abbottDiabetesCare.name, "Abbott Diabetes Care")
        XCTAssertNotEqual(BluetoothUUID.abbottDiabetesCare, .bit32(64995))
        XCTAssertNotEqual(BluetoothUUID.abbottDiabetesCare, .bit32(0xFDE3))

        /// JUUL Labs, Inc.
        XCTAssertEqual(BluetoothUUID.juulLabs.rawValue, "FDE4")
        XCTAssertEqual(BluetoothUUID.juulLabs, .bit16(0xFDE4))
        XCTAssertEqual(BluetoothUUID.juulLabs, .bit16(64996))
        XCTAssertEqual(BluetoothUUID.juulLabs.name, "JUUL Labs, Inc.")
        XCTAssertNotEqual(BluetoothUUID.juulLabs, .bit32(64996))
        XCTAssertNotEqual(BluetoothUUID.juulLabs, .bit32(0xFDE4))

        /// SMK Corporation
        XCTAssertEqual(BluetoothUUID.smk.rawValue, "FDE5")
        XCTAssertEqual(BluetoothUUID.smk, .bit16(0xFDE5))
        XCTAssertEqual(BluetoothUUID.smk, .bit16(64997))
        XCTAssertEqual(BluetoothUUID.smk.name, "SMK Corporation")
        XCTAssertNotEqual(BluetoothUUID.smk, .bit32(64997))
        XCTAssertNotEqual(BluetoothUUID.smk, .bit32(0xFDE5))

        /// Intelletto Technologies Inc
        XCTAssertEqual(BluetoothUUID.intellettoTechnologies.rawValue, "FDE6")
        XCTAssertEqual(BluetoothUUID.intellettoTechnologies, .bit16(0xFDE6))
        XCTAssertEqual(BluetoothUUID.intellettoTechnologies, .bit16(64998))
        XCTAssertEqual(BluetoothUUID.intellettoTechnologies.name, "Intelletto Technologies Inc")
        XCTAssertNotEqual(BluetoothUUID.intellettoTechnologies, .bit32(64998))
        XCTAssertNotEqual(BluetoothUUID.intellettoTechnologies, .bit32(0xFDE6))

        /// SECOM Co., LTD
        XCTAssertEqual(BluetoothUUID.secom.rawValue, "FDE7")
        XCTAssertEqual(BluetoothUUID.secom, .bit16(0xFDE7))
        XCTAssertEqual(BluetoothUUID.secom, .bit16(64999))
        XCTAssertEqual(BluetoothUUID.secom.name, "SECOM Co., LTD")
        XCTAssertNotEqual(BluetoothUUID.secom, .bit32(64999))
        XCTAssertNotEqual(BluetoothUUID.secom, .bit32(0xFDE7))

        /// Robert Bosch GmbH
        XCTAssertEqual(BluetoothUUID.robertBosch.rawValue, "FDE8")
        XCTAssertEqual(BluetoothUUID.robertBosch, .bit16(0xFDE8))
        XCTAssertEqual(BluetoothUUID.robertBosch, .bit16(65000))
        XCTAssertEqual(BluetoothUUID.robertBosch.name, "Robert Bosch GmbH")
        XCTAssertNotEqual(BluetoothUUID.robertBosch, .bit32(65000))
        XCTAssertNotEqual(BluetoothUUID.robertBosch, .bit32(0xFDE8))

        /// Spacesaver Corporation
        XCTAssertEqual(BluetoothUUID.spacesaver.rawValue, "FDE9")
        XCTAssertEqual(BluetoothUUID.spacesaver, .bit16(0xFDE9))
        XCTAssertEqual(BluetoothUUID.spacesaver, .bit16(65001))
        XCTAssertEqual(BluetoothUUID.spacesaver.name, "Spacesaver Corporation")
        XCTAssertNotEqual(BluetoothUUID.spacesaver, .bit32(65001))
        XCTAssertNotEqual(BluetoothUUID.spacesaver, .bit32(0xFDE9))

        /// SeeScan, Inc
        XCTAssertEqual(BluetoothUUID.seescan.rawValue, "FDEA")
        XCTAssertEqual(BluetoothUUID.seescan, .bit16(0xFDEA))
        XCTAssertEqual(BluetoothUUID.seescan, .bit16(65002))
        XCTAssertEqual(BluetoothUUID.seescan.name, "SeeScan, Inc")
        XCTAssertNotEqual(BluetoothUUID.seescan, .bit32(65002))
        XCTAssertNotEqual(BluetoothUUID.seescan, .bit32(0xFDEA))

        /// Syntronix Corporation
        XCTAssertEqual(BluetoothUUID.syntronix.rawValue, "FDEB")
        XCTAssertEqual(BluetoothUUID.syntronix, .bit16(0xFDEB))
        XCTAssertEqual(BluetoothUUID.syntronix, .bit16(65003))
        XCTAssertEqual(BluetoothUUID.syntronix.name, "Syntronix Corporation")
        XCTAssertNotEqual(BluetoothUUID.syntronix, .bit32(65003))
        XCTAssertNotEqual(BluetoothUUID.syntronix, .bit32(0xFDEB))

        /// Mannkind Corporation
        XCTAssertEqual(BluetoothUUID.mannkind.rawValue, "FDEC")
        XCTAssertEqual(BluetoothUUID.mannkind, .bit16(0xFDEC))
        XCTAssertEqual(BluetoothUUID.mannkind, .bit16(65004))
        XCTAssertEqual(BluetoothUUID.mannkind.name, "Mannkind Corporation")
        XCTAssertNotEqual(BluetoothUUID.mannkind, .bit32(65004))
        XCTAssertNotEqual(BluetoothUUID.mannkind, .bit32(0xFDEC))

        /// Pole Star
        XCTAssertEqual(BluetoothUUID.poleStar.rawValue, "FDED")
        XCTAssertEqual(BluetoothUUID.poleStar, .bit16(0xFDED))
        XCTAssertEqual(BluetoothUUID.poleStar, .bit16(65005))
        XCTAssertEqual(BluetoothUUID.poleStar.name, "Pole Star")
        XCTAssertNotEqual(BluetoothUUID.poleStar, .bit32(65005))
        XCTAssertNotEqual(BluetoothUUID.poleStar, .bit32(0xFDED))

        /// Huawei Technologies Co., Ltd.
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies.rawValue, "FDEE")
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies, .bit16(0xFDEE))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies, .bit16(65006))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies.name, "Huawei Technologies Co., Ltd.")
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies, .bit32(65006))
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies, .bit32(0xFDEE))

        /// ART AND PROGRAM, INC.
        XCTAssertEqual(BluetoothUUID.artAndProgram.rawValue, "FDEF")
        XCTAssertEqual(BluetoothUUID.artAndProgram, .bit16(0xFDEF))
        XCTAssertEqual(BluetoothUUID.artAndProgram, .bit16(65007))
        XCTAssertEqual(BluetoothUUID.artAndProgram.name, "ART AND PROGRAM, INC.")
        XCTAssertNotEqual(BluetoothUUID.artAndProgram, .bit32(65007))
        XCTAssertNotEqual(BluetoothUUID.artAndProgram, .bit32(0xFDEF))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google.rawValue, "FDF0")
        XCTAssertEqual(BluetoothUUID.google, .bit16(0xFDF0))
        XCTAssertEqual(BluetoothUUID.google, .bit16(65008))
        XCTAssertEqual(BluetoothUUID.google.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google, .bit32(65008))
        XCTAssertNotEqual(BluetoothUUID.google, .bit32(0xFDF0))

        /// LAMPLIGHT Co.,Ltd
        XCTAssertEqual(BluetoothUUID.lamplight.rawValue, "FDF1")
        XCTAssertEqual(BluetoothUUID.lamplight, .bit16(0xFDF1))
        XCTAssertEqual(BluetoothUUID.lamplight, .bit16(65009))
        XCTAssertEqual(BluetoothUUID.lamplight.name, "LAMPLIGHT Co.,Ltd")
        XCTAssertNotEqual(BluetoothUUID.lamplight, .bit32(65009))
        XCTAssertNotEqual(BluetoothUUID.lamplight, .bit32(0xFDF1))

        /// AMICCOM Electronics Corporation
        XCTAssertEqual(BluetoothUUID.amiccomElectronics.rawValue, "FDF2")
        XCTAssertEqual(BluetoothUUID.amiccomElectronics, .bit16(0xFDF2))
        XCTAssertEqual(BluetoothUUID.amiccomElectronics, .bit16(65010))
        XCTAssertEqual(BluetoothUUID.amiccomElectronics.name, "AMICCOM Electronics Corporation")
        XCTAssertNotEqual(BluetoothUUID.amiccomElectronics, .bit32(65010))
        XCTAssertNotEqual(BluetoothUUID.amiccomElectronics, .bit32(0xFDF2))

        /// Amersports
        XCTAssertEqual(BluetoothUUID.amersports.rawValue, "FDF3")
        XCTAssertEqual(BluetoothUUID.amersports, .bit16(0xFDF3))
        XCTAssertEqual(BluetoothUUID.amersports, .bit16(65011))
        XCTAssertEqual(BluetoothUUID.amersports.name, "Amersports")
        XCTAssertNotEqual(BluetoothUUID.amersports, .bit32(65011))
        XCTAssertNotEqual(BluetoothUUID.amersports, .bit32(0xFDF3))

        /// O. E. M. Controls, Inc.
        XCTAssertEqual(BluetoothUUID.oEMControls.rawValue, "FDF4")
        XCTAssertEqual(BluetoothUUID.oEMControls, .bit16(0xFDF4))
        XCTAssertEqual(BluetoothUUID.oEMControls, .bit16(65012))
        XCTAssertEqual(BluetoothUUID.oEMControls.name, "O. E. M. Controls, Inc.")
        XCTAssertNotEqual(BluetoothUUID.oEMControls, .bit32(65012))
        XCTAssertNotEqual(BluetoothUUID.oEMControls, .bit32(0xFDF4))

        /// Milwaukee Electric Tools
        XCTAssertEqual(BluetoothUUID.milwaukeeElectricTools.rawValue, "FDF5")
        XCTAssertEqual(BluetoothUUID.milwaukeeElectricTools, .bit16(0xFDF5))
        XCTAssertEqual(BluetoothUUID.milwaukeeElectricTools, .bit16(65013))
        XCTAssertEqual(BluetoothUUID.milwaukeeElectricTools.name, "Milwaukee Electric Tools")
        XCTAssertNotEqual(BluetoothUUID.milwaukeeElectricTools, .bit32(65013))
        XCTAssertNotEqual(BluetoothUUID.milwaukeeElectricTools, .bit32(0xFDF5))

        /// AIAIAI ApS
        XCTAssertEqual(BluetoothUUID.aiaiai.rawValue, "FDF6")
        XCTAssertEqual(BluetoothUUID.aiaiai, .bit16(0xFDF6))
        XCTAssertEqual(BluetoothUUID.aiaiai, .bit16(65014))
        XCTAssertEqual(BluetoothUUID.aiaiai.name, "AIAIAI ApS")
        XCTAssertNotEqual(BluetoothUUID.aiaiai, .bit32(65014))
        XCTAssertNotEqual(BluetoothUUID.aiaiai, .bit32(0xFDF6))

        /// HP Inc.
        XCTAssertEqual(BluetoothUUID.hp.rawValue, "FDF7")
        XCTAssertEqual(BluetoothUUID.hp, .bit16(0xFDF7))
        XCTAssertEqual(BluetoothUUID.hp, .bit16(65015))
        XCTAssertEqual(BluetoothUUID.hp.name, "HP Inc.")
        XCTAssertNotEqual(BluetoothUUID.hp, .bit32(65015))
        XCTAssertNotEqual(BluetoothUUID.hp, .bit32(0xFDF7))

        /// Onvocal
        XCTAssertEqual(BluetoothUUID.onvocal.rawValue, "FDF8")
        XCTAssertEqual(BluetoothUUID.onvocal, .bit16(0xFDF8))
        XCTAssertEqual(BluetoothUUID.onvocal, .bit16(65016))
        XCTAssertEqual(BluetoothUUID.onvocal.name, "Onvocal")
        XCTAssertNotEqual(BluetoothUUID.onvocal, .bit32(65016))
        XCTAssertNotEqual(BluetoothUUID.onvocal, .bit32(0xFDF8))

        /// INIA
        XCTAssertEqual(BluetoothUUID.inia.rawValue, "FDF9")
        XCTAssertEqual(BluetoothUUID.inia, .bit16(0xFDF9))
        XCTAssertEqual(BluetoothUUID.inia, .bit16(65017))
        XCTAssertEqual(BluetoothUUID.inia.name, "INIA")
        XCTAssertNotEqual(BluetoothUUID.inia, .bit32(65017))
        XCTAssertNotEqual(BluetoothUUID.inia, .bit32(0xFDF9))

        /// Tandem Diabetes Care
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare.rawValue, "FDFA")
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare, .bit16(0xFDFA))
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare, .bit16(65018))
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare.name, "Tandem Diabetes Care")
        XCTAssertNotEqual(BluetoothUUID.tandemDiabetesCare, .bit32(65018))
        XCTAssertNotEqual(BluetoothUUID.tandemDiabetesCare, .bit32(0xFDFA))

        /// Tandem Diabetes Care
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare2.rawValue, "FDFB")
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare2, .bit16(0xFDFB))
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare2, .bit16(65019))
        XCTAssertEqual(BluetoothUUID.tandemDiabetesCare2.name, "Tandem Diabetes Care")
        XCTAssertNotEqual(BluetoothUUID.tandemDiabetesCare2, .bit32(65019))
        XCTAssertNotEqual(BluetoothUUID.tandemDiabetesCare2, .bit32(0xFDFB))

        /// Optrel AG
        XCTAssertEqual(BluetoothUUID.optrel.rawValue, "FDFC")
        XCTAssertEqual(BluetoothUUID.optrel, .bit16(0xFDFC))
        XCTAssertEqual(BluetoothUUID.optrel, .bit16(65020))
        XCTAssertEqual(BluetoothUUID.optrel.name, "Optrel AG")
        XCTAssertNotEqual(BluetoothUUID.optrel, .bit32(65020))
        XCTAssertNotEqual(BluetoothUUID.optrel, .bit32(0xFDFC))

        /// RecursiveSoft Inc.
        XCTAssertEqual(BluetoothUUID.recursivesoft.rawValue, "FDFD")
        XCTAssertEqual(BluetoothUUID.recursivesoft, .bit16(0xFDFD))
        XCTAssertEqual(BluetoothUUID.recursivesoft, .bit16(65021))
        XCTAssertEqual(BluetoothUUID.recursivesoft.name, "RecursiveSoft Inc.")
        XCTAssertNotEqual(BluetoothUUID.recursivesoft, .bit32(65021))
        XCTAssertNotEqual(BluetoothUUID.recursivesoft, .bit32(0xFDFD))

        /// ADHERIUM(NZ) LIMITED
        XCTAssertEqual(BluetoothUUID.adheriumNzLimited.rawValue, "FDFE")
        XCTAssertEqual(BluetoothUUID.adheriumNzLimited, .bit16(0xFDFE))
        XCTAssertEqual(BluetoothUUID.adheriumNzLimited, .bit16(65022))
        XCTAssertEqual(BluetoothUUID.adheriumNzLimited.name, "ADHERIUM(NZ) LIMITED")
        XCTAssertNotEqual(BluetoothUUID.adheriumNzLimited, .bit32(65022))
        XCTAssertNotEqual(BluetoothUUID.adheriumNzLimited, .bit32(0xFDFE))

        /// OSRAM GmbH
        XCTAssertEqual(BluetoothUUID.osram.rawValue, "FDFF")
        XCTAssertEqual(BluetoothUUID.osram, .bit16(0xFDFF))
        XCTAssertEqual(BluetoothUUID.osram, .bit16(65023))
        XCTAssertEqual(BluetoothUUID.osram.name, "OSRAM GmbH")
        XCTAssertNotEqual(BluetoothUUID.osram, .bit32(65023))
        XCTAssertNotEqual(BluetoothUUID.osram, .bit32(0xFDFF))

        /// Amazon.com Services, Inc.
        XCTAssertEqual(BluetoothUUID.amazon.rawValue, "FE00")
        XCTAssertEqual(BluetoothUUID.amazon, .bit16(0xFE00))
        XCTAssertEqual(BluetoothUUID.amazon, .bit16(65024))
        XCTAssertEqual(BluetoothUUID.amazon.name, "Amazon.com Services, Inc.")
        XCTAssertNotEqual(BluetoothUUID.amazon, .bit32(65024))
        XCTAssertNotEqual(BluetoothUUID.amazon, .bit32(0xFE00))

        /// Duracell U.S. Operations Inc.
        XCTAssertEqual(BluetoothUUID.duracellUSOperations.rawValue, "FE01")
        XCTAssertEqual(BluetoothUUID.duracellUSOperations, .bit16(0xFE01))
        XCTAssertEqual(BluetoothUUID.duracellUSOperations, .bit16(65025))
        XCTAssertEqual(BluetoothUUID.duracellUSOperations.name, "Duracell U.S. Operations Inc.")
        XCTAssertNotEqual(BluetoothUUID.duracellUSOperations, .bit32(65025))
        XCTAssertNotEqual(BluetoothUUID.duracellUSOperations, .bit32(0xFE01))

        /// Robert Bosch GmbH
        XCTAssertEqual(BluetoothUUID.robertBosch2.rawValue, "FE02")
        XCTAssertEqual(BluetoothUUID.robertBosch2, .bit16(0xFE02))
        XCTAssertEqual(BluetoothUUID.robertBosch2, .bit16(65026))
        XCTAssertEqual(BluetoothUUID.robertBosch2.name, "Robert Bosch GmbH")
        XCTAssertNotEqual(BluetoothUUID.robertBosch2, .bit32(65026))
        XCTAssertNotEqual(BluetoothUUID.robertBosch2, .bit32(0xFE02))

        /// Amazon.com Services, Inc.
        XCTAssertEqual(BluetoothUUID.amazon2.rawValue, "FE03")
        XCTAssertEqual(BluetoothUUID.amazon2, .bit16(0xFE03))
        XCTAssertEqual(BluetoothUUID.amazon2, .bit16(65027))
        XCTAssertEqual(BluetoothUUID.amazon2.name, "Amazon.com Services, Inc.")
        XCTAssertNotEqual(BluetoothUUID.amazon2, .bit32(65027))
        XCTAssertNotEqual(BluetoothUUID.amazon2, .bit32(0xFE03))

        /// OpenPath Security Inc
        XCTAssertEqual(BluetoothUUID.openpathSecurity.rawValue, "FE04")
        XCTAssertEqual(BluetoothUUID.openpathSecurity, .bit16(0xFE04))
        XCTAssertEqual(BluetoothUUID.openpathSecurity, .bit16(65028))
        XCTAssertEqual(BluetoothUUID.openpathSecurity.name, "OpenPath Security Inc")
        XCTAssertNotEqual(BluetoothUUID.openpathSecurity, .bit32(65028))
        XCTAssertNotEqual(BluetoothUUID.openpathSecurity, .bit32(0xFE04))

        /// CORE Transport Technologies NZ Limited
        XCTAssertEqual(BluetoothUUID.coreTransportTechnologiesNz.rawValue, "FE05")
        XCTAssertEqual(BluetoothUUID.coreTransportTechnologiesNz, .bit16(0xFE05))
        XCTAssertEqual(BluetoothUUID.coreTransportTechnologiesNz, .bit16(65029))
        XCTAssertEqual(BluetoothUUID.coreTransportTechnologiesNz.name, "CORE Transport Technologies NZ Limited")
        XCTAssertNotEqual(BluetoothUUID.coreTransportTechnologiesNz, .bit32(65029))
        XCTAssertNotEqual(BluetoothUUID.coreTransportTechnologiesNz, .bit32(0xFE05))

        /// Qualcomm Technologies, Inc.
        XCTAssertEqual(BluetoothUUID.qualcommTechnologies.rawValue, "FE06")
        XCTAssertEqual(BluetoothUUID.qualcommTechnologies, .bit16(0xFE06))
        XCTAssertEqual(BluetoothUUID.qualcommTechnologies, .bit16(65030))
        XCTAssertEqual(BluetoothUUID.qualcommTechnologies.name, "Qualcomm Technologies, Inc.")
        XCTAssertNotEqual(BluetoothUUID.qualcommTechnologies, .bit32(65030))
        XCTAssertNotEqual(BluetoothUUID.qualcommTechnologies, .bit32(0xFE06))

        /// Microsoft
        XCTAssertEqual(BluetoothUUID.microsoft.rawValue, "FE08")
        XCTAssertEqual(BluetoothUUID.microsoft, .bit16(0xFE08))
        XCTAssertEqual(BluetoothUUID.microsoft, .bit16(65032))
        XCTAssertEqual(BluetoothUUID.microsoft.name, "Microsoft")
        XCTAssertNotEqual(BluetoothUUID.microsoft, .bit32(65032))
        XCTAssertNotEqual(BluetoothUUID.microsoft, .bit32(0xFE08))

        /// Pillsy, Inc.
        XCTAssertEqual(BluetoothUUID.pillsy.rawValue, "FE09")
        XCTAssertEqual(BluetoothUUID.pillsy, .bit16(0xFE09))
        XCTAssertEqual(BluetoothUUID.pillsy, .bit16(65033))
        XCTAssertEqual(BluetoothUUID.pillsy.name, "Pillsy, Inc.")
        XCTAssertNotEqual(BluetoothUUID.pillsy, .bit32(65033))
        XCTAssertNotEqual(BluetoothUUID.pillsy, .bit32(0xFE09))

        /// ruwido austria gmbh
        XCTAssertEqual(BluetoothUUID.ruwidoAustria.rawValue, "FE0A")
        XCTAssertEqual(BluetoothUUID.ruwidoAustria, .bit16(0xFE0A))
        XCTAssertEqual(BluetoothUUID.ruwidoAustria, .bit16(65034))
        XCTAssertEqual(BluetoothUUID.ruwidoAustria.name, "ruwido austria gmbh")
        XCTAssertNotEqual(BluetoothUUID.ruwidoAustria, .bit32(65034))
        XCTAssertNotEqual(BluetoothUUID.ruwidoAustria, .bit32(0xFE0A))

        /// ruwido austria gmbh
        XCTAssertEqual(BluetoothUUID.ruwidoAustria2.rawValue, "FE0B")
        XCTAssertEqual(BluetoothUUID.ruwidoAustria2, .bit16(0xFE0B))
        XCTAssertEqual(BluetoothUUID.ruwidoAustria2, .bit16(65035))
        XCTAssertEqual(BluetoothUUID.ruwidoAustria2.name, "ruwido austria gmbh")
        XCTAssertNotEqual(BluetoothUUID.ruwidoAustria2, .bit32(65035))
        XCTAssertNotEqual(BluetoothUUID.ruwidoAustria2, .bit32(0xFE0B))

        /// Procter & Gamble
        XCTAssertEqual(BluetoothUUID.procterGamble.rawValue, "FE0C")
        XCTAssertEqual(BluetoothUUID.procterGamble, .bit16(0xFE0C))
        XCTAssertEqual(BluetoothUUID.procterGamble, .bit16(65036))
        XCTAssertEqual(BluetoothUUID.procterGamble.name, "Procter & Gamble")
        XCTAssertNotEqual(BluetoothUUID.procterGamble, .bit32(65036))
        XCTAssertNotEqual(BluetoothUUID.procterGamble, .bit32(0xFE0C))

        /// Procter & Gamble
        XCTAssertEqual(BluetoothUUID.procterGamble2.rawValue, "FE0D")
        XCTAssertEqual(BluetoothUUID.procterGamble2, .bit16(0xFE0D))
        XCTAssertEqual(BluetoothUUID.procterGamble2, .bit16(65037))
        XCTAssertEqual(BluetoothUUID.procterGamble2.name, "Procter & Gamble")
        XCTAssertNotEqual(BluetoothUUID.procterGamble2, .bit32(65037))
        XCTAssertNotEqual(BluetoothUUID.procterGamble2, .bit32(0xFE0D))

        /// Setec Pty Ltd
        XCTAssertEqual(BluetoothUUID.setecPty.rawValue, "FE0E")
        XCTAssertEqual(BluetoothUUID.setecPty, .bit16(0xFE0E))
        XCTAssertEqual(BluetoothUUID.setecPty, .bit16(65038))
        XCTAssertEqual(BluetoothUUID.setecPty.name, "Setec Pty Ltd")
        XCTAssertNotEqual(BluetoothUUID.setecPty, .bit32(65038))
        XCTAssertNotEqual(BluetoothUUID.setecPty, .bit32(0xFE0E))

        /// Philips Lighting B.V.
        XCTAssertEqual(BluetoothUUID.philipsLighting.rawValue, "FE0F")
        XCTAssertEqual(BluetoothUUID.philipsLighting, .bit16(0xFE0F))
        XCTAssertEqual(BluetoothUUID.philipsLighting, .bit16(65039))
        XCTAssertEqual(BluetoothUUID.philipsLighting.name, "Philips Lighting B.V.")
        XCTAssertNotEqual(BluetoothUUID.philipsLighting, .bit32(65039))
        XCTAssertNotEqual(BluetoothUUID.philipsLighting, .bit32(0xFE0F))

        /// Lapis Semiconductor Co., Ltd.
        XCTAssertEqual(BluetoothUUID.lapisSemiconductor.rawValue, "FE10")
        XCTAssertEqual(BluetoothUUID.lapisSemiconductor, .bit16(0xFE10))
        XCTAssertEqual(BluetoothUUID.lapisSemiconductor, .bit16(65040))
        XCTAssertEqual(BluetoothUUID.lapisSemiconductor.name, "Lapis Semiconductor Co., Ltd.")
        XCTAssertNotEqual(BluetoothUUID.lapisSemiconductor, .bit32(65040))
        XCTAssertNotEqual(BluetoothUUID.lapisSemiconductor, .bit32(0xFE10))

        /// GMC-I Messtechnik GmbH
        XCTAssertEqual(BluetoothUUID.gmcIMesstechnik.rawValue, "FE11")
        XCTAssertEqual(BluetoothUUID.gmcIMesstechnik, .bit16(0xFE11))
        XCTAssertEqual(BluetoothUUID.gmcIMesstechnik, .bit16(65041))
        XCTAssertEqual(BluetoothUUID.gmcIMesstechnik.name, "GMC-I Messtechnik GmbH")
        XCTAssertNotEqual(BluetoothUUID.gmcIMesstechnik, .bit32(65041))
        XCTAssertNotEqual(BluetoothUUID.gmcIMesstechnik, .bit32(0xFE11))

        /// M-Way Solutions GmbH
        XCTAssertEqual(BluetoothUUID.mWaySolutions.rawValue, "FE12")
        XCTAssertEqual(BluetoothUUID.mWaySolutions, .bit16(0xFE12))
        XCTAssertEqual(BluetoothUUID.mWaySolutions, .bit16(65042))
        XCTAssertEqual(BluetoothUUID.mWaySolutions.name, "M-Way Solutions GmbH")
        XCTAssertNotEqual(BluetoothUUID.mWaySolutions, .bit32(65042))
        XCTAssertNotEqual(BluetoothUUID.mWaySolutions, .bit32(0xFE12))

        /// Apple Inc.
        XCTAssertEqual(BluetoothUUID.apple.rawValue, "FE13")
        XCTAssertEqual(BluetoothUUID.apple, .bit16(0xFE13))
        XCTAssertEqual(BluetoothUUID.apple, .bit16(65043))
        XCTAssertEqual(BluetoothUUID.apple.name, "Apple Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple, .bit32(65043))
        XCTAssertNotEqual(BluetoothUUID.apple, .bit32(0xFE13))

        /// Flextronics International USA Inc.
        XCTAssertEqual(BluetoothUUID.flextronicsInternationalUsa.rawValue, "FE14")
        XCTAssertEqual(BluetoothUUID.flextronicsInternationalUsa, .bit16(0xFE14))
        XCTAssertEqual(BluetoothUUID.flextronicsInternationalUsa, .bit16(65044))
        XCTAssertEqual(BluetoothUUID.flextronicsInternationalUsa.name, "Flextronics International USA Inc.")
        XCTAssertNotEqual(BluetoothUUID.flextronicsInternationalUsa, .bit32(65044))
        XCTAssertNotEqual(BluetoothUUID.flextronicsInternationalUsa, .bit32(0xFE14))

        /// Amazon.com Services, Inc.
        XCTAssertEqual(BluetoothUUID.amazon3.rawValue, "FE15")
        XCTAssertEqual(BluetoothUUID.amazon3, .bit16(0xFE15))
        XCTAssertEqual(BluetoothUUID.amazon3, .bit16(65045))
        XCTAssertEqual(BluetoothUUID.amazon3.name, "Amazon.com Services, Inc.")
        XCTAssertNotEqual(BluetoothUUID.amazon3, .bit32(65045))
        XCTAssertNotEqual(BluetoothUUID.amazon3, .bit32(0xFE15))

        /// Footmarks, Inc.
        XCTAssertEqual(BluetoothUUID.footmarks.rawValue, "FE16")
        XCTAssertEqual(BluetoothUUID.footmarks, .bit16(0xFE16))
        XCTAssertEqual(BluetoothUUID.footmarks, .bit16(65046))
        XCTAssertEqual(BluetoothUUID.footmarks.name, "Footmarks, Inc.")
        XCTAssertNotEqual(BluetoothUUID.footmarks, .bit32(65046))
        XCTAssertNotEqual(BluetoothUUID.footmarks, .bit32(0xFE16))

        /// Telit Wireless Solutions GmbH
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions.rawValue, "FE17")
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions, .bit16(0xFE17))
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions, .bit16(65047))
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions.name, "Telit Wireless Solutions GmbH")
        XCTAssertNotEqual(BluetoothUUID.telitWirelessSolutions, .bit32(65047))
        XCTAssertNotEqual(BluetoothUUID.telitWirelessSolutions, .bit32(0xFE17))

        /// Runtime, Inc.
        XCTAssertEqual(BluetoothUUID.runtime.rawValue, "FE18")
        XCTAssertEqual(BluetoothUUID.runtime, .bit16(0xFE18))
        XCTAssertEqual(BluetoothUUID.runtime, .bit16(65048))
        XCTAssertEqual(BluetoothUUID.runtime.name, "Runtime, Inc.")
        XCTAssertNotEqual(BluetoothUUID.runtime, .bit32(65048))
        XCTAssertNotEqual(BluetoothUUID.runtime, .bit32(0xFE18))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google2.rawValue, "FE19")
        XCTAssertEqual(BluetoothUUID.google2, .bit16(0xFE19))
        XCTAssertEqual(BluetoothUUID.google2, .bit16(65049))
        XCTAssertEqual(BluetoothUUID.google2.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google2, .bit32(65049))
        XCTAssertNotEqual(BluetoothUUID.google2, .bit32(0xFE19))

        /// Tyto Life LLC
        XCTAssertEqual(BluetoothUUID.tytoLife.rawValue, "FE1A")
        XCTAssertEqual(BluetoothUUID.tytoLife, .bit16(0xFE1A))
        XCTAssertEqual(BluetoothUUID.tytoLife, .bit16(65050))
        XCTAssertEqual(BluetoothUUID.tytoLife.name, "Tyto Life LLC")
        XCTAssertNotEqual(BluetoothUUID.tytoLife, .bit32(65050))
        XCTAssertNotEqual(BluetoothUUID.tytoLife, .bit32(0xFE1A))

        /// Tyto Life LLC
        XCTAssertEqual(BluetoothUUID.tytoLife2.rawValue, "FE1B")
        XCTAssertEqual(BluetoothUUID.tytoLife2, .bit16(0xFE1B))
        XCTAssertEqual(BluetoothUUID.tytoLife2, .bit16(65051))
        XCTAssertEqual(BluetoothUUID.tytoLife2.name, "Tyto Life LLC")
        XCTAssertNotEqual(BluetoothUUID.tytoLife2, .bit32(65051))
        XCTAssertNotEqual(BluetoothUUID.tytoLife2, .bit32(0xFE1B))

        /// NetMedia, Inc.
        XCTAssertEqual(BluetoothUUID.netmedia.rawValue, "FE1C")
        XCTAssertEqual(BluetoothUUID.netmedia, .bit16(0xFE1C))
        XCTAssertEqual(BluetoothUUID.netmedia, .bit16(65052))
        XCTAssertEqual(BluetoothUUID.netmedia.name, "NetMedia, Inc.")
        XCTAssertNotEqual(BluetoothUUID.netmedia, .bit32(65052))
        XCTAssertNotEqual(BluetoothUUID.netmedia, .bit32(0xFE1C))

        /// Illuminati Instrument Corporation
        XCTAssertEqual(BluetoothUUID.illuminatiInstrument.rawValue, "FE1D")
        XCTAssertEqual(BluetoothUUID.illuminatiInstrument, .bit16(0xFE1D))
        XCTAssertEqual(BluetoothUUID.illuminatiInstrument, .bit16(65053))
        XCTAssertEqual(BluetoothUUID.illuminatiInstrument.name, "Illuminati Instrument Corporation")
        XCTAssertNotEqual(BluetoothUUID.illuminatiInstrument, .bit32(65053))
        XCTAssertNotEqual(BluetoothUUID.illuminatiInstrument, .bit32(0xFE1D))

        /// Smart Innovations Co., Ltd
        XCTAssertEqual(BluetoothUUID.smartInnovations.rawValue, "FE1E")
        XCTAssertEqual(BluetoothUUID.smartInnovations, .bit16(0xFE1E))
        XCTAssertEqual(BluetoothUUID.smartInnovations, .bit16(65054))
        XCTAssertEqual(BluetoothUUID.smartInnovations.name, "Smart Innovations Co., Ltd")
        XCTAssertNotEqual(BluetoothUUID.smartInnovations, .bit32(65054))
        XCTAssertNotEqual(BluetoothUUID.smartInnovations, .bit32(0xFE1E))

        /// Garmin International, Inc.
        XCTAssertEqual(BluetoothUUID.garminInternational.rawValue, "FE1F")
        XCTAssertEqual(BluetoothUUID.garminInternational, .bit16(0xFE1F))
        XCTAssertEqual(BluetoothUUID.garminInternational, .bit16(65055))
        XCTAssertEqual(BluetoothUUID.garminInternational.name, "Garmin International, Inc.")
        XCTAssertNotEqual(BluetoothUUID.garminInternational, .bit32(65055))
        XCTAssertNotEqual(BluetoothUUID.garminInternational, .bit32(0xFE1F))

        /// Emerson
        XCTAssertEqual(BluetoothUUID.emerson.rawValue, "FE20")
        XCTAssertEqual(BluetoothUUID.emerson, .bit16(0xFE20))
        XCTAssertEqual(BluetoothUUID.emerson, .bit16(65056))
        XCTAssertEqual(BluetoothUUID.emerson.name, "Emerson")
        XCTAssertNotEqual(BluetoothUUID.emerson, .bit32(65056))
        XCTAssertNotEqual(BluetoothUUID.emerson, .bit32(0xFE20))

        /// Bose Corporation
        XCTAssertEqual(BluetoothUUID.bose.rawValue, "FE21")
        XCTAssertEqual(BluetoothUUID.bose, .bit16(0xFE21))
        XCTAssertEqual(BluetoothUUID.bose, .bit16(65057))
        XCTAssertEqual(BluetoothUUID.bose.name, "Bose Corporation")
        XCTAssertNotEqual(BluetoothUUID.bose, .bit32(65057))
        XCTAssertNotEqual(BluetoothUUID.bose, .bit32(0xFE21))

        /// Zoll Medical Corporation
        XCTAssertEqual(BluetoothUUID.zollMedical.rawValue, "FE22")
        XCTAssertEqual(BluetoothUUID.zollMedical, .bit16(0xFE22))
        XCTAssertEqual(BluetoothUUID.zollMedical, .bit16(65058))
        XCTAssertEqual(BluetoothUUID.zollMedical.name, "Zoll Medical Corporation")
        XCTAssertNotEqual(BluetoothUUID.zollMedical, .bit32(65058))
        XCTAssertNotEqual(BluetoothUUID.zollMedical, .bit32(0xFE22))

        /// Zoll Medical Corporation
        XCTAssertEqual(BluetoothUUID.zollMedical2.rawValue, "FE23")
        XCTAssertEqual(BluetoothUUID.zollMedical2, .bit16(0xFE23))
        XCTAssertEqual(BluetoothUUID.zollMedical2, .bit16(65059))
        XCTAssertEqual(BluetoothUUID.zollMedical2.name, "Zoll Medical Corporation")
        XCTAssertNotEqual(BluetoothUUID.zollMedical2, .bit32(65059))
        XCTAssertNotEqual(BluetoothUUID.zollMedical2, .bit32(0xFE23))

        /// August Home Inc
        XCTAssertEqual(BluetoothUUID.augustHome.rawValue, "FE24")
        XCTAssertEqual(BluetoothUUID.augustHome, .bit16(0xFE24))
        XCTAssertEqual(BluetoothUUID.augustHome, .bit16(65060))
        XCTAssertEqual(BluetoothUUID.augustHome.name, "August Home Inc")
        XCTAssertNotEqual(BluetoothUUID.augustHome, .bit32(65060))
        XCTAssertNotEqual(BluetoothUUID.augustHome, .bit32(0xFE24))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple2.rawValue, "FE25")
        XCTAssertEqual(BluetoothUUID.apple2, .bit16(0xFE25))
        XCTAssertEqual(BluetoothUUID.apple2, .bit16(65061))
        XCTAssertEqual(BluetoothUUID.apple2.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple2, .bit32(65061))
        XCTAssertNotEqual(BluetoothUUID.apple2, .bit32(0xFE25))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google3.rawValue, "FE26")
        XCTAssertEqual(BluetoothUUID.google3, .bit16(0xFE26))
        XCTAssertEqual(BluetoothUUID.google3, .bit16(65062))
        XCTAssertEqual(BluetoothUUID.google3.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google3, .bit32(65062))
        XCTAssertNotEqual(BluetoothUUID.google3, .bit32(0xFE26))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google4.rawValue, "FE27")
        XCTAssertEqual(BluetoothUUID.google4, .bit16(0xFE27))
        XCTAssertEqual(BluetoothUUID.google4, .bit16(65063))
        XCTAssertEqual(BluetoothUUID.google4.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google4, .bit32(65063))
        XCTAssertNotEqual(BluetoothUUID.google4, .bit32(0xFE27))

        /// Ayla Networks
        XCTAssertEqual(BluetoothUUID.aylaNetworks.rawValue, "FE28")
        XCTAssertEqual(BluetoothUUID.aylaNetworks, .bit16(0xFE28))
        XCTAssertEqual(BluetoothUUID.aylaNetworks, .bit16(65064))
        XCTAssertEqual(BluetoothUUID.aylaNetworks.name, "Ayla Networks")
        XCTAssertNotEqual(BluetoothUUID.aylaNetworks, .bit32(65064))
        XCTAssertNotEqual(BluetoothUUID.aylaNetworks, .bit32(0xFE28))

        /// Gibson Innovations
        XCTAssertEqual(BluetoothUUID.gibsonInnovations.rawValue, "FE29")
        XCTAssertEqual(BluetoothUUID.gibsonInnovations, .bit16(0xFE29))
        XCTAssertEqual(BluetoothUUID.gibsonInnovations, .bit16(65065))
        XCTAssertEqual(BluetoothUUID.gibsonInnovations.name, "Gibson Innovations")
        XCTAssertNotEqual(BluetoothUUID.gibsonInnovations, .bit32(65065))
        XCTAssertNotEqual(BluetoothUUID.gibsonInnovations, .bit32(0xFE29))

        /// DaisyWorks, Inc.
        XCTAssertEqual(BluetoothUUID.daisyworks.rawValue, "FE2A")
        XCTAssertEqual(BluetoothUUID.daisyworks, .bit16(0xFE2A))
        XCTAssertEqual(BluetoothUUID.daisyworks, .bit16(65066))
        XCTAssertEqual(BluetoothUUID.daisyworks.name, "DaisyWorks, Inc.")
        XCTAssertNotEqual(BluetoothUUID.daisyworks, .bit32(65066))
        XCTAssertNotEqual(BluetoothUUID.daisyworks, .bit32(0xFE2A))

        /// ITT Industries
        XCTAssertEqual(BluetoothUUID.ittIndustries.rawValue, "FE2B")
        XCTAssertEqual(BluetoothUUID.ittIndustries, .bit16(0xFE2B))
        XCTAssertEqual(BluetoothUUID.ittIndustries, .bit16(65067))
        XCTAssertEqual(BluetoothUUID.ittIndustries.name, "ITT Industries")
        XCTAssertNotEqual(BluetoothUUID.ittIndustries, .bit32(65067))
        XCTAssertNotEqual(BluetoothUUID.ittIndustries, .bit32(0xFE2B))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google5.rawValue, "FE2C")
        XCTAssertEqual(BluetoothUUID.google5, .bit16(0xFE2C))
        XCTAssertEqual(BluetoothUUID.google5, .bit16(65068))
        XCTAssertEqual(BluetoothUUID.google5.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google5, .bit32(65068))
        XCTAssertNotEqual(BluetoothUUID.google5, .bit32(0xFE2C))

        /// SMART INNOVATION Co.,Ltd
        XCTAssertEqual(BluetoothUUID.smartInnovation.rawValue, "FE2D")
        XCTAssertEqual(BluetoothUUID.smartInnovation, .bit16(0xFE2D))
        XCTAssertEqual(BluetoothUUID.smartInnovation, .bit16(65069))
        XCTAssertEqual(BluetoothUUID.smartInnovation.name, "SMART INNOVATION Co.,Ltd")
        XCTAssertNotEqual(BluetoothUUID.smartInnovation, .bit32(65069))
        XCTAssertNotEqual(BluetoothUUID.smartInnovation, .bit32(0xFE2D))

        /// ERi,Inc.
        XCTAssertEqual(BluetoothUUID.eri.rawValue, "FE2E")
        XCTAssertEqual(BluetoothUUID.eri, .bit16(0xFE2E))
        XCTAssertEqual(BluetoothUUID.eri, .bit16(65070))
        XCTAssertEqual(BluetoothUUID.eri.name, "ERi,Inc.")
        XCTAssertNotEqual(BluetoothUUID.eri, .bit32(65070))
        XCTAssertNotEqual(BluetoothUUID.eri, .bit32(0xFE2E))

        /// CRESCO Wireless, Inc
        XCTAssertEqual(BluetoothUUID.crescoWireless.rawValue, "FE2F")
        XCTAssertEqual(BluetoothUUID.crescoWireless, .bit16(0xFE2F))
        XCTAssertEqual(BluetoothUUID.crescoWireless, .bit16(65071))
        XCTAssertEqual(BluetoothUUID.crescoWireless.name, "CRESCO Wireless, Inc")
        XCTAssertNotEqual(BluetoothUUID.crescoWireless, .bit32(65071))
        XCTAssertNotEqual(BluetoothUUID.crescoWireless, .bit32(0xFE2F))

        /// Volkswagen AG
        XCTAssertEqual(BluetoothUUID.volkswagen.rawValue, "FE30")
        XCTAssertEqual(BluetoothUUID.volkswagen, .bit16(0xFE30))
        XCTAssertEqual(BluetoothUUID.volkswagen, .bit16(65072))
        XCTAssertEqual(BluetoothUUID.volkswagen.name, "Volkswagen AG")
        XCTAssertNotEqual(BluetoothUUID.volkswagen, .bit32(65072))
        XCTAssertNotEqual(BluetoothUUID.volkswagen, .bit32(0xFE30))

        /// Volkswagen AG
        XCTAssertEqual(BluetoothUUID.volkswagen2.rawValue, "FE31")
        XCTAssertEqual(BluetoothUUID.volkswagen2, .bit16(0xFE31))
        XCTAssertEqual(BluetoothUUID.volkswagen2, .bit16(65073))
        XCTAssertEqual(BluetoothUUID.volkswagen2.name, "Volkswagen AG")
        XCTAssertNotEqual(BluetoothUUID.volkswagen2, .bit32(65073))
        XCTAssertNotEqual(BluetoothUUID.volkswagen2, .bit32(0xFE31))

        /// Pro-Mark, Inc.
        XCTAssertEqual(BluetoothUUID.proMark.rawValue, "FE32")
        XCTAssertEqual(BluetoothUUID.proMark, .bit16(0xFE32))
        XCTAssertEqual(BluetoothUUID.proMark, .bit16(65074))
        XCTAssertEqual(BluetoothUUID.proMark.name, "Pro-Mark, Inc.")
        XCTAssertNotEqual(BluetoothUUID.proMark, .bit32(65074))
        XCTAssertNotEqual(BluetoothUUID.proMark, .bit32(0xFE32))

        /// CHIPOLO d.o.o.
        XCTAssertEqual(BluetoothUUID.chipolo.rawValue, "FE33")
        XCTAssertEqual(BluetoothUUID.chipolo, .bit16(0xFE33))
        XCTAssertEqual(BluetoothUUID.chipolo, .bit16(65075))
        XCTAssertEqual(BluetoothUUID.chipolo.name, "CHIPOLO d.o.o.")
        XCTAssertNotEqual(BluetoothUUID.chipolo, .bit32(65075))
        XCTAssertNotEqual(BluetoothUUID.chipolo, .bit32(0xFE33))

        /// SmallLoop LLC
        XCTAssertEqual(BluetoothUUID.smallloop.rawValue, "FE34")
        XCTAssertEqual(BluetoothUUID.smallloop, .bit16(0xFE34))
        XCTAssertEqual(BluetoothUUID.smallloop, .bit16(65076))
        XCTAssertEqual(BluetoothUUID.smallloop.name, "SmallLoop LLC")
        XCTAssertNotEqual(BluetoothUUID.smallloop, .bit32(65076))
        XCTAssertNotEqual(BluetoothUUID.smallloop, .bit32(0xFE34))

        /// HUAWEI Technologies Co., Ltd
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies2.rawValue, "FE35")
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies2, .bit16(0xFE35))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies2, .bit16(65077))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies2.name, "HUAWEI Technologies Co., Ltd")
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies2, .bit32(65077))
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies2, .bit32(0xFE35))

        /// HUAWEI Technologies Co., Ltd
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies3.rawValue, "FE36")
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies3, .bit16(0xFE36))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies3, .bit16(65078))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies3.name, "HUAWEI Technologies Co., Ltd")
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies3, .bit32(65078))
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies3, .bit32(0xFE36))

        /// Spaceek LTD
        XCTAssertEqual(BluetoothUUID.spaceek.rawValue, "FE37")
        XCTAssertEqual(BluetoothUUID.spaceek, .bit16(0xFE37))
        XCTAssertEqual(BluetoothUUID.spaceek, .bit16(65079))
        XCTAssertEqual(BluetoothUUID.spaceek.name, "Spaceek LTD")
        XCTAssertNotEqual(BluetoothUUID.spaceek, .bit32(65079))
        XCTAssertNotEqual(BluetoothUUID.spaceek, .bit32(0xFE37))

        /// Spaceek LTD
        XCTAssertEqual(BluetoothUUID.spaceek2.rawValue, "FE38")
        XCTAssertEqual(BluetoothUUID.spaceek2, .bit16(0xFE38))
        XCTAssertEqual(BluetoothUUID.spaceek2, .bit16(65080))
        XCTAssertEqual(BluetoothUUID.spaceek2.name, "Spaceek LTD")
        XCTAssertNotEqual(BluetoothUUID.spaceek2, .bit32(65080))
        XCTAssertNotEqual(BluetoothUUID.spaceek2, .bit32(0xFE38))

        /// TTS Tooltechnic Systems AG & Co.
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems.rawValue, "FE39")
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems, .bit16(0xFE39))
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems, .bit16(65081))
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems.name, "TTS Tooltechnic Systems AG & Co.")
        XCTAssertNotEqual(BluetoothUUID.ttsTooltechnicSystems, .bit32(65081))
        XCTAssertNotEqual(BluetoothUUID.ttsTooltechnicSystems, .bit32(0xFE39))

        /// TTS Tooltechnic Systems AG & Co.
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems2.rawValue, "FE3A")
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems2, .bit16(0xFE3A))
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems2, .bit16(65082))
        XCTAssertEqual(BluetoothUUID.ttsTooltechnicSystems2.name, "TTS Tooltechnic Systems AG & Co.")
        XCTAssertNotEqual(BluetoothUUID.ttsTooltechnicSystems2, .bit32(65082))
        XCTAssertNotEqual(BluetoothUUID.ttsTooltechnicSystems2, .bit32(0xFE3A))

        /// Dolby Laboratories
        XCTAssertEqual(BluetoothUUID.dolbyLaboratories.rawValue, "FE3B")
        XCTAssertEqual(BluetoothUUID.dolbyLaboratories, .bit16(0xFE3B))
        XCTAssertEqual(BluetoothUUID.dolbyLaboratories, .bit16(65083))
        XCTAssertEqual(BluetoothUUID.dolbyLaboratories.name, "Dolby Laboratories")
        XCTAssertNotEqual(BluetoothUUID.dolbyLaboratories, .bit32(65083))
        XCTAssertNotEqual(BluetoothUUID.dolbyLaboratories, .bit32(0xFE3B))

        /// Alibaba
        XCTAssertEqual(BluetoothUUID.alibaba.rawValue, "FE3C")
        XCTAssertEqual(BluetoothUUID.alibaba, .bit16(0xFE3C))
        XCTAssertEqual(BluetoothUUID.alibaba, .bit16(65084))
        XCTAssertEqual(BluetoothUUID.alibaba.name, "Alibaba")
        XCTAssertNotEqual(BluetoothUUID.alibaba, .bit32(65084))
        XCTAssertNotEqual(BluetoothUUID.alibaba, .bit32(0xFE3C))

        /// BD Medical
        XCTAssertEqual(BluetoothUUID.bdMedical.rawValue, "FE3D")
        XCTAssertEqual(BluetoothUUID.bdMedical, .bit16(0xFE3D))
        XCTAssertEqual(BluetoothUUID.bdMedical, .bit16(65085))
        XCTAssertEqual(BluetoothUUID.bdMedical.name, "BD Medical")
        XCTAssertNotEqual(BluetoothUUID.bdMedical, .bit32(65085))
        XCTAssertNotEqual(BluetoothUUID.bdMedical, .bit32(0xFE3D))

        /// BD Medical
        XCTAssertEqual(BluetoothUUID.bdMedical2.rawValue, "FE3E")
        XCTAssertEqual(BluetoothUUID.bdMedical2, .bit16(0xFE3E))
        XCTAssertEqual(BluetoothUUID.bdMedical2, .bit16(65086))
        XCTAssertEqual(BluetoothUUID.bdMedical2.name, "BD Medical")
        XCTAssertNotEqual(BluetoothUUID.bdMedical2, .bit32(65086))
        XCTAssertNotEqual(BluetoothUUID.bdMedical2, .bit32(0xFE3E))

        /// Friday Labs Limited
        XCTAssertEqual(BluetoothUUID.fridayLabs.rawValue, "FE3F")
        XCTAssertEqual(BluetoothUUID.fridayLabs, .bit16(0xFE3F))
        XCTAssertEqual(BluetoothUUID.fridayLabs, .bit16(65087))
        XCTAssertEqual(BluetoothUUID.fridayLabs.name, "Friday Labs Limited")
        XCTAssertNotEqual(BluetoothUUID.fridayLabs, .bit32(65087))
        XCTAssertNotEqual(BluetoothUUID.fridayLabs, .bit32(0xFE3F))

        /// Inugo Systems Limited
        XCTAssertEqual(BluetoothUUID.inugoSystems.rawValue, "FE40")
        XCTAssertEqual(BluetoothUUID.inugoSystems, .bit16(0xFE40))
        XCTAssertEqual(BluetoothUUID.inugoSystems, .bit16(65088))
        XCTAssertEqual(BluetoothUUID.inugoSystems.name, "Inugo Systems Limited")
        XCTAssertNotEqual(BluetoothUUID.inugoSystems, .bit32(65088))
        XCTAssertNotEqual(BluetoothUUID.inugoSystems, .bit32(0xFE40))

        /// Inugo Systems Limited
        XCTAssertEqual(BluetoothUUID.inugoSystems2.rawValue, "FE41")
        XCTAssertEqual(BluetoothUUID.inugoSystems2, .bit16(0xFE41))
        XCTAssertEqual(BluetoothUUID.inugoSystems2, .bit16(65089))
        XCTAssertEqual(BluetoothUUID.inugoSystems2.name, "Inugo Systems Limited")
        XCTAssertNotEqual(BluetoothUUID.inugoSystems2, .bit32(65089))
        XCTAssertNotEqual(BluetoothUUID.inugoSystems2, .bit32(0xFE41))

        /// Nets A/S
        XCTAssertEqual(BluetoothUUID.nets.rawValue, "FE42")
        XCTAssertEqual(BluetoothUUID.nets, .bit16(0xFE42))
        XCTAssertEqual(BluetoothUUID.nets, .bit16(65090))
        XCTAssertEqual(BluetoothUUID.nets.name, "Nets A/S")
        XCTAssertNotEqual(BluetoothUUID.nets, .bit32(65090))
        XCTAssertNotEqual(BluetoothUUID.nets, .bit32(0xFE42))

        /// Andreas Stihl AG & Co. KG
        XCTAssertEqual(BluetoothUUID.andreasStihl.rawValue, "FE43")
        XCTAssertEqual(BluetoothUUID.andreasStihl, .bit16(0xFE43))
        XCTAssertEqual(BluetoothUUID.andreasStihl, .bit16(65091))
        XCTAssertEqual(BluetoothUUID.andreasStihl.name, "Andreas Stihl AG & Co. KG")
        XCTAssertNotEqual(BluetoothUUID.andreasStihl, .bit32(65091))
        XCTAssertNotEqual(BluetoothUUID.andreasStihl, .bit32(0xFE43))

        /// SK Telecom
        XCTAssertEqual(BluetoothUUID.skTelecom.rawValue, "FE44")
        XCTAssertEqual(BluetoothUUID.skTelecom, .bit16(0xFE44))
        XCTAssertEqual(BluetoothUUID.skTelecom, .bit16(65092))
        XCTAssertEqual(BluetoothUUID.skTelecom.name, "SK Telecom")
        XCTAssertNotEqual(BluetoothUUID.skTelecom, .bit32(65092))
        XCTAssertNotEqual(BluetoothUUID.skTelecom, .bit32(0xFE44))

        /// Snapchat Inc
        XCTAssertEqual(BluetoothUUID.snapchat.rawValue, "FE45")
        XCTAssertEqual(BluetoothUUID.snapchat, .bit16(0xFE45))
        XCTAssertEqual(BluetoothUUID.snapchat, .bit16(65093))
        XCTAssertEqual(BluetoothUUID.snapchat.name, "Snapchat Inc")
        XCTAssertNotEqual(BluetoothUUID.snapchat, .bit32(65093))
        XCTAssertNotEqual(BluetoothUUID.snapchat, .bit32(0xFE45))

        /// B&O Play A/S
        XCTAssertEqual(BluetoothUUID.bOPlay.rawValue, "FE46")
        XCTAssertEqual(BluetoothUUID.bOPlay, .bit16(0xFE46))
        XCTAssertEqual(BluetoothUUID.bOPlay, .bit16(65094))
        XCTAssertEqual(BluetoothUUID.bOPlay.name, "B&O Play A/S")
        XCTAssertNotEqual(BluetoothUUID.bOPlay, .bit32(65094))
        XCTAssertNotEqual(BluetoothUUID.bOPlay, .bit32(0xFE46))

        /// General Motors
        XCTAssertEqual(BluetoothUUID.generalMotors.rawValue, "FE47")
        XCTAssertEqual(BluetoothUUID.generalMotors, .bit16(0xFE47))
        XCTAssertEqual(BluetoothUUID.generalMotors, .bit16(65095))
        XCTAssertEqual(BluetoothUUID.generalMotors.name, "General Motors")
        XCTAssertNotEqual(BluetoothUUID.generalMotors, .bit32(65095))
        XCTAssertNotEqual(BluetoothUUID.generalMotors, .bit32(0xFE47))

        /// General Motors
        XCTAssertEqual(BluetoothUUID.generalMotors2.rawValue, "FE48")
        XCTAssertEqual(BluetoothUUID.generalMotors2, .bit16(0xFE48))
        XCTAssertEqual(BluetoothUUID.generalMotors2, .bit16(65096))
        XCTAssertEqual(BluetoothUUID.generalMotors2.name, "General Motors")
        XCTAssertNotEqual(BluetoothUUID.generalMotors2, .bit32(65096))
        XCTAssertNotEqual(BluetoothUUID.generalMotors2, .bit32(0xFE48))

        /// SenionLab AB
        XCTAssertEqual(BluetoothUUID.senionlab.rawValue, "FE49")
        XCTAssertEqual(BluetoothUUID.senionlab, .bit16(0xFE49))
        XCTAssertEqual(BluetoothUUID.senionlab, .bit16(65097))
        XCTAssertEqual(BluetoothUUID.senionlab.name, "SenionLab AB")
        XCTAssertNotEqual(BluetoothUUID.senionlab, .bit32(65097))
        XCTAssertNotEqual(BluetoothUUID.senionlab, .bit32(0xFE49))

        /// OMRON HEALTHCARE Co., Ltd.
        XCTAssertEqual(BluetoothUUID.omronHealthcare.rawValue, "FE4A")
        XCTAssertEqual(BluetoothUUID.omronHealthcare, .bit16(0xFE4A))
        XCTAssertEqual(BluetoothUUID.omronHealthcare, .bit16(65098))
        XCTAssertEqual(BluetoothUUID.omronHealthcare.name, "OMRON HEALTHCARE Co., Ltd.")
        XCTAssertNotEqual(BluetoothUUID.omronHealthcare, .bit32(65098))
        XCTAssertNotEqual(BluetoothUUID.omronHealthcare, .bit32(0xFE4A))

        /// Philips Lighting B.V.
        XCTAssertEqual(BluetoothUUID.philipsLighting2.rawValue, "FE4B")
        XCTAssertEqual(BluetoothUUID.philipsLighting2, .bit16(0xFE4B))
        XCTAssertEqual(BluetoothUUID.philipsLighting2, .bit16(65099))
        XCTAssertEqual(BluetoothUUID.philipsLighting2.name, "Philips Lighting B.V.")
        XCTAssertNotEqual(BluetoothUUID.philipsLighting2, .bit32(65099))
        XCTAssertNotEqual(BluetoothUUID.philipsLighting2, .bit32(0xFE4B))

        /// Volkswagen AG
        XCTAssertEqual(BluetoothUUID.volkswagen3.rawValue, "FE4C")
        XCTAssertEqual(BluetoothUUID.volkswagen3, .bit16(0xFE4C))
        XCTAssertEqual(BluetoothUUID.volkswagen3, .bit16(65100))
        XCTAssertEqual(BluetoothUUID.volkswagen3.name, "Volkswagen AG")
        XCTAssertNotEqual(BluetoothUUID.volkswagen3, .bit32(65100))
        XCTAssertNotEqual(BluetoothUUID.volkswagen3, .bit32(0xFE4C))

        /// Casambi Technologies Oy
        XCTAssertEqual(BluetoothUUID.casambiTechnologies.rawValue, "FE4D")
        XCTAssertEqual(BluetoothUUID.casambiTechnologies, .bit16(0xFE4D))
        XCTAssertEqual(BluetoothUUID.casambiTechnologies, .bit16(65101))
        XCTAssertEqual(BluetoothUUID.casambiTechnologies.name, "Casambi Technologies Oy")
        XCTAssertNotEqual(BluetoothUUID.casambiTechnologies, .bit32(65101))
        XCTAssertNotEqual(BluetoothUUID.casambiTechnologies, .bit32(0xFE4D))

        /// NTT docomo
        XCTAssertEqual(BluetoothUUID.nttDocomo.rawValue, "FE4E")
        XCTAssertEqual(BluetoothUUID.nttDocomo, .bit16(0xFE4E))
        XCTAssertEqual(BluetoothUUID.nttDocomo, .bit16(65102))
        XCTAssertEqual(BluetoothUUID.nttDocomo.name, "NTT docomo")
        XCTAssertNotEqual(BluetoothUUID.nttDocomo, .bit32(65102))
        XCTAssertNotEqual(BluetoothUUID.nttDocomo, .bit32(0xFE4E))

        /// Molekule, Inc.
        XCTAssertEqual(BluetoothUUID.molekule.rawValue, "FE4F")
        XCTAssertEqual(BluetoothUUID.molekule, .bit16(0xFE4F))
        XCTAssertEqual(BluetoothUUID.molekule, .bit16(65103))
        XCTAssertEqual(BluetoothUUID.molekule.name, "Molekule, Inc.")
        XCTAssertNotEqual(BluetoothUUID.molekule, .bit32(65103))
        XCTAssertNotEqual(BluetoothUUID.molekule, .bit32(0xFE4F))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google6.rawValue, "FE50")
        XCTAssertEqual(BluetoothUUID.google6, .bit16(0xFE50))
        XCTAssertEqual(BluetoothUUID.google6, .bit16(65104))
        XCTAssertEqual(BluetoothUUID.google6.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google6, .bit32(65104))
        XCTAssertNotEqual(BluetoothUUID.google6, .bit32(0xFE50))

        /// SRAM
        XCTAssertEqual(BluetoothUUID.sram.rawValue, "FE51")
        XCTAssertEqual(BluetoothUUID.sram, .bit16(0xFE51))
        XCTAssertEqual(BluetoothUUID.sram, .bit16(65105))
        XCTAssertEqual(BluetoothUUID.sram.name, "SRAM")
        XCTAssertNotEqual(BluetoothUUID.sram, .bit32(65105))
        XCTAssertNotEqual(BluetoothUUID.sram, .bit32(0xFE51))

        /// SetPoint Medical
        XCTAssertEqual(BluetoothUUID.setpointMedical.rawValue, "FE52")
        XCTAssertEqual(BluetoothUUID.setpointMedical, .bit16(0xFE52))
        XCTAssertEqual(BluetoothUUID.setpointMedical, .bit16(65106))
        XCTAssertEqual(BluetoothUUID.setpointMedical.name, "SetPoint Medical")
        XCTAssertNotEqual(BluetoothUUID.setpointMedical, .bit32(65106))
        XCTAssertNotEqual(BluetoothUUID.setpointMedical, .bit32(0xFE52))

        /// 3M
        XCTAssertEqual(BluetoothUUID.uuid3M.rawValue, "FE53")
        XCTAssertEqual(BluetoothUUID.uuid3M, .bit16(0xFE53))
        XCTAssertEqual(BluetoothUUID.uuid3M, .bit16(65107))
        XCTAssertEqual(BluetoothUUID.uuid3M.name, "3M")
        XCTAssertNotEqual(BluetoothUUID.uuid3M, .bit32(65107))
        XCTAssertNotEqual(BluetoothUUID.uuid3M, .bit32(0xFE53))

        /// Motiv, Inc.
        XCTAssertEqual(BluetoothUUID.motiv.rawValue, "FE54")
        XCTAssertEqual(BluetoothUUID.motiv, .bit16(0xFE54))
        XCTAssertEqual(BluetoothUUID.motiv, .bit16(65108))
        XCTAssertEqual(BluetoothUUID.motiv.name, "Motiv, Inc.")
        XCTAssertNotEqual(BluetoothUUID.motiv, .bit32(65108))
        XCTAssertNotEqual(BluetoothUUID.motiv, .bit32(0xFE54))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google7.rawValue, "FE55")
        XCTAssertEqual(BluetoothUUID.google7, .bit16(0xFE55))
        XCTAssertEqual(BluetoothUUID.google7, .bit16(65109))
        XCTAssertEqual(BluetoothUUID.google7.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google7, .bit32(65109))
        XCTAssertNotEqual(BluetoothUUID.google7, .bit32(0xFE55))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google8.rawValue, "FE56")
        XCTAssertEqual(BluetoothUUID.google8, .bit16(0xFE56))
        XCTAssertEqual(BluetoothUUID.google8, .bit16(65110))
        XCTAssertEqual(BluetoothUUID.google8.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google8, .bit32(65110))
        XCTAssertNotEqual(BluetoothUUID.google8, .bit32(0xFE56))

        /// Dotted Labs
        XCTAssertEqual(BluetoothUUID.dottedLabs.rawValue, "FE57")
        XCTAssertEqual(BluetoothUUID.dottedLabs, .bit16(0xFE57))
        XCTAssertEqual(BluetoothUUID.dottedLabs, .bit16(65111))
        XCTAssertEqual(BluetoothUUID.dottedLabs.name, "Dotted Labs")
        XCTAssertNotEqual(BluetoothUUID.dottedLabs, .bit32(65111))
        XCTAssertNotEqual(BluetoothUUID.dottedLabs, .bit32(0xFE57))

        /// Nordic Semiconductor ASA
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor.rawValue, "FE58")
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor, .bit16(0xFE58))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor, .bit16(65112))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor.name, "Nordic Semiconductor ASA")
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor, .bit32(65112))
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor, .bit32(0xFE58))

        /// Nordic Semiconductor ASA
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor2.rawValue, "FE59")
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor2, .bit16(0xFE59))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor2, .bit16(65113))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor2.name, "Nordic Semiconductor ASA")
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor2, .bit32(65113))
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor2, .bit32(0xFE59))

        /// Chronologics Corporation
        XCTAssertEqual(BluetoothUUID.chronologics.rawValue, "FE5A")
        XCTAssertEqual(BluetoothUUID.chronologics, .bit16(0xFE5A))
        XCTAssertEqual(BluetoothUUID.chronologics, .bit16(65114))
        XCTAssertEqual(BluetoothUUID.chronologics.name, "Chronologics Corporation")
        XCTAssertNotEqual(BluetoothUUID.chronologics, .bit32(65114))
        XCTAssertNotEqual(BluetoothUUID.chronologics, .bit32(0xFE5A))

        /// GT-tronics HK Ltd
        XCTAssertEqual(BluetoothUUID.gtTronicsHk.rawValue, "FE5B")
        XCTAssertEqual(BluetoothUUID.gtTronicsHk, .bit16(0xFE5B))
        XCTAssertEqual(BluetoothUUID.gtTronicsHk, .bit16(65115))
        XCTAssertEqual(BluetoothUUID.gtTronicsHk.name, "GT-tronics HK Ltd")
        XCTAssertNotEqual(BluetoothUUID.gtTronicsHk, .bit32(65115))
        XCTAssertNotEqual(BluetoothUUID.gtTronicsHk, .bit32(0xFE5B))

        /// million hunters GmbH
        XCTAssertEqual(BluetoothUUID.millionHunters.rawValue, "FE5C")
        XCTAssertEqual(BluetoothUUID.millionHunters, .bit16(0xFE5C))
        XCTAssertEqual(BluetoothUUID.millionHunters, .bit16(65116))
        XCTAssertEqual(BluetoothUUID.millionHunters.name, "million hunters GmbH")
        XCTAssertNotEqual(BluetoothUUID.millionHunters, .bit32(65116))
        XCTAssertNotEqual(BluetoothUUID.millionHunters, .bit32(0xFE5C))

        /// Grundfos A/S
        XCTAssertEqual(BluetoothUUID.grundfos.rawValue, "FE5D")
        XCTAssertEqual(BluetoothUUID.grundfos, .bit16(0xFE5D))
        XCTAssertEqual(BluetoothUUID.grundfos, .bit16(65117))
        XCTAssertEqual(BluetoothUUID.grundfos.name, "Grundfos A/S")
        XCTAssertNotEqual(BluetoothUUID.grundfos, .bit32(65117))
        XCTAssertNotEqual(BluetoothUUID.grundfos, .bit32(0xFE5D))

        /// Plastc Corporation
        XCTAssertEqual(BluetoothUUID.plastc.rawValue, "FE5E")
        XCTAssertEqual(BluetoothUUID.plastc, .bit16(0xFE5E))
        XCTAssertEqual(BluetoothUUID.plastc, .bit16(65118))
        XCTAssertEqual(BluetoothUUID.plastc.name, "Plastc Corporation")
        XCTAssertNotEqual(BluetoothUUID.plastc, .bit32(65118))
        XCTAssertNotEqual(BluetoothUUID.plastc, .bit32(0xFE5E))

        /// Eyefi, Inc.
        XCTAssertEqual(BluetoothUUID.eyefi.rawValue, "FE5F")
        XCTAssertEqual(BluetoothUUID.eyefi, .bit16(0xFE5F))
        XCTAssertEqual(BluetoothUUID.eyefi, .bit16(65119))
        XCTAssertEqual(BluetoothUUID.eyefi.name, "Eyefi, Inc.")
        XCTAssertNotEqual(BluetoothUUID.eyefi, .bit32(65119))
        XCTAssertNotEqual(BluetoothUUID.eyefi, .bit32(0xFE5F))

        /// Lierda Science & Technology Group Co., Ltd.
        XCTAssertEqual(BluetoothUUID.lierdaScienceTechnologyGroup.rawValue, "FE60")
        XCTAssertEqual(BluetoothUUID.lierdaScienceTechnologyGroup, .bit16(0xFE60))
        XCTAssertEqual(BluetoothUUID.lierdaScienceTechnologyGroup, .bit16(65120))
        XCTAssertEqual(BluetoothUUID.lierdaScienceTechnologyGroup.name, "Lierda Science & Technology Group Co., Ltd.")
        XCTAssertNotEqual(BluetoothUUID.lierdaScienceTechnologyGroup, .bit32(65120))
        XCTAssertNotEqual(BluetoothUUID.lierdaScienceTechnologyGroup, .bit32(0xFE60))

        /// Logitech International SA
        XCTAssertEqual(BluetoothUUID.logitechInternational.rawValue, "FE61")
        XCTAssertEqual(BluetoothUUID.logitechInternational, .bit16(0xFE61))
        XCTAssertEqual(BluetoothUUID.logitechInternational, .bit16(65121))
        XCTAssertEqual(BluetoothUUID.logitechInternational.name, "Logitech International SA")
        XCTAssertNotEqual(BluetoothUUID.logitechInternational, .bit32(65121))
        XCTAssertNotEqual(BluetoothUUID.logitechInternational, .bit32(0xFE61))

        /// Indagem Tech LLC
        XCTAssertEqual(BluetoothUUID.indagemTech.rawValue, "FE62")
        XCTAssertEqual(BluetoothUUID.indagemTech, .bit16(0xFE62))
        XCTAssertEqual(BluetoothUUID.indagemTech, .bit16(65122))
        XCTAssertEqual(BluetoothUUID.indagemTech.name, "Indagem Tech LLC")
        XCTAssertNotEqual(BluetoothUUID.indagemTech, .bit32(65122))
        XCTAssertNotEqual(BluetoothUUID.indagemTech, .bit32(0xFE62))

        /// Connected Yard, Inc.
        XCTAssertEqual(BluetoothUUID.connectedYard.rawValue, "FE63")
        XCTAssertEqual(BluetoothUUID.connectedYard, .bit16(0xFE63))
        XCTAssertEqual(BluetoothUUID.connectedYard, .bit16(65123))
        XCTAssertEqual(BluetoothUUID.connectedYard.name, "Connected Yard, Inc.")
        XCTAssertNotEqual(BluetoothUUID.connectedYard, .bit32(65123))
        XCTAssertNotEqual(BluetoothUUID.connectedYard, .bit32(0xFE63))

        /// Siemens AG
        XCTAssertEqual(BluetoothUUID.siemens.rawValue, "FE64")
        XCTAssertEqual(BluetoothUUID.siemens, .bit16(0xFE64))
        XCTAssertEqual(BluetoothUUID.siemens, .bit16(65124))
        XCTAssertEqual(BluetoothUUID.siemens.name, "Siemens AG")
        XCTAssertNotEqual(BluetoothUUID.siemens, .bit32(65124))
        XCTAssertNotEqual(BluetoothUUID.siemens, .bit32(0xFE64))

        /// CHIPOLO d.o.o.
        XCTAssertEqual(BluetoothUUID.chipolo2.rawValue, "FE65")
        XCTAssertEqual(BluetoothUUID.chipolo2, .bit16(0xFE65))
        XCTAssertEqual(BluetoothUUID.chipolo2, .bit16(65125))
        XCTAssertEqual(BluetoothUUID.chipolo2.name, "CHIPOLO d.o.o.")
        XCTAssertNotEqual(BluetoothUUID.chipolo2, .bit32(65125))
        XCTAssertNotEqual(BluetoothUUID.chipolo2, .bit32(0xFE65))

        /// Intel Corporation
        XCTAssertEqual(BluetoothUUID.intel.rawValue, "FE66")
        XCTAssertEqual(BluetoothUUID.intel, .bit16(0xFE66))
        XCTAssertEqual(BluetoothUUID.intel, .bit16(65126))
        XCTAssertEqual(BluetoothUUID.intel.name, "Intel Corporation")
        XCTAssertNotEqual(BluetoothUUID.intel, .bit32(65126))
        XCTAssertNotEqual(BluetoothUUID.intel, .bit32(0xFE66))

        /// Lab Sensor Solutions
        XCTAssertEqual(BluetoothUUID.labSensorSolutions.rawValue, "FE67")
        XCTAssertEqual(BluetoothUUID.labSensorSolutions, .bit16(0xFE67))
        XCTAssertEqual(BluetoothUUID.labSensorSolutions, .bit16(65127))
        XCTAssertEqual(BluetoothUUID.labSensorSolutions.name, "Lab Sensor Solutions")
        XCTAssertNotEqual(BluetoothUUID.labSensorSolutions, .bit32(65127))
        XCTAssertNotEqual(BluetoothUUID.labSensorSolutions, .bit32(0xFE67))

        /// Qualcomm Life Inc
        XCTAssertEqual(BluetoothUUID.qualcommLife.rawValue, "FE68")
        XCTAssertEqual(BluetoothUUID.qualcommLife, .bit16(0xFE68))
        XCTAssertEqual(BluetoothUUID.qualcommLife, .bit16(65128))
        XCTAssertEqual(BluetoothUUID.qualcommLife.name, "Qualcomm Life Inc")
        XCTAssertNotEqual(BluetoothUUID.qualcommLife, .bit32(65128))
        XCTAssertNotEqual(BluetoothUUID.qualcommLife, .bit32(0xFE68))

        /// Qualcomm Life Inc
        XCTAssertEqual(BluetoothUUID.qualcommLife2.rawValue, "FE69")
        XCTAssertEqual(BluetoothUUID.qualcommLife2, .bit16(0xFE69))
        XCTAssertEqual(BluetoothUUID.qualcommLife2, .bit16(65129))
        XCTAssertEqual(BluetoothUUID.qualcommLife2.name, "Qualcomm Life Inc")
        XCTAssertNotEqual(BluetoothUUID.qualcommLife2, .bit32(65129))
        XCTAssertNotEqual(BluetoothUUID.qualcommLife2, .bit32(0xFE69))

        /// Kontakt Micro-Location Sp. z o.o.
        XCTAssertEqual(BluetoothUUID.kontaktMicroLocation.rawValue, "FE6A")
        XCTAssertEqual(BluetoothUUID.kontaktMicroLocation, .bit16(0xFE6A))
        XCTAssertEqual(BluetoothUUID.kontaktMicroLocation, .bit16(65130))
        XCTAssertEqual(BluetoothUUID.kontaktMicroLocation.name, "Kontakt Micro-Location Sp. z o.o.")
        XCTAssertNotEqual(BluetoothUUID.kontaktMicroLocation, .bit32(65130))
        XCTAssertNotEqual(BluetoothUUID.kontaktMicroLocation, .bit32(0xFE6A))

        /// TASER International, Inc.
        XCTAssertEqual(BluetoothUUID.taserInternational.rawValue, "FE6B")
        XCTAssertEqual(BluetoothUUID.taserInternational, .bit16(0xFE6B))
        XCTAssertEqual(BluetoothUUID.taserInternational, .bit16(65131))
        XCTAssertEqual(BluetoothUUID.taserInternational.name, "TASER International, Inc.")
        XCTAssertNotEqual(BluetoothUUID.taserInternational, .bit32(65131))
        XCTAssertNotEqual(BluetoothUUID.taserInternational, .bit32(0xFE6B))

        /// TASER International, Inc.
        XCTAssertEqual(BluetoothUUID.taserInternational2.rawValue, "FE6C")
        XCTAssertEqual(BluetoothUUID.taserInternational2, .bit16(0xFE6C))
        XCTAssertEqual(BluetoothUUID.taserInternational2, .bit16(65132))
        XCTAssertEqual(BluetoothUUID.taserInternational2.name, "TASER International, Inc.")
        XCTAssertNotEqual(BluetoothUUID.taserInternational2, .bit32(65132))
        XCTAssertNotEqual(BluetoothUUID.taserInternational2, .bit32(0xFE6C))

        /// The University of Tokyo
        XCTAssertEqual(BluetoothUUID.universityOfTokyo.rawValue, "FE6D")
        XCTAssertEqual(BluetoothUUID.universityOfTokyo, .bit16(0xFE6D))
        XCTAssertEqual(BluetoothUUID.universityOfTokyo, .bit16(65133))
        XCTAssertEqual(BluetoothUUID.universityOfTokyo.name, "The University of Tokyo")
        XCTAssertNotEqual(BluetoothUUID.universityOfTokyo, .bit32(65133))
        XCTAssertNotEqual(BluetoothUUID.universityOfTokyo, .bit32(0xFE6D))

        /// The University of Tokyo
        XCTAssertEqual(BluetoothUUID.universityOfTokyo2.rawValue, "FE6E")
        XCTAssertEqual(BluetoothUUID.universityOfTokyo2, .bit16(0xFE6E))
        XCTAssertEqual(BluetoothUUID.universityOfTokyo2, .bit16(65134))
        XCTAssertEqual(BluetoothUUID.universityOfTokyo2.name, "The University of Tokyo")
        XCTAssertNotEqual(BluetoothUUID.universityOfTokyo2, .bit32(65134))
        XCTAssertNotEqual(BluetoothUUID.universityOfTokyo2, .bit32(0xFE6E))

        /// LINE Corporation
        XCTAssertEqual(BluetoothUUID.line.rawValue, "FE6F")
        XCTAssertEqual(BluetoothUUID.line, .bit16(0xFE6F))
        XCTAssertEqual(BluetoothUUID.line, .bit16(65135))
        XCTAssertEqual(BluetoothUUID.line.name, "LINE Corporation")
        XCTAssertNotEqual(BluetoothUUID.line, .bit32(65135))
        XCTAssertNotEqual(BluetoothUUID.line, .bit32(0xFE6F))

        /// Beijing Jingdong Century Trading Co., Ltd.
        XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading.rawValue, "FE70")
        XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit16(0xFE70))
        XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit16(65136))
        XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading.name, "Beijing Jingdong Century Trading Co., Ltd.")
        XCTAssertNotEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit32(65136))
        XCTAssertNotEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit32(0xFE70))

        /// Plume Design Inc
        XCTAssertEqual(BluetoothUUID.plumeDesign.rawValue, "FE71")
        XCTAssertEqual(BluetoothUUID.plumeDesign, .bit16(0xFE71))
        XCTAssertEqual(BluetoothUUID.plumeDesign, .bit16(65137))
        XCTAssertEqual(BluetoothUUID.plumeDesign.name, "Plume Design Inc")
        XCTAssertNotEqual(BluetoothUUID.plumeDesign, .bit32(65137))
        XCTAssertNotEqual(BluetoothUUID.plumeDesign, .bit32(0xFE71))

        /// St. Jude Medical, Inc.
        XCTAssertEqual(BluetoothUUID.stJudeMedical.rawValue, "FE72")
        XCTAssertEqual(BluetoothUUID.stJudeMedical, .bit16(0xFE72))
        XCTAssertEqual(BluetoothUUID.stJudeMedical, .bit16(65138))
        XCTAssertEqual(BluetoothUUID.stJudeMedical.name, "St. Jude Medical, Inc.")
        XCTAssertNotEqual(BluetoothUUID.stJudeMedical, .bit32(65138))
        XCTAssertNotEqual(BluetoothUUID.stJudeMedical, .bit32(0xFE72))

        /// St. Jude Medical, Inc.
        XCTAssertEqual(BluetoothUUID.stJudeMedical2.rawValue, "FE73")
        XCTAssertEqual(BluetoothUUID.stJudeMedical2, .bit16(0xFE73))
        XCTAssertEqual(BluetoothUUID.stJudeMedical2, .bit16(65139))
        XCTAssertEqual(BluetoothUUID.stJudeMedical2.name, "St. Jude Medical, Inc.")
        XCTAssertNotEqual(BluetoothUUID.stJudeMedical2, .bit32(65139))
        XCTAssertNotEqual(BluetoothUUID.stJudeMedical2, .bit32(0xFE73))

        /// unwire
        XCTAssertEqual(BluetoothUUID.unwire.rawValue, "FE74")
        XCTAssertEqual(BluetoothUUID.unwire, .bit16(0xFE74))
        XCTAssertEqual(BluetoothUUID.unwire, .bit16(65140))
        XCTAssertEqual(BluetoothUUID.unwire.name, "unwire")
        XCTAssertNotEqual(BluetoothUUID.unwire, .bit32(65140))
        XCTAssertNotEqual(BluetoothUUID.unwire, .bit32(0xFE74))

        /// TangoMe
        XCTAssertEqual(BluetoothUUID.tangome.rawValue, "FE75")
        XCTAssertEqual(BluetoothUUID.tangome, .bit16(0xFE75))
        XCTAssertEqual(BluetoothUUID.tangome, .bit16(65141))
        XCTAssertEqual(BluetoothUUID.tangome.name, "TangoMe")
        XCTAssertNotEqual(BluetoothUUID.tangome, .bit32(65141))
        XCTAssertNotEqual(BluetoothUUID.tangome, .bit32(0xFE75))

        /// TangoMe
        XCTAssertEqual(BluetoothUUID.tangome2.rawValue, "FE76")
        XCTAssertEqual(BluetoothUUID.tangome2, .bit16(0xFE76))
        XCTAssertEqual(BluetoothUUID.tangome2, .bit16(65142))
        XCTAssertEqual(BluetoothUUID.tangome2.name, "TangoMe")
        XCTAssertNotEqual(BluetoothUUID.tangome2, .bit32(65142))
        XCTAssertNotEqual(BluetoothUUID.tangome2, .bit32(0xFE76))

        /// Hewlett-Packard Company
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany.rawValue, "FE77")
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany, .bit16(0xFE77))
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany, .bit16(65143))
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany.name, "Hewlett-Packard Company")
        XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany, .bit32(65143))
        XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany, .bit32(0xFE77))

        /// Hewlett-Packard Company
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2.rawValue, "FE78")
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2, .bit16(0xFE78))
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2, .bit16(65144))
        XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2.name, "Hewlett-Packard Company")
        XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany2, .bit32(65144))
        XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany2, .bit32(0xFE78))

        /// Zebra Technologies
        XCTAssertEqual(BluetoothUUID.zebraTechnologies.rawValue, "FE79")
        XCTAssertEqual(BluetoothUUID.zebraTechnologies, .bit16(0xFE79))
        XCTAssertEqual(BluetoothUUID.zebraTechnologies, .bit16(65145))
        XCTAssertEqual(BluetoothUUID.zebraTechnologies.name, "Zebra Technologies")
        XCTAssertNotEqual(BluetoothUUID.zebraTechnologies, .bit32(65145))
        XCTAssertNotEqual(BluetoothUUID.zebraTechnologies, .bit32(0xFE79))

        /// Bragi GmbH
        XCTAssertEqual(BluetoothUUID.bragi.rawValue, "FE7A")
        XCTAssertEqual(BluetoothUUID.bragi, .bit16(0xFE7A))
        XCTAssertEqual(BluetoothUUID.bragi, .bit16(65146))
        XCTAssertEqual(BluetoothUUID.bragi.name, "Bragi GmbH")
        XCTAssertNotEqual(BluetoothUUID.bragi, .bit32(65146))
        XCTAssertNotEqual(BluetoothUUID.bragi, .bit32(0xFE7A))

        /// Orion Labs, Inc.
        XCTAssertEqual(BluetoothUUID.orionLabs.rawValue, "FE7B")
        XCTAssertEqual(BluetoothUUID.orionLabs, .bit16(0xFE7B))
        XCTAssertEqual(BluetoothUUID.orionLabs, .bit16(65147))
        XCTAssertEqual(BluetoothUUID.orionLabs.name, "Orion Labs, Inc.")
        XCTAssertNotEqual(BluetoothUUID.orionLabs, .bit32(65147))
        XCTAssertNotEqual(BluetoothUUID.orionLabs, .bit32(0xFE7B))

        /// Stollmann E+V GmbH
        XCTAssertEqual(BluetoothUUID.stollmannEV.rawValue, "FE7C")
        XCTAssertEqual(BluetoothUUID.stollmannEV, .bit16(0xFE7C))
        XCTAssertEqual(BluetoothUUID.stollmannEV, .bit16(65148))
        XCTAssertEqual(BluetoothUUID.stollmannEV.name, "Stollmann E+V GmbH")
        XCTAssertNotEqual(BluetoothUUID.stollmannEV, .bit32(65148))
        XCTAssertNotEqual(BluetoothUUID.stollmannEV, .bit32(0xFE7C))

        /// Aterica Health Inc.
        XCTAssertEqual(BluetoothUUID.atericaHealth.rawValue, "FE7D")
        XCTAssertEqual(BluetoothUUID.atericaHealth, .bit16(0xFE7D))
        XCTAssertEqual(BluetoothUUID.atericaHealth, .bit16(65149))
        XCTAssertEqual(BluetoothUUID.atericaHealth.name, "Aterica Health Inc.")
        XCTAssertNotEqual(BluetoothUUID.atericaHealth, .bit32(65149))
        XCTAssertNotEqual(BluetoothUUID.atericaHealth, .bit32(0xFE7D))

        /// Awear Solutions Ltd
        XCTAssertEqual(BluetoothUUID.awearSolutions.rawValue, "FE7E")
        XCTAssertEqual(BluetoothUUID.awearSolutions, .bit16(0xFE7E))
        XCTAssertEqual(BluetoothUUID.awearSolutions, .bit16(65150))
        XCTAssertEqual(BluetoothUUID.awearSolutions.name, "Awear Solutions Ltd")
        XCTAssertNotEqual(BluetoothUUID.awearSolutions, .bit32(65150))
        XCTAssertNotEqual(BluetoothUUID.awearSolutions, .bit32(0xFE7E))

        /// Doppler Lab
        XCTAssertEqual(BluetoothUUID.dopplerLab.rawValue, "FE7F")
        XCTAssertEqual(BluetoothUUID.dopplerLab, .bit16(0xFE7F))
        XCTAssertEqual(BluetoothUUID.dopplerLab, .bit16(65151))
        XCTAssertEqual(BluetoothUUID.dopplerLab.name, "Doppler Lab")
        XCTAssertNotEqual(BluetoothUUID.dopplerLab, .bit32(65151))
        XCTAssertNotEqual(BluetoothUUID.dopplerLab, .bit32(0xFE7F))

        /// Doppler Lab
        XCTAssertEqual(BluetoothUUID.dopplerLab2.rawValue, "FE80")
        XCTAssertEqual(BluetoothUUID.dopplerLab2, .bit16(0xFE80))
        XCTAssertEqual(BluetoothUUID.dopplerLab2, .bit16(65152))
        XCTAssertEqual(BluetoothUUID.dopplerLab2.name, "Doppler Lab")
        XCTAssertNotEqual(BluetoothUUID.dopplerLab2, .bit32(65152))
        XCTAssertNotEqual(BluetoothUUID.dopplerLab2, .bit32(0xFE80))

        /// Medtronic Inc.
        XCTAssertEqual(BluetoothUUID.medtronic.rawValue, "FE81")
        XCTAssertEqual(BluetoothUUID.medtronic, .bit16(0xFE81))
        XCTAssertEqual(BluetoothUUID.medtronic, .bit16(65153))
        XCTAssertEqual(BluetoothUUID.medtronic.name, "Medtronic Inc.")
        XCTAssertNotEqual(BluetoothUUID.medtronic, .bit32(65153))
        XCTAssertNotEqual(BluetoothUUID.medtronic, .bit32(0xFE81))

        /// Medtronic Inc.
        XCTAssertEqual(BluetoothUUID.medtronic2.rawValue, "FE82")
        XCTAssertEqual(BluetoothUUID.medtronic2, .bit16(0xFE82))
        XCTAssertEqual(BluetoothUUID.medtronic2, .bit16(65154))
        XCTAssertEqual(BluetoothUUID.medtronic2.name, "Medtronic Inc.")
        XCTAssertNotEqual(BluetoothUUID.medtronic2, .bit32(65154))
        XCTAssertNotEqual(BluetoothUUID.medtronic2, .bit32(0xFE82))

        /// Blue Bite
        XCTAssertEqual(BluetoothUUID.blueBite.rawValue, "FE83")
        XCTAssertEqual(BluetoothUUID.blueBite, .bit16(0xFE83))
        XCTAssertEqual(BluetoothUUID.blueBite, .bit16(65155))
        XCTAssertEqual(BluetoothUUID.blueBite.name, "Blue Bite")
        XCTAssertNotEqual(BluetoothUUID.blueBite, .bit32(65155))
        XCTAssertNotEqual(BluetoothUUID.blueBite, .bit32(0xFE83))

        /// RF Digital Corp
        XCTAssertEqual(BluetoothUUID.rfDigital.rawValue, "FE84")
        XCTAssertEqual(BluetoothUUID.rfDigital, .bit16(0xFE84))
        XCTAssertEqual(BluetoothUUID.rfDigital, .bit16(65156))
        XCTAssertEqual(BluetoothUUID.rfDigital.name, "RF Digital Corp")
        XCTAssertNotEqual(BluetoothUUID.rfDigital, .bit32(65156))
        XCTAssertNotEqual(BluetoothUUID.rfDigital, .bit32(0xFE84))

        /// RF Digital Corp
        XCTAssertEqual(BluetoothUUID.rfDigital2.rawValue, "FE85")
        XCTAssertEqual(BluetoothUUID.rfDigital2, .bit16(0xFE85))
        XCTAssertEqual(BluetoothUUID.rfDigital2, .bit16(65157))
        XCTAssertEqual(BluetoothUUID.rfDigital2.name, "RF Digital Corp")
        XCTAssertNotEqual(BluetoothUUID.rfDigital2, .bit32(65157))
        XCTAssertNotEqual(BluetoothUUID.rfDigital2, .bit32(0xFE85))

        /// HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司.rawValue, "FE86")
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit16(0xFE86))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit16(65158))
        XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司.name, "HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )")
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit32(65158))
        XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit32(0xFE86))

        /// Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )
        XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.rawValue, "FE87")
        XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit16(0xFE87))
        XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit16(65159))
        XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.name, "Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )")
        XCTAssertNotEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit32(65159))
        XCTAssertNotEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit32(0xFE87))

        /// SALTO SYSTEMS S.L.
        XCTAssertEqual(BluetoothUUID.saltoSystems.rawValue, "FE88")
        XCTAssertEqual(BluetoothUUID.saltoSystems, .bit16(0xFE88))
        XCTAssertEqual(BluetoothUUID.saltoSystems, .bit16(65160))
        XCTAssertEqual(BluetoothUUID.saltoSystems.name, "SALTO SYSTEMS S.L.")
        XCTAssertNotEqual(BluetoothUUID.saltoSystems, .bit32(65160))
        XCTAssertNotEqual(BluetoothUUID.saltoSystems, .bit32(0xFE88))

        /// B&O Play A/S
        XCTAssertEqual(BluetoothUUID.bOPlay2.rawValue, "FE89")
        XCTAssertEqual(BluetoothUUID.bOPlay2, .bit16(0xFE89))
        XCTAssertEqual(BluetoothUUID.bOPlay2, .bit16(65161))
        XCTAssertEqual(BluetoothUUID.bOPlay2.name, "B&O Play A/S")
        XCTAssertNotEqual(BluetoothUUID.bOPlay2, .bit32(65161))
        XCTAssertNotEqual(BluetoothUUID.bOPlay2, .bit32(0xFE89))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple3.rawValue, "FE8A")
        XCTAssertEqual(BluetoothUUID.apple3, .bit16(0xFE8A))
        XCTAssertEqual(BluetoothUUID.apple3, .bit16(65162))
        XCTAssertEqual(BluetoothUUID.apple3.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple3, .bit32(65162))
        XCTAssertNotEqual(BluetoothUUID.apple3, .bit32(0xFE8A))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple4.rawValue, "FE8B")
        XCTAssertEqual(BluetoothUUID.apple4, .bit16(0xFE8B))
        XCTAssertEqual(BluetoothUUID.apple4, .bit16(65163))
        XCTAssertEqual(BluetoothUUID.apple4.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple4, .bit32(65163))
        XCTAssertNotEqual(BluetoothUUID.apple4, .bit32(0xFE8B))

        /// TRON Forum
        XCTAssertEqual(BluetoothUUID.tronForum.rawValue, "FE8C")
        XCTAssertEqual(BluetoothUUID.tronForum, .bit16(0xFE8C))
        XCTAssertEqual(BluetoothUUID.tronForum, .bit16(65164))
        XCTAssertEqual(BluetoothUUID.tronForum.name, "TRON Forum")
        XCTAssertNotEqual(BluetoothUUID.tronForum, .bit32(65164))
        XCTAssertNotEqual(BluetoothUUID.tronForum, .bit32(0xFE8C))

        /// Interaxon Inc.
        XCTAssertEqual(BluetoothUUID.interaxon.rawValue, "FE8D")
        XCTAssertEqual(BluetoothUUID.interaxon, .bit16(0xFE8D))
        XCTAssertEqual(BluetoothUUID.interaxon, .bit16(65165))
        XCTAssertEqual(BluetoothUUID.interaxon.name, "Interaxon Inc.")
        XCTAssertNotEqual(BluetoothUUID.interaxon, .bit32(65165))
        XCTAssertNotEqual(BluetoothUUID.interaxon, .bit32(0xFE8D))

        /// ARM Ltd
        XCTAssertEqual(BluetoothUUID.arm.rawValue, "FE8E")
        XCTAssertEqual(BluetoothUUID.arm, .bit16(0xFE8E))
        XCTAssertEqual(BluetoothUUID.arm, .bit16(65166))
        XCTAssertEqual(BluetoothUUID.arm.name, "ARM Ltd")
        XCTAssertNotEqual(BluetoothUUID.arm, .bit32(65166))
        XCTAssertNotEqual(BluetoothUUID.arm, .bit32(0xFE8E))

        /// CSR
        XCTAssertEqual(BluetoothUUID.csr.rawValue, "FE8F")
        XCTAssertEqual(BluetoothUUID.csr, .bit16(0xFE8F))
        XCTAssertEqual(BluetoothUUID.csr, .bit16(65167))
        XCTAssertEqual(BluetoothUUID.csr.name, "CSR")
        XCTAssertNotEqual(BluetoothUUID.csr, .bit32(65167))
        XCTAssertNotEqual(BluetoothUUID.csr, .bit32(0xFE8F))

        /// JUMA
        XCTAssertEqual(BluetoothUUID.juma.rawValue, "FE90")
        XCTAssertEqual(BluetoothUUID.juma, .bit16(0xFE90))
        XCTAssertEqual(BluetoothUUID.juma, .bit16(65168))
        XCTAssertEqual(BluetoothUUID.juma.name, "JUMA")
        XCTAssertNotEqual(BluetoothUUID.juma, .bit32(65168))
        XCTAssertNotEqual(BluetoothUUID.juma, .bit32(0xFE90))

        /// Shanghai Imilab Technology Co.,Ltd
        XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology.rawValue, "FE91")
        XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology, .bit16(0xFE91))
        XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology, .bit16(65169))
        XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology.name, "Shanghai Imilab Technology Co.,Ltd")
        XCTAssertNotEqual(BluetoothUUID.shanghaiImilabTechnology, .bit32(65169))
        XCTAssertNotEqual(BluetoothUUID.shanghaiImilabTechnology, .bit32(0xFE91))

        /// Jarden Safety & Security
        XCTAssertEqual(BluetoothUUID.jardenSafetySecurity.rawValue, "FE92")
        XCTAssertEqual(BluetoothUUID.jardenSafetySecurity, .bit16(0xFE92))
        XCTAssertEqual(BluetoothUUID.jardenSafetySecurity, .bit16(65170))
        XCTAssertEqual(BluetoothUUID.jardenSafetySecurity.name, "Jarden Safety & Security")
        XCTAssertNotEqual(BluetoothUUID.jardenSafetySecurity, .bit32(65170))
        XCTAssertNotEqual(BluetoothUUID.jardenSafetySecurity, .bit32(0xFE92))

        /// OttoQ Inc.
        XCTAssertEqual(BluetoothUUID.ottoq.rawValue, "FE93")
        XCTAssertEqual(BluetoothUUID.ottoq, .bit16(0xFE93))
        XCTAssertEqual(BluetoothUUID.ottoq, .bit16(65171))
        XCTAssertEqual(BluetoothUUID.ottoq.name, "OttoQ Inc.")
        XCTAssertNotEqual(BluetoothUUID.ottoq, .bit32(65171))
        XCTAssertNotEqual(BluetoothUUID.ottoq, .bit32(0xFE93))

        /// OttoQ Inc.
        XCTAssertEqual(BluetoothUUID.ottoq2.rawValue, "FE94")
        XCTAssertEqual(BluetoothUUID.ottoq2, .bit16(0xFE94))
        XCTAssertEqual(BluetoothUUID.ottoq2, .bit16(65172))
        XCTAssertEqual(BluetoothUUID.ottoq2.name, "OttoQ Inc.")
        XCTAssertNotEqual(BluetoothUUID.ottoq2, .bit32(65172))
        XCTAssertNotEqual(BluetoothUUID.ottoq2, .bit32(0xFE94))

        /// Xiaomi Inc.
        XCTAssertEqual(BluetoothUUID.xiaomi.rawValue, "FE95")
        XCTAssertEqual(BluetoothUUID.xiaomi, .bit16(0xFE95))
        XCTAssertEqual(BluetoothUUID.xiaomi, .bit16(65173))
        XCTAssertEqual(BluetoothUUID.xiaomi.name, "Xiaomi Inc.")
        XCTAssertNotEqual(BluetoothUUID.xiaomi, .bit32(65173))
        XCTAssertNotEqual(BluetoothUUID.xiaomi, .bit32(0xFE95))

        /// Tesla Motor Inc.
        XCTAssertEqual(BluetoothUUID.teslaMotor.rawValue, "FE96")
        XCTAssertEqual(BluetoothUUID.teslaMotor, .bit16(0xFE96))
        XCTAssertEqual(BluetoothUUID.teslaMotor, .bit16(65174))
        XCTAssertEqual(BluetoothUUID.teslaMotor.name, "Tesla Motor Inc.")
        XCTAssertNotEqual(BluetoothUUID.teslaMotor, .bit32(65174))
        XCTAssertNotEqual(BluetoothUUID.teslaMotor, .bit32(0xFE96))

        /// Tesla Motor Inc.
        XCTAssertEqual(BluetoothUUID.teslaMotor2.rawValue, "FE97")
        XCTAssertEqual(BluetoothUUID.teslaMotor2, .bit16(0xFE97))
        XCTAssertEqual(BluetoothUUID.teslaMotor2, .bit16(65175))
        XCTAssertEqual(BluetoothUUID.teslaMotor2.name, "Tesla Motor Inc.")
        XCTAssertNotEqual(BluetoothUUID.teslaMotor2, .bit32(65175))
        XCTAssertNotEqual(BluetoothUUID.teslaMotor2, .bit32(0xFE97))

        /// Currant, Inc.
        XCTAssertEqual(BluetoothUUID.currant.rawValue, "FE98")
        XCTAssertEqual(BluetoothUUID.currant, .bit16(0xFE98))
        XCTAssertEqual(BluetoothUUID.currant, .bit16(65176))
        XCTAssertEqual(BluetoothUUID.currant.name, "Currant, Inc.")
        XCTAssertNotEqual(BluetoothUUID.currant, .bit32(65176))
        XCTAssertNotEqual(BluetoothUUID.currant, .bit32(0xFE98))

        /// Currant, Inc.
        XCTAssertEqual(BluetoothUUID.currant2.rawValue, "FE99")
        XCTAssertEqual(BluetoothUUID.currant2, .bit16(0xFE99))
        XCTAssertEqual(BluetoothUUID.currant2, .bit16(65177))
        XCTAssertEqual(BluetoothUUID.currant2.name, "Currant, Inc.")
        XCTAssertNotEqual(BluetoothUUID.currant2, .bit32(65177))
        XCTAssertNotEqual(BluetoothUUID.currant2, .bit32(0xFE99))

        /// Estimote
        XCTAssertEqual(BluetoothUUID.estimote.rawValue, "FE9A")
        XCTAssertEqual(BluetoothUUID.estimote, .bit16(0xFE9A))
        XCTAssertEqual(BluetoothUUID.estimote, .bit16(65178))
        XCTAssertEqual(BluetoothUUID.estimote.name, "Estimote")
        XCTAssertNotEqual(BluetoothUUID.estimote, .bit32(65178))
        XCTAssertNotEqual(BluetoothUUID.estimote, .bit32(0xFE9A))

        /// Samsara Networks, Inc
        XCTAssertEqual(BluetoothUUID.samsaraNetworks.rawValue, "FE9B")
        XCTAssertEqual(BluetoothUUID.samsaraNetworks, .bit16(0xFE9B))
        XCTAssertEqual(BluetoothUUID.samsaraNetworks, .bit16(65179))
        XCTAssertEqual(BluetoothUUID.samsaraNetworks.name, "Samsara Networks, Inc")
        XCTAssertNotEqual(BluetoothUUID.samsaraNetworks, .bit32(65179))
        XCTAssertNotEqual(BluetoothUUID.samsaraNetworks, .bit32(0xFE9B))

        /// GSI Laboratories, Inc.
        XCTAssertEqual(BluetoothUUID.gsiLaboratories.rawValue, "FE9C")
        XCTAssertEqual(BluetoothUUID.gsiLaboratories, .bit16(0xFE9C))
        XCTAssertEqual(BluetoothUUID.gsiLaboratories, .bit16(65180))
        XCTAssertEqual(BluetoothUUID.gsiLaboratories.name, "GSI Laboratories, Inc.")
        XCTAssertNotEqual(BluetoothUUID.gsiLaboratories, .bit32(65180))
        XCTAssertNotEqual(BluetoothUUID.gsiLaboratories, .bit32(0xFE9C))

        /// Mobiquity Networks Inc
        XCTAssertEqual(BluetoothUUID.mobiquityNetworks.rawValue, "FE9D")
        XCTAssertEqual(BluetoothUUID.mobiquityNetworks, .bit16(0xFE9D))
        XCTAssertEqual(BluetoothUUID.mobiquityNetworks, .bit16(65181))
        XCTAssertEqual(BluetoothUUID.mobiquityNetworks.name, "Mobiquity Networks Inc")
        XCTAssertNotEqual(BluetoothUUID.mobiquityNetworks, .bit32(65181))
        XCTAssertNotEqual(BluetoothUUID.mobiquityNetworks, .bit32(0xFE9D))

        /// Dialog Semiconductor B.V.
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor.rawValue, "FE9E")
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor, .bit16(0xFE9E))
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor, .bit16(65182))
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor.name, "Dialog Semiconductor B.V.")
        XCTAssertNotEqual(BluetoothUUID.dialogSemiconductor, .bit32(65182))
        XCTAssertNotEqual(BluetoothUUID.dialogSemiconductor, .bit32(0xFE9E))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google9.rawValue, "FE9F")
        XCTAssertEqual(BluetoothUUID.google9, .bit16(0xFE9F))
        XCTAssertEqual(BluetoothUUID.google9, .bit16(65183))
        XCTAssertEqual(BluetoothUUID.google9.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google9, .bit32(65183))
        XCTAssertNotEqual(BluetoothUUID.google9, .bit32(0xFE9F))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google10.rawValue, "FEA0")
        XCTAssertEqual(BluetoothUUID.google10, .bit16(0xFEA0))
        XCTAssertEqual(BluetoothUUID.google10, .bit16(65184))
        XCTAssertEqual(BluetoothUUID.google10.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google10, .bit32(65184))
        XCTAssertNotEqual(BluetoothUUID.google10, .bit32(0xFEA0))

        /// Intrepid Control Systems, Inc.
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems.rawValue, "FEA1")
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems, .bit16(0xFEA1))
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems, .bit16(65185))
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems.name, "Intrepid Control Systems, Inc.")
        XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems, .bit32(65185))
        XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems, .bit32(0xFEA1))

        /// Intrepid Control Systems, Inc.
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems2.rawValue, "FEA2")
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems2, .bit16(0xFEA2))
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems2, .bit16(65186))
        XCTAssertEqual(BluetoothUUID.intrepidControlSystems2.name, "Intrepid Control Systems, Inc.")
        XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems2, .bit32(65186))
        XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems2, .bit32(0xFEA2))

        /// ITT Industries
        XCTAssertEqual(BluetoothUUID.ittIndustries2.rawValue, "FEA3")
        XCTAssertEqual(BluetoothUUID.ittIndustries2, .bit16(0xFEA3))
        XCTAssertEqual(BluetoothUUID.ittIndustries2, .bit16(65187))
        XCTAssertEqual(BluetoothUUID.ittIndustries2.name, "ITT Industries")
        XCTAssertNotEqual(BluetoothUUID.ittIndustries2, .bit32(65187))
        XCTAssertNotEqual(BluetoothUUID.ittIndustries2, .bit32(0xFEA3))

        /// Paxton Access Ltd
        XCTAssertEqual(BluetoothUUID.paxtonAccess.rawValue, "FEA4")
        XCTAssertEqual(BluetoothUUID.paxtonAccess, .bit16(0xFEA4))
        XCTAssertEqual(BluetoothUUID.paxtonAccess, .bit16(65188))
        XCTAssertEqual(BluetoothUUID.paxtonAccess.name, "Paxton Access Ltd")
        XCTAssertNotEqual(BluetoothUUID.paxtonAccess, .bit32(65188))
        XCTAssertNotEqual(BluetoothUUID.paxtonAccess, .bit32(0xFEA4))

        /// GoPro, Inc.
        XCTAssertEqual(BluetoothUUID.gopro.rawValue, "FEA5")
        XCTAssertEqual(BluetoothUUID.gopro, .bit16(0xFEA5))
        XCTAssertEqual(BluetoothUUID.gopro, .bit16(65189))
        XCTAssertEqual(BluetoothUUID.gopro.name, "GoPro, Inc.")
        XCTAssertNotEqual(BluetoothUUID.gopro, .bit32(65189))
        XCTAssertNotEqual(BluetoothUUID.gopro, .bit32(0xFEA5))

        /// GoPro, Inc.
        XCTAssertEqual(BluetoothUUID.gopro2.rawValue, "FEA6")
        XCTAssertEqual(BluetoothUUID.gopro2, .bit16(0xFEA6))
        XCTAssertEqual(BluetoothUUID.gopro2, .bit16(65190))
        XCTAssertEqual(BluetoothUUID.gopro2.name, "GoPro, Inc.")
        XCTAssertNotEqual(BluetoothUUID.gopro2, .bit32(65190))
        XCTAssertNotEqual(BluetoothUUID.gopro2, .bit32(0xFEA6))

        /// UTC Fire and Security
        XCTAssertEqual(BluetoothUUID.utcFireAndSecurity.rawValue, "FEA7")
        XCTAssertEqual(BluetoothUUID.utcFireAndSecurity, .bit16(0xFEA7))
        XCTAssertEqual(BluetoothUUID.utcFireAndSecurity, .bit16(65191))
        XCTAssertEqual(BluetoothUUID.utcFireAndSecurity.name, "UTC Fire and Security")
        XCTAssertNotEqual(BluetoothUUID.utcFireAndSecurity, .bit32(65191))
        XCTAssertNotEqual(BluetoothUUID.utcFireAndSecurity, .bit32(0xFEA7))

        /// Savant Systems LLC
        XCTAssertEqual(BluetoothUUID.savantSystems.rawValue, "FEA8")
        XCTAssertEqual(BluetoothUUID.savantSystems, .bit16(0xFEA8))
        XCTAssertEqual(BluetoothUUID.savantSystems, .bit16(65192))
        XCTAssertEqual(BluetoothUUID.savantSystems.name, "Savant Systems LLC")
        XCTAssertNotEqual(BluetoothUUID.savantSystems, .bit32(65192))
        XCTAssertNotEqual(BluetoothUUID.savantSystems, .bit32(0xFEA8))

        /// Savant Systems LLC
        XCTAssertEqual(BluetoothUUID.savantSystems2.rawValue, "FEA9")
        XCTAssertEqual(BluetoothUUID.savantSystems2, .bit16(0xFEA9))
        XCTAssertEqual(BluetoothUUID.savantSystems2, .bit16(65193))
        XCTAssertEqual(BluetoothUUID.savantSystems2.name, "Savant Systems LLC")
        XCTAssertNotEqual(BluetoothUUID.savantSystems2, .bit32(65193))
        XCTAssertNotEqual(BluetoothUUID.savantSystems2, .bit32(0xFEA9))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google11.rawValue, "FEAA")
        XCTAssertEqual(BluetoothUUID.google11, .bit16(0xFEAA))
        XCTAssertEqual(BluetoothUUID.google11, .bit16(65194))
        XCTAssertEqual(BluetoothUUID.google11.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google11, .bit32(65194))
        XCTAssertNotEqual(BluetoothUUID.google11, .bit32(0xFEAA))

        /// Nokia Corporation
        XCTAssertEqual(BluetoothUUID.nokia.rawValue, "FEAB")
        XCTAssertEqual(BluetoothUUID.nokia, .bit16(0xFEAB))
        XCTAssertEqual(BluetoothUUID.nokia, .bit16(65195))
        XCTAssertEqual(BluetoothUUID.nokia.name, "Nokia Corporation")
        XCTAssertNotEqual(BluetoothUUID.nokia, .bit32(65195))
        XCTAssertNotEqual(BluetoothUUID.nokia, .bit32(0xFEAB))

        /// Nokia Corporation
        XCTAssertEqual(BluetoothUUID.nokia2.rawValue, "FEAC")
        XCTAssertEqual(BluetoothUUID.nokia2, .bit16(0xFEAC))
        XCTAssertEqual(BluetoothUUID.nokia2, .bit16(65196))
        XCTAssertEqual(BluetoothUUID.nokia2.name, "Nokia Corporation")
        XCTAssertNotEqual(BluetoothUUID.nokia2, .bit32(65196))
        XCTAssertNotEqual(BluetoothUUID.nokia2, .bit32(0xFEAC))

        /// Nokia Corporation
        XCTAssertEqual(BluetoothUUID.nokia3.rawValue, "FEAD")
        XCTAssertEqual(BluetoothUUID.nokia3, .bit16(0xFEAD))
        XCTAssertEqual(BluetoothUUID.nokia3, .bit16(65197))
        XCTAssertEqual(BluetoothUUID.nokia3.name, "Nokia Corporation")
        XCTAssertNotEqual(BluetoothUUID.nokia3, .bit32(65197))
        XCTAssertNotEqual(BluetoothUUID.nokia3, .bit32(0xFEAD))

        /// Nokia Corporation
        XCTAssertEqual(BluetoothUUID.nokia4.rawValue, "FEAE")
        XCTAssertEqual(BluetoothUUID.nokia4, .bit16(0xFEAE))
        XCTAssertEqual(BluetoothUUID.nokia4, .bit16(65198))
        XCTAssertEqual(BluetoothUUID.nokia4.name, "Nokia Corporation")
        XCTAssertNotEqual(BluetoothUUID.nokia4, .bit32(65198))
        XCTAssertNotEqual(BluetoothUUID.nokia4, .bit32(0xFEAE))

        /// Nest Labs Inc.
        XCTAssertEqual(BluetoothUUID.nestLabs.rawValue, "FEAF")
        XCTAssertEqual(BluetoothUUID.nestLabs, .bit16(0xFEAF))
        XCTAssertEqual(BluetoothUUID.nestLabs, .bit16(65199))
        XCTAssertEqual(BluetoothUUID.nestLabs.name, "Nest Labs Inc.")
        XCTAssertNotEqual(BluetoothUUID.nestLabs, .bit32(65199))
        XCTAssertNotEqual(BluetoothUUID.nestLabs, .bit32(0xFEAF))

        /// Nest Labs Inc.
        XCTAssertEqual(BluetoothUUID.nestLabs2.rawValue, "FEB0")
        XCTAssertEqual(BluetoothUUID.nestLabs2, .bit16(0xFEB0))
        XCTAssertEqual(BluetoothUUID.nestLabs2, .bit16(65200))
        XCTAssertEqual(BluetoothUUID.nestLabs2.name, "Nest Labs Inc.")
        XCTAssertNotEqual(BluetoothUUID.nestLabs2, .bit32(65200))
        XCTAssertNotEqual(BluetoothUUID.nestLabs2, .bit32(0xFEB0))

        /// Electronics Tomorrow Limited
        XCTAssertEqual(BluetoothUUID.electronicsTomorrow.rawValue, "FEB1")
        XCTAssertEqual(BluetoothUUID.electronicsTomorrow, .bit16(0xFEB1))
        XCTAssertEqual(BluetoothUUID.electronicsTomorrow, .bit16(65201))
        XCTAssertEqual(BluetoothUUID.electronicsTomorrow.name, "Electronics Tomorrow Limited")
        XCTAssertNotEqual(BluetoothUUID.electronicsTomorrow, .bit32(65201))
        XCTAssertNotEqual(BluetoothUUID.electronicsTomorrow, .bit32(0xFEB1))

        /// Microsoft Corporation
        XCTAssertEqual(BluetoothUUID.microsoft2.rawValue, "FEB2")
        XCTAssertEqual(BluetoothUUID.microsoft2, .bit16(0xFEB2))
        XCTAssertEqual(BluetoothUUID.microsoft2, .bit16(65202))
        XCTAssertEqual(BluetoothUUID.microsoft2.name, "Microsoft Corporation")
        XCTAssertNotEqual(BluetoothUUID.microsoft2, .bit32(65202))
        XCTAssertNotEqual(BluetoothUUID.microsoft2, .bit32(0xFEB2))

        /// Taobao
        XCTAssertEqual(BluetoothUUID.taobao.rawValue, "FEB3")
        XCTAssertEqual(BluetoothUUID.taobao, .bit16(0xFEB3))
        XCTAssertEqual(BluetoothUUID.taobao, .bit16(65203))
        XCTAssertEqual(BluetoothUUID.taobao.name, "Taobao")
        XCTAssertNotEqual(BluetoothUUID.taobao, .bit32(65203))
        XCTAssertNotEqual(BluetoothUUID.taobao, .bit32(0xFEB3))

        /// WiSilica Inc.
        XCTAssertEqual(BluetoothUUID.wisilica.rawValue, "FEB4")
        XCTAssertEqual(BluetoothUUID.wisilica, .bit16(0xFEB4))
        XCTAssertEqual(BluetoothUUID.wisilica, .bit16(65204))
        XCTAssertEqual(BluetoothUUID.wisilica.name, "WiSilica Inc.")
        XCTAssertNotEqual(BluetoothUUID.wisilica, .bit32(65204))
        XCTAssertNotEqual(BluetoothUUID.wisilica, .bit32(0xFEB4))

        /// WiSilica Inc.
        XCTAssertEqual(BluetoothUUID.wisilica2.rawValue, "FEB5")
        XCTAssertEqual(BluetoothUUID.wisilica2, .bit16(0xFEB5))
        XCTAssertEqual(BluetoothUUID.wisilica2, .bit16(65205))
        XCTAssertEqual(BluetoothUUID.wisilica2.name, "WiSilica Inc.")
        XCTAssertNotEqual(BluetoothUUID.wisilica2, .bit32(65205))
        XCTAssertNotEqual(BluetoothUUID.wisilica2, .bit32(0xFEB5))

        /// Vencer Co, Ltd
        XCTAssertEqual(BluetoothUUID.vencerCo.rawValue, "FEB6")
        XCTAssertEqual(BluetoothUUID.vencerCo, .bit16(0xFEB6))
        XCTAssertEqual(BluetoothUUID.vencerCo, .bit16(65206))
        XCTAssertEqual(BluetoothUUID.vencerCo.name, "Vencer Co, Ltd")
        XCTAssertNotEqual(BluetoothUUID.vencerCo, .bit32(65206))
        XCTAssertNotEqual(BluetoothUUID.vencerCo, .bit32(0xFEB6))

        /// Facebook, Inc.
        XCTAssertEqual(BluetoothUUID.facebook.rawValue, "FEB7")
        XCTAssertEqual(BluetoothUUID.facebook, .bit16(0xFEB7))
        XCTAssertEqual(BluetoothUUID.facebook, .bit16(65207))
        XCTAssertEqual(BluetoothUUID.facebook.name, "Facebook, Inc.")
        XCTAssertNotEqual(BluetoothUUID.facebook, .bit32(65207))
        XCTAssertNotEqual(BluetoothUUID.facebook, .bit32(0xFEB7))

        /// Facebook, Inc.
        XCTAssertEqual(BluetoothUUID.facebook2.rawValue, "FEB8")
        XCTAssertEqual(BluetoothUUID.facebook2, .bit16(0xFEB8))
        XCTAssertEqual(BluetoothUUID.facebook2, .bit16(65208))
        XCTAssertEqual(BluetoothUUID.facebook2.name, "Facebook, Inc.")
        XCTAssertNotEqual(BluetoothUUID.facebook2, .bit32(65208))
        XCTAssertNotEqual(BluetoothUUID.facebook2, .bit32(0xFEB8))

        /// LG Electronics
        XCTAssertEqual(BluetoothUUID.lgElectronics.rawValue, "FEB9")
        XCTAssertEqual(BluetoothUUID.lgElectronics, .bit16(0xFEB9))
        XCTAssertEqual(BluetoothUUID.lgElectronics, .bit16(65209))
        XCTAssertEqual(BluetoothUUID.lgElectronics.name, "LG Electronics")
        XCTAssertNotEqual(BluetoothUUID.lgElectronics, .bit32(65209))
        XCTAssertNotEqual(BluetoothUUID.lgElectronics, .bit32(0xFEB9))

        /// Tencent Holdings Limited
        XCTAssertEqual(BluetoothUUID.tencentHoldings.rawValue, "FEBA")
        XCTAssertEqual(BluetoothUUID.tencentHoldings, .bit16(0xFEBA))
        XCTAssertEqual(BluetoothUUID.tencentHoldings, .bit16(65210))
        XCTAssertEqual(BluetoothUUID.tencentHoldings.name, "Tencent Holdings Limited")
        XCTAssertNotEqual(BluetoothUUID.tencentHoldings, .bit32(65210))
        XCTAssertNotEqual(BluetoothUUID.tencentHoldings, .bit32(0xFEBA))

        /// adafruit industries
        XCTAssertEqual(BluetoothUUID.adafruitIndustries.rawValue, "FEBB")
        XCTAssertEqual(BluetoothUUID.adafruitIndustries, .bit16(0xFEBB))
        XCTAssertEqual(BluetoothUUID.adafruitIndustries, .bit16(65211))
        XCTAssertEqual(BluetoothUUID.adafruitIndustries.name, "adafruit industries")
        XCTAssertNotEqual(BluetoothUUID.adafruitIndustries, .bit32(65211))
        XCTAssertNotEqual(BluetoothUUID.adafruitIndustries, .bit32(0xFEBB))

        /// Dexcom, Inc.
        XCTAssertEqual(BluetoothUUID.dexcom.rawValue, "FEBC")
        XCTAssertEqual(BluetoothUUID.dexcom, .bit16(0xFEBC))
        XCTAssertEqual(BluetoothUUID.dexcom, .bit16(65212))
        XCTAssertEqual(BluetoothUUID.dexcom.name, "Dexcom, Inc.")
        XCTAssertNotEqual(BluetoothUUID.dexcom, .bit32(65212))
        XCTAssertNotEqual(BluetoothUUID.dexcom, .bit32(0xFEBC))

        /// Clover Network, Inc.
        XCTAssertEqual(BluetoothUUID.cloverNetwork.rawValue, "FEBD")
        XCTAssertEqual(BluetoothUUID.cloverNetwork, .bit16(0xFEBD))
        XCTAssertEqual(BluetoothUUID.cloverNetwork, .bit16(65213))
        XCTAssertEqual(BluetoothUUID.cloverNetwork.name, "Clover Network, Inc.")
        XCTAssertNotEqual(BluetoothUUID.cloverNetwork, .bit32(65213))
        XCTAssertNotEqual(BluetoothUUID.cloverNetwork, .bit32(0xFEBD))

        /// Bose Corporation
        XCTAssertEqual(BluetoothUUID.bose2.rawValue, "FEBE")
        XCTAssertEqual(BluetoothUUID.bose2, .bit16(0xFEBE))
        XCTAssertEqual(BluetoothUUID.bose2, .bit16(65214))
        XCTAssertEqual(BluetoothUUID.bose2.name, "Bose Corporation")
        XCTAssertNotEqual(BluetoothUUID.bose2, .bit32(65214))
        XCTAssertNotEqual(BluetoothUUID.bose2, .bit32(0xFEBE))

        /// Nod, Inc.
        XCTAssertEqual(BluetoothUUID.nod.rawValue, "FEBF")
        XCTAssertEqual(BluetoothUUID.nod, .bit16(0xFEBF))
        XCTAssertEqual(BluetoothUUID.nod, .bit16(65215))
        XCTAssertEqual(BluetoothUUID.nod.name, "Nod, Inc.")
        XCTAssertNotEqual(BluetoothUUID.nod, .bit32(65215))
        XCTAssertNotEqual(BluetoothUUID.nod, .bit32(0xFEBF))

        /// KDDI Corporation
        XCTAssertEqual(BluetoothUUID.kddi.rawValue, "FEC0")
        XCTAssertEqual(BluetoothUUID.kddi, .bit16(0xFEC0))
        XCTAssertEqual(BluetoothUUID.kddi, .bit16(65216))
        XCTAssertEqual(BluetoothUUID.kddi.name, "KDDI Corporation")
        XCTAssertNotEqual(BluetoothUUID.kddi, .bit32(65216))
        XCTAssertNotEqual(BluetoothUUID.kddi, .bit32(0xFEC0))

        /// KDDI Corporation
        XCTAssertEqual(BluetoothUUID.kddi2.rawValue, "FEC1")
        XCTAssertEqual(BluetoothUUID.kddi2, .bit16(0xFEC1))
        XCTAssertEqual(BluetoothUUID.kddi2, .bit16(65217))
        XCTAssertEqual(BluetoothUUID.kddi2.name, "KDDI Corporation")
        XCTAssertNotEqual(BluetoothUUID.kddi2, .bit32(65217))
        XCTAssertNotEqual(BluetoothUUID.kddi2, .bit32(0xFEC1))

        /// Blue Spark Technologies, Inc.
        XCTAssertEqual(BluetoothUUID.blueSparkTechnologies.rawValue, "FEC2")
        XCTAssertEqual(BluetoothUUID.blueSparkTechnologies, .bit16(0xFEC2))
        XCTAssertEqual(BluetoothUUID.blueSparkTechnologies, .bit16(65218))
        XCTAssertEqual(BluetoothUUID.blueSparkTechnologies.name, "Blue Spark Technologies, Inc.")
        XCTAssertNotEqual(BluetoothUUID.blueSparkTechnologies, .bit32(65218))
        XCTAssertNotEqual(BluetoothUUID.blueSparkTechnologies, .bit32(0xFEC2))

        /// 360fly, Inc.
        XCTAssertEqual(BluetoothUUID.uuid360Fly.rawValue, "FEC3")
        XCTAssertEqual(BluetoothUUID.uuid360Fly, .bit16(0xFEC3))
        XCTAssertEqual(BluetoothUUID.uuid360Fly, .bit16(65219))
        XCTAssertEqual(BluetoothUUID.uuid360Fly.name, "360fly, Inc.")
        XCTAssertNotEqual(BluetoothUUID.uuid360Fly, .bit32(65219))
        XCTAssertNotEqual(BluetoothUUID.uuid360Fly, .bit32(0xFEC3))

        /// PLUS Location Systems
        XCTAssertEqual(BluetoothUUID.plusLocationSystems.rawValue, "FEC4")
        XCTAssertEqual(BluetoothUUID.plusLocationSystems, .bit16(0xFEC4))
        XCTAssertEqual(BluetoothUUID.plusLocationSystems, .bit16(65220))
        XCTAssertEqual(BluetoothUUID.plusLocationSystems.name, "PLUS Location Systems")
        XCTAssertNotEqual(BluetoothUUID.plusLocationSystems, .bit32(65220))
        XCTAssertNotEqual(BluetoothUUID.plusLocationSystems, .bit32(0xFEC4))

        /// Realtek Semiconductor Corp.
        XCTAssertEqual(BluetoothUUID.realtekSemiconductor.rawValue, "FEC5")
        XCTAssertEqual(BluetoothUUID.realtekSemiconductor, .bit16(0xFEC5))
        XCTAssertEqual(BluetoothUUID.realtekSemiconductor, .bit16(65221))
        XCTAssertEqual(BluetoothUUID.realtekSemiconductor.name, "Realtek Semiconductor Corp.")
        XCTAssertNotEqual(BluetoothUUID.realtekSemiconductor, .bit32(65221))
        XCTAssertNotEqual(BluetoothUUID.realtekSemiconductor, .bit32(0xFEC5))

        /// Kocomojo, LLC
        XCTAssertEqual(BluetoothUUID.kocomojo.rawValue, "FEC6")
        XCTAssertEqual(BluetoothUUID.kocomojo, .bit16(0xFEC6))
        XCTAssertEqual(BluetoothUUID.kocomojo, .bit16(65222))
        XCTAssertEqual(BluetoothUUID.kocomojo.name, "Kocomojo, LLC")
        XCTAssertNotEqual(BluetoothUUID.kocomojo, .bit32(65222))
        XCTAssertNotEqual(BluetoothUUID.kocomojo, .bit32(0xFEC6))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple5.rawValue, "FEC7")
        XCTAssertEqual(BluetoothUUID.apple5, .bit16(0xFEC7))
        XCTAssertEqual(BluetoothUUID.apple5, .bit16(65223))
        XCTAssertEqual(BluetoothUUID.apple5.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple5, .bit32(65223))
        XCTAssertNotEqual(BluetoothUUID.apple5, .bit32(0xFEC7))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple6.rawValue, "FEC8")
        XCTAssertEqual(BluetoothUUID.apple6, .bit16(0xFEC8))
        XCTAssertEqual(BluetoothUUID.apple6, .bit16(65224))
        XCTAssertEqual(BluetoothUUID.apple6.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple6, .bit32(65224))
        XCTAssertNotEqual(BluetoothUUID.apple6, .bit32(0xFEC8))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple7.rawValue, "FEC9")
        XCTAssertEqual(BluetoothUUID.apple7, .bit16(0xFEC9))
        XCTAssertEqual(BluetoothUUID.apple7, .bit16(65225))
        XCTAssertEqual(BluetoothUUID.apple7.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple7, .bit32(65225))
        XCTAssertNotEqual(BluetoothUUID.apple7, .bit32(0xFEC9))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple8.rawValue, "FECA")
        XCTAssertEqual(BluetoothUUID.apple8, .bit16(0xFECA))
        XCTAssertEqual(BluetoothUUID.apple8, .bit16(65226))
        XCTAssertEqual(BluetoothUUID.apple8.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple8, .bit32(65226))
        XCTAssertNotEqual(BluetoothUUID.apple8, .bit32(0xFECA))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple9.rawValue, "FECB")
        XCTAssertEqual(BluetoothUUID.apple9, .bit16(0xFECB))
        XCTAssertEqual(BluetoothUUID.apple9, .bit16(65227))
        XCTAssertEqual(BluetoothUUID.apple9.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple9, .bit32(65227))
        XCTAssertNotEqual(BluetoothUUID.apple9, .bit32(0xFECB))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple10.rawValue, "FECC")
        XCTAssertEqual(BluetoothUUID.apple10, .bit16(0xFECC))
        XCTAssertEqual(BluetoothUUID.apple10, .bit16(65228))
        XCTAssertEqual(BluetoothUUID.apple10.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple10, .bit32(65228))
        XCTAssertNotEqual(BluetoothUUID.apple10, .bit32(0xFECC))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple11.rawValue, "FECD")
        XCTAssertEqual(BluetoothUUID.apple11, .bit16(0xFECD))
        XCTAssertEqual(BluetoothUUID.apple11, .bit16(65229))
        XCTAssertEqual(BluetoothUUID.apple11.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple11, .bit32(65229))
        XCTAssertNotEqual(BluetoothUUID.apple11, .bit32(0xFECD))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple12.rawValue, "FECE")
        XCTAssertEqual(BluetoothUUID.apple12, .bit16(0xFECE))
        XCTAssertEqual(BluetoothUUID.apple12, .bit16(65230))
        XCTAssertEqual(BluetoothUUID.apple12.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple12, .bit32(65230))
        XCTAssertNotEqual(BluetoothUUID.apple12, .bit32(0xFECE))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple13.rawValue, "FECF")
        XCTAssertEqual(BluetoothUUID.apple13, .bit16(0xFECF))
        XCTAssertEqual(BluetoothUUID.apple13, .bit16(65231))
        XCTAssertEqual(BluetoothUUID.apple13.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple13, .bit32(65231))
        XCTAssertNotEqual(BluetoothUUID.apple13, .bit32(0xFECF))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple14.rawValue, "FED0")
        XCTAssertEqual(BluetoothUUID.apple14, .bit16(0xFED0))
        XCTAssertEqual(BluetoothUUID.apple14, .bit16(65232))
        XCTAssertEqual(BluetoothUUID.apple14.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple14, .bit32(65232))
        XCTAssertNotEqual(BluetoothUUID.apple14, .bit32(0xFED0))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple15.rawValue, "FED1")
        XCTAssertEqual(BluetoothUUID.apple15, .bit16(0xFED1))
        XCTAssertEqual(BluetoothUUID.apple15, .bit16(65233))
        XCTAssertEqual(BluetoothUUID.apple15.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple15, .bit32(65233))
        XCTAssertNotEqual(BluetoothUUID.apple15, .bit32(0xFED1))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple16.rawValue, "FED2")
        XCTAssertEqual(BluetoothUUID.apple16, .bit16(0xFED2))
        XCTAssertEqual(BluetoothUUID.apple16, .bit16(65234))
        XCTAssertEqual(BluetoothUUID.apple16.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple16, .bit32(65234))
        XCTAssertNotEqual(BluetoothUUID.apple16, .bit32(0xFED2))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple17.rawValue, "FED3")
        XCTAssertEqual(BluetoothUUID.apple17, .bit16(0xFED3))
        XCTAssertEqual(BluetoothUUID.apple17, .bit16(65235))
        XCTAssertEqual(BluetoothUUID.apple17.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple17, .bit32(65235))
        XCTAssertNotEqual(BluetoothUUID.apple17, .bit32(0xFED3))

        /// Apple, Inc.
        XCTAssertEqual(BluetoothUUID.apple18.rawValue, "FED4")
        XCTAssertEqual(BluetoothUUID.apple18, .bit16(0xFED4))
        XCTAssertEqual(BluetoothUUID.apple18, .bit16(65236))
        XCTAssertEqual(BluetoothUUID.apple18.name, "Apple, Inc.")
        XCTAssertNotEqual(BluetoothUUID.apple18, .bit32(65236))
        XCTAssertNotEqual(BluetoothUUID.apple18, .bit32(0xFED4))

        /// Plantronics Inc.
        XCTAssertEqual(BluetoothUUID.plantronics.rawValue, "FED5")
        XCTAssertEqual(BluetoothUUID.plantronics, .bit16(0xFED5))
        XCTAssertEqual(BluetoothUUID.plantronics, .bit16(65237))
        XCTAssertEqual(BluetoothUUID.plantronics.name, "Plantronics Inc.")
        XCTAssertNotEqual(BluetoothUUID.plantronics, .bit32(65237))
        XCTAssertNotEqual(BluetoothUUID.plantronics, .bit32(0xFED5))

        /// Broadcom Corporation
        XCTAssertEqual(BluetoothUUID.broadcom.rawValue, "FED6")
        XCTAssertEqual(BluetoothUUID.broadcom, .bit16(0xFED6))
        XCTAssertEqual(BluetoothUUID.broadcom, .bit16(65238))
        XCTAssertEqual(BluetoothUUID.broadcom.name, "Broadcom Corporation")
        XCTAssertNotEqual(BluetoothUUID.broadcom, .bit32(65238))
        XCTAssertNotEqual(BluetoothUUID.broadcom, .bit32(0xFED6))

        /// Broadcom Corporation
        XCTAssertEqual(BluetoothUUID.broadcom2.rawValue, "FED7")
        XCTAssertEqual(BluetoothUUID.broadcom2, .bit16(0xFED7))
        XCTAssertEqual(BluetoothUUID.broadcom2, .bit16(65239))
        XCTAssertEqual(BluetoothUUID.broadcom2.name, "Broadcom Corporation")
        XCTAssertNotEqual(BluetoothUUID.broadcom2, .bit32(65239))
        XCTAssertNotEqual(BluetoothUUID.broadcom2, .bit32(0xFED7))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google12.rawValue, "FED8")
        XCTAssertEqual(BluetoothUUID.google12, .bit16(0xFED8))
        XCTAssertEqual(BluetoothUUID.google12, .bit16(65240))
        XCTAssertEqual(BluetoothUUID.google12.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google12, .bit32(65240))
        XCTAssertNotEqual(BluetoothUUID.google12, .bit32(0xFED8))

        /// Pebble Technology Corporation
        XCTAssertEqual(BluetoothUUID.pebbleTechnology.rawValue, "FED9")
        XCTAssertEqual(BluetoothUUID.pebbleTechnology, .bit16(0xFED9))
        XCTAssertEqual(BluetoothUUID.pebbleTechnology, .bit16(65241))
        XCTAssertEqual(BluetoothUUID.pebbleTechnology.name, "Pebble Technology Corporation")
        XCTAssertNotEqual(BluetoothUUID.pebbleTechnology, .bit32(65241))
        XCTAssertNotEqual(BluetoothUUID.pebbleTechnology, .bit32(0xFED9))

        /// ISSC Technologies Corporation
        XCTAssertEqual(BluetoothUUID.isscTechnologies.rawValue, "FEDA")
        XCTAssertEqual(BluetoothUUID.isscTechnologies, .bit16(0xFEDA))
        XCTAssertEqual(BluetoothUUID.isscTechnologies, .bit16(65242))
        XCTAssertEqual(BluetoothUUID.isscTechnologies.name, "ISSC Technologies Corporation")
        XCTAssertNotEqual(BluetoothUUID.isscTechnologies, .bit32(65242))
        XCTAssertNotEqual(BluetoothUUID.isscTechnologies, .bit32(0xFEDA))

        /// Perka, Inc.
        XCTAssertEqual(BluetoothUUID.perka.rawValue, "FEDB")
        XCTAssertEqual(BluetoothUUID.perka, .bit16(0xFEDB))
        XCTAssertEqual(BluetoothUUID.perka, .bit16(65243))
        XCTAssertEqual(BluetoothUUID.perka.name, "Perka, Inc.")
        XCTAssertNotEqual(BluetoothUUID.perka, .bit32(65243))
        XCTAssertNotEqual(BluetoothUUID.perka, .bit32(0xFEDB))

        /// Jawbone
        XCTAssertEqual(BluetoothUUID.jawbone.rawValue, "FEDC")
        XCTAssertEqual(BluetoothUUID.jawbone, .bit16(0xFEDC))
        XCTAssertEqual(BluetoothUUID.jawbone, .bit16(65244))
        XCTAssertEqual(BluetoothUUID.jawbone.name, "Jawbone")
        XCTAssertNotEqual(BluetoothUUID.jawbone, .bit32(65244))
        XCTAssertNotEqual(BluetoothUUID.jawbone, .bit32(0xFEDC))

        /// Jawbone
        XCTAssertEqual(BluetoothUUID.jawbone2.rawValue, "FEDD")
        XCTAssertEqual(BluetoothUUID.jawbone2, .bit16(0xFEDD))
        XCTAssertEqual(BluetoothUUID.jawbone2, .bit16(65245))
        XCTAssertEqual(BluetoothUUID.jawbone2.name, "Jawbone")
        XCTAssertNotEqual(BluetoothUUID.jawbone2, .bit32(65245))
        XCTAssertNotEqual(BluetoothUUID.jawbone2, .bit32(0xFEDD))

        /// Coin, Inc.
        XCTAssertEqual(BluetoothUUID.coin.rawValue, "FEDE")
        XCTAssertEqual(BluetoothUUID.coin, .bit16(0xFEDE))
        XCTAssertEqual(BluetoothUUID.coin, .bit16(65246))
        XCTAssertEqual(BluetoothUUID.coin.name, "Coin, Inc.")
        XCTAssertNotEqual(BluetoothUUID.coin, .bit32(65246))
        XCTAssertNotEqual(BluetoothUUID.coin, .bit32(0xFEDE))

        /// Design SHIFT
        XCTAssertEqual(BluetoothUUID.designShift.rawValue, "FEDF")
        XCTAssertEqual(BluetoothUUID.designShift, .bit16(0xFEDF))
        XCTAssertEqual(BluetoothUUID.designShift, .bit16(65247))
        XCTAssertEqual(BluetoothUUID.designShift.name, "Design SHIFT")
        XCTAssertNotEqual(BluetoothUUID.designShift, .bit32(65247))
        XCTAssertNotEqual(BluetoothUUID.designShift, .bit32(0xFEDF))

        /// Anhui Huami Information Technology Co.
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology.rawValue, "FEE0")
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology, .bit16(0xFEE0))
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology, .bit16(65248))
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology.name, "Anhui Huami Information Technology Co.")
        XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnology, .bit32(65248))
        XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnology, .bit32(0xFEE0))

        /// Anhui Huami Information Technology Co.
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology2.rawValue, "FEE1")
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology2, .bit16(0xFEE1))
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology2, .bit16(65249))
        XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnology2.name, "Anhui Huami Information Technology Co.")
        XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnology2, .bit32(65249))
        XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnology2, .bit32(0xFEE1))

        /// Anki, Inc.
        XCTAssertEqual(BluetoothUUID.anki.rawValue, "FEE2")
        XCTAssertEqual(BluetoothUUID.anki, .bit16(0xFEE2))
        XCTAssertEqual(BluetoothUUID.anki, .bit16(65250))
        XCTAssertEqual(BluetoothUUID.anki.name, "Anki, Inc.")
        XCTAssertNotEqual(BluetoothUUID.anki, .bit32(65250))
        XCTAssertNotEqual(BluetoothUUID.anki, .bit32(0xFEE2))

        /// Anki, Inc.
        XCTAssertEqual(BluetoothUUID.anki2.rawValue, "FEE3")
        XCTAssertEqual(BluetoothUUID.anki2, .bit16(0xFEE3))
        XCTAssertEqual(BluetoothUUID.anki2, .bit16(65251))
        XCTAssertEqual(BluetoothUUID.anki2.name, "Anki, Inc.")
        XCTAssertNotEqual(BluetoothUUID.anki2, .bit32(65251))
        XCTAssertNotEqual(BluetoothUUID.anki2, .bit32(0xFEE3))

        /// Nordic Semiconductor ASA
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor3.rawValue, "FEE4")
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor3, .bit16(0xFEE4))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor3, .bit16(65252))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor3.name, "Nordic Semiconductor ASA")
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor3, .bit32(65252))
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor3, .bit32(0xFEE4))

        /// Nordic Semiconductor ASA
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor4.rawValue, "FEE5")
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor4, .bit16(0xFEE5))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor4, .bit16(65253))
        XCTAssertEqual(BluetoothUUID.nordicSemiconductor4.name, "Nordic Semiconductor ASA")
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor4, .bit32(65253))
        XCTAssertNotEqual(BluetoothUUID.nordicSemiconductor4, .bit32(0xFEE5))

        /// Silvair, Inc.
        XCTAssertEqual(BluetoothUUID.silvair.rawValue, "FEE6")
        XCTAssertEqual(BluetoothUUID.silvair, .bit16(0xFEE6))
        XCTAssertEqual(BluetoothUUID.silvair, .bit16(65254))
        XCTAssertEqual(BluetoothUUID.silvair.name, "Silvair, Inc.")
        XCTAssertNotEqual(BluetoothUUID.silvair, .bit32(65254))
        XCTAssertNotEqual(BluetoothUUID.silvair, .bit32(0xFEE6))

        /// Tencent Holdings Limited
        XCTAssertEqual(BluetoothUUID.tencentHoldings2.rawValue, "FEE7")
        XCTAssertEqual(BluetoothUUID.tencentHoldings2, .bit16(0xFEE7))
        XCTAssertEqual(BluetoothUUID.tencentHoldings2, .bit16(65255))
        XCTAssertEqual(BluetoothUUID.tencentHoldings2.name, "Tencent Holdings Limited")
        XCTAssertNotEqual(BluetoothUUID.tencentHoldings2, .bit32(65255))
        XCTAssertNotEqual(BluetoothUUID.tencentHoldings2, .bit32(0xFEE7))

        /// Quintic Corp.
        XCTAssertEqual(BluetoothUUID.quintic.rawValue, "FEE8")
        XCTAssertEqual(BluetoothUUID.quintic, .bit16(0xFEE8))
        XCTAssertEqual(BluetoothUUID.quintic, .bit16(65256))
        XCTAssertEqual(BluetoothUUID.quintic.name, "Quintic Corp.")
        XCTAssertNotEqual(BluetoothUUID.quintic, .bit32(65256))
        XCTAssertNotEqual(BluetoothUUID.quintic, .bit32(0xFEE8))

        /// Quintic Corp.
        XCTAssertEqual(BluetoothUUID.quintic2.rawValue, "FEE9")
        XCTAssertEqual(BluetoothUUID.quintic2, .bit16(0xFEE9))
        XCTAssertEqual(BluetoothUUID.quintic2, .bit16(65257))
        XCTAssertEqual(BluetoothUUID.quintic2.name, "Quintic Corp.")
        XCTAssertNotEqual(BluetoothUUID.quintic2, .bit32(65257))
        XCTAssertNotEqual(BluetoothUUID.quintic2, .bit32(0xFEE9))

        /// Swirl Networks, Inc.
        XCTAssertEqual(BluetoothUUID.swirlNetworks.rawValue, "FEEA")
        XCTAssertEqual(BluetoothUUID.swirlNetworks, .bit16(0xFEEA))
        XCTAssertEqual(BluetoothUUID.swirlNetworks, .bit16(65258))
        XCTAssertEqual(BluetoothUUID.swirlNetworks.name, "Swirl Networks, Inc.")
        XCTAssertNotEqual(BluetoothUUID.swirlNetworks, .bit32(65258))
        XCTAssertNotEqual(BluetoothUUID.swirlNetworks, .bit32(0xFEEA))

        /// Swirl Networks, Inc.
        XCTAssertEqual(BluetoothUUID.swirlNetworks2.rawValue, "FEEB")
        XCTAssertEqual(BluetoothUUID.swirlNetworks2, .bit16(0xFEEB))
        XCTAssertEqual(BluetoothUUID.swirlNetworks2, .bit16(65259))
        XCTAssertEqual(BluetoothUUID.swirlNetworks2.name, "Swirl Networks, Inc.")
        XCTAssertNotEqual(BluetoothUUID.swirlNetworks2, .bit32(65259))
        XCTAssertNotEqual(BluetoothUUID.swirlNetworks2, .bit32(0xFEEB))

        /// Tile, Inc.
        XCTAssertEqual(BluetoothUUID.tile.rawValue, "FEEC")
        XCTAssertEqual(BluetoothUUID.tile, .bit16(0xFEEC))
        XCTAssertEqual(BluetoothUUID.tile, .bit16(65260))
        XCTAssertEqual(BluetoothUUID.tile.name, "Tile, Inc.")
        XCTAssertNotEqual(BluetoothUUID.tile, .bit32(65260))
        XCTAssertNotEqual(BluetoothUUID.tile, .bit32(0xFEEC))

        /// Tile, Inc.
        XCTAssertEqual(BluetoothUUID.tile2.rawValue, "FEED")
        XCTAssertEqual(BluetoothUUID.tile2, .bit16(0xFEED))
        XCTAssertEqual(BluetoothUUID.tile2, .bit16(65261))
        XCTAssertEqual(BluetoothUUID.tile2.name, "Tile, Inc.")
        XCTAssertNotEqual(BluetoothUUID.tile2, .bit32(65261))
        XCTAssertNotEqual(BluetoothUUID.tile2, .bit32(0xFEED))

        /// Polar Electro Oy
        XCTAssertEqual(BluetoothUUID.polarElectro.rawValue, "FEEE")
        XCTAssertEqual(BluetoothUUID.polarElectro, .bit16(0xFEEE))
        XCTAssertEqual(BluetoothUUID.polarElectro, .bit16(65262))
        XCTAssertEqual(BluetoothUUID.polarElectro.name, "Polar Electro Oy")
        XCTAssertNotEqual(BluetoothUUID.polarElectro, .bit32(65262))
        XCTAssertNotEqual(BluetoothUUID.polarElectro, .bit32(0xFEEE))

        /// Polar Electro Oy
        XCTAssertEqual(BluetoothUUID.polarElectro2.rawValue, "FEEF")
        XCTAssertEqual(BluetoothUUID.polarElectro2, .bit16(0xFEEF))
        XCTAssertEqual(BluetoothUUID.polarElectro2, .bit16(65263))
        XCTAssertEqual(BluetoothUUID.polarElectro2.name, "Polar Electro Oy")
        XCTAssertNotEqual(BluetoothUUID.polarElectro2, .bit32(65263))
        XCTAssertNotEqual(BluetoothUUID.polarElectro2, .bit32(0xFEEF))

        /// Intel
        XCTAssertEqual(BluetoothUUID.intel2.rawValue, "FEF0")
        XCTAssertEqual(BluetoothUUID.intel2, .bit16(0xFEF0))
        XCTAssertEqual(BluetoothUUID.intel2, .bit16(65264))
        XCTAssertEqual(BluetoothUUID.intel2.name, "Intel")
        XCTAssertNotEqual(BluetoothUUID.intel2, .bit32(65264))
        XCTAssertNotEqual(BluetoothUUID.intel2, .bit32(0xFEF0))

        /// CSR
        XCTAssertEqual(BluetoothUUID.csr2.rawValue, "FEF1")
        XCTAssertEqual(BluetoothUUID.csr2, .bit16(0xFEF1))
        XCTAssertEqual(BluetoothUUID.csr2, .bit16(65265))
        XCTAssertEqual(BluetoothUUID.csr2.name, "CSR")
        XCTAssertNotEqual(BluetoothUUID.csr2, .bit32(65265))
        XCTAssertNotEqual(BluetoothUUID.csr2, .bit32(0xFEF1))

        /// CSR
        XCTAssertEqual(BluetoothUUID.csr3.rawValue, "FEF2")
        XCTAssertEqual(BluetoothUUID.csr3, .bit16(0xFEF2))
        XCTAssertEqual(BluetoothUUID.csr3, .bit16(65266))
        XCTAssertEqual(BluetoothUUID.csr3.name, "CSR")
        XCTAssertNotEqual(BluetoothUUID.csr3, .bit32(65266))
        XCTAssertNotEqual(BluetoothUUID.csr3, .bit32(0xFEF2))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google13.rawValue, "FEF3")
        XCTAssertEqual(BluetoothUUID.google13, .bit16(0xFEF3))
        XCTAssertEqual(BluetoothUUID.google13, .bit16(65267))
        XCTAssertEqual(BluetoothUUID.google13.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google13, .bit32(65267))
        XCTAssertNotEqual(BluetoothUUID.google13, .bit32(0xFEF3))

        /// Google Inc.
        XCTAssertEqual(BluetoothUUID.google14.rawValue, "FEF4")
        XCTAssertEqual(BluetoothUUID.google14, .bit16(0xFEF4))
        XCTAssertEqual(BluetoothUUID.google14, .bit16(65268))
        XCTAssertEqual(BluetoothUUID.google14.name, "Google Inc.")
        XCTAssertNotEqual(BluetoothUUID.google14, .bit32(65268))
        XCTAssertNotEqual(BluetoothUUID.google14, .bit32(0xFEF4))

        /// Dialog Semiconductor GmbH
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor2.rawValue, "FEF5")
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor2, .bit16(0xFEF5))
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor2, .bit16(65269))
        XCTAssertEqual(BluetoothUUID.dialogSemiconductor2.name, "Dialog Semiconductor GmbH")
        XCTAssertNotEqual(BluetoothUUID.dialogSemiconductor2, .bit32(65269))
        XCTAssertNotEqual(BluetoothUUID.dialogSemiconductor2, .bit32(0xFEF5))

        /// Wicentric, Inc.
        XCTAssertEqual(BluetoothUUID.wicentric.rawValue, "FEF6")
        XCTAssertEqual(BluetoothUUID.wicentric, .bit16(0xFEF6))
        XCTAssertEqual(BluetoothUUID.wicentric, .bit16(65270))
        XCTAssertEqual(BluetoothUUID.wicentric.name, "Wicentric, Inc.")
        XCTAssertNotEqual(BluetoothUUID.wicentric, .bit32(65270))
        XCTAssertNotEqual(BluetoothUUID.wicentric, .bit32(0xFEF6))

        /// Aplix Corporation
        XCTAssertEqual(BluetoothUUID.aplix.rawValue, "FEF7")
        XCTAssertEqual(BluetoothUUID.aplix, .bit16(0xFEF7))
        XCTAssertEqual(BluetoothUUID.aplix, .bit16(65271))
        XCTAssertEqual(BluetoothUUID.aplix.name, "Aplix Corporation")
        XCTAssertNotEqual(BluetoothUUID.aplix, .bit32(65271))
        XCTAssertNotEqual(BluetoothUUID.aplix, .bit32(0xFEF7))

        /// Aplix Corporation
        XCTAssertEqual(BluetoothUUID.aplix2.rawValue, "FEF8")
        XCTAssertEqual(BluetoothUUID.aplix2, .bit16(0xFEF8))
        XCTAssertEqual(BluetoothUUID.aplix2, .bit16(65272))
        XCTAssertEqual(BluetoothUUID.aplix2.name, "Aplix Corporation")
        XCTAssertNotEqual(BluetoothUUID.aplix2, .bit32(65272))
        XCTAssertNotEqual(BluetoothUUID.aplix2, .bit32(0xFEF8))

        /// PayPal, Inc.
        XCTAssertEqual(BluetoothUUID.paypal.rawValue, "FEF9")
        XCTAssertEqual(BluetoothUUID.paypal, .bit16(0xFEF9))
        XCTAssertEqual(BluetoothUUID.paypal, .bit16(65273))
        XCTAssertEqual(BluetoothUUID.paypal.name, "PayPal, Inc.")
        XCTAssertNotEqual(BluetoothUUID.paypal, .bit32(65273))
        XCTAssertNotEqual(BluetoothUUID.paypal, .bit32(0xFEF9))

        /// PayPal, Inc.
        XCTAssertEqual(BluetoothUUID.paypal2.rawValue, "FEFA")
        XCTAssertEqual(BluetoothUUID.paypal2, .bit16(0xFEFA))
        XCTAssertEqual(BluetoothUUID.paypal2, .bit16(65274))
        XCTAssertEqual(BluetoothUUID.paypal2.name, "PayPal, Inc.")
        XCTAssertNotEqual(BluetoothUUID.paypal2, .bit32(65274))
        XCTAssertNotEqual(BluetoothUUID.paypal2, .bit32(0xFEFA))

        /// Telit Wireless Solutions
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions2.rawValue, "FEFB")
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions2, .bit16(0xFEFB))
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions2, .bit16(65275))
        XCTAssertEqual(BluetoothUUID.telitWirelessSolutions2.name, "Telit Wireless Solutions")
        XCTAssertNotEqual(BluetoothUUID.telitWirelessSolutions2, .bit32(65275))
        XCTAssertNotEqual(BluetoothUUID.telitWirelessSolutions2, .bit32(0xFEFB))

        /// Gimbal, Inc.
        XCTAssertEqual(BluetoothUUID.gimbal.rawValue, "FEFC")
        XCTAssertEqual(BluetoothUUID.gimbal, .bit16(0xFEFC))
        XCTAssertEqual(BluetoothUUID.gimbal, .bit16(65276))
        XCTAssertEqual(BluetoothUUID.gimbal.name, "Gimbal, Inc.")
        XCTAssertNotEqual(BluetoothUUID.gimbal, .bit32(65276))
        XCTAssertNotEqual(BluetoothUUID.gimbal, .bit32(0xFEFC))

        /// Gimbal, Inc.
        XCTAssertEqual(BluetoothUUID.gimbal2.rawValue, "FEFD")
        XCTAssertEqual(BluetoothUUID.gimbal2, .bit16(0xFEFD))
        XCTAssertEqual(BluetoothUUID.gimbal2, .bit16(65277))
        XCTAssertEqual(BluetoothUUID.gimbal2.name, "Gimbal, Inc.")
        XCTAssertNotEqual(BluetoothUUID.gimbal2, .bit32(65277))
        XCTAssertNotEqual(BluetoothUUID.gimbal2, .bit32(0xFEFD))

        /// GN ReSound A/S
        XCTAssertEqual(BluetoothUUID.gnResound.rawValue, "FEFE")
        XCTAssertEqual(BluetoothUUID.gnResound, .bit16(0xFEFE))
        XCTAssertEqual(BluetoothUUID.gnResound, .bit16(65278))
        XCTAssertEqual(BluetoothUUID.gnResound.name, "GN ReSound A/S")
        XCTAssertNotEqual(BluetoothUUID.gnResound, .bit32(65278))
        XCTAssertNotEqual(BluetoothUUID.gnResound, .bit32(0xFEFE))

        /// GN Netcom
        XCTAssertEqual(BluetoothUUID.gnNetcom.rawValue, "FEFF")
        XCTAssertEqual(BluetoothUUID.gnNetcom, .bit16(0xFEFF))
        XCTAssertEqual(BluetoothUUID.gnNetcom, .bit16(65279))
        XCTAssertEqual(BluetoothUUID.gnNetcom.name, "GN Netcom")
        XCTAssertNotEqual(BluetoothUUID.gnNetcom, .bit32(65279))
        XCTAssertNotEqual(BluetoothUUID.gnNetcom, .bit32(0xFEFF))

        /// Fast IDentity Online Alliance (FIDO)
        XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido.rawValue, "FFFD")
        XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit16(0xFFFD))
        XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit16(65533))
        XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido.name, "Fast IDentity Online Alliance (FIDO)")
        XCTAssertNotEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit32(65533))
        XCTAssertNotEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit32(0xFFFD))

        /// Alliance for Wireless Power (A4WP)
        XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp.rawValue, "FFFE")
        XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit16(0xFFFE))
        XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit16(65534))
        XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp.name, "Alliance for Wireless Power (A4WP)")
        XCTAssertNotEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit32(65534))
        XCTAssertNotEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit32(0xFFFE))

    }

}
// swiftlint:enable type_body_length
