//
//  Attribute.swift
//  Bluetooth
//
//  Created by Alsey Coleman Miller on 4/1/16.
//  Copyright © 2016 PureSwift. All rights reserved.
//

import Foundation

public extension GATT {
    
    typealias Permission = ATT.AttributePermission
    
    /// GATT Service
    struct Service {
        
        public var uuid: BluetoothUUID
        
        public var primary: Bool
        
        public var characteristics: [Characteristic]
        
        public var includedServices: [Include]
        
        public init(uuid: BluetoothUUID = BluetoothUUID(),
                    primary: Bool = true,
                    characteristics: [Characteristic] = [],
                    includedServices: [Include] = []) {
            
            self.uuid = uuid
            self.characteristics = characteristics
            self.primary = primary
            self.includedServices = includedServices
        }
    }
    
    /// GATT Include Declaration
    struct Include {
        
        /// Included service handle
        public var serviceHandle: UInt16
        
        /// End group handle
        public var endGroupHandle: UInt16
        
        /// Included Service UUID
        public var serviceUUID: BluetoothUUID
        
        public init(serviceHandle: UInt16,
                    endGroupHandle: UInt16,
                    serviceUUID: BluetoothUUID) {
            
            self.serviceHandle = serviceHandle
            self.endGroupHandle = endGroupHandle
            self.serviceUUID = serviceUUID
        }
    }
    
    /// GATT Characteristic
    struct Characteristic {
        
        public typealias Descriptor = GATT.Descriptor
        public typealias Property = GATT.CharacteristicProperty
        
        public var uuid: BluetoothUUID
        
        public var value: Data
        
        public var permissions: BitMaskOptionSet<Permission>
        
        public var properties: BitMaskOptionSet<Property>
        
        public var descriptors: [Descriptor]
        
        public init(uuid: BluetoothUUID = BluetoothUUID(),
                    value: Data = Data(),
                    permissions: BitMaskOptionSet<Permission> = [],
                    properties: BitMaskOptionSet<Property> = [],
                    descriptors: [Descriptor] = []) {
            
            self.uuid = uuid
            self.value = value
            self.permissions = permissions
            self.descriptors = descriptors
            self.properties = properties
        }
    }
    
    /// GATT Characteristic Descriptor
    struct Descriptor {
        
        public var uuid: BluetoothUUID
        
        public var value: Data
        
        public var permissions: BitMaskOptionSet<Permission>
        
        public init(uuid: BluetoothUUID = BluetoothUUID(),
                    value: Data = Data(),
                    permissions: BitMaskOptionSet<Permission> = []) {
            
            self.uuid = uuid
            self.value = value
            self.permissions = permissions
        }
    }
}
