//
//  UnitIdentifierTests.swift
//  Bluetooth
//
//  Generated by Carlos Duclos on 11/21/18.
//

import XCTest
import Foundation
@testable import Bluetooth

// swiftlint:disable type_body_length
final class UnitIdentifierTests: XCTestCase {

    static let allTests = [
        ("testUnits", testUnits)
    ]

    func testUnits() {

        /// plane angle (minute)
        XCTAssertEqual(UnitIdentifier.planeAngleMinute.rawValue, 0x2764)
        XCTAssertEqual(UnitIdentifier.planeAngleMinute.type, "org.bluetooth.unit.plane_angle.minute")
        XCTAssertEqual(UnitIdentifier.planeAngleMinute.name, "plane angle (minute)")
        XCTAssertEqual(UnitIdentifier.planeAngleMinute.description, "2764 (plane angle (minute))")

        /// magnetic flux (weber)
        XCTAssertEqual(UnitIdentifier.magneticFlux.rawValue, 0x272C)
        XCTAssertEqual(UnitIdentifier.magneticFlux.type, "org.bluetooth.unit.magnetic_flux.weber")
        XCTAssertEqual(UnitIdentifier.magneticFlux.name, "magnetic flux (weber)")
        XCTAssertEqual(UnitIdentifier.magneticFlux.description, "272C (magnetic flux (weber))")

        /// energy (kilowatt hour)
        XCTAssertEqual(UnitIdentifier.kilowattHour.rawValue, 0x27AB)
        XCTAssertEqual(UnitIdentifier.kilowattHour.type, "org.bluetooth.unit.energy.kilowatt_hour")
        XCTAssertEqual(UnitIdentifier.kilowattHour.name, "energy (kilowatt hour)")
        XCTAssertEqual(UnitIdentifier.kilowattHour.description, "27AB (energy (kilowatt hour))")

        /// electric field strength (volt per metre)
        XCTAssertEqual(UnitIdentifier.electricFieldStrength.rawValue, 0x274B)
        XCTAssertEqual(UnitIdentifier.electricFieldStrength.type, "org.bluetooth.unit.electric_field_strength.volt_per_metre")
        XCTAssertEqual(UnitIdentifier.electricFieldStrength.name, "electric field strength (volt per metre)")
        XCTAssertEqual(UnitIdentifier.electricFieldStrength.description, "274B (electric field strength (volt per metre))")

        /// mass (pound)
        XCTAssertEqual(UnitIdentifier.pound.rawValue, 0x27B8)
        XCTAssertEqual(UnitIdentifier.pound.type, "org.bluetooth.unit.mass.pound")
        XCTAssertEqual(UnitIdentifier.pound.name, "mass (pound)")
        XCTAssertEqual(UnitIdentifier.pound.description, "27B8 (mass (pound))")

        /// electric flux density (coulomb per square metre)
        XCTAssertEqual(UnitIdentifier.electricFluxDensity.rawValue, 0x274E)
        XCTAssertEqual(UnitIdentifier.electricFluxDensity.type, "org.bluetooth.unit.electric_flux_density.coulomb_per_square_metre")
        XCTAssertEqual(UnitIdentifier.electricFluxDensity.name, "electric flux density (coulomb per square metre)")
        XCTAssertEqual(UnitIdentifier.electricFluxDensity.description, "274E (electric flux density (coulomb per square metre))")

        /// activity referred to a radionuclide (becquerel)
        XCTAssertEqual(UnitIdentifier.becquerel.rawValue, 0x2732)
        XCTAssertEqual(UnitIdentifier.becquerel.type, "org.bluetooth.unit.activity_referred_to_a_radionuclide.becquerel")
        XCTAssertEqual(UnitIdentifier.becquerel.name, "activity referred to a radionuclide (becquerel)")
        XCTAssertEqual(UnitIdentifier.becquerel.description, "2732 (activity referred to a radionuclide (becquerel))")

        /// surface tension (newton per metre)
        XCTAssertEqual(UnitIdentifier.surfaceTension.rawValue, 0x2742)
        XCTAssertEqual(UnitIdentifier.surfaceTension.type, "org.bluetooth.unit.surface_tension.newton_per_metre")
        XCTAssertEqual(UnitIdentifier.surfaceTension.name, "surface tension (newton per metre)")
        XCTAssertEqual(UnitIdentifier.surfaceTension.description, "2742 (surface tension (newton per metre))")

        /// permittivity (farad per metre)
        XCTAssertEqual(UnitIdentifier.permittivity.rawValue, 0x274F)
        XCTAssertEqual(UnitIdentifier.permittivity.type, "org.bluetooth.unit.permittivity.farad_per_metre")
        XCTAssertEqual(UnitIdentifier.permittivity.name, "permittivity (farad per metre)")
        XCTAssertEqual(UnitIdentifier.permittivity.description, "274F (permittivity (farad per metre))")

        /// absorbed dose (gray)
        XCTAssertEqual(UnitIdentifier.absorbedDose.rawValue, 0x2733)
        XCTAssertEqual(UnitIdentifier.absorbedDose.type, "org.bluetooth.unit.absorbed_dose.gray")
        XCTAssertEqual(UnitIdentifier.absorbedDose.name, "absorbed dose (gray)")
        XCTAssertEqual(UnitIdentifier.absorbedDose.description, "2733 (absorbed dose (gray))")

        /// luminous intensity (candela)
        XCTAssertEqual(UnitIdentifier.candela.rawValue, 0x2707)
        XCTAssertEqual(UnitIdentifier.candela.type, "org.bluetooth.unit.luminous_intensity.candela")
        XCTAssertEqual(UnitIdentifier.candela.name, "luminous intensity (candela)")
        XCTAssertEqual(UnitIdentifier.candela.description, "2707 (luminous intensity (candela))")

        /// heat flux density (watt per square metre)
        XCTAssertEqual(UnitIdentifier.heatFluxDensity.rawValue, 0x2745)
        XCTAssertEqual(UnitIdentifier.heatFluxDensity.type, "org.bluetooth.unit.heat_flux_density.watt_per_square_metre")
        XCTAssertEqual(UnitIdentifier.heatFluxDensity.name, "heat flux density (watt per square metre)")
        XCTAssertEqual(UnitIdentifier.heatFluxDensity.description, "2745 (heat flux density (watt per square metre))")

        /// catalytic activity concentration (katal per cubic metre)
        XCTAssertEqual(UnitIdentifier.catalyticActivity.rawValue, 0x2757)
        XCTAssertEqual(UnitIdentifier.catalyticActivity.type, "org.bluetooth.unit.catalytic_activity_concentration.katal_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.catalyticActivity.name, "catalytic activity concentration (katal per cubic metre)")
        XCTAssertEqual(UnitIdentifier.catalyticActivity.description, "2757 (catalytic activity concentration (katal per cubic metre))")

        /// time (minute)
        XCTAssertEqual(UnitIdentifier.minute.rawValue, 0x2760)
        XCTAssertEqual(UnitIdentifier.minute.type, "org.bluetooth.unit.time.minute")
        XCTAssertEqual(UnitIdentifier.minute.name, "time (minute)")
        XCTAssertEqual(UnitIdentifier.minute.description, "2760 (time (minute))")

        /// electric conductance (siemens)
        XCTAssertEqual(UnitIdentifier.electricConductance.rawValue, 0x272B)
        XCTAssertEqual(UnitIdentifier.electricConductance.type, "org.bluetooth.unit.electric_conductance.siemens")
        XCTAssertEqual(UnitIdentifier.electricConductance.name, "electric conductance (siemens)")
        XCTAssertEqual(UnitIdentifier.electricConductance.description, "272B (electric conductance (siemens))")

        /// length (inch)
        XCTAssertEqual(UnitIdentifier.inch.rawValue, 0x27A2)
        XCTAssertEqual(UnitIdentifier.inch.type, "org.bluetooth.unit.length.inch")
        XCTAssertEqual(UnitIdentifier.inch.name, "length (inch)")
        XCTAssertEqual(UnitIdentifier.inch.description, "27A2 (length (inch))")

        /// velocity (kilometre per hour)
        XCTAssertEqual(UnitIdentifier.kilometrePerHour.rawValue, 0x27A6)
        XCTAssertEqual(UnitIdentifier.kilometrePerHour.type, "org.bluetooth.unit.velocity.kilometre_per_hour")
        XCTAssertEqual(UnitIdentifier.kilometrePerHour.name, "velocity (kilometre per hour)")
        XCTAssertEqual(UnitIdentifier.kilometrePerHour.description, "27A6 (velocity (kilometre per hour))")

        /// time (second)
        XCTAssertEqual(UnitIdentifier.second.rawValue, 0x2703)
        XCTAssertEqual(UnitIdentifier.second.type, "org.bluetooth.unit.time.second")
        XCTAssertEqual(UnitIdentifier.second.name, "time (second)")
        XCTAssertEqual(UnitIdentifier.second.description, "2703 (time (second))")

        /// thermal conductivity (watt per metre kelvin)
        XCTAssertEqual(UnitIdentifier.thermalConductivity.rawValue, 0x2749)
        XCTAssertEqual(UnitIdentifier.thermalConductivity.type, "org.bluetooth.unit.thermal_conductivity.watt_per_metre_kelvin")
        XCTAssertEqual(UnitIdentifier.thermalConductivity.name, "thermal conductivity (watt per metre kelvin)")
        XCTAssertEqual(UnitIdentifier.thermalConductivity.description, "2749 (thermal conductivity (watt per metre kelvin))")

        /// velocity (mile per hour)
        XCTAssertEqual(UnitIdentifier.milePerHour.rawValue, 0x27A7)
        XCTAssertEqual(UnitIdentifier.milePerHour.type, "org.bluetooth.unit.velocity.mile_per_hour")
        XCTAssertEqual(UnitIdentifier.milePerHour.name, "velocity (mile per hour)")
        XCTAssertEqual(UnitIdentifier.milePerHour.description, "27A7 (velocity (mile per hour))")

        /// heat capacity (joule per kelvin)
        XCTAssertEqual(UnitIdentifier.heatCapacity.rawValue, 0x2746)
        XCTAssertEqual(UnitIdentifier.heatCapacity.type, "org.bluetooth.unit.heat_capacity.joule_per_kelvin")
        XCTAssertEqual(UnitIdentifier.heatCapacity.name, "heat capacity (joule per kelvin)")
        XCTAssertEqual(UnitIdentifier.heatCapacity.description, "2746 (heat capacity (joule per kelvin))")

        /// period (beats per minute)
        XCTAssertEqual(UnitIdentifier.beatsPerMinute.rawValue, 0x27AF)
        XCTAssertEqual(UnitIdentifier.beatsPerMinute.type, "org.bluetooth.unit.period.beats_per_minute")
        XCTAssertEqual(UnitIdentifier.beatsPerMinute.name, "period (beats per minute)")
        XCTAssertEqual(UnitIdentifier.beatsPerMinute.description, "27AF (period (beats per minute))")

        /// milliliter (per kilogram per minute)
        XCTAssertEqual(UnitIdentifier.millilitre.rawValue, 0x27B7)
        XCTAssertEqual(UnitIdentifier.millilitre.type, "org.bluetooth.unit.transfer_rate.milliliter_per_kilogram_per_minute")
        XCTAssertEqual(UnitIdentifier.millilitre.name, "milliliter (per kilogram per minute)")
        XCTAssertEqual(UnitIdentifier.millilitre.description, "27B7 (milliliter (per kilogram per minute))")

        /// stroke (per minute)
        XCTAssertEqual(UnitIdentifier.stroke.rawValue, 0x27BC)
        XCTAssertEqual(UnitIdentifier.stroke.type, "org.bluetooth.unit.stroke_per_minute")
        XCTAssertEqual(UnitIdentifier.stroke.name, "stroke (per minute)")
        XCTAssertEqual(UnitIdentifier.stroke.description, "27BC (stroke (per minute))")

        /// length (yard)
        XCTAssertEqual(UnitIdentifier.yard.rawValue, 0x27A0)
        XCTAssertEqual(UnitIdentifier.yard.type, "org.bluetooth.unit.length.yard")
        XCTAssertEqual(UnitIdentifier.yard.name, "length (yard)")
        XCTAssertEqual(UnitIdentifier.yard.description, "27A0 (length (yard))")

        /// energy (kilogram calorie)
        XCTAssertEqual(UnitIdentifier.kilogramCalorie.rawValue, 0x27AA)
        XCTAssertEqual(UnitIdentifier.kilogramCalorie.type, "org.bluetooth.unit.energy.kilogram_calorie")
        XCTAssertEqual(UnitIdentifier.kilogramCalorie.name, "energy (kilogram calorie)")
        XCTAssertEqual(UnitIdentifier.kilogramCalorie.description, "27AA (energy (kilogram calorie))")

        /// energy (gram calorie)
        XCTAssertEqual(UnitIdentifier.gramCalorie.rawValue, 0x27A9)
        XCTAssertEqual(UnitIdentifier.gramCalorie.type, "org.bluetooth.unit.energy.gram_calorie")
        XCTAssertEqual(UnitIdentifier.gramCalorie.name, "energy (gram calorie)")
        XCTAssertEqual(UnitIdentifier.gramCalorie.description, "27A9 (energy (gram calorie))")

        /// time (year)
        XCTAssertEqual(UnitIdentifier.year.rawValue, 0x27B3)
        XCTAssertEqual(UnitIdentifier.year.type, "org.bluetooth.unit.time.year")
        XCTAssertEqual(UnitIdentifier.year.name, "time (year)")
        XCTAssertEqual(UnitIdentifier.year.description, "27B3 (time (year))")

        /// refractive index
        XCTAssertEqual(UnitIdentifier.refractiveIndex.rawValue, 0x271D)
        XCTAssertEqual(UnitIdentifier.refractiveIndex.type, "org.bluetooth.unit.refractive_index")
        XCTAssertEqual(UnitIdentifier.refractiveIndex.name, "refractive index")
        XCTAssertEqual(UnitIdentifier.refractiveIndex.description, "271D (refractive index)")

        /// absorbed dose rate (gray per second)
        XCTAssertEqual(UnitIdentifier.absorbedDoseRate.rawValue, 0x2754)
        XCTAssertEqual(UnitIdentifier.absorbedDoseRate.type, "org.bluetooth.unit.absorbed_dose_rate.gray_per_second")
        XCTAssertEqual(UnitIdentifier.absorbedDoseRate.name, "absorbed dose rate (gray per second)")
        XCTAssertEqual(UnitIdentifier.absorbedDoseRate.description, "2754 (absorbed dose rate (gray per second))")

        /// inductance (henry)
        XCTAssertEqual(UnitIdentifier.inductance.rawValue, 0x272E)
        XCTAssertEqual(UnitIdentifier.inductance.type, "org.bluetooth.unit.inductance.henry")
        XCTAssertEqual(UnitIdentifier.inductance.name, "inductance (henry)")
        XCTAssertEqual(UnitIdentifier.inductance.description, "272E (inductance (henry))")

        /// electric charge (coulomb)
        XCTAssertEqual(UnitIdentifier.coulomb.rawValue, 0x2727)
        XCTAssertEqual(UnitIdentifier.coulomb.type, "org.bluetooth.unit.electric_charge.coulomb")
        XCTAssertEqual(UnitIdentifier.coulomb.name, "electric charge (coulomb)")
        XCTAssertEqual(UnitIdentifier.coulomb.description, "2727 (electric charge (coulomb))")

        /// metabolic equivalent
        XCTAssertEqual(UnitIdentifier.metabolicEquivalent.rawValue, 0x27B9)
        XCTAssertEqual(UnitIdentifier.metabolicEquivalent.type, "org.bluetooth.unit.metabolic_equivalent")
        XCTAssertEqual(UnitIdentifier.metabolicEquivalent.name, "metabolic equivalent")
        XCTAssertEqual(UnitIdentifier.metabolicEquivalent.description, "27B9 (metabolic equivalent)")

        /// luminous exposure (lux hour)
        XCTAssertEqual(UnitIdentifier.luminousExposure.rawValue, 0x27C0)
        XCTAssertEqual(UnitIdentifier.luminousExposure.type, "org.bluetooth.unit.luminous_exposure.lux_hour")
        XCTAssertEqual(UnitIdentifier.luminousExposure.name, "luminous exposure (lux hour)")
        XCTAssertEqual(UnitIdentifier.luminousExposure.description, "27C0 (luminous exposure (lux hour))")

        /// length (nautical mile)
        XCTAssertEqual(UnitIdentifier.nauticalMile.rawValue, 0x2783)
        XCTAssertEqual(UnitIdentifier.nauticalMile.type, "org.bluetooth.unit.length.nautical_mile")
        XCTAssertEqual(UnitIdentifier.nauticalMile.name, "length (nautical mile)")
        XCTAssertEqual(UnitIdentifier.nauticalMile.description, "2783 (length (nautical mile))")

        /// area (hectare)
        XCTAssertEqual(UnitIdentifier.hectare.rawValue, 0x2766)
        XCTAssertEqual(UnitIdentifier.hectare.type, "org.bluetooth.unit.area.hectare")
        XCTAssertEqual(UnitIdentifier.hectare.name, "area (hectare)")
        XCTAssertEqual(UnitIdentifier.hectare.description, "2766 (area (hectare))")

        /// per mille
        XCTAssertEqual(UnitIdentifier.perMille.rawValue, 0x27AE)
        XCTAssertEqual(UnitIdentifier.perMille.type, "org.bluetooth.unit.per_mille")
        XCTAssertEqual(UnitIdentifier.perMille.name, "per mille")
        XCTAssertEqual(UnitIdentifier.perMille.description, "27AE (per mille)")

        /// energy density (joule per cubic metre)
        XCTAssertEqual(UnitIdentifier.energyDensity.rawValue, 0x274A)
        XCTAssertEqual(UnitIdentifier.energyDensity.type, "org.bluetooth.unit.energy_density.joule_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.energyDensity.name, "energy density (joule per cubic metre)")
        XCTAssertEqual(UnitIdentifier.energyDensity.description, "274A (energy density (joule per cubic metre))")

        /// capacitance (farad)
        XCTAssertEqual(UnitIdentifier.capitance.rawValue, 0x2729)
        XCTAssertEqual(UnitIdentifier.capitance.type, "org.bluetooth.unit.capacitance.farad")
        XCTAssertEqual(UnitIdentifier.capitance.name, "capacitance (farad)")
        XCTAssertEqual(UnitIdentifier.capitance.description, "2729 (capacitance (farad))")

        /// wavenumber (reciprocal metre)
        XCTAssertEqual(UnitIdentifier.wavenumber.rawValue, 0x2714)
        XCTAssertEqual(UnitIdentifier.wavenumber.type, "org.bluetooth.unit.wavenumber.reciprocal_metre")
        XCTAssertEqual(UnitIdentifier.wavenumber.name, "wavenumber (reciprocal metre)")
        XCTAssertEqual(UnitIdentifier.wavenumber.description, "2714 (wavenumber (reciprocal metre))")

        /// plane angle (second)
        XCTAssertEqual(UnitIdentifier.planeAngleSecond.rawValue, 0x2765)
        XCTAssertEqual(UnitIdentifier.planeAngleSecond.type, "org.bluetooth.unit.plane_angle.second")
        XCTAssertEqual(UnitIdentifier.planeAngleSecond.name, "plane angle (second)")
        XCTAssertEqual(UnitIdentifier.planeAngleSecond.description, "2765 (plane angle (second))")

        /// time (day)
        XCTAssertEqual(UnitIdentifier.day.rawValue, 0x2762)
        XCTAssertEqual(UnitIdentifier.day.type, "org.bluetooth.unit.time.day")
        XCTAssertEqual(UnitIdentifier.day.name, "time (day)")
        XCTAssertEqual(UnitIdentifier.day.description, "2762 (time (day))")

        /// mass flow (gram per second)
        XCTAssertEqual(UnitIdentifier.massFlow.rawValue, 0x27C1)
        XCTAssertEqual(UnitIdentifier.massFlow.type, "org.bluetooth.unit.mass_flow.gram_per_second")
        XCTAssertEqual(UnitIdentifier.massFlow.name, "mass flow (gram per second)")
        XCTAssertEqual(UnitIdentifier.massFlow.description, "27C1 (mass flow (gram per second))")

        /// radiance (watt per square metre steradian)
        XCTAssertEqual(UnitIdentifier.radiance.rawValue, 0x2756)
        XCTAssertEqual(UnitIdentifier.radiance.type, "org.bluetooth.unit.radiance.watt_per_square_metre_steradian")
        XCTAssertEqual(UnitIdentifier.radiance.name, "radiance (watt per square metre steradian)")
        XCTAssertEqual(UnitIdentifier.radiance.description, "2756 (radiance (watt per square metre steradian))")

        /// thermodynamic temperature (degree Fahrenheit)
        XCTAssertEqual(UnitIdentifier.degreeFahrenheit.rawValue, 0x27AC)
        XCTAssertEqual(UnitIdentifier.degreeFahrenheit.type, "org.bluetooth.unit.thermodynamic_temperature.degree_fahrenheit")
        XCTAssertEqual(UnitIdentifier.degreeFahrenheit.name, "thermodynamic temperature (degree Fahrenheit)")
        XCTAssertEqual(UnitIdentifier.degreeFahrenheit.description, "27AC (thermodynamic temperature (degree Fahrenheit))")

        /// luminance (candela per square metre)
        XCTAssertEqual(UnitIdentifier.luminance.rawValue, 0x271C)
        XCTAssertEqual(UnitIdentifier.luminance.type, "org.bluetooth.unit.luminance.candela_per_square_metre")
        XCTAssertEqual(UnitIdentifier.luminance.name, "luminance (candela per square metre)")
        XCTAssertEqual(UnitIdentifier.luminance.description, "271C (luminance (candela per square metre))")

        /// length (ngstrm)
        XCTAssertEqual(UnitIdentifier.ngstrm.rawValue, 0x2782)
        XCTAssertEqual(UnitIdentifier.ngstrm.type, "org.bluetooth.unit.length.ngstrm")
        XCTAssertEqual(UnitIdentifier.ngstrm.name, "length (ngstrm)")
        XCTAssertEqual(UnitIdentifier.ngstrm.description, "2782 (length (ngstrm))")

        /// luminous energy (lumen hour)
        XCTAssertEqual(UnitIdentifier.luminousEnergy.rawValue, 0x27BF)
        XCTAssertEqual(UnitIdentifier.luminousEnergy.type, "org.bluetooth.unit.luminous_energy.lumen_hour")
        XCTAssertEqual(UnitIdentifier.luminousEnergy.name, "luminous energy (lumen hour)")
        XCTAssertEqual(UnitIdentifier.luminousEnergy.description, "27BF (luminous energy (lumen hour))")

        /// logarithmic radio quantity (neper)
        XCTAssertEqual(UnitIdentifier.neper.rawValue, 0x2786)
        XCTAssertEqual(UnitIdentifier.neper.type, "org.bluetooth.unit.logarithmic_radio_quantity.neper")
        XCTAssertEqual(UnitIdentifier.neper.name, "logarithmic radio quantity (neper)")
        XCTAssertEqual(UnitIdentifier.neper.description, "2786 (logarithmic radio quantity (neper))")

        /// mass (tonne)
        XCTAssertEqual(UnitIdentifier.tonne.rawValue, 0x2768)
        XCTAssertEqual(UnitIdentifier.tonne.type, "org.bluetooth.unit.mass.tonne")
        XCTAssertEqual(UnitIdentifier.tonne.name, "mass (tonne)")
        XCTAssertEqual(UnitIdentifier.tonne.description, "2768 (mass (tonne))")

        /// Celsius temperature (degree Celsius)
        XCTAssertEqual(UnitIdentifier.celsius.rawValue, 0x272F)
        XCTAssertEqual(UnitIdentifier.celsius.type, "org.bluetooth.unit.thermodynamic_temperature.degree_celsius")
        XCTAssertEqual(UnitIdentifier.celsius.name, "Celsius temperature (degree Celsius)")
        XCTAssertEqual(UnitIdentifier.celsius.description, "272F (Celsius temperature (degree Celsius))")

        /// thermodynamic temperature (kelvin)
        XCTAssertEqual(UnitIdentifier.kelvin.rawValue, 0x2705)
        XCTAssertEqual(UnitIdentifier.kelvin.type, "org.bluetooth.unit.thermodynamic_temperature.kelvin")
        XCTAssertEqual(UnitIdentifier.kelvin.name, "thermodynamic temperature (kelvin)")
        XCTAssertEqual(UnitIdentifier.kelvin.description, "2705 (thermodynamic temperature (kelvin))")

        /// unitless
        XCTAssertEqual(UnitIdentifier.unitless.rawValue, 0x2700)
        XCTAssertEqual(UnitIdentifier.unitless.type, "org.bluetooth.unit.unitless")
        XCTAssertEqual(UnitIdentifier.unitless.name, "unitless")
        XCTAssertEqual(UnitIdentifier.unitless.description, "2700 (unitless)")

        /// surface density (kilogram per square metre)
        XCTAssertEqual(UnitIdentifier.surfaceDensity.rawValue, 0x2716)
        XCTAssertEqual(UnitIdentifier.surfaceDensity.type, "org.bluetooth.unit.surface_density.kilogram_per_square_metre")
        XCTAssertEqual(UnitIdentifier.surfaceDensity.name, "surface density (kilogram per square metre)")
        XCTAssertEqual(UnitIdentifier.surfaceDensity.description, "2716 (surface density (kilogram per square metre))")

        /// length (parsec)
        XCTAssertEqual(UnitIdentifier.parsec.rawValue, 0x27A1)
        XCTAssertEqual(UnitIdentifier.parsec.type, "org.bluetooth.unit.length.parsec")
        XCTAssertEqual(UnitIdentifier.parsec.name, "length (parsec)")
        XCTAssertEqual(UnitIdentifier.parsec.description, "27A1 (length (parsec))")

        /// velocity (metres per second)
        XCTAssertEqual(UnitIdentifier.velocity.rawValue, 0x2712)
        XCTAssertEqual(UnitIdentifier.velocity.type, "org.bluetooth.unit.velocity.metres_per_second")
        XCTAssertEqual(UnitIdentifier.velocity.name, "velocity (metres per second)")
        XCTAssertEqual(UnitIdentifier.velocity.description, "2712 (velocity (metres per second))")

        /// energy (joule)
        XCTAssertEqual(UnitIdentifier.energy.rawValue, 0x2725)
        XCTAssertEqual(UnitIdentifier.energy.type, "org.bluetooth.unit.energy.joule")
        XCTAssertEqual(UnitIdentifier.energy.name, "energy (joule)")
        XCTAssertEqual(UnitIdentifier.energy.description, "2725 (energy (joule))")

        /// electric current (ampere)
        XCTAssertEqual(UnitIdentifier.ampere.rawValue, 0x2704)
        XCTAssertEqual(UnitIdentifier.ampere.type, "org.bluetooth.unit.electric_current.ampere")
        XCTAssertEqual(UnitIdentifier.ampere.name, "electric current (ampere)")
        XCTAssertEqual(UnitIdentifier.ampere.description, "2704 (electric current (ampere))")

        /// relative permeability
        XCTAssertEqual(UnitIdentifier.relativePermeability.rawValue, 0x271E)
        XCTAssertEqual(UnitIdentifier.relativePermeability.type, "org.bluetooth.unit.relative_permeability")
        XCTAssertEqual(UnitIdentifier.relativePermeability.name, "relative permeability")
        XCTAssertEqual(UnitIdentifier.relativePermeability.description, "271E (relative permeability)")

        /// electric resistance (ohm)
        XCTAssertEqual(UnitIdentifier.electricResistance.rawValue, 0x272A)
        XCTAssertEqual(UnitIdentifier.electricResistance.type, "org.bluetooth.unit.electric_resistance.ohm")
        XCTAssertEqual(UnitIdentifier.electricResistance.name, "electric resistance (ohm)")
        XCTAssertEqual(UnitIdentifier.electricResistance.description, "272A (electric resistance (ohm))")

        /// pace (kilometre per minute)
        XCTAssertEqual(UnitIdentifier.pace.rawValue, 0x27BD)
        XCTAssertEqual(UnitIdentifier.pace.type, "org.bluetooth.unit.velocity.kilometer_per_minute")
        XCTAssertEqual(UnitIdentifier.pace.name, "pace (kilometre per minute)")
        XCTAssertEqual(UnitIdentifier.pace.description, "27BD (pace (kilometre per minute))")

        /// pressure (pound-force per square inch)
        XCTAssertEqual(UnitIdentifier.pressurePoundForce.rawValue, 0x27A5)
        XCTAssertEqual(UnitIdentifier.pressurePoundForce.type, "org.bluetooth.unit.pressure.pound_force_per_square_inch")
        XCTAssertEqual(UnitIdentifier.pressurePoundForce.name, "pressure (pound-force per square inch)")
        XCTAssertEqual(UnitIdentifier.pressurePoundForce.description, "27A5 (pressure (pound-force per square inch))")

        /// dynamic viscosity (pascal second)
        XCTAssertEqual(UnitIdentifier.pascalSecond.rawValue, 0x2740)
        XCTAssertEqual(UnitIdentifier.pascalSecond.type, "org.bluetooth.unit.dynamic_viscosity.pascal_second")
        XCTAssertEqual(UnitIdentifier.pascalSecond.name, "dynamic viscosity (pascal second)")
        XCTAssertEqual(UnitIdentifier.pascalSecond.description, "2740 (dynamic viscosity (pascal second))")

        /// volume (cubic metres)
        XCTAssertEqual(UnitIdentifier.volume.rawValue, 0x2711)
        XCTAssertEqual(UnitIdentifier.volume.type, "org.bluetooth.unit.volume.cubic_metres")
        XCTAssertEqual(UnitIdentifier.volume.name, "volume (cubic metres)")
        XCTAssertEqual(UnitIdentifier.volume.description, "2711 (volume (cubic metres))")

        /// angular acceleration (radian per second squared)
        XCTAssertEqual(UnitIdentifier.angularAcceleration.rawValue, 0x2744)
        XCTAssertEqual(UnitIdentifier.angularAcceleration.type, "org.bluetooth.unit.angular_acceleration.radian_per_second_squared")
        XCTAssertEqual(UnitIdentifier.angularAcceleration.name, "angular acceleration (radian per second squared)")
        XCTAssertEqual(UnitIdentifier.angularAcceleration.description, "2744 (angular acceleration (radian per second squared))")

        /// molar energy (joule per mole)
        XCTAssertEqual(UnitIdentifier.molarEnergy.rawValue, 0x2751)
        XCTAssertEqual(UnitIdentifier.molarEnergy.type, "org.bluetooth.unit.molar_energy.joule_per_mole")
        XCTAssertEqual(UnitIdentifier.molarEnergy.name, "molar energy (joule per mole)")
        XCTAssertEqual(UnitIdentifier.molarEnergy.description, "2751 (molar energy (joule per mole))")

        /// radiant intensity (watt per steradian)
        XCTAssertEqual(UnitIdentifier.radradiantIntensityiance.rawValue, 0x2755)
        XCTAssertEqual(UnitIdentifier.radradiantIntensityiance.type, "org.bluetooth.unit.radiant_intensity.watt_per_steradian")
        XCTAssertEqual(UnitIdentifier.radradiantIntensityiance.name, "radiant intensity (watt per steradian)")
        XCTAssertEqual(UnitIdentifier.radradiantIntensityiance.description, "2755 (radiant intensity (watt per steradian))")

        /// illuminance (lux)
        XCTAssertEqual(UnitIdentifier.illuminance.rawValue, 0x2731)
        XCTAssertEqual(UnitIdentifier.illuminance.type, "org.bluetooth.unit.illuminance.lux")
        XCTAssertEqual(UnitIdentifier.illuminance.name, "illuminance (lux)")
        XCTAssertEqual(UnitIdentifier.illuminance.description, "2731 (illuminance (lux))")

        /// mass density (millimole per litre)
        XCTAssertEqual(UnitIdentifier.millimolePerLitre.rawValue, 0x27B2)
        XCTAssertEqual(UnitIdentifier.millimolePerLitre.type, "org.bluetooth.unit.mass_density.millimole_per_litre")
        XCTAssertEqual(UnitIdentifier.millimolePerLitre.name, "mass density (millimole per litre)")
        XCTAssertEqual(UnitIdentifier.millimolePerLitre.description, "27B2 (mass density (millimole per litre))")

        /// pressure (pascal)
        XCTAssertEqual(UnitIdentifier.pascalPressure.rawValue, 0x2724)
        XCTAssertEqual(UnitIdentifier.pascalPressure.type, "org.bluetooth.unit.pressure.pascal")
        XCTAssertEqual(UnitIdentifier.pascalPressure.name, "pressure (pascal)")
        XCTAssertEqual(UnitIdentifier.pascalPressure.description, "2724 (pressure (pascal))")

        /// pressure (millimetre of mercury)
        XCTAssertEqual(UnitIdentifier.millimetreOfMercury.rawValue, 0x2781)
        XCTAssertEqual(UnitIdentifier.millimetreOfMercury.type, "org.bluetooth.unit.pressure.millimetre_of_mercury")
        XCTAssertEqual(UnitIdentifier.millimetreOfMercury.name, "pressure (millimetre of mercury)")
        XCTAssertEqual(UnitIdentifier.millimetreOfMercury.description, "2781 (pressure (millimetre of mercury))")

        /// mass concentration (kilogram per cubic metre)
        XCTAssertEqual(UnitIdentifier.massConcentration.rawValue, 0x271B)
        XCTAssertEqual(UnitIdentifier.massConcentration.type, "org.bluetooth.unit.mass_concentration.kilogram_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.massConcentration.name, "mass concentration (kilogram per cubic metre)")
        XCTAssertEqual(UnitIdentifier.massConcentration.description, "271B (mass concentration (kilogram per cubic metre))")

        /// molar entropy (joule per mole kelvin)
        XCTAssertEqual(UnitIdentifier.molarEntropy.rawValue, 0x2752)
        XCTAssertEqual(UnitIdentifier.molarEntropy.type, "org.bluetooth.unit.molar_entropy.joule_per_mole_kelvin")
        XCTAssertEqual(UnitIdentifier.molarEntropy.name, "molar entropy (joule per mole kelvin)")
        XCTAssertEqual(UnitIdentifier.molarEntropy.description, "2752 (molar entropy (joule per mole kelvin))")

        /// area (barn)
        XCTAssertEqual(UnitIdentifier.barn.rawValue, 0x2784)
        XCTAssertEqual(UnitIdentifier.barn.type, "org.bluetooth.unit.area.barn")
        XCTAssertEqual(UnitIdentifier.barn.name, "area (barn)")
        XCTAssertEqual(UnitIdentifier.barn.description, "2784 (area (barn))")

        /// angular velocity (revolution per minute)
        XCTAssertEqual(UnitIdentifier.revolutionPerMinute.rawValue, 0x27A8)
        XCTAssertEqual(UnitIdentifier.revolutionPerMinute.type, "org.bluetooth.unit.angular_velocity.revolution_per_minute")
        XCTAssertEqual(UnitIdentifier.revolutionPerMinute.name, "angular velocity (revolution per minute)")
        XCTAssertEqual(UnitIdentifier.revolutionPerMinute.description, "27A8 (angular velocity (revolution per minute))")

        /// plane angle (radian)
        XCTAssertEqual(UnitIdentifier.planeAngle.rawValue, 0x2720)
        XCTAssertEqual(UnitIdentifier.planeAngle.type, "org.bluetooth.unit.plane_angle.radian")
        XCTAssertEqual(UnitIdentifier.planeAngle.name, "plane angle (radian)")
        XCTAssertEqual(UnitIdentifier.planeAngle.description, "2720 (plane angle (radian))")

        /// pressure (bar)
        XCTAssertEqual(UnitIdentifier.bar.rawValue, 0x2780)
        XCTAssertEqual(UnitIdentifier.bar.type, "org.bluetooth.unit.pressure.bar")
        XCTAssertEqual(UnitIdentifier.bar.name, "pressure (bar)")
        XCTAssertEqual(UnitIdentifier.bar.description, "2780 (pressure (bar))")

        /// irradiance (watt per square metre)
        XCTAssertEqual(UnitIdentifier.irrandiance.rawValue, 0x27B6)
        XCTAssertEqual(UnitIdentifier.irrandiance.type, "org.bluetooth.unit.irradiance.watt_per_square_metre")
        XCTAssertEqual(UnitIdentifier.irrandiance.name, "irradiance (watt per square metre)")
        XCTAssertEqual(UnitIdentifier.irrandiance.description, "27B6 (irradiance (watt per square metre))")

        /// luminous efficacy (lumen per watt)
        XCTAssertEqual(UnitIdentifier.luminousEfficacy.rawValue, 0x27BE)
        XCTAssertEqual(UnitIdentifier.luminousEfficacy.type, "org.bluetooth.unit.luminous_efficacy.lumen_per_watt")
        XCTAssertEqual(UnitIdentifier.luminousEfficacy.name, "luminous efficacy (lumen per watt)")
        XCTAssertEqual(UnitIdentifier.luminousEfficacy.description, "27BE (luminous efficacy (lumen per watt))")

        /// percentage
        XCTAssertEqual(UnitIdentifier.percentage.rawValue, 0x27AD)
        XCTAssertEqual(UnitIdentifier.percentage.type, "org.bluetooth.unit.percentage")
        XCTAssertEqual(UnitIdentifier.percentage.name, "percentage")
        XCTAssertEqual(UnitIdentifier.percentage.description, "27AD (percentage)")

        /// catalytic activity (katal)
        XCTAssertEqual(UnitIdentifier.katal.rawValue, 0x2735)
        XCTAssertEqual(UnitIdentifier.katal.type, "org.bluetooth.unit.catalytic_activity.katal")
        XCTAssertEqual(UnitIdentifier.katal.name, "catalytic activity (katal)")
        XCTAssertEqual(UnitIdentifier.katal.description, "2735 (catalytic activity (katal))")

        /// volume flow (litre per second)
        XCTAssertEqual(UnitIdentifier.volumeFlow.rawValue, 0x27C2)
        XCTAssertEqual(UnitIdentifier.volumeFlow.type, "org.bluetooth.unit.volume_flow.litre_per_second")
        XCTAssertEqual(UnitIdentifier.volumeFlow.name, "volume flow (litre per second)")
        XCTAssertEqual(UnitIdentifier.volumeFlow.description, "27C2 (volume flow (litre per second))")

        /// specific heat capacity (joule per kilogram kelvin)
        XCTAssertEqual(UnitIdentifier.specificHeatCapacity.rawValue, 0x2747)
        XCTAssertEqual(UnitIdentifier.specificHeatCapacity.type, "org.bluetooth.unit.specific_heat_capacity.joule_per_kilogram_kelvin")
        XCTAssertEqual(UnitIdentifier.specificHeatCapacity.name, "specific heat capacity (joule per kilogram kelvin)")
        XCTAssertEqual(UnitIdentifier.specificHeatCapacity.description, "2747 (specific heat capacity (joule per kilogram kelvin))")

        /// solid angle (steradian)
        XCTAssertEqual(UnitIdentifier.solidAngle.rawValue, 0x2721)
        XCTAssertEqual(UnitIdentifier.solidAngle.type, "org.bluetooth.unit.solid_angle.steradian")
        XCTAssertEqual(UnitIdentifier.solidAngle.name, "solid angle (steradian)")
        XCTAssertEqual(UnitIdentifier.solidAngle.description, "2721 (solid angle (steradian))")

        /// power (watt)
        XCTAssertEqual(UnitIdentifier.power.rawValue, 0x2726)
        XCTAssertEqual(UnitIdentifier.power.type, "org.bluetooth.unit.power.watt")
        XCTAssertEqual(UnitIdentifier.power.name, "power (watt)")
        XCTAssertEqual(UnitIdentifier.power.description, "2726 (power (watt))")

        /// amount of substance (mole)
        XCTAssertEqual(UnitIdentifier.mole.rawValue, 0x2706)
        XCTAssertEqual(UnitIdentifier.mole.type, "org.bluetooth.unit.amount_of_substance.mole")
        XCTAssertEqual(UnitIdentifier.mole.name, "amount of substance (mole)")
        XCTAssertEqual(UnitIdentifier.mole.description, "2706 (amount of substance (mole))")

        /// density (kilogram per cubic metre)
        XCTAssertEqual(UnitIdentifier.density.rawValue, 0x2715)
        XCTAssertEqual(UnitIdentifier.density.type, "org.bluetooth.unit.density.kilogram_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.density.name, "density (kilogram per cubic metre)")
        XCTAssertEqual(UnitIdentifier.density.description, "2715 (density (kilogram per cubic metre))")

        /// magnetic flux density (tesla)
        XCTAssertEqual(UnitIdentifier.magneticFluxDensity.rawValue, 0x272D)
        XCTAssertEqual(UnitIdentifier.magneticFluxDensity.type, "org.bluetooth.unit.magnetic_flux_density.tesla")
        XCTAssertEqual(UnitIdentifier.magneticFluxDensity.name, "magnetic flux density (tesla)")
        XCTAssertEqual(UnitIdentifier.magneticFluxDensity.description, "272D (magnetic flux density (tesla))")

        /// length (mile)
        XCTAssertEqual(UnitIdentifier.mile.rawValue, 0x27A4)
        XCTAssertEqual(UnitIdentifier.mile.type, "org.bluetooth.unit.length.mile")
        XCTAssertEqual(UnitIdentifier.mile.name, "length (mile)")
        XCTAssertEqual(UnitIdentifier.mile.description, "27A4 (length (mile))")

        /// angular velocity (radian per second)
        XCTAssertEqual(UnitIdentifier.angularVelocity.rawValue, 0x2743)
        XCTAssertEqual(UnitIdentifier.angularVelocity.type, "org.bluetooth.unit.angular_velocity.radian_per_second")
        XCTAssertEqual(UnitIdentifier.angularVelocity.name, "angular velocity (radian per second)")
        XCTAssertEqual(UnitIdentifier.angularVelocity.description, "2743 (angular velocity (radian per second))")

        /// frequency (hertz)
        XCTAssertEqual(UnitIdentifier.frequency.rawValue, 0x2722)
        XCTAssertEqual(UnitIdentifier.frequency.type, "org.bluetooth.unit.frequency.hertz")
        XCTAssertEqual(UnitIdentifier.frequency.name, "frequency (hertz)")
        XCTAssertEqual(UnitIdentifier.frequency.description, "2722 (frequency (hertz))")

        /// mass (kilogram)
        XCTAssertEqual(UnitIdentifier.kilogram.rawValue, 0x2702)
        XCTAssertEqual(UnitIdentifier.kilogram.type, "org.bluetooth.unit.mass.kilogram")
        XCTAssertEqual(UnitIdentifier.kilogram.name, "mass (kilogram)")
        XCTAssertEqual(UnitIdentifier.kilogram.description, "2702 (mass (kilogram))")

        /// specific volume (cubic metre per kilogram)
        XCTAssertEqual(UnitIdentifier.specificVolume.rawValue, 0x2717)
        XCTAssertEqual(UnitIdentifier.specificVolume.type, "org.bluetooth.unit.specific_volume.cubic_metre_per_kilogram")
        XCTAssertEqual(UnitIdentifier.specificVolume.name, "specific volume (cubic metre per kilogram)")
        XCTAssertEqual(UnitIdentifier.specificVolume.description, "2717 (specific volume (cubic metre per kilogram))")

        /// plane angle (degree)
        XCTAssertEqual(UnitIdentifier.degree.rawValue, 0x2763)
        XCTAssertEqual(UnitIdentifier.degree.type, "org.bluetooth.unit.plane_angle.degree")
        XCTAssertEqual(UnitIdentifier.degree.name, "plane angle (degree)")
        XCTAssertEqual(UnitIdentifier.degree.description, "2763 (plane angle (degree))")

        /// velocity (knot)
        XCTAssertEqual(UnitIdentifier.velocityKnot.rawValue, 0x2785)
        XCTAssertEqual(UnitIdentifier.velocityKnot.type, "org.bluetooth.unit.velocity.knot")
        XCTAssertEqual(UnitIdentifier.velocityKnot.name, "velocity (knot)")
        XCTAssertEqual(UnitIdentifier.velocityKnot.description, "2785 (velocity (knot))")

        /// acceleration (metres per second squared)
        XCTAssertEqual(UnitIdentifier.acceleration.rawValue, 0x2713)
        XCTAssertEqual(UnitIdentifier.acceleration.type, "org.bluetooth.unit.acceleration.metres_per_second_squared")
        XCTAssertEqual(UnitIdentifier.acceleration.name, "acceleration (metres per second squared)")
        XCTAssertEqual(UnitIdentifier.acceleration.description, "2713 (acceleration (metres per second squared))")

        /// current density (ampere per square metre)
        XCTAssertEqual(UnitIdentifier.currentDensity.rawValue, 0x2718)
        XCTAssertEqual(UnitIdentifier.currentDensity.type, "org.bluetooth.unit.current_density.ampere_per_square_metre")
        XCTAssertEqual(UnitIdentifier.currentDensity.name, "current density (ampere per square metre)")
        XCTAssertEqual(UnitIdentifier.currentDensity.description, "2718 (current density (ampere per square metre))")

        /// moment of force (newton metre)
        XCTAssertEqual(UnitIdentifier.newtonMetre.rawValue, 0x2741)
        XCTAssertEqual(UnitIdentifier.newtonMetre.type, "org.bluetooth.unit.moment_of_force.newton_metre")
        XCTAssertEqual(UnitIdentifier.newtonMetre.name, "moment of force (newton metre)")
        XCTAssertEqual(UnitIdentifier.newtonMetre.description, "2741 (moment of force (newton metre))")

        /// specific energy (joule per kilogram)
        XCTAssertEqual(UnitIdentifier.specificEnergy.rawValue, 0x2748)
        XCTAssertEqual(UnitIdentifier.specificEnergy.type, "org.bluetooth.unit.specific_energy.joule_per_kilogram")
        XCTAssertEqual(UnitIdentifier.specificEnergy.name, "specific energy (joule per kilogram)")
        XCTAssertEqual(UnitIdentifier.specificEnergy.description, "2748 (specific energy (joule per kilogram))")

        /// length (foot)
        XCTAssertEqual(UnitIdentifier.foot.rawValue, 0x27A3)
        XCTAssertEqual(UnitIdentifier.foot.type, "org.bluetooth.unit.length.foot")
        XCTAssertEqual(UnitIdentifier.foot.name, "length (foot)")
        XCTAssertEqual(UnitIdentifier.foot.description, "27A3 (length (foot))")

        /// area (square metres)
        XCTAssertEqual(UnitIdentifier.area.rawValue, 0x2710)
        XCTAssertEqual(UnitIdentifier.area.type, "org.bluetooth.unit.area.square_metres")
        XCTAssertEqual(UnitIdentifier.area.name, "area (square metres)")
        XCTAssertEqual(UnitIdentifier.area.description, "2710 (area (square metres))")

        /// electric potential difference (volt)
        XCTAssertEqual(UnitIdentifier.electricPotential.rawValue, 0x2728)
        XCTAssertEqual(UnitIdentifier.electricPotential.type, "org.bluetooth.unit.electric_potential_difference.volt")
        XCTAssertEqual(UnitIdentifier.electricPotential.name, "electric potential difference (volt)")
        XCTAssertEqual(UnitIdentifier.electricPotential.description, "2728 (electric potential difference (volt))")

        /// time (hour)
        XCTAssertEqual(UnitIdentifier.hour.rawValue, 0x2761)
        XCTAssertEqual(UnitIdentifier.hour.type, "org.bluetooth.unit.time.hour")
        XCTAssertEqual(UnitIdentifier.hour.name, "time (hour)")
        XCTAssertEqual(UnitIdentifier.hour.description, "2761 (time (hour))")

        /// dose equivalent (sievert)
        XCTAssertEqual(UnitIdentifier.sievert.rawValue, 0x2734)
        XCTAssertEqual(UnitIdentifier.sievert.type, "org.bluetooth.unit.dose_equivalent.sievert")
        XCTAssertEqual(UnitIdentifier.sievert.name, "dose equivalent (sievert)")
        XCTAssertEqual(UnitIdentifier.sievert.description, "2734 (dose equivalent (sievert))")

        /// step (per minute)
        XCTAssertEqual(UnitIdentifier.step.rawValue, 0x27BA)
        XCTAssertEqual(UnitIdentifier.step.type, "org.bluetooth.unit.step_per_minute")
        XCTAssertEqual(UnitIdentifier.step.name, "step (per minute)")
        XCTAssertEqual(UnitIdentifier.step.description, "27BA (step (per minute))")

        /// concentration (count per cubic metre)
        XCTAssertEqual(UnitIdentifier.concentration.rawValue, 0x27B5)
        XCTAssertEqual(UnitIdentifier.concentration.type, "org.bluetooth.unit.concentration.count_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.concentration.name, "concentration (count per cubic metre)")
        XCTAssertEqual(UnitIdentifier.concentration.description, "27B5 (concentration (count per cubic metre))")

        /// logarithmic radio quantity (bel)
        XCTAssertEqual(UnitIdentifier.bel.rawValue, 0x2787)
        XCTAssertEqual(UnitIdentifier.bel.type, "org.bluetooth.unit.logarithmic_radio_quantity.bel")
        XCTAssertEqual(UnitIdentifier.bel.name, "logarithmic radio quantity (bel)")
        XCTAssertEqual(UnitIdentifier.bel.description, "2787 (logarithmic radio quantity (bel))")

        /// electric charge (ampere hours)
        XCTAssertEqual(UnitIdentifier.ampereHours.rawValue, 0x27B0)
        XCTAssertEqual(UnitIdentifier.ampereHours.type, "org.bluetooth.unit.electric_charge.ampere_hours")
        XCTAssertEqual(UnitIdentifier.ampereHours.name, "electric charge (ampere hours)")
        XCTAssertEqual(UnitIdentifier.ampereHours.description, "27B0 (electric charge (ampere hours))")

        /// volume (litre)
        XCTAssertEqual(UnitIdentifier.litre.rawValue, 0x2767)
        XCTAssertEqual(UnitIdentifier.litre.type, "org.bluetooth.unit.volume.litre")
        XCTAssertEqual(UnitIdentifier.litre.name, "volume (litre)")
        XCTAssertEqual(UnitIdentifier.litre.description, "2767 (volume (litre))")

        /// time (month)
        XCTAssertEqual(UnitIdentifier.month.rawValue, 0x27B4)
        XCTAssertEqual(UnitIdentifier.month.type, "org.bluetooth.unit.time.month")
        XCTAssertEqual(UnitIdentifier.month.name, "time (month)")
        XCTAssertEqual(UnitIdentifier.month.description, "27B4 (time (month))")

        /// amount concentration (mole per cubic metre)
        XCTAssertEqual(UnitIdentifier.amountConcentration.rawValue, 0x271A)
        XCTAssertEqual(UnitIdentifier.amountConcentration.type, "org.bluetooth.unit.amount_concentration.mole_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.amountConcentration.name, "amount concentration (mole per cubic metre)")
        XCTAssertEqual(UnitIdentifier.amountConcentration.description, "271A (amount concentration (mole per cubic metre))")

        /// permeability (henry per metre)
        XCTAssertEqual(UnitIdentifier.permeability.rawValue, 0x2750)
        XCTAssertEqual(UnitIdentifier.permeability.type, "org.bluetooth.unit.permeability.henry_per_metre")
        XCTAssertEqual(UnitIdentifier.permeability.name, "permeability (henry per metre)")
        XCTAssertEqual(UnitIdentifier.permeability.description, "2750 (permeability (henry per metre))")

        /// mass density (milligram per decilitre)
        XCTAssertEqual(UnitIdentifier.milligramPerDecilitre.rawValue, 0x27B1)
        XCTAssertEqual(UnitIdentifier.milligramPerDecilitre.type, "org.bluetooth.unit.mass_density.milligram_per_decilitre")
        XCTAssertEqual(UnitIdentifier.milligramPerDecilitre.name, "mass density (milligram per decilitre)")
        XCTAssertEqual(UnitIdentifier.milligramPerDecilitre.description, "27B1 (mass density (milligram per decilitre))")

        /// length (metre)
        XCTAssertEqual(UnitIdentifier.metre.rawValue, 0x2701)
        XCTAssertEqual(UnitIdentifier.metre.type, "org.bluetooth.unit.length.metre")
        XCTAssertEqual(UnitIdentifier.metre.name, "length (metre)")
        XCTAssertEqual(UnitIdentifier.metre.description, "2701 (length (metre))")

        /// electric charge density (coulomb per cubic metre)
        XCTAssertEqual(UnitIdentifier.electricChargeDensity.rawValue, 0x274C)
        XCTAssertEqual(UnitIdentifier.electricChargeDensity.type, "org.bluetooth.unit.electric_charge_density.coulomb_per_cubic_metre")
        XCTAssertEqual(UnitIdentifier.electricChargeDensity.name, "electric charge density (coulomb per cubic metre)")
        XCTAssertEqual(UnitIdentifier.electricChargeDensity.description, "274C (electric charge density (coulomb per cubic metre))")

        /// surface charge density (coulomb per square metre)
        XCTAssertEqual(UnitIdentifier.surfaceChargeDensity.rawValue, 0x274D)
        XCTAssertEqual(UnitIdentifier.surfaceChargeDensity.type, "org.bluetooth.unit.surface_charge_density.coulomb_per_square_metre")
        XCTAssertEqual(UnitIdentifier.surfaceChargeDensity.name, "surface charge density (coulomb per square metre)")
        XCTAssertEqual(UnitIdentifier.surfaceChargeDensity.description, "274D (surface charge density (coulomb per square metre))")

        /// magnetic field strength (ampere per metre)
        XCTAssertEqual(UnitIdentifier.magneticFieldStrengh.rawValue, 0x2719)
        XCTAssertEqual(UnitIdentifier.magneticFieldStrengh.type, "org.bluetooth.unit.magnetic_field_strength.ampere_per_metre")
        XCTAssertEqual(UnitIdentifier.magneticFieldStrengh.name, "magnetic field strength (ampere per metre)")
        XCTAssertEqual(UnitIdentifier.magneticFieldStrengh.description, "2719 (magnetic field strength (ampere per metre))")

        /// luminous flux (lumen)
        XCTAssertEqual(UnitIdentifier.luminousFlux.rawValue, 0x2730)
        XCTAssertEqual(UnitIdentifier.luminousFlux.type, "org.bluetooth.unit.luminous_flux.lumen")
        XCTAssertEqual(UnitIdentifier.luminousFlux.name, "luminous flux (lumen)")
        XCTAssertEqual(UnitIdentifier.luminousFlux.description, "2730 (luminous flux (lumen))")

        /// force (newton)
        XCTAssertEqual(UnitIdentifier.force.rawValue, 0x2723)
        XCTAssertEqual(UnitIdentifier.force.type, "org.bluetooth.unit.force.newton")
        XCTAssertEqual(UnitIdentifier.force.name, "force (newton)")
        XCTAssertEqual(UnitIdentifier.force.description, "2723 (force (newton))")

        /// exposure (coulomb per kilogram)
        XCTAssertEqual(UnitIdentifier.exposure.rawValue, 0x2753)
        XCTAssertEqual(UnitIdentifier.exposure.type, "org.bluetooth.unit.exposure.coulomb_per_kilogram")
        XCTAssertEqual(UnitIdentifier.exposure.name, "exposure (coulomb per kilogram)")
        XCTAssertEqual(UnitIdentifier.exposure.description, "2753 (exposure (coulomb per kilogram))")

    }

}
// swiftlint:enable type_body_length
