//
//  DefinedUUIDTests.swift
//  Bluetooth
//
//  Generated by Alsey Coleman Miller on 4/12/18.
//

import XCTest
import Foundation
@testable import Bluetooth

final class DefinedUUIDTests: XCTestCase {

        static let allTests: [(String, (DefinedUUIDTests) -> () -> ())] = {

            var allTests = [(String, (DefinedUUIDTests) -> () -> ())]()

            allTests.append(("testSdp", testSdp))
            allTests.append(("testRfcomm", testRfcomm))
            allTests.append(("testTcsBin", testTcsBin))
            allTests.append(("testAtt", testAtt))
            allTests.append(("testObex", testObex))
            allTests.append(("testBnep", testBnep))
            allTests.append(("testUpnp", testUpnp))
            allTests.append(("testHidp", testHidp))
            allTests.append(("testHardcopyControlChannel", testHardcopyControlChannel))
            allTests.append(("testHardcopyDataChannel", testHardcopyDataChannel))
            allTests.append(("testHardcopyNotification", testHardcopyNotification))
            allTests.append(("testAvctp", testAvctp))
            allTests.append(("testAvdtp", testAvdtp))
            allTests.append(("testCmtp", testCmtp))
            allTests.append(("testMcapControlChannel", testMcapControlChannel))
            allTests.append(("testMcapDataChannel", testMcapDataChannel))
            allTests.append(("testL2Cap", testL2Cap))
            allTests.append(("testServiceDiscoveryServerServiceClass", testServiceDiscoveryServerServiceClass))
            allTests.append(("testBrowseGroupDescriptorServiceClass", testBrowseGroupDescriptorServiceClass))
            allTests.append(("testPublicBrowseRoot", testPublicBrowseRoot))
            allTests.append(("testSerialPort", testSerialPort))
            allTests.append(("testLanAccessUsingPpp", testLanAccessUsingPpp))
            allTests.append(("testDialupNetworking", testDialupNetworking))
            allTests.append(("testIrmcSync", testIrmcSync))
            allTests.append(("testObexObjectPush", testObexObjectPush))
            allTests.append(("testObexFileTransfer", testObexFileTransfer))
            allTests.append(("testIrmcSyncCommand", testIrmcSyncCommand))
            allTests.append(("testHeadset", testHeadset))
            allTests.append(("testCordlessTelephony", testCordlessTelephony))
            allTests.append(("testAudioSource", testAudioSource))
            allTests.append(("testAudioSink", testAudioSink))
            allTests.append(("testAvRemoteControlTarget", testAvRemoteControlTarget))
            allTests.append(("testAdvancedAudioDistribution", testAdvancedAudioDistribution))
            allTests.append(("testAvRemoteControl", testAvRemoteControl))
            allTests.append(("testAvRemoteControlController", testAvRemoteControlController))
            allTests.append(("testIntercom", testIntercom))
            allTests.append(("testFax", testFax))
            allTests.append(("testHeadsetAg", testHeadsetAg))
            allTests.append(("testWap", testWap))
            allTests.append(("testWapClient", testWapClient))
            allTests.append(("testPanu", testPanu))
            allTests.append(("testNap", testNap))
            allTests.append(("testGn", testGn))
            allTests.append(("testDirectPrinting", testDirectPrinting))
            allTests.append(("testReferencePrinting", testReferencePrinting))
            allTests.append(("testBasicImagingProfile", testBasicImagingProfile))
            allTests.append(("testImagingResponder", testImagingResponder))
            allTests.append(("testImagingAutomaticArchive", testImagingAutomaticArchive))
            allTests.append(("testImagingReferencedObjects", testImagingReferencedObjects))
            allTests.append(("testHandsfree", testHandsfree))
            allTests.append(("testHandsfreeAudioGateway", testHandsfreeAudioGateway))
            allTests.append(("testDirectPrintingRefrenceObjectsService", testDirectPrintingRefrenceObjectsService))
            allTests.append(("testReflectedUi", testReflectedUi))
            allTests.append(("testBasicPrinting", testBasicPrinting))
            allTests.append(("testPrintingStatus", testPrintingStatus))
            allTests.append(("testHumanInterfaceDeviceService", testHumanInterfaceDeviceService))
            allTests.append(("testHardcopyCableReplacement", testHardcopyCableReplacement))
            allTests.append(("testHcrPrint", testHcrPrint))
            allTests.append(("testHcrScan", testHcrScan))
            allTests.append(("testCommonIsdnAccess", testCommonIsdnAccess))
            allTests.append(("testSimAccess", testSimAccess))
            allTests.append(("testPhonebookAccessClient", testPhonebookAccessClient))
            allTests.append(("testPhonebookAccessServer", testPhonebookAccessServer))
            allTests.append(("testPhonebookAccess", testPhonebookAccess))
            allTests.append(("testHeadsetHs", testHeadsetHs))
            allTests.append(("testMessageAccessServer", testMessageAccessServer))
            allTests.append(("testMessageNotificationServer", testMessageNotificationServer))
            allTests.append(("testMessageAccessProfile", testMessageAccessProfile))
            allTests.append(("testGnss", testGnss))
            allTests.append(("testGnssServer", testGnssServer))
            allTests.append(("testUuid3Ddisplay", testUuid3Ddisplay))
            allTests.append(("testUuid3Dglasses", testUuid3Dglasses))
            allTests.append(("testUuid3Dsynchronization", testUuid3Dsynchronization))
            allTests.append(("testMpsProfile", testMpsProfile))
            allTests.append(("testMpsService", testMpsService))
            allTests.append(("testPnpInformation", testPnpInformation))
            allTests.append(("testGenericNetworking", testGenericNetworking))
            allTests.append(("testGenericFileTransfer", testGenericFileTransfer))
            allTests.append(("testGenericAudio", testGenericAudio))
            allTests.append(("testGenericTelephony", testGenericTelephony))
            allTests.append(("testUpnpService", testUpnpService))
            allTests.append(("testUpnpIpService", testUpnpIpService))
            allTests.append(("testUpnpIpPan", testUpnpIpPan))
            allTests.append(("testUpnpIpLap", testUpnpIpLap))
            allTests.append(("testUpnpIpL2Cap", testUpnpIpL2Cap))
            allTests.append(("testVideoSource", testVideoSource))
            allTests.append(("testVideoSink", testVideoSink))
            allTests.append(("testVideoDistribution", testVideoDistribution))
            allTests.append(("testHdp", testHdp))
            allTests.append(("testHdpSource", testHdpSource))
            allTests.append(("testHdpSink", testHdpSink))
            allTests.append(("testGenericAccessProfile", testGenericAccessProfile))
            allTests.append(("testGenericAttributeProfile", testGenericAttributeProfile))
            allTests.append(("testImmediateAlert", testImmediateAlert))
            allTests.append(("testLinkLoss", testLinkLoss))
            allTests.append(("testTxPower", testTxPower))
            allTests.append(("testCurrentTimeService", testCurrentTimeService))
            allTests.append(("testReferenceTimeUpdateService", testReferenceTimeUpdateService))
            allTests.append(("testNextDstChangeService", testNextDstChangeService))
            allTests.append(("testGlucose", testGlucose))
            allTests.append(("testHealthThermometer", testHealthThermometer))
            allTests.append(("testDeviceInformation", testDeviceInformation))
            allTests.append(("testHeartRate", testHeartRate))
            allTests.append(("testPhoneAlertStatusService", testPhoneAlertStatusService))
            allTests.append(("testBatteryService", testBatteryService))
            allTests.append(("testBloodPressure", testBloodPressure))
            allTests.append(("testAlertNotificationService", testAlertNotificationService))
            allTests.append(("testHumanInterfaceDevice", testHumanInterfaceDevice))
            allTests.append(("testScanParameters", testScanParameters))
            allTests.append(("testRunningSpeedAndCadence", testRunningSpeedAndCadence))
            allTests.append(("testAutomationIo", testAutomationIo))
            allTests.append(("testCyclingSpeedAndCadence", testCyclingSpeedAndCadence))
            allTests.append(("testCyclingPower", testCyclingPower))
            allTests.append(("testLocationAndNavigation", testLocationAndNavigation))
            allTests.append(("testEnvironmentalSensing", testEnvironmentalSensing))
            allTests.append(("testBodyComposition", testBodyComposition))
            allTests.append(("testUserData", testUserData))
            allTests.append(("testWeightScale", testWeightScale))
            allTests.append(("testBondManagement", testBondManagement))
            allTests.append(("testContinuousGlucoseMonitoring", testContinuousGlucoseMonitoring))
            allTests.append(("testInternetProtocolSupport", testInternetProtocolSupport))
            allTests.append(("testIndoorPositioning", testIndoorPositioning))
            allTests.append(("testPulseOximeter", testPulseOximeter))
            allTests.append(("testHttpProxy", testHttpProxy))
            allTests.append(("testTransportDiscovery", testTransportDiscovery))
            allTests.append(("testObjectTransfer", testObjectTransfer))
            allTests.append(("testPrimaryService", testPrimaryService))
            allTests.append(("testSecondaryService", testSecondaryService))
            allTests.append(("testInclude", testInclude))
            allTests.append(("testCharacteristic", testCharacteristic))
            allTests.append(("testCharacteristicExtendedProperties", testCharacteristicExtendedProperties))
            allTests.append(("testCharacteristicUserDescription", testCharacteristicUserDescription))
            allTests.append(("testClientCharacteristicConfiguration", testClientCharacteristicConfiguration))
            allTests.append(("testServerCharacteristicConfiguration", testServerCharacteristicConfiguration))
            allTests.append(("testCharacteristicFormat", testCharacteristicFormat))
            allTests.append(("testCharacteristicAggregateFormat", testCharacteristicAggregateFormat))
            allTests.append(("testValidRange", testValidRange))
            allTests.append(("testExternalReportReference", testExternalReportReference))
            allTests.append(("testReportReference", testReportReference))
            allTests.append(("testNumberOfDigitals", testNumberOfDigitals))
            allTests.append(("testValueTriggerSetting", testValueTriggerSetting))
            allTests.append(("testEnvironmentalSensingConfiguration", testEnvironmentalSensingConfiguration))
            allTests.append(("testEnvironmentalSensingMeasurement", testEnvironmentalSensingMeasurement))
            allTests.append(("testEnvironmentalSensingTriggerSetting", testEnvironmentalSensingTriggerSetting))
            allTests.append(("testTimeTriggerSetting", testTimeTriggerSetting))
            allTests.append(("testDeviceName", testDeviceName))
            allTests.append(("testAppearance", testAppearance))
            allTests.append(("testPeripheralPrivacyFlag", testPeripheralPrivacyFlag))
            allTests.append(("testReconnectionAddress", testReconnectionAddress))
            allTests.append(("testPeripheralPreferredConnectionParameters", testPeripheralPreferredConnectionParameters))
            allTests.append(("testServiceChanged", testServiceChanged))
            allTests.append(("testAlertLevel", testAlertLevel))
            allTests.append(("testTxPowerLevel", testTxPowerLevel))
            allTests.append(("testDateTime", testDateTime))
            allTests.append(("testDayOfWeek", testDayOfWeek))
            allTests.append(("testDayDateTime", testDayDateTime))
            allTests.append(("testExactTime256", testExactTime256))
            allTests.append(("testDstOffset", testDstOffset))
            allTests.append(("testTimeZone", testTimeZone))
            allTests.append(("testLocalTimeInformation", testLocalTimeInformation))
            allTests.append(("testTimeWithDst", testTimeWithDst))
            allTests.append(("testTimeAccuracy", testTimeAccuracy))
            allTests.append(("testTimeSource", testTimeSource))
            allTests.append(("testReferenceTimeInformation", testReferenceTimeInformation))
            allTests.append(("testTimeUpdateControlPoint", testTimeUpdateControlPoint))
            allTests.append(("testTimeUpdateState", testTimeUpdateState))
            allTests.append(("testGlucoseMeasurement", testGlucoseMeasurement))
            allTests.append(("testBatteryLevel", testBatteryLevel))
            allTests.append(("testTemperatureMeasurement", testTemperatureMeasurement))
            allTests.append(("testTemperatureType", testTemperatureType))
            allTests.append(("testIntermediateTemperature", testIntermediateTemperature))
            allTests.append(("testMeasurementInterval", testMeasurementInterval))
            allTests.append(("testBootKeyboardInputReport", testBootKeyboardInputReport))
            allTests.append(("testSystemId", testSystemId))
            allTests.append(("testModelNumberString", testModelNumberString))
            allTests.append(("testSerialNumberString", testSerialNumberString))
            allTests.append(("testFirmwareRevisionString", testFirmwareRevisionString))
            allTests.append(("testHardwareRevisionString", testHardwareRevisionString))
            allTests.append(("testSoftwareRevisionString", testSoftwareRevisionString))
            allTests.append(("testManufacturerNameString", testManufacturerNameString))
            allTests.append(("testIeee1107320601RegulatoryCertDataList", testIeee1107320601RegulatoryCertDataList))
            allTests.append(("testCurrentTime", testCurrentTime))
            allTests.append(("testMagneticDeclination", testMagneticDeclination))
            allTests.append(("testScanRefresh", testScanRefresh))
            allTests.append(("testBootKeyboardOutputReport", testBootKeyboardOutputReport))
            allTests.append(("testBootMouseInputReport", testBootMouseInputReport))
            allTests.append(("testGlucoseMeasurementContext", testGlucoseMeasurementContext))
            allTests.append(("testBloodPressureMeasurement", testBloodPressureMeasurement))
            allTests.append(("testIntermediateCuffPressure", testIntermediateCuffPressure))
            allTests.append(("testHeartRateMeasurement", testHeartRateMeasurement))
            allTests.append(("testBodySensorLocation", testBodySensorLocation))
            allTests.append(("testHeartRateControlPoint", testHeartRateControlPoint))
            allTests.append(("testAlertStatus", testAlertStatus))
            allTests.append(("testRingerControlPoint", testRingerControlPoint))
            allTests.append(("testRingerSetting", testRingerSetting))
            allTests.append(("testAlertCategoryIdBitMask", testAlertCategoryIdBitMask))
            allTests.append(("testAlertCategoryId", testAlertCategoryId))
            allTests.append(("testAlertNotificationControlPoint", testAlertNotificationControlPoint))
            allTests.append(("testUnreadAlertStatus", testUnreadAlertStatus))
            allTests.append(("testNewAlert", testNewAlert))
            allTests.append(("testSupportedNewAlertCategory", testSupportedNewAlertCategory))
            allTests.append(("testSupportedUnreadAlertCategory", testSupportedUnreadAlertCategory))
            allTests.append(("testBloodPressureFeature", testBloodPressureFeature))
            allTests.append(("testHidInformation", testHidInformation))
            allTests.append(("testReportMap", testReportMap))
            allTests.append(("testHidControlPoint", testHidControlPoint))
            allTests.append(("testReport", testReport))
            allTests.append(("testProtocolMode", testProtocolMode))
            allTests.append(("testScanIntervalWindow", testScanIntervalWindow))
            allTests.append(("testPnpId", testPnpId))
            allTests.append(("testGlucoseFeature", testGlucoseFeature))
            allTests.append(("testRecordAccessControlPoint", testRecordAccessControlPoint))
            allTests.append(("testRscMeasurement", testRscMeasurement))
            allTests.append(("testRscFeature", testRscFeature))
            allTests.append(("testScControlPoint", testScControlPoint))
            allTests.append(("testDigital", testDigital))
            allTests.append(("testAnalog", testAnalog))
            allTests.append(("testAggregate", testAggregate))
            allTests.append(("testCscMeasurement", testCscMeasurement))
            allTests.append(("testCscFeature", testCscFeature))
            allTests.append(("testSensorLocation", testSensorLocation))
            allTests.append(("testCyclingPowerMeasurement", testCyclingPowerMeasurement))
            allTests.append(("testCyclingPowerVector", testCyclingPowerVector))
            allTests.append(("testCyclingPowerFeature", testCyclingPowerFeature))
            allTests.append(("testCyclingPowerControlPoint", testCyclingPowerControlPoint))
            allTests.append(("testLocationAndSpeed", testLocationAndSpeed))
            allTests.append(("testNavigation", testNavigation))
            allTests.append(("testPositionQuality", testPositionQuality))
            allTests.append(("testLnFeature", testLnFeature))
            allTests.append(("testLnControlPoint", testLnControlPoint))
            allTests.append(("testElevation", testElevation))
            allTests.append(("testPressure", testPressure))
            allTests.append(("testTemperature", testTemperature))
            allTests.append(("testHumidity", testHumidity))
            allTests.append(("testTrueWindSpeed", testTrueWindSpeed))
            allTests.append(("testTrueWindDirection", testTrueWindDirection))
            allTests.append(("testApparentWindSpeed", testApparentWindSpeed))
            allTests.append(("testApparentWindDirection", testApparentWindDirection))
            allTests.append(("testGustFactor", testGustFactor))
            allTests.append(("testPollenConcentration", testPollenConcentration))
            allTests.append(("testUvIndex", testUvIndex))
            allTests.append(("testIrradiance", testIrradiance))
            allTests.append(("testRainfall", testRainfall))
            allTests.append(("testWindChill", testWindChill))
            allTests.append(("testHeatIndex", testHeatIndex))
            allTests.append(("testDewPoint", testDewPoint))
            allTests.append(("testTrend", testTrend))
            allTests.append(("testDescriptorValueChanged", testDescriptorValueChanged))
            allTests.append(("testAerobicHeartRateLowerLimit", testAerobicHeartRateLowerLimit))
            allTests.append(("testAerobicThreshold", testAerobicThreshold))
            allTests.append(("testAge", testAge))
            allTests.append(("testAnaerobicHeartRateLowerLimit", testAnaerobicHeartRateLowerLimit))
            allTests.append(("testAnaerobicHeartRateUpperLimit", testAnaerobicHeartRateUpperLimit))
            allTests.append(("testAnaerobicThreshold", testAnaerobicThreshold))
            allTests.append(("testAerobicHeartRateUpperLimit", testAerobicHeartRateUpperLimit))
            allTests.append(("testDateOfBirth", testDateOfBirth))
            allTests.append(("testDateOfThresholdAssessment", testDateOfThresholdAssessment))
            allTests.append(("testEmailAddress", testEmailAddress))
            allTests.append(("testFatBurnHeartRateLowerLimit", testFatBurnHeartRateLowerLimit))
            allTests.append(("testFatBurnHeartRateUpperLimit", testFatBurnHeartRateUpperLimit))
            allTests.append(("testFirstName", testFirstName))
            allTests.append(("testFiveZoneHeartRateLimits", testFiveZoneHeartRateLimits))
            allTests.append(("testGender", testGender))
            allTests.append(("testHeartRateMax", testHeartRateMax))
            allTests.append(("testHeight", testHeight))
            allTests.append(("testHipCircumference", testHipCircumference))
            allTests.append(("testLastName", testLastName))
            allTests.append(("testMaximumRecommendedHeartRate", testMaximumRecommendedHeartRate))
            allTests.append(("testRestingHeartRate", testRestingHeartRate))
            allTests.append(("testSportTypeForAerobicAnaerobicThresholds", testSportTypeForAerobicAnaerobicThresholds))
            allTests.append(("testThreeZoneHeartRateLimits", testThreeZoneHeartRateLimits))
            allTests.append(("testTwoZoneHeartRateLimit", testTwoZoneHeartRateLimit))
            allTests.append(("testVo2Max", testVo2Max))
            allTests.append(("testWaistCircumference", testWaistCircumference))
            allTests.append(("testWeight", testWeight))
            allTests.append(("testDatabaseChangerement", testDatabaseChangerement))
            allTests.append(("testUserIndex", testUserIndex))
            allTests.append(("testBodyCompositionFeature", testBodyCompositionFeature))
            allTests.append(("testBodyCompositionMeasurement", testBodyCompositionMeasurement))
            allTests.append(("testWeightMeasurement", testWeightMeasurement))
            allTests.append(("testWeightScaleFeature", testWeightScaleFeature))
            allTests.append(("testUserControlPoint", testUserControlPoint))
            allTests.append(("testMagneticFluxDensity2D", testMagneticFluxDensity2D))
            allTests.append(("testMagneticFluxDensity3D", testMagneticFluxDensity3D))
            allTests.append(("testLanguage", testLanguage))
            allTests.append(("testBarometricPressureTrend", testBarometricPressureTrend))
            allTests.append(("testBondManagementControlPoint", testBondManagementControlPoint))
            allTests.append(("testBondManagementFeature", testBondManagementFeature))
            allTests.append(("testCentralAddressResolution", testCentralAddressResolution))
            allTests.append(("testCgmMeasurement", testCgmMeasurement))
            allTests.append(("testCgmFeature", testCgmFeature))
            allTests.append(("testCgmStatus", testCgmStatus))
            allTests.append(("testCgmSessionStartTime", testCgmSessionStartTime))
            allTests.append(("testCgmSessionRunTime", testCgmSessionRunTime))
            allTests.append(("testCgmSpecificOpsControlPoint", testCgmSpecificOpsControlPoint))
            allTests.append(("testIndoorPositioningConfiguration", testIndoorPositioningConfiguration))
            allTests.append(("testLatitude", testLatitude))
            allTests.append(("testLongitude", testLongitude))
            allTests.append(("testLocalNorthCoordinate", testLocalNorthCoordinate))
            allTests.append(("testLocalEastCoordinate", testLocalEastCoordinate))
            allTests.append(("testFloorNumber", testFloorNumber))
            allTests.append(("testAltitude", testAltitude))
            allTests.append(("testUncertainty", testUncertainty))
            allTests.append(("testLocationName", testLocationName))
            allTests.append(("testUri", testUri))
            allTests.append(("testHttpHeaders", testHttpHeaders))
            allTests.append(("testHttpStatusCode", testHttpStatusCode))
            allTests.append(("testHttpEntityBody", testHttpEntityBody))
            allTests.append(("testHttpControlPoint", testHttpControlPoint))
            allTests.append(("testHttpsSecurity", testHttpsSecurity))
            allTests.append(("testTdsControlPoint", testTdsControlPoint))
            allTests.append(("testOtsFeature", testOtsFeature))
            allTests.append(("testObjectName", testObjectName))
            allTests.append(("testObjectType", testObjectType))
            allTests.append(("testObjectSize", testObjectSize))
            allTests.append(("testObjectFirstCreated", testObjectFirstCreated))
            allTests.append(("testObjectLastModified", testObjectLastModified))
            allTests.append(("testObjectId", testObjectId))
            allTests.append(("testObjectProperties", testObjectProperties))
            allTests.append(("testObjectActionControlPoint", testObjectActionControlPoint))
            allTests.append(("testObjectListControlPoint", testObjectListControlPoint))
            allTests.append(("testObjectListFilter", testObjectListFilter))
            allTests.append(("testObjectChanged", testObjectChanged))
            allTests.append(("testIntelCorporation", testIntelCorporation))
            allTests.append(("testLabSensorSolutions", testLabSensorSolutions))
            allTests.append(("testQualcommLife", testQualcommLife))
            allTests.append(("testQualcommLife2", testQualcommLife2))
            allTests.append(("testKontaktMicroLocation", testKontaktMicroLocation))
            allTests.append(("testTaserInternational", testTaserInternational))
            allTests.append(("testTaserInternational2", testTaserInternational2))
            allTests.append(("testUniversityOfTokyo", testUniversityOfTokyo))
            allTests.append(("testUniversityOfTokyo2", testUniversityOfTokyo2))
            allTests.append(("testLineCorporation", testLineCorporation))
            allTests.append(("testBeijingJingdongCenturyTrading", testBeijingJingdongCenturyTrading))
            allTests.append(("testPlumeDesign", testPlumeDesign))
            allTests.append(("testStJudeMedical", testStJudeMedical))
            allTests.append(("testStJudeMedical2", testStJudeMedical2))
            allTests.append(("testUnwire", testUnwire))
            allTests.append(("testTangome", testTangome))
            allTests.append(("testTangome2", testTangome2))
            allTests.append(("testHewlettPackardCompany", testHewlettPackardCompany))
            allTests.append(("testHewlettPackardCompany2", testHewlettPackardCompany2))
            allTests.append(("testZebraTechnologies", testZebraTechnologies))
            allTests.append(("testBragiGmbh", testBragiGmbh))
            allTests.append(("testOrionLabs", testOrionLabs))
            allTests.append(("testStollmannEVGmbh", testStollmannEVGmbh))
            allTests.append(("testAtericaHealth", testAtericaHealth))
            allTests.append(("testAwearSolutions", testAwearSolutions))
            allTests.append(("testDopplerLab", testDopplerLab))
            allTests.append(("testDopplerLab2", testDopplerLab2))
            allTests.append(("testMedtronic", testMedtronic))
            allTests.append(("testMedtronic2", testMedtronic2))
            allTests.append(("testBlueBite", testBlueBite))
            allTests.append(("testRfDigitalCorp", testRfDigitalCorp))
            allTests.append(("testRfDigitalCorp2", testRfDigitalCorp2))
            allTests.append(("testHuaweiTechnologies华为技术有限公司", testHuaweiTechnologies华为技术有限公司))
            allTests.append(("testQingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司", testQingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司))
            allTests.append(("testSaltoSystemsSL", testSaltoSystemsSL))
            allTests.append(("testBOPlayAS", testBOPlayAS))
            allTests.append(("testApple", testApple))
            allTests.append(("testApple2", testApple2))
            allTests.append(("testTronForum", testTronForum))
            allTests.append(("testInteraxon", testInteraxon))
            allTests.append(("testArm", testArm))
            allTests.append(("testCsr", testCsr))
            allTests.append(("testJuma", testJuma))
            allTests.append(("testShanghaiImilabTechnology", testShanghaiImilabTechnology))
            allTests.append(("testJardenSafetySecurity", testJardenSafetySecurity))
            allTests.append(("testOttoq", testOttoq))
            allTests.append(("testOttoq2", testOttoq2))
            allTests.append(("testXiaomi", testXiaomi))
            allTests.append(("testTeslaMotor", testTeslaMotor))
            allTests.append(("testTeslaMotor2", testTeslaMotor2))
            allTests.append(("testCurrant", testCurrant))
            allTests.append(("testCurrant2", testCurrant2))
            allTests.append(("testEstimote", testEstimote))
            allTests.append(("testSamsaraNetworks", testSamsaraNetworks))
            allTests.append(("testGsiLaboratories", testGsiLaboratories))
            allTests.append(("testMobiquityNetworks", testMobiquityNetworks))
            allTests.append(("testDialogSemiconductorBV", testDialogSemiconductorBV))
            allTests.append(("testGoogle", testGoogle))
            allTests.append(("testGoogle2", testGoogle2))
            allTests.append(("testIntrepidControlSystems", testIntrepidControlSystems))
            allTests.append(("testIntrepidControlSystems2", testIntrepidControlSystems2))
            allTests.append(("testIttIndustries", testIttIndustries))
            allTests.append(("testPaxtonAccess", testPaxtonAccess))
            allTests.append(("testGopro", testGopro))
            allTests.append(("testGopro2", testGopro2))
            allTests.append(("testUtcFireAndSecurity", testUtcFireAndSecurity))
            allTests.append(("testSavantSystems", testSavantSystems))
            allTests.append(("testSavantSystems2", testSavantSystems2))
            allTests.append(("testGoogle3", testGoogle3))
            allTests.append(("testNokiaCorporation", testNokiaCorporation))
            allTests.append(("testNokiaCorporation2", testNokiaCorporation2))
            allTests.append(("testNokiaCorporation3", testNokiaCorporation3))
            allTests.append(("testNokiaCorporation4", testNokiaCorporation4))
            allTests.append(("testNestLabs", testNestLabs))
            allTests.append(("testNestLabs2", testNestLabs2))
            allTests.append(("testElectronicsTomorrowLimited", testElectronicsTomorrowLimited))
            allTests.append(("testMicrosoftCorporation", testMicrosoftCorporation))
            allTests.append(("testTaobao", testTaobao))
            allTests.append(("testWisilica", testWisilica))
            allTests.append(("testWisilica2", testWisilica2))
            allTests.append(("testVencerCo", testVencerCo))
            allTests.append(("testFacebook", testFacebook))
            allTests.append(("testFacebook2", testFacebook2))
            allTests.append(("testLgElectronics", testLgElectronics))
            allTests.append(("testTencentHoldingsLimited", testTencentHoldingsLimited))
            allTests.append(("testAdafruitIndustries", testAdafruitIndustries))
            allTests.append(("testDexcom", testDexcom))
            allTests.append(("testCloverNetwork", testCloverNetwork))
            allTests.append(("testBoseCorporation", testBoseCorporation))
            allTests.append(("testNod", testNod))
            allTests.append(("testKddiCorporation", testKddiCorporation))
            allTests.append(("testKddiCorporation2", testKddiCorporation2))
            allTests.append(("testBlueSparkTechnologies", testBlueSparkTechnologies))
            allTests.append(("testUuid360Fly", testUuid360Fly))
            allTests.append(("testPlusLocationSystems", testPlusLocationSystems))
            allTests.append(("testRealtekSemiconductorCorp", testRealtekSemiconductorCorp))
            allTests.append(("testKocomojo", testKocomojo))
            allTests.append(("testApple3", testApple3))
            allTests.append(("testApple4", testApple4))
            allTests.append(("testApple5", testApple5))
            allTests.append(("testApple6", testApple6))
            allTests.append(("testApple7", testApple7))
            allTests.append(("testApple8", testApple8))
            allTests.append(("testApple9", testApple9))
            allTests.append(("testApple10", testApple10))
            allTests.append(("testApple11", testApple11))
            allTests.append(("testApple12", testApple12))
            allTests.append(("testApple13", testApple13))
            allTests.append(("testApple14", testApple14))
            allTests.append(("testApple15", testApple15))
            allTests.append(("testApple16", testApple16))
            allTests.append(("testPlantronics", testPlantronics))
            allTests.append(("testBroadcomCorporation", testBroadcomCorporation))
            allTests.append(("testBroadcomCorporation2", testBroadcomCorporation2))
            allTests.append(("testGoogle4", testGoogle4))
            allTests.append(("testPebbleTechnologyCorporation", testPebbleTechnologyCorporation))
            allTests.append(("testIsscTechnologiesCorporation", testIsscTechnologiesCorporation))
            allTests.append(("testPerka", testPerka))
            allTests.append(("testJawbone", testJawbone))
            allTests.append(("testJawbone2", testJawbone2))
            allTests.append(("testCoin", testCoin))
            allTests.append(("testDesignShift", testDesignShift))
            allTests.append(("testAnhuiHuamiInformationTechnologyCo", testAnhuiHuamiInformationTechnologyCo))
            allTests.append(("testAnhuiHuamiInformationTechnologyCo2", testAnhuiHuamiInformationTechnologyCo2))
            allTests.append(("testAnki", testAnki))
            allTests.append(("testAnki2", testAnki2))
            allTests.append(("testNordicSemiconductorAsa", testNordicSemiconductorAsa))
            allTests.append(("testNordicSemiconductorAsa2", testNordicSemiconductorAsa2))
            allTests.append(("testSeedLabs", testSeedLabs))
            allTests.append(("testTencentHoldingsLimited2", testTencentHoldingsLimited2))
            allTests.append(("testQuinticCorp", testQuinticCorp))
            allTests.append(("testQuinticCorp2", testQuinticCorp2))
            allTests.append(("testSwirlNetworks", testSwirlNetworks))
            allTests.append(("testSwirlNetworks2", testSwirlNetworks2))
            allTests.append(("testTile", testTile))
            allTests.append(("testTile2", testTile2))
            allTests.append(("testPolarElectroOy", testPolarElectroOy))
            allTests.append(("testPolarElectroOy2", testPolarElectroOy2))
            allTests.append(("testIntel", testIntel))
            allTests.append(("testCsr2", testCsr2))
            allTests.append(("testCsr3", testCsr3))
            allTests.append(("testGoogle5", testGoogle5))
            allTests.append(("testGoogle6", testGoogle6))
            allTests.append(("testDialogSemiconductorGmbh", testDialogSemiconductorGmbh))
            allTests.append(("testWicentric", testWicentric))
            allTests.append(("testAplixCorporation", testAplixCorporation))
            allTests.append(("testAplixCorporation2", testAplixCorporation2))
            allTests.append(("testPaypal", testPaypal))
            allTests.append(("testPaypal2", testPaypal2))
            allTests.append(("testStollmannEVGmbh2", testStollmannEVGmbh2))
            allTests.append(("testGimbal", testGimbal))
            allTests.append(("testGimbal2", testGimbal2))
            allTests.append(("testGnResoundAS", testGnResoundAS))
            allTests.append(("testGnNetcom", testGnNetcom))
            allTests.append(("testFastIdentityOnlineAllianceFido", testFastIdentityOnlineAllianceFido))
            allTests.append(("testAllianceForWirelessPowerA4Wp", testAllianceForWirelessPowerA4Wp))

            return allTests
        }()

    /// Test SDP
    func testSdp() {

         XCTAssertEqual(BluetoothUUID.sdp.rawValue, "0001")
         XCTAssertEqual(BluetoothUUID.sdp, .bit16(0x0001))
         XCTAssertEqual(BluetoothUUID.sdp, .bit16(1))
         XCTAssertEqual(BluetoothUUID.sdp.name, "SDP")
         XCTAssertNotEqual(BluetoothUUID.sdp, .bit32(1))
         XCTAssertNotEqual(BluetoothUUID.sdp, .bit32(0x0001))

    }

    /// Test RFCOMM
    func testRfcomm() {

         XCTAssertEqual(BluetoothUUID.rfcomm.rawValue, "0003")
         XCTAssertEqual(BluetoothUUID.rfcomm, .bit16(0x0003))
         XCTAssertEqual(BluetoothUUID.rfcomm, .bit16(3))
         XCTAssertEqual(BluetoothUUID.rfcomm.name, "RFCOMM")
         XCTAssertNotEqual(BluetoothUUID.rfcomm, .bit32(3))
         XCTAssertNotEqual(BluetoothUUID.rfcomm, .bit32(0x0003))

    }

    /// Test TCS-BIN
    func testTcsBin() {

         XCTAssertEqual(BluetoothUUID.tcsBin.rawValue, "0005")
         XCTAssertEqual(BluetoothUUID.tcsBin, .bit16(0x0005))
         XCTAssertEqual(BluetoothUUID.tcsBin, .bit16(5))
         XCTAssertEqual(BluetoothUUID.tcsBin.name, "TCS-BIN")
         XCTAssertNotEqual(BluetoothUUID.tcsBin, .bit32(5))
         XCTAssertNotEqual(BluetoothUUID.tcsBin, .bit32(0x0005))

    }

    /// Test ATT
    func testAtt() {

         XCTAssertEqual(BluetoothUUID.att.rawValue, "0007")
         XCTAssertEqual(BluetoothUUID.att, .bit16(0x0007))
         XCTAssertEqual(BluetoothUUID.att, .bit16(7))
         XCTAssertEqual(BluetoothUUID.att.name, "ATT")
         XCTAssertNotEqual(BluetoothUUID.att, .bit32(7))
         XCTAssertNotEqual(BluetoothUUID.att, .bit32(0x0007))

    }

    /// Test OBEX
    func testObex() {

         XCTAssertEqual(BluetoothUUID.obex.rawValue, "0008")
         XCTAssertEqual(BluetoothUUID.obex, .bit16(0x0008))
         XCTAssertEqual(BluetoothUUID.obex, .bit16(8))
         XCTAssertEqual(BluetoothUUID.obex.name, "OBEX")
         XCTAssertNotEqual(BluetoothUUID.obex, .bit32(8))
         XCTAssertNotEqual(BluetoothUUID.obex, .bit32(0x0008))

    }

    /// Test BNEP
    func testBnep() {

         XCTAssertEqual(BluetoothUUID.bnep.rawValue, "000F")
         XCTAssertEqual(BluetoothUUID.bnep, .bit16(0x000F))
         XCTAssertEqual(BluetoothUUID.bnep, .bit16(15))
         XCTAssertEqual(BluetoothUUID.bnep.name, "BNEP")
         XCTAssertNotEqual(BluetoothUUID.bnep, .bit32(15))
         XCTAssertNotEqual(BluetoothUUID.bnep, .bit32(0x000F))

    }

    /// Test UPNP
    func testUpnp() {

         XCTAssertEqual(BluetoothUUID.upnp.rawValue, "0010")
         XCTAssertEqual(BluetoothUUID.upnp, .bit16(0x0010))
         XCTAssertEqual(BluetoothUUID.upnp, .bit16(16))
         XCTAssertEqual(BluetoothUUID.upnp.name, "UPNP")
         XCTAssertNotEqual(BluetoothUUID.upnp, .bit32(16))
         XCTAssertNotEqual(BluetoothUUID.upnp, .bit32(0x0010))

    }

    /// Test HIDP
    func testHidp() {

         XCTAssertEqual(BluetoothUUID.hidp.rawValue, "0011")
         XCTAssertEqual(BluetoothUUID.hidp, .bit16(0x0011))
         XCTAssertEqual(BluetoothUUID.hidp, .bit16(17))
         XCTAssertEqual(BluetoothUUID.hidp.name, "HIDP")
         XCTAssertNotEqual(BluetoothUUID.hidp, .bit32(17))
         XCTAssertNotEqual(BluetoothUUID.hidp, .bit32(0x0011))

    }

    /// Test Hardcopy Control Channel
    func testHardcopyControlChannel() {

         XCTAssertEqual(BluetoothUUID.hardcopyControlChannel.rawValue, "0012")
         XCTAssertEqual(BluetoothUUID.hardcopyControlChannel, .bit16(0x0012))
         XCTAssertEqual(BluetoothUUID.hardcopyControlChannel, .bit16(18))
         XCTAssertEqual(BluetoothUUID.hardcopyControlChannel.name, "Hardcopy Control Channel")
         XCTAssertNotEqual(BluetoothUUID.hardcopyControlChannel, .bit32(18))
         XCTAssertNotEqual(BluetoothUUID.hardcopyControlChannel, .bit32(0x0012))

    }

    /// Test Hardcopy Data Channel
    func testHardcopyDataChannel() {

         XCTAssertEqual(BluetoothUUID.hardcopyDataChannel.rawValue, "0014")
         XCTAssertEqual(BluetoothUUID.hardcopyDataChannel, .bit16(0x0014))
         XCTAssertEqual(BluetoothUUID.hardcopyDataChannel, .bit16(20))
         XCTAssertEqual(BluetoothUUID.hardcopyDataChannel.name, "Hardcopy Data Channel")
         XCTAssertNotEqual(BluetoothUUID.hardcopyDataChannel, .bit32(20))
         XCTAssertNotEqual(BluetoothUUID.hardcopyDataChannel, .bit32(0x0014))

    }

    /// Test Hardcopy Notification
    func testHardcopyNotification() {

         XCTAssertEqual(BluetoothUUID.hardcopyNotification.rawValue, "0016")
         XCTAssertEqual(BluetoothUUID.hardcopyNotification, .bit16(0x0016))
         XCTAssertEqual(BluetoothUUID.hardcopyNotification, .bit16(22))
         XCTAssertEqual(BluetoothUUID.hardcopyNotification.name, "Hardcopy Notification")
         XCTAssertNotEqual(BluetoothUUID.hardcopyNotification, .bit32(22))
         XCTAssertNotEqual(BluetoothUUID.hardcopyNotification, .bit32(0x0016))

    }

    /// Test AVCTP
    func testAvctp() {

         XCTAssertEqual(BluetoothUUID.avctp.rawValue, "0017")
         XCTAssertEqual(BluetoothUUID.avctp, .bit16(0x0017))
         XCTAssertEqual(BluetoothUUID.avctp, .bit16(23))
         XCTAssertEqual(BluetoothUUID.avctp.name, "AVCTP")
         XCTAssertNotEqual(BluetoothUUID.avctp, .bit32(23))
         XCTAssertNotEqual(BluetoothUUID.avctp, .bit32(0x0017))

    }

    /// Test AVDTP
    func testAvdtp() {

         XCTAssertEqual(BluetoothUUID.avdtp.rawValue, "0019")
         XCTAssertEqual(BluetoothUUID.avdtp, .bit16(0x0019))
         XCTAssertEqual(BluetoothUUID.avdtp, .bit16(25))
         XCTAssertEqual(BluetoothUUID.avdtp.name, "AVDTP")
         XCTAssertNotEqual(BluetoothUUID.avdtp, .bit32(25))
         XCTAssertNotEqual(BluetoothUUID.avdtp, .bit32(0x0019))

    }

    /// Test CMTP
    func testCmtp() {

         XCTAssertEqual(BluetoothUUID.cmtp.rawValue, "001B")
         XCTAssertEqual(BluetoothUUID.cmtp, .bit16(0x001B))
         XCTAssertEqual(BluetoothUUID.cmtp, .bit16(27))
         XCTAssertEqual(BluetoothUUID.cmtp.name, "CMTP")
         XCTAssertNotEqual(BluetoothUUID.cmtp, .bit32(27))
         XCTAssertNotEqual(BluetoothUUID.cmtp, .bit32(0x001B))

    }

    /// Test MCAP Control Channel
    func testMcapControlChannel() {

         XCTAssertEqual(BluetoothUUID.mcapControlChannel.rawValue, "001E")
         XCTAssertEqual(BluetoothUUID.mcapControlChannel, .bit16(0x001E))
         XCTAssertEqual(BluetoothUUID.mcapControlChannel, .bit16(30))
         XCTAssertEqual(BluetoothUUID.mcapControlChannel.name, "MCAP Control Channel")
         XCTAssertNotEqual(BluetoothUUID.mcapControlChannel, .bit32(30))
         XCTAssertNotEqual(BluetoothUUID.mcapControlChannel, .bit32(0x001E))

    }

    /// Test MCAP Data Channel
    func testMcapDataChannel() {

         XCTAssertEqual(BluetoothUUID.mcapDataChannel.rawValue, "001F")
         XCTAssertEqual(BluetoothUUID.mcapDataChannel, .bit16(0x001F))
         XCTAssertEqual(BluetoothUUID.mcapDataChannel, .bit16(31))
         XCTAssertEqual(BluetoothUUID.mcapDataChannel.name, "MCAP Data Channel")
         XCTAssertNotEqual(BluetoothUUID.mcapDataChannel, .bit32(31))
         XCTAssertNotEqual(BluetoothUUID.mcapDataChannel, .bit32(0x001F))

    }

    /// Test L2CAP
    func testL2Cap() {

         XCTAssertEqual(BluetoothUUID.l2Cap.rawValue, "0100")
         XCTAssertEqual(BluetoothUUID.l2Cap, .bit16(0x0100))
         XCTAssertEqual(BluetoothUUID.l2Cap, .bit16(256))
         XCTAssertEqual(BluetoothUUID.l2Cap.name, "L2CAP")
         XCTAssertNotEqual(BluetoothUUID.l2Cap, .bit32(256))
         XCTAssertNotEqual(BluetoothUUID.l2Cap, .bit32(0x0100))

    }

    /// Test Service Discovery Server Service Class
    func testServiceDiscoveryServerServiceClass() {

         XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass.rawValue, "1000")
         XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit16(0x1000))
         XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit16(4096))
         XCTAssertEqual(BluetoothUUID.serviceDiscoveryServerServiceClass.name, "Service Discovery Server Service Class")
         XCTAssertNotEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit32(4096))
         XCTAssertNotEqual(BluetoothUUID.serviceDiscoveryServerServiceClass, .bit32(0x1000))

    }

    /// Test Browse Group Descriptor Service Class
    func testBrowseGroupDescriptorServiceClass() {

         XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass.rawValue, "1001")
         XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit16(0x1001))
         XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit16(4097))
         XCTAssertEqual(BluetoothUUID.browseGroupDescriptorServiceClass.name, "Browse Group Descriptor Service Class")
         XCTAssertNotEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit32(4097))
         XCTAssertNotEqual(BluetoothUUID.browseGroupDescriptorServiceClass, .bit32(0x1001))

    }

    /// Test Public Browse Root
    func testPublicBrowseRoot() {

         XCTAssertEqual(BluetoothUUID.publicBrowseRoot.rawValue, "1002")
         XCTAssertEqual(BluetoothUUID.publicBrowseRoot, .bit16(0x1002))
         XCTAssertEqual(BluetoothUUID.publicBrowseRoot, .bit16(4098))
         XCTAssertEqual(BluetoothUUID.publicBrowseRoot.name, "Public Browse Root")
         XCTAssertNotEqual(BluetoothUUID.publicBrowseRoot, .bit32(4098))
         XCTAssertNotEqual(BluetoothUUID.publicBrowseRoot, .bit32(0x1002))

    }

    /// Test Serial Port
    func testSerialPort() {

         XCTAssertEqual(BluetoothUUID.serialPort.rawValue, "1101")
         XCTAssertEqual(BluetoothUUID.serialPort, .bit16(0x1101))
         XCTAssertEqual(BluetoothUUID.serialPort, .bit16(4353))
         XCTAssertEqual(BluetoothUUID.serialPort.name, "Serial Port")
         XCTAssertNotEqual(BluetoothUUID.serialPort, .bit32(4353))
         XCTAssertNotEqual(BluetoothUUID.serialPort, .bit32(0x1101))

    }

    /// Test LAN Access Using PPP
    func testLanAccessUsingPpp() {

         XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp.rawValue, "1102")
         XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp, .bit16(0x1102))
         XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp, .bit16(4354))
         XCTAssertEqual(BluetoothUUID.lanAccessUsingPpp.name, "LAN Access Using PPP")
         XCTAssertNotEqual(BluetoothUUID.lanAccessUsingPpp, .bit32(4354))
         XCTAssertNotEqual(BluetoothUUID.lanAccessUsingPpp, .bit32(0x1102))

    }

    /// Test Dialup Networking
    func testDialupNetworking() {

         XCTAssertEqual(BluetoothUUID.dialupNetworking.rawValue, "1103")
         XCTAssertEqual(BluetoothUUID.dialupNetworking, .bit16(0x1103))
         XCTAssertEqual(BluetoothUUID.dialupNetworking, .bit16(4355))
         XCTAssertEqual(BluetoothUUID.dialupNetworking.name, "Dialup Networking")
         XCTAssertNotEqual(BluetoothUUID.dialupNetworking, .bit32(4355))
         XCTAssertNotEqual(BluetoothUUID.dialupNetworking, .bit32(0x1103))

    }

    /// Test IrMC Sync
    func testIrmcSync() {

         XCTAssertEqual(BluetoothUUID.irmcSync.rawValue, "1104")
         XCTAssertEqual(BluetoothUUID.irmcSync, .bit16(0x1104))
         XCTAssertEqual(BluetoothUUID.irmcSync, .bit16(4356))
         XCTAssertEqual(BluetoothUUID.irmcSync.name, "IrMC Sync")
         XCTAssertNotEqual(BluetoothUUID.irmcSync, .bit32(4356))
         XCTAssertNotEqual(BluetoothUUID.irmcSync, .bit32(0x1104))

    }

    /// Test OBEX Object Push
    func testObexObjectPush() {

         XCTAssertEqual(BluetoothUUID.obexObjectPush.rawValue, "1105")
         XCTAssertEqual(BluetoothUUID.obexObjectPush, .bit16(0x1105))
         XCTAssertEqual(BluetoothUUID.obexObjectPush, .bit16(4357))
         XCTAssertEqual(BluetoothUUID.obexObjectPush.name, "OBEX Object Push")
         XCTAssertNotEqual(BluetoothUUID.obexObjectPush, .bit32(4357))
         XCTAssertNotEqual(BluetoothUUID.obexObjectPush, .bit32(0x1105))

    }

    /// Test OBEX File Transfer
    func testObexFileTransfer() {

         XCTAssertEqual(BluetoothUUID.obexFileTransfer.rawValue, "1106")
         XCTAssertEqual(BluetoothUUID.obexFileTransfer, .bit16(0x1106))
         XCTAssertEqual(BluetoothUUID.obexFileTransfer, .bit16(4358))
         XCTAssertEqual(BluetoothUUID.obexFileTransfer.name, "OBEX File Transfer")
         XCTAssertNotEqual(BluetoothUUID.obexFileTransfer, .bit32(4358))
         XCTAssertNotEqual(BluetoothUUID.obexFileTransfer, .bit32(0x1106))

    }

    /// Test IrMC Sync Command
    func testIrmcSyncCommand() {

         XCTAssertEqual(BluetoothUUID.irmcSyncCommand.rawValue, "1107")
         XCTAssertEqual(BluetoothUUID.irmcSyncCommand, .bit16(0x1107))
         XCTAssertEqual(BluetoothUUID.irmcSyncCommand, .bit16(4359))
         XCTAssertEqual(BluetoothUUID.irmcSyncCommand.name, "IrMC Sync Command")
         XCTAssertNotEqual(BluetoothUUID.irmcSyncCommand, .bit32(4359))
         XCTAssertNotEqual(BluetoothUUID.irmcSyncCommand, .bit32(0x1107))

    }

    /// Test Headset
    func testHeadset() {

         XCTAssertEqual(BluetoothUUID.headset.rawValue, "1108")
         XCTAssertEqual(BluetoothUUID.headset, .bit16(0x1108))
         XCTAssertEqual(BluetoothUUID.headset, .bit16(4360))
         XCTAssertEqual(BluetoothUUID.headset.name, "Headset")
         XCTAssertNotEqual(BluetoothUUID.headset, .bit32(4360))
         XCTAssertNotEqual(BluetoothUUID.headset, .bit32(0x1108))

    }

    /// Test Cordless Telephony
    func testCordlessTelephony() {

         XCTAssertEqual(BluetoothUUID.cordlessTelephony.rawValue, "1109")
         XCTAssertEqual(BluetoothUUID.cordlessTelephony, .bit16(0x1109))
         XCTAssertEqual(BluetoothUUID.cordlessTelephony, .bit16(4361))
         XCTAssertEqual(BluetoothUUID.cordlessTelephony.name, "Cordless Telephony")
         XCTAssertNotEqual(BluetoothUUID.cordlessTelephony, .bit32(4361))
         XCTAssertNotEqual(BluetoothUUID.cordlessTelephony, .bit32(0x1109))

    }

    /// Test Audio Source
    func testAudioSource() {

         XCTAssertEqual(BluetoothUUID.audioSource.rawValue, "110A")
         XCTAssertEqual(BluetoothUUID.audioSource, .bit16(0x110A))
         XCTAssertEqual(BluetoothUUID.audioSource, .bit16(4362))
         XCTAssertEqual(BluetoothUUID.audioSource.name, "Audio Source")
         XCTAssertNotEqual(BluetoothUUID.audioSource, .bit32(4362))
         XCTAssertNotEqual(BluetoothUUID.audioSource, .bit32(0x110A))

    }

    /// Test Audio Sink
    func testAudioSink() {

         XCTAssertEqual(BluetoothUUID.audioSink.rawValue, "110B")
         XCTAssertEqual(BluetoothUUID.audioSink, .bit16(0x110B))
         XCTAssertEqual(BluetoothUUID.audioSink, .bit16(4363))
         XCTAssertEqual(BluetoothUUID.audioSink.name, "Audio Sink")
         XCTAssertNotEqual(BluetoothUUID.audioSink, .bit32(4363))
         XCTAssertNotEqual(BluetoothUUID.audioSink, .bit32(0x110B))

    }

    /// Test A/V Remote Control Target
    func testAvRemoteControlTarget() {

         XCTAssertEqual(BluetoothUUID.avRemoteControlTarget.rawValue, "110C")
         XCTAssertEqual(BluetoothUUID.avRemoteControlTarget, .bit16(0x110C))
         XCTAssertEqual(BluetoothUUID.avRemoteControlTarget, .bit16(4364))
         XCTAssertEqual(BluetoothUUID.avRemoteControlTarget.name, "A/V Remote Control Target")
         XCTAssertNotEqual(BluetoothUUID.avRemoteControlTarget, .bit32(4364))
         XCTAssertNotEqual(BluetoothUUID.avRemoteControlTarget, .bit32(0x110C))

    }

    /// Test Advanced Audio Distribution
    func testAdvancedAudioDistribution() {

         XCTAssertEqual(BluetoothUUID.advancedAudioDistribution.rawValue, "110D")
         XCTAssertEqual(BluetoothUUID.advancedAudioDistribution, .bit16(0x110D))
         XCTAssertEqual(BluetoothUUID.advancedAudioDistribution, .bit16(4365))
         XCTAssertEqual(BluetoothUUID.advancedAudioDistribution.name, "Advanced Audio Distribution")
         XCTAssertNotEqual(BluetoothUUID.advancedAudioDistribution, .bit32(4365))
         XCTAssertNotEqual(BluetoothUUID.advancedAudioDistribution, .bit32(0x110D))

    }

    /// Test A/V Remote Control
    func testAvRemoteControl() {

         XCTAssertEqual(BluetoothUUID.avRemoteControl.rawValue, "110E")
         XCTAssertEqual(BluetoothUUID.avRemoteControl, .bit16(0x110E))
         XCTAssertEqual(BluetoothUUID.avRemoteControl, .bit16(4366))
         XCTAssertEqual(BluetoothUUID.avRemoteControl.name, "A/V Remote Control")
         XCTAssertNotEqual(BluetoothUUID.avRemoteControl, .bit32(4366))
         XCTAssertNotEqual(BluetoothUUID.avRemoteControl, .bit32(0x110E))

    }

    /// Test A/V Remote Control Controller
    func testAvRemoteControlController() {

         XCTAssertEqual(BluetoothUUID.avRemoteControlController.rawValue, "110F")
         XCTAssertEqual(BluetoothUUID.avRemoteControlController, .bit16(0x110F))
         XCTAssertEqual(BluetoothUUID.avRemoteControlController, .bit16(4367))
         XCTAssertEqual(BluetoothUUID.avRemoteControlController.name, "A/V Remote Control Controller")
         XCTAssertNotEqual(BluetoothUUID.avRemoteControlController, .bit32(4367))
         XCTAssertNotEqual(BluetoothUUID.avRemoteControlController, .bit32(0x110F))

    }

    /// Test Intercom
    func testIntercom() {

         XCTAssertEqual(BluetoothUUID.intercom.rawValue, "1110")
         XCTAssertEqual(BluetoothUUID.intercom, .bit16(0x1110))
         XCTAssertEqual(BluetoothUUID.intercom, .bit16(4368))
         XCTAssertEqual(BluetoothUUID.intercom.name, "Intercom")
         XCTAssertNotEqual(BluetoothUUID.intercom, .bit32(4368))
         XCTAssertNotEqual(BluetoothUUID.intercom, .bit32(0x1110))

    }

    /// Test Fax
    func testFax() {

         XCTAssertEqual(BluetoothUUID.fax.rawValue, "1111")
         XCTAssertEqual(BluetoothUUID.fax, .bit16(0x1111))
         XCTAssertEqual(BluetoothUUID.fax, .bit16(4369))
         XCTAssertEqual(BluetoothUUID.fax.name, "Fax")
         XCTAssertNotEqual(BluetoothUUID.fax, .bit32(4369))
         XCTAssertNotEqual(BluetoothUUID.fax, .bit32(0x1111))

    }

    /// Test Headset AG
    func testHeadsetAg() {

         XCTAssertEqual(BluetoothUUID.headsetAg.rawValue, "1112")
         XCTAssertEqual(BluetoothUUID.headsetAg, .bit16(0x1112))
         XCTAssertEqual(BluetoothUUID.headsetAg, .bit16(4370))
         XCTAssertEqual(BluetoothUUID.headsetAg.name, "Headset AG")
         XCTAssertNotEqual(BluetoothUUID.headsetAg, .bit32(4370))
         XCTAssertNotEqual(BluetoothUUID.headsetAg, .bit32(0x1112))

    }

    /// Test WAP
    func testWap() {

         XCTAssertEqual(BluetoothUUID.wap.rawValue, "1113")
         XCTAssertEqual(BluetoothUUID.wap, .bit16(0x1113))
         XCTAssertEqual(BluetoothUUID.wap, .bit16(4371))
         XCTAssertEqual(BluetoothUUID.wap.name, "WAP")
         XCTAssertNotEqual(BluetoothUUID.wap, .bit32(4371))
         XCTAssertNotEqual(BluetoothUUID.wap, .bit32(0x1113))

    }

    /// Test WAP Client
    func testWapClient() {

         XCTAssertEqual(BluetoothUUID.wapClient.rawValue, "1114")
         XCTAssertEqual(BluetoothUUID.wapClient, .bit16(0x1114))
         XCTAssertEqual(BluetoothUUID.wapClient, .bit16(4372))
         XCTAssertEqual(BluetoothUUID.wapClient.name, "WAP Client")
         XCTAssertNotEqual(BluetoothUUID.wapClient, .bit32(4372))
         XCTAssertNotEqual(BluetoothUUID.wapClient, .bit32(0x1114))

    }

    /// Test PANU
    func testPanu() {

         XCTAssertEqual(BluetoothUUID.panu.rawValue, "1115")
         XCTAssertEqual(BluetoothUUID.panu, .bit16(0x1115))
         XCTAssertEqual(BluetoothUUID.panu, .bit16(4373))
         XCTAssertEqual(BluetoothUUID.panu.name, "PANU")
         XCTAssertNotEqual(BluetoothUUID.panu, .bit32(4373))
         XCTAssertNotEqual(BluetoothUUID.panu, .bit32(0x1115))

    }

    /// Test NAP
    func testNap() {

         XCTAssertEqual(BluetoothUUID.nap.rawValue, "1116")
         XCTAssertEqual(BluetoothUUID.nap, .bit16(0x1116))
         XCTAssertEqual(BluetoothUUID.nap, .bit16(4374))
         XCTAssertEqual(BluetoothUUID.nap.name, "NAP")
         XCTAssertNotEqual(BluetoothUUID.nap, .bit32(4374))
         XCTAssertNotEqual(BluetoothUUID.nap, .bit32(0x1116))

    }

    /// Test GN
    func testGn() {

         XCTAssertEqual(BluetoothUUID.gn.rawValue, "1117")
         XCTAssertEqual(BluetoothUUID.gn, .bit16(0x1117))
         XCTAssertEqual(BluetoothUUID.gn, .bit16(4375))
         XCTAssertEqual(BluetoothUUID.gn.name, "GN")
         XCTAssertNotEqual(BluetoothUUID.gn, .bit32(4375))
         XCTAssertNotEqual(BluetoothUUID.gn, .bit32(0x1117))

    }

    /// Test Direct Printing
    func testDirectPrinting() {

         XCTAssertEqual(BluetoothUUID.directPrinting.rawValue, "1118")
         XCTAssertEqual(BluetoothUUID.directPrinting, .bit16(0x1118))
         XCTAssertEqual(BluetoothUUID.directPrinting, .bit16(4376))
         XCTAssertEqual(BluetoothUUID.directPrinting.name, "Direct Printing")
         XCTAssertNotEqual(BluetoothUUID.directPrinting, .bit32(4376))
         XCTAssertNotEqual(BluetoothUUID.directPrinting, .bit32(0x1118))

    }

    /// Test Reference Printing
    func testReferencePrinting() {

         XCTAssertEqual(BluetoothUUID.referencePrinting.rawValue, "1119")
         XCTAssertEqual(BluetoothUUID.referencePrinting, .bit16(0x1119))
         XCTAssertEqual(BluetoothUUID.referencePrinting, .bit16(4377))
         XCTAssertEqual(BluetoothUUID.referencePrinting.name, "Reference Printing")
         XCTAssertNotEqual(BluetoothUUID.referencePrinting, .bit32(4377))
         XCTAssertNotEqual(BluetoothUUID.referencePrinting, .bit32(0x1119))

    }

    /// Test Basic Imaging Profile
    func testBasicImagingProfile() {

         XCTAssertEqual(BluetoothUUID.basicImagingProfile.rawValue, "111A")
         XCTAssertEqual(BluetoothUUID.basicImagingProfile, .bit16(0x111A))
         XCTAssertEqual(BluetoothUUID.basicImagingProfile, .bit16(4378))
         XCTAssertEqual(BluetoothUUID.basicImagingProfile.name, "Basic Imaging Profile")
         XCTAssertNotEqual(BluetoothUUID.basicImagingProfile, .bit32(4378))
         XCTAssertNotEqual(BluetoothUUID.basicImagingProfile, .bit32(0x111A))

    }

    /// Test Imaging Responder
    func testImagingResponder() {

         XCTAssertEqual(BluetoothUUID.imagingResponder.rawValue, "111B")
         XCTAssertEqual(BluetoothUUID.imagingResponder, .bit16(0x111B))
         XCTAssertEqual(BluetoothUUID.imagingResponder, .bit16(4379))
         XCTAssertEqual(BluetoothUUID.imagingResponder.name, "Imaging Responder")
         XCTAssertNotEqual(BluetoothUUID.imagingResponder, .bit32(4379))
         XCTAssertNotEqual(BluetoothUUID.imagingResponder, .bit32(0x111B))

    }

    /// Test Imaging Automatic Archive
    func testImagingAutomaticArchive() {

         XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive.rawValue, "111C")
         XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive, .bit16(0x111C))
         XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive, .bit16(4380))
         XCTAssertEqual(BluetoothUUID.imagingAutomaticArchive.name, "Imaging Automatic Archive")
         XCTAssertNotEqual(BluetoothUUID.imagingAutomaticArchive, .bit32(4380))
         XCTAssertNotEqual(BluetoothUUID.imagingAutomaticArchive, .bit32(0x111C))

    }

    /// Test Imaging Referenced Objects
    func testImagingReferencedObjects() {

         XCTAssertEqual(BluetoothUUID.imagingReferencedObjects.rawValue, "111D")
         XCTAssertEqual(BluetoothUUID.imagingReferencedObjects, .bit16(0x111D))
         XCTAssertEqual(BluetoothUUID.imagingReferencedObjects, .bit16(4381))
         XCTAssertEqual(BluetoothUUID.imagingReferencedObjects.name, "Imaging Referenced Objects")
         XCTAssertNotEqual(BluetoothUUID.imagingReferencedObjects, .bit32(4381))
         XCTAssertNotEqual(BluetoothUUID.imagingReferencedObjects, .bit32(0x111D))

    }

    /// Test Handsfree
    func testHandsfree() {

         XCTAssertEqual(BluetoothUUID.handsfree.rawValue, "111E")
         XCTAssertEqual(BluetoothUUID.handsfree, .bit16(0x111E))
         XCTAssertEqual(BluetoothUUID.handsfree, .bit16(4382))
         XCTAssertEqual(BluetoothUUID.handsfree.name, "Handsfree")
         XCTAssertNotEqual(BluetoothUUID.handsfree, .bit32(4382))
         XCTAssertNotEqual(BluetoothUUID.handsfree, .bit32(0x111E))

    }

    /// Test Handsfree Audio Gateway
    func testHandsfreeAudioGateway() {

         XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway.rawValue, "111F")
         XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway, .bit16(0x111F))
         XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway, .bit16(4383))
         XCTAssertEqual(BluetoothUUID.handsfreeAudioGateway.name, "Handsfree Audio Gateway")
         XCTAssertNotEqual(BluetoothUUID.handsfreeAudioGateway, .bit32(4383))
         XCTAssertNotEqual(BluetoothUUID.handsfreeAudioGateway, .bit32(0x111F))

    }

    /// Test Direct Printing Refrence Objects Service
    func testDirectPrintingRefrenceObjectsService() {

         XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService.rawValue, "1120")
         XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit16(0x1120))
         XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit16(4384))
         XCTAssertEqual(BluetoothUUID.directPrintingRefrenceObjectsService.name, "Direct Printing Refrence Objects Service")
         XCTAssertNotEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit32(4384))
         XCTAssertNotEqual(BluetoothUUID.directPrintingRefrenceObjectsService, .bit32(0x1120))

    }

    /// Test Reflected UI
    func testReflectedUi() {

         XCTAssertEqual(BluetoothUUID.reflectedUi.rawValue, "1121")
         XCTAssertEqual(BluetoothUUID.reflectedUi, .bit16(0x1121))
         XCTAssertEqual(BluetoothUUID.reflectedUi, .bit16(4385))
         XCTAssertEqual(BluetoothUUID.reflectedUi.name, "Reflected UI")
         XCTAssertNotEqual(BluetoothUUID.reflectedUi, .bit32(4385))
         XCTAssertNotEqual(BluetoothUUID.reflectedUi, .bit32(0x1121))

    }

    /// Test Basic Printing
    func testBasicPrinting() {

         XCTAssertEqual(BluetoothUUID.basicPrinting.rawValue, "1122")
         XCTAssertEqual(BluetoothUUID.basicPrinting, .bit16(0x1122))
         XCTAssertEqual(BluetoothUUID.basicPrinting, .bit16(4386))
         XCTAssertEqual(BluetoothUUID.basicPrinting.name, "Basic Printing")
         XCTAssertNotEqual(BluetoothUUID.basicPrinting, .bit32(4386))
         XCTAssertNotEqual(BluetoothUUID.basicPrinting, .bit32(0x1122))

    }

    /// Test Printing Status
    func testPrintingStatus() {

         XCTAssertEqual(BluetoothUUID.printingStatus.rawValue, "1123")
         XCTAssertEqual(BluetoothUUID.printingStatus, .bit16(0x1123))
         XCTAssertEqual(BluetoothUUID.printingStatus, .bit16(4387))
         XCTAssertEqual(BluetoothUUID.printingStatus.name, "Printing Status")
         XCTAssertNotEqual(BluetoothUUID.printingStatus, .bit32(4387))
         XCTAssertNotEqual(BluetoothUUID.printingStatus, .bit32(0x1123))

    }

    /// Test Human Interface Device Service
    func testHumanInterfaceDeviceService() {

         XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService.rawValue, "1124")
         XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService, .bit16(0x1124))
         XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService, .bit16(4388))
         XCTAssertEqual(BluetoothUUID.humanInterfaceDeviceService.name, "Human Interface Device Service")
         XCTAssertNotEqual(BluetoothUUID.humanInterfaceDeviceService, .bit32(4388))
         XCTAssertNotEqual(BluetoothUUID.humanInterfaceDeviceService, .bit32(0x1124))

    }

    /// Test Hardcopy Cable Replacement
    func testHardcopyCableReplacement() {

         XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement.rawValue, "1125")
         XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement, .bit16(0x1125))
         XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement, .bit16(4389))
         XCTAssertEqual(BluetoothUUID.hardcopyCableReplacement.name, "Hardcopy Cable Replacement")
         XCTAssertNotEqual(BluetoothUUID.hardcopyCableReplacement, .bit32(4389))
         XCTAssertNotEqual(BluetoothUUID.hardcopyCableReplacement, .bit32(0x1125))

    }

    /// Test HCR Print
    func testHcrPrint() {

         XCTAssertEqual(BluetoothUUID.hcrPrint.rawValue, "1126")
         XCTAssertEqual(BluetoothUUID.hcrPrint, .bit16(0x1126))
         XCTAssertEqual(BluetoothUUID.hcrPrint, .bit16(4390))
         XCTAssertEqual(BluetoothUUID.hcrPrint.name, "HCR Print")
         XCTAssertNotEqual(BluetoothUUID.hcrPrint, .bit32(4390))
         XCTAssertNotEqual(BluetoothUUID.hcrPrint, .bit32(0x1126))

    }

    /// Test HCR Scan
    func testHcrScan() {

         XCTAssertEqual(BluetoothUUID.hcrScan.rawValue, "1127")
         XCTAssertEqual(BluetoothUUID.hcrScan, .bit16(0x1127))
         XCTAssertEqual(BluetoothUUID.hcrScan, .bit16(4391))
         XCTAssertEqual(BluetoothUUID.hcrScan.name, "HCR Scan")
         XCTAssertNotEqual(BluetoothUUID.hcrScan, .bit32(4391))
         XCTAssertNotEqual(BluetoothUUID.hcrScan, .bit32(0x1127))

    }

    /// Test Common ISDN Access
    func testCommonIsdnAccess() {

         XCTAssertEqual(BluetoothUUID.commonIsdnAccess.rawValue, "1128")
         XCTAssertEqual(BluetoothUUID.commonIsdnAccess, .bit16(0x1128))
         XCTAssertEqual(BluetoothUUID.commonIsdnAccess, .bit16(4392))
         XCTAssertEqual(BluetoothUUID.commonIsdnAccess.name, "Common ISDN Access")
         XCTAssertNotEqual(BluetoothUUID.commonIsdnAccess, .bit32(4392))
         XCTAssertNotEqual(BluetoothUUID.commonIsdnAccess, .bit32(0x1128))

    }

    /// Test SIM Access
    func testSimAccess() {

         XCTAssertEqual(BluetoothUUID.simAccess.rawValue, "112D")
         XCTAssertEqual(BluetoothUUID.simAccess, .bit16(0x112D))
         XCTAssertEqual(BluetoothUUID.simAccess, .bit16(4397))
         XCTAssertEqual(BluetoothUUID.simAccess.name, "SIM Access")
         XCTAssertNotEqual(BluetoothUUID.simAccess, .bit32(4397))
         XCTAssertNotEqual(BluetoothUUID.simAccess, .bit32(0x112D))

    }

    /// Test Phonebook Access Client
    func testPhonebookAccessClient() {

         XCTAssertEqual(BluetoothUUID.phonebookAccessClient.rawValue, "112E")
         XCTAssertEqual(BluetoothUUID.phonebookAccessClient, .bit16(0x112E))
         XCTAssertEqual(BluetoothUUID.phonebookAccessClient, .bit16(4398))
         XCTAssertEqual(BluetoothUUID.phonebookAccessClient.name, "Phonebook Access Client")
         XCTAssertNotEqual(BluetoothUUID.phonebookAccessClient, .bit32(4398))
         XCTAssertNotEqual(BluetoothUUID.phonebookAccessClient, .bit32(0x112E))

    }

    /// Test Phonebook Access Server
    func testPhonebookAccessServer() {

         XCTAssertEqual(BluetoothUUID.phonebookAccessServer.rawValue, "112F")
         XCTAssertEqual(BluetoothUUID.phonebookAccessServer, .bit16(0x112F))
         XCTAssertEqual(BluetoothUUID.phonebookAccessServer, .bit16(4399))
         XCTAssertEqual(BluetoothUUID.phonebookAccessServer.name, "Phonebook Access Server")
         XCTAssertNotEqual(BluetoothUUID.phonebookAccessServer, .bit32(4399))
         XCTAssertNotEqual(BluetoothUUID.phonebookAccessServer, .bit32(0x112F))

    }

    /// Test Phonebook Access
    func testPhonebookAccess() {

         XCTAssertEqual(BluetoothUUID.phonebookAccess.rawValue, "1130")
         XCTAssertEqual(BluetoothUUID.phonebookAccess, .bit16(0x1130))
         XCTAssertEqual(BluetoothUUID.phonebookAccess, .bit16(4400))
         XCTAssertEqual(BluetoothUUID.phonebookAccess.name, "Phonebook Access")
         XCTAssertNotEqual(BluetoothUUID.phonebookAccess, .bit32(4400))
         XCTAssertNotEqual(BluetoothUUID.phonebookAccess, .bit32(0x1130))

    }

    /// Test Headset HS
    func testHeadsetHs() {

         XCTAssertEqual(BluetoothUUID.headsetHs.rawValue, "1131")
         XCTAssertEqual(BluetoothUUID.headsetHs, .bit16(0x1131))
         XCTAssertEqual(BluetoothUUID.headsetHs, .bit16(4401))
         XCTAssertEqual(BluetoothUUID.headsetHs.name, "Headset HS")
         XCTAssertNotEqual(BluetoothUUID.headsetHs, .bit32(4401))
         XCTAssertNotEqual(BluetoothUUID.headsetHs, .bit32(0x1131))

    }

    /// Test Message Access Server
    func testMessageAccessServer() {

         XCTAssertEqual(BluetoothUUID.messageAccessServer.rawValue, "1132")
         XCTAssertEqual(BluetoothUUID.messageAccessServer, .bit16(0x1132))
         XCTAssertEqual(BluetoothUUID.messageAccessServer, .bit16(4402))
         XCTAssertEqual(BluetoothUUID.messageAccessServer.name, "Message Access Server")
         XCTAssertNotEqual(BluetoothUUID.messageAccessServer, .bit32(4402))
         XCTAssertNotEqual(BluetoothUUID.messageAccessServer, .bit32(0x1132))

    }

    /// Test Message Notification Server
    func testMessageNotificationServer() {

         XCTAssertEqual(BluetoothUUID.messageNotificationServer.rawValue, "1133")
         XCTAssertEqual(BluetoothUUID.messageNotificationServer, .bit16(0x1133))
         XCTAssertEqual(BluetoothUUID.messageNotificationServer, .bit16(4403))
         XCTAssertEqual(BluetoothUUID.messageNotificationServer.name, "Message Notification Server")
         XCTAssertNotEqual(BluetoothUUID.messageNotificationServer, .bit32(4403))
         XCTAssertNotEqual(BluetoothUUID.messageNotificationServer, .bit32(0x1133))

    }

    /// Test Message Access Profile
    func testMessageAccessProfile() {

         XCTAssertEqual(BluetoothUUID.messageAccessProfile.rawValue, "1134")
         XCTAssertEqual(BluetoothUUID.messageAccessProfile, .bit16(0x1134))
         XCTAssertEqual(BluetoothUUID.messageAccessProfile, .bit16(4404))
         XCTAssertEqual(BluetoothUUID.messageAccessProfile.name, "Message Access Profile")
         XCTAssertNotEqual(BluetoothUUID.messageAccessProfile, .bit32(4404))
         XCTAssertNotEqual(BluetoothUUID.messageAccessProfile, .bit32(0x1134))

    }

    /// Test GNSS
    func testGnss() {

         XCTAssertEqual(BluetoothUUID.gnss.rawValue, "1135")
         XCTAssertEqual(BluetoothUUID.gnss, .bit16(0x1135))
         XCTAssertEqual(BluetoothUUID.gnss, .bit16(4405))
         XCTAssertEqual(BluetoothUUID.gnss.name, "GNSS")
         XCTAssertNotEqual(BluetoothUUID.gnss, .bit32(4405))
         XCTAssertNotEqual(BluetoothUUID.gnss, .bit32(0x1135))

    }

    /// Test GNSS Server
    func testGnssServer() {

         XCTAssertEqual(BluetoothUUID.gnssServer.rawValue, "1136")
         XCTAssertEqual(BluetoothUUID.gnssServer, .bit16(0x1136))
         XCTAssertEqual(BluetoothUUID.gnssServer, .bit16(4406))
         XCTAssertEqual(BluetoothUUID.gnssServer.name, "GNSS Server")
         XCTAssertNotEqual(BluetoothUUID.gnssServer, .bit32(4406))
         XCTAssertNotEqual(BluetoothUUID.gnssServer, .bit32(0x1136))

    }

    /// Test 3D Display
    func testUuid3Ddisplay() {

         XCTAssertEqual(BluetoothUUID.uuid3Ddisplay.rawValue, "1137")
         XCTAssertEqual(BluetoothUUID.uuid3Ddisplay, .bit16(0x1137))
         XCTAssertEqual(BluetoothUUID.uuid3Ddisplay, .bit16(4407))
         XCTAssertEqual(BluetoothUUID.uuid3Ddisplay.name, "3D Display")
         XCTAssertNotEqual(BluetoothUUID.uuid3Ddisplay, .bit32(4407))
         XCTAssertNotEqual(BluetoothUUID.uuid3Ddisplay, .bit32(0x1137))

    }

    /// Test 3D Glasses
    func testUuid3Dglasses() {

         XCTAssertEqual(BluetoothUUID.uuid3Dglasses.rawValue, "1138")
         XCTAssertEqual(BluetoothUUID.uuid3Dglasses, .bit16(0x1138))
         XCTAssertEqual(BluetoothUUID.uuid3Dglasses, .bit16(4408))
         XCTAssertEqual(BluetoothUUID.uuid3Dglasses.name, "3D Glasses")
         XCTAssertNotEqual(BluetoothUUID.uuid3Dglasses, .bit32(4408))
         XCTAssertNotEqual(BluetoothUUID.uuid3Dglasses, .bit32(0x1138))

    }

    /// Test 3D Synchronization
    func testUuid3Dsynchronization() {

         XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization.rawValue, "1139")
         XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization, .bit16(0x1139))
         XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization, .bit16(4409))
         XCTAssertEqual(BluetoothUUID.uuid3Dsynchronization.name, "3D Synchronization")
         XCTAssertNotEqual(BluetoothUUID.uuid3Dsynchronization, .bit32(4409))
         XCTAssertNotEqual(BluetoothUUID.uuid3Dsynchronization, .bit32(0x1139))

    }

    /// Test MPS Profile
    func testMpsProfile() {

         XCTAssertEqual(BluetoothUUID.mpsProfile.rawValue, "113A")
         XCTAssertEqual(BluetoothUUID.mpsProfile, .bit16(0x113A))
         XCTAssertEqual(BluetoothUUID.mpsProfile, .bit16(4410))
         XCTAssertEqual(BluetoothUUID.mpsProfile.name, "MPS Profile")
         XCTAssertNotEqual(BluetoothUUID.mpsProfile, .bit32(4410))
         XCTAssertNotEqual(BluetoothUUID.mpsProfile, .bit32(0x113A))

    }

    /// Test MPS Service
    func testMpsService() {

         XCTAssertEqual(BluetoothUUID.mpsService.rawValue, "113B")
         XCTAssertEqual(BluetoothUUID.mpsService, .bit16(0x113B))
         XCTAssertEqual(BluetoothUUID.mpsService, .bit16(4411))
         XCTAssertEqual(BluetoothUUID.mpsService.name, "MPS Service")
         XCTAssertNotEqual(BluetoothUUID.mpsService, .bit32(4411))
         XCTAssertNotEqual(BluetoothUUID.mpsService, .bit32(0x113B))

    }

    /// Test PnP Information
    func testPnpInformation() {

         XCTAssertEqual(BluetoothUUID.pnpInformation.rawValue, "1200")
         XCTAssertEqual(BluetoothUUID.pnpInformation, .bit16(0x1200))
         XCTAssertEqual(BluetoothUUID.pnpInformation, .bit16(4608))
         XCTAssertEqual(BluetoothUUID.pnpInformation.name, "PnP Information")
         XCTAssertNotEqual(BluetoothUUID.pnpInformation, .bit32(4608))
         XCTAssertNotEqual(BluetoothUUID.pnpInformation, .bit32(0x1200))

    }

    /// Test Generic Networking
    func testGenericNetworking() {

         XCTAssertEqual(BluetoothUUID.genericNetworking.rawValue, "1201")
         XCTAssertEqual(BluetoothUUID.genericNetworking, .bit16(0x1201))
         XCTAssertEqual(BluetoothUUID.genericNetworking, .bit16(4609))
         XCTAssertEqual(BluetoothUUID.genericNetworking.name, "Generic Networking")
         XCTAssertNotEqual(BluetoothUUID.genericNetworking, .bit32(4609))
         XCTAssertNotEqual(BluetoothUUID.genericNetworking, .bit32(0x1201))

    }

    /// Test Generic File Transfer
    func testGenericFileTransfer() {

         XCTAssertEqual(BluetoothUUID.genericFileTransfer.rawValue, "1202")
         XCTAssertEqual(BluetoothUUID.genericFileTransfer, .bit16(0x1202))
         XCTAssertEqual(BluetoothUUID.genericFileTransfer, .bit16(4610))
         XCTAssertEqual(BluetoothUUID.genericFileTransfer.name, "Generic File Transfer")
         XCTAssertNotEqual(BluetoothUUID.genericFileTransfer, .bit32(4610))
         XCTAssertNotEqual(BluetoothUUID.genericFileTransfer, .bit32(0x1202))

    }

    /// Test Generic Audio
    func testGenericAudio() {

         XCTAssertEqual(BluetoothUUID.genericAudio.rawValue, "1203")
         XCTAssertEqual(BluetoothUUID.genericAudio, .bit16(0x1203))
         XCTAssertEqual(BluetoothUUID.genericAudio, .bit16(4611))
         XCTAssertEqual(BluetoothUUID.genericAudio.name, "Generic Audio")
         XCTAssertNotEqual(BluetoothUUID.genericAudio, .bit32(4611))
         XCTAssertNotEqual(BluetoothUUID.genericAudio, .bit32(0x1203))

    }

    /// Test Generic Telephony
    func testGenericTelephony() {

         XCTAssertEqual(BluetoothUUID.genericTelephony.rawValue, "1204")
         XCTAssertEqual(BluetoothUUID.genericTelephony, .bit16(0x1204))
         XCTAssertEqual(BluetoothUUID.genericTelephony, .bit16(4612))
         XCTAssertEqual(BluetoothUUID.genericTelephony.name, "Generic Telephony")
         XCTAssertNotEqual(BluetoothUUID.genericTelephony, .bit32(4612))
         XCTAssertNotEqual(BluetoothUUID.genericTelephony, .bit32(0x1204))

    }

    /// Test UPNP Service
    func testUpnpService() {

         XCTAssertEqual(BluetoothUUID.upnpService.rawValue, "1205")
         XCTAssertEqual(BluetoothUUID.upnpService, .bit16(0x1205))
         XCTAssertEqual(BluetoothUUID.upnpService, .bit16(4613))
         XCTAssertEqual(BluetoothUUID.upnpService.name, "UPNP Service")
         XCTAssertNotEqual(BluetoothUUID.upnpService, .bit32(4613))
         XCTAssertNotEqual(BluetoothUUID.upnpService, .bit32(0x1205))

    }

    /// Test UPNP IP Service
    func testUpnpIpService() {

         XCTAssertEqual(BluetoothUUID.upnpIpService.rawValue, "1206")
         XCTAssertEqual(BluetoothUUID.upnpIpService, .bit16(0x1206))
         XCTAssertEqual(BluetoothUUID.upnpIpService, .bit16(4614))
         XCTAssertEqual(BluetoothUUID.upnpIpService.name, "UPNP IP Service")
         XCTAssertNotEqual(BluetoothUUID.upnpIpService, .bit32(4614))
         XCTAssertNotEqual(BluetoothUUID.upnpIpService, .bit32(0x1206))

    }

    /// Test UPNP IP PAN
    func testUpnpIpPan() {

         XCTAssertEqual(BluetoothUUID.upnpIpPan.rawValue, "1300")
         XCTAssertEqual(BluetoothUUID.upnpIpPan, .bit16(0x1300))
         XCTAssertEqual(BluetoothUUID.upnpIpPan, .bit16(4864))
         XCTAssertEqual(BluetoothUUID.upnpIpPan.name, "UPNP IP PAN")
         XCTAssertNotEqual(BluetoothUUID.upnpIpPan, .bit32(4864))
         XCTAssertNotEqual(BluetoothUUID.upnpIpPan, .bit32(0x1300))

    }

    /// Test UPNP IP LAP
    func testUpnpIpLap() {

         XCTAssertEqual(BluetoothUUID.upnpIpLap.rawValue, "1301")
         XCTAssertEqual(BluetoothUUID.upnpIpLap, .bit16(0x1301))
         XCTAssertEqual(BluetoothUUID.upnpIpLap, .bit16(4865))
         XCTAssertEqual(BluetoothUUID.upnpIpLap.name, "UPNP IP LAP")
         XCTAssertNotEqual(BluetoothUUID.upnpIpLap, .bit32(4865))
         XCTAssertNotEqual(BluetoothUUID.upnpIpLap, .bit32(0x1301))

    }

    /// Test UPNP IP L2CAP
    func testUpnpIpL2Cap() {

         XCTAssertEqual(BluetoothUUID.upnpIpL2Cap.rawValue, "1302")
         XCTAssertEqual(BluetoothUUID.upnpIpL2Cap, .bit16(0x1302))
         XCTAssertEqual(BluetoothUUID.upnpIpL2Cap, .bit16(4866))
         XCTAssertEqual(BluetoothUUID.upnpIpL2Cap.name, "UPNP IP L2CAP")
         XCTAssertNotEqual(BluetoothUUID.upnpIpL2Cap, .bit32(4866))
         XCTAssertNotEqual(BluetoothUUID.upnpIpL2Cap, .bit32(0x1302))

    }

    /// Test Video Source
    func testVideoSource() {

         XCTAssertEqual(BluetoothUUID.videoSource.rawValue, "1303")
         XCTAssertEqual(BluetoothUUID.videoSource, .bit16(0x1303))
         XCTAssertEqual(BluetoothUUID.videoSource, .bit16(4867))
         XCTAssertEqual(BluetoothUUID.videoSource.name, "Video Source")
         XCTAssertNotEqual(BluetoothUUID.videoSource, .bit32(4867))
         XCTAssertNotEqual(BluetoothUUID.videoSource, .bit32(0x1303))

    }

    /// Test Video Sink
    func testVideoSink() {

         XCTAssertEqual(BluetoothUUID.videoSink.rawValue, "1304")
         XCTAssertEqual(BluetoothUUID.videoSink, .bit16(0x1304))
         XCTAssertEqual(BluetoothUUID.videoSink, .bit16(4868))
         XCTAssertEqual(BluetoothUUID.videoSink.name, "Video Sink")
         XCTAssertNotEqual(BluetoothUUID.videoSink, .bit32(4868))
         XCTAssertNotEqual(BluetoothUUID.videoSink, .bit32(0x1304))

    }

    /// Test Video Distribution
    func testVideoDistribution() {

         XCTAssertEqual(BluetoothUUID.videoDistribution.rawValue, "1305")
         XCTAssertEqual(BluetoothUUID.videoDistribution, .bit16(0x1305))
         XCTAssertEqual(BluetoothUUID.videoDistribution, .bit16(4869))
         XCTAssertEqual(BluetoothUUID.videoDistribution.name, "Video Distribution")
         XCTAssertNotEqual(BluetoothUUID.videoDistribution, .bit32(4869))
         XCTAssertNotEqual(BluetoothUUID.videoDistribution, .bit32(0x1305))

    }

    /// Test HDP
    func testHdp() {

         XCTAssertEqual(BluetoothUUID.hdp.rawValue, "1400")
         XCTAssertEqual(BluetoothUUID.hdp, .bit16(0x1400))
         XCTAssertEqual(BluetoothUUID.hdp, .bit16(5120))
         XCTAssertEqual(BluetoothUUID.hdp.name, "HDP")
         XCTAssertNotEqual(BluetoothUUID.hdp, .bit32(5120))
         XCTAssertNotEqual(BluetoothUUID.hdp, .bit32(0x1400))

    }

    /// Test HDP Source
    func testHdpSource() {

         XCTAssertEqual(BluetoothUUID.hdpSource.rawValue, "1401")
         XCTAssertEqual(BluetoothUUID.hdpSource, .bit16(0x1401))
         XCTAssertEqual(BluetoothUUID.hdpSource, .bit16(5121))
         XCTAssertEqual(BluetoothUUID.hdpSource.name, "HDP Source")
         XCTAssertNotEqual(BluetoothUUID.hdpSource, .bit32(5121))
         XCTAssertNotEqual(BluetoothUUID.hdpSource, .bit32(0x1401))

    }

    /// Test HDP Sink
    func testHdpSink() {

         XCTAssertEqual(BluetoothUUID.hdpSink.rawValue, "1402")
         XCTAssertEqual(BluetoothUUID.hdpSink, .bit16(0x1402))
         XCTAssertEqual(BluetoothUUID.hdpSink, .bit16(5122))
         XCTAssertEqual(BluetoothUUID.hdpSink.name, "HDP Sink")
         XCTAssertNotEqual(BluetoothUUID.hdpSink, .bit32(5122))
         XCTAssertNotEqual(BluetoothUUID.hdpSink, .bit32(0x1402))

    }

    /// Test Generic Access Profile
    func testGenericAccessProfile() {

         XCTAssertEqual(BluetoothUUID.genericAccessProfile.rawValue, "1800")
         XCTAssertEqual(BluetoothUUID.genericAccessProfile, .bit16(0x1800))
         XCTAssertEqual(BluetoothUUID.genericAccessProfile, .bit16(6144))
         XCTAssertEqual(BluetoothUUID.genericAccessProfile.name, "Generic Access Profile")
         XCTAssertNotEqual(BluetoothUUID.genericAccessProfile, .bit32(6144))
         XCTAssertNotEqual(BluetoothUUID.genericAccessProfile, .bit32(0x1800))

    }

    /// Test Generic Attribute Profile
    func testGenericAttributeProfile() {

         XCTAssertEqual(BluetoothUUID.genericAttributeProfile.rawValue, "1801")
         XCTAssertEqual(BluetoothUUID.genericAttributeProfile, .bit16(0x1801))
         XCTAssertEqual(BluetoothUUID.genericAttributeProfile, .bit16(6145))
         XCTAssertEqual(BluetoothUUID.genericAttributeProfile.name, "Generic Attribute Profile")
         XCTAssertNotEqual(BluetoothUUID.genericAttributeProfile, .bit32(6145))
         XCTAssertNotEqual(BluetoothUUID.genericAttributeProfile, .bit32(0x1801))

    }

    /// Test Immediate Alert
    func testImmediateAlert() {

         XCTAssertEqual(BluetoothUUID.immediateAlert.rawValue, "1802")
         XCTAssertEqual(BluetoothUUID.immediateAlert, .bit16(0x1802))
         XCTAssertEqual(BluetoothUUID.immediateAlert, .bit16(6146))
         XCTAssertEqual(BluetoothUUID.immediateAlert.name, "Immediate Alert")
         XCTAssertNotEqual(BluetoothUUID.immediateAlert, .bit32(6146))
         XCTAssertNotEqual(BluetoothUUID.immediateAlert, .bit32(0x1802))

    }

    /// Test Link Loss
    func testLinkLoss() {

         XCTAssertEqual(BluetoothUUID.linkLoss.rawValue, "1803")
         XCTAssertEqual(BluetoothUUID.linkLoss, .bit16(0x1803))
         XCTAssertEqual(BluetoothUUID.linkLoss, .bit16(6147))
         XCTAssertEqual(BluetoothUUID.linkLoss.name, "Link Loss")
         XCTAssertNotEqual(BluetoothUUID.linkLoss, .bit32(6147))
         XCTAssertNotEqual(BluetoothUUID.linkLoss, .bit32(0x1803))

    }

    /// Test Tx Power
    func testTxPower() {

         XCTAssertEqual(BluetoothUUID.txPower.rawValue, "1804")
         XCTAssertEqual(BluetoothUUID.txPower, .bit16(0x1804))
         XCTAssertEqual(BluetoothUUID.txPower, .bit16(6148))
         XCTAssertEqual(BluetoothUUID.txPower.name, "Tx Power")
         XCTAssertNotEqual(BluetoothUUID.txPower, .bit32(6148))
         XCTAssertNotEqual(BluetoothUUID.txPower, .bit32(0x1804))

    }

    /// Test Current Time Service
    func testCurrentTimeService() {

         XCTAssertEqual(BluetoothUUID.currentTimeService.rawValue, "1805")
         XCTAssertEqual(BluetoothUUID.currentTimeService, .bit16(0x1805))
         XCTAssertEqual(BluetoothUUID.currentTimeService, .bit16(6149))
         XCTAssertEqual(BluetoothUUID.currentTimeService.name, "Current Time Service")
         XCTAssertNotEqual(BluetoothUUID.currentTimeService, .bit32(6149))
         XCTAssertNotEqual(BluetoothUUID.currentTimeService, .bit32(0x1805))

    }

    /// Test Reference Time Update Service
    func testReferenceTimeUpdateService() {

         XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService.rawValue, "1806")
         XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService, .bit16(0x1806))
         XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService, .bit16(6150))
         XCTAssertEqual(BluetoothUUID.referenceTimeUpdateService.name, "Reference Time Update Service")
         XCTAssertNotEqual(BluetoothUUID.referenceTimeUpdateService, .bit32(6150))
         XCTAssertNotEqual(BluetoothUUID.referenceTimeUpdateService, .bit32(0x1806))

    }

    /// Test Next DST Change Service
    func testNextDstChangeService() {

         XCTAssertEqual(BluetoothUUID.nextDstChangeService.rawValue, "1807")
         XCTAssertEqual(BluetoothUUID.nextDstChangeService, .bit16(0x1807))
         XCTAssertEqual(BluetoothUUID.nextDstChangeService, .bit16(6151))
         XCTAssertEqual(BluetoothUUID.nextDstChangeService.name, "Next DST Change Service")
         XCTAssertNotEqual(BluetoothUUID.nextDstChangeService, .bit32(6151))
         XCTAssertNotEqual(BluetoothUUID.nextDstChangeService, .bit32(0x1807))

    }

    /// Test Glucose
    func testGlucose() {

         XCTAssertEqual(BluetoothUUID.glucose.rawValue, "1808")
         XCTAssertEqual(BluetoothUUID.glucose, .bit16(0x1808))
         XCTAssertEqual(BluetoothUUID.glucose, .bit16(6152))
         XCTAssertEqual(BluetoothUUID.glucose.name, "Glucose")
         XCTAssertNotEqual(BluetoothUUID.glucose, .bit32(6152))
         XCTAssertNotEqual(BluetoothUUID.glucose, .bit32(0x1808))

    }

    /// Test Health Thermometer
    func testHealthThermometer() {

         XCTAssertEqual(BluetoothUUID.healthThermometer.rawValue, "1809")
         XCTAssertEqual(BluetoothUUID.healthThermometer, .bit16(0x1809))
         XCTAssertEqual(BluetoothUUID.healthThermometer, .bit16(6153))
         XCTAssertEqual(BluetoothUUID.healthThermometer.name, "Health Thermometer")
         XCTAssertNotEqual(BluetoothUUID.healthThermometer, .bit32(6153))
         XCTAssertNotEqual(BluetoothUUID.healthThermometer, .bit32(0x1809))

    }

    /// Test Device Information
    func testDeviceInformation() {

         XCTAssertEqual(BluetoothUUID.deviceInformation.rawValue, "180A")
         XCTAssertEqual(BluetoothUUID.deviceInformation, .bit16(0x180A))
         XCTAssertEqual(BluetoothUUID.deviceInformation, .bit16(6154))
         XCTAssertEqual(BluetoothUUID.deviceInformation.name, "Device Information")
         XCTAssertNotEqual(BluetoothUUID.deviceInformation, .bit32(6154))
         XCTAssertNotEqual(BluetoothUUID.deviceInformation, .bit32(0x180A))

    }

    /// Test Heart Rate
    func testHeartRate() {

         XCTAssertEqual(BluetoothUUID.heartRate.rawValue, "180D")
         XCTAssertEqual(BluetoothUUID.heartRate, .bit16(0x180D))
         XCTAssertEqual(BluetoothUUID.heartRate, .bit16(6157))
         XCTAssertEqual(BluetoothUUID.heartRate.name, "Heart Rate")
         XCTAssertNotEqual(BluetoothUUID.heartRate, .bit32(6157))
         XCTAssertNotEqual(BluetoothUUID.heartRate, .bit32(0x180D))

    }

    /// Test Phone Alert Status Service
    func testPhoneAlertStatusService() {

         XCTAssertEqual(BluetoothUUID.phoneAlertStatusService.rawValue, "180E")
         XCTAssertEqual(BluetoothUUID.phoneAlertStatusService, .bit16(0x180E))
         XCTAssertEqual(BluetoothUUID.phoneAlertStatusService, .bit16(6158))
         XCTAssertEqual(BluetoothUUID.phoneAlertStatusService.name, "Phone Alert Status Service")
         XCTAssertNotEqual(BluetoothUUID.phoneAlertStatusService, .bit32(6158))
         XCTAssertNotEqual(BluetoothUUID.phoneAlertStatusService, .bit32(0x180E))

    }

    /// Test Battery Service
    func testBatteryService() {

         XCTAssertEqual(BluetoothUUID.batteryService.rawValue, "180F")
         XCTAssertEqual(BluetoothUUID.batteryService, .bit16(0x180F))
         XCTAssertEqual(BluetoothUUID.batteryService, .bit16(6159))
         XCTAssertEqual(BluetoothUUID.batteryService.name, "Battery Service")
         XCTAssertNotEqual(BluetoothUUID.batteryService, .bit32(6159))
         XCTAssertNotEqual(BluetoothUUID.batteryService, .bit32(0x180F))

    }

    /// Test Blood Pressure
    func testBloodPressure() {

         XCTAssertEqual(BluetoothUUID.bloodPressure.rawValue, "1810")
         XCTAssertEqual(BluetoothUUID.bloodPressure, .bit16(0x1810))
         XCTAssertEqual(BluetoothUUID.bloodPressure, .bit16(6160))
         XCTAssertEqual(BluetoothUUID.bloodPressure.name, "Blood Pressure")
         XCTAssertNotEqual(BluetoothUUID.bloodPressure, .bit32(6160))
         XCTAssertNotEqual(BluetoothUUID.bloodPressure, .bit32(0x1810))

    }

    /// Test Alert Notification Service
    func testAlertNotificationService() {

         XCTAssertEqual(BluetoothUUID.alertNotificationService.rawValue, "1811")
         XCTAssertEqual(BluetoothUUID.alertNotificationService, .bit16(0x1811))
         XCTAssertEqual(BluetoothUUID.alertNotificationService, .bit16(6161))
         XCTAssertEqual(BluetoothUUID.alertNotificationService.name, "Alert Notification Service")
         XCTAssertNotEqual(BluetoothUUID.alertNotificationService, .bit32(6161))
         XCTAssertNotEqual(BluetoothUUID.alertNotificationService, .bit32(0x1811))

    }

    /// Test Human Interface Device
    func testHumanInterfaceDevice() {

         XCTAssertEqual(BluetoothUUID.humanInterfaceDevice.rawValue, "1812")
         XCTAssertEqual(BluetoothUUID.humanInterfaceDevice, .bit16(0x1812))
         XCTAssertEqual(BluetoothUUID.humanInterfaceDevice, .bit16(6162))
         XCTAssertEqual(BluetoothUUID.humanInterfaceDevice.name, "Human Interface Device")
         XCTAssertNotEqual(BluetoothUUID.humanInterfaceDevice, .bit32(6162))
         XCTAssertNotEqual(BluetoothUUID.humanInterfaceDevice, .bit32(0x1812))

    }

    /// Test Scan Parameters
    func testScanParameters() {

         XCTAssertEqual(BluetoothUUID.scanParameters.rawValue, "1813")
         XCTAssertEqual(BluetoothUUID.scanParameters, .bit16(0x1813))
         XCTAssertEqual(BluetoothUUID.scanParameters, .bit16(6163))
         XCTAssertEqual(BluetoothUUID.scanParameters.name, "Scan Parameters")
         XCTAssertNotEqual(BluetoothUUID.scanParameters, .bit32(6163))
         XCTAssertNotEqual(BluetoothUUID.scanParameters, .bit32(0x1813))

    }

    /// Test Running Speed and Cadence
    func testRunningSpeedAndCadence() {

         XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence.rawValue, "1814")
         XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence, .bit16(0x1814))
         XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence, .bit16(6164))
         XCTAssertEqual(BluetoothUUID.runningSpeedAndCadence.name, "Running Speed and Cadence")
         XCTAssertNotEqual(BluetoothUUID.runningSpeedAndCadence, .bit32(6164))
         XCTAssertNotEqual(BluetoothUUID.runningSpeedAndCadence, .bit32(0x1814))

    }

    /// Test Automation IO
    func testAutomationIo() {

         XCTAssertEqual(BluetoothUUID.automationIo.rawValue, "1815")
         XCTAssertEqual(BluetoothUUID.automationIo, .bit16(0x1815))
         XCTAssertEqual(BluetoothUUID.automationIo, .bit16(6165))
         XCTAssertEqual(BluetoothUUID.automationIo.name, "Automation IO")
         XCTAssertNotEqual(BluetoothUUID.automationIo, .bit32(6165))
         XCTAssertNotEqual(BluetoothUUID.automationIo, .bit32(0x1815))

    }

    /// Test Cycling Speed and Cadence
    func testCyclingSpeedAndCadence() {

         XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence.rawValue, "1816")
         XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit16(0x1816))
         XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit16(6166))
         XCTAssertEqual(BluetoothUUID.cyclingSpeedAndCadence.name, "Cycling Speed and Cadence")
         XCTAssertNotEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit32(6166))
         XCTAssertNotEqual(BluetoothUUID.cyclingSpeedAndCadence, .bit32(0x1816))

    }

    /// Test Cycling Power
    func testCyclingPower() {

         XCTAssertEqual(BluetoothUUID.cyclingPower.rawValue, "1818")
         XCTAssertEqual(BluetoothUUID.cyclingPower, .bit16(0x1818))
         XCTAssertEqual(BluetoothUUID.cyclingPower, .bit16(6168))
         XCTAssertEqual(BluetoothUUID.cyclingPower.name, "Cycling Power")
         XCTAssertNotEqual(BluetoothUUID.cyclingPower, .bit32(6168))
         XCTAssertNotEqual(BluetoothUUID.cyclingPower, .bit32(0x1818))

    }

    /// Test Location and Navigation
    func testLocationAndNavigation() {

         XCTAssertEqual(BluetoothUUID.locationAndNavigation.rawValue, "1819")
         XCTAssertEqual(BluetoothUUID.locationAndNavigation, .bit16(0x1819))
         XCTAssertEqual(BluetoothUUID.locationAndNavigation, .bit16(6169))
         XCTAssertEqual(BluetoothUUID.locationAndNavigation.name, "Location and Navigation")
         XCTAssertNotEqual(BluetoothUUID.locationAndNavigation, .bit32(6169))
         XCTAssertNotEqual(BluetoothUUID.locationAndNavigation, .bit32(0x1819))

    }

    /// Test Environmental Sensing
    func testEnvironmentalSensing() {

         XCTAssertEqual(BluetoothUUID.environmentalSensing.rawValue, "181A")
         XCTAssertEqual(BluetoothUUID.environmentalSensing, .bit16(0x181A))
         XCTAssertEqual(BluetoothUUID.environmentalSensing, .bit16(6170))
         XCTAssertEqual(BluetoothUUID.environmentalSensing.name, "Environmental Sensing")
         XCTAssertNotEqual(BluetoothUUID.environmentalSensing, .bit32(6170))
         XCTAssertNotEqual(BluetoothUUID.environmentalSensing, .bit32(0x181A))

    }

    /// Test Body Composition
    func testBodyComposition() {

         XCTAssertEqual(BluetoothUUID.bodyComposition.rawValue, "181B")
         XCTAssertEqual(BluetoothUUID.bodyComposition, .bit16(0x181B))
         XCTAssertEqual(BluetoothUUID.bodyComposition, .bit16(6171))
         XCTAssertEqual(BluetoothUUID.bodyComposition.name, "Body Composition")
         XCTAssertNotEqual(BluetoothUUID.bodyComposition, .bit32(6171))
         XCTAssertNotEqual(BluetoothUUID.bodyComposition, .bit32(0x181B))

    }

    /// Test User Data
    func testUserData() {

         XCTAssertEqual(BluetoothUUID.userData.rawValue, "181C")
         XCTAssertEqual(BluetoothUUID.userData, .bit16(0x181C))
         XCTAssertEqual(BluetoothUUID.userData, .bit16(6172))
         XCTAssertEqual(BluetoothUUID.userData.name, "User Data")
         XCTAssertNotEqual(BluetoothUUID.userData, .bit32(6172))
         XCTAssertNotEqual(BluetoothUUID.userData, .bit32(0x181C))

    }

    /// Test Weight Scale
    func testWeightScale() {

         XCTAssertEqual(BluetoothUUID.weightScale.rawValue, "181D")
         XCTAssertEqual(BluetoothUUID.weightScale, .bit16(0x181D))
         XCTAssertEqual(BluetoothUUID.weightScale, .bit16(6173))
         XCTAssertEqual(BluetoothUUID.weightScale.name, "Weight Scale")
         XCTAssertNotEqual(BluetoothUUID.weightScale, .bit32(6173))
         XCTAssertNotEqual(BluetoothUUID.weightScale, .bit32(0x181D))

    }

    /// Test Bond Management
    func testBondManagement() {

         XCTAssertEqual(BluetoothUUID.bondManagement.rawValue, "181E")
         XCTAssertEqual(BluetoothUUID.bondManagement, .bit16(0x181E))
         XCTAssertEqual(BluetoothUUID.bondManagement, .bit16(6174))
         XCTAssertEqual(BluetoothUUID.bondManagement.name, "Bond Management")
         XCTAssertNotEqual(BluetoothUUID.bondManagement, .bit32(6174))
         XCTAssertNotEqual(BluetoothUUID.bondManagement, .bit32(0x181E))

    }

    /// Test Continuous Glucose Monitoring
    func testContinuousGlucoseMonitoring() {

         XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring.rawValue, "181F")
         XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit16(0x181F))
         XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit16(6175))
         XCTAssertEqual(BluetoothUUID.continuousGlucoseMonitoring.name, "Continuous Glucose Monitoring")
         XCTAssertNotEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit32(6175))
         XCTAssertNotEqual(BluetoothUUID.continuousGlucoseMonitoring, .bit32(0x181F))

    }

    /// Test Internet Protocol Support
    func testInternetProtocolSupport() {

         XCTAssertEqual(BluetoothUUID.internetProtocolSupport.rawValue, "1820")
         XCTAssertEqual(BluetoothUUID.internetProtocolSupport, .bit16(0x1820))
         XCTAssertEqual(BluetoothUUID.internetProtocolSupport, .bit16(6176))
         XCTAssertEqual(BluetoothUUID.internetProtocolSupport.name, "Internet Protocol Support")
         XCTAssertNotEqual(BluetoothUUID.internetProtocolSupport, .bit32(6176))
         XCTAssertNotEqual(BluetoothUUID.internetProtocolSupport, .bit32(0x1820))

    }

    /// Test Indoor Positioning
    func testIndoorPositioning() {

         XCTAssertEqual(BluetoothUUID.indoorPositioning.rawValue, "1821")
         XCTAssertEqual(BluetoothUUID.indoorPositioning, .bit16(0x1821))
         XCTAssertEqual(BluetoothUUID.indoorPositioning, .bit16(6177))
         XCTAssertEqual(BluetoothUUID.indoorPositioning.name, "Indoor Positioning")
         XCTAssertNotEqual(BluetoothUUID.indoorPositioning, .bit32(6177))
         XCTAssertNotEqual(BluetoothUUID.indoorPositioning, .bit32(0x1821))

    }

    /// Test Pulse Oximeter
    func testPulseOximeter() {

         XCTAssertEqual(BluetoothUUID.pulseOximeter.rawValue, "1822")
         XCTAssertEqual(BluetoothUUID.pulseOximeter, .bit16(0x1822))
         XCTAssertEqual(BluetoothUUID.pulseOximeter, .bit16(6178))
         XCTAssertEqual(BluetoothUUID.pulseOximeter.name, "Pulse Oximeter")
         XCTAssertNotEqual(BluetoothUUID.pulseOximeter, .bit32(6178))
         XCTAssertNotEqual(BluetoothUUID.pulseOximeter, .bit32(0x1822))

    }

    /// Test HTTP Proxy
    func testHttpProxy() {

         XCTAssertEqual(BluetoothUUID.httpProxy.rawValue, "1823")
         XCTAssertEqual(BluetoothUUID.httpProxy, .bit16(0x1823))
         XCTAssertEqual(BluetoothUUID.httpProxy, .bit16(6179))
         XCTAssertEqual(BluetoothUUID.httpProxy.name, "HTTP Proxy")
         XCTAssertNotEqual(BluetoothUUID.httpProxy, .bit32(6179))
         XCTAssertNotEqual(BluetoothUUID.httpProxy, .bit32(0x1823))

    }

    /// Test Transport Discovery
    func testTransportDiscovery() {

         XCTAssertEqual(BluetoothUUID.transportDiscovery.rawValue, "1824")
         XCTAssertEqual(BluetoothUUID.transportDiscovery, .bit16(0x1824))
         XCTAssertEqual(BluetoothUUID.transportDiscovery, .bit16(6180))
         XCTAssertEqual(BluetoothUUID.transportDiscovery.name, "Transport Discovery")
         XCTAssertNotEqual(BluetoothUUID.transportDiscovery, .bit32(6180))
         XCTAssertNotEqual(BluetoothUUID.transportDiscovery, .bit32(0x1824))

    }

    /// Test Object Transfer
    func testObjectTransfer() {

         XCTAssertEqual(BluetoothUUID.objectTransfer.rawValue, "1825")
         XCTAssertEqual(BluetoothUUID.objectTransfer, .bit16(0x1825))
         XCTAssertEqual(BluetoothUUID.objectTransfer, .bit16(6181))
         XCTAssertEqual(BluetoothUUID.objectTransfer.name, "Object Transfer")
         XCTAssertNotEqual(BluetoothUUID.objectTransfer, .bit32(6181))
         XCTAssertNotEqual(BluetoothUUID.objectTransfer, .bit32(0x1825))

    }

    /// Test Primary Service
    func testPrimaryService() {

         XCTAssertEqual(BluetoothUUID.primaryService.rawValue, "2800")
         XCTAssertEqual(BluetoothUUID.primaryService, .bit16(0x2800))
         XCTAssertEqual(BluetoothUUID.primaryService, .bit16(10240))
         XCTAssertEqual(BluetoothUUID.primaryService.name, "Primary Service")
         XCTAssertNotEqual(BluetoothUUID.primaryService, .bit32(10240))
         XCTAssertNotEqual(BluetoothUUID.primaryService, .bit32(0x2800))

    }

    /// Test Secondary Service
    func testSecondaryService() {

         XCTAssertEqual(BluetoothUUID.secondaryService.rawValue, "2801")
         XCTAssertEqual(BluetoothUUID.secondaryService, .bit16(0x2801))
         XCTAssertEqual(BluetoothUUID.secondaryService, .bit16(10241))
         XCTAssertEqual(BluetoothUUID.secondaryService.name, "Secondary Service")
         XCTAssertNotEqual(BluetoothUUID.secondaryService, .bit32(10241))
         XCTAssertNotEqual(BluetoothUUID.secondaryService, .bit32(0x2801))

    }

    /// Test Include
    func testInclude() {

         XCTAssertEqual(BluetoothUUID.include.rawValue, "2802")
         XCTAssertEqual(BluetoothUUID.include, .bit16(0x2802))
         XCTAssertEqual(BluetoothUUID.include, .bit16(10242))
         XCTAssertEqual(BluetoothUUID.include.name, "Include")
         XCTAssertNotEqual(BluetoothUUID.include, .bit32(10242))
         XCTAssertNotEqual(BluetoothUUID.include, .bit32(0x2802))

    }

    /// Test Characteristic
    func testCharacteristic() {

         XCTAssertEqual(BluetoothUUID.characteristic.rawValue, "2803")
         XCTAssertEqual(BluetoothUUID.characteristic, .bit16(0x2803))
         XCTAssertEqual(BluetoothUUID.characteristic, .bit16(10243))
         XCTAssertEqual(BluetoothUUID.characteristic.name, "Characteristic")
         XCTAssertNotEqual(BluetoothUUID.characteristic, .bit32(10243))
         XCTAssertNotEqual(BluetoothUUID.characteristic, .bit32(0x2803))

    }

    /// Test Characteristic Extended Properties
    func testCharacteristicExtendedProperties() {

         XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties.rawValue, "2900")
         XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties, .bit16(0x2900))
         XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties, .bit16(10496))
         XCTAssertEqual(BluetoothUUID.characteristicExtendedProperties.name, "Characteristic Extended Properties")
         XCTAssertNotEqual(BluetoothUUID.characteristicExtendedProperties, .bit32(10496))
         XCTAssertNotEqual(BluetoothUUID.characteristicExtendedProperties, .bit32(0x2900))

    }

    /// Test Characteristic User Description
    func testCharacteristicUserDescription() {

         XCTAssertEqual(BluetoothUUID.characteristicUserDescription.rawValue, "2901")
         XCTAssertEqual(BluetoothUUID.characteristicUserDescription, .bit16(0x2901))
         XCTAssertEqual(BluetoothUUID.characteristicUserDescription, .bit16(10497))
         XCTAssertEqual(BluetoothUUID.characteristicUserDescription.name, "Characteristic User Description")
         XCTAssertNotEqual(BluetoothUUID.characteristicUserDescription, .bit32(10497))
         XCTAssertNotEqual(BluetoothUUID.characteristicUserDescription, .bit32(0x2901))

    }

    /// Test Client Characteristic Configuration
    func testClientCharacteristicConfiguration() {

         XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration.rawValue, "2902")
         XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit16(0x2902))
         XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit16(10498))
         XCTAssertEqual(BluetoothUUID.clientCharacteristicConfiguration.name, "Client Characteristic Configuration")
         XCTAssertNotEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit32(10498))
         XCTAssertNotEqual(BluetoothUUID.clientCharacteristicConfiguration, .bit32(0x2902))

    }

    /// Test Server Characteristic Configuration
    func testServerCharacteristicConfiguration() {

         XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration.rawValue, "2903")
         XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit16(0x2903))
         XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit16(10499))
         XCTAssertEqual(BluetoothUUID.serverCharacteristicConfiguration.name, "Server Characteristic Configuration")
         XCTAssertNotEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit32(10499))
         XCTAssertNotEqual(BluetoothUUID.serverCharacteristicConfiguration, .bit32(0x2903))

    }

    /// Test Characteristic Format
    func testCharacteristicFormat() {

         XCTAssertEqual(BluetoothUUID.characteristicFormat.rawValue, "2904")
         XCTAssertEqual(BluetoothUUID.characteristicFormat, .bit16(0x2904))
         XCTAssertEqual(BluetoothUUID.characteristicFormat, .bit16(10500))
         XCTAssertEqual(BluetoothUUID.characteristicFormat.name, "Characteristic Format")
         XCTAssertNotEqual(BluetoothUUID.characteristicFormat, .bit32(10500))
         XCTAssertNotEqual(BluetoothUUID.characteristicFormat, .bit32(0x2904))

    }

    /// Test Characteristic Aggregate Format
    func testCharacteristicAggregateFormat() {

         XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat.rawValue, "2905")
         XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat, .bit16(0x2905))
         XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat, .bit16(10501))
         XCTAssertEqual(BluetoothUUID.characteristicAggregateFormat.name, "Characteristic Aggregate Format")
         XCTAssertNotEqual(BluetoothUUID.characteristicAggregateFormat, .bit32(10501))
         XCTAssertNotEqual(BluetoothUUID.characteristicAggregateFormat, .bit32(0x2905))

    }

    /// Test Valid Range
    func testValidRange() {

         XCTAssertEqual(BluetoothUUID.validRange.rawValue, "2906")
         XCTAssertEqual(BluetoothUUID.validRange, .bit16(0x2906))
         XCTAssertEqual(BluetoothUUID.validRange, .bit16(10502))
         XCTAssertEqual(BluetoothUUID.validRange.name, "Valid Range")
         XCTAssertNotEqual(BluetoothUUID.validRange, .bit32(10502))
         XCTAssertNotEqual(BluetoothUUID.validRange, .bit32(0x2906))

    }

    /// Test External Report Reference
    func testExternalReportReference() {

         XCTAssertEqual(BluetoothUUID.externalReportReference.rawValue, "2907")
         XCTAssertEqual(BluetoothUUID.externalReportReference, .bit16(0x2907))
         XCTAssertEqual(BluetoothUUID.externalReportReference, .bit16(10503))
         XCTAssertEqual(BluetoothUUID.externalReportReference.name, "External Report Reference")
         XCTAssertNotEqual(BluetoothUUID.externalReportReference, .bit32(10503))
         XCTAssertNotEqual(BluetoothUUID.externalReportReference, .bit32(0x2907))

    }

    /// Test Report Reference
    func testReportReference() {

         XCTAssertEqual(BluetoothUUID.reportReference.rawValue, "2908")
         XCTAssertEqual(BluetoothUUID.reportReference, .bit16(0x2908))
         XCTAssertEqual(BluetoothUUID.reportReference, .bit16(10504))
         XCTAssertEqual(BluetoothUUID.reportReference.name, "Report Reference")
         XCTAssertNotEqual(BluetoothUUID.reportReference, .bit32(10504))
         XCTAssertNotEqual(BluetoothUUID.reportReference, .bit32(0x2908))

    }

    /// Test Number of Digitals
    func testNumberOfDigitals() {

         XCTAssertEqual(BluetoothUUID.numberOfDigitals.rawValue, "2909")
         XCTAssertEqual(BluetoothUUID.numberOfDigitals, .bit16(0x2909))
         XCTAssertEqual(BluetoothUUID.numberOfDigitals, .bit16(10505))
         XCTAssertEqual(BluetoothUUID.numberOfDigitals.name, "Number of Digitals")
         XCTAssertNotEqual(BluetoothUUID.numberOfDigitals, .bit32(10505))
         XCTAssertNotEqual(BluetoothUUID.numberOfDigitals, .bit32(0x2909))

    }

    /// Test Value Trigger Setting
    func testValueTriggerSetting() {

         XCTAssertEqual(BluetoothUUID.valueTriggerSetting.rawValue, "290A")
         XCTAssertEqual(BluetoothUUID.valueTriggerSetting, .bit16(0x290A))
         XCTAssertEqual(BluetoothUUID.valueTriggerSetting, .bit16(10506))
         XCTAssertEqual(BluetoothUUID.valueTriggerSetting.name, "Value Trigger Setting")
         XCTAssertNotEqual(BluetoothUUID.valueTriggerSetting, .bit32(10506))
         XCTAssertNotEqual(BluetoothUUID.valueTriggerSetting, .bit32(0x290A))

    }

    /// Test Environmental Sensing Configuration
    func testEnvironmentalSensingConfiguration() {

         XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration.rawValue, "290B")
         XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration, .bit16(0x290B))
         XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration, .bit16(10507))
         XCTAssertEqual(BluetoothUUID.environmentalSensingConfiguration.name, "Environmental Sensing Configuration")
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingConfiguration, .bit32(10507))
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingConfiguration, .bit32(0x290B))

    }

    /// Test Environmental Sensing Measurement
    func testEnvironmentalSensingMeasurement() {

         XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement.rawValue, "290C")
         XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement, .bit16(0x290C))
         XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement, .bit16(10508))
         XCTAssertEqual(BluetoothUUID.environmentalSensingMeasurement.name, "Environmental Sensing Measurement")
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingMeasurement, .bit32(10508))
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingMeasurement, .bit32(0x290C))

    }

    /// Test Environmental Sensing Trigger Setting
    func testEnvironmentalSensingTriggerSetting() {

         XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting.rawValue, "290D")
         XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit16(0x290D))
         XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit16(10509))
         XCTAssertEqual(BluetoothUUID.environmentalSensingTriggerSetting.name, "Environmental Sensing Trigger Setting")
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit32(10509))
         XCTAssertNotEqual(BluetoothUUID.environmentalSensingTriggerSetting, .bit32(0x290D))

    }

    /// Test Time Trigger Setting
    func testTimeTriggerSetting() {

         XCTAssertEqual(BluetoothUUID.timeTriggerSetting.rawValue, "290E")
         XCTAssertEqual(BluetoothUUID.timeTriggerSetting, .bit16(0x290E))
         XCTAssertEqual(BluetoothUUID.timeTriggerSetting, .bit16(10510))
         XCTAssertEqual(BluetoothUUID.timeTriggerSetting.name, "Time Trigger Setting")
         XCTAssertNotEqual(BluetoothUUID.timeTriggerSetting, .bit32(10510))
         XCTAssertNotEqual(BluetoothUUID.timeTriggerSetting, .bit32(0x290E))

    }

    /// Test Device Name
    func testDeviceName() {

         XCTAssertEqual(BluetoothUUID.deviceName.rawValue, "2A00")
         XCTAssertEqual(BluetoothUUID.deviceName, .bit16(0x2A00))
         XCTAssertEqual(BluetoothUUID.deviceName, .bit16(10752))
         XCTAssertEqual(BluetoothUUID.deviceName.name, "Device Name")
         XCTAssertNotEqual(BluetoothUUID.deviceName, .bit32(10752))
         XCTAssertNotEqual(BluetoothUUID.deviceName, .bit32(0x2A00))

    }

    /// Test Appearance
    func testAppearance() {

         XCTAssertEqual(BluetoothUUID.appearance.rawValue, "2A01")
         XCTAssertEqual(BluetoothUUID.appearance, .bit16(0x2A01))
         XCTAssertEqual(BluetoothUUID.appearance, .bit16(10753))
         XCTAssertEqual(BluetoothUUID.appearance.name, "Appearance")
         XCTAssertNotEqual(BluetoothUUID.appearance, .bit32(10753))
         XCTAssertNotEqual(BluetoothUUID.appearance, .bit32(0x2A01))

    }

    /// Test Peripheral Privacy Flag
    func testPeripheralPrivacyFlag() {

         XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag.rawValue, "2A02")
         XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag, .bit16(0x2A02))
         XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag, .bit16(10754))
         XCTAssertEqual(BluetoothUUID.peripheralPrivacyFlag.name, "Peripheral Privacy Flag")
         XCTAssertNotEqual(BluetoothUUID.peripheralPrivacyFlag, .bit32(10754))
         XCTAssertNotEqual(BluetoothUUID.peripheralPrivacyFlag, .bit32(0x2A02))

    }

    /// Test Reconnection Address
    func testReconnectionAddress() {

         XCTAssertEqual(BluetoothUUID.reconnectionAddress.rawValue, "2A03")
         XCTAssertEqual(BluetoothUUID.reconnectionAddress, .bit16(0x2A03))
         XCTAssertEqual(BluetoothUUID.reconnectionAddress, .bit16(10755))
         XCTAssertEqual(BluetoothUUID.reconnectionAddress.name, "Reconnection Address")
         XCTAssertNotEqual(BluetoothUUID.reconnectionAddress, .bit32(10755))
         XCTAssertNotEqual(BluetoothUUID.reconnectionAddress, .bit32(0x2A03))

    }

    /// Test Peripheral Preferred Connection Parameters
    func testPeripheralPreferredConnectionParameters() {

         XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters.rawValue, "2A04")
         XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit16(0x2A04))
         XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit16(10756))
         XCTAssertEqual(BluetoothUUID.peripheralPreferredConnectionParameters.name, "Peripheral Preferred Connection Parameters")
         XCTAssertNotEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit32(10756))
         XCTAssertNotEqual(BluetoothUUID.peripheralPreferredConnectionParameters, .bit32(0x2A04))

    }

    /// Test Service Changed
    func testServiceChanged() {

         XCTAssertEqual(BluetoothUUID.serviceChanged.rawValue, "2A05")
         XCTAssertEqual(BluetoothUUID.serviceChanged, .bit16(0x2A05))
         XCTAssertEqual(BluetoothUUID.serviceChanged, .bit16(10757))
         XCTAssertEqual(BluetoothUUID.serviceChanged.name, "Service Changed")
         XCTAssertNotEqual(BluetoothUUID.serviceChanged, .bit32(10757))
         XCTAssertNotEqual(BluetoothUUID.serviceChanged, .bit32(0x2A05))

    }

    /// Test Alert Level
    func testAlertLevel() {

         XCTAssertEqual(BluetoothUUID.alertLevel.rawValue, "2A06")
         XCTAssertEqual(BluetoothUUID.alertLevel, .bit16(0x2A06))
         XCTAssertEqual(BluetoothUUID.alertLevel, .bit16(10758))
         XCTAssertEqual(BluetoothUUID.alertLevel.name, "Alert Level")
         XCTAssertNotEqual(BluetoothUUID.alertLevel, .bit32(10758))
         XCTAssertNotEqual(BluetoothUUID.alertLevel, .bit32(0x2A06))

    }

    /// Test Tx Power Level
    func testTxPowerLevel() {

         XCTAssertEqual(BluetoothUUID.txPowerLevel.rawValue, "2A07")
         XCTAssertEqual(BluetoothUUID.txPowerLevel, .bit16(0x2A07))
         XCTAssertEqual(BluetoothUUID.txPowerLevel, .bit16(10759))
         XCTAssertEqual(BluetoothUUID.txPowerLevel.name, "Tx Power Level")
         XCTAssertNotEqual(BluetoothUUID.txPowerLevel, .bit32(10759))
         XCTAssertNotEqual(BluetoothUUID.txPowerLevel, .bit32(0x2A07))

    }

    /// Test Date Time
    func testDateTime() {

         XCTAssertEqual(BluetoothUUID.dateTime.rawValue, "2A08")
         XCTAssertEqual(BluetoothUUID.dateTime, .bit16(0x2A08))
         XCTAssertEqual(BluetoothUUID.dateTime, .bit16(10760))
         XCTAssertEqual(BluetoothUUID.dateTime.name, "Date Time")
         XCTAssertNotEqual(BluetoothUUID.dateTime, .bit32(10760))
         XCTAssertNotEqual(BluetoothUUID.dateTime, .bit32(0x2A08))

    }

    /// Test Day of Week
    func testDayOfWeek() {

         XCTAssertEqual(BluetoothUUID.dayOfWeek.rawValue, "2A09")
         XCTAssertEqual(BluetoothUUID.dayOfWeek, .bit16(0x2A09))
         XCTAssertEqual(BluetoothUUID.dayOfWeek, .bit16(10761))
         XCTAssertEqual(BluetoothUUID.dayOfWeek.name, "Day of Week")
         XCTAssertNotEqual(BluetoothUUID.dayOfWeek, .bit32(10761))
         XCTAssertNotEqual(BluetoothUUID.dayOfWeek, .bit32(0x2A09))

    }

    /// Test Day Date Time
    func testDayDateTime() {

         XCTAssertEqual(BluetoothUUID.dayDateTime.rawValue, "2A0A")
         XCTAssertEqual(BluetoothUUID.dayDateTime, .bit16(0x2A0A))
         XCTAssertEqual(BluetoothUUID.dayDateTime, .bit16(10762))
         XCTAssertEqual(BluetoothUUID.dayDateTime.name, "Day Date Time")
         XCTAssertNotEqual(BluetoothUUID.dayDateTime, .bit32(10762))
         XCTAssertNotEqual(BluetoothUUID.dayDateTime, .bit32(0x2A0A))

    }

    /// Test Exact Time 256
    func testExactTime256() {

         XCTAssertEqual(BluetoothUUID.exactTime256.rawValue, "2A0C")
         XCTAssertEqual(BluetoothUUID.exactTime256, .bit16(0x2A0C))
         XCTAssertEqual(BluetoothUUID.exactTime256, .bit16(10764))
         XCTAssertEqual(BluetoothUUID.exactTime256.name, "Exact Time 256")
         XCTAssertNotEqual(BluetoothUUID.exactTime256, .bit32(10764))
         XCTAssertNotEqual(BluetoothUUID.exactTime256, .bit32(0x2A0C))

    }

    /// Test DST Offset
    func testDstOffset() {

         XCTAssertEqual(BluetoothUUID.dstOffset.rawValue, "2A0D")
         XCTAssertEqual(BluetoothUUID.dstOffset, .bit16(0x2A0D))
         XCTAssertEqual(BluetoothUUID.dstOffset, .bit16(10765))
         XCTAssertEqual(BluetoothUUID.dstOffset.name, "DST Offset")
         XCTAssertNotEqual(BluetoothUUID.dstOffset, .bit32(10765))
         XCTAssertNotEqual(BluetoothUUID.dstOffset, .bit32(0x2A0D))

    }

    /// Test Time Zone
    func testTimeZone() {

         XCTAssertEqual(BluetoothUUID.timeZone.rawValue, "2A0E")
         XCTAssertEqual(BluetoothUUID.timeZone, .bit16(0x2A0E))
         XCTAssertEqual(BluetoothUUID.timeZone, .bit16(10766))
         XCTAssertEqual(BluetoothUUID.timeZone.name, "Time Zone")
         XCTAssertNotEqual(BluetoothUUID.timeZone, .bit32(10766))
         XCTAssertNotEqual(BluetoothUUID.timeZone, .bit32(0x2A0E))

    }

    /// Test Local Time Information
    func testLocalTimeInformation() {

         XCTAssertEqual(BluetoothUUID.localTimeInformation.rawValue, "2A0F")
         XCTAssertEqual(BluetoothUUID.localTimeInformation, .bit16(0x2A0F))
         XCTAssertEqual(BluetoothUUID.localTimeInformation, .bit16(10767))
         XCTAssertEqual(BluetoothUUID.localTimeInformation.name, "Local Time Information")
         XCTAssertNotEqual(BluetoothUUID.localTimeInformation, .bit32(10767))
         XCTAssertNotEqual(BluetoothUUID.localTimeInformation, .bit32(0x2A0F))

    }

    /// Test Time with DST
    func testTimeWithDst() {

         XCTAssertEqual(BluetoothUUID.timeWithDst.rawValue, "2A11")
         XCTAssertEqual(BluetoothUUID.timeWithDst, .bit16(0x2A11))
         XCTAssertEqual(BluetoothUUID.timeWithDst, .bit16(10769))
         XCTAssertEqual(BluetoothUUID.timeWithDst.name, "Time with DST")
         XCTAssertNotEqual(BluetoothUUID.timeWithDst, .bit32(10769))
         XCTAssertNotEqual(BluetoothUUID.timeWithDst, .bit32(0x2A11))

    }

    /// Test Time Accuracy
    func testTimeAccuracy() {

         XCTAssertEqual(BluetoothUUID.timeAccuracy.rawValue, "2A12")
         XCTAssertEqual(BluetoothUUID.timeAccuracy, .bit16(0x2A12))
         XCTAssertEqual(BluetoothUUID.timeAccuracy, .bit16(10770))
         XCTAssertEqual(BluetoothUUID.timeAccuracy.name, "Time Accuracy")
         XCTAssertNotEqual(BluetoothUUID.timeAccuracy, .bit32(10770))
         XCTAssertNotEqual(BluetoothUUID.timeAccuracy, .bit32(0x2A12))

    }

    /// Test Time Source
    func testTimeSource() {

         XCTAssertEqual(BluetoothUUID.timeSource.rawValue, "2A13")
         XCTAssertEqual(BluetoothUUID.timeSource, .bit16(0x2A13))
         XCTAssertEqual(BluetoothUUID.timeSource, .bit16(10771))
         XCTAssertEqual(BluetoothUUID.timeSource.name, "Time Source")
         XCTAssertNotEqual(BluetoothUUID.timeSource, .bit32(10771))
         XCTAssertNotEqual(BluetoothUUID.timeSource, .bit32(0x2A13))

    }

    /// Test Reference Time Information
    func testReferenceTimeInformation() {

         XCTAssertEqual(BluetoothUUID.referenceTimeInformation.rawValue, "2A14")
         XCTAssertEqual(BluetoothUUID.referenceTimeInformation, .bit16(0x2A14))
         XCTAssertEqual(BluetoothUUID.referenceTimeInformation, .bit16(10772))
         XCTAssertEqual(BluetoothUUID.referenceTimeInformation.name, "Reference Time Information")
         XCTAssertNotEqual(BluetoothUUID.referenceTimeInformation, .bit32(10772))
         XCTAssertNotEqual(BluetoothUUID.referenceTimeInformation, .bit32(0x2A14))

    }

    /// Test Time Update Control Point
    func testTimeUpdateControlPoint() {

         XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint.rawValue, "2A16")
         XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint, .bit16(0x2A16))
         XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint, .bit16(10774))
         XCTAssertEqual(BluetoothUUID.timeUpdateControlPoint.name, "Time Update Control Point")
         XCTAssertNotEqual(BluetoothUUID.timeUpdateControlPoint, .bit32(10774))
         XCTAssertNotEqual(BluetoothUUID.timeUpdateControlPoint, .bit32(0x2A16))

    }

    /// Test Time Update State
    func testTimeUpdateState() {

         XCTAssertEqual(BluetoothUUID.timeUpdateState.rawValue, "2A17")
         XCTAssertEqual(BluetoothUUID.timeUpdateState, .bit16(0x2A17))
         XCTAssertEqual(BluetoothUUID.timeUpdateState, .bit16(10775))
         XCTAssertEqual(BluetoothUUID.timeUpdateState.name, "Time Update State")
         XCTAssertNotEqual(BluetoothUUID.timeUpdateState, .bit32(10775))
         XCTAssertNotEqual(BluetoothUUID.timeUpdateState, .bit32(0x2A17))

    }

    /// Test Glucose Measurement
    func testGlucoseMeasurement() {

         XCTAssertEqual(BluetoothUUID.glucoseMeasurement.rawValue, "2A18")
         XCTAssertEqual(BluetoothUUID.glucoseMeasurement, .bit16(0x2A18))
         XCTAssertEqual(BluetoothUUID.glucoseMeasurement, .bit16(10776))
         XCTAssertEqual(BluetoothUUID.glucoseMeasurement.name, "Glucose Measurement")
         XCTAssertNotEqual(BluetoothUUID.glucoseMeasurement, .bit32(10776))
         XCTAssertNotEqual(BluetoothUUID.glucoseMeasurement, .bit32(0x2A18))

    }

    /// Test Battery Level
    func testBatteryLevel() {

         XCTAssertEqual(BluetoothUUID.batteryLevel.rawValue, "2A19")
         XCTAssertEqual(BluetoothUUID.batteryLevel, .bit16(0x2A19))
         XCTAssertEqual(BluetoothUUID.batteryLevel, .bit16(10777))
         XCTAssertEqual(BluetoothUUID.batteryLevel.name, "Battery Level")
         XCTAssertNotEqual(BluetoothUUID.batteryLevel, .bit32(10777))
         XCTAssertNotEqual(BluetoothUUID.batteryLevel, .bit32(0x2A19))

    }

    /// Test Temperature Measurement
    func testTemperatureMeasurement() {

         XCTAssertEqual(BluetoothUUID.temperatureMeasurement.rawValue, "2A1C")
         XCTAssertEqual(BluetoothUUID.temperatureMeasurement, .bit16(0x2A1C))
         XCTAssertEqual(BluetoothUUID.temperatureMeasurement, .bit16(10780))
         XCTAssertEqual(BluetoothUUID.temperatureMeasurement.name, "Temperature Measurement")
         XCTAssertNotEqual(BluetoothUUID.temperatureMeasurement, .bit32(10780))
         XCTAssertNotEqual(BluetoothUUID.temperatureMeasurement, .bit32(0x2A1C))

    }

    /// Test Temperature Type
    func testTemperatureType() {

         XCTAssertEqual(BluetoothUUID.temperatureType.rawValue, "2A1D")
         XCTAssertEqual(BluetoothUUID.temperatureType, .bit16(0x2A1D))
         XCTAssertEqual(BluetoothUUID.temperatureType, .bit16(10781))
         XCTAssertEqual(BluetoothUUID.temperatureType.name, "Temperature Type")
         XCTAssertNotEqual(BluetoothUUID.temperatureType, .bit32(10781))
         XCTAssertNotEqual(BluetoothUUID.temperatureType, .bit32(0x2A1D))

    }

    /// Test Intermediate Temperature
    func testIntermediateTemperature() {

         XCTAssertEqual(BluetoothUUID.intermediateTemperature.rawValue, "2A1E")
         XCTAssertEqual(BluetoothUUID.intermediateTemperature, .bit16(0x2A1E))
         XCTAssertEqual(BluetoothUUID.intermediateTemperature, .bit16(10782))
         XCTAssertEqual(BluetoothUUID.intermediateTemperature.name, "Intermediate Temperature")
         XCTAssertNotEqual(BluetoothUUID.intermediateTemperature, .bit32(10782))
         XCTAssertNotEqual(BluetoothUUID.intermediateTemperature, .bit32(0x2A1E))

    }

    /// Test Measurement Interval
    func testMeasurementInterval() {

         XCTAssertEqual(BluetoothUUID.measurementInterval.rawValue, "2A21")
         XCTAssertEqual(BluetoothUUID.measurementInterval, .bit16(0x2A21))
         XCTAssertEqual(BluetoothUUID.measurementInterval, .bit16(10785))
         XCTAssertEqual(BluetoothUUID.measurementInterval.name, "Measurement Interval")
         XCTAssertNotEqual(BluetoothUUID.measurementInterval, .bit32(10785))
         XCTAssertNotEqual(BluetoothUUID.measurementInterval, .bit32(0x2A21))

    }

    /// Test Boot Keyboard Input Report
    func testBootKeyboardInputReport() {

         XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport.rawValue, "2A22")
         XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport, .bit16(0x2A22))
         XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport, .bit16(10786))
         XCTAssertEqual(BluetoothUUID.bootKeyboardInputReport.name, "Boot Keyboard Input Report")
         XCTAssertNotEqual(BluetoothUUID.bootKeyboardInputReport, .bit32(10786))
         XCTAssertNotEqual(BluetoothUUID.bootKeyboardInputReport, .bit32(0x2A22))

    }

    /// Test System ID
    func testSystemId() {

         XCTAssertEqual(BluetoothUUID.systemId.rawValue, "2A23")
         XCTAssertEqual(BluetoothUUID.systemId, .bit16(0x2A23))
         XCTAssertEqual(BluetoothUUID.systemId, .bit16(10787))
         XCTAssertEqual(BluetoothUUID.systemId.name, "System ID")
         XCTAssertNotEqual(BluetoothUUID.systemId, .bit32(10787))
         XCTAssertNotEqual(BluetoothUUID.systemId, .bit32(0x2A23))

    }

    /// Test Model Number String
    func testModelNumberString() {

         XCTAssertEqual(BluetoothUUID.modelNumberString.rawValue, "2A24")
         XCTAssertEqual(BluetoothUUID.modelNumberString, .bit16(0x2A24))
         XCTAssertEqual(BluetoothUUID.modelNumberString, .bit16(10788))
         XCTAssertEqual(BluetoothUUID.modelNumberString.name, "Model Number String")
         XCTAssertNotEqual(BluetoothUUID.modelNumberString, .bit32(10788))
         XCTAssertNotEqual(BluetoothUUID.modelNumberString, .bit32(0x2A24))

    }

    /// Test Serial Number String
    func testSerialNumberString() {

         XCTAssertEqual(BluetoothUUID.serialNumberString.rawValue, "2A25")
         XCTAssertEqual(BluetoothUUID.serialNumberString, .bit16(0x2A25))
         XCTAssertEqual(BluetoothUUID.serialNumberString, .bit16(10789))
         XCTAssertEqual(BluetoothUUID.serialNumberString.name, "Serial Number String")
         XCTAssertNotEqual(BluetoothUUID.serialNumberString, .bit32(10789))
         XCTAssertNotEqual(BluetoothUUID.serialNumberString, .bit32(0x2A25))

    }

    /// Test Firmware Revision String
    func testFirmwareRevisionString() {

         XCTAssertEqual(BluetoothUUID.firmwareRevisionString.rawValue, "2A26")
         XCTAssertEqual(BluetoothUUID.firmwareRevisionString, .bit16(0x2A26))
         XCTAssertEqual(BluetoothUUID.firmwareRevisionString, .bit16(10790))
         XCTAssertEqual(BluetoothUUID.firmwareRevisionString.name, "Firmware Revision String")
         XCTAssertNotEqual(BluetoothUUID.firmwareRevisionString, .bit32(10790))
         XCTAssertNotEqual(BluetoothUUID.firmwareRevisionString, .bit32(0x2A26))

    }

    /// Test Hardware Revision String
    func testHardwareRevisionString() {

         XCTAssertEqual(BluetoothUUID.hardwareRevisionString.rawValue, "2A27")
         XCTAssertEqual(BluetoothUUID.hardwareRevisionString, .bit16(0x2A27))
         XCTAssertEqual(BluetoothUUID.hardwareRevisionString, .bit16(10791))
         XCTAssertEqual(BluetoothUUID.hardwareRevisionString.name, "Hardware Revision String")
         XCTAssertNotEqual(BluetoothUUID.hardwareRevisionString, .bit32(10791))
         XCTAssertNotEqual(BluetoothUUID.hardwareRevisionString, .bit32(0x2A27))

    }

    /// Test Software Revision String
    func testSoftwareRevisionString() {

         XCTAssertEqual(BluetoothUUID.softwareRevisionString.rawValue, "2A28")
         XCTAssertEqual(BluetoothUUID.softwareRevisionString, .bit16(0x2A28))
         XCTAssertEqual(BluetoothUUID.softwareRevisionString, .bit16(10792))
         XCTAssertEqual(BluetoothUUID.softwareRevisionString.name, "Software Revision String")
         XCTAssertNotEqual(BluetoothUUID.softwareRevisionString, .bit32(10792))
         XCTAssertNotEqual(BluetoothUUID.softwareRevisionString, .bit32(0x2A28))

    }

    /// Test Manufacturer Name String
    func testManufacturerNameString() {

         XCTAssertEqual(BluetoothUUID.manufacturerNameString.rawValue, "2A29")
         XCTAssertEqual(BluetoothUUID.manufacturerNameString, .bit16(0x2A29))
         XCTAssertEqual(BluetoothUUID.manufacturerNameString, .bit16(10793))
         XCTAssertEqual(BluetoothUUID.manufacturerNameString.name, "Manufacturer Name String")
         XCTAssertNotEqual(BluetoothUUID.manufacturerNameString, .bit32(10793))
         XCTAssertNotEqual(BluetoothUUID.manufacturerNameString, .bit32(0x2A29))

    }

    /// Test IEEE 11073-20601 Regulatory Cert. Data List
    func testIeee1107320601RegulatoryCertDataList() {

         XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList.rawValue, "2A2A")
         XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit16(0x2A2A))
         XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit16(10794))
         XCTAssertEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList.name, "IEEE 11073-20601 Regulatory Cert. Data List")
         XCTAssertNotEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit32(10794))
         XCTAssertNotEqual(BluetoothUUID.ieee1107320601RegulatoryCertDataList, .bit32(0x2A2A))

    }

    /// Test Current Time
    func testCurrentTime() {

         XCTAssertEqual(BluetoothUUID.currentTime.rawValue, "2A2B")
         XCTAssertEqual(BluetoothUUID.currentTime, .bit16(0x2A2B))
         XCTAssertEqual(BluetoothUUID.currentTime, .bit16(10795))
         XCTAssertEqual(BluetoothUUID.currentTime.name, "Current Time")
         XCTAssertNotEqual(BluetoothUUID.currentTime, .bit32(10795))
         XCTAssertNotEqual(BluetoothUUID.currentTime, .bit32(0x2A2B))

    }

    /// Test Magnetic Declination
    func testMagneticDeclination() {

         XCTAssertEqual(BluetoothUUID.magneticDeclination.rawValue, "2A2C")
         XCTAssertEqual(BluetoothUUID.magneticDeclination, .bit16(0x2A2C))
         XCTAssertEqual(BluetoothUUID.magneticDeclination, .bit16(10796))
         XCTAssertEqual(BluetoothUUID.magneticDeclination.name, "Magnetic Declination")
         XCTAssertNotEqual(BluetoothUUID.magneticDeclination, .bit32(10796))
         XCTAssertNotEqual(BluetoothUUID.magneticDeclination, .bit32(0x2A2C))

    }

    /// Test Scan Refresh
    func testScanRefresh() {

         XCTAssertEqual(BluetoothUUID.scanRefresh.rawValue, "2A31")
         XCTAssertEqual(BluetoothUUID.scanRefresh, .bit16(0x2A31))
         XCTAssertEqual(BluetoothUUID.scanRefresh, .bit16(10801))
         XCTAssertEqual(BluetoothUUID.scanRefresh.name, "Scan Refresh")
         XCTAssertNotEqual(BluetoothUUID.scanRefresh, .bit32(10801))
         XCTAssertNotEqual(BluetoothUUID.scanRefresh, .bit32(0x2A31))

    }

    /// Test Boot Keyboard Output Report
    func testBootKeyboardOutputReport() {

         XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport.rawValue, "2A32")
         XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport, .bit16(0x2A32))
         XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport, .bit16(10802))
         XCTAssertEqual(BluetoothUUID.bootKeyboardOutputReport.name, "Boot Keyboard Output Report")
         XCTAssertNotEqual(BluetoothUUID.bootKeyboardOutputReport, .bit32(10802))
         XCTAssertNotEqual(BluetoothUUID.bootKeyboardOutputReport, .bit32(0x2A32))

    }

    /// Test Boot Mouse Input Report
    func testBootMouseInputReport() {

         XCTAssertEqual(BluetoothUUID.bootMouseInputReport.rawValue, "2A33")
         XCTAssertEqual(BluetoothUUID.bootMouseInputReport, .bit16(0x2A33))
         XCTAssertEqual(BluetoothUUID.bootMouseInputReport, .bit16(10803))
         XCTAssertEqual(BluetoothUUID.bootMouseInputReport.name, "Boot Mouse Input Report")
         XCTAssertNotEqual(BluetoothUUID.bootMouseInputReport, .bit32(10803))
         XCTAssertNotEqual(BluetoothUUID.bootMouseInputReport, .bit32(0x2A33))

    }

    /// Test Glucose Measurement Context
    func testGlucoseMeasurementContext() {

         XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext.rawValue, "2A34")
         XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext, .bit16(0x2A34))
         XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext, .bit16(10804))
         XCTAssertEqual(BluetoothUUID.glucoseMeasurementContext.name, "Glucose Measurement Context")
         XCTAssertNotEqual(BluetoothUUID.glucoseMeasurementContext, .bit32(10804))
         XCTAssertNotEqual(BluetoothUUID.glucoseMeasurementContext, .bit32(0x2A34))

    }

    /// Test Blood Pressure Measurement
    func testBloodPressureMeasurement() {

         XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement.rawValue, "2A35")
         XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement, .bit16(0x2A35))
         XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement, .bit16(10805))
         XCTAssertEqual(BluetoothUUID.bloodPressureMeasurement.name, "Blood Pressure Measurement")
         XCTAssertNotEqual(BluetoothUUID.bloodPressureMeasurement, .bit32(10805))
         XCTAssertNotEqual(BluetoothUUID.bloodPressureMeasurement, .bit32(0x2A35))

    }

    /// Test Intermediate Cuff Pressure
    func testIntermediateCuffPressure() {

         XCTAssertEqual(BluetoothUUID.intermediateCuffPressure.rawValue, "2A36")
         XCTAssertEqual(BluetoothUUID.intermediateCuffPressure, .bit16(0x2A36))
         XCTAssertEqual(BluetoothUUID.intermediateCuffPressure, .bit16(10806))
         XCTAssertEqual(BluetoothUUID.intermediateCuffPressure.name, "Intermediate Cuff Pressure")
         XCTAssertNotEqual(BluetoothUUID.intermediateCuffPressure, .bit32(10806))
         XCTAssertNotEqual(BluetoothUUID.intermediateCuffPressure, .bit32(0x2A36))

    }

    /// Test Heart Rate Measurement
    func testHeartRateMeasurement() {

         XCTAssertEqual(BluetoothUUID.heartRateMeasurement.rawValue, "2A37")
         XCTAssertEqual(BluetoothUUID.heartRateMeasurement, .bit16(0x2A37))
         XCTAssertEqual(BluetoothUUID.heartRateMeasurement, .bit16(10807))
         XCTAssertEqual(BluetoothUUID.heartRateMeasurement.name, "Heart Rate Measurement")
         XCTAssertNotEqual(BluetoothUUID.heartRateMeasurement, .bit32(10807))
         XCTAssertNotEqual(BluetoothUUID.heartRateMeasurement, .bit32(0x2A37))

    }

    /// Test Body Sensor Location
    func testBodySensorLocation() {

         XCTAssertEqual(BluetoothUUID.bodySensorLocation.rawValue, "2A38")
         XCTAssertEqual(BluetoothUUID.bodySensorLocation, .bit16(0x2A38))
         XCTAssertEqual(BluetoothUUID.bodySensorLocation, .bit16(10808))
         XCTAssertEqual(BluetoothUUID.bodySensorLocation.name, "Body Sensor Location")
         XCTAssertNotEqual(BluetoothUUID.bodySensorLocation, .bit32(10808))
         XCTAssertNotEqual(BluetoothUUID.bodySensorLocation, .bit32(0x2A38))

    }

    /// Test Heart Rate Control Point
    func testHeartRateControlPoint() {

         XCTAssertEqual(BluetoothUUID.heartRateControlPoint.rawValue, "2A39")
         XCTAssertEqual(BluetoothUUID.heartRateControlPoint, .bit16(0x2A39))
         XCTAssertEqual(BluetoothUUID.heartRateControlPoint, .bit16(10809))
         XCTAssertEqual(BluetoothUUID.heartRateControlPoint.name, "Heart Rate Control Point")
         XCTAssertNotEqual(BluetoothUUID.heartRateControlPoint, .bit32(10809))
         XCTAssertNotEqual(BluetoothUUID.heartRateControlPoint, .bit32(0x2A39))

    }

    /// Test Alert Status
    func testAlertStatus() {

         XCTAssertEqual(BluetoothUUID.alertStatus.rawValue, "2A3F")
         XCTAssertEqual(BluetoothUUID.alertStatus, .bit16(0x2A3F))
         XCTAssertEqual(BluetoothUUID.alertStatus, .bit16(10815))
         XCTAssertEqual(BluetoothUUID.alertStatus.name, "Alert Status")
         XCTAssertNotEqual(BluetoothUUID.alertStatus, .bit32(10815))
         XCTAssertNotEqual(BluetoothUUID.alertStatus, .bit32(0x2A3F))

    }

    /// Test Ringer Control Point
    func testRingerControlPoint() {

         XCTAssertEqual(BluetoothUUID.ringerControlPoint.rawValue, "2A40")
         XCTAssertEqual(BluetoothUUID.ringerControlPoint, .bit16(0x2A40))
         XCTAssertEqual(BluetoothUUID.ringerControlPoint, .bit16(10816))
         XCTAssertEqual(BluetoothUUID.ringerControlPoint.name, "Ringer Control Point")
         XCTAssertNotEqual(BluetoothUUID.ringerControlPoint, .bit32(10816))
         XCTAssertNotEqual(BluetoothUUID.ringerControlPoint, .bit32(0x2A40))

    }

    /// Test Ringer Setting
    func testRingerSetting() {

         XCTAssertEqual(BluetoothUUID.ringerSetting.rawValue, "2A41")
         XCTAssertEqual(BluetoothUUID.ringerSetting, .bit16(0x2A41))
         XCTAssertEqual(BluetoothUUID.ringerSetting, .bit16(10817))
         XCTAssertEqual(BluetoothUUID.ringerSetting.name, "Ringer Setting")
         XCTAssertNotEqual(BluetoothUUID.ringerSetting, .bit32(10817))
         XCTAssertNotEqual(BluetoothUUID.ringerSetting, .bit32(0x2A41))

    }

    /// Test Alert Category ID Bit Mask
    func testAlertCategoryIdBitMask() {

         XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask.rawValue, "2A42")
         XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask, .bit16(0x2A42))
         XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask, .bit16(10818))
         XCTAssertEqual(BluetoothUUID.alertCategoryIdBitMask.name, "Alert Category ID Bit Mask")
         XCTAssertNotEqual(BluetoothUUID.alertCategoryIdBitMask, .bit32(10818))
         XCTAssertNotEqual(BluetoothUUID.alertCategoryIdBitMask, .bit32(0x2A42))

    }

    /// Test Alert Category ID
    func testAlertCategoryId() {

         XCTAssertEqual(BluetoothUUID.alertCategoryId.rawValue, "2A43")
         XCTAssertEqual(BluetoothUUID.alertCategoryId, .bit16(0x2A43))
         XCTAssertEqual(BluetoothUUID.alertCategoryId, .bit16(10819))
         XCTAssertEqual(BluetoothUUID.alertCategoryId.name, "Alert Category ID")
         XCTAssertNotEqual(BluetoothUUID.alertCategoryId, .bit32(10819))
         XCTAssertNotEqual(BluetoothUUID.alertCategoryId, .bit32(0x2A43))

    }

    /// Test Alert Notification Control Point
    func testAlertNotificationControlPoint() {

         XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint.rawValue, "2A44")
         XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint, .bit16(0x2A44))
         XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint, .bit16(10820))
         XCTAssertEqual(BluetoothUUID.alertNotificationControlPoint.name, "Alert Notification Control Point")
         XCTAssertNotEqual(BluetoothUUID.alertNotificationControlPoint, .bit32(10820))
         XCTAssertNotEqual(BluetoothUUID.alertNotificationControlPoint, .bit32(0x2A44))

    }

    /// Test Unread Alert Status
    func testUnreadAlertStatus() {

         XCTAssertEqual(BluetoothUUID.unreadAlertStatus.rawValue, "2A45")
         XCTAssertEqual(BluetoothUUID.unreadAlertStatus, .bit16(0x2A45))
         XCTAssertEqual(BluetoothUUID.unreadAlertStatus, .bit16(10821))
         XCTAssertEqual(BluetoothUUID.unreadAlertStatus.name, "Unread Alert Status")
         XCTAssertNotEqual(BluetoothUUID.unreadAlertStatus, .bit32(10821))
         XCTAssertNotEqual(BluetoothUUID.unreadAlertStatus, .bit32(0x2A45))

    }

    /// Test New Alert
    func testNewAlert() {

         XCTAssertEqual(BluetoothUUID.newAlert.rawValue, "2A46")
         XCTAssertEqual(BluetoothUUID.newAlert, .bit16(0x2A46))
         XCTAssertEqual(BluetoothUUID.newAlert, .bit16(10822))
         XCTAssertEqual(BluetoothUUID.newAlert.name, "New Alert")
         XCTAssertNotEqual(BluetoothUUID.newAlert, .bit32(10822))
         XCTAssertNotEqual(BluetoothUUID.newAlert, .bit32(0x2A46))

    }

    /// Test Supported New Alert Category
    func testSupportedNewAlertCategory() {

         XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory.rawValue, "2A47")
         XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory, .bit16(0x2A47))
         XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory, .bit16(10823))
         XCTAssertEqual(BluetoothUUID.supportedNewAlertCategory.name, "Supported New Alert Category")
         XCTAssertNotEqual(BluetoothUUID.supportedNewAlertCategory, .bit32(10823))
         XCTAssertNotEqual(BluetoothUUID.supportedNewAlertCategory, .bit32(0x2A47))

    }

    /// Test Supported Unread Alert Category
    func testSupportedUnreadAlertCategory() {

         XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory.rawValue, "2A48")
         XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit16(0x2A48))
         XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit16(10824))
         XCTAssertEqual(BluetoothUUID.supportedUnreadAlertCategory.name, "Supported Unread Alert Category")
         XCTAssertNotEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit32(10824))
         XCTAssertNotEqual(BluetoothUUID.supportedUnreadAlertCategory, .bit32(0x2A48))

    }

    /// Test Blood Pressure Feature
    func testBloodPressureFeature() {

         XCTAssertEqual(BluetoothUUID.bloodPressureFeature.rawValue, "2A49")
         XCTAssertEqual(BluetoothUUID.bloodPressureFeature, .bit16(0x2A49))
         XCTAssertEqual(BluetoothUUID.bloodPressureFeature, .bit16(10825))
         XCTAssertEqual(BluetoothUUID.bloodPressureFeature.name, "Blood Pressure Feature")
         XCTAssertNotEqual(BluetoothUUID.bloodPressureFeature, .bit32(10825))
         XCTAssertNotEqual(BluetoothUUID.bloodPressureFeature, .bit32(0x2A49))

    }

    /// Test HID Information
    func testHidInformation() {

         XCTAssertEqual(BluetoothUUID.hidInformation.rawValue, "2A4A")
         XCTAssertEqual(BluetoothUUID.hidInformation, .bit16(0x2A4A))
         XCTAssertEqual(BluetoothUUID.hidInformation, .bit16(10826))
         XCTAssertEqual(BluetoothUUID.hidInformation.name, "HID Information")
         XCTAssertNotEqual(BluetoothUUID.hidInformation, .bit32(10826))
         XCTAssertNotEqual(BluetoothUUID.hidInformation, .bit32(0x2A4A))

    }

    /// Test Report Map
    func testReportMap() {

         XCTAssertEqual(BluetoothUUID.reportMap.rawValue, "2A4B")
         XCTAssertEqual(BluetoothUUID.reportMap, .bit16(0x2A4B))
         XCTAssertEqual(BluetoothUUID.reportMap, .bit16(10827))
         XCTAssertEqual(BluetoothUUID.reportMap.name, "Report Map")
         XCTAssertNotEqual(BluetoothUUID.reportMap, .bit32(10827))
         XCTAssertNotEqual(BluetoothUUID.reportMap, .bit32(0x2A4B))

    }

    /// Test HID Control Point
    func testHidControlPoint() {

         XCTAssertEqual(BluetoothUUID.hidControlPoint.rawValue, "2A4C")
         XCTAssertEqual(BluetoothUUID.hidControlPoint, .bit16(0x2A4C))
         XCTAssertEqual(BluetoothUUID.hidControlPoint, .bit16(10828))
         XCTAssertEqual(BluetoothUUID.hidControlPoint.name, "HID Control Point")
         XCTAssertNotEqual(BluetoothUUID.hidControlPoint, .bit32(10828))
         XCTAssertNotEqual(BluetoothUUID.hidControlPoint, .bit32(0x2A4C))

    }

    /// Test Report
    func testReport() {

         XCTAssertEqual(BluetoothUUID.report.rawValue, "2A4D")
         XCTAssertEqual(BluetoothUUID.report, .bit16(0x2A4D))
         XCTAssertEqual(BluetoothUUID.report, .bit16(10829))
         XCTAssertEqual(BluetoothUUID.report.name, "Report")
         XCTAssertNotEqual(BluetoothUUID.report, .bit32(10829))
         XCTAssertNotEqual(BluetoothUUID.report, .bit32(0x2A4D))

    }

    /// Test Protocol Mode
    func testProtocolMode() {

         XCTAssertEqual(BluetoothUUID.protocolMode.rawValue, "2A4E")
         XCTAssertEqual(BluetoothUUID.protocolMode, .bit16(0x2A4E))
         XCTAssertEqual(BluetoothUUID.protocolMode, .bit16(10830))
         XCTAssertEqual(BluetoothUUID.protocolMode.name, "Protocol Mode")
         XCTAssertNotEqual(BluetoothUUID.protocolMode, .bit32(10830))
         XCTAssertNotEqual(BluetoothUUID.protocolMode, .bit32(0x2A4E))

    }

    /// Test Scan Interval Window
    func testScanIntervalWindow() {

         XCTAssertEqual(BluetoothUUID.scanIntervalWindow.rawValue, "2A4F")
         XCTAssertEqual(BluetoothUUID.scanIntervalWindow, .bit16(0x2A4F))
         XCTAssertEqual(BluetoothUUID.scanIntervalWindow, .bit16(10831))
         XCTAssertEqual(BluetoothUUID.scanIntervalWindow.name, "Scan Interval Window")
         XCTAssertNotEqual(BluetoothUUID.scanIntervalWindow, .bit32(10831))
         XCTAssertNotEqual(BluetoothUUID.scanIntervalWindow, .bit32(0x2A4F))

    }

    /// Test PnP ID
    func testPnpId() {

         XCTAssertEqual(BluetoothUUID.pnpId.rawValue, "2A50")
         XCTAssertEqual(BluetoothUUID.pnpId, .bit16(0x2A50))
         XCTAssertEqual(BluetoothUUID.pnpId, .bit16(10832))
         XCTAssertEqual(BluetoothUUID.pnpId.name, "PnP ID")
         XCTAssertNotEqual(BluetoothUUID.pnpId, .bit32(10832))
         XCTAssertNotEqual(BluetoothUUID.pnpId, .bit32(0x2A50))

    }

    /// Test Glucose Feature
    func testGlucoseFeature() {

         XCTAssertEqual(BluetoothUUID.glucoseFeature.rawValue, "2A51")
         XCTAssertEqual(BluetoothUUID.glucoseFeature, .bit16(0x2A51))
         XCTAssertEqual(BluetoothUUID.glucoseFeature, .bit16(10833))
         XCTAssertEqual(BluetoothUUID.glucoseFeature.name, "Glucose Feature")
         XCTAssertNotEqual(BluetoothUUID.glucoseFeature, .bit32(10833))
         XCTAssertNotEqual(BluetoothUUID.glucoseFeature, .bit32(0x2A51))

    }

    /// Test Record Access Control Point
    func testRecordAccessControlPoint() {

         XCTAssertEqual(BluetoothUUID.recordAccessControlPoint.rawValue, "2A52")
         XCTAssertEqual(BluetoothUUID.recordAccessControlPoint, .bit16(0x2A52))
         XCTAssertEqual(BluetoothUUID.recordAccessControlPoint, .bit16(10834))
         XCTAssertEqual(BluetoothUUID.recordAccessControlPoint.name, "Record Access Control Point")
         XCTAssertNotEqual(BluetoothUUID.recordAccessControlPoint, .bit32(10834))
         XCTAssertNotEqual(BluetoothUUID.recordAccessControlPoint, .bit32(0x2A52))

    }

    /// Test RSC Measurement
    func testRscMeasurement() {

         XCTAssertEqual(BluetoothUUID.rscMeasurement.rawValue, "2A53")
         XCTAssertEqual(BluetoothUUID.rscMeasurement, .bit16(0x2A53))
         XCTAssertEqual(BluetoothUUID.rscMeasurement, .bit16(10835))
         XCTAssertEqual(BluetoothUUID.rscMeasurement.name, "RSC Measurement")
         XCTAssertNotEqual(BluetoothUUID.rscMeasurement, .bit32(10835))
         XCTAssertNotEqual(BluetoothUUID.rscMeasurement, .bit32(0x2A53))

    }

    /// Test RSC Feature
    func testRscFeature() {

         XCTAssertEqual(BluetoothUUID.rscFeature.rawValue, "2A54")
         XCTAssertEqual(BluetoothUUID.rscFeature, .bit16(0x2A54))
         XCTAssertEqual(BluetoothUUID.rscFeature, .bit16(10836))
         XCTAssertEqual(BluetoothUUID.rscFeature.name, "RSC Feature")
         XCTAssertNotEqual(BluetoothUUID.rscFeature, .bit32(10836))
         XCTAssertNotEqual(BluetoothUUID.rscFeature, .bit32(0x2A54))

    }

    /// Test SC Control Point
    func testScControlPoint() {

         XCTAssertEqual(BluetoothUUID.scControlPoint.rawValue, "2A55")
         XCTAssertEqual(BluetoothUUID.scControlPoint, .bit16(0x2A55))
         XCTAssertEqual(BluetoothUUID.scControlPoint, .bit16(10837))
         XCTAssertEqual(BluetoothUUID.scControlPoint.name, "SC Control Point")
         XCTAssertNotEqual(BluetoothUUID.scControlPoint, .bit32(10837))
         XCTAssertNotEqual(BluetoothUUID.scControlPoint, .bit32(0x2A55))

    }

    /// Test Digital
    func testDigital() {

         XCTAssertEqual(BluetoothUUID.digital.rawValue, "2A56")
         XCTAssertEqual(BluetoothUUID.digital, .bit16(0x2A56))
         XCTAssertEqual(BluetoothUUID.digital, .bit16(10838))
         XCTAssertEqual(BluetoothUUID.digital.name, "Digital")
         XCTAssertNotEqual(BluetoothUUID.digital, .bit32(10838))
         XCTAssertNotEqual(BluetoothUUID.digital, .bit32(0x2A56))

    }

    /// Test Analog
    func testAnalog() {

         XCTAssertEqual(BluetoothUUID.analog.rawValue, "2A58")
         XCTAssertEqual(BluetoothUUID.analog, .bit16(0x2A58))
         XCTAssertEqual(BluetoothUUID.analog, .bit16(10840))
         XCTAssertEqual(BluetoothUUID.analog.name, "Analog")
         XCTAssertNotEqual(BluetoothUUID.analog, .bit32(10840))
         XCTAssertNotEqual(BluetoothUUID.analog, .bit32(0x2A58))

    }

    /// Test Aggregate
    func testAggregate() {

         XCTAssertEqual(BluetoothUUID.aggregate.rawValue, "2A5A")
         XCTAssertEqual(BluetoothUUID.aggregate, .bit16(0x2A5A))
         XCTAssertEqual(BluetoothUUID.aggregate, .bit16(10842))
         XCTAssertEqual(BluetoothUUID.aggregate.name, "Aggregate")
         XCTAssertNotEqual(BluetoothUUID.aggregate, .bit32(10842))
         XCTAssertNotEqual(BluetoothUUID.aggregate, .bit32(0x2A5A))

    }

    /// Test CSC Measurement
    func testCscMeasurement() {

         XCTAssertEqual(BluetoothUUID.cscMeasurement.rawValue, "2A5B")
         XCTAssertEqual(BluetoothUUID.cscMeasurement, .bit16(0x2A5B))
         XCTAssertEqual(BluetoothUUID.cscMeasurement, .bit16(10843))
         XCTAssertEqual(BluetoothUUID.cscMeasurement.name, "CSC Measurement")
         XCTAssertNotEqual(BluetoothUUID.cscMeasurement, .bit32(10843))
         XCTAssertNotEqual(BluetoothUUID.cscMeasurement, .bit32(0x2A5B))

    }

    /// Test CSC Feature
    func testCscFeature() {

         XCTAssertEqual(BluetoothUUID.cscFeature.rawValue, "2A5C")
         XCTAssertEqual(BluetoothUUID.cscFeature, .bit16(0x2A5C))
         XCTAssertEqual(BluetoothUUID.cscFeature, .bit16(10844))
         XCTAssertEqual(BluetoothUUID.cscFeature.name, "CSC Feature")
         XCTAssertNotEqual(BluetoothUUID.cscFeature, .bit32(10844))
         XCTAssertNotEqual(BluetoothUUID.cscFeature, .bit32(0x2A5C))

    }

    /// Test Sensor Location
    func testSensorLocation() {

         XCTAssertEqual(BluetoothUUID.sensorLocation.rawValue, "2A5D")
         XCTAssertEqual(BluetoothUUID.sensorLocation, .bit16(0x2A5D))
         XCTAssertEqual(BluetoothUUID.sensorLocation, .bit16(10845))
         XCTAssertEqual(BluetoothUUID.sensorLocation.name, "Sensor Location")
         XCTAssertNotEqual(BluetoothUUID.sensorLocation, .bit32(10845))
         XCTAssertNotEqual(BluetoothUUID.sensorLocation, .bit32(0x2A5D))

    }

    /// Test Cycling Power Measurement
    func testCyclingPowerMeasurement() {

         XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement.rawValue, "2A63")
         XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement, .bit16(0x2A63))
         XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement, .bit16(10851))
         XCTAssertEqual(BluetoothUUID.cyclingPowerMeasurement.name, "Cycling Power Measurement")
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerMeasurement, .bit32(10851))
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerMeasurement, .bit32(0x2A63))

    }

    /// Test Cycling Power Vector
    func testCyclingPowerVector() {

         XCTAssertEqual(BluetoothUUID.cyclingPowerVector.rawValue, "2A64")
         XCTAssertEqual(BluetoothUUID.cyclingPowerVector, .bit16(0x2A64))
         XCTAssertEqual(BluetoothUUID.cyclingPowerVector, .bit16(10852))
         XCTAssertEqual(BluetoothUUID.cyclingPowerVector.name, "Cycling Power Vector")
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerVector, .bit32(10852))
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerVector, .bit32(0x2A64))

    }

    /// Test Cycling Power Feature
    func testCyclingPowerFeature() {

         XCTAssertEqual(BluetoothUUID.cyclingPowerFeature.rawValue, "2A65")
         XCTAssertEqual(BluetoothUUID.cyclingPowerFeature, .bit16(0x2A65))
         XCTAssertEqual(BluetoothUUID.cyclingPowerFeature, .bit16(10853))
         XCTAssertEqual(BluetoothUUID.cyclingPowerFeature.name, "Cycling Power Feature")
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerFeature, .bit32(10853))
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerFeature, .bit32(0x2A65))

    }

    /// Test Cycling Power Control Point
    func testCyclingPowerControlPoint() {

         XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint.rawValue, "2A66")
         XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint, .bit16(0x2A66))
         XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint, .bit16(10854))
         XCTAssertEqual(BluetoothUUID.cyclingPowerControlPoint.name, "Cycling Power Control Point")
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerControlPoint, .bit32(10854))
         XCTAssertNotEqual(BluetoothUUID.cyclingPowerControlPoint, .bit32(0x2A66))

    }

    /// Test Location and Speed
    func testLocationAndSpeed() {

         XCTAssertEqual(BluetoothUUID.locationAndSpeed.rawValue, "2A67")
         XCTAssertEqual(BluetoothUUID.locationAndSpeed, .bit16(0x2A67))
         XCTAssertEqual(BluetoothUUID.locationAndSpeed, .bit16(10855))
         XCTAssertEqual(BluetoothUUID.locationAndSpeed.name, "Location and Speed")
         XCTAssertNotEqual(BluetoothUUID.locationAndSpeed, .bit32(10855))
         XCTAssertNotEqual(BluetoothUUID.locationAndSpeed, .bit32(0x2A67))

    }

    /// Test Navigation
    func testNavigation() {

         XCTAssertEqual(BluetoothUUID.navigation.rawValue, "2A68")
         XCTAssertEqual(BluetoothUUID.navigation, .bit16(0x2A68))
         XCTAssertEqual(BluetoothUUID.navigation, .bit16(10856))
         XCTAssertEqual(BluetoothUUID.navigation.name, "Navigation")
         XCTAssertNotEqual(BluetoothUUID.navigation, .bit32(10856))
         XCTAssertNotEqual(BluetoothUUID.navigation, .bit32(0x2A68))

    }

    /// Test Position Quality
    func testPositionQuality() {

         XCTAssertEqual(BluetoothUUID.positionQuality.rawValue, "2A69")
         XCTAssertEqual(BluetoothUUID.positionQuality, .bit16(0x2A69))
         XCTAssertEqual(BluetoothUUID.positionQuality, .bit16(10857))
         XCTAssertEqual(BluetoothUUID.positionQuality.name, "Position Quality")
         XCTAssertNotEqual(BluetoothUUID.positionQuality, .bit32(10857))
         XCTAssertNotEqual(BluetoothUUID.positionQuality, .bit32(0x2A69))

    }

    /// Test LN Feature
    func testLnFeature() {

         XCTAssertEqual(BluetoothUUID.lnFeature.rawValue, "2A6A")
         XCTAssertEqual(BluetoothUUID.lnFeature, .bit16(0x2A6A))
         XCTAssertEqual(BluetoothUUID.lnFeature, .bit16(10858))
         XCTAssertEqual(BluetoothUUID.lnFeature.name, "LN Feature")
         XCTAssertNotEqual(BluetoothUUID.lnFeature, .bit32(10858))
         XCTAssertNotEqual(BluetoothUUID.lnFeature, .bit32(0x2A6A))

    }

    /// Test LN Control Point
    func testLnControlPoint() {

         XCTAssertEqual(BluetoothUUID.lnControlPoint.rawValue, "2A6B")
         XCTAssertEqual(BluetoothUUID.lnControlPoint, .bit16(0x2A6B))
         XCTAssertEqual(BluetoothUUID.lnControlPoint, .bit16(10859))
         XCTAssertEqual(BluetoothUUID.lnControlPoint.name, "LN Control Point")
         XCTAssertNotEqual(BluetoothUUID.lnControlPoint, .bit32(10859))
         XCTAssertNotEqual(BluetoothUUID.lnControlPoint, .bit32(0x2A6B))

    }

    /// Test Elevation
    func testElevation() {

         XCTAssertEqual(BluetoothUUID.elevation.rawValue, "2A6C")
         XCTAssertEqual(BluetoothUUID.elevation, .bit16(0x2A6C))
         XCTAssertEqual(BluetoothUUID.elevation, .bit16(10860))
         XCTAssertEqual(BluetoothUUID.elevation.name, "Elevation")
         XCTAssertNotEqual(BluetoothUUID.elevation, .bit32(10860))
         XCTAssertNotEqual(BluetoothUUID.elevation, .bit32(0x2A6C))

    }

    /// Test Pressure
    func testPressure() {

         XCTAssertEqual(BluetoothUUID.pressure.rawValue, "2A6D")
         XCTAssertEqual(BluetoothUUID.pressure, .bit16(0x2A6D))
         XCTAssertEqual(BluetoothUUID.pressure, .bit16(10861))
         XCTAssertEqual(BluetoothUUID.pressure.name, "Pressure")
         XCTAssertNotEqual(BluetoothUUID.pressure, .bit32(10861))
         XCTAssertNotEqual(BluetoothUUID.pressure, .bit32(0x2A6D))

    }

    /// Test Temperature
    func testTemperature() {

         XCTAssertEqual(BluetoothUUID.temperature.rawValue, "2A6E")
         XCTAssertEqual(BluetoothUUID.temperature, .bit16(0x2A6E))
         XCTAssertEqual(BluetoothUUID.temperature, .bit16(10862))
         XCTAssertEqual(BluetoothUUID.temperature.name, "Temperature")
         XCTAssertNotEqual(BluetoothUUID.temperature, .bit32(10862))
         XCTAssertNotEqual(BluetoothUUID.temperature, .bit32(0x2A6E))

    }

    /// Test Humidity
    func testHumidity() {

         XCTAssertEqual(BluetoothUUID.humidity.rawValue, "2A6F")
         XCTAssertEqual(BluetoothUUID.humidity, .bit16(0x2A6F))
         XCTAssertEqual(BluetoothUUID.humidity, .bit16(10863))
         XCTAssertEqual(BluetoothUUID.humidity.name, "Humidity")
         XCTAssertNotEqual(BluetoothUUID.humidity, .bit32(10863))
         XCTAssertNotEqual(BluetoothUUID.humidity, .bit32(0x2A6F))

    }

    /// Test True Wind Speed
    func testTrueWindSpeed() {

         XCTAssertEqual(BluetoothUUID.trueWindSpeed.rawValue, "2A70")
         XCTAssertEqual(BluetoothUUID.trueWindSpeed, .bit16(0x2A70))
         XCTAssertEqual(BluetoothUUID.trueWindSpeed, .bit16(10864))
         XCTAssertEqual(BluetoothUUID.trueWindSpeed.name, "True Wind Speed")
         XCTAssertNotEqual(BluetoothUUID.trueWindSpeed, .bit32(10864))
         XCTAssertNotEqual(BluetoothUUID.trueWindSpeed, .bit32(0x2A70))

    }

    /// Test True Wind Direction
    func testTrueWindDirection() {

         XCTAssertEqual(BluetoothUUID.trueWindDirection.rawValue, "2A71")
         XCTAssertEqual(BluetoothUUID.trueWindDirection, .bit16(0x2A71))
         XCTAssertEqual(BluetoothUUID.trueWindDirection, .bit16(10865))
         XCTAssertEqual(BluetoothUUID.trueWindDirection.name, "True Wind Direction")
         XCTAssertNotEqual(BluetoothUUID.trueWindDirection, .bit32(10865))
         XCTAssertNotEqual(BluetoothUUID.trueWindDirection, .bit32(0x2A71))

    }

    /// Test Apparent Wind Speed
    func testApparentWindSpeed() {

         XCTAssertEqual(BluetoothUUID.apparentWindSpeed.rawValue, "2A72")
         XCTAssertEqual(BluetoothUUID.apparentWindSpeed, .bit16(0x2A72))
         XCTAssertEqual(BluetoothUUID.apparentWindSpeed, .bit16(10866))
         XCTAssertEqual(BluetoothUUID.apparentWindSpeed.name, "Apparent Wind Speed")
         XCTAssertNotEqual(BluetoothUUID.apparentWindSpeed, .bit32(10866))
         XCTAssertNotEqual(BluetoothUUID.apparentWindSpeed, .bit32(0x2A72))

    }

    /// Test Apparent Wind Direction
    func testApparentWindDirection() {

         XCTAssertEqual(BluetoothUUID.apparentWindDirection.rawValue, "2A73")
         XCTAssertEqual(BluetoothUUID.apparentWindDirection, .bit16(0x2A73))
         XCTAssertEqual(BluetoothUUID.apparentWindDirection, .bit16(10867))
         XCTAssertEqual(BluetoothUUID.apparentWindDirection.name, "Apparent Wind Direction")
         XCTAssertNotEqual(BluetoothUUID.apparentWindDirection, .bit32(10867))
         XCTAssertNotEqual(BluetoothUUID.apparentWindDirection, .bit32(0x2A73))

    }

    /// Test Gust Factor
    func testGustFactor() {

         XCTAssertEqual(BluetoothUUID.gustFactor.rawValue, "2A74")
         XCTAssertEqual(BluetoothUUID.gustFactor, .bit16(0x2A74))
         XCTAssertEqual(BluetoothUUID.gustFactor, .bit16(10868))
         XCTAssertEqual(BluetoothUUID.gustFactor.name, "Gust Factor")
         XCTAssertNotEqual(BluetoothUUID.gustFactor, .bit32(10868))
         XCTAssertNotEqual(BluetoothUUID.gustFactor, .bit32(0x2A74))

    }

    /// Test Pollen Concentration
    func testPollenConcentration() {

         XCTAssertEqual(BluetoothUUID.pollenConcentration.rawValue, "2A75")
         XCTAssertEqual(BluetoothUUID.pollenConcentration, .bit16(0x2A75))
         XCTAssertEqual(BluetoothUUID.pollenConcentration, .bit16(10869))
         XCTAssertEqual(BluetoothUUID.pollenConcentration.name, "Pollen Concentration")
         XCTAssertNotEqual(BluetoothUUID.pollenConcentration, .bit32(10869))
         XCTAssertNotEqual(BluetoothUUID.pollenConcentration, .bit32(0x2A75))

    }

    /// Test UV Index
    func testUvIndex() {

         XCTAssertEqual(BluetoothUUID.uvIndex.rawValue, "2A76")
         XCTAssertEqual(BluetoothUUID.uvIndex, .bit16(0x2A76))
         XCTAssertEqual(BluetoothUUID.uvIndex, .bit16(10870))
         XCTAssertEqual(BluetoothUUID.uvIndex.name, "UV Index")
         XCTAssertNotEqual(BluetoothUUID.uvIndex, .bit32(10870))
         XCTAssertNotEqual(BluetoothUUID.uvIndex, .bit32(0x2A76))

    }

    /// Test Irradiance
    func testIrradiance() {

         XCTAssertEqual(BluetoothUUID.irradiance.rawValue, "2A77")
         XCTAssertEqual(BluetoothUUID.irradiance, .bit16(0x2A77))
         XCTAssertEqual(BluetoothUUID.irradiance, .bit16(10871))
         XCTAssertEqual(BluetoothUUID.irradiance.name, "Irradiance")
         XCTAssertNotEqual(BluetoothUUID.irradiance, .bit32(10871))
         XCTAssertNotEqual(BluetoothUUID.irradiance, .bit32(0x2A77))

    }

    /// Test Rainfall
    func testRainfall() {

         XCTAssertEqual(BluetoothUUID.rainfall.rawValue, "2A78")
         XCTAssertEqual(BluetoothUUID.rainfall, .bit16(0x2A78))
         XCTAssertEqual(BluetoothUUID.rainfall, .bit16(10872))
         XCTAssertEqual(BluetoothUUID.rainfall.name, "Rainfall")
         XCTAssertNotEqual(BluetoothUUID.rainfall, .bit32(10872))
         XCTAssertNotEqual(BluetoothUUID.rainfall, .bit32(0x2A78))

    }

    /// Test Wind Chill
    func testWindChill() {

         XCTAssertEqual(BluetoothUUID.windChill.rawValue, "2A79")
         XCTAssertEqual(BluetoothUUID.windChill, .bit16(0x2A79))
         XCTAssertEqual(BluetoothUUID.windChill, .bit16(10873))
         XCTAssertEqual(BluetoothUUID.windChill.name, "Wind Chill")
         XCTAssertNotEqual(BluetoothUUID.windChill, .bit32(10873))
         XCTAssertNotEqual(BluetoothUUID.windChill, .bit32(0x2A79))

    }

    /// Test Heat Index
    func testHeatIndex() {

         XCTAssertEqual(BluetoothUUID.heatIndex.rawValue, "2A7A")
         XCTAssertEqual(BluetoothUUID.heatIndex, .bit16(0x2A7A))
         XCTAssertEqual(BluetoothUUID.heatIndex, .bit16(10874))
         XCTAssertEqual(BluetoothUUID.heatIndex.name, "Heat Index")
         XCTAssertNotEqual(BluetoothUUID.heatIndex, .bit32(10874))
         XCTAssertNotEqual(BluetoothUUID.heatIndex, .bit32(0x2A7A))

    }

    /// Test Dew Point
    func testDewPoint() {

         XCTAssertEqual(BluetoothUUID.dewPoint.rawValue, "2A7B")
         XCTAssertEqual(BluetoothUUID.dewPoint, .bit16(0x2A7B))
         XCTAssertEqual(BluetoothUUID.dewPoint, .bit16(10875))
         XCTAssertEqual(BluetoothUUID.dewPoint.name, "Dew Point")
         XCTAssertNotEqual(BluetoothUUID.dewPoint, .bit32(10875))
         XCTAssertNotEqual(BluetoothUUID.dewPoint, .bit32(0x2A7B))

    }

    /// Test Trend
    func testTrend() {

         XCTAssertEqual(BluetoothUUID.trend.rawValue, "2A7C")
         XCTAssertEqual(BluetoothUUID.trend, .bit16(0x2A7C))
         XCTAssertEqual(BluetoothUUID.trend, .bit16(10876))
         XCTAssertEqual(BluetoothUUID.trend.name, "Trend")
         XCTAssertNotEqual(BluetoothUUID.trend, .bit32(10876))
         XCTAssertNotEqual(BluetoothUUID.trend, .bit32(0x2A7C))

    }

    /// Test Descriptor Value Changed
    func testDescriptorValueChanged() {

         XCTAssertEqual(BluetoothUUID.descriptorValueChanged.rawValue, "2A7D")
         XCTAssertEqual(BluetoothUUID.descriptorValueChanged, .bit16(0x2A7D))
         XCTAssertEqual(BluetoothUUID.descriptorValueChanged, .bit16(10877))
         XCTAssertEqual(BluetoothUUID.descriptorValueChanged.name, "Descriptor Value Changed")
         XCTAssertNotEqual(BluetoothUUID.descriptorValueChanged, .bit32(10877))
         XCTAssertNotEqual(BluetoothUUID.descriptorValueChanged, .bit32(0x2A7D))

    }

    /// Test Aerobic Heart Rate Lower Limit
    func testAerobicHeartRateLowerLimit() {

         XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit.rawValue, "2A7E")
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit16(0x2A7E))
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit16(10878))
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateLowerLimit.name, "Aerobic Heart Rate Lower Limit")
         XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit32(10878))
         XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateLowerLimit, .bit32(0x2A7E))

    }

    /// Test Aerobic Threshold
    func testAerobicThreshold() {

         XCTAssertEqual(BluetoothUUID.aerobicThreshold.rawValue, "2A7F")
         XCTAssertEqual(BluetoothUUID.aerobicThreshold, .bit16(0x2A7F))
         XCTAssertEqual(BluetoothUUID.aerobicThreshold, .bit16(10879))
         XCTAssertEqual(BluetoothUUID.aerobicThreshold.name, "Aerobic Threshold")
         XCTAssertNotEqual(BluetoothUUID.aerobicThreshold, .bit32(10879))
         XCTAssertNotEqual(BluetoothUUID.aerobicThreshold, .bit32(0x2A7F))

    }

    /// Test Age
    func testAge() {

         XCTAssertEqual(BluetoothUUID.age.rawValue, "2A80")
         XCTAssertEqual(BluetoothUUID.age, .bit16(0x2A80))
         XCTAssertEqual(BluetoothUUID.age, .bit16(10880))
         XCTAssertEqual(BluetoothUUID.age.name, "Age")
         XCTAssertNotEqual(BluetoothUUID.age, .bit32(10880))
         XCTAssertNotEqual(BluetoothUUID.age, .bit32(0x2A80))

    }

    /// Test Anaerobic Heart Rate Lower Limit
    func testAnaerobicHeartRateLowerLimit() {

         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit.rawValue, "2A81")
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit16(0x2A81))
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit16(10881))
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateLowerLimit.name, "Anaerobic Heart Rate Lower Limit")
         XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit32(10881))
         XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateLowerLimit, .bit32(0x2A81))

    }

    /// Test Anaerobic Heart Rate Upper Limit
    func testAnaerobicHeartRateUpperLimit() {

         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit.rawValue, "2A82")
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit16(0x2A82))
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit16(10882))
         XCTAssertEqual(BluetoothUUID.anaerobicHeartRateUpperLimit.name, "Anaerobic Heart Rate Upper Limit")
         XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit32(10882))
         XCTAssertNotEqual(BluetoothUUID.anaerobicHeartRateUpperLimit, .bit32(0x2A82))

    }

    /// Test Anaerobic Threshold
    func testAnaerobicThreshold() {

         XCTAssertEqual(BluetoothUUID.anaerobicThreshold.rawValue, "2A83")
         XCTAssertEqual(BluetoothUUID.anaerobicThreshold, .bit16(0x2A83))
         XCTAssertEqual(BluetoothUUID.anaerobicThreshold, .bit16(10883))
         XCTAssertEqual(BluetoothUUID.anaerobicThreshold.name, "Anaerobic Threshold")
         XCTAssertNotEqual(BluetoothUUID.anaerobicThreshold, .bit32(10883))
         XCTAssertNotEqual(BluetoothUUID.anaerobicThreshold, .bit32(0x2A83))

    }

    /// Test Aerobic Heart Rate Upper Limit
    func testAerobicHeartRateUpperLimit() {

         XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit.rawValue, "2A84")
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit16(0x2A84))
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit16(10884))
         XCTAssertEqual(BluetoothUUID.aerobicHeartRateUpperLimit.name, "Aerobic Heart Rate Upper Limit")
         XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit32(10884))
         XCTAssertNotEqual(BluetoothUUID.aerobicHeartRateUpperLimit, .bit32(0x2A84))

    }

    /// Test Date of Birth
    func testDateOfBirth() {

         XCTAssertEqual(BluetoothUUID.dateOfBirth.rawValue, "2A85")
         XCTAssertEqual(BluetoothUUID.dateOfBirth, .bit16(0x2A85))
         XCTAssertEqual(BluetoothUUID.dateOfBirth, .bit16(10885))
         XCTAssertEqual(BluetoothUUID.dateOfBirth.name, "Date of Birth")
         XCTAssertNotEqual(BluetoothUUID.dateOfBirth, .bit32(10885))
         XCTAssertNotEqual(BluetoothUUID.dateOfBirth, .bit32(0x2A85))

    }

    /// Test Date of Threshold Assessment
    func testDateOfThresholdAssessment() {

         XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment.rawValue, "2A86")
         XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment, .bit16(0x2A86))
         XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment, .bit16(10886))
         XCTAssertEqual(BluetoothUUID.dateOfThresholdAssessment.name, "Date of Threshold Assessment")
         XCTAssertNotEqual(BluetoothUUID.dateOfThresholdAssessment, .bit32(10886))
         XCTAssertNotEqual(BluetoothUUID.dateOfThresholdAssessment, .bit32(0x2A86))

    }

    /// Test Email Address
    func testEmailAddress() {

         XCTAssertEqual(BluetoothUUID.emailAddress.rawValue, "2A87")
         XCTAssertEqual(BluetoothUUID.emailAddress, .bit16(0x2A87))
         XCTAssertEqual(BluetoothUUID.emailAddress, .bit16(10887))
         XCTAssertEqual(BluetoothUUID.emailAddress.name, "Email Address")
         XCTAssertNotEqual(BluetoothUUID.emailAddress, .bit32(10887))
         XCTAssertNotEqual(BluetoothUUID.emailAddress, .bit32(0x2A87))

    }

    /// Test Fat Burn Heart Rate Lower Limit
    func testFatBurnHeartRateLowerLimit() {

         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit.rawValue, "2A88")
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit16(0x2A88))
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit16(10888))
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateLowerLimit.name, "Fat Burn Heart Rate Lower Limit")
         XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit32(10888))
         XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateLowerLimit, .bit32(0x2A88))

    }

    /// Test Fat Burn Heart Rate Upper Limit
    func testFatBurnHeartRateUpperLimit() {

         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit.rawValue, "2A89")
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit16(0x2A89))
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit16(10889))
         XCTAssertEqual(BluetoothUUID.fatBurnHeartRateUpperLimit.name, "Fat Burn Heart Rate Upper Limit")
         XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit32(10889))
         XCTAssertNotEqual(BluetoothUUID.fatBurnHeartRateUpperLimit, .bit32(0x2A89))

    }

    /// Test First Name
    func testFirstName() {

         XCTAssertEqual(BluetoothUUID.firstName.rawValue, "2A8A")
         XCTAssertEqual(BluetoothUUID.firstName, .bit16(0x2A8A))
         XCTAssertEqual(BluetoothUUID.firstName, .bit16(10890))
         XCTAssertEqual(BluetoothUUID.firstName.name, "First Name")
         XCTAssertNotEqual(BluetoothUUID.firstName, .bit32(10890))
         XCTAssertNotEqual(BluetoothUUID.firstName, .bit32(0x2A8A))

    }

    /// Test Five Zone Heart Rate Limits
    func testFiveZoneHeartRateLimits() {

         XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits.rawValue, "2A8B")
         XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit16(0x2A8B))
         XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit16(10891))
         XCTAssertEqual(BluetoothUUID.fiveZoneHeartRateLimits.name, "Five Zone Heart Rate Limits")
         XCTAssertNotEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit32(10891))
         XCTAssertNotEqual(BluetoothUUID.fiveZoneHeartRateLimits, .bit32(0x2A8B))

    }

    /// Test Gender
    func testGender() {

         XCTAssertEqual(BluetoothUUID.gender.rawValue, "2A8C")
         XCTAssertEqual(BluetoothUUID.gender, .bit16(0x2A8C))
         XCTAssertEqual(BluetoothUUID.gender, .bit16(10892))
         XCTAssertEqual(BluetoothUUID.gender.name, "Gender")
         XCTAssertNotEqual(BluetoothUUID.gender, .bit32(10892))
         XCTAssertNotEqual(BluetoothUUID.gender, .bit32(0x2A8C))

    }

    /// Test Heart Rate Max
    func testHeartRateMax() {

         XCTAssertEqual(BluetoothUUID.heartRateMax.rawValue, "2A8D")
         XCTAssertEqual(BluetoothUUID.heartRateMax, .bit16(0x2A8D))
         XCTAssertEqual(BluetoothUUID.heartRateMax, .bit16(10893))
         XCTAssertEqual(BluetoothUUID.heartRateMax.name, "Heart Rate Max")
         XCTAssertNotEqual(BluetoothUUID.heartRateMax, .bit32(10893))
         XCTAssertNotEqual(BluetoothUUID.heartRateMax, .bit32(0x2A8D))

    }

    /// Test Height
    func testHeight() {

         XCTAssertEqual(BluetoothUUID.height.rawValue, "2A8E")
         XCTAssertEqual(BluetoothUUID.height, .bit16(0x2A8E))
         XCTAssertEqual(BluetoothUUID.height, .bit16(10894))
         XCTAssertEqual(BluetoothUUID.height.name, "Height")
         XCTAssertNotEqual(BluetoothUUID.height, .bit32(10894))
         XCTAssertNotEqual(BluetoothUUID.height, .bit32(0x2A8E))

    }

    /// Test Hip Circumference
    func testHipCircumference() {

         XCTAssertEqual(BluetoothUUID.hipCircumference.rawValue, "2A8F")
         XCTAssertEqual(BluetoothUUID.hipCircumference, .bit16(0x2A8F))
         XCTAssertEqual(BluetoothUUID.hipCircumference, .bit16(10895))
         XCTAssertEqual(BluetoothUUID.hipCircumference.name, "Hip Circumference")
         XCTAssertNotEqual(BluetoothUUID.hipCircumference, .bit32(10895))
         XCTAssertNotEqual(BluetoothUUID.hipCircumference, .bit32(0x2A8F))

    }

    /// Test Last Name
    func testLastName() {

         XCTAssertEqual(BluetoothUUID.lastName.rawValue, "2A90")
         XCTAssertEqual(BluetoothUUID.lastName, .bit16(0x2A90))
         XCTAssertEqual(BluetoothUUID.lastName, .bit16(10896))
         XCTAssertEqual(BluetoothUUID.lastName.name, "Last Name")
         XCTAssertNotEqual(BluetoothUUID.lastName, .bit32(10896))
         XCTAssertNotEqual(BluetoothUUID.lastName, .bit32(0x2A90))

    }

    /// Test Maximum Recommended Heart Rate
    func testMaximumRecommendedHeartRate() {

         XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate.rawValue, "2A91")
         XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit16(0x2A91))
         XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit16(10897))
         XCTAssertEqual(BluetoothUUID.maximumRecommendedHeartRate.name, "Maximum Recommended Heart Rate")
         XCTAssertNotEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit32(10897))
         XCTAssertNotEqual(BluetoothUUID.maximumRecommendedHeartRate, .bit32(0x2A91))

    }

    /// Test Resting Heart Rate
    func testRestingHeartRate() {

         XCTAssertEqual(BluetoothUUID.restingHeartRate.rawValue, "2A92")
         XCTAssertEqual(BluetoothUUID.restingHeartRate, .bit16(0x2A92))
         XCTAssertEqual(BluetoothUUID.restingHeartRate, .bit16(10898))
         XCTAssertEqual(BluetoothUUID.restingHeartRate.name, "Resting Heart Rate")
         XCTAssertNotEqual(BluetoothUUID.restingHeartRate, .bit32(10898))
         XCTAssertNotEqual(BluetoothUUID.restingHeartRate, .bit32(0x2A92))

    }

    /// Test Sport Type for Aerobic/Anaerobic Thresholds
    func testSportTypeForAerobicAnaerobicThresholds() {

         XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.rawValue, "2A93")
         XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit16(0x2A93))
         XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit16(10899))
         XCTAssertEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds.name, "Sport Type for Aerobic/Anaerobic Thresholds")
         XCTAssertNotEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit32(10899))
         XCTAssertNotEqual(BluetoothUUID.sportTypeForAerobicAnaerobicThresholds, .bit32(0x2A93))

    }

    /// Test Three Zone Heart Rate Limits
    func testThreeZoneHeartRateLimits() {

         XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits.rawValue, "2A94")
         XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit16(0x2A94))
         XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit16(10900))
         XCTAssertEqual(BluetoothUUID.threeZoneHeartRateLimits.name, "Three Zone Heart Rate Limits")
         XCTAssertNotEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit32(10900))
         XCTAssertNotEqual(BluetoothUUID.threeZoneHeartRateLimits, .bit32(0x2A94))

    }

    /// Test Two Zone Heart Rate Limit
    func testTwoZoneHeartRateLimit() {

         XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit.rawValue, "2A95")
         XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit16(0x2A95))
         XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit16(10901))
         XCTAssertEqual(BluetoothUUID.twoZoneHeartRateLimit.name, "Two Zone Heart Rate Limit")
         XCTAssertNotEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit32(10901))
         XCTAssertNotEqual(BluetoothUUID.twoZoneHeartRateLimit, .bit32(0x2A95))

    }

    /// Test VO2 Max
    func testVo2Max() {

         XCTAssertEqual(BluetoothUUID.vo2Max.rawValue, "2A96")
         XCTAssertEqual(BluetoothUUID.vo2Max, .bit16(0x2A96))
         XCTAssertEqual(BluetoothUUID.vo2Max, .bit16(10902))
         XCTAssertEqual(BluetoothUUID.vo2Max.name, "VO2 Max")
         XCTAssertNotEqual(BluetoothUUID.vo2Max, .bit32(10902))
         XCTAssertNotEqual(BluetoothUUID.vo2Max, .bit32(0x2A96))

    }

    /// Test Waist Circumference
    func testWaistCircumference() {

         XCTAssertEqual(BluetoothUUID.waistCircumference.rawValue, "2A97")
         XCTAssertEqual(BluetoothUUID.waistCircumference, .bit16(0x2A97))
         XCTAssertEqual(BluetoothUUID.waistCircumference, .bit16(10903))
         XCTAssertEqual(BluetoothUUID.waistCircumference.name, "Waist Circumference")
         XCTAssertNotEqual(BluetoothUUID.waistCircumference, .bit32(10903))
         XCTAssertNotEqual(BluetoothUUID.waistCircumference, .bit32(0x2A97))

    }

    /// Test Weight
    func testWeight() {

         XCTAssertEqual(BluetoothUUID.weight.rawValue, "2A98")
         XCTAssertEqual(BluetoothUUID.weight, .bit16(0x2A98))
         XCTAssertEqual(BluetoothUUID.weight, .bit16(10904))
         XCTAssertEqual(BluetoothUUID.weight.name, "Weight")
         XCTAssertNotEqual(BluetoothUUID.weight, .bit32(10904))
         XCTAssertNotEqual(BluetoothUUID.weight, .bit32(0x2A98))

    }

    /// Test Database Change Increment
    func testDatabaseChangerement() {

         XCTAssertEqual(BluetoothUUID.databaseChangerement.rawValue, "2A99")
         XCTAssertEqual(BluetoothUUID.databaseChangerement, .bit16(0x2A99))
         XCTAssertEqual(BluetoothUUID.databaseChangerement, .bit16(10905))
         XCTAssertEqual(BluetoothUUID.databaseChangerement.name, "Database Change Increment")
         XCTAssertNotEqual(BluetoothUUID.databaseChangerement, .bit32(10905))
         XCTAssertNotEqual(BluetoothUUID.databaseChangerement, .bit32(0x2A99))

    }

    /// Test User Index
    func testUserIndex() {

         XCTAssertEqual(BluetoothUUID.userIndex.rawValue, "2A9A")
         XCTAssertEqual(BluetoothUUID.userIndex, .bit16(0x2A9A))
         XCTAssertEqual(BluetoothUUID.userIndex, .bit16(10906))
         XCTAssertEqual(BluetoothUUID.userIndex.name, "User Index")
         XCTAssertNotEqual(BluetoothUUID.userIndex, .bit32(10906))
         XCTAssertNotEqual(BluetoothUUID.userIndex, .bit32(0x2A9A))

    }

    /// Test Body Composition Feature
    func testBodyCompositionFeature() {

         XCTAssertEqual(BluetoothUUID.bodyCompositionFeature.rawValue, "2A9B")
         XCTAssertEqual(BluetoothUUID.bodyCompositionFeature, .bit16(0x2A9B))
         XCTAssertEqual(BluetoothUUID.bodyCompositionFeature, .bit16(10907))
         XCTAssertEqual(BluetoothUUID.bodyCompositionFeature.name, "Body Composition Feature")
         XCTAssertNotEqual(BluetoothUUID.bodyCompositionFeature, .bit32(10907))
         XCTAssertNotEqual(BluetoothUUID.bodyCompositionFeature, .bit32(0x2A9B))

    }

    /// Test Body Composition Measurement
    func testBodyCompositionMeasurement() {

         XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement.rawValue, "2A9C")
         XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement, .bit16(0x2A9C))
         XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement, .bit16(10908))
         XCTAssertEqual(BluetoothUUID.bodyCompositionMeasurement.name, "Body Composition Measurement")
         XCTAssertNotEqual(BluetoothUUID.bodyCompositionMeasurement, .bit32(10908))
         XCTAssertNotEqual(BluetoothUUID.bodyCompositionMeasurement, .bit32(0x2A9C))

    }

    /// Test Weight Measurement
    func testWeightMeasurement() {

         XCTAssertEqual(BluetoothUUID.weightMeasurement.rawValue, "2A9D")
         XCTAssertEqual(BluetoothUUID.weightMeasurement, .bit16(0x2A9D))
         XCTAssertEqual(BluetoothUUID.weightMeasurement, .bit16(10909))
         XCTAssertEqual(BluetoothUUID.weightMeasurement.name, "Weight Measurement")
         XCTAssertNotEqual(BluetoothUUID.weightMeasurement, .bit32(10909))
         XCTAssertNotEqual(BluetoothUUID.weightMeasurement, .bit32(0x2A9D))

    }

    /// Test Weight Scale Feature
    func testWeightScaleFeature() {

         XCTAssertEqual(BluetoothUUID.weightScaleFeature.rawValue, "2A9E")
         XCTAssertEqual(BluetoothUUID.weightScaleFeature, .bit16(0x2A9E))
         XCTAssertEqual(BluetoothUUID.weightScaleFeature, .bit16(10910))
         XCTAssertEqual(BluetoothUUID.weightScaleFeature.name, "Weight Scale Feature")
         XCTAssertNotEqual(BluetoothUUID.weightScaleFeature, .bit32(10910))
         XCTAssertNotEqual(BluetoothUUID.weightScaleFeature, .bit32(0x2A9E))

    }

    /// Test User Control Point
    func testUserControlPoint() {

         XCTAssertEqual(BluetoothUUID.userControlPoint.rawValue, "2A9F")
         XCTAssertEqual(BluetoothUUID.userControlPoint, .bit16(0x2A9F))
         XCTAssertEqual(BluetoothUUID.userControlPoint, .bit16(10911))
         XCTAssertEqual(BluetoothUUID.userControlPoint.name, "User Control Point")
         XCTAssertNotEqual(BluetoothUUID.userControlPoint, .bit32(10911))
         XCTAssertNotEqual(BluetoothUUID.userControlPoint, .bit32(0x2A9F))

    }

    /// Test Magnetic Flux Density - 2D
    func testMagneticFluxDensity2D() {

         XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D.rawValue, "2AA0")
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D, .bit16(0x2AA0))
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D, .bit16(10912))
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity2D.name, "Magnetic Flux Density - 2D")
         XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity2D, .bit32(10912))
         XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity2D, .bit32(0x2AA0))

    }

    /// Test Magnetic Flux Density - 3D
    func testMagneticFluxDensity3D() {

         XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D.rawValue, "2AA1")
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D, .bit16(0x2AA1))
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D, .bit16(10913))
         XCTAssertEqual(BluetoothUUID.magneticFluxDensity3D.name, "Magnetic Flux Density - 3D")
         XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity3D, .bit32(10913))
         XCTAssertNotEqual(BluetoothUUID.magneticFluxDensity3D, .bit32(0x2AA1))

    }

    /// Test Language
    func testLanguage() {

         XCTAssertEqual(BluetoothUUID.language.rawValue, "2AA2")
         XCTAssertEqual(BluetoothUUID.language, .bit16(0x2AA2))
         XCTAssertEqual(BluetoothUUID.language, .bit16(10914))
         XCTAssertEqual(BluetoothUUID.language.name, "Language")
         XCTAssertNotEqual(BluetoothUUID.language, .bit32(10914))
         XCTAssertNotEqual(BluetoothUUID.language, .bit32(0x2AA2))

    }

    /// Test Barometric Pressure Trend
    func testBarometricPressureTrend() {

         XCTAssertEqual(BluetoothUUID.barometricPressureTrend.rawValue, "2AA3")
         XCTAssertEqual(BluetoothUUID.barometricPressureTrend, .bit16(0x2AA3))
         XCTAssertEqual(BluetoothUUID.barometricPressureTrend, .bit16(10915))
         XCTAssertEqual(BluetoothUUID.barometricPressureTrend.name, "Barometric Pressure Trend")
         XCTAssertNotEqual(BluetoothUUID.barometricPressureTrend, .bit32(10915))
         XCTAssertNotEqual(BluetoothUUID.barometricPressureTrend, .bit32(0x2AA3))

    }

    /// Test Bond Management Control Point
    func testBondManagementControlPoint() {

         XCTAssertEqual(BluetoothUUID.bondManagementControlPoint.rawValue, "2AA4")
         XCTAssertEqual(BluetoothUUID.bondManagementControlPoint, .bit16(0x2AA4))
         XCTAssertEqual(BluetoothUUID.bondManagementControlPoint, .bit16(10916))
         XCTAssertEqual(BluetoothUUID.bondManagementControlPoint.name, "Bond Management Control Point")
         XCTAssertNotEqual(BluetoothUUID.bondManagementControlPoint, .bit32(10916))
         XCTAssertNotEqual(BluetoothUUID.bondManagementControlPoint, .bit32(0x2AA4))

    }

    /// Test Bond Management Feature
    func testBondManagementFeature() {

         XCTAssertEqual(BluetoothUUID.bondManagementFeature.rawValue, "2AA5")
         XCTAssertEqual(BluetoothUUID.bondManagementFeature, .bit16(0x2AA5))
         XCTAssertEqual(BluetoothUUID.bondManagementFeature, .bit16(10917))
         XCTAssertEqual(BluetoothUUID.bondManagementFeature.name, "Bond Management Feature")
         XCTAssertNotEqual(BluetoothUUID.bondManagementFeature, .bit32(10917))
         XCTAssertNotEqual(BluetoothUUID.bondManagementFeature, .bit32(0x2AA5))

    }

    /// Test Central Address Resolution
    func testCentralAddressResolution() {

         XCTAssertEqual(BluetoothUUID.centralAddressResolution.rawValue, "2AA6")
         XCTAssertEqual(BluetoothUUID.centralAddressResolution, .bit16(0x2AA6))
         XCTAssertEqual(BluetoothUUID.centralAddressResolution, .bit16(10918))
         XCTAssertEqual(BluetoothUUID.centralAddressResolution.name, "Central Address Resolution")
         XCTAssertNotEqual(BluetoothUUID.centralAddressResolution, .bit32(10918))
         XCTAssertNotEqual(BluetoothUUID.centralAddressResolution, .bit32(0x2AA6))

    }

    /// Test CGM Measurement
    func testCgmMeasurement() {

         XCTAssertEqual(BluetoothUUID.cgmMeasurement.rawValue, "2AA7")
         XCTAssertEqual(BluetoothUUID.cgmMeasurement, .bit16(0x2AA7))
         XCTAssertEqual(BluetoothUUID.cgmMeasurement, .bit16(10919))
         XCTAssertEqual(BluetoothUUID.cgmMeasurement.name, "CGM Measurement")
         XCTAssertNotEqual(BluetoothUUID.cgmMeasurement, .bit32(10919))
         XCTAssertNotEqual(BluetoothUUID.cgmMeasurement, .bit32(0x2AA7))

    }

    /// Test CGM Feature
    func testCgmFeature() {

         XCTAssertEqual(BluetoothUUID.cgmFeature.rawValue, "2AA8")
         XCTAssertEqual(BluetoothUUID.cgmFeature, .bit16(0x2AA8))
         XCTAssertEqual(BluetoothUUID.cgmFeature, .bit16(10920))
         XCTAssertEqual(BluetoothUUID.cgmFeature.name, "CGM Feature")
         XCTAssertNotEqual(BluetoothUUID.cgmFeature, .bit32(10920))
         XCTAssertNotEqual(BluetoothUUID.cgmFeature, .bit32(0x2AA8))

    }

    /// Test CGM Status
    func testCgmStatus() {

         XCTAssertEqual(BluetoothUUID.cgmStatus.rawValue, "2AA9")
         XCTAssertEqual(BluetoothUUID.cgmStatus, .bit16(0x2AA9))
         XCTAssertEqual(BluetoothUUID.cgmStatus, .bit16(10921))
         XCTAssertEqual(BluetoothUUID.cgmStatus.name, "CGM Status")
         XCTAssertNotEqual(BluetoothUUID.cgmStatus, .bit32(10921))
         XCTAssertNotEqual(BluetoothUUID.cgmStatus, .bit32(0x2AA9))

    }

    /// Test CGM Session Start Time
    func testCgmSessionStartTime() {

         XCTAssertEqual(BluetoothUUID.cgmSessionStartTime.rawValue, "2AAA")
         XCTAssertEqual(BluetoothUUID.cgmSessionStartTime, .bit16(0x2AAA))
         XCTAssertEqual(BluetoothUUID.cgmSessionStartTime, .bit16(10922))
         XCTAssertEqual(BluetoothUUID.cgmSessionStartTime.name, "CGM Session Start Time")
         XCTAssertNotEqual(BluetoothUUID.cgmSessionStartTime, .bit32(10922))
         XCTAssertNotEqual(BluetoothUUID.cgmSessionStartTime, .bit32(0x2AAA))

    }

    /// Test CGM Session Run Time
    func testCgmSessionRunTime() {

         XCTAssertEqual(BluetoothUUID.cgmSessionRunTime.rawValue, "2AAB")
         XCTAssertEqual(BluetoothUUID.cgmSessionRunTime, .bit16(0x2AAB))
         XCTAssertEqual(BluetoothUUID.cgmSessionRunTime, .bit16(10923))
         XCTAssertEqual(BluetoothUUID.cgmSessionRunTime.name, "CGM Session Run Time")
         XCTAssertNotEqual(BluetoothUUID.cgmSessionRunTime, .bit32(10923))
         XCTAssertNotEqual(BluetoothUUID.cgmSessionRunTime, .bit32(0x2AAB))

    }

    /// Test CGM Specific Ops Control Point
    func testCgmSpecificOpsControlPoint() {

         XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint.rawValue, "2AAC")
         XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit16(0x2AAC))
         XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit16(10924))
         XCTAssertEqual(BluetoothUUID.cgmSpecificOpsControlPoint.name, "CGM Specific Ops Control Point")
         XCTAssertNotEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit32(10924))
         XCTAssertNotEqual(BluetoothUUID.cgmSpecificOpsControlPoint, .bit32(0x2AAC))

    }

    /// Test Indoor Positioning Configuration
    func testIndoorPositioningConfiguration() {

         XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration.rawValue, "2AAD")
         XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration, .bit16(0x2AAD))
         XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration, .bit16(10925))
         XCTAssertEqual(BluetoothUUID.indoorPositioningConfiguration.name, "Indoor Positioning Configuration")
         XCTAssertNotEqual(BluetoothUUID.indoorPositioningConfiguration, .bit32(10925))
         XCTAssertNotEqual(BluetoothUUID.indoorPositioningConfiguration, .bit32(0x2AAD))

    }

    /// Test Latitude
    func testLatitude() {

         XCTAssertEqual(BluetoothUUID.latitude.rawValue, "2AAE")
         XCTAssertEqual(BluetoothUUID.latitude, .bit16(0x2AAE))
         XCTAssertEqual(BluetoothUUID.latitude, .bit16(10926))
         XCTAssertEqual(BluetoothUUID.latitude.name, "Latitude")
         XCTAssertNotEqual(BluetoothUUID.latitude, .bit32(10926))
         XCTAssertNotEqual(BluetoothUUID.latitude, .bit32(0x2AAE))

    }

    /// Test Longitude
    func testLongitude() {

         XCTAssertEqual(BluetoothUUID.longitude.rawValue, "2AAF")
         XCTAssertEqual(BluetoothUUID.longitude, .bit16(0x2AAF))
         XCTAssertEqual(BluetoothUUID.longitude, .bit16(10927))
         XCTAssertEqual(BluetoothUUID.longitude.name, "Longitude")
         XCTAssertNotEqual(BluetoothUUID.longitude, .bit32(10927))
         XCTAssertNotEqual(BluetoothUUID.longitude, .bit32(0x2AAF))

    }

    /// Test Local North Coordinate
    func testLocalNorthCoordinate() {

         XCTAssertEqual(BluetoothUUID.localNorthCoordinate.rawValue, "2AB0")
         XCTAssertEqual(BluetoothUUID.localNorthCoordinate, .bit16(0x2AB0))
         XCTAssertEqual(BluetoothUUID.localNorthCoordinate, .bit16(10928))
         XCTAssertEqual(BluetoothUUID.localNorthCoordinate.name, "Local North Coordinate")
         XCTAssertNotEqual(BluetoothUUID.localNorthCoordinate, .bit32(10928))
         XCTAssertNotEqual(BluetoothUUID.localNorthCoordinate, .bit32(0x2AB0))

    }

    /// Test Local East Coordinate
    func testLocalEastCoordinate() {

         XCTAssertEqual(BluetoothUUID.localEastCoordinate.rawValue, "2AB1")
         XCTAssertEqual(BluetoothUUID.localEastCoordinate, .bit16(0x2AB1))
         XCTAssertEqual(BluetoothUUID.localEastCoordinate, .bit16(10929))
         XCTAssertEqual(BluetoothUUID.localEastCoordinate.name, "Local East Coordinate")
         XCTAssertNotEqual(BluetoothUUID.localEastCoordinate, .bit32(10929))
         XCTAssertNotEqual(BluetoothUUID.localEastCoordinate, .bit32(0x2AB1))

    }

    /// Test Floor Number
    func testFloorNumber() {

         XCTAssertEqual(BluetoothUUID.floorNumber.rawValue, "2AB2")
         XCTAssertEqual(BluetoothUUID.floorNumber, .bit16(0x2AB2))
         XCTAssertEqual(BluetoothUUID.floorNumber, .bit16(10930))
         XCTAssertEqual(BluetoothUUID.floorNumber.name, "Floor Number")
         XCTAssertNotEqual(BluetoothUUID.floorNumber, .bit32(10930))
         XCTAssertNotEqual(BluetoothUUID.floorNumber, .bit32(0x2AB2))

    }

    /// Test Altitude
    func testAltitude() {

         XCTAssertEqual(BluetoothUUID.altitude.rawValue, "2AB3")
         XCTAssertEqual(BluetoothUUID.altitude, .bit16(0x2AB3))
         XCTAssertEqual(BluetoothUUID.altitude, .bit16(10931))
         XCTAssertEqual(BluetoothUUID.altitude.name, "Altitude")
         XCTAssertNotEqual(BluetoothUUID.altitude, .bit32(10931))
         XCTAssertNotEqual(BluetoothUUID.altitude, .bit32(0x2AB3))

    }

    /// Test Uncertainty
    func testUncertainty() {

         XCTAssertEqual(BluetoothUUID.uncertainty.rawValue, "2AB4")
         XCTAssertEqual(BluetoothUUID.uncertainty, .bit16(0x2AB4))
         XCTAssertEqual(BluetoothUUID.uncertainty, .bit16(10932))
         XCTAssertEqual(BluetoothUUID.uncertainty.name, "Uncertainty")
         XCTAssertNotEqual(BluetoothUUID.uncertainty, .bit32(10932))
         XCTAssertNotEqual(BluetoothUUID.uncertainty, .bit32(0x2AB4))

    }

    /// Test Location Name
    func testLocationName() {

         XCTAssertEqual(BluetoothUUID.locationName.rawValue, "2AB5")
         XCTAssertEqual(BluetoothUUID.locationName, .bit16(0x2AB5))
         XCTAssertEqual(BluetoothUUID.locationName, .bit16(10933))
         XCTAssertEqual(BluetoothUUID.locationName.name, "Location Name")
         XCTAssertNotEqual(BluetoothUUID.locationName, .bit32(10933))
         XCTAssertNotEqual(BluetoothUUID.locationName, .bit32(0x2AB5))

    }

    /// Test URI
    func testUri() {

         XCTAssertEqual(BluetoothUUID.uri.rawValue, "2AB6")
         XCTAssertEqual(BluetoothUUID.uri, .bit16(0x2AB6))
         XCTAssertEqual(BluetoothUUID.uri, .bit16(10934))
         XCTAssertEqual(BluetoothUUID.uri.name, "URI")
         XCTAssertNotEqual(BluetoothUUID.uri, .bit32(10934))
         XCTAssertNotEqual(BluetoothUUID.uri, .bit32(0x2AB6))

    }

    /// Test HTTP Headers
    func testHttpHeaders() {

         XCTAssertEqual(BluetoothUUID.httpHeaders.rawValue, "2AB7")
         XCTAssertEqual(BluetoothUUID.httpHeaders, .bit16(0x2AB7))
         XCTAssertEqual(BluetoothUUID.httpHeaders, .bit16(10935))
         XCTAssertEqual(BluetoothUUID.httpHeaders.name, "HTTP Headers")
         XCTAssertNotEqual(BluetoothUUID.httpHeaders, .bit32(10935))
         XCTAssertNotEqual(BluetoothUUID.httpHeaders, .bit32(0x2AB7))

    }

    /// Test HTTP Status Code
    func testHttpStatusCode() {

         XCTAssertEqual(BluetoothUUID.httpStatusCode.rawValue, "2AB8")
         XCTAssertEqual(BluetoothUUID.httpStatusCode, .bit16(0x2AB8))
         XCTAssertEqual(BluetoothUUID.httpStatusCode, .bit16(10936))
         XCTAssertEqual(BluetoothUUID.httpStatusCode.name, "HTTP Status Code")
         XCTAssertNotEqual(BluetoothUUID.httpStatusCode, .bit32(10936))
         XCTAssertNotEqual(BluetoothUUID.httpStatusCode, .bit32(0x2AB8))

    }

    /// Test HTTP Entity Body
    func testHttpEntityBody() {

         XCTAssertEqual(BluetoothUUID.httpEntityBody.rawValue, "2AB9")
         XCTAssertEqual(BluetoothUUID.httpEntityBody, .bit16(0x2AB9))
         XCTAssertEqual(BluetoothUUID.httpEntityBody, .bit16(10937))
         XCTAssertEqual(BluetoothUUID.httpEntityBody.name, "HTTP Entity Body")
         XCTAssertNotEqual(BluetoothUUID.httpEntityBody, .bit32(10937))
         XCTAssertNotEqual(BluetoothUUID.httpEntityBody, .bit32(0x2AB9))

    }

    /// Test HTTP Control Point
    func testHttpControlPoint() {

         XCTAssertEqual(BluetoothUUID.httpControlPoint.rawValue, "2ABA")
         XCTAssertEqual(BluetoothUUID.httpControlPoint, .bit16(0x2ABA))
         XCTAssertEqual(BluetoothUUID.httpControlPoint, .bit16(10938))
         XCTAssertEqual(BluetoothUUID.httpControlPoint.name, "HTTP Control Point")
         XCTAssertNotEqual(BluetoothUUID.httpControlPoint, .bit32(10938))
         XCTAssertNotEqual(BluetoothUUID.httpControlPoint, .bit32(0x2ABA))

    }

    /// Test HTTPS Security
    func testHttpsSecurity() {

         XCTAssertEqual(BluetoothUUID.httpsSecurity.rawValue, "2ABB")
         XCTAssertEqual(BluetoothUUID.httpsSecurity, .bit16(0x2ABB))
         XCTAssertEqual(BluetoothUUID.httpsSecurity, .bit16(10939))
         XCTAssertEqual(BluetoothUUID.httpsSecurity.name, "HTTPS Security")
         XCTAssertNotEqual(BluetoothUUID.httpsSecurity, .bit32(10939))
         XCTAssertNotEqual(BluetoothUUID.httpsSecurity, .bit32(0x2ABB))

    }

    /// Test TDS Control Point
    func testTdsControlPoint() {

         XCTAssertEqual(BluetoothUUID.tdsControlPoint.rawValue, "2ABC")
         XCTAssertEqual(BluetoothUUID.tdsControlPoint, .bit16(0x2ABC))
         XCTAssertEqual(BluetoothUUID.tdsControlPoint, .bit16(10940))
         XCTAssertEqual(BluetoothUUID.tdsControlPoint.name, "TDS Control Point")
         XCTAssertNotEqual(BluetoothUUID.tdsControlPoint, .bit32(10940))
         XCTAssertNotEqual(BluetoothUUID.tdsControlPoint, .bit32(0x2ABC))

    }

    /// Test OTS Feature
    func testOtsFeature() {

         XCTAssertEqual(BluetoothUUID.otsFeature.rawValue, "2ABD")
         XCTAssertEqual(BluetoothUUID.otsFeature, .bit16(0x2ABD))
         XCTAssertEqual(BluetoothUUID.otsFeature, .bit16(10941))
         XCTAssertEqual(BluetoothUUID.otsFeature.name, "OTS Feature")
         XCTAssertNotEqual(BluetoothUUID.otsFeature, .bit32(10941))
         XCTAssertNotEqual(BluetoothUUID.otsFeature, .bit32(0x2ABD))

    }

    /// Test Object Name
    func testObjectName() {

         XCTAssertEqual(BluetoothUUID.objectName.rawValue, "2ABE")
         XCTAssertEqual(BluetoothUUID.objectName, .bit16(0x2ABE))
         XCTAssertEqual(BluetoothUUID.objectName, .bit16(10942))
         XCTAssertEqual(BluetoothUUID.objectName.name, "Object Name")
         XCTAssertNotEqual(BluetoothUUID.objectName, .bit32(10942))
         XCTAssertNotEqual(BluetoothUUID.objectName, .bit32(0x2ABE))

    }

    /// Test Object Type
    func testObjectType() {

         XCTAssertEqual(BluetoothUUID.objectType.rawValue, "2ABF")
         XCTAssertEqual(BluetoothUUID.objectType, .bit16(0x2ABF))
         XCTAssertEqual(BluetoothUUID.objectType, .bit16(10943))
         XCTAssertEqual(BluetoothUUID.objectType.name, "Object Type")
         XCTAssertNotEqual(BluetoothUUID.objectType, .bit32(10943))
         XCTAssertNotEqual(BluetoothUUID.objectType, .bit32(0x2ABF))

    }

    /// Test Object Size
    func testObjectSize() {

         XCTAssertEqual(BluetoothUUID.objectSize.rawValue, "2AC0")
         XCTAssertEqual(BluetoothUUID.objectSize, .bit16(0x2AC0))
         XCTAssertEqual(BluetoothUUID.objectSize, .bit16(10944))
         XCTAssertEqual(BluetoothUUID.objectSize.name, "Object Size")
         XCTAssertNotEqual(BluetoothUUID.objectSize, .bit32(10944))
         XCTAssertNotEqual(BluetoothUUID.objectSize, .bit32(0x2AC0))

    }

    /// Test Object First-Created
    func testObjectFirstCreated() {

         XCTAssertEqual(BluetoothUUID.objectFirstCreated.rawValue, "2AC1")
         XCTAssertEqual(BluetoothUUID.objectFirstCreated, .bit16(0x2AC1))
         XCTAssertEqual(BluetoothUUID.objectFirstCreated, .bit16(10945))
         XCTAssertEqual(BluetoothUUID.objectFirstCreated.name, "Object First-Created")
         XCTAssertNotEqual(BluetoothUUID.objectFirstCreated, .bit32(10945))
         XCTAssertNotEqual(BluetoothUUID.objectFirstCreated, .bit32(0x2AC1))

    }

    /// Test Object Last-Modified
    func testObjectLastModified() {

         XCTAssertEqual(BluetoothUUID.objectLastModified.rawValue, "2AC2")
         XCTAssertEqual(BluetoothUUID.objectLastModified, .bit16(0x2AC2))
         XCTAssertEqual(BluetoothUUID.objectLastModified, .bit16(10946))
         XCTAssertEqual(BluetoothUUID.objectLastModified.name, "Object Last-Modified")
         XCTAssertNotEqual(BluetoothUUID.objectLastModified, .bit32(10946))
         XCTAssertNotEqual(BluetoothUUID.objectLastModified, .bit32(0x2AC2))

    }

    /// Test Object ID
    func testObjectId() {

         XCTAssertEqual(BluetoothUUID.objectId.rawValue, "2AC3")
         XCTAssertEqual(BluetoothUUID.objectId, .bit16(0x2AC3))
         XCTAssertEqual(BluetoothUUID.objectId, .bit16(10947))
         XCTAssertEqual(BluetoothUUID.objectId.name, "Object ID")
         XCTAssertNotEqual(BluetoothUUID.objectId, .bit32(10947))
         XCTAssertNotEqual(BluetoothUUID.objectId, .bit32(0x2AC3))

    }

    /// Test Object Properties
    func testObjectProperties() {

         XCTAssertEqual(BluetoothUUID.objectProperties.rawValue, "2AC4")
         XCTAssertEqual(BluetoothUUID.objectProperties, .bit16(0x2AC4))
         XCTAssertEqual(BluetoothUUID.objectProperties, .bit16(10948))
         XCTAssertEqual(BluetoothUUID.objectProperties.name, "Object Properties")
         XCTAssertNotEqual(BluetoothUUID.objectProperties, .bit32(10948))
         XCTAssertNotEqual(BluetoothUUID.objectProperties, .bit32(0x2AC4))

    }

    /// Test Object Action Control Point
    func testObjectActionControlPoint() {

         XCTAssertEqual(BluetoothUUID.objectActionControlPoint.rawValue, "2AC5")
         XCTAssertEqual(BluetoothUUID.objectActionControlPoint, .bit16(0x2AC5))
         XCTAssertEqual(BluetoothUUID.objectActionControlPoint, .bit16(10949))
         XCTAssertEqual(BluetoothUUID.objectActionControlPoint.name, "Object Action Control Point")
         XCTAssertNotEqual(BluetoothUUID.objectActionControlPoint, .bit32(10949))
         XCTAssertNotEqual(BluetoothUUID.objectActionControlPoint, .bit32(0x2AC5))

    }

    /// Test Object List Control Point
    func testObjectListControlPoint() {

         XCTAssertEqual(BluetoothUUID.objectListControlPoint.rawValue, "2AC6")
         XCTAssertEqual(BluetoothUUID.objectListControlPoint, .bit16(0x2AC6))
         XCTAssertEqual(BluetoothUUID.objectListControlPoint, .bit16(10950))
         XCTAssertEqual(BluetoothUUID.objectListControlPoint.name, "Object List Control Point")
         XCTAssertNotEqual(BluetoothUUID.objectListControlPoint, .bit32(10950))
         XCTAssertNotEqual(BluetoothUUID.objectListControlPoint, .bit32(0x2AC6))

    }

    /// Test Object List Filter
    func testObjectListFilter() {

         XCTAssertEqual(BluetoothUUID.objectListFilter.rawValue, "2AC7")
         XCTAssertEqual(BluetoothUUID.objectListFilter, .bit16(0x2AC7))
         XCTAssertEqual(BluetoothUUID.objectListFilter, .bit16(10951))
         XCTAssertEqual(BluetoothUUID.objectListFilter.name, "Object List Filter")
         XCTAssertNotEqual(BluetoothUUID.objectListFilter, .bit32(10951))
         XCTAssertNotEqual(BluetoothUUID.objectListFilter, .bit32(0x2AC7))

    }

    /// Test Object Changed
    func testObjectChanged() {

         XCTAssertEqual(BluetoothUUID.objectChanged.rawValue, "2AC8")
         XCTAssertEqual(BluetoothUUID.objectChanged, .bit16(0x2AC8))
         XCTAssertEqual(BluetoothUUID.objectChanged, .bit16(10952))
         XCTAssertEqual(BluetoothUUID.objectChanged.name, "Object Changed")
         XCTAssertNotEqual(BluetoothUUID.objectChanged, .bit32(10952))
         XCTAssertNotEqual(BluetoothUUID.objectChanged, .bit32(0x2AC8))

    }

    /// Test Intel Corporation
    func testIntelCorporation() {

         XCTAssertEqual(BluetoothUUID.intelCorporation.rawValue, "FE66")
         XCTAssertEqual(BluetoothUUID.intelCorporation, .bit16(0xFE66))
         XCTAssertEqual(BluetoothUUID.intelCorporation, .bit16(65126))
         XCTAssertEqual(BluetoothUUID.intelCorporation.name, "Intel Corporation")
         XCTAssertNotEqual(BluetoothUUID.intelCorporation, .bit32(65126))
         XCTAssertNotEqual(BluetoothUUID.intelCorporation, .bit32(0xFE66))

    }

    /// Test Lab Sensor Solutions
    func testLabSensorSolutions() {

         XCTAssertEqual(BluetoothUUID.labSensorSolutions.rawValue, "FE67")
         XCTAssertEqual(BluetoothUUID.labSensorSolutions, .bit16(0xFE67))
         XCTAssertEqual(BluetoothUUID.labSensorSolutions, .bit16(65127))
         XCTAssertEqual(BluetoothUUID.labSensorSolutions.name, "Lab Sensor Solutions")
         XCTAssertNotEqual(BluetoothUUID.labSensorSolutions, .bit32(65127))
         XCTAssertNotEqual(BluetoothUUID.labSensorSolutions, .bit32(0xFE67))

    }

    /// Test Qualcomm Life Inc
    func testQualcommLife() {

         XCTAssertEqual(BluetoothUUID.qualcommLife.rawValue, "FE68")
         XCTAssertEqual(BluetoothUUID.qualcommLife, .bit16(0xFE68))
         XCTAssertEqual(BluetoothUUID.qualcommLife, .bit16(65128))
         XCTAssertEqual(BluetoothUUID.qualcommLife.name, "Qualcomm Life Inc")
         XCTAssertNotEqual(BluetoothUUID.qualcommLife, .bit32(65128))
         XCTAssertNotEqual(BluetoothUUID.qualcommLife, .bit32(0xFE68))

    }

    /// Test Qualcomm Life Inc
    func testQualcommLife2() {

         XCTAssertEqual(BluetoothUUID.qualcommLife2.rawValue, "FE69")
         XCTAssertEqual(BluetoothUUID.qualcommLife2, .bit16(0xFE69))
         XCTAssertEqual(BluetoothUUID.qualcommLife2, .bit16(65129))
         XCTAssertEqual(BluetoothUUID.qualcommLife2.name, "Qualcomm Life Inc")
         XCTAssertNotEqual(BluetoothUUID.qualcommLife2, .bit32(65129))
         XCTAssertNotEqual(BluetoothUUID.qualcommLife2, .bit32(0xFE69))

    }

    /// Test Kontakt Micro-Location Sp. z o.o.
    func testKontaktMicroLocation() {

         XCTAssertEqual(BluetoothUUID.kontaktMicroLocation.rawValue, "FE6A")
         XCTAssertEqual(BluetoothUUID.kontaktMicroLocation, .bit16(0xFE6A))
         XCTAssertEqual(BluetoothUUID.kontaktMicroLocation, .bit16(65130))
         XCTAssertEqual(BluetoothUUID.kontaktMicroLocation.name, "Kontakt Micro-Location Sp. z o.o.")
         XCTAssertNotEqual(BluetoothUUID.kontaktMicroLocation, .bit32(65130))
         XCTAssertNotEqual(BluetoothUUID.kontaktMicroLocation, .bit32(0xFE6A))

    }

    /// Test TASER International, Inc.
    func testTaserInternational() {

         XCTAssertEqual(BluetoothUUID.taserInternational.rawValue, "FE6B")
         XCTAssertEqual(BluetoothUUID.taserInternational, .bit16(0xFE6B))
         XCTAssertEqual(BluetoothUUID.taserInternational, .bit16(65131))
         XCTAssertEqual(BluetoothUUID.taserInternational.name, "TASER International, Inc.")
         XCTAssertNotEqual(BluetoothUUID.taserInternational, .bit32(65131))
         XCTAssertNotEqual(BluetoothUUID.taserInternational, .bit32(0xFE6B))

    }

    /// Test TASER International, Inc.
    func testTaserInternational2() {

         XCTAssertEqual(BluetoothUUID.taserInternational2.rawValue, "FE6C")
         XCTAssertEqual(BluetoothUUID.taserInternational2, .bit16(0xFE6C))
         XCTAssertEqual(BluetoothUUID.taserInternational2, .bit16(65132))
         XCTAssertEqual(BluetoothUUID.taserInternational2.name, "TASER International, Inc.")
         XCTAssertNotEqual(BluetoothUUID.taserInternational2, .bit32(65132))
         XCTAssertNotEqual(BluetoothUUID.taserInternational2, .bit32(0xFE6C))

    }

    /// Test The University of Tokyo
    func testUniversityOfTokyo() {

         XCTAssertEqual(BluetoothUUID.universityOfTokyo.rawValue, "FE6D")
         XCTAssertEqual(BluetoothUUID.universityOfTokyo, .bit16(0xFE6D))
         XCTAssertEqual(BluetoothUUID.universityOfTokyo, .bit16(65133))
         XCTAssertEqual(BluetoothUUID.universityOfTokyo.name, "The University of Tokyo")
         XCTAssertNotEqual(BluetoothUUID.universityOfTokyo, .bit32(65133))
         XCTAssertNotEqual(BluetoothUUID.universityOfTokyo, .bit32(0xFE6D))

    }

    /// Test The University of Tokyo
    func testUniversityOfTokyo2() {

         XCTAssertEqual(BluetoothUUID.universityOfTokyo2.rawValue, "FE6E")
         XCTAssertEqual(BluetoothUUID.universityOfTokyo2, .bit16(0xFE6E))
         XCTAssertEqual(BluetoothUUID.universityOfTokyo2, .bit16(65134))
         XCTAssertEqual(BluetoothUUID.universityOfTokyo2.name, "The University of Tokyo")
         XCTAssertNotEqual(BluetoothUUID.universityOfTokyo2, .bit32(65134))
         XCTAssertNotEqual(BluetoothUUID.universityOfTokyo2, .bit32(0xFE6E))

    }

    /// Test LINE Corporation
    func testLineCorporation() {

         XCTAssertEqual(BluetoothUUID.lineCorporation.rawValue, "FE6F")
         XCTAssertEqual(BluetoothUUID.lineCorporation, .bit16(0xFE6F))
         XCTAssertEqual(BluetoothUUID.lineCorporation, .bit16(65135))
         XCTAssertEqual(BluetoothUUID.lineCorporation.name, "LINE Corporation")
         XCTAssertNotEqual(BluetoothUUID.lineCorporation, .bit32(65135))
         XCTAssertNotEqual(BluetoothUUID.lineCorporation, .bit32(0xFE6F))

    }

    /// Test Beijing Jingdong Century Trading Co., Ltd.
    func testBeijingJingdongCenturyTrading() {

         XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading.rawValue, "FE70")
         XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit16(0xFE70))
         XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit16(65136))
         XCTAssertEqual(BluetoothUUID.beijingJingdongCenturyTrading.name, "Beijing Jingdong Century Trading Co., Ltd.")
         XCTAssertNotEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit32(65136))
         XCTAssertNotEqual(BluetoothUUID.beijingJingdongCenturyTrading, .bit32(0xFE70))

    }

    /// Test Plume Design Inc
    func testPlumeDesign() {

         XCTAssertEqual(BluetoothUUID.plumeDesign.rawValue, "FE71")
         XCTAssertEqual(BluetoothUUID.plumeDesign, .bit16(0xFE71))
         XCTAssertEqual(BluetoothUUID.plumeDesign, .bit16(65137))
         XCTAssertEqual(BluetoothUUID.plumeDesign.name, "Plume Design Inc")
         XCTAssertNotEqual(BluetoothUUID.plumeDesign, .bit32(65137))
         XCTAssertNotEqual(BluetoothUUID.plumeDesign, .bit32(0xFE71))

    }

    /// Test St. Jude Medical, Inc.
    func testStJudeMedical() {

         XCTAssertEqual(BluetoothUUID.stJudeMedical.rawValue, "FE72")
         XCTAssertEqual(BluetoothUUID.stJudeMedical, .bit16(0xFE72))
         XCTAssertEqual(BluetoothUUID.stJudeMedical, .bit16(65138))
         XCTAssertEqual(BluetoothUUID.stJudeMedical.name, "St. Jude Medical, Inc.")
         XCTAssertNotEqual(BluetoothUUID.stJudeMedical, .bit32(65138))
         XCTAssertNotEqual(BluetoothUUID.stJudeMedical, .bit32(0xFE72))

    }

    /// Test St. Jude Medical, Inc.
    func testStJudeMedical2() {

         XCTAssertEqual(BluetoothUUID.stJudeMedical2.rawValue, "FE73")
         XCTAssertEqual(BluetoothUUID.stJudeMedical2, .bit16(0xFE73))
         XCTAssertEqual(BluetoothUUID.stJudeMedical2, .bit16(65139))
         XCTAssertEqual(BluetoothUUID.stJudeMedical2.name, "St. Jude Medical, Inc.")
         XCTAssertNotEqual(BluetoothUUID.stJudeMedical2, .bit32(65139))
         XCTAssertNotEqual(BluetoothUUID.stJudeMedical2, .bit32(0xFE73))

    }

    /// Test unwire
    func testUnwire() {

         XCTAssertEqual(BluetoothUUID.unwire.rawValue, "FE74")
         XCTAssertEqual(BluetoothUUID.unwire, .bit16(0xFE74))
         XCTAssertEqual(BluetoothUUID.unwire, .bit16(65140))
         XCTAssertEqual(BluetoothUUID.unwire.name, "unwire")
         XCTAssertNotEqual(BluetoothUUID.unwire, .bit32(65140))
         XCTAssertNotEqual(BluetoothUUID.unwire, .bit32(0xFE74))

    }

    /// Test TangoMe
    func testTangome() {

         XCTAssertEqual(BluetoothUUID.tangome.rawValue, "FE75")
         XCTAssertEqual(BluetoothUUID.tangome, .bit16(0xFE75))
         XCTAssertEqual(BluetoothUUID.tangome, .bit16(65141))
         XCTAssertEqual(BluetoothUUID.tangome.name, "TangoMe")
         XCTAssertNotEqual(BluetoothUUID.tangome, .bit32(65141))
         XCTAssertNotEqual(BluetoothUUID.tangome, .bit32(0xFE75))

    }

    /// Test TangoMe
    func testTangome2() {

         XCTAssertEqual(BluetoothUUID.tangome2.rawValue, "FE76")
         XCTAssertEqual(BluetoothUUID.tangome2, .bit16(0xFE76))
         XCTAssertEqual(BluetoothUUID.tangome2, .bit16(65142))
         XCTAssertEqual(BluetoothUUID.tangome2.name, "TangoMe")
         XCTAssertNotEqual(BluetoothUUID.tangome2, .bit32(65142))
         XCTAssertNotEqual(BluetoothUUID.tangome2, .bit32(0xFE76))

    }

    /// Test Hewlett-Packard Company
    func testHewlettPackardCompany() {

         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany.rawValue, "FE77")
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany, .bit16(0xFE77))
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany, .bit16(65143))
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany.name, "Hewlett-Packard Company")
         XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany, .bit32(65143))
         XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany, .bit32(0xFE77))

    }

    /// Test Hewlett-Packard Company
    func testHewlettPackardCompany2() {

         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2.rawValue, "FE78")
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2, .bit16(0xFE78))
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2, .bit16(65144))
         XCTAssertEqual(BluetoothUUID.hewlettPackardCompany2.name, "Hewlett-Packard Company")
         XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany2, .bit32(65144))
         XCTAssertNotEqual(BluetoothUUID.hewlettPackardCompany2, .bit32(0xFE78))

    }

    /// Test Zebra Technologies
    func testZebraTechnologies() {

         XCTAssertEqual(BluetoothUUID.zebraTechnologies.rawValue, "FE79")
         XCTAssertEqual(BluetoothUUID.zebraTechnologies, .bit16(0xFE79))
         XCTAssertEqual(BluetoothUUID.zebraTechnologies, .bit16(65145))
         XCTAssertEqual(BluetoothUUID.zebraTechnologies.name, "Zebra Technologies")
         XCTAssertNotEqual(BluetoothUUID.zebraTechnologies, .bit32(65145))
         XCTAssertNotEqual(BluetoothUUID.zebraTechnologies, .bit32(0xFE79))

    }

    /// Test Bragi GmbH
    func testBragiGmbh() {

         XCTAssertEqual(BluetoothUUID.bragiGmbh.rawValue, "FE7A")
         XCTAssertEqual(BluetoothUUID.bragiGmbh, .bit16(0xFE7A))
         XCTAssertEqual(BluetoothUUID.bragiGmbh, .bit16(65146))
         XCTAssertEqual(BluetoothUUID.bragiGmbh.name, "Bragi GmbH")
         XCTAssertNotEqual(BluetoothUUID.bragiGmbh, .bit32(65146))
         XCTAssertNotEqual(BluetoothUUID.bragiGmbh, .bit32(0xFE7A))

    }

    /// Test Orion Labs, Inc.
    func testOrionLabs() {

         XCTAssertEqual(BluetoothUUID.orionLabs.rawValue, "FE7B")
         XCTAssertEqual(BluetoothUUID.orionLabs, .bit16(0xFE7B))
         XCTAssertEqual(BluetoothUUID.orionLabs, .bit16(65147))
         XCTAssertEqual(BluetoothUUID.orionLabs.name, "Orion Labs, Inc.")
         XCTAssertNotEqual(BluetoothUUID.orionLabs, .bit32(65147))
         XCTAssertNotEqual(BluetoothUUID.orionLabs, .bit32(0xFE7B))

    }

    /// Test Stollmann E+V GmbH
    func testStollmannEVGmbh() {

         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh.rawValue, "FE7C")
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh, .bit16(0xFE7C))
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh, .bit16(65148))
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh.name, "Stollmann E+V GmbH")
         XCTAssertNotEqual(BluetoothUUID.stollmannEVGmbh, .bit32(65148))
         XCTAssertNotEqual(BluetoothUUID.stollmannEVGmbh, .bit32(0xFE7C))

    }

    /// Test Aterica Health Inc.
    func testAtericaHealth() {

         XCTAssertEqual(BluetoothUUID.atericaHealth.rawValue, "FE7D")
         XCTAssertEqual(BluetoothUUID.atericaHealth, .bit16(0xFE7D))
         XCTAssertEqual(BluetoothUUID.atericaHealth, .bit16(65149))
         XCTAssertEqual(BluetoothUUID.atericaHealth.name, "Aterica Health Inc.")
         XCTAssertNotEqual(BluetoothUUID.atericaHealth, .bit32(65149))
         XCTAssertNotEqual(BluetoothUUID.atericaHealth, .bit32(0xFE7D))

    }

    /// Test Awear Solutions Ltd
    func testAwearSolutions() {

         XCTAssertEqual(BluetoothUUID.awearSolutions.rawValue, "FE7E")
         XCTAssertEqual(BluetoothUUID.awearSolutions, .bit16(0xFE7E))
         XCTAssertEqual(BluetoothUUID.awearSolutions, .bit16(65150))
         XCTAssertEqual(BluetoothUUID.awearSolutions.name, "Awear Solutions Ltd")
         XCTAssertNotEqual(BluetoothUUID.awearSolutions, .bit32(65150))
         XCTAssertNotEqual(BluetoothUUID.awearSolutions, .bit32(0xFE7E))

    }

    /// Test Doppler Lab
    func testDopplerLab() {

         XCTAssertEqual(BluetoothUUID.dopplerLab.rawValue, "FE7F")
         XCTAssertEqual(BluetoothUUID.dopplerLab, .bit16(0xFE7F))
         XCTAssertEqual(BluetoothUUID.dopplerLab, .bit16(65151))
         XCTAssertEqual(BluetoothUUID.dopplerLab.name, "Doppler Lab")
         XCTAssertNotEqual(BluetoothUUID.dopplerLab, .bit32(65151))
         XCTAssertNotEqual(BluetoothUUID.dopplerLab, .bit32(0xFE7F))

    }

    /// Test Doppler Lab
    func testDopplerLab2() {

         XCTAssertEqual(BluetoothUUID.dopplerLab2.rawValue, "FE80")
         XCTAssertEqual(BluetoothUUID.dopplerLab2, .bit16(0xFE80))
         XCTAssertEqual(BluetoothUUID.dopplerLab2, .bit16(65152))
         XCTAssertEqual(BluetoothUUID.dopplerLab2.name, "Doppler Lab")
         XCTAssertNotEqual(BluetoothUUID.dopplerLab2, .bit32(65152))
         XCTAssertNotEqual(BluetoothUUID.dopplerLab2, .bit32(0xFE80))

    }

    /// Test Medtronic Inc.
    func testMedtronic() {

         XCTAssertEqual(BluetoothUUID.medtronic.rawValue, "FE81")
         XCTAssertEqual(BluetoothUUID.medtronic, .bit16(0xFE81))
         XCTAssertEqual(BluetoothUUID.medtronic, .bit16(65153))
         XCTAssertEqual(BluetoothUUID.medtronic.name, "Medtronic Inc.")
         XCTAssertNotEqual(BluetoothUUID.medtronic, .bit32(65153))
         XCTAssertNotEqual(BluetoothUUID.medtronic, .bit32(0xFE81))

    }

    /// Test Medtronic Inc.
    func testMedtronic2() {

         XCTAssertEqual(BluetoothUUID.medtronic2.rawValue, "FE82")
         XCTAssertEqual(BluetoothUUID.medtronic2, .bit16(0xFE82))
         XCTAssertEqual(BluetoothUUID.medtronic2, .bit16(65154))
         XCTAssertEqual(BluetoothUUID.medtronic2.name, "Medtronic Inc.")
         XCTAssertNotEqual(BluetoothUUID.medtronic2, .bit32(65154))
         XCTAssertNotEqual(BluetoothUUID.medtronic2, .bit32(0xFE82))

    }

    /// Test Blue Bite
    func testBlueBite() {

         XCTAssertEqual(BluetoothUUID.blueBite.rawValue, "FE83")
         XCTAssertEqual(BluetoothUUID.blueBite, .bit16(0xFE83))
         XCTAssertEqual(BluetoothUUID.blueBite, .bit16(65155))
         XCTAssertEqual(BluetoothUUID.blueBite.name, "Blue Bite")
         XCTAssertNotEqual(BluetoothUUID.blueBite, .bit32(65155))
         XCTAssertNotEqual(BluetoothUUID.blueBite, .bit32(0xFE83))

    }

    /// Test RF Digital Corp
    func testRfDigitalCorp() {

         XCTAssertEqual(BluetoothUUID.rfDigitalCorp.rawValue, "FE84")
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp, .bit16(0xFE84))
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp, .bit16(65156))
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp.name, "RF Digital Corp")
         XCTAssertNotEqual(BluetoothUUID.rfDigitalCorp, .bit32(65156))
         XCTAssertNotEqual(BluetoothUUID.rfDigitalCorp, .bit32(0xFE84))

    }

    /// Test RF Digital Corp
    func testRfDigitalCorp2() {

         XCTAssertEqual(BluetoothUUID.rfDigitalCorp2.rawValue, "FE85")
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp2, .bit16(0xFE85))
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp2, .bit16(65157))
         XCTAssertEqual(BluetoothUUID.rfDigitalCorp2.name, "RF Digital Corp")
         XCTAssertNotEqual(BluetoothUUID.rfDigitalCorp2, .bit32(65157))
         XCTAssertNotEqual(BluetoothUUID.rfDigitalCorp2, .bit32(0xFE85))

    }

    /// Test HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )
    func testHuaweiTechnologies华为技术有限公司() {

         XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司.rawValue, "FE86")
         XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit16(0xFE86))
         XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit16(65158))
         XCTAssertEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司.name, "HUAWEI Technologies Co., Ltd. ( 华为技术有限公司 )")
         XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit32(65158))
         XCTAssertNotEqual(BluetoothUUID.huaweiTechnologies华为技术有限公司, .bit32(0xFE86))

    }

    /// Test Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )
    func testQingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司() {

         XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.rawValue, "FE87")
         XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit16(0xFE87))
         XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit16(65159))
         XCTAssertEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司.name, "Qingdao Yeelink Information Technology Co., Ltd. ( 青岛亿联客信息技术有限公司 )")
         XCTAssertNotEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit32(65159))
         XCTAssertNotEqual(BluetoothUUID.qingdaoYeelinkInformationTechnology青岛亿联客信息技术有限公司, .bit32(0xFE87))

    }

    /// Test SALTO SYSTEMS S.L.
    func testSaltoSystemsSL() {

         XCTAssertEqual(BluetoothUUID.saltoSystemsSL.rawValue, "FE88")
         XCTAssertEqual(BluetoothUUID.saltoSystemsSL, .bit16(0xFE88))
         XCTAssertEqual(BluetoothUUID.saltoSystemsSL, .bit16(65160))
         XCTAssertEqual(BluetoothUUID.saltoSystemsSL.name, "SALTO SYSTEMS S.L.")
         XCTAssertNotEqual(BluetoothUUID.saltoSystemsSL, .bit32(65160))
         XCTAssertNotEqual(BluetoothUUID.saltoSystemsSL, .bit32(0xFE88))

    }

    /// Test B&O Play A/S
    func testBOPlayAS() {

         XCTAssertEqual(BluetoothUUID.bOPlayAS.rawValue, "FE89")
         XCTAssertEqual(BluetoothUUID.bOPlayAS, .bit16(0xFE89))
         XCTAssertEqual(BluetoothUUID.bOPlayAS, .bit16(65161))
         XCTAssertEqual(BluetoothUUID.bOPlayAS.name, "B&O Play A/S")
         XCTAssertNotEqual(BluetoothUUID.bOPlayAS, .bit32(65161))
         XCTAssertNotEqual(BluetoothUUID.bOPlayAS, .bit32(0xFE89))

    }

    /// Test Apple, Inc.
    func testApple() {

         XCTAssertEqual(BluetoothUUID.apple.rawValue, "FE8A")
         XCTAssertEqual(BluetoothUUID.apple, .bit16(0xFE8A))
         XCTAssertEqual(BluetoothUUID.apple, .bit16(65162))
         XCTAssertEqual(BluetoothUUID.apple.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple, .bit32(65162))
         XCTAssertNotEqual(BluetoothUUID.apple, .bit32(0xFE8A))

    }

    /// Test Apple, Inc.
    func testApple2() {

         XCTAssertEqual(BluetoothUUID.apple2.rawValue, "FE8B")
         XCTAssertEqual(BluetoothUUID.apple2, .bit16(0xFE8B))
         XCTAssertEqual(BluetoothUUID.apple2, .bit16(65163))
         XCTAssertEqual(BluetoothUUID.apple2.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple2, .bit32(65163))
         XCTAssertNotEqual(BluetoothUUID.apple2, .bit32(0xFE8B))

    }

    /// Test TRON Forum
    func testTronForum() {

         XCTAssertEqual(BluetoothUUID.tronForum.rawValue, "FE8C")
         XCTAssertEqual(BluetoothUUID.tronForum, .bit16(0xFE8C))
         XCTAssertEqual(BluetoothUUID.tronForum, .bit16(65164))
         XCTAssertEqual(BluetoothUUID.tronForum.name, "TRON Forum")
         XCTAssertNotEqual(BluetoothUUID.tronForum, .bit32(65164))
         XCTAssertNotEqual(BluetoothUUID.tronForum, .bit32(0xFE8C))

    }

    /// Test Interaxon Inc.
    func testInteraxon() {

         XCTAssertEqual(BluetoothUUID.interaxon.rawValue, "FE8D")
         XCTAssertEqual(BluetoothUUID.interaxon, .bit16(0xFE8D))
         XCTAssertEqual(BluetoothUUID.interaxon, .bit16(65165))
         XCTAssertEqual(BluetoothUUID.interaxon.name, "Interaxon Inc.")
         XCTAssertNotEqual(BluetoothUUID.interaxon, .bit32(65165))
         XCTAssertNotEqual(BluetoothUUID.interaxon, .bit32(0xFE8D))

    }

    /// Test ARM Ltd
    func testArm() {

         XCTAssertEqual(BluetoothUUID.arm.rawValue, "FE8E")
         XCTAssertEqual(BluetoothUUID.arm, .bit16(0xFE8E))
         XCTAssertEqual(BluetoothUUID.arm, .bit16(65166))
         XCTAssertEqual(BluetoothUUID.arm.name, "ARM Ltd")
         XCTAssertNotEqual(BluetoothUUID.arm, .bit32(65166))
         XCTAssertNotEqual(BluetoothUUID.arm, .bit32(0xFE8E))

    }

    /// Test CSR
    func testCsr() {

         XCTAssertEqual(BluetoothUUID.csr.rawValue, "FE8F")
         XCTAssertEqual(BluetoothUUID.csr, .bit16(0xFE8F))
         XCTAssertEqual(BluetoothUUID.csr, .bit16(65167))
         XCTAssertEqual(BluetoothUUID.csr.name, "CSR")
         XCTAssertNotEqual(BluetoothUUID.csr, .bit32(65167))
         XCTAssertNotEqual(BluetoothUUID.csr, .bit32(0xFE8F))

    }

    /// Test JUMA
    func testJuma() {

         XCTAssertEqual(BluetoothUUID.juma.rawValue, "FE90")
         XCTAssertEqual(BluetoothUUID.juma, .bit16(0xFE90))
         XCTAssertEqual(BluetoothUUID.juma, .bit16(65168))
         XCTAssertEqual(BluetoothUUID.juma.name, "JUMA")
         XCTAssertNotEqual(BluetoothUUID.juma, .bit32(65168))
         XCTAssertNotEqual(BluetoothUUID.juma, .bit32(0xFE90))

    }

    /// Test Shanghai Imilab Technology Co.,Ltd
    func testShanghaiImilabTechnology() {

         XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology.rawValue, "FE91")
         XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology, .bit16(0xFE91))
         XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology, .bit16(65169))
         XCTAssertEqual(BluetoothUUID.shanghaiImilabTechnology.name, "Shanghai Imilab Technology Co.,Ltd")
         XCTAssertNotEqual(BluetoothUUID.shanghaiImilabTechnology, .bit32(65169))
         XCTAssertNotEqual(BluetoothUUID.shanghaiImilabTechnology, .bit32(0xFE91))

    }

    /// Test Jarden Safety & Security
    func testJardenSafetySecurity() {

         XCTAssertEqual(BluetoothUUID.jardenSafetySecurity.rawValue, "FE92")
         XCTAssertEqual(BluetoothUUID.jardenSafetySecurity, .bit16(0xFE92))
         XCTAssertEqual(BluetoothUUID.jardenSafetySecurity, .bit16(65170))
         XCTAssertEqual(BluetoothUUID.jardenSafetySecurity.name, "Jarden Safety & Security")
         XCTAssertNotEqual(BluetoothUUID.jardenSafetySecurity, .bit32(65170))
         XCTAssertNotEqual(BluetoothUUID.jardenSafetySecurity, .bit32(0xFE92))

    }

    /// Test OttoQ Inc.
    func testOttoq() {

         XCTAssertEqual(BluetoothUUID.ottoq.rawValue, "FE93")
         XCTAssertEqual(BluetoothUUID.ottoq, .bit16(0xFE93))
         XCTAssertEqual(BluetoothUUID.ottoq, .bit16(65171))
         XCTAssertEqual(BluetoothUUID.ottoq.name, "OttoQ Inc.")
         XCTAssertNotEqual(BluetoothUUID.ottoq, .bit32(65171))
         XCTAssertNotEqual(BluetoothUUID.ottoq, .bit32(0xFE93))

    }

    /// Test OttoQ Inc.
    func testOttoq2() {

         XCTAssertEqual(BluetoothUUID.ottoq2.rawValue, "FE94")
         XCTAssertEqual(BluetoothUUID.ottoq2, .bit16(0xFE94))
         XCTAssertEqual(BluetoothUUID.ottoq2, .bit16(65172))
         XCTAssertEqual(BluetoothUUID.ottoq2.name, "OttoQ Inc.")
         XCTAssertNotEqual(BluetoothUUID.ottoq2, .bit32(65172))
         XCTAssertNotEqual(BluetoothUUID.ottoq2, .bit32(0xFE94))

    }

    /// Test Xiaomi Inc.
    func testXiaomi() {

         XCTAssertEqual(BluetoothUUID.xiaomi.rawValue, "FE95")
         XCTAssertEqual(BluetoothUUID.xiaomi, .bit16(0xFE95))
         XCTAssertEqual(BluetoothUUID.xiaomi, .bit16(65173))
         XCTAssertEqual(BluetoothUUID.xiaomi.name, "Xiaomi Inc.")
         XCTAssertNotEqual(BluetoothUUID.xiaomi, .bit32(65173))
         XCTAssertNotEqual(BluetoothUUID.xiaomi, .bit32(0xFE95))

    }

    /// Test Tesla Motor Inc.
    func testTeslaMotor() {

         XCTAssertEqual(BluetoothUUID.teslaMotor.rawValue, "FE96")
         XCTAssertEqual(BluetoothUUID.teslaMotor, .bit16(0xFE96))
         XCTAssertEqual(BluetoothUUID.teslaMotor, .bit16(65174))
         XCTAssertEqual(BluetoothUUID.teslaMotor.name, "Tesla Motor Inc.")
         XCTAssertNotEqual(BluetoothUUID.teslaMotor, .bit32(65174))
         XCTAssertNotEqual(BluetoothUUID.teslaMotor, .bit32(0xFE96))

    }

    /// Test Tesla Motor Inc.
    func testTeslaMotor2() {

         XCTAssertEqual(BluetoothUUID.teslaMotor2.rawValue, "FE97")
         XCTAssertEqual(BluetoothUUID.teslaMotor2, .bit16(0xFE97))
         XCTAssertEqual(BluetoothUUID.teslaMotor2, .bit16(65175))
         XCTAssertEqual(BluetoothUUID.teslaMotor2.name, "Tesla Motor Inc.")
         XCTAssertNotEqual(BluetoothUUID.teslaMotor2, .bit32(65175))
         XCTAssertNotEqual(BluetoothUUID.teslaMotor2, .bit32(0xFE97))

    }

    /// Test Currant, Inc.
    func testCurrant() {

         XCTAssertEqual(BluetoothUUID.currant.rawValue, "FE98")
         XCTAssertEqual(BluetoothUUID.currant, .bit16(0xFE98))
         XCTAssertEqual(BluetoothUUID.currant, .bit16(65176))
         XCTAssertEqual(BluetoothUUID.currant.name, "Currant, Inc.")
         XCTAssertNotEqual(BluetoothUUID.currant, .bit32(65176))
         XCTAssertNotEqual(BluetoothUUID.currant, .bit32(0xFE98))

    }

    /// Test Currant, Inc.
    func testCurrant2() {

         XCTAssertEqual(BluetoothUUID.currant2.rawValue, "FE99")
         XCTAssertEqual(BluetoothUUID.currant2, .bit16(0xFE99))
         XCTAssertEqual(BluetoothUUID.currant2, .bit16(65177))
         XCTAssertEqual(BluetoothUUID.currant2.name, "Currant, Inc.")
         XCTAssertNotEqual(BluetoothUUID.currant2, .bit32(65177))
         XCTAssertNotEqual(BluetoothUUID.currant2, .bit32(0xFE99))

    }

    /// Test Estimote
    func testEstimote() {

         XCTAssertEqual(BluetoothUUID.estimote.rawValue, "FE9A")
         XCTAssertEqual(BluetoothUUID.estimote, .bit16(0xFE9A))
         XCTAssertEqual(BluetoothUUID.estimote, .bit16(65178))
         XCTAssertEqual(BluetoothUUID.estimote.name, "Estimote")
         XCTAssertNotEqual(BluetoothUUID.estimote, .bit32(65178))
         XCTAssertNotEqual(BluetoothUUID.estimote, .bit32(0xFE9A))

    }

    /// Test Samsara Networks, Inc
    func testSamsaraNetworks() {

         XCTAssertEqual(BluetoothUUID.samsaraNetworks.rawValue, "FE9B")
         XCTAssertEqual(BluetoothUUID.samsaraNetworks, .bit16(0xFE9B))
         XCTAssertEqual(BluetoothUUID.samsaraNetworks, .bit16(65179))
         XCTAssertEqual(BluetoothUUID.samsaraNetworks.name, "Samsara Networks, Inc")
         XCTAssertNotEqual(BluetoothUUID.samsaraNetworks, .bit32(65179))
         XCTAssertNotEqual(BluetoothUUID.samsaraNetworks, .bit32(0xFE9B))

    }

    /// Test GSI Laboratories, Inc.
    func testGsiLaboratories() {

         XCTAssertEqual(BluetoothUUID.gsiLaboratories.rawValue, "FE9C")
         XCTAssertEqual(BluetoothUUID.gsiLaboratories, .bit16(0xFE9C))
         XCTAssertEqual(BluetoothUUID.gsiLaboratories, .bit16(65180))
         XCTAssertEqual(BluetoothUUID.gsiLaboratories.name, "GSI Laboratories, Inc.")
         XCTAssertNotEqual(BluetoothUUID.gsiLaboratories, .bit32(65180))
         XCTAssertNotEqual(BluetoothUUID.gsiLaboratories, .bit32(0xFE9C))

    }

    /// Test Mobiquity Networks Inc
    func testMobiquityNetworks() {

         XCTAssertEqual(BluetoothUUID.mobiquityNetworks.rawValue, "FE9D")
         XCTAssertEqual(BluetoothUUID.mobiquityNetworks, .bit16(0xFE9D))
         XCTAssertEqual(BluetoothUUID.mobiquityNetworks, .bit16(65181))
         XCTAssertEqual(BluetoothUUID.mobiquityNetworks.name, "Mobiquity Networks Inc")
         XCTAssertNotEqual(BluetoothUUID.mobiquityNetworks, .bit32(65181))
         XCTAssertNotEqual(BluetoothUUID.mobiquityNetworks, .bit32(0xFE9D))

    }

    /// Test Dialog Semiconductor B.V.
    func testDialogSemiconductorBV() {

         XCTAssertEqual(BluetoothUUID.dialogSemiconductorBV.rawValue, "FE9E")
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorBV, .bit16(0xFE9E))
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorBV, .bit16(65182))
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorBV.name, "Dialog Semiconductor B.V.")
         XCTAssertNotEqual(BluetoothUUID.dialogSemiconductorBV, .bit32(65182))
         XCTAssertNotEqual(BluetoothUUID.dialogSemiconductorBV, .bit32(0xFE9E))

    }

    /// Test Google
    func testGoogle() {

         XCTAssertEqual(BluetoothUUID.google.rawValue, "FE9F")
         XCTAssertEqual(BluetoothUUID.google, .bit16(0xFE9F))
         XCTAssertEqual(BluetoothUUID.google, .bit16(65183))
         XCTAssertEqual(BluetoothUUID.google.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google, .bit32(65183))
         XCTAssertNotEqual(BluetoothUUID.google, .bit32(0xFE9F))

    }

    /// Test Google
    func testGoogle2() {

         XCTAssertEqual(BluetoothUUID.google2.rawValue, "FEA0")
         XCTAssertEqual(BluetoothUUID.google2, .bit16(0xFEA0))
         XCTAssertEqual(BluetoothUUID.google2, .bit16(65184))
         XCTAssertEqual(BluetoothUUID.google2.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google2, .bit32(65184))
         XCTAssertNotEqual(BluetoothUUID.google2, .bit32(0xFEA0))

    }

    /// Test Intrepid Control Systems, Inc.
    func testIntrepidControlSystems() {

         XCTAssertEqual(BluetoothUUID.intrepidControlSystems.rawValue, "FEA1")
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems, .bit16(0xFEA1))
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems, .bit16(65185))
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems.name, "Intrepid Control Systems, Inc.")
         XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems, .bit32(65185))
         XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems, .bit32(0xFEA1))

    }

    /// Test Intrepid Control Systems, Inc.
    func testIntrepidControlSystems2() {

         XCTAssertEqual(BluetoothUUID.intrepidControlSystems2.rawValue, "FEA2")
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems2, .bit16(0xFEA2))
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems2, .bit16(65186))
         XCTAssertEqual(BluetoothUUID.intrepidControlSystems2.name, "Intrepid Control Systems, Inc.")
         XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems2, .bit32(65186))
         XCTAssertNotEqual(BluetoothUUID.intrepidControlSystems2, .bit32(0xFEA2))

    }

    /// Test ITT Industries
    func testIttIndustries() {

         XCTAssertEqual(BluetoothUUID.ittIndustries.rawValue, "FEA3")
         XCTAssertEqual(BluetoothUUID.ittIndustries, .bit16(0xFEA3))
         XCTAssertEqual(BluetoothUUID.ittIndustries, .bit16(65187))
         XCTAssertEqual(BluetoothUUID.ittIndustries.name, "ITT Industries")
         XCTAssertNotEqual(BluetoothUUID.ittIndustries, .bit32(65187))
         XCTAssertNotEqual(BluetoothUUID.ittIndustries, .bit32(0xFEA3))

    }

    /// Test Paxton Access Ltd
    func testPaxtonAccess() {

         XCTAssertEqual(BluetoothUUID.paxtonAccess.rawValue, "FEA4")
         XCTAssertEqual(BluetoothUUID.paxtonAccess, .bit16(0xFEA4))
         XCTAssertEqual(BluetoothUUID.paxtonAccess, .bit16(65188))
         XCTAssertEqual(BluetoothUUID.paxtonAccess.name, "Paxton Access Ltd")
         XCTAssertNotEqual(BluetoothUUID.paxtonAccess, .bit32(65188))
         XCTAssertNotEqual(BluetoothUUID.paxtonAccess, .bit32(0xFEA4))

    }

    /// Test GoPro, Inc.
    func testGopro() {

         XCTAssertEqual(BluetoothUUID.gopro.rawValue, "FEA5")
         XCTAssertEqual(BluetoothUUID.gopro, .bit16(0xFEA5))
         XCTAssertEqual(BluetoothUUID.gopro, .bit16(65189))
         XCTAssertEqual(BluetoothUUID.gopro.name, "GoPro, Inc.")
         XCTAssertNotEqual(BluetoothUUID.gopro, .bit32(65189))
         XCTAssertNotEqual(BluetoothUUID.gopro, .bit32(0xFEA5))

    }

    /// Test GoPro, Inc.
    func testGopro2() {

         XCTAssertEqual(BluetoothUUID.gopro2.rawValue, "FEA6")
         XCTAssertEqual(BluetoothUUID.gopro2, .bit16(0xFEA6))
         XCTAssertEqual(BluetoothUUID.gopro2, .bit16(65190))
         XCTAssertEqual(BluetoothUUID.gopro2.name, "GoPro, Inc.")
         XCTAssertNotEqual(BluetoothUUID.gopro2, .bit32(65190))
         XCTAssertNotEqual(BluetoothUUID.gopro2, .bit32(0xFEA6))

    }

    /// Test UTC Fire and Security
    func testUtcFireAndSecurity() {

         XCTAssertEqual(BluetoothUUID.utcFireAndSecurity.rawValue, "FEA7")
         XCTAssertEqual(BluetoothUUID.utcFireAndSecurity, .bit16(0xFEA7))
         XCTAssertEqual(BluetoothUUID.utcFireAndSecurity, .bit16(65191))
         XCTAssertEqual(BluetoothUUID.utcFireAndSecurity.name, "UTC Fire and Security")
         XCTAssertNotEqual(BluetoothUUID.utcFireAndSecurity, .bit32(65191))
         XCTAssertNotEqual(BluetoothUUID.utcFireAndSecurity, .bit32(0xFEA7))

    }

    /// Test Savant Systems LLC
    func testSavantSystems() {

         XCTAssertEqual(BluetoothUUID.savantSystems.rawValue, "FEA8")
         XCTAssertEqual(BluetoothUUID.savantSystems, .bit16(0xFEA8))
         XCTAssertEqual(BluetoothUUID.savantSystems, .bit16(65192))
         XCTAssertEqual(BluetoothUUID.savantSystems.name, "Savant Systems LLC")
         XCTAssertNotEqual(BluetoothUUID.savantSystems, .bit32(65192))
         XCTAssertNotEqual(BluetoothUUID.savantSystems, .bit32(0xFEA8))

    }

    /// Test Savant Systems LLC
    func testSavantSystems2() {

         XCTAssertEqual(BluetoothUUID.savantSystems2.rawValue, "FEA9")
         XCTAssertEqual(BluetoothUUID.savantSystems2, .bit16(0xFEA9))
         XCTAssertEqual(BluetoothUUID.savantSystems2, .bit16(65193))
         XCTAssertEqual(BluetoothUUID.savantSystems2.name, "Savant Systems LLC")
         XCTAssertNotEqual(BluetoothUUID.savantSystems2, .bit32(65193))
         XCTAssertNotEqual(BluetoothUUID.savantSystems2, .bit32(0xFEA9))

    }

    /// Test Google
    func testGoogle3() {

         XCTAssertEqual(BluetoothUUID.google3.rawValue, "FEAA")
         XCTAssertEqual(BluetoothUUID.google3, .bit16(0xFEAA))
         XCTAssertEqual(BluetoothUUID.google3, .bit16(65194))
         XCTAssertEqual(BluetoothUUID.google3.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google3, .bit32(65194))
         XCTAssertNotEqual(BluetoothUUID.google3, .bit32(0xFEAA))

    }

    /// Test Nokia Corporation
    func testNokiaCorporation() {

         XCTAssertEqual(BluetoothUUID.nokiaCorporation.rawValue, "FEAB")
         XCTAssertEqual(BluetoothUUID.nokiaCorporation, .bit16(0xFEAB))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation, .bit16(65195))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation.name, "Nokia Corporation")
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation, .bit32(65195))
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation, .bit32(0xFEAB))

    }

    /// Test Nokia Corporation
    func testNokiaCorporation2() {

         XCTAssertEqual(BluetoothUUID.nokiaCorporation2.rawValue, "FEAC")
         XCTAssertEqual(BluetoothUUID.nokiaCorporation2, .bit16(0xFEAC))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation2, .bit16(65196))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation2.name, "Nokia Corporation")
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation2, .bit32(65196))
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation2, .bit32(0xFEAC))

    }

    /// Test Nokia Corporation
    func testNokiaCorporation3() {

         XCTAssertEqual(BluetoothUUID.nokiaCorporation3.rawValue, "FEAD")
         XCTAssertEqual(BluetoothUUID.nokiaCorporation3, .bit16(0xFEAD))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation3, .bit16(65197))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation3.name, "Nokia Corporation")
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation3, .bit32(65197))
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation3, .bit32(0xFEAD))

    }

    /// Test Nokia Corporation
    func testNokiaCorporation4() {

         XCTAssertEqual(BluetoothUUID.nokiaCorporation4.rawValue, "FEAE")
         XCTAssertEqual(BluetoothUUID.nokiaCorporation4, .bit16(0xFEAE))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation4, .bit16(65198))
         XCTAssertEqual(BluetoothUUID.nokiaCorporation4.name, "Nokia Corporation")
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation4, .bit32(65198))
         XCTAssertNotEqual(BluetoothUUID.nokiaCorporation4, .bit32(0xFEAE))

    }

    /// Test Nest Labs Inc.
    func testNestLabs() {

         XCTAssertEqual(BluetoothUUID.nestLabs.rawValue, "FEAF")
         XCTAssertEqual(BluetoothUUID.nestLabs, .bit16(0xFEAF))
         XCTAssertEqual(BluetoothUUID.nestLabs, .bit16(65199))
         XCTAssertEqual(BluetoothUUID.nestLabs.name, "Nest Labs Inc.")
         XCTAssertNotEqual(BluetoothUUID.nestLabs, .bit32(65199))
         XCTAssertNotEqual(BluetoothUUID.nestLabs, .bit32(0xFEAF))

    }

    /// Test Nest Labs Inc.
    func testNestLabs2() {

         XCTAssertEqual(BluetoothUUID.nestLabs2.rawValue, "FEB0")
         XCTAssertEqual(BluetoothUUID.nestLabs2, .bit16(0xFEB0))
         XCTAssertEqual(BluetoothUUID.nestLabs2, .bit16(65200))
         XCTAssertEqual(BluetoothUUID.nestLabs2.name, "Nest Labs Inc.")
         XCTAssertNotEqual(BluetoothUUID.nestLabs2, .bit32(65200))
         XCTAssertNotEqual(BluetoothUUID.nestLabs2, .bit32(0xFEB0))

    }

    /// Test Electronics Tomorrow Limited
    func testElectronicsTomorrowLimited() {

         XCTAssertEqual(BluetoothUUID.electronicsTomorrowLimited.rawValue, "FEB1")
         XCTAssertEqual(BluetoothUUID.electronicsTomorrowLimited, .bit16(0xFEB1))
         XCTAssertEqual(BluetoothUUID.electronicsTomorrowLimited, .bit16(65201))
         XCTAssertEqual(BluetoothUUID.electronicsTomorrowLimited.name, "Electronics Tomorrow Limited")
         XCTAssertNotEqual(BluetoothUUID.electronicsTomorrowLimited, .bit32(65201))
         XCTAssertNotEqual(BluetoothUUID.electronicsTomorrowLimited, .bit32(0xFEB1))

    }

    /// Test Microsoft Corporation
    func testMicrosoftCorporation() {

         XCTAssertEqual(BluetoothUUID.microsoftCorporation.rawValue, "FEB2")
         XCTAssertEqual(BluetoothUUID.microsoftCorporation, .bit16(0xFEB2))
         XCTAssertEqual(BluetoothUUID.microsoftCorporation, .bit16(65202))
         XCTAssertEqual(BluetoothUUID.microsoftCorporation.name, "Microsoft Corporation")
         XCTAssertNotEqual(BluetoothUUID.microsoftCorporation, .bit32(65202))
         XCTAssertNotEqual(BluetoothUUID.microsoftCorporation, .bit32(0xFEB2))

    }

    /// Test Taobao
    func testTaobao() {

         XCTAssertEqual(BluetoothUUID.taobao.rawValue, "FEB3")
         XCTAssertEqual(BluetoothUUID.taobao, .bit16(0xFEB3))
         XCTAssertEqual(BluetoothUUID.taobao, .bit16(65203))
         XCTAssertEqual(BluetoothUUID.taobao.name, "Taobao")
         XCTAssertNotEqual(BluetoothUUID.taobao, .bit32(65203))
         XCTAssertNotEqual(BluetoothUUID.taobao, .bit32(0xFEB3))

    }

    /// Test WiSilica Inc.
    func testWisilica() {

         XCTAssertEqual(BluetoothUUID.wisilica.rawValue, "FEB4")
         XCTAssertEqual(BluetoothUUID.wisilica, .bit16(0xFEB4))
         XCTAssertEqual(BluetoothUUID.wisilica, .bit16(65204))
         XCTAssertEqual(BluetoothUUID.wisilica.name, "WiSilica Inc.")
         XCTAssertNotEqual(BluetoothUUID.wisilica, .bit32(65204))
         XCTAssertNotEqual(BluetoothUUID.wisilica, .bit32(0xFEB4))

    }

    /// Test WiSilica Inc.
    func testWisilica2() {

         XCTAssertEqual(BluetoothUUID.wisilica2.rawValue, "FEB5")
         XCTAssertEqual(BluetoothUUID.wisilica2, .bit16(0xFEB5))
         XCTAssertEqual(BluetoothUUID.wisilica2, .bit16(65205))
         XCTAssertEqual(BluetoothUUID.wisilica2.name, "WiSilica Inc.")
         XCTAssertNotEqual(BluetoothUUID.wisilica2, .bit32(65205))
         XCTAssertNotEqual(BluetoothUUID.wisilica2, .bit32(0xFEB5))

    }

    /// Test Vencer Co, Ltd
    func testVencerCo() {

         XCTAssertEqual(BluetoothUUID.vencerCo.rawValue, "FEB6")
         XCTAssertEqual(BluetoothUUID.vencerCo, .bit16(0xFEB6))
         XCTAssertEqual(BluetoothUUID.vencerCo, .bit16(65206))
         XCTAssertEqual(BluetoothUUID.vencerCo.name, "Vencer Co, Ltd")
         XCTAssertNotEqual(BluetoothUUID.vencerCo, .bit32(65206))
         XCTAssertNotEqual(BluetoothUUID.vencerCo, .bit32(0xFEB6))

    }

    /// Test Facebook, Inc.
    func testFacebook() {

         XCTAssertEqual(BluetoothUUID.facebook.rawValue, "FEB7")
         XCTAssertEqual(BluetoothUUID.facebook, .bit16(0xFEB7))
         XCTAssertEqual(BluetoothUUID.facebook, .bit16(65207))
         XCTAssertEqual(BluetoothUUID.facebook.name, "Facebook, Inc.")
         XCTAssertNotEqual(BluetoothUUID.facebook, .bit32(65207))
         XCTAssertNotEqual(BluetoothUUID.facebook, .bit32(0xFEB7))

    }

    /// Test Facebook, Inc.
    func testFacebook2() {

         XCTAssertEqual(BluetoothUUID.facebook2.rawValue, "FEB8")
         XCTAssertEqual(BluetoothUUID.facebook2, .bit16(0xFEB8))
         XCTAssertEqual(BluetoothUUID.facebook2, .bit16(65208))
         XCTAssertEqual(BluetoothUUID.facebook2.name, "Facebook, Inc.")
         XCTAssertNotEqual(BluetoothUUID.facebook2, .bit32(65208))
         XCTAssertNotEqual(BluetoothUUID.facebook2, .bit32(0xFEB8))

    }

    /// Test LG Electronics
    func testLgElectronics() {

         XCTAssertEqual(BluetoothUUID.lgElectronics.rawValue, "FEB9")
         XCTAssertEqual(BluetoothUUID.lgElectronics, .bit16(0xFEB9))
         XCTAssertEqual(BluetoothUUID.lgElectronics, .bit16(65209))
         XCTAssertEqual(BluetoothUUID.lgElectronics.name, "LG Electronics")
         XCTAssertNotEqual(BluetoothUUID.lgElectronics, .bit32(65209))
         XCTAssertNotEqual(BluetoothUUID.lgElectronics, .bit32(0xFEB9))

    }

    /// Test Tencent Holdings Limited
    func testTencentHoldingsLimited() {

         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited.rawValue, "FEBA")
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited, .bit16(0xFEBA))
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited, .bit16(65210))
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited.name, "Tencent Holdings Limited")
         XCTAssertNotEqual(BluetoothUUID.tencentHoldingsLimited, .bit32(65210))
         XCTAssertNotEqual(BluetoothUUID.tencentHoldingsLimited, .bit32(0xFEBA))

    }

    /// Test adafruit industries
    func testAdafruitIndustries() {

         XCTAssertEqual(BluetoothUUID.adafruitIndustries.rawValue, "FEBB")
         XCTAssertEqual(BluetoothUUID.adafruitIndustries, .bit16(0xFEBB))
         XCTAssertEqual(BluetoothUUID.adafruitIndustries, .bit16(65211))
         XCTAssertEqual(BluetoothUUID.adafruitIndustries.name, "adafruit industries")
         XCTAssertNotEqual(BluetoothUUID.adafruitIndustries, .bit32(65211))
         XCTAssertNotEqual(BluetoothUUID.adafruitIndustries, .bit32(0xFEBB))

    }

    /// Test Dexcom, Inc.
    func testDexcom() {

         XCTAssertEqual(BluetoothUUID.dexcom.rawValue, "FEBC")
         XCTAssertEqual(BluetoothUUID.dexcom, .bit16(0xFEBC))
         XCTAssertEqual(BluetoothUUID.dexcom, .bit16(65212))
         XCTAssertEqual(BluetoothUUID.dexcom.name, "Dexcom, Inc.")
         XCTAssertNotEqual(BluetoothUUID.dexcom, .bit32(65212))
         XCTAssertNotEqual(BluetoothUUID.dexcom, .bit32(0xFEBC))

    }

    /// Test Clover Network, Inc.
    func testCloverNetwork() {

         XCTAssertEqual(BluetoothUUID.cloverNetwork.rawValue, "FEBD")
         XCTAssertEqual(BluetoothUUID.cloverNetwork, .bit16(0xFEBD))
         XCTAssertEqual(BluetoothUUID.cloverNetwork, .bit16(65213))
         XCTAssertEqual(BluetoothUUID.cloverNetwork.name, "Clover Network, Inc.")
         XCTAssertNotEqual(BluetoothUUID.cloverNetwork, .bit32(65213))
         XCTAssertNotEqual(BluetoothUUID.cloverNetwork, .bit32(0xFEBD))

    }

    /// Test Bose Corporation
    func testBoseCorporation() {

         XCTAssertEqual(BluetoothUUID.boseCorporation.rawValue, "FEBE")
         XCTAssertEqual(BluetoothUUID.boseCorporation, .bit16(0xFEBE))
         XCTAssertEqual(BluetoothUUID.boseCorporation, .bit16(65214))
         XCTAssertEqual(BluetoothUUID.boseCorporation.name, "Bose Corporation")
         XCTAssertNotEqual(BluetoothUUID.boseCorporation, .bit32(65214))
         XCTAssertNotEqual(BluetoothUUID.boseCorporation, .bit32(0xFEBE))

    }

    /// Test Nod, Inc.
    func testNod() {

         XCTAssertEqual(BluetoothUUID.nod.rawValue, "FEBF")
         XCTAssertEqual(BluetoothUUID.nod, .bit16(0xFEBF))
         XCTAssertEqual(BluetoothUUID.nod, .bit16(65215))
         XCTAssertEqual(BluetoothUUID.nod.name, "Nod, Inc.")
         XCTAssertNotEqual(BluetoothUUID.nod, .bit32(65215))
         XCTAssertNotEqual(BluetoothUUID.nod, .bit32(0xFEBF))

    }

    /// Test KDDI Corporation
    func testKddiCorporation() {

         XCTAssertEqual(BluetoothUUID.kddiCorporation.rawValue, "FEC0")
         XCTAssertEqual(BluetoothUUID.kddiCorporation, .bit16(0xFEC0))
         XCTAssertEqual(BluetoothUUID.kddiCorporation, .bit16(65216))
         XCTAssertEqual(BluetoothUUID.kddiCorporation.name, "KDDI Corporation")
         XCTAssertNotEqual(BluetoothUUID.kddiCorporation, .bit32(65216))
         XCTAssertNotEqual(BluetoothUUID.kddiCorporation, .bit32(0xFEC0))

    }

    /// Test KDDI Corporation
    func testKddiCorporation2() {

         XCTAssertEqual(BluetoothUUID.kddiCorporation2.rawValue, "FEC1")
         XCTAssertEqual(BluetoothUUID.kddiCorporation2, .bit16(0xFEC1))
         XCTAssertEqual(BluetoothUUID.kddiCorporation2, .bit16(65217))
         XCTAssertEqual(BluetoothUUID.kddiCorporation2.name, "KDDI Corporation")
         XCTAssertNotEqual(BluetoothUUID.kddiCorporation2, .bit32(65217))
         XCTAssertNotEqual(BluetoothUUID.kddiCorporation2, .bit32(0xFEC1))

    }

    /// Test Blue Spark Technologies, Inc.
    func testBlueSparkTechnologies() {

         XCTAssertEqual(BluetoothUUID.blueSparkTechnologies.rawValue, "FEC2")
         XCTAssertEqual(BluetoothUUID.blueSparkTechnologies, .bit16(0xFEC2))
         XCTAssertEqual(BluetoothUUID.blueSparkTechnologies, .bit16(65218))
         XCTAssertEqual(BluetoothUUID.blueSparkTechnologies.name, "Blue Spark Technologies, Inc.")
         XCTAssertNotEqual(BluetoothUUID.blueSparkTechnologies, .bit32(65218))
         XCTAssertNotEqual(BluetoothUUID.blueSparkTechnologies, .bit32(0xFEC2))

    }

    /// Test 360fly, Inc.
    func testUuid360Fly() {

         XCTAssertEqual(BluetoothUUID.uuid360Fly.rawValue, "FEC3")
         XCTAssertEqual(BluetoothUUID.uuid360Fly, .bit16(0xFEC3))
         XCTAssertEqual(BluetoothUUID.uuid360Fly, .bit16(65219))
         XCTAssertEqual(BluetoothUUID.uuid360Fly.name, "360fly, Inc.")
         XCTAssertNotEqual(BluetoothUUID.uuid360Fly, .bit32(65219))
         XCTAssertNotEqual(BluetoothUUID.uuid360Fly, .bit32(0xFEC3))

    }

    /// Test PLUS Location Systems
    func testPlusLocationSystems() {

         XCTAssertEqual(BluetoothUUID.plusLocationSystems.rawValue, "FEC4")
         XCTAssertEqual(BluetoothUUID.plusLocationSystems, .bit16(0xFEC4))
         XCTAssertEqual(BluetoothUUID.plusLocationSystems, .bit16(65220))
         XCTAssertEqual(BluetoothUUID.plusLocationSystems.name, "PLUS Location Systems")
         XCTAssertNotEqual(BluetoothUUID.plusLocationSystems, .bit32(65220))
         XCTAssertNotEqual(BluetoothUUID.plusLocationSystems, .bit32(0xFEC4))

    }

    /// Test Realtek Semiconductor Corp.
    func testRealtekSemiconductorCorp() {

         XCTAssertEqual(BluetoothUUID.realtekSemiconductorCorp.rawValue, "FEC5")
         XCTAssertEqual(BluetoothUUID.realtekSemiconductorCorp, .bit16(0xFEC5))
         XCTAssertEqual(BluetoothUUID.realtekSemiconductorCorp, .bit16(65221))
         XCTAssertEqual(BluetoothUUID.realtekSemiconductorCorp.name, "Realtek Semiconductor Corp.")
         XCTAssertNotEqual(BluetoothUUID.realtekSemiconductorCorp, .bit32(65221))
         XCTAssertNotEqual(BluetoothUUID.realtekSemiconductorCorp, .bit32(0xFEC5))

    }

    /// Test Kocomojo, LLC
    func testKocomojo() {

         XCTAssertEqual(BluetoothUUID.kocomojo.rawValue, "FEC6")
         XCTAssertEqual(BluetoothUUID.kocomojo, .bit16(0xFEC6))
         XCTAssertEqual(BluetoothUUID.kocomojo, .bit16(65222))
         XCTAssertEqual(BluetoothUUID.kocomojo.name, "Kocomojo, LLC")
         XCTAssertNotEqual(BluetoothUUID.kocomojo, .bit32(65222))
         XCTAssertNotEqual(BluetoothUUID.kocomojo, .bit32(0xFEC6))

    }

    /// Test Apple, Inc.
    func testApple3() {

         XCTAssertEqual(BluetoothUUID.apple3.rawValue, "FEC7")
         XCTAssertEqual(BluetoothUUID.apple3, .bit16(0xFEC7))
         XCTAssertEqual(BluetoothUUID.apple3, .bit16(65223))
         XCTAssertEqual(BluetoothUUID.apple3.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple3, .bit32(65223))
         XCTAssertNotEqual(BluetoothUUID.apple3, .bit32(0xFEC7))

    }

    /// Test Apple, Inc.
    func testApple4() {

         XCTAssertEqual(BluetoothUUID.apple4.rawValue, "FEC8")
         XCTAssertEqual(BluetoothUUID.apple4, .bit16(0xFEC8))
         XCTAssertEqual(BluetoothUUID.apple4, .bit16(65224))
         XCTAssertEqual(BluetoothUUID.apple4.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple4, .bit32(65224))
         XCTAssertNotEqual(BluetoothUUID.apple4, .bit32(0xFEC8))

    }

    /// Test Apple, Inc.
    func testApple5() {

         XCTAssertEqual(BluetoothUUID.apple5.rawValue, "FEC9")
         XCTAssertEqual(BluetoothUUID.apple5, .bit16(0xFEC9))
         XCTAssertEqual(BluetoothUUID.apple5, .bit16(65225))
         XCTAssertEqual(BluetoothUUID.apple5.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple5, .bit32(65225))
         XCTAssertNotEqual(BluetoothUUID.apple5, .bit32(0xFEC9))

    }

    /// Test Apple, Inc.
    func testApple6() {

         XCTAssertEqual(BluetoothUUID.apple6.rawValue, "FECA")
         XCTAssertEqual(BluetoothUUID.apple6, .bit16(0xFECA))
         XCTAssertEqual(BluetoothUUID.apple6, .bit16(65226))
         XCTAssertEqual(BluetoothUUID.apple6.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple6, .bit32(65226))
         XCTAssertNotEqual(BluetoothUUID.apple6, .bit32(0xFECA))

    }

    /// Test Apple, Inc.
    func testApple7() {

         XCTAssertEqual(BluetoothUUID.apple7.rawValue, "FECB")
         XCTAssertEqual(BluetoothUUID.apple7, .bit16(0xFECB))
         XCTAssertEqual(BluetoothUUID.apple7, .bit16(65227))
         XCTAssertEqual(BluetoothUUID.apple7.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple7, .bit32(65227))
         XCTAssertNotEqual(BluetoothUUID.apple7, .bit32(0xFECB))

    }

    /// Test Apple, Inc.
    func testApple8() {

         XCTAssertEqual(BluetoothUUID.apple8.rawValue, "FECC")
         XCTAssertEqual(BluetoothUUID.apple8, .bit16(0xFECC))
         XCTAssertEqual(BluetoothUUID.apple8, .bit16(65228))
         XCTAssertEqual(BluetoothUUID.apple8.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple8, .bit32(65228))
         XCTAssertNotEqual(BluetoothUUID.apple8, .bit32(0xFECC))

    }

    /// Test Apple, Inc.
    func testApple9() {

         XCTAssertEqual(BluetoothUUID.apple9.rawValue, "FECD")
         XCTAssertEqual(BluetoothUUID.apple9, .bit16(0xFECD))
         XCTAssertEqual(BluetoothUUID.apple9, .bit16(65229))
         XCTAssertEqual(BluetoothUUID.apple9.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple9, .bit32(65229))
         XCTAssertNotEqual(BluetoothUUID.apple9, .bit32(0xFECD))

    }

    /// Test Apple, Inc.
    func testApple10() {

         XCTAssertEqual(BluetoothUUID.apple10.rawValue, "FECE")
         XCTAssertEqual(BluetoothUUID.apple10, .bit16(0xFECE))
         XCTAssertEqual(BluetoothUUID.apple10, .bit16(65230))
         XCTAssertEqual(BluetoothUUID.apple10.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple10, .bit32(65230))
         XCTAssertNotEqual(BluetoothUUID.apple10, .bit32(0xFECE))

    }

    /// Test Apple, Inc.
    func testApple11() {

         XCTAssertEqual(BluetoothUUID.apple11.rawValue, "FECF")
         XCTAssertEqual(BluetoothUUID.apple11, .bit16(0xFECF))
         XCTAssertEqual(BluetoothUUID.apple11, .bit16(65231))
         XCTAssertEqual(BluetoothUUID.apple11.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple11, .bit32(65231))
         XCTAssertNotEqual(BluetoothUUID.apple11, .bit32(0xFECF))

    }

    /// Test Apple, Inc.
    func testApple12() {

         XCTAssertEqual(BluetoothUUID.apple12.rawValue, "FED0")
         XCTAssertEqual(BluetoothUUID.apple12, .bit16(0xFED0))
         XCTAssertEqual(BluetoothUUID.apple12, .bit16(65232))
         XCTAssertEqual(BluetoothUUID.apple12.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple12, .bit32(65232))
         XCTAssertNotEqual(BluetoothUUID.apple12, .bit32(0xFED0))

    }

    /// Test Apple, Inc.
    func testApple13() {

         XCTAssertEqual(BluetoothUUID.apple13.rawValue, "FED1")
         XCTAssertEqual(BluetoothUUID.apple13, .bit16(0xFED1))
         XCTAssertEqual(BluetoothUUID.apple13, .bit16(65233))
         XCTAssertEqual(BluetoothUUID.apple13.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple13, .bit32(65233))
         XCTAssertNotEqual(BluetoothUUID.apple13, .bit32(0xFED1))

    }

    /// Test Apple, Inc.
    func testApple14() {

         XCTAssertEqual(BluetoothUUID.apple14.rawValue, "FED2")
         XCTAssertEqual(BluetoothUUID.apple14, .bit16(0xFED2))
         XCTAssertEqual(BluetoothUUID.apple14, .bit16(65234))
         XCTAssertEqual(BluetoothUUID.apple14.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple14, .bit32(65234))
         XCTAssertNotEqual(BluetoothUUID.apple14, .bit32(0xFED2))

    }

    /// Test Apple, Inc.
    func testApple15() {

         XCTAssertEqual(BluetoothUUID.apple15.rawValue, "FED3")
         XCTAssertEqual(BluetoothUUID.apple15, .bit16(0xFED3))
         XCTAssertEqual(BluetoothUUID.apple15, .bit16(65235))
         XCTAssertEqual(BluetoothUUID.apple15.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple15, .bit32(65235))
         XCTAssertNotEqual(BluetoothUUID.apple15, .bit32(0xFED3))

    }

    /// Test Apple, Inc.
    func testApple16() {

         XCTAssertEqual(BluetoothUUID.apple16.rawValue, "FED4")
         XCTAssertEqual(BluetoothUUID.apple16, .bit16(0xFED4))
         XCTAssertEqual(BluetoothUUID.apple16, .bit16(65236))
         XCTAssertEqual(BluetoothUUID.apple16.name, "Apple, Inc.")
         XCTAssertNotEqual(BluetoothUUID.apple16, .bit32(65236))
         XCTAssertNotEqual(BluetoothUUID.apple16, .bit32(0xFED4))

    }

    /// Test Plantronics Inc.
    func testPlantronics() {

         XCTAssertEqual(BluetoothUUID.plantronics.rawValue, "FED5")
         XCTAssertEqual(BluetoothUUID.plantronics, .bit16(0xFED5))
         XCTAssertEqual(BluetoothUUID.plantronics, .bit16(65237))
         XCTAssertEqual(BluetoothUUID.plantronics.name, "Plantronics Inc.")
         XCTAssertNotEqual(BluetoothUUID.plantronics, .bit32(65237))
         XCTAssertNotEqual(BluetoothUUID.plantronics, .bit32(0xFED5))

    }

    /// Test Broadcom Corporation
    func testBroadcomCorporation() {

         XCTAssertEqual(BluetoothUUID.broadcomCorporation.rawValue, "FED6")
         XCTAssertEqual(BluetoothUUID.broadcomCorporation, .bit16(0xFED6))
         XCTAssertEqual(BluetoothUUID.broadcomCorporation, .bit16(65238))
         XCTAssertEqual(BluetoothUUID.broadcomCorporation.name, "Broadcom Corporation")
         XCTAssertNotEqual(BluetoothUUID.broadcomCorporation, .bit32(65238))
         XCTAssertNotEqual(BluetoothUUID.broadcomCorporation, .bit32(0xFED6))

    }

    /// Test Broadcom Corporation
    func testBroadcomCorporation2() {

         XCTAssertEqual(BluetoothUUID.broadcomCorporation2.rawValue, "FED7")
         XCTAssertEqual(BluetoothUUID.broadcomCorporation2, .bit16(0xFED7))
         XCTAssertEqual(BluetoothUUID.broadcomCorporation2, .bit16(65239))
         XCTAssertEqual(BluetoothUUID.broadcomCorporation2.name, "Broadcom Corporation")
         XCTAssertNotEqual(BluetoothUUID.broadcomCorporation2, .bit32(65239))
         XCTAssertNotEqual(BluetoothUUID.broadcomCorporation2, .bit32(0xFED7))

    }

    /// Test Google
    func testGoogle4() {

         XCTAssertEqual(BluetoothUUID.google4.rawValue, "FED8")
         XCTAssertEqual(BluetoothUUID.google4, .bit16(0xFED8))
         XCTAssertEqual(BluetoothUUID.google4, .bit16(65240))
         XCTAssertEqual(BluetoothUUID.google4.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google4, .bit32(65240))
         XCTAssertNotEqual(BluetoothUUID.google4, .bit32(0xFED8))

    }

    /// Test Pebble Technology Corporation
    func testPebbleTechnologyCorporation() {

         XCTAssertEqual(BluetoothUUID.pebbleTechnologyCorporation.rawValue, "FED9")
         XCTAssertEqual(BluetoothUUID.pebbleTechnologyCorporation, .bit16(0xFED9))
         XCTAssertEqual(BluetoothUUID.pebbleTechnologyCorporation, .bit16(65241))
         XCTAssertEqual(BluetoothUUID.pebbleTechnologyCorporation.name, "Pebble Technology Corporation")
         XCTAssertNotEqual(BluetoothUUID.pebbleTechnologyCorporation, .bit32(65241))
         XCTAssertNotEqual(BluetoothUUID.pebbleTechnologyCorporation, .bit32(0xFED9))

    }

    /// Test ISSC Technologies Corporation
    func testIsscTechnologiesCorporation() {

         XCTAssertEqual(BluetoothUUID.isscTechnologiesCorporation.rawValue, "FEDA")
         XCTAssertEqual(BluetoothUUID.isscTechnologiesCorporation, .bit16(0xFEDA))
         XCTAssertEqual(BluetoothUUID.isscTechnologiesCorporation, .bit16(65242))
         XCTAssertEqual(BluetoothUUID.isscTechnologiesCorporation.name, "ISSC Technologies Corporation")
         XCTAssertNotEqual(BluetoothUUID.isscTechnologiesCorporation, .bit32(65242))
         XCTAssertNotEqual(BluetoothUUID.isscTechnologiesCorporation, .bit32(0xFEDA))

    }

    /// Test Perka, Inc.
    func testPerka() {

         XCTAssertEqual(BluetoothUUID.perka.rawValue, "FEDB")
         XCTAssertEqual(BluetoothUUID.perka, .bit16(0xFEDB))
         XCTAssertEqual(BluetoothUUID.perka, .bit16(65243))
         XCTAssertEqual(BluetoothUUID.perka.name, "Perka, Inc.")
         XCTAssertNotEqual(BluetoothUUID.perka, .bit32(65243))
         XCTAssertNotEqual(BluetoothUUID.perka, .bit32(0xFEDB))

    }

    /// Test Jawbone
    func testJawbone() {

         XCTAssertEqual(BluetoothUUID.jawbone.rawValue, "FEDC")
         XCTAssertEqual(BluetoothUUID.jawbone, .bit16(0xFEDC))
         XCTAssertEqual(BluetoothUUID.jawbone, .bit16(65244))
         XCTAssertEqual(BluetoothUUID.jawbone.name, "Jawbone")
         XCTAssertNotEqual(BluetoothUUID.jawbone, .bit32(65244))
         XCTAssertNotEqual(BluetoothUUID.jawbone, .bit32(0xFEDC))

    }

    /// Test Jawbone
    func testJawbone2() {

         XCTAssertEqual(BluetoothUUID.jawbone2.rawValue, "FEDD")
         XCTAssertEqual(BluetoothUUID.jawbone2, .bit16(0xFEDD))
         XCTAssertEqual(BluetoothUUID.jawbone2, .bit16(65245))
         XCTAssertEqual(BluetoothUUID.jawbone2.name, "Jawbone")
         XCTAssertNotEqual(BluetoothUUID.jawbone2, .bit32(65245))
         XCTAssertNotEqual(BluetoothUUID.jawbone2, .bit32(0xFEDD))

    }

    /// Test Coin, Inc.
    func testCoin() {

         XCTAssertEqual(BluetoothUUID.coin.rawValue, "FEDE")
         XCTAssertEqual(BluetoothUUID.coin, .bit16(0xFEDE))
         XCTAssertEqual(BluetoothUUID.coin, .bit16(65246))
         XCTAssertEqual(BluetoothUUID.coin.name, "Coin, Inc.")
         XCTAssertNotEqual(BluetoothUUID.coin, .bit32(65246))
         XCTAssertNotEqual(BluetoothUUID.coin, .bit32(0xFEDE))

    }

    /// Test Design SHIFT
    func testDesignShift() {

         XCTAssertEqual(BluetoothUUID.designShift.rawValue, "FEDF")
         XCTAssertEqual(BluetoothUUID.designShift, .bit16(0xFEDF))
         XCTAssertEqual(BluetoothUUID.designShift, .bit16(65247))
         XCTAssertEqual(BluetoothUUID.designShift.name, "Design SHIFT")
         XCTAssertNotEqual(BluetoothUUID.designShift, .bit32(65247))
         XCTAssertNotEqual(BluetoothUUID.designShift, .bit32(0xFEDF))

    }

    /// Test Anhui Huami Information Technology Co.
    func testAnhuiHuamiInformationTechnologyCo() {

         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo.rawValue, "FEE0")
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo, .bit16(0xFEE0))
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo, .bit16(65248))
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo.name, "Anhui Huami Information Technology Co.")
         XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo, .bit32(65248))
         XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo, .bit32(0xFEE0))

    }

    /// Test Anhui Huami Information Technology Co.
    func testAnhuiHuamiInformationTechnologyCo2() {

         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2.rawValue, "FEE1")
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2, .bit16(0xFEE1))
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2, .bit16(65249))
         XCTAssertEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2.name, "Anhui Huami Information Technology Co.")
         XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2, .bit32(65249))
         XCTAssertNotEqual(BluetoothUUID.anhuiHuamiInformationTechnologyCo2, .bit32(0xFEE1))

    }

    /// Test Anki, Inc.
    func testAnki() {

         XCTAssertEqual(BluetoothUUID.anki.rawValue, "FEE2")
         XCTAssertEqual(BluetoothUUID.anki, .bit16(0xFEE2))
         XCTAssertEqual(BluetoothUUID.anki, .bit16(65250))
         XCTAssertEqual(BluetoothUUID.anki.name, "Anki, Inc.")
         XCTAssertNotEqual(BluetoothUUID.anki, .bit32(65250))
         XCTAssertNotEqual(BluetoothUUID.anki, .bit32(0xFEE2))

    }

    /// Test Anki, Inc.
    func testAnki2() {

         XCTAssertEqual(BluetoothUUID.anki2.rawValue, "FEE3")
         XCTAssertEqual(BluetoothUUID.anki2, .bit16(0xFEE3))
         XCTAssertEqual(BluetoothUUID.anki2, .bit16(65251))
         XCTAssertEqual(BluetoothUUID.anki2.name, "Anki, Inc.")
         XCTAssertNotEqual(BluetoothUUID.anki2, .bit32(65251))
         XCTAssertNotEqual(BluetoothUUID.anki2, .bit32(0xFEE3))

    }

    /// Test Nordic Semiconductor ASA
    func testNordicSemiconductorAsa() {

         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa.rawValue, "FEE4")
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa, .bit16(0xFEE4))
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa, .bit16(65252))
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa.name, "Nordic Semiconductor ASA")
         XCTAssertNotEqual(BluetoothUUID.nordicSemiconductorAsa, .bit32(65252))
         XCTAssertNotEqual(BluetoothUUID.nordicSemiconductorAsa, .bit32(0xFEE4))

    }

    /// Test Nordic Semiconductor ASA
    func testNordicSemiconductorAsa2() {

         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa2.rawValue, "FEE5")
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa2, .bit16(0xFEE5))
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa2, .bit16(65253))
         XCTAssertEqual(BluetoothUUID.nordicSemiconductorAsa2.name, "Nordic Semiconductor ASA")
         XCTAssertNotEqual(BluetoothUUID.nordicSemiconductorAsa2, .bit32(65253))
         XCTAssertNotEqual(BluetoothUUID.nordicSemiconductorAsa2, .bit32(0xFEE5))

    }

    /// Test Seed Labs, Inc.
    func testSeedLabs() {

         XCTAssertEqual(BluetoothUUID.seedLabs.rawValue, "FEE6")
         XCTAssertEqual(BluetoothUUID.seedLabs, .bit16(0xFEE6))
         XCTAssertEqual(BluetoothUUID.seedLabs, .bit16(65254))
         XCTAssertEqual(BluetoothUUID.seedLabs.name, "Seed Labs, Inc.")
         XCTAssertNotEqual(BluetoothUUID.seedLabs, .bit32(65254))
         XCTAssertNotEqual(BluetoothUUID.seedLabs, .bit32(0xFEE6))

    }

    /// Test Tencent Holdings Limited
    func testTencentHoldingsLimited2() {

         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited2.rawValue, "FEE7")
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited2, .bit16(0xFEE7))
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited2, .bit16(65255))
         XCTAssertEqual(BluetoothUUID.tencentHoldingsLimited2.name, "Tencent Holdings Limited")
         XCTAssertNotEqual(BluetoothUUID.tencentHoldingsLimited2, .bit32(65255))
         XCTAssertNotEqual(BluetoothUUID.tencentHoldingsLimited2, .bit32(0xFEE7))

    }

    /// Test Quintic Corp.
    func testQuinticCorp() {

         XCTAssertEqual(BluetoothUUID.quinticCorp.rawValue, "FEE8")
         XCTAssertEqual(BluetoothUUID.quinticCorp, .bit16(0xFEE8))
         XCTAssertEqual(BluetoothUUID.quinticCorp, .bit16(65256))
         XCTAssertEqual(BluetoothUUID.quinticCorp.name, "Quintic Corp.")
         XCTAssertNotEqual(BluetoothUUID.quinticCorp, .bit32(65256))
         XCTAssertNotEqual(BluetoothUUID.quinticCorp, .bit32(0xFEE8))

    }

    /// Test Quintic Corp.
    func testQuinticCorp2() {

         XCTAssertEqual(BluetoothUUID.quinticCorp2.rawValue, "FEE9")
         XCTAssertEqual(BluetoothUUID.quinticCorp2, .bit16(0xFEE9))
         XCTAssertEqual(BluetoothUUID.quinticCorp2, .bit16(65257))
         XCTAssertEqual(BluetoothUUID.quinticCorp2.name, "Quintic Corp.")
         XCTAssertNotEqual(BluetoothUUID.quinticCorp2, .bit32(65257))
         XCTAssertNotEqual(BluetoothUUID.quinticCorp2, .bit32(0xFEE9))

    }

    /// Test Swirl Networks, Inc.
    func testSwirlNetworks() {

         XCTAssertEqual(BluetoothUUID.swirlNetworks.rawValue, "FEEA")
         XCTAssertEqual(BluetoothUUID.swirlNetworks, .bit16(0xFEEA))
         XCTAssertEqual(BluetoothUUID.swirlNetworks, .bit16(65258))
         XCTAssertEqual(BluetoothUUID.swirlNetworks.name, "Swirl Networks, Inc.")
         XCTAssertNotEqual(BluetoothUUID.swirlNetworks, .bit32(65258))
         XCTAssertNotEqual(BluetoothUUID.swirlNetworks, .bit32(0xFEEA))

    }

    /// Test Swirl Networks, Inc.
    func testSwirlNetworks2() {

         XCTAssertEqual(BluetoothUUID.swirlNetworks2.rawValue, "FEEB")
         XCTAssertEqual(BluetoothUUID.swirlNetworks2, .bit16(0xFEEB))
         XCTAssertEqual(BluetoothUUID.swirlNetworks2, .bit16(65259))
         XCTAssertEqual(BluetoothUUID.swirlNetworks2.name, "Swirl Networks, Inc.")
         XCTAssertNotEqual(BluetoothUUID.swirlNetworks2, .bit32(65259))
         XCTAssertNotEqual(BluetoothUUID.swirlNetworks2, .bit32(0xFEEB))

    }

    /// Test Tile, Inc.
    func testTile() {

         XCTAssertEqual(BluetoothUUID.tile.rawValue, "FEEC")
         XCTAssertEqual(BluetoothUUID.tile, .bit16(0xFEEC))
         XCTAssertEqual(BluetoothUUID.tile, .bit16(65260))
         XCTAssertEqual(BluetoothUUID.tile.name, "Tile, Inc.")
         XCTAssertNotEqual(BluetoothUUID.tile, .bit32(65260))
         XCTAssertNotEqual(BluetoothUUID.tile, .bit32(0xFEEC))

    }

    /// Test Tile, Inc.
    func testTile2() {

         XCTAssertEqual(BluetoothUUID.tile2.rawValue, "FEED")
         XCTAssertEqual(BluetoothUUID.tile2, .bit16(0xFEED))
         XCTAssertEqual(BluetoothUUID.tile2, .bit16(65261))
         XCTAssertEqual(BluetoothUUID.tile2.name, "Tile, Inc.")
         XCTAssertNotEqual(BluetoothUUID.tile2, .bit32(65261))
         XCTAssertNotEqual(BluetoothUUID.tile2, .bit32(0xFEED))

    }

    /// Test Polar Electro Oy
    func testPolarElectroOy() {

         XCTAssertEqual(BluetoothUUID.polarElectroOy.rawValue, "FEEE")
         XCTAssertEqual(BluetoothUUID.polarElectroOy, .bit16(0xFEEE))
         XCTAssertEqual(BluetoothUUID.polarElectroOy, .bit16(65262))
         XCTAssertEqual(BluetoothUUID.polarElectroOy.name, "Polar Electro Oy")
         XCTAssertNotEqual(BluetoothUUID.polarElectroOy, .bit32(65262))
         XCTAssertNotEqual(BluetoothUUID.polarElectroOy, .bit32(0xFEEE))

    }

    /// Test Polar Electro Oy
    func testPolarElectroOy2() {

         XCTAssertEqual(BluetoothUUID.polarElectroOy2.rawValue, "FEEF")
         XCTAssertEqual(BluetoothUUID.polarElectroOy2, .bit16(0xFEEF))
         XCTAssertEqual(BluetoothUUID.polarElectroOy2, .bit16(65263))
         XCTAssertEqual(BluetoothUUID.polarElectroOy2.name, "Polar Electro Oy")
         XCTAssertNotEqual(BluetoothUUID.polarElectroOy2, .bit32(65263))
         XCTAssertNotEqual(BluetoothUUID.polarElectroOy2, .bit32(0xFEEF))

    }

    /// Test Intel
    func testIntel() {

         XCTAssertEqual(BluetoothUUID.intel.rawValue, "FEF0")
         XCTAssertEqual(BluetoothUUID.intel, .bit16(0xFEF0))
         XCTAssertEqual(BluetoothUUID.intel, .bit16(65264))
         XCTAssertEqual(BluetoothUUID.intel.name, "Intel")
         XCTAssertNotEqual(BluetoothUUID.intel, .bit32(65264))
         XCTAssertNotEqual(BluetoothUUID.intel, .bit32(0xFEF0))

    }

    /// Test CSR
    func testCsr2() {

         XCTAssertEqual(BluetoothUUID.csr2.rawValue, "FEF1")
         XCTAssertEqual(BluetoothUUID.csr2, .bit16(0xFEF1))
         XCTAssertEqual(BluetoothUUID.csr2, .bit16(65265))
         XCTAssertEqual(BluetoothUUID.csr2.name, "CSR")
         XCTAssertNotEqual(BluetoothUUID.csr2, .bit32(65265))
         XCTAssertNotEqual(BluetoothUUID.csr2, .bit32(0xFEF1))

    }

    /// Test CSR
    func testCsr3() {

         XCTAssertEqual(BluetoothUUID.csr3.rawValue, "FEF2")
         XCTAssertEqual(BluetoothUUID.csr3, .bit16(0xFEF2))
         XCTAssertEqual(BluetoothUUID.csr3, .bit16(65266))
         XCTAssertEqual(BluetoothUUID.csr3.name, "CSR")
         XCTAssertNotEqual(BluetoothUUID.csr3, .bit32(65266))
         XCTAssertNotEqual(BluetoothUUID.csr3, .bit32(0xFEF2))

    }

    /// Test Google
    func testGoogle5() {

         XCTAssertEqual(BluetoothUUID.google5.rawValue, "FEF3")
         XCTAssertEqual(BluetoothUUID.google5, .bit16(0xFEF3))
         XCTAssertEqual(BluetoothUUID.google5, .bit16(65267))
         XCTAssertEqual(BluetoothUUID.google5.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google5, .bit32(65267))
         XCTAssertNotEqual(BluetoothUUID.google5, .bit32(0xFEF3))

    }

    /// Test Google
    func testGoogle6() {

         XCTAssertEqual(BluetoothUUID.google6.rawValue, "FEF4")
         XCTAssertEqual(BluetoothUUID.google6, .bit16(0xFEF4))
         XCTAssertEqual(BluetoothUUID.google6, .bit16(65268))
         XCTAssertEqual(BluetoothUUID.google6.name, "Google")
         XCTAssertNotEqual(BluetoothUUID.google6, .bit32(65268))
         XCTAssertNotEqual(BluetoothUUID.google6, .bit32(0xFEF4))

    }

    /// Test Dialog Semiconductor GmbH
    func testDialogSemiconductorGmbh() {

         XCTAssertEqual(BluetoothUUID.dialogSemiconductorGmbh.rawValue, "FEF5")
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorGmbh, .bit16(0xFEF5))
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorGmbh, .bit16(65269))
         XCTAssertEqual(BluetoothUUID.dialogSemiconductorGmbh.name, "Dialog Semiconductor GmbH")
         XCTAssertNotEqual(BluetoothUUID.dialogSemiconductorGmbh, .bit32(65269))
         XCTAssertNotEqual(BluetoothUUID.dialogSemiconductorGmbh, .bit32(0xFEF5))

    }

    /// Test Wicentric, Inc.
    func testWicentric() {

         XCTAssertEqual(BluetoothUUID.wicentric.rawValue, "FEF6")
         XCTAssertEqual(BluetoothUUID.wicentric, .bit16(0xFEF6))
         XCTAssertEqual(BluetoothUUID.wicentric, .bit16(65270))
         XCTAssertEqual(BluetoothUUID.wicentric.name, "Wicentric, Inc.")
         XCTAssertNotEqual(BluetoothUUID.wicentric, .bit32(65270))
         XCTAssertNotEqual(BluetoothUUID.wicentric, .bit32(0xFEF6))

    }

    /// Test Aplix Corporation
    func testAplixCorporation() {

         XCTAssertEqual(BluetoothUUID.aplixCorporation.rawValue, "FEF7")
         XCTAssertEqual(BluetoothUUID.aplixCorporation, .bit16(0xFEF7))
         XCTAssertEqual(BluetoothUUID.aplixCorporation, .bit16(65271))
         XCTAssertEqual(BluetoothUUID.aplixCorporation.name, "Aplix Corporation")
         XCTAssertNotEqual(BluetoothUUID.aplixCorporation, .bit32(65271))
         XCTAssertNotEqual(BluetoothUUID.aplixCorporation, .bit32(0xFEF7))

    }

    /// Test Aplix Corporation
    func testAplixCorporation2() {

         XCTAssertEqual(BluetoothUUID.aplixCorporation2.rawValue, "FEF8")
         XCTAssertEqual(BluetoothUUID.aplixCorporation2, .bit16(0xFEF8))
         XCTAssertEqual(BluetoothUUID.aplixCorporation2, .bit16(65272))
         XCTAssertEqual(BluetoothUUID.aplixCorporation2.name, "Aplix Corporation")
         XCTAssertNotEqual(BluetoothUUID.aplixCorporation2, .bit32(65272))
         XCTAssertNotEqual(BluetoothUUID.aplixCorporation2, .bit32(0xFEF8))

    }

    /// Test PayPal, Inc.
    func testPaypal() {

         XCTAssertEqual(BluetoothUUID.paypal.rawValue, "FEF9")
         XCTAssertEqual(BluetoothUUID.paypal, .bit16(0xFEF9))
         XCTAssertEqual(BluetoothUUID.paypal, .bit16(65273))
         XCTAssertEqual(BluetoothUUID.paypal.name, "PayPal, Inc.")
         XCTAssertNotEqual(BluetoothUUID.paypal, .bit32(65273))
         XCTAssertNotEqual(BluetoothUUID.paypal, .bit32(0xFEF9))

    }

    /// Test PayPal, Inc.
    func testPaypal2() {

         XCTAssertEqual(BluetoothUUID.paypal2.rawValue, "FEFA")
         XCTAssertEqual(BluetoothUUID.paypal2, .bit16(0xFEFA))
         XCTAssertEqual(BluetoothUUID.paypal2, .bit16(65274))
         XCTAssertEqual(BluetoothUUID.paypal2.name, "PayPal, Inc.")
         XCTAssertNotEqual(BluetoothUUID.paypal2, .bit32(65274))
         XCTAssertNotEqual(BluetoothUUID.paypal2, .bit32(0xFEFA))

    }

    /// Test Stollmann E+V GmbH
    func testStollmannEVGmbh2() {

         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh2.rawValue, "FEFB")
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh2, .bit16(0xFEFB))
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh2, .bit16(65275))
         XCTAssertEqual(BluetoothUUID.stollmannEVGmbh2.name, "Stollmann E+V GmbH")
         XCTAssertNotEqual(BluetoothUUID.stollmannEVGmbh2, .bit32(65275))
         XCTAssertNotEqual(BluetoothUUID.stollmannEVGmbh2, .bit32(0xFEFB))

    }

    /// Test Gimbal, Inc.
    func testGimbal() {

         XCTAssertEqual(BluetoothUUID.gimbal.rawValue, "FEFC")
         XCTAssertEqual(BluetoothUUID.gimbal, .bit16(0xFEFC))
         XCTAssertEqual(BluetoothUUID.gimbal, .bit16(65276))
         XCTAssertEqual(BluetoothUUID.gimbal.name, "Gimbal, Inc.")
         XCTAssertNotEqual(BluetoothUUID.gimbal, .bit32(65276))
         XCTAssertNotEqual(BluetoothUUID.gimbal, .bit32(0xFEFC))

    }

    /// Test Gimbal, Inc.
    func testGimbal2() {

         XCTAssertEqual(BluetoothUUID.gimbal2.rawValue, "FEFD")
         XCTAssertEqual(BluetoothUUID.gimbal2, .bit16(0xFEFD))
         XCTAssertEqual(BluetoothUUID.gimbal2, .bit16(65277))
         XCTAssertEqual(BluetoothUUID.gimbal2.name, "Gimbal, Inc.")
         XCTAssertNotEqual(BluetoothUUID.gimbal2, .bit32(65277))
         XCTAssertNotEqual(BluetoothUUID.gimbal2, .bit32(0xFEFD))

    }

    /// Test GN ReSound A/S
    func testGnResoundAS() {

         XCTAssertEqual(BluetoothUUID.gnResoundAS.rawValue, "FEFE")
         XCTAssertEqual(BluetoothUUID.gnResoundAS, .bit16(0xFEFE))
         XCTAssertEqual(BluetoothUUID.gnResoundAS, .bit16(65278))
         XCTAssertEqual(BluetoothUUID.gnResoundAS.name, "GN ReSound A/S")
         XCTAssertNotEqual(BluetoothUUID.gnResoundAS, .bit32(65278))
         XCTAssertNotEqual(BluetoothUUID.gnResoundAS, .bit32(0xFEFE))

    }

    /// Test GN Netcom
    func testGnNetcom() {

         XCTAssertEqual(BluetoothUUID.gnNetcom.rawValue, "FEFF")
         XCTAssertEqual(BluetoothUUID.gnNetcom, .bit16(0xFEFF))
         XCTAssertEqual(BluetoothUUID.gnNetcom, .bit16(65279))
         XCTAssertEqual(BluetoothUUID.gnNetcom.name, "GN Netcom")
         XCTAssertNotEqual(BluetoothUUID.gnNetcom, .bit32(65279))
         XCTAssertNotEqual(BluetoothUUID.gnNetcom, .bit32(0xFEFF))

    }

    /// Test Fast IDentity Online Alliance (FIDO)
    func testFastIdentityOnlineAllianceFido() {

         XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido.rawValue, "FFFD")
         XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit16(0xFFFD))
         XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit16(65533))
         XCTAssertEqual(BluetoothUUID.fastIdentityOnlineAllianceFido.name, "Fast IDentity Online Alliance (FIDO)")
         XCTAssertNotEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit32(65533))
         XCTAssertNotEqual(BluetoothUUID.fastIdentityOnlineAllianceFido, .bit32(0xFFFD))

    }

    /// Test Alliance for Wireless Power (A4WP)
    func testAllianceForWirelessPowerA4Wp() {

         XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp.rawValue, "FFFE")
         XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit16(0xFFFE))
         XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit16(65534))
         XCTAssertEqual(BluetoothUUID.allianceForWirelessPowerA4Wp.name, "Alliance for Wireless Power (A4WP)")
         XCTAssertNotEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit32(65534))
         XCTAssertNotEqual(BluetoothUUID.allianceForWirelessPowerA4Wp, .bit32(0xFFFE))

    }

}
