# Perfect-Authentication

[![Perfect logo](http://www.perfect.org/github/Perfect_GH_header_854.jpg)](http://perfect.org/get-involved.html)

[![Perfect logo](http://www.perfect.org/github/Perfect_GH_button_1_Star.jpg)](https://github.com/PerfectlySoft/Perfect)
[![Perfect logo](http://www.perfect.org/github/Perfect_GH_button_2_Git.jpg)](https://gitter.im/PerfectlySoft/Perfect)
[![Perfect logo](http://www.perfect.org/github/Perfect_GH_button_3_twit.jpg)](https://twitter.com/perfectlysoft)
[![Perfect logo](http://www.perfect.org/github/Perfect_GH_button_4_slack.jpg)](http://perfect.ly)


[![Swift 3.0](https://img.shields.io/badge/Swift-3.0-orange.svg?style=flat)](https://developer.apple.com/swift/)
[![Platforms OS X | Linux](https://img.shields.io/badge/Platforms-OS%20X%20%7C%20Linux%20-lightgray.svg?style=flat)](https://developer.apple.com/swift/)
[![License Apache](https://img.shields.io/badge/License-Apache-lightgrey.svg?style=flat)](http://perfect.org/licensing.html)
[![Twitter](https://img.shields.io/badge/Twitter-@PerfectlySoft-blue.svg?style=flat)](http://twitter.com/PerfectlySoft)
[![Join the chat at https://gitter.im/PerfectlySoft/Perfect](https://img.shields.io/badge/Gitter-Join%20Chat-brightgreen.svg)](https://gitter.im/PerfectlySoft/Perfect?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![Slack Status](http://perfect.ly/badge.svg)](http://perfect.ly) [![GitHub version](https://badge.fury.io/gh/PerfectlySoft%2FPerfect-CURL.svg)](https://badge.fury.io/gh/PerfectlySoft%2FPerfect-CURL)

## OAuth2 Library for Perfect


This project provides [OAuth2](https://oauth.net/2/) libraries and select OAuth2 provider drivers - Facebook, Google, GitHub.

Full documentation can be found at [http://www.perfect.org/docs/OAuth2.html](http://www.perfect.org/docs/OAuth2.html)

A demo application can be found at [https://github.com/PerfectExamples/Perfect-Authentication-Demo](https://github.com/PerfectExamples/Perfect-Authentication-Demo) that shows the usage of the system.

This package builds with Swift Package Manager and is part of the [Perfect](https://github.com/PerfectlySoft/Perfect) project. It was written to be stand-alone and so does not require PerfectLib or any other components.

Ensure you have installed and activated the latest Swift 3.0 tool chain.

## Adding to your project

Add this project as a dependency in your Package.swift file.

``` swift
.Package(url: "https://github.com/PerfectlySoft/Perfect-Authentication.git", majorVersion: 1)
```

To then use the OAuth2 module in your code:

``` swift
import OAuth2
```

## Configuration

Each provider needs an "appid", also known as a "key", and a "secret". These are usually generated by the OAuth Host, such as Facebook, GitHub and Google developer consoles. These values, as well as an "endpointAfterAuth" and "redirectAfterAuth" value must be set for each provider you wish to use. 

To configure Facebook as a provider:

``` swift
FacebookConfig.appid = "yourAppID"
FacebookConfig.secret = "yourSecret"
FacebookConfig.endpointAfterAuth = "http://localhost:8181/auth/response/facebook"
FacebookConfig.redirectAfterAuth = "http://localhost:8181/"
```

To configure Google as a provider:

``` swift
GoogleConfig.appid = "yourAppID"
GoogleConfig.secret = "yourSecret"
GoogleConfig.endpointAfterAuth = "http://localhost:8181/auth/response/google"
GoogleConfig.redirectAfterAuth = "http://localhost:8181/"
```

To configure GitHub as a provider:

``` swift
GitHubConfig.appid = "yourAppID"
GitHubConfig.secret = "yourSecret"
GitHubConfig.endpointAfterAuth = "http://localhost:8181/auth/response/github"
GitHubConfig.redirectAfterAuth = "http://localhost:8181/"
```

## Adding Routes

The OAuth2 system relies on an authentication / exchange system, which requires a URL to be specially assembled that the user is redirected to, and a URL that the user is returned to after the user has committed the authorization action.

The first set of routes below are the action URL's that will redirect to the OAuth2 provider's system. They can be anything you wish them to be. The user will never see anything on them as they will be immediately redirected to the correct place.

The second set of routes below are where the OAuth2 provider should return the user to. Note that this is the same as the "endpointAfterAuth" configuration option. Once the "authResponse" function has been completed the user is automatically forwarded to the URL in the "redirectAfterAuth" option.

``` swift
var routes: [[String: Any]] = [[String: Any]]()

routes.append(["method":"get", "uri":"/to/facebook", "handler":Facebook.sendToProvider])
routes.append(["method":"get", "uri":"/to/github", "handler":GitHub.sendToProvider])
routes.append(["method":"get", "uri":"/to/google", "handler":Google.sendToProvider])

routes.append(["method":"get", "uri":"/auth/response/facebook", "handler":Facebook.authResponse])
routes.append(["method":"get", "uri":"/auth/response/github", "handler":GitHub.authResponse])
routes.append(["method":"get", "uri":"/auth/response/google", "handler":Google.authResponse])
```

## Information returned and made available

After the user has been authenticated, certain information is gleaned from the OAuth2 provider.

Note that the session ID can be retrieved using:

``` swift
request.session?.token
```

The user-specific information can be accessed as part of the session info:

``` swift
// The UserID as defined by the provider
request.session?.userid

// designates the OAuth2 source - useful if you are allowing multiple OAuth providers
request.session?.data["loginType"]

// The access token obtained in the process
request.session?.data["accessToken"]

// The user's first name as supplied by the provider
request.session?.data["firstName"]

// The user's last name as supplied by the provider
request.session?.data["lastName"]

// The user's profile picture as supplied by the provider
request.session?.data["picture"]

```

With access to this information, you can now save to the database of your choice.


## Issues

We are transitioning to using JIRA for all bugs and support related issues, therefore the GitHub issues has been disabled.

If you find a mistake, bug, or any other helpful suggestion you'd like to make on the docs please head over to [http://jira.perfect.org:8080/servicedesk/customer/portal/1](http://jira.perfect.org:8080/servicedesk/customer/portal/1) and raise it.

A comprehensive list of open issues can be found at [http://jira.perfect.org:8080/projects/ISS/issues](http://jira.perfect.org:8080/projects/ISS/issues)


## Further Information
For more information on the Perfect project, please visit [perfect.org](http://perfect.org).
