'    WinFBE - Programmer's Code Editor for the FreeBASIC Compiler
'    Copyright (C) 2016-2025 Paul Squires, PlanetSquires Software
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT any WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

''  Scintilla source code edit control v. 3.0.3
''  @file Scintilla.h
''  Interface to the edit control.
'' 
''  Copyright 1998-2003 by Neil Hodgson <neilh@scintilla.org>
''  The License.txt file describes the conditions under which this software may be distributed.

''  THIS FILE CONTAINS ALL OF THE SCINTILLA INTERFACE CONSTANTS AND STRUCTURES
''  Scintilla.h
''  SciLexer.h
''  Lexilla.h


#Pragma Once

#Include Once "Windows.bi"

#Define SCLEX_VB                                   8      ' // Visual Basic lexer
#Define SCE_B_DEFAULT                              0
#Define SCE_B_COMMENT                              1
#Define SCE_B_NUMBER                               2
#Define SCE_B_KEYWORD                              3
#Define SCE_B_STRING                               4
#Define SCE_B_PREPROCESSOR                         5
#Define SCE_B_OPERATOR                             6
#Define SCE_B_IDENTIFIER                           7
#Define SCE_B_DATE                                 8
#Define SCE_B_STRINGEOL                            9
#Define SCE_B_KEYWORD2                             10
#Define SCE_B_KEYWORD3                             11
#Define SCE_B_KEYWORD4                             12
#Define SCE_B_CONSTANT                             13
#Define SCE_B_ASM                                  14
#Define SCE_B_LABEL                                15
#Define SCE_B_ERROR                                16
#Define SCE_B_HEXNUMBER                            17
#Define SCE_B_BINNUMBER                            18
#Define SCE_B_MULTILINECOMMENT                     19

'// Define the default Lexilla shared library name for each platform
#define LEXILLA_LIB "lexilla"
#define LEXILLA_EXTENSION ".dll"

'// On Win32 use the stdcall calling convention otherwise use the standard calling convention
#define LEXILLA_CALL __stdcall

'// MSVC __declspec(deprecated) has different positioning rules to GCC so define to nothing
#define DEPRECATE_DEFINITION

type ILexer5 as any
type LexerFactoryFunction as function cdecl() as ILexer5 ptr

type GetLexerCountFn as function() as long
type GetLexerNameFn as sub(byval Index as ulong, byval name as zstring ptr, byval buflength as long)
type GetLexerFactoryFn as function(byval Index as ulong) as LexerFactoryFunction
type CreateLexerFn as function (byval name as const zstring ptr) as ILexer5 ptr
type LexerNameFromIDFn as function(byval identifier as long) as const zstring ptr
type GetLibraryPropertyNamesFn as function() as const zstring ptr
type SetLibraryPropertyFn as sub(byval key as const zstring ptr, byval value as const zstring ptr)
type GetNameSpaceFn as function() as const zstring ptr

#define LEXILLA_NAMESPACE_SEPARATOR asc('.')

#define LEXILLA_GETLEXERCOUNT "GetLexerCount"
#define LEXILLA_GETLEXERNAME "GetLexerName"
#define LEXILLA_GETLEXERFACTORY "GetLexerFactory"
#define LEXILLA_CREATELEXER "CreateLexer"
#define LEXILLA_LEXERNAMEFROMID "LexerNameFromID"
#define LEXILLA_GETLIBRARYPROPERTYNAMES "GetLibraryPropertyNames"
#define LEXILLA_SETLIBRARYPROPERTY "SetLibraryProperty"
#define LEXILLA_GETNAMESPACE "GetNameSpace"

' ========================================================================================
' Declaration of the only function exported by SciLexer.dll.
' All the comunication with the control is done sending messages.
' Note: Since no function is provided to register the classes, the only way is to load the
' library with LoadLibrary (the attach process automatically register the classes) and free
' it with FreeLibrary (the detach process unregisters the classes).
' ========================================================================================
Type Scintilla_DirectFunction As _
      Function CDECL(   ByVal As Any Ptr, _
                        ByVal As UINT, _
                        ByVal As WPARAM, _
                        ByVal As LPARAM  ) As LRESULT

Dim Shared SciMsg As Scintilla_DirectFunction
'Dim pSci As Any Ptr 
'
'SciMsg = Cast( Scintilla_DirectFunction, SendMessage( HWnd, SCI_GETDIRECTFUNCTION, 0, 0 ) )
'pSci = SendMessage( HWnd, SCI_GETDIRECTPOINTER, 0, 0 ) 
'  
'canundo = SciMsg( pSci, SCI_CANUNDO, 0, 0)


'' ++Autogenerated -- start of section automatically generated from Scintilla.iface
#Define SCI_TARGETWHOLEDOCUMENT                         2690

#Define INVALID_POSITION                                -1
#Define SCI_START                                       2000
#Define SCI_OPTIONAL_START                              3000
#Define SCI_LEXER_START                                 4000
#define SCI_SETILEXER                                   4033
#Define SCI_ADDTEXT                                     2001
#Define SCI_ADDSTYLEDTEXT                               2002
#Define SCI_INSERTTEXT                                  2003
#Define SCI_CLEARALL                                    2004
#Define SCI_DELETERANGE                                 2645
#Define SCI_CLEARDOCUMENTSTYLE                          2005
#Define SCI_GETLENGTH                                   2006
#Define SCI_GETCHARAT                                   2007
#Define SCI_GETCURRENTPOS                               2008
#Define SCI_GETANCHOR                                   2009
#Define SCI_GETSTYLEAT                                  2010
#Define SCI_REDO                                        2011
#Define SCI_SETUNDOCOLLECTION                           2012
#Define SCI_SELECTALL                                   2013
#Define SCI_SETSAVEPOINT                                2014
#Define SCI_GETSTYLEDTEXT                               2015
#Define SCI_CANREDO                                     2016
#Define SCI_MARKERLINEFROMHANDLE                        2017
#Define SCI_MARKERDELETEHANDLE                          2018
#Define SCI_GETUNDOCOLLECTION                           2019
#Define SCWS_INVISIBLE                                  0
#Define SCWS_VISIBLEALWAYS                              1
#Define SCWS_VISIBLEAFTERINDENT                         2
#Define SCI_GETVIEWWS                                   2020
#Define SCI_SETVIEWWS                                   2021
#Define SCI_POSITIONFROMPOINT                           2022
#Define SCI_POSITIONFROMPOINTCLOSE                      2023
#Define SCI_GOTOLINE                                    2024
#Define SCI_GOTOPOS                                     2025
#Define SCI_SETANCHOR                                   2026
#Define SCI_GETCURLINE                                  2027
#Define SCI_GETENDSTYLED                                2028
#Define SC_EOL_CRLF                                     0
#Define SC_EOL_CR                                       1
#Define SC_EOL_LF                                       2
#Define SCI_CONVERTEOLS                                 2029
#Define SCI_GETEOLMODE                                  2030
#Define SCI_SETEOLMODE                                  2031
#Define SCI_STARTSTYLING                                2032
#Define SCI_SETSTYLING                                  2033
#Define SCI_GETBUFFEREDDRAW                             2034
#Define SCI_SETBUFFEREDDRAW                             2035
#Define SCI_SETTABWIDTH                                 2036
#Define SCI_GETTABWIDTH                                 2121
#Define SC_CP_UTF8                                      65001
#Define SCI_SETCODEPAGE                                 2037
#Define MARKER_MAX                                      31
#Define SC_MARK_CIRCLE                                  0
#Define SC_MARK_ROUNDRECT                               1
#Define SC_MARK_ARROW                                   2
#Define SC_MARK_SMALLRECT                               3
#Define SC_MARK_SHORTARROW                              4
#Define SC_MARK_EMPTY                                   5
#Define SC_MARK_ARROWDOWN                               6
#Define SC_MARK_MINUS                                   7
#Define SC_MARK_PLUS                                    8
#Define SC_MARK_VLINE                                   9
#Define SC_MARK_LCORNER                                 10
#Define SC_MARK_TCORNER                                 11
#Define SC_MARK_BOXPLUS                                 12
#Define SC_MARK_BOXPLUSCONNECTED                        13
#Define SC_MARK_BOXMINUS                                14
#Define SC_MARK_BOXMINUSCONNECTED                       15
#Define SC_MARK_LCORNERCURVE                            16
#Define SC_MARK_TCORNERCURVE                            17
#Define SC_MARK_CIRCLEPLUS                              18
#Define SC_MARK_CIRCLEPLUSCONNECTED                     19
#Define SC_MARK_CIRCLEMINUS                             20
#Define SC_MARK_CIRCLEMINUSCONNECTED                    21
#Define SC_MARK_BACKGROUND                              22
#Define SC_MARK_DOTDOTDOT                               23
#Define SC_MARK_ARROWS                                  24
#Define SC_MARK_PIXMAP                                  25
#Define SC_MARK_FULLRECT                                26
#Define SC_MARK_LEFTRECT                                27
#Define SC_MARK_AVAILABLE                               28
#Define SC_MARK_UNDERLINE                               29
#Define SC_MARK_RGBAIMAGE                               30
#define SC_MARK_BOOKMARK                                31
#define SC_MARK_VERTICALBOOKMARK                        32
#Define SC_MARK_CHARACTER                               10000
#Define SC_MARKNUM_FOLDEREND                            25
#Define SC_MARKNUM_FOLDEROPENMID                        26
#Define SC_MARKNUM_FOLDERMIDTAIL                        27
#Define SC_MARKNUM_FOLDERTAIL                           28
#Define SC_MARKNUM_FOLDERSUB                            29
#Define SC_MARKNUM_FOLDER                               30
#Define SC_MARKNUM_FOLDEROPEN                           31
#Define SC_MASK_FOLDERS                                 &HFE000000
#Define SCI_MARKERDEFINE                                2040
#Define SCI_MARKERSETFORE                               2041
#Define SCI_MARKERSETBACK                               2042
#Define SCI_MARKERSETBACKSELECTED                       2292
#Define SCI_MARKERENABLEHIGHLIGHT                       2293
#Define SCI_MARKERADD                                   2043
#Define SCI_MARKERDELETE                                2044
#Define SCI_MARKERDELETEALL                             2045
#Define SCI_MARKERGET                                   2046
#Define SCI_MARKERNEXT                                  2047
#Define SCI_MARKERPREVIOUS                              2048
#Define SCI_MARKERDEFINEPIXMAP                          2049
#Define SCI_MARKERADDSET                                2466
#Define SCI_MARKERSETALPHA                              2476
#Define SC_MAX_MARGIN                                   4
#Define SC_MARGIN_SYMBOL                                0
#Define SC_MARGIN_NUMBER                                1
#Define SC_MARGIN_BACK                                  2
#Define SC_MARGIN_FORE                                  3
#Define SC_MARGIN_TEXT                                  4
#Define SC_MARGIN_RTEXT                                 5
#Define SCI_SETMARGINTYPEN                              2240
#Define SCI_GETMARGINTYPEN                              2241
#Define SCI_SETMARGINWIDTHN                             2242
#Define SCI_GETMARGINWIDTHN                             2243
#Define SCI_SETMARGINMASKN                              2244
#Define SCI_GETMARGINMASKN                              2245
#Define SCI_SETMARGINSENSITIVEN                         2246
#Define SCI_GETMARGINSENSITIVEN                         2247
#Define SCI_SETMARGINCURSORN                            2248
#Define SCI_GETMARGINCURSORN                            2249
#Define STYLE_AUTOCOMPLETE                              255      ' Added by Paul / WinFBE
#define STYLE_DEFAULT                                   32
#Define STYLE_LINENUMBER                                33
#Define STYLE_BRACELIGHT                                34
#Define STYLE_BRACEBAD                                  35
#Define STYLE_CONTROLCHAR                               36
#Define STYLE_INDENTGUIDE                               37
#Define STYLE_CALLTIP                                   38
#Define STYLE_FOLDDISPLAYTEXT                           39
#Define STYLE_LASTPREDEFINED                            39
#Define STYLE_MAX                                       255
#Define SC_CHARSET_ANSI                                 0
#Define SC_CHARSET_DEFAULT                              1
#Define SC_CHARSET_BALTIC                               186
#Define SC_CHARSET_CHINESEBIG5                          136
#Define SC_CHARSET_EASTEUROPE                           238
#Define SC_CHARSET_GB2312                               134
#Define SC_CHARSET_GREEK                                161
#Define SC_CHARSET_HANGUL                               129
#Define SC_CHARSET_MAC                                  77
#Define SC_CHARSET_OEM                                  255
#Define SC_CHARSET_RUSSIAN                              204
#Define SC_CHARSET_CYRILLIC                             1251
#Define SC_CHARSET_SHIFTJIS                             128
#Define SC_CHARSET_SYMBOL                               2
#Define SC_CHARSET_TURKISH                              162
#Define SC_CHARSET_JOHAB                                130
#Define SC_CHARSET_HEBREW                               177
#Define SC_CHARSET_ARABIC                               178
#Define SC_CHARSET_VIETNAMESE                           163
#Define SC_CHARSET_THAI                                 222
#Define SC_CHARSET_8859_15                              1000
#Define SCI_STYLECLEARALL                               2050
#Define SCI_STYLESETFORE                                2051
#Define SCI_STYLESETBACK                                2052
#Define SCI_STYLESETBOLD                                2053
#Define SCI_STYLESETITALIC                              2054
#Define SCI_STYLESETSIZE                                2055
#Define SCI_STYLESETFONT                                2056
#Define SCI_STYLESETEOLFILLED                           2057
#Define SCI_STYLERESETDEFAULT                           2058
#Define SCI_STYLESETUNDERLINE                           2059
#Define SC_CASE_MIXED                                   0
#Define SC_CASE_UPPER                                   1
#Define SC_CASE_LOWER                                   2
#Define SC_CASE_CAMEL                                   3
#Define SCI_STYLEGETFORE                                2481
#Define SCI_STYLEGETBACK                                2482
#Define SCI_STYLEGETBOLD                                2483
#Define SCI_STYLEGETITALIC                              2484
#Define SCI_STYLEGETSIZE                                2485
#Define SCI_STYLEGETFONT                                2486
#Define SCI_STYLEGETEOLFILLED                           2487
#Define SCI_STYLEGETUNDERLINE                           2488
#Define SCI_STYLEGETCASE                                2489
#Define SCI_STYLEGETCHARACTERSET                        2490
#Define SCI_STYLEGETVISIBLE                             2491
#Define SCI_STYLEGETCHANGEABLE                          2492
#Define SCI_STYLEGETHOTSPOT                             2493
#Define SCI_STYLESETCASE                                2060
#Define SC_FONT_SIZE_MULTIPLIER                         100
#Define SCI_STYLESETSIZEFRACTIONAL                      2061
#Define SCI_STYLEGETSIZEFRACTIONAL                      2062
#Define SC_WEIGHT_NORMAL                                400
#Define SC_WEIGHT_SEMIBOLD                              600
#Define SC_WEIGHT_BOLD                                  700
#Define SCI_STYLESETWEIGHT                              2063
#Define SCI_STYLEGETWEIGHT                              2064
#Define SCI_STYLESETCHARACTERSET                        2066
#Define SCI_STYLESETHOTSPOT                             2409
#Define SCI_SETSELFORE                                  2067
#Define SCI_SETSELBACK                                  2068
#Define SCI_GETSELALPHA                                 2477
#Define SCI_SETSELALPHA                                 2478
#Define SCI_GETSELEOLFILLED                             2479
#Define SCI_SETSELEOLFILLED                             2480
#Define SCI_SETCARETFORE                                2069
#Define SCI_ASSIGNCMDKEY                                2070
#Define SCI_CLEARCMDKEY                                 2071
#Define SCI_CLEARALLCMDKEYS                             2072
#Define SCI_SETSTYLINGEX                                2073
#Define SCI_STYLESETVISIBLE                             2074
#Define SCI_GETCARETPERIOD                              2075
#Define SCI_SETCARETPERIOD                              2076
#Define SCI_SETWORDCHARS                                2077
#Define SCI_GETWORDCHARS                                2646
#Define SCI_BEGINUNDOACTION                             2078
#Define SCI_ENDUNDOACTION                               2079
#Define INDIC_PLAIN                                     0
#Define INDIC_SQUIGGLE                                  1
#Define INDIC_TT                                        2
#Define INDIC_DIAGONAL                                  3
#Define INDIC_STRIKE                                    4
#Define INDIC_HIDDEN                                    5
#Define INDIC_BOX                                       6
#Define INDIC_ROUNDBOX                                  7
#Define INDIC_STRAIGHTBOX                               8
#Define INDIC_DASH                                      9
#Define INDIC_DOTS                                      10
#Define INDIC_SQUIGGLELOW                               11
#Define INDIC_DOTBOX                                    12
#Define INDIC_SQUIGGLEPIXMAP                            13
#Define INDIC_COMPOSITIONTHICK                          14
#define INDIC_COMPOSITIONTHIN                           15
#define INDIC_FULLBOX                                   16
#define INDIC_TEXTFORE                                  17
#define INDIC_POINT                                     18
#define INDIC_POINTCHARACTER                            19
#define INDIC_GRADIENT                                  20
#define INDIC_GRADIENTCENTRE                            21
#Define INDIC_MAX                                       31
#Define INDIC_CONTAINER                                 8
#Define INDIC0_MASK                                     &H20
#Define INDIC1_MASK                                     &H40
#Define INDIC2_MASK                                     &H80
#Define INDICS_MASK                                     &HE0
#Define SCI_INDICSETSTYLE                               2080
#Define SCI_INDICGETSTYLE                               2081
#Define SCI_INDICSETFORE                                2082
#Define SCI_INDICGETFORE                                2083
#Define SCI_INDICSETUNDER                               2510
#Define SCI_INDICGETUNDER                               2511
#Define SCI_SETWHITESPACEFORE                           2084
#Define SCI_SETWHITESPACEBACK                           2085
#Define SCI_SETWHITESPACESIZE                           2086
#Define SCI_GETWHITESPACESIZE                           2087
#Define SCI_SETSTYLEBITS                                2090
#Define SCI_GETSTYLEBITS                                2091
#Define SCI_SETLINESTATE                                2092
#Define SCI_GETLINESTATE                                2093
#Define SCI_GETMAXLINESTATE                             2094
#Define SCI_GETCARETLINEVISIBLE                         2095
#Define SCI_SETCARETLINEVISIBLE                         2096
#Define SCI_GETCARETLINEBACK                            2097
#Define SCI_SETCARETLINEBACK                            2098
#Define SCI_STYLESETCHANGEABLE                          2099
#define SCN_AUTOCSELECTIONCHANGE                        2032
#Define SCI_AUTOCSHOW                                   2100
#Define SCI_AUTOCCANCEL                                 2101
#Define SCI_AUTOCACTIVE                                 2102
#Define SCI_AUTOCPOSSTART                               2103
#Define SCI_AUTOCCOMPLETE                               2104
#Define SCI_AUTOCSTOPS                                  2105
#Define SCI_AUTOCSETSEPARATOR                           2106
#Define SCI_AUTOCGETSEPARATOR                           2107
#Define SCI_AUTOCSELECT                                 2108
#Define SCI_AUTOCSETCANCELATSTART                       2110
#Define SCI_AUTOCGETCANCELATSTART                       2111
#Define SCI_AUTOCSETFILLUPS                             2112
#Define SCI_AUTOCSETCHOOSESINGLE                        2113
#Define SCI_AUTOCGETCHOOSESINGLE                        2114
#Define SCI_AUTOCSETIGNORECASE                          2115
#Define SCI_AUTOCGETIGNORECASE                          2116
#Define SCI_USERLISTSHOW                                2117
#Define SCI_AUTOCSETAUTOHIDE                            2118
#Define SCI_AUTOCGETAUTOHIDE                            2119
#Define SCI_AUTOCSETDROPRESTOFWORD                      2270
#Define SCI_AUTOCGETDROPRESTOFWORD                      2271
#Define SCI_REGISTERIMAGE                               2405
#Define SCI_CLEARREGISTEREDIMAGES                       2408
#Define SCI_AUTOCGETTYPESEPARATOR                       2285
#Define SCI_AUTOCSETTYPESEPARATOR                       2286
#Define SCI_AUTOCSETMAXWIDTH                            2208
#Define SCI_AUTOCGETMAXWIDTH                            2209
#Define SCI_AUTOCSETMAXHEIGHT                           2210
#Define SCI_AUTOCGETMAXHEIGHT                           2211
#Define SCI_SETINDENT                                   2122
#Define SCI_GETINDENT                                   2123
#Define SCI_SETUSETABS                                  2124
#Define SCI_GETUSETABS                                  2125
#Define SCI_SETLINEINDENTATION                          2126
#Define SCI_GETLINEINDENTATION                          2127
#Define SCI_GETLINEINDENTPOSITION                       2128
#Define SCI_GETCOLUMN                                   2129
#Define SCI_COUNTCHARACTERS                             2633
#Define SCI_SETHSCROLLBAR                               2130
#Define SCI_GETHSCROLLBAR                               2131
#Define SC_IV_NONE                                      0
#Define SC_IV_REAL                                      1
#Define SC_IV_LOOKFORWARD                               2
#Define SC_IV_LOOKBOTH                                  3
#Define SCI_SETINDENTATIONGUIDES                        2132
#Define SCI_GETINDENTATIONGUIDES                        2133
#Define SCI_SETHIGHLIGHTGUIDE                           2134
#Define SCI_GETHIGHLIGHTGUIDE                           2135
#Define SCI_GETLINEENDPOSITION                          2136
#Define SCI_GETCODEPAGE                                 2137
#Define SCI_GETCARETFORE                                2138
#Define SCI_GETREADONLY                                 2140
#Define SCI_SETCURRENTPOS                               2141
#Define SCI_SETSELECTIONSTART                           2142
#Define SCI_GETSELECTIONSTART                           2143
#Define SCI_SETSELECTIONEND                             2144
#Define SCI_GETSELECTIONEND                             2145
#Define SCI_SETEMPTYSELECTION                           2556
#Define SCI_SETPRINTMAGNIFICATION                       2146
#Define SCI_GETPRINTMAGNIFICATION                       2147
#Define SC_PRINT_NORMAL                                 0
#Define SC_PRINT_INVERTLIGHT                            1
#Define SC_PRINT_BLACKONWHITE                           2
#Define SC_PRINT_COLOURONWHITE                          3
#Define SC_PRINT_COLOURONWHITEDEFAULTBG                 4
#Define SCI_SETPRINTCOLOURMODE                          2148
#Define SCI_GETPRINTCOLOURMODE                          2149
#Define SCFIND_WHOLEWORD                                2
#Define SCFIND_MATCHCASE                                4
#Define SCFIND_WORDSTART                                &H00100000
#Define SCFIND_REGEXP                                   &H00200000
#Define SCFIND_POSIX                                    &H00400000
#Define SCI_FINDTEXT                                    2150
#Define SCI_FORMATRANGE                                 2151
#Define SCI_GETFIRSTVISIBLELINE                         2152
#Define SCI_GETLINE                                     2153
#Define SCI_GETLINECOUNT                                2154
#Define SCI_SETMARGINLEFT                               2155
#Define SCI_GETMARGINLEFT                               2156
#Define SCI_SETMARGINRIGHT                              2157
#Define SCI_GETMARGINRIGHT                              2158
#Define SCI_GETMODIFY                                   2159
#Define SCI_SETSEL                                      2160
#Define SCI_GETSELTEXT                                  2161
#Define SCI_GETTEXTRANGE                                2162
#Define SCI_HIDESELECTION                               2163
#Define SCI_POINTXFROMPOSITION                          2164
#Define SCI_POINTYFROMPOSITION                          2165
#Define SCI_LINEFROMPOSITION                            2166
#Define SCI_POSITIONFROMLINE                            2167
#Define SCI_LINESCROLL                                  2168
#Define SCI_SCROLLCARET                                 2169
#Define SCI_SCROLLRANGE                                 2569
#Define SCI_REPLACESEL                                  2170
#Define SCI_SETREADONLY                                 2171
#Define SCI_NULL                                        2172
#Define SCI_CANPASTE                                    2173
#Define SCI_CANUNDO                                     2174
#Define SCI_EMPTYUNDOBUFFER                             2175
#Define SCI_UNDO                                        2176
#Define SCI_CUT                                         2177
#Define SCI_COPY                                        2178
#Define SCI_PASTE                                       2179
#Define SCI_CLEAR                                       2180
#Define SCI_SETTEXT                                     2181
#Define SCI_GETTEXT                                     2182
#Define SCI_GETTEXTLENGTH                               2183
#Define SCI_GETDIRECTFUNCTION                           2184
#Define SCI_GETDIRECTPOINTER                            2185
#Define SCI_SETOVERTYPE                                 2186
#Define SCI_GETOVERTYPE                                 2187
#Define SCI_SETCARETWIDTH                               2188
#Define SCI_GETCARETWIDTH                               2189
#Define SCI_SETTARGETSTART                              2190
#Define SCI_GETTARGETSTART                              2191
#Define SCI_SETTARGETEND                                2192
#Define SCI_GETTARGETEND                                2193
#Define SCI_REPLACETARGET                               2194
#Define SCI_REPLACETARGETRE                             2195
#Define SCI_SEARCHINTARGET                              2197
#define SCI_GETTARGETTEXT                               2687
#Define SCI_SETSEARCHFLAGS                              2198
#Define SCI_GETSEARCHFLAGS                              2199
#Define SCI_CALLTIPSHOW                                 2200
#Define SCI_CALLTIPCANCEL                               2201
#Define SCI_CALLTIPACTIVE                               2202
#Define SCI_CALLTIPPOSSTART                             2203
#Define SCI_CALLTIPSETHLT                               2204
#Define SCI_CALLTIPSETBACK                              2205
#Define SCI_CALLTIPSETFORE                              2206
#Define SCI_CALLTIPSETFOREHLT                           2207
#Define SCI_CALLTIPUSESTYLE                             2212
#Define SCI_CALLTIPSETPOSITION                          2213
#Define SCI_CALLTIPSETPOSSTART                          2214 
#Define SCI_VISIBLEFROMDOCLINE                          2220
#Define SCI_DOCLINEFROMVISIBLE                          2221
#Define SCI_WRAPCOUNT                                   2235
#Define SC_FOLDLEVELBASE                                &H400
#Define SC_FOLDLEVELWHITEFLAG                           &H1000
#Define SC_FOLDLEVELHEADERFLAG                          &H2000
#Define SC_FOLDLEVELNUMBERMASK                          &H0FFF
#Define SCI_SETFOLDLEVEL                                2222
#Define SCI_GETFOLDLEVEL                                2223
#Define SCI_GETLASTCHILD                                2224
#Define SCI_GETFOLDPARENT                               2225
#Define SCI_SHOWLINES                                   2226
#Define SCI_HIDELINES                                   2227
#Define SCI_GETLINEVISIBLE                              2228
#Define SCI_GETALLLINESVISIBLE                          2236
#Define SCI_SETFOLDEXPANDED                             2229
#Define SCI_GETFOLDEXPANDED                             2230
#Define SCI_TOGGLEFOLD                                  2231
#Define SC_FOLDACTION_CONTRACT                          0
#Define SC_FOLDACTION_EXPAND                            1
#Define SC_FOLDACTION_TOGGLE                            2
#Define SCI_FOLDLINE                                    2237
#Define SCI_FOLDCHILDREN                                2238
#Define SCI_EXPANDCHILDREN                              2239
#Define SCI_FOLDALL                                     2662
#Define SCI_ENSUREVISIBLE                               2232
#Define SC_AUTOMATICFOLD_SHOW                           &H0001
#Define SC_AUTOMATICFOLD_CLICK                          &H0002
#Define SC_AUTOMATICFOLD_CHANGE                         &H0004
#Define SCI_SETAUTOMATICFOLD                            2663
#Define SCI_GETAUTOMATICFOLD                            2664
#Define SC_FOLDFLAG_LINEBEFORE_EXPANDED                 &H0002
#Define SC_FOLDFLAG_LINEBEFORE_CONTRACTED               &H0004
#Define SC_FOLDFLAG_LINEAFTER_EXPANDED                  &H0008
#Define SC_FOLDFLAG_LINEAFTER_CONTRACTED                &H0010
#Define SC_FOLDFLAG_LEVELNUMBERS                        &H0040
#Define SCI_SETFOLDFLAGS                                2233
#Define SCI_ENSUREVISIBLEENFORCEPOLICY                  2234
#Define SCI_SETTABINDENTS                               2260
#Define SCI_GETTABINDENTS                               2261
#Define SCI_SETBACKSPACEUNINDENTS                       2262
#Define SCI_GETBACKSPACEUNINDENTS                       2263
#Define SC_TIME_FOREVER                                 10000000
#Define SCI_SETMOUSEDWELLTIME                           2264
#Define SCI_GETMOUSEDWELLTIME                           2265
#Define SCI_WORDSTARTPOSITION                           2266
#Define SCI_WORDENDPOSITION                             2267
#Define SC_WRAP_NONE                                    0
#Define SC_WRAP_WORD                                    1
#Define SC_WRAP_CHAR                                    2
#Define SCI_SETWRAPMODE                                 2268
#Define SCI_GETWRAPMODE                                 2269
#Define SC_WRAPVISUALFLAG_NONE                          &H0000
#Define SC_WRAPVISUALFLAG_END                           &H0001
#Define SC_WRAPVISUALFLAG_START                         &H0002
#Define SC_WRAPVISUALFLAG_MARGIN                        &H0004
#Define SCI_SETWRAPVISUALFLAGS                          2460
#Define SCI_GETWRAPVISUALFLAGS                          2461
#Define SC_WRAPVISUALFLAGLOC_DEFAULT                    &H0000
#Define SC_WRAPVISUALFLAGLOC_END_BY_TEXT                &H0001
#Define SC_WRAPVISUALFLAGLOC_START_BY_TEXT              &H0002
#Define SCI_SETWRAPVISUALFLAGSLOCATION                  2462
#Define SCI_GETWRAPVISUALFLAGSLOCATION                  2463
#Define SCI_SETWRAPSTARTINDENT                          2464
#Define SCI_GETWRAPSTARTINDENT                          2465
#Define SC_WRAPINDENT_FIXED                             0
#Define SC_WRAPINDENT_SAME                              1
#Define SC_WRAPINDENT_INDENT                            2
#Define SCI_SETWRAPINDENTMODE                           2472
#Define SCI_GETWRAPINDENTMODE                           2473
#Define SC_CACHE_NONE                                   0
#Define SC_CACHE_CARET                                  1
#Define SC_CACHE_PAGE                                   2
#Define SC_CACHE_DOCUMENT                               3
#Define SCI_SETLAYOUTCACHE                              2272
#Define SCI_GETLAYOUTCACHE                              2273
#Define SCI_SETSCROLLWIDTH                              2274
#Define SCI_GETSCROLLWIDTH                              2275
#Define SCI_SETSCROLLWIDTHTRACKING                      2516
#Define SCI_GETSCROLLWIDTHTRACKING                      2517
#Define SCI_TEXTWIDTH                                   2276
#Define SCI_SETENDATLASTLINE                            2277
#Define SCI_GETENDATLASTLINE                            2278
#Define SCI_TEXTHEIGHT                                  2279
#Define SCI_SETVSCROLLBAR                               2280
#Define SCI_GETVSCROLLBAR                               2281
#Define SCI_APPENDTEXT                                  2282
#Define SCI_GETTWOPHASEDRAW                             2283
#Define SCI_SETTWOPHASEDRAW                             2284
#Define SC_EFF_QUALITY_MASK                             &HF
#Define SC_EFF_QUALITY_DEFAULT                          0
#Define SC_EFF_QUALITY_NON_ANTIALIASED                  1
#Define SC_EFF_QUALITY_ANTIALIASED                      2
#Define SC_EFF_QUALITY_LCD_OPTIMIZED                    3
#Define SCI_SETFONTQUALITY                              2611
#Define SCI_GETFONTQUALITY                              2612
#Define SCI_SETFIRSTVISIBLELINE                         2613
#Define SC_MULTIPASTE_ONCE                              0
#Define SC_MULTIPASTE_EACH                              1
#Define SCI_SETMULTIPASTE                               2614
#Define SCI_GETMULTIPASTE                               2615
#Define SCI_GETTAG                                      2616
#Define SCI_TARGETFROMSELECTION                         2287
#Define SCI_LINESJOIN                                   2288
#Define SCI_LINESSPLIT                                  2289
#Define SCI_SETFOLDMARGINCOLOUR                         2290
#Define SCI_SETFOLDMARGINHICOLOUR                       2291
#Define SCI_LINEDOWN                                    2300
#Define SCI_LINEDOWNEXTEND                              2301
#Define SCI_LINEUP                                      2302
#Define SCI_LINEUPEXTEND                                2303
#Define SCI_CHARLEFT                                    2304
#Define SCI_CHARLEFTEXTEND                              2305
#Define SCI_CHARRIGHT                                   2306
#Define SCI_CHARRIGHTEXTEND                             2307
#Define SCI_WORDLEFT                                    2308
#Define SCI_WORDLEFTEXTEND                              2309
#Define SCI_WORDRIGHT                                   2310
#Define SCI_WORDRIGHTEXTEND                             2311
#Define SCI_HOME                                        2312
#Define SCI_HOMEEXTEND                                  2313
#Define SCI_LINEEND                                     2314
#Define SCI_LINEENDEXTEND                               2315
#Define SCI_DOCUMENTSTART                               2316
#Define SCI_DOCUMENTSTARTEXTEND                         2317
#Define SCI_DOCUMENTEND                                 2318
#Define SCI_DOCUMENTENDEXTEND                           2319
#Define SCI_PAGEUP                                      2320
#Define SCI_PAGEUPEXTEND                                2321
#Define SCI_PAGEDOWN                                    2322
#Define SCI_PAGEDOWNEXTEND                              2323
#Define SCI_EDITTOGGLEOVERTYPE                          2324
#Define SCI_CANCEL                                      2325
#Define SCI_DELETEBACK                                  2326
#Define SCI_TAB                                         2327
#Define SCI_BACKTAB                                     2328
#Define SCI_NEWLINE                                     2329
#Define SCI_FORMFEED                                    2330
#Define SCI_VCHOME                                      2331
#Define SCI_VCHOMEEXTEND                                2332
#Define SCI_ZOOMIN                                      2333
#Define SCI_ZOOMOUT                                     2334
#Define SCI_DELWORDLEFT                                 2335
#Define SCI_DELWORDRIGHT                                2336
#Define SCI_DELWORDRIGHTEND                             2518
#Define SCI_LINECUT                                     2337
#Define SCI_LINEDELETE                                  2338
#Define SCI_LINETRANSPOSE                               2339
#Define SCI_LINEDUPLICATE                               2404
#Define SCI_LOWERCASE                                   2340
#Define SCI_UPPERCASE                                   2341
#Define SCI_LINESCROLLDOWN                              2342
#Define SCI_LINESCROLLUP                                2343
#Define SCI_DELETEBACKNOTLINE                           2344
#Define SCI_HOMEDISPLAY                                 2345
#Define SCI_HOMEDISPLAYEXTEND                           2346
#Define SCI_LINEENDDISPLAY                              2347
#Define SCI_LINEENDDISPLAYEXTEND                        2348
#Define SCI_HOMEWRAP                                    2349
#Define SCI_HOMEWRAPEXTEND                              2450
#Define SCI_LINEENDWRAP                                 2451
#Define SCI_LINEENDWRAPEXTEND                           2452
#Define SCI_VCHOMEWRAP                                  2453
#Define SCI_VCHOMEWRAPEXTEND                            2454
#Define SCI_LINECOPY                                    2455
#Define SCI_MOVECARETINSIDEVIEW                         2401
#Define SCI_LINELENGTH                                  2350
#Define SCI_BRACEHIGHLIGHT                              2351
#Define SCI_BRACEHIGHLIGHTINDICATOR                     2498
#Define SCI_BRACEBADLIGHT                               2352
#Define SCI_BRACEBADLIGHTINDICATOR                      2499
#Define SCI_BRACEMATCH                                  2353
#Define SCI_GETVIEWEOL                                  2355
#Define SCI_SETVIEWEOL                                  2356
#Define SCI_GETDOCPOINTER                               2357
#Define SCI_SETDOCPOINTER                               2358
#Define SCI_SETMODEVENTMASK                             2359
#Define EDGE_NONE                                       0
#Define EDGE_LINE                                       1
#Define EDGE_BACKGROUND                                 2
#Define SCI_GETEDGECOLUMN                               2360
#Define SCI_SETEDGECOLUMN                               2361
#Define SCI_GETEDGEMODE                                 2362
#Define SCI_SETEDGEMODE                                 2363
#Define SCI_GETEDGECOLOUR                               2364
#Define SCI_SETEDGECOLOUR                               2365
#Define SCI_SEARCHANCHOR                                2366
#Define SCI_SEARCHNEXT                                  2367
#Define SCI_SEARCHPREV                                  2368
#Define SCI_LINESONSCREEN                               2370
#Define SCI_USEPOPUP                                    2371
#Define SCI_SELECTIONISRECTANGLE                        2372
#Define SCI_SETZOOM                                     2373
#Define SCI_GETZOOM                                     2374
#Define SCI_CREATEDOCUMENT                              2375
#Define SCI_ADDREFDOCUMENT                              2376
#Define SCI_RELEASEDOCUMENT                             2377
#Define SCI_GETMODEVENTMASK                             2378
#Define SCI_SETFOCUS                                    2380
#Define SCI_GETFOCUS                                    2381
#Define SC_STATUS_OK                                    0
#Define SC_STATUS_FAILURE                               1
#Define SC_STATUS_BADALLOC                              2
#Define SCI_SETSTATUS                                   2382
#Define SCI_GETSTATUS                                   2383
#Define SCI_SETMOUSEDOWNCAPTURES                        2384
#Define SCI_GETMOUSEDOWNCAPTURES                        2385
#Define SC_CURSORNORMAL                                 -1
#Define SC_CURSORARROW                                  2
#Define SC_CURSORWAIT                                   4
#Define SC_CURSORREVERSEARROW                           7
#Define SCI_SETCURSOR                                   2386
#Define SCI_GETCURSOR                                   2387
#Define SCI_SETCONTROLCHARSYMBOL                        2388
#Define SCI_GETCONTROLCHARSYMBOL                        2389
#Define SCI_WORDPARTLEFT                                2390
#Define SCI_WORDPARTLEFTEXTEND                          2391
#Define SCI_WORDPARTRIGHT                               2392
#Define SCI_WORDPARTRIGHTEXTEND                         2393
#Define VISIBLE_SLOP                                    &H01
#Define VISIBLE_STRICT                                  &H04
#Define SCI_SETVISIBLEPOLICY                            2394
#Define SCI_DELLINELEFT                                 2395
#Define SCI_DELLINERIGHT                                2396
#Define SCI_SETXOFFSET                                  2397
#Define SCI_GETXOFFSET                                  2398
#Define SCI_CHOOSECARETX                                2399
#Define SCI_GRABFOCUS                                   2400
#Define CARET_SLOP                                      &H01
#Define CARET_STRICT                                    &H04
#Define CARET_JUMPS                                     &H10
#Define CARET_EVEN                                      &H08
#Define SCI_SETXCARETPOLICY                             2402
#Define SCI_SETYCARETPOLICY                             2403
#Define SCI_SETPRINTWRAPMODE                            2406
#Define SCI_GETPRINTWRAPMODE                            2407
#Define SCI_SETHOTSPOTACTIVEFORE                        2410
#Define SCI_GETHOTSPOTACTIVEFORE                        2494
#Define SCI_SETHOTSPOTACTIVEBACK                        2411
#Define SCI_GETHOTSPOTACTIVEBACK                        2495
#Define SCI_SETHOTSPOTACTIVEUNDERLINE                   2412
#Define SCI_GETHOTSPOTACTIVEUNDERLINE                   2496
#Define SCI_SETHOTSPOTSINGLELINE                        2421
#Define SCI_GETHOTSPOTSINGLELINE                        2497
#Define SCI_PARADOWN                                    2413
#Define SCI_PARADOWNEXTEND                              2414
#Define SCI_PARAUP                                      2415
#Define SCI_PARAUPEXTEND                                2416
#Define SCI_POSITIONBEFORE                              2417
#Define SCI_POSITIONAFTER                               2418
#Define SCI_POSITIONRELATIVE                            2670
#Define SCI_COPYRANGE                                   2419
#Define SCI_COPYTEXT                                    2420
#Define SC_SEL_STREAM                                   0
#Define SC_SEL_RECTANGLE                                1
#Define SC_SEL_LINES                                    2
#Define SCI_SETSELECTIONMODE                            2422
#Define SCI_GETSELECTIONMODE                            2423
#Define SCI_GETLINESELSTARTPOSITION                     2424
#Define SCI_GETLINESELENDPOSITION                       2425
#Define SCI_LINEDOWNRECTEXTEND                          2426
#Define SCI_LINEUPRECTEXTEND                            2427
#Define SCI_CHARLEFTRECTEXTEND                          2428
#Define SCI_CHARRIGHTRECTEXTEND                         2429
#Define SCI_HOMERECTEXTEND                              2430
#Define SCI_VCHOMERECTEXTEND                            2431
#Define SCI_LINEENDRECTEXTEND                           2432
#Define SCI_PAGEUPRECTEXTEND                            2433
#Define SCI_PAGEDOWNRECTEXTEND                          2434
#Define SCI_STUTTEREDPAGEUP                             2435
#Define SCI_STUTTEREDPAGEUPEXTEND                       2436
#Define SCI_STUTTEREDPAGEDOWN                           2437
#Define SCI_STUTTEREDPAGEDOWNEXTEND                     2438
#Define SCI_WORDLEFTEND                                 2439
#Define SCI_WORDLEFTENDEXTEND                           2440
#Define SCI_WORDRIGHTEND                                2441
#Define SCI_WORDRIGHTENDEXTEND                          2442
#Define SCI_SETWHITESPACECHARS                          2443
#Define SCI_GETWHITESPACECHARS                          2647
#Define SCI_SETPUNCTUATIONCHARS                         2648
#Define SCI_GETPUNCTUATIONCHARS                         2649
#Define SCI_SETCHARSDEFAULT                             2444
#Define SCI_AUTOCGETCURRENT                             2445
#Define SCI_AUTOCGETCURRENTTEXT                         2610
#Define SC_CASEINSENSITIVEBEHAVIOUR_RESPECTCASE         0
#Define SC_CASEINSENSITIVEBEHAVIOUR_IGNORECASE          1
#Define SCI_AUTOCSETCASEINSENSITIVEBEHAVIOUR            2634
#Define SCI_AUTOCGETCASEINSENSITIVEBEHAVIOUR            2635
#Define SC_ORDER_PRESORTED                              0
#Define SC_ORDER_PERFORMSORT                            1
#Define SC_ORDER_CUSTOM                                 2
#Define SCI_AUTOCSETORDER                               2660
#Define SCI_AUTOCGETORDER                               2661
#Define SCI_ALLOCATE                                    2446
#Define SCI_TARGETASUTF8                                2447
#Define SCI_SETLENGTHFORENCODE                          2448
#Define SCI_ENCODEDFROMUTF8                             2449
#Define SCI_FINDCOLUMN                                  2456
#Define SCI_GETCARETSTICKY                              2457
#Define SCI_SETCARETSTICKY                              2458
#Define SC_CARETSTICKY_OFF                              0
#Define SC_CARETSTICKY_ON                               1
#Define SC_CARETSTICKY_WHITESPACE                       2
#Define SCI_TOGGLECARETSTICKY                           2459
#Define SCI_SETPASTECONVERTENDINGS                      2467
#Define SCI_GETPASTECONVERTENDINGS                      2468
#Define SCI_SELECTIONDUPLICATE                          2469
#Define SC_ALPHA_TRANSPARENT                            0
#Define SC_ALPHA_OPAQUE                                 255
#Define SC_ALPHA_NOALPHA                                256
#Define SCI_SETCARETLINEBACKALPHA                       2470
#Define SCI_GETCARETLINEBACKALPHA                       2471
#Define CARETSTYLE_INVISIBLE                            0
#Define CARETSTYLE_LINE                                 1
#Define CARETSTYLE_BLOCK                                2
#Define SCI_SETCARETSTYLE                               2512
#Define SCI_GETCARETSTYLE                               2513
#Define SCI_SETINDICATORCURRENT                         2500
#Define SCI_GETINDICATORCURRENT                         2501
#Define SCI_SETINDICATORVALUE                           2502
#Define SCI_GETINDICATORVALUE                           2503
#Define SCI_INDICATORFILLRANGE                          2504
#Define SCI_INDICATORCLEARRANGE                         2505
#Define SCI_INDICATORALLONFOR                           2506
#Define SCI_INDICATORVALUEAT                            2507
#Define SCI_INDICATORSTART                              2508
#Define SCI_INDICATOREND                                2509
#Define SCI_SETPOSITIONCACHE                            2514
#Define SCI_GETPOSITIONCACHE                            2515
#Define SCI_COPYALLOWLINE                               2519
#Define SCI_GETCHARACTERPOINTER                         2520
#Define SCI_GETRANGEPOINTER                             2643
#Define SCI_GETGAPPOSITION                              2644
#Define SCI_SETKEYSUNICODE                              2521
#Define SCI_GETKEYSUNICODE                              2522
#Define SCI_INDICSETALPHA                               2523
#Define SCI_INDICGETALPHA                               2524
#Define SCI_INDICSETOUTLINEALPHA                        2558
#Define SCI_INDICGETOUTLINEALPHA                        2559
#Define SCI_SETEXTRAASCENT                              2525
#Define SCI_GETEXTRAASCENT                              2526
#Define SCI_SETEXTRADESCENT                             2527
#Define SCI_GETEXTRADESCENT                             2528
#Define SCI_MARKERSYMBOLDEFINED                         2529
#Define SCI_MARGINSETTEXT                               2530
#Define SCI_MARGINGETTEXT                               2531
#Define SCI_MARGINSETSTYLE                              2532
#Define SCI_MARGINGETSTYLE                              2533
#Define SCI_MARGINSETSTYLES                             2534
#Define SCI_MARGINGETSTYLES                             2535
#Define SCI_MARGINTEXTCLEARALL                          2536
#Define SCI_MARGINSETSTYLEOFFSET                        2537
#Define SCI_MARGINGETSTYLEOFFSET                        2538
#Define SC_MARGINOPTION_NONE                            0
#Define SC_MARGINOPTION_SUBLINESELECT                   1
#Define SCI_SETMARGINOPTIONS                            2539
#Define SCI_GETMARGINOPTIONS                            2557
#Define SCI_ANNOTATIONSETTEXT                           2540
#Define SCI_ANNOTATIONGETTEXT                           2541
#Define SCI_ANNOTATIONSETSTYLE                          2542
#Define SCI_ANNOTATIONGETSTYLE                          2543
#Define SCI_ANNOTATIONSETSTYLES                         2544
#Define SCI_ANNOTATIONGETSTYLES                         2545
#Define SCI_ANNOTATIONGETLINES                          2546
#Define SCI_ANNOTATIONCLEARALL                          2547
#Define ANNOTATION_HIDDEN                               0
#Define ANNOTATION_STANDARD                             1
#Define ANNOTATION_BOXED                                2
#Define SCI_ANNOTATIONSETVISIBLE                        2548
#Define SCI_ANNOTATIONGETVISIBLE                        2549
#Define SCI_ANNOTATIONSETSTYLEOFFSET                    2550
#Define SCI_ANNOTATIONGETSTYLEOFFSET                    2551
#Define SCI_RELEASEALLEXTENDEDSTYLES                    2552
#Define SCI_ALLOCATEEXTENDEDSTYLES                      2553
#Define UNDO_MAY_COALESCE                               1
#Define SCI_ADDUNDOACTION                               2560
#Define SCI_CHARPOSITIONFROMPOINT                       2561
#Define SCI_CHARPOSITIONFROMPOINTCLOSE                  2562
#Define SCI_SETMOUSESELECTIONRECTANGULARSWITCH          2668
#Define SCI_GETMOUSESELECTIONRECTANGULARSWITCH          2669
#Define SCI_SETMULTIPLESELECTION                        2563
#Define SCI_GETMULTIPLESELECTION                        2564
#Define SCI_SETADDITIONALSELECTIONTYPING                2565
#Define SCI_GETADDITIONALSELECTIONTYPING                2566
#Define SCI_SETADDITIONALCARETSBLINK                    2567
#Define SCI_GETADDITIONALCARETSBLINK                    2568
#Define SCI_SETADDITIONALCARETSVISIBLE                  2608
#Define SCI_GETADDITIONALCARETSVISIBLE                  2609
#Define SCI_GETSELECTIONS                               2570
#Define SCI_GETSELECTIONEMPTY                           2650
#define SCI_DROPSELECTIONN                              2671
#Define SCI_CLEARSELECTIONS                             2571
#Define SCI_SETSELECTION                                2572
#Define SCI_ADDSELECTION                                2573
#Define SCI_SETMAINSELECTION                            2574
#Define SCI_GETMAINSELECTION                            2575
#Define SCI_SETSELECTIONNCARET                          2576
#Define SCI_GETSELECTIONNCARET                          2577
#Define SCI_SETSELECTIONNANCHOR                         2578
#Define SCI_GETSELECTIONNANCHOR                         2579
#Define SCI_SETSELECTIONNCARETVIRTUALSPACE              2580
#Define SCI_GETSELECTIONNCARETVIRTUALSPACE              2581
#Define SCI_SETSELECTIONNANCHORVIRTUALSPACE             2582
#Define SCI_GETSELECTIONNANCHORVIRTUALSPACE             2583
#Define SCI_SETSELECTIONNSTART                          2584
#Define SCI_GETSELECTIONNSTART                          2585
#Define SCI_SETSELECTIONNEND                            2586
#Define SCI_GETSELECTIONNEND                            2587
#Define SCI_SETRECTANGULARSELECTIONCARET                2588
#Define SCI_GETRECTANGULARSELECTIONCARET                2589
#Define SCI_SETRECTANGULARSELECTIONANCHOR               2590
#Define SCI_GETRECTANGULARSELECTIONANCHOR               2591
#Define SCI_SETRECTANGULARSELECTIONCARETVIRTUALSPACE    2592
#Define SCI_GETRECTANGULARSELECTIONCARETVIRTUALSPACE    2593
#Define SCI_SETRECTANGULARSELECTIONANCHORVIRTUALSPACE   2594
#Define SCI_GETRECTANGULARSELECTIONANCHORVIRTUALSPACE   2595
#Define SCVS_NONE                                       0
#Define SCVS_RECTANGULARSELECTION                       1
#Define SCVS_USERACCESSIBLE                             2
#Define SCI_SETVIRTUALSPACEOPTIONS                      2596
#Define SCI_GETVIRTUALSPACEOPTIONS                      2597
#Define SCI_SETRECTANGULARSELECTIONMODIFIER             2598
#Define SCI_GETRECTANGULARSELECTIONMODIFIER             2599
#Define SCI_SETADDITIONALSELFORE                        2600
#Define SCI_SETADDITIONALSELBACK                        2601
#Define SCI_SETADDITIONALSELALPHA                       2602
#Define SCI_GETADDITIONALSELALPHA                       2603
#Define SCI_SETADDITIONALCARETFORE                      2604
#Define SCI_GETADDITIONALCARETFORE                      2605
#Define SCI_ROTATESELECTION                             2606
#Define SCI_SWAPMAINANCHORCARET                         2607
#Define SCI_CHANGELEXERSTATE                            2617
#Define SCI_CONTRACTEDFOLDNEXT                          2618
#Define SCI_VERTICALCENTRECARET                         2619
#Define SCI_MOVESELECTEDLINESUP                         2620
#Define SCI_MOVESELECTEDLINESDOWN                       2621
#Define SCI_SETIDENTIFIER                               2622
#Define SCI_GETIDENTIFIER                               2623
#Define SCI_RGBAIMAGESETWIDTH                           2624
#Define SCI_RGBAIMAGESETHEIGHT                          2625
#Define SCI_MARKERDEFINERGBAIMAGE                       2626
#Define SCI_RGBAIMAGESETSCALE                           2651
#Define SCI_REGISTERRGBAIMAGE                           2627
#Define SCI_SCROLLTOSTART                               2628
#Define SCI_SCROLLTOEND                                 2629
#Define SC_TECHNOLOGY_DEFAULT                           0
#Define SC_TECHNOLOGY_DIRECTWRITE                       1
#Define SCI_SETTECHNOLOGY                               2630
#Define SCI_GETTECHNOLOGY                               2631
#Define SCI_CREATELOADER                                2632
#Define SCI_FINDINDICATORSHOW                           2640
#Define SCI_FINDINDICATORFLASH                          2641
#Define SCI_FINDINDICATORHIDE                           2642
#Define SCI_VCHOMEDISPLAY                               2652
#Define SCI_VCHOMEDISPLAYEXTEND                         2653
#Define SCI_GETCARETLINEVISIBLEALWAYS                   2654
#Define SCI_SETCARETLINEVISIBLEALWAYS                   2655
#Define SCI_SETREPRESENTATION                           2665
#Define SCI_GETREPRESENTATION                           2666
#Define SCI_CLEARREPRESENTATION                         2667
#Define SCI_STARTRECORD                                 3001
#Define SCI_STOPRECORD                                  3002
#Define SCI_SETLEXER                                    4001
#Define SCI_GETLEXER                                    4002
#Define SCI_COLOURISE                                   4003
#Define SCI_SETPROPERTY                                 4004
#Define KEYWORDSET_MAX                                  8
#Define SCI_SETKEYWORDS                                 4005
#Define SCI_SETLEXERLANGUAGE                            4006
#Define SCI_LOADLEXERLIBRARY                            4007
#Define SCI_GETPROPERTY                                 4008
#Define SCI_GETPROPERTYEXPANDED                         4009
#Define SCI_GETPROPERTYINT                              4010
#Define SCI_GETSTYLEBITSNEEDED                          4011
#Define SCI_GETLEXERLANGUAGE                            4012
#Define SCI_PRIVATELEXERCALL                            4013
#Define SCI_PROPERTYNAMES                               4014
#Define SC_TYPE_BOOLEAN                                 0
#Define SC_TYPE_INTEGER                                 1
#Define SC_TYPE_STRING                                  2
#Define SCI_PROPERTYTYPE                                4015
#Define SCI_DESCRIBEPROPERTY                            4016
#Define SCI_DESCRIBEKEYWORDSETS                         4017
#Define SC_MOD_INSERTTEXT                               &H1
#Define SC_MOD_DELETETEXT                               &H2
#Define SC_MOD_CHANGESTYLE                              &H4
#Define SC_MOD_CHANGEFOLD                               &H8
#Define SC_PERFORMED_USER                               &H10
#Define SC_PERFORMED_UNDO                               &H20
#Define SC_PERFORMED_REDO                               &H40
#Define SC_MULTISTEPUNDOREDO                            &H80
#Define SC_LASTSTEPINUNDOREDO                           &H100
#Define SC_MOD_CHANGEMARKER                             &H200
#Define SC_MOD_BEFOREINSERT                             &H400
#Define SC_MOD_BEFOREDELETE                             &H800
#Define SC_MULTILINEUNDOREDO                            &H1000
#Define SC_STARTACTION                                  &H2000
#Define SC_MOD_CHANGEINDICATOR                          &H4000
#Define SC_MOD_CHANGELINESTATE                          &H8000
#Define SC_MOD_CHANGEMARGIN                             &H10000
#Define SC_MOD_CHANGEANNOTATION                         &H20000
#Define SC_MOD_CONTAINER                                &H40000
#Define SC_MOD_LEXERSTATE                               &H80000
#Define SC_MODEVENTMASKALL                              &HFFFF
#Define SC_UPDATE_CONTENT                               &H1
#Define SC_UPDATE_SELECTION                             &H2
#Define SC_UPDATE_V_SCROLL                              &H4
#Define SC_UPDATE_H_SCROLL                              &H8
#Define SCEN_CHANGE                                     768
#Define SCEN_SETFOCUS                                   512
#Define SCEN_KILLFOCUS                                  256
#Define SCK_DOWN                                        300
#Define SCK_UP                                          301
#Define SCK_LEFT                                        302
#Define SCK_RIGHT                                       303
#Define SCK_HOME                                        304
#Define SCK_END                                         305
#Define SCK_PRIOR                                       306
#Define SCK_NEXT                                        307
#Define SCK_DELETE                                      308
#Define SCK_INSERT                                      309
#Define SCK_ESCAPE                                      7
#Define SCK_BACK                                        8
#Define SCK_TAB                                         9
#Define SCK_RETURN                                      13
#Define SCK_ADD                                         310
#Define SCK_SUBTRACT                                    311
#Define SCK_DIVIDE                                      312
#Define SCK_WIN                                         313
#Define SCK_RWIN                                        314
#Define SCK_MENU                                        315
#Define SCMOD_NORM                                      0
#Define SCMOD_SHIFT                                     1
#Define SCMOD_CTRL                                      2
#Define SCMOD_ALT                                       4
#Define SCMOD_SUPER                                     8
#Define SCMOD_META                                      16
#Define SCN_STYLENEEDED                                 2000
#Define SCN_CHARADDED                                   2001
#Define SCN_SAVEPOINTREACHED                            2002
#Define SCN_SAVEPOINTLEFT                               2003
#Define SCN_MODIFYATTEMPTRO                             2004
#Define SCN_KEY                                         2005
#Define SCN_DOUBLECLICK                                 2006
#Define SCN_UPDATEUI                                    2007
#Define SCN_MODIFIED                                    2008
#Define SCN_MACRORECORD                                 2009
#Define SCN_MARGINCLICK                                 2010
#Define SCN_NEEDSHOWN                                   2011
#Define SCN_PAINTED                                     2013
#Define SCN_USERLISTSELECTION                           2014
#Define SCN_URIDROPPED                                  2015
#Define SCN_DWELLSTART                                  2016
#Define SCN_DWELLEND                                    2017
#Define SCN_ZOOM                                        2018
#Define SCN_HOTSPOTCLICK                                2019
#Define SCN_HOTSPOTDOUBLECLICK                          2020
#Define SCN_CALLTIPCLICK                                2021
#Define SCN_AUTOCSELECTION                              2022
#Define SCN_INDICATORCLICK                              2023
#Define SCN_INDICATORRELEASE                            2024
#Define SCN_AUTOCCANCELLED                              2025
#Define SCN_AUTOCCHARDELETED                            2026
#Define SCN_HOTSPOTRELEASECLICK                         2027
#Define SCN_FOCUSIN                                     2028
#Define SCN_FOCUSOUT                                    2029
#Define SCN_AUTOCCOMPLETED                              2030
#define SC_AUTOCOMPLETE_NORMAL                          0
#define SC_AUTOCOMPLETE_FIXED_SIZE                      1
#define SCI_AUTOCSETOPTIONS                             2638
#define SCI_AUTOCGETOPTIONS                             2639

#IfnDef SCI_DISABLE_PROVISIONAL
   #Define SC_LINE_END_TYPE_DEFAULT        0
   #Define SC_LINE_END_TYPE_UNICODE        1
   #Define SCI_SETLINEENDTYPESALLOWED      2656
   #Define SCI_GETLINEENDTYPESALLOWED      2657
   #Define SCI_GETLINEENDTYPESACTIVE       2658
   #Define SCI_GETLINEENDTYPESSUPPORTED    4018
   #Define SCI_ALLOCATESUBSTYLES           4020
   #Define SCI_GETSUBSTYLESSTART           4021
   #Define SCI_GETSUBSTYLESLENGTH          4022
   #Define SCI_FREESUBSTYLES               4023
   #Define SCI_SETIDENTIFIERS              4024
   #Define SCI_DISTANCETOSECONDARYSTYLES   4025
   #Define SCI_GETSUBSTYLEBASES            4026
#EndIf   

''--Autogenerated -- end of section automatically generated from Scintilla.iface

''  These structures are defined to be exactly the same shape as the Win32
''  CHARRANGE, TEXTRANGE, FINDTEXTEX, FORMATRANGE, and NMHDR structs.
''  So older code that treats Scintilla as a RichEdit will work.

type uptr_t as uinteger
type sptr_t as integer


' // Size = 8 bytes
Type Sci_CharacterRange Field = 4
   cpMin As Long   ' long cpMin
   cpMax As Long   ' long cpMax
End Type

' // Size = 12 bytes
Type Sci_TextRange Field = 4
   chrg      As Sci_CharacterRange   ' struct Sci_CharacterRange chrg
   lpstrText As ZString Ptr          ' char *lpstrText
End Type

' // Size = 20 bytes
Type Sci_TextToFind Field = 4
   chrg      As Sci_CharacterRange   ' struct Sci_CharacterRange chrg
   lpstrText As ZString Ptr          ' char *lpstrText
   chrgText  As Sci_CharacterRange   ' struct Sci_CharacterRange chrgText
End Type


' // Size = 16 bytes
Type Sci_Rectangle
   Left   As Long   ' int
   top    As Long   ' int
   Right  As Long   ' int
   bottom As Long   ' int
End Type

'' This structure is used in printing and requires some of the graphics types
'' from Platform.h.  Not needed by most client code.

' // Size = 48 bytes
Type Sci_RangeToFormat Field = 4
   hdc       As HDC                  ' Sci_SurfaceID hdc
   hdcTarget As HDC                  ' Sci_SurfaceID hdcTarget
   rc        As Sci_Rectangle        ' struct Sci_Rectangle rc
   rcPage    As Sci_Rectangle        ' struct Sci_Rectangle rcPage
   chrg      As Sci_CharacterRange   ' struct Sci_CharacterRange chrg
End Type

         
type Sci_Position as integer
type Sci_PositionU as uinteger
type Sci_PositionCR as clong
         
type Sci_NotifyHeader
	hwndFrom as any ptr
	idFrom as uptr_t
	code as ulong
end type

type SCNotification
	hdr as Sci_NotifyHeader
	position as Sci_Position
	ch as long
	modifiers as long
	modificationType as long
	lptext as const zstring ptr
	length as Sci_Position
	linesAdded as Sci_Position
	message as long
	wParam as uptr_t
	lParam as sptr_t
	line as Sci_Position
	foldLevelNow as long
	foldLevelPrev as long
	margin as long
	listType as long
	x as long
	y as long
	token as long
	annotationLinesAdded as Sci_Position
	updated as long
	listCompletionMethod as long
end type



#IfDef INCLUDE_DEPRECATED_FEATURES
   #Define SC_CP_DBCS         1
   #Define SCI_SETUSEPALETTE  2039
   #Define SCI_GETUSEPALETTE  2139
#EndIf
