/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class SampleConsumer {
    private ConsumerManager manager;
    private String returnToUrl;

    public SampleConsumer() throws ConsumerException {
        this("http://example.com/openid");
    }

    public SampleConsumer(String returnToUrl) throws ConsumerException {
        this.returnToUrl = returnToUrl;
        this.manager = new ConsumerManager();
        this.manager.setAssociations(new InMemoryConsumerAssociationStore());
        this.manager.setNonceVerifier(new InMemoryNonceVerifier(5000));
        this.manager.getRealmVerifier().setEnforceRpId(false);
    }

    public String authRequest(String userSuppliedString, HttpServletRequest httpReq, HttpServletResponse httpResp) throws IOException {
        try {
            List discoveries = this.manager.discover(userSuppliedString);
            DiscoveryInformation discovered = this.manager.associate(discoveries);
            httpReq.getSession().setAttribute("openid-disc", (Object)discovered);
            AuthRequest authReq = this.manager.authenticate(discovered, this.returnToUrl);
            FetchRequest fetch = FetchRequest.createFetchRequest();
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
            authReq.addExtension(fetch);
            SRegRequest sregReq = SRegRequest.createFetchRequest();
            sregReq.addAttribute("email", true);
            authReq.addExtension(sregReq);
            if (!discovered.isVersion2()) {
                httpResp.sendRedirect(authReq.getDestinationUrl(true));
                return null;
            }
        }
        catch (OpenIDException e) {
            throw new RuntimeException("wrap:" + e.getMessage(), e);
        }
        return null;
    }

    public Identifier verifyResponse(HttpServletRequest httpReq) {
        try {
            VerificationResult verification;
            Identifier verified;
            ParameterList response = new ParameterList(httpReq.getParameterMap());
            DiscoveryInformation discovered = (DiscoveryInformation)httpReq.getSession().getAttribute("openid-disc");
            StringBuffer receivingURL = httpReq.getRequestURL();
            String queryString = httpReq.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(httpReq.getQueryString());
            }
            if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, discovered)).getVerifiedId()) != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                HttpSession session = httpReq.getSession(true);
                session.setAttribute("openid_identifier", (Object)authSuccess.getIdentity());
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    session.setAttribute("emailFromFetch", fetchResp.getAttributeValues("email").get(0));
                }
                if (authSuccess.hasExtension("http://openid.net/sreg/1.0")) {
                    SRegResponse sregResp = (SRegResponse)authSuccess.getExtension("http://openid.net/sreg/1.0");
                    session.setAttribute("emailFromSReg", (Object)sregResp.getAttributeValue("email"));
                }
                return verified;
            }
        }
        catch (OpenIDException e) {
            throw new RuntimeException("wrap:" + e.getMessage(), e);
        }
        return null;
    }
}

