/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.util.BasicPrettyPrinter;
import flex.messaging.util.PrettyPrintable;
import flex.messaging.util.XMLUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ToStringPrettyPrinter
extends BasicPrettyPrinter {
    private IdentityHashMap knownObjects;
    private int knownObjectsCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prettify(Object o) {
        try {
            this.knownObjects = new IdentityHashMap();
            this.knownObjectsCount = 0;
            String string = super.prettify(o);
            return string;
        }
        finally {
            this.knownObjects = null;
            this.knownObjectsCount = 0;
        }
    }

    public Object clone() {
        return new ToStringPrettyPrinter();
    }

    protected void prettifyComplexType(Object o) {
        if (!this.isKnownObject(o)) {
            StringBuffer header = new StringBuffer();
            Class<?> c = o.getClass();
            if (this.hasCustomToStringMethod(c)) {
                this.trace.write((Object)String.valueOf(o));
            } else if (o instanceof Collection) {
                Collection col = (Collection)o;
                header.append(c.getName()).append(" (Collection size:").append(col.size()).append(")");
                this.trace.startArray(header.toString());
                Iterator it = col.iterator();
                int i = 0;
                while (it.hasNext()) {
                    this.trace.arrayElement(i);
                    this.internalPrettify(it.next());
                    this.trace.newLine();
                    ++i;
                }
                this.trace.endArray();
            } else if (c.isArray()) {
                Class<?> componentType = c.getComponentType();
                int count = Array.getLength(o);
                header.append(componentType.getName()).append("[] (Array length:").append(count).append(")");
                this.trace.startArray(header.toString());
                for (int i = 0; i < count; ++i) {
                    this.trace.arrayElement(i);
                    this.internalPrettify(Array.get(o, i));
                    this.trace.newLine();
                }
                this.trace.endArray();
            } else if (o instanceof Document) {
                try {
                    String xml = XMLUtil.documentToString((Document)o);
                    this.trace.write((Object)xml);
                }
                catch (IOException ex) {
                    this.trace.write((Object)"(Document not printable)");
                }
            } else {
                PropertyProxy proxy = PropertyProxyRegistry.getProxy(o);
                if (o instanceof PrettyPrintable) {
                    PrettyPrintable pp = (PrettyPrintable)o;
                    header.append(pp.toStringHeader());
                } else {
                    header.append(c.getName());
                    if (o instanceof Map) {
                        header.append(" (Map size:").append(((Map)o).size()).append(")");
                    }
                }
                this.trace.startObject(header.toString());
                List propertyNames = proxy.getPropertyNames();
                if (propertyNames != null) {
                    Iterator it = propertyNames.iterator();
                    while (it.hasNext()) {
                        String propName = (String)it.next();
                        this.trace.namedElement(propName);
                        Object value = null;
                        if (this.trace.nextElementExclude) {
                            this.trace.nextElementExclude = false;
                            value = "** [Value Suppressed] **";
                        } else {
                            String customToString;
                            if (o instanceof PrettyPrintable && (customToString = ((PrettyPrintable)o).toStringCustomProperty(propName)) != null) {
                                value = customToString;
                            }
                            if (value == null) {
                                value = proxy.getValue(propName);
                            }
                        }
                        this.internalPrettify(value);
                        this.trace.newLine();
                    }
                }
                this.trace.endObject();
            }
        }
    }

    private boolean isKnownObject(Object o) {
        Object ref = this.knownObjects.get(o);
        if (ref != null) {
            try {
                int refNum = (Integer)ref;
                this.trace.writeRef(refNum);
            }
            catch (ClassCastException classCastException) {}
        } else {
            this.rememberObject(o);
        }
        return ref != null;
    }

    private void rememberObject(Object o) {
        this.knownObjects.put(o, new Integer(this.knownObjectsCount++));
    }
}

