/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageClient;
import flex.messaging.client.FlexClient;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.SettingsReplaceUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseHTTPEndpoint
extends AbstractEndpoint {
    private static final String ADD_NO_CACHE_HEADERS = "add-no-cache-headers";
    private static final String REDIRECT_URL = "redirect-url";
    private static final String INVALIDATE_SESSION_ON_DISCONNECT = "invalidate-session-on-disconnect";
    protected EndpointControl controller;
    protected AMFFilter filterChain;
    protected boolean addNoCacheHeaders = true;
    protected boolean loginAfterDisconnect;
    protected boolean invalidateSessionOnDisconnect;
    protected String redirectURL;

    public BaseHTTPEndpoint() {
        this(false);
    }

    public BaseHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.addNoCacheHeaders = properties.getPropertyAsBoolean(ADD_NO_CACHE_HEADERS, true);
        this.redirectURL = properties.getPropertyAsString(REDIRECT_URL, null);
        this.invalidateSessionOnDisconnect = properties.getPropertyAsBoolean(INVALIDATE_SESSION_ON_DISCONNECT, false);
        this.loginAfterDisconnect = properties.getPropertyAsBoolean("login-after-disconnect", false);
        this.validateEndpointProtocol();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.filterChain = this.createFilterChain();
    }

    public boolean isAddNoCacheHeaders() {
        return this.addNoCacheHeaders;
    }

    public void setAddNoCacheHeaders(boolean addNoCacheHeaders) {
        this.addNoCacheHeaders = addNoCacheHeaders;
    }

    public boolean isInvalidateSessionOnDisconnect() {
        return this.invalidateSessionOnDisconnect;
    }

    public void setInvalidateSessionOnDisconnect(boolean value) {
        this.invalidateSessionOnDisconnect = value;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) {
        super.service(req, res);
        try {
            this.setThreadLocals();
            ActionContext context = new ActionContext();
            context.setRecordMessageSizes(this.isRecordMessageSizes());
            context.setRecordMessageTimes(this.isRecordMessageTimes());
            this.filterChain.invoke(context);
            if (this.isManaged()) {
                this.controller.addToBytesDeserialized(context.getDeserializedBytes());
                this.controller.addToBytesSerialized(context.getSerializedBytes());
            }
            if (context.getStatus() != 2) {
                if (this.addNoCacheHeaders) {
                    BaseHTTPEndpoint.addNoCacheHeaders(req, res);
                }
                ByteArrayOutputStream outBuffer = context.getResponseOutput();
                res.setContentType(this.getResponseContentType());
                res.setContentLength(outBuffer.size());
                outBuffer.writeTo((OutputStream)res.getOutputStream());
                res.flushBuffer();
            } else if (this.redirectURL != null) {
                try {
                    this.redirectURL = SettingsReplaceUtil.replaceContextPath(this.redirectURL, req.getContextPath());
                    res.sendRedirect(this.redirectURL);
                }
                catch (IllegalStateException alreadyFlushed) {
                    // empty catch block
                }
            }
        }
        catch (SocketException se) {
            this.log.info(se.getMessage());
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
        }
        finally {
            this.clearThreadLocals();
        }
    }

    public ConfigMap describeEndpoint() {
        ConfigMap endpointConfig = super.describeEndpoint();
        boolean createdProperties = false;
        ConfigMap properties = endpointConfig.getPropertyAsMap("properties", null);
        if (properties == null) {
            properties = new ConfigMap();
            createdProperties = true;
        }
        if (this.loginAfterDisconnect) {
            ConfigMap loginAfterDisconnect = new ConfigMap();
            loginAfterDisconnect.addProperty("", "true");
            properties.addProperty("login-after-disconnect", loginAfterDisconnect);
        }
        if (createdProperties && properties.size() > 0) {
            endpointConfig.addProperty("properties", properties);
        }
        return endpointConfig;
    }

    protected abstract AMFFilter createFilterChain();

    protected abstract String getResponseContentType();

    protected Message handleChannelDisconnect(CommandMessage disconnectCommand) {
        HttpFlexSession session = (HttpFlexSession)FlexContext.getFlexSession();
        FlexClient flexClient = FlexContext.getFlexClient();
        if (flexClient.isValid()) {
            String endpointId = this.getId();
            List messageClients = flexClient.getMessageClients();
            Iterator iter = messageClients.iterator();
            while (iter.hasNext()) {
                MessageClient messageClient = (MessageClient)iter.next();
                if (!messageClient.getEndpointId().equals(endpointId)) continue;
                messageClient.setClientChannelDisconnected(true);
                messageClient.invalidate();
            }
        }
        if (session.isValid() && this.isInvalidateSessionOnDisconnect()) {
            session.invalidate(false);
        }
        return super.handleChannelDisconnect(disconnectCommand);
    }

    protected void validateEndpointProtocol() {
        if (this.isSecure() && !this.url.startsWith("https:")) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11100, new Object[]{this.url, "https"});
            throw ce;
        }
    }
}

