/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

public class UserAgentSettings {
    public static final String GENERIC_MSIE_USER_AGENT = "MSIE";
    public static final int MSIE_KICKSTART_BYTES = 2048;
    public static final String GENERIC_FIREFOX_USER_AGENT = "Firefox";
    public static final int FIREFOX_KICKSTART_BYTES = 0;
    public static final int DEFAULT_MAX_STREAMING_CONNECTIONS_PER_SESSION = 1;
    private String matchOn;
    private int kickstartBytes;
    private int maxStreamingConnectionsPerSession = 1;

    public static UserAgentSettings getAgent(String matchOn) {
        UserAgentSettings userAgent = new UserAgentSettings();
        userAgent.setMatchOn(matchOn);
        userAgent.setMaxStreamingConnectionsPerSession(1);
        if (GENERIC_MSIE_USER_AGENT.equals(matchOn)) {
            userAgent.setKickstartBytes(2048);
        } else if (GENERIC_FIREFOX_USER_AGENT.equals(matchOn)) {
            userAgent.setKickstartBytes(0);
        }
        return userAgent;
    }

    public String getMatchOn() {
        return this.matchOn;
    }

    public void setMatchOn(String matchOn) {
        this.matchOn = matchOn;
    }

    public int getKickstartBytes() {
        return this.kickstartBytes;
    }

    public void setKickstartBytes(int kickstartBytes) {
        if (kickstartBytes < 0) {
            kickstartBytes = 0;
        }
        this.kickstartBytes = kickstartBytes;
    }

    public int getMaxStreamingConnectionsPerSession() {
        return this.maxStreamingConnectionsPerSession;
    }

    public void setMaxStreamingConnectionsPerSession(int maxStreamingConnectionsPerSession) {
        this.maxStreamingConnectionsPerSession = maxStreamingConnectionsPerSession;
    }
}

