/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.MessageClient;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlushResult;
import flex.messaging.config.ConfigMap;
import flex.messaging.messages.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FlexClientOutboundQueueProcessor {
    private FlexClient client;
    private String endpointId;

    public void setEndpointId(String value) {
        this.endpointId = value;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setFlexClient(FlexClient value) {
        this.client = value;
    }

    public FlexClient getFlexClient() {
        return this.client;
    }

    public void initialize(ConfigMap properties) {
    }

    public void add(List outboundQueue, Message message) {
        outboundQueue.add(message);
    }

    public FlushResult flush(List outboundQueue) {
        FlushResult flushResult = new FlushResult();
        ArrayList<Message> messagesToFlush = new ArrayList<Message>();
        Iterator iter = outboundQueue.iterator();
        while (iter.hasNext()) {
            Message message = (Message)iter.next();
            if (this.isMessageExpired(message)) continue;
            messagesToFlush.add(message);
        }
        flushResult.setMessages(messagesToFlush);
        outboundQueue.clear();
        return flushResult;
    }

    public FlushResult flush(MessageClient client, List outboundQueue) {
        FlushResult flushResult = new FlushResult();
        ArrayList<Message> messagesForClient = new ArrayList<Message>();
        Message message = null;
        Iterator iter = outboundQueue.iterator();
        while (iter.hasNext()) {
            message = (Message)iter.next();
            if (!message.getClientId().equals(client.getClientId())) continue;
            iter.remove();
            if (this.isMessageExpired(message)) continue;
            messagesForClient.add(message);
        }
        flushResult.setMessages(messagesForClient);
        return flushResult;
    }

    public boolean isMessageExpired(Message message) {
        return message.getTimeToLive() > 0L && System.currentTimeMillis() - message.getTimestamp() >= message.getTimeToLive();
    }
}

