/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.services.ServiceControl;
import flex.messaging.FlexContext;
import flex.messaging.MessageBroker;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.NetworkSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.log.Log;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Destination
extends ManageableComponent
implements Serializable {
    static final long serialVersionUID = -977001797620881435L;
    public static final String LOG_CATEGORY = "Service.General";
    private static final int NO_SERVICE = 11117;
    protected ServiceAdapter adapter;
    protected List channelIds;
    protected NetworkSettings networkSettings = new NetworkSettings();
    protected SecurityConstraint securityConstraint;
    protected String securityConstraintRef;
    protected HashMap extraProperties;

    public Destination() {
        this(false);
    }

    public Destination(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id, ConfigMap properties) {
        ConfigMap clusterInfo;
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        ConfigMap network = properties.getPropertyAsMap("network", null);
        if (network != null && (clusterInfo = network.getPropertyAsMap("cluster", null)) != null) {
            network.allowProperty("cluster");
            clusterInfo.allowProperty("ref");
            clusterInfo.allowProperty("shared-backend");
            String clusterId = clusterInfo.getPropertyAsString("ref", null);
            String coordinatorPolicy = clusterInfo.getPropertyAsString("shared-backend", null);
            if (coordinatorPolicy != null) {
                this.networkSettings.setSharedBackend(Boolean.valueOf(coordinatorPolicy));
            }
            this.networkSettings.setClusterId(clusterId);
        }
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.getAdapter() == null) {
            String defaultAdapterId = this.getService().getDefaultAdapter();
            if (defaultAdapterId != null) {
                this.createAdapter(defaultAdapterId);
            } else {
                this.invalidate();
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10127, new Object[]{this.getId()});
                throw ex;
            }
        }
        if (this.channelIds != null) {
            List brokerChannelIds = this.getService().getMessageBroker().getChannelIds();
            Iterator iter = this.channelIds.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (brokerChannelIds != null && brokerChannelIds.contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Removing the channel.", new Object[]{id});
            }
        }
        if (this.channelIds == null) {
            List defaultChannelIds = this.getService().getDefaultChannels();
            if (defaultChannelIds != null && defaultChannelIds.size() > 0) {
                this.setChannels(defaultChannelIds);
            } else {
                this.invalidate();
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10123, new Object[]{this.getId()});
                throw ex;
            }
        }
        MessageBroker broker = this.getService().getMessageBroker();
        if (this.securityConstraint == null && this.securityConstraintRef != null) {
            this.securityConstraint = broker.getSecurityConstraint(this.securityConstraintRef);
        }
        ClusterManager cm = broker.getClusterManager();
        if (this.getNetworkSettings().getClusterId() != null || cm.getDefaultClusterId() != null) {
            cm.clusterDestination(this);
        }
    }

    public void start() {
        if (this.isStarted()) {
            this.getAdapter().start();
            return;
        }
        Service service = this.getService();
        if (!service.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Destination with id '{0}' cannot be started when its Service with id '{1}' is not started.", new Object[]{this.getId(), service.getId()});
            }
            return;
        }
        if (this.isManaged() && service.isManaged()) {
            this.setupDestinationControl(service);
            ServiceControl controller = (ServiceControl)service.getControl();
            if (this.getControl() != null) {
                controller.addDestination(this.getControl().getObjectName());
            }
        }
        super.start();
        this.getAdapter().start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.getAdapter().stop();
        super.stop();
        if (this.isManaged() && this.getService().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public ServiceAdapter getAdapter() {
        return this.adapter;
    }

    public ServiceAdapter createAdapter(String id) {
        if (this.getService() == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11117, new Object[]{id});
            throw ex;
        }
        Map adapterClasses = this.getService().getRegisteredAdapters();
        if (!adapterClasses.containsKey(id)) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11114, new Object[]{id, this.getService().getId()});
            throw ex;
        }
        String adapterClassName = (String)adapterClasses.get(id);
        Class adapterClass = ClassUtil.createClass(adapterClassName, FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader());
        ServiceAdapter adapter = (ServiceAdapter)ClassUtil.createDefaultInstance(adapterClass, ServiceAdapter.class);
        adapter.setId(id);
        adapter.setManaged(this.isManaged());
        adapter.setDestination(this);
        return adapter;
    }

    public void setAdapter(ServiceAdapter adapter) {
        if (this.getAdapter() == adapter) {
            return;
        }
        if (adapter == null) {
            this.removeAdapter();
            return;
        }
        this.addAdapter(adapter);
    }

    private void addAdapter(ServiceAdapter adapter) {
        this.removeAdapter();
        this.adapter = adapter;
        if (adapter.getDestination() == null || adapter.getDestination() != this) {
            adapter.setDestination(this);
        }
    }

    private void removeAdapter() {
        ServiceAdapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.stop();
        }
        this.adapter = null;
    }

    public boolean isBackendShared() {
        if (!this.isStarted()) {
            return false;
        }
        ClusterManager clm = this.getService().getMessageBroker().getClusterManager();
        boolean backendShared = clm.isBackendShared(this.getService().getClass().getName(), this.getId());
        return backendShared;
    }

    public List getChannels() {
        return this.channelIds;
    }

    public void addChannel(String id) {
        List brokerChannelIds;
        if (this.channelIds == null) {
            this.channelIds = new ArrayList();
        } else if (this.channelIds.contains(id)) {
            return;
        }
        if (this.isStarted() && ((brokerChannelIds = this.getService().getMessageBroker().getChannelIds()) == null || !brokerChannelIds.contains(id))) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
            return;
        }
        this.channelIds.add(id);
    }

    public boolean removeChannel(String id) {
        if (this.channelIds == null) {
            return false;
        }
        return this.channelIds.remove(id);
    }

    public void setChannels(List ids) {
        if (ids != null && this.isStarted()) {
            List brokerChannelIds = this.getService().getMessageBroker().getChannelIds();
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (brokerChannelIds != null && brokerChannelIds.contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
        }
        this.channelIds = ids;
    }

    public boolean isClustered() {
        if (!this.isStarted()) {
            return false;
        }
        ClusterManager clm = this.getService().getMessageBroker().getClusterManager();
        boolean clusterReplicated = clm.isDestinationClustered(this.getService().getClass().getName(), this.getId());
        return clusterReplicated;
    }

    public void setId(String id) {
        String oldId = this.getId();
        super.setId(id);
        Service service = this.getService();
        if (service != null) {
            service.getMessageBroker().unregisterDestination(oldId);
            service.getDestinations().remove(oldId);
            service.getMessageBroker().registerDestination(id, service.getId());
            service.getDestinations().put(id, this);
        }
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public void setNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public Service getService() {
        return (Service)this.getParent();
    }

    public void setService(Service service) {
        Service oldService = this.getService();
        this.setParent(service);
        if (oldService != null) {
            oldService.removeDestination(this.getId());
        }
        if (service.getDestination(this.getId()) != this) {
            service.addDestination(this);
        }
    }

    public String getServiceType() {
        Service service = this.getService();
        if (service == null) {
            return null;
        }
        return service.getClass().getName();
    }

    public SecurityConstraint getSecurityConstraint() {
        return this.securityConstraint;
    }

    public void setSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraint = securityConstraint;
    }

    public void setSecurityConstraint(String ref) {
        if (this.isStarted()) {
            MessageBroker msgBroker = this.getService().getMessageBroker();
            this.securityConstraint = msgBroker.getSecurityConstraint(ref);
        }
        this.securityConstraintRef = ref;
    }

    public ConfigMap describeDestination() {
        ConfigMap destinationConfig = new ConfigMap();
        destinationConfig.addProperty("id", this.getId());
        ConfigMap channelsConfig = new ConfigMap();
        Iterator iter = this.channelIds.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            ConfigMap channelConfig = new ConfigMap();
            channelConfig.addProperty("ref", id);
            channelsConfig.addProperty("channel", channelConfig);
        }
        if (channelsConfig.size() > 0) {
            destinationConfig.addProperty("channels", channelsConfig);
        }
        return destinationConfig;
    }

    public void addExtraProperty(String name, Object value) {
        if (this.extraProperties == null) {
            this.extraProperties = new HashMap();
        }
        this.extraProperties.put(name, value);
    }

    public Object getExtraProperty(String name) {
        if (this.extraProperties != null) {
            return this.extraProperties.get(name);
        }
        return null;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected void setupDestinationControl(Service service) {
        this.setManaged(false);
    }
}

