/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging.services.messaging;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.messaging.SubscriptionManagerControlMBean;
import flex.messaging.MessageClient;
import flex.messaging.services.messaging.SubscriptionManager;
import java.util.Set;

public class SubscriptionManagerControl
extends BaseControl
implements SubscriptionManagerControlMBean {
    private SubscriptionManager subscriptionManager;
    private Long sessionDuration;

    public SubscriptionManagerControl(SubscriptionManager subscriptionManager, BaseControl parent) {
        super(parent);
        this.subscriptionManager = subscriptionManager;
    }

    public String getId() {
        return this.subscriptionManager.getId();
    }

    public String getType() {
        return "SubscriptionManager";
    }

    public Integer getSubscriberCount() {
        Set subscriberIds = this.subscriptionManager.getSubscriberIds();
        if (subscriberIds != null) {
            return new Integer(subscriberIds.size());
        }
        return new Integer(0);
    }

    public String[] getSubscriberIds() {
        Set subscriberIds = this.subscriptionManager.getSubscriberIds();
        if (subscriberIds != null) {
            String[] ids = new String[subscriberIds.size()];
            return subscriberIds.toArray(ids);
        }
        return new String[0];
    }

    public void removeSubscriber(String subscriberId) {
        MessageClient subscriber = this.subscriptionManager.getSubscriber(subscriberId);
        if (subscriber != null) {
            this.subscriptionManager.removeSubscriber(subscriber);
        }
    }

    public void removeAllSubscribers() {
        String[] subscriberIds = this.getSubscriberIds();
        int length = subscriberIds.length;
        for (int i = 0; i < length; ++i) {
            this.removeSubscriber(subscriberIds[i]);
        }
    }
}

