/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.NodeFactory;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.AppletTag;
import org.htmlparser.tags.BaseHrefTag;
import org.htmlparser.tags.BodyTag;
import org.htmlparser.tags.Bullet;
import org.htmlparser.tags.BulletList;
import org.htmlparser.tags.Div;
import org.htmlparser.tags.DoctypeTag;
import org.htmlparser.tags.FormTag;
import org.htmlparser.tags.FrameSetTag;
import org.htmlparser.tags.FrameTag;
import org.htmlparser.tags.HeadTag;
import org.htmlparser.tags.Html;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.InputTag;
import org.htmlparser.tags.JspTag;
import org.htmlparser.tags.LabelTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.tags.ObjectTag;
import org.htmlparser.tags.OptionTag;
import org.htmlparser.tags.ScriptTag;
import org.htmlparser.tags.SelectTag;
import org.htmlparser.tags.Span;
import org.htmlparser.tags.StyleTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.tags.TextareaTag;
import org.htmlparser.tags.TitleTag;
import org.htmlparser.util.ParserException;

public class PrototypicalNodeFactory
implements Serializable,
NodeFactory {
    protected Text mText;
    protected Remark mRemark;
    protected Tag mTag;
    protected Map mBlastocyst;

    public PrototypicalNodeFactory() {
        this(false);
    }

    public PrototypicalNodeFactory(boolean empty) {
        this.clear();
        this.mText = new TextNode(null, 0, 0);
        this.mRemark = new RemarkNode(null, 0, 0);
        this.mTag = new TagNode(null, 0, 0, null);
        if (!empty) {
            this.registerTags();
        }
    }

    public PrototypicalNodeFactory(Tag tag) {
        this(true);
        this.registerTag(tag);
    }

    public PrototypicalNodeFactory(Tag[] tags) {
        this(true);
        for (int i = 0; i < tags.length; ++i) {
            this.registerTag(tags[i]);
        }
    }

    public Tag put(String id, Tag tag) {
        return this.mBlastocyst.put(id, tag);
    }

    public Tag get(String id) {
        return (Tag)this.mBlastocyst.get(id);
    }

    public Tag remove(String id) {
        return (Tag)this.mBlastocyst.remove(id);
    }

    public void clear() {
        this.mBlastocyst = new Hashtable();
    }

    public Set getTagNames() {
        return this.mBlastocyst.keySet();
    }

    public void registerTag(Tag tag) {
        String[] ids = tag.getIds();
        for (int i = 0; i < ids.length; ++i) {
            this.put(ids[i], tag);
        }
    }

    public void unregisterTag(Tag tag) {
        String[] ids = tag.getIds();
        for (int i = 0; i < ids.length; ++i) {
            this.remove(ids[i]);
        }
    }

    public PrototypicalNodeFactory registerTags() {
        this.registerTag(new AppletTag());
        this.registerTag(new BaseHrefTag());
        this.registerTag(new Bullet());
        this.registerTag(new BulletList());
        this.registerTag(new DoctypeTag());
        this.registerTag(new FormTag());
        this.registerTag(new FrameSetTag());
        this.registerTag(new FrameTag());
        this.registerTag(new ImageTag());
        this.registerTag(new InputTag());
        this.registerTag(new JspTag());
        this.registerTag(new LabelTag());
        this.registerTag(new LinkTag());
        this.registerTag(new MetaTag());
        this.registerTag(new ObjectTag());
        this.registerTag(new OptionTag());
        this.registerTag(new ScriptTag());
        this.registerTag(new SelectTag());
        this.registerTag(new StyleTag());
        this.registerTag(new TableColumn());
        this.registerTag(new TableHeader());
        this.registerTag(new TableRow());
        this.registerTag(new TableTag());
        this.registerTag(new TextareaTag());
        this.registerTag(new TitleTag());
        this.registerTag(new Div());
        this.registerTag(new Span());
        this.registerTag(new BodyTag());
        this.registerTag(new HeadTag());
        this.registerTag(new Html());
        return this;
    }

    public Text getTextPrototype() {
        return this.mText;
    }

    public void setTextPrototype(Text text) {
        if (null == text) {
            throw new IllegalArgumentException("text prototype node cannot be null");
        }
        this.mText = text;
    }

    public Remark getRemarkPrototype() {
        return this.mRemark;
    }

    public void setRemarkPrototype(Remark remark) {
        if (null == remark) {
            throw new IllegalArgumentException("remark prototype node cannot be null");
        }
        this.mRemark = remark;
    }

    public Tag getTagPrototype() {
        return this.mTag;
    }

    public void setTagPrototype(Tag tag) {
        if (null == tag) {
            throw new IllegalArgumentException("tag prototype node cannot be null");
        }
        this.mTag = tag;
    }

    public Text createStringNode(Page page, int start, int end) {
        Text ret;
        try {
            ret = (Text)this.getTextPrototype().clone();
            ret.setPage(page);
            ret.setStartPosition(start);
            ret.setEndPosition(end);
        }
        catch (CloneNotSupportedException cnse) {
            ret = new TextNode(page, start, end);
        }
        return ret;
    }

    public Remark createRemarkNode(Page page, int start, int end) {
        Remark ret;
        try {
            ret = (Remark)this.getRemarkPrototype().clone();
            ret.setPage(page);
            ret.setStartPosition(start);
            ret.setEndPosition(end);
        }
        catch (CloneNotSupportedException cnse) {
            ret = new RemarkNode(page, start, end);
        }
        return ret;
    }

    public Tag createTagNode(Page page, int start, int end, Vector attributes) throws ParserException {
        Attribute attribute;
        String id;
        Tag ret = null;
        if (0 != attributes.size() && null != (id = (attribute = (Attribute)attributes.elementAt(0)).getName())) {
            try {
                id = id.toUpperCase(Locale.ENGLISH);
                if (!id.startsWith("/")) {
                    Tag prototype;
                    if (id.endsWith("/")) {
                        id = id.substring(0, id.length() - 1);
                    }
                    if (null != (prototype = (Tag)this.mBlastocyst.get(id))) {
                        ret = (Tag)prototype.clone();
                        ret.setPage(page);
                        ret.setStartPosition(start);
                        ret.setEndPosition(end);
                        ret.setAttributesEx(attributes);
                    }
                }
            }
            catch (CloneNotSupportedException cnse) {
                // empty catch block
            }
        }
        if (null == ret) {
            try {
                ret = (Tag)this.getTagPrototype().clone();
                ret.setPage(page);
                ret.setStartPosition(start);
                ret.setEndPosition(end);
                ret.setAttributesEx(attributes);
            }
            catch (CloneNotSupportedException cnse) {
                ret = new TagNode(page, start, end, attributes);
            }
        }
        return ret;
    }
}

