# MyScriptJS

Welcome to the [MyScript](www.myscript.com) JavaScript framework.

Learn more in the [Developer Guide](http://myscript.github.io/MyScriptJS/developer-guide/index.html) and the [API Reference](http://myscript.github.io/MyScriptJS/api-reference/index.html).

## Installation

**Browser**: Use our [CDN](https://cdnjs.com/libraries/myscript) or [Download](https://github.com/MyScript/MyScriptJS/releases/latest) the latest `myscript.js`

**Bower**: `bower install myscript`

**Node**:  `npm install myscript`	

## Getting started

This tutorial shows how to perform the recognition of a digital handwritten
sample with MyScript. It gives the main steps to follow, based on the provided [code samples](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples).

### Generate your keys

A valid MyScript Cloud account is necessary to use MyScriptJS.
To create a MyScript Cloud account, look at [MyScript Developer Portal](https://dev.myscript.com/).

1. [Login](https://cloud.myscript.com) to your Cloud account
2. Create an application
3. Generate an application and an HMAC key

Store your keys for later use.

__No handwriting recognition can be processed without these keys__.

### Follow the tutorial

- [Analyzer recognition](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples/analyzer#create-your-html5-canvas)
- [Math recognition](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples/math#create-your-html5-canvas)
- [Music recognition](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples/music#create-your-html5-canvas)
- [Shape recognition](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples/shape#create-your-html5-canvas)
- [Text recognition](https://github.com/MyScript/MyScriptJS/tree/master/resources/samples/text#create-your-html5-canvas)
