/*
 myscript - MyScriptJS is a free and open-source JavaScript library providing the easiest way to use MyScript Cloud handwriting recognition in your web app
 Version: 1.0.6
 License: Apache-2.0
 */
MyScript={},function(scope){function Point(obj){obj&&(this.x=obj.x,this.y=obj.y)}Point.prototype.getX=function(){return this.x},Point.prototype.setX=function(x){this.x=x},Point.prototype.getY=function(){return this.y},Point.prototype.setY=function(y){this.y=y},scope.Point=Point}(MyScript),function(scope){function QuadraticPoint(obj){scope.Point.call(this,obj),this.pressure=.5,this.distance=0,this.length=0,this.ux=0,this.uy=0,this.x1=0,this.x2=0,this.y1=0,this.y2=0}QuadraticPoint.prototype=new scope.Point,QuadraticPoint.prototype.constructor=QuadraticPoint,QuadraticPoint.prototype.getPressure=function(){return this.pressure},QuadraticPoint.prototype.setPressure=function(pressure){this.pressure=pressure},QuadraticPoint.prototype.getDistance=function(){return this.distance},QuadraticPoint.prototype.setDistance=function(distance){this.distance=distance},QuadraticPoint.prototype.getLength=function(){return this.length},QuadraticPoint.prototype.setLength=function(length){this.length=length},QuadraticPoint.prototype.getUx=function(){return this.ux},QuadraticPoint.prototype.setUx=function(ux){this.ux=ux},QuadraticPoint.prototype.getUy=function(){return this.uy},QuadraticPoint.prototype.setUy=function(uy){this.uy=uy},QuadraticPoint.prototype.getX1=function(){return this.x1},QuadraticPoint.prototype.setX1=function(x1){this.x1=x1},QuadraticPoint.prototype.getX2=function(){return this.x2},QuadraticPoint.prototype.setX2=function(x2){this.x2=x2},QuadraticPoint.prototype.getY1=function(){return this.y1},QuadraticPoint.prototype.setY1=function(y1){this.y1=y1},QuadraticPoint.prototype.getY2=function(){return this.y2},QuadraticPoint.prototype.setY2=function(y2){this.y2=y2},scope.QuadraticPoint=QuadraticPoint}(MyScript),function(scope){function Rectangle(obj){obj&&(this.x=obj.x,this.y=obj.y,this.width=obj.width,this.height=obj.height)}Rectangle.prototype.getX=function(){return this.x},Rectangle.prototype.setX=function(x){this.x=x},Rectangle.prototype.getY=function(){return this.y},Rectangle.prototype.setY=function(y){this.y=y},Rectangle.prototype.getTopLeftPoint=function(){var point=new scope.Point;return point.setX(this.x),point.setY(this.y),point},Rectangle.prototype.setTopLeftPoint=function(topLeftPoint){this.x=topLeftPoint.getX(),this.y=topLeftPoint.getY()},Rectangle.prototype.getWidth=function(){return this.width},Rectangle.prototype.setWidth=function(width){this.width=width},Rectangle.prototype.getHeight=function(){return this.height},Rectangle.prototype.setHeight=function(height){this.height=height},scope.Rectangle=Rectangle}(MyScript),function(scope){function InkManager(){this.writing=!1,this.strokes=[],this.currentStroke=null,this.undoRedoStack=[]}InkManager.prototype.isWriting=function(){return this.writing},InkManager.prototype.getCurrentStroke=function(){return this.currentStroke},InkManager.prototype.startInkCapture=function(x,y,t){if(this.writing)throw new Error("Stroke capture already running");this.currentStroke=new scope.Stroke,this.currentStroke.addX(x),this.currentStroke.addY(y),this.currentStroke.addT(t),this.writing=!0},InkManager.prototype.continueInkCapture=function(x,y,t){if(!this.writing)throw new Error("Missing startInkCapture");this.currentStroke.addX(x),this.currentStroke.addY(y),this.currentStroke.addT(t)},InkManager.prototype.endInkCapture=function(){if(!this.writing)throw new Error("Missing startInkCapture");this.strokes.push(this.currentStroke),this.writing=!1},InkManager.prototype.clear=function(){this.writing=!1,this.strokes=[],this.currentStroke=null,this.undoRedoStack=[]},InkManager.prototype.isEmpty=function(){return 0===this.strokes.length},InkManager.prototype.isRedoEmpty=function(){return 0===this.undoRedoStack.length},InkManager.prototype.undo=function(){this.isEmpty()||(this.undoRedoStack.push(this.strokes[this.strokes.length-1]),this.strokes.pop())},InkManager.prototype.redo=function(){this.isRedoEmpty()||(this.strokes.push(this.undoRedoStack[this.undoRedoStack.length-1]),this.undoRedoStack.pop())},InkManager.prototype.getStrokes=function(){return this.strokes},InkManager.prototype.getUndoRedoStack=function(){return this.undoRedoStack},InkManager.prototype.clearUndoRedoStack=function(){this.undoRedoStack=[]},InkManager.prototype.copy=function(strokes,index){for(index;index<this.strokes.length;index++)strokes.push(this.strokes[index])},scope.InkManager=InkManager}(MyScript),function(scope){function MathUtils(){}MathUtils.getEllipseArcRect=function(center,maxRadius,minRadius,orientation,startAngle,sweepAngle){var angle,alpha,z1,z2,z3,z4,cosAlpha,sinAlpha,n,xList,yList,i,x,y,xMin,xMax,yMin,yMax,angleStep=.02,sortFloat=function(a,b){return a-b};for(z1=z2=Math.cos(orientation),z3=z4=Math.sin(orientation),z1*=maxRadius,z2*=minRadius,z3*=maxRadius,z4*=minRadius,n=Math.abs(sweepAngle)/angleStep,xList=[],yList=[],i=0;n>=i;i++)angle=startAngle+i/n*sweepAngle,alpha=Math.atan2(Math.sin(angle)/minRadius,Math.cos(angle)/maxRadius),cosAlpha=Math.cos(alpha),sinAlpha=Math.sin(alpha),x=center.x+z1*cosAlpha-z4*sinAlpha,y=center.y+z2*sinAlpha+z3*cosAlpha,xList.push(x),yList.push(y);return xList.sort(sortFloat),yList.sort(sortFloat),xMin=xList[0],xMax=xList[xList.length-1],yMin=yList[0],yMax=yList[yList.length-1],new scope.Rectangle({x:xMin,y:yMin,width:xMax-xMin,height:yMax-yMin})},MathUtils.getLineRect=function(firstPoint,lastPoint){var xFirst=firstPoint.x,xLast=lastPoint.x,xMin=Math.min(xFirst,xLast),xMax=Math.max(xFirst,xLast),yFirst=firstPoint.y,yLast=lastPoint.y,yMin=Math.min(yFirst,yLast),yMax=Math.max(yFirst,yLast);return new scope.Rectangle({x:xMin,y:yMin,width:xMax-xMin,height:yMax-yMin})},MathUtils.getBoundingRect=function(boundingBoxes){var xList=[],yList=[];for(var i in boundingBoxes){var rectangle=boundingBoxes[i];xList.push(rectangle.getX()),xList.push(rectangle.getX()+rectangle.getWidth()),yList.push(rectangle.getY()),yList.push(rectangle.getY()+rectangle.getHeight())}var xMin=Math.min.apply(Math,xList),xMax=Math.max.apply(Math,xList),yMin=Math.min.apply(Math,yList),yMax=Math.max.apply(Math,yList);return new scope.Rectangle({x:xMin,y:yMin,width:xMax-xMin,height:yMax-yMin})},scope.MathUtils=MathUtils}(MyScript),function(scope){function AbstractWSMessage(obj){obj&&(this.type=obj.type)}AbstractWSMessage.prototype.getType=function(){return this.type},scope.AbstractWSMessage=AbstractWSMessage}(MyScript),function(scope){function AbstractComponent(){}AbstractComponent.prototype.getType=function(){return this.type},AbstractComponent.prototype.setType=function(type){if("string"!=typeof type)throw new Error("Invalid param type");this.type=type},scope.AbstractComponent=AbstractComponent}(MyScript),function(scope){function Stroke(){this.type="stroke",this.x=[],this.y=[],this.t=[]}Stroke.prototype=new scope.AbstractComponent,Stroke.prototype.constructor=Stroke,Stroke.prototype.getX=function(){return this.x},Stroke.prototype.setX=function(x){this.x=x},Stroke.prototype.addX=function(x){null!==x&&void 0!==x&&this.x.push(x)},Stroke.prototype.getY=function(){return this.y},Stroke.prototype.setY=function(y){this.y=y},Stroke.prototype.addY=function(y){null!==y&&void 0!==y&&this.y.push(y)},Stroke.prototype.getT=function(){return this.t},Stroke.prototype.setT=function(t){this.t=t},Stroke.prototype.addT=function(t){null!==t&&void 0!==t&&this.t.push(t)},Stroke.prototype.getLength=function(){return this.x.length},Stroke.prototype.getBoundingBox=function(){var boundingBox=new scope.Rectangle;return boundingBox.setX(Math.min.apply(Math,this.getX())),boundingBox.setY(Math.min.apply(Math,this.getY())),boundingBox.setWidth(Math.max.apply(Math,this.getX())-boundingBox.getX()),boundingBox.setHeight(Math.max.apply(Math,this.getY())-boundingBox.getY()),boundingBox},scope.Stroke=Stroke}(MyScript),function(scope){function CharacterInputComponent(){this.type="inputCharacter",this.alternates=[]}CharacterInputComponent.prototype=new scope.AbstractComponent,CharacterInputComponent.prototype.constructor=CharacterInputComponent,CharacterInputComponent.prototype.getAlternates=function(){return this.alternates},CharacterInputComponent.prototype.setAlternates=function(alternates){this.alternates=alternates},CharacterInputComponent.prototype.addAlternate=function(alternate){this.alternates.push(alternate)},CharacterInputComponent.prototype.getBoundingBox=function(){return this.boundingBox},CharacterInputComponent.prototype.setBoundingBox=function(boundingBox){this.boundingBox=boundingBox},scope.CharacterInputComponent=CharacterInputComponent}(MyScript),function(scope){function CharacterInputComponentAlternate(alternate,probability){this.alternate=alternate,this.probability=probability}CharacterInputComponentAlternate.prototype.getAlternate=function(){return this.alternate},CharacterInputComponentAlternate.prototype.setAlternate=function(alternate){this.alternate=alternate},CharacterInputComponentAlternate.prototype.getProbability=function(){return this.probability},CharacterInputComponentAlternate.prototype.setProbability=function(probability){this.probability=probability},scope.CharacterInputComponentAlternate=CharacterInputComponentAlternate}(MyScript),function(scope){function AbstractParameter(){}scope.AbstractParameter=AbstractParameter}(MyScript),function(scope){function AbstractRecognitionInput(){}scope.AbstractRecognitionInput=AbstractRecognitionInput}(MyScript),function(scope){function AbstractRecognitionData(){}AbstractRecognitionData.prototype.getApplicationKey=function(){return this.applicationKey},AbstractRecognitionData.prototype.setApplicationKey=function(applicationKey){this.applicationKey=applicationKey},AbstractRecognitionData.prototype.getInstanceId=function(){return this.instanceId},AbstractRecognitionData.prototype.setInstanceId=function(instanceId){this.instanceId=instanceId},AbstractRecognitionData.prototype.getHmac=function(){return this.hmac},AbstractRecognitionData.prototype.setHmac=function(hmac){this.hmac=hmac},scope.AbstractRecognitionData=AbstractRecognitionData}(MyScript),function(scope){function RecognitionLanguagesData(){}RecognitionLanguagesData.prototype=new scope.AbstractRecognitionData,RecognitionLanguagesData.prototype.constructor=RecognitionLanguagesData,RecognitionLanguagesData.prototype.getInputMode=function(){return this.inputMode},RecognitionLanguagesData.prototype.setInputMode=function(inputMode){this.inputMode=inputMode},scope.RecognitionLanguagesData=RecognitionLanguagesData}(MyScript),function(scope){function AbstractStartRequestWSMessage(obj){this.type="start",scope.AbstractWSMessage.call(this,obj)}AbstractStartRequestWSMessage.prototype=new scope.AbstractWSMessage,AbstractStartRequestWSMessage.prototype.constructor=AbstractStartRequestWSMessage,scope.AbstractStartRequestWSMessage=AbstractStartRequestWSMessage}(MyScript),function(scope){function AbstractContinueRequestWSMessage(obj){this.type="continue",scope.AbstractWSMessage.call(this,obj)}AbstractContinueRequestWSMessage.prototype=new scope.AbstractWSMessage,AbstractContinueRequestWSMessage.prototype.constructor=AbstractContinueRequestWSMessage,AbstractContinueRequestWSMessage.prototype.getInstanceId=function(){return this.instanceId},AbstractContinueRequestWSMessage.prototype.setInstanceId=function(instanceId){this.instanceId=instanceId},scope.AbstractContinueRequestWSMessage=AbstractContinueRequestWSMessage}(MyScript),function(scope){function ChallengeRequestWSMessage(obj){this.type="hmac",scope.AbstractWSMessage.call(this,obj)}ChallengeRequestWSMessage.prototype=new scope.AbstractWSMessage,ChallengeRequestWSMessage.prototype.constructor=ChallengeRequestWSMessage,ChallengeRequestWSMessage.prototype.getChallenge=function(){return this.challenge},ChallengeRequestWSMessage.prototype.setChallenge=function(challenge){this.challenge=challenge},ChallengeRequestWSMessage.prototype.getApplicationKey=function(){return this.applicationKey},ChallengeRequestWSMessage.prototype.setApplicationKey=function(applicationKey){this.applicationKey=applicationKey},ChallengeRequestWSMessage.prototype.getHmacSignature=function(){return this.hmac},ChallengeRequestWSMessage.prototype.setHmacSignature=function(hmac){this.hmac=hmac},scope.ChallengeRequestWSMessage=ChallengeRequestWSMessage}(MyScript),function(scope){function InitRequestWSMessage(obj){this.type="applicationKey",scope.AbstractWSMessage.call(this,obj)}InitRequestWSMessage.prototype=new scope.AbstractWSMessage,InitRequestWSMessage.prototype.constructor=InitRequestWSMessage,InitRequestWSMessage.prototype.getApplicationKey=function(){return this.applicationKey},InitRequestWSMessage.prototype.setApplicationKey=function(applicationKey){this.applicationKey=applicationKey},scope.InitRequestWSMessage=InitRequestWSMessage}(MyScript),function(scope){function ResetRequestWSMessage(obj){this.type="reset",scope.AbstractWSMessage.call(this,obj)}ResetRequestWSMessage.prototype=new scope.AbstractWSMessage,ResetRequestWSMessage.prototype.constructor=ResetRequestWSMessage,scope.ResetRequestWSMessage=ResetRequestWSMessage}(MyScript),function(scope){function AbstractTextInputComponent(){}AbstractTextInputComponent.prototype=new scope.AbstractComponent,AbstractTextInputComponent.prototype.constructor=AbstractTextInputComponent,AbstractTextInputComponent.prototype.getBoundingBox=function(){return this.boundingBox},AbstractTextInputComponent.prototype.setBoundingBox=function(boundingBox){this.boundingBox=boundingBox},scope.AbstractTextInputComponent=AbstractTextInputComponent}(MyScript),function(scope){function CharInputComponent(){this.type="char"}CharInputComponent.prototype=new scope.AbstractTextInputComponent,CharInputComponent.prototype.constructor=CharInputComponent,CharInputComponent.prototype.getCharacter=function(){return this.character},CharInputComponent.prototype.setCharacter=function(character){this.character=character},scope.CharInputComponent=CharInputComponent}(MyScript),function(scope){function StringInputComponent(){this.type="string"}StringInputComponent.prototype=new scope.AbstractTextInputComponent,StringInputComponent.prototype.constructor=StringInputComponent,StringInputComponent.prototype.getString=function(){return this.string},StringInputComponent.prototype.setString=function(string){this.string=string},scope.StringInputComponent=StringInputComponent}(MyScript),function(scope){function TextInputUnit(){this.textInputType="MULTI_LINE_TEXT",this.components=[]}TextInputUnit.prototype.getInputType=function(){return this.textInputType},TextInputUnit.prototype.setInputType=function(inputType){this.textInputType=inputType},TextInputUnit.prototype.getComponents=function(inkRange){return inkRange&&inkRange instanceof scope.TextInkRange?this.components.slice(inkRange.getStartComponent(),inkRange.getEndComponent()+1):this.components},TextInputUnit.prototype.setComponents=function(components){this.components=components},scope.TextInputUnit=TextInputUnit}(MyScript),function(scope){function TextParameter(obj){scope.AbstractParameter.call(this,obj)}TextParameter.prototype=new scope.AbstractParameter,TextParameter.prototype.constructor=TextParameter,TextParameter.prototype.getLanguage=function(){return this.language},TextParameter.prototype.setLanguage=function(language){this.language=language},TextParameter.prototype.getInputMode=function(){return this.textInputMode},TextParameter.prototype.setInputMode=function(inputMode){this.textInputMode=inputMode},TextParameter.prototype.getContentTypes=function(){return this.contentTypes},TextParameter.prototype.setContentTypes=function(contentTypes){this.contentTypes=contentTypes},TextParameter.prototype.getSubsetKnowledges=function(){return this.subsetKnowledges},TextParameter.prototype.setSubsetKnowledges=function(subsetKnowledges){this.subsetKnowledges=subsetKnowledges},TextParameter.prototype.getUserResources=function(){return this.userResources},TextParameter.prototype.setUserResources=function(userResources){this.userResources=userResources},TextParameter.prototype.getUserLkWords=function(){return this.userLkWords},TextParameter.prototype.setUserLkWords=function(userLkWords){this.userLkWords=userLkWords},TextParameter.prototype.getResultDetail=function(){return this.resultDetail},TextParameter.prototype.setResultDetail=function(resultDetail){this.resultDetail=resultDetail},TextParameter.prototype.getTextProperties=function(){return this.textProperties},TextParameter.prototype.setTextProperties=function(textProperties){this.textProperties=textProperties},scope.TextParameter=TextParameter}(MyScript),function(scope){function TextProperties(){}TextProperties.prototype.getTextCandidateListSize=function(){return this.textCandidateListSize},TextProperties.prototype.setTextCandidateListSize=function(textCandidateListSize){this.textCandidateListSize=textCandidateListSize},TextProperties.prototype.getWordCandidateListSize=function(){return this.wordCandidateListSize},TextProperties.prototype.setWordCandidateListSize=function(wordCandidateListSize){this.wordCandidateListSize=wordCandidateListSize},TextProperties.prototype.getWordPredictionListSize=function(){return this.wordPredictionListSize},TextProperties.prototype.setWordPredictionListSize=function(wordPredictionListSize){this.wordPredictionListSize=wordPredictionListSize},TextProperties.prototype.getWordCompletionListSize=function(){return this.wordCompletionListSize},TextProperties.prototype.setWordCompletionListSize=function(wordCompletionListSize){this.wordCompletionListSize=wordCompletionListSize},TextProperties.prototype.getCharacterCandidateListSize=function(){return this.characterCandidateListSize},TextProperties.prototype.setCharacterCandidateListSize=function(characterCandidateListSize){this.characterCandidateListSize=characterCandidateListSize},TextProperties.prototype.getDiscardCaseVariations=function(){return this.discardCaseVariations},TextProperties.prototype.setDiscardCaseVariations=function(discardCaseVariations){this.discardCaseVariations=discardCaseVariations},TextProperties.prototype.getDiscardAccentuationVariations=function(){return this.discardAccentuationVariations},TextProperties.prototype.setDiscardAccentuationVariations=function(discardAccentuationVariations){this.discardAccentuationVariations=discardAccentuationVariations},TextProperties.prototype.getDisableSpatialOrdering=function(){return this.disableSpatialOrdering},TextProperties.prototype.setDisableSpatialOrdering=function(disableSpatialOrdering){this.disableSpatialOrdering=disableSpatialOrdering},TextProperties.prototype.getGlyphDistortion=function(){return this.glyphDistortion},TextProperties.prototype.setGlyphDistortion=function(glyphDistortion){this.glyphDistortion=glyphDistortion},TextProperties.prototype.getEnableOutOfLexicon=function(){return this.enableOutOfLexicon},TextProperties.prototype.setEnableOutOfLexicon=function(enableOutOfLexicon){this.enableOutOfLexicon=enableOutOfLexicon},TextProperties.prototype.getSpellingDistortion=function(){return this.spellingDistortion},TextProperties.prototype.setSpellingDistortion=function(spellingDistortion){this.spellingDistortion=spellingDistortion},scope.TextProperties=TextProperties}(MyScript),function(scope){function TextRecognitionInput(){}TextRecognitionInput.prototype=new scope.AbstractRecognitionInput,TextRecognitionInput.prototype.constructor=TextRecognitionInput,TextRecognitionInput.prototype.getParameters=function(){return this.textParameter},TextRecognitionInput.prototype.setParameters=function(parameters){this.textParameter=parameters},TextRecognitionInput.prototype.getInputUnits=function(inkRange){return inkRange&&inkRange instanceof scope.TextInkRange?this.inputUnits.slice(inkRange.getStartUnit(),inkRange.getEndUnit()+1):this.inputUnits},TextRecognitionInput.prototype.setInputUnits=function(inputUnits){this.inputUnits=inputUnits},scope.TextRecognitionInput=TextRecognitionInput}(MyScript),function(scope){function TextRecognitionData(){}TextRecognitionData.prototype=new scope.AbstractRecognitionData,TextRecognitionData.prototype.constructor=TextRecognitionData,TextRecognitionData.prototype.getTextRecognitionInput=function(){return this.textInput},TextRecognitionData.prototype.setTextRecognitionInput=function(input){this.textInput=JSON.stringify(input)},scope.TextRecognitionData=TextRecognitionData}(MyScript),function(scope){function TextStartRequestWSMessage(obj){scope.AbstractStartRequestWSMessage.call(this,obj)}TextStartRequestWSMessage.prototype=new scope.AbstractStartRequestWSMessage,TextStartRequestWSMessage.prototype.constructor=TextStartRequestWSMessage,TextStartRequestWSMessage.prototype.getParameters=function(){return this.textParameter},TextStartRequestWSMessage.prototype.setParameters=function(parameters){this.textParameter=parameters},TextStartRequestWSMessage.prototype.getInputUnits=function(){return this.inputUnits},TextStartRequestWSMessage.prototype.setInputUnits=function(inputUnits){this.inputUnits=inputUnits},scope.TextStartRequestWSMessage=TextStartRequestWSMessage}(MyScript),function(scope){function TextContinueRequestWSMessage(obj){scope.AbstractContinueRequestWSMessage.call(this,obj)}TextContinueRequestWSMessage.prototype=new scope.AbstractContinueRequestWSMessage,TextContinueRequestWSMessage.prototype.constructor=TextContinueRequestWSMessage,TextContinueRequestWSMessage.prototype.getInputUnits=function(){return this.inputUnits},TextContinueRequestWSMessage.prototype.setInputUnits=function(inputUnits){this.inputUnits=inputUnits},scope.TextContinueRequestWSMessage=TextContinueRequestWSMessage}(MyScript),function(scope){function ShapeParameter(obj){scope.AbstractParameter.call(this,obj)}ShapeParameter.prototype=new scope.AbstractParameter,ShapeParameter.prototype.constructor=ShapeParameter,ShapeParameter.prototype.getRejectDetectionSensitivity=function(){return this.rejectDetectionSensitivity},ShapeParameter.prototype.setRejectDetectionSensitivity=function(rejectDetectionSensitivity){this.rejectDetectionSensitivity=rejectDetectionSensitivity},ShapeParameter.prototype.hasBeautification=function(){return this.doBeautification},ShapeParameter.prototype.setBeautification=function(doBeautification){this.doBeautification=doBeautification},ShapeParameter.prototype.getUserResources=function(){return this.userResources},ShapeParameter.prototype.setUserResources=function(userResources){this.userResources=userResources},scope.ShapeParameter=ShapeParameter}(MyScript),function(scope){function ShapeRecognitionInput(){}ShapeRecognitionInput.prototype=new scope.AbstractRecognitionInput,ShapeRecognitionInput.prototype.constructor=ShapeRecognitionInput,ShapeRecognitionInput.prototype.getComponents=function(){return this.components},ShapeRecognitionInput.prototype.setComponents=function(components){this.components=components},ShapeRecognitionInput.prototype.getDoBeautification=function(){return this.doBeautification},ShapeRecognitionInput.prototype.setDoBeautification=function(doBeautification){this.doBeautification=doBeautification},ShapeRecognitionInput.prototype.getRejectDetectionSensitivity=function(){return this.rejectDetectionSensitivity},ShapeRecognitionInput.prototype.setRejectDetectionSensitivity=function(rejectDetectionSensitivity){this.rejectDetectionSensitivity=rejectDetectionSensitivity},scope.ShapeRecognitionInput=ShapeRecognitionInput}(MyScript),function(scope){function ShapeRecognitionData(){}ShapeRecognitionData.prototype=new scope.AbstractRecognitionData,ShapeRecognitionData.prototype.constructor=ShapeRecognitionData,ShapeRecognitionData.prototype.getShapeRecognitionInput=function(){return this.shapeInput},ShapeRecognitionData.prototype.setShapeRecognitionInput=function(input){this.shapeInput=JSON.stringify(input)},scope.ShapeRecognitionData=ShapeRecognitionData}(MyScript),function(scope){function MathParameter(obj){scope.AbstractParameter.call(this,obj),this.resultTypes=[],this.userResources=[]}MathParameter.prototype=new scope.AbstractParameter,MathParameter.prototype.constructor=MathParameter,MathParameter.prototype.getResultTypes=function(){return this.resultTypes},MathParameter.prototype.setResultTypes=function(resultTypes){this.resultTypes=resultTypes},MathParameter.prototype.isColumnar=function(){return this.columnarOperation},MathParameter.prototype.setColumnar=function(columnar){this.columnarOperation=columnar},MathParameter.prototype.getUserResources=function(){return this.userResources},MathParameter.prototype.setUserResources=function(userResources){this.userResources=userResources},MathParameter.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},MathParameter.prototype.setScratchOutDetectionSensitivity=function(scratchOutDetectionSensitivity){this.scratchOutDetectionSensitivity=scratchOutDetectionSensitivity},scope.MathParameter=MathParameter}(MyScript),function(scope){function MathRecognitionInput(){}MathRecognitionInput.prototype=new scope.AbstractRecognitionInput,MathRecognitionInput.prototype.constructor=MathRecognitionInput,MathRecognitionInput.prototype.getComponents=function(){return this.components},MathRecognitionInput.prototype.setComponents=function(components){this.components=components},MathRecognitionInput.prototype.getResultTypes=function(){return this.resultTypes},MathRecognitionInput.prototype.setResultTypes=function(resultTypes){this.resultTypes=resultTypes},MathRecognitionInput.prototype.isColumnar=function(){return this.columnarOperation},MathRecognitionInput.prototype.setColumnar=function(columnar){this.columnarOperation=columnar},MathRecognitionInput.prototype.getUserResources=function(){return this.userResources},MathRecognitionInput.prototype.setUserResources=function(userResources){this.userResources=userResources},MathRecognitionInput.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},MathRecognitionInput.prototype.setScratchOutDetectionSensitivity=function(scratchOutDetectionSensitivity){this.scratchOutDetectionSensitivity=scratchOutDetectionSensitivity},scope.MathRecognitionInput=MathRecognitionInput}(MyScript),function(scope){function MathRecognitionData(){}MathRecognitionData.prototype=new scope.AbstractRecognitionData,MathRecognitionData.prototype.constructor=MathRecognitionData,MathRecognitionData.prototype.getMathRecognitionInput=function(){return this.mathInput},MathRecognitionData.prototype.setMathRecognitionInput=function(input){this.mathInput=JSON.stringify(input)},scope.MathRecognitionData=MathRecognitionData}(MyScript),function(scope){function MathStartRequestWSMessage(obj){scope.AbstractStartRequestWSMessage.call(this,obj)}MathStartRequestWSMessage.prototype=new scope.AbstractStartRequestWSMessage,MathStartRequestWSMessage.prototype.constructor=MathStartRequestWSMessage,MathStartRequestWSMessage.prototype.getParameters=function(){return this.parameters},MathStartRequestWSMessage.prototype.setParameters=function(parameters){this.parameters=parameters},MathStartRequestWSMessage.prototype.getComponents=function(){return this.components},MathStartRequestWSMessage.prototype.setComponents=function(components){this.components=components},scope.MathStartRequestWSMessage=MathStartRequestWSMessage}(MyScript),function(scope){function MathContinueRequestWSMessage(obj){this.type="continue",scope.AbstractContinueRequestWSMessage.call(this,obj)}MathContinueRequestWSMessage.prototype=new scope.AbstractContinueRequestWSMessage,MathContinueRequestWSMessage.prototype.constructor=MathContinueRequestWSMessage,MathContinueRequestWSMessage.prototype.getComponents=function(){return this.components},MathContinueRequestWSMessage.prototype.setComponents=function(components){this.components=components},scope.MathContinueRequestWSMessage=MathContinueRequestWSMessage}(MyScript),function(scope){function AbstractMusicInputComponent(){}AbstractMusicInputComponent.prototype=new scope.AbstractComponent,AbstractMusicInputComponent.prototype.constructor=AbstractMusicInputComponent,AbstractMusicInputComponent.prototype.getBoundingBox=function(){return this.boundingBox},AbstractMusicInputComponent.prototype.setBoundingBox=function(boundingBox){this.boundingBox=boundingBox},scope.AbstractMusicInputComponent=AbstractMusicInputComponent}(MyScript),function(scope){function MusicAccidentalInputComponent(){this.type="accidental"}MusicAccidentalInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicAccidentalInputComponent.prototype.constructor=MusicAccidentalInputComponent,MusicAccidentalInputComponent.prototype.getValue=function(){return this.value},MusicAccidentalInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicAccidentalInputComponent=MusicAccidentalInputComponent}(MyScript),function(scope){function MusicArpeggiateInputComponent(){this.type="arpeggiate"}MusicArpeggiateInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicArpeggiateInputComponent.prototype.constructor=MusicArpeggiateInputComponent,MusicArpeggiateInputComponent.prototype.getValue=function(){return this.value},MusicArpeggiateInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicArpeggiateInputComponent=MusicArpeggiateInputComponent}(MyScript),function(scope){function MusicBarInput(){}MusicBarInput.prototype.getRepeatDirection=function(){return this.repeatDirection},MusicBarInput.prototype.setRepeatDirection=function(repeatDirection){this.repeatDirection=repeatDirection},MusicBarInput.prototype.getStyle=function(){return this.style},MusicBarInput.prototype.setStyle=function(style){this.style=style},scope.MusicBarInput=MusicBarInput}(MyScript),function(scope){function MusicBarInputComponent(){this.type="bar",this.value=new scope.MusicBarInput}MusicBarInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicBarInputComponent.prototype.constructor=MusicBarInputComponent,MusicBarInputComponent.prototype.getValue=function(){return this.value},MusicBarInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicBarInputComponent=MusicBarInputComponent}(MyScript),function(scope){function MusicBeamInput(){}MusicBeamInput.prototype.getPlacement=function(){return this.placement},MusicBeamInput.prototype.setPlacement=function(placement){this.placement=placement},MusicBeamInput.prototype.getSlope=function(){return this.slope},MusicBeamInput.prototype.setSlope=function(slope){this.slope=slope},MusicBeamInput.prototype.getLeftCount=function(){return this.leftCount},MusicBeamInput.prototype.setLeftCount=function(leftCount){this.leftCount=leftCount},MusicBeamInput.prototype.getRightCount=function(){return this.rightCount},MusicBeamInput.prototype.setRightCount=function(rightCount){this.rightCount=rightCount},MusicBeamInput.prototype.getGap=function(){return this.gap},MusicBeamInput.prototype.setGap=function(gap){this.gap=gap},scope.MusicBeamInput=MusicBeamInput}(MyScript),function(scope){function MusicBeamInputComponent(){this.type="beam",this.value=new scope.MusicBeamInput}MusicBeamInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicBeamInputComponent.prototype.constructor=MusicBeamInputComponent,MusicBeamInputComponent.prototype.getValue=function(){return this.value},MusicBeamInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicBeamInputComponent=MusicBeamInputComponent}(MyScript),function(scope){function MusicClefInput(){this.symbol="G",this.octave=0}MusicClefInput.prototype.getYAnchor=function(){return this.yAnchor},MusicClefInput.prototype.setYAnchor=function(yAnchor){this.yAnchor=yAnchor},MusicClefInput.prototype.getOctave=function(){return this.octave},MusicClefInput.prototype.setOctave=function(octave){this.octave=octave},MusicClefInput.prototype.getSymbol=function(){return this.symbol},MusicClefInput.prototype.setSymbol=function(symbol){this.symbol=symbol},scope.MusicClefInput=MusicClefInput}(MyScript),function(scope){function MusicClefInputComponent(){this.type="clef",this.value=new scope.MusicClefInput}MusicClefInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicClefInputComponent.prototype.constructor=MusicClefInputComponent,
MusicClefInputComponent.prototype.getValue=function(){return this.value},MusicClefInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicClefInputComponent=MusicClefInputComponent}(MyScript),function(scope){function MusicDecorationInput(){}MusicDecorationInput.prototype.getSymbol=function(){return this.symbol},MusicDecorationInput.prototype.setSymbol=function(symbol){this.symbol=symbol},MusicDecorationInput.prototype.getPlacement=function(){return this.placement},MusicDecorationInput.prototype.setPlacement=function(placement){this.placement=placement},scope.MusicDecorationInput=MusicDecorationInput}(MyScript),function(scope){function MusicDecorationInputComponent(){this.type="decoration",this.value=new scope.MusicDecorationInput}MusicDecorationInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicDecorationInputComponent.prototype.constructor=MusicDecorationInputComponent,MusicDecorationInputComponent.prototype.getValue=function(){return this.value},MusicDecorationInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicDecorationInputComponent=MusicDecorationInputComponent}(MyScript),function(scope){function MusicDotsInputComponent(){this.type="dots"}MusicDotsInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicDotsInputComponent.prototype.constructor=MusicDotsInputComponent,MusicDotsInputComponent.prototype.getValue=function(){return this.value},MusicDotsInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicDotsInputComponent=MusicDotsInputComponent}(MyScript),function(scope){function MusicHeadInputComponent(){this.type="head"}MusicHeadInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicHeadInputComponent.prototype.constructor=MusicHeadInputComponent,MusicHeadInputComponent.prototype.getValue=function(){return this.value},MusicHeadInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicHeadInputComponent=MusicHeadInputComponent}(MyScript),function(scope){function MusicLedgerLineInputComponent(){this.type="ledgerLine"}MusicLedgerLineInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicLedgerLineInputComponent.prototype.constructor=MusicLedgerLineInputComponent,scope.MusicLedgerLineInputComponent=MusicLedgerLineInputComponent}(MyScript),function(scope){function MusicRestInputComponent(){this.type="rest"}MusicRestInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicRestInputComponent.prototype.constructor=MusicRestInputComponent,MusicRestInputComponent.prototype.getValue=function(){return this.value},MusicRestInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicRestInputComponent=MusicRestInputComponent}(MyScript),function(scope){function MusicStemInputComponent(){this.type="stem"}MusicStemInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicStemInputComponent.prototype.constructor=MusicStemInputComponent,MusicStemInputComponent.prototype.getValue=function(){return this.value},MusicStemInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicStemInputComponent=MusicStemInputComponent}(MyScript),function(scope){function MusicTieOrSlurInputComponent(){this.type="tieOrSlur"}MusicTieOrSlurInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicTieOrSlurInputComponent.prototype.constructor=MusicTieOrSlurInputComponent,MusicTieOrSlurInputComponent.prototype.getValue=function(){return this.value},MusicTieOrSlurInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicTieOrSlurInputComponent=MusicTieOrSlurInputComponent}(MyScript),function(scope){function MusicTimeSignatureInputComponent(){this.type="timeSignature"}MusicTimeSignatureInputComponent.prototype=new scope.AbstractMusicInputComponent,MusicTimeSignatureInputComponent.prototype.constructor=MusicTimeSignatureInputComponent,MusicTimeSignatureInputComponent.prototype.getValue=function(){return this.value},MusicTimeSignatureInputComponent.prototype.setValue=function(value){this.value=value},scope.MusicTimeSignatureInputComponent=MusicTimeSignatureInputComponent}(MyScript),function(scope){function MusicStaff(){this.count=5,this.gap=20}MusicStaff.prototype.getCount=function(){return this.count},MusicStaff.prototype.setCount=function(count){this.count=count},MusicStaff.prototype.getTop=function(){return this.top},MusicStaff.prototype.setTop=function(top){this.top=top},MusicStaff.prototype.getGap=function(){return this.gap},MusicStaff.prototype.setGap=function(gap){this.gap=gap},scope.MusicStaff=MusicStaff}(MyScript),function(scope){function MusicParameter(obj){scope.AbstractParameter.call(this,obj),this.resultTypes=[],this.userResources=[]}MusicParameter.prototype=new scope.AbstractParameter,MusicParameter.prototype.constructor=MusicParameter,MusicParameter.prototype.getResultTypes=function(){return this.resultTypes},MusicParameter.prototype.setResultTypes=function(resultTypes){this.resultTypes=resultTypes},MusicParameter.prototype.getUserResources=function(){return this.userResources},MusicParameter.prototype.setUserResources=function(userResources){this.userResources=userResources},MusicParameter.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},MusicParameter.prototype.setScratchOutDetectionSensitivity=function(scratchOutDetectionSensitivity){this.scratchOutDetectionSensitivity=scratchOutDetectionSensitivity},MusicParameter.prototype.getStaff=function(){return this.staff},MusicParameter.prototype.setStaff=function(staff){this.staff=staff},MusicParameter.prototype.getDivisions=function(){return this.divisions},MusicParameter.prototype.setDivisions=function(divisions){this.divisions=divisions},scope.MusicParameter=MusicParameter}(MyScript),function(scope){function MusicRecognitionInput(){}MusicRecognitionInput.prototype=new scope.AbstractRecognitionInput,MusicRecognitionInput.prototype.constructor=MusicRecognitionInput,MusicRecognitionInput.prototype.getComponents=function(){return this.components},MusicRecognitionInput.prototype.setComponents=function(components){this.components=components},MusicRecognitionInput.prototype.getResultTypes=function(){return this.resultTypes},MusicRecognitionInput.prototype.setResultTypes=function(resultTypes){this.resultTypes=resultTypes},MusicRecognitionInput.prototype.getUserResources=function(){return this.userResources},MusicRecognitionInput.prototype.setUserResources=function(userResources){this.userResources=userResources},MusicRecognitionInput.prototype.getScratchOutDetectionSensitivity=function(){return this.scratchOutDetectionSensitivity},MusicRecognitionInput.prototype.setScratchOutDetectionSensitivity=function(scratchOutDetectionSensitivity){this.scratchOutDetectionSensitivity=scratchOutDetectionSensitivity},MusicRecognitionInput.prototype.getStaff=function(){return this.staff},MusicRecognitionInput.prototype.setStaff=function(staff){this.staff=staff},MusicRecognitionInput.prototype.getDivisions=function(){return this.divisions},MusicRecognitionInput.prototype.setDivisions=function(divisions){this.divisions=divisions},scope.MusicRecognitionInput=MusicRecognitionInput}(MyScript),function(scope){function MusicRecognitionData(){}MusicRecognitionData.prototype=new scope.AbstractRecognitionData,MusicRecognitionData.prototype.constructor=MusicRecognitionData,MusicRecognitionData.prototype.getMusicRecognitionInput=function(){return this.musicInput},MusicRecognitionData.prototype.setMusicRecognitionInput=function(input){this.musicInput=JSON.stringify(input)},scope.MusicRecognitionData=MusicRecognitionData}(MyScript),function(scope){function AnalyzerParameter(obj){scope.AbstractParameter.call(this,obj),this.textParameter=new scope.TextParameter,this.textParameter.setLanguage("en_US"),this.textParameter.setInputMode("CURSIVE")}AnalyzerParameter.prototype=new scope.AbstractParameter,AnalyzerParameter.prototype.constructor=AnalyzerParameter,AnalyzerParameter.prototype.getTextParameters=function(){return this.textParameter},AnalyzerParameter.prototype.setTextParameters=function(parameters){this.textParameter=parameters},AnalyzerParameter.prototype.getCoordinateResolution=function(){return this.coordinateResolution},AnalyzerParameter.prototype.setCoordinateResolution=function(coordinateResolution){this.coordinateResolution=coordinateResolution},scope.AnalyzerParameter=AnalyzerParameter}(MyScript),function(scope){function AnalyzerRecognitionInput(){}AnalyzerRecognitionInput.prototype=new scope.AbstractRecognitionInput,AnalyzerRecognitionInput.prototype.constructor=AnalyzerRecognitionInput,AnalyzerRecognitionInput.prototype.getParameters=function(){return this.parameter},AnalyzerRecognitionInput.prototype.setParameters=function(parameters){this.parameter=parameters},AnalyzerRecognitionInput.prototype.getComponents=function(){return this.components},AnalyzerRecognitionInput.prototype.setComponents=function(components){this.components=components},scope.AnalyzerRecognitionInput=AnalyzerRecognitionInput}(MyScript),function(scope){function AnalyzerRecognitionData(){}AnalyzerRecognitionData.prototype=new scope.AbstractRecognitionData,AnalyzerRecognitionData.prototype.constructor=AnalyzerRecognitionData,AnalyzerRecognitionData.prototype.getAnalyzerRecognitionInput=function(){return this.analyzerInput},AnalyzerRecognitionData.prototype.setAnalyzerRecognitionInput=function(input){this.analyzerInput=JSON.stringify(input)},scope.AnalyzerRecognitionData=AnalyzerRecognitionData}(MyScript),function(scope){function AbstractResult(obj){obj&&(this.instanceId=obj.instanceId)}AbstractResult.prototype.getInstanceId=function(){return this.instanceId},scope.AbstractResult=AbstractResult}(MyScript),function(scope){function AbstractRecoResponseWSMessage(obj){scope.AbstractWSMessage.call(this,obj),obj&&(this.instanceId=obj.instanceId)}AbstractRecoResponseWSMessage.prototype=new scope.AbstractWSMessage,AbstractRecoResponseWSMessage.prototype.constructor=AbstractRecoResponseWSMessage,AbstractRecoResponseWSMessage.prototype.getInstanceId=function(){return this.instanceId},scope.AbstractRecoResponseWSMessage=AbstractRecoResponseWSMessage}(MyScript),function(scope){function ChallengeResponseWSMessage(obj){scope.AbstractWSMessage.call(this,obj),obj&&(this.challenge=obj.challenge)}ChallengeResponseWSMessage.prototype=new scope.AbstractWSMessage,ChallengeResponseWSMessage.prototype.constructor=ChallengeResponseWSMessage,ChallengeResponseWSMessage.prototype.getChallenge=function(){return this.challenge},scope.ChallengeResponseWSMessage=ChallengeResponseWSMessage}(MyScript),function(scope){function ErrorResponseWSMessage(obj){scope.AbstractWSMessage.call(this,obj),obj&&(this.error=obj.error)}ErrorResponseWSMessage.prototype=new scope.AbstractWSMessage,ErrorResponseWSMessage.prototype.constructor=ErrorResponseWSMessage,ErrorResponseWSMessage.prototype.getError=function(){return this.error},scope.ErrorResponseWSMessage=ErrorResponseWSMessage}(MyScript),function(scope){function InitResponseWSMessage(obj){scope.AbstractWSMessage.call(this,obj)}InitResponseWSMessage.prototype=new scope.AbstractWSMessage,InitResponseWSMessage.prototype.constructor=InitResponseWSMessage,scope.InitResponseWSMessage=InitResponseWSMessage}(MyScript),function(scope){function TextInkRange(obj){if(obj){var cpt=obj.split(/[:-]+/);this.startUnit=Number(cpt[0]),this.startComponent=Number(cpt[1]),this.startPoint=Number(cpt[2]),this.endUnit=Number(cpt[3]),this.endComponent=Number(cpt[4]),this.endPoint=Number(cpt[5])}}TextInkRange.prototype.getStartUnit=function(){return this.startUnit},TextInkRange.prototype.getEndUnit=function(){return this.endUnit},TextInkRange.prototype.getStartComponent=function(){return this.startComponent},TextInkRange.prototype.getEndComponent=function(){return this.endComponent},TextInkRange.prototype.getStartPoint=function(){return this.startPoint},TextInkRange.prototype.getEndPoint=function(){return this.endPoint},scope.TextInkRange=TextInkRange}(MyScript),function(scope){function TextCandidate(obj){if(this.flags=[],obj){this.label=obj.label,this.normalizedScore=obj.normalizedScore,this.spellingDistortionRatio=obj.spellingDistortionRatio;for(var j in obj.flags)this.flags.push(obj.flags[j])}}TextCandidate.prototype.getLabel=function(){return this.label},TextCandidate.prototype.getNormalizedScore=function(){return this.normalizedScore},TextCandidate.prototype.getResemblanceScore=function(){return this.resemblanceScore},TextCandidate.prototype.getSpellingDistortionRatio=function(){return this.spellingDistortionRatio},TextCandidate.prototype.getFlags=function(){return this.flags},scope.TextCandidate=TextCandidate}(MyScript),function(scope){function TextCharCandidate(obj){scope.TextCandidate.call(this,obj)}TextCharCandidate.prototype=new scope.TextCandidate,TextCharCandidate.prototype.constructor=TextCharCandidate,scope.TextCharCandidate=TextCharCandidate}(MyScript),function(scope){function TextWordCandidate(obj){if(scope.TextCandidate.call(this,obj),this.children=[],obj)for(var i in obj.children)this.children.push(new scope.TextCharSegment(obj.children[i]))}TextWordCandidate.prototype=new scope.TextCandidate,TextWordCandidate.prototype.constructor=TextWordCandidate,TextWordCandidate.prototype.getChildren=function(){return this.children},scope.TextWordCandidate=TextWordCandidate}(MyScript),function(scope){function TextResultCandidate(obj){if(scope.TextCandidate.call(this,obj),this.children=[],obj)for(var i in obj.children)this.children.push(new scope.TextWordSegment(obj.children[i]))}TextResultCandidate.prototype=new scope.TextCandidate,TextResultCandidate.prototype.constructor=TextResultCandidate,TextResultCandidate.prototype.getChildren=function(){return this.children},scope.TextResultCandidate=TextResultCandidate}(MyScript),function(scope){function TextDocument(obj){if(this.tagItems=[],this.wordCandidates=[],this.charCandidates=[],obj){obj.textSegmentResult&&(this.textSegmentResult=new scope.TextResultSegment(obj.textSegmentResult));for(var i in obj.tagItems)this.tagItems.push(new scope.TextTagItem(obj.tagItems[i]));for(var j in obj.wordCandidates)this.wordCandidates.push(new scope.TextWordSegment(obj.wordCandidates[j]));for(var k in obj.charCandidates)this.charCandidates.push(new scope.TextCharSegment(obj.charCandidates[k]))}}TextDocument.prototype.getTagItems=function(){return this.tagItems},TextDocument.prototype.getWordSegments=function(){return this.wordCandidates},TextDocument.prototype.getWordSegment=function(inkRanges){for(var i=0;i<this.getWordSegments().length;i++)if(JSON.stringify(this.getWordSegments()[i].getInkRanges())===JSON.stringify(inkRanges))return this.getWordSegments()[i];return void 0},TextDocument.prototype.getCharSegments=function(){return this.charCandidates},TextDocument.prototype.getCharSegment=function(inkRanges){for(var i=0;i<this.getCharSegments().length;i++)if(JSON.stringify(this.getCharSegments()[i].getInkRanges())===JSON.stringify(inkRanges))return this.getCharSegments()[i];return void 0},TextDocument.prototype.getTextSegment=function(){return this.textSegmentResult},scope.TextDocument=TextDocument}(MyScript),function(scope){function TextResult(obj){scope.AbstractResult.call(this,obj),obj&&obj.result&&(this.result=new scope.TextDocument(obj.result))}TextResult.prototype=new scope.AbstractResult,TextResult.prototype.constructor=TextResult,TextResult.prototype.getTextDocument=function(){return this.result},scope.TextResult=TextResult}(MyScript),function(scope){function TextSegment(obj){if(this.candidates=[],this.inkRanges=[],obj&&(this.selectedCandidateIdx=obj.selectedCandidateIdx,obj.inkRanges)){var ranges=obj.inkRanges.split(/[\s]+/);for(var j in ranges)this.inkRanges.push(new scope.TextInkRange(ranges[j]))}}TextSegment.prototype.getCandidates=function(){return this.candidates},TextSegment.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidateIdx},TextSegment.prototype.getSelectedCandidate=function(){return this.candidates&&void 0!==this.selectedCandidateIdx?this.candidates[this.selectedCandidateIdx]:void 0},TextSegment.prototype.getInkRanges=function(){return this.inkRanges},scope.TextSegment=TextSegment}(MyScript),function(scope){function TextCharSegment(obj){if(scope.TextSegment.call(this,obj),obj)for(var i in obj.candidates)this.candidates.push(new scope.TextCharCandidate(obj.candidates[i]))}TextCharSegment.prototype=new scope.TextSegment,TextCharSegment.prototype.constructor=TextCharSegment,scope.TextCharSegment=TextCharSegment}(MyScript),function(scope){function TextWordSegment(obj){if(scope.TextSegment.call(this,obj),obj)for(var i in obj.candidates)this.candidates.push(new scope.TextWordCandidate(obj.candidates[i]))}TextWordSegment.prototype=new scope.TextSegment,TextWordSegment.prototype.constructor=TextWordSegment,scope.TextWordSegment=TextWordSegment}(MyScript),function(scope){function TextResultSegment(obj){if(scope.TextSegment.call(this,obj),obj)for(var i in obj.candidates)this.candidates.push(new scope.TextResultCandidate(obj.candidates[i]))}TextResultSegment.prototype=new scope.TextSegment,TextResultSegment.prototype.constructor=TextResultSegment,scope.TextResultSegment=TextResultSegment}(MyScript),function(scope){function TextTagItem(obj){if(this.inkRanges=[],obj&&(this.tagType=obj.tagType,obj.inkRanges)){var ranges=obj.inkRanges.split(/[\s]+/);for(var i in ranges)this.inkRanges.push(new scope.TextInkRange(ranges[i]))}}TextTagItem.prototype.getTagType=function(){return this.tagType},TextTagItem.prototype.getInkRanges=function(){return this.inkRanges},scope.TextTagItem=TextTagItem}(MyScript),function(scope){function TextResponseWSMessage(obj){scope.AbstractRecoResponseWSMessage.call(this,obj),obj&&obj.result&&(this.result=new scope.TextDocument(obj.result))}TextResponseWSMessage.prototype=new scope.AbstractRecoResponseWSMessage,TextResponseWSMessage.prototype.constructor=TextResponseWSMessage,TextResponseWSMessage.prototype.getTextDocument=function(){return this.result},scope.TextResponseWSMessage=TextResponseWSMessage}(MyScript),function(scope){function AbstractShapePrimitive(obj){obj&&(this.type=obj.type)}AbstractShapePrimitive.prototype.getType=function(){return this.type},AbstractShapePrimitive.prototype.isLine=function(){return"line"===this.type},AbstractShapePrimitive.prototype.isEllipse=function(){return"ellipse"===this.type},scope.AbstractShapePrimitive=AbstractShapePrimitive}(MyScript),function(scope){function AbstractDecoratedShape(obj){scope.AbstractShapePrimitive.call(this,obj),obj&&(this.beginDecoration=obj.beginDecoration,this.beginTangentAngle=obj.beginTangentAngle,this.endDecoration=obj.endDecoration,this.endTangentAngle=obj.endTangentAngle)}AbstractDecoratedShape.prototype=new scope.AbstractShapePrimitive,AbstractDecoratedShape.prototype.constructor=AbstractDecoratedShape,AbstractDecoratedShape.prototype.hasBeginDecoration=function(){return"undefined"!=typeof this.beginDecoration},AbstractDecoratedShape.prototype.hasEndDecoration=function(){return"undefined"!=typeof this.endDecoration},AbstractDecoratedShape.prototype.getBeginDecoration=function(){return this.beginDecoration},AbstractDecoratedShape.prototype.getEndDecoration=function(){return this.endDecoration},AbstractDecoratedShape.prototype.getBeginTangentAngle=function(){return this.beginTangentAngle},AbstractDecoratedShape.prototype.getEndTangentAngle=function(){return this.endTangentAngle},scope.AbstractDecoratedShape=AbstractDecoratedShape}(MyScript),function(scope){function ShapeCandidate(obj){obj&&(this.type=obj.type)}ShapeCandidate.prototype.getType=function(){return this.type},ShapeCandidate.prototype.isErased=function(){return"erased"===this.type},ShapeCandidate.prototype.isScratchOut=function(){return"scratchOut"===this.type},ShapeCandidate.prototype.isNotRecognized=function(){return"notRecognized"===this.type},ShapeCandidate.prototype.isRecognized=function(){return"recognizedShape"===this.type},scope.ShapeCandidate=ShapeCandidate}(MyScript),function(scope){function ShapeDocument(obj){if(this.segments=[],obj)for(var i in obj.segments)this.segments.push(new scope.ShapeSegment(obj.segments[i]))}ShapeDocument.prototype.getSegments=function(){return this.segments},scope.ShapeDocument=ShapeDocument}(MyScript),function(scope){function ShapeEllipse(obj){scope.AbstractDecoratedShape.call(this,obj),obj&&(this.center=new scope.Point(obj.center),this.minRadius=obj.minRadius,this.maxRadius=obj.maxRadius,this.orientation=obj.orientation,this.startAngle=obj.startAngle,this.sweepAngle=obj.sweepAngle)}ShapeEllipse.prototype=new scope.AbstractDecoratedShape,ShapeEllipse.prototype.constructor=ShapeEllipse,ShapeEllipse.prototype.getCenter=function(){return this.center},ShapeEllipse.prototype.getMinRadius=function(){return this.minRadius},ShapeEllipse.prototype.getMaxRadius=function(){return this.maxRadius},ShapeEllipse.prototype.getOrientation=function(){return this.orientation},ShapeEllipse.prototype.getStartAngle=function(){return this.startAngle},ShapeEllipse.prototype.getSweepAngle=function(){return this.sweepAngle},scope.ShapeEllipse=ShapeEllipse}(MyScript),function(scope){function ShapeErased(obj){scope.ShapeCandidate.call(this,obj)}ShapeErased.prototype=new scope.ShapeCandidate,ShapeErased.prototype.constructor=ShapeErased,scope.ShapeErased=ShapeErased}(MyScript),function(scope){function ShapeInkRange(obj){obj&&(this.firstStroke=obj.firstStroke,this.lastStroke=obj.lastStroke,this.firstPoint=obj.firstPoint,this.lastPoint=obj.lastPoint)}ShapeInkRange.prototype.getFirstStroke=function(){return this.firstStroke},ShapeInkRange.prototype.getLastStroke=function(){return this.lastStroke},ShapeInkRange.prototype.getFirstPoint=function(){return this.firstPoint},ShapeInkRange.prototype.getLastPoint=function(){return this.lastPoint},scope.ShapeInkRange=ShapeInkRange}(MyScript),function(scope){function ShapeLine(obj){scope.AbstractDecoratedShape.call(this,obj),obj&&(this.firstPoint=new scope.Point(obj.firstPoint),this.lastPoint=new scope.Point(obj.lastPoint))}ShapeLine.prototype=new scope.AbstractDecoratedShape,ShapeLine.prototype.constructor=ShapeLine,ShapeLine.prototype.getFirstPoint=function(){return this.firstPoint},ShapeLine.prototype.getLastPoint=function(){return this.lastPoint},scope.ShapeLine=ShapeLine}(MyScript),function(scope){function ShapeNotRecognized(obj){scope.ShapeCandidate.call(this,obj)}ShapeNotRecognized.prototype=new scope.ShapeCandidate,ShapeNotRecognized.prototype.constructor=ShapeNotRecognized,scope.ShapeNotRecognized=ShapeNotRecognized}(MyScript),function(scope){function ShapeRecognized(obj){if(scope.ShapeCandidate.call(this,obj),this.primitives=[],obj){this.label=obj.label,this.normalizedRecognitionScore=obj.normalizedRecognitionScore,this.resemblanceScore=obj.resemblanceScore;for(var i in obj.primitives)switch(obj.primitives[i].type){case"line":this.primitives.push(new scope.ShapeLine(obj.primitives[i]));break;case"ellipse":this.primitives.push(new scope.ShapeEllipse(obj.primitives[i]));break;default:throw new Error("Unknown shape primitive")}}}ShapeRecognized.prototype=new scope.ShapeCandidate,ShapeRecognized.prototype.constructor=ShapeRecognized,ShapeRecognized.prototype.getPrimitives=function(){return this.primitives},ShapeRecognized.prototype.getLabel=function(){return this.label},ShapeRecognized.prototype.getNormalizedRecognitionScore=function(){return this.normalizedRecognitionScore},ShapeRecognized.prototype.getResemblanceScore=function(){return this.resemblanceScore},scope.ShapeRecognized=ShapeRecognized}(MyScript),function(scope){function ShapeResult(obj){scope.AbstractResult.call(this,obj),obj&&(this.result=new scope.ShapeDocument(obj.result))}ShapeResult.prototype=new scope.AbstractResult,ShapeResult.prototype.constructor=ShapeResult,ShapeResult.prototype.getShapeDocument=function(){return this.result},scope.ShapeResult=ShapeResult}(MyScript),function(scope){function ShapeScratchOut(obj){if(scope.ShapeCandidate.call(this,obj),this.inkRanges=[],obj)for(var j in obj.inkRanges)this.inkRanges.push(new scope.ShapeInkRange(obj.inkRanges[j]))}ShapeScratchOut.prototype=new scope.ShapeCandidate,ShapeScratchOut.prototype.constructor=ShapeScratchOut,ShapeScratchOut.prototype.getInkRanges=function(){return this.inkRanges},scope.ShapeScratchOut=ShapeScratchOut}(MyScript),function(scope){function ShapeSegment(obj){if(this.inkRanges=[],this.candidates=[],obj){this.elementType=obj.elementType,this.uniqueID=obj.uniqueID,this.selectedCandidateIndex=obj.selectedCandidateIndex;for(var i in obj.candidates)switch(obj.candidates[i].type){case"erased":this.candidates.push(new scope.ShapeErased(obj.candidates[i]));break;case"scratchOut":this.candidates.push(new scope.ShapeScratchOut(obj.candidates[i]));break;case"recognizedShape":this.candidates.push(new scope.ShapeRecognized(obj.candidates[i]));break;default:this.candidates.push(new scope.ShapeNotRecognized(obj.candidates[i]))}for(var j in obj.inkRanges)this.inkRanges.push(new scope.ShapeInkRange(obj.inkRanges[j]))}}ShapeSegment.prototype.getElementType=function(){return this.elementType},ShapeSegment.prototype.getUniqueId=function(){return this.uniqueID},ShapeSegment.prototype.getInkRanges=function(){return this.inkRanges},ShapeSegment.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidateIndex},ShapeSegment.prototype.getCandidates=function(){return this.candidates},ShapeSegment.prototype.getSelectedCandidate=function(){return this.candidates&&void 0!==this.selectedCandidateIndex?this.candidates[this.selectedCandidateIndex]:void 0},scope.ShapeSegment=ShapeSegment}(MyScript),function(scope){function MathNode(obj){obj&&(this.name=obj.name,this.type=obj.type)}MathNode.prototype.getName=function(){return this.name},MathNode.prototype.getType=function(){return this.type},scope.MathNode=MathNode}(MyScript),function(scope){function MathNonTerminalNode(obj){if(scope.MathNode.call(this,obj),this.candidates=[],obj){this.selectedCandidate=obj.selectedCandidate;for(var i in obj.candidates)switch(obj.candidates[i].type){case"nonTerminalNode":switch(obj.candidates[i].name){case"term":this.candidates.push(new scope.MathTermNonTerminalNode(obj.candidates[i]));break;case"sqrtTerm":this.candidates.push(new scope.MathSqrtNonTerminalNode(obj.candidates[i]));break;case"vectorTerm":this.candidates.push(new scope.MathVectorNonTerminalNode(obj.candidates[i]));break;case"system":this.candidates.push(new scope.MathSystemNonTerminalNode(obj.candidates[i]));break;case"exponentiable":this.candidates.push(new scope.MathExponentiableNonTerminalNode(obj.candidates[i]));break;case"expression":this.candidates.push(new scope.MathExpressionNonTerminalNode(obj.candidates[i]));break;default:throw new Error("Unknown nonTerminalNode")}break;case"terminalNode":this.candidates.push(new scope.MathTerminalNode(obj.candidates[i]));break;case"rule":switch(obj.candidates[i].name){case"identity":this.candidates.push(new scope.MathIdentityRuleNode(obj.candidates[i]));break;case"horizontal pair":this.candidates.push(new scope.MathHorizontalPairRuleNode(obj.candidates[i]));break;case"fence":this.candidates.push(new scope.MathFenceRuleNode(obj.candidates[i]));break;case"fraction":this.candidates.push(new scope.MathFractionRuleNode(obj.candidates[i]));break;case"sqrt":this.candidates.push(new scope.MathSqrtRuleNode(obj.candidates[i]));break;case"subscript":this.candidates.push(new scope.MathSubscriptRuleNode(obj.candidates[i]));break;case"superscript":this.candidates.push(new scope.MathSuperscriptRuleNode(obj.candidates[i]));break;case"subsuperscript":this.candidates.push(new scope.MathSubSuperscriptRuleNode(obj.candidates[i]));break;case"underscript":this.candidates.push(new scope.MathUnderscriptRuleNode(obj.candidates[i]));break;case"overscript":this.candidates.push(new scope.MathOverscriptRuleNode(obj.candidates[i]));break;case"underoverscript":this.candidates.push(new scope.MathUnderOverscriptRuleNode(obj.candidates[i]));break;case"presuperscript":this.candidates.push(new scope.MathPreSuperscriptRuleNode(obj.candidates[i]));break;case"vertical pair":this.candidates.push(new scope.MathVerticalPairRuleNode(obj.candidates[i]));break;case"left fence":this.candidates.push(new scope.MathLeftFenceRuleNode(obj.candidates[i]));break;default:throw new Error("Unknown ruleNode")}break;default:throw new Error("Unknown math node type")}}}MathNonTerminalNode.prototype=new scope.MathNode,MathNonTerminalNode.prototype.constructor=MathNonTerminalNode,MathNonTerminalNode.prototype.getCandidates=function(){return this.candidates},MathNonTerminalNode.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidate},MathNonTerminalNode.prototype.getSelectedCandidate=function(){return this.candidates&&void 0!==this.selectedCandidate?this.candidates[this.selectedCandidate]:void 0},MathNonTerminalNode.prototype.getBoundingBox=function(){return this.getSelectedCandidate()?this.getSelectedCandidate().getBoundingBox():void 0},scope.MathNonTerminalNode=MathNonTerminalNode}(MyScript),function(scope){function MathResultElement(obj){obj&&(this.type=obj.type)}MathResultElement.prototype.getType=function(){return this.type},MathResultElement.prototype.isLaTex=function(){return"LATEX"===this.type},MathResultElement.prototype.isMathMl=function(){return"MATHML"===this.type},MathResultElement.prototype.isSymbolTree=function(){return"SYMBOLTREE"===this.type},scope.MathResultElement=MathResultElement}(MyScript),function(scope){"use strict";function MathRuleNode(obj){if(scope.MathNode.call(this,obj),this.children=[],obj){this.name=obj.name;for(var i in obj.children)switch(obj.children[i].type){case"nonTerminalNode":switch(obj.children[i].name){case"term":this.children.push(new scope.MathTermNonTerminalNode(obj.children[i]));break;case"sqrtTerm":this.children.push(new scope.MathSqrtNonTerminalNode(obj.children[i]));break;case"vectorTerm":this.children.push(new scope.MathVectorNonTerminalNode(obj.children[i]));break;case"system":this.children.push(new scope.MathSystemNonTerminalNode(obj.children[i]));break;case"exponentiable":this.children.push(new scope.MathExponentiableNonTerminalNode(obj.children[i]));break;case"expression":this.children.push(new scope.MathExpressionNonTerminalNode(obj.children[i]));break;default:throw new Error("Unknown nonTerminalNode")}break;case"terminalNode":this.children.push(new scope.MathTerminalNode(obj.children[i]));break;case"rule":switch(obj.children[i].name){case"identity":this.children.push(new scope.MathIdentityRuleNode(obj.children[i]));break;case"horizontal pair":this.children.push(new scope.MathHorizontalPairRuleNode(obj.children[i]));break;case"fence":this.children.push(new scope.MathFenceRuleNode(obj.children[i]));break;case"fraction":this.children.push(new scope.MathFractionRuleNode(obj.children[i]));break;case"sqrt":this.children.push(new scope.MathSqrtRuleNode(obj.children[i]));break;case"subscript":this.children.push(new scope.MathSubscriptRuleNode(obj.children[i]));break;case"superscript":this.children.push(new scope.MathSuperscriptRuleNode(obj.children[i]));break;case"subsuperscript":this.children.push(new scope.MathSubSuperscriptRuleNode(obj.children[i]));break;case"underscript":this.children.push(new scope.MathUnderscriptRuleNode(obj.children[i]));break;case"overscript":this.children.push(new scope.MathOverscriptRuleNode(obj.children[i]));break;case"underoverscript":this.children.push(new scope.MathUnderOverscriptRuleNode(obj.children[i]));break;case"presuperscript":this.children.push(new scope.MathPreSuperscriptRuleNode(obj.children[i]));break;case"vertical pair":this.children.push(new scope.MathVerticalPairRuleNode(obj.children[i]));break;case"left fence":this.children.push(new scope.MathLeftFenceRuleNode(obj.children[i]));break;default:throw new Error("Unknown ruleNode")}break;default:throw new Error("Unknown math node type")}}}MathRuleNode.prototype=new scope.MathNode,MathRuleNode.prototype.constructor=MathRuleNode,MathRuleNode.prototype.getName=function(){return this.name;

},MathRuleNode.prototype.getChildren=function(){return this.children},scope.MathRuleNode=MathRuleNode}(MyScript),function(scope){function MathDocument(obj){if(this.results=[],this.scratchOutResults=[],obj){for(var i in obj.results){var result=obj.results[i];switch(result.type){case"MATHML":this.results.push(new scope.MathMathMLResultElement(result));break;case"LATEX":this.results.push(new scope.MathLaTexResultElement(result));break;case"SYMBOLTREE":this.results.push(new scope.MathSymbolTreeResultElement(result));break;default:throw new Error("Unknown math result type")}}for(var j in obj.scratchOutResults)this.scratchOutResults.push(new scope.MathScratchOut(obj.scratchOutResults[j]))}}MathDocument.prototype.getResultElements=function(){return this.results},MathDocument.prototype.getScratchOutResults=function(){return this.scratchOutResults},scope.MathDocument=MathDocument}(MyScript),function(scope){function MathInkRange(obj){obj&&(this.component=obj.component,this.firstItem=obj.firstItem,this.lastItem=obj.lastItem)}MathInkRange.prototype.getComponent=function(){return this.component},MathInkRange.prototype.getFirstItem=function(){return this.firstItem},MathInkRange.prototype.getLastItem=function(){return this.lastItem},scope.MathInkRange=MathInkRange}(MyScript),function(scope){function MathLaTexResultElement(obj){scope.MathResultElement.call(this,obj),obj&&(this.value=obj.value)}MathLaTexResultElement.prototype=new scope.MathResultElement,MathLaTexResultElement.prototype.constructor=MathLaTexResultElement,MathLaTexResultElement.prototype.getValue=function(){return this.value},scope.MathLaTexResultElement=MathLaTexResultElement}(MyScript),function(scope){function MathMathMLResultElement(obj){scope.MathResultElement.call(this,obj),obj&&(this.value=obj.value)}MathMathMLResultElement.prototype=new scope.MathResultElement,MathMathMLResultElement.prototype.constructor=MathMathMLResultElement,MathMathMLResultElement.prototype.getValue=function(){return this.value},scope.MathMathMLResultElement=MathMathMLResultElement}(MyScript),function(scope){function MathResult(obj){scope.AbstractResult.call(this,obj),obj&&(this.result=new scope.MathDocument(obj.result))}MathResult.prototype=new scope.AbstractResult,MathResult.prototype.constructor=MathResult,MathResult.prototype.getMathDocument=function(){return this.result},scope.MathResult=MathResult}(MyScript),function(scope){function MathScratchOut(obj){if(this.inkRanges=[],this.erasedInkRanges=[],obj){for(var i in obj.inkRanges)this.inkRanges.push(new scope.MathInkRange(obj.inkRanges[i]));for(var j in obj.erasedInkRanges)this.erasedInkRanges.push(new scope.MathInkRange(obj.erasedInkRanges[j]))}}MathScratchOut.prototype.getInkRanges=function(){return this.inkRanges},MathScratchOut.prototype.getErasedInkRanges=function(){return this.erasedInkRanges},scope.MathScratchOut=MathScratchOut}(MyScript),function(scope){function MathSymbolTreeResultElement(obj){if(scope.MathResultElement.call(this,obj),obj){switch(obj.root.type){case"nonTerminalNode":switch(obj.root.name){case"term":this.root=new scope.MathTermNonTerminalNode(obj.root);break;case"sqrtTerm":this.root=new scope.MathSqrtNonTerminalNode(obj.root);break;case"vectorTerm":this.root=new scope.MathVectorNonTerminalNode(obj.root);break;case"system":this.root=new scope.MathSystemNonTerminalNode(obj.root);break;case"exponentiable":this.root=new scope.MathExponentiableNonTerminalNode(obj.root);break;case"expression":this.root=new scope.MathExpressionNonTerminalNode(obj.root);break;default:throw new Error("Unknown nonTerminalNode")}break;case"terminalNode":this.root=new scope.MathTerminalNode(obj.root);break;case"rule":switch(obj.root.name){case"identity":this.root=new scope.MathIdentityRuleNode(obj.root);break;case"horizontal pair":this.root=new scope.MathHorizontalPairRuleNode(obj.root);break;case"fence":this.root=new scope.MathFenceRuleNode(obj.root);break;case"fraction":this.root=new scope.MathFractionRuleNode(obj.root);break;case"sqrt":this.root=new scope.MathSqrtRuleNode(obj.root);break;case"subscript":this.root=new scope.MathSubscriptRuleNode(obj.root);break;case"superscript":this.root=new scope.MathSuperscriptRuleNode(obj.root);break;case"subsuperscript":this.root=new scope.MathSubSuperscriptRuleNode(obj.root);break;case"underscript":this.root=new scope.MathUnderscriptRuleNode(obj.root);break;case"overscript":this.root=new scope.MathOverscriptRuleNode(obj.root);break;case"underoverscript":this.root=new scope.MathUnderOverscriptRuleNode(obj.root);break;case"presuperscript":this.root=new scope.MathPreSuperscriptRuleNode(obj.root);break;case"vertical pair":this.root=new scope.MathVerticalPairRuleNode(obj.root);break;case"left fence":this.root=new scope.MathLeftFenceRuleNode(obj.root);break;default:throw new Error("Unknown ruleNode")}break;default:throw new Error("Unknown math node type")}this.value=JSON.stringify(obj.root,null,"  ")}}MathSymbolTreeResultElement.prototype=new scope.MathResultElement,MathSymbolTreeResultElement.prototype.constructor=MathSymbolTreeResultElement,MathSymbolTreeResultElement.prototype.getRoot=function(){return this.root},scope.MathSymbolTreeResultElement=MathSymbolTreeResultElement}(MyScript),function(scope){function MathTerminalNode(obj){if(scope.MathNode.call(this,obj),this.candidates=[],this.inkRanges=[],obj){this.selectedCandidate=obj.selectedCandidate;for(var i in obj.candidates)this.candidates.push(new scope.MathTerminalNodeCandidate(obj.candidates[i]));for(var j in obj.inkRanges)this.inkRanges.push(new scope.MathInkRange(obj.inkRanges[j]))}}MathTerminalNode.prototype=new scope.MathNode,MathTerminalNode.prototype.constructor=MathTerminalNode,MathTerminalNode.prototype.getCandidates=function(){return this.candidates},MathTerminalNode.prototype.getInkRanges=function(){return this.inkRanges},MathTerminalNode.prototype.getSelectedCandidateIdx=function(){return this.selectedCandidate},MathTerminalNode.prototype.getSelectedCandidate=function(){return this.candidates&&void 0!==this.selectedCandidate?this.candidates[this.selectedCandidate]:void 0},scope.MathTerminalNode=MathTerminalNode}(MyScript),function(scope){function MathTerminalNodeCandidate(obj){obj&&(this.label=obj.label,this.normalizedRecognitionScore=obj.normalizedRecognitionScore)}MathTerminalNodeCandidate.prototype.getLabel=function(){return this.label},MathTerminalNodeCandidate.prototype.getNormalizedRecognitionScore=function(){return this.normalizedRecognitionScore},scope.MathTerminalNodeCandidate=MathTerminalNodeCandidate}(MyScript),function(scope){function MathFenceRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathFenceRuleNode.prototype=new scope.MathRuleNode,MathFenceRuleNode.prototype.constructor=MathFenceRuleNode,scope.MathFenceRuleNode=MathFenceRuleNode}(MyScript),function(scope){function MathFractionRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathFractionRuleNode.prototype=new scope.MathRuleNode,MathFractionRuleNode.prototype.constructor=MathFractionRuleNode,scope.MathFractionRuleNode=MathFractionRuleNode}(MyScript),function(scope){function MathHorizontalPairRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathHorizontalPairRuleNode.prototype=new scope.MathRuleNode,MathHorizontalPairRuleNode.prototype.constructor=MathHorizontalPairRuleNode,scope.MathHorizontalPairRuleNode=MathHorizontalPairRuleNode}(MyScript),function(scope){function MathIdentityRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathIdentityRuleNode.prototype=new scope.MathRuleNode,MathIdentityRuleNode.prototype.constructor=MathIdentityRuleNode,scope.MathIdentityRuleNode=MathIdentityRuleNode}(MyScript),function(scope){function MathLeftFenceRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathLeftFenceRuleNode.prototype=new scope.MathRuleNode,MathLeftFenceRuleNode.prototype.constructor=MathLeftFenceRuleNode,scope.MathLeftFenceRuleNode=MathLeftFenceRuleNode}(MyScript),function(scope){function MathOverscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathOverscriptRuleNode.prototype=new scope.MathRuleNode,MathOverscriptRuleNode.prototype.constructor=MathOverscriptRuleNode,scope.MathOverscriptRuleNode=MathOverscriptRuleNode}(MyScript),function(scope){function MathPreSuperscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathPreSuperscriptRuleNode.prototype=new scope.MathRuleNode,MathPreSuperscriptRuleNode.prototype.constructor=MathPreSuperscriptRuleNode,scope.MathPreSuperscriptRuleNode=MathPreSuperscriptRuleNode}(MyScript),function(scope){function MathSqrtRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathSqrtRuleNode.prototype=new scope.MathRuleNode,MathSqrtRuleNode.prototype.constructor=MathSqrtRuleNode,scope.MathSqrtRuleNode=MathSqrtRuleNode}(MyScript),function(scope){function MathSubscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathSubscriptRuleNode.prototype=new scope.MathRuleNode,MathSubscriptRuleNode.prototype.constructor=MathSubscriptRuleNode,scope.MathSubscriptRuleNode=MathSubscriptRuleNode}(MyScript),function(scope){function MathSubSuperscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathSubSuperscriptRuleNode.prototype=new scope.MathRuleNode,MathSubSuperscriptRuleNode.prototype.constructor=MathSubSuperscriptRuleNode,scope.MathSubSuperscriptRuleNode=MathSubSuperscriptRuleNode}(MyScript),function(scope){function MathSuperscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathSuperscriptRuleNode.prototype=new scope.MathRuleNode,MathSuperscriptRuleNode.prototype.constructor=MathSuperscriptRuleNode,scope.MathSuperscriptRuleNode=MathSuperscriptRuleNode}(MyScript),function(scope){function MathUnderOverscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathUnderOverscriptRuleNode.prototype=new scope.MathRuleNode,MathUnderOverscriptRuleNode.prototype.constructor=MathUnderOverscriptRuleNode,scope.MathUnderOverscriptRuleNode=MathUnderOverscriptRuleNode}(MyScript),function(scope){function MathUnderscriptRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathUnderscriptRuleNode.prototype=new scope.MathRuleNode,MathUnderscriptRuleNode.prototype.constructor=MathUnderscriptRuleNode,scope.MathUnderscriptRuleNode=MathUnderscriptRuleNode}(MyScript),function(scope){function MathVerticalPairRuleNode(obj){scope.MathRuleNode.call(this,obj)}MathVerticalPairRuleNode.prototype=new scope.MathRuleNode,MathVerticalPairRuleNode.prototype.constructor=MathVerticalPairRuleNode,scope.MathVerticalPairRuleNode=MathVerticalPairRuleNode}(MyScript),function(scope){function MathExponentiableNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathExponentiableNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathExponentiableNonTerminalNode.prototype.constructor=MathExponentiableNonTerminalNode,scope.MathExponentiableNonTerminalNode=MathExponentiableNonTerminalNode}(MyScript),function(scope){function MathExpressionNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathExpressionNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathExpressionNonTerminalNode.prototype.constructor=MathExpressionNonTerminalNode,scope.MathExpressionNonTerminalNode=MathExpressionNonTerminalNode}(MyScript),function(scope){function MathSqrtNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathSqrtNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathSqrtNonTerminalNode.prototype.constructor=MathSqrtNonTerminalNode,scope.MathSqrtNonTerminalNode=MathSqrtNonTerminalNode}(MyScript),function(scope){function MathVectorNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathVectorNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathVectorNonTerminalNode.prototype.constructor=MathVectorNonTerminalNode,scope.MathVectorNonTerminalNode=MathVectorNonTerminalNode}(MyScript),function(scope){function MathSystemNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathSystemNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathSystemNonTerminalNode.prototype.constructor=MathSystemNonTerminalNode,scope.MathSystemNonTerminalNode=MathSystemNonTerminalNode}(MyScript),function(scope){function MathTermNonTerminalNode(obj){scope.MathNonTerminalNode.call(this,obj)}MathTermNonTerminalNode.prototype=new scope.MathNonTerminalNode,MathTermNonTerminalNode.prototype.constructor=MathTermNonTerminalNode,scope.MathTermNonTerminalNode=MathTermNonTerminalNode}(MyScript),function(scope){function MathResponseWSMessage(obj){scope.AbstractRecoResponseWSMessage.call(this,obj),obj&&(this.result=new scope.MathDocument(obj.result))}MathResponseWSMessage.prototype=new scope.AbstractRecoResponseWSMessage,MathResponseWSMessage.prototype.constructor=MathResponseWSMessage,MathResponseWSMessage.prototype.getMathDocument=function(){return this.result},scope.MathResponseWSMessage=MathResponseWSMessage}(MyScript),function(scope){function MusicElement(obj){this.inputRanges=[],obj&&(this.elementType=obj.elementType,this.inputRanges=obj.inputRanges)}MusicElement.prototype.getElementType=function(){return this.elementType},MusicElement.prototype.getInputRanges=function(){return this.inputRanges},scope.MusicElement=MusicElement}(MyScript),function(scope){function MusicResultElement(obj){obj&&(this.type=obj.type)}MusicResultElement.prototype.getType=function(){return this.type},MusicResultElement.prototype.isMusicXML=function(){return"MUSICXML"===this.type},MusicResultElement.prototype.isScoreTree=function(){return"SCORETREE"===this.type},scope.MusicResultElement=MusicResultElement}(MyScript),function(scope){function MusicAccidental(obj){scope.MusicElement.call(this,obj),obj&&(this.type=obj.type)}MusicAccidental.prototype=new scope.MusicElement,MusicAccidental.prototype.constructor=MusicAccidental,MusicAccidental.prototype.getType=function(){return this.type},scope.MusicAccidental=MusicAccidental}(MyScript),function(scope){function MusicAnnotation(obj){scope.MusicElement.call(this,obj),obj&&(this.label=obj.label)}MusicAnnotation.prototype=new scope.MusicElement,MusicAnnotation.prototype.constructor=MusicAnnotation,MusicAnnotation.prototype.getLabel=function(){return this.label},scope.MusicAnnotation=MusicAnnotation}(MyScript),function(scope){function MusicArpeggiate(obj){scope.MusicElement.call(this,obj),obj&&(this.type=obj.type)}MusicArpeggiate.prototype=new scope.MusicElement,MusicArpeggiate.prototype.constructor=MusicArpeggiate,MusicArpeggiate.prototype.getType=function(){return this.type},scope.MusicArpeggiate=MusicArpeggiate}(MyScript),function(scope){function MusicBar(obj){if(scope.MusicElement.call(this,obj),this.decorations=[],obj){this.repeatDirection=obj.repeatDirection,this.style=obj.style;for(var i in obj.decorations)this.decorations.push(new scope.MusicDecoration(obj.decorations[i]))}}MusicBar.prototype=new scope.MusicElement,MusicBar.prototype.constructor=MusicBar,MusicBar.prototype.getRepeatDirection=function(){return this.repeatDirection},MusicBar.prototype.getStyle=function(){return this.style},MusicBar.prototype.getDecorations=function(){return this.decorations},scope.MusicBar=MusicBar}(MyScript),function(scope){function MusicBeam(obj){scope.MusicElement.call(this,obj),obj&&(this.placement=obj.placement,this.leftCount=obj.leftCount,this.rightCount=obj.rightCount)}MusicBeam.prototype=new scope.MusicElement,MusicBeam.prototype.constructor=MusicBeam,MusicBeam.prototype.getPlacement=function(){return this.placement},MusicBeam.prototype.getLeftCount=function(){return this.leftCount},MusicBeam.prototype.getRightCount=function(){return this.rightCount},scope.MusicBeam=MusicBeam}(MyScript),function(scope){function MusicChord(obj){if(scope.MusicElement.call(this,obj),this.decorations=[],this.notes=[],this.beamTypes=[],this.ledgerLines=[],this.startSlurs=[],this.stopSlurs=[],obj){this.duration=obj.duration,this.arpeggiate=new scope.MusicArpeggiate(obj.arpeggiate),this.startBeam=new scope.MusicBeam(obj.startBeam),this.stopBeam=new scope.MusicBeam(obj.stopBeam),this.stem=new scope.MusicStem(obj.stem);for(var i in obj.decorations)this.decorations.push(new scope.MusicDecoration(obj.decorations[i]));for(var j in obj.notes)this.notes.push(new scope.MusicNote(obj.notes[j]));for(var k in obj.beamTypes)this.beamTypes.push(obj.beamTypes[k]);for(var l in obj.ledgerLines)this.ledgerLines.push(new scope.MusicLedgerLine(obj.ledgerLines[l]));for(var m in obj.startSlurs)this.startSlurs.push(new scope.MusicSlur(obj.startSlurs[m]));for(var n in obj.stopSlurs)this.stopSlurs.push(new scope.MusicSlur(obj.stopSlurs[n]))}}MusicChord.prototype=new scope.MusicElement,MusicChord.prototype.constructor=MusicChord,MusicChord.prototype.getDuration=function(){return this.duration},MusicChord.prototype.getArpeggiate=function(){return this.arpeggiate},MusicChord.prototype.getStartBeam=function(){return this.startBeam},MusicChord.prototype.getStopBeam=function(){return this.stopBeam},MusicChord.prototype.getStem=function(){return this.stem},MusicChord.prototype.getDecorations=function(){return this.decorations},MusicChord.prototype.getNotes=function(){return this.notes},MusicChord.prototype.getBeamTypes=function(){return this.beamTypes},MusicChord.prototype.getLedgerLines=function(){return this.ledgerLines},MusicChord.prototype.getStartSlurs=function(){return this.startSlurs},MusicChord.prototype.getStopSlurs=function(){return this.stopSlurs},scope.MusicChord=MusicChord}(MyScript),function(scope){function MusicClef(obj){scope.MusicElement.call(this,obj),obj&&(this.line=obj.line,this.octave=obj.octave,this.symbol=obj.symbol)}MusicClef.prototype=new scope.MusicElement,MusicClef.prototype.constructor=MusicClef,MusicClef.prototype.getLine=function(){return this.line},MusicClef.prototype.getOctave=function(){return this.octave},MusicClef.prototype.getSymbol=function(){return this.symbol},scope.MusicClef=MusicClef}(MyScript),function(scope){function MusicDecoration(obj){scope.MusicElement.call(this,obj),obj&&(this.symbol=obj.symbol,this.placement=obj.placement)}MusicDecoration.prototype=new scope.MusicElement,MusicDecoration.prototype.constructor=MusicDecoration,MusicDecoration.prototype.getSymbol=function(){return this.symbol},MusicDecoration.prototype.getPlacement=function(){return this.placement},scope.MusicDecoration=MusicDecoration}(MyScript),function(scope){function MusicDocument(obj){if(this.results=[],this.scratchOutResults=[],obj){for(var i in obj.results)switch(obj.results[i].type){case"MUSICXML":this.results.push(new scope.MusicXMLResultElement(obj.results[i]));break;default:this.results.push(new scope.MusicScoreTreeResultElement(obj.results[i]))}for(var j in obj.scratchOutResults)this.scratchOutResults.push(new scope.MusicScratchOut(obj.scratchOutResults[j]))}}MusicDocument.prototype.getResultElements=function(){return this.results},MusicDocument.prototype.getScratchOutResults=function(){return this.scratchOutResults},scope.MusicDocument=MusicDocument}(MyScript),function(scope){function MusicDots(obj){scope.MusicElement.call(this,obj),obj&&(this.count=obj.count)}MusicDots.prototype=new scope.MusicElement,MusicDots.prototype.constructor=MusicDots,MusicDots.prototype.getCount=function(){return this.count},scope.MusicDots=MusicDots}(MyScript),function(scope){function MusicHead(obj){scope.MusicElement.call(this,obj),obj&&(this.type=obj.type)}MusicHead.prototype=new scope.MusicElement,MusicHead.prototype.constructor=MusicHead,MusicHead.prototype.getType=function(){return this.type},scope.MusicHead=MusicHead}(MyScript),function(scope){function MusicInputRange(obj){obj&&(this.component=obj.component,this.firstItem=obj.firstItem,this.lastItem=obj.lastItem)}MusicInputRange.prototype.getComponent=function(){return this.component},MusicInputRange.prototype.getFirstItem=function(){return this.firstItem},MusicInputRange.prototype.getLastItem=function(){return this.lastItem},scope.MusicInputRange=MusicInputRange}(MyScript),function(scope){function MusicKeySignature(obj){if(scope.MusicElement.call(this,obj),this.accidentals=[],obj){this.signature=new scope.MusicKeySignatureData(obj.signature);for(var i in obj.accidentals)this.accidentals.push(new scope.MusicAccidental(obj.accidentals[i]))}}MusicKeySignature.prototype=new scope.MusicElement,MusicKeySignature.prototype.constructor=MusicKeySignature,MusicKeySignature.prototype.getSignature=function(){return this.signature},MusicKeySignature.prototype.getAccidentals=function(){return this.accidentals},scope.MusicKeySignature=MusicKeySignature}(MyScript),function(scope){function MusicKeySignatureData(obj){obj&&(this.fifths=obj.fifths,this.cancel=obj.cancel)}MusicKeySignatureData.prototype.getFifths=function(){return this.fifths},MusicKeySignatureData.prototype.getCancel=function(){return this.cancel},scope.MusicKeySignatureData=MusicKeySignatureData}(MyScript),function(scope){function MusicLedgerLine(obj){scope.MusicElement.call(this,obj)}MusicLedgerLine.prototype=new scope.MusicElement,MusicLedgerLine.prototype.constructor=MusicLedgerLine,scope.MusicLedgerLine=MusicLedgerLine}(MyScript),function(scope){function MusicNote(obj){if(scope.MusicElement.call(this,obj),this.decorations=[],this.beamTypes=[],this.ledgerLines=[],this.startSlurs=[],this.stopSlurs=[],obj){this.accidental=new scope.MusicAccidental(obj.accidental),this.dots=new scope.MusicDots(obj.dots),this.duration=obj.duration,this.head=new scope.MusicHead(obj.head),this.line=obj.line,this.pitch=new scope.MusicPitchData(obj.pitch),this.startBeam=new scope.MusicBeam(obj.startBeam),this.stopBeam=new scope.MusicBeam(obj.stopBeam),this.stem=new scope.MusicStem(obj.stem),this.startTie=new scope.MusicTie(obj.startTie),this.stopTie=new scope.MusicTie(obj.stopTie),this.startTuplet=new scope.MusicTuplet(obj.startTuplet),this.stopTuplet=new scope.MusicTuplet(obj.stopTuplet),this.timeModification=new scope.MusicTimeModificationData(obj.timeModification),this.type=obj.type;for(var i in obj.decorations)this.decorations.push(new scope.MusicDecoration(obj.decorations[i]));for(var j in obj.beamTypes)this.beamTypes.push(obj.beamTypes[j]);for(var k in obj.ledgerLines)this.ledgerLines.push(new scope.MusicLedgerLine(obj.ledgerLines[k]));for(var l in obj.startSlurs)this.startSlurs.push(new scope.MusicSlur(obj.startSlurs[l]));for(var m in obj.stopSlurs)this.stopSlurs.push(new scope.MusicSlur(obj.stopSlurs[m]))}}MusicNote.prototype=new scope.MusicElement,MusicNote.prototype.constructor=MusicNote,MusicNote.prototype.getAccidental=function(){return this.accidental},MusicNote.prototype.getDots=function(){return this.dots},MusicNote.prototype.getDuration=function(){return this.duration},MusicNote.prototype.getHead=function(){return this.head},MusicNote.prototype.getLine=function(){return this.line},MusicNote.prototype.getPitch=function(){return this.pitch},MusicNote.prototype.getStartBeam=function(){return this.startBeam},MusicNote.prototype.getStopBeam=function(){return this.stopBeam},MusicNote.prototype.getStem=function(){return this.stem},MusicNote.prototype.getStartTie=function(){return this.startTie},MusicNote.prototype.getStopTie=function(){return this.stopTie},MusicNote.prototype.getStartTuplet=function(){return this.startTuplet},MusicNote.prototype.getStopTuplet=function(){return this.stopTuplet},MusicNote.prototype.getTimeModification=function(){return this.timeModification},MusicNote.prototype.getType=function(){return this.type},MusicNote.prototype.getDecorations=function(){return this.decorations},MusicNote.prototype.getBeamTypes=function(){return this.beamTypes},MusicNote.prototype.getLedgerLines=function(){return this.ledgerLines},MusicNote.prototype.getStartSlurs=function(){return this.startSlurs},MusicNote.prototype.getStopSlurs=function(){return this.stopSlurs},scope.MusicNote=MusicNote}(MyScript),function(scope){function MusicPart(obj){if(this.elements=[],obj)for(var i in obj.elements)switch(obj.elements[i].elementType){case"accidental":this.elements.push(new scope.MusicAccidental(obj.elements[i]));break;case"annotation":this.elements.push(new scope.MusicAnnotation(obj.elements[i]));break;case"arpeggiate":this.elements.push(new scope.MusicArpeggiate(obj.elements[i]));break;case"bar":this.elements.push(new scope.MusicBar(obj.elements[i]));break;case"beam":this.elements.push(new scope.MusicBeam(obj.elements[i]));break;case"chord":this.elements.push(new scope.MusicChord(obj.elements[i]));break;case"clef":this.elements.push(new scope.MusicClef(obj.elements[i]));break;case"decoration":this.elements.push(new scope.MusicDecoration(obj.elements[i]));break;case"dots":this.elements.push(new scope.MusicDots(obj.elements[i]));break;case"head":this.elements.push(new scope.MusicHead(obj.elements[i]));break;case"keySignature":this.elements.push(new scope.MusicKeySignature(obj.elements[i]));break;case"ledgerLine":this.elements.push(new scope.MusicLedgerLine(obj.elements[i]));break;case"note":this.elements.push(new scope.MusicNote(obj.elements[i]));break;case"rest":this.elements.push(new scope.MusicRest(obj.elements[i]));break;case"slur":this.elements.push(new scope.MusicSlur(obj.elements[i]));break;case"stem":this.elements.push(new scope.MusicStem(obj.elements[i]));break;case"tie":this.elements.push(new scope.MusicTie(obj.elements[i]));break;case"timeSignature":this.elements.push(new scope.MusicTimeSignature(obj.elements[i]));break;case"tuplet":this.elements.push(new scope.MusicTuplet(obj.elements[i]));break;case"tupletBracket":this.elements.push(new scope.MusicTupletBracket(obj.elements[i]));break;default:throw new Error("Unknown music element")}}MusicPart.prototype.getElements=function(){return this.elements},scope.MusicPart=MusicPart}(MyScript),function(scope){function MusicPitchData(obj){obj&&(this.alteration=obj.alteration,this.octave=obj.octave,this.step=obj.step)}MusicPitchData.prototype.getAlteration=function(){return this.alteration},MusicPitchData.prototype.getOctave=function(){return this.octave},MusicPitchData.prototype.getStep=function(){return this.step},scope.MusicPitchData=MusicPitchData}(MyScript),function(scope){function MusicRest(obj){if(scope.MusicElement.call(this,obj),this.decorations=[],this.startSlurs=[],this.stopSlurs=[],obj){this.type=obj.type,this.dots=new scope.MusicDots(obj.dots),this.startTuplet=new scope.MusicTuplet(obj.startTuplet),this.stopTuplet=new scope.MusicTuplet(obj.stopTuplet),this.timeModification=new scope.MusicTimeModificationData(obj.timeModification),this.duration=obj.duration;for(var i in obj.decorations)this.decorations.push(new scope.MusicDecoration(obj.decorations[i]));for(var l in obj.startSlurs)this.startSlurs.push(new scope.MusicSlur(obj.startSlurs[l]));for(var m in obj.stopSlurs)this.stopSlurs.push(new scope.MusicSlur(obj.stopSlurs[m]))}}MusicRest.prototype=new scope.MusicElement,MusicRest.prototype.constructor=MusicRest,MusicRest.prototype.getType=function(){return this.type},MusicRest.prototype.getDots=function(){return this.dots},MusicRest.prototype.getStartTuplet=function(){return this.startTuplet},MusicRest.prototype.getStopTuplet=function(){return this.stopTuplet},MusicRest.prototype.getTimeModification=function(){return this.timeModification},MusicRest.prototype.getDuration=function(){return this.duration},MusicRest.prototype.getDecorations=function(){return this.decorations},MusicRest.prototype.getStartSlurs=function(){return this.startSlurs},MusicRest.prototype.getStopSlurs=function(){return this.stopSlurs},scope.MusicRest=MusicRest}(MyScript),function(scope){function MusicResult(obj){scope.AbstractResult.call(this,obj),obj&&(this.result=new scope.MusicDocument(obj.result))}MusicResult.prototype=new scope.AbstractResult,MusicResult.prototype.constructor=MusicResult,MusicResult.prototype.getMusicDocument=function(){return this.result},scope.MusicResult=MusicResult}(MyScript),function(scope){function MusicScore(obj){if(this.parts=[],obj)for(var i in obj.parts)this.parts.push(new scope.MusicPart(obj.parts[i]))}MusicScore.prototype.getParts=function(){return this.parts},scope.MusicScore=MusicScore}(MyScript),function(scope){function MusicScoreTreeResultElement(obj){scope.MusicResultElement.call(this,obj),obj&&(this.score=new scope.MusicScore(obj.score))}MusicScoreTreeResultElement.prototype=new scope.MusicResultElement,MusicScoreTreeResultElement.prototype.constructor=MusicScoreTreeResultElement,MusicScoreTreeResultElement.prototype.getScore=function(){return this.score},scope.MusicScoreTreeResultElement=MusicScoreTreeResultElement}(MyScript),function(scope){function MusicScratchOut(obj){if(this.inputRanges=[],this.erasedInputRanges=[],obj){for(var i in obj.inputRanges)this.inputRanges.push(new scope.MusicInputRange(obj.inputRanges[i]));for(var j in obj.erasedInputRanges)this.erasedInputRanges.push(new scope.MusicInputRange(obj.erasedInputRanges[j]))}}MusicScratchOut.prototype.getInputRanges=function(){return this.inputRanges},MusicScratchOut.prototype.getErasedInputRanges=function(){return this.erasedInputRanges},scope.MusicScratchOut=MusicScratchOut}(MyScript),function(scope){function MusicSlur(obj){scope.MusicElement.call(this,obj),obj&&(this.placement=obj.placement)}MusicSlur.prototype=new scope.MusicElement,MusicSlur.prototype.constructor=MusicSlur,MusicSlur.prototype.getPlacement=function(){return this.placement},scope.MusicSlur=MusicSlur}(MyScript),function(scope){function MusicStem(obj){scope.MusicElement.call(this,obj),obj&&(this.type=obj.type)}MusicStem.prototype=new scope.MusicElement,MusicStem.prototype.constructor=MusicStem,MusicStem.prototype.getType=function(){return this.type},scope.MusicStem=MusicStem}(MyScript),function(scope){function MusicTie(obj){scope.MusicElement.call(this,obj),obj&&(this.placement=obj.placement)}MusicTie.prototype=new scope.MusicElement,MusicTie.prototype.constructor=MusicTie,MusicTie.prototype.getPlacement=function(){return this.placement},scope.MusicTie=MusicTie}(MyScript),function(scope){function MusicTimeModificationData(obj){obj&&(this.actual=obj.actual,this.dots=obj.dots,this.normal=obj.normal,this.type=obj.type)}MusicTimeModificationData.prototype.getActual=function(){return this.actual},MusicTimeModificationData.prototype.getDots=function(){return this.dots},MusicTimeModificationData.prototype.getNormal=function(){return this.normal},MusicTimeModificationData.prototype.getType=function(){return this.type},scope.MusicTimeModificationData=MusicTimeModificationData}(MyScript),function(scope){function MusicTimeSignature(obj){scope.MusicElement.call(this,obj),obj&&(this.top=new scope.MusicAnnotation(obj.top),this.bottom=new scope.MusicAnnotation(obj.bottom),this.type=obj.type)}MusicTimeSignature.prototype=new scope.MusicElement,MusicTimeSignature.prototype.constructor=MusicTimeSignature,MusicTimeSignature.prototype.getTop=function(){return this.top},MusicTimeSignature.prototype.getBottom=function(){return this.bottom},MusicTimeSignature.prototype.getType=function(){return this.type},scope.MusicTimeSignature=MusicTimeSignature}(MyScript),function(scope){function MusicTupletBracket(obj){scope.MusicElement.call(this,obj),obj&&(this.type=obj.type)}MusicTupletBracket.prototype=new scope.MusicElement,MusicTupletBracket.prototype.constructor=MusicTupletBracket,MusicTupletBracket.prototype.getType=function(){return this.type},scope.MusicTupletBracket=MusicTupletBracket}(MyScript),function(scope){function MusicTuplet(obj){if(scope.MusicElement.call(this,obj),this.brackets=[],obj){this.placement=obj.placement,this.number=new scope.MusicAnnotation(obj.number);for(var i in obj.brackets)this.brackets.push(new scope.MusicTupletBracket(obj.brackets[i]))}}MusicTuplet.prototype=new scope.MusicElement,MusicTuplet.prototype.constructor=MusicTuplet,MusicTuplet.prototype.getPlacement=function(){return this.placement},MusicTuplet.prototype.getNumber=function(){return this.number},MusicTuplet.prototype.getBrackets=function(){return this.brackets},scope.MusicTuplet=MusicTuplet}(MyScript),function(scope){function MusicXMLResultElement(obj){scope.MusicResultElement.call(this,obj),obj&&(this.value=obj.value)}MusicXMLResultElement.prototype=new scope.MusicResultElement,MusicXMLResultElement.prototype.constructor=MusicXMLResultElement,MusicXMLResultElement.prototype.getValue=function(){return this.value},scope.MusicXMLResultElement=MusicXMLResultElement;

}(MyScript),function(scope){function AnalyzerElement(obj){obj&&(this.elementType=obj.elementType)}AnalyzerElement.prototype.getElementType=function(){return this.elementType},scope.AnalyzerElement=AnalyzerElement}(MyScript),function(scope){function AnalyzerCell(obj){scope.AnalyzerElement.call(this,obj),obj&&(this.data=new scope.AnalyzerCellData(obj.data))}AnalyzerCell.prototype=new scope.AnalyzerElement,AnalyzerCell.prototype.constructor=AnalyzerCell,AnalyzerCell.prototype.getData=function(){return this.data},scope.AnalyzerCell=AnalyzerCell}(MyScript),function(scope){function AnalyzerCellData(obj){obj&&(this.firstColumn=obj.firstColumn,this.lastColumn=obj.lastColumn,this.firstRow=obj.firstRow,this.lastRow=obj.lastRow,this.height=obj.height,this.width=obj.width,this.orientation=obj.orientation,this.topLeftPoint=new scope.Point(obj.topLeftPoint),this.topBorder=obj.topBorder,this.bottomBorder=obj.bottomBorder,this.leftBorder=obj.leftBorder,this.rightBorder=obj.rightBorder)}AnalyzerCellData.prototype.getFirstColumn=function(){return this.firstColumn},AnalyzerCellData.prototype.getLastColumn=function(){return this.lastColumn},AnalyzerCellData.prototype.getFirstRow=function(){return this.firstRow},AnalyzerCellData.prototype.getLastRow=function(){return this.lastRow},AnalyzerCellData.prototype.getHeight=function(){return this.height},AnalyzerCellData.prototype.getWidth=function(){return this.width},AnalyzerCellData.prototype.getOrientation=function(){return this.orientation},AnalyzerCellData.prototype.getTopLeftPoint=function(){return this.topLeftPoint},AnalyzerCellData.prototype.hasTopBorder=function(){return this.topBorder},AnalyzerCellData.prototype.hasBottomBorder=function(){return this.bottomBorder},AnalyzerCellData.prototype.hasLeftBorder=function(){return this.leftBorder},AnalyzerCellData.prototype.hasRightBorder=function(){return this.rightBorder},AnalyzerCellData.prototype.getBoundingBox=function(){var rectangle=new scope.Rectangle;return rectangle.setTopLeftPoint(this.getTopLeftPoint()),rectangle.setWidth(this.getWidth()),rectangle.setHeight(this.getHeight()),rectangle},scope.AnalyzerCellData=AnalyzerCellData}(MyScript),function(scope){function AnalyzerDocument(obj){if(scope.AnalyzerElement.call(this,obj),this.textLines=[],this.shapes=[],this.tables=[],this.groups=[],obj){for(var i in obj.textLines)this.textLines.push(new scope.AnalyzerTextLine(obj.textLines[i]));for(var j in obj.shapes)this.shapes.push(new scope.ShapeSegment(obj.shapes[j]));for(var k in obj.tables)this.tables.push(new scope.AnalyzerTable(obj.tables[k]));for(var l in obj.groups)this.groups.push(new scope.AnalyzerGroup(obj.groups[l]))}}AnalyzerDocument.prototype=new scope.AnalyzerElement,AnalyzerDocument.prototype.constructor=AnalyzerDocument,AnalyzerDocument.prototype.getTextLines=function(){return this.textLines},AnalyzerDocument.prototype.getShapes=function(){return this.shapes},AnalyzerDocument.prototype.getTables=function(){return this.tables},AnalyzerDocument.prototype.getGroups=function(){return this.groups},scope.AnalyzerDocument=AnalyzerDocument}(MyScript),function(scope){function AnalyzerElementReference(obj){obj&&(this.uniqueID=obj.uniqueID,this.type=obj.type)}AnalyzerElementReference.prototype.getUniqueId=function(){return this.uniqueID},AnalyzerElementReference.prototype.getType=function(){return this.type},scope.AnalyzerElementReference=AnalyzerElementReference}(MyScript),function(scope){function AnalyzerGroup(obj){if(scope.AnalyzerElement.call(this,obj),this.elementReferences=[],obj){this.type=obj.type,this.uniqueID=obj.uniqueID;for(var i in obj.elementReferences)this.elementReferences.push(new scope.AnalyzerElementReference(obj.elementReferences[i]))}}AnalyzerGroup.prototype=new scope.AnalyzerElement,AnalyzerGroup.prototype.constructor=AnalyzerGroup,AnalyzerGroup.prototype.getElementReferences=function(){return this.elementReferences},AnalyzerGroup.prototype.getType=function(){return this.type},AnalyzerGroup.prototype.getUniqueId=function(){return this.uniqueID},scope.AnalyzerGroup=AnalyzerGroup}(MyScript),function(scope){function AnalyzerInkRange(obj){obj&&(this.firstPoint=new scope.Point(obj.firstPoint),this.lastPoint=new scope.Point(obj.lastPoint),this.stroke=new scope.AnalyzerRecognizedStroke(obj.stroke))}AnalyzerInkRange.prototype.getFirstPoint=function(){return this.firstPoint},AnalyzerInkRange.prototype.getLastPoint=function(){return this.lastPoint},AnalyzerInkRange.prototype.getStroke=function(){return this.stroke},scope.AnalyzerInkRange=AnalyzerInkRange}(MyScript),function(scope){function AnalyzerLine(obj){scope.AnalyzerElement.call(this,obj),obj&&(this.data=new scope.AnalyzerLineData(obj.data))}AnalyzerLine.prototype=new scope.AnalyzerElement,AnalyzerLine.prototype.constructor=AnalyzerLine,AnalyzerLine.prototype.getData=function(){return this.data},scope.AnalyzerLine=AnalyzerLine}(MyScript),function(scope){function AnalyzerLineData(obj){obj&&(this.p1=new scope.Point(obj.p1),this.p2=new scope.Point(obj.p2))}AnalyzerLineData.prototype.getP1=function(){return this.p1},AnalyzerLineData.prototype.getP2=function(){return this.p2},scope.AnalyzerLineData=AnalyzerLineData}(MyScript),function(scope){function AnalyzerRecognizedStroke(obj){obj&&(this.type=obj.type,this.x=obj.x,this.y=obj.y)}AnalyzerRecognizedStroke.prototype.getType=function(){return this.type},AnalyzerRecognizedStroke.prototype.getX=function(){return this.x},AnalyzerRecognizedStroke.prototype.getY=function(){return this.y},scope.AnalyzerRecognizedStroke=AnalyzerRecognizedStroke}(MyScript),function(scope){function AnalyzerResult(obj){scope.AbstractResult.call(this,obj),obj&&(this.result=new scope.AnalyzerDocument(obj.result))}AnalyzerResult.prototype=new scope.AbstractResult,AnalyzerResult.prototype.constructor=AnalyzerResult,AnalyzerResult.prototype.getAnalyzerDocument=function(){return this.result},scope.AnalyzerResult=AnalyzerResult}(MyScript),function(scope){function AnalyzerStrokeType(obj){obj&&(this.inkRange=new scope.AnalyzerInkRange(obj.inkRange),this.type=obj.type)}AnalyzerStrokeType.prototype.getInkRange=function(){return this.inkRange},AnalyzerStrokeType.prototype.getType=function(){return this.type},scope.AnalyzerStrokeType=AnalyzerStrokeType}(MyScript),function(scope){function AnalyzerTable(obj){if(scope.AnalyzerElement.call(this,obj),this.lines=[],this.cells=[],this.inkRanges=[],obj){this.data=new scope.AnalyzerTableData(obj.data);for(var i in obj.lines)this.lines.push(new scope.AnalyzerLine(obj.lines[i]));for(var j in obj.cells)this.cells.push(new scope.AnalyzerCell(obj.cells[j]));for(var k in obj.inkRanges)this.inkRanges.push(new scope.AnalyzerInkRange(obj.inkRanges[k]))}}AnalyzerTable.prototype=new scope.AnalyzerElement,AnalyzerTable.prototype.constructor=AnalyzerTable,AnalyzerTable.prototype.getData=function(){return this.data},AnalyzerTable.prototype.getLines=function(){return this.lines},AnalyzerTable.prototype.getCells=function(){return this.cells},AnalyzerTable.prototype.getInkRanges=function(){return this.inkRanges},scope.AnalyzerTable=AnalyzerTable}(MyScript),function(scope){function AnalyzerTableData(obj){obj&&(this.columnCount=obj.columnCount,this.rowCount=obj.rowCount)}AnalyzerTableData.prototype.getColumnCount=function(){return this.columnCount},AnalyzerTableData.prototype.getRowCount=function(){return this.rowCount},scope.AnalyzerTableData=AnalyzerTableData}(MyScript),function(scope){function AnalyzerTextLine(obj){if(scope.AnalyzerElement.call(this,obj),this.inkRanges=[],this.underlineList=[],obj){this.data=new scope.AnalyzerTextLineData(obj.data),this.result=new scope.TextDocument(obj.result);for(var i in obj.inkRanges)this.inkRanges.push(new scope.AnalyzerInkRange(obj.inkRanges[i]));for(var j in obj.underlineList)this.underlineList.push(new scope.AnalyzerUnderline(obj.underlineList[j]))}}AnalyzerTextLine.prototype=new scope.AnalyzerElement,AnalyzerTextLine.prototype.constructor=AnalyzerTextLine,AnalyzerTextLine.prototype.getData=function(){return this.data},AnalyzerTextLine.prototype.getTextDocument=function(){return this.result},AnalyzerTextLine.prototype.getInkRanges=function(){return this.inkRanges},AnalyzerTextLine.prototype.getUnderlineList=function(){return this.underlineList},scope.AnalyzerTextLine=AnalyzerTextLine}(MyScript),function(scope){function AnalyzerTextLineData(obj){obj&&(this.baselinePos=obj.baselinePos,this.toMidline=obj.toMidline,this.orientation=obj.orientation,this.topLeftPoint=new scope.Point(obj.topLeftPoint),this.textHeight=obj.textHeight,this.justificationType=obj.justificationType,this.height=obj.height,this.width=obj.width)}AnalyzerTextLineData.prototype.getBaselinePos=function(){return this.baselinePos},AnalyzerTextLineData.prototype.getToMidline=function(){return this.toMidline},AnalyzerTextLineData.prototype.getOrientation=function(){return this.orientation},AnalyzerTextLineData.prototype.getTopLeftPoint=function(){return this.topLeftPoint},AnalyzerTextLineData.prototype.getTextHeight=function(){return this.textHeight},AnalyzerTextLineData.prototype.getJustificationType=function(){return this.justificationType},AnalyzerTextLineData.prototype.getHeight=function(){return this.height},AnalyzerTextLineData.prototype.getWidth=function(){return this.width},AnalyzerTextLineData.prototype.getBoundingBox=function(){var rectangle=new scope.Rectangle;return(this.getTopLeftPoint()||this.getWidth()||this.getHeight())&&(rectangle.setTopLeftPoint(this.getTopLeftPoint()),rectangle.setWidth(this.getWidth()),rectangle.setHeight(this.getHeight())),rectangle},scope.AnalyzerTextLineData=AnalyzerTextLineData}(MyScript),function(scope){function AnalyzerUnderline(obj){if(scope.AnalyzerElement.call(this,obj),this.inkRanges=[],obj){this.data=new scope.AnalyzerUnderlineData(obj.data);for(var i in obj.inkRanges)this.inkRanges.push(new scope.AnalyzerInkRange(obj.inkRanges[i]))}}AnalyzerUnderline.prototype=new scope.AnalyzerElement,AnalyzerUnderline.prototype.constructor=AnalyzerUnderline,AnalyzerUnderline.prototype.getData=function(){return this.data},AnalyzerUnderline.prototype.getInkRanges=function(){return this.inkRanges},scope.AnalyzerUnderline=AnalyzerUnderline}(MyScript),function(scope){function AnalyzerUnderlineData(obj){obj&&(this.firstCharacter=obj.firstCharacter,this.lastCharacter=obj.lastCharacter)}AnalyzerUnderlineData.prototype.getFirstCharacter=function(){return this.firstCharacter},AnalyzerUnderlineData.prototype.getLastCharacter=function(){return this.lastCharacter},scope.AnalyzerUnderlineData=AnalyzerUnderlineData}(MyScript),function(scope,Q){function NetworkInterface(){}NetworkInterface.parse=function(req){var result;try{result=JSON.parse(req.responseText)}catch(e){result=req.responseText}return result},NetworkInterface.transformRequest=function(obj){var str=[];for(var p in obj)"undefined"!=typeof obj[p]&&"function"!=typeof obj[p]&&str.push(encodeURIComponent(p)+"="+encodeURIComponent(obj[p]));return str.join("&")},NetworkInterface.prototype.xhr=function(type,url,data){function onStateChange(){4===request.readyState&&(request.status>=200&&request.status<300?deferred.resolve(NetworkInterface.parse(request)):deferred.reject(NetworkInterface.parse(request)))}function onLoad(){request.status>=200&&request.status<300?deferred.resolve(NetworkInterface.parse(request)):deferred.reject("Status code was "+request.status)}function onError(){deferred.reject("Can't XHR "+JSON.stringify(url))}function onProgress(event){deferred.notify(event.loaded/event.total)}var deferred=Q.defer(),request=new XMLHttpRequest;return request.open(type,url,!0),request.setRequestHeader("Accept","application/json"),request.setRequestHeader("Content-Type","application/x-www-form-urlencoded;charset=UTF-8"),request.onload=onLoad,request.onerror=onError,request.onprogress=onProgress,request.onreadystatechange=onStateChange,request.send(NetworkInterface.transformRequest(data)),deferred.promise},NetworkInterface.prototype.get=function(src,params){return params&&(src+="?"+NetworkInterface.transformRequest(params)),this.xhr("GET",src).then(function(response){return response},function(response){throw response})},NetworkInterface.prototype.put=function(url,data){return this.xhr("PUT",url,data).then(function(response){return response},function(response){throw response})},NetworkInterface.prototype.post=function(url,data){return this.xhr("POST",url,data).then(function(response){return response},function(response){throw response})},NetworkInterface.prototype["delete"]=function(url,data){return this.xhr("DELETE",url,data).then(function(response){return response},function(response){throw response})},scope.NetworkInterface=NetworkInterface}(MyScript,Q),function(scope,CryptoJS){function AbstractRecognizer(host){this.host="cloud.myscript.com",host&&(this.host=host),this.http=new scope.NetworkInterface}AbstractRecognizer.prototype.getAvailableLanguageList=function(applicationKey,inputMode){var data=new scope.RecognitionLanguagesData;return data.setApplicationKey(applicationKey),data.setInputMode(inputMode),this.http.get("//"+this.host+"/api/v3.0/recognition/rest/text/languages.json",data).then(function(response){return response.result},function(response){return response})},AbstractRecognizer.prototype.computeHmac=function(applicationKey,data,hmacKey){var jsonInput="object"==typeof data?JSON.stringify(data):data;return CryptoJS.HmacSHA512(jsonInput,applicationKey+hmacKey).toString(CryptoJS.enc.Hex)},scope.AbstractRecognizer=AbstractRecognizer}(MyScript,CryptoJS),function(scope){function AbstractWSRecognizer(host){scope.AbstractRecognizer.call(this,host)}AbstractWSRecognizer.prototype=new scope.AbstractRecognizer,AbstractWSRecognizer.prototype.constructor=AbstractWSRecognizer,AbstractWSRecognizer.prototype.getMessageCallback=function(){return this.messageCallback},AbstractWSRecognizer.prototype.setMessageCallback=function(callback){this.messageCallback=callback},AbstractWSRecognizer.prototype.getOpenCallback=function(){return this.openCallback},AbstractWSRecognizer.prototype.setOpenCallback=function(callback){this.openCallback=callback},AbstractWSRecognizer.prototype.getCloseCallback=function(){return this.closeCallback},AbstractWSRecognizer.prototype.setCloseCallback=function(callback){this.closeCallback=callback},AbstractWSRecognizer.prototype.getErrorCallback=function(){return this.errorCallback},AbstractWSRecognizer.prototype.setErrorCallback=function(callback){this.errorCallback=callback},AbstractWSRecognizer.prototype.getState=function(){var deferred=Q.defer();return this.socket?deferred.resolve(this.socket.readyState):deferred.reject(new Error("Can't find WebSocket")),deferred.promise},AbstractWSRecognizer.prototype.close=function(){var deferred=Q.defer();return this.socket?deferred.resolve(this.socket.close()):deferred.reject(new Error("Can't find WebSocket")),deferred.promise},AbstractWSRecognizer.prototype.sendMessage=function(message){var deferred=Q.defer();return this.socket?deferred.resolve(this.socket.send(JSON.stringify(message))):deferred.reject(new Error("Can't find WebSocket")),deferred.promise},AbstractWSRecognizer.prototype.initWSRecognition=function(applicationKey){var message=new scope.InitRequestWSMessage;return message.setApplicationKey(applicationKey),this.sendMessage(message)},AbstractWSRecognizer.prototype.takeUpHmacChallenge=function(applicationKey,challenge,hmacKey){var message=new scope.ChallengeRequestWSMessage;return message.setApplicationKey(applicationKey),message.setChallenge(challenge),message.setHmacSignature(this.computeHmac(applicationKey,challenge,hmacKey)),this.sendMessage(message)},AbstractWSRecognizer.prototype.resetWSRecognition=function(){var message=new scope.ResetRequestWSMessage;return this.sendMessage(message)},scope.AbstractWSRecognizer=AbstractWSRecognizer}(MyScript),function(scope){function TextRecognizer(host){scope.AbstractRecognizer.call(this,host),this.parameters=new scope.TextParameter,this.parameters.setLanguage("en_US"),this.parameters.setInputMode("CURSIVE")}TextRecognizer.prototype=new scope.AbstractRecognizer,TextRecognizer.prototype.constructor=TextRecognizer,TextRecognizer.prototype.getParameters=function(){return this.parameters},TextRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},TextRecognizer.prototype.doSimpleRecognition=function(applicationKey,instanceId,inputUnits,hmacKey,parameters){var input=new scope.TextRecognitionInput;input.setParameters(parameters?parameters:this.parameters),input.setInputUnits(inputUnits);var data=new scope.TextRecognitionData;return data.setApplicationKey(applicationKey),data.setTextRecognitionInput(input),data.setInstanceId(instanceId),data.setHmac(this.computeHmac(applicationKey,input,hmacKey)),this.http.post("//"+this.host+"/api/v3.0/recognition/rest/text/doSimpleRecognition.json",data).then(function(response){return new scope.TextResult(response)},function(response){throw response})},scope.TextRecognizer=TextRecognizer}(MyScript),function(scope){function TextWSRecognizer(host){scope.AbstractWSRecognizer.call(this,host),this.parameters=new scope.TextParameter,this.parameters.setLanguage("en_US"),this.parameters.setInputMode("CURSIVE"),this.socket=new WebSocket("ws://"+this.host+"/api/v3.0/recognition/ws/text");var self=this;this.socket.onopen=function(message){console.log("WebSocket opened"),self.openCallback&&self.openCallback(message)},this.socket.onmessage=function(message){var data=JSON.parse(message.data);switch(console.log("WebSocket message received"),data.type){case"init":data=new scope.InitResponseWSMessage(data);break;case"error":data=new scope.ErrorResponseWSMessage(data);break;case"hmacChallenge":data=new scope.ChallengeResponseWSMessage(data);break;default:data=new scope.TextResponseWSMessage(data)}self.messageCallback&&self.messageCallback(data)},this.socket.onerror=function(message){console.log("WebSocket error received"),self.errorCallback&&self.errorCallback(message)},this.socket.onclose=function(message){console.log("WebSocket opened"),self.closeCallback&&self.closeCallback(message)}}TextWSRecognizer.prototype=new scope.AbstractWSRecognizer,TextWSRecognizer.prototype.constructor=TextWSRecognizer,TextWSRecognizer.prototype.getParameters=function(){return this.parameters},TextWSRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},TextWSRecognizer.prototype.startWSRecognition=function(inputUnits,parameters){var message=new scope.TextStartRequestWSMessage;return message.setParameters(parameters?parameters:this.getParameters()),message.setInputUnits(inputUnits),this.sendMessage(message)},TextWSRecognizer.prototype.continueWSRecognition=function(inputUnits,instanceId){var message=new scope.TextContinueRequestWSMessage;return message.setInputUnits(inputUnits),message.setInstanceId(instanceId),this.sendMessage(message)},TextWSRecognizer.prototype.doWSRecognition=function(instanceId,inputUnits,parameters){return instanceId?this.continueWSRecognition(inputUnits,instanceId):this.startWSRecognition(inputUnits,parameters)},scope.TextWSRecognizer=TextWSRecognizer}(MyScript),function(scope){function ShapeRecognizer(host){scope.AbstractRecognizer.call(this,host),this.parameters=new scope.ShapeParameter}ShapeRecognizer.prototype=new scope.AbstractRecognizer,ShapeRecognizer.prototype.constructor=ShapeRecognizer,ShapeRecognizer.prototype.getParameters=function(){return this.parameters},ShapeRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},ShapeRecognizer.prototype.doSimpleRecognition=function(applicationKey,instanceId,components,hmacKey,parameters){var input=new scope.ShapeRecognitionInput;input.setComponents(components),parameters?(input.setDoBeautification(parameters.hasBeautification()),input.setRejectDetectionSensitivity(parameters.getRejectDetectionSensitivity())):(input.setDoBeautification(this.getParameters().hasBeautification()),input.setRejectDetectionSensitivity(this.getParameters().getRejectDetectionSensitivity()));var data=new scope.ShapeRecognitionData;return data.setApplicationKey(applicationKey),data.setShapeRecognitionInput(input),data.setInstanceId(instanceId),data.setHmac(this.computeHmac(applicationKey,input,hmacKey)),this.http.post("//"+this.host+"/api/v3.0/recognition/rest/shape/doSimpleRecognition.json",data).then(function(response){return new scope.ShapeResult(response)},function(response){throw response})},ShapeRecognizer.prototype.clearShapeRecognitionSession=function(applicationKey,instanceId){var data={instanceSessionId:instanceId};return this.http.post("//"+this.host+"/api/v3.0/recognition/rest/shape/clearSessionId.json",data).then(function(response){return response},function(response){throw response})},scope.ShapeRecognizer=ShapeRecognizer}(MyScript),function(scope){function MathRecognizer(host){scope.AbstractRecognizer.call(this,host),this.parameters=new scope.MathParameter}MathRecognizer.prototype=new scope.AbstractRecognizer,MathRecognizer.prototype.constructor=MathRecognizer,MathRecognizer.prototype.getParameters=function(){return this.parameters},MathRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},MathRecognizer.prototype.doSimpleRecognition=function(applicationKey,instanceId,components,hmacKey,parameters){var input=new scope.MathRecognitionInput;input.setComponents(components),parameters?(input.setResultTypes(parameters.getResultTypes()),input.setColumnar(parameters.isColumnar()),input.setScratchOutDetectionSensitivity(parameters.getScratchOutDetectionSensitivity()),input.setUserResources(parameters.getUserResources())):(input.setResultTypes(this.getParameters().getResultTypes()),input.setColumnar(this.getParameters().isColumnar()),input.setScratchOutDetectionSensitivity(this.getParameters().getScratchOutDetectionSensitivity()),input.setUserResources(this.getParameters().getUserResources()));var data=new scope.MathRecognitionData;return data.setApplicationKey(applicationKey),data.setMathRecognitionInput(input),data.setInstanceId(instanceId),data.setHmac(this.computeHmac(applicationKey,input,hmacKey)),this.http.post("//"+this.host+"/api/v3.0/recognition/rest/math/doSimpleRecognition.json",data).then(function(response){return new scope.MathResult(response)},function(response){throw response})},scope.MathRecognizer=MathRecognizer}(MyScript),function(scope){function MathWSRecognizer(host){scope.AbstractWSRecognizer.call(this,host),this.parameters=new scope.MathParameter,this.socket=new WebSocket("ws://"+this.host+"/api/v3.0/recognition/ws/math");var self=this;this.socket.onopen=function(message){console.log("WebSocket opened"),self.openCallback&&self.openCallback(message)},this.socket.onmessage=function(message){var data=JSON.parse(message.data);switch(console.log("WebSocket message received"),data.type){case"init":data=new scope.InitResponseWSMessage(data);break;case"error":data=new scope.ErrorResponseWSMessage(data);break;case"hmacChallenge":data=new scope.ChallengeResponseWSMessage(data);break;default:data=new scope.MathResponseWSMessage(data)}self.messageCallback&&self.messageCallback(data)},this.socket.onerror=function(message){console.log("WebSocket error received"),self.errorCallback&&self.errorCallback(message)},this.socket.onclose=function(message){console.log("WebSocket opened"),self.closeCallback&&self.closeCallback(message)}}MathWSRecognizer.prototype=new scope.AbstractWSRecognizer,MathWSRecognizer.prototype.constructor=MathWSRecognizer,MathWSRecognizer.prototype.getParameters=function(){return this.parameters},MathWSRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},MathWSRecognizer.prototype.startWSRecognition=function(components,parameters){var message=new scope.MathStartRequestWSMessage;return message.setParameters(parameters?parameters:this.getParameters()),message.setComponents(components),this.sendMessage(message)},MathWSRecognizer.prototype.continueWSRecognition=function(components,instanceId){var message=new scope.MathContinueRequestWSMessage;return message.setComponents(components),message.setInstanceId(instanceId),this.sendMessage(message)},MathWSRecognizer.prototype.doWSRecognition=function(instanceId,components,parameters){return instanceId?this.continueWSRecognition(components,instanceId):this.startWSRecognition(components,parameters)},scope.MathWSRecognizer=MathWSRecognizer}(MyScript),function(scope){function MusicRecognizer(host){scope.AbstractRecognizer.call(this,host),this.parameters=new scope.MusicParameter}MusicRecognizer.prototype=new scope.AbstractRecognizer,MusicRecognizer.prototype.constructor=MusicRecognizer,MusicRecognizer.prototype.getParameters=function(){return this.parameters},MusicRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},MusicRecognizer.prototype.doSimpleRecognition=function(applicationKey,instanceId,components,hmacKey,parameters){var input=new scope.MusicRecognitionInput;input.setComponents(components),parameters?(input.setStaff(parameters.getStaff()),input.setDivisions(parameters.getDivisions()),input.setResultTypes(parameters.getResultTypes()),input.setScratchOutDetectionSensitivity(parameters.getScratchOutDetectionSensitivity()),input.setUserResources(parameters.getUserResources())):(input.setStaff(this.getParameters().getStaff()),input.setDivisions(this.getParameters().getDivisions()),input.setResultTypes(this.getParameters().getResultTypes()),input.setScratchOutDetectionSensitivity(this.getParameters().getScratchOutDetectionSensitivity()),input.setUserResources(this.getParameters().getUserResources()));var data=new scope.MusicRecognitionData;return data.setApplicationKey(applicationKey),data.setMusicRecognitionInput(input),data.setInstanceId(instanceId),data.setHmac(this.computeHmac(applicationKey,input,hmacKey)),this.http.post("//"+this.host+"/api/v3.0/recognition/rest/music/doSimpleRecognition.json",data).then(function(response){return new scope.MusicResult(response)},function(response){throw response})},scope.MusicRecognizer=MusicRecognizer}(MyScript),function(scope){function AnalyzerRecognizer(host){scope.AbstractRecognizer.call(this,host),this.parameters=new scope.AnalyzerParameter}AnalyzerRecognizer.prototype=new scope.AbstractRecognizer,AnalyzerRecognizer.prototype.constructor=AnalyzerRecognizer,AnalyzerRecognizer.prototype.getParameters=function(){return this.parameters},AnalyzerRecognizer.prototype.setParameters=function(parameters){this.parameters=parameters},AnalyzerRecognizer.prototype.doSimpleRecognition=function(applicationKey,instanceId,components,hmacKey,parameters){var input=new scope.AnalyzerRecognitionInput;input.setComponents(components),input.setParameters(parameters?parameters:this.getParameters());var data=new scope.AnalyzerRecognitionData;return data.setApplicationKey(applicationKey),data.setAnalyzerRecognitionInput(input),data.setInstanceId(instanceId),data.setHmac(this.computeHmac(applicationKey,input,hmacKey)),this.http.post("//"+this.host+"/api/v3.0/recognition/rest/analyzer/doSimpleRecognition.json",data).then(function(response){return new scope.AnalyzerResult(response)},function(response){return response})},scope.AnalyzerRecognizer=AnalyzerRecognizer}(MyScript),function(scope){function RenderingParameters(){this.color="black",this.rectColor="rgba(0, 0, 0, 0.2)",this.font="Times New Roman",this.decoration="",this.width=4,this.pressureType="SIMULATED",this.alpha="1.0",this.doFadeOutLoop=!1,this.showBoundingBoxes=!1}RenderingParameters.prototype.getColor=function(){return this.color},RenderingParameters.prototype.setColor=function(color){this.color=color},RenderingParameters.prototype.getRectColor=function(){return this.rectColor},RenderingParameters.prototype.setRectColor=function(rectColor){this.rectColor=rectColor},RenderingParameters.prototype.getFont=function(){return this.font},RenderingParameters.prototype.setFont=function(font){this.font=font},RenderingParameters.prototype.getDecoration=function(){return this.decoration},RenderingParameters.prototype.setDecoration=function(decoration){this.decoration=decoration},RenderingParameters.prototype.getWidth=function(){return this.width},RenderingParameters.prototype.setWidth=function(width){this.width=width},RenderingParameters.prototype.getPressureType=function(){return this.pressureType},RenderingParameters.prototype.setPressureType=function(pressureType){this.pressureType=pressureType},RenderingParameters.prototype.getAlpha=function(){return this.alpha},RenderingParameters.prototype.setAlpha=function(alpha){this.alpha=alpha},RenderingParameters.prototype.getDoFadeOutLoop=function(){return this.doFadeOutLoop},RenderingParameters.prototype.setDoFadeOutLoop=function(doFadeOutLoop){this.doFadeOutLoop=doFadeOutLoop},RenderingParameters.prototype.getShowBoundingBoxes=function(){return this.showBoundingBoxes},RenderingParameters.prototype.setShowBoundingBoxes=function(showBoundingBoxes){this.showBoundingBoxes=showBoundingBoxes},scope.RenderingParameters=RenderingParameters}(MyScript),function(scope){function AbstractRenderer(){this.points=[],this.drawing=!1,this.parameters=new scope.RenderingParameters}AbstractRenderer.prototype.getParameters=function(){return this.parameters},AbstractRenderer.prototype.setParameters=function(parameters){this.parameters=parameters},AbstractRenderer.prototype.drawRecognitionResult=function(components,recognitionResult,context,parameters){throw new Error("not implemented")},AbstractRenderer.prototype.drawComponents=function(components,context,parameters){for(var i in components){var component=components[i];component instanceof scope.Stroke?this.drawStroke(component,context,parameters):component instanceof scope.CharacterInputComponent&&this.drawCharacter(component,context,parameters)}},AbstractRenderer.prototype.drawStart=function(x,y){this.points.length=0,this.drawing=!0,this.points.push({x:x,y:y,pressure:.5,distance:0,length:0,ux:0,uy:0,x1:0,x2:0,y1:0,y2:0})},AbstractRenderer.prototype.drawContinue=function(x,y,context,parameters){if(this.drawing){var point={x:x,y:y,pressure:.5,distance:0,length:0,ux:0,uy:0,x1:0,x2:0,y1:0,y2:0};if(this.points.push(point),this.points.length>1){var previous=this.points[this.points.length-2];if(2===this.points.length)this.drawQuadratricStart(previous,point,context,parameters);else{var third=this.points[this.points.length-3];this.drawQuadratricContinue(third,previous,point,context,parameters)}}}},AbstractRenderer.prototype.drawEnd=function(x,y,context,parameters){if(this.drawing){if(1===this.points.length)this.drawPoint({x:x,y:y,pressure:.5,distance:0,length:0,ux:0,uy:0,x1:0,x2:0,y1:0,y2:0},context,parameters);else if(this.points.length>1){var lastPoint=this.points[this.points.length-1],point=this.points[this.points.length-2];this.drawQuadratricEnd(point,lastPoint,context,parameters)}this.drawing=!1}},AbstractRenderer.prototype.clear=function(context){context.clearRect(0,0,context.canvas.width,context.canvas.height)},AbstractRenderer.prototype.drawGuidelines=function(horizontalSpacing,verticalSpacing,context,parameters){context.save();try{if(parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.lineWidth=.5*this.parameters.getWidth()),context.clearRect(0,0,context.canvas.clientWidth,context.canvas.clientHeight),verticalSpacing)for(var y=verticalSpacing;y<context.canvas.clientHeight-verticalSpacing;y+=verticalSpacing)context.beginPath(),context.moveTo(horizontalSpacing,y),context.lineTo(context.canvas.clientWidth-horizontalSpacing,y),context.stroke();if(horizontalSpacing)for(var x=horizontalSpacing;x<context.canvas.clientWidth-horizontalSpacing;x+=horizontalSpacing)context.beginPath(),context.moveTo(x,verticalSpacing),context.lineTo(x,context.canvas.clientHeight-verticalSpacing),context.stroke()}finally{context.restore()}},AbstractRenderer.prototype.drawLineByCoordinates=function(lX,lY,cX,cY,context,parameters){context.save();try{parameters?(context.fillStyle=parameters.getColor(),
context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.beginPath(),context.moveTo(lX,lY),context.lineTo(cX,cY),context.stroke()}finally{context.restore()}},AbstractRenderer.prototype.drawLineByPoints=function(firstPoint,lastPoint,context,parameters){this.drawLineByCoordinates(firstPoint.x,firstPoint.y,lastPoint.x,lastPoint.y,context,parameters)},AbstractRenderer.prototype.drawRectangle=function(rectangle,context,parameters){context.save();try{parameters?(context.fillStyle=parameters.getRectColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getRectColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.fillRect(rectangle.getX(),rectangle.getY(),rectangle.getWidth(),rectangle.getHeight())}finally{context.restore()}},AbstractRenderer.prototype.drawStrokes=function(strokes,context,parameters){for(var i in strokes)this.drawStroke(strokes[i],context,parameters)},AbstractRenderer.prototype.drawStroke=function(stroke,context,parameters){for(var strokePoints=[],j=0;j<stroke.getLength();j++)strokePoints.push(new scope.QuadraticPoint({x:stroke.getX()[j],y:stroke.getY()[j]}));if(1===stroke.getLength())this.drawPoint(strokePoints[0],context,parameters);else for(var k=0;k<stroke.getLength();k++)if(0===k){var p1=strokePoints[0],p2=strokePoints[1];this.drawQuadratricStart(p1,p2,context,parameters)}else if(k<stroke.getLength()-1){var p3=strokePoints[k-1],p4=strokePoints[k],p5=strokePoints[k+1];this.drawQuadratricContinue(p3,p4,p5,context,parameters)}else if(k>1){var p6=strokePoints[k-1],p7=strokePoints[k];this.drawQuadratricEnd(p6,p7,context,parameters)}},AbstractRenderer.prototype.drawCharacter=function(character,context,parameters){throw new Error("not implemented")},AbstractRenderer.prototype.drawPoint=function(point,context,parameters){context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth(),context.beginPath(),context.arc(point.x,point.y,.5*parameters.getWidth(),0,2*Math.PI),context.fill()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth(),context.beginPath(),context.arc(point.x,point.y,.5*this.parameters.getWidth(),0,2*Math.PI),context.fill())}finally{context.restore()}},AbstractRenderer.prototype.drawArrowHead=function(headPoint,angle,length,context,parameters){var alpha=phi(angle+Math.PI-Math.PI/8),beta=phi(angle-Math.PI+Math.PI/8);context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.moveTo(headPoint.x,headPoint.y),context.beginPath(),context.lineTo(headPoint.x+length*Math.cos(alpha),headPoint.y+length*Math.sin(alpha)),context.lineTo(headPoint.x+length*Math.cos(beta),headPoint.y+length*Math.sin(beta)),context.lineTo(headPoint.x,headPoint.y),context.fill()}finally{context.restore()}},AbstractRenderer.prototype.extractStroke=function(strokes,inkRange){for(var result=[],firstPointIndex=Math.floor(inkRange.getFirstPoint()),lastPointIndex=Math.ceil(inkRange.getLastPoint()),strokeIndex=inkRange.getFirstStroke();strokeIndex<=inkRange.getLastStroke();strokeIndex++){for(var currentStroke=strokes[strokeIndex],currentStrokePointCount=currentStroke.x.length,newStroke=new scope.Stroke,x=[],y=[],pointIndex=firstPointIndex;strokeIndex===inkRange.getLastStroke()&&lastPointIndex>=pointIndex&&currentStrokePointCount>pointIndex||strokeIndex!==inkRange.getLastStroke()&&currentStrokePointCount>pointIndex;pointIndex++)x.push(currentStroke.x[pointIndex]),y.push(currentStroke.y[pointIndex]);newStroke.setX(x),newStroke.setY(y),result.push(newStroke)}return result},AbstractRenderer.prototype.drawQuadratricStart=function(p1,p2,context,parameters){parameters?computePoint(null,p1,!0,!1,parameters.getPressureType(),parameters.getWidth()):computePoint(null,p1,!0,!1,this.parameters.getPressureType(),this.parameters.getWidth()),context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.beginPath(),strokeFirstSegment(p1,p2,context),context.fill()}finally{context.restore()}},AbstractRenderer.prototype.drawQuadratricContinue=function(p1,p2,p3,context,parameters){parameters?computePoint(p2,p3,!1,!1,parameters.getPressureType(),parameters.getWidth()):computePoint(p2,p3,!1,!1,this.parameters.getPressureType(),this.parameters.getWidth()),context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.beginPath(),strokeSegment(p1,p2,p3,context),context.fill()}finally{context.restore()}},AbstractRenderer.prototype.drawQuadratricEnd=function(p1,p2,context,parameters){parameters?computePoint(p1,p2,!1,!0,parameters.getPressureType(),parameters.getWidth()):computePoint(p1,p2,!1,!0,this.parameters.getPressureType(),this.parameters.getWidth()),context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.beginPath(),strokeLastSegment(p1,p2,context),context.fill()}finally{context.restore()}};var strokeFirstSegment=function(p1,p2,context){var x11=p1.x1,y11=p1.y1,x12=p1.x2,y12=p1.y2,x21=.5*p1.x1+p2.x1,y21=.5*p1.y1+p2.y1,x22=.5*p1.x2+p2.x2,y22=.5*p1.y2+p2.y2;context.moveTo(x11,y11),context.lineTo(x21,y21),context.lineTo(x22,y22),context.lineTo(x12,y12),context.lineTo(x11,y11)},strokeSegment=function(p1,p2,p3,context){var x11=.5*(p1.x1+p2.x1),y11=.5*(p1.y1+p2.y1),x12=.5*(p1.x2+p2.x2),y12=.5*(p1.y2+p2.y2),x21=.5*(p2.x1+p3.x1),y21=.5*(p2.y1+p3.y1),x22=.5*(p2.x2+p3.x2),y22=.5*(p2.y2+p3.y2);context.moveTo(x11,y11),context.quadraticCurveTo(p2.x1,p2.y1,x21,y21),context.lineTo(x22,y22),context.quadraticCurveTo(p2.x2,p2.y2,x12,y12),context.lineTo(x11,y11)},strokeLastSegment=function(p1,p2,context){var x11=.5*(p1.x1+p2.x1),y11=.5*(p1.y1+p2.y1),x12=.5*(p1.x2+p2.x2),y12=.5*(p1.y2+p2.y2),x21=p2.x1,y21=p2.y1,x22=p2.x2,y22=p2.y2;context.moveTo(x11,y11),context.lineTo(x21,y21),context.lineTo(x22,y22),context.lineTo(x12,y12),context.lineTo(x11,y11)},phi=function(angle){return angle=(angle+Math.PI)%(2*Math.PI)-Math.PI,angle<-Math.PI&&(angle+=2*Math.PI),angle},computePoint=function(previous,point,isFirst,isLast,pressureType,penWidth){if(null!==previous){computeDistance(previous,point);var strokeLength=previous.length+point.distance;point.length=strokeLength}switch(pressureType){case"SIMULATED":computePressure(point,point.distance,point.length);break;case"CONSTANT":point.pressure=1;break;case"REAL":break;default:throw new Error("Unknown pressure type")}computeLastControls(point,penWidth),null===previous||isLast||(isFirst&&computeFirstControls(previous,point,penWidth),isLast?computeLastControls(point,penWidth):computeControls(previous,point,penWidth))},computeDistance=function(previous,point){var dx=point.x-previous.x,dy=point.y-previous.y,d=Math.sqrt(dx*dx+dy*dy);0!==d&&(point.distance=d,point.ux=dx/d,point.uy=dy/d)},computePressure=function(point,distance,length){var k,pressure;k=10>distance?.2+Math.pow(.1*distance,.4):distance>length-10?.2+Math.pow(.1*(length-distance),.4):1,pressure=k*Math.max(.1,1-.1*Math.sqrt(point.distance)),isNaN(parseFloat(pressure))&&(pressure=.5),point.pressure=pressure},computeFirstControls=function(first,next,penWidth){var r=.5*penWidth*first.pressure,nx=-r*next.uy,ny=r*next.ux;first.x1=first.x+nx,first.y1=first.y+ny,first.x2=first.x-nx,first.y1=first.y-ny},computeControls=function(point,next,penWidth){var ux=point.ux+next.ux,uy=point.uy+next.uy,u=Math.sqrt(ux*ux+uy*uy);if(0!==u){var r=.5*penWidth*point.pressure,nx=-r*uy/u,ny=r*ux/u;point.x1=point.x+nx,point.y1=point.y+ny,point.x2=point.x-nx,point.y2=point.y-ny}else point.x1=point.x,point.y1=point.y,point.x2=point.x,point.y2=point.y},computeLastControls=function(last,penWidth){var r=.5*penWidth*last.pressure,nx=-r*last.uy,ny=r*last.ux;last.x1=last.x+nx,last.y1=last.y+ny,last.x2=last.x-nx,last.y2=last.y-ny};scope.AbstractRenderer=AbstractRenderer}(MyScript),function(scope){function TextRenderer(){scope.AbstractRenderer.call(this)}TextRenderer.prototype=new scope.AbstractRenderer,TextRenderer.prototype.constructor=TextRenderer,TextRenderer.prototype.drawRecognitionResult=function(inputUnits,recognitionResult,context,parameters){this.drawInputUnits(inputUnits,context,parameters)},TextRenderer.prototype.drawInputUnits=function(inputUnits,context,parameters){for(var i in inputUnits)this.drawComponents(inputUnits[i].getComponents(),context,parameters)},TextRenderer.prototype.drawComponents=function(components,context,parameters){for(var i in components){var component=components[i];if(component instanceof scope.Stroke)scope.AbstractRenderer.prototype.drawStroke.call(this,component,context,parameters);else if(component instanceof scope.CharacterInputComponent)scope.AbstractRenderer.prototype.drawCharacter.call(this,component,context,parameters);else if(component instanceof scope.CharInputComponent)drawChar(component,context,parameters);else{if(!(component instanceof scope.StringInputComponent))throw new Error("not implemented");drawString(component,context,parameters)}}};var drawChar=function(char,context,parameters){throw new Error("not implemented")},drawString=function(string,context,parameters){throw new Error("not implemented")};scope.TextRenderer=TextRenderer}(MyScript),function(scope){function ShapeRenderer(){scope.AbstractRenderer.call(this)}ShapeRenderer.prototype=new scope.AbstractRenderer,ShapeRenderer.prototype.constructor=ShapeRenderer,ShapeRenderer.prototype.drawRecognitionResult=function(components,recognitionResult,parameters,context){this.drawShapes(components,recognitionResult.getSegments(),parameters,context)},ShapeRenderer.prototype.drawComponents=function(components,context,parameters){for(var i in components){var component=components[i];if(component instanceof scope.Stroke)scope.AbstractRenderer.prototype.drawStroke.call(this,component,context,parameters);else if(component instanceof scope.CharacterInputComponent)scope.AbstractRenderer.prototype.drawCharacter.call(this,component,context,parameters);else if(component instanceof scope.ShapeEllipse)this.drawShapeEllipse(component,context,parameters);else{if(!(component instanceof scope.ShapeLine))throw new Error("not implemented");this.drawShapeLine(component,context,parameters)}}},ShapeRenderer.prototype.drawShapes=function(components,shapes,context,parameters){for(var i in shapes){var segment=shapes[i],candidate=segment.getSelectedCandidate();if(candidate)if(candidate instanceof scope.ShapeRecognized)this.drawShapeRecognized(candidate,context,parameters);else{if(!(candidate instanceof scope.ShapeNotRecognized))throw new Error("not implemented");this.drawShapeNotRecognized(components,segment.getInkRanges(),candidate,context,parameters)}}},ShapeRenderer.prototype.drawShapeRecognized=function(shapeRecognized,context,parameters){var primitives=shapeRecognized.getPrimitives();for(var i in primitives)this.drawShapePrimitive(primitives[i],context,parameters);var showBoundingBoxes=this.getParameters().getShowBoundingBoxes();if(parameters&&(showBoundingBoxes=parameters.getShowBoundingBoxes()),showBoundingBoxes){var rectangleList=[];for(var j in primitives)rectangleList.push(this.getPrimitiveBoundingBox(primitives[j]));var boundingRect=scope.MathUtils.getBoundingRect(rectangleList);this.drawRectangle(boundingRect,context,parameters)}},ShapeRenderer.prototype.drawShapeNotRecognized=function(components,inkRanges,shapeNotRecognized,context,parameters){for(var i in inkRanges){var extractedStrokes=this.extractStroke(components,inkRanges[i]);this.drawStrokes(extractedStrokes,context,parameters)}},ShapeRenderer.prototype.drawShapePrimitive=function(primitive,context,parameters){primitive instanceof scope.ShapeEllipse?this.drawShapeEllipse(primitive,context,parameters):primitive instanceof scope.ShapeLine&&this.drawShapeLine(primitive,context,parameters)},ShapeRenderer.prototype.drawShapeLine=function(shapeLine,context,parameters){this.drawLineByPoints(shapeLine.getFirstPoint(),shapeLine.getLastPoint(),context,parameters),shapeLine.hasBeginDecoration()&&"ARROW_HEAD"===shapeLine.getBeginDecoration()&&this.drawArrowHead(shapeLine.getFirstPoint(),shapeLine.getBeginTangentAngle(),12,context,parameters),shapeLine.hasEndDecoration()&&"ARROW_HEAD"===shapeLine.getEndDecoration()&&this.drawArrowHead(shapeLine.getLastPoint(),shapeLine.getEndTangentAngle(),12,context,parameters)},ShapeRenderer.prototype.drawEllipseArc=function(centerPoint,maxRadius,minRadius,orientation,startAngle,sweepAngle,context,parameters){var angleStep=.02,z1=Math.cos(orientation),z3=Math.sin(orientation),z2=z1,z4=z3;z1*=maxRadius,z2*=minRadius,z3*=maxRadius,z4*=minRadius;var n=Math.floor(Math.abs(sweepAngle)/angleStep),boundariesPoints=[];context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.parameters.getColor(),context.strokeStyle=this.parameters.getColor(),context.globalAlpha=this.parameters.getAlpha(),context.lineWidth=.5*this.parameters.getWidth()),context.beginPath();for(var i=0;n>=i;i++){var angle=startAngle+i/n*sweepAngle,alpha=Math.atan2(Math.sin(angle)/minRadius,Math.cos(angle)/maxRadius),cosAlpha=Math.cos(alpha),sinAlpha=Math.sin(alpha),x=centerPoint.x+z1*cosAlpha-z4*sinAlpha,y=centerPoint.y+z2*sinAlpha+z3*cosAlpha;0===i?context.moveTo(x,y):context.lineTo(x,y),(0===i||i===n)&&boundariesPoints.push({x:x,y:y})}context.stroke()}finally{context.restore()}return boundariesPoints},ShapeRenderer.prototype.drawShapeEllipse=function(shapeEllipse,context,parameters){var points=this.drawEllipseArc(shapeEllipse.getCenter(),shapeEllipse.getMaxRadius(),shapeEllipse.getMinRadius(),shapeEllipse.getOrientation(),shapeEllipse.getStartAngle(),shapeEllipse.getSweepAngle(),context,parameters);shapeEllipse.hasBeginDecoration()&&"ARROW_HEAD"===shapeEllipse.getBeginDecoration()&&this.drawArrowHead(points[0],shapeEllipse.getBeginTangentAngle(),12,context,parameters),shapeEllipse.hasEndDecoration()&&"ARROW_HEAD"===shapeEllipse.getEndDecoration()&&this.drawArrowHead(points[1],shapeEllipse.getEndTangentAngle(),12,context,parameters)},ShapeRenderer.prototype.getPrimitiveBoundingBox=function(primitive){var rectangle=null;return primitive instanceof scope.ShapeEllipse?rectangle=scope.MathUtils.getEllipseArcRect(primitive.getCenter(),primitive.getMaxRadius(),primitive.getMinRadius(),primitive.getOrientation(),primitive.getStartAngle(),primitive.getSweepAngle()):primitive instanceof scope.ShapeLine&&(rectangle=scope.MathUtils.getLineRect(primitive.getFirstPoint(),primitive.getLastPoint())),rectangle},scope.ShapeRenderer=ShapeRenderer}(MyScript),function(scope){function MathRenderer(){scope.AbstractRenderer.call(this)}MathRenderer.prototype=new scope.AbstractRenderer,MathRenderer.prototype.constructor=MathRenderer,MathRenderer.prototype.drawRecognitionResult=function(components,recognitionResult,context,parameters){var notScratchOutComponents=this.removeScratchOut(components,recognitionResult.getScratchOutResults());this.drawComponents(notScratchOutComponents,context,parameters)},MathRenderer.prototype.removeScratchOut=function(components,scratchOutResults){if(!scratchOutResults||0===scratchOutResults.length)return components;var cloneComponents=components.slice(0),componentsToRemove=[];for(var k in scratchOutResults)if(scratchOutResults[k].getErasedInkRanges()){for(var n in scratchOutResults[k].getErasedInkRanges())componentsToRemove.push(scratchOutResults[k].getErasedInkRanges()[n].getComponent());for(var p in scratchOutResults[k].getInkRanges())componentsToRemove.push(scratchOutResults[k].getInkRanges()[p].getComponent())}componentsToRemove.sort(function(a,b){return b-a});for(var z in componentsToRemove)cloneComponents.splice(componentsToRemove[z],1);return cloneComponents},scope.MathRenderer=MathRenderer}(MyScript),function(scope){function MusicRenderer(){scope.AbstractRenderer.call(this)}MusicRenderer.prototype=new scope.AbstractRenderer,MusicRenderer.prototype.constructor=MusicRenderer,MusicRenderer.prototype.drawRecognitionResult=function(components,recognitionResult,context,parameters){var notScratchOutComponents=this.removeScratchOut(components,recognitionResult.getScratchOutResults());this.drawComponents(notScratchOutComponents,context,parameters)},MusicRenderer.prototype.removeScratchOut=function(components,scratchOutResults){if(!scratchOutResults||0===scratchOutResults.length)return components;var cloneComponents=components.slice(0),componentsToRemove=[];for(var k in scratchOutResults)if(scratchOutResults[k].getErasedInputRanges()){for(var n in scratchOutResults[k].getErasedInputRanges())componentsToRemove.push(scratchOutResults[k].getErasedInputRanges()[n].getComponent());for(var p in scratchOutResults[k].getInputRanges())componentsToRemove.push(scratchOutResults[k].getInputRanges()[p].getComponent())}componentsToRemove.sort(function(a,b){return b-a});for(var z in componentsToRemove)cloneComponents.splice(componentsToRemove[z],1);return cloneComponents},MusicRenderer.prototype.drawStaff=function(staff,context,parameters){var staffHeight=staff.getTop()+(staff.getCount()-1)*staff.getGap(),staves=1;context.beginPath();for(var i=0;staves>i;i++)for(var offset=staffHeight*i,j=0;j<staff.getCount();j++)context.moveTo(0,staff.getTop()+offset+j*staff.getGap()),context.lineTo(context.canvas.clientWidth,staff.getTop()+offset+j*staff.getGap());context.stroke()},MusicRenderer.prototype.drawComponents=function(components,context,parameters){for(var i in components){var component=components[i];if(component instanceof scope.Stroke)scope.AbstractRenderer.prototype.drawStroke.call(this,component,context,parameters);else if(component instanceof scope.CharacterInputComponent)scope.AbstractRenderer.prototype.drawCharacter.call(this,component,context,parameters);else if(component instanceof scope.MusicAccidentalInputComponent)drawAccidental(component,context,parameters);else if(component instanceof scope.MusicArpeggiateInputComponent)drawArpeggiate(component,context,parameters);else if(component instanceof scope.MusicBarInputComponent)drawBar(component,context,parameters);else if(component instanceof scope.MusicBeamInputComponent)drawBeam(component,context,parameters);else if(component instanceof scope.MusicClefInputComponent)drawClef(component,context,parameters);else if(component instanceof scope.MusicDecorationInputComponent)drawDecoration(component,context,parameters);else if(component instanceof scope.MusicDotsInputComponent)drawDots(component,context,parameters);else if(component instanceof scope.MusicHeadInputComponent)drawHead(component,context,parameters);else if(component instanceof scope.MusicLedgerLineInputComponent)drawLedgerLine(component,context,parameters);else if(component instanceof scope.MusicRestInputComponent)drawRest(component,context,parameters);else if(component instanceof scope.MusicStemInputComponent)drawStem(component,context,parameters);else if(component instanceof scope.MusicTieOrSlurInputComponent)drawTieOrSlur(component,context,parameters);else{if(!(component instanceof scope.MusicTimeSignatureInputComponent))throw new Error("not implemented");drawTimeSignature(component,context,parameters)}}};var drawAccidental=function(accidental,context,parameters){throw new Error("not implemented")},drawArpeggiate=function(arpeggiate,context,parameters){throw new Error("not implemented")},drawBar=function(bar,context,parameters){throw new Error("not implemented")},drawBeam=function(beam,context,parameters){throw new Error("not implemented")},drawClef=function(clef,context,parameters){var src="data:image/svg+xml,";switch(clef.getValue().getSymbol()){case"F":src+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" x="0" y="0" width="18" height="20"><defs/><g transform="translate(6.600000e-3,3.125356e-3)"><g><path d="M17.3 3.1 C17.3 3.5 17.1 3.8 16.8 4.1 C16.5 4.4 15.9 4.5 15.5 4.3 C15 4.1 14.7 3.7 14.7 3.2 C14.6 2.8 14.8 2.5 15 2.2 C15.3 1.9 15.7 1.8 16 1.8 C16.4 1.8 16.8 2 17 2.3 C17.2 2.5 17.3 2.8 17.3 3.1 z"/></g><g><path d="M17.3 8.9 C17.3 9.3 17.1 9.7 16.8 9.9 C16.5 10.3 15.9 10.3 15.5 10.2 C15 10 14.7 9.5 14.7 9.1 C14.6 8.7 14.8 8.3 15 8 C15.3 7.8 15.7 7.6 16 7.6 C16.5 7.7 17 8 17.2 8.4 C17.2 8.6 17.3 8.8 17.3 8.9 z"/></g><g><path d="M13 7.2 C13 10 11.8 12.7 9.8 14.7 C7.3 17.2 4 18.8 0.7 19.8 C0.3 20.1 -0.4 19.8 0.3 19.4 C1.6 18.8 3 18.3 4.2 17.5 C7 15.8 9.3 13.1 9.8 9.9 C10.1 8 10.1 5.9 9.6 4 C9.2 2.6 8.2 1.1 6.7 0.9 C5.3 0.7 3.7 1.2 2.7 2.2 C2.5 2.4 2 3.2 2 4 C2.6 3.6 2.6 3.6 3.1 3.4 C4.2 2.9 5.7 3.6 6 4.9 C6.3 6 6.1 7.5 5 8.1 C3.8 8.7 2 8.5 1.4 7.2 C0.3 5.3 0.9 2.6 2.6 1.2 C4.4 -0.3 7.1 -0.3 9.2 0.4 C11.4 1.3 12.7 3.5 12.9 5.8 C13 6.2 13 6.7 13 7.2 z"/></g></g></svg>';break;case"C":src+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" width="18" height="25"><defs/><g><g transform="matrix(1,0,0,1.030698,-309.364,-543.8647)"><path d="M 325.9 546.8 C 325.8 548.7 324.7 550.7 322.8 551.5 C 321.1 552.1 319.1 552.2 317.6 551 C 316.6 550.2 316.2 548.4 317.3 547.5 C 318.3 546.5 320.4 547.4 320.3 548.9 C 320.7 549.9 318.5 550.5 319.7 551.3 C 321 551.6 322.3 550.5 322.6 549.3 C 323.1 547.5 323.1 545.6 322.7 543.8 C 322.4 542.9 321.9 541.5 320.7 541.9 C 319.2 542.2 318.3 543.8 317.9 545.1 C 317.6 543.2 316.4 541.5 315 540.2 C 315 544.1 315 548 315 551.9 L 314.1 551.9 C 314.1 543.9 314.1 535.7 314.1 527.7 L 315 527.7 C 315 531.5 315 535.5 315 539.4 C 316.4 538.1 317.6 536.4 317.8 534.5 C 318.3 535.9 319.3 537.5 321 537.8 C 322.2 537.8 322.5 536.3 322.8 535.4 C 323.1 533.7 323.1 531.8 322.6 530.1 C 322.2 529 320.9 528 319.6 528.3 C 318.6 529 320.6 529.6 320.3 530.6 C 320.5 532 318.8 533 317.6 532.3 C 316.3 531.6 316.4 529.7 317.4 528.8 C 318 528.1 319.3 527.7 320.3 527.7 C 321.2 527.7 321.8 527.7 322.6 528 C 324.6 528.7 325.7 530.7 325.9 532.7 C 326.2 534.9 324.9 537.3 322.8 538.2 C 321.5 538.7 319.9 538.3 318.8 537.3 C 318.7 538.3 318.2 539.2 317.7 539.9 C 318.1 540.6 318.6 541.8 318.8 542.1 C 320.1 540.9 322.5 540.8 323.8 542 C 325.2 543.1 326.1 545 325.9 546.8 z "/></g><g transform="matrix(1,0,0,1.030928,-309.364,-543.9805)"><path d="M 312.2 551.9 L 309.4 551.9 L 309.4 527.7 L 312.2 527.7 L 312.2 551.9 z "/></g></g></svg>';break;case"G":src+='<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" width="15" height="40"><defs/><path d="m 12 3.4 c 0.3 3.1 -2 5.6 -4.1 7.6 -0.9 0.9 -0.2 0.1 -0.6 0.6 -0.1 -0.5 -0.3 -1.7 -0.3 -2.1 0.1 -2.6 2.3 -6.5 4.2 -7.9 0.3 0.6 0.6 0.6 0.8 1.8 z m 0.7 15.9 c -1.2 -0.9 -2.8 -1.1 -4.3 -0.9 -0.2 -1.2 -0.4 -2.5 -0.6 -3.7 2.4 -2.3 4.9 -4.9 5 -8.4 0.1 -2.2 -0.3 -4.6 -1.7 -6.4 C 9.5 0.1 8.3 2.1 7.4 3.3 c -1.5 2.6 -1.1 5.8 -0.6 8.6 -0.8 0.9 -1.9 1.7 -2.7 2.7 -2.4 2.3 -4.4 5.3 -4 8.7 0.2 3.3 2.6 6.3 5.9 7.1 1.2 0.3 2.6 0.3 3.8 0.1 0.2 2.2 1 4.5 0.1 6.7 -0.7 1.6 -2.8 2.9 -4.3 2.2 -0.6 -0.3 -0.1 -0.1 -0.5 -0.2 1.1 -0.3 2 -1 2.3 -1.5 0.8 -1.4 -0.4 -3.6 -2.2 -3.3 -2.3 0 -3.2 3.1 -1.7 4.6 1.3 1.5 3.8 1.3 5.4 0.3 1.8 -1.2 2 -3.5 1.8 -5.5 -0.1 -0.7 -0.4 -2.6 -0.4 -3.3 0.7 -0.2 0.2 -0.1 1.2 -0.4 2.7 -1 4.4 -4.2 3.6 -7 -0.3 -1.4 -1 -2.9 -2.3 -3.7 z m 0.6 5.7 c 0.2 2 -1.1 4.2 -3.1 4.9 -0.1 -0.8 -0.2 -1 -0.3 -1.4 -0.5 -2.4 -0.7 -4.9 -1.1 -7.3 1.6 -0.2 3.5 0.5 4 2.1 0.2 0.6 0.3 1.2 0.4 1.8 z m -5.1 5.1 c -2.5 0.1 -5 -1.6 -5.6 -4 -0.7 -2.1 -0.5 -4.5 0.8 -6.4 1.1 -1.7 2.6 -3 4 -4.5 0.2 1.1 0.4 2.2 0.5 3.3 -3 0.8 -5 4.6 -3.2 7.3 0.5 0.8 2 2.2 2.8 1.6 -1.1 -0.7 -2 -1.8 -1.8 -3.2 -0.1 -1.3 1.4 -2.9 2.7 -3.1 0.4 2.8 0.9 6 1.4 8.8 -0.5 0.1 -1 0.1 -1.5 0.1 z"/></svg>';break;default:throw new Error("Unknown music clef symbol")}var imageObj=new Image;imageObj.onload=function(){var ratio=clef.getBoundingBox().getHeight()/this.height;clef.getBoundingBox().setWidth(this.width*ratio),context.drawImage(imageObj,clef.getBoundingBox().getX(),clef.getBoundingBox().getY(),clef.getBoundingBox().getWidth(),clef.getBoundingBox().getHeight())},imageObj.src=src},drawDecoration=function(decoration,context,parameters){throw new Error("not implemented")},drawDots=function(dots,context,parameters){throw new Error("not implemented")},drawHead=function(head,context,parameters){throw new Error("not implemented")},drawLedgerLine=function(ledgerLine,context,parameters){throw new Error("not implemented")},drawRest=function(rest,context,parameters){throw new Error("not implemented")},drawStem=function(stem,context,parameters){throw new Error("not implemented")},drawTieOrSlur=function(tieOrSlur,context,parameters){throw new Error("not implemented")},drawTimeSignature=function(timeSignature,context,parameters){throw new Error("not implemented")};scope.MusicRenderer=MusicRenderer}(MyScript),function(scope){function AnalyzerRenderer(){scope.AbstractRenderer.call(this)}AnalyzerRenderer.prototype=new scope.AbstractRenderer,AnalyzerRenderer.prototype.constructor=AnalyzerRenderer,AnalyzerRenderer.prototype.drawRecognitionResult=function(components,recognitionResult,context,parameters){this.drawShapes(components,recognitionResult.getShapes(),context,parameters),this.drawTables(components,recognitionResult.getTables(),context,parameters),this.drawTextLines(components,recognitionResult.getTextLines(),context,parameters)},AnalyzerRenderer.prototype.drawTables=function(components,tables,context,parameters){for(var i in tables){var showBoundingBoxes=this.getParameters().getShowBoundingBoxes();if(parameters&&(showBoundingBoxes=parameters.getShowBoundingBoxes()),showBoundingBoxes)for(var j in tables[i].getCells())this.drawCell(tables[i].getCells()[j],context,parameters);for(var k in tables[i].getLines())this.drawLine(tables[i].getLines()[k],context,parameters)}},AnalyzerRenderer.prototype.drawTextLines=function(components,textLines,context,parameters){for(var i in textLines){var textLine=textLines[i],data=textLine.getData();if(data){var showBoundingBoxes=this.getParameters().getShowBoundingBoxes();parameters&&(showBoundingBoxes=parameters.getShowBoundingBoxes()),showBoundingBoxes&&this.drawRectangle(data.getBoundingBox(),context,parameters);var text=textLine.getTextDocument().getTextSegment().getSelectedCandidate().getLabel();this.drawText(data.getBoundingBox(),text,data.getJustificationType(),data.getTextHeight(),data.getBaselinePos(),context,parameters);var underlines=textLine.getUnderlineList();for(var j in underlines)this.drawUnderline(data.getBoundingBox(),underlines[j],text,data.getTextHeight(),data.getBaselinePos()+data.getTextHeight()/10,context,parameters)}}},AnalyzerRenderer.prototype.drawText=function(boundingBox,text,justificationType,textHeight,baseline,context,parameters){context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth(),context.font=parameters.getDecoration()+textHeight+"px "+parameters.getFont()):(context.fillStyle=this.getParameters().getColor(),context.strokeStyle=this.getParameters().getColor(),context.globalAlpha=this.getParameters().getAlpha(),context.lineWidth=.5*this.getParameters().getWidth(),context.font=this.getParameters().getDecoration()+textHeight+"px "+this.parameters.getFont()),context.textAlign="CENTER"===justificationType?"center":"left",context.fillText(text,boundingBox.getX(),baseline,boundingBox.getWidth())}finally{context.restore()}},AnalyzerRenderer.prototype.drawUnderline=function(boundingBox,underline,text,textHeight,baseline,context,parameters){var topLeft=boundingBox.getTopLeftPoint(),firstCharacter=underline.getData().getFirstCharacter(),lastCharacter=underline.getData().getLastCharacter();parameters?context.font=parameters.getDecoration()+textHeight+"px "+parameters.getFont():context.font=this.getParameters().getDecoration()+textHeight+"px "+this.parameters.getFont();var textMetrics=context.measureText(text.substring(0,firstCharacter)),x1=topLeft.x+textMetrics.width;textMetrics=context.measureText(text.substring(firstCharacter,lastCharacter+1));var x2=x1+textMetrics.width;this.drawLine(new scope.AnalyzerLine({data:new scope.AnalyzerLineData({p1:{x:x1,y:baseline},p2:{x:x2,y:baseline}})}),context,parameters)},AnalyzerRenderer.prototype.drawGroups=function(components,groups,context,parameters){throw new Error("not implemented")},AnalyzerRenderer.prototype.drawLine=function(line,context,parameters){line.getData()&&this.drawLineByPoints(line.getData().getP1(),line.getData().getP2(),context,parameters)},AnalyzerRenderer.prototype.drawCell=function(cell,context,parameters){cell.getData()&&this.drawRectangle(cell.getData().getBoundingBox(),context,parameters)},AnalyzerRenderer.prototype.drawShapes=function(components,shapes,context,parameters){for(var i in shapes){var segment=shapes[i],candidate=segment.getSelectedCandidate();if(candidate)if(candidate instanceof scope.ShapeRecognized)this.drawShapeRecognized(candidate,context,parameters);else{if(!(candidate instanceof scope.ShapeNotRecognized))throw new Error("not implemented");this.drawShapeNotRecognized(components,segment.getInkRanges(),candidate,context,parameters)}}},AnalyzerRenderer.prototype.drawShapeRecognized=function(shapeRecognized,context,parameters){var primitives=shapeRecognized.getPrimitives();for(var i in primitives)this.drawShapePrimitive(primitives[i],context,parameters);var showBoundingBoxes=this.getParameters().getShowBoundingBoxes();if(parameters&&(showBoundingBoxes=parameters.getShowBoundingBoxes()),showBoundingBoxes){var rectangleList=[];for(var j in primitives)rectangleList.push(this.getPrimitiveBoundingBox(primitives[j]));var boundingRect=scope.MathUtils.getBoundingRect(rectangleList);this.drawRectangle(boundingRect,context,parameters)}},AnalyzerRenderer.prototype.drawShapeNotRecognized=function(components,inkRanges,shapeNotRecognized,context,parameters){for(var i in inkRanges){var extractedStrokes=this.extractStroke(components,inkRanges[i]);this.drawStrokes(extractedStrokes,context,parameters)}},AnalyzerRenderer.prototype.drawShapePrimitive=function(primitive,context,parameters){primitive instanceof scope.ShapeEllipse?this.drawShapeEllipse(primitive,context,parameters):primitive instanceof scope.ShapeLine&&this.drawShapeLine(primitive,context,parameters)},AnalyzerRenderer.prototype.drawShapeLine=function(shapeLine,context,parameters){
this.drawLineByPoints(shapeLine.getFirstPoint(),shapeLine.getLastPoint(),context,parameters),shapeLine.hasBeginDecoration()&&"ARROW_HEAD"===shapeLine.getBeginDecoration()&&this.drawArrowHead(shapeLine.getFirstPoint(),shapeLine.getBeginTangentAngle(),12,context,parameters),shapeLine.hasEndDecoration()&&"ARROW_HEAD"===shapeLine.getEndDecoration()&&this.drawArrowHead(shapeLine.getLastPoint(),shapeLine.getEndTangentAngle(),12,context,parameters)},AnalyzerRenderer.prototype.drawEllipseArc=function(centerPoint,maxRadius,minRadius,orientation,startAngle,sweepAngle,context,parameters){var angleStep=.02,z1=Math.cos(orientation),z3=Math.sin(orientation),z2=z1,z4=z3;z1*=maxRadius,z2*=minRadius,z3*=maxRadius,z4*=minRadius;var n=Math.floor(Math.abs(sweepAngle)/angleStep),boundariesPoints=[];context.save();try{parameters?(context.fillStyle=parameters.getColor(),context.strokeStyle=parameters.getColor(),context.globalAlpha=parameters.getAlpha(),context.lineWidth=.5*parameters.getWidth()):(context.fillStyle=this.getParameters().getColor(),context.strokeStyle=this.getParameters().getColor(),context.globalAlpha=this.getParameters().getAlpha(),context.lineWidth=.5*this.getParameters().getWidth()),context.beginPath();for(var i=0;n>=i;i++){var angle=startAngle+i/n*sweepAngle,alpha=Math.atan2(Math.sin(angle)/minRadius,Math.cos(angle)/maxRadius),cosAlpha=Math.cos(alpha),sinAlpha=Math.sin(alpha),x=centerPoint.x+z1*cosAlpha-z4*sinAlpha,y=centerPoint.y+z2*sinAlpha+z3*cosAlpha;0===i?context.moveTo(x,y):context.lineTo(x,y),(0===i||i===n)&&boundariesPoints.push({x:x,y:y})}context.stroke()}finally{context.restore()}return boundariesPoints},AnalyzerRenderer.prototype.drawShapeEllipse=function(shapeEllipse,context,parameters){var points=this.drawEllipseArc(shapeEllipse.getCenter(),shapeEllipse.getMaxRadius(),shapeEllipse.getMinRadius(),shapeEllipse.getOrientation(),shapeEllipse.getStartAngle(),shapeEllipse.getSweepAngle(),context,parameters);shapeEllipse.hasBeginDecoration()&&"ARROW_HEAD"===shapeEllipse.getBeginDecoration()&&this.drawArrowHead(points[0],shapeEllipse.getBeginTangentAngle(),12,context,parameters),shapeEllipse.hasEndDecoration()&&"ARROW_HEAD"===shapeEllipse.getEndDecoration()&&this.drawArrowHead(points[1],shapeEllipse.getEndTangentAngle(),12,context,parameters)},AnalyzerRenderer.prototype.getPrimitiveBoundingBox=function(primitive){var rectangle=null;return primitive instanceof scope.ShapeEllipse?rectangle=scope.MathUtils.getEllipseArcRect(primitive.getCenter(),primitive.getMaxRadius(),primitive.getMinRadius(),primitive.getOrientation(),primitive.getStartAngle(),primitive.getSweepAngle()):primitive instanceof scope.ShapeLine&&(rectangle=scope.MathUtils.getLineRect(primitive.getFirstPoint(),primitive.getLastPoint())),rectangle},scope.AnalyzerRenderer=AnalyzerRenderer}(MyScript);
//# sourceMappingURL=myscript.min.js.map