# [Java 24](https://openjdk.org/projects/jdk/24/)
- JEP404: [Generational Shenandoah (Experimental)](https://openjdk.org/jeps/404)
- JEP450: [Compact Object Headers (Experimental)](https://openjdk.org/jeps/450)
- JEP472: [Prepare to Restrict the Use of JNI](https://openjdk.org/jeps/472)
- JEP475: [Late Barrier Expansion for G1](https://openjdk.org/jeps/475)
- JEP478: [Key Derivation Function API (Preview)](https://openjdk.org/jeps/478)
- JEP479: [Remove the Windows 32-bit x86 Port](https://openjdk.org/jeps/479)
- JEP483: [Ahead-of-Time Class Loading & Linking](https://openjdk.org/jeps/483)
- JEP484: [Class-File API](https://openjdk.org/jeps/484)
- JEP485: [Stream Gatherers](https://openjdk.org/jeps/485)
- JEP486: [Permanently Disable the Security Manager](https://openjdk.org/jeps/486)
- JEP487: [Scoped Values (Fourth Preview)](https://openjdk.org/jeps/487)
- JEP488: [Primitive Types in Patterns, instanceof, and switch (Second Preview)](https://openjdk.org/jeps/488)
- JEP489: [Vector API (Ninth Incubator)](https://openjdk.org/jeps/489)
- JEP490: [ZGC: Remove the Non-Generational Mode](https://openjdk.org/jeps/490)
- JEP491: [Synchronize Virtual Threads without Pinning](https://openjdk.org/jeps/491)
- JEP492: [Flexible Constructor Bodies (Third Preview)](https://openjdk.org/jeps/492)
- JEP493: [Linking Run-Time Images without JMODs](https://openjdk.org/jeps/493)
- JEP494: [Module Import Declarations (Second Preview)](https://openjdk.org/jeps/494)
- JEP495: [Simple Source Files and Instance Main Methods (Fourth Preview)](https://openjdk.org/jeps/495)
- JEP496: [Quantum-Resistant Module-Lattice-Based Key Encapsulation Mechanism](https://openjdk.org/jeps/496)
- JEP497: [Quantum-Resistant Module-Lattice-Based Digital Signature Algorithm](https://openjdk.org/jeps/497)
- JEP498: [Warn upon Use of Memory-Access Methods in sun.misc.Unsafe](https://openjdk.org/jeps/498)
- JEP499: [Structured Concurrency (Fourth Preview)](https://openjdk.org/jeps/499)
- JEP501: [Deprecate the 32-bit x86 Port for Removal](https://openjdk.org/jeps/501)

# [Java 23](https://openjdk.org/projects/jdk/23/)
- JEP455: [Primitive Types in Patterns, instanceof, and switch (Preview)](https://openjdk.org/jeps/455)
- JEP466: [Class-File API (Second Preview)](https://openjdk.org/jeps/466)
- JEP467: [Markdown Documentation Comments](https://openjdk.org/jeps/467)
- JEP469: [Vector API (Eighth Incubator)](https://openjdk.org/jeps/469)
- JEP473: [Stream Gatherers (Second Preview)](https://openjdk.org/jeps/473)
- JEP471: [Deprecate the Memory-Access Methods in sun.misc.Unsafe for Removal](https://openjdk.org/jeps/471)
- JEP474: [ZGC: Generational Mode by Default](https://openjdk.org/jeps/474)
- JEP476: [Module Import Declarations (Preview)](https://openjdk.org/jeps/476)
- JEP477: [Implicitly Declared Classes and Instance Main Methods (Third Preview)](https://openjdk.org/jeps/477)
- JEP480: [Structured Concurrency (Third Preview)](https://openjdk.org/jeps/480)
- JEP481: [Scoped Values (Third Preview)](https://openjdk.org/jeps/481)
- JEP482: [Flexible Constructor Bodies (Second Preview)](https://openjdk.org/jeps/482)

# [Java 22](https://openjdk.org/projects/jdk/22/)
- JEP423: [Region Pinning for G1](https://openjdk.org/jeps/423)
- JEP447: [Statements before super(...) (Preview)](https://openjdk.org/jeps/447)
- JEP454: [Foreign Function & Memory API](https://openjdk.org/jeps/454)
- JEP456: [Unnamed Variables & Patterns](https://openjdk.org/jeps/456)
- JEP457: [Class-File API (Preview)](https://openjdk.org/jeps/457)
- JEP458: [Launch Multi-File Source-Code Programs](https://openjdk.org/jeps/458)
- JEP459: [String Templates (Second Preview)](https://openjdk.org/jeps/459)
- JEP460: [Vector API (Seventh Incubator)](https://openjdk.org/jeps/460)
- JEP461: [Stream Gatherers (Preview)](https://openjdk.org/jeps/461)
- JEP462: [Structured Concurrency (Second Preview)](https://openjdk.org/jeps/462)
- JEP463: [Implicitly Declared Classes and Instance Main Methods (Second Preview)](https://openjdk.org/jeps/463)
- JEP464: [Scoped Values (Second Preview)](https://openjdk.org/jeps/464)

# [Java 21](https://openjdk.org/projects/jdk/21/)
- JEP430: [String Templates (Preview)](https://openjdk.org/jeps/430)
- JEP431: [Sequenced Collections](https://openjdk.org/jeps/431)
- JEP439: [Generational ZGC](https://openjdk.org/jeps/439)
- JEP440: [Record Patterns](https://openjdk.org/jeps/440)
- JEP441: [Pattern Matching for switch](https://openjdk.org/jeps/441)
- JEP442: [Foreign Function & Memory API (Third Preview)](https://openjdk.org/jeps/442)
- JEP443: [Unnamed Patterns and Variables (Preview)](https://openjdk.org/jeps/443)
- JEP444: [Virtual Threads](https://openjdk.org/jeps/444)
- JEP445: [Unnamed Classes and Instance Main Methods (Preview)](https://openjdk.org/jeps/445)
- JEP446: [Scoped Values (Preview)](https://openjdk.org/jeps/446)
- JEP448: [Vector API (Sixth Incubator)](https://openjdk.org/jeps/448)
- JEP449: [Deprecate the Windows 32-bit x86 Port for Removal](https://openjdk.org/jeps/449)
- JEP451: [Prepare to Disallow the Dynamic Loading of Agents](https://openjdk.org/jeps/451)
- JEP452: [Key Encapsulation Mechanism API](https://openjdk.org/jeps/452)
- JEP453: [Structured Concurrency (Preview)](https://openjdk.org/jeps/453)

# [Java 20](https://openjdk.org/projects/jdk/20/)
- JEP429: [Scoped Values (Incubator)](https://openjdk.org/jeps/429)
- JEP432: [Record Patterns (Second Preview)](https://openjdk.org/jeps/432)
- JEP433: [Pattern Matching for switch (Fourth Preview)](https://openjdk.org/jeps/433)
- JEP434: [Foreign Function & Memory API (Second Preview)](https://openjdk.org/jeps/434)
- JEP436: [Virtual Threads (Second Preview)](https://openjdk.org/jeps/436)
- JEP437: [Structured Concurrency (Second Incubator)](https://openjdk.org/jeps/437)
- JEP438: [Vector API (Fifth Incubator)](https://openjdk.org/jeps/438)

# [Java 19](https://openjdk.org/projects/jdk/19/)
- JEP405: [Record Patterns (Preview)](https://openjdk.org/jeps/405)
- JEP422: [Linux/RISC-V Port](https://openjdk.org/jeps/422)
- JEP424: [Foreign Function & Memory API (Preview)](https://openjdk.org/jeps/424)
- JEP425: [Virtual Threads (Preview)](https://openjdk.org/jeps/425)
- JEP426: [Vector API (Fourth Incubator)](https://openjdk.org/jeps/426)
- JEP427: [Pattern Matching for switch (Third Preview)](https://openjdk.org/jeps/427)
- JEP428: [Structured Concurrency (Incubator)](https://openjdk.org/jeps/428)

# [Java 18](https://openjdk.org/projects/jdk/18/)
- JEP400: [UTF-8 by Default](https://openjdk.org/jeps/400)
- JEP408: [Simple Web Server](https://openjdk.org/jeps/408)
- JEP413: [Code Snippets in Java API Documentation](https://openjdk.org/jeps/413)
- JEP416: [Reimplement Core Reflection with Method Handles](https://openjdk.org/jeps/416)
- JEP417: [Vector API (Third Incubator)](https://openjdk.org/jeps/417)
- JEP418: [Internet-Address Resolution SPI](https://openjdk.org/jeps/418)
- JEP419: [Foreign Function & Memory API (Second Incubator)](https://openjdk.org/jeps/419)
- JEP420: [Pattern Matching for switch (Second Preview)](https://openjdk.org/jeps/420)
- JEP421: [Deprecate Finalization for Removal](https://openjdk.org/jeps/421)

# [Java 17](https://openjdk.org/projects/jdk/17/)
- JEP306: [Restore Always-Strict Floating-Point Semantics](https://openjdk.org/jeps/306)
- JEP356: [Enhanced Pseudo-Random Number Generators](https://openjdk.org/jeps/356)
- JEP382: [New macOS Rendering Pipeline](https://openjdk.org/jeps/382)
- JEP391: [macOS/AArch64 Port](https://openjdk.org/jeps/391)
- JEP398: [Deprecate the Applet API for Removal](https://openjdk.org/jeps/398)
- JEP403: [Strongly Encapsulate JDK Internals](https://openjdk.org/jeps/403)
- JEP406: [Pattern Matching for switch (Preview)](https://openjdk.org/jeps/406)
- JEP407: [Remove RMI Activation](https://openjdk.org/jeps/407)
- JEP409: [Sealed Classes](https://openjdk.org/jeps/409)
- JEP410: [Remove the Experimental AOT and JIT Compiler](https://openjdk.org/jeps/410)
- JEP411: [Deprecate the Security Manager for Removal](https://openjdk.org/jeps/411)
- JEP412: [Foreign Function & Memory API (Incubator)](https://openjdk.org/jeps/412)
- JEP414: [Vector API (Second Incubator)](https://openjdk.org/jeps/414)
- JEP415: [Context-Specific Deserialization Filters](https://openjdk.org/jeps/415)

# [Java 16](https://openjdk.org/projects/jdk/16/)
- JEP338: [Vector API (Incubator)](https://openjdk.org/jeps/338)
- JEP347: [Enable C++14 Language Features](https://openjdk.org/jeps/347)
- JEP357: [Migrate from Mercurial to Git](https://openjdk.org/jeps/357)
- JEP369: [Migrate to GitHub](https://openjdk.org/jeps/369)
- JEP376: [ZGC: Concurrent Thread-Stack Processing](https://openjdk.org/jeps/376)
- JEP380: [Unix-Domain Socket Channels](https://openjdk.org/jeps/380)
- JEP386: [Alpine Linux Port](https://openjdk.org/jeps/386)
- JEP387: [Elastic Metaspace](https://openjdk.org/jeps/387)
- JEP388: [Windows/AArch64 Port](https://openjdk.org/jeps/388)
- JEP389: [Foreign Linker API (Incubator)](https://openjdk.org/jeps/389)
- JEP390: [Warnings for Value-Based Classes](https://openjdk.org/jeps/390)
- JEP392: [Packaging Tool](https://openjdk.org/jeps/392)
- JEP393: [Foreign-Memory Access API (Third Incubator)](https://openjdk.org/jeps/393)
- JEP394: [Pattern Matching for instanceof](https://openjdk.org/jeps/394)
- JEP395: [Records](https://openjdk.org/jeps/395)
- JEP396: [Strongly Encapsulate JDK Internals by Default](https://openjdk.org/jeps/396)
- JEP397: [Sealed Classes (Second Preview)](https://openjdk.org/jeps/397)

# [Java 15](https://openjdk.org/projects/jdk/15/)
- JEP339: [Edwards-Curve Digital Signature Algorithm (EdDSA)](https://openjdk.org/jeps/339)
- JEP360: [Sealed Classes (Preview)](https://openjdk.org/jeps/360)
- JEP371: [Hidden Classes](https://openjdk.org/jeps/371)
- JEP372: [Remove the Nashorn JavaScript Engine](https://openjdk.org/jeps/372)
- JEP373: [Reimplement the Legacy DatagramSocket API](https://openjdk.org/jeps/373)
- JEP374: [Disable and Deprecate Biased Locking](https://openjdk.org/jeps/374)
- JEP375: [Pattern Matching for instanceof (Second Preview)](https://openjdk.org/jeps/375)
- JEP377: [ZGC: A Scalable Low-Latency Garbage Collector](https://openjdk.org/jeps/377)
- JEP378: [Text Blocks](https://openjdk.org/jeps/378)
- JEP379: [Shenandoah: A Low-Pause-Time Garbage Collector](https://openjdk.org/jeps/379)
- JEP381: [Remove the Solaris and SPARC Ports](https://openjdk.org/jeps/381)
- JEP383: [Foreign-Memory Access API (Second Incubator)](https://openjdk.org/jeps/383)
- JEP384: [Records (Second Preview)](https://openjdk.org/jeps/384)
- JEP385: [Deprecate RMI Activation for Removal](https://openjdk.org/jeps/385)

# [Java 14](https://openjdk.org/projects/jdk/14/)
- JEP305: [Pattern Matching for instanceof (Preview)](https://openjdk.org/jeps/305)
- JEP343: [Packaging Tool (Incubator)](https://openjdk.org/jeps/343)
- JEP345: [NUMA-Aware Memory Allocation for G1](https://openjdk.org/jeps/345)
- JEP349: [JFR Event Streaming](https://openjdk.org/jeps/349)
- JEP352: [Non-Volatile Mapped Byte Buffers](https://openjdk.org/jeps/352)
- JEP358: [Helpful NullPointerExceptions](https://openjdk.org/jeps/358)
- JEP359: [Records (Preview)](https://openjdk.org/jeps/359)
- JEP361: [Switch Expressions (Standard)](https://openjdk.org/jeps/361)
- JEP362: [Deprecate the Solaris and SPARC Ports](https://openjdk.org/jeps/362)
- JEP363: [Remove the Concurrent Mark Sweep (CMS) Garbage Collector](https://openjdk.org/jeps/363)
- JEP364: [ZGC on macOS](https://openjdk.org/jeps/364)
- JEP365: [ZGC on Windows](https://openjdk.org/jeps/365)
- JEP366: [Deprecate the ParallelScavenge + SerialOld GC Combination](https://openjdk.org/jeps/366)
- JEP367: [Remove the Pack200 Tools and API](https://openjdk.org/jeps/367)
- JEP368: [Text Blocks (Second Preview)](https://openjdk.org/jeps/368)
- JEP370: [Foreign-Memory Access API (Incubator)](https://openjdk.org/jeps/370)

# [Java 13](https://openjdk.org/projects/jdk/13/)
- JEP350: [Dynamic CDS Archives](https://openjdk.org/jeps/350)
- JEP351: [ZGC: Uncommit Unused Memory](https://openjdk.org/jeps/351)
- JEP353: [Reimplement the Legacy Socket API](https://openjdk.org/jeps/353)
- JEP354: [Switch Expressions (Preview)](https://openjdk.org/jeps/354)
- JEP355: [Text Blocks (Preview)](https://openjdk.org/jeps/355)

# [Java 12](https://openjdk.org/projects/jdk/12/)
- JEP189: [Shenandoah: A Low-Pause-Time Garbage Collector (Experimental)](https://openjdk.org/jeps/189)
- JEP230: [Microbenchmark Suite](https://openjdk.org/jeps/230)
- JEP325: [Switch Expressions (Preview)](https://openjdk.org/jeps/325)
- JEP334: [JVM Constants API](https://openjdk.org/jeps/334)
- JEP340: [One AArch64 Port, Not Two](https://openjdk.org/jeps/340)
- JEP341: [Default CDS Archives](https://openjdk.org/jeps/341)
- JEP344: [Abortable Mixed Collections for G1](https://openjdk.org/jeps/344)
- JEP346: [Promptly Return Unused Committed Memory from G1](https://openjdk.org/jeps/346)

# [Java 11](https://openjdk.org/projects/jdk/11/)
- JEP181: [Nest-Based Access Control](https://openjdk.org/jeps/181)
- JEP309: [Dynamic Class-File Constants](https://openjdk.org/jeps/309)
- JEP315: [Improve Aarch64 Intrinsics](https://openjdk.org/jeps/315)
- JEP318: [Epsilon](https://openjdk.org/jeps/318)
- JEP320: [Remove the Java EE and CORBA Modules](https://openjdk.org/jeps/320)
- JEP321: [HTTP Client (Standard)](https://openjdk.org/jeps/321)
- JEP323: [Local-Variable Syntax for Lambda Parameters](https://openjdk.org/jeps/323)
- JEP324: [Key Agreement with Curve25519 and Curve448](https://openjdk.org/jeps/324)
- JEP327: [Unicode 10](https://openjdk.org/jeps/327)
- JEP328: [Flight Recorder](https://openjdk.org/jeps/328)
- JEP329: [ChaCha20 and Poly1305 Cryptographic Algorithms](https://openjdk.org/jeps/329)
- JEP330: [Launch Single-File Source-Code Programs](https://openjdk.org/jeps/330)
- JEP331: [Low-Overhead Heap Profiling](https://openjdk.org/jeps/331)
- JEP332: [Transport Layer Security (TLS) 1.3](https://openjdk.org/jeps/332)
- JEP333: [ZGC](https://openjdk.org/jeps/333)
- JEP335: [Deprecate the Nashorn JavaScript Engine](https://openjdk.org/jeps/335)
- JEP336: [Deprecate the Pack200 Tools and API](https://openjdk.org/jeps/336)

# [Java 10](https://openjdk.org/projects/jdk/10/)
- JEP286: [Local-Variable Type Inference](https://openjdk.org/jeps/286)
- JEP296: [Consolidate the JDK Forest into a Single Repository](https://openjdk.org/jeps/296)
- JEP304: [Garbage-Collector Interface](https://openjdk.org/jeps/304)
- JEP307: [Parallel Full GC for G1](https://openjdk.org/jeps/307)
- JEP310: [Application Class-Data Sharing](https://openjdk.org/jeps/310)
- JEP312: [Thread-Local Handshakes](https://openjdk.org/jeps/312)
- JEP313: [Remove the Native-Header Generation Tool (javah)](https://openjdk.org/jeps/313)
- JEP314: [Additional Unicode Language-Tag Extensions](https://openjdk.org/jeps/314)
- JEP316: [Heap Allocation on Alternative Memory Devices](https://openjdk.org/jeps/316)
- JEP317: [Experimental Java-Based JIT Compiler](https://openjdk.org/jeps/317)
- JEP319: [Root Certificates](https://openjdk.org/jeps/319)
- JEP322: [Time-Based Release Versioning](https://openjdk.org/jeps/322)

# [Java 9](https://openjdk.org/projects/jdk9/)
- JEP102: [Process API Updates](https://openjdk.org/jeps/102)
- JEP110: [HTTP 2 Client](https://openjdk.org/jeps/110)
- JEP143: [Improve Contended Locking](https://openjdk.org/jeps/143)
- JEP158: [Unified JVM Logging](https://openjdk.org/jeps/158)
- JEP165: [Compiler Control](https://openjdk.org/jeps/165)
- JEP193: [Variable Handles](https://openjdk.org/jeps/193)
- JEP197: [Segmented Code Cache](https://openjdk.org/jeps/197)
- JEP199: [Smart Java Compilation, Phase Two](https://openjdk.org/jeps/199)
- JEP200: [The Modular JDK](https://openjdk.org/jeps/200)
- JEP201: [Modular Source Code](https://openjdk.org/jeps/201)
- JEP211: [Elide Deprecation Warnings on Import Statements](https://openjdk.org/jeps/211)
- JEP212: [Resolve Lint and Doclint Warnings](https://openjdk.org/jeps/212)
- JEP213: [Milling Project Coin](https://openjdk.org/jeps/213)
- JEP214: [Remove GC Combinations Deprecated in JDK 8](https://openjdk.org/jeps/214)
- JEP215: [Tiered Attribution for javac](https://openjdk.org/jeps/215)
- JEP216: [Process Import Statements Correctly](https://openjdk.org/jeps/216)
- JEP217: [Annotations Pipeline 2.0](https://openjdk.org/jeps/217)
- JEP219: [Datagram Transport Layer Security (DTLS)](https://openjdk.org/jeps/219)
- JEP220: [Modular Run-Time Images](https://openjdk.org/jeps/220)
- JEP221: [Simplified Doclet API](https://openjdk.org/jeps/221)
- JEP222: [jshell](https://openjdk.org/jeps/222)
- JEP223: [New Version-String Scheme](https://openjdk.org/jeps/223)
- JEP224: [HTML5 Javadoc](https://openjdk.org/jeps/224)
- JEP225: [Javadoc Search](https://openjdk.org/jeps/225)
- JEP226: [UTF-8 Property Files](https://openjdk.org/jeps/226)
- JEP227: [Unicode 7.0](https://openjdk.org/jeps/227)
- JEP228: [Add More Diagnostic Commands](https://openjdk.org/jeps/228)
- JEP229: [Create PKCS12 Keystores by Default](https://openjdk.org/jeps/229)
- JEP231: [Remove Launch-Time JRE Version Selection](https://openjdk.org/jeps/231)
- JEP232: [Improve Secure Application Performance](https://openjdk.org/jeps/232)
- JEP233: [Generate Run-Time Compiler Tests Automatically](https://openjdk.org/jeps/233)
- JEP235: [Test Class-File Attributes Generated by javac](https://openjdk.org/jeps/235)
- JEP236: [Parser API for Nashorn](https://openjdk.org/jeps/236)
- JEP237: [Linux/AArch64 Port](https://openjdk.org/jeps/237)
- JEP238: [Multi-Release JAR Files](https://openjdk.org/jeps/238)
- JEP240: [Remove the JVM TI hprof Agent](https://openjdk.org/jeps/240)
- JEP241: [Remove the jhat Tool](https://openjdk.org/jeps/241)
- JEP243: [Java-Level JVM Compiler Interface](https://openjdk.org/jeps/243)
- JEP244: [TLS Application-Layer Protocol Negotiation Extension](https://openjdk.org/jeps/244)
- JEP245: [Validate JVM Command-Line Flag Arguments](https://openjdk.org/jeps/245)
- JEP246: [Leverage CPU Instructions for GHASH and RSA](https://openjdk.org/jeps/246)
- JEP247: [Compile for Older Platform Versions](https://openjdk.org/jeps/247)
- JEP248: [Make G1 the Default Garbage Collector](https://openjdk.org/jeps/248)
- JEP249: [OCSP Stapling for TLS](https://openjdk.org/jeps/249)
- JEP250: [Store Interned Strings in CDS Archives](https://openjdk.org/jeps/250)
- JEP251: [Multi-Resolution Images](https://openjdk.org/jeps/251)
- JEP252: [Use CLDR Locale Data by Default](https://openjdk.org/jeps/252)
- JEP253: [Prepare JavaFX UI Controls & CSS APIs for Modularization](https://openjdk.org/jeps/253)
- JEP254: [Compact Strings](https://openjdk.org/jeps/254)
- JEP255: [Merge Selected Xerces 2.11.0 Updates into JAXP](https://openjdk.org/jeps/255)
- JEP256: [BeanInfo Annotations](https://openjdk.org/jeps/256)
- JEP257: [Update JavaFX/Media to Newer Version of GStreamer](https://openjdk.org/jeps/257)
- JEP258: [HarfBuzz Font-Layout Engine](https://openjdk.org/jeps/258)
- JEP259: [Stack-Walking API](https://openjdk.org/jeps/259)
- JEP260: [Encapsulate Most Internal APIs](https://openjdk.org/jeps/260)
- JEP261: [Module System](https://openjdk.org/jeps/261)
- JEP262: [TIFF Image I/O](https://openjdk.org/jeps/262)
- JEP263: [HiDPI Graphics on Windows and Linux](https://openjdk.org/jeps/263)
- JEP264: [Platform Logging API and Service](https://openjdk.org/jeps/264)
- JEP265: [Marlin Graphics Renderer](https://openjdk.org/jeps/265)
- JEP266: [More Concurrency Updates](https://openjdk.org/jeps/266)
- JEP267: [Unicode 8.0](https://openjdk.org/jeps/267)
- JEP268: [XML Catalogs](https://openjdk.org/jeps/268)
- JEP269: [Convenience Factory Methods for Collections](https://openjdk.org/jeps/269)
- JEP270: [Reserved Stack Areas for Critical Sections](https://openjdk.org/jeps/270)
- JEP271: [Unified GC Logging](https://openjdk.org/jeps/271)
- JEP272: [Platform-Specific Desktop Features](https://openjdk.org/jeps/272)
- JEP273: [DRBG-Based SecureRandom Implementations](https://openjdk.org/jeps/273)
- JEP274: [Enhanced Method Handles](https://openjdk.org/jeps/274)
- JEP275: [Modular Java Application Packaging](https://openjdk.org/jeps/275)
- JEP276: [Dynamic Linking of Language-Defined Object Models](https://openjdk.org/jeps/276)
- JEP277: [Enhanced Deprecation](https://openjdk.org/jeps/277)
- JEP278: [Additional Tests for Humongous Objects in G1](https://openjdk.org/jeps/278)
- JEP279: [Improve Test-Failure Troubleshooting](https://openjdk.org/jeps/279)
- JEP280: [Indify String Concatenation](https://openjdk.org/jeps/280)
- JEP281: [HotSpot C++ Unit-Test Framework](https://openjdk.org/jeps/281)
- JEP282: [jlink](https://openjdk.org/jeps/282)
- JEP283: [Enable GTK 3 on Linux](https://openjdk.org/jeps/283)
- JEP284: [New HotSpot Build System](https://openjdk.org/jeps/284)
- JEP285: [Spin-Wait Hints](https://openjdk.org/jeps/285)
- JEP287: [SHA-3 Hash Algorithms](https://openjdk.org/jeps/287)
- JEP288: [Disable SHA-1 Certificates](https://openjdk.org/jeps/288)
- JEP289: [Deprecate the Applet API](https://openjdk.org/jeps/289)
- JEP290: [Filter Incoming Serialization Data](https://openjdk.org/jeps/290)
- JEP291: [Deprecate the Concurrent Mark Sweep (CMS) Garbage Collector](https://openjdk.org/jeps/291)
- JEP292: [Implement Selected ECMAScript 6 Features in Nashorn](https://openjdk.org/jeps/292)
- JEP294: [Linux/s390x Port](https://openjdk.org/jeps/294)
- JEP295: [Ahead-of-Time Compilation](https://openjdk.org/jeps/295)
- JEP297: [Unified arm32/arm64 Port](https://openjdk.org/jeps/297)
- JEP298: [Remove Demos and Samples](https://openjdk.org/jeps/298)
- JEP299: [Reorganize Documentation](https://openjdk.org/jeps/299)

# [Java 8](https://openjdk.org/projects/jdk8/)([Feature](https://openjdk.org/projects/jdk8/milestones))
- JEP117: [Remove the Annotation-Processing Tool (apt)](http://openjdk.java.net/jeps/117)
- JEP124: [Enhance the Certificate Revocation-Checking API](http://openjdk.java.net/jeps/124)
- JEP130: [SHA-224 Message Digests](http://openjdk.java.net/jeps/130)
- JEP131: [PKCS#11 Crypto Provider for 64-bit Windows](http://openjdk.java.net/jeps/131)
- JEP112: [Charset Implementation Improvements](http://openjdk.java.net/jeps/112)
- JEP129: [NSA Suite B Cryptographic Algorithms](http://openjdk.java.net/jeps/129)
- JEP105: [DocTree API](http://openjdk.java.net/jeps/105)
- JEP106: [Add Javadoc to javax.tools](http://openjdk.java.net/jeps/106)
- JEP113: [MS-SFU Kerberos 5 Extensions](http://openjdk.java.net/jeps/113)
- JEP114: [TLS Server Name Indication (SNI) Extension](http://openjdk.java.net/jeps/114)
- JEP121: [Stronger Algorithms for Password-Based Encryption](http://openjdk.java.net/jeps/121)
- JEP122: [Remove the Permanent Generation](http://openjdk.java.net/jeps/122)
- JEP127: [Improve Locale Data Packaging and Adopt Unicode CLDR Data](http://openjdk.java.net/jeps/127)
- JEP128: [BCP 47 Locale Matching](http://openjdk.java.net/jeps/128)
- JEP133: [Unicode 6.2](http://openjdk.java.net/jeps/133)
- JEP136: [Enhanced Verification Errors](http://openjdk.java.net/jeps/136)
- JEP153: [Launch JavaFX Applications](http://openjdk.java.net/jeps/153)
- JEP177: [Optimize java.text.DecimalFormat.format](http://openjdk.java.net/jeps/177)
- JEP103: [Parallel Array Sorting](http://openjdk.java.net/jeps/103)
- JEP135: [Base64 Encoding & Decoding](http://openjdk.java.net/jeps/135)
- JEP138: [Autoconf-Based Build System](http://openjdk.java.net/jeps/138)
- JEP139: [Enhance javac to Improve Build Speed](http://openjdk.java.net/jeps/139)
- JEP142: [Reduce Cache Contention on Specified Fields](http://openjdk.java.net/jeps/142)
- JEP147: [Reduce Class Metadata Footprint](http://openjdk.java.net/jeps/147)
- JEP148: [Small VM](http://openjdk.java.net/jeps/148)
- JEP149: [Reduce Core-Library Memory Usage](http://openjdk.java.net/jeps/149)
- JEP150: [Date & Time API](http://openjdk.java.net/jeps/150)
- JEP160: [Lambda-Form Representation for Method Handles](http://openjdk.java.net/jeps/160)
- JEP164: [Leverage CPU Instructions for AES Cryptography](http://openjdk.java.net/jeps/164)
- JEP166: [Overhaul JKS-JCEKS-PKCS12 Keystores](http://openjdk.java.net/jeps/166)
- JEP170: [JDBC 4.2](http://openjdk.java.net/jeps/170)
- JEP172: [DocLint](http://openjdk.java.net/jeps/172)
- JEP173: [Retire Some Rarely-Used GC Combinations](http://openjdk.java.net/jeps/173)
- JEP101: [Generalized Target-Type Inference](http://openjdk.java.net/jeps/101)
- JEP104: [Annotations on Java Types](http://openjdk.java.net/jeps/104)
- JEP107: [Bulk Data Operations for Collections](http://openjdk.java.net/jeps/107)
- JEP109: [Enhance Core Libraries with Lambda](http://openjdk.java.net/jeps/109)
- JEP115: [AEAD CipherSuites](http://openjdk.java.net/jeps/115)
- JEP118: [Access to Parameter Names at Runtime](http://openjdk.java.net/jeps/118)
- JEP119: [javax.lang.model Implementation Backed by Core Reflection](http://openjdk.java.net/jeps/119)
- JEP120: [Repeating Annotations](http://openjdk.java.net/jeps/120)
- JEP123: [Configurable Secure Random-Number Generation](http://openjdk.java.net/jeps/123)
- JEP126: [Lambda Expressions & Virtual Extension Methods](http://openjdk.java.net/jeps/126)
- JEP140: [Limited doPrivileged](http://openjdk.java.net/jeps/140)
- JEP155: [Concurrency Updates](http://openjdk.java.net/jeps/155)
- JEP161: [Compact Profiles](http://openjdk.java.net/jeps/161)
- JEP162: [Prepare for Modularization](http://openjdk.java.net/jeps/162)
- JEP171: [Fence Intrinsics](http://openjdk.java.net/jeps/171)
- JEP174: [Nashorn JavaScript Engine](http://openjdk.java.net/jeps/174)
- JEP176: [Mechanical Checking of Caller-Sensitive Methods](http://openjdk.java.net/jeps/176)
- JEP178: [Statically-Linked JNI Libraries](http://openjdk.java.net/jeps/178)
- JEP179: [Document JDK API Support and Stability](http://openjdk.java.net/jeps/179)
- JEP180: [Handle Frequent HashMap Collisions with Balanced Trees](http://openjdk.java.net/jeps/180)
- JEP184: [HTTP URL Permissions](http://openjdk.java.net/jeps/184)
- JEP185: [Restrict Fetching of External XML Resources](http://openjdk.java.net/jeps/185)

# [Java 7](https://openjdk.org/projects/jdk7/)([Feature](https://openjdk.org/projects/jdk7/milestones/))
## vm
- [JSR 292: Support for dynamically-typed languages (InvokeDynamic)](https://openjdk.org/projects/jdk7/features/#f353)
- [Strict class-file checking](https://openjdk.org/projects/jdk7/features/#fa535991)

## lang
- [JSR 334: Small language enhancements (Project Coin)](https://openjdk.org/projects/jdk7/features/#f618)

## core
- [Upgrade class-loader architecture](https://openjdk.org/projects/jdk7/features/#f352)
- [Method to close a URLClassLoader](https://openjdk.org/projects/jdk7/features/#f584)
- [Concurrency and collections updates (jsr166y)](https://openjdk.org/projects/jdk7/features/#f515)

## i18n
- [Unicode 6.0](https://openjdk.org/projects/jdk7/features/#f497)
- [Locale enhancement](https://openjdk.org/projects/jdk7/features/#fa535895)
- [Separate user locale and user-interface locale](https://openjdk.org/projects/jdk7/features/#fa538265)

## ionet
- [JSR 203: More new I/O APIs for the Java platform (NIO.2)](https://openjdk.org/projects/jdk7/features/#f250)
- [NIO.2 filesystem provider for zip/jar archives](https://openjdk.org/projects/jdk7/features/#fa537814)
- [SCTP (Stream Control Transmission Protocol)](https://openjdk.org/projects/jdk7/features/#f405)
- [SDP (Sockets Direct Protocol)](https://openjdk.org/projects/jdk7/features/#f639)
- [Use the Windows Vista IPv6 stack](https://openjdk.org/projects/jdk7/features/#fa535996)
- [TLS 1.2](https://openjdk.org/projects/jdk7/features/#fa534339)

## sec
- [Elliptic-curve cryptography (ECC)](https://openjdk.org/projects/jdk7/features/#f73)

## jdbc
- [JDBC 4.1](https://openjdk.org/projects/jdk7/features/#fa539110)

## client
- [XRender pipeline for Java 2D](https://openjdk.org/projects/jdk7/features/#f653)
- [Create new platform APIs for 6u10 graphics features](https://openjdk.org/projects/jdk7/features/#f650)
- [Nimbus look-and-feel for Swing](https://openjdk.org/projects/jdk7/features/#f244)
- [Swing JLayer component](https://openjdk.org/projects/jdk7/features/#f652)
- [Gervill sound synthesizer](https://openjdk.org/projects/jdk7/features/#fa99999)

## web
- [Update the XML stack](https://openjdk.org/projects/jdk7/features/#f568)

## mgmt
- [Enhanced MBeans](https://openjdk.org/projects/jdk7/features/#fa530068)
