
# San Andreas Unity

<br>

<div align="center">
    <img src="https://i.imgur.com/aIojfPW.png" width="320" height="320">
    <br>
    <a href="https://discord.gg/p6jjud5"> <img src="https://img.shields.io/discord/454006273751515152.svg"></a>
    &nbsp;
    <a href="https://gtaforums.com/topic/912395-san-andreas-unity/"> <img src="http://i.imgur.com/Fatp2jZ.png" width="50" height="30"></a>
    &nbsp;
    <a href="https://www.youtube.com/channel/UCsslP7vqD06AMh6JlEy0pkg"> <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/0/09/YouTube_full-color_icon_%282017%29.svg/71px-YouTube_full-color_icon_%282017%29.svg.png" width="30" height="21"> </a>
</div>

<br>

San Andreas Unity is an open source reimplementation of GTA San Andreas game engine in Unity.

This won't be a complete reimplementation, but the focus is on gameplay features, mutliplayer, and creating a framework which will allow easy game extending and unlimited modding possibilities.

For more information about the project, read this [wiki page](https://github.com/GTA-ASM/SanAndreasUnity/wiki/About-project).

When running for the first time, the game will ask you for path to GTA installation. You need to own GTA in order to play it.


## Download

Download it for [Windows](https://github.com/GTA-ASM/SanAndreasUnity/releases/download/v4.0/SanAndreasUnity-4.0-windows.zip), [Linux](https://github.com/GTA-ASM/SanAndreasUnity/releases/download/v4.0/SanAndreasUnity-4.0-linux.zip) or [Android](https://github.com/GTA-ASM/SanAndreasUnity/wiki/Running-on-Android).

The game is tested on Linux, Windows, Mac, and Android. It supports both Mono and IL2CPP scripting backends, so it can be built for any platform that Unity supports, provided that you can copy PC version of GTASA to target device.


## Multiplayer

Game fully works in multiplayer. You can start the game as dedicated server, as a host (server & client at the same time), or you can connect to a server. This works on all supported platforms, which means you can start a host even on Android device.

If you want to host a server, take a look at [command line instructions](https://github.com/GTA-ASM/SanAndreasUnity/wiki/Command-line) and [server administration](https://github.com/GTA-ASM/SanAndreasUnity/wiki/Server-administration).


## Development setup

- clone the project, including submodules: `git clone --depth 1 --recurse-submodules https://github.com/GTA-ASM/SanAndreasUnity`
- open the project with Unity 2020.3.26 or newer
- open startup scene located at Assets/Scenes/Startup.unity
- press Play button


## In-game controls

Press Escape while in game to open pause menu. You'll see there a lot of utilities, and among them, there is a window which shows all controls.


## Game modes

Game can be extended through plugins/game modes in the form of C# DLLs. More info on [wiki](https://github.com/GTA-ASM/SanAndreasUnity/wiki/Plugins-(Game-modes)).


## Contributing

Join us on [discord](https://discord.gg/p6jjud5) to discuss about development.

You can check out issues for [newcomers](https://github.com/GTA-ASM/SanAndreasUnity/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22), issues related to [importing assets](https://github.com/GTA-ASM/SanAndreasUnity/issues?q=is%3Aissue+is%3Aopen+label%3Aimporting) from original game, or the [whole list](https://github.com/GTA-ASM/SanAndreasUnity/issues) of issues.

Issues that are in focus right now are those with [high priority](https://github.com/GTA-ASM/SanAndreasUnity/issues?q=is%3Aissue+is%3Aopen+label%3Apriority%3Ahigh) label and those found in [milestones](https://github.com/GTA-ASM/SanAndreasUnity/milestones).


## Screenshots

![](https://cloud.githubusercontent.com/assets/557828/24571348/d964f098-1670-11e7-8759-0160dbf5bcb5.png)

![](https://cloud.githubusercontent.com/assets/557828/24571349/d96b7c24-1670-11e7-997d-ae15913481f8.png)

![](https://i.imgur.com/HX978mr.png)

## Videos

###

[![](http://img.youtube.com/vi/PItR-0FF7JI/0.jpg)](https://www.youtube.com/watch?v=PItR-0FF7JI)

###

[![](http://img.youtube.com/vi/hnInLUbobI8/0.jpg)](https://www.youtube.com/watch?v=hnInLUbobI8)

###

[![](http://img.youtube.com/vi/VDfSE3nc3oM/0.jpg)](https://www.youtube.com/watch?v=VDfSE3nc3oM)

###

[![](http://img.youtube.com/vi/NPCiUZ-MZGM/0.jpg)](https://www.youtube.com/watch?v=NPCiUZ-MZGM)

