//
//  DeltaExtentions.swift
//  AntMessageProtocol
//
//  Created by Kevin Hoogheem on 4/23/17.
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.

import Foundation


extension UInt8 {

    func delta(from: UInt8) -> UInt8 {
        var current = self

        //Out of Order Packet
        let (tmpCurrent, _) = self.subtractingReportingOverflow((UInt8.max / 2))

        if tmpCurrent > from {
            return 0
        }

        if from < self {
            let (tmpCurrent, _) = self.subtractingReportingOverflow(from)
            return tmpCurrent

        } else {

            let (value, _) = self.subtractingReportingOverflow(from)
            current = value
            
        }
        
        return current
    }
}

extension UInt16 {

    func delta(from: UInt16) -> UInt16 {
        var current = self

        //Out of Order Packet
        let (tmpCurrent, _) = self.subtractingReportingOverflow((UInt16.max / 2))

        if tmpCurrent > from {
            return 0
        }

        if from < self {
            let (tmpCurrent, _) = self.subtractingReportingOverflow(from)
            return tmpCurrent

        } else {

            let (value, _) = self.subtractingReportingOverflow(from)
            current = value

        }
        
        return current
    }
}

extension UInt32 {

    func delta(from: UInt32) -> UInt32 {
        var current = self

        //Out of Order Packet
        let (tmpCurrent, _) = self.subtractingReportingOverflow((UInt32.max / 2))

        if tmpCurrent > from {
            return 0
        }

        if from < self {
            let (tmpCurrent, _) = self.subtractingReportingOverflow(from)
            return tmpCurrent

        } else {

            let (value, _) = self.subtractingReportingOverflow(from)
            current = value
            
        }
        
        return current
    }
}

