---
name: Compilation Issue
about: Having a Cocoapods / Carthage / SPM problem when linking the SDK?
title: ''
labels: compilation issue
assignees: ''

---

### The issue

📝 Give us the error message you receive, describe the problem and answer the questions.

### Reproduction

Provide a self-contained, concise snippet of code that can be used to reproduce the issue.
For more complex issues provide a repo with the smallest sample that reproduces the bug.

Avoid including business logic or unrelated code, it makes diagnosis more difficult.
The code sample should be an SSCCE. See http://sscce.org/ for details. In short, please provide a code sample that we can copy/paste, run and reproduce.

Do not share secrets or sensitive information in the code sample.

---

#### Datadog SDK version:

_Which version of the Datadog SDK causes this problem? e.g. `2.5.0`_

#### Last working Datadog SDK version:

_What is the last Datadog SDK version where this problem didn't occur? e.g. `1.1.0`_

#### Dependency Manager:

_Which dependency manager do you use? e.g. Cocoapods / Carthage / SPM / ..._

#### Other toolset:

_Do you use additional tools with your dependency manager? e.g. [CarthageCache](https://github.com/Wolox/carthage_cache)_

#### Xcode version:

_e.g. `Xcode 11.5 (11E608c)`_

#### Swift version:

_e.g. `5.1`_

#### Deployment Target:

_What is the Deployment Target of your app? e.g. `iOS 12`, `iPhone` + `iPad`_

#### macOS version:

_e.g. `macOS Catalina 10.15.5 (19F96)`_
