/*
* Unless explicitly stated otherwise all files in this repository are licensed under the Apache License Version 2.0.
* This product includes software developed at Datadog (https://www.datadoghq.com/).
* Copyright 2019-2020 Datadog, Inc.
*/

#import <XCTest/XCTest.h>
@import DatadogObjc;
@import DatadogCrashReporting;

// MARK: - DDUIKitRUMViewsPredicate

@interface CustomDDUIKitRUMViewsPredicate: NSObject
@end

@interface CustomDDUIKitRUMViewsPredicate () <DDUIKitRUMViewsPredicate>
@end

@implementation CustomDDUIKitRUMViewsPredicate
- (DDRUMView * _Nullable)rumViewFor:(UIViewController * _Nonnull)viewController { return nil; }
@end

// MARK: - DDUIKitRUMViewsPredicate

@interface CustomDDUIKitRUMUserActionsPredicate: NSObject
@end

@interface CustomDDUIKitRUMUserActionsPredicate () <DDUIKitRUMUserActionsPredicate>
@end

@implementation CustomDDUIKitRUMUserActionsPredicate
- (DDRUMAction * _Nullable)rumActionWithTargetView:(UIView * _Nonnull)targetView { return nil; }
@end

// MARK: - Tests

@interface DDConfiguration_apiTests : XCTestCase
@end

/*
 * `DatadogObjc` APIs smoke tests - only check if the interface is available to Objc.
 */
@implementation DDConfiguration_apiTests

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-value"

- (void)testDDEndpointAPI {
    [DDEndpoint eu];
    [DDEndpoint eu1];
    [DDEndpoint gov];
    [DDEndpoint us];
    [DDEndpoint us1];
    [DDEndpoint us1];
    [DDEndpoint us1_fed];
    [DDEndpoint us3];
}

- (void)testDDBatchSizeAPI {
    DDBatchSizeSmall; DDBatchSizeMedium; DDBatchSizeLarge;
}

- (void)testDDUploadFrequencyAPI {
    DDUploadFrequencyRare; DDUploadFrequencyAverage; DDUploadFrequencyFrequent;
}

- (void)testDDConfigurationAPI {
    [DDConfiguration builderWithClientToken:@"" environment:@""];
    [DDConfiguration builderWithRumApplicationID:@"" clientToken:@"" environment:@""];
}

- (void)testDDConfigurationBuilderAPI {
    DDConfigurationBuilder *builder = [DDConfiguration builderWithClientToken:@"" environment:@""];
    [builder enableLogging:YES];
    [builder enableTracing:YES];
    [builder enableRUM:YES];
    [builder enableCrashReportingUsing:[DDCrashReportingPlugin new]];
    [builder setWithEndpoint:[DDEndpoint us]];
    [builder setWithCustomLogsEndpoint:[NSURL new]];
    [builder setWithCustomTracesEndpoint:[NSURL new]];
    [builder setWithCustomRUMEndpoint:[NSURL new]];
    [builder trackURLSessionWithFirstPartyHosts:[NSSet setWithArray:@[]]];
    [builder setWithServiceName:@""];
    [builder setWithRumSessionsSamplingRate:50];
    [builder trackUIKitRUMViews];
    [builder trackUIKitRUMViewsUsing:[CustomDDUIKitRUMViewsPredicate new]];
    [builder trackUIKitRUMActions];
    [builder trackUIKitRUMActionsUsing:[CustomDDUIKitRUMUserActionsPredicate new]];
    [builder setRUMViewEventMapper:^DDRUMViewEvent * _Nonnull(DDRUMViewEvent * _Nonnull viewEvent) {
        viewEvent.view.url = @"";
        return viewEvent;
    }];
    [builder setRUMResourceEventMapper:^DDRUMResourceEvent * _Nullable(DDRUMResourceEvent * _Nonnull resourceEvent) {
        resourceEvent.resource.url = @"";
        return resourceEvent;
    }];
    [builder setRUMActionEventMapper:^DDRUMActionEvent * _Nullable(DDRUMActionEvent * _Nonnull actionEvent) {
        return nil;
    }];
    [builder setRUMErrorEventMapper:^DDRUMErrorEvent * _Nullable(DDRUMErrorEvent * _Nonnull errorEvent) {
        return nil;
    }];
    [builder setWithBatchSize:DDBatchSizeMedium];
    [builder setWithUploadFrequency:DDUploadFrequencyAverage];
    [builder setWithAdditionalConfiguration:@{}];
    [builder build];
}

#pragma clang diagnostic pop

@end
