/*
 * Unless explicitly stated otherwise all files in this repository are licensed under the Apache License Version 2.0.
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2019-2020 Datadog, Inc.
 */

import Foundation

/// Creates randomized `[String: Codable]` attributes
func mockRandomAttributes() -> [String: Codable] {
    struct Foo: Codable {
        var bar: String = .mockRandom()
        var bizz = Bizz()

        struct Bizz: Codable {
            var buzz: String = .mockRandom()
        }
    }

    return [
        "string-attribute": String.mockRandom(),
        "int-attribute": Int.mockRandom(),
        "uint64-attribute": UInt64.mockRandom(),
        "double-attribute": Double.mockRandom(),
        "bool-attribute": Bool.random(),
        "int-array-attribute": [Int].mockRandom(),
        "dictionary-attribute": [String: Int].mockRandom(),
        "url-attribute": URL.mockRandom(),
        "encodable-struct-attribute": Foo()
    ]
}
